<?php

namespace App\Controllers;

use CodeIgniter\Controller;
use CodeIgniter\Database\Config;
use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;
use CodeIgniter\HTTP\IncomingRequest;
use Config\Services;
use App\Controllers\BaseController;
use App\Models\UserModel;
use CodeIgniter\Exceptions\PageNotFoundException;

class Auth extends BaseController
{

       public function __construct()
    {
        $this->userModel = new UserModel();
        $this->request = Services::request();
        $this->session = Services::session();
        $this->db = \Config\Database::connect();

    }

     public function index()
    {
          return view('auth');
    }
    
  public function signinActionNORWORKING()
{
    $session = session();
    $userModel = new UserModel();

    $username = $this->request->getPost('username');
    $password = $this->request->getPost('password');

    // Fetch user by username
    $user = $userModel->where('username', $username)->first();

    if (!$user) {
        // No user found
        return redirect()->back()->with('error', 'Invalid login details');
    }

    if ($user['status'] === 'blocked') {
        return redirect()->back()->with('error', 'You cannot login - Account Blocked');
    }

    if (!password_verify($password, $user['password'])) {
        return redirect()->back()->with('error', 'Invalid login details');
    }

    // Set session data
    $session->set([
        'user_id'  => $user['user_id'],
        'username' => $user['username'],
        'role'     => $user['role'],
        'logged_in'=> true
    ]);

    // Redirect based on role
    switch ($user['role']) {
        case 'admin':
            return redirect()->to(site_url('admin')); // Uncomment for real redirect
        case 'storekeeper':
            return redirect()->to(site_url('storekeeper'));
        default:
            return redirect()->back()->with('error', 'You are not registered');
    }
}
public function signinAction()
{
    $session = session();
    $userModel = new UserModel();

    $username = $this->request->getPost('username');
    $password = $this->request->getPost('password');

    // Hash input password using MD5
    $password_md5 = md5($password);

    $user = $userModel->where('username', $username)->first();

    // Check if user exists and MD5 passwords match
    if ($user && $user['password'] === $password_md5) {

        $session->set([
            'user_id'        => $user['user_id'],
            'username'  => $user['username'],
            'role'      => $user['role'],
            'logged_in' => true
        ]);

        
       if ($user['role'] === 'admin') {
         // echo 'admin logged';
				return redirect()->to(site_url('admin'));
            } 
			elseif($user['role'] === 'sales') {
           echo ' sales  logged';
			   return redirect()->to(site_url('storekeeper'));
            }
			else{
				return redirect()->back()->with('error', 'Your not Registered');
			}

    } else {
        return redirect()->back()->with('error', 'Incorrect Password or Username');
    }
}

        

    public function logout()
    {
        session()->destroy();
        return redirect()->to('/');
    }
    

}
