
<?php echo view('admin/includes/head');?>

<body>
	<div id="global-loader">
		<div class="whirly-loader"> </div>
	</div>
	<!-- Main Wrapper -->
	<div class="main-wrapper">

		<!-- Header -->
<?php echo view('admin/includes/header');?>
		<!-- /Header -->

		<!-- Sidebar -->
<?php echo view('admin/includes/sidebarmenulogo');?>
		<!-- /Sidebar -->


			
			<div class="page-wrapper">
				<div class="content">
					<div class="page-header">
						<div class="add-item d-flex">
							<div class="page-title">
								<h4 class="fw-bold">Product List</h4>
								<h6>Manage your products</h6>
							</div>
						</div>
						<ul class="table-top-head">
							<li>
								<a data-bs-toggle="tooltip" data-bs-placement="top" title="Pdf"><img src="assets/img/icons/pdf.svg" alt="img"></a>
							</li>
							<li>
								<a data-bs-toggle="tooltip" data-bs-placement="top" title="Excel"><img src="assets/img/icons/excel.svg" alt="img"></a>
							</li>
							<li>
								<a data-bs-toggle="tooltip" data-bs-placement="top" title="Refresh"><i class="ti ti-refresh"></i></a>
							</li>
							<li>
								<a data-bs-toggle="tooltip" data-bs-placement="top" title="Collapse" id="collapse-header"><i class="ti ti-chevron-up"></i></a>
							</li>
						</ul>
						<div class="page-btn">
							<a href="<?= base_url('createproduct')?>" class="btn btn-primary"><i class="ti ti-circle-plus me-1"></i>Add Product</a>
						</div>	
						<!--<div class="page-btn import">-->
						<!--	<a href="#" class="btn btn-secondary color" data-bs-toggle="modal" data-bs-target="#view-notes"><i-->
						<!--		data-feather="download" class="me-1"></i>Import Product</a>-->
						<!--</div>-->
					</div>
					
					<!-- /product list -->
					<div class="card">
						<div class="card-header d-flex align-items-center justify-content-between flex-wrap row-gap-3">
							<div class="search-set">
								<div class="search-input">
									<span class="btn-searchset"><i class="ti ti-search fs-14 feather-search"></i></span>
								</div>
							</div>
							<div class="d-flex table-dropdown my-xl-auto right-content align-items-center flex-wrap row-gap-3">
								<div class="dropdown me-2">
								<select class="form-control" name="product_category" required>
														<option value="" selected>Category</option>
														<?php foreach ($categories as $row): ?>
                                              <option value="<?= $row['category_id']?>"><?= $row['category_name'] ?></option>
                                              <?php endforeach; ?>
														
													</select>
								</div>
								<div class="dropdown">
									<select name="category_status" class="form-control">
									<?php foreach ($units as $row): ?>
									 <option value="" selected>Units</option>
                                              <option value="<?= $row['unit_id']?>"><?= $row['unit_name'] ?></option>
                                            <?php endforeach; ?>
                                            </select>
								</div>
							</div>
						</div>
						<div class="card-body p-0">
							<div class="table-responsive">
								<table class="table datatable">
									<thead class="thead-light">
										<tr>
									
											<th>Product Code</th>
											<th>Product Name</th>
											<th>Category</th>
											<th>Price</th>
											<th>Unit</th>
											<th>Created at</th>
											<th class="no-sort"></th>
										</tr>
									</thead>
									<tbody>
									    <?php if (!empty($products)): ?>
    <?php foreach ($products as $product): ?>
										<tr>
											<td><?= esc($product['product_code']) ?></td>
											<td><?= esc($product['product_name']) ?></td>
										   <td><?= esc($product['category_name']) ?></td>							
											<td><?= number_format(($product['product_price']))?>/=</td>
											<td><?= esc($product['unit_name']) ?></td>
											<td><?= esc($product['product_created_at']) ?></td>
										
											<td class="action-table-data">
												<div class="edit-delete-action">
													<a class="me-2 edit-icon  p-2" href="<?= base_url('productdetails/' . $product['product_id']) ?>">
														<i data-feather="eye" class="feather-eye"></i>
													</a>
													<a class="me-2 p-2" href="<?= base_url('editproduct/' . $product['product_id']) ?>" >
														<i data-feather="edit" class="feather-edit"></i>
													</a>
													<!--<a data-bs-toggle="modal" data-bs-target="#delete-modal" class="p-2" href="javascript:void(0);">-->
													<!--	<i data-feather="trash-2" class="feather-trash-2"></i>-->
													<!--</a>-->
												</div>
											</td>
										</tr>
								    <?php endforeach; ?>
<?php else: ?>
    <p>No products found.</p>
<?php endif; ?>	
									</tbody>
								</table>
							</div>
						</div>
					</div>
					<!-- /product list -->
				</div>
				<?php echo view('admin/includes/coppy');?>
			</div>
        </div>
		<!-- /Main Wrapper -->

		<!-- Import Product -->
		<div class="modal fade" id="view-notes">
			<div class="modal-dialog modal-dialog-centered">
				<div class="modal-content">
					<div class="page-wrapper-new p-0">
						<div class="content">
							<div class="modal-header">
								<div class="page-title">
									<h4>Import Product</h4>
								</div>
								<button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
									<span aria-hidden="true">&times;</span>
								</button>
							</div>
							<div class="modal-body">
								<form action="https://dreamspos.dreamstechnologies.com/html/template/product-list.html">
								
									<div class="row">
										<div class="col-12">
											<div class="mb-3">
												<label>Product<span class="ms-1 text-danger">*</span></label>
												<select class="select">
													<option>Select</option>
													<option>Bold V3.2</option>
													<option>Nike Jordan</option>
													<option>Iphone 14 Pro</option>
												</select>
											</div>
										</div>
										<div class="col-sm-6 col-12">
											<div class="mb-3">
												<label>Category<span class="ms-1 text-danger">*</span></label>
												<select class="select">
													<option>Select</option>
													<option>Laptop</option>
													<option>Electronics</option>
													<option>Shoe</option>
												</select>
											</div>
										</div>
										<div class="col-sm-6 col-12">
											<div class="mb-3">
												<label>Sub Category<span class="ms-1 text-danger">*</span></label>
												<select class="select">
													<option>Select</option>
													<option>Lenovo</option>
													<option>Bolt</option>
													<option>Nike</option>
												</select>
											</div>
										</div>
										<div class="col-lg-12 col-sm-6 col-12">
											<div class="row">
												<div>
													<div class="modal-footer-btn download-file">
														<a href="javascript:void(0)" class="btn btn-submit">Download Sample File</a>
													</div>
												</div>
											</div>
										</div>
										<div class="col-lg-12">
											<div class="mb-3 image-upload-down">
												<label class="form-label">Upload CSV File</label>
												<div class="image-upload download">
													<input type="file">
													<div class="image-uploads">
														<img src="assets/img/download-img.png" alt="img">
														<h4>Drag and drop a <span>file to upload</span></h4>
													</div>
												</div>
											</div>
										</div>
										<div class="col-lg-12 col-sm-6 col-12">
											<div class="mb-3">
												<label class="form-label">Created by<span class="ms-1 text-danger">*</span></label>
												<input type="text" class="form-control">
											</div>
										</div>
									</div>
									<div class="row">
									<div class="col-lg-12">
										<div class="mb-3 mb-3">
											<label class="form-label">Description</label>
											<textarea class="form-control"></textarea>
											<p class="mt-1">Maximum 60 Characters</p>
										</div>
									</div>
								</div>
								</form>
							</div>
							<div class="modal-footer">
								<button type="button" class="btn me-2 btn-secondary fs-13 fw-medium p-2 px-3 shadow-none" data-bs-dismiss="modal">Cancel</button>
								<button type="submit" class="btn btn-primary fs-13 fw-medium p-2 px-3">Submit</button>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<!-- /Import Product -->

		<!-- delete modal -->
			<div class="modal fade" id="delete-modal">
			<div class="modal-dialog modal-dialog-centered">
				<div class="modal-content">
					<div class="page-wrapper-new p-0">
						<div class="content p-5 px-3 text-center">
								<span class="rounded-circle d-inline-flex p-2 bg-danger-transparent mb-2"><i class="ti ti-trash fs-24 text-danger"></i></span>
								<h4 class="fs-20 text-gray-9 fw-bold mb-2 mt-1">Delete Product</h4>
								<p class="text-gray-6 mb-0 fs-16">Are you sure you want to delete product?</p>
								<div class="modal-footer-btn mt-3 d-flex justify-content-center">
									<button type="button" class="btn me-2 btn-secondary fs-13 fw-medium p-2 px-3 shadow-none" data-bs-dismiss="modal">Cancel</button>
									<button type="submit" class="btn btn-primary fs-13 fw-medium p-2 px-3">Yes Delete</button>
								</div>						
						</div>
					</div>
				</div>
			</div>
		</div>
			
		
		
		<!-- jQuery -->
        <script src="<?= base_url('assets/js/jquery-3.7.1.min.js');?>" type="720bf3ec64aeaa45aeafc738-text/javascript"></script>

		<!-- Bootstrap Core JS -->
		<script src="<?= base_url('assets/js/bootstrap.bundle.min.js');?>" type="720bf3ec64aeaa45aeafc738-text/javascript"></script>

        <!-- Feather Icon JS -->
		<script src="<?= base_url('assets/js/feather.min.js');?>" type="720bf3ec64aeaa45aeafc738-text/javascript"></script>

		<!-- Slimscroll JS -->
		<script src="<?= base_url('assets/js/jquery.slimscroll.min.js');?>" type="720bf3ec64aeaa45aeafc738-text/javascript"></script>

		<!-- Datatable JS -->
		<script src="<?= base_url('assets/js/jquery.dataTables.min.js');?>" type="720bf3ec64aeaa45aeafc738-text/javascript"></script>
		<script src="<?= base_url('assets/js/dataTables.bootstrap5.min.js');?>" type="720bf3ec64aeaa45aeafc738-text/javascript"></script>

		<!-- Quill JS -->
    <script src="<?= base_url('assets/plugins/quill/quill.min.js');?>" type="720bf3ec64aeaa45aeafc738-text/javascript"></script>

		<!-- Select2 JS -->
		<script src="<?= base_url('assets/plugins/select2/js/select2.min.js');?>" type="720bf3ec64aeaa45aeafc738-text/javascript"></script>

		<!-- Datetimepicker JS -->
		<script src="<?= base_url('assets/js/moment.min.js');?>" type="720bf3ec64aeaa45aeafc738-text/javascript"></script>
		<script src="<?= base_url('assets/js/bootstrap-datetimepicker.min.js');?>" type="720bf3ec64aeaa45aeafc738-text/javascript"></script>

		<!-- Bootstrap Tagsinput JS -->
		<script src="<?= base_url('assets/plugins/bootstrap-tagsinput/bootstrap-tagsinput.js');?>" type="720bf3ec64aeaa45aeafc738-text/javascript"></script>

		<!-- Color Picker JS -->
		<script src="<?= base_url('assets/plugins/%40simonwep/pickr/pickr.es5.min.js');?>" type="720bf3ec64aeaa45aeafc738-text/javascript"></script>

		<!-- Custom JS -->
		<script src="<?= base_url('assets/js/theme-colorpicker.js');?>" type="720bf3ec64aeaa45aeafc738-text/javascript"></script>
		<script src="<?= base_url('assets/js/script.js');?>" type="720bf3ec64aeaa45aeafc738-text/javascript"></script>
	
	<script src="<?= base_url('assets/scripts/7d0fa10a/cloudflare-static/rocket-loader.min.js');?>" data-cf-settings="720bf3ec64aeaa45aeafc738-|49" defer></script><script defer src="https://static.cloudflareinsights.com/beacon.min.js/vcd15cbe7772f49c399c6a5babf22c1241717689176015" integrity="sha512-ZpsOmlRQV6y907TI0dKBHq9Md29nnaEIPlkf84rnaERnq6zvWvPUqr2ft8M1aS28oN72PdrCzSjY4U6VaAw1EQ==" data-cf-beacon='{"version":"2024.11.0","token":"3ca157e612a14eccbb30cf6db6691c29","server_timing":{"name":{"cfCacheStatus":true,"cfEdge":true,"cfExtPri":true,"cfL4":true,"cfOrigin":true,"cfSpeedBrain":true},"location_startswith":null}}' crossorigin="anonymous"></script>

       </body>

</html>