--
-- PostgreSQL database dump
--

-- Dumped from database version 17.5
-- Dumped by pg_dump version 17.5

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET transaction_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

SET default_tablespace = '';

SET default_table_access_method = heap;

--
-- Name: amortization_schedule; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.amortization_schedule (
    id integer NOT NULL,
    loan_id integer,
    payment_number integer,
    payment_date date,
    actual_payment_date character varying(50),
    payment_amount numeric(10,2),
    principal numeric(10,2),
    interest numeric(10,2),
    remaining_balance character varying(300),
    paid_amount numeric(10,2) DEFAULT 0.00,
    payment_status character varying(20) DEFAULT 'pending'::character varying,
    late_penalty character varying(30) DEFAULT '0.00'::character varying,
    amount_due character varying(30)
);


ALTER TABLE public.amortization_schedule OWNER TO postgres;

--
-- Name: amortization_schedule_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.amortization_schedule_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.amortization_schedule_id_seq OWNER TO postgres;

--
-- Name: amortization_schedule_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.amortization_schedule_id_seq OWNED BY public.amortization_schedule.id;


--
-- Name: loan_penalties; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.loan_penalties (
    id integer NOT NULL,
    loan_id integer NOT NULL,
    penalty_amount numeric(15,2) NOT NULL,
    penalty_date date NOT NULL,
    created_at timestamp without time zone DEFAULT CURRENT_TIMESTAMP
);


ALTER TABLE public.loan_penalties OWNER TO postgres;

--
-- Name: loan_penalties_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.loan_penalties_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.loan_penalties_id_seq OWNER TO postgres;

--
-- Name: loan_penalties_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.loan_penalties_id_seq OWNED BY public.loan_penalties.id;


--
-- Name: loan_repayments; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.loan_repayments (
    id integer NOT NULL,
    loan_id integer NOT NULL,
    payment_date date NOT NULL,
    principal_amount character varying(30) NOT NULL,
    interest_amount integer NOT NULL,
    repayment_amount character varying(30) NOT NULL,
    late_penalty character varying(30) DEFAULT '0.00'::character varying,
    payment_status character varying(10) DEFAULT 'on_time'::character varying
);


ALTER TABLE public.loan_repayments OWNER TO postgres;

--
-- Name: loan_repayments_existing; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.loan_repayments_existing (
    id integer NOT NULL,
    loan_id integer NOT NULL,
    payment_date date NOT NULL,
    amount_paid numeric(15,2) NOT NULL,
    interest_paid numeric(15,2) NOT NULL,
    principal_paid numeric(15,2) NOT NULL,
    status character varying(10) NOT NULL,
    penalty numeric(15,2) DEFAULT 0.00,
    created_at timestamp without time zone DEFAULT CURRENT_TIMESTAMP
);


ALTER TABLE public.loan_repayments_existing OWNER TO postgres;

--
-- Name: loan_repayments_existing_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.loan_repayments_existing_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.loan_repayments_existing_id_seq OWNER TO postgres;

--
-- Name: loan_repayments_existing_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.loan_repayments_existing_id_seq OWNED BY public.loan_repayments_existing.id;


--
-- Name: loan_repayments_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.loan_repayments_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.loan_repayments_id_seq OWNER TO postgres;

--
-- Name: loan_repayments_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.loan_repayments_id_seq OWNED BY public.loan_repayments.id;


--
-- Name: repayment_history; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.repayment_history (
    id integer NOT NULL,
    loan_id integer NOT NULL,
    payment_date date NOT NULL,
    paid_amount numeric(10,2) NOT NULL,
    interest_paid numeric(10,2) NOT NULL,
    principal_paid numeric(10,2) NOT NULL,
    total_paid_amount numeric(10,2) NOT NULL,
    outstanding_amount numeric(10,2) NOT NULL,
    created_at timestamp without time zone DEFAULT CURRENT_TIMESTAMP,
    updated_at timestamp without time zone DEFAULT CURRENT_TIMESTAMP,
    outstanding_principal numeric(10,2) NOT NULL,
    outstanding_interest numeric(10,2) NOT NULL,
    total_outstanding numeric(10,2) NOT NULL,
    payment_mode character varying(50) NOT NULL,
    produce character varying(60),
    produce_price character varying(60),
    quantity character varying(80),
    penalty_charged numeric(15,2) DEFAULT 0,
    credit_balance numeric(18,2) DEFAULT 0
);


ALTER TABLE public.repayment_history OWNER TO postgres;

--
-- Name: repayment_history_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.repayment_history_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.repayment_history_id_seq OWNER TO postgres;

--
-- Name: repayment_history_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.repayment_history_id_seq OWNED BY public.repayment_history.id;


--
-- Name: repayment_historyxx; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.repayment_historyxx (
    id integer NOT NULL,
    loan_id integer,
    payment_date character varying(50),
    paid_amount numeric(10,2),
    interest_paid numeric(10,2),
    principal_paid numeric(10,2),
    total_paid numeric(10,2),
    outstanding_balance numeric(10,2)
);


ALTER TABLE public.repayment_historyxx OWNER TO postgres;

--
-- Name: repayment_historyxx_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.repayment_historyxx_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.repayment_historyxx_id_seq OWNER TO postgres;

--
-- Name: repayment_historyxx_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.repayment_historyxx_id_seq OWNED BY public.repayment_historyxx.id;


--
-- Name: repayments; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.repayments (
    repayment_id integer NOT NULL,
    loan_id integer NOT NULL,
    repayment_date date NOT NULL,
    amount_paid numeric(10,2) NOT NULL,
    late_penalty numeric(10,2) DEFAULT 0.00,
    total_paid numeric(10,2) NOT NULL,
    new_balance character varying(50) NOT NULL,
    created_at timestamp without time zone DEFAULT CURRENT_TIMESTAMP
);


ALTER TABLE public.repayments OWNER TO postgres;

--
-- Name: repayments_repayment_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.repayments_repayment_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.repayments_repayment_id_seq OWNER TO postgres;

--
-- Name: repayments_repayment_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.repayments_repayment_id_seq OWNED BY public.repayments.repayment_id;


--
-- Name: tbagriitem; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.tbagriitem (
    agriitem_id integer NOT NULL,
    agriitem_name character varying(30) NOT NULL,
    agriitem_group character varying(30),
    created_by character varying(30),
    created_date character varying(30),
    agriitem_status character varying(30) DEFAULT 'Active'::character varying
);


ALTER TABLE public.tbagriitem OWNER TO postgres;

--
-- Name: tbagriitem_agriitem_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.tbagriitem_agriitem_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.tbagriitem_agriitem_id_seq OWNER TO postgres;

--
-- Name: tbagriitem_agriitem_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.tbagriitem_agriitem_id_seq OWNED BY public.tbagriitem.agriitem_id;


--
-- Name: tbaudit_trail; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.tbaudit_trail (
    action character varying(50) NOT NULL,
    activity_date character varying(50) NOT NULL,
    activity_time character varying(50) NOT NULL,
    audit_id character varying(50),
    creator character varying(50),
    description character varying(500),
    ip character varying(50),
    id integer NOT NULL
);


ALTER TABLE public.tbaudit_trail OWNER TO postgres;

--
-- Name: tbaudit_trail_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.tbaudit_trail_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.tbaudit_trail_id_seq OWNER TO postgres;

--
-- Name: tbaudit_trail_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.tbaudit_trail_id_seq OWNED BY public.tbaudit_trail.id;


--
-- Name: tbbranches; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.tbbranches (
    branch_categoty character varying(50) NOT NULL,
    branch_description character varying(50) NOT NULL,
    branch_district character varying(50) NOT NULL,
    branch_id integer NOT NULL,
    branch_name character varying(50) NOT NULL,
    branch_region character varying(50) NOT NULL,
    branch_status character varying(50) DEFAULT 'Active'::character varying,
    branch_ward character varying(50),
    created_by character varying(50),
    created_date character varying(50)
);


ALTER TABLE public.tbbranches OWNER TO postgres;

--
-- Name: tbbranches_branch_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.tbbranches_branch_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.tbbranches_branch_id_seq OWNER TO postgres;

--
-- Name: tbbranches_branch_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.tbbranches_branch_id_seq OWNED BY public.tbbranches.branch_id;


--
-- Name: tbdepartments; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.tbdepartments (
    department_id character varying(20) NOT NULL,
    department_id_auto integer NOT NULL,
    department_name character varying(50) NOT NULL,
    hod character varying(30),
    department_description text,
    department_status character varying(11) DEFAULT 'Active'::character varying NOT NULL,
    created_by character varying(50),
    created_date character varying(50)
);


ALTER TABLE public.tbdepartments OWNER TO postgres;

--
-- Name: tbdepartments_department_id_auto_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.tbdepartments_department_id_auto_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.tbdepartments_department_id_auto_seq OWNER TO postgres;

--
-- Name: tbdepartments_department_id_auto_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.tbdepartments_department_id_auto_seq OWNED BY public.tbdepartments.department_id_auto;


--
-- Name: tbdesignations; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.tbdesignations (
    designation_id character varying(50) NOT NULL,
    designation_id_auto integer NOT NULL,
    designation_name character varying(50),
    designation_description text,
    created_by character varying(50),
    created_date character varying(50),
    designation_status character varying(11) DEFAULT 'Active'::character varying NOT NULL
);


ALTER TABLE public.tbdesignations OWNER TO postgres;

--
-- Name: tbdesignations_designation_id_auto_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.tbdesignations_designation_id_auto_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.tbdesignations_designation_id_auto_seq OWNER TO postgres;

--
-- Name: tbdesignations_designation_id_auto_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.tbdesignations_designation_id_auto_seq OWNED BY public.tbdesignations.designation_id_auto;


--
-- Name: tbdisbursements; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.tbdisbursements (
    disb_id integer NOT NULL,
    group_id integer,
    loan_terms text,
    penalty_percent numeric,
    calculation_type text,
    disbursement_date date,
    loan_rate numeric,
    loan_interest numeric,
    disbursement_bank integer,
    principle_amount numeric,
    principle_amount_original numeric,
    outstanding_balance numeric,
    loan_status character(1),
    created_by character varying(100),
    created_at timestamp without time zone DEFAULT CURRENT_TIMESTAMP,
    is_deleted character(5) DEFAULT 'NO'::bpchar,
    deleted_date timestamp without time zone,
    application_id integer,
    disbursment_slip text
);


ALTER TABLE public.tbdisbursements OWNER TO postgres;

--
-- Name: tbdisbursements_disb_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.tbdisbursements_disb_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.tbdisbursements_disb_id_seq OWNER TO postgres;

--
-- Name: tbdisbursements_disb_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.tbdisbursements_disb_id_seq OWNED BY public.tbdisbursements.disb_id;


--
-- Name: tbdistricts; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.tbdistricts (
    district_id integer NOT NULL,
    district_name character varying(50) NOT NULL,
    district_status character varying(50) DEFAULT 'Active'::character varying NOT NULL,
    region_id integer
);


ALTER TABLE public.tbdistricts OWNER TO postgres;

--
-- Name: tbdistricts_district_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.tbdistricts_district_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.tbdistricts_district_id_seq OWNER TO postgres;

--
-- Name: tbdistricts_district_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.tbdistricts_district_id_seq OWNED BY public.tbdistricts.district_id;


--
-- Name: tbfertilize; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.tbfertilize (
    fertilizer_id integer NOT NULL,
    fertilizer_loan_rate character varying(50) NOT NULL,
    fertilizer_name character varying(50) NOT NULL,
    fertilizer_status character varying(50) DEFAULT 'Active'::character varying,
    fertilizer_unit_price character varying(50) NOT NULL,
    created_by character varying(50),
    created_date character varying(50),
    fertilizer_code character varying(50)
);


ALTER TABLE public.tbfertilize OWNER TO postgres;

--
-- Name: tbfertilize_fertilizer_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.tbfertilize_fertilizer_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.tbfertilize_fertilizer_id_seq OWNER TO postgres;

--
-- Name: tbfertilize_fertilizer_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.tbfertilize_fertilizer_id_seq OWNED BY public.tbfertilize.fertilizer_id;


--
-- Name: tbgroup_bank_accounts; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.tbgroup_bank_accounts (
    bank_account_id integer NOT NULL,
    group_id character varying(30),
    group_bank character varying(30),
    group_account_number character varying(30)
);


ALTER TABLE public.tbgroup_bank_accounts OWNER TO postgres;

--
-- Name: tbgroup_bank_accounts_bank_account_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.tbgroup_bank_accounts_bank_account_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.tbgroup_bank_accounts_bank_account_id_seq OWNER TO postgres;

--
-- Name: tbgroup_bank_accounts_bank_account_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.tbgroup_bank_accounts_bank_account_id_seq OWNED BY public.tbgroup_bank_accounts.bank_account_id;


--
-- Name: tbgroup_budget_items; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.tbgroup_budget_items (
    id integer NOT NULL,
    budget_id integer NOT NULL,
    product_id integer NOT NULL,
    quantity numeric(10,2) NOT NULL,
    price numeric(10,2) NOT NULL,
    total numeric(10,2) GENERATED ALWAYS AS ((quantity * price)) STORED
);


ALTER TABLE public.tbgroup_budget_items OWNER TO postgres;

--
-- Name: tbgroup_budget_items_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.tbgroup_budget_items_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.tbgroup_budget_items_id_seq OWNER TO postgres;

--
-- Name: tbgroup_budget_items_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.tbgroup_budget_items_id_seq OWNED BY public.tbgroup_budget_items.id;


--
-- Name: tbgroup_budgets; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.tbgroup_budgets (
    id integer NOT NULL,
    group_id integer NOT NULL,
    season_year character varying(20) NOT NULL,
    groupresolution character varying(255),
    groupletter character varying(255),
    inputrequirementform character varying(255),
    applicationleterandresolution character varying(255),
    upfrontcontribution character varying(255),
    created_by character varying(255),
    created_at timestamp without time zone DEFAULT CURRENT_TIMESTAMP,
    budget_amount numeric(12,2) DEFAULT 0.00,
    input_package character varying(30)
);


ALTER TABLE public.tbgroup_budgets OWNER TO postgres;

--
-- Name: tbgroup_budgets_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.tbgroup_budgets_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.tbgroup_budgets_id_seq OWNER TO postgres;

--
-- Name: tbgroup_budgets_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.tbgroup_budgets_id_seq OWNED BY public.tbgroup_budgets.id;


--
-- Name: tbgroup_members; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.tbgroup_members (
    group_member_id integer NOT NULL,
    group_id integer,
    member_id integer,
    group_member_status character varying(10) DEFAULT 'Active'::character varying,
    created_by character varying(10),
    created_date character varying(30)
);


ALTER TABLE public.tbgroup_members OWNER TO postgres;

--
-- Name: tbgroup_members_group_member_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.tbgroup_members_group_member_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.tbgroup_members_group_member_id_seq OWNER TO postgres;

--
-- Name: tbgroup_members_group_member_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.tbgroup_members_group_member_id_seq OWNED BY public.tbgroup_members.group_member_id;


--
-- Name: tbgroups; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.tbgroups (
    group_id integer NOT NULL,
    group_name character varying(50),
    group_region character varying(50),
    group_district character varying(50),
    group_code character varying(100),
    chairperson_first_name character varying(100),
    chairperson_middle_name character varying(100),
    chairperson_last_name character varying(100),
    secretary_first_name character varying(100),
    secretary_middle_name character varying(100),
    secretary_last_name character varying(100),
    treasurer_first_name character varying(100),
    treasurer_middle_name character varying(100),
    treasurer_last_name character varying(100),
    contact_personel_first_name character varying(100),
    contact_personel_last_name character varying(100),
    contact_personel_phone_number character varying(100),
    group_registration_number character varying(500),
    group_status character varying(50) DEFAULT 'Active'::character varying,
    number_of_members character varying(50),
    village character varying(50),
    ward character varying(50),
    certificateofregistration character varying(500),
    groupconstitution character varying(500),
    signatories character varying(500),
    description text,
    created_by character varying(50),
    created_date character varying(50)
);


ALTER TABLE public.tbgroups OWNER TO postgres;

--
-- Name: tbgroups_group_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.tbgroups_group_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.tbgroups_group_id_seq OWNER TO postgres;

--
-- Name: tbgroups_group_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.tbgroups_group_id_seq OWNED BY public.tbgroups.group_id;


--
-- Name: tbherbicide; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.tbherbicide (
    herbicide_id integer NOT NULL,
    herbicide_loan_rate character varying(50),
    herbicide_name character varying(50),
    herbicide_status character varying(50) DEFAULT 'Active'::character varying,
    herbicide_unit_price character varying(50),
    herbicide_code character varying(50),
    herbicide_category character varying(50),
    created_by character varying(50),
    created_date character varying(50)
);


ALTER TABLE public.tbherbicide OWNER TO postgres;

--
-- Name: tbherbicide_herbicide_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.tbherbicide_herbicide_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.tbherbicide_herbicide_id_seq OWNER TO postgres;

--
-- Name: tbherbicide_herbicide_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.tbherbicide_herbicide_id_seq OWNED BY public.tbherbicide.herbicide_id;


--
-- Name: tbloan; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.tbloan (
    loan_id integer NOT NULL,
    approved_by character varying(50),
    approved_date character varying(50),
    created_by character varying(50),
    created_date character varying(50),
    farmer_group_id character varying(50),
    farmer_id character varying(50),
    given_agri_input_id character varying(50),
    given_input_se_fe_he character varying(50),
    given_units_kg_little_bag character varying(50),
    is_approved character varying(50) DEFAULT 'No'::character varying,
    loan_end_date character varying(50),
    loan_interest_amount character varying(50),
    loan_principle character varying(50),
    loan_rate character varying(50),
    disbursement_date character varying(50),
    loan_status character varying(50) DEFAULT 'Active'::character varying,
    remained_amount character varying(50),
    total_loan character varying(50),
    utilized_acres character varying(50)
);


ALTER TABLE public.tbloan OWNER TO postgres;

--
-- Name: tbloan_existing; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.tbloan_existing (
    id integer NOT NULL,
    group_id integer,
    season_year character varying(30),
    utilized_acres character varying(30),
    loan_terms integer,
    penalty_percent character varying(30),
    recovery_commission_percentage character varying(30),
    calculation_type character varying(30),
    disbursement_date character varying(30),
    loan_rate numeric,
    loan_interest character varying(30),
    disbursement_bank integer,
    principle_amount numeric,
    principle_amount_original character varying(50),
    outstanding_balance character varying(30),
    loan_status character varying(30),
    created_by character varying(50),
    created_at timestamp without time zone DEFAULT CURRENT_TIMESTAMP,
    is_deleted character varying(5) DEFAULT 'NO'::character varying,
    deleted_by character varying(5),
    deleted_date character varying(30),
    is_approved character varying(10) DEFAULT 'NO'::character varying,
    approved_by character varying(50),
    approved_date character varying(50),
    rejection_reason text
);


ALTER TABLE public.tbloan_existing OWNER TO postgres;

--
-- Name: tbloan_existing_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.tbloan_existing_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.tbloan_existing_id_seq OWNER TO postgres;

--
-- Name: tbloan_existing_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.tbloan_existing_id_seq OWNED BY public.tbloan_existing.id;


--
-- Name: tbloan_existing_product; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.tbloan_existing_product (
    id integer NOT NULL,
    loan_id character varying(30),
    product_id integer,
    quantity numeric(10,2),
    price numeric(10,2),
    total_amount numeric(15,2)
);


ALTER TABLE public.tbloan_existing_product OWNER TO postgres;

--
-- Name: tbloan_existing_product_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.tbloan_existing_product_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.tbloan_existing_product_id_seq OWNER TO postgres;

--
-- Name: tbloan_existing_product_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.tbloan_existing_product_id_seq OWNED BY public.tbloan_existing_product.id;


--
-- Name: tbloan_loan_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.tbloan_loan_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.tbloan_loan_id_seq OWNER TO postgres;

--
-- Name: tbloan_loan_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.tbloan_loan_id_seq OWNED BY public.tbloan.loan_id;


--
-- Name: tbloan_monthly_details; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.tbloan_monthly_details (
    id integer NOT NULL,
    loan_id integer,
    month integer,
    opening_balance character varying(500),
    amount_repaid_principal character varying(100),
    installment character varying(30),
    monthly_interest numeric(15,2),
    interest character varying(30),
    monthly_repayment numeric(15,2),
    remaining_principal numeric(15,2),
    closing_balance character varying(30)
);


ALTER TABLE public.tbloan_monthly_details OWNER TO postgres;

--
-- Name: tbloan_monthly_details_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.tbloan_monthly_details_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.tbloan_monthly_details_id_seq OWNER TO postgres;

--
-- Name: tbloan_monthly_details_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.tbloan_monthly_details_id_seq OWNED BY public.tbloan_monthly_details.id;


--
-- Name: tbloan_repayment; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.tbloan_repayment (
    id integer NOT NULL,
    loan_id integer,
    repayment_date date,
    repayment_amount numeric(15,2),
    new_remaining_balance numeric(15,2)
);


ALTER TABLE public.tbloan_repayment OWNER TO postgres;

--
-- Name: tbloan_repayment_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.tbloan_repayment_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.tbloan_repayment_id_seq OWNER TO postgres;

--
-- Name: tbloan_repayment_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.tbloan_repayment_id_seq OWNED BY public.tbloan_repayment.id;


--
-- Name: tbloanapplicants; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.tbloanapplicants (
    id integer NOT NULL,
    loan_application_id integer,
    member_id integer NOT NULL,
    acres numeric(6,2),
    group_budget_amount numeric(10,2),
    total_amount numeric(12,2)
);


ALTER TABLE public.tbloanapplicants OWNER TO postgres;

--
-- Name: tbloanapplicants_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.tbloanapplicants_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.tbloanapplicants_id_seq OWNER TO postgres;

--
-- Name: tbloanapplicants_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.tbloanapplicants_id_seq OWNED BY public.tbloanapplicants.id;


--
-- Name: tbloanapplications; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.tbloanapplications (
    id integer NOT NULL,
    group_id integer NOT NULL,
    total_loan_amount numeric(30,2),
    created_by character varying(255),
    created_at date,
    status character varying(50),
    is_approved character varying(30),
    approved_by character varying(20),
    approved_date date,
    is_rejected character varying(10),
    rejected_by character varying(20),
    rejected_date date
);


ALTER TABLE public.tbloanapplications OWNER TO postgres;

--
-- Name: tbloanapplications_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.tbloanapplications_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.tbloanapplications_id_seq OWNER TO postgres;

--
-- Name: tbloanapplications_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.tbloanapplications_id_seq OWNED BY public.tbloanapplications.id;


--
-- Name: tbmanufuctures_varieties; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.tbmanufuctures_varieties (
    id integer NOT NULL,
    name character varying(100),
    category character varying(50),
    status character varying(10) DEFAULT 'Active'::character varying,
    created_by character varying(50),
    created_date character varying(50)
);


ALTER TABLE public.tbmanufuctures_varieties OWNER TO postgres;

--
-- Name: tbmanufuctures_varieties_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.tbmanufuctures_varieties_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.tbmanufuctures_varieties_id_seq OWNER TO postgres;

--
-- Name: tbmanufuctures_varieties_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.tbmanufuctures_varieties_id_seq OWNED BY public.tbmanufuctures_varieties.id;


--
-- Name: tbmembers; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.tbmembers (
    member_id integer NOT NULL,
    first_name character varying(50),
    middle_name character varying(50),
    last_name character varying(50),
    phone_number character varying(50),
    member_status character varying(50) DEFAULT 'Active'::character varying,
    member_age integer,
    filename character varying(500),
    nida character varying(50),
    group_id character varying(30),
    gender character varying(50),
    created_date character varying(50),
    created_by character varying(50),
    acres character varying(50)
);


ALTER TABLE public.tbmembers OWNER TO postgres;

--
-- Name: tbmembers_member_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.tbmembers_member_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.tbmembers_member_id_seq OWNER TO postgres;

--
-- Name: tbmembers_member_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.tbmembers_member_id_seq OWNED BY public.tbmembers.member_id;


--
-- Name: tbmodules; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.tbmodules (
    module_id integer NOT NULL,
    module_name character varying(100),
    module_status character varying(30) DEFAULT 'Active'::character varying,
    module_date integer
);


ALTER TABLE public.tbmodules OWNER TO postgres;

--
-- Name: tbmodules_module_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.tbmodules_module_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.tbmodules_module_id_seq OWNER TO postgres;

--
-- Name: tbmodules_module_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.tbmodules_module_id_seq OWNED BY public.tbmodules.module_id;


--
-- Name: tbmodules_user; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.tbmodules_user (
    id integer NOT NULL,
    user_id character varying(50),
    module_id character varying(50),
    is_active character varying(50) DEFAULT 'Active'::character varying
);


ALTER TABLE public.tbmodules_user OWNER TO postgres;

--
-- Name: tbmodules_user_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.tbmodules_user_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.tbmodules_user_id_seq OWNER TO postgres;

--
-- Name: tbmodules_user_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.tbmodules_user_id_seq OWNED BY public.tbmodules_user.id;


--
-- Name: tbproduct_categories; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.tbproduct_categories (
    product_categorie_id integer NOT NULL,
    product_categories_name character varying(50),
    product_categories_status character varying(50) DEFAULT 'Active'::character varying,
    created_date integer,
    created_by integer
);


ALTER TABLE public.tbproduct_categories OWNER TO postgres;

--
-- Name: tbproduct_categories_product_categorie_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.tbproduct_categories_product_categorie_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.tbproduct_categories_product_categorie_id_seq OWNER TO postgres;

--
-- Name: tbproduct_categories_product_categorie_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.tbproduct_categories_product_categorie_id_seq OWNED BY public.tbproduct_categories.product_categorie_id;


--
-- Name: tbproducts; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.tbproducts (
    product_id integer NOT NULL,
    product_code character varying(30),
    product_name character varying(100),
    variety_manufacture character varying(30),
    product_group integer,
    product_unit_price character varying(30),
    product_measurement character varying(30),
    filename character varying(500),
    description text,
    created_by character varying(30),
    created_date character varying(30),
    product_status character varying(10) DEFAULT 'Active'::character varying
);


ALTER TABLE public.tbproducts OWNER TO postgres;

--
-- Name: tbproducts_product_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.tbproducts_product_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.tbproducts_product_id_seq OWNER TO postgres;

--
-- Name: tbproducts_product_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.tbproducts_product_id_seq OWNED BY public.tbproducts.product_id;


--
-- Name: tbregions; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.tbregions (
    region_id integer NOT NULL,
    region_name character varying(50),
    region_code character varying(50),
    region_status character varying(50)
);


ALTER TABLE public.tbregions OWNER TO postgres;

--
-- Name: tbregions_region_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.tbregions_region_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.tbregions_region_id_seq OWNER TO postgres;

--
-- Name: tbregions_region_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.tbregions_region_id_seq OWNED BY public.tbregions.region_id;


--
-- Name: tbrepayment; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.tbrepayment (
    repayment_id integer NOT NULL,
    repaym_date character varying(50),
    total_loan_amount character varying(50),
    paid_amount character varying(50),
    remained_amount character varying(50),
    repayment_code character varying(50),
    loan_id character varying(50),
    is_deleted character varying(50) DEFAULT 'No'::character varying,
    group_id character varying(50),
    farmer character varying(50),
    created_date character varying(50),
    created_by character varying(50)
);


ALTER TABLE public.tbrepayment OWNER TO postgres;

--
-- Name: tbrepayment_existing_loan; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.tbrepayment_existing_loan (
    id integer NOT NULL,
    loan_id integer,
    repayment_date date,
    amount_paid numeric(10,2),
    years_since_disbursement character varying(50),
    penalty_amount character varying(30),
    outstanding_principal character varying(20),
    total_outstanding_with_penalty character varying(30),
    total_outstanding_no_penalty character varying(30),
    created_at timestamp without time zone DEFAULT CURRENT_TIMESTAMP
);


ALTER TABLE public.tbrepayment_existing_loan OWNER TO postgres;

--
-- Name: tbrepayment_existing_loan_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.tbrepayment_existing_loan_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.tbrepayment_existing_loan_id_seq OWNER TO postgres;

--
-- Name: tbrepayment_existing_loan_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.tbrepayment_existing_loan_id_seq OWNED BY public.tbrepayment_existing_loan.id;


--
-- Name: tbrepayment_repayment_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.tbrepayment_repayment_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.tbrepayment_repayment_id_seq OWNER TO postgres;

--
-- Name: tbrepayment_repayment_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.tbrepayment_repayment_id_seq OWNED BY public.tbrepayment.repayment_id;


--
-- Name: tbsalary_scale; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.tbsalary_scale (
    salary_id_auto integer NOT NULL,
    salary_id character varying(50),
    salary_name character varying(100),
    salary_amount character varying(30),
    salary_status character varying(10) DEFAULT 'Active'::character varying,
    created_by character varying(50),
    created_date character varying(50)
);


ALTER TABLE public.tbsalary_scale OWNER TO postgres;

--
-- Name: tbsalary_scale_salary_id_auto_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.tbsalary_scale_salary_id_auto_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.tbsalary_scale_salary_id_auto_seq OWNER TO postgres;

--
-- Name: tbsalary_scale_salary_id_auto_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.tbsalary_scale_salary_id_auto_seq OWNED BY public.tbsalary_scale.salary_id_auto;


--
-- Name: tbseeds; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.tbseeds (
    seeds_id integer NOT NULL,
    seeds_name character varying(50),
    seeds_category character varying(50),
    seeds_code character varying(50),
    seeds_loan_rate character varying(50),
    seeds_status character varying(50) DEFAULT 'Active'::character varying,
    seeds_unit_price character varying(50),
    created_date character varying(50),
    created_by character varying(50)
);


ALTER TABLE public.tbseeds OWNER TO postgres;

--
-- Name: tbseeds_seeds_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.tbseeds_seeds_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.tbseeds_seeds_id_seq OWNER TO postgres;

--
-- Name: tbseeds_seeds_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.tbseeds_seeds_id_seq OWNED BY public.tbseeds.seeds_id;


--
-- Name: tbstaffs; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.tbstaffs (
    id integer NOT NULL,
    staff_id character varying(100),
    first_name character varying(100),
    last_name character varying(100),
    email character varying(255),
    phone_number character varying(20),
    gender character varying(10),
    date_of_birth date,
    hire_date date,
    "position" character varying(100),
    department character varying(100),
    salary integer,
    status character varying(20),
    address text,
    emergency_contact_name character varying(100),
    emergency_contact_phone character varying(20),
    hire_type character varying(20),
    employee_code character varying(50),
    national_id character varying(50),
    created_at timestamp without time zone DEFAULT CURRENT_TIMESTAMP,
    updated_at timestamp without time zone DEFAULT CURRENT_TIMESTAMP
);


ALTER TABLE public.tbstaffs OWNER TO postgres;

--
-- Name: tbstaffs_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.tbstaffs_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.tbstaffs_id_seq OWNER TO postgres;

--
-- Name: tbstaffs_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.tbstaffs_id_seq OWNED BY public.tbstaffs.id;


--
-- Name: tbstaffs_old; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.tbstaffs_old (
    staff_id_auto integer NOT NULL,
    staff_id character varying(100),
    first_name character varying(30),
    middle_name character varying(50),
    last_name character varying(50),
    staff_post character varying(11),
    birth_date character varying(50),
    phone_number character varying(20),
    staff_status character varying(11) DEFAULT 'Active'::character varying
);


ALTER TABLE public.tbstaffs_old OWNER TO postgres;

--
-- Name: tbstaffs_old_staff_id_auto_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.tbstaffs_old_staff_id_auto_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.tbstaffs_old_staff_id_auto_seq OWNER TO postgres;

--
-- Name: tbstaffs_old_staff_id_auto_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.tbstaffs_old_staff_id_auto_seq OWNED BY public.tbstaffs_old.staff_id_auto;


--
-- Name: tbstakeholder; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.tbstakeholder (
    stakeholder_id integer NOT NULL,
    stakeholder_name character varying(50),
    stakeholder_group character varying(30),
    "postal_box_physical_Address" character varying(100),
    contact_person_full_names character varying(100),
    contact_person_email character varying(100),
    contact_person_phonenumber character varying(100),
    certificateofregistration character varying(500),
    taxclearance character varying(500),
    tin character varying(500),
    logo character varying(100),
    stakeholder_status character varying(50) DEFAULT 'Active'::character varying,
    created_date_old integer,
    created_by character varying(100),
    removed_by character varying(30),
    postal_box_physical_address character varying(400),
    created_date date
);


ALTER TABLE public.tbstakeholder OWNER TO postgres;

--
-- Name: tbstakeholder_stakeholder_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.tbstakeholder_stakeholder_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.tbstakeholder_stakeholder_id_seq OWNER TO postgres;

--
-- Name: tbstakeholder_stakeholder_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.tbstakeholder_stakeholder_id_seq OWNED BY public.tbstakeholder.stakeholder_id;


--
-- Name: tbusers; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.tbusers (
    user_id character varying(30) NOT NULL,
    first_name character varying(70),
    last_name character varying(70),
    phone_number character varying(12),
    profile character varying(50),
    created_by integer,
    edit_status integer DEFAULT 0,
    edited_by integer DEFAULT 0,
    edit_approved_by integer DEFAULT 0,
    is_blocked integer DEFAULT 0,
    login_attempts integer DEFAULT 0,
    user_name character varying(70),
    password character varying(100),
    created_date character varying(50),
    status character varying(11) DEFAULT 'Active'::character varying
);


ALTER TABLE public.tbusers OWNER TO postgres;

--
-- Name: tbvillages; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.tbvillages (
    village_id integer NOT NULL,
    village_name character varying(50),
    village_status character varying(50) DEFAULT 'Active'::character varying,
    region_id integer,
    district_id integer,
    ward_id integer
);


ALTER TABLE public.tbvillages OWNER TO postgres;

--
-- Name: tbvillages_village_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.tbvillages_village_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.tbvillages_village_id_seq OWNER TO postgres;

--
-- Name: tbvillages_village_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.tbvillages_village_id_seq OWNED BY public.tbvillages.village_id;


--
-- Name: tbwards; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.tbwards (
    ward_id integer NOT NULL,
    ward_name character varying(50),
    ward_status character varying(50),
    region_id integer,
    district_id integer
);


ALTER TABLE public.tbwards OWNER TO postgres;

--
-- Name: tbwards_ward_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.tbwards_ward_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.tbwards_ward_id_seq OWNER TO postgres;

--
-- Name: tbwards_ward_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.tbwards_ward_id_seq OWNED BY public.tbwards.ward_id;


--
-- Name: test_data; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.test_data (
    id integer NOT NULL,
    name character varying(100),
    email character varying(100),
    message text
);


ALTER TABLE public.test_data OWNER TO postgres;

--
-- Name: test_data_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.test_data_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.test_data_id_seq OWNER TO postgres;

--
-- Name: test_data_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.test_data_id_seq OWNED BY public.test_data.id;


--
-- Name: user_sessions; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.user_sessions (
    id integer NOT NULL,
    user_id character varying(30),
    device_name character varying(500),
    "Accessed_module" character varying(20),
    session_id character varying(255),
    ip_address character varying(45),
    last_activity integer
);


ALTER TABLE public.user_sessions OWNER TO postgres;

--
-- Name: user_sessions_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.user_sessions_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.user_sessions_id_seq OWNER TO postgres;

--
-- Name: user_sessions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.user_sessions_id_seq OWNED BY public.user_sessions.id;


--
-- Name: amortization_schedule id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.amortization_schedule ALTER COLUMN id SET DEFAULT nextval('public.amortization_schedule_id_seq'::regclass);


--
-- Name: loan_penalties id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.loan_penalties ALTER COLUMN id SET DEFAULT nextval('public.loan_penalties_id_seq'::regclass);


--
-- Name: loan_repayments id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.loan_repayments ALTER COLUMN id SET DEFAULT nextval('public.loan_repayments_id_seq'::regclass);


--
-- Name: loan_repayments_existing id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.loan_repayments_existing ALTER COLUMN id SET DEFAULT nextval('public.loan_repayments_existing_id_seq'::regclass);


--
-- Name: repayment_history id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.repayment_history ALTER COLUMN id SET DEFAULT nextval('public.repayment_history_id_seq'::regclass);


--
-- Name: repayment_historyxx id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.repayment_historyxx ALTER COLUMN id SET DEFAULT nextval('public.repayment_historyxx_id_seq'::regclass);


--
-- Name: repayments repayment_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.repayments ALTER COLUMN repayment_id SET DEFAULT nextval('public.repayments_repayment_id_seq'::regclass);


--
-- Name: tbagriitem agriitem_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbagriitem ALTER COLUMN agriitem_id SET DEFAULT nextval('public.tbagriitem_agriitem_id_seq'::regclass);


--
-- Name: tbaudit_trail id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbaudit_trail ALTER COLUMN id SET DEFAULT nextval('public.tbaudit_trail_id_seq'::regclass);


--
-- Name: tbbranches branch_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbbranches ALTER COLUMN branch_id SET DEFAULT nextval('public.tbbranches_branch_id_seq'::regclass);


--
-- Name: tbdepartments department_id_auto; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbdepartments ALTER COLUMN department_id_auto SET DEFAULT nextval('public.tbdepartments_department_id_auto_seq'::regclass);


--
-- Name: tbdesignations designation_id_auto; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbdesignations ALTER COLUMN designation_id_auto SET DEFAULT nextval('public.tbdesignations_designation_id_auto_seq'::regclass);


--
-- Name: tbdisbursements disb_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbdisbursements ALTER COLUMN disb_id SET DEFAULT nextval('public.tbdisbursements_disb_id_seq'::regclass);


--
-- Name: tbdistricts district_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbdistricts ALTER COLUMN district_id SET DEFAULT nextval('public.tbdistricts_district_id_seq'::regclass);


--
-- Name: tbfertilize fertilizer_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbfertilize ALTER COLUMN fertilizer_id SET DEFAULT nextval('public.tbfertilize_fertilizer_id_seq'::regclass);


--
-- Name: tbgroup_bank_accounts bank_account_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbgroup_bank_accounts ALTER COLUMN bank_account_id SET DEFAULT nextval('public.tbgroup_bank_accounts_bank_account_id_seq'::regclass);


--
-- Name: tbgroup_budget_items id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbgroup_budget_items ALTER COLUMN id SET DEFAULT nextval('public.tbgroup_budget_items_id_seq'::regclass);


--
-- Name: tbgroup_budgets id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbgroup_budgets ALTER COLUMN id SET DEFAULT nextval('public.tbgroup_budgets_id_seq'::regclass);


--
-- Name: tbgroup_members group_member_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbgroup_members ALTER COLUMN group_member_id SET DEFAULT nextval('public.tbgroup_members_group_member_id_seq'::regclass);


--
-- Name: tbgroups group_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbgroups ALTER COLUMN group_id SET DEFAULT nextval('public.tbgroups_group_id_seq'::regclass);


--
-- Name: tbherbicide herbicide_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbherbicide ALTER COLUMN herbicide_id SET DEFAULT nextval('public.tbherbicide_herbicide_id_seq'::regclass);


--
-- Name: tbloan loan_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbloan ALTER COLUMN loan_id SET DEFAULT nextval('public.tbloan_loan_id_seq'::regclass);


--
-- Name: tbloan_existing id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbloan_existing ALTER COLUMN id SET DEFAULT nextval('public.tbloan_existing_id_seq'::regclass);


--
-- Name: tbloan_existing_product id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbloan_existing_product ALTER COLUMN id SET DEFAULT nextval('public.tbloan_existing_product_id_seq'::regclass);


--
-- Name: tbloan_monthly_details id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbloan_monthly_details ALTER COLUMN id SET DEFAULT nextval('public.tbloan_monthly_details_id_seq'::regclass);


--
-- Name: tbloan_repayment id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbloan_repayment ALTER COLUMN id SET DEFAULT nextval('public.tbloan_repayment_id_seq'::regclass);


--
-- Name: tbloanapplicants id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbloanapplicants ALTER COLUMN id SET DEFAULT nextval('public.tbloanapplicants_id_seq'::regclass);


--
-- Name: tbloanapplications id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbloanapplications ALTER COLUMN id SET DEFAULT nextval('public.tbloanapplications_id_seq'::regclass);


--
-- Name: tbmanufuctures_varieties id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbmanufuctures_varieties ALTER COLUMN id SET DEFAULT nextval('public.tbmanufuctures_varieties_id_seq'::regclass);


--
-- Name: tbmembers member_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbmembers ALTER COLUMN member_id SET DEFAULT nextval('public.tbmembers_member_id_seq'::regclass);


--
-- Name: tbmodules module_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbmodules ALTER COLUMN module_id SET DEFAULT nextval('public.tbmodules_module_id_seq'::regclass);


--
-- Name: tbmodules_user id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbmodules_user ALTER COLUMN id SET DEFAULT nextval('public.tbmodules_user_id_seq'::regclass);


--
-- Name: tbproduct_categories product_categorie_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbproduct_categories ALTER COLUMN product_categorie_id SET DEFAULT nextval('public.tbproduct_categories_product_categorie_id_seq'::regclass);


--
-- Name: tbproducts product_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbproducts ALTER COLUMN product_id SET DEFAULT nextval('public.tbproducts_product_id_seq'::regclass);


--
-- Name: tbregions region_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbregions ALTER COLUMN region_id SET DEFAULT nextval('public.tbregions_region_id_seq'::regclass);


--
-- Name: tbrepayment repayment_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbrepayment ALTER COLUMN repayment_id SET DEFAULT nextval('public.tbrepayment_repayment_id_seq'::regclass);


--
-- Name: tbrepayment_existing_loan id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbrepayment_existing_loan ALTER COLUMN id SET DEFAULT nextval('public.tbrepayment_existing_loan_id_seq'::regclass);


--
-- Name: tbsalary_scale salary_id_auto; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbsalary_scale ALTER COLUMN salary_id_auto SET DEFAULT nextval('public.tbsalary_scale_salary_id_auto_seq'::regclass);


--
-- Name: tbseeds seeds_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbseeds ALTER COLUMN seeds_id SET DEFAULT nextval('public.tbseeds_seeds_id_seq'::regclass);


--
-- Name: tbstaffs id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbstaffs ALTER COLUMN id SET DEFAULT nextval('public.tbstaffs_id_seq'::regclass);


--
-- Name: tbstaffs_old staff_id_auto; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbstaffs_old ALTER COLUMN staff_id_auto SET DEFAULT nextval('public.tbstaffs_old_staff_id_auto_seq'::regclass);


--
-- Name: tbstakeholder stakeholder_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbstakeholder ALTER COLUMN stakeholder_id SET DEFAULT nextval('public.tbstakeholder_stakeholder_id_seq'::regclass);


--
-- Name: tbvillages village_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbvillages ALTER COLUMN village_id SET DEFAULT nextval('public.tbvillages_village_id_seq'::regclass);


--
-- Name: tbwards ward_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbwards ALTER COLUMN ward_id SET DEFAULT nextval('public.tbwards_ward_id_seq'::regclass);


--
-- Name: test_data id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.test_data ALTER COLUMN id SET DEFAULT nextval('public.test_data_id_seq'::regclass);


--
-- Name: user_sessions id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.user_sessions ALTER COLUMN id SET DEFAULT nextval('public.user_sessions_id_seq'::regclass);


--
-- Data for Name: amortization_schedule; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.amortization_schedule (id, loan_id, payment_number, payment_date, actual_payment_date, payment_amount, principal, interest, remaining_balance, paid_amount, payment_status, late_penalty, amount_due) FROM stdin;
66	14	1	2024-07-10	\N	14750.00	12500.00	2250.00	150000	0.00	pending	0.00	\N
67	14	2	2024-08-10	\N	14750.00	12500.00	2250.00	150000	0.00	pending	0.00	\N
68	14	3	2024-09-10	\N	14750.00	12500.00	2250.00	150000	0.00	pending	0.00	\N
69	14	4	2024-10-10	\N	14750.00	12500.00	2250.00	150000	0.00	pending	0.00	\N
70	14	5	2024-11-10	\N	14750.00	12500.00	2250.00	150000	0.00	pending	0.00	\N
71	14	6	2024-12-10	\N	14750.00	12500.00	2250.00	150000	0.00	pending	0.00	\N
72	14	7	2025-01-10	\N	14750.00	12500.00	2250.00	150000	0.00	pending	0.00	\N
73	14	8	2025-02-10	\N	14750.00	12500.00	2250.00	150000	0.00	pending	0.00	\N
74	14	9	2025-03-10	\N	14750.00	12500.00	2250.00	150000	0.00	pending	0.00	\N
75	14	10	2025-04-10	\N	14750.00	12500.00	2250.00	150000	0.00	pending	0.00	\N
76	14	11	2025-05-10	\N	14750.00	12500.00	2250.00	150000	0.00	pending	0.00	\N
77	14	12	2025-06-10	\N	14750.00	12500.00	2250.00	150000	0.00	pending	0.00	\N
78	15	1	2021-07-23	\N	27500.00	22916.67	4583.33	275000	0.00	pending	0.00	\N
79	15	2	2021-08-23	\N	27500.00	22916.67	4583.33	275000	0.00	pending	0.00	\N
80	15	3	2021-09-23	\N	27500.00	22916.67	4583.33	275000	0.00	pending	0.00	\N
81	15	4	2021-10-23	\N	27500.00	22916.67	4583.33	275000	0.00	pending	0.00	\N
82	15	5	2021-11-23	\N	27500.00	22916.67	4583.33	275000	0.00	pending	0.00	\N
83	15	6	2021-12-23	\N	27500.00	22916.67	4583.33	275000	0.00	pending	0.00	\N
84	15	7	2022-01-23	\N	27500.00	22916.67	4583.33	275000	0.00	pending	0.00	\N
85	15	8	2022-02-23	\N	27500.00	22916.67	4583.33	275000	0.00	pending	0.00	\N
86	15	9	2022-03-23	\N	27500.00	22916.67	4583.33	275000	0.00	pending	0.00	\N
87	15	10	2022-04-23	\N	27500.00	22916.67	4583.33	275000	0.00	pending	0.00	\N
88	15	11	2022-05-23	\N	27500.00	22916.67	4583.33	275000	0.00	pending	0.00	\N
89	15	12	2022-06-23	\N	27500.00	22916.67	4583.33	275000	0.00	pending	0.00	\N
90	16	1	2020-07-30	\N	196666.67	166666.67	30000.00	2000000	0.00	pending	0.00	\N
91	16	2	2020-08-30	\N	196666.67	166666.67	30000.00	2000000	0.00	pending	0.00	\N
92	16	3	2020-09-30	\N	196666.67	166666.67	30000.00	2000000	0.00	pending	0.00	\N
93	16	4	2020-10-30	\N	196666.67	166666.67	30000.00	2000000	0.00	pending	0.00	\N
94	16	5	2020-11-30	\N	196666.67	166666.67	30000.00	2000000	0.00	pending	0.00	\N
95	16	6	2020-12-30	\N	196666.67	166666.67	30000.00	2000000	0.00	pending	0.00	\N
96	16	7	2021-01-30	\N	196666.67	166666.67	30000.00	2000000	0.00	pending	0.00	\N
97	16	8	2021-03-02	\N	196666.67	166666.67	30000.00	2000000	0.00	pending	0.00	\N
98	16	9	2021-03-30	\N	196666.67	166666.67	30000.00	2000000	0.00	pending	0.00	\N
99	16	10	2021-04-30	\N	196666.67	166666.67	30000.00	2000000	0.00	pending	0.00	\N
100	16	11	2021-05-30	\N	196666.67	166666.67	30000.00	2000000	0.00	pending	0.00	\N
101	16	12	2021-06-30	\N	196666.67	166666.67	30000.00	2000000	0.00	pending	0.00	\N
102	17	1	2023-01-31	\N	11900.00	10316.67	1583.33	100000	0.00	pending	0.00	\N
103	17	2	2023-03-03	\N	11900.00	10316.67	1583.33	100000	0.00	pending	0.00	\N
104	17	3	2023-03-31	\N	11900.00	10316.67	1583.33	100000	0.00	pending	0.00	\N
105	17	4	2023-05-01	\N	11900.00	10316.67	1583.33	100000	0.00	pending	0.00	\N
106	17	5	2023-05-31	\N	11900.00	10316.67	1583.33	100000	0.00	pending	0.00	\N
107	17	6	2023-07-01	\N	11900.00	10316.67	1583.33	100000	0.00	pending	0.00	\N
108	17	7	2023-07-31	\N	11900.00	10316.67	1583.33	100000	0.00	pending	0.00	\N
109	17	8	2023-08-31	\N	11900.00	10316.67	1583.33	100000	0.00	pending	0.00	\N
110	17	9	2023-10-01	\N	11900.00	10316.67	1583.33	100000	0.00	pending	0.00	\N
111	17	10	2023-10-31	\N	11900.00	10316.67	1583.33	100000	0.00	pending	0.00	\N
112	18	1	2023-01-31	\N	9916.67	8333.33	1583.33	100000	0.00	pending	0.00	\N
113	18	2	2023-03-03	\N	9916.67	8333.33	1583.33	100000	0.00	pending	0.00	\N
114	18	3	2023-03-31	\N	9916.67	8333.33	1583.33	100000	0.00	pending	0.00	\N
115	18	4	2023-05-01	\N	9916.67	8333.33	1583.33	100000	0.00	pending	0.00	\N
116	18	5	2023-05-31	\N	9916.67	8333.33	1583.33	100000	0.00	pending	0.00	\N
117	18	6	2023-07-01	\N	9916.67	8333.33	1583.33	100000	0.00	pending	0.00	\N
118	18	7	2023-07-31	\N	9916.67	8333.33	1583.33	100000	0.00	pending	0.00	\N
119	18	8	2023-08-31	\N	9916.67	8333.33	1583.33	100000	0.00	pending	0.00	\N
120	18	9	2023-10-01	\N	9916.67	8333.33	1583.33	100000	0.00	pending	0.00	\N
121	18	10	2023-10-31	\N	9916.67	8333.33	1583.33	100000	0.00	pending	0.00	\N
122	18	11	2023-12-01	\N	9916.67	8333.33	1583.33	100000	0.00	pending	0.00	\N
123	18	12	2023-12-31	\N	9916.67	8333.33	1583.33	100000	0.00	pending	0.00	\N
124	19	1	2023-01-05	\N	9916.67	8333.33	1583.33	100000	0.00	pending	0.00	\N
125	19	2	2023-02-05	\N	9916.67	8333.33	1583.33	100000	0.00	pending	0.00	\N
126	19	3	2023-03-05	\N	9916.67	8333.33	1583.33	100000	0.00	pending	0.00	\N
127	19	4	2023-04-05	\N	9916.67	8333.33	1583.33	100000	0.00	pending	0.00	\N
128	19	5	2023-05-05	\N	9916.67	8333.33	1583.33	100000	0.00	pending	0.00	\N
129	19	6	2023-06-05	\N	9916.67	8333.33	1583.33	100000	0.00	pending	0.00	\N
130	19	7	2023-07-05	\N	9916.67	8333.33	1583.33	100000	0.00	pending	0.00	\N
131	19	8	2023-08-05	\N	9916.67	8333.33	1583.33	100000	0.00	pending	0.00	\N
132	19	9	2023-09-05	\N	9916.67	8333.33	1583.33	100000	0.00	pending	0.00	\N
133	19	10	2023-10-05	\N	9916.67	8333.33	1583.33	100000	0.00	pending	0.00	\N
134	19	11	2023-11-05	\N	9916.67	8333.33	1583.33	100000	0.00	pending	0.00	\N
135	19	12	2023-12-05	\N	9916.67	8333.33	1583.33	100000	0.00	pending	0.00	\N
136	20	1	2023-08-05	\N	19833.33	16666.67	3166.67	200000	0.00	pending	0.00	\N
137	20	2	2023-09-05	\N	19833.33	16666.67	3166.67	200000	0.00	pending	0.00	\N
138	20	3	2023-10-05	\N	19833.33	16666.67	3166.67	200000	0.00	pending	0.00	\N
139	20	4	2023-11-05	\N	19833.33	16666.67	3166.67	200000	0.00	pending	0.00	\N
140	20	5	2023-12-05	\N	19833.33	16666.67	3166.67	200000	0.00	pending	0.00	\N
141	20	6	2024-01-05	\N	19833.33	16666.67	3166.67	200000	0.00	pending	0.00	\N
142	20	7	2024-02-05	\N	19833.33	16666.67	3166.67	200000	0.00	pending	0.00	\N
143	20	8	2024-03-05	\N	19833.33	16666.67	3166.67	200000	0.00	pending	0.00	\N
144	20	9	2024-04-05	\N	19833.33	16666.67	3166.67	200000	0.00	pending	0.00	\N
145	20	10	2024-05-05	\N	19833.33	16666.67	3166.67	200000	0.00	pending	0.00	\N
146	20	11	2024-06-05	\N	19833.33	16666.67	3166.67	200000	0.00	pending	0.00	\N
147	20	12	2024-07-05	\N	19833.33	16666.67	3166.67	200000	0.00	pending	0.00	\N
148	21	1	2023-01-05	\N	9916.67	8333.33	1583.33	100000	0.00	pending	0.00	\N
149	21	2	2023-02-05	\N	9916.67	8333.33	1583.33	100000	0.00	pending	0.00	\N
150	21	3	2023-03-05	\N	9916.67	8333.33	1583.33	100000	0.00	pending	0.00	\N
151	21	4	2023-04-05	\N	9916.67	8333.33	1583.33	100000	0.00	pending	0.00	\N
152	21	5	2023-05-05	\N	9916.67	8333.33	1583.33	100000	0.00	pending	0.00	\N
153	21	6	2023-06-05	\N	9916.67	8333.33	1583.33	100000	0.00	pending	0.00	\N
154	21	7	2023-07-05	\N	9916.67	8333.33	1583.33	100000	0.00	pending	0.00	\N
155	21	8	2023-08-05	\N	9916.67	8333.33	1583.33	100000	0.00	pending	0.00	\N
156	21	9	2023-09-05	\N	9916.67	8333.33	1583.33	100000	0.00	pending	0.00	\N
157	21	10	2023-10-05	\N	9916.67	8333.33	1583.33	100000	0.00	pending	0.00	\N
158	21	11	2023-11-05	\N	9916.67	8333.33	1583.33	100000	0.00	pending	0.00	\N
159	21	12	2023-12-05	\N	9916.67	8333.33	1583.33	100000	0.00	pending	0.00	\N
160	22	1	2019-08-07	\N	9916.67	8333.33	1583.33	100000	0.00	pending	0.00	\N
161	22	2	2019-09-07	\N	9916.67	8333.33	1583.33	100000	0.00	pending	0.00	\N
162	22	3	2019-10-07	\N	9916.67	8333.33	1583.33	100000	0.00	pending	0.00	\N
163	22	4	2019-11-07	\N	9916.67	8333.33	1583.33	100000	0.00	pending	0.00	\N
164	22	5	2019-12-07	\N	9916.67	8333.33	1583.33	100000	0.00	pending	0.00	\N
165	22	6	2020-01-07	\N	9916.67	8333.33	1583.33	100000	0.00	pending	0.00	\N
166	22	7	2020-02-07	\N	9916.67	8333.33	1583.33	100000	0.00	pending	0.00	\N
167	22	8	2020-03-07	\N	9916.67	8333.33	1583.33	100000	0.00	pending	0.00	\N
168	22	9	2020-04-07	\N	9916.67	8333.33	1583.33	100000	0.00	pending	0.00	\N
169	22	10	2020-05-07	\N	9916.67	8333.33	1583.33	100000	0.00	pending	0.00	\N
170	22	11	2020-06-07	\N	9916.67	8333.33	1583.33	100000	0.00	pending	0.00	\N
171	22	12	2020-07-07	\N	9916.67	8333.33	1583.33	100000	0.00	pending	0.00	\N
172	23	1	2023-01-31	\N	9916.67	8333.33	1583.33	100000	0.00	pending	0.00	\N
173	23	2	2023-03-03	\N	9916.67	8333.33	1583.33	100000	0.00	pending	0.00	\N
174	23	3	2023-03-31	\N	9916.67	8333.33	1583.33	100000	0.00	pending	0.00	\N
175	23	4	2023-05-01	\N	9916.67	8333.33	1583.33	100000	0.00	pending	0.00	\N
176	23	5	2023-05-31	\N	9916.67	8333.33	1583.33	100000	0.00	pending	0.00	\N
177	23	6	2023-07-01	\N	9916.67	8333.33	1583.33	100000	0.00	pending	0.00	\N
178	23	7	2023-07-31	\N	9916.67	8333.33	1583.33	100000	0.00	pending	0.00	\N
179	23	8	2023-08-31	\N	9916.67	8333.33	1583.33	100000	0.00	pending	0.00	\N
180	23	9	2023-10-01	\N	9916.67	8333.33	1583.33	100000	0.00	pending	0.00	\N
181	23	10	2023-10-31	\N	9916.67	8333.33	1583.33	100000	0.00	pending	0.00	\N
182	23	11	2023-12-01	\N	9916.67	8333.33	1583.33	100000	0.00	pending	0.00	\N
183	23	12	2023-12-31	\N	9916.67	8333.33	1583.33	100000	0.00	pending	0.00	\N
184	24	1	2024-01-31	\N	196666.67	166666.67	30000.00	2000000	0.00	pending	0.00	\N
185	24	2	2024-03-02	\N	196666.67	166666.67	30000.00	2000000	0.00	pending	0.00	\N
186	24	3	2024-03-31	\N	196666.67	166666.67	30000.00	2000000	0.00	pending	0.00	\N
187	24	4	2024-05-01	\N	196666.67	166666.67	30000.00	2000000	0.00	pending	0.00	\N
188	24	5	2024-05-31	\N	196666.67	166666.67	30000.00	2000000	0.00	pending	0.00	\N
189	24	6	2024-07-01	\N	196666.67	166666.67	30000.00	2000000	0.00	pending	0.00	\N
190	24	7	2024-07-31	\N	196666.67	166666.67	30000.00	2000000	0.00	pending	0.00	\N
191	24	8	2024-08-31	\N	196666.67	166666.67	30000.00	2000000	0.00	pending	0.00	\N
192	24	9	2024-10-01	\N	196666.67	166666.67	30000.00	2000000	0.00	pending	0.00	\N
193	24	10	2024-10-31	\N	196666.67	166666.67	30000.00	2000000	0.00	pending	0.00	\N
194	24	11	2024-12-01	\N	196666.67	166666.67	30000.00	2000000	0.00	pending	0.00	\N
195	24	12	2024-12-31	\N	196666.67	166666.67	30000.00	2000000	0.00	pending	0.00	\N
196	25	1	2022-01-20	\N	23800.00	20633.33	3166.67	200000	0.00	pending	0.00	\N
197	25	2	2022-02-20	\N	23800.00	20633.33	3166.67	200000	0.00	pending	0.00	\N
198	25	3	2022-03-20	\N	23800.00	20633.33	3166.67	200000	0.00	pending	0.00	\N
199	25	4	2022-04-20	\N	23800.00	20633.33	3166.67	200000	0.00	pending	0.00	\N
200	25	5	2022-05-20	\N	23800.00	20633.33	3166.67	200000	0.00	pending	0.00	\N
201	25	6	2022-06-20	\N	23800.00	20633.33	3166.67	200000	0.00	pending	0.00	\N
202	25	7	2022-07-20	\N	23800.00	20633.33	3166.67	200000	0.00	pending	0.00	\N
203	25	8	2022-08-20	\N	23800.00	20633.33	3166.67	200000	0.00	pending	0.00	\N
204	25	9	2022-09-20	\N	23800.00	20633.33	3166.67	200000	0.00	pending	0.00	\N
205	25	10	2022-10-20	\N	23800.00	20633.33	3166.67	200000	0.00	pending	0.00	\N
\.


--
-- Data for Name: loan_penalties; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.loan_penalties (id, loan_id, penalty_amount, penalty_date, created_at) FROM stdin;
\.


--
-- Data for Name: loan_repayments; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.loan_repayments (id, loan_id, payment_date, principal_amount, interest_amount, repayment_amount, late_penalty, payment_status) FROM stdin;
\.


--
-- Data for Name: loan_repayments_existing; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.loan_repayments_existing (id, loan_id, payment_date, amount_paid, interest_paid, principal_paid, status, penalty, created_at) FROM stdin;
\.


--
-- Data for Name: repayment_history; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.repayment_history (id, loan_id, payment_date, paid_amount, interest_paid, principal_paid, total_paid_amount, outstanding_amount, created_at, updated_at, outstanding_principal, outstanding_interest, total_outstanding, payment_mode, produce, produce_price, quantity, penalty_charged, credit_balance) FROM stdin;
120	23	2023-01-31	10000.00	1583.33	8416.67	10000.00	109000.00	2025-07-07 21:11:10.730182	2025-07-07 21:11:10.730182	91583.33	17416.67	109000.00	Cash	\N	\N	\N	0.00	0.00
121	23	2025-07-07	151000.00	17416.67	91583.33	151000.00	0.00	2025-07-07 21:14:41.639123	2025-07-07 21:14:41.639123	0.00	0.00	0.00	Cash	\N	\N	\N	0.00	0.00
122	25	2025-07-07	370000.00	31666.67	200000.00	370000.00	0.00	2025-07-07 21:19:05.883068	2025-07-07 21:19:05.883068	0.00	0.00	0.00	Cash	\N	\N	\N	0.00	0.00
123	24	2024-01-31	200000.00	30000.00	170000.00	200000.00	2160000.00	2025-07-07 21:21:26.823485	2025-07-07 21:21:26.823485	1830000.00	330000.00	2160000.00	Cash	\N	\N	\N	0.00	0.00
124	24	2024-04-30	400000.00	90000.00	310000.00	400000.00	1760000.00	2025-07-07 21:23:27.68023	2025-07-07 21:23:27.68023	1520000.00	240000.00	1760000.00	Cash	\N	\N	\N	0.00	0.00
125	24	2025-07-07	1980000.00	240000.00	1520000.00	1980000.00	0.00	2025-07-07 21:26:06.578218	2025-07-07 21:26:06.578218	0.00	0.00	0.00	Cash	\N	\N	\N	0.00	0.00
\.


--
-- Data for Name: repayment_historyxx; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.repayment_historyxx (id, loan_id, payment_date, paid_amount, interest_paid, principal_paid, total_paid, outstanding_balance) FROM stdin;
\.


--
-- Data for Name: repayments; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.repayments (repayment_id, loan_id, repayment_date, amount_paid, late_penalty, total_paid, new_balance, created_at) FROM stdin;
\.


--
-- Data for Name: tbagriitem; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.tbagriitem (agriitem_id, agriitem_name, agriitem_group, created_by, created_date, agriitem_status) FROM stdin;
1	Seeds	Input	79	2024-12-26	Active
3	Fertilizers	Input	79	2024-12-27	Active
4	Boosters	Input	79	2024-12-27	Active
5	Herbicides	Input	79	2024-12-27	Active
6	Maize	Produce	79	2025-01-01	Active
7	Paddy	Produce	79	2025-01-13	Active
8	Soybeans	Produce	79	2025-01-13	Active
9	Tractor	Implements	79	2025-01-19	Active
10	Power Tiller	Implements	79	2025-01-19	Active
14	White Maize	Produce	STAFF505507	2025-04-24	Active
15	we	Implements	79	2025-04-27	Active
2	www	Implements	79	2025-06-26	Active
11	tt	Produce	79	2025-06-26	Active
12	rty	Implements	79	2025-06-26	Active
\.


--
-- Data for Name: tbaudit_trail; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.tbaudit_trail (action, activity_date, activity_time, audit_id, creator, description, ip, id) FROM stdin;
Add Group	2025-06-11	19:12:44	\N	79	Add Group: ee Located at region - Mbeya	197.250.229.209	1
Add Group	2025-06-11	20:54:29	\N	79	Add Group: o Located at region - Iringa	197.250.229.209	2
Add Group	2025-06-11	20:56:55	\N	79	Add Group: p Located at region - Ruvuma	197.250.199.252	3
Add Group	2025-06-11	20:59:22	\N	79	Add Group: Q Located at region - Mbeya	197.250.199.252	4
Add Group	2025-06-11	21:02:20	\N	79	Add Group: W Located at region - Iringa	197.250.199.252	5
Add Group	2025-06-11	21:04:20	\N	79	Add Group: Z Located at region - Mbeya	197.250.199.252	6
Add Group	2025-06-11	21:07:26	\N	79	Add Group: J Located at region - Songwe	197.250.199.252	7
Add Group	2025-06-11	21:27:24	\N	79	Add Group: M Located at region - Ruvuma	197.250.199.252	8
Add Group	2025-06-11	21:38:50	\N	79	Add Group: n Located at region - Mbeya	197.250.199.252	9
Add Group	2025-06-11	21:45:29	\N	79	Add Group: W Located at region - Songwe	197.250.199.252	10
Add Group	2025-06-11	22:04:49	\N	79	Add Group: c Located at region - Njombe	197.250.199.252	11
Add Group	2025-06-11	22:09:03	\N	79	Add Group: a Located at region - Mbeya	197.250.199.252	12
Add Member	2025-06-11	22:37:49	\N	79	Add Member:  in group number - 2	197.250.199.252	13
Add Member	2025-06-11	22:41:37	\N	79	Add Member:  in group number - 2	197.250.199.252	14
Add Member	2025-06-11	22:47:22	\N	79	Add Member:  in group number - 2	197.250.199.252	15
Add Member	2025-06-11	22:53:02	\N	79	Add Member:  in group number - 2	197.250.199.252	16
Add Member	2025-06-18	07:41:06	\N	79	Add Member:  in group number - 1	197.250.199.203	17
Approve Loan	2025-06-23	21:08:15	\N	\N	Approve loan id - 	197.250.134.235	18
Approve Loan	2025-06-23	21:09:29	\N	\N	Approve loan id - 	197.250.134.235	19
Approve Loan	2025-06-23	21:23:16	\N	\N	Approve loan id - 	197.250.134.235	20
Approve Loan	2025-06-23	21:25:02	\N	\N	Approve loan id - 14	197.250.134.235	21
Approve Loan	2025-06-23	21:28:24	\N	\N	Approve loan id - 14	197.250.134.235	22
Approve Loan	2025-06-23	21:29:47	\N	\N	Approve loan id - 14	197.250.134.235	23
Approve Loan	2025-06-23	21:32:46	\N	79	Approve loan id - 14	197.250.134.235	24
Approve Loan	2025-06-23	22:59:30	\N	79	Approve loan id - 15	197.250.134.235	25
Approve Loan	2025-06-24	15:46:02	\N	\N	Approve loan id - 14	197.250.134.235	26
Add Stakeholder	2025-06-26	10:10:03	\N	\N	Add stakeholder named: rr	197.250.103.74	27
Add Stakeholder	2025-06-26	10:15:16	\N	\N	Add stakeholder named: CRDB BANK	197.250.103.74	28
Add Stakeholder	2025-06-26	11:29:47	\N	\N	Add stakeholder named: EQUITY BANK	197.250.103.74	29
Add Agri-item	2025-06-26	11:40:56	\N	79	Add agri item: www	197.250.103.74	30
Add Agri-item	2025-06-26	11:44:38	\N	79	Add agri item: tt	197.250.103.74	31
Add Agri-item	2025-06-26	11:44:50	\N	79	Add agri item: rty	197.250.103.74	32
Add variety or manufacture	2025-06-26	12:10:18	\N	79	Add variety or manufacture named: dde	197.250.103.74	33
Add variety or manufacture	2025-06-26	12:11:10	\N	79	Add variety or manufacture named: PPF TR	197.250.103.74	34
Add Product	2025-06-26	12:29:17	\N	79	Add product named: RRTRY with group id - 3	197.250.103.74	35
Add Product	2025-06-26	12:31:59	\N	79	Add product named: po with group id - 5	197.250.103.74	36
Add Product	2025-06-26	12:37:18	\N	79	Add product named: uu with group id - 8	197.250.103.74	37
Add Product	2025-06-26	12:38:39	\N	79	Add product named: kk with group id - 5	197.250.103.74	38
Add Member	2025-07-01	07:15:46	\N	\N	Add Member:  in group number - 1	51.159.226.155	39
Approve Loan	2025-07-03	10:45:24	\N	79	Approve loan id - 16	197.250.133.236	40
Approve Loan	2025-07-03	11:38:17	\N	79	Approve loan id - 17	197.250.133.236	41
Approve Loan	2025-07-03	19:27:08	\N	79	Approve loan id - 18	197.250.50.73	42
Approve Loan	2025-07-05	19:46:50	\N	79	Approve loan id - 21	197.250.50.11	43
Approve Loan	2025-07-05	19:46:54	\N	STAFF505507	Approve loan id - 20	197.250.199.216	44
Approve Loan	2025-07-07	19:07:08	\N	79	Approve loan id - 23	197.250.51.218	45
Approve Loan	2025-07-07	19:07:16	\N	79	Approve loan id - 24	197.250.51.218	46
Approve Loan	2025-07-07	19:07:22	\N	79	Approve loan id - 25	197.250.51.218	47
Group Ordering Budget	2025-07-07	23:11:58	\N	79	Group budgeting for group id - 1	197.250.51.218	48
Group Ordering Budget	2025-07-07	23:23:26	\N	79	Group budgeting for group id - 3	197.250.51.218	49
Group Ordering Budget	2025-07-07	23:28:25	\N	79	Group budgeting for group id - 2	197.250.51.218	50
Group Ordering Budget	2025-07-07	23:31:27	\N	79	Group budgeting for group id - 3	197.250.51.218	51
Group Ordering Budget	2025-07-07	23:38:07	\N	79	Group budgeting for group id - 3	197.250.51.218	52
Group Ordering Budget	2025-07-07	23:42:26	\N	79	Group budgeting for group id - 5	197.250.51.218	53
Group Ordering Budget	2025-07-08	00:21:31	\N	79	Group budgeting for group id - 1	197.250.51.218	54
Group Ordering Budget	2025-07-08	00:39:16	\N	79	Group budgeting for group id - 2	197.250.51.218	55
Group Ordering Budget	2025-07-08	14:39:36	\N	79	Group budgeting for group id - 1	197.250.51.218	56
Group Ordering Budget	2025-07-08	16:48:51	\N	\N	Group budgeting for group id - 1	197.250.226.213	57
Group Ordering Budget	2025-07-08	22:31:31	\N	\N	Group budgeting for group id - 2	197.250.100.90	58
Approve Loan	2025-07-09	16:09:20	\N	79	Create loan id - 20	197.250.100.90	59
Approve Loan	2025-07-09	16:11:17	\N	79	Create loan id - 21	197.250.100.90	60
Group Ordering Budget	2025-07-09	17:58:45	\N	79	Group budgeting for group id - 3	197.250.100.90	61
Group Ordering Budget	2025-07-09	17:59:10	\N	79	Group budgeting for group id - 3	197.250.100.90	62
Group Ordering Budget	2025-07-09	18:02:17	\N	79	Group budgeting for group id - 3	197.250.100.90	63
Add Member	2025-07-09	18:04:48	\N	79	Add Member:  in group number - 3	197.250.100.90	64
Approve Loan	2025-07-09	18:05:37	\N	79	Create loan id - 22	197.250.100.90	65
Group Ordering Budget	2025-07-09	22:21:44	\N	\N	Group budgeting for group id - 7	197.250.100.90	66
Add Member	2025-07-09	22:43:24	\N	\N	Add Member:  in group number - 4	197.250.100.90	67
Add Member	2025-07-09	22:44:13	\N	\N	Add Member:  in group number - 5	197.250.100.90	68
Add Member	2025-07-09	22:45:31	\N	\N	Add Member:  in group number - 6	197.250.100.90	69
Add Member	2025-07-09	22:47:49	\N	\N	Add Member:  in group number - 7	197.250.100.90	70
Approve Loan	2025-07-10	18:05:08	\N	\N	Create loan id - 24	169.255.185.16	71
Group Ordering Budget	2025-07-10	18:22:18	\N	\N	Group budgeting for group id - 5	169.255.185.16	72
Approve Loan	2025-07-10	18:47:46	\N	\N	Create loan id - 25	169.255.185.16	73
Group Ordering Budget	2025-07-10	20:52:20	\N	79	Group budgeting for group id - 1	197.250.100.90	74
Group Ordering Budget	2025-07-10	20:54:46	\N	79	Group budgeting for group id - 5	197.250.100.90	75
Group Ordering Budget	2025-07-10	20:56:34	\N	79	Group budgeting for group id - 7	197.250.100.90	76
Group Ordering Budget	2025-07-10	22:26:46	\N	\N	Group budgeting for group id - 2	197.250.134.58	77
Group Ordering Budget	2025-07-10	22:33:29	\N	\N	Group budgeting for group id - 1	197.250.134.58	78
Group Ordering Budget	2025-07-10	22:39:47	\N	\N	Group budgeting for group id - 1	197.250.134.58	79
Group Ordering Budget	2025-07-10	22:43:15	\N	79	Group budgeting for group id - 7	197.250.134.58	80
Group Ordering Budget	2025-07-10	22:51:40	\N	79	Group budgeting for group id - 1	197.250.134.58	81
Approve New Loan	2025-07-14	10:24:13	\N	79	Approve New loan id - 22	197.250.230.14	82
Reject New Loan	2025-07-14	10:36:33	\N	79	Reject New loan id - 22	197.250.230.14	83
Approve New Loan	2025-07-14	10:38:34	\N	79	Approve New loan id - 24	197.250.230.14	84
Approve New Loan	2025-07-14	12:19:05	\N	79	Approve New loan id - 22	197.250.230.14	85
Approve New Loan	2025-07-14	19:18:34	\N	\N	Approve New loan id - 24	196.249.99.190	86
Approve New Loan	2025-07-14	19:19:33	\N	\N	Approve New loan id - 25	196.249.99.190	87
Approve New Loan	2025-07-15	10:00:32	\N	79	Approve New loan id - 25	197.250.230.14	88
\.


--
-- Data for Name: tbbranches; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.tbbranches (branch_categoty, branch_description, branch_district, branch_id, branch_name, branch_region, branch_status, branch_ward, created_by, created_date) FROM stdin;
\.


--
-- Data for Name: tbdepartments; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.tbdepartments (department_id, department_id_auto, department_name, hod, department_description, department_status, created_by, created_date) FROM stdin;
DEP222693	6	Human Resources	STAFF429439	 HR Department at MCODE plays a crucial role in attracting, developing, and retaining a high-performing workforce. Key functions include recruitment, onboarding, employee development, compensation & benefits, and employee relations. The department fosters a positive work environment, ensures compliance with labor laws, and maintains accurate employee records. This enables MCODE to build a strong and motivated team to effectively achieve its mission of empowering rural communities in Tanzania	Active	79	2024-12-27
DEP230286	3	Credit	STAFF236983	heck that Firefox has permission to access the web (you might be connected but behind a firewall)	Active	79	2024-10-22
DEP27101	5	Programs	STAFF505507	The Programs Department is the heart of MCODE, driving the organizations mission to empower rural communities in Tanzania. This dynamic department plays a crucial role in:rnrnDeveloping impactful programs: Identifying critical needs in rural communities, conducting thorough needs assessments, and designing innovative and effective development programs.rnSecuring sustainable funding: Writing compelling project proposals and actively pursuing funding opportunities from diverse sources, including donors, foundations, and government agencies.rnEnsuring program success: Overseeing the day-to-day implementation of all programs, providing technical guidance to field staff, and conducting rigorous monitoring and evaluation to track progress and measure impact.rnBuilding strong community partnerships: Fostering active community participation in program design and implementation, addressing community concerns, and ensuring the long-term sustainability of interventions.rnStrengthening capacity: Providing targeted training and capacity building support to community members, local partners, and MCODE staff.rnBy effectively fulfilling these key functions, the Programs Department ensures that MCODEs interventions are impactful, sustainable, and contribute significantly to the development of rural communities in Tanzania.	Active	79	2024-12-27
DEP292871	4	MicroLanding	STAFF925448	kjhsdfklkf shdf jkgdfs	Active	79	2024-11-25
DEP483282	7	Accounting	STAFF505507	Accounting Department at MCODE is essential for the organizations financial health and sustainability. Key functions include:rnrnFinancial Record Keeping: Accurate and timely recording of all financial transactions, including income, expenses, and assets.rnBudgeting & Forecasting: Developing and managing budgets, monitoring expenditures, and preparing financial forecasts.rnPayroll & Accounts Payable/Receivable: Processing salaries, managing supplier invoices, and collecting revenue.rnFinancial Reporting: Preparing financial statements for management, donors, and regulatory authorities.rnInternal Controls: Implementing strong internal controls to safeguard organizational assets and ensure financial integrity.	Active	79	2024-12-27
DEP844772	1	finance	STAFF925448	asdjlhsds dskfjlhksdjf	Active	79	2024-10-22
\.


--
-- Data for Name: tbdesignations; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.tbdesignations (designation_id, designation_id_auto, designation_name, designation_description, created_by, created_date, designation_status) FROM stdin;
\.


--
-- Data for Name: tbdisbursements; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.tbdisbursements (disb_id, group_id, loan_terms, penalty_percent, calculation_type, disbursement_date, loan_rate, loan_interest, disbursement_bank, principle_amount, principle_amount_original, outstanding_balance, loan_status, created_by, created_at, is_deleted, deleted_date, application_id, disbursment_slip) FROM stdin;
5	5	12	20	flat	2025-07-14	20	500000	3	2500000	2500000	3000000	\N	79	2025-07-15 12:04:46.81719	NO   	\N	25	1752573886_d86e0865041596c0b78a.pdf
\.


--
-- Data for Name: tbdistricts; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.tbdistricts (district_id, district_name, district_status, region_id) FROM stdin;
\.


--
-- Data for Name: tbfertilize; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.tbfertilize (fertilizer_id, fertilizer_loan_rate, fertilizer_name, fertilizer_status, fertilizer_unit_price, created_by, created_date, fertilizer_code) FROM stdin;
\.


--
-- Data for Name: tbgroup_bank_accounts; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.tbgroup_bank_accounts (bank_account_id, group_id, group_bank, group_account_number) FROM stdin;
1	8	8	ee
2	9	8	ee
3	10	8	990
4	11	12	pp
5	12	8	QQ
6	13	8	W
7	14	8	Z
8	15	8	J
9	16	8	M1
10	16	12	M2
11	17	8	n1
12	17	12	n2
13	17	8	n3
14	18	8	W2
15	19	12	c
16	20	12	aa
\.


--
-- Data for Name: tbgroup_budget_items; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.tbgroup_budget_items (id, budget_id, product_id, quantity, price) FROM stdin;
21	12	24	100.00	50000.00
22	12	42	50.00	20000.00
23	15	49	100.00	5000.00
24	15	12	50.00	4000.00
25	15	13	40.00	3000.00
34	18	34	50.00	7000.00
35	18	21	50.00	8000.00
36	18	28	22.00	48000.00
37	18	33	30.00	50000.00
43	20	34	1.00	100000.00
44	20	28	2.00	100000.00
45	20	33	1.00	100000.00
46	20	31	1.00	30000.00
47	20	15	1.00	80000.00
48	21	34	5.00	20000.00
49	22	28	5.00	30000.00
50	23	24	20.00	20000.00
57	31	34	1.00	20000.00
58	31	21	2.00	35000.00
59	32	34	1.00	49000.00
60	32	33	1.00	1000.00
61	33	2	343.00	380.00
\.


--
-- Data for Name: tbgroup_budgets; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.tbgroup_budgets (id, group_id, season_year, groupresolution, groupletter, inputrequirementform, applicationleterandresolution, upfrontcontribution, created_by, created_at, budget_amount, input_package) FROM stdin;
12	1	2020-2021	upload/groupordering/1751993331_d353d70e381ee37a3099.pdf	upload/groupordering/1751993331_8f4d08d656dcb5ff7d8a.pdf	upload/groupordering/1751993331_d8249895ab5bcf48afaf.pdf	upload/groupordering/1751993331_b7167d5c927395294fdd.pdf	upload/groupordering/1751993331_cad4e924eefd0b0a1968.pdf	\N	2025-07-08 18:48:51.705426	6000000.00	\N
15	2	2024-2025	upload/groupordering/1752013891_b49f3c4d2456e07bb30c.pdf	upload/groupordering/1752013891_531eade01c8d160f58f8.pdf	upload/groupordering/1752013891_df06c277c759338e680d.pdf	upload/groupordering/1752013891_d6766a027855e917a6ae.pdf	upload/groupordering/1752013891_9c54d4f7186bd102d565.pdf	\N	2025-07-09 00:31:31.554198	820000.00	\N
18	3	2023-2024	upload/groupordering/1752084137_d6ead9d82c5f54bf56ee.pdf	upload/groupordering/1752084137_79a9172c55a5e6002ec1.pdf	upload/groupordering/1752084137_32b45349511ff5e92e94.pdf	upload/groupordering/1752084137_17efdf426f2f28f699b6.pdf	upload/groupordering/1752084137_12119403412d6a423aba.pdf	79	2025-07-09 20:02:17.665742	3306000.00	\N
21	1	2024-2025	upload/groupordering/1752180740_690e2c442c4f1113f1b1.pdf	upload/groupordering/1752180740_a98d33df421c0dd37dde.pdf	upload/groupordering/1752180740_a75854a2df0bd3ddb9e5.pdf	upload/groupordering/1752180740_5405c72173913faeaf58.pdf	upload/groupordering/1752180740_6120ecfccdb3c438ba6f.pdf	79	2025-07-10 22:52:20.441528	100000.00	\N
22	5	2022-2023	upload/groupordering/1752180886_bc0f34303fbc6ed87d2a.pdf	upload/groupordering/1752180886_eedda0d08b0dda312637.pdf	upload/groupordering/1752180886_648d64eebf3eaacc1576.pdf	upload/groupordering/1752180886_a1c26b4af54fee7d7f79.pdf	upload/groupordering/1752180886_fb07bdb7a3e47b73fa3d.pdf	79	2025-07-10 22:54:46.471724	150000.00	\N
23	7	2024-2025	upload/groupordering/1752180994_a8bcb0663f074ae1ef88.pdf	upload/groupordering/1752180994_5fd127f312b1e5e97967.pdf	upload/groupordering/1752180994_57153f91ca6dd806b073.pdf	upload/groupordering/1752180994_4f983b164a330a8f8a0c.pdf	upload/groupordering/1752180994_1a97bad7f433c1171297.pdf	79	2025-07-10 22:56:34.529485	400000.00	\N
31	1	2023-2024	upload/groupordering/1752187187_4c89ff67c9d44a682111.pdf	upload/groupordering/1752187187_f7bf116f3c3152cd3f60.pdf	upload/groupordering/1752187187_5babf5d40c777eea49fa.pdf	upload/groupordering/1752187187_2dc34268cadad38d6994.pdf	upload/groupordering/1752187187_d88d73c45099b7f0868f.pdf	\N	2025-07-11 00:39:47.222012	90000.00	\N
32	7	2022-2023	upload/groupordering/1752187395_66c62f39284ca17108a1.pdf	upload/groupordering/1752187395_51fb422987f55c7af274.pdf	upload/groupordering/1752187395_be4e073d2827023d59d5.pdf	upload/groupordering/1752187395_2fbd8f15baddc001c670.pdf	upload/groupordering/1752187395_519fa7147dc767ca2c32.pdf	79	2025-07-11 00:43:15.877212	50000.00	\N
33	1	2020-2021	upload/groupordering/1752187900_92a6c75f6add410abedf.pdf	upload/groupordering/1752187900_167fa8e133e61066a340.pdf	upload/groupordering/1752187900_60af3dd896e7eb03c5cb.pdf	upload/groupordering/1752187900_69d4792110a0ab03a58e.pdf	upload/groupordering/1752187900_bcb65d327c607de7b85c.pdf	79	2025-07-11 00:51:40.909618	130340.00	\N
20	5	2025-2026	upload/groupordering/1752171738_da5087e1c4af187b1ffa.pdf	upload/groupordering/1752171738_dc00ca4ae06dc42855ba.pdf	upload/groupordering/1752171738_089aebd2881bf0205279.pdf	upload/groupordering/1752171738_791e604ba7d3db6091a7.pdf	upload/groupordering/1752171738_1e1602daebd7a5caff5a.pdf	333	2025-07-10 20:22:19.049665	510000.00	\N
\.


--
-- Data for Name: tbgroup_members; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.tbgroup_members (group_member_id, group_id, member_id, group_member_status, created_by, created_date) FROM stdin;
1	1	1	Active	79	2025-01-14
2	1	2	Active	79	2025-01-19
3	2	12	Active	79	2025-06-11
4	2	13	Active	79	2025-06-11
5	2	14	Active	79	2025-06-11
6	2	15	Active	79	2025-06-11
7	1	16	Active	79	2025-06-18
8	1	17	Active	\N	2025-07-01
9	3	19	Active	79	2025-07-09
10	4	20	Active	\N	2025-07-09
11	5	21	Active	\N	2025-07-09
12	6	22	Active	\N	2025-07-09
13	7	23	Active	\N	2025-07-09
\.


--
-- Data for Name: tbgroups; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.tbgroups (group_id, group_name, group_region, group_district, group_code, chairperson_first_name, chairperson_middle_name, chairperson_last_name, secretary_first_name, secretary_middle_name, secretary_last_name, treasurer_first_name, treasurer_middle_name, treasurer_last_name, contact_personel_first_name, contact_personel_last_name, contact_personel_phone_number, group_registration_number, group_status, number_of_members, village, ward, certificateofregistration, groupconstitution, signatories, description, created_by, created_date) FROM stdin;
1	UMOJA WA VIJANA	Mbeya	Chunya	Mbe-819	HASSANI	JAMALI	KASANA	HALIMA	MUSSA	JUMA	TAUSI	ALLY	RAMADHANI	SHABANI	087635623	087635623	MBRIU/9983	Active	10	KIJUKI	KEKELO	certificateofregistration_1736888056_6786cef8089e2.pdf	groupconstitution_1736888056_6786cef80964f.pdf	[\\"signatories_1736888056_0_6786cef817d3d.pdf\\"]	new group which perfome well	79	2025-01-14
2	ACHIMENENGULE GROUP	Ruvuma	Mbinga	Ruv371	Greyson	Oscar	Komba	Greyson	Oscar	Komba	Greyson	Oscar	Komba	Greyson	0653521633	0653521633	RUV/MBI/2021-2022	Active	15	Kigonsera	Kigonsera	certificateofregistration_1737374865_678e3c91e0aaa.pdf	groupconstitution_1737374865_678e3c91e4b33.pdf	[\\"signatories_1737374866_0_678e3c920ddd8.pdf\\"]	Achimenengule Wawawaaaa	79	2025-01-20
3	IBESA MAU	Songwe	Momba	Son786	Greyson	Oscar	Komba	Greyson	Oscar	Komba	Greyson	Oscar	Komba	Greyson	0653521633	0653521633	RUV/SMC/2021-2022	Active	15	Kigonsera	Mputa	certificateofregistration_1737375656_678e3fa8a0a3f.pdf	groupconstitution_1737375656_678e3fa8a1e0f.pdf	[\\"signatories_1737375656_0_678e3fa8a25ec.pdf\\"]	IBESA MAU VADADI KUNYWA UGIMBI	79	2025-01-20
4	WAKUMUZI GROUP	Iringa	Iringa	Iri596	Greyson	Oscar	Komba	Greyson	Oscar	Komba	Greyson	Oscar	Komba	Greyson	0653521633	0653521633	RUV/TUN/0004	Active	15	Kigonsera	Mputa	certificateofregistration_1737462497_678f92e1e8d93.docx	groupconstitution_1737462498_678f92e22c7c0.docx	[\\"signatories_1737462498_0_678f92e234e77.docx\\"]	axsio;cdjm;	79	2025-01-21
5	WAKUNYUMBA GROUP	Iringa	Iringa	Iri810	Greyson	Oscar	Komba	Greyson	Oscar	Komba	Greyson	Oscar	Komba	Greyson	0653521633	0653521633	RUV/SMC/2021-2022	Active	12	Kigonsera	Mputa	certificateofregistration_1737463849_678f9829cd193.docx	groupconstitution_1737463849_678f9829d1371.docx	[\\"signatories_1737463849_0_678f9829dbb7c.docx\\"]	ERSYIHGP	79	2025-01-21
6	MAENDELEO YA KILIMO NA UFUGAJI	Ruvuma	Songea	Ruv109	Greyson	Oscar	Komba	Greyson	Oscar	Komba	Greyson	Oscar	Komba	Greyson	0653521633	0653521633	RUV/SMC/2021-2022	Active	14	MPAMBALYOTO	MJINI	certificateofregistration_1737795269_6794a6c512847.pdf	groupconstitution_1737795269_6794a6c513fa5.pdf	[\\"signatories_1737795269_0_6794a6c514b37.pdf\\"]	ABC	STAFF505507	2025-01-25
7	KILIMO NA UFUGAJI	Ruvuma	Songea	Ruv656	Greyson	Oscar	Komba	Greyson	Oscar	Komba	Greyson	Oscar	Komba	Greyson	0653521633	0653521633	RUV/TUN/0004	Active	14	MPAMBALYOTO	MJINI	certificateofregistration_1737909718_679665d6684e8.pdf	groupconstitution_1737909718_679665d6698b3.pdf	[\\"signatories_1737909718_0_679665d66c3ec.pdf\\"]	TRIAL	79	2025-01-26
\.


--
-- Data for Name: tbherbicide; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.tbherbicide (herbicide_id, herbicide_loan_rate, herbicide_name, herbicide_status, herbicide_unit_price, herbicide_code, herbicide_category, created_by, created_date) FROM stdin;
\.


--
-- Data for Name: tbloan; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.tbloan (loan_id, approved_by, approved_date, created_by, created_date, farmer_group_id, farmer_id, given_agri_input_id, given_input_se_fe_he, given_units_kg_little_bag, is_approved, loan_end_date, loan_interest_amount, loan_principle, loan_rate, disbursement_date, loan_status, remained_amount, total_loan, utilized_acres) FROM stdin;
\.


--
-- Data for Name: tbloan_existing; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.tbloan_existing (id, group_id, season_year, utilized_acres, loan_terms, penalty_percent, recovery_commission_percentage, calculation_type, disbursement_date, loan_rate, loan_interest, disbursement_bank, principle_amount, principle_amount_original, outstanding_balance, loan_status, created_by, created_at, is_deleted, deleted_by, deleted_date, is_approved, approved_by, approved_date, rejection_reason) FROM stdin;
23	4	2022-2023	40	12	25	0	flat	2022-12-31	19	19000	3	100000	100000	0	\N	STAFF505507	2025-07-07 20:36:53.167493	NO	\N	\N	YES	79	2025-07-07	\N
25	2	2021-2022	60	10	25	0	flat	2021-12-20	19	31666.666666667	3	200000	200000	0	\N	STAFF505507	2025-07-07 20:40:44.580958	NO	\N	\N	YES	79	2025-07-07	\N
24	1	2022-2023	50	12	24	0	flat	2023-12-31	18	360000	3	2000000	2000000	0	\N	STAFF505507	2025-07-07 20:39:02.308396	NO	\N	\N	YES	79	2025-07-07	\N
\.


--
-- Data for Name: tbloan_existing_product; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.tbloan_existing_product (id, loan_id, product_id, quantity, price, total_amount) FROM stdin;
1	3	34	200.00	50.00	10000.00
2	3	21	100.00	20.00	2000.00
3	4	34	200.00	50.00	10000.00
4	4	21	100.00	20.00	2000.00
5	5	34	200.00	50.00	10000.00
6	5	21	100.00	20.00	2000.00
7	6	34	200.00	50.00	10000.00
8	6	21	100.00	20.00	2000.00
9	7	34	200.00	50.00	10000.00
10	7	21	100.00	20.00	2000.00
11	8	34	200.00	50.00	10000.00
12	8	21	100.00	20.00	2000.00
13	9	34	200.00	50.00	10000.00
14	9	21	100.00	20.00	2000.00
15	10	34	200.00	50.00	10000.00
16	10	21	100.00	20.00	2000.00
17	11	34	200.00	50.00	10000.00
18	11	21	100.00	20.00	2000.00
19	12	34	200.00	50.00	10000.00
20	12	21	100.00	20.00	2000.00
21	13	36	5.00	1000.00	5000.00
22	13	24	5.00	2000.00	10000.00
23	14	19	2000.00	50.00	100000.00
24	14	49	5000.00	10.00	50000.00
25	15	12	4.00	20000.00	80000.00
26	15	1	20.00	3000.00	60000.00
27	15	47	20.00	500.00	10000.00
28	15	11	50.00	2500.00	125000.00
29	16	34	300.00	5000.00	1500000.00
30	16	21	250.00	2000.00	500000.00
31	17	34	2.00	50000.00	100000.00
32	18	34	1.00	100000.00	100000.00
33	19	34	1.00	100000.00	100000.00
34	20	34	2.00	100000.00	200000.00
35	21	34	1.00	100000.00	100000.00
36	22	21	2.00	50000.00	100000.00
37	23	34	1.00	100000.00	100000.00
38	24	34	1.00	2000000.00	2000000.00
39	25	34	1.00	200000.00	200000.00
\.


--
-- Data for Name: tbloan_monthly_details; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.tbloan_monthly_details (id, loan_id, month, opening_balance, amount_repaid_principal, installment, monthly_interest, interest, monthly_repayment, remaining_principal, closing_balance) FROM stdin;
1	1	1	12,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	11,000.00
2	1	2	11,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	10,000.00
3	1	3	10,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	9,000.00
4	1	4	9,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	8,000.00
5	1	5	8,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	7,000.00
6	1	6	7,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	6,000.00
7	1	7	6,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	5,000.00
8	1	8	5,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	4,000.00
9	1	9	4,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	3,000.00
10	1	10	3,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	2,000.00
11	1	11	2,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	1,000.00
12	1	12	1,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	0.00
13	2	1	12,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	11,000.00
14	2	2	11,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	10,000.00
15	2	3	10,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	9,000.00
16	2	4	9,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	8,000.00
17	2	5	8,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	7,000.00
18	2	6	7,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	6,000.00
19	2	7	6,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	5,000.00
20	2	8	5,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	4,000.00
21	2	9	4,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	3,000.00
22	2	10	3,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	2,000.00
23	2	11	2,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	1,000.00
24	2	12	1,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	0.00
25	3	1	12,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	11,000.00
26	3	2	11,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	10,000.00
27	3	3	10,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	9,000.00
28	3	4	9,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	8,000.00
29	3	5	8,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	7,000.00
30	3	6	7,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	6,000.00
31	3	7	6,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	5,000.00
32	3	8	5,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	4,000.00
33	3	9	4,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	3,000.00
34	3	10	3,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	2,000.00
35	3	11	2,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	1,000.00
36	3	12	1,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	0.00
37	4	1	12,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	11,000.00
38	4	2	11,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	10,000.00
39	4	3	10,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	9,000.00
40	4	4	9,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	8,000.00
41	4	5	8,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	7,000.00
42	4	6	7,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	6,000.00
43	4	7	6,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	5,000.00
44	4	8	5,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	4,000.00
45	4	9	4,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	3,000.00
46	4	10	3,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	2,000.00
47	4	11	2,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	1,000.00
48	4	12	1,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	0.00
49	5	1	12,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	11,000.00
50	5	2	11,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	10,000.00
51	5	3	10,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	9,000.00
52	5	4	9,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	8,000.00
53	5	5	8,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	7,000.00
54	5	6	7,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	6,000.00
55	5	7	6,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	5,000.00
56	5	8	5,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	4,000.00
57	5	9	4,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	3,000.00
58	5	10	3,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	2,000.00
59	5	11	2,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	1,000.00
60	5	12	1,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	0.00
61	6	1	12,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	11,000.00
62	6	2	11,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	10,000.00
63	6	3	10,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	9,000.00
64	6	4	9,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	8,000.00
65	6	5	8,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	7,000.00
66	6	6	7,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	6,000.00
67	6	7	6,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	5,000.00
68	6	8	5,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	4,000.00
69	6	9	4,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	3,000.00
70	6	10	3,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	2,000.00
71	6	11	2,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	1,000.00
72	6	12	1,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	0.00
73	7	1	12,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	11,000.00
74	7	2	11,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	10,000.00
75	7	3	10,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	9,000.00
76	7	4	9,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	8,000.00
77	7	5	8,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	7,000.00
78	7	6	7,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	6,000.00
79	7	7	6,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	5,000.00
80	7	8	5,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	4,000.00
81	7	9	4,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	3,000.00
82	7	10	3,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	2,000.00
83	7	11	2,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	1,000.00
84	7	12	1,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	0.00
85	8	1	12,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	11,000.00
86	8	2	11,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	10,000.00
87	8	3	10,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	9,000.00
88	8	4	9,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	8,000.00
89	8	5	8,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	7,000.00
90	8	6	7,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	6,000.00
91	8	7	6,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	5,000.00
92	8	8	5,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	4,000.00
93	8	9	4,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	3,000.00
94	8	10	3,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	2,000.00
95	8	11	2,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	1,000.00
96	8	12	1,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	0.00
97	9	1	12,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	11,000.00
98	9	2	11,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	10,000.00
99	9	3	10,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	9,000.00
100	9	4	9,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	8,000.00
101	9	5	8,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	7,000.00
102	9	6	7,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	6,000.00
103	9	7	6,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	5,000.00
104	9	8	5,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	4,000.00
105	9	9	4,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	3,000.00
106	9	10	3,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	2,000.00
107	9	11	2,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	1,000.00
108	9	12	1,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	0.00
109	10	1	12,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	11,000.00
110	10	2	11,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	10,000.00
111	10	3	10,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	9,000.00
112	10	4	9,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	8,000.00
113	10	5	8,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	7,000.00
114	10	6	7,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	6,000.00
115	10	7	6,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	5,000.00
116	10	8	5,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	4,000.00
117	10	9	4,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	3,000.00
118	10	10	3,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	2,000.00
119	10	11	2,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	1,000.00
120	10	12	1,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	0.00
121	11	1	12,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	11,000.00
122	11	2	11,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	10,000.00
123	11	3	10,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	9,000.00
124	11	4	9,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	8,000.00
125	11	5	8,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	7,000.00
126	11	6	7,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	6,000.00
127	11	7	6,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	5,000.00
128	11	8	5,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	4,000.00
129	11	9	4,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	3,000.00
130	11	10	3,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	2,000.00
131	11	11	2,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	1,000.00
132	11	12	1,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	0.00
133	12	1	12,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	11,000.00
134	12	2	11,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	10,000.00
135	12	3	10,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	9,000.00
136	12	4	9,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	8,000.00
137	12	5	8,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	7,000.00
138	12	6	7,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	6,000.00
139	12	7	6,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	5,000.00
140	12	8	5,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	4,000.00
141	12	9	4,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	3,000.00
142	12	10	3,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	2,000.00
143	12	11	2,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	1,000.00
144	12	12	1,000.00	1,000.00	1,180.00	\N	180.00	\N	\N	0.00
145	13	1	15,000.00	1,250.00	1,500.00	\N	250.00	\N	\N	13,750.00
146	13	2	13,750.00	1,250.00	1,500.00	\N	250.00	\N	\N	12,500.00
147	13	3	12,500.00	1,250.00	1,500.00	\N	250.00	\N	\N	11,250.00
148	13	4	11,250.00	1,250.00	1,500.00	\N	250.00	\N	\N	10,000.00
149	13	5	10,000.00	1,250.00	1,500.00	\N	250.00	\N	\N	8,750.00
150	13	6	8,750.00	1,250.00	1,500.00	\N	250.00	\N	\N	7,500.00
151	13	7	7,500.00	1,250.00	1,500.00	\N	250.00	\N	\N	6,250.00
152	13	8	6,250.00	1,250.00	1,500.00	\N	250.00	\N	\N	5,000.00
153	13	9	5,000.00	1,250.00	1,500.00	\N	250.00	\N	\N	3,750.00
154	13	10	3,750.00	1,250.00	1,500.00	\N	250.00	\N	\N	2,500.00
155	13	11	2,500.00	1,250.00	1,500.00	\N	250.00	\N	\N	1,250.00
156	13	12	1,250.00	1,250.00	1,500.00	\N	250.00	\N	\N	0.00
157	14	1	150,000.00	12,500.00	14,750.00	\N	2,250.00	\N	\N	137,500.00
158	14	2	137,500.00	12,500.00	14,750.00	\N	2,250.00	\N	\N	125,000.00
159	14	3	125,000.00	12,500.00	14,750.00	\N	2,250.00	\N	\N	112,500.00
160	14	4	112,500.00	12,500.00	14,750.00	\N	2,250.00	\N	\N	100,000.00
161	14	5	100,000.00	12,500.00	14,750.00	\N	2,250.00	\N	\N	87,500.00
162	14	6	87,500.00	12,500.00	14,750.00	\N	2,250.00	\N	\N	75,000.00
163	14	7	75,000.00	12,500.00	14,750.00	\N	2,250.00	\N	\N	62,500.00
164	14	8	62,500.00	12,500.00	14,750.00	\N	2,250.00	\N	\N	50,000.00
165	14	9	50,000.00	12,500.00	14,750.00	\N	2,250.00	\N	\N	37,500.00
166	14	10	37,500.00	12,500.00	14,750.00	\N	2,250.00	\N	\N	25,000.00
167	14	11	25,000.00	12,500.00	14,750.00	\N	2,250.00	\N	\N	12,500.00
168	14	12	12,500.00	12,500.00	14,750.00	\N	2,250.00	\N	\N	0.00
169	15	1	275,000.00	22,916.67	27,500.00	\N	4,583.33	\N	\N	252,083.33
170	15	2	252,083.33	22,916.67	27,500.00	\N	4,583.33	\N	\N	229,166.67
171	15	3	229,166.67	22,916.67	27,500.00	\N	4,583.33	\N	\N	206,250.00
172	15	4	206,250.00	22,916.67	27,500.00	\N	4,583.33	\N	\N	183,333.33
173	15	5	183,333.33	22,916.67	27,500.00	\N	4,583.33	\N	\N	160,416.67
174	15	6	160,416.67	22,916.67	27,500.00	\N	4,583.33	\N	\N	137,500.00
175	15	7	137,500.00	22,916.67	27,500.00	\N	4,583.33	\N	\N	114,583.33
176	15	8	114,583.33	22,916.67	27,500.00	\N	4,583.33	\N	\N	91,666.67
177	15	9	91,666.67	22,916.67	27,500.00	\N	4,583.33	\N	\N	68,750.00
178	15	10	68,750.00	22,916.67	27,500.00	\N	4,583.33	\N	\N	45,833.33
179	15	11	45,833.33	22,916.67	27,500.00	\N	4,583.33	\N	\N	22,916.67
180	15	12	22,916.67	22,916.67	27,500.00	\N	4,583.33	\N	\N	0.00
181	16	1	2,000,000.00	166,666.67	196,666.67	\N	30,000.00	\N	\N	1,833,333.33
182	16	2	1,833,333.33	166,666.67	196,666.67	\N	30,000.00	\N	\N	1,666,666.67
183	16	3	1,666,666.67	166,666.67	196,666.67	\N	30,000.00	\N	\N	1,500,000.00
184	16	4	1,500,000.00	166,666.67	196,666.67	\N	30,000.00	\N	\N	1,333,333.33
185	16	5	1,333,333.33	166,666.67	196,666.67	\N	30,000.00	\N	\N	1,166,666.67
186	16	6	1,166,666.67	166,666.67	196,666.67	\N	30,000.00	\N	\N	1,000,000.00
187	16	7	1,000,000.00	166,666.67	196,666.67	\N	30,000.00	\N	\N	833,333.33
188	16	8	833,333.33	166,666.67	196,666.67	\N	30,000.00	\N	\N	666,666.67
189	16	9	666,666.67	166,666.67	196,666.67	\N	30,000.00	\N	\N	500,000.00
190	16	10	500,000.00	166,666.67	196,666.67	\N	30,000.00	\N	\N	333,333.33
191	16	11	333,333.33	166,666.67	196,666.67	\N	30,000.00	\N	\N	166,666.67
192	16	12	166,666.67	166,666.67	196,666.67	\N	30,000.00	\N	\N	0.00
193	17	1	100,000.00	10,000.00	11,583.33	\N	1,583.33	\N	\N	90,000.00
194	17	2	90,000.00	10,000.00	11,583.33	\N	1,583.33	\N	\N	80,000.00
195	17	3	80,000.00	10,000.00	11,583.33	\N	1,583.33	\N	\N	70,000.00
196	17	4	70,000.00	10,000.00	11,583.33	\N	1,583.33	\N	\N	60,000.00
197	17	5	60,000.00	10,000.00	11,583.33	\N	1,583.33	\N	\N	50,000.00
198	17	6	50,000.00	10,000.00	11,583.33	\N	1,583.33	\N	\N	40,000.00
199	17	7	40,000.00	10,000.00	11,583.33	\N	1,583.33	\N	\N	30,000.00
200	17	8	30,000.00	10,000.00	11,583.33	\N	1,583.33	\N	\N	20,000.00
201	17	9	20,000.00	10,000.00	11,583.33	\N	1,583.33	\N	\N	10,000.00
202	17	10	10,000.00	10,000.00	11,583.33	\N	1,583.33	\N	\N	0.00
203	18	1	100,000.00	8,333.33	9,916.67	\N	1,583.33	\N	\N	91,666.67
204	18	2	91,666.67	8,333.33	9,916.67	\N	1,583.33	\N	\N	83,333.33
205	18	3	83,333.33	8,333.33	9,916.67	\N	1,583.33	\N	\N	75,000.00
206	18	4	75,000.00	8,333.33	9,916.67	\N	1,583.33	\N	\N	66,666.67
207	18	5	66,666.67	8,333.33	9,916.67	\N	1,583.33	\N	\N	58,333.33
208	18	6	58,333.33	8,333.33	9,916.67	\N	1,583.33	\N	\N	50,000.00
209	18	7	50,000.00	8,333.33	9,916.67	\N	1,583.33	\N	\N	41,666.67
210	18	8	41,666.67	8,333.33	9,916.67	\N	1,583.33	\N	\N	33,333.33
211	18	9	33,333.33	8,333.33	9,916.67	\N	1,583.33	\N	\N	25,000.00
212	18	10	25,000.00	8,333.33	9,916.67	\N	1,583.33	\N	\N	16,666.67
213	18	11	16,666.67	8,333.33	9,916.67	\N	1,583.33	\N	\N	8,333.33
214	18	12	8,333.33	8,333.33	9,916.67	\N	1,583.33	\N	\N	0.00
215	19	1	100,000.00	8,333.33	9,916.67	\N	1,583.33	\N	\N	91,666.67
216	19	2	91,666.67	8,333.33	9,916.67	\N	1,583.33	\N	\N	83,333.33
217	19	3	83,333.33	8,333.33	9,916.67	\N	1,583.33	\N	\N	75,000.00
218	19	4	75,000.00	8,333.33	9,916.67	\N	1,583.33	\N	\N	66,666.67
219	19	5	66,666.67	8,333.33	9,916.67	\N	1,583.33	\N	\N	58,333.33
220	19	6	58,333.33	8,333.33	9,916.67	\N	1,583.33	\N	\N	50,000.00
221	19	7	50,000.00	8,333.33	9,916.67	\N	1,583.33	\N	\N	41,666.67
222	19	8	41,666.67	8,333.33	9,916.67	\N	1,583.33	\N	\N	33,333.33
223	19	9	33,333.33	8,333.33	9,916.67	\N	1,583.33	\N	\N	25,000.00
224	19	10	25,000.00	8,333.33	9,916.67	\N	1,583.33	\N	\N	16,666.67
225	19	11	16,666.67	8,333.33	9,916.67	\N	1,583.33	\N	\N	8,333.33
226	19	12	8,333.33	8,333.33	9,916.67	\N	1,583.33	\N	\N	0.00
227	20	1	200,000.00	16,666.67	19,833.33	\N	3,166.67	\N	\N	183,333.33
228	20	2	183,333.33	16,666.67	19,833.33	\N	3,166.67	\N	\N	166,666.67
229	20	3	166,666.67	16,666.67	19,833.33	\N	3,166.67	\N	\N	150,000.00
230	20	4	150,000.00	16,666.67	19,833.33	\N	3,166.67	\N	\N	133,333.33
231	20	5	133,333.33	16,666.67	19,833.33	\N	3,166.67	\N	\N	116,666.67
232	20	6	116,666.67	16,666.67	19,833.33	\N	3,166.67	\N	\N	100,000.00
233	20	7	100,000.00	16,666.67	19,833.33	\N	3,166.67	\N	\N	83,333.33
234	20	8	83,333.33	16,666.67	19,833.33	\N	3,166.67	\N	\N	66,666.67
235	20	9	66,666.67	16,666.67	19,833.33	\N	3,166.67	\N	\N	50,000.00
236	20	10	50,000.00	16,666.67	19,833.33	\N	3,166.67	\N	\N	33,333.33
237	20	11	33,333.33	16,666.67	19,833.33	\N	3,166.67	\N	\N	16,666.67
238	20	12	16,666.67	16,666.67	19,833.33	\N	3,166.67	\N	\N	0.00
239	21	1	100,000.00	8,333.33	9,916.67	\N	1,583.33	\N	\N	91,666.67
240	21	2	91,666.67	8,333.33	9,916.67	\N	1,583.33	\N	\N	83,333.33
241	21	3	83,333.33	8,333.33	9,916.67	\N	1,583.33	\N	\N	75,000.00
242	21	4	75,000.00	8,333.33	9,916.67	\N	1,583.33	\N	\N	66,666.67
243	21	5	66,666.67	8,333.33	9,916.67	\N	1,583.33	\N	\N	58,333.33
244	21	6	58,333.33	8,333.33	9,916.67	\N	1,583.33	\N	\N	50,000.00
245	21	7	50,000.00	8,333.33	9,916.67	\N	1,583.33	\N	\N	41,666.67
246	21	8	41,666.67	8,333.33	9,916.67	\N	1,583.33	\N	\N	33,333.33
247	21	9	33,333.33	8,333.33	9,916.67	\N	1,583.33	\N	\N	25,000.00
248	21	10	25,000.00	8,333.33	9,916.67	\N	1,583.33	\N	\N	16,666.67
249	21	11	16,666.67	8,333.33	9,916.67	\N	1,583.33	\N	\N	8,333.33
250	21	12	8,333.33	8,333.33	9,916.67	\N	1,583.33	\N	\N	0.00
251	22	1	100,000.00	8,333.33	9,916.67	\N	1,583.33	\N	\N	91,666.67
252	22	2	91,666.67	8,333.33	9,916.67	\N	1,583.33	\N	\N	83,333.33
253	22	3	83,333.33	8,333.33	9,916.67	\N	1,583.33	\N	\N	75,000.00
254	22	4	75,000.00	8,333.33	9,916.67	\N	1,583.33	\N	\N	66,666.67
255	22	5	66,666.67	8,333.33	9,916.67	\N	1,583.33	\N	\N	58,333.33
256	22	6	58,333.33	8,333.33	9,916.67	\N	1,583.33	\N	\N	50,000.00
257	22	7	50,000.00	8,333.33	9,916.67	\N	1,583.33	\N	\N	41,666.67
258	22	8	41,666.67	8,333.33	9,916.67	\N	1,583.33	\N	\N	33,333.33
259	22	9	33,333.33	8,333.33	9,916.67	\N	1,583.33	\N	\N	25,000.00
260	22	10	25,000.00	8,333.33	9,916.67	\N	1,583.33	\N	\N	16,666.67
261	22	11	16,666.67	8,333.33	9,916.67	\N	1,583.33	\N	\N	8,333.33
262	22	12	8,333.33	8,333.33	9,916.67	\N	1,583.33	\N	\N	0.00
263	23	1	100,000.00	8,333.33	9,916.67	\N	1,583.33	\N	\N	91,666.67
264	23	2	91,666.67	8,333.33	9,916.67	\N	1,583.33	\N	\N	83,333.33
265	23	3	83,333.33	8,333.33	9,916.67	\N	1,583.33	\N	\N	75,000.00
266	23	4	75,000.00	8,333.33	9,916.67	\N	1,583.33	\N	\N	66,666.67
267	23	5	66,666.67	8,333.33	9,916.67	\N	1,583.33	\N	\N	58,333.33
268	23	6	58,333.33	8,333.33	9,916.67	\N	1,583.33	\N	\N	50,000.00
269	23	7	50,000.00	8,333.33	9,916.67	\N	1,583.33	\N	\N	41,666.67
270	23	8	41,666.67	8,333.33	9,916.67	\N	1,583.33	\N	\N	33,333.33
271	23	9	33,333.33	8,333.33	9,916.67	\N	1,583.33	\N	\N	25,000.00
272	23	10	25,000.00	8,333.33	9,916.67	\N	1,583.33	\N	\N	16,666.67
273	23	11	16,666.67	8,333.33	9,916.67	\N	1,583.33	\N	\N	8,333.33
274	23	12	8,333.33	8,333.33	9,916.67	\N	1,583.33	\N	\N	0.00
275	24	1	2,000,000.00	166,666.67	196,666.67	\N	30,000.00	\N	\N	1,833,333.33
276	24	2	1,833,333.33	166,666.67	196,666.67	\N	30,000.00	\N	\N	1,666,666.67
277	24	3	1,666,666.67	166,666.67	196,666.67	\N	30,000.00	\N	\N	1,500,000.00
278	24	4	1,500,000.00	166,666.67	196,666.67	\N	30,000.00	\N	\N	1,333,333.33
279	24	5	1,333,333.33	166,666.67	196,666.67	\N	30,000.00	\N	\N	1,166,666.67
280	24	6	1,166,666.67	166,666.67	196,666.67	\N	30,000.00	\N	\N	1,000,000.00
281	24	7	1,000,000.00	166,666.67	196,666.67	\N	30,000.00	\N	\N	833,333.33
282	24	8	833,333.33	166,666.67	196,666.67	\N	30,000.00	\N	\N	666,666.67
283	24	9	666,666.67	166,666.67	196,666.67	\N	30,000.00	\N	\N	500,000.00
284	24	10	500,000.00	166,666.67	196,666.67	\N	30,000.00	\N	\N	333,333.33
285	24	11	333,333.33	166,666.67	196,666.67	\N	30,000.00	\N	\N	166,666.67
286	24	12	166,666.67	166,666.67	196,666.67	\N	30,000.00	\N	\N	0.00
287	25	1	200,000.00	20,000.00	23,166.67	\N	3,166.67	\N	\N	180,000.00
288	25	2	180,000.00	20,000.00	23,166.67	\N	3,166.67	\N	\N	160,000.00
289	25	3	160,000.00	20,000.00	23,166.67	\N	3,166.67	\N	\N	140,000.00
290	25	4	140,000.00	20,000.00	23,166.67	\N	3,166.67	\N	\N	120,000.00
291	25	5	120,000.00	20,000.00	23,166.67	\N	3,166.67	\N	\N	100,000.00
292	25	6	100,000.00	20,000.00	23,166.67	\N	3,166.67	\N	\N	80,000.00
293	25	7	80,000.00	20,000.00	23,166.67	\N	3,166.67	\N	\N	60,000.00
294	25	8	60,000.00	20,000.00	23,166.67	\N	3,166.67	\N	\N	40,000.00
295	25	9	40,000.00	20,000.00	23,166.67	\N	3,166.67	\N	\N	20,000.00
296	25	10	20,000.00	20,000.00	23,166.67	\N	3,166.67	\N	\N	0.00
297	4	1	33060000	2755000	3306000	\N	551000	\N	\N	30305000
298	4	2	30305000	2755000	3306000	\N	551000	\N	\N	27550000
299	4	3	27550000	2755000	3306000	\N	551000	\N	\N	24795000
300	4	4	24795000	2755000	3306000	\N	551000	\N	\N	22040000
301	4	5	22040000	2755000	3306000	\N	551000	\N	\N	19285000
302	4	6	19285000	2755000	3306000	\N	551000	\N	\N	16530000
303	4	7	16530000	2755000	3306000	\N	551000	\N	\N	13775000
304	4	8	13775000	2755000	3306000	\N	551000	\N	\N	11020000
305	4	9	11020000	2755000	3306000	\N	551000	\N	\N	8265000
306	4	10	8265000	2755000	3306000	\N	551000	\N	\N	5510000
307	4	11	5510000	2755000	3306000	\N	551000	\N	\N	2755000
308	4	12	2755000	2755000	3306000	\N	551000	\N	\N	0
309	5	1	2500000	208333.33333333	250000	\N	41666.666666667	\N	\N	2291666.6666667
310	5	2	2291666.6666667	208333.33333333	250000	\N	41666.666666667	\N	\N	2083333.3333333
311	5	3	2083333.3333333	208333.33333333	250000	\N	41666.666666667	\N	\N	1875000
312	5	4	1875000	208333.33333333	250000	\N	41666.666666667	\N	\N	1666666.6666667
313	5	5	1666666.6666667	208333.33333333	250000	\N	41666.666666667	\N	\N	1458333.3333333
314	5	6	1458333.3333333	208333.33333333	250000	\N	41666.666666667	\N	\N	1250000
315	5	7	1250000	208333.33333333	250000	\N	41666.666666667	\N	\N	1041666.6666667
316	5	8	1041666.6666667	208333.33333333	250000	\N	41666.666666667	\N	\N	833333.33333333
317	5	9	833333.33333333	208333.33333333	250000	\N	41666.666666667	\N	\N	625000
318	5	10	625000	208333.33333333	250000	\N	41666.666666667	\N	\N	416666.66666667
319	5	11	416666.66666667	208333.33333333	250000	\N	41666.666666667	\N	\N	208333.33333333
320	5	12	208333.33333333	208333.33333333	250000	\N	41666.666666667	\N	\N	0
\.


--
-- Data for Name: tbloan_repayment; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.tbloan_repayment (id, loan_id, repayment_date, repayment_amount, new_remaining_balance) FROM stdin;
1	24	2025-01-27	5000000.00	-5000000.00
2	24	2025-01-27	5000000.00	-5000000.00
3	24	2025-01-27	5000000.00	-5000000.00
4	24	2025-01-27	5000000.00	1865271855.29
5	24	2025-01-27	5000000.00	1865271855.29
6	24	2025-01-27	2000000.00	1863621855.29
\.


--
-- Data for Name: tbloanapplicants; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.tbloanapplicants (id, loan_application_id, member_id, acres, group_budget_amount, total_amount) FROM stdin;
6	21	13	3.00	820000.00	2460000.00
7	21	14	3.00	820000.00	2460000.00
8	21	12	3.00	820000.00	2460000.00
9	22	19	10.00	3306000.00	33060000.00
10	24	17	1.00	6000000.00	6000000.00
11	24	18	2.00	6000000.00	12000000.00
12	24	16	1.00	6000000.00	6000000.00
13	25	21	10.00	510000.00	5100000.00
\.


--
-- Data for Name: tbloanapplications; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.tbloanapplications (id, group_id, total_loan_amount, created_by, created_at, status, is_approved, approved_by, approved_date, is_rejected, rejected_by, rejected_date) FROM stdin;
21	2	7380000.00	79	2025-07-09	Pending	NO	\N	\N	\N	\N	\N
22	3	33060000.00	STAFF429439	2025-07-09	Pending	YES	79	2025-07-14	YES	79	2025-07-14
24	1	24000000.00	STAFF505507	2025-07-10	Pending	YES	\N	2025-07-14	\N	\N	\N
25	5	5100000.00	STAFF505507	2025-07-10	disbursed	YES	79	2025-07-15	\N	\N	\N
\.


--
-- Data for Name: tbmanufuctures_varieties; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.tbmanufuctures_varieties (id, name, category, status, created_by, created_date) FROM stdin;
1	dde	Manufucture	Active	79	2025-06-26
2	PPF TR	Variety	Active	79	2025-06-26
\.


--
-- Data for Name: tbmembers; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.tbmembers (member_id, first_name, middle_name, last_name, phone_number, member_status, member_age, filename, nida, group_id, gender, created_date, created_by, acres) FROM stdin;
13	kalunda	mikael	mkami	09874872	Active	18	member_1749681697_684a0621da366.jpg	948924	2	Female	2025-06-11	79	12
14	halima	fadhil	kokuli	2231	Active	21	member_1749682042_684a077a33538.jpg	232	2	Female	2025-06-11	79	28
17	John	Michael	Stones	0653521633	Active	32	member_1751354146_68638b2246139.jpg	197401015730400001-29	1	Male	2025-07-01	\N	20
18	Amiel	Ahsante	Zenda	0789715593	Active	18	member_1751573896_6866e5882b7df.jpg	20250617	1	Male	2025-07-03	STAFF505507	10
12	Hassani	Dickson	Mkwama	44444	Active	18	member_1749681469_684a053d5861f.jpg	1212121	2	Male	2025-06-11	79	9
15	Francis	Shebuge	Zongi	2222	Active	70	sample_pass.jpg	z	2	Male	2025-06-11	79	12
16	Michael	Mushi	Hoza	6	Active	22	member_1750232466_68526d9206d6d.jpg	66	1	Male	2025-06-18	79	12
19	Frank	gabriel	Kiota	087827817	Active	27	member_1752084288_686eaf40aaaab.jpg	9274279382	3	Male	2025-07-09	79	14
20	Shabani	hassani	dede	33324	Active	27	member_1752101004_686ef08cd322f.jpg	4442425	4	Male	2025-07-09	\N	13
21	Belinda	john	Mushi	4536244	Active	23	member_1752101053_686ef0bd3adf8.jpg	55346	5	Female	2025-07-09	\N	12
22	Asnath	Zeno	Mbele	09878764	Active	24	member_1752101131_686ef10b4b062.jpg	435356	6	Female	2025-07-09	\N	14
23	Richard	Yohana	Mavunde	3342525	Active	49	member_1752101269_686ef1951030c.jpg	232455	7	Male	2025-07-09	\N	27
\.


--
-- Data for Name: tbmodules; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.tbmodules (module_id, module_name, module_status, module_date) FROM stdin;
1	Loan	Active	0
2	Leave	Active	0
3	Payroll	Active	0
4	Hr	Active	0
5	Funds Request	Active	0
7	ICT	Active	0
\.


--
-- Data for Name: tbmodules_user; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.tbmodules_user (id, user_id, module_id, is_active) FROM stdin;
1	79	1	Active
2	79	4	Active
3	79	7	Active
25	STAFF505507	1	Active
26	STAFF505507	5	Active
27	STAFF429439	1	Active
28	STAFF56728	1	Active
29	STAFF56728	2	Active
30	STAFF56728	3	Active
31	STAFF56728	4	Active
32	STAFF56728	5	Active
33	STAFF56728	7	Active
\.


--
-- Data for Name: tbproduct_categories; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.tbproduct_categories (product_categorie_id, product_categories_name, product_categories_status, created_date, created_by) FROM stdin;
3	Maize	Active	2024	79
4	Rice	Active	2024	79
9	Soyabean	Active	2024	79
\.


--
-- Data for Name: tbproducts; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.tbproducts (product_id, product_code, product_name, variety_manufacture, product_group, product_unit_price, product_measurement, filename, description, created_by, created_date, product_status) FROM stdin;
1	PRD8001	TEMBO 719		1	800	Kg			79	2024-12-26	Active
2	PRD1599	ZMS 638		1	900	Kg			79	2024-12-26	Active
3	PRD1121	MAGUG34352		1	3000	Kg			79	2024-12-26	Active
4	PRD4965	LUBANGO		1	5500	Kg			79	2024-12-26	Active
7	PRD4176	SA		3	48000	Kg			79	2024-12-27	Active
8	PRD8181	UREA		3	76000	Kg			79	2024-12-27	Active
10	PRD1512	ZAMSEED 606		1	8000	Kg			79	2024-12-27	Active
11	PRD9219	ZAMSEED 638		1	8000	Kg			79	2024-12-27	Active
12	PRD3133	SEEDCO 719		1	8000	Kg			79	2024-12-27	Active
13	PRD7751	SEEDCO 729		1	8000	Kg			79	2024-12-27	Active
14	PRD1674	LUBANGO		1	8000	Kg			79	2024-12-27	Active
15	PRD6798	DK 777		1	8000	Kg			79	2024-12-27	Active
16	PRD7094	DK 90-89		1	8000	Kg			79	2024-12-27	Active
17	PRD8756	TXD 306 SARO 5		1	5000	Kg			79	2024-12-27	Active
19	PRD5020	SA		1	48000	Kg			79	2024-12-28	Active
20	PRD9924	UREA		1	75000	Kg			79	2024-12-28	Active
24	PRD6131	DAP		3	80000	Kg			79	2024-12-28	Active
25	PRD1444	NPK		3	80000	Kg			79	2024-12-28	Active
26	PRD5209	NPS Boron		3	80000	Kg			79	2024-12-28	Active
27	PRD3969	NPS Zinc		3	80000	Kg			79	2024-12-28	Active
28	PRD4999	CEREAL NPK		3	80000	Kg			79	2024-12-28	Active
29	PRD4769	YARAVERA PANDA		3	80000	Kg			79	2024-12-28	Active
30	PRD9211	MICRO TOP NPK		3	80000	Kg			79	2024-12-28	Active
31	PRD9638	SNOWBURNER		5	30000	Lt			79	2024-12-28	Active
32	PRD4300	NICOFORN		5	30000	Lt			79	2024-12-28	Active
33	ITM6654	CEREAL OTESHA (2021-2022)		3	105000	50kg Bag			79	2025-01-13	Active
34	ITM3889	AMIDAS (2021-2022)		3	107000	50kg Bag			79	2025-01-13	Active
35	ITM5628	CEREAL OTESHA 1 (2021-2022)		3	105000	50kg Bag			79	2025-01-13	Active
36	ITM6479	CEREAL OTESHA 2 (2021-2022)		3	108500	50kg Bag			79	2025-01-13	Active
37	ITM3206	YARAMIRA CEREAL		3	105000	50kg Bag			79	2025-01-13	Active
38	ITM6049	YARAMIRA CEREAL		3	108500	50kg Bag			79	2025-01-13	Active
39	ITM4755	YARAVERA AMIDAS		3	107000	50kg Bag			79	2025-01-13	Active
40	ITM7897	YARAMIRA CEREAL 25KGS		3	54500	50kg Bag			79	2025-01-13	Active
41	ITM7769	PIONEER		1	5800	Kg			79	2025-01-13	Active
42	ITM9995	DAWA		5	25000	Lt			79	2025-01-13	Active
43	ITM8940	YARAMIRA CEREAL		3	54500	25kg Bag			79	2025-01-13	Active
48	PRD5762	soya	7	6	6000	Kg	econtract.webp	sddsds	79	2025-04-29	Active
49	PRD1211	SC-719 (TEMBO)	10	1	8000	Kg	amazonmusicussharedidappsforyou_install1	A seed with long term maturity	STAFF429439	2025-05-02	Active
9	PRD2031	po	2	5	6900	Quantity(Qty)	1750941119_3ab45cd34dff6c41a7a2.jpg	opopopo	79	2025-06-26	Active
21	PRD2771	CAN		3	50000	Kg			79	2024-12-28	Active
\.


--
-- Data for Name: tbregions; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.tbregions (region_id, region_name, region_code, region_status) FROM stdin;
\.


--
-- Data for Name: tbrepayment; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.tbrepayment (repayment_id, repaym_date, total_loan_amount, paid_amount, remained_amount, repayment_code, loan_id, is_deleted, group_id, farmer, created_date, created_by) FROM stdin;
\.


--
-- Data for Name: tbrepayment_existing_loan; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.tbrepayment_existing_loan (id, loan_id, repayment_date, amount_paid, years_since_disbursement, penalty_amount, outstanding_principal, total_outstanding_with_penalty, total_outstanding_no_penalty, created_at) FROM stdin;
\.


--
-- Data for Name: tbsalary_scale; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.tbsalary_scale (salary_id_auto, salary_id, salary_name, salary_amount, salary_status, created_by, created_date) FROM stdin;
\.


--
-- Data for Name: tbseeds; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.tbseeds (seeds_id, seeds_name, seeds_category, seeds_code, seeds_loan_rate, seeds_status, seeds_unit_price, created_date, created_by) FROM stdin;
\.


--
-- Data for Name: tbstaffs; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.tbstaffs (id, staff_id, first_name, last_name, email, phone_number, gender, date_of_birth, hire_date, "position", department, salary, status, address, emergency_contact_name, emergency_contact_phone, hire_type, employee_code, national_id, created_at, updated_at) FROM stdin;
1	STAFF925448	SELEMANI	KAJUNA	skajuna@mcode.com	0765454324	Male	2024-11-25	2024-11-18	DES0094792	DEP844772	2	Active	mufindi	JUMA JUMA	078942424	Contract	mcd002	1232412-24124-3424	2024-11-25 21:43:13	2024-11-25 23:35:35
\.


--
-- Data for Name: tbstaffs_old; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.tbstaffs_old (staff_id_auto, staff_id, first_name, middle_name, last_name, staff_post, birth_date, phone_number, staff_status) FROM stdin;
\.


--
-- Data for Name: tbstakeholder; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.tbstakeholder (stakeholder_id, stakeholder_name, stakeholder_group, "postal_box_physical_Address", contact_person_full_names, contact_person_email, contact_person_phonenumber, certificateofregistration, taxclearance, tin, logo, stakeholder_status, created_date_old, created_by, removed_by, postal_box_physical_address, created_date) FROM stdin;
2	CRDB BANK	Financiers(Bank)	76767 DSM	JUMA MWAKALUMIALE	juma@crdb.co.tz	0787675625	certificateofregistration_1750932916_685d1db4754cf.jpg	taxclearance_1750932916_685d1db475b2e.jpg	tin_1750932916_685d1db475ea9.jpg	logo_1750932916_685d1db475ce8.jpg	Active	\N	\N	\N	\N	2025-06-26
3	EQUITY BANK	Financiers(Bank)	6676 dar	Selemani Mwalimu	sele@equity.com	0787651662	certificateofregistration_1750937387_685d2f2b2d30b.jpg	taxclearance_1750937387_685d2f2b2d9b1.jpg	tin_1750937387_685d2f2b2ddc1.jpg	logo_1750937387_685d2f2b2dba0.jpg	Active	\N	\N	\N	\N	2025-06-26
\.


--
-- Data for Name: tbusers; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.tbusers (user_id, first_name, last_name, phone_number, profile, created_by, edit_status, edited_by, edit_approved_by, is_blocked, login_attempts, user_name, password, created_date, status) FROM stdin;
79	shabani	Kaseko	77777	Mkuuwafamilia	113	0	0	0	0	0	admin@mcd.or.tz	$2y$10$7lDQwSDI0ppZo8pz2zLNf.TTzPvqSdyDIwX3XyLRnp2x5/tGmpp6m	2019-09-05	Active
STAFF429439	Slaiton	Kaberege		director	0	0	0	0	0	0	slaiton.kaberege@mcd.or.tz	$2y$10$7lDQwSDI0ppZo8pz2zLNf.TTzPvqSdyDIwX3XyLRnp2x5/tGmpp6m		Active
STAFF505507	Ahsante	Zenda		director	0	0	0	0	0	0	ahsante.zenda@mcd.or.tz	$2y$10$7lDQwSDI0ppZo8pz2zLNf.TTzPvqSdyDIwX3XyLRnp2x5/tGmpp6m		Active
STAFF56728	John	hoevn		officer	0	0	0	0	0	0	johnaugustijnhoeven@gmail.com	$2y$10$7lDQwSDI0ppZo8pz2zLNf.TTzPvqSdyDIwX3XyLRnp2x5/tGmpp6m		Active
STAFF925448	SELEMANI	KAJUNA		Seniorofficer	0	0	0	0	0	0	skajuna@mcode.com	$2y$10$7lDQwSDI0ppZo8pz2zLNf.TTzPvqSdyDIwX3XyLRnp2x5/tGmpp6m		Active
\.


--
-- Data for Name: tbvillages; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.tbvillages (village_id, village_name, village_status, region_id, district_id, ward_id) FROM stdin;
\.


--
-- Data for Name: tbwards; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.tbwards (ward_id, ward_name, ward_status, region_id, district_id) FROM stdin;
\.


--
-- Data for Name: test_data; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.test_data (id, name, email, message) FROM stdin;
1	shabani	shabanimustafa20@gmail.com	test
\.


--
-- Data for Name: user_sessions; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.user_sessions (id, user_id, device_name, "Accessed_module", session_id, ip_address, last_activity) FROM stdin;
1	79	Desktop	Loan	c577f019ef203e1d50b052c906c845a0	197.250.133.80	1749565854
2	79	Desktop	Hr	5c4a14126b5d030508fd177f7bf51e8c	197.250.133.80	1749565901
3	79	Desktop	Loan	d7ba2a6111dd91759b6d21dc4896038a	197.250.133.80	1749566590
4	79	Desktop	Loan	d7ba2a6111dd91759b6d21dc4896038a	197.250.133.80	1749566647
5	79	Desktop	Loan	d7ba2a6111dd91759b6d21dc4896038a	197.250.133.80	1749566710
6	79	Desktop	Loan	f024b3e14c73832c643092c4244e93eb	197.250.133.80	1749566929
7	79	Desktop	Loan	f024b3e14c73832c643092c4244e93eb	197.250.133.80	1749567022
8	79	Desktop	Loan	b276296622ad52a105095f2abfb8fca6	197.250.133.80	1749567347
9	79	Desktop	Loan	b276296622ad52a105095f2abfb8fca6	197.250.133.80	1749567445
10	79	Desktop	Loan	b276296622ad52a105095f2abfb8fca6	197.250.133.80	1749567512
11	79	Desktop	Loan	b276296622ad52a105095f2abfb8fca6	197.250.133.80	1749567538
12	79	Desktop	Loan	550b5e8d0590068bd30abe97133f2941	197.250.133.80	1749567725
13	79	Desktop	Loan	c526e6fb1109aaeb30a8e0b9786d3226	197.250.133.80	1749568316
14	79	Desktop	Loan	c526e6fb1109aaeb30a8e0b9786d3226	197.250.133.80	1749568352
15	79	Desktop	Loan	c526e6fb1109aaeb30a8e0b9786d3226	197.250.133.80	1749568401
16	79	Desktop	Loan	6e2b3a822e085d0812fadcdaba35818c	197.250.133.80	1749569769
17	79	Desktop	Hr	6e2b3a822e085d0812fadcdaba35818c	197.250.133.80	1749569816
18	79	Desktop	Loan	6e2b3a822e085d0812fadcdaba35818c	197.250.133.80	1749569827
19	79	Desktop	Loan	c2f8dbaf9e2b8d8405c5d95e35ff8ec4	197.250.133.80	1749570377
22	79	Desktop	Loan	957c1747e9c8e97de3e342bec0a462f5	197.250.229.209	1749635741
23	79	Desktop	Loan	00dbd9a0662d55e36c40fe4f5d57463d	197.250.229.209	1749662634
28	79	Desktop	Loan	a7540665b0ac02cf94da034536d1b27d	197.250.229.209	1749672781
29	79	Desktop	Loan	c26b1259099cd250a5ef7d88f8d3d662	197.250.199.252	1749675697
31	79	Desktop	Loan	b2dd6f872354aa3a22c265c52aeef637	197.250.199.203	1750232400
32	STAFF429439	Desktop	Loan	cc18716b6b31488e141507748b12cd67	154.74.159.9	1750256834
33	STAFF505507	Mobile Device	Loan	818be368db63d8075b709408383a88c3	196.249.109.113	1750430522
34	STAFF505507	Mobile Device	Loan	818be368db63d8075b709408383a88c3	196.249.109.113	1750430688
35	79	Desktop	Loan	d96b6714be8f21fa7b784f906c0edf14	197.250.134.235	1750714349
36	79	Desktop	Loan	1cd16aba15a7bf50fc21be050a3b73a7	197.250.134.235	1750718972
37	79	Desktop	Loan	f5d0588c9069f3fd04dff311a2df327a	197.250.103.74	1750937727
38	79	Desktop	Loan	f0647f70cab0a82cb084ef8e14443d2f	197.250.204.7	1751280480
39	79	Desktop	Loan	0cc0c57e6b00db21a95c40820c76c91e	51.159.226.155	1751292591
40	79	Desktop	Loan	b406c4b6446a8adb518fa7e6d4f044eb	197.250.130.151	1751394232
41	79	Desktop	Loan	004b8835a5337c14c54c92742a665d54	197.250.130.151	1751398182
42	79	Desktop	Loan	293379e42037712224a60a96ca3c41a6	197.250.130.151	1751398857
43	STAFF429439	Desktop	Loan	e6ca9b61bbdb96493a100a6ef7f27c82	196.249.92.4	1751435579
44	79	Desktop	Loan	abeca7068f30fd18013ee8c109a681b7	197.250.133.236	1751539475
45	STAFF505507	Desktop	Loan	9f9cad37c476c1f80c7dd977c03b809a	169.255.185.170	1751542365
46	79	Desktop	Loan	ab3b4f7ca65e1396b353a963675d1a32	197.250.50.73	1751567569
47	STAFF505507	Desktop	Loan	bcd0ef3f3ea6a4a051619e69605b796f	154.74.158.20	1751567697
48	STAFF505507	Desktop	Loan	3ad2a7ede7bdc7fca0c06ebf6531855d	154.74.158.20	1751570072
49	STAFF505507	Desktop	Loan	1a274a44fb6776d9de683816186e6f09	169.255.184.170	1751627039
50	79	Desktop	Loan	ea1e88bdbacbbc5ac30905ce452d782c	197.250.50.73	1751653891
51	STAFF505507	Desktop	Loan	67d6480ee2e56ae97c0b8c39005acb8d	197.250.199.216	1751743890
52	79	Desktop	Loan	a895c16c3d6e580d75149ff8c4688d16	197.250.50.11	1751744299
53	79	Desktop	Loan	c612ab9d6fd6353ecc4bf7770675c895	197.250.50.11	1751779798
54	79	Desktop	Loan	c612ab9d6fd6353ecc4bf7770675c895	197.250.50.11	1751779813
55	STAFF505507	Desktop	Loan	b88e52293d57ab6b9aff4014e470bdbf	196.249.93.25	1751913283
56	79	Desktop	Loan	9039ccb644009d9e06c4f0547ff21651	197.250.51.218	1751915166
57	79	Desktop	Loan	c92563b7bbd258aab04c18fdcbe5d54b	197.250.51.218	1751983834
58	79	Desktop	Loan	a28444a3dce704c6b42256de3432cade	197.250.100.90	1752065624
59	79	Desktop	Loan	40922f22d8d2eae0661037dbd418dd83	197.250.100.90	1752070466
60	79	Desktop	Loan	0786e903dcd4d98ddd5732983af1c39d	197.250.100.90	1752101522
61	79	Desktop	Loan	b9c0830f6b430bcb66990b4d7b0c8bd9	197.250.100.90	1752171851
62	79	Desktop	Loan	62e0dc24479037f39a3377bb69ff6acc	197.250.134.58	1752187301
63	79	Desktop	Loan	d93cbbd852c94f8ed9d298340cd19164	197.250.134.58	1752188981
64	79	Desktop	Hr	8b749de370fdf1f8da46ef95ac35a3a8	197.250.230.14	1752483134
65	79	Desktop	ICT	8b749de370fdf1f8da46ef95ac35a3a8	197.250.230.14	1752483146
66	79	Desktop	Loan	8b749de370fdf1f8da46ef95ac35a3a8	197.250.230.14	1752483161
67	79	Desktop	Loan	70a0efde4e1236c086ab976dc92f8dfb	197.250.230.14	1752484528
68	79	Desktop	Loan	ce0017fbbecd21da80125996be7a046a	197.250.230.14	1752486207
69	79	Desktop	Loan	1ee87dff70ef412722855779e2290f7c	197.250.230.14	1752571334
\.


--
-- Name: amortization_schedule_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.amortization_schedule_id_seq', 205, true);


--
-- Name: loan_penalties_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.loan_penalties_id_seq', 1, false);


--
-- Name: loan_repayments_existing_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.loan_repayments_existing_id_seq', 1, false);


--
-- Name: loan_repayments_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.loan_repayments_id_seq', 1, false);


--
-- Name: repayment_history_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.repayment_history_id_seq', 125, true);


--
-- Name: repayment_historyxx_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.repayment_historyxx_id_seq', 1, false);


--
-- Name: repayments_repayment_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.repayments_repayment_id_seq', 1, false);


--
-- Name: tbagriitem_agriitem_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.tbagriitem_agriitem_id_seq', 12, true);


--
-- Name: tbaudit_trail_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.tbaudit_trail_id_seq', 88, true);


--
-- Name: tbbranches_branch_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.tbbranches_branch_id_seq', 1, false);


--
-- Name: tbdepartments_department_id_auto_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.tbdepartments_department_id_auto_seq', 1, false);


--
-- Name: tbdesignations_designation_id_auto_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.tbdesignations_designation_id_auto_seq', 1, false);


--
-- Name: tbdisbursements_disb_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.tbdisbursements_disb_id_seq', 5, true);


--
-- Name: tbdistricts_district_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.tbdistricts_district_id_seq', 1, false);


--
-- Name: tbfertilize_fertilizer_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.tbfertilize_fertilizer_id_seq', 1, false);


--
-- Name: tbgroup_bank_accounts_bank_account_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.tbgroup_bank_accounts_bank_account_id_seq', 16, true);


--
-- Name: tbgroup_budget_items_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.tbgroup_budget_items_id_seq', 61, true);


--
-- Name: tbgroup_budgets_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.tbgroup_budgets_id_seq', 33, true);


--
-- Name: tbgroup_members_group_member_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.tbgroup_members_group_member_id_seq', 13, true);


--
-- Name: tbgroups_group_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.tbgroups_group_id_seq', 20, true);


--
-- Name: tbherbicide_herbicide_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.tbherbicide_herbicide_id_seq', 1, false);


--
-- Name: tbloan_existing_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.tbloan_existing_id_seq', 25, true);


--
-- Name: tbloan_existing_product_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.tbloan_existing_product_id_seq', 39, true);


--
-- Name: tbloan_loan_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.tbloan_loan_id_seq', 1, false);


--
-- Name: tbloan_monthly_details_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.tbloan_monthly_details_id_seq', 320, true);


--
-- Name: tbloan_repayment_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.tbloan_repayment_id_seq', 1, false);


--
-- Name: tbloanapplicants_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.tbloanapplicants_id_seq', 13, true);


--
-- Name: tbloanapplications_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.tbloanapplications_id_seq', 25, true);


--
-- Name: tbmanufuctures_varieties_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.tbmanufuctures_varieties_id_seq', 2, true);


--
-- Name: tbmembers_member_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.tbmembers_member_id_seq', 23, true);


--
-- Name: tbmodules_module_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.tbmodules_module_id_seq', 1, false);


--
-- Name: tbmodules_user_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.tbmodules_user_id_seq', 1, false);


--
-- Name: tbproduct_categories_product_categorie_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.tbproduct_categories_product_categorie_id_seq', 1, false);


--
-- Name: tbproducts_product_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.tbproducts_product_id_seq', 52, true);


--
-- Name: tbregions_region_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.tbregions_region_id_seq', 1, false);


--
-- Name: tbrepayment_existing_loan_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.tbrepayment_existing_loan_id_seq', 1, false);


--
-- Name: tbrepayment_repayment_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.tbrepayment_repayment_id_seq', 1, false);


--
-- Name: tbsalary_scale_salary_id_auto_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.tbsalary_scale_salary_id_auto_seq', 1, false);


--
-- Name: tbseeds_seeds_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.tbseeds_seeds_id_seq', 1, false);


--
-- Name: tbstaffs_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.tbstaffs_id_seq', 1, false);


--
-- Name: tbstaffs_old_staff_id_auto_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.tbstaffs_old_staff_id_auto_seq', 1, false);


--
-- Name: tbstakeholder_stakeholder_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.tbstakeholder_stakeholder_id_seq', 3, true);


--
-- Name: tbvillages_village_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.tbvillages_village_id_seq', 1, false);


--
-- Name: tbwards_ward_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.tbwards_ward_id_seq', 1, false);


--
-- Name: test_data_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.test_data_id_seq', 1, true);


--
-- Name: user_sessions_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.user_sessions_id_seq', 69, true);


--
-- Name: amortization_schedule amortization_schedule_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.amortization_schedule
    ADD CONSTRAINT amortization_schedule_pkey PRIMARY KEY (id);


--
-- Name: loan_penalties loan_penalties_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.loan_penalties
    ADD CONSTRAINT loan_penalties_pkey PRIMARY KEY (id);


--
-- Name: loan_repayments_existing loan_repayments_existing_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.loan_repayments_existing
    ADD CONSTRAINT loan_repayments_existing_pkey PRIMARY KEY (id);


--
-- Name: loan_repayments loan_repayments_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.loan_repayments
    ADD CONSTRAINT loan_repayments_pkey PRIMARY KEY (id);


--
-- Name: repayment_history repayment_history_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.repayment_history
    ADD CONSTRAINT repayment_history_pkey PRIMARY KEY (id);


--
-- Name: repayment_historyxx repayment_historyxx_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.repayment_historyxx
    ADD CONSTRAINT repayment_historyxx_pkey PRIMARY KEY (id);


--
-- Name: repayments repayments_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.repayments
    ADD CONSTRAINT repayments_pkey PRIMARY KEY (repayment_id);


--
-- Name: tbagriitem tbagriitem_agriitem_name_key; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbagriitem
    ADD CONSTRAINT tbagriitem_agriitem_name_key UNIQUE (agriitem_name);


--
-- Name: tbagriitem tbagriitem_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbagriitem
    ADD CONSTRAINT tbagriitem_pkey PRIMARY KEY (agriitem_id);


--
-- Name: tbaudit_trail tbaudit_trail_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbaudit_trail
    ADD CONSTRAINT tbaudit_trail_pkey PRIMARY KEY (id);


--
-- Name: tbbranches tbbranches_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbbranches
    ADD CONSTRAINT tbbranches_pkey PRIMARY KEY (branch_id);


--
-- Name: tbdepartments tbdepartments_department_id_auto_key; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbdepartments
    ADD CONSTRAINT tbdepartments_department_id_auto_key UNIQUE (department_id_auto);


--
-- Name: tbdepartments tbdepartments_department_name_key; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbdepartments
    ADD CONSTRAINT tbdepartments_department_name_key UNIQUE (department_name);


--
-- Name: tbdepartments tbdepartments_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbdepartments
    ADD CONSTRAINT tbdepartments_pkey PRIMARY KEY (department_id);


--
-- Name: tbdesignations tbdesignations_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbdesignations
    ADD CONSTRAINT tbdesignations_pkey PRIMARY KEY (designation_id_auto, designation_id);


--
-- Name: tbdisbursements tbdisbursements_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbdisbursements
    ADD CONSTRAINT tbdisbursements_pkey PRIMARY KEY (disb_id);


--
-- Name: tbdistricts tbdistricts_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbdistricts
    ADD CONSTRAINT tbdistricts_pkey PRIMARY KEY (district_id);


--
-- Name: tbfertilize tbfertilize_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbfertilize
    ADD CONSTRAINT tbfertilize_pkey PRIMARY KEY (fertilizer_id);


--
-- Name: tbgroup_bank_accounts tbgroup_bank_accounts_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbgroup_bank_accounts
    ADD CONSTRAINT tbgroup_bank_accounts_pkey PRIMARY KEY (bank_account_id);


--
-- Name: tbgroup_budget_items tbgroup_budget_items_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbgroup_budget_items
    ADD CONSTRAINT tbgroup_budget_items_pkey PRIMARY KEY (id);


--
-- Name: tbgroup_budgets tbgroup_budgets_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbgroup_budgets
    ADD CONSTRAINT tbgroup_budgets_pkey PRIMARY KEY (id);


--
-- Name: tbgroup_members tbgroup_members_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbgroup_members
    ADD CONSTRAINT tbgroup_members_pkey PRIMARY KEY (group_member_id);


--
-- Name: tbgroups tbgroups_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbgroups
    ADD CONSTRAINT tbgroups_pkey PRIMARY KEY (group_id);


--
-- Name: tbherbicide tbherbicide_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbherbicide
    ADD CONSTRAINT tbherbicide_pkey PRIMARY KEY (herbicide_id);


--
-- Name: tbloan_existing tbloan_existing_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbloan_existing
    ADD CONSTRAINT tbloan_existing_pkey PRIMARY KEY (id);


--
-- Name: tbloan_existing_product tbloan_existing_product_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbloan_existing_product
    ADD CONSTRAINT tbloan_existing_product_pkey PRIMARY KEY (id);


--
-- Name: tbloan_monthly_details tbloan_monthly_details_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbloan_monthly_details
    ADD CONSTRAINT tbloan_monthly_details_pkey PRIMARY KEY (id);


--
-- Name: tbloan tbloan_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbloan
    ADD CONSTRAINT tbloan_pkey PRIMARY KEY (loan_id);


--
-- Name: tbloan_repayment tbloan_repayment_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbloan_repayment
    ADD CONSTRAINT tbloan_repayment_pkey PRIMARY KEY (id);


--
-- Name: tbloanapplicants tbloanapplicants_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbloanapplicants
    ADD CONSTRAINT tbloanapplicants_pkey PRIMARY KEY (id);


--
-- Name: tbloanapplications tbloanapplications_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbloanapplications
    ADD CONSTRAINT tbloanapplications_pkey PRIMARY KEY (id);


--
-- Name: tbmanufuctures_varieties tbmanufuctures_varieties_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbmanufuctures_varieties
    ADD CONSTRAINT tbmanufuctures_varieties_pkey PRIMARY KEY (id);


--
-- Name: tbmembers tbmembers_nida_key; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbmembers
    ADD CONSTRAINT tbmembers_nida_key UNIQUE (nida);


--
-- Name: tbmembers tbmembers_phone_number_key; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbmembers
    ADD CONSTRAINT tbmembers_phone_number_key UNIQUE (phone_number);


--
-- Name: tbmembers tbmembers_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbmembers
    ADD CONSTRAINT tbmembers_pkey PRIMARY KEY (member_id);


--
-- Name: tbmodules tbmodules_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbmodules
    ADD CONSTRAINT tbmodules_pkey PRIMARY KEY (module_id);


--
-- Name: tbmodules_user tbmodules_user_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbmodules_user
    ADD CONSTRAINT tbmodules_user_pkey PRIMARY KEY (id);


--
-- Name: tbproduct_categories tbproduct_categories_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbproduct_categories
    ADD CONSTRAINT tbproduct_categories_pkey PRIMARY KEY (product_categorie_id);


--
-- Name: tbproducts tbproducts_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbproducts
    ADD CONSTRAINT tbproducts_pkey PRIMARY KEY (product_id);


--
-- Name: tbregions tbregions_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbregions
    ADD CONSTRAINT tbregions_pkey PRIMARY KEY (region_id);


--
-- Name: tbrepayment_existing_loan tbrepayment_existing_loan_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbrepayment_existing_loan
    ADD CONSTRAINT tbrepayment_existing_loan_pkey PRIMARY KEY (id);


--
-- Name: tbrepayment tbrepayment_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbrepayment
    ADD CONSTRAINT tbrepayment_pkey PRIMARY KEY (repayment_id);


--
-- Name: tbsalary_scale tbsalary_scale_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbsalary_scale
    ADD CONSTRAINT tbsalary_scale_pkey PRIMARY KEY (salary_id_auto);


--
-- Name: tbseeds tbseeds_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbseeds
    ADD CONSTRAINT tbseeds_pkey PRIMARY KEY (seeds_id);


--
-- Name: tbstaffs tbstaffs_email_key; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbstaffs
    ADD CONSTRAINT tbstaffs_email_key UNIQUE (email);


--
-- Name: tbstaffs_old tbstaffs_old_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbstaffs_old
    ADD CONSTRAINT tbstaffs_old_pkey PRIMARY KEY (staff_id_auto);


--
-- Name: tbstaffs_old tbstaffs_old_staff_id_key; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbstaffs_old
    ADD CONSTRAINT tbstaffs_old_staff_id_key UNIQUE (staff_id);


--
-- Name: tbstaffs tbstaffs_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbstaffs
    ADD CONSTRAINT tbstaffs_pkey PRIMARY KEY (id);


--
-- Name: tbstaffs tbstaffs_staff_id_key; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbstaffs
    ADD CONSTRAINT tbstaffs_staff_id_key UNIQUE (staff_id);


--
-- Name: tbstakeholder tbstakeholder_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbstakeholder
    ADD CONSTRAINT tbstakeholder_pkey PRIMARY KEY (stakeholder_id);


--
-- Name: tbusers tbusers_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbusers
    ADD CONSTRAINT tbusers_pkey PRIMARY KEY (user_id);


--
-- Name: tbvillages tbvillages_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbvillages
    ADD CONSTRAINT tbvillages_pkey PRIMARY KEY (village_id);


--
-- Name: tbwards tbwards_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbwards
    ADD CONSTRAINT tbwards_pkey PRIMARY KEY (ward_id);


--
-- Name: test_data test_data_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.test_data
    ADD CONSTRAINT test_data_pkey PRIMARY KEY (id);


--
-- Name: user_sessions user_sessions_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.user_sessions
    ADD CONSTRAINT user_sessions_pkey PRIMARY KEY (id);


--
-- Name: tbgroup_budget_items tbgroup_budget_items_budget_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbgroup_budget_items
    ADD CONSTRAINT tbgroup_budget_items_budget_id_fkey FOREIGN KEY (budget_id) REFERENCES public.tbgroup_budgets(id) ON DELETE CASCADE;


--
-- Name: tbloanapplicants tbloanapplicants_loan_application_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbloanapplicants
    ADD CONSTRAINT tbloanapplicants_loan_application_id_fkey FOREIGN KEY (loan_application_id) REFERENCES public.tbloanapplications(id);


--
-- PostgreSQL database dump complete
--

