--
-- PostgreSQL database dump
--

-- Dumped from database version 17.5
-- Dumped by pg_dump version 17.5

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET transaction_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

SET default_tablespace = '';

SET default_table_access_method = heap;

--
-- Name: amortization_schedule; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.amortization_schedule (
    id integer NOT NULL,
    loan_id integer,
    payment_number integer,
    payment_date date,
    actual_payment_date character varying(50),
    payment_amount numeric(10,2),
    principal numeric(10,2),
    interest numeric(10,2),
    remaining_balance character varying(300),
    paid_amount numeric(10,2) DEFAULT 0.00,
    payment_status character varying(20) DEFAULT 'pending'::character varying,
    late_penalty character varying(30) DEFAULT '0.00'::character varying,
    amount_due character varying(30)
);


ALTER TABLE public.amortization_schedule OWNER TO postgres;

--
-- Name: amortization_schedule_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.amortization_schedule_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.amortization_schedule_id_seq OWNER TO postgres;

--
-- Name: amortization_schedule_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.amortization_schedule_id_seq OWNED BY public.amortization_schedule.id;


--
-- Name: loan_penalties; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.loan_penalties (
    id integer NOT NULL,
    loan_id integer NOT NULL,
    penalty_amount numeric(15,2) NOT NULL,
    penalty_date date NOT NULL,
    created_at timestamp without time zone DEFAULT CURRENT_TIMESTAMP
);


ALTER TABLE public.loan_penalties OWNER TO postgres;

--
-- Name: loan_penalties_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.loan_penalties_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.loan_penalties_id_seq OWNER TO postgres;

--
-- Name: loan_penalties_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.loan_penalties_id_seq OWNED BY public.loan_penalties.id;


--
-- Name: loan_repayments; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.loan_repayments (
    id integer NOT NULL,
    loan_id integer NOT NULL,
    payment_date date NOT NULL,
    principal_amount character varying(30) NOT NULL,
    interest_amount integer NOT NULL,
    repayment_amount character varying(30) NOT NULL,
    late_penalty character varying(30) DEFAULT '0.00'::character varying,
    payment_status character varying(10) DEFAULT 'on_time'::character varying
);


ALTER TABLE public.loan_repayments OWNER TO postgres;

--
-- Name: loan_repayments_existing; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.loan_repayments_existing (
    id integer NOT NULL,
    loan_id integer NOT NULL,
    payment_date date NOT NULL,
    amount_paid numeric(15,2) NOT NULL,
    interest_paid numeric(15,2) NOT NULL,
    principal_paid numeric(15,2) NOT NULL,
    status character varying(10) NOT NULL,
    penalty numeric(15,2) DEFAULT 0.00,
    created_at timestamp without time zone DEFAULT CURRENT_TIMESTAMP
);


ALTER TABLE public.loan_repayments_existing OWNER TO postgres;

--
-- Name: loan_repayments_existing_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.loan_repayments_existing_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.loan_repayments_existing_id_seq OWNER TO postgres;

--
-- Name: loan_repayments_existing_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.loan_repayments_existing_id_seq OWNED BY public.loan_repayments_existing.id;


--
-- Name: loan_repayments_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.loan_repayments_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.loan_repayments_id_seq OWNER TO postgres;

--
-- Name: loan_repayments_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.loan_repayments_id_seq OWNED BY public.loan_repayments.id;


--
-- Name: repayment_history; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.repayment_history (
    id integer NOT NULL,
    loan_id integer NOT NULL,
    payment_date date NOT NULL,
    paid_amount numeric(10,2) NOT NULL,
    interest_paid numeric(10,2) NOT NULL,
    principal_paid numeric(10,2) NOT NULL,
    total_paid_amount numeric(10,2) NOT NULL,
    outstanding_amount numeric(10,2) NOT NULL,
    created_at timestamp without time zone DEFAULT CURRENT_TIMESTAMP,
    updated_at timestamp without time zone DEFAULT CURRENT_TIMESTAMP,
    outstanding_principal numeric(10,2) NOT NULL,
    outstanding_interest numeric(10,2) NOT NULL,
    total_outstanding numeric(10,2) NOT NULL,
    payment_mode character varying(50) NOT NULL,
    produce character varying(60),
    produce_price character varying(60),
    quantity character varying(80),
    penalty_charged numeric(15,2) DEFAULT 0,
    credit_balance numeric(18,2) DEFAULT 0
);


ALTER TABLE public.repayment_history OWNER TO postgres;

--
-- Name: repayment_history_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.repayment_history_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.repayment_history_id_seq OWNER TO postgres;

--
-- Name: repayment_history_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.repayment_history_id_seq OWNED BY public.repayment_history.id;


--
-- Name: repayment_history_new; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.repayment_history_new (
    id integer NOT NULL,
    loan_id integer NOT NULL,
    payment_date date NOT NULL,
    paid_amount numeric(10,2) NOT NULL,
    interest_paid numeric(10,2) NOT NULL,
    principal_paid numeric(10,2) NOT NULL,
    total_paid_amount numeric(10,2) NOT NULL,
    outstanding_amount numeric(10,2) NOT NULL,
    created_at timestamp without time zone DEFAULT CURRENT_TIMESTAMP,
    updated_at timestamp without time zone DEFAULT CURRENT_TIMESTAMP,
    outstanding_principal numeric(10,2) NOT NULL,
    outstanding_interest numeric(10,2) NOT NULL,
    total_outstanding numeric(10,2) NOT NULL,
    payment_mode character varying(50) NOT NULL,
    produce character varying(60),
    produce_price character varying(60),
    quantity character varying(80),
    penalty_charged numeric(15,2) DEFAULT 0,
    credit_balance numeric(18,2) DEFAULT 0
);


ALTER TABLE public.repayment_history_new OWNER TO postgres;

--
-- Name: repayment_history_new_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.repayment_history_new_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.repayment_history_new_id_seq OWNER TO postgres;

--
-- Name: repayment_history_new_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.repayment_history_new_id_seq OWNED BY public.repayment_history_new.id;


--
-- Name: repayment_historyxx; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.repayment_historyxx (
    id integer NOT NULL,
    loan_id integer,
    payment_date character varying(50),
    paid_amount numeric(10,2),
    interest_paid numeric(10,2),
    principal_paid numeric(10,2),
    total_paid numeric(10,2),
    outstanding_balance numeric(10,2)
);


ALTER TABLE public.repayment_historyxx OWNER TO postgres;

--
-- Name: repayment_historyxx_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.repayment_historyxx_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.repayment_historyxx_id_seq OWNER TO postgres;

--
-- Name: repayment_historyxx_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.repayment_historyxx_id_seq OWNED BY public.repayment_historyxx.id;


--
-- Name: repayments; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.repayments (
    repayment_id integer NOT NULL,
    loan_id integer NOT NULL,
    repayment_date date NOT NULL,
    amount_paid numeric(10,2) NOT NULL,
    late_penalty numeric(10,2) DEFAULT 0.00,
    total_paid numeric(10,2) NOT NULL,
    new_balance character varying(50) NOT NULL,
    created_at timestamp without time zone DEFAULT CURRENT_TIMESTAMP
);


ALTER TABLE public.repayments OWNER TO postgres;

--
-- Name: repayments_repayment_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.repayments_repayment_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.repayments_repayment_id_seq OWNER TO postgres;

--
-- Name: repayments_repayment_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.repayments_repayment_id_seq OWNED BY public.repayments.repayment_id;


--
-- Name: tbaggregation; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.tbaggregation (
    aggregation_id integer NOT NULL,
    member_id integer,
    aggregation_date character varying(20),
    crop character varying(20),
    price numeric,
    quantity numeric,
    total_aggregation numeric,
    created_by character varying(100),
    created_date timestamp without time zone DEFAULT CURRENT_TIMESTAMP
);


ALTER TABLE public.tbaggregation OWNER TO postgres;

--
-- Name: tbaggregation_aggregation_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.tbaggregation_aggregation_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.tbaggregation_aggregation_id_seq OWNER TO postgres;

--
-- Name: tbaggregation_aggregation_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.tbaggregation_aggregation_id_seq OWNED BY public.tbaggregation.aggregation_id;


--
-- Name: tbagriitem; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.tbagriitem (
    agriitem_id integer NOT NULL,
    agriitem_name character varying(30) NOT NULL,
    agriitem_group character varying(30),
    created_by character varying(30),
    created_date character varying(30),
    agriitem_status character varying(30) DEFAULT 'Active'::character varying
);


ALTER TABLE public.tbagriitem OWNER TO postgres;

--
-- Name: tbagriitem_agriitem_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.tbagriitem_agriitem_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.tbagriitem_agriitem_id_seq OWNER TO postgres;

--
-- Name: tbagriitem_agriitem_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.tbagriitem_agriitem_id_seq OWNED BY public.tbagriitem.agriitem_id;


--
-- Name: tbaudit_trail; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.tbaudit_trail (
    action character varying(50) NOT NULL,
    activity_date character varying(50) NOT NULL,
    activity_time character varying(50) NOT NULL,
    audit_id character varying(50),
    creator character varying(50),
    description character varying(500),
    ip character varying(50),
    id integer NOT NULL
);


ALTER TABLE public.tbaudit_trail OWNER TO postgres;

--
-- Name: tbaudit_trail_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.tbaudit_trail_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.tbaudit_trail_id_seq OWNER TO postgres;

--
-- Name: tbaudit_trail_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.tbaudit_trail_id_seq OWNED BY public.tbaudit_trail.id;


--
-- Name: tbbranches; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.tbbranches (
    branch_categoty character varying(50) NOT NULL,
    branch_description character varying(50) NOT NULL,
    branch_district character varying(50) NOT NULL,
    branch_id integer NOT NULL,
    branch_name character varying(50) NOT NULL,
    branch_region character varying(50) NOT NULL,
    branch_status character varying(50) DEFAULT 'Active'::character varying,
    branch_ward character varying(50),
    created_by character varying(50),
    created_date character varying(50)
);


ALTER TABLE public.tbbranches OWNER TO postgres;

--
-- Name: tbbranches_branch_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.tbbranches_branch_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.tbbranches_branch_id_seq OWNER TO postgres;

--
-- Name: tbbranches_branch_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.tbbranches_branch_id_seq OWNED BY public.tbbranches.branch_id;


--
-- Name: tbdepartments; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.tbdepartments (
    department_id character varying(20) NOT NULL,
    department_id_auto integer NOT NULL,
    department_name character varying(50) NOT NULL,
    hod character varying(30),
    department_description text,
    department_status character varying(11) DEFAULT 'Active'::character varying NOT NULL,
    created_by character varying(50),
    created_date character varying(50)
);


ALTER TABLE public.tbdepartments OWNER TO postgres;

--
-- Name: tbdepartments_department_id_auto_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.tbdepartments_department_id_auto_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.tbdepartments_department_id_auto_seq OWNER TO postgres;

--
-- Name: tbdepartments_department_id_auto_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.tbdepartments_department_id_auto_seq OWNED BY public.tbdepartments.department_id_auto;


--
-- Name: tbdesignations; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.tbdesignations (
    designation_id character varying(50) NOT NULL,
    designation_id_auto integer NOT NULL,
    designation_name character varying(50),
    designation_description text,
    created_by character varying(50),
    created_date character varying(50),
    designation_status character varying(11) DEFAULT 'Active'::character varying NOT NULL
);


ALTER TABLE public.tbdesignations OWNER TO postgres;

--
-- Name: tbdesignations_designation_id_auto_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.tbdesignations_designation_id_auto_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.tbdesignations_designation_id_auto_seq OWNER TO postgres;

--
-- Name: tbdesignations_designation_id_auto_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.tbdesignations_designation_id_auto_seq OWNED BY public.tbdesignations.designation_id_auto;


--
-- Name: tbdisbursements; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.tbdisbursements (
    disb_id integer NOT NULL,
    group_id integer,
    loan_terms text,
    penalty_percent numeric,
    calculation_type text,
    disbursement_date date,
    loan_rate numeric,
    loan_interest numeric,
    disbursement_bank integer,
    principle_amount numeric,
    principle_amount_original numeric,
    outstanding_balance numeric,
    loan_status character(1),
    created_by character varying(100),
    created_at timestamp without time zone DEFAULT CURRENT_TIMESTAMP,
    is_deleted character(5) DEFAULT 'NO'::bpchar,
    deleted_date timestamp without time zone,
    application_id integer,
    disbursment_slip text,
    is_distributed text DEFAULT 'NO'::text
);


ALTER TABLE public.tbdisbursements OWNER TO postgres;

--
-- Name: tbdisbursements_disb_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.tbdisbursements_disb_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.tbdisbursements_disb_id_seq OWNER TO postgres;

--
-- Name: tbdisbursements_disb_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.tbdisbursements_disb_id_seq OWNED BY public.tbdisbursements.disb_id;


--
-- Name: tbdistribution; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.tbdistribution (
    distrution_id integer NOT NULL,
    group_id integer,
    application_id integer,
    created_by character varying(100),
    created_at timestamp without time zone DEFAULT CURRENT_TIMESTAMP,
    is_deleted character(5) DEFAULT 'NO'::bpchar,
    deleted_date timestamp without time zone,
    guarenteeendorsementletter text,
    grn text,
    deliverynote text,
    budget_id integer,
    disb_id integer,
    orderalteration text
);


ALTER TABLE public.tbdistribution OWNER TO postgres;

--
-- Name: tbdistribution_distrution_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.tbdistribution_distrution_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.tbdistribution_distrution_id_seq OWNER TO postgres;

--
-- Name: tbdistribution_distrution_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.tbdistribution_distrution_id_seq OWNED BY public.tbdistribution.distrution_id;


--
-- Name: tbdistricts; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.tbdistricts (
    district_id integer NOT NULL,
    district_name character varying(50) NOT NULL,
    district_status character varying(50) DEFAULT 'Active'::character varying NOT NULL,
    region_id integer
);


ALTER TABLE public.tbdistricts OWNER TO postgres;

--
-- Name: tbdistricts_district_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.tbdistricts_district_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.tbdistricts_district_id_seq OWNER TO postgres;

--
-- Name: tbdistricts_district_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.tbdistricts_district_id_seq OWNED BY public.tbdistricts.district_id;


--
-- Name: tbfertilize; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.tbfertilize (
    fertilizer_id integer NOT NULL,
    fertilizer_loan_rate character varying(50) NOT NULL,
    fertilizer_name character varying(50) NOT NULL,
    fertilizer_status character varying(50) DEFAULT 'Active'::character varying,
    fertilizer_unit_price character varying(50) NOT NULL,
    created_by character varying(50),
    created_date character varying(50),
    fertilizer_code character varying(50)
);


ALTER TABLE public.tbfertilize OWNER TO postgres;

--
-- Name: tbfertilize_fertilizer_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.tbfertilize_fertilizer_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.tbfertilize_fertilizer_id_seq OWNER TO postgres;

--
-- Name: tbfertilize_fertilizer_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.tbfertilize_fertilizer_id_seq OWNED BY public.tbfertilize.fertilizer_id;


--
-- Name: tbgroup_bank_accounts; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.tbgroup_bank_accounts (
    bank_account_id integer NOT NULL,
    group_id character varying(30),
    group_bank character varying(30),
    group_account_number character varying(30)
);


ALTER TABLE public.tbgroup_bank_accounts OWNER TO postgres;

--
-- Name: tbgroup_bank_accounts_bank_account_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.tbgroup_bank_accounts_bank_account_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.tbgroup_bank_accounts_bank_account_id_seq OWNER TO postgres;

--
-- Name: tbgroup_bank_accounts_bank_account_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.tbgroup_bank_accounts_bank_account_id_seq OWNED BY public.tbgroup_bank_accounts.bank_account_id;


--
-- Name: tbgroup_budget_count; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.tbgroup_budget_count (
    count_id integer NOT NULL,
    group_id integer,
    budget_id integer,
    budget_year character varying(5)
);


ALTER TABLE public.tbgroup_budget_count OWNER TO postgres;

--
-- Name: tbgroup_budget_count_count_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.tbgroup_budget_count_count_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.tbgroup_budget_count_count_id_seq OWNER TO postgres;

--
-- Name: tbgroup_budget_count_count_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.tbgroup_budget_count_count_id_seq OWNED BY public.tbgroup_budget_count.count_id;


--
-- Name: tbgroup_budget_items; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.tbgroup_budget_items (
    id integer NOT NULL,
    budget_id integer NOT NULL,
    product_id integer NOT NULL,
    quantity numeric(10,2) NOT NULL,
    price numeric(10,2) NOT NULL,
    total numeric(10,2) GENERATED ALWAYS AS ((quantity * price)) STORED
);


ALTER TABLE public.tbgroup_budget_items OWNER TO postgres;

--
-- Name: tbgroup_budget_items_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.tbgroup_budget_items_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.tbgroup_budget_items_id_seq OWNER TO postgres;

--
-- Name: tbgroup_budget_items_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.tbgroup_budget_items_id_seq OWNED BY public.tbgroup_budget_items.id;


--
-- Name: tbgroup_budgets; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.tbgroup_budgets (
    id integer NOT NULL,
    group_id integer NOT NULL,
    season_year character varying(20) NOT NULL,
    groupresolution character varying(255),
    groupletter character varying(255),
    inputrequirementform character varying(255),
    applicationleterandresolution character varying(255),
    upfrontcontribution character varying(255),
    created_by character varying(255),
    created_at timestamp without time zone DEFAULT CURRENT_TIMESTAMP,
    budget_amount numeric(12,2) DEFAULT 0.00,
    input_package character varying(30),
    is_utilized text DEFAULT 'NO'::text,
    value_chain integer
);


ALTER TABLE public.tbgroup_budgets OWNER TO postgres;

--
-- Name: tbgroup_budgets_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.tbgroup_budgets_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.tbgroup_budgets_id_seq OWNER TO postgres;

--
-- Name: tbgroup_budgets_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.tbgroup_budgets_id_seq OWNED BY public.tbgroup_budgets.id;


--
-- Name: tbgroup_members; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.tbgroup_members (
    group_member_id integer NOT NULL,
    group_id integer,
    member_id integer,
    group_member_status character varying(10) DEFAULT 'Active'::character varying,
    created_by character varying(100),
    created_date character varying(30)
);


ALTER TABLE public.tbgroup_members OWNER TO postgres;

--
-- Name: tbgroup_members_group_member_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.tbgroup_members_group_member_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.tbgroup_members_group_member_id_seq OWNER TO postgres;

--
-- Name: tbgroup_members_group_member_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.tbgroup_members_group_member_id_seq OWNED BY public.tbgroup_members.group_member_id;


--
-- Name: tbgroups; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.tbgroups (
    group_id integer NOT NULL,
    group_name character varying(50),
    group_region character varying(50),
    group_district character varying(50),
    group_code character varying(100),
    chairperson_first_name character varying(100),
    chairperson_middle_name character varying(100),
    chairperson_last_name character varying(100),
    secretary_first_name character varying(100),
    secretary_middle_name character varying(100),
    secretary_last_name character varying(100),
    treasurer_first_name character varying(100),
    treasurer_middle_name character varying(100),
    treasurer_last_name character varying(100),
    contact_personel_first_name character varying(100),
    contact_personel_last_name character varying(100),
    contact_personel_phone_number character varying(100),
    group_registration_number character varying(500),
    group_status character varying(50) DEFAULT 'Active'::character varying,
    number_of_members character varying(50),
    village character varying(50),
    ward character varying(50),
    certificateofregistration character varying(500),
    groupconstitution character varying(500),
    description text,
    created_by character varying(50),
    created_date character varying(50),
    chairperson_phone_number character varying(12),
    secretary_phone_number character varying(12),
    treasurer_phone_number character varying(12),
    is_contact_personel_chairperson character varying(4),
    is_contact_personel_secretary character varying(4),
    is_contact_personel_treasurer character varying(4),
    lgaletter character varying(500)
);


ALTER TABLE public.tbgroups OWNER TO postgres;

--
-- Name: tbgroups_group_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.tbgroups_group_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.tbgroups_group_id_seq OWNER TO postgres;

--
-- Name: tbgroups_group_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.tbgroups_group_id_seq OWNED BY public.tbgroups.group_id;


--
-- Name: tbherbicide; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.tbherbicide (
    herbicide_id integer NOT NULL,
    herbicide_loan_rate character varying(50),
    herbicide_name character varying(50),
    herbicide_status character varying(50) DEFAULT 'Active'::character varying,
    herbicide_unit_price character varying(50),
    herbicide_code character varying(50),
    herbicide_category character varying(50),
    created_by character varying(50),
    created_date character varying(50)
);


ALTER TABLE public.tbherbicide OWNER TO postgres;

--
-- Name: tbherbicide_herbicide_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.tbherbicide_herbicide_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.tbherbicide_herbicide_id_seq OWNER TO postgres;

--
-- Name: tbherbicide_herbicide_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.tbherbicide_herbicide_id_seq OWNED BY public.tbherbicide.herbicide_id;


--
-- Name: tbloan; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.tbloan (
    loan_id integer NOT NULL,
    approved_by character varying(50),
    approved_date character varying(50),
    created_by character varying(50),
    created_date character varying(50),
    farmer_group_id character varying(50),
    farmer_id character varying(50),
    given_agri_input_id character varying(50),
    given_input_se_fe_he character varying(50),
    given_units_kg_little_bag character varying(50),
    is_approved character varying(50) DEFAULT 'No'::character varying,
    loan_end_date character varying(50),
    loan_interest_amount character varying(50),
    loan_principle character varying(50),
    loan_rate character varying(50),
    disbursement_date character varying(50),
    loan_status character varying(50) DEFAULT 'Active'::character varying,
    remained_amount character varying(50),
    total_loan character varying(50),
    utilized_acres character varying(50)
);


ALTER TABLE public.tbloan OWNER TO postgres;

--
-- Name: tbloan_existing; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.tbloan_existing (
    id integer NOT NULL,
    group_id integer,
    season_year character varying(30),
    utilized_acres character varying(30),
    loan_terms integer,
    penalty_percent character varying(30),
    recovery_commission_percentage character varying(30),
    calculation_type character varying(30),
    disbursement_date character varying(30),
    loan_rate numeric,
    loan_interest character varying(30),
    disbursement_bank integer,
    principle_amount numeric,
    principle_amount_original character varying(50),
    outstanding_balance character varying(30),
    loan_status character varying(30),
    created_by character varying(50),
    created_at timestamp without time zone DEFAULT CURRENT_TIMESTAMP,
    is_deleted character varying(5) DEFAULT 'NO'::character varying,
    deleted_by character varying(5),
    deleted_date character varying(30),
    is_approved character varying(10) DEFAULT 'NO'::character varying,
    approved_by character varying(50),
    approved_date character varying(50),
    rejection_reason text
);


ALTER TABLE public.tbloan_existing OWNER TO postgres;

--
-- Name: tbloan_existing_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.tbloan_existing_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.tbloan_existing_id_seq OWNER TO postgres;

--
-- Name: tbloan_existing_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.tbloan_existing_id_seq OWNED BY public.tbloan_existing.id;


--
-- Name: tbloan_existing_product; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.tbloan_existing_product (
    id integer NOT NULL,
    loan_id character varying(30),
    product_id integer,
    quantity numeric(10,2),
    price numeric(10,2),
    total_amount numeric(15,2)
);


ALTER TABLE public.tbloan_existing_product OWNER TO postgres;

--
-- Name: tbloan_existing_product_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.tbloan_existing_product_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.tbloan_existing_product_id_seq OWNER TO postgres;

--
-- Name: tbloan_existing_product_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.tbloan_existing_product_id_seq OWNED BY public.tbloan_existing_product.id;


--
-- Name: tbloan_loan_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.tbloan_loan_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.tbloan_loan_id_seq OWNER TO postgres;

--
-- Name: tbloan_loan_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.tbloan_loan_id_seq OWNED BY public.tbloan.loan_id;


--
-- Name: tbloan_monthly_details; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.tbloan_monthly_details (
    id integer NOT NULL,
    loan_id integer,
    month integer,
    opening_balance character varying(500),
    amount_repaid_principal character varying(100),
    installment character varying(30),
    monthly_interest numeric(15,2),
    interest character varying(30),
    monthly_repayment numeric(15,2),
    remaining_principal numeric(15,2),
    closing_balance character varying(30)
);


ALTER TABLE public.tbloan_monthly_details OWNER TO postgres;

--
-- Name: tbloan_monthly_details_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.tbloan_monthly_details_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.tbloan_monthly_details_id_seq OWNER TO postgres;

--
-- Name: tbloan_monthly_details_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.tbloan_monthly_details_id_seq OWNED BY public.tbloan_monthly_details.id;


--
-- Name: tbloan_repayment; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.tbloan_repayment (
    id integer NOT NULL,
    loan_id integer,
    repayment_date date,
    repayment_amount numeric(15,2),
    new_remaining_balance numeric(15,2)
);


ALTER TABLE public.tbloan_repayment OWNER TO postgres;

--
-- Name: tbloan_repayment_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.tbloan_repayment_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.tbloan_repayment_id_seq OWNER TO postgres;

--
-- Name: tbloan_repayment_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.tbloan_repayment_id_seq OWNED BY public.tbloan_repayment.id;


--
-- Name: tbloanapplicants; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.tbloanapplicants (
    id integer NOT NULL,
    loan_application_id integer,
    member_id integer NOT NULL,
    acres numeric(6,2),
    group_budget_amount numeric(10,2),
    total_amount numeric(12,2)
);


ALTER TABLE public.tbloanapplicants OWNER TO postgres;

--
-- Name: tbloanapplicants_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.tbloanapplicants_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.tbloanapplicants_id_seq OWNER TO postgres;

--
-- Name: tbloanapplicants_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.tbloanapplicants_id_seq OWNED BY public.tbloanapplicants.id;


--
-- Name: tbloanapplications; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.tbloanapplications (
    id integer NOT NULL,
    group_id integer NOT NULL,
    total_loan_amount numeric(30,2),
    created_by character varying(255),
    created_at date,
    status character varying(50),
    is_approved character varying(30),
    approved_by character varying(20),
    approved_date date,
    is_rejected character varying(10),
    rejected_by character varying(20),
    rejected_date date,
    budget_id integer
);


ALTER TABLE public.tbloanapplications OWNER TO postgres;

--
-- Name: tbloanapplications_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.tbloanapplications_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.tbloanapplications_id_seq OWNER TO postgres;

--
-- Name: tbloanapplications_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.tbloanapplications_id_seq OWNED BY public.tbloanapplications.id;


--
-- Name: tbmanufuctures_varieties; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.tbmanufuctures_varieties (
    id integer NOT NULL,
    name character varying(100),
    category character varying(50),
    status character varying(10) DEFAULT 'Active'::character varying,
    created_by character varying(50),
    created_date character varying(50)
);


ALTER TABLE public.tbmanufuctures_varieties OWNER TO postgres;

--
-- Name: tbmanufuctures_varieties_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.tbmanufuctures_varieties_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.tbmanufuctures_varieties_id_seq OWNER TO postgres;

--
-- Name: tbmanufuctures_varieties_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.tbmanufuctures_varieties_id_seq OWNED BY public.tbmanufuctures_varieties.id;


--
-- Name: tbmembers; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.tbmembers (
    member_id integer NOT NULL,
    first_name character varying(50),
    middle_name character varying(50),
    last_name character varying(50),
    phone_number character varying(50),
    member_status character varying(50) DEFAULT 'Active'::character varying,
    member_age integer,
    filename character varying(500),
    nida character varying(50),
    group_id character varying(30),
    gender character varying(50),
    created_date character varying(50),
    created_by character varying(50),
    acres character varying(50),
    marital_status character varying(20),
    crop_grown integer,
    filenamenida character varying(500),
    animal_kept character varying(50),
    next_of_kin_names character varying(100),
    next_of_kin_phonenumber character varying(50),
    member_bank integer,
    member_bank_acc_number character varying(20)
);


ALTER TABLE public.tbmembers OWNER TO postgres;

--
-- Name: tbmembers_member_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.tbmembers_member_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.tbmembers_member_id_seq OWNER TO postgres;

--
-- Name: tbmembers_member_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.tbmembers_member_id_seq OWNED BY public.tbmembers.member_id;


--
-- Name: tbmodules; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.tbmodules (
    module_id integer NOT NULL,
    module_name character varying(100),
    module_status character varying(30) DEFAULT 'Active'::character varying,
    module_date integer
);


ALTER TABLE public.tbmodules OWNER TO postgres;

--
-- Name: tbmodules_module_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.tbmodules_module_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.tbmodules_module_id_seq OWNER TO postgres;

--
-- Name: tbmodules_module_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.tbmodules_module_id_seq OWNED BY public.tbmodules.module_id;


--
-- Name: tbmodules_user; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.tbmodules_user (
    id integer NOT NULL,
    user_id character varying(50),
    module_id character varying(50),
    is_active character varying(50) DEFAULT 'Active'::character varying
);


ALTER TABLE public.tbmodules_user OWNER TO postgres;

--
-- Name: tbmodules_user_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.tbmodules_user_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.tbmodules_user_id_seq OWNER TO postgres;

--
-- Name: tbmodules_user_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.tbmodules_user_id_seq OWNED BY public.tbmodules_user.id;


--
-- Name: tbproduct_categories; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.tbproduct_categories (
    product_categorie_id integer NOT NULL,
    product_categories_name character varying(50),
    product_categories_status character varying(50) DEFAULT 'Active'::character varying,
    created_date integer,
    created_by integer
);


ALTER TABLE public.tbproduct_categories OWNER TO postgres;

--
-- Name: tbproduct_categories_product_categorie_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.tbproduct_categories_product_categorie_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.tbproduct_categories_product_categorie_id_seq OWNER TO postgres;

--
-- Name: tbproduct_categories_product_categorie_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.tbproduct_categories_product_categorie_id_seq OWNED BY public.tbproduct_categories.product_categorie_id;


--
-- Name: tbproducts; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.tbproducts (
    product_id integer NOT NULL,
    product_code character varying(30),
    product_name character varying(100),
    variety_manufacture character varying(30),
    product_group integer,
    product_unit_price character varying(30),
    product_measurement character varying(30),
    filename character varying(500),
    description text,
    created_by character varying(30),
    created_date character varying(30),
    product_status character varying(10) DEFAULT 'Active'::character varying
);


ALTER TABLE public.tbproducts OWNER TO postgres;

--
-- Name: tbproducts_product_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.tbproducts_product_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.tbproducts_product_id_seq OWNER TO postgres;

--
-- Name: tbproducts_product_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.tbproducts_product_id_seq OWNED BY public.tbproducts.product_id;


--
-- Name: tbregions; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.tbregions (
    region_id integer NOT NULL,
    region_name character varying(50),
    region_code character varying(50),
    region_status character varying(50)
);


ALTER TABLE public.tbregions OWNER TO postgres;

--
-- Name: tbregions_region_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.tbregions_region_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.tbregions_region_id_seq OWNER TO postgres;

--
-- Name: tbregions_region_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.tbregions_region_id_seq OWNED BY public.tbregions.region_id;


--
-- Name: tbrepayment; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.tbrepayment (
    repayment_id integer NOT NULL,
    repaym_date character varying(50),
    total_loan_amount character varying(50),
    paid_amount character varying(50),
    remained_amount character varying(50),
    repayment_code character varying(50),
    loan_id character varying(50),
    is_deleted character varying(50) DEFAULT 'No'::character varying,
    group_id character varying(50),
    farmer character varying(50),
    created_date character varying(50),
    created_by character varying(50)
);


ALTER TABLE public.tbrepayment OWNER TO postgres;

--
-- Name: tbrepayment_existing_loan; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.tbrepayment_existing_loan (
    id integer NOT NULL,
    loan_id integer,
    repayment_date date,
    amount_paid numeric(10,2),
    years_since_disbursement character varying(50),
    penalty_amount character varying(30),
    outstanding_principal character varying(20),
    total_outstanding_with_penalty character varying(30),
    total_outstanding_no_penalty character varying(30),
    created_at timestamp without time zone DEFAULT CURRENT_TIMESTAMP
);


ALTER TABLE public.tbrepayment_existing_loan OWNER TO postgres;

--
-- Name: tbrepayment_existing_loan_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.tbrepayment_existing_loan_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.tbrepayment_existing_loan_id_seq OWNER TO postgres;

--
-- Name: tbrepayment_existing_loan_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.tbrepayment_existing_loan_id_seq OWNED BY public.tbrepayment_existing_loan.id;


--
-- Name: tbrepayment_repayment_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.tbrepayment_repayment_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.tbrepayment_repayment_id_seq OWNER TO postgres;

--
-- Name: tbrepayment_repayment_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.tbrepayment_repayment_id_seq OWNED BY public.tbrepayment.repayment_id;


--
-- Name: tbsalary_scale; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.tbsalary_scale (
    salary_id_auto integer NOT NULL,
    salary_id character varying(50),
    salary_name character varying(100),
    salary_amount character varying(30),
    salary_status character varying(10) DEFAULT 'Active'::character varying,
    created_by character varying(50),
    created_date character varying(50)
);


ALTER TABLE public.tbsalary_scale OWNER TO postgres;

--
-- Name: tbsalary_scale_salary_id_auto_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.tbsalary_scale_salary_id_auto_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.tbsalary_scale_salary_id_auto_seq OWNER TO postgres;

--
-- Name: tbsalary_scale_salary_id_auto_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.tbsalary_scale_salary_id_auto_seq OWNED BY public.tbsalary_scale.salary_id_auto;


--
-- Name: tbseeds; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.tbseeds (
    seeds_id integer NOT NULL,
    seeds_name character varying(50),
    seeds_category character varying(50),
    seeds_code character varying(50),
    seeds_loan_rate character varying(50),
    seeds_status character varying(50) DEFAULT 'Active'::character varying,
    seeds_unit_price character varying(50),
    created_date character varying(50),
    created_by character varying(50)
);


ALTER TABLE public.tbseeds OWNER TO postgres;

--
-- Name: tbseeds_seeds_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.tbseeds_seeds_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.tbseeds_seeds_id_seq OWNER TO postgres;

--
-- Name: tbseeds_seeds_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.tbseeds_seeds_id_seq OWNED BY public.tbseeds.seeds_id;


--
-- Name: tbstaffs; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.tbstaffs (
    id integer NOT NULL,
    staff_id character varying(100),
    first_name character varying(100),
    last_name character varying(100),
    email character varying(255),
    phone_number character varying(20),
    gender character varying(10),
    date_of_birth date,
    hire_date date,
    "position" character varying(100),
    department character varying(100),
    salary character varying(20),
    status character varying(20),
    address text,
    emergency_contact_name character varying(100),
    emergency_contact_phone character varying(20),
    hire_type character varying(20),
    employee_code character varying(50),
    national_id character varying(50),
    created_at timestamp without time zone DEFAULT CURRENT_TIMESTAMP,
    updated_at timestamp without time zone DEFAULT CURRENT_TIMESTAMP
);


ALTER TABLE public.tbstaffs OWNER TO postgres;

--
-- Name: tbstaffs_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.tbstaffs_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.tbstaffs_id_seq OWNER TO postgres;

--
-- Name: tbstaffs_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.tbstaffs_id_seq OWNED BY public.tbstaffs.id;


--
-- Name: tbstaffs_old; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.tbstaffs_old (
    staff_id_auto integer NOT NULL,
    staff_id character varying(100),
    first_name character varying(30),
    middle_name character varying(50),
    last_name character varying(50),
    staff_post character varying(11),
    birth_date character varying(50),
    phone_number character varying(20),
    staff_status character varying(11) DEFAULT 'Active'::character varying
);


ALTER TABLE public.tbstaffs_old OWNER TO postgres;

--
-- Name: tbstaffs_old_staff_id_auto_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.tbstaffs_old_staff_id_auto_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.tbstaffs_old_staff_id_auto_seq OWNER TO postgres;

--
-- Name: tbstaffs_old_staff_id_auto_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.tbstaffs_old_staff_id_auto_seq OWNED BY public.tbstaffs_old.staff_id_auto;


--
-- Name: tbstakeholder; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.tbstakeholder (
    stakeholder_id integer NOT NULL,
    stakeholder_name character varying(50),
    stakeholder_group character varying(30),
    "postal_box_physical_Address" character varying(100),
    contact_person_full_names character varying(100),
    contact_person_email character varying(100),
    contact_person_phonenumber character varying(100),
    certificateofregistration character varying(500),
    taxclearance character varying(500),
    tin character varying(500),
    logo character varying(100),
    stakeholder_status character varying(50) DEFAULT 'Active'::character varying,
    created_date_old integer,
    created_by character varying(100),
    removed_by character varying(30),
    postal_box_physical_address character varying(400),
    created_date date
);


ALTER TABLE public.tbstakeholder OWNER TO postgres;

--
-- Name: tbstakeholder_stakeholder_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.tbstakeholder_stakeholder_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.tbstakeholder_stakeholder_id_seq OWNER TO postgres;

--
-- Name: tbstakeholder_stakeholder_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.tbstakeholder_stakeholder_id_seq OWNED BY public.tbstakeholder.stakeholder_id;


--
-- Name: tbusers; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.tbusers (
    user_id character varying(30) NOT NULL,
    first_name character varying(70),
    last_name character varying(70),
    phone_number character varying(50),
    profile character varying(50),
    created_by character varying(100),
    edit_status integer DEFAULT 0,
    edited_by integer DEFAULT 0,
    edit_approved_by integer DEFAULT 0,
    is_blocked integer DEFAULT 0,
    login_attempts integer DEFAULT 0,
    user_name character varying(70),
    password character varying(500),
    created_date character varying(50),
    status character varying(11) DEFAULT 'Active'::character varying
);


ALTER TABLE public.tbusers OWNER TO postgres;

--
-- Name: tbvillages; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.tbvillages (
    village_id integer NOT NULL,
    village_name character varying(50),
    village_status character varying(50) DEFAULT 'Active'::character varying,
    region_id integer,
    district_id integer,
    ward_id integer
);


ALTER TABLE public.tbvillages OWNER TO postgres;

--
-- Name: tbvillages_village_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.tbvillages_village_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.tbvillages_village_id_seq OWNER TO postgres;

--
-- Name: tbvillages_village_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.tbvillages_village_id_seq OWNED BY public.tbvillages.village_id;


--
-- Name: tbwards; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.tbwards (
    ward_id integer NOT NULL,
    ward_name character varying(50),
    ward_status character varying(50),
    region_id integer,
    district_id integer
);


ALTER TABLE public.tbwards OWNER TO postgres;

--
-- Name: tbwards_ward_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.tbwards_ward_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.tbwards_ward_id_seq OWNER TO postgres;

--
-- Name: tbwards_ward_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.tbwards_ward_id_seq OWNED BY public.tbwards.ward_id;


--
-- Name: test_data; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.test_data (
    id integer NOT NULL,
    name character varying(100),
    email character varying(100),
    message text
);


ALTER TABLE public.test_data OWNER TO postgres;

--
-- Name: test_data_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.test_data_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.test_data_id_seq OWNER TO postgres;

--
-- Name: test_data_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.test_data_id_seq OWNED BY public.test_data.id;


--
-- Name: user_sessions; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.user_sessions (
    id integer NOT NULL,
    user_id character varying(30),
    device_name character varying(500),
    "Accessed_module" character varying(20),
    session_id character varying(255),
    ip_address character varying(45),
    last_activity integer
);


ALTER TABLE public.user_sessions OWNER TO postgres;

--
-- Name: user_sessions_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.user_sessions_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.user_sessions_id_seq OWNER TO postgres;

--
-- Name: user_sessions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.user_sessions_id_seq OWNED BY public.user_sessions.id;


--
-- Name: amortization_schedule id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.amortization_schedule ALTER COLUMN id SET DEFAULT nextval('public.amortization_schedule_id_seq'::regclass);


--
-- Name: loan_penalties id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.loan_penalties ALTER COLUMN id SET DEFAULT nextval('public.loan_penalties_id_seq'::regclass);


--
-- Name: loan_repayments id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.loan_repayments ALTER COLUMN id SET DEFAULT nextval('public.loan_repayments_id_seq'::regclass);


--
-- Name: loan_repayments_existing id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.loan_repayments_existing ALTER COLUMN id SET DEFAULT nextval('public.loan_repayments_existing_id_seq'::regclass);


--
-- Name: repayment_history id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.repayment_history ALTER COLUMN id SET DEFAULT nextval('public.repayment_history_id_seq'::regclass);


--
-- Name: repayment_history_new id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.repayment_history_new ALTER COLUMN id SET DEFAULT nextval('public.repayment_history_new_id_seq'::regclass);


--
-- Name: repayment_historyxx id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.repayment_historyxx ALTER COLUMN id SET DEFAULT nextval('public.repayment_historyxx_id_seq'::regclass);


--
-- Name: repayments repayment_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.repayments ALTER COLUMN repayment_id SET DEFAULT nextval('public.repayments_repayment_id_seq'::regclass);


--
-- Name: tbaggregation aggregation_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbaggregation ALTER COLUMN aggregation_id SET DEFAULT nextval('public.tbaggregation_aggregation_id_seq'::regclass);


--
-- Name: tbagriitem agriitem_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbagriitem ALTER COLUMN agriitem_id SET DEFAULT nextval('public.tbagriitem_agriitem_id_seq'::regclass);


--
-- Name: tbaudit_trail id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbaudit_trail ALTER COLUMN id SET DEFAULT nextval('public.tbaudit_trail_id_seq'::regclass);


--
-- Name: tbbranches branch_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbbranches ALTER COLUMN branch_id SET DEFAULT nextval('public.tbbranches_branch_id_seq'::regclass);


--
-- Name: tbdepartments department_id_auto; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbdepartments ALTER COLUMN department_id_auto SET DEFAULT nextval('public.tbdepartments_department_id_auto_seq'::regclass);


--
-- Name: tbdesignations designation_id_auto; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbdesignations ALTER COLUMN designation_id_auto SET DEFAULT nextval('public.tbdesignations_designation_id_auto_seq'::regclass);


--
-- Name: tbdisbursements disb_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbdisbursements ALTER COLUMN disb_id SET DEFAULT nextval('public.tbdisbursements_disb_id_seq'::regclass);


--
-- Name: tbdistribution distrution_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbdistribution ALTER COLUMN distrution_id SET DEFAULT nextval('public.tbdistribution_distrution_id_seq'::regclass);


--
-- Name: tbdistricts district_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbdistricts ALTER COLUMN district_id SET DEFAULT nextval('public.tbdistricts_district_id_seq'::regclass);


--
-- Name: tbfertilize fertilizer_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbfertilize ALTER COLUMN fertilizer_id SET DEFAULT nextval('public.tbfertilize_fertilizer_id_seq'::regclass);


--
-- Name: tbgroup_bank_accounts bank_account_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbgroup_bank_accounts ALTER COLUMN bank_account_id SET DEFAULT nextval('public.tbgroup_bank_accounts_bank_account_id_seq'::regclass);


--
-- Name: tbgroup_budget_count count_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbgroup_budget_count ALTER COLUMN count_id SET DEFAULT nextval('public.tbgroup_budget_count_count_id_seq'::regclass);


--
-- Name: tbgroup_budget_items id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbgroup_budget_items ALTER COLUMN id SET DEFAULT nextval('public.tbgroup_budget_items_id_seq'::regclass);


--
-- Name: tbgroup_budgets id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbgroup_budgets ALTER COLUMN id SET DEFAULT nextval('public.tbgroup_budgets_id_seq'::regclass);


--
-- Name: tbgroup_members group_member_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbgroup_members ALTER COLUMN group_member_id SET DEFAULT nextval('public.tbgroup_members_group_member_id_seq'::regclass);


--
-- Name: tbgroups group_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbgroups ALTER COLUMN group_id SET DEFAULT nextval('public.tbgroups_group_id_seq'::regclass);


--
-- Name: tbherbicide herbicide_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbherbicide ALTER COLUMN herbicide_id SET DEFAULT nextval('public.tbherbicide_herbicide_id_seq'::regclass);


--
-- Name: tbloan loan_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbloan ALTER COLUMN loan_id SET DEFAULT nextval('public.tbloan_loan_id_seq'::regclass);


--
-- Name: tbloan_existing id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbloan_existing ALTER COLUMN id SET DEFAULT nextval('public.tbloan_existing_id_seq'::regclass);


--
-- Name: tbloan_existing_product id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbloan_existing_product ALTER COLUMN id SET DEFAULT nextval('public.tbloan_existing_product_id_seq'::regclass);


--
-- Name: tbloan_monthly_details id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbloan_monthly_details ALTER COLUMN id SET DEFAULT nextval('public.tbloan_monthly_details_id_seq'::regclass);


--
-- Name: tbloan_repayment id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbloan_repayment ALTER COLUMN id SET DEFAULT nextval('public.tbloan_repayment_id_seq'::regclass);


--
-- Name: tbloanapplicants id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbloanapplicants ALTER COLUMN id SET DEFAULT nextval('public.tbloanapplicants_id_seq'::regclass);


--
-- Name: tbloanapplications id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbloanapplications ALTER COLUMN id SET DEFAULT nextval('public.tbloanapplications_id_seq'::regclass);


--
-- Name: tbmanufuctures_varieties id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbmanufuctures_varieties ALTER COLUMN id SET DEFAULT nextval('public.tbmanufuctures_varieties_id_seq'::regclass);


--
-- Name: tbmembers member_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbmembers ALTER COLUMN member_id SET DEFAULT nextval('public.tbmembers_member_id_seq'::regclass);


--
-- Name: tbmodules module_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbmodules ALTER COLUMN module_id SET DEFAULT nextval('public.tbmodules_module_id_seq'::regclass);


--
-- Name: tbmodules_user id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbmodules_user ALTER COLUMN id SET DEFAULT nextval('public.tbmodules_user_id_seq'::regclass);


--
-- Name: tbproduct_categories product_categorie_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbproduct_categories ALTER COLUMN product_categorie_id SET DEFAULT nextval('public.tbproduct_categories_product_categorie_id_seq'::regclass);


--
-- Name: tbproducts product_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbproducts ALTER COLUMN product_id SET DEFAULT nextval('public.tbproducts_product_id_seq'::regclass);


--
-- Name: tbregions region_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbregions ALTER COLUMN region_id SET DEFAULT nextval('public.tbregions_region_id_seq'::regclass);


--
-- Name: tbrepayment repayment_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbrepayment ALTER COLUMN repayment_id SET DEFAULT nextval('public.tbrepayment_repayment_id_seq'::regclass);


--
-- Name: tbrepayment_existing_loan id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbrepayment_existing_loan ALTER COLUMN id SET DEFAULT nextval('public.tbrepayment_existing_loan_id_seq'::regclass);


--
-- Name: tbsalary_scale salary_id_auto; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbsalary_scale ALTER COLUMN salary_id_auto SET DEFAULT nextval('public.tbsalary_scale_salary_id_auto_seq'::regclass);


--
-- Name: tbseeds seeds_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbseeds ALTER COLUMN seeds_id SET DEFAULT nextval('public.tbseeds_seeds_id_seq'::regclass);


--
-- Name: tbstaffs id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbstaffs ALTER COLUMN id SET DEFAULT nextval('public.tbstaffs_id_seq'::regclass);


--
-- Name: tbstaffs_old staff_id_auto; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbstaffs_old ALTER COLUMN staff_id_auto SET DEFAULT nextval('public.tbstaffs_old_staff_id_auto_seq'::regclass);


--
-- Name: tbstakeholder stakeholder_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbstakeholder ALTER COLUMN stakeholder_id SET DEFAULT nextval('public.tbstakeholder_stakeholder_id_seq'::regclass);


--
-- Name: tbvillages village_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbvillages ALTER COLUMN village_id SET DEFAULT nextval('public.tbvillages_village_id_seq'::regclass);


--
-- Name: tbwards ward_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbwards ALTER COLUMN ward_id SET DEFAULT nextval('public.tbwards_ward_id_seq'::regclass);


--
-- Name: test_data id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.test_data ALTER COLUMN id SET DEFAULT nextval('public.test_data_id_seq'::regclass);


--
-- Name: user_sessions id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.user_sessions ALTER COLUMN id SET DEFAULT nextval('public.user_sessions_id_seq'::regclass);


--
-- Data for Name: amortization_schedule; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.amortization_schedule (id, loan_id, payment_number, payment_date, actual_payment_date, payment_amount, principal, interest, remaining_balance, paid_amount, payment_status, late_penalty, amount_due) FROM stdin;
\.


--
-- Data for Name: loan_penalties; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.loan_penalties (id, loan_id, penalty_amount, penalty_date, created_at) FROM stdin;
\.


--
-- Data for Name: loan_repayments; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.loan_repayments (id, loan_id, payment_date, principal_amount, interest_amount, repayment_amount, late_penalty, payment_status) FROM stdin;
\.


--
-- Data for Name: loan_repayments_existing; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.loan_repayments_existing (id, loan_id, payment_date, amount_paid, interest_paid, principal_paid, status, penalty, created_at) FROM stdin;
\.


--
-- Data for Name: repayment_history; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.repayment_history (id, loan_id, payment_date, paid_amount, interest_paid, principal_paid, total_paid_amount, outstanding_amount, created_at, updated_at, outstanding_principal, outstanding_interest, total_outstanding, payment_mode, produce, produce_price, quantity, penalty_charged, credit_balance) FROM stdin;
\.


--
-- Data for Name: repayment_history_new; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.repayment_history_new (id, loan_id, payment_date, paid_amount, interest_paid, principal_paid, total_paid_amount, outstanding_amount, created_at, updated_at, outstanding_principal, outstanding_interest, total_outstanding, payment_mode, produce, produce_price, quantity, penalty_charged, credit_balance) FROM stdin;
9	12	2025-07-30	1000000.00	443333.33	556666.67	1000000.00	3165000.00	2025-07-30 09:35:14.751089	2025-07-30 09:35:14.751089	2943333.33	221666.67	3165000.00	Cash	\N	\N	\N	0.00	0.00
18	12	2025-07-30	10000.00	0.00	10000.00	10000.00	3155000.00	2025-07-30 20:06:15.109129	2025-07-30 20:06:15.109129	2933333.33	221666.67	3155000.00	Cash	\N	\N	\N	0.00	0.00
19	12	2025-07-30	12000.00	0.00	12000.00	12000.00	3143000.00	2025-07-30 20:06:28.421863	2025-07-30 20:06:28.421863	2921333.33	221666.67	3143000.00	Cash	\N	\N	\N	0.00	0.00
\.


--
-- Data for Name: repayment_historyxx; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.repayment_historyxx (id, loan_id, payment_date, paid_amount, interest_paid, principal_paid, total_paid, outstanding_balance) FROM stdin;
\.


--
-- Data for Name: repayments; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.repayments (repayment_id, loan_id, repayment_date, amount_paid, late_penalty, total_paid, new_balance, created_at) FROM stdin;
\.


--
-- Data for Name: tbaggregation; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.tbaggregation (aggregation_id, member_id, aggregation_date, crop, price, quantity, total_aggregation, created_by, created_date) FROM stdin;
1	29	2025-08-13	7	2000	20	40000	79	2025-08-13 00:35:05.508916
2	29	2025-08-13	7	2000	20	40000	79	2025-08-13 00:35:47.971289
3	29	2025-08-14	14	4500	2	9000	79	2025-08-13 00:37:55.918599
\.


--
-- Data for Name: tbagriitem; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.tbagriitem (agriitem_id, agriitem_name, agriitem_group, created_by, created_date, agriitem_status) FROM stdin;
1	Seeds	Input	79	2024-12-26	Active
3	Fertilizers	Input	79	2024-12-27	Active
4	Boosters	Input	79	2024-12-27	Active
5	Herbicides	Input	79	2024-12-27	Active
6	Maize	Produce	79	2025-01-01	Active
7	Paddy	Produce	79	2025-01-13	Active
8	Soybeans	Produce	79	2025-01-13	Active
9	Tractor	Implements	79	2025-01-19	Active
10	Power Tiller	Implements	79	2025-01-19	Active
14	White Maize	Produce	STAFF505507	2025-04-24	Active
15	we	Implements	79	2025-04-27	Active
2	www	Implements	79	2025-06-26	Active
12	rty	Implements	79	2025-06-26	Active
\.


--
-- Data for Name: tbaudit_trail; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.tbaudit_trail (action, activity_date, activity_time, audit_id, creator, description, ip, id) FROM stdin;
Add Group	2025-06-11	19:12:44	\N	79	Add Group: ee Located at region - Mbeya	197.250.229.209	1
Add Group	2025-06-11	20:54:29	\N	79	Add Group: o Located at region - Iringa	197.250.229.209	2
Add Group	2025-06-11	20:56:55	\N	79	Add Group: p Located at region - Ruvuma	197.250.199.252	3
Add Group	2025-06-11	20:59:22	\N	79	Add Group: Q Located at region - Mbeya	197.250.199.252	4
Add Group	2025-06-11	21:02:20	\N	79	Add Group: W Located at region - Iringa	197.250.199.252	5
Add Group	2025-06-11	21:04:20	\N	79	Add Group: Z Located at region - Mbeya	197.250.199.252	6
Add Group	2025-06-11	21:07:26	\N	79	Add Group: J Located at region - Songwe	197.250.199.252	7
Add Group	2025-06-11	21:27:24	\N	79	Add Group: M Located at region - Ruvuma	197.250.199.252	8
Add Group	2025-06-11	21:38:50	\N	79	Add Group: n Located at region - Mbeya	197.250.199.252	9
Add Group	2025-06-11	21:45:29	\N	79	Add Group: W Located at region - Songwe	197.250.199.252	10
Add Group	2025-06-11	22:04:49	\N	79	Add Group: c Located at region - Njombe	197.250.199.252	11
Add Group	2025-06-11	22:09:03	\N	79	Add Group: a Located at region - Mbeya	197.250.199.252	12
Add Member	2025-06-11	22:37:49	\N	79	Add Member:  in group number - 2	197.250.199.252	13
Add Member	2025-06-11	22:41:37	\N	79	Add Member:  in group number - 2	197.250.199.252	14
Add Member	2025-06-11	22:47:22	\N	79	Add Member:  in group number - 2	197.250.199.252	15
Add Member	2025-06-11	22:53:02	\N	79	Add Member:  in group number - 2	197.250.199.252	16
Add Member	2025-06-18	07:41:06	\N	79	Add Member:  in group number - 1	197.250.199.203	17
Approve Loan	2025-06-23	21:08:15	\N	\N	Approve loan id - 	197.250.134.235	18
Approve Loan	2025-06-23	21:09:29	\N	\N	Approve loan id - 	197.250.134.235	19
Approve Loan	2025-06-23	21:23:16	\N	\N	Approve loan id - 	197.250.134.235	20
Approve Loan	2025-06-23	21:25:02	\N	\N	Approve loan id - 14	197.250.134.235	21
Approve Loan	2025-06-23	21:28:24	\N	\N	Approve loan id - 14	197.250.134.235	22
Approve Loan	2025-06-23	21:29:47	\N	\N	Approve loan id - 14	197.250.134.235	23
Approve Loan	2025-06-23	21:32:46	\N	79	Approve loan id - 14	197.250.134.235	24
Approve Loan	2025-06-23	22:59:30	\N	79	Approve loan id - 15	197.250.134.235	25
Approve Loan	2025-06-24	15:46:02	\N	\N	Approve loan id - 14	197.250.134.235	26
Add Stakeholder	2025-06-26	10:10:03	\N	\N	Add stakeholder named: rr	197.250.103.74	27
Add Stakeholder	2025-06-26	10:15:16	\N	\N	Add stakeholder named: CRDB BANK	197.250.103.74	28
Add Stakeholder	2025-06-26	11:29:47	\N	\N	Add stakeholder named: EQUITY BANK	197.250.103.74	29
Add Agri-item	2025-06-26	11:40:56	\N	79	Add agri item: www	197.250.103.74	30
Add Agri-item	2025-06-26	11:44:38	\N	79	Add agri item: tt	197.250.103.74	31
Add Agri-item	2025-06-26	11:44:50	\N	79	Add agri item: rty	197.250.103.74	32
Add variety or manufacture	2025-06-26	12:10:18	\N	79	Add variety or manufacture named: dde	197.250.103.74	33
Add variety or manufacture	2025-06-26	12:11:10	\N	79	Add variety or manufacture named: PPF TR	197.250.103.74	34
Add Product	2025-06-26	12:29:17	\N	79	Add product named: RRTRY with group id - 3	197.250.103.74	35
Add Product	2025-06-26	12:31:59	\N	79	Add product named: po with group id - 5	197.250.103.74	36
Add Product	2025-06-26	12:37:18	\N	79	Add product named: uu with group id - 8	197.250.103.74	37
Add Product	2025-06-26	12:38:39	\N	79	Add product named: kk with group id - 5	197.250.103.74	38
Add Member	2025-07-01	07:15:46	\N	\N	Add Member:  in group number - 1	51.159.226.155	39
Approve Loan	2025-07-03	10:45:24	\N	79	Approve loan id - 16	197.250.133.236	40
Approve Loan	2025-07-03	11:38:17	\N	79	Approve loan id - 17	197.250.133.236	41
Approve Loan	2025-07-03	19:27:08	\N	79	Approve loan id - 18	197.250.50.73	42
Approve Loan	2025-07-05	19:46:50	\N	79	Approve loan id - 21	197.250.50.11	43
Approve Loan	2025-07-05	19:46:54	\N	STAFF505507	Approve loan id - 20	197.250.199.216	44
Approve Loan	2025-07-07	19:07:08	\N	79	Approve loan id - 23	197.250.51.218	45
Approve Loan	2025-07-07	19:07:16	\N	79	Approve loan id - 24	197.250.51.218	46
Approve Loan	2025-07-07	19:07:22	\N	79	Approve loan id - 25	197.250.51.218	47
Group Ordering Budget	2025-07-07	23:11:58	\N	79	Group budgeting for group id - 1	197.250.51.218	48
Group Ordering Budget	2025-07-07	23:23:26	\N	79	Group budgeting for group id - 3	197.250.51.218	49
Group Ordering Budget	2025-07-07	23:28:25	\N	79	Group budgeting for group id - 2	197.250.51.218	50
Group Ordering Budget	2025-07-07	23:31:27	\N	79	Group budgeting for group id - 3	197.250.51.218	51
Group Ordering Budget	2025-07-07	23:38:07	\N	79	Group budgeting for group id - 3	197.250.51.218	52
Group Ordering Budget	2025-07-07	23:42:26	\N	79	Group budgeting for group id - 5	197.250.51.218	53
Group Ordering Budget	2025-07-08	00:21:31	\N	79	Group budgeting for group id - 1	197.250.51.218	54
Group Ordering Budget	2025-07-08	00:39:16	\N	79	Group budgeting for group id - 2	197.250.51.218	55
Group Ordering Budget	2025-07-08	14:39:36	\N	79	Group budgeting for group id - 1	197.250.51.218	56
Group Ordering Budget	2025-07-08	16:48:51	\N	\N	Group budgeting for group id - 1	197.250.226.213	57
Group Ordering Budget	2025-07-08	22:31:31	\N	\N	Group budgeting for group id - 2	197.250.100.90	58
Approve Loan	2025-07-09	16:09:20	\N	79	Create loan id - 20	197.250.100.90	59
Approve Loan	2025-07-09	16:11:17	\N	79	Create loan id - 21	197.250.100.90	60
Group Ordering Budget	2025-07-09	17:58:45	\N	79	Group budgeting for group id - 3	197.250.100.90	61
Group Ordering Budget	2025-07-09	17:59:10	\N	79	Group budgeting for group id - 3	197.250.100.90	62
Group Ordering Budget	2025-07-09	18:02:17	\N	79	Group budgeting for group id - 3	197.250.100.90	63
Add Member	2025-07-09	18:04:48	\N	79	Add Member:  in group number - 3	197.250.100.90	64
Approve Loan	2025-07-09	18:05:37	\N	79	Create loan id - 22	197.250.100.90	65
Group Ordering Budget	2025-07-09	22:21:44	\N	\N	Group budgeting for group id - 7	197.250.100.90	66
Add Member	2025-07-09	22:43:24	\N	\N	Add Member:  in group number - 4	197.250.100.90	67
Add Member	2025-07-09	22:44:13	\N	\N	Add Member:  in group number - 5	197.250.100.90	68
Add Member	2025-07-09	22:45:31	\N	\N	Add Member:  in group number - 6	197.250.100.90	69
Add Member	2025-07-09	22:47:49	\N	\N	Add Member:  in group number - 7	197.250.100.90	70
Approve Loan	2025-07-10	18:05:08	\N	\N	Create loan id - 24	169.255.185.16	71
Group Ordering Budget	2025-07-10	18:22:18	\N	\N	Group budgeting for group id - 5	169.255.185.16	72
Approve Loan	2025-07-10	18:47:46	\N	\N	Create loan id - 25	169.255.185.16	73
Group Ordering Budget	2025-07-10	20:52:20	\N	79	Group budgeting for group id - 1	197.250.100.90	74
Group Ordering Budget	2025-07-10	20:54:46	\N	79	Group budgeting for group id - 5	197.250.100.90	75
Group Ordering Budget	2025-07-10	20:56:34	\N	79	Group budgeting for group id - 7	197.250.100.90	76
Group Ordering Budget	2025-07-10	22:26:46	\N	\N	Group budgeting for group id - 2	197.250.134.58	77
Group Ordering Budget	2025-07-10	22:33:29	\N	\N	Group budgeting for group id - 1	197.250.134.58	78
Group Ordering Budget	2025-07-10	22:39:47	\N	\N	Group budgeting for group id - 1	197.250.134.58	79
Group Ordering Budget	2025-07-10	22:43:15	\N	79	Group budgeting for group id - 7	197.250.134.58	80
Group Ordering Budget	2025-07-10	22:51:40	\N	79	Group budgeting for group id - 1	197.250.134.58	81
Approve New Loan	2025-07-14	10:24:13	\N	79	Approve New loan id - 22	197.250.230.14	82
Reject New Loan	2025-07-14	10:36:33	\N	79	Reject New loan id - 22	197.250.230.14	83
Approve New Loan	2025-07-14	10:38:34	\N	79	Approve New loan id - 24	197.250.230.14	84
Approve New Loan	2025-07-14	12:19:05	\N	79	Approve New loan id - 22	197.250.230.14	85
Approve New Loan	2025-07-14	19:18:34	\N	\N	Approve New loan id - 24	196.249.99.190	86
Approve New Loan	2025-07-14	19:19:33	\N	\N	Approve New loan id - 25	196.249.99.190	87
Approve New Loan	2025-07-15	10:00:32	\N	79	Approve New loan id - 25	197.250.230.14	88
Approve New Loan	2025-07-15	21:02:24	\N	\N	Approve New loan id - 24	197.250.230.14	89
Create Loan	2025-07-15	21:59:42	\N	\N	Create loan id - 26	197.250.230.14	90
Create Loan	2025-07-15	22:03:29	\N	79	Create loan id - 27	197.250.230.14	91
Create Loan	2025-07-15	22:06:11	\N	79	Create loan id - 28	197.250.230.14	92
Create Loan	2025-07-15	22:09:26	\N	79	Create loan id - 30	197.250.230.14	93
Create Loan	2025-07-15	22:10:40	\N	79	Create loan id - 31	197.250.230.14	94
Approve New Loan	2025-07-15	22:33:22	\N	79	Approve New loan id - 22	197.250.230.14	95
Create Loan	2025-07-16	13:27:17	\N	79	Create loan id - 32	197.250.230.14	96
Create Loan	2025-07-16	13:33:22	\N	79	Create loan id - 33	197.250.230.14	97
Create Loan	2025-07-16	16:16:33	\N	79	Create loan id - 34	197.250.230.14	98
Approve New Loan	2025-07-16	16:17:30	\N	79	Approve New loan id - 34	197.250.230.14	99
Group Input Distribution	2025-07-16	19:37:10	\N	79	Input distribution for group id - 	197.250.230.14	100
Group Ordering Budget	2025-07-16	19:57:31	\N	79	Group budgeting for group id - 1	197.250.230.14	101
Create Loan	2025-07-16	20:03:26	\N	79	Create loan id - 35	197.250.230.14	102
Group Ordering Budget	2025-07-16	20:25:52	\N	79	Group budgeting for group id - 2	197.250.230.14	103
Create Loan	2025-07-16	20:40:20	\N	79	Create loan id - 40	197.250.230.14	104
Approve New Loan	2025-07-16	20:44:58	\N	79	Approve New loan id - 40	197.250.230.14	105
Group Input Distribution	2025-07-16	20:58:53	\N	79	Input distribution for group id - 2	197.250.230.14	106
Group Input Distribution	2025-07-16	21:04:38	\N	79	Input distribution for group id - 2	197.250.230.14	107
Group Ordering Budget	2025-07-16	21:07:12	\N	79	Group budgeting for group id - 3	197.250.230.14	108
Create Loan	2025-07-16	21:07:39	\N	79	Create loan id - 41	197.250.230.14	109
Group Input Distribution	2025-07-16	21:47:51	\N	79	Input distribution for group id - 2	197.250.230.14	110
Approve New Loan	2025-07-17	17:36:11	\N	\N	Approve New loan id - 41	196.249.109.59	111
Group Ordering Budget	2025-07-17	21:43:57	\N	79	Group budgeting for group id - 7	197.250.199.233	112
Group Ordering Budget	2025-07-17	21:44:23	\N	79	Group budgeting for group id - 7	197.250.199.233	113
Group Ordering Budget	2025-07-17	21:44:33	\N	79	Group budgeting for group id - 7	197.250.199.233	114
Group Ordering Budget	2025-07-18	20:02:03	\N	79	Group budgeting for group id - 6	197.250.199.233	115
Add Group	2025-07-25	10:48:08	\N	\N	Add Group: 7 COAL MINING CO. LTD Located at region - Ruvuma	169.255.185.156	116
Add Member	2025-07-25	10:52:16	\N	\N	Add Member:  in group number - 21	169.255.185.156	117
Add Member	2025-07-25	10:54:52	\N	\N	Add Member:  in group number - 21	169.255.185.156	118
Group Ordering Budget	2025-07-25	11:25:06	\N	\N	Group budgeting for group id - 21	169.255.185.156	119
Add Group	2025-07-25	11:29:58	\N	STAFF505507	Add Group: KUTOTOKELA Located at region - Iringa	169.255.185.156	120
Group Ordering Budget	2025-07-28	18:43:00	\N	79	Group budgeting for group id - 22	197.250.131.204	121
Group Ordering Budget	2025-07-28	19:49:19	\N	79	Group budgeting for group id - 1	197.250.131.204	122
Add Group	2025-07-28	21:33:58	\N	79	Add Group: WAUMINI Located at region - Iringa	197.250.131.204	123
Add Member	2025-07-28	21:38:23	\N	79	Add Member:  in group number - 23	197.250.131.204	124
Add Member	2025-07-28	21:51:54	\N	79	Add Member:  in group number - 23	197.250.131.204	125
Group Ordering Budget	2025-07-28	21:58:43	\N	79	Group budgeting for group id - 23	197.250.131.204	126
Create Loan	2025-07-28	22:06:42	\N	79	Create loan id - 42	197.250.131.204	127
Approve New Loan	2025-07-28	22:08:41	\N	79	Approve New loan id - 42	197.250.131.204	128
Add Designation	2025-07-29	19:17:30	\N	79	Add designation named dfdf	197.250.227.32	129
Add Designation	2025-07-29	19:17:50	\N	79	Add designation named ff	197.250.227.32	130
Add Salary Scale	2025-07-29	19:20:32	\N	79	Add Salary Scale named MCODE0090	197.250.227.32	131
Add Department	2025-07-29	19:21:52	\N	79	Add Department named WW with hod id - STAFF925448	197.250.227.32	132
Add Staff	2025-07-29	19:32:09	\N	79	Add Staff named FF with nida id - FFF	197.250.227.32	133
Add Staff	2025-07-30	06:07:19	\N	79	Add Staff named Grey with nida id - 73728282	197.250.199.197	134
Add Group	2025-07-30	06:45:41	\N	STAFF925448x	Add Group: MAPOTO Located at region - Ruvuma	51.159.226.151	135
Group Ordering Budget	2025-07-30	07:01:17	\N	STAFF925448x	Group budgeting for group id - 24	51.159.226.151	136
Create Loan	2025-07-30	07:02:24	\N	STAFF925448x	Create loan id - 43	51.159.226.151	137
Approve New Loan	2025-07-30	07:02:57	\N	79	Approve New loan id - 43	197.250.199.197	138
Group Input Distribution	2025-07-30	07:13:16	\N	STAFF925448x	Input distribution for group id - 24	51.159.226.151	139
Add Member	2025-07-30	11:41:58	\N	79	Add Member:  in group number - 24	197.250.199.197	140
Add Group	2025-07-30	12:32:43	\N	STAFF470835	Add Group: Busara Located at region - Rukwa	197.250.199.197	141
Add Member	2025-07-30	13:45:24	\N	STAFF470835	Add Member:  in group number - 25	197.250.199.197	142
Add Member	2025-07-30	13:56:58	\N	STAFF470835	Add Member:  in group number - 25	197.250.199.197	143
Add Member	2025-07-30	14:09:12	\N	STAFF470835	Add Member:  in group number - 25	197.250.199.197	144
Add Member	2025-07-30	14:10:15	\N	STAFF470835	Add Member:  in group number - 25	197.250.199.197	145
Add Member	2025-07-30	14:15:36	\N	STAFF470835	Add Member:  in group number - 25	197.250.199.197	146
Group Ordering Budget	2025-07-30	18:20:43	\N	\N	Group budgeting for group id - 25	197.250.199.197	147
Create Loan	2025-07-30	18:23:25	\N	STAFF470835	Create loan id - 44	197.250.199.197	148
Approve New Loan	2025-07-30	18:24:13	\N	79	Approve New loan id - 44	197.250.199.197	149
Add Staff	2025-08-04	10:09:56	\N	79	Add Staff named Aloyce with nida id - 82828282828	197.250.100.40	150
Add Group	2025-08-10	09:21:53	\N	STAFF429439	Add Group: Dodoma Swaswa Located at region - Ruvuma	154.74.175.3	151
Group Ordering Budget	2025-08-10	17:39:53	\N	STAFF505507	Group budgeting for group id - 26	196.249.93.215	152
Add Group	2025-08-11	21:53:26	\N	79	Add Group: KASUKU Located at region - Iringa	197.250.132.73	153
Add Member	2025-08-11	23:16:48	\N	79	Add Member:  in group number - 27	197.250.132.73	154
Add Member	2025-08-11	23:21:38	\N	79	Add Member:  in group number - 27	197.250.132.73	155
Add Member	2025-08-11	23:54:15	\N	79	Add Member:  in group number - 27	197.250.132.73	156
Add Member	2025-08-12	00:08:39	\N	79	Add Member:  in group number - 27	197.250.132.73	157
Add Aggregation	2025-08-12	22:35:46	\N	79	Add Aggregation for member id: 29	197.250.131.240	158
Add Aggregation	2025-08-12	22:37:55	\N	79	Add Aggregation for member id: 29	197.250.131.240	159
\.


--
-- Data for Name: tbbranches; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.tbbranches (branch_categoty, branch_description, branch_district, branch_id, branch_name, branch_region, branch_status, branch_ward, created_by, created_date) FROM stdin;
\.


--
-- Data for Name: tbdepartments; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.tbdepartments (department_id, department_id_auto, department_name, hod, department_description, department_status, created_by, created_date) FROM stdin;
DEP222693	6	Human Resources	STAFF429439	 HR Department at MCODE plays a crucial role in attracting, developing, and retaining a high-performing workforce. Key functions include recruitment, onboarding, employee development, compensation & benefits, and employee relations. The department fosters a positive work environment, ensures compliance with labor laws, and maintains accurate employee records. This enables MCODE to build a strong and motivated team to effectively achieve its mission of empowering rural communities in Tanzania	Active	79	2024-12-27
DEP230286	3	Credit	STAFF236983	heck that Firefox has permission to access the web (you might be connected but behind a firewall)	Active	79	2024-10-22
DEP27101	5	Programs	STAFF505507	The Programs Department is the heart of MCODE, driving the organizations mission to empower rural communities in Tanzania. This dynamic department plays a crucial role in:rnrnDeveloping impactful programs: Identifying critical needs in rural communities, conducting thorough needs assessments, and designing innovative and effective development programs.rnSecuring sustainable funding: Writing compelling project proposals and actively pursuing funding opportunities from diverse sources, including donors, foundations, and government agencies.rnEnsuring program success: Overseeing the day-to-day implementation of all programs, providing technical guidance to field staff, and conducting rigorous monitoring and evaluation to track progress and measure impact.rnBuilding strong community partnerships: Fostering active community participation in program design and implementation, addressing community concerns, and ensuring the long-term sustainability of interventions.rnStrengthening capacity: Providing targeted training and capacity building support to community members, local partners, and MCODE staff.rnBy effectively fulfilling these key functions, the Programs Department ensures that MCODEs interventions are impactful, sustainable, and contribute significantly to the development of rural communities in Tanzania.	Active	79	2024-12-27
DEP292871	4	MicroLanding	STAFF925448	kjhsdfklkf shdf jkgdfs	Active	79	2024-11-25
DEP483282	7	Accounting	STAFF505507	Accounting Department at MCODE is essential for the organizations financial health and sustainability. Key functions include:rnrnFinancial Record Keeping: Accurate and timely recording of all financial transactions, including income, expenses, and assets.rnBudgeting & Forecasting: Developing and managing budgets, monitoring expenditures, and preparing financial forecasts.rnPayroll & Accounts Payable/Receivable: Processing salaries, managing supplier invoices, and collecting revenue.rnFinancial Reporting: Preparing financial statements for management, donors, and regulatory authorities.rnInternal Controls: Implementing strong internal controls to safeguard organizational assets and ensure financial integrity.	Active	79	2024-12-27
DEP844772	1	finance	STAFF925448	asdjlhsds dskfjlhksdjf	Active	79	2024-10-22
DEP946684	2	WW	STAFF925448	WW	Active	79	2025-07-29
\.


--
-- Data for Name: tbdesignations; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.tbdesignations (designation_id, designation_id_auto, designation_name, designation_description, created_by, created_date, designation_status) FROM stdin;
DES340354	1	dfdf	dfdfd	79	2025-07-29	Active
DES678018	2	ff	fff	79	2025-07-29	Active
\.


--
-- Data for Name: tbdisbursements; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.tbdisbursements (disb_id, group_id, loan_terms, penalty_percent, calculation_type, disbursement_date, loan_rate, loan_interest, disbursement_bank, principle_amount, principle_amount_original, outstanding_balance, loan_status, created_by, created_at, is_deleted, deleted_date, application_id, disbursment_slip, is_distributed) FROM stdin;
12	24	12	6	flat	2024-12-25	19	665000	3	3500000	3500000	3123000	\N	STAFF925448x	2025-07-30 09:08:49.142622	NO   	\N	43	1753859329_0ecc1a0085682f4f4c64.pdf	YES
\.


--
-- Data for Name: tbdistribution; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.tbdistribution (distrution_id, group_id, application_id, created_by, created_at, is_deleted, deleted_date, guarenteeendorsementletter, grn, deliverynote, budget_id, disb_id, orderalteration) FROM stdin;
5	24	43	STAFF925448x	2025-07-30 09:13:16.870282	NO   	\N	upload/inputdistribution/1753859596_bc906b6d059f5624d85f.pdf	upload/inputdistribution/1753859596_f97c424715be904658c3.pdf	upload/inputdistribution/1753859596_f23f5fbd2241af666cda.pdf	45	12	upload/inputdistribution/1753859596_1483ec9f72dacbdbb868.pdf
\.


--
-- Data for Name: tbdistricts; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.tbdistricts (district_id, district_name, district_status, region_id) FROM stdin;
\.


--
-- Data for Name: tbfertilize; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.tbfertilize (fertilizer_id, fertilizer_loan_rate, fertilizer_name, fertilizer_status, fertilizer_unit_price, created_by, created_date, fertilizer_code) FROM stdin;
\.


--
-- Data for Name: tbgroup_bank_accounts; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.tbgroup_bank_accounts (bank_account_id, group_id, group_bank, group_account_number) FROM stdin;
20	23	2	0009J7824
21	24	3	3000111895699
22	25	2	09898793820
23	26	2	015222368998
24	26	3	01133123897654
25	27	2	0908SD8822
\.


--
-- Data for Name: tbgroup_budget_count; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.tbgroup_budget_count (count_id, group_id, budget_id, budget_year) FROM stdin;
7	24	45	2025
8	25	46	2025
9	26	47	2025
\.


--
-- Data for Name: tbgroup_budget_items; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.tbgroup_budget_items (id, budget_id, product_id, quantity, price) FROM stdin;
91	45	21	1.00	65000.00
92	45	24	1.00	80000.00
93	45	7	1.00	50000.00
94	45	8	1.00	70000.00
95	45	32	1.00	30000.00
96	45	15	10.00	8000.00
97	46	21	4.00	50000.00
98	46	32	1.00	20000.00
99	46	15	10.00	35000.00
\.


--
-- Data for Name: tbgroup_budgets; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.tbgroup_budgets (id, group_id, season_year, groupresolution, groupletter, inputrequirementform, applicationleterandresolution, upfrontcontribution, created_by, created_at, budget_amount, input_package, is_utilized, value_chain) FROM stdin;
44	23	2024-2025	upload/groupordering/1753739923_fa8145157bd9da26d730.pdf	upload/groupordering/1753739923_6906b84052356a4438d6.pdf	upload/groupordering/1753739923_25338f944fcd62f3b99f.pdf	upload/groupordering/1753739923_4867adea98d3d99643dc.pdf	upload/groupordering/1753739923_cdfc4c40dde6fef44b7b.pdf	79	2025-07-28 23:58:43.951399	758000.00	Normal	YES	6
45	24	2024-2025	upload/groupordering/1753858877_f45343a856be286e1bef.pdf	upload/groupordering/1753858877_666a920085e9e724c7c7.pdf	upload/groupordering/1753858877_8c426ac2919b2c443666.pdf	upload/groupordering/1753858877_c7c18a3474b4a57c28db.pdf	upload/groupordering/1753858877_29dda944129c374356b1.pdf	STAFF925448x	2025-07-30 09:01:17.663496	375000.00	Advanced	YES	6
46	25	2024-2025	upload/groupordering/1753899643_a689c1f140c686d3ddc5.pdf	upload/groupordering/1753899643_1889fc197d6952ad4476.pdf	upload/groupordering/1753899643_1857fd490b9823ab1ed0.pdf	upload/groupordering/1753899643_5cb82e7be042c5717ee5.pdf	upload/groupordering/1753899643_f7ba9f18ea851f6bbec1.pdf	\N	2025-07-30 20:20:44.076953	570000.00	Advanced	YES	6
\.


--
-- Data for Name: tbgroup_members; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.tbgroup_members (group_member_id, group_id, member_id, group_member_status, created_by, created_date) FROM stdin;
16	23	27	Active	79	2025-07-28
17	23	28	Active	79	2025-07-28
18	24	31	Active	79	2025-07-30
19	24	29	Active	STAFF925448x	2025-07-30
20	25	34	Active	STAFF470835	2025-07-30
21	25	35	Active	STAFF470835	2025-07-30
22	25	36	Active	STAFF470835	2025-07-30
23	25	37	Active	STAFF470835	2025-07-30
24	25	38	Active	STAFF470835	2025-07-30
25	27	39	Active	79	2025-08-11
26	27	40	Active	79	2025-08-11
27	27	42	Active	79	2025-08-11
28	27	43	Active	79	2025-08-12
\.


--
-- Data for Name: tbgroups; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.tbgroups (group_id, group_name, group_region, group_district, group_code, chairperson_first_name, chairperson_middle_name, chairperson_last_name, secretary_first_name, secretary_middle_name, secretary_last_name, treasurer_first_name, treasurer_middle_name, treasurer_last_name, contact_personel_first_name, contact_personel_last_name, contact_personel_phone_number, group_registration_number, group_status, number_of_members, village, ward, certificateofregistration, groupconstitution, description, created_by, created_date, chairperson_phone_number, secretary_phone_number, treasurer_phone_number, is_contact_personel_chairperson, is_contact_personel_secretary, is_contact_personel_treasurer, lgaletter) FROM stdin;
24	MAPOTO	Ruvuma	Mbinga	Ruv-854	Greyson	Oscar	Komba	Johnson	Oscar	Komba	James	Oscar	Komba	Greyson	Komba	0653521633	RUV/NAM/2021-2022	Active	8	Semeni	Mputa	certificateofregistration_1753857940_6889bf94e565c.pdf	groupconstitution_1753857941_6889bf9502bf7.pdf	M/Kiti ana uelewa mkubwa wa Mradi	STAFF925448x	2025-07-30	\N	\N	\N	\N	\N	\N	\N
25	Busara	Rukwa	Nkasi	Ruk-766	cc	cc	cc	cc	cc	cc	dd	dd	dd	ee	ee	09876767	uyiuyw983	Active	10	kwangwa	Nkasi chini	certificateofregistration_1753878763_688a10ebe1258.pdf	groupconstitution_1753878763_688a10ebe18a1.pdf	dfsjskf dfsjfhksdf ksjdfsfkjsf kjhdfkfjskf ksjdfskjfhskf skfslhksdfhskfhksjf	STAFF470835	2025-07-30	\N	\N	\N	\N	\N	\N	\N
26	Dodoma Swaswa	Ruvuma	Songea Urban	Ruv-987	Slaiton	Godfrey	Kaberege	Ahsante	Menas	Zenda	Aloyce	Julius	Mbilinyi	Slaiton	Kaberege	0717380874	CBO 123	Active	24	Ruhuwiko Shuleni	Ruhuwiko	certificateofregistration_1754817713_689864b1497b4.pdf	groupconstitution_1754817713_689864b153752.pdf	The group office is near the village catholic church on the northside	STAFF429439	2025-08-10	\N	\N	\N	\N	\N	\N	\N
27	KASUKU	Iringa	Iringa Urban	Iri-442	AA	BB	CC	CC	DD	EE	FF	GG	HH	\N	\N	\N	WEWE2323	Active	11	IKUKI	HOZA	certificateofregistration_1754949206_689a665691ec7.pdf	groupconstitution_1754949206_689a66569c798.pdf	ASDAD	79	2025-08-11	07123663	098987787787	0787261	Yes	No	No	\N
\.


--
-- Data for Name: tbherbicide; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.tbherbicide (herbicide_id, herbicide_loan_rate, herbicide_name, herbicide_status, herbicide_unit_price, herbicide_code, herbicide_category, created_by, created_date) FROM stdin;
\.


--
-- Data for Name: tbloan; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.tbloan (loan_id, approved_by, approved_date, created_by, created_date, farmer_group_id, farmer_id, given_agri_input_id, given_input_se_fe_he, given_units_kg_little_bag, is_approved, loan_end_date, loan_interest_amount, loan_principle, loan_rate, disbursement_date, loan_status, remained_amount, total_loan, utilized_acres) FROM stdin;
\.


--
-- Data for Name: tbloan_existing; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.tbloan_existing (id, group_id, season_year, utilized_acres, loan_terms, penalty_percent, recovery_commission_percentage, calculation_type, disbursement_date, loan_rate, loan_interest, disbursement_bank, principle_amount, principle_amount_original, outstanding_balance, loan_status, created_by, created_at, is_deleted, deleted_by, deleted_date, is_approved, approved_by, approved_date, rejection_reason) FROM stdin;
\.


--
-- Data for Name: tbloan_existing_product; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.tbloan_existing_product (id, loan_id, product_id, quantity, price, total_amount) FROM stdin;
\.


--
-- Data for Name: tbloan_monthly_details; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.tbloan_monthly_details (id, loan_id, month, opening_balance, amount_repaid_principal, installment, monthly_interest, interest, monthly_repayment, remaining_principal, closing_balance) FROM stdin;
389	12	1	3500000	291666.66666667	347083.33333333	\N	55416.666666667	\N	\N	3208333.3333333
390	12	2	3208333.3333333	291666.66666667	347083.33333333	\N	55416.666666667	\N	\N	2916666.6666667
391	12	3	2916666.6666667	291666.66666667	347083.33333333	\N	55416.666666667	\N	\N	2625000
392	12	4	2625000	291666.66666667	347083.33333333	\N	55416.666666667	\N	\N	2333333.3333333
393	12	5	2333333.3333333	291666.66666667	347083.33333333	\N	55416.666666667	\N	\N	2041666.6666667
394	12	6	2041666.6666667	291666.66666667	347083.33333333	\N	55416.666666667	\N	\N	1750000
395	12	7	1750000	291666.66666667	347083.33333333	\N	55416.666666667	\N	\N	1458333.3333333
396	12	8	1458333.3333333	291666.66666667	347083.33333333	\N	55416.666666667	\N	\N	1166666.6666667
397	12	9	1166666.6666667	291666.66666667	347083.33333333	\N	55416.666666667	\N	\N	875000
398	12	10	875000	291666.66666667	347083.33333333	\N	55416.666666667	\N	\N	583333.33333333
399	12	11	583333.33333333	291666.66666667	347083.33333333	\N	55416.666666667	\N	\N	291666.66666667
400	12	12	291666.66666667	291666.66666667	347083.33333333	\N	55416.666666667	\N	\N	0
\.


--
-- Data for Name: tbloan_repayment; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.tbloan_repayment (id, loan_id, repayment_date, repayment_amount, new_remaining_balance) FROM stdin;
\.


--
-- Data for Name: tbloanapplicants; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.tbloanapplicants (id, loan_application_id, member_id, acres, group_budget_amount, total_amount) FROM stdin;
37	43	29	10.00	375000.00	3750000.00
38	44	35	20.00	570000.00	11400000.00
39	44	36	15.00	570000.00	8550000.00
40	44	37	10.00	570000.00	5700000.00
41	44	38	5.00	570000.00	2850000.00
\.


--
-- Data for Name: tbloanapplications; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.tbloanapplications (id, group_id, total_loan_amount, created_by, created_at, status, is_approved, approved_by, approved_date, is_rejected, rejected_by, rejected_date, budget_id) FROM stdin;
43	24	3750000.00	STAFF925448x	2025-07-30	disbursed	YES	79	2025-07-30	\N	\N	\N	45
44	25	28500000.00	STAFF470835	2025-07-30	approved for Disbursement	YES	79	2025-07-30	\N	\N	\N	46
\.


--
-- Data for Name: tbmanufuctures_varieties; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.tbmanufuctures_varieties (id, name, category, status, created_by, created_date) FROM stdin;
1	dde	Manufucture	Active	79	2025-06-26
2	PPF TR	Variety	Active	79	2025-06-26
\.


--
-- Data for Name: tbmembers; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.tbmembers (member_id, first_name, middle_name, last_name, phone_number, member_status, member_age, filename, nida, group_id, gender, created_date, created_by, acres, marital_status, crop_grown, filenamenida, animal_kept, next_of_kin_names, next_of_kin_phonenumber, member_bank, member_bank_acc_number) FROM stdin;
39	QQ	XX	ZZ	098887732	Active	29	member_1754954208_689a79e0e1aea.jpg	19966666-66666-66666-66	27	Male	2025-08-11	79	6	married	6	\N	\N	\N	\N	\N	\N
40	bb	nn	mm	08756545	Active	37	member_1754954498_689a7b02a1e96.jpg	19880999-99999-99999-99	27	Female	2025-08-11	79	5	divorced	8	member_nida_1754954498_689a7b02ae8ac.jpg	\N	\N	\N	\N	\N
42	tt	rr	jj	0999494	Active	27	member_1754956455_689a82a7decbe.jpg	19989999-99999-99999-99	27	Male	2025-08-11	79	7	separated	14	member_nida_1754956455_689a82a7df182.jpg	Poultry 	ll	dd	\N	\N
43	ll	kk	hh	0990392	Active	40	member_1754957319_689a86075fefd.jpg	19857267-26272-72222-22	27	Female	2025-08-12	79	10	widowed	8	member_nida_1754957319_689a860760817.jpg	None	yyyy	656565	2	0it9504itr999
29	Greyson	Oscar	Komba	0653521633	Active	38	member_1753858151_6889c06740a41.jpg	197307015730400014-24	24	Male	2025-07-30	STAFF925448x	10	married	\N	\N	\N	\N	\N	\N	\N
31	Jackson	John	Mkwama	09773823	Active	34	member_1753875718_688a050680826.png	198809298308820000-00	24	Male	2025-07-30	79	11	divorced	\N	\N	\N	\N	\N	\N	\N
35	bb	bb	bb	22234	Active	22	member_1753883818_688a24aa5bd33.jpg	19909099-09090-90909-09	25	Female	2025-07-30	STAFF470835	12	widowed	\N	\N	\N	\N	\N	\N	\N
36	zz	zz	zz	34332	Active	27	member_1753884552_688a2788c0973.jpg	19939999-99999-99999-99	25	Male	2025-07-30	STAFF470835	9	married	\N	\N	\N	\N	\N	\N	\N
37	iii	iii	ii	33354	Active	-6560	member_1753884615_688a27c79c477.jpg	85858585-85858-58585-85	25	Male	2025-07-30	STAFF470835	1	separated	\N	\N	\N	\N	\N	\N	\N
38	dd	dd	dd	111	Active	35	member_1753884936_688a290886deb.jpg	19900809-09090-90909-09	25	Male	2025-07-30	STAFF470835	5	separated	\N	\N	\N	\N	\N	\N	\N
\.


--
-- Data for Name: tbmodules; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.tbmodules (module_id, module_name, module_status, module_date) FROM stdin;
1	Loan	Active	0
2	Leave	Active	0
3	Payroll	Active	0
4	Hr	Active	0
5	Funds Request	Active	0
7	ICT	Active	0
\.


--
-- Data for Name: tbmodules_user; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.tbmodules_user (id, user_id, module_id, is_active) FROM stdin;
1	79	1	Active
2	79	4	Active
3	79	7	Active
25	STAFF505507	1	Active
26	STAFF505507	5	Active
27	STAFF429439	1	Active
28	STAFF56728	1	Active
29	STAFF56728	2	Active
30	STAFF56728	3	Active
31	STAFF56728	4	Active
32	STAFF56728	5	Active
33	STAFF56728	7	Active
34	STAFF470835	1	Active
35	STAFF470835	2	Active
36	STAFF358589	1	Active
37	STAFF358589	4	Active
38	STAFF358589	7	Active
39	STAFF470835	1	Active
40	STAFF358589	1	Active
41	STAFF620463	1	Active
\.


--
-- Data for Name: tbproduct_categories; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.tbproduct_categories (product_categorie_id, product_categories_name, product_categories_status, created_date, created_by) FROM stdin;
3	Maize	Active	2024	79
4	Rice	Active	2024	79
9	Soyabean	Active	2024	79
\.


--
-- Data for Name: tbproducts; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.tbproducts (product_id, product_code, product_name, variety_manufacture, product_group, product_unit_price, product_measurement, filename, description, created_by, created_date, product_status) FROM stdin;
1	PRD8001	TEMBO 719		1	800	Kg			79	2024-12-26	Active
2	PRD1599	ZMS 638		1	900	Kg			79	2024-12-26	Active
3	PRD1121	MAGUG34352		1	3000	Kg			79	2024-12-26	Active
4	PRD4965	LUBANGO		1	5500	Kg			79	2024-12-26	Active
7	PRD4176	SA		3	48000	Kg			79	2024-12-27	Active
8	PRD8181	UREA		3	76000	Kg			79	2024-12-27	Active
10	PRD1512	ZAMSEED 606		1	8000	Kg			79	2024-12-27	Active
11	PRD9219	ZAMSEED 638		1	8000	Kg			79	2024-12-27	Active
12	PRD3133	SEEDCO 719		1	8000	Kg			79	2024-12-27	Active
13	PRD7751	SEEDCO 729		1	8000	Kg			79	2024-12-27	Active
14	PRD1674	LUBANGO		1	8000	Kg			79	2024-12-27	Active
15	PRD6798	DK 777		1	8000	Kg			79	2024-12-27	Active
16	PRD7094	DK 90-89		1	8000	Kg			79	2024-12-27	Active
17	PRD8756	TXD 306 SARO 5		1	5000	Kg			79	2024-12-27	Active
19	PRD5020	SA		1	48000	Kg			79	2024-12-28	Active
20	PRD9924	UREA		1	75000	Kg			79	2024-12-28	Active
24	PRD6131	DAP		3	80000	Kg			79	2024-12-28	Active
25	PRD1444	NPK		3	80000	Kg			79	2024-12-28	Active
26	PRD5209	NPS Boron		3	80000	Kg			79	2024-12-28	Active
27	PRD3969	NPS Zinc		3	80000	Kg			79	2024-12-28	Active
28	PRD4999	CEREAL NPK		3	80000	Kg			79	2024-12-28	Active
29	PRD4769	YARAVERA PANDA		3	80000	Kg			79	2024-12-28	Active
30	PRD9211	MICRO TOP NPK		3	80000	Kg			79	2024-12-28	Active
31	PRD9638	SNOWBURNER		5	30000	Lt			79	2024-12-28	Active
32	PRD4300	NICOFORN		5	30000	Lt			79	2024-12-28	Active
33	ITM6654	CEREAL OTESHA (2021-2022)		3	105000	50kg Bag			79	2025-01-13	Active
34	ITM3889	AMIDAS (2021-2022)		3	107000	50kg Bag			79	2025-01-13	Active
35	ITM5628	CEREAL OTESHA 1 (2021-2022)		3	105000	50kg Bag			79	2025-01-13	Active
36	ITM6479	CEREAL OTESHA 2 (2021-2022)		3	108500	50kg Bag			79	2025-01-13	Active
37	ITM3206	YARAMIRA CEREAL		3	105000	50kg Bag			79	2025-01-13	Active
38	ITM6049	YARAMIRA CEREAL		3	108500	50kg Bag			79	2025-01-13	Active
39	ITM4755	YARAVERA AMIDAS		3	107000	50kg Bag			79	2025-01-13	Active
40	ITM7897	YARAMIRA CEREAL 25KGS		3	54500	50kg Bag			79	2025-01-13	Active
41	ITM7769	PIONEER		1	5800	Kg			79	2025-01-13	Active
42	ITM9995	DAWA		5	25000	Lt			79	2025-01-13	Active
43	ITM8940	YARAMIRA CEREAL		3	54500	25kg Bag			79	2025-01-13	Active
48	PRD5762	soya	7	6	6000	Kg	econtract.webp	sddsds	79	2025-04-29	Active
49	PRD1211	SC-719 (TEMBO)	10	1	8000	Kg	amazonmusicussharedidappsforyou_install1	A seed with long term maturity	STAFF429439	2025-05-02	Active
9	PRD2031	po	2	5	6900	Quantity(Qty)	1750941119_3ab45cd34dff6c41a7a2.jpg	opopopo	79	2025-06-26	Active
21	PRD2771	CAN		3	50000	Kg			79	2024-12-28	Active
\.


--
-- Data for Name: tbregions; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.tbregions (region_id, region_name, region_code, region_status) FROM stdin;
\.


--
-- Data for Name: tbrepayment; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.tbrepayment (repayment_id, repaym_date, total_loan_amount, paid_amount, remained_amount, repayment_code, loan_id, is_deleted, group_id, farmer, created_date, created_by) FROM stdin;
\.


--
-- Data for Name: tbrepayment_existing_loan; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.tbrepayment_existing_loan (id, loan_id, repayment_date, amount_paid, years_since_disbursement, penalty_amount, outstanding_principal, total_outstanding_with_penalty, total_outstanding_no_penalty, created_at) FROM stdin;
\.


--
-- Data for Name: tbsalary_scale; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.tbsalary_scale (salary_id_auto, salary_id, salary_name, salary_amount, salary_status, created_by, created_date) FROM stdin;
1	SAL784174	MCODE0090	2000000	Active	79	2025-07-29
2	SAL593758	MCODE0090	2000000	Active	79	2025-07-29
3	SAL789950	MCODE0090	2000000	Active	79	2025-07-29
4	SAL266220	MCODE0090	2000000	Active	79	2025-07-29
\.


--
-- Data for Name: tbseeds; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.tbseeds (seeds_id, seeds_name, seeds_category, seeds_code, seeds_loan_rate, seeds_status, seeds_unit_price, created_date, created_by) FROM stdin;
\.


--
-- Data for Name: tbstaffs; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.tbstaffs (id, staff_id, first_name, last_name, email, phone_number, gender, date_of_birth, hire_date, "position", department, salary, status, address, emergency_contact_name, emergency_contact_phone, hire_type, employee_code, national_id, created_at, updated_at) FROM stdin;
1	STAFF925448	SELEMANI	KAJUNA	skajuna@mcode.com	0765454324	Male	2024-11-25	2024-11-18	DES0094792	DEP844772	2	Active	mufindi	JUMA JUMA	078942424	Contract	mcd002	1232412-24124-3424	2024-11-25 21:43:13	2024-11-25 23:35:35
2	STAFF470835	FF	FF	shabaFFnimustafa20@gmail.com	444	Male	2025-07-29	2025-07-29	DES678018	DEP230286	SAL784174	Active	FFF	FFF	FFF	Full-time	FFF	FFF	2025-07-29 21:32:09.925018	2025-07-29 21:32:09.925018
3	STAFF358589	Grey	Komba	grey@mcd.or.tz	07150962020	Male	2025-07-30	2025-07-30	DES340354	DEP230286	SAL784174	Active	Songea	Komba	0993939	Full-time	Mcd0029	73728282	2025-07-30 08:07:19.524315	2025-07-30 08:07:19.524315
4	STAFF620463	Aloyce	Mbilinyi	aloyce@mcd.or.tz	0759000000	Male	2025-08-04	2025-08-04	DES340354	DEP230286	SAL593758	Active	Songea	Aloyce	07157372727	Full-time	Mcd9992	82828282828	2025-08-04 12:09:57.027223	2025-08-04 12:09:57.027223
\.


--
-- Data for Name: tbstaffs_old; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.tbstaffs_old (staff_id_auto, staff_id, first_name, middle_name, last_name, staff_post, birth_date, phone_number, staff_status) FROM stdin;
\.


--
-- Data for Name: tbstakeholder; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.tbstakeholder (stakeholder_id, stakeholder_name, stakeholder_group, "postal_box_physical_Address", contact_person_full_names, contact_person_email, contact_person_phonenumber, certificateofregistration, taxclearance, tin, logo, stakeholder_status, created_date_old, created_by, removed_by, postal_box_physical_address, created_date) FROM stdin;
2	CRDB BANK	Financiers(Bank)	76767 DSM	JUMA MWAKALUMIALE	juma@crdb.co.tz	0787675625	certificateofregistration_1750932916_685d1db4754cf.jpg	taxclearance_1750932916_685d1db475b2e.jpg	tin_1750932916_685d1db475ea9.jpg	logo_1750932916_685d1db475ce8.jpg	Active	\N	\N	\N	\N	2025-06-26
3	EQUITY BANK	Financiers(Bank)	6676 dar	Selemani Mwalimu	sele@equity.com	0787651662	certificateofregistration_1750937387_685d2f2b2d30b.jpg	taxclearance_1750937387_685d2f2b2d9b1.jpg	tin_1750937387_685d2f2b2ddc1.jpg	logo_1750937387_685d2f2b2dba0.jpg	Active	\N	\N	\N	\N	2025-06-26
\.


--
-- Data for Name: tbusers; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.tbusers (user_id, first_name, last_name, phone_number, profile, created_by, edit_status, edited_by, edit_approved_by, is_blocked, login_attempts, user_name, password, created_date, status) FROM stdin;
79	shabani	Kaseko	77777	Mkuuwafamilia	113	0	0	0	0	0	admin@mcd.or.tz	$2y$10$7lDQwSDI0ppZo8pz2zLNf.TTzPvqSdyDIwX3XyLRnp2x5/tGmpp6m	2019-09-05	Active
STAFF429439	Slaiton	Kaberege		director	0	0	0	0	0	0	slaiton.kaberege@mcd.or.tz	$2y$10$7lDQwSDI0ppZo8pz2zLNf.TTzPvqSdyDIwX3XyLRnp2x5/tGmpp6m		Active
STAFF505507	Ahsante	Zenda		director	0	0	0	0	0	0	ahsante.zenda@mcd.or.tz	$2y$10$7lDQwSDI0ppZo8pz2zLNf.TTzPvqSdyDIwX3XyLRnp2x5/tGmpp6m		Active
STAFF56728	John	hoevn		officer	0	0	0	0	0	0	johnaugustijnhoeven@gmail.com	$2y$10$7lDQwSDI0ppZo8pz2zLNf.TTzPvqSdyDIwX3XyLRnp2x5/tGmpp6m		Active
STAFF925448x	Greyson	komba		Seniorofficer	0	0	0	0	0	0	greyson@mcd.or.tz	$2y$10$7lDQwSDI0ppZo8pz2zLNf.TTzPvqSdyDIwX3XyLRnp2x5/tGmpp6m		Active
STAFF358589	Grey	Komba	\N	Accountant	\N	0	0	0	0	0	grey@mcd.or.tz	$2y$12$4BHo1A53Dxh39VU/WHLBb.u5a5PUWo2iKmHD30gGFVcxg3eH0/Keu	\N	Active
STAFF470835	Hassani	Kikumbe	\N	officer	\N	0	0	0	0	0	shabaFFnimustafa20@gmail.com	$2y$12$znZ4m0Rw5keyPOWpYFunZ.JxpRnlFIpdIx5R/GrFh/mFfvpKashd2	\N	Active
STAFF620463	Aloyce	Mbilinyi	\N	officer	\N	0	0	0	0	0	aloyce@mcd.or.tz	$2y$12$8ememjnt9hrTz4Sv4cd4LOHi73pgxwHgAqcgbAOA/lSVWjM.M457y	\N	Active
\.


--
-- Data for Name: tbvillages; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.tbvillages (village_id, village_name, village_status, region_id, district_id, ward_id) FROM stdin;
\.


--
-- Data for Name: tbwards; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.tbwards (ward_id, ward_name, ward_status, region_id, district_id) FROM stdin;
\.


--
-- Data for Name: test_data; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.test_data (id, name, email, message) FROM stdin;
1	shabani	shabanimustafa20@gmail.com	test
\.


--
-- Data for Name: user_sessions; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.user_sessions (id, user_id, device_name, "Accessed_module", session_id, ip_address, last_activity) FROM stdin;
1	79	Desktop	Loan	c577f019ef203e1d50b052c906c845a0	197.250.133.80	1749565854
2	79	Desktop	Hr	5c4a14126b5d030508fd177f7bf51e8c	197.250.133.80	1749565901
3	79	Desktop	Loan	d7ba2a6111dd91759b6d21dc4896038a	197.250.133.80	1749566590
4	79	Desktop	Loan	d7ba2a6111dd91759b6d21dc4896038a	197.250.133.80	1749566647
5	79	Desktop	Loan	d7ba2a6111dd91759b6d21dc4896038a	197.250.133.80	1749566710
6	79	Desktop	Loan	f024b3e14c73832c643092c4244e93eb	197.250.133.80	1749566929
7	79	Desktop	Loan	f024b3e14c73832c643092c4244e93eb	197.250.133.80	1749567022
8	79	Desktop	Loan	b276296622ad52a105095f2abfb8fca6	197.250.133.80	1749567347
9	79	Desktop	Loan	b276296622ad52a105095f2abfb8fca6	197.250.133.80	1749567445
10	79	Desktop	Loan	b276296622ad52a105095f2abfb8fca6	197.250.133.80	1749567512
11	79	Desktop	Loan	b276296622ad52a105095f2abfb8fca6	197.250.133.80	1749567538
12	79	Desktop	Loan	550b5e8d0590068bd30abe97133f2941	197.250.133.80	1749567725
13	79	Desktop	Loan	c526e6fb1109aaeb30a8e0b9786d3226	197.250.133.80	1749568316
14	79	Desktop	Loan	c526e6fb1109aaeb30a8e0b9786d3226	197.250.133.80	1749568352
15	79	Desktop	Loan	c526e6fb1109aaeb30a8e0b9786d3226	197.250.133.80	1749568401
16	79	Desktop	Loan	6e2b3a822e085d0812fadcdaba35818c	197.250.133.80	1749569769
17	79	Desktop	Hr	6e2b3a822e085d0812fadcdaba35818c	197.250.133.80	1749569816
18	79	Desktop	Loan	6e2b3a822e085d0812fadcdaba35818c	197.250.133.80	1749569827
19	79	Desktop	Loan	c2f8dbaf9e2b8d8405c5d95e35ff8ec4	197.250.133.80	1749570377
22	79	Desktop	Loan	957c1747e9c8e97de3e342bec0a462f5	197.250.229.209	1749635741
23	79	Desktop	Loan	00dbd9a0662d55e36c40fe4f5d57463d	197.250.229.209	1749662634
28	79	Desktop	Loan	a7540665b0ac02cf94da034536d1b27d	197.250.229.209	1749672781
29	79	Desktop	Loan	c26b1259099cd250a5ef7d88f8d3d662	197.250.199.252	1749675697
31	79	Desktop	Loan	b2dd6f872354aa3a22c265c52aeef637	197.250.199.203	1750232400
32	STAFF429439	Desktop	Loan	cc18716b6b31488e141507748b12cd67	154.74.159.9	1750256834
33	STAFF505507	Mobile Device	Loan	818be368db63d8075b709408383a88c3	196.249.109.113	1750430522
34	STAFF505507	Mobile Device	Loan	818be368db63d8075b709408383a88c3	196.249.109.113	1750430688
35	79	Desktop	Loan	d96b6714be8f21fa7b784f906c0edf14	197.250.134.235	1750714349
36	79	Desktop	Loan	1cd16aba15a7bf50fc21be050a3b73a7	197.250.134.235	1750718972
37	79	Desktop	Loan	f5d0588c9069f3fd04dff311a2df327a	197.250.103.74	1750937727
38	79	Desktop	Loan	f0647f70cab0a82cb084ef8e14443d2f	197.250.204.7	1751280480
39	79	Desktop	Loan	0cc0c57e6b00db21a95c40820c76c91e	51.159.226.155	1751292591
40	79	Desktop	Loan	b406c4b6446a8adb518fa7e6d4f044eb	197.250.130.151	1751394232
41	79	Desktop	Loan	004b8835a5337c14c54c92742a665d54	197.250.130.151	1751398182
42	79	Desktop	Loan	293379e42037712224a60a96ca3c41a6	197.250.130.151	1751398857
43	STAFF429439	Desktop	Loan	e6ca9b61bbdb96493a100a6ef7f27c82	196.249.92.4	1751435579
44	79	Desktop	Loan	abeca7068f30fd18013ee8c109a681b7	197.250.133.236	1751539475
45	STAFF505507	Desktop	Loan	9f9cad37c476c1f80c7dd977c03b809a	169.255.185.170	1751542365
46	79	Desktop	Loan	ab3b4f7ca65e1396b353a963675d1a32	197.250.50.73	1751567569
47	STAFF505507	Desktop	Loan	bcd0ef3f3ea6a4a051619e69605b796f	154.74.158.20	1751567697
48	STAFF505507	Desktop	Loan	3ad2a7ede7bdc7fca0c06ebf6531855d	154.74.158.20	1751570072
49	STAFF505507	Desktop	Loan	1a274a44fb6776d9de683816186e6f09	169.255.184.170	1751627039
50	79	Desktop	Loan	ea1e88bdbacbbc5ac30905ce452d782c	197.250.50.73	1751653891
51	STAFF505507	Desktop	Loan	67d6480ee2e56ae97c0b8c39005acb8d	197.250.199.216	1751743890
52	79	Desktop	Loan	a895c16c3d6e580d75149ff8c4688d16	197.250.50.11	1751744299
53	79	Desktop	Loan	c612ab9d6fd6353ecc4bf7770675c895	197.250.50.11	1751779798
54	79	Desktop	Loan	c612ab9d6fd6353ecc4bf7770675c895	197.250.50.11	1751779813
55	STAFF505507	Desktop	Loan	b88e52293d57ab6b9aff4014e470bdbf	196.249.93.25	1751913283
56	79	Desktop	Loan	9039ccb644009d9e06c4f0547ff21651	197.250.51.218	1751915166
57	79	Desktop	Loan	c92563b7bbd258aab04c18fdcbe5d54b	197.250.51.218	1751983834
58	79	Desktop	Loan	a28444a3dce704c6b42256de3432cade	197.250.100.90	1752065624
59	79	Desktop	Loan	40922f22d8d2eae0661037dbd418dd83	197.250.100.90	1752070466
60	79	Desktop	Loan	0786e903dcd4d98ddd5732983af1c39d	197.250.100.90	1752101522
61	79	Desktop	Loan	b9c0830f6b430bcb66990b4d7b0c8bd9	197.250.100.90	1752171851
62	79	Desktop	Loan	62e0dc24479037f39a3377bb69ff6acc	197.250.134.58	1752187301
63	79	Desktop	Loan	d93cbbd852c94f8ed9d298340cd19164	197.250.134.58	1752188981
64	79	Desktop	Hr	8b749de370fdf1f8da46ef95ac35a3a8	197.250.230.14	1752483134
65	79	Desktop	ICT	8b749de370fdf1f8da46ef95ac35a3a8	197.250.230.14	1752483146
66	79	Desktop	Loan	8b749de370fdf1f8da46ef95ac35a3a8	197.250.230.14	1752483161
67	79	Desktop	Loan	70a0efde4e1236c086ab976dc92f8dfb	197.250.230.14	1752484528
68	79	Desktop	Loan	ce0017fbbecd21da80125996be7a046a	197.250.230.14	1752486207
69	79	Desktop	Loan	1ee87dff70ef412722855779e2290f7c	197.250.230.14	1752571334
70	79	Desktop	Loan	d5d580b74eed0420c12f4e62330699ae	197.250.230.14	1752602928
71	79	Desktop	Loan	18e8e7ebd16cd2596c77f89df5f849c4	197.250.230.14	1752616958
72	79	Desktop	Loan	1f60b150116499d23ded247f0db8aa3d	197.250.230.14	1752670036
73	79	Desktop	Loan	31374fb1afbfa7d6c099f5e276e4cd83	197.250.230.14	1752680984
74	79	Desktop	Loan	d78267d1526461925ea4cd620cef0339	197.250.199.233	1752786493
75	79	Desktop	Loan	e0d389498b503ad272b7f21cbcc49f86	197.250.199.233	1752865664
76	STAFF429439	Desktop	Loan	03cc69493b326f6f75af29ac35bb326c	169.255.185.72	1752993619
77	79	Desktop	Loan	a005f57b28be5046e8f8bbde729aca1c	197.250.227.2	1753073314
78	STAFF505507	Desktop	Loan	5d96cb2f3b7eae6ecaded80e0479358b	169.255.185.156	1753442818
79	79	Desktop	Loan	e57a053b39760d3f2d2af397290d6792	51.159.226.151	1753514805
80	79	Desktop	Loan	6c34a4fe9176bd56f6358b49c908db69	197.250.103.79	1753518819
81	79	Desktop	Loan	87f244eece7ea294039db9b66a074292	197.250.131.204	1753709550
82	79	Desktop	Loan	0e15371cf43805108964b0df1cb0859c	197.250.131.204	1753727945
85	79	Desktop	Loan	69ca71434440cc2f2643cd7949f8f0a8	51.159.226.151	1753764793
86	79	Desktop	Loan	716db40b85b0edc0abb3309ae3a45ecd	41.222.179.234	1753803272
87	79	Desktop	ICT	f63337672aa5ff7623d569736af23341	41.222.179.234	1753805269
88	79	Desktop	Hr	f63337672aa5ff7623d569736af23341	41.222.179.234	1753805283
89	79	Desktop	Hr	5f00a9391ccfd32716c78cad64b42b34	41.222.179.234	1753805676
90	79	Desktop	Hr	ff90d770be5e5bc607655b91f47f37cd	41.222.179.234	1753806851
91	79	Desktop	Hr	3988b987a4738008fe35a7ff5bb5d727	41.222.179.234	1753807221
92	79	Desktop	Hr	3988b987a4738008fe35a7ff5bb5d727	197.250.227.32	1753808149
93	79	Desktop	ICT	6ad2ef5c21723971ee87bfe770670eab	197.250.227.32	1753817754
94	79	Desktop	Loan	5168445f40f6fd66fb010f4dca56ef35	197.250.227.32	1753822074
132	STAFF925448x	Desktop	Loan	707310e972b235cfc9bc3fb64ee9b1d2	51.159.226.151	1753856942
133	79	Desktop	Loan	8e89f5426e1728d30f9cfda7286b2c19	197.250.199.197	1753856996
138	79	Desktop	Loan	6e621977cce85d71ae419f99a1434083	197.250.199.197	1753858192
139	79	Desktop	Loan	844d9a81baf2bd381bd8edc486ada44d	197.250.199.197	1753875421
140	STAFF470835	Desktop	Loan	78aad291178c2aa4cb0267936b89ca35	197.250.199.197	1753878499
142	79	Desktop	Loan	c25ad379f5a961fff5622ef601332907	197.250.199.197	1753899830
143	79	Mobile Device	Loan	171842eab3dfde81bb6665063224b5ae	197.250.199.197	1753905520
144	79	Desktop	Loan	eee67240e3cc2875adf2ef6f9821cd4c	197.250.199.197	1753908967
146	79	Desktop	Loan	5f0533e159343c17f0d142bc5c03a230	197.250.199.197	1753910792
147	79	Desktop	Loan	4fd8950e463681383680a361e56bbe28	197.250.199.197	1753911619
148	79	Desktop	Loan	b6b42f8305372db04e851072594691eb	197.250.199.197	1753911654
149	79	Desktop	Loan	9ffbb77d2c226596e4a63da9abfd74d9	197.250.199.197	1753912514
150	79	Desktop	Loan	ce79d3daf3c2be3a0e71f21b49ff2865	197.250.199.197	1753912533
151	79	Desktop	Loan	6188116be00bedb687eb030967f61f67	197.250.199.197	1753912790
152	79	Mobile Device	Loan	81092ac078dee88c7b0c49caa1fc55b3	197.250.199.197	1753912922
153	79	Desktop	ICT	f854850abd04716f53ceeb17f0a45480	197.250.199.197	1753912949
154	79	Desktop	Loan	7d5dc0e7c3a3a142c9f6b0aba84c68cd	197.250.199.197	1753912971
155	79	Desktop	Loan	ef9bfc705581f02a04ccd91c04fbf96c	197.250.199.197	1753914923
156	79	Desktop	Loan	61ef7a0ad37a130d2149968cd64545bc	197.250.199.197	1753915633
157	79	Desktop	Loan	fdced7b8c6f5168565965e04abd8eb20	197.250.199.197	1753916237
158	79	Mobile Device	Hr	b5f4639d8880b54f422ba46ea42dc5a8	197.250.100.40	1754302104
159	79	Mobile Device	ICT	635562dc21bc9ad73f4b30b0195bff94	197.250.100.40	1754302275
160	STAFF620463	Mobile Device	Loan	011dbb69dd84b075253de7d024c0c364	197.250.100.40	1754302355
161	STAFF925448x	Desktop	Loan	a6e6039b0b70d6203ab0d28ae4f7f9d2	51.159.226.151	1754305122
162	79	Desktop	Loan	46db0f60635362c93030fe1eaf953cc4	41.59.30.236	1754305174
163	STAFF429439	Desktop	Loan	15653c8a985aefb148a3e43c20ff38fa	154.74.190.30	1754326831
164	STAFF429439	Mobile Device	Loan	7b59dadc16a225c9f700e1085c4d7ff4	197.250.100.40	1754327071
165	STAFF925448x	Desktop	Hr	93ce6cd3abab14547c017153e33668c3	51.159.226.155	1754371190
166	STAFF925448x	Desktop	ICT	aa3b27ac6ce284f2c3b282e0739ca71e	51.159.226.155	1754371397
167	STAFF925448x	Desktop	Loan	604d5c4a2be588028adf131485e12c26	51.159.226.155	1754393878
168	79	Desktop	Loan	c57fd019611ebb063a25a9ae92a74839	197.250.136.246	1754435177
169	79	Desktop	Loan	4b104e65b356434db646b1b376ba6e90	197.250.136.246	1754441295
170	79	Desktop	Loan	e2d73cfa82eeea966c48796f97d35014	197.250.102.30	1754510233
171	STAFF505507	Desktop	Loan	b16dccb18a2f3adfe482cb836a51c882	196.249.92.254	1754740734
172	STAFF429439	Desktop	Loan	407f537a13c72b95924c80d25a82fbfe	154.74.175.3	1754816013
173	STAFF505507	Desktop	Loan	67c1cb28cfb2fbf988b01f025429e193	196.249.93.215	1754845665
174	STAFF925448x	Desktop	Loan	b78d3e5ae5d3be00f11c18c120a1582c	51.159.226.155	1754888948
175	79	Desktop	Loan	9bb45c7b236ad4bb3d12cd401390d8e3	197.250.132.73	1754925985
176	79	Desktop	Loan	d00ebb4a016458db497fa74c928a4551	197.250.132.73	1754941447
177	79	Desktop	Loan	460ef7c4c518a42727263ed988a20131	197.250.132.73	1754941772
178	79	Desktop	Loan	e3678a235e354df10b0a0acfe7f14c3c	197.250.132.73	1755010213
179	79	Desktop	Loan	bb730afe0b61b1745e289e4deb6e5b9c	197.250.130.196	1755033357
212	79	Desktop	Loan	16935f218d772b2c362aa775d2f57a5f	197.250.131.240	1755037611
213	79	Desktop	Loan	4746a6212dd8696fcf6c66b9d26adf35	197.250.131.240	1755037936
\.


--
-- Name: amortization_schedule_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.amortization_schedule_id_seq', 205, true);


--
-- Name: loan_penalties_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.loan_penalties_id_seq', 1, false);


--
-- Name: loan_repayments_existing_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.loan_repayments_existing_id_seq', 1, false);


--
-- Name: loan_repayments_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.loan_repayments_id_seq', 1, false);


--
-- Name: repayment_history_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.repayment_history_id_seq', 126, true);


--
-- Name: repayment_history_new_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.repayment_history_new_id_seq', 20, true);


--
-- Name: repayment_historyxx_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.repayment_historyxx_id_seq', 1, false);


--
-- Name: repayments_repayment_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.repayments_repayment_id_seq', 1, false);


--
-- Name: tbaggregation_aggregation_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.tbaggregation_aggregation_id_seq', 3, true);


--
-- Name: tbagriitem_agriitem_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.tbagriitem_agriitem_id_seq', 12, true);


--
-- Name: tbaudit_trail_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.tbaudit_trail_id_seq', 159, true);


--
-- Name: tbbranches_branch_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.tbbranches_branch_id_seq', 1, false);


--
-- Name: tbdepartments_department_id_auto_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.tbdepartments_department_id_auto_seq', 2, true);


--
-- Name: tbdesignations_designation_id_auto_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.tbdesignations_designation_id_auto_seq', 2, true);


--
-- Name: tbdisbursements_disb_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.tbdisbursements_disb_id_seq', 12, true);


--
-- Name: tbdistribution_distrution_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.tbdistribution_distrution_id_seq', 5, true);


--
-- Name: tbdistricts_district_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.tbdistricts_district_id_seq', 1, false);


--
-- Name: tbfertilize_fertilizer_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.tbfertilize_fertilizer_id_seq', 1, false);


--
-- Name: tbgroup_bank_accounts_bank_account_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.tbgroup_bank_accounts_bank_account_id_seq', 25, true);


--
-- Name: tbgroup_budget_count_count_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.tbgroup_budget_count_count_id_seq', 9, true);


--
-- Name: tbgroup_budget_items_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.tbgroup_budget_items_id_seq', 100, true);


--
-- Name: tbgroup_budgets_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.tbgroup_budgets_id_seq', 47, true);


--
-- Name: tbgroup_members_group_member_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.tbgroup_members_group_member_id_seq', 28, true);


--
-- Name: tbgroups_group_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.tbgroups_group_id_seq', 27, true);


--
-- Name: tbherbicide_herbicide_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.tbherbicide_herbicide_id_seq', 1, false);


--
-- Name: tbloan_existing_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.tbloan_existing_id_seq', 25, true);


--
-- Name: tbloan_existing_product_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.tbloan_existing_product_id_seq', 39, true);


--
-- Name: tbloan_loan_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.tbloan_loan_id_seq', 1, false);


--
-- Name: tbloan_monthly_details_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.tbloan_monthly_details_id_seq', 400, true);


--
-- Name: tbloan_repayment_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.tbloan_repayment_id_seq', 1, false);


--
-- Name: tbloanapplicants_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.tbloanapplicants_id_seq', 41, true);


--
-- Name: tbloanapplications_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.tbloanapplications_id_seq', 44, true);


--
-- Name: tbmanufuctures_varieties_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.tbmanufuctures_varieties_id_seq', 2, true);


--
-- Name: tbmembers_member_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.tbmembers_member_id_seq', 43, true);


--
-- Name: tbmodules_module_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.tbmodules_module_id_seq', 1, false);


--
-- Name: tbmodules_user_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.tbmodules_user_id_seq', 41, true);


--
-- Name: tbproduct_categories_product_categorie_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.tbproduct_categories_product_categorie_id_seq', 1, false);


--
-- Name: tbproducts_product_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.tbproducts_product_id_seq', 52, true);


--
-- Name: tbregions_region_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.tbregions_region_id_seq', 1, false);


--
-- Name: tbrepayment_existing_loan_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.tbrepayment_existing_loan_id_seq', 1, false);


--
-- Name: tbrepayment_repayment_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.tbrepayment_repayment_id_seq', 1, false);


--
-- Name: tbsalary_scale_salary_id_auto_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.tbsalary_scale_salary_id_auto_seq', 4, true);


--
-- Name: tbseeds_seeds_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.tbseeds_seeds_id_seq', 1, false);


--
-- Name: tbstaffs_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.tbstaffs_id_seq', 5, true);


--
-- Name: tbstaffs_old_staff_id_auto_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.tbstaffs_old_staff_id_auto_seq', 1, false);


--
-- Name: tbstakeholder_stakeholder_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.tbstakeholder_stakeholder_id_seq', 3, true);


--
-- Name: tbvillages_village_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.tbvillages_village_id_seq', 1, false);


--
-- Name: tbwards_ward_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.tbwards_ward_id_seq', 1, false);


--
-- Name: test_data_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.test_data_id_seq', 1, true);


--
-- Name: user_sessions_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.user_sessions_id_seq', 213, true);


--
-- Name: amortization_schedule amortization_schedule_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.amortization_schedule
    ADD CONSTRAINT amortization_schedule_pkey PRIMARY KEY (id);


--
-- Name: loan_penalties loan_penalties_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.loan_penalties
    ADD CONSTRAINT loan_penalties_pkey PRIMARY KEY (id);


--
-- Name: loan_repayments_existing loan_repayments_existing_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.loan_repayments_existing
    ADD CONSTRAINT loan_repayments_existing_pkey PRIMARY KEY (id);


--
-- Name: loan_repayments loan_repayments_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.loan_repayments
    ADD CONSTRAINT loan_repayments_pkey PRIMARY KEY (id);


--
-- Name: repayment_history_new repayment_history_new_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.repayment_history_new
    ADD CONSTRAINT repayment_history_new_pkey PRIMARY KEY (id);


--
-- Name: repayment_history repayment_history_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.repayment_history
    ADD CONSTRAINT repayment_history_pkey PRIMARY KEY (id);


--
-- Name: repayment_historyxx repayment_historyxx_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.repayment_historyxx
    ADD CONSTRAINT repayment_historyxx_pkey PRIMARY KEY (id);


--
-- Name: repayments repayments_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.repayments
    ADD CONSTRAINT repayments_pkey PRIMARY KEY (repayment_id);


--
-- Name: tbaggregation tbaggregation_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbaggregation
    ADD CONSTRAINT tbaggregation_pkey PRIMARY KEY (aggregation_id);


--
-- Name: tbagriitem tbagriitem_agriitem_name_key; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbagriitem
    ADD CONSTRAINT tbagriitem_agriitem_name_key UNIQUE (agriitem_name);


--
-- Name: tbagriitem tbagriitem_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbagriitem
    ADD CONSTRAINT tbagriitem_pkey PRIMARY KEY (agriitem_id);


--
-- Name: tbaudit_trail tbaudit_trail_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbaudit_trail
    ADD CONSTRAINT tbaudit_trail_pkey PRIMARY KEY (id);


--
-- Name: tbbranches tbbranches_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbbranches
    ADD CONSTRAINT tbbranches_pkey PRIMARY KEY (branch_id);


--
-- Name: tbdepartments tbdepartments_department_id_auto_key; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbdepartments
    ADD CONSTRAINT tbdepartments_department_id_auto_key UNIQUE (department_id_auto);


--
-- Name: tbdepartments tbdepartments_department_name_key; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbdepartments
    ADD CONSTRAINT tbdepartments_department_name_key UNIQUE (department_name);


--
-- Name: tbdepartments tbdepartments_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbdepartments
    ADD CONSTRAINT tbdepartments_pkey PRIMARY KEY (department_id);


--
-- Name: tbdesignations tbdesignations_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbdesignations
    ADD CONSTRAINT tbdesignations_pkey PRIMARY KEY (designation_id_auto, designation_id);


--
-- Name: tbdisbursements tbdisbursements_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbdisbursements
    ADD CONSTRAINT tbdisbursements_pkey PRIMARY KEY (disb_id);


--
-- Name: tbdistribution tbdistribution_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbdistribution
    ADD CONSTRAINT tbdistribution_pkey PRIMARY KEY (distrution_id);


--
-- Name: tbdistricts tbdistricts_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbdistricts
    ADD CONSTRAINT tbdistricts_pkey PRIMARY KEY (district_id);


--
-- Name: tbfertilize tbfertilize_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbfertilize
    ADD CONSTRAINT tbfertilize_pkey PRIMARY KEY (fertilizer_id);


--
-- Name: tbgroup_bank_accounts tbgroup_bank_accounts_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbgroup_bank_accounts
    ADD CONSTRAINT tbgroup_bank_accounts_pkey PRIMARY KEY (bank_account_id);


--
-- Name: tbgroup_budget_count tbgroup_budget_count_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbgroup_budget_count
    ADD CONSTRAINT tbgroup_budget_count_pkey PRIMARY KEY (count_id);


--
-- Name: tbgroup_budget_items tbgroup_budget_items_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbgroup_budget_items
    ADD CONSTRAINT tbgroup_budget_items_pkey PRIMARY KEY (id);


--
-- Name: tbgroup_budgets tbgroup_budgets_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbgroup_budgets
    ADD CONSTRAINT tbgroup_budgets_pkey PRIMARY KEY (id);


--
-- Name: tbgroup_members tbgroup_members_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbgroup_members
    ADD CONSTRAINT tbgroup_members_pkey PRIMARY KEY (group_member_id);


--
-- Name: tbgroups tbgroups_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbgroups
    ADD CONSTRAINT tbgroups_pkey PRIMARY KEY (group_id);


--
-- Name: tbherbicide tbherbicide_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbherbicide
    ADD CONSTRAINT tbherbicide_pkey PRIMARY KEY (herbicide_id);


--
-- Name: tbloan_existing tbloan_existing_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbloan_existing
    ADD CONSTRAINT tbloan_existing_pkey PRIMARY KEY (id);


--
-- Name: tbloan_existing_product tbloan_existing_product_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbloan_existing_product
    ADD CONSTRAINT tbloan_existing_product_pkey PRIMARY KEY (id);


--
-- Name: tbloan_monthly_details tbloan_monthly_details_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbloan_monthly_details
    ADD CONSTRAINT tbloan_monthly_details_pkey PRIMARY KEY (id);


--
-- Name: tbloan tbloan_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbloan
    ADD CONSTRAINT tbloan_pkey PRIMARY KEY (loan_id);


--
-- Name: tbloan_repayment tbloan_repayment_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbloan_repayment
    ADD CONSTRAINT tbloan_repayment_pkey PRIMARY KEY (id);


--
-- Name: tbloanapplicants tbloanapplicants_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbloanapplicants
    ADD CONSTRAINT tbloanapplicants_pkey PRIMARY KEY (id);


--
-- Name: tbloanapplications tbloanapplications_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbloanapplications
    ADD CONSTRAINT tbloanapplications_pkey PRIMARY KEY (id);


--
-- Name: tbmanufuctures_varieties tbmanufuctures_varieties_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbmanufuctures_varieties
    ADD CONSTRAINT tbmanufuctures_varieties_pkey PRIMARY KEY (id);


--
-- Name: tbmembers tbmembers_nida_key; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbmembers
    ADD CONSTRAINT tbmembers_nida_key UNIQUE (nida);


--
-- Name: tbmembers tbmembers_phone_number_key; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbmembers
    ADD CONSTRAINT tbmembers_phone_number_key UNIQUE (phone_number);


--
-- Name: tbmembers tbmembers_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbmembers
    ADD CONSTRAINT tbmembers_pkey PRIMARY KEY (member_id);


--
-- Name: tbmodules tbmodules_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbmodules
    ADD CONSTRAINT tbmodules_pkey PRIMARY KEY (module_id);


--
-- Name: tbmodules_user tbmodules_user_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbmodules_user
    ADD CONSTRAINT tbmodules_user_pkey PRIMARY KEY (id);


--
-- Name: tbproduct_categories tbproduct_categories_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbproduct_categories
    ADD CONSTRAINT tbproduct_categories_pkey PRIMARY KEY (product_categorie_id);


--
-- Name: tbproducts tbproducts_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbproducts
    ADD CONSTRAINT tbproducts_pkey PRIMARY KEY (product_id);


--
-- Name: tbregions tbregions_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbregions
    ADD CONSTRAINT tbregions_pkey PRIMARY KEY (region_id);


--
-- Name: tbrepayment_existing_loan tbrepayment_existing_loan_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbrepayment_existing_loan
    ADD CONSTRAINT tbrepayment_existing_loan_pkey PRIMARY KEY (id);


--
-- Name: tbrepayment tbrepayment_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbrepayment
    ADD CONSTRAINT tbrepayment_pkey PRIMARY KEY (repayment_id);


--
-- Name: tbsalary_scale tbsalary_scale_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbsalary_scale
    ADD CONSTRAINT tbsalary_scale_pkey PRIMARY KEY (salary_id_auto);


--
-- Name: tbseeds tbseeds_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbseeds
    ADD CONSTRAINT tbseeds_pkey PRIMARY KEY (seeds_id);


--
-- Name: tbstaffs tbstaffs_email_key; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbstaffs
    ADD CONSTRAINT tbstaffs_email_key UNIQUE (email);


--
-- Name: tbstaffs_old tbstaffs_old_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbstaffs_old
    ADD CONSTRAINT tbstaffs_old_pkey PRIMARY KEY (staff_id_auto);


--
-- Name: tbstaffs_old tbstaffs_old_staff_id_key; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbstaffs_old
    ADD CONSTRAINT tbstaffs_old_staff_id_key UNIQUE (staff_id);


--
-- Name: tbstaffs tbstaffs_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbstaffs
    ADD CONSTRAINT tbstaffs_pkey PRIMARY KEY (id);


--
-- Name: tbstaffs tbstaffs_staff_id_key; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbstaffs
    ADD CONSTRAINT tbstaffs_staff_id_key UNIQUE (staff_id);


--
-- Name: tbstakeholder tbstakeholder_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbstakeholder
    ADD CONSTRAINT tbstakeholder_pkey PRIMARY KEY (stakeholder_id);


--
-- Name: tbusers tbusers_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbusers
    ADD CONSTRAINT tbusers_pkey PRIMARY KEY (user_id);


--
-- Name: tbvillages tbvillages_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbvillages
    ADD CONSTRAINT tbvillages_pkey PRIMARY KEY (village_id);


--
-- Name: tbwards tbwards_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbwards
    ADD CONSTRAINT tbwards_pkey PRIMARY KEY (ward_id);


--
-- Name: test_data test_data_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.test_data
    ADD CONSTRAINT test_data_pkey PRIMARY KEY (id);


--
-- Name: user_sessions user_sessions_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.user_sessions
    ADD CONSTRAINT user_sessions_pkey PRIMARY KEY (id);


--
-- Name: tbgroup_budget_items tbgroup_budget_items_budget_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbgroup_budget_items
    ADD CONSTRAINT tbgroup_budget_items_budget_id_fkey FOREIGN KEY (budget_id) REFERENCES public.tbgroup_budgets(id) ON DELETE CASCADE;


--
-- Name: tbloanapplicants tbloanapplicants_loan_application_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tbloanapplicants
    ADD CONSTRAINT tbloanapplicants_loan_application_id_fkey FOREIGN KEY (loan_application_id) REFERENCES public.tbloanapplications(id);


--
-- PostgreSQL database dump complete
--

