/* Mapbox GL JS is Copyright © 2020 Mapbox and subject to the Mapbox Terms of Service ((https://www.mapbox.com/legal/tos/). */
(function (global, factory) {
typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory() :
typeof define === 'function' && define.amd ? define(factory) :
(global = typeof globalThis !== 'undefined' ? globalThis : global || self, global.mapboxgl = factory());
})(this, (function () { 'use strict';

/* eslint-disable */

var shared, worker, mapboxgl;
// define gets called three times: one for each chunk. we rely on the order
// they're imported to know which is which
function define(_, chunk) {
if (!shared) {
    shared = chunk;
} else if (!worker) {
    worker = chunk;
} else {
    var workerBundleString = "self.onerror = function() { console.error('An error occurred while parsing the WebWorker bundle. This is most likely due to improper transpilation by Babel; please see https://docs.mapbox.com/mapbox-gl-js/guides/install/#transpiling'); }; var sharedChunk = {}; (" + shared + ")(sharedChunk); (" + worker + ")(sharedChunk); self.onerror = null;"

    var sharedChunk = {};
    shared(sharedChunk);
    mapboxgl = chunk(sharedChunk);
    if (typeof window !== 'undefined' && window && window.URL && window.URL.createObjectURL) {
        mapboxgl.workerUrl = window.URL.createObjectURL(new Blob([workerBundleString], { type: 'text/javascript' }));
    }
}
}


define(["exports"],(function(t){"use strict";var e="3.3.0";let r;const n={API_URL:"https://api.mapbox.com",get API_URL_REGEX(){if(null==r){const t=/^((https?:)?\/\/)?([^\/]+\.)?mapbox\.c(n|om)(\/|\?|$)/i;try{r=null!=process.env.API_URL_REGEX?new RegExp(process.env.API_URL_REGEX):t;}catch(e){r=t;}}return r},get API_TILEJSON_REGEX(){return /^((https?:)?\/\/)?([^\/]+\.)?mapbox\.c(n|om)(\/v[0-9]*\/.*\.json.*$)/i},get API_SPRITE_REGEX(){return /^((https?:)?\/\/)?([^\/]+\.)?mapbox\.c(n|om)(\/styles\/v[0-9]*\/)(.*\/sprite.*\..*$)/i},get API_FONTS_REGEX(){return /^((https?:)?\/\/)?([^\/]+\.)?mapbox\.c(n|om)(\/fonts\/v[0-9]*\/)(.*\.pbf.*$)/i},get API_STYLE_REGEX(){return /^((https?:)?\/\/)?([^\/]+\.)?mapbox\.c(n|om)(\/styles\/v[0-9]*\/)(.*$)/i},get API_CDN_URL_REGEX(){return /^((https?:)?\/\/)?api\.mapbox\.c(n|om)(\/mapbox-gl-js\/)(.*$)/i},get EVENTS_URL(){if(!n.API_URL)return null;try{const t=new URL(n.API_URL);return "api.mapbox.cn"===t.hostname?"https://events.mapbox.cn/events/v2":"api.mapbox.com"===t.hostname?"https://events.mapbox.com/events/v2":null}catch(t){return null}},SESSION_PATH:"/map-sessions/v1",FEEDBACK_URL:"https://apps.mapbox.com/feedback",TILE_URL_VERSION:"v4",RASTER_URL_PREFIX:"raster/v1",RASTERARRAYS_URL_PREFIX:"rasterarrays/v1",REQUIRE_ACCESS_TOKEN:!0,ACCESS_TOKEN:null,DEFAULT_STYLE:"mapbox://styles/mapbox/standard",MAX_PARALLEL_IMAGE_REQUESTS:16,DRACO_URL:"https://api.mapbox.com/mapbox-gl-js/draco_decoder_gltf_v1.5.6.wasm",MESHOPT_URL:"https://api.mapbox.com/mapbox-gl-js/meshopt_base_v0.20.wasm",MESHOPT_SIMD_URL:"https://api.mapbox.com/mapbox-gl-js/meshopt_simd_v0.20.wasm",GLYPHS_URL:"mapbox://fonts/mapbox/{fontstack}/{range}.pbf"};function i(t){return n.API_URL_REGEX.test(t)}function a(t){return 0===t.indexOf("mapbox:")}function s(t){return n.API_CDN_URL_REGEX.test(t)}function o(t){return n.API_SPRITE_REGEX.test(t)}function l(t){return n.API_STYLE_REGEX.test(t)&&!o(t)}const u={create:"create",load:"load",fullLoad:"fullLoad"};function c(t){const e=t.name.split("?")[0];return s(e)&&e.includes("mapbox-gl.js")?"javascript":s(e)&&e.includes("mapbox-gl.css")?"css":function(t){return n.API_FONTS_REGEX.test(t)}(e)?"fontRange":o(e)?"sprite":l(e)?"style":function(t){return n.API_TILEJSON_REGEX.test(t)}(e)?"tilejson":"other"}function h(t){return t&&t.__esModule&&Object.prototype.hasOwnProperty.call(t,"default")?t.default:t}var p=f;function f(t,e,r,n){this.cx=3*t,this.bx=3*(r-t)-this.cx,this.ax=1-this.cx-this.bx,this.cy=3*e,this.by=3*(n-e)-this.cy,this.ay=1-this.cy-this.by,this.p1x=t,this.p1y=e,this.p2x=r,this.p2y=n;}f.prototype={sampleCurveX:function(t){return ((this.ax*t+this.bx)*t+this.cx)*t},sampleCurveY:function(t){return ((this.ay*t+this.by)*t+this.cy)*t},sampleCurveDerivativeX:function(t){return (3*this.ax*t+2*this.bx)*t+this.cx},solveCurveX:function(t,e){if(void 0===e&&(e=1e-6),t<0)return 0;if(t>1)return 1;for(var r=t,n=0;n<8;n++){var i=this.sampleCurveX(r)-t;if(Math.abs(i)<e)return r;var a=this.sampleCurveDerivativeX(r);if(Math.abs(a)<1e-6)break;r-=i/a;}var s=0,o=1;for(r=t,n=0;n<20&&(i=this.sampleCurveX(r),!(Math.abs(i-t)<e));n++)t>i?s=r:o=r,r=.5*(o-s)+s;return r},solve:function(t,e){return this.sampleCurveY(this.solveCurveX(t,e))}};var d=h(p),m=y;function y(t,e){this.x=t,this.y=e;}y.prototype={clone:function(){return new y(this.x,this.y)},add:function(t){return this.clone()._add(t)},sub:function(t){return this.clone()._sub(t)},multByPoint:function(t){return this.clone()._multByPoint(t)},divByPoint:function(t){return this.clone()._divByPoint(t)},mult:function(t){return this.clone()._mult(t)},div:function(t){return this.clone()._div(t)},rotate:function(t){return this.clone()._rotate(t)},rotateAround:function(t,e){return this.clone()._rotateAround(t,e)},matMult:function(t){return this.clone()._matMult(t)},unit:function(){return this.clone()._unit()},perp:function(){return this.clone()._perp()},round:function(){return this.clone()._round()},mag:function(){return Math.sqrt(this.x*this.x+this.y*this.y)},equals:function(t){return this.x===t.x&&this.y===t.y},dist:function(t){return Math.sqrt(this.distSqr(t))},distSqr:function(t){var e=t.x-this.x,r=t.y-this.y;return e*e+r*r},angle:function(){return Math.atan2(this.y,this.x)},angleTo:function(t){return Math.atan2(this.y-t.y,this.x-t.x)},angleWith:function(t){return this.angleWithSep(t.x,t.y)},angleWithSep:function(t,e){return Math.atan2(this.x*e-this.y*t,this.x*t+this.y*e)},_matMult:function(t){var e=t[2]*this.x+t[3]*this.y;return this.x=t[0]*this.x+t[1]*this.y,this.y=e,this},_add:function(t){return this.x+=t.x,this.y+=t.y,this},_sub:function(t){return this.x-=t.x,this.y-=t.y,this},_mult:function(t){return this.x*=t,this.y*=t,this},_div:function(t){return this.x/=t,this.y/=t,this},_multByPoint:function(t){return this.x*=t.x,this.y*=t.y,this},_divByPoint:function(t){return this.x/=t.x,this.y/=t.y,this},_unit:function(){return this._div(this.mag()),this},_perp:function(){var t=this.y;return this.y=this.x,this.x=-t,this},_rotate:function(t){var e=Math.cos(t),r=Math.sin(t),n=r*this.x+e*this.y;return this.x=e*this.x-r*this.y,this.y=n,this},_rotateAround:function(t,e){var r=Math.cos(t),n=Math.sin(t),i=e.y+n*(this.x-e.x)+r*(this.y-e.y);return this.x=e.x+r*(this.x-e.x)-n*(this.y-e.y),this.y=i,this},_round:function(){return this.x=Math.round(this.x),this.y=Math.round(this.y),this}},y.convert=function(t){return t instanceof y?t:Array.isArray(t)?new y(t[0],t[1]):t};var g=h(m);const x=Math.PI/180,v=180/Math.PI;function b(t){return t*x}function _(t){return t*v}const w=[[0,0],[1,0],[1,1],[0,1]];function M(t){if(t<=0)return 0;if(t>=1)return 1;const e=t*t,r=e*t;return 4*(t<.5?r:3*(t-e)+r-.75)}function A(t,e,r,n){const i=new d(t,e,r,n);return function(t){return i.solve(t)}}const S=A(.25,.1,.25,1);function I(t,e,r){return Math.min(r,Math.max(e,t))}function k(t,e,r){return (r=I((r-t)/(e-t),0,1))*r*(3-2*r)}function P(t,e,r){const n=r-e,i=((t-e)%n+n)%n+e;return i===e?r:i}function E(t,e,r){if(!t.length)return r(null,[]);let n=t.length;const i=new Array(t.length);let a=null;t.forEach(((t,s)=>{e(t,((t,e)=>{t&&(a=t),i[s]=e,0==--n&&r(a,i);}));}));}function z(t,...e){for(const r of e)for(const e in r)t[e]=r[e];return t}let T=1;function B(){return T++}function C(){return function t(e){return e?(e^Math.random()*(16>>e/4)).toString(16):([1e7]+-[1e3]+-4e3+-8e3+-1e11).replace(/[018]/g,t)}()}function R(t){return t<=1?1:Math.pow(2,Math.ceil(Math.log(t)/Math.LN2))}function D(t){return !!t&&/^[0-9a-f]{8}-[0-9a-f]{4}-[4][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}$/i.test(t)}function V(t,e){t.forEach((t=>{e[t]&&(e[t]=e[t].bind(e));}));}function L(t,e){return -1!==t.indexOf(e,t.length-e.length)}function F(t,e,r){const n={};for(const i in t)n[i]=e.call(r||this,t[i],i,t);return n}function N(t,e,r){const n={};for(const i in t)e.call(r||this,t[i],i,t)&&(n[i]=t[i]);return n}function O(t){return Array.isArray(t)?t.map(O):"object"==typeof t&&t?F(t,O):t}const U={};function j(t){U[t]||("undefined"!=typeof console&&console.warn(t),U[t]=!0);}function q(t,e,r){return (r.y-t.y)*(e.x-t.x)>(e.y-t.y)*(r.x-t.x)}function $(t){let e=0;for(let r,n,i=0,a=t.length,s=a-1;i<a;s=i++)r=t[i],n=t[s],e+=(n.x-r.x)*(r.y+n.y);return e}function G([t,e,r]){const n=b(e+90),i=b(r);return {x:t*Math.cos(n)*Math.sin(i),y:t*Math.sin(n)*Math.sin(i),z:t*Math.cos(i),azimuthal:e,polar:r}}function Y(){return "undefined"!=typeof WorkerGlobalScope&&"undefined"!=typeof self&&self instanceof WorkerGlobalScope}function X(t){const e={};if(t.replace(/(?:^|(?:\s*\,\s*))([^\x00-\x20\(\)<>@\,;\:\\"\/\[\]\?\=\{\}\x7F]+)(?:\=(?:([^\x00-\x20\(\)<>@\,;\:\\"\/\[\]\?\=\{\}\x7F]+)|(?:\"((?:[^"\\]|\\.)*)\")))?/g,((t,r,n,i)=>{const a=n||i;return e[r]=!a||a.toLowerCase(),""})),e["max-age"]){const t=parseInt(e["max-age"],10);isNaN(t)?delete e["max-age"]:e["max-age"]=t;}return e}let Z,K,H,W,J,Q,tt=null;function et(t){try{const e=self[t];return e.setItem("_mapbox_test_",1),e.removeItem("_mapbox_test_"),!0}catch(t){return !1}}function rt(t,e){return [t[4*e],t[4*e+1],t[4*e+2],t[4*e+3]]}function nt(t,e,r,n){for(;e<r;){const i=e+r>>1;t[i]<n?e=i+1:r=i;}return e}function it(t,e,r,n){for(;e<r;){const i=e+r>>1;t[i]<=n?e=i+1:r=i;}return e}function at(){return null==Z&&(Z=self.OffscreenCanvas&&new OffscreenCanvas(1,1).getContext("2d")&&"function"==typeof self.createImageBitmap),Z}const st={now:()=>void 0!==W?W:performance.now(),setNow(t){W=t;},restoreNow(){W=void 0;},frame(t){const e=requestAnimationFrame(t);return {cancel:()=>cancelAnimationFrame(e)}},getImageData(t,e=0){const{width:r,height:n}=t;J||(J=document.createElement("canvas"));const i=J.getContext("2d",{willReadFrequently:!0});if(!i)throw new Error("failed to create canvas 2d context");return (r>J.width||n>J.height)&&(J.width=r,J.height=n),i.clearRect(-e,-e,r+2*e,n+2*e),i.drawImage(t,0,0,r,n),i.getImageData(-e,-e,r+2*e,n+2*e)},resolveURL:t=>(K||(K=document.createElement("a")),K.href=t,K.href),get devicePixelRatio(){return window.devicePixelRatio},get prefersReducedMotion(){return !!window.matchMedia&&(null==H&&(H=window.matchMedia("(prefers-reduced-motion: reduce)")),H.matches)},hasCanvasFingerprintNoise(){if(void 0!==Q)return Q;if(!at())return Q=!1,!1;const t=new OffscreenCanvas(85,1),e=t.getContext("2d",{willReadFrequently:!0});let r=0;for(let n=0;n<t.width;++n)e.fillStyle=`rgba(${r++},${r++},${r++}, 255)`,e.fillRect(n,0,1,1);const n=e.getImageData(0,0,t.width,t.height);r=0;for(let t=0;t<n.data.length;++t)if(t%4!=3&&r++!==n.data[t])return Q=!0,!0;return Q=!1,!1}},ot="mapbox-tiles";let lt=500,ut=50;let ct,ht;function pt(){try{return caches}catch(t){}}function ft(){const t=pt();t&&!ct&&(ct=t.open(ot));}function dt(t){const e=t.indexOf("?");if(e<0)return t;const r=["language","worldview"],n=new URLSearchParams,i=new URLSearchParams(t.slice(e));for(const t of r){const e=i.get(t);e&&n.set(t,e);}return `${t.slice(0,e)}?${n.toString()}`}function mt(t,e){const r=t.indexOf("?");if(r<0)return `${t}?${new URLSearchParams(e).toString()}`;const n=new URLSearchParams(t.slice(r));for(const t in e)n.set(t,e[t]);return `${t.slice(0,r)}?${n.toString()}`}let yt=1/0;const gt={supported:!1,testSupport:function(t){!bt&&vt&&(_t?Mt(t):xt=t);}};let xt,vt,bt=!1,_t=!1;const wt="undefined"!=typeof self?self:{};function Mt(t){const e=t.createTexture();t.bindTexture(t.TEXTURE_2D,e);try{if(t.texImage2D(t.TEXTURE_2D,0,t.RGBA,t.RGBA,t.UNSIGNED_BYTE,vt),t.isContextLost())return;gt.supported=!0;}catch(t){}t.deleteTexture(e),bt=!0;}wt.document&&(vt=wt.document.createElement("img"),vt.onload=function(){xt&&Mt(xt),xt=null,_t=!0;},vt.onerror=function(){bt=!0,xt=null;},vt.src="data:image/webp;base64,UklGRh4AAABXRUJQVlA4TBEAAAAvAQAAAAfQ//73v/+BiOh/AAA=");const At={Unknown:"Unknown",Style:"Style",Source:"Source",Tile:"Tile",Glyphs:"Glyphs",SpriteImage:"SpriteImage",SpriteJSON:"SpriteJSON",Image:"Image",Model:"Model"};"function"==typeof Object.freeze&&Object.freeze(At);class St extends Error{constructor(t,e,r){401===e&&i(r)&&(t+=": you may have provided an invalid Mapbox access token. See https://docs.mapbox.com/api/overview/#access-tokens-and-token-scopes"),super(t),this.status=e,this.url=r;}toString(){return `${this.name}: ${this.message} (${this.status}): ${this.url}`}}const It=Y()?()=>self.worker&&self.worker.referrer:()=>("blob:"===location.protocol?parent:self).location.href;const kt=function(t,e){if(!(/^file:/.test(r=t.url)||/^file:/.test(It())&&!/^\w+:/.test(r))){if(self.fetch&&self.Request&&self.AbortController&&Request.prototype.hasOwnProperty("signal"))return function(t,e){const r=new AbortController,n=new Request(t.url,{method:t.method||"GET",body:t.body,credentials:t.credentials,headers:t.headers,referrer:It(),referrerPolicy:t.referrerPolicy,signal:r.signal});let a=!1,s=!1;const o=(l=n.url).indexOf("sku=")>0&&i(l);var l;"json"===t.type&&n.headers.set("Accept","application/json");const u=(r,i,a)=>{if(s)return;if(r&&"SecurityError"!==r.message&&j(r.toString()),i&&a)return c(i);const l=Date.now();fetch(n).then((r=>{if(r.ok){const t=o?r.clone():null;return c(r,t,l)}return e(new St(r.statusText,r.status,t.url))})).catch((r=>{"AbortError"!==r.name&&e(new Error(`${r.message} ${t.url}`));}));},c=(r,i,o)=>{("arrayBuffer"===t.type?r.arrayBuffer():"json"===t.type?r.json():r.text()).then((t=>{s||(i&&o&&function(t,e,r){if(ft(),!ct)return;const n=X(e.headers.get("Cache-Control")||"");if(n["no-store"])return;const i={status:e.status,statusText:e.statusText,headers:new Headers};e.headers.forEach(((t,e)=>i.headers.set(e,t))),n["max-age"]&&i.headers.set("Expires",new Date(r+1e3*n["max-age"]).toUTCString());const a=i.headers.get("Expires");if(!a)return;if(new Date(a).getTime()-r<42e4)return;let s=dt(t.url);if(206===e.status){const e=t.headers.get("Range");if(!e)return;i.status=200,s=mt(s,{range:e});}!function(t,e){if(void 0===ht)try{new Response(new ReadableStream),ht=!0;}catch(t){ht=!1;}ht?e(t.body):t.blob().then(e);}(e,(t=>{const e=new Response(t,i);ft(),ct&&ct.then((t=>t.put(s,e))).catch((t=>j(t.message)));}));}(n,i,o),a=!0,e(null,t,r.headers.get("Cache-Control"),r.headers.get("Expires")));})).catch((t=>{s||e(new Error(t.message));}));};return o?function(t,e){if(ft(),!ct)return e(null);ct.then((r=>{let n=dt(t.url);const i=t.headers.get("Range");i&&(n=mt(n,{range:i})),r.match(n).then((t=>{const i=function(t){if(!t)return !1;const e=new Date(t.headers.get("Expires")||0),r=X(t.headers.get("Cache-Control")||"");return e>Date.now()&&!r["no-cache"]}(t);r.delete(n),i&&r.put(n,t.clone()),e(null,t,i);})).catch(e);})).catch(e);}(n,u):u(null,null),{cancel:()=>{s=!0,a||r.abort();}}}(t,e);if(Y()&&self.worker&&self.worker.actor)return self.worker.actor.send("getResource",t,e,void 0,!0)}var r;return function(t,e){const r=new XMLHttpRequest;r.open(t.method||"GET",t.url,!0),"arrayBuffer"===t.type&&(r.responseType="arraybuffer");for(const e in t.headers)r.setRequestHeader(e,t.headers[e]);return "json"===t.type&&(r.responseType="text",r.setRequestHeader("Accept","application/json")),r.withCredentials="include"===t.credentials,r.onerror=()=>{e(new Error(r.statusText));},r.onload=()=>{if((r.status>=200&&r.status<300||0===r.status)&&null!==r.response){let n=r.response;if("json"===t.type)try{n=JSON.parse(r.response);}catch(t){return e(t)}e(null,n,r.getResponseHeader("Cache-Control"),r.getResponseHeader("Expires"));}else e(new St(r.statusText,r.status,t.url));},r.send(t.body),{cancel:()=>r.abort()}}(t,e)},Pt=function(t,e){return kt(z(t,{type:"arrayBuffer"}),e)};function Et(t){const e=document.createElement("a");return e.href=t,e.protocol===location.protocol&&e.host===location.host}const zt="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAAC0lEQVQYV2NgAAIAAAUAAarVyFEAAAAASUVORK5CYII=";let Tt,Bt;Tt=[],Bt=0;const Ct=function(t,e){if(gt.supported&&(t.headers||(t.headers={}),t.headers.accept="image/webp,*/*"),Bt>=n.MAX_PARALLEL_IMAGE_REQUESTS){const r={requestParameters:t,callback:e,cancelled:!1,cancel(){this.cancelled=!0;}};return Tt.push(r),r}Bt++;let r=!1;const i=()=>{if(!r)for(r=!0,Bt--;Tt.length&&Bt<n.MAX_PARALLEL_IMAGE_REQUESTS;){const t=Tt.shift(),{requestParameters:e,callback:r,cancelled:n}=t;n||(t.cancel=Ct(e,r).cancel);}},a=Pt(t,((t,r,n,a)=>{i(),t?e(t):r&&(self.createImageBitmap?function(t,e){const r=new Blob([new Uint8Array(t)],{type:"image/png"});createImageBitmap(r).then((t=>{e(null,t);})).catch((t=>{e(new Error(`Could not load image because of ${t.message}. Please make sure to use a supported image type such as PNG or JPEG. Note that SVGs are not supported.`));}));}(r,((t,r)=>e(t,r,n,a))):function(t,e){const r=new Image;r.onload=()=>{e(null,r),URL.revokeObjectURL(r.src),r.onload=null,requestAnimationFrame((()=>{r.src=zt;}));},r.onerror=()=>e(new Error("Could not load image. Please make sure to use a supported image type such as PNG or JPEG. Note that SVGs are not supported."));const n=new Blob([new Uint8Array(t)],{type:"image/png"});r.src=t.byteLength?URL.createObjectURL(n):zt;}(r,((t,r)=>e(t,r,n,a))));}));return {cancel:()=>{a.cancel(),i();}}},Rt="01",Dt="NO_ACCESS_TOKEN",Vt=/^(\w+):\/\/([^/?]*)(\/[^?]+)?\??(.+)?/;function Lt(t){const e=t.match(Vt);if(!e)throw new Error("Unable to parse URL object");return {protocol:e[1],authority:e[2],path:e[3]||"/",params:e[4]?e[4].split("&"):[]}}function Ft(t){const e=t.params.length?`?${t.params.join("&")}`:"";return `${t.protocol}://${t.authority}${t.path}${e}`}const Nt="mapbox.eventData";function Ot(t){if(!t)return null;const e=t.split(".");if(!e||3!==e.length)return null;try{return JSON.parse(decodeURIComponent(atob(e[1]).split("").map((t=>"%"+("00"+t.charCodeAt(0).toString(16)).slice(-2))).join("")))}catch(t){return null}}class Ut{constructor(t){this.type=t,this.anonId=null,this.eventData={},this.queue=[],this.pendingRequest=null;}getStorageKey(t){const e=Ot(n.ACCESS_TOKEN);let r="";return r=e&&e.u?btoa(encodeURIComponent(e.u).replace(/%([0-9A-F]{2})/g,((t,e)=>String.fromCharCode(Number("0x"+e))))):n.ACCESS_TOKEN||"",t?`${Nt}.${t}:${r}`:`${Nt}:${r}`}fetchEventData(){const t=et("localStorage"),e=this.getStorageKey(),r=this.getStorageKey("uuid");if(t)try{const t=localStorage.getItem(e);t&&(this.eventData=JSON.parse(t));const n=localStorage.getItem(r);n&&(this.anonId=n);}catch(t){j("Unable to read from LocalStorage");}}saveEventData(){const t=et("localStorage"),e=this.getStorageKey(),r=this.getStorageKey("uuid"),n=this.anonId;if(t&&n)try{localStorage.setItem(r,n),Object.keys(this.eventData).length>=1&&localStorage.setItem(e,JSON.stringify(this.eventData));}catch(t){j("Unable to write to LocalStorage");}}processRequests(t){}postEvent(t,e,r,i){if(!n.EVENTS_URL)return;const a=Lt(n.EVENTS_URL);a.params.push(`access_token=${i||n.ACCESS_TOKEN||""}`);const s={event:this.type,created:new Date(t).toISOString()},o=e?z(s,e):s,l={url:Ft(a),headers:{"Content-Type":"text/plain"},body:JSON.stringify([o])};this.pendingRequest=function(t,e){return kt(z(t,{method:"POST"}),e)}(l,(t=>{this.pendingRequest=null,r(t),this.saveEventData(),this.processRequests(i);}));}queueRequest(t,e){this.queue.push(t),this.processRequests(e);}}const jt=new class extends Ut{constructor(t){super("appUserTurnstile"),this._customAccessToken=t;}postTurnstileEvent(t,e){n.EVENTS_URL&&n.ACCESS_TOKEN&&Array.isArray(t)&&t.some((t=>a(t)||i(t)))&&this.queueRequest(Date.now(),e);}processRequests(t){if(this.pendingRequest||0===this.queue.length)return;this.anonId&&this.eventData.lastSuccess&&this.eventData.tokenU||this.fetchEventData();const r=Ot(n.ACCESS_TOKEN),i=r?r.u:n.ACCESS_TOKEN;let a=i!==this.eventData.tokenU;D(this.anonId)||(this.anonId=C(),a=!0);const s=this.queue.shift();if(this.eventData.lastSuccess){const t=new Date(this.eventData.lastSuccess),e=new Date(s),r=(s-this.eventData.lastSuccess)/864e5;a=a||r>=1||r<-1||t.getDate()!==e.getDate();}else a=!0;a?this.postEvent(s,{sdkIdentifier:"mapbox-gl-js",sdkVersion:e,skuId:Rt,"enabled.telemetry":!1,userId:this.anonId},(t=>{t||(this.eventData.lastSuccess=s,this.eventData.tokenU=i);}),t):this.processRequests();}},qt=jt.postTurnstileEvent.bind(jt),$t=new class extends Ut{constructor(){super("map.load"),this.success={},this.skuToken="";}postMapLoadEvent(t,e,r,i){this.skuToken=e,this.errorCb=i,n.EVENTS_URL&&(r||n.ACCESS_TOKEN?this.queueRequest({id:t,timestamp:Date.now()},r):this.errorCb(new Error(Dt)));}processRequests(t){if(this.pendingRequest||0===this.queue.length)return;const{id:r,timestamp:n}=this.queue.shift();r&&this.success[r]||(this.anonId||this.fetchEventData(),D(this.anonId)||(this.anonId=C()),this.postEvent(n,{sdkIdentifier:"mapbox-gl-js",sdkVersion:e,skuId:Rt,skuToken:this.skuToken,userId:this.anonId},(t=>{t?this.errorCb(t):r&&(this.success[r]=!0);}),t));}remove(){this.errorCb=null;}},Gt=$t.postMapLoadEvent.bind($t),Yt=new class extends Ut{constructor(){super("gljs.performance");}postPerformanceEvent(t,e){n.EVENTS_URL&&(t||n.ACCESS_TOKEN)&&this.queueRequest({timestamp:Date.now(),performanceData:e},t);}processRequests(t){if(this.pendingRequest||0===this.queue.length)return;const{timestamp:r,performanceData:n}=this.queue.shift(),i=function(t){const r=performance.getEntriesByType("resource"),n=performance.getEntriesByType("mark"),i=function(t){const e={};if(t)for(const r in t)if("other"!==r)for(const n of t[r]){const t=`${r}ResolveRangeMin`,i=`${r}ResolveRangeMax`,a=`${r}RequestCount`,s=`${r}RequestCachedCount`;e[t]=Math.min(e[t]||1/0,n.startTime),e[i]=Math.max(e[i]||-1/0,n.responseEnd);const o=t=>{void 0===e[t]&&(e[t]=0),++e[t];};void 0!==n.transferSize&&0===n.transferSize&&o(s),o(a);}return e}(function(t,e){const r={};if(t)for(const n of t){const t=e(n);void 0===r[t]&&(r[t]=[]),r[t].push(n);}return r}(r,c)),a=window.devicePixelRatio,s=navigator.connection||navigator.mozConnection||navigator.webkitConnection,o=s?s.effectiveType:void 0,h={counters:[],metadata:[],attributes:[]},p=(t,e,r)=>{null!=r&&t.push({name:e,value:r.toString()});};for(const t in i)p(h.counters,t,i[t]);if(t.interactionRange[0]!==1/0&&t.interactionRange[1]!==-1/0&&(p(h.counters,"interactionRangeMin",t.interactionRange[0]),p(h.counters,"interactionRangeMax",t.interactionRange[1])),n)for(const t of Object.keys(u)){const e=u[t],r=n.find((t=>t.name===e));r&&p(h.counters,e,r.startTime);}return p(h.counters,"visibilityHidden",t.visibilityHidden),p(h.attributes,"style",function(t){if(t)for(const e of t){const t=e.name.split("?")[0];if(l(t)){const e=t.split("/").slice(-2);if(2===e.length)return `mapbox://styles/${e[0]}/${e[1]}`}}}(r)),p(h.attributes,"terrainEnabled",t.terrainEnabled?"true":"false"),p(h.attributes,"fogEnabled",t.fogEnabled?"true":"false"),p(h.attributes,"projection",t.projection),p(h.attributes,"zoom",t.zoom),p(h.metadata,"devicePixelRatio",a),p(h.metadata,"connectionEffectiveType",o),p(h.metadata,"navigatorUserAgent",navigator.userAgent),p(h.metadata,"screenWidth",window.screen.width),p(h.metadata,"screenHeight",window.screen.height),p(h.metadata,"windowWidth",window.innerWidth),p(h.metadata,"windowHeight",window.innerHeight),p(h.metadata,"mapWidth",t.width/a),p(h.metadata,"mapHeight",t.height/a),p(h.metadata,"webglRenderer",t.renderer),p(h.metadata,"webglVendor",t.vendor),p(h.metadata,"sdkVersion",e),p(h.metadata,"sdkIdentifier","mapbox-gl-js"),h}(n);for(const t of i.metadata);for(const t of i.counters);for(const t of i.attributes);this.postEvent(r,i,(()=>{}),t);}},Xt=Yt.postPerformanceEvent.bind(Yt),Zt=new class extends Ut{constructor(){super("map.auth"),this.success={},this.skuToken="";}getSession(t,e,r,i){if(!n.API_URL||!n.SESSION_PATH)return;const a=Lt(n.API_URL+n.SESSION_PATH);a.params.push(`sku=${e||""}`),a.params.push(`access_token=${i||n.ACCESS_TOKEN||""}`);const s={url:Ft(a),headers:{"Content-Type":"text/plain"}};this.pendingRequest=function(t,e){return kt(z(t,{method:"GET"}),e)}(s,(t=>{this.pendingRequest=null,r(t),this.saveEventData(),this.processRequests(i);}));}getSessionAPI(t,e,r,i){this.skuToken=e,this.errorCb=i,n.SESSION_PATH&&n.API_URL&&(r||n.ACCESS_TOKEN?this.queueRequest({id:t,timestamp:Date.now()},r):this.errorCb(new Error(Dt)));}processRequests(t){if(this.pendingRequest||0===this.queue.length)return;const{id:e,timestamp:r}=this.queue.shift();e&&this.success[e]||this.getSession(r,this.skuToken,(t=>{t?this.errorCb(t):e&&(this.success[e]=!0);}),t);}remove(){this.errorCb=null;}},Kt=Zt.getSessionAPI.bind(Zt),Ht=new Set;function Wt(t,e,r){r[t]&&-1!==r[t].indexOf(e)||(r[t]=r[t]||[],r[t].push(e));}function Jt(t,e,r){if(r&&r[t]){const n=r[t].indexOf(e);-1!==n&&r[t].splice(n,1);}}class Qt{constructor(t,e={}){z(this,e),this.type=t;}}class te extends Qt{constructor(t,e={}){super("error",z({error:t},e));}}class ee{on(t,e){return this._listeners=this._listeners||{},Wt(t,e,this._listeners),this}off(t,e){return Jt(t,e,this._listeners),Jt(t,e,this._oneTimeListeners),this}once(t,e){return e?(this._oneTimeListeners=this._oneTimeListeners||{},Wt(t,e,this._oneTimeListeners),this):new Promise((e=>this.once(t,e)))}fire(t,e){"string"==typeof t&&(t=new Qt(t,e||{}));const r=t.type;if(this.listens(r)){t.target=this;const e=this._listeners&&this._listeners[r]?this._listeners[r].slice():[];for(const r of e)r.call(this,t);const n=this._oneTimeListeners&&this._oneTimeListeners[r]?this._oneTimeListeners[r].slice():[];for(const e of n)Jt(r,e,this._oneTimeListeners),e.call(this,t);const i=this._eventedParent;i&&(z(t,"function"==typeof this._eventedParentData?this._eventedParentData():this._eventedParentData),i.fire(t));}else t instanceof te&&console.error(t.error);return this}listens(t){return !!(this._listeners&&this._listeners[t]&&this._listeners[t].length>0||this._oneTimeListeners&&this._oneTimeListeners[t]&&this._oneTimeListeners[t].length>0||this._eventedParent&&this._eventedParent.listens(t))}setEventedParent(t,e){return this._eventedParent=t,this._eventedParentData=e,this}}t.y=void 0;var re={transparent:[0,0,0,0],aliceblue:[240,248,255,1],antiquewhite:[250,235,215,1],aqua:[0,255,255,1],aquamarine:[127,255,212,1],azure:[240,255,255,1],beige:[245,245,220,1],bisque:[255,228,196,1],black:[0,0,0,1],blanchedalmond:[255,235,205,1],blue:[0,0,255,1],blueviolet:[138,43,226,1],brown:[165,42,42,1],burlywood:[222,184,135,1],cadetblue:[95,158,160,1],chartreuse:[127,255,0,1],chocolate:[210,105,30,1],coral:[255,127,80,1],cornflowerblue:[100,149,237,1],cornsilk:[255,248,220,1],crimson:[220,20,60,1],cyan:[0,255,255,1],darkblue:[0,0,139,1],darkcyan:[0,139,139,1],darkgoldenrod:[184,134,11,1],darkgray:[169,169,169,1],darkgreen:[0,100,0,1],darkgrey:[169,169,169,1],darkkhaki:[189,183,107,1],darkmagenta:[139,0,139,1],darkolivegreen:[85,107,47,1],darkorange:[255,140,0,1],darkorchid:[153,50,204,1],darkred:[139,0,0,1],darksalmon:[233,150,122,1],darkseagreen:[143,188,143,1],darkslateblue:[72,61,139,1],darkslategray:[47,79,79,1],darkslategrey:[47,79,79,1],darkturquoise:[0,206,209,1],darkviolet:[148,0,211,1],deeppink:[255,20,147,1],deepskyblue:[0,191,255,1],dimgray:[105,105,105,1],dimgrey:[105,105,105,1],dodgerblue:[30,144,255,1],firebrick:[178,34,34,1],floralwhite:[255,250,240,1],forestgreen:[34,139,34,1],fuchsia:[255,0,255,1],gainsboro:[220,220,220,1],ghostwhite:[248,248,255,1],gold:[255,215,0,1],goldenrod:[218,165,32,1],gray:[128,128,128,1],green:[0,128,0,1],greenyellow:[173,255,47,1],grey:[128,128,128,1],honeydew:[240,255,240,1],hotpink:[255,105,180,1],indianred:[205,92,92,1],indigo:[75,0,130,1],ivory:[255,255,240,1],khaki:[240,230,140,1],lavender:[230,230,250,1],lavenderblush:[255,240,245,1],lawngreen:[124,252,0,1],lemonchiffon:[255,250,205,1],lightblue:[173,216,230,1],lightcoral:[240,128,128,1],lightcyan:[224,255,255,1],lightgoldenrodyellow:[250,250,210,1],lightgray:[211,211,211,1],lightgreen:[144,238,144,1],lightgrey:[211,211,211,1],lightpink:[255,182,193,1],lightsalmon:[255,160,122,1],lightseagreen:[32,178,170,1],lightskyblue:[135,206,250,1],lightslategray:[119,136,153,1],lightslategrey:[119,136,153,1],lightsteelblue:[176,196,222,1],lightyellow:[255,255,224,1],lime:[0,255,0,1],limegreen:[50,205,50,1],linen:[250,240,230,1],magenta:[255,0,255,1],maroon:[128,0,0,1],mediumaquamarine:[102,205,170,1],mediumblue:[0,0,205,1],mediumorchid:[186,85,211,1],mediumpurple:[147,112,219,1],mediumseagreen:[60,179,113,1],mediumslateblue:[123,104,238,1],mediumspringgreen:[0,250,154,1],mediumturquoise:[72,209,204,1],mediumvioletred:[199,21,133,1],midnightblue:[25,25,112,1],mintcream:[245,255,250,1],mistyrose:[255,228,225,1],moccasin:[255,228,181,1],navajowhite:[255,222,173,1],navy:[0,0,128,1],oldlace:[253,245,230,1],olive:[128,128,0,1],olivedrab:[107,142,35,1],orange:[255,165,0,1],orangered:[255,69,0,1],orchid:[218,112,214,1],palegoldenrod:[238,232,170,1],palegreen:[152,251,152,1],paleturquoise:[175,238,238,1],palevioletred:[219,112,147,1],papayawhip:[255,239,213,1],peachpuff:[255,218,185,1],peru:[205,133,63,1],pink:[255,192,203,1],plum:[221,160,221,1],powderblue:[176,224,230,1],purple:[128,0,128,1],rebeccapurple:[102,51,153,1],red:[255,0,0,1],rosybrown:[188,143,143,1],royalblue:[65,105,225,1],saddlebrown:[139,69,19,1],salmon:[250,128,114,1],sandybrown:[244,164,96,1],seagreen:[46,139,87,1],seashell:[255,245,238,1],sienna:[160,82,45,1],silver:[192,192,192,1],skyblue:[135,206,235,1],slateblue:[106,90,205,1],slategray:[112,128,144,1],slategrey:[112,128,144,1],snow:[255,250,250,1],springgreen:[0,255,127,1],steelblue:[70,130,180,1],tan:[210,180,140,1],teal:[0,128,128,1],thistle:[216,191,216,1],tomato:[255,99,71,1],turquoise:[64,224,208,1],violet:[238,130,238,1],wheat:[245,222,179,1],white:[255,255,255,1],whitesmoke:[245,245,245,1],yellow:[255,255,0,1],yellowgreen:[154,205,50,1]};function ne(t){return (t=Math.round(t))<0?0:t>255?255:t}function ie(t){return ne("%"===t[t.length-1]?parseFloat(t)/100*255:parseInt(t))}function ae(t){return (e="%"===t[t.length-1]?parseFloat(t)/100:parseFloat(t))<0?0:e>1?1:e;var e;}function se(t,e,r){return r<0?r+=1:r>1&&(r-=1),6*r<1?t+(e-t)*r*6:2*r<1?e:3*r<2?t+(e-t)*(2/3-r)*6:t}try{t.y={}.parseCSSColor=function(t){var e,r=t.replace(/ /g,"").toLowerCase();if(r in re)return re[r].slice();if("#"===r[0])return 4===r.length?(e=parseInt(r.substr(1),16))>=0&&e<=4095?[(3840&e)>>4|(3840&e)>>8,240&e|(240&e)>>4,15&e|(15&e)<<4,1]:null:7===r.length&&(e=parseInt(r.substr(1),16))>=0&&e<=16777215?[(16711680&e)>>16,(65280&e)>>8,255&e,1]:null;var n=r.indexOf("("),i=r.indexOf(")");if(-1!==n&&i+1===r.length){var a=r.substr(0,n),s=r.substr(n+1,i-(n+1)).split(","),o=1;switch(a){case"rgba":if(4!==s.length)return null;o=ae(s.pop());case"rgb":return 3!==s.length?null:[ie(s[0]),ie(s[1]),ie(s[2]),o];case"hsla":if(4!==s.length)return null;o=ae(s.pop());case"hsl":if(3!==s.length)return null;var l=(parseFloat(s[0])%360+360)%360/360,u=ae(s[1]),c=ae(s[2]),h=c<=.5?c*(u+1):c+u-c*u,p=2*c-h;return [ne(255*se(p,h,l+1/3)),ne(255*se(p,h,l)),ne(255*se(p,h,l-1/3)),o];default:return null}}return null};}catch(t){}class oe{constructor(t,e,r,n=1){this.r=t,this.g=e,this.b=r,this.a=n;}static parse(e){if(!e)return;if(e instanceof oe)return e;if("string"!=typeof e)return;const r=t.y(e);return r?new oe(r[0]/255*r[3],r[1]/255*r[3],r[2]/255*r[3],r[3]):void 0}toString(){const[t,e,r,n]=this.toArray();return `rgba(${Math.round(t)},${Math.round(e)},${Math.round(r)},${n})`}toArray(){const{r:t,g:e,b:r,a:n}=this;return 0===n?[0,0,0,0]:[255*t/n,255*e/n,255*r/n,n]}toArray01(){const{r:t,g:e,b:r,a:n}=this;return 0===n?[0,0,0,0]:[t/n,e/n,r/n,n]}toArray01Scaled(t){const{r:e,g:r,b:n,a:i}=this;return 0===i?[0,0,0]:[e/i*t,r/i*t,n/i*t]}toArray01PremultipliedAlpha(){const{r:t,g:e,b:r,a:n}=this;return [t,e,r,n]}toArray01Linear(){const{r:t,g:e,b:r,a:n}=this;return 0===n?[0,0,0,0]:[Math.pow(t/n,2.2),Math.pow(e/n,2.2),Math.pow(r/n,2.2),n]}}oe.black=new oe(0,0,0,1),oe.white=new oe(1,1,1,1),oe.transparent=new oe(0,0,0,0),oe.red=new oe(1,0,0,1),oe.blue=new oe(0,0,1,1);var le=oe;function ue(t,e,r){return t*(1-r)+e*r}function ce(t,e,r){return t.map(((t,n)=>ue(t,e[n],r)))}var he=Object.freeze({__proto__:null,array:ce,color:function(t,e,r){return new le(ue(t.r,e.r,r),ue(t.g,e.g,r),ue(t.b,e.b,r),ue(t.a,e.a,r))},number:ue});function pe(t,...e){for(const r of e)for(const e in r)t[e]=r[e];return t}class fe extends Error{constructor(t,e){super(e),this.message=e,this.key=t;}}var de=fe;class me{constructor(t,e=[]){this.parent=t,this.bindings={};for(const[t,r]of e)this.bindings[t]=r;}concat(t){return new me(this,t)}get(t){if(this.bindings[t])return this.bindings[t];if(this.parent)return this.parent.get(t);throw new Error(`${t} not found in scope.`)}has(t){return !!this.bindings[t]||!!this.parent&&this.parent.has(t)}}var ye=me;const ge={kind:"null"},xe={kind:"number"},ve={kind:"string"},be={kind:"boolean"},_e={kind:"color"},we={kind:"object"},Me={kind:"value"},Ae={kind:"collator"},Se={kind:"formatted"},Ie={kind:"resolvedImage"};function ke(t,e){return {kind:"array",itemType:t,N:e}}function Pe(t){if("array"===t.kind){const e=Pe(t.itemType);return "number"==typeof t.N?`array<${e}, ${t.N}>`:"value"===t.itemType.kind?"array":`array<${e}>`}return t.kind}const Ee=[ge,xe,ve,be,_e,Se,we,ke(Me),Ie];function ze(t,e){if("error"===e.kind)return null;if("array"===t.kind){if("array"===e.kind&&(0===e.N&&"value"===e.itemType.kind||!ze(t.itemType,e.itemType))&&("number"!=typeof t.N||t.N===e.N))return null}else {if(t.kind===e.kind)return null;if("value"===t.kind)for(const t of Ee)if(!ze(t,e))return null}return `Expected ${Pe(t)} but found ${Pe(e)} instead.`}function Te(t,e){return e.some((e=>e.kind===t.kind))}function Be(t,e){return e.some((e=>"null"===e?null===t:"array"===e?Array.isArray(t):"object"===e?t&&!Array.isArray(t)&&"object"==typeof t:e===typeof t))}class Ce{constructor(t,e,r){this.sensitivity=t?e?"variant":"case":e?"accent":"base",this.locale=r,this.collator=new Intl.Collator(this.locale?this.locale:[],{sensitivity:this.sensitivity,usage:"search"});}compare(t,e){return this.collator.compare(t,e)}resolvedLocale(){return new Intl.Collator(this.locale?this.locale:[]).resolvedOptions().locale}}class Re{constructor(t,e,r,n,i){this.text=t.normalize?t.normalize():t,this.image=e,this.scale=r,this.fontStack=n,this.textColor=i;}}class De{constructor(t){this.sections=t;}static fromString(t){return new De([new Re(t,null,null,null,null)])}isEmpty(){return 0===this.sections.length||!this.sections.some((t=>0!==t.text.length||t.image&&0!==t.image.namePrimary.length))}static factory(t){return t instanceof De?t:De.fromString(t)}toString(){return 0===this.sections.length?"":this.sections.map((t=>t.text)).join("")}serialize(){const t=["format"];for(const e of this.sections){if(e.image){t.push(["image",e.image.namePrimary]);continue}t.push(e.text);const r={};e.fontStack&&(r["text-font"]=["literal",e.fontStack.split(",")]),e.scale&&(r["font-scale"]=e.scale),e.textColor&&(r["text-color"]=["rgba"].concat(e.textColor.toArray())),t.push(r);}return t}}class Ve{constructor(t){this.namePrimary=t.namePrimary,t.nameSecondary&&(this.nameSecondary=t.nameSecondary),this.available=t.available;}toString(){return this.nameSecondary?`[${this.namePrimary},${this.nameSecondary}]`:this.namePrimary}static fromString(t,e){return t?new Ve({namePrimary:t,nameSecondary:e,available:!1}):null}serialize(){return this.nameSecondary?["image",this.namePrimary,this.nameSecondary]:["image",this.namePrimary]}}function Le(t,e,r,n){return "number"==typeof t&&t>=0&&t<=255&&"number"==typeof e&&e>=0&&e<=255&&"number"==typeof r&&r>=0&&r<=255?void 0===n||"number"==typeof n&&n>=0&&n<=1?null:`Invalid rgba value [${[t,e,r,n].join(", ")}]: 'a' must be between 0 and 1.`:`Invalid rgba value [${("number"==typeof n?[t,e,r,n]:[t,e,r]).join(", ")}]: 'r', 'g', and 'b' must be between 0 and 255.`}function Fe(t){if(null===t)return !0;if("string"==typeof t)return !0;if("boolean"==typeof t)return !0;if("number"==typeof t)return !0;if(t instanceof le)return !0;if(t instanceof Ce)return !0;if(t instanceof De)return !0;if(t instanceof Ve)return !0;if(Array.isArray(t)){for(const e of t)if(!Fe(e))return !1;return !0}if("object"==typeof t){for(const e in t)if(!Fe(t[e]))return !1;return !0}return !1}function Ne(t){if(null===t)return ge;if("string"==typeof t)return ve;if("boolean"==typeof t)return be;if("number"==typeof t)return xe;if(t instanceof le)return _e;if(t instanceof Ce)return Ae;if(t instanceof De)return Se;if(t instanceof Ve)return Ie;if(Array.isArray(t)){const e=t.length;let r;for(const e of t){const t=Ne(e);if(r){if(r===t)continue;r=Me;break}r=t;}return ke(r||Me,e)}return we}function Oe(t){const e=typeof t;return null===t?"":"string"===e||"number"===e||"boolean"===e?String(t):t instanceof le||t instanceof De||t instanceof Ve?t.toString():JSON.stringify(t)}class Ue{constructor(t,e){this.type=t,this.value=e;}static parse(t,e){if(2!==t.length)return e.error(`'literal' expression requires exactly one argument, but found ${t.length-1} instead.`);if(!Fe(t[1]))return e.error("invalid value");const r=t[1];let n=Ne(r);const i=e.expectedType;return "array"!==n.kind||0!==n.N||!i||"array"!==i.kind||"number"==typeof i.N&&0!==i.N||(n=i),new Ue(n,r)}evaluate(){return this.value}eachChild(){}outputDefined(){return !0}serialize(){return "array"===this.type.kind||"object"===this.type.kind?["literal",this.value]:this.value instanceof le?["rgba"].concat(this.value.toArray()):this.value instanceof De?this.value.serialize():this.value}}var je=Ue,qe=class{constructor(t){this.name="ExpressionEvaluationError",this.message=t;}toJSON(){return this.message}};const $e={string:ve,number:xe,boolean:be,object:we};class Ge{constructor(t,e){this.type=t,this.args=e;}static parse(t,e){if(t.length<2)return e.error("Expected at least one argument.");let r,n=1;const i=t[0];if("array"===i){let i,a;if(t.length>2){const r=t[1];if("string"!=typeof r||!(r in $e)||"object"===r)return e.error('The item type argument of "array" must be one of string, number, boolean',1);i=$e[r],n++;}else i=Me;if(t.length>3){if(null!==t[2]&&("number"!=typeof t[2]||t[2]<0||t[2]!==Math.floor(t[2])))return e.error('The length argument to "array" must be a positive integer literal',2);a=t[2],n++;}r=ke(i,a);}else r=$e[i];const a=[];for(;n<t.length;n++){const r=e.parse(t[n],n,Me);if(!r)return null;a.push(r);}return new Ge(r,a)}evaluate(t){for(let e=0;e<this.args.length;e++){const r=this.args[e].evaluate(t);if(!ze(this.type,Ne(r)))return r;if(e===this.args.length-1)throw new qe(`Expected value to be of type ${Pe(this.type)}, but found ${Pe(Ne(r))} instead.`)}return null}eachChild(t){this.args.forEach(t);}outputDefined(){return this.args.every((t=>t.outputDefined()))}serialize(){const t=this.type,e=[t.kind];if("array"===t.kind){const r=t.itemType;if("string"===r.kind||"number"===r.kind||"boolean"===r.kind){e.push(r.kind);const n=t.N;("number"==typeof n||this.args.length>1)&&e.push(n);}}return e.concat(this.args.map((t=>t.serialize())))}}var Ye=Ge;class Xe{constructor(t){this.type=Se,this.sections=t;}static parse(t,e){if(t.length<2)return e.error("Expected at least one argument.");const r=t[1];if(!Array.isArray(r)&&"object"==typeof r)return e.error("First argument must be an image or text section.");const n=[];let i=!1;for(let r=1;r<=t.length-1;++r){const a=t[r];if(i&&"object"==typeof a&&!Array.isArray(a)){i=!1;let t=null;if(a["font-scale"]&&(t=e.parse(a["font-scale"],1,xe),!t))return null;let r=null;if(a["text-font"]&&(r=e.parse(a["text-font"],1,ke(ve)),!r))return null;let s=null;if(a["text-color"]&&(s=e.parse(a["text-color"],1,_e),!s))return null;const o=n[n.length-1];o.scale=t,o.font=r,o.textColor=s;}else {const a=e.parse(t[r],1,Me);if(!a)return null;const s=a.type.kind;if("string"!==s&&"value"!==s&&"null"!==s&&"resolvedImage"!==s)return e.error("Formatted text type must be 'string', 'value', 'image' or 'null'.");i=!0,n.push({content:a,scale:null,font:null,textColor:null});}}return new Xe(n)}evaluate(t){return new De(this.sections.map((e=>{const r=e.content.evaluate(t);return Ne(r)===Ie?new Re("",r,null,null,null):new Re(Oe(r),null,e.scale?e.scale.evaluate(t):null,e.font?e.font.evaluate(t).join(","):null,e.textColor?e.textColor.evaluate(t):null)})))}eachChild(t){for(const e of this.sections)t(e.content),e.scale&&t(e.scale),e.font&&t(e.font),e.textColor&&t(e.textColor);}outputDefined(){return !1}serialize(){const t=["format"];for(const e of this.sections){t.push(e.content.serialize());const r={};e.scale&&(r["font-scale"]=e.scale.serialize()),e.font&&(r["text-font"]=e.font.serialize()),e.textColor&&(r["text-color"]=e.textColor.serialize()),t.push(r);}return t}}class Ze{constructor(t,e){this.type=Ie,this.inputPrimary=t,this.inputSecondary=e;}static parse(t,e){if(t.length<2)return e.error("Expected two or more arguments.");const r=e.parse(t[1],1,ve);if(!r)return e.error("No image name provided.");if(2===t.length)return new Ze(r);const n=e.parse(t[2],1,ve);return n?new Ze(r,n):e.error("Secondary image variant is not a string.")}evaluate(t){const e=Ve.fromString(this.inputPrimary.evaluate(t),this.inputSecondary?this.inputSecondary.evaluate(t):void 0);return e&&t.availableImages&&(e.available=t.availableImages.indexOf(e.namePrimary)>-1,e.nameSecondary&&e.available&&t.availableImages&&(e.available=t.availableImages.indexOf(e.nameSecondary)>-1)),e}eachChild(t){t(this.inputPrimary),this.inputSecondary&&t(this.inputSecondary);}outputDefined(){return !1}serialize(){return this.inputSecondary?["image",this.inputPrimary.serialize(),this.inputSecondary.serialize()]:["image",this.inputPrimary.serialize()]}}function Ke(t){return t instanceof Number?"number":t instanceof String?"string":t instanceof Boolean?"boolean":Array.isArray(t)?"array":null===t?"null":typeof t}const He={"to-boolean":be,"to-color":_e,"to-number":xe,"to-string":ve};class We{constructor(t,e){this.type=t,this.args=e;}static parse(t,e){if(t.length<2)return e.error("Expected at least one argument.");const r=t[0],n=[];let i=ge;if("to-array"===r){if(!Array.isArray(t[1]))return null;const r=t[1].length;if(e.expectedType){if("array"!==e.expectedType.kind)return e.error(`Expected ${e.expectedType.kind} but found array.`);i=ke(e.expectedType.itemType,r);}else {if(!(r>0&&Fe(t[1][0])))return null;i=ke(Ne(t[1][0]),r);}for(let a=0;a<r;a++){const r=t[1][a];let s;if("array"===Ke(r))s=e.parse(r,void 0,i.itemType);else {const t=Ke(r);if(t!==i.itemType.kind)return e.error(`Expected ${i.itemType.kind} but found ${t}.`);s=e.registry.literal.parse(["literal",void 0===r?null:r],e);}if(!s)return null;n.push(s);}}else {if(("to-boolean"===r||"to-string"===r)&&2!==t.length)return e.error("Expected one argument.");i=He[r];for(let r=1;r<t.length;r++){const i=e.parse(t[r],r,Me);if(!i)return null;n.push(i);}}return new We(i,n)}evaluate(t){if("boolean"===this.type.kind)return Boolean(this.args[0].evaluate(t));if("color"===this.type.kind){let e,r;for(const n of this.args){if(e=n.evaluate(t),r=null,e instanceof le)return e;if("string"==typeof e){const r=t.parseColor(e);if(r)return r}else if(Array.isArray(e)&&(r=e.length<3||e.length>4?`Invalid rbga value ${JSON.stringify(e)}: expected an array containing either three or four numeric values.`:Le(e[0],e[1],e[2],e[3]),!r))return new le(e[0]/255,e[1]/255,e[2]/255,e[3])}throw new qe(r||`Could not parse color from value '${"string"==typeof e?e:String(JSON.stringify(e))}'`)}if("number"===this.type.kind){let e=null;for(const r of this.args){if(e=r.evaluate(t),null===e)return 0;const n=Number(e);if(!isNaN(n))return n}throw new qe(`Could not convert ${JSON.stringify(e)} to number.`)}return "formatted"===this.type.kind?De.fromString(Oe(this.args[0].evaluate(t))):"resolvedImage"===this.type.kind?Ve.fromString(Oe(this.args[0].evaluate(t))):"array"===this.type.kind?this.args.map((e=>e.evaluate(t))):Oe(this.args[0].evaluate(t))}eachChild(t){this.args.forEach(t);}outputDefined(){return this.args.every((t=>t.outputDefined()))}serialize(){if("formatted"===this.type.kind)return new Xe([{content:this.args[0],scale:null,font:null,textColor:null}]).serialize();if("resolvedImage"===this.type.kind)return new Ze(this.args[0]).serialize();const t="array"===this.type.kind?[]:[`to-${this.type.kind}`];return this.eachChild((e=>{t.push(e.serialize());})),t}}var Je=We;const Qe=["Unknown","Point","LineString","Polygon"];var tr=class{constructor(t,e){this.globals=null,this.feature=null,this.featureState=null,this.formattedSection=null,this._parseColorCache={},this.availableImages=null,this.canonical=null,this.featureTileCoord=null,this.featureDistanceData=null,this.scope=t,this.options=e;}id(){return this.feature&&void 0!==this.feature.id?this.feature.id:null}geometryType(){return this.feature?"number"==typeof this.feature.type?Qe[this.feature.type]:this.feature.type:null}geometry(){return this.feature&&"geometry"in this.feature?this.feature.geometry:null}canonicalID(){return this.canonical}properties(){return this.feature&&this.feature.properties||{}}measureLight(t){return this.globals.brightness||0}distanceFromCenter(){if(this.featureTileCoord&&this.featureDistanceData){const t=this.featureDistanceData.center,e=this.featureDistanceData.scale,{x:r,y:n}=this.featureTileCoord;return this.featureDistanceData.bearing[0]*(r*e-t[0])+this.featureDistanceData.bearing[1]*(n*e-t[1])}return 0}parseColor(t){let e=this._parseColorCache[t];return e||(e=this._parseColorCache[t]=le.parse(t)),e}getConfig(t){return this.options?this.options.get(t):null}};class er{constructor(t,e,r,n,i){this.name=t,this.type=e,this._evaluate=r,this.args=n,this._overloadIndex=i;}evaluate(t){if(!this._evaluate){const t=er.definitions[this.name];this._evaluate=Array.isArray(t)?t[2]:t.overloads[this._overloadIndex][1];}return this._evaluate(t,this.args)}eachChild(t){this.args.forEach(t);}outputDefined(){return !1}serialize(){return [this.name].concat(this.args.map((t=>t.serialize())))}static parse(t,e){const r=t[0],n=er.definitions[r];if(!n)return e.error(`Unknown expression "${r}". If you wanted a literal array, use ["literal", [...]].`,0);const i=Array.isArray(n)?n[0]:n.type,a=Array.isArray(n)?[[n[1],n[2]]]:n.overloads,s=[];let o=null,l=-1;for(const[n,u]of a){if(Array.isArray(n)&&n.length!==t.length-1)continue;s.push(n),l++,o=new _n(e.registry,e.path,null,e.scope,void 0,e._scope,e.options);const a=[];let c=!1;for(let e=1;e<t.length;e++){const r=t[e],i=Array.isArray(n)?n[e-1]:n.type,s=o.parse(r,1+a.length,i);if(!s){c=!0;break}a.push(s);}if(!c)if(Array.isArray(n)&&n.length!==a.length)o.error(`Expected ${n.length} arguments, but found ${a.length} instead.`);else {for(let t=0;t<a.length;t++){const e=Array.isArray(n)?n[t]:n.type,r=a[t];o.concat(t+1).checkSubtype(e,r.type);}if(0===o.errors.length)return new er(r,i,u,a,l)}}if(1===s.length)e.errors.push(...o.errors);else {const r=(s.length?s:a.map((([t])=>t))).map(rr).join(" | "),n=[];for(let r=1;r<t.length;r++){const i=e.parse(t[r],1+n.length);if(!i)return null;n.push(Pe(i.type));}e.error(`Expected arguments of type ${r}, but found (${n.join(", ")}) instead.`);}return null}static register(t,e){er.definitions=e;for(const r in e)t[r]=er;}}function rr(t){return Array.isArray(t)?`(${t.map(Pe).join(", ")})`:`(${Pe(t.type)}...)`}var nr=er;class ir{constructor(t,e,r){this.type=Ae,this.locale=r,this.caseSensitive=t,this.diacriticSensitive=e;}static parse(t,e){if(2!==t.length)return e.error("Expected one argument.");const r=t[1];if("object"!=typeof r||Array.isArray(r))return e.error("Collator options argument must be an object.");const n=e.parse(void 0!==r["case-sensitive"]&&r["case-sensitive"],1,be);if(!n)return null;const i=e.parse(void 0!==r["diacritic-sensitive"]&&r["diacritic-sensitive"],1,be);if(!i)return null;let a=null;return r.locale&&(a=e.parse(r.locale,1,ve),!a)?null:new ir(n,i,a)}evaluate(t){return new Ce(this.caseSensitive.evaluate(t),this.diacriticSensitive.evaluate(t),this.locale?this.locale.evaluate(t):null)}eachChild(t){t(this.caseSensitive),t(this.diacriticSensitive),this.locale&&t(this.locale);}outputDefined(){return !1}serialize(){const t={};return t["case-sensitive"]=this.caseSensitive.serialize(),t["diacritic-sensitive"]=this.diacriticSensitive.serialize(),this.locale&&(t.locale=this.locale.serialize()),["collator",t]}}var ar={exports:{}};ar.exports=function(){function t(r,n,i,a,s){for(;a>i;){if(a-i>600){var o=a-i+1,l=n-i+1,u=Math.log(o),c=.5*Math.exp(2*u/3),h=.5*Math.sqrt(u*c*(o-c)/o)*(l-o/2<0?-1:1);t(r,n,Math.max(i,Math.floor(n-l*c/o+h)),Math.min(a,Math.floor(n+(o-l)*c/o+h)),s);}var p=r[n],f=i,d=a;for(e(r,i,n),s(r[a],p)>0&&e(r,i,a);f<d;){for(e(r,f,d),f++,d--;s(r[f],p)<0;)f++;for(;s(r[d],p)>0;)d--;}0===s(r[i],p)?e(r,i,d):e(r,++d,a),d<=n&&(i=d+1),n<=d&&(a=d-1);}}function e(t,e,r){var n=t[e];t[e]=t[r],t[r]=n;}function r(t,e){return t<e?-1:t>e?1:0}return function(e,n,i,a,s){t(e,n,i||0,a||e.length-1,s||r);}}();var sr=h(ar.exports);function or(t){let e=0;for(let r,n,i=0,a=t.length,s=a-1;i<a;s=i++)r=t[i],n=t[s],e+=(n.x-r.x)*(r.y+n.y);return e}function lr(t,e){t[0]=Math.min(t[0],e[0]),t[1]=Math.min(t[1],e[1]),t[2]=Math.max(t[2],e[0]),t[3]=Math.max(t[3],e[1]);}function ur(t,e){return !(t[0]<=e[0]||t[2]>=e[2]||t[1]<=e[1]||t[3]>=e[3])}function cr(t,e,r){const n=t[0]-e[0],i=t[1]-e[1],a=t[0]-r[0],s=t[1]-r[1];return n*s-a*i==0&&n*a<=0&&i*s<=0}function hr(t,e,r=!1){let n=!1;for(let o=0,l=e.length;o<l;o++){const l=e[o];for(let e=0,o=l.length,u=o-1;e<o;u=e++){const o=l[u],c=l[e];if(cr(t,o,c))return r;(a=o)[1]>(i=t)[1]!=(s=c)[1]>i[1]&&i[0]<(s[0]-a[0])*(i[1]-a[1])/(s[1]-a[1])+a[0]&&(n=!n);}}var i,a,s;return n}function pr(t,e,r,n){const i=n[0]-r[0],a=n[1]-r[1],s=(t[0]-r[0])*a-i*(t[1]-r[1]),o=(e[0]-r[0])*a-i*(e[1]-r[1]);return s>0&&o<0||s<0&&o>0}function fr(t,e,r,n){return 0!=(i=[n[0]-r[0],n[1]-r[1]])[0]*(a=[e[0]-t[0],e[1]-t[1]])[1]-i[1]*a[0]&&!(!pr(t,e,r,n)||!pr(r,n,t,e));var i,a;}const dr=8192;function mr(t,e){const r=(180+t[0])/360,n=(180-180/Math.PI*Math.log(Math.tan(Math.PI/4+t[1]*Math.PI/360)))/360,i=Math.pow(2,e.z);return [Math.round(r*i*dr),Math.round(n*i*dr)]}function yr(t,e){for(let r=0;r<e.length;r++)if(hr(t,e[r]))return !0;return !1}function gr(t,e,r){for(const n of r)for(let r=0,i=n.length,a=i-1;r<i;a=r++)if(fr(t,e,n[a],n[r]))return !0;return !1}function xr(t,e){for(let r=0;r<t.length;++r)if(!hr(t[r],e))return !1;for(let r=0;r<t.length-1;++r)if(gr(t[r],t[r+1],e))return !1;return !0}function vr(t,e){for(let r=0;r<e.length;r++)if(xr(t,e[r]))return !0;return !1}function br(t,e,r){const n=[];for(let i=0;i<t.length;i++){const a=[];for(let n=0;n<t[i].length;n++){const s=mr(t[i][n],r);lr(e,s),a.push(s);}n.push(a);}return n}function _r(t,e,r){const n=[];for(let i=0;i<t.length;i++){const a=br(t[i],e,r);n.push(a);}return n}function wr(t,e,r,n){if(t[0]<r[0]||t[0]>r[2]){const e=.5*n;let i=t[0]-r[0]>e?-n:r[0]-t[0]>e?n:0;0===i&&(i=t[0]-r[2]>e?-n:r[2]-t[0]>e?n:0),t[0]+=i;}lr(e,t);}function Mr(t,e,r,n){const i=Math.pow(2,n.z)*dr,a=[n.x*dr,n.y*dr],s=[];if(!t)return s;for(const n of t)for(const t of n){const n=[t.x+a[0],t.y+a[1]];wr(n,e,r,i),s.push(n);}return s}function Ar(t,e,r,n){const i=Math.pow(2,n.z)*dr,a=[n.x*dr,n.y*dr],s=[];if(!t)return s;for(const r of t){const t=[];for(const n of r){const r=[n.x+a[0],n.y+a[1]];lr(e,r),t.push(r);}s.push(t);}if(e[2]-e[0]<=i/2){(o=e)[0]=o[1]=1/0,o[2]=o[3]=-1/0;for(const t of s)for(const n of t)wr(n,e,r,i);}var o;return s}class Sr{constructor(t,e){this.type=be,this.geojson=t,this.geometries=e;}static parse(t,e){if(2!==t.length)return e.error(`'within' expression requires exactly one argument, but found ${t.length-1} instead.`);if(Fe(t[1])){const e=t[1];if("FeatureCollection"===e.type)for(let t=0;t<e.features.length;++t){const r=e.features[t].geometry.type;if("Polygon"===r||"MultiPolygon"===r)return new Sr(e,e.features[t].geometry)}else if("Feature"===e.type){const t=e.geometry.type;if("Polygon"===t||"MultiPolygon"===t)return new Sr(e,e.geometry)}else if("Polygon"===e.type||"MultiPolygon"===e.type)return new Sr(e,e)}return e.error("'within' expression requires valid geojson object that contains polygon geometry type.")}evaluate(t){if(null!=t.geometry()&&null!=t.canonicalID()){if("Point"===t.geometryType())return function(t,e){const r=[1/0,1/0,-1/0,-1/0],n=[1/0,1/0,-1/0,-1/0],i=t.canonicalID();if(!i)return !1;if("Polygon"===e.type){const a=br(e.coordinates,n,i),s=Mr(t.geometry(),r,n,i);if(!ur(r,n))return !1;for(const t of s)if(!hr(t,a))return !1}if("MultiPolygon"===e.type){const a=_r(e.coordinates,n,i),s=Mr(t.geometry(),r,n,i);if(!ur(r,n))return !1;for(const t of s)if(!yr(t,a))return !1}return !0}(t,this.geometries);if("LineString"===t.geometryType())return function(t,e){const r=[1/0,1/0,-1/0,-1/0],n=[1/0,1/0,-1/0,-1/0],i=t.canonicalID();if(!i)return !1;if("Polygon"===e.type){const a=br(e.coordinates,n,i),s=Ar(t.geometry(),r,n,i);if(!ur(r,n))return !1;for(const t of s)if(!xr(t,a))return !1}if("MultiPolygon"===e.type){const a=_r(e.coordinates,n,i),s=Ar(t.geometry(),r,n,i);if(!ur(r,n))return !1;for(const t of s)if(!vr(t,a))return !1}return !0}(t,this.geometries)}return !1}eachChild(){}outputDefined(){return !0}serialize(){return ["within",this.geojson]}}var Ir=Sr,kr={exports:{}};kr.exports=function(){var t={kilometers:1,miles:1e3/1609.344,nauticalmiles:1e3/1852,meters:1e3,metres:1e3,yards:1e3/.9144,feet:1e3/.3048,inches:1e3/.0254},e=1/298.257223563,r=e*(2-e),n=Math.PI/180,i=function(e,i){if(void 0===e)throw new Error("No latitude given.");if(i&&!t[i])throw new Error("Unknown unit "+i+". Use one of: "+Object.keys(t).join(", "));var a=6378.137*n*(i?t[i]:1),s=Math.cos(e*n),o=1/(1-r*(1-s*s)),l=Math.sqrt(o);this.kx=a*l*s,this.ky=a*l*o*(1-r);},a={units:{configurable:!0}};function s(t,e){return t[0]===e[0]&&t[1]===e[1]}function o(t,e,r){var n=l(e[0]-t[0]);return [t[0]+n*r,t[1]+(e[1]-t[1])*r]}function l(t){for(;t<-180;)t+=360;for(;t>180;)t-=360;return t}return i.fromTile=function(t,e,r){var a=Math.PI*(1-2*(t+.5)/Math.pow(2,e)),s=Math.atan(.5*(Math.exp(a)-Math.exp(-a)))/n;return new i(s,r)},a.units.get=function(){return t},i.prototype.distance=function(t,e){var r=l(t[0]-e[0])*this.kx,n=(t[1]-e[1])*this.ky;return Math.sqrt(r*r+n*n)},i.prototype.bearing=function(t,e){var r=l(e[0]-t[0])*this.kx;return Math.atan2(r,(e[1]-t[1])*this.ky)/n},i.prototype.destination=function(t,e,r){var i=r*n;return this.offset(t,Math.sin(i)*e,Math.cos(i)*e)},i.prototype.offset=function(t,e,r){return [t[0]+e/this.kx,t[1]+r/this.ky]},i.prototype.lineDistance=function(t){for(var e=0,r=0;r<t.length-1;r++)e+=this.distance(t[r],t[r+1]);return e},i.prototype.area=function(t){for(var e=0,r=0;r<t.length;r++)for(var n=t[r],i=0,a=n.length,s=a-1;i<a;s=i++)e+=l(n[i][0]-n[s][0])*(n[i][1]+n[s][1])*(r?-1:1);return Math.abs(e)/2*this.kx*this.ky},i.prototype.along=function(t,e){var r=0;if(e<=0)return t[0];for(var n=0;n<t.length-1;n++){var i=t[n],a=t[n+1],s=this.distance(i,a);if((r+=s)>e)return o(i,a,(e-(r-s))/s)}return t[t.length-1]},i.prototype.pointToSegmentDistance=function(t,e,r){var n=e[0],i=e[1],a=l(r[0]-n)*this.kx,s=(r[1]-i)*this.ky,o=0;return 0===a&&0===s||((o=(l(t[0]-n)*this.kx*a+(t[1]-i)*this.ky*s)/(a*a+s*s))>1?(n=r[0],i=r[1]):o>0&&(n+=a/this.kx*o,i+=s/this.ky*o)),a=l(t[0]-n)*this.kx,s=(t[1]-i)*this.ky,Math.sqrt(a*a+s*s)},i.prototype.pointOnLine=function(t,e){for(var r,n,i,a,s=1/0,o=0;o<t.length-1;o++){var u=t[o][0],c=t[o][1],h=l(t[o+1][0]-u)*this.kx,p=(t[o+1][1]-c)*this.ky,f=0;0===h&&0===p||((f=(l(e[0]-u)*this.kx*h+(e[1]-c)*this.ky*p)/(h*h+p*p))>1?(u=t[o+1][0],c=t[o+1][1]):f>0&&(u+=h/this.kx*f,c+=p/this.ky*f));var d=(h=l(e[0]-u)*this.kx)*h+(p=(e[1]-c)*this.ky)*p;d<s&&(s=d,r=u,n=c,i=o,a=f);}return {point:[r,n],index:i,t:Math.max(0,Math.min(1,a))}},i.prototype.lineSlice=function(t,e,r){var n=this.pointOnLine(r,t),i=this.pointOnLine(r,e);if(n.index>i.index||n.index===i.index&&n.t>i.t){var a=n;n=i,i=a;}var o=[n.point],l=n.index+1,u=i.index;!s(r[l],o[0])&&l<=u&&o.push(r[l]);for(var c=l+1;c<=u;c++)o.push(r[c]);return s(r[u],i.point)||o.push(i.point),o},i.prototype.lineSliceAlong=function(t,e,r){for(var n=0,i=[],a=0;a<r.length-1;a++){var s=r[a],l=r[a+1],u=this.distance(s,l);if((n+=u)>t&&0===i.length&&i.push(o(s,l,(t-(n-u))/u)),n>=e)return i.push(o(s,l,(e-(n-u))/u)),i;n>t&&i.push(l);}return i},i.prototype.bufferPoint=function(t,e){var r=e/this.ky,n=e/this.kx;return [t[0]-n,t[1]-r,t[0]+n,t[1]+r]},i.prototype.bufferBBox=function(t,e){var r=e/this.ky,n=e/this.kx;return [t[0]-n,t[1]-r,t[2]+n,t[3]+r]},i.prototype.insideBBox=function(t,e){return l(t[0]-e[0])>=0&&l(t[0]-e[2])<=0&&t[1]>=e[1]&&t[1]<=e[3]},Object.defineProperties(i,a),i}();var Pr=h(kr.exports),Er={exports:{}};Er.exports=function(){var t=function(t,r){if(void 0===t&&(t=[]),void 0===r&&(r=e),this.data=t,this.length=this.data.length,this.compare=r,this.length>0)for(var n=(this.length>>1)-1;n>=0;n--)this._down(n);};function e(t,e){return t<e?-1:t>e?1:0}return t.prototype.push=function(t){this.data.push(t),this.length++,this._up(this.length-1);},t.prototype.pop=function(){if(0!==this.length){var t=this.data[0],e=this.data.pop();return this.length--,this.length>0&&(this.data[0]=e,this._down(0)),t}},t.prototype.peek=function(){return this.data[0]},t.prototype._up=function(t){for(var e=this.data,r=this.compare,n=e[t];t>0;){var i=t-1>>1,a=e[i];if(r(n,a)>=0)break;e[t]=a,t=i;}e[t]=n;},t.prototype._down=function(t){for(var e=this.data,r=this.compare,n=this.length>>1,i=e[t];t<n;){var a=1+(t<<1),s=e[a],o=a+1;if(o<this.length&&r(e[o],s)<0&&(a=o,s=e[o]),r(s,i)>=0)break;e[t]=s,t=a;}e[t]=i;},t}();var zr=h(Er.exports),Tr=8192;function Br(t,e){return e.dist-t.dist}const Cr=100,Rr=50;function Dr(t){const e=[1/0,1/0,-1/0,-1/0];if(e.length!==t.length)return !1;for(let r=0;r<e.length;r++)if(e[r]!==t[r])return !1;return !0}function Vr(t){return t[1]-t[0]+1}function Lr(t,e){const r=t[1]>=t[0]&&t[1]<e;return r||console.warn("Distance Expression: Index is out of range"),r}function Fr(t,e){if(t[0]>t[1])return [null,null];const r=Vr(t);if(e){if(2===r)return [t,null];const e=Math.floor(r/2);return [[t[0],t[0]+e],[t[0]+e,t[1]]]}{if(1===r)return [t,null];const e=Math.floor(r/2)-1;return [[t[0],t[0]+e],[t[0]+e+1,t[1]]]}}function Nr(t,e){const r=[1/0,1/0,-1/0,-1/0];if(!Lr(e,t.length))return r;for(let n=e[0];n<=e[1];++n)lr(r,t[n]);return r}function Or(t){const e=[1/0,1/0,-1/0,-1/0];for(let r=0;r<t.length;++r)for(let n=0;n<t[r].length;++n)lr(e,t[r][n]);return e}function Ur(t,e,r){if(Dr(t)||Dr(e))return NaN;let n=0,i=0;return t[2]<e[0]&&(n=e[0]-t[2]),t[0]>e[2]&&(n=t[0]-e[2]),t[1]>e[3]&&(i=t[1]-e[3]),t[3]<e[1]&&(i=e[1]-t[3]),r.distance([0,0],[n,i])}function jr(t){return 360*t-180}function qr(t){return 360/Math.PI*Math.atan(Math.exp((180-360*t)*Math.PI/180))-90}function $r(t,e){const r=Math.pow(2,e.z),n=(t.y/Tr+e.y)/r;return [jr((t.x/Tr+e.x)/r),qr(n)]}function Gr(t,e){const r=[];for(let n=0;n<t.length;++n)r.push($r(t[n],e));return r}function Yr(t,e,r){const n=r.pointOnLine(e,t).point;return r.distance(t,n)}function Xr(t,e,r,n,i){const a=r.slice(n[0],n[1]+1);let s=1/0;for(let r=e[0];r<=e[1];++r)if(0===(s=Math.min(s,Yr(t[r],a,i))))return 0;return s}function Zr(t,e,r,n,i){const a=Math.min(i.pointToSegmentDistance(t,r,n),i.pointToSegmentDistance(e,r,n)),s=Math.min(i.pointToSegmentDistance(r,t,e),i.pointToSegmentDistance(n,t,e));return Math.min(a,s)}function Kr(t,e,r,n,i){if(!Lr(e,t.length)||!Lr(n,r.length))return NaN;let a=1/0;for(let s=e[0];s<e[1];++s)for(let e=n[0];e<n[1];++e){if(fr(t[s],t[s+1],r[e],r[e+1]))return 0;a=Math.min(a,Zr(t[s],t[s+1],r[e],r[e+1],i));}return a}function Hr(t,e,r,n,i){if(!Lr(e,t.length)||!Lr(n,r.length))return NaN;let a=1/0;for(let s=e[0];s<=e[1];++s)for(let e=n[0];e<=n[1];++e)if(0===(a=Math.min(a,i.distance(t[s],r[e]))))return a;return a}function Wr(t,e,r){if(hr(t,e,!0))return 0;let n=1/0;for(const i of e){const e=i.length;if(e<2)return console.warn("Distance Expression: Invalid polygon!"),NaN;if(i[0]!==i[e-1]&&0===(n=Math.min(n,r.pointToSegmentDistance(t,i[e-1],i[0]))))return n;if(0===(n=Math.min(n,Yr(t,i,r))))return n}return n}function Jr(t,e,r,n){if(!Lr(e,t.length))return NaN;for(let n=e[0];n<=e[1];++n)if(hr(t[n],r,!0))return 0;let i=1/0;for(let a=e[0];a<e[1];++a)for(const e of r)for(let r=0,s=e.length,o=s-1;r<s;o=r++){if(fr(t[a],t[a+1],e[o],e[r]))return 0;i=Math.min(i,Zr(t[a],t[a+1],e[o],e[r],n));}return i}function Qr(t,e){for(const r of t)for(let t=0;t<=r.length-1;++t)if(hr(r[t],e,!0))return !0;return !1}function tn(t,e,r,n=1/0){const i=Or(t),a=Or(e);if(n!==1/0&&Ur(i,a,r)>=n)return n;if(ur(i,a)){if(Qr(t,e))return 0}else if(Qr(e,t))return 0;let s=n;for(const n of t)for(let t=0,i=n.length,a=i-1;t<i;a=t++)for(const i of e)for(let e=0,o=i.length,l=o-1;e<o;l=e++){if(fr(n[a],n[t],i[l],i[e]))return 0;s=Math.min(s,Zr(n[a],n[t],i[l],i[e],r));}return s}function en(t,e,r,n,i,a,s){if(null===a||null===s)return;const o=Ur(Nr(n,a),Nr(i,s),r);o<e&&t.push({dist:o,range1:a,range2:s});}function rn(t,e,r,n,i=1/0){let a=Math.min(n.distance(t[0],r[0][0]),i);if(0===a)return a;const s=new zr([{dist:0,range1:[0,t.length-1],range2:[0,0]}],Br),o=e?Rr:Cr,l=Or(r);for(;s.length;){const i=s.pop();if(i.dist>=a)continue;const u=i.range1;if(Vr(u)<=o){if(!Lr(u,t.length))return NaN;if(e){const e=Jr(t,u,r,n);if(0===(a=Math.min(a,e)))return a}else for(let e=u[0];e<=u[1];++e){const i=Wr(t[e],r,n);if(0===(a=Math.min(a,i)))return a}}else {const r=Fr(u,e);if(null!==r[0]){const e=Ur(Nr(t,r[0]),l,n);e<a&&s.push({dist:e,range1:r[0],range2:[0,0]});}if(null!==r[1]){const e=Ur(Nr(t,r[1]),l,n);e<a&&s.push({dist:e,range1:r[1],range2:[0,0]});}}}return a}function nn(t,e,r,n,i,a=1/0){let s=Math.min(a,i.distance(t[0],r[0]));if(0===s)return s;const o=new zr([{dist:0,range1:[0,t.length-1],range2:[0,r.length-1]}],Br),l=e?Rr:Cr,u=n?Rr:Cr;for(;o.length;){const a=o.pop();if(a.dist>=s)continue;const c=a.range1,h=a.range2;if(Vr(c)<=l&&Vr(h)<=u){if(!Lr(c,t.length)||!Lr(h,r.length))return NaN;if(e&&n?s=Math.min(s,Kr(t,c,r,h,i)):e||n?e&&!n?s=Math.min(s,Xr(r,h,t,c,i)):!e&&n&&(s=Math.min(s,Xr(t,c,r,h,i))):s=Math.min(s,Hr(t,c,r,h,i)),0===s)return s}else {const a=Fr(c,e),l=Fr(h,n);en(o,s,i,t,r,a[0],l[0]),en(o,s,i,t,r,a[0],l[1]),en(o,s,i,t,r,a[1],l[0]),en(o,s,i,t,r,a[1],l[1]);}}return s}function an(t,e,r,n,i=1/0){let a=i;const s=Nr(t,[0,t.length-1]);for(const i of r)if(!(a!==1/0&&Ur(s,Nr(i,[0,i.length-1]),n)>=a)&&(a=Math.min(a,nn(t,e,i,!0,n,a)),0===a))return a;return a}function sn(t,e,r,n,i=1/0){let a=i;const s=Nr(t,[0,t.length-1]);for(const i of r){if(a!==1/0&&Ur(s,Or(i),n)>=a)continue;const r=rn(t,e,i,n,a);if(isNaN(r))return r;if(0===(a=Math.min(a,r)))return a}return a}function on(t){return "Point"===t||"MultiPoint"===t||"LineString"===t||"MultiLineString"===t||"Polygon"===t||"MultiPolygon"===t}class ln{constructor(t,e){this.type=xe,this.geojson=t,this.geometries=e;}static parse(t,e){if(2!==t.length)return e.error(`'distance' expression requires either one argument, but found ' ${t.length-1} instead.`);if(Fe(t[1])){const e=t[1];if("FeatureCollection"===e.type){for(let t=0;t<e.features.length;++t)if(on(e.features[t].geometry.type))return new ln(e,e.features[t].geometry)}else if("Feature"===e.type){if(on(e.geometry.type))return new ln(e,e.geometry)}else if(on(e.type))return new ln(e,e)}return e.error("'distance' expression needs to be an array with format ['Distance', GeoJSONObj].")}evaluate(t){const e=t.geometry(),r=t.canonicalID();if(null!=e&&null!=r){if("Point"===t.geometryType())return function(t,e,r){const n=[];for(const r of t)for(const t of r)n.push($r(t,e));const i=new Pr(n[0][1],"meters");return "Point"===r.type||"MultiPoint"===r.type||"LineString"===r.type?nn(n,!1,"Point"===r.type?[r.coordinates]:r.coordinates,"LineString"===r.type,i):"MultiLineString"===r.type?an(n,!1,r.coordinates,i):"Polygon"===r.type||"MultiPolygon"===r.type?sn(n,!1,"Polygon"===r.type?[r.coordinates]:r.coordinates,i):null}(e,r,this.geometries);if("LineString"===t.geometryType())return function(t,e,r){const n=[];for(const r of t){const t=[];for(const n of r)t.push($r(n,e));n.push(t);}const i=new Pr(n[0][0][1],"meters");if("Point"===r.type||"MultiPoint"===r.type||"LineString"===r.type)return an("Point"===r.type?[r.coordinates]:r.coordinates,"LineString"===r.type,n,i);if("MultiLineString"===r.type){let t=1/0;for(let e=0;e<r.coordinates.length;e++){const a=an(r.coordinates[e],!0,n,i,t);if(isNaN(a))return a;if(0===(t=Math.min(t,a)))return t}return t}if("Polygon"===r.type||"MultiPolygon"===r.type){let t=1/0;for(let e=0;e<n.length;e++){const a=sn(n[e],!0,"Polygon"===r.type?[r.coordinates]:r.coordinates,i,t);if(isNaN(a))return a;if(0===(t=Math.min(t,a)))return t}return t}return null}(e,r,this.geometries);if("Polygon"===t.geometryType())return function(t,e,r){const n=[];for(const r of function(t,e){const r=t.length;if(r<=1)return [t];const n=[];let i,a;for(let e=0;e<r;e++){const r=or(t[e]);0!==r&&(t[e].area=Math.abs(r),void 0===a&&(a=r<0),a===r<0?(i&&n.push(i),i=[t[e]]):i.push(t[e]));}return i&&n.push(i),n}(t)){const t=[];for(let n=0;n<r.length;++n)t.push(Gr(r[n],e));n.push(t);}const i=new Pr(n[0][0][0][1],"meters");if("Point"===r.type||"MultiPoint"===r.type||"LineString"===r.type)return sn("Point"===r.type?[r.coordinates]:r.coordinates,"LineString"===r.type,n,i);if("MultiLineString"===r.type){let t=1/0;for(let e=0;e<r.coordinates.length;e++){const a=sn(r.coordinates[e],!0,n,i,t);if(isNaN(a))return a;if(0===(t=Math.min(t,a)))return t}return t}return "Polygon"===r.type||"MultiPolygon"===r.type?function(t,e,r){let n=1/0;for(const i of t)for(const t of e){const e=tn(i,t,r,n);if(isNaN(e))return e;if(0===(n=Math.min(n,e)))return n}return n}("Polygon"===r.type?[r.coordinates]:r.coordinates,n,i):null}(e,r,this.geometries);console.warn("Distance Expression: currently only evaluates valid Point/LineString/Polygon geometries.");}else console.warn("Distance Expression: requirs valid feature and canonical information.");return null}eachChild(){}outputDefined(){return !0}serialize(){return ["distance",this.geojson]}}var un=ln;function cn(t,e){switch(t){case"string":return Oe(e);case"number":return +e;case"boolean":return !!e;case"color":return le.parse(e);case"formatted":return De.fromString(Oe(e));case"resolvedImage":return Ve.fromString(Oe(e))}return e}function hn(t,e,r,n){return void 0!==n&&(t=n*Math.round(t/n)),void 0!==e&&t<e&&(t=e),void 0!==r&&t>r&&(t=r),t}class pn{constructor(t,e,r){this.type=t,this.key=e,this.scope=r;}static parse(t,e){let r=e.expectedType;if(null==r&&(r=Me),t.length<2||t.length>3)return e.error("Invalid number of arguments for 'config' expression.");const n=e.parse(t[1],1);if(!(n instanceof je))return e.error("Key name of 'config' expression must be a string literal.");if(t.length>=3){const i=e.parse(t[2],2);return i instanceof je?new pn(r,Oe(n.value),Oe(i.value)):e.error("Scope of 'config' expression must be a string literal.")}return new pn(r,Oe(n.value))}evaluate(t){const e=[this.key,this.scope,t.scope].filter(Boolean).join(""),r=t.getConfig(e);if(!r)return null;const{type:n,value:i,values:a,minValue:s,maxValue:o,stepValue:l}=r,u=r.default.evaluate(t);let c=u;if(i){const e=t.scope;t.scope=(e||"").split("").slice(1).join(""),c=i.evaluate(t),t.scope=e;}return n&&(c=cn(n,c)),void 0===c||void 0===s&&void 0===o&&void 0===l||("number"==typeof c?c=hn(c,s,o,l):Array.isArray(c)&&(c=c.map((t=>"number"==typeof t?hn(t,s,o,l):t)))),void 0!==i&&void 0!==c&&a&&!a.includes(c)&&(c=u,n&&(c=cn(n,c))),(n&&n!==this.type||void 0!==c&&Ne(c)!==this.type)&&(c=cn(this.type.kind,c)),c}eachChild(){}outputDefined(){return !1}serialize(){const t=["config",this.key];return this.scope&&t.concat(this.key),t}}var fn=pn;function dn(t){if(t instanceof nr){if("get"===t.name&&1===t.args.length)return !1;if("feature-state"===t.name)return !1;if("has"===t.name&&1===t.args.length)return !1;if("properties"===t.name||"geometry-type"===t.name||"id"===t.name)return !1;if(/^filter-/.test(t.name))return !1}if(t instanceof Ir)return !1;if(t instanceof un)return !1;let e=!0;return t.eachChild((t=>{e&&!dn(t)&&(e=!1);})),e}function mn(t){if(t instanceof nr&&"feature-state"===t.name)return !1;let e=!0;return t.eachChild((t=>{e&&!mn(t)&&(e=!1);})),e}function yn(t){if(t instanceof fn)return !1;let e=!0;return t.eachChild((t=>{e&&!yn(t)&&(e=!1);})),e}function gn(t,e){if(t instanceof nr&&e.indexOf(t.name)>=0)return !1;let r=!0;return t.eachChild((t=>{r&&!gn(t,e)&&(r=!1);})),r}class xn{constructor(t,e){this.type=e.type,this.name=t,this.boundExpression=e;}static parse(t,e){if(2!==t.length||"string"!=typeof t[1])return e.error("'var' expression requires exactly one string literal argument.");const r=t[1];return e.scope.has(r)?new xn(r,e.scope.get(r)):e.error(`Unknown variable "${r}". Make sure "${r}" has been bound in an enclosing "let" expression before using it.`,1)}evaluate(t){return this.boundExpression.evaluate(t)}eachChild(){}outputDefined(){return !1}serialize(){return ["var",this.name]}}var vn=xn;class bn{constructor(t,e=[],r,n=new ye,i=[],a,s){this.registry=t,this.path=e,this.key=e.map((t=>`[${t}]`)).join(""),this.scope=n,this.errors=i,this.expectedType=r,this._scope=a,this.options=s;}parse(t,e,r,n,i={}){return e||r?this.concat(e,r,n)._parse(t,i):this._parse(t,i)}_parse(t,e){function r(t,e,r){return "assert"===r?new Ye(e,[t]):"coerce"===r?new Je(e,[t]):t}if(null!==t&&"string"!=typeof t&&"boolean"!=typeof t&&"number"!=typeof t||(t=["literal",t]),Array.isArray(t)){if(0===t.length)return this.error('Expected an array with at least one element. If you wanted a literal array, use ["literal", []].');const n="string"==typeof t[0]?this.registry[t[0]]:void 0;if(n){let i=n.parse(t,this);if(!i)return null;if(this.expectedType){const t=this.expectedType,n=i.type;if("string"!==t.kind&&"number"!==t.kind&&"boolean"!==t.kind&&"object"!==t.kind&&"array"!==t.kind||"value"!==n.kind)if("color"!==t.kind&&"formatted"!==t.kind&&"resolvedImage"!==t.kind||"value"!==n.kind&&"string"!==n.kind){if(this.checkSubtype(t,n))return null}else i=r(i,t,e.typeAnnotation||"coerce");else i=r(i,t,e.typeAnnotation||"assert");}if(!(i instanceof je)&&"resolvedImage"!==i.type.kind&&wn(i)){const t=new tr(this._scope,this.options);try{i=new je(i.type,i.evaluate(t));}catch(t){return this.error(t.message),null}}return i}return Je.parse(["to-array",t],this)}return this.error(void 0===t?"'undefined' value invalid. Use null instead.":"object"==typeof t?'Bare objects invalid. Use ["literal", {...}] instead.':`Expected an array, but found ${typeof t} instead.`)}concat(t,e,r){const n="number"==typeof t?this.path.concat(t):this.path,i=r?this.scope.concat(r):this.scope;return new bn(this.registry,n,e||null,i,this.errors,this._scope,this.options)}error(t,...e){const r=`${this.key}${e.map((t=>`[${t}]`)).join("")}`;this.errors.push(new de(r,t));}checkSubtype(t,e){const r=ze(t,e);return r&&this.error(r),r}}var _n=bn;function wn(t){if(t instanceof vn)return wn(t.boundExpression);if(t instanceof nr&&"error"===t.name)return !1;if(t instanceof ir)return !1;if(t instanceof Ir)return !1;if(t instanceof un)return !1;if(t instanceof fn)return !1;const e=t instanceof Je||t instanceof Ye;let r=!0;return t.eachChild((t=>{r=e?r&&wn(t):r&&t instanceof je;})),!!r&&dn(t)&&gn(t,["zoom","heatmap-density","line-progress","raster-value","sky-radial-progress","accumulated","is-supported-script","pitch","distance-from-center","measure-light","raster-particle-speed"])}function Mn(t,e){const r=t.length-1;let n,i,a=0,s=r,o=0;for(;a<=s;)if(o=Math.floor((a+s)/2),n=t[o],i=t[o+1],n<=e){if(o===r||e<i)return o;a=o+1;}else {if(!(n>e))throw new qe("Input is not a number.");s=o-1;}return 0}class An{constructor(t,e,r){this.type=t,this.input=e,this.labels=[],this.outputs=[];for(const[t,e]of r)this.labels.push(t),this.outputs.push(e);}static parse(t,e){if(t.length-1<4)return e.error(`Expected at least 4 arguments, but found only ${t.length-1}.`);if((t.length-1)%2!=0)return e.error("Expected an even number of arguments.");const r=e.parse(t[1],1,xe);if(!r)return null;const n=[];let i=null;e.expectedType&&"value"!==e.expectedType.kind&&(i=e.expectedType);for(let r=1;r<t.length;r+=2){const a=1===r?-1/0:t[r],s=t[r+1],o=r,l=r+1;if("number"!=typeof a)return e.error('Input/output pairs for "step" expressions must be defined using literal numeric values (not computed expressions) for the input values.',o);if(n.length&&n[n.length-1][0]>=a)return e.error('Input/output pairs for "step" expressions must be arranged with input values in strictly ascending order.',o);const u=e.parse(s,l,i);if(!u)return null;i=i||u.type,n.push([a,u]);}return new An(i,r,n)}evaluate(t){const e=this.labels,r=this.outputs;if(1===e.length)return r[0].evaluate(t);const n=this.input.evaluate(t);if(n<=e[0])return r[0].evaluate(t);const i=e.length;return n>=e[i-1]?r[i-1].evaluate(t):r[Mn(e,n)].evaluate(t)}eachChild(t){t(this.input);for(const e of this.outputs)t(e);}outputDefined(){return this.outputs.every((t=>t.outputDefined()))}serialize(){const t=["step",this.input.serialize()];for(let e=0;e<this.labels.length;e++)e>0&&t.push(this.labels[e]),t.push(this.outputs[e].serialize());return t}}var Sn=An;const In=.95047,kn=1.08883,Pn=4/29,En=6/29,zn=3*En*En,Tn=En*En*En,Bn=Math.PI/180,Cn=180/Math.PI;function Rn(t){return t>Tn?Math.pow(t,1/3):t/zn+Pn}function Dn(t){return t>En?t*t*t:zn*(t-Pn)}function Vn(t){return 255*(t<=.0031308?12.92*t:1.055*Math.pow(t,1/2.4)-.055)}function Ln(t){return (t/=255)<=.04045?t/12.92:Math.pow((t+.055)/1.055,2.4)}function Fn(t){const e=Ln(t.r),r=Ln(t.g),n=Ln(t.b),i=Rn((.4124564*e+.3575761*r+.1804375*n)/In),a=Rn((.2126729*e+.7151522*r+.072175*n)/1);return {l:116*a-16,a:500*(i-a),b:200*(a-Rn((.0193339*e+.119192*r+.9503041*n)/kn)),alpha:t.a}}function Nn(t){let e=(t.l+16)/116,r=isNaN(t.a)?e:e+t.a/500,n=isNaN(t.b)?e:e-t.b/200;return e=1*Dn(e),r=In*Dn(r),n=kn*Dn(n),new le(Vn(3.2404542*r-1.5371385*e-.4985314*n),Vn(-.969266*r+1.8760108*e+.041556*n),Vn(.0556434*r-.2040259*e+1.0572252*n),t.alpha)}function On(t,e,r){const n=e-t;return t+r*(n>180||n<-180?n-360*Math.round(n/360):n)}const Un={forward:Fn,reverse:Nn,interpolate:function(t,e,r){return {l:ue(t.l,e.l,r),a:ue(t.a,e.a,r),b:ue(t.b,e.b,r),alpha:ue(t.alpha,e.alpha,r)}}},jn={forward:function(t){const{l:e,a:r,b:n}=Fn(t),i=Math.atan2(n,r)*Cn;return {h:i<0?i+360:i,c:Math.sqrt(r*r+n*n),l:e,alpha:t.a}},reverse:function(t){const e=t.h*Bn,r=t.c;return Nn({l:t.l,a:Math.cos(e)*r,b:Math.sin(e)*r,alpha:t.alpha})},interpolate:function(t,e,r){return {h:On(t.h,e.h,r),c:ue(t.c,e.c,r),l:ue(t.l,e.l,r),alpha:ue(t.alpha,e.alpha,r)}}};var qn=Object.freeze({__proto__:null,hcl:jn,lab:Un});class $n{constructor(t,e,r,n,i){this.type=t,this.operator=e,this.interpolation=r,this.input=n,this.labels=[],this.outputs=[];for(const[t,e]of i)this.labels.push(t),this.outputs.push(e);}static interpolationFactor(t,e,r,n){let i=0;if("exponential"===t.name)i=Gn(e,t.base,r,n);else if("linear"===t.name)i=Gn(e,1,r,n);else if("cubic-bezier"===t.name){const a=t.controlPoints;i=new d(a[0],a[1],a[2],a[3]).solve(Gn(e,1,r,n));}return i}static parse(t,e){let[r,n,i,...a]=t;if(!Array.isArray(n)||0===n.length)return e.error("Expected an interpolation type expression.",1);if("linear"===n[0])n={name:"linear"};else if("exponential"===n[0]){const t=n[1];if("number"!=typeof t)return e.error("Exponential interpolation requires a numeric base.",1,1);n={name:"exponential",base:t};}else {if("cubic-bezier"!==n[0])return e.error(`Unknown interpolation type ${String(n[0])}`,1,0);{const t=n.slice(1);if(4!==t.length||t.some((t=>"number"!=typeof t||t<0||t>1)))return e.error("Cubic bezier interpolation requires four numeric arguments with values between 0 and 1.",1);n={name:"cubic-bezier",controlPoints:t};}}if(t.length-1<4)return e.error(`Expected at least 4 arguments, but found only ${t.length-1}.`);if((t.length-1)%2!=0)return e.error("Expected an even number of arguments.");if(i=e.parse(i,2,xe),!i)return null;const s=[];let o=null;"interpolate-hcl"===r||"interpolate-lab"===r?o=_e:e.expectedType&&"value"!==e.expectedType.kind&&(o=e.expectedType);for(let t=0;t<a.length;t+=2){const r=a[t],n=a[t+1],i=t+3,l=t+4;if("number"!=typeof r)return e.error('Input/output pairs for "interpolate" expressions must be defined using literal numeric values (not computed expressions) for the input values.',i);if(s.length&&s[s.length-1][0]>=r)return e.error('Input/output pairs for "interpolate" expressions must be arranged with input values in strictly ascending order.',i);const u=e.parse(n,l,o);if(!u)return null;o=o||u.type,s.push([r,u]);}return "number"===o.kind||"color"===o.kind||"array"===o.kind&&"number"===o.itemType.kind&&"number"==typeof o.N?new $n(o,r,n,i,s):e.error(`Type ${Pe(o)} is not interpolatable.`)}evaluate(t){const e=this.labels,r=this.outputs;if(1===e.length)return r[0].evaluate(t);const n=this.input.evaluate(t);if(n<=e[0])return r[0].evaluate(t);const i=e.length;if(n>=e[i-1])return r[i-1].evaluate(t);const a=Mn(e,n),s=$n.interpolationFactor(this.interpolation,n,e[a],e[a+1]),o=r[a].evaluate(t),l=r[a+1].evaluate(t);return "interpolate"===this.operator?he[this.type.kind.toLowerCase()](o,l,s):"interpolate-hcl"===this.operator?jn.reverse(jn.interpolate(jn.forward(o),jn.forward(l),s)):Un.reverse(Un.interpolate(Un.forward(o),Un.forward(l),s))}eachChild(t){t(this.input);for(const e of this.outputs)t(e);}outputDefined(){return this.outputs.every((t=>t.outputDefined()))}serialize(){let t;t="linear"===this.interpolation.name?["linear"]:"exponential"===this.interpolation.name?1===this.interpolation.base?["linear"]:["exponential",this.interpolation.base]:["cubic-bezier"].concat(this.interpolation.controlPoints);const e=[this.operator,t,this.input.serialize()];for(let t=0;t<this.labels.length;t++)e.push(this.labels[t],this.outputs[t].serialize());return e}}function Gn(t,e,r,n){const i=n-r,a=t-r;return 0===i?0:1===e?a/i:(Math.pow(e,a)-1)/(Math.pow(e,i)-1)}var Yn=$n;class Xn{constructor(t,e){this.type=t,this.args=e;}static parse(t,e){if(t.length<2)return e.error("Expectected at least one argument.");let r=null;const n=e.expectedType;n&&"value"!==n.kind&&(r=n);const i=[];for(const n of t.slice(1)){const t=e.parse(n,1+i.length,r,void 0,{typeAnnotation:"omit"});if(!t)return null;r=r||t.type,i.push(t);}const a=n&&i.some((t=>ze(n,t.type)));return new Xn(a?Me:r,i)}evaluate(t){let e,r=null,n=0;for(const i of this.args){if(n++,r=i.evaluate(t),r&&r instanceof Ve&&!r.available&&(e||(e=r),r=null,n===this.args.length))return e;if(null!==r)break}return r}eachChild(t){this.args.forEach(t);}outputDefined(){return this.args.every((t=>t.outputDefined()))}serialize(){const t=["coalesce"];return this.eachChild((e=>{t.push(e.serialize());})),t}}var Zn=Xn;class Kn{constructor(t,e){this.type=e.type,this.bindings=[].concat(t),this.result=e;}evaluate(t){return this.result.evaluate(t)}eachChild(t){for(const e of this.bindings)t(e[1]);t(this.result);}static parse(t,e){if(t.length<4)return e.error(`Expected at least 3 arguments, but found ${t.length-1} instead.`);const r=[];for(let n=1;n<t.length-1;n+=2){const i=t[n];if("string"!=typeof i)return e.error(`Expected string, but found ${typeof i} instead.`,n);if(/[^a-zA-Z0-9_]/.test(i))return e.error("Variable names must contain only alphanumeric characters or '_'.",n);const a=e.parse(t[n+1],n+1);if(!a)return null;r.push([i,a]);}const n=e.parse(t[t.length-1],t.length-1,e.expectedType,r);return n?new Kn(r,n):null}outputDefined(){return this.result.outputDefined()}serialize(){const t=["let"];for(const[e,r]of this.bindings)t.push(e,r.serialize());return t.push(this.result.serialize()),t}}var Hn=Kn;class Wn{constructor(t,e,r){this.type=t,this.index=e,this.input=r;}static parse(t,e){if(3!==t.length)return e.error(`Expected 2 arguments, but found ${t.length-1} instead.`);const r=e.parse(t[1],1,xe),n=e.parse(t[2],2,ke(e.expectedType||Me));return r&&n?new Wn(n.type.itemType,r,n):null}evaluate(t){const e=this.index.evaluate(t),r=this.input.evaluate(t);if(e<0)throw new qe(`Array index out of bounds: ${e} < 0.`);if(e>=r.length)throw new qe(`Array index out of bounds: ${e} > ${r.length-1}.`);if(e!==Math.floor(e))throw new qe(`Array index must be an integer, but found ${e} instead.`);return r[e]}eachChild(t){t(this.index),t(this.input);}outputDefined(){return !1}serialize(){return ["at",this.index.serialize(),this.input.serialize()]}}var Jn=Wn;class Qn{constructor(t,e){this.type=be,this.needle=t,this.haystack=e;}static parse(t,e){if(3!==t.length)return e.error(`Expected 2 arguments, but found ${t.length-1} instead.`);const r=e.parse(t[1],1,Me),n=e.parse(t[2],2,Me);return r&&n?Te(r.type,[be,ve,xe,ge,Me])?new Qn(r,n):e.error(`Expected first argument to be of type boolean, string, number or null, but found ${Pe(r.type)} instead`):null}evaluate(t){const e=this.needle.evaluate(t),r=this.haystack.evaluate(t);if(null==r)return !1;if(!Be(e,["boolean","string","number","null"]))throw new qe(`Expected first argument to be of type boolean, string, number or null, but found ${Pe(Ne(e))} instead.`);if(!Be(r,["string","array"]))throw new qe(`Expected second argument to be of type array or string, but found ${Pe(Ne(r))} instead.`);return r.indexOf(e)>=0}eachChild(t){t(this.needle),t(this.haystack);}outputDefined(){return !0}serialize(){return ["in",this.needle.serialize(),this.haystack.serialize()]}}var ti=Qn;class ei{constructor(t,e,r){this.type=xe,this.needle=t,this.haystack=e,this.fromIndex=r;}static parse(t,e){if(t.length<=2||t.length>=5)return e.error(`Expected 3 or 4 arguments, but found ${t.length-1} instead.`);const r=e.parse(t[1],1,Me),n=e.parse(t[2],2,Me);if(!r||!n)return null;if(!Te(r.type,[be,ve,xe,ge,Me]))return e.error(`Expected first argument to be of type boolean, string, number or null, but found ${Pe(r.type)} instead`);if(4===t.length){const i=e.parse(t[3],3,xe);return i?new ei(r,n,i):null}return new ei(r,n)}evaluate(t){const e=this.needle.evaluate(t),r=this.haystack.evaluate(t);if(!Be(e,["boolean","string","number","null"]))throw new qe(`Expected first argument to be of type boolean, string, number or null, but found ${Pe(Ne(e))} instead.`);if(!Be(r,["string","array"]))throw new qe(`Expected second argument to be of type array or string, but found ${Pe(Ne(r))} instead.`);if(this.fromIndex){const n=this.fromIndex.evaluate(t);return r.indexOf(e,n)}return r.indexOf(e)}eachChild(t){t(this.needle),t(this.haystack),this.fromIndex&&t(this.fromIndex);}outputDefined(){return !1}serialize(){if(null!=this.fromIndex&&void 0!==this.fromIndex){const t=this.fromIndex.serialize();return ["index-of",this.needle.serialize(),this.haystack.serialize(),t]}return ["index-of",this.needle.serialize(),this.haystack.serialize()]}}var ri=ei;class ni{constructor(t,e,r,n,i,a){this.inputType=t,this.type=e,this.input=r,this.cases=n,this.outputs=i,this.otherwise=a;}static parse(t,e){if(t.length<5)return e.error(`Expected at least 4 arguments, but found only ${t.length-1}.`);if(t.length%2!=1)return e.error("Expected an even number of arguments.");let r,n;e.expectedType&&"value"!==e.expectedType.kind&&(n=e.expectedType);const i={},a=[];for(let s=2;s<t.length-1;s+=2){let o=t[s];const l=t[s+1];Array.isArray(o)||(o=[o]);const u=e.concat(s);if(0===o.length)return u.error("Expected at least one branch label.");for(const t of o){if("number"!=typeof t&&"string"!=typeof t)return u.error("Branch labels must be numbers or strings.");if("number"==typeof t&&Math.abs(t)>Number.MAX_SAFE_INTEGER)return u.error(`Branch labels must be integers no larger than ${Number.MAX_SAFE_INTEGER}.`);if("number"==typeof t&&Math.floor(t)!==t)return u.error("Numeric branch labels must be integer values.");if(r){if(u.checkSubtype(r,Ne(t)))return null}else r=Ne(t);if(void 0!==i[String(t)])return u.error("Branch labels must be unique.");i[String(t)]=a.length;}const c=e.parse(l,s,n);if(!c)return null;n=n||c.type,a.push(c);}const s=e.parse(t[1],1,Me);if(!s)return null;const o=e.parse(t[t.length-1],t.length-1,n);return o?"value"!==s.type.kind&&e.concat(1).checkSubtype(r,s.type)?null:new ni(r,n,s,i,a,o):null}evaluate(t){const e=this.input.evaluate(t);return (Ne(e)===this.inputType&&this.outputs[this.cases[e]]||this.otherwise).evaluate(t)}eachChild(t){t(this.input),this.outputs.forEach(t),t(this.otherwise);}outputDefined(){return this.outputs.every((t=>t.outputDefined()))&&this.otherwise.outputDefined()}serialize(){const t=["match",this.input.serialize()],e=Object.keys(this.cases).sort(),r=[],n={};for(const t of e){const e=n[this.cases[t]];void 0===e?(n[this.cases[t]]=r.length,r.push([this.cases[t],[t]])):r[e][1].push(t);}const i=t=>"number"===this.inputType.kind?Number(t):t;for(const[e,n]of r)t.push(1===n.length?i(n[0]):n.map(i)),t.push(this.outputs[e].serialize());return t.push(this.otherwise.serialize()),t}}var ii=ni;class ai{constructor(t,e,r){this.type=t,this.branches=e,this.otherwise=r;}static parse(t,e){if(t.length<4)return e.error(`Expected at least 3 arguments, but found only ${t.length-1}.`);if(t.length%2!=0)return e.error("Expected an odd number of arguments.");let r;e.expectedType&&"value"!==e.expectedType.kind&&(r=e.expectedType);const n=[];for(let i=1;i<t.length-1;i+=2){const a=e.parse(t[i],i,be);if(!a)return null;const s=e.parse(t[i+1],i+1,r);if(!s)return null;n.push([a,s]),r=r||s.type;}const i=e.parse(t[t.length-1],t.length-1,r);return i?new ai(r,n,i):null}evaluate(t){for(const[e,r]of this.branches)if(e.evaluate(t))return r.evaluate(t);return this.otherwise.evaluate(t)}eachChild(t){for(const[e,r]of this.branches)t(e),t(r);t(this.otherwise);}outputDefined(){return this.branches.every((([t,e])=>e.outputDefined()))&&this.otherwise.outputDefined()}serialize(){const t=["case"];return this.eachChild((e=>{t.push(e.serialize());})),t}}var si=ai;class oi{constructor(t,e,r,n){this.type=t,this.input=e,this.beginIndex=r,this.endIndex=n;}static parse(t,e){if(t.length<=2||t.length>=5)return e.error(`Expected 3 or 4 arguments, but found ${t.length-1} instead.`);const r=e.parse(t[1],1,Me),n=e.parse(t[2],2,xe);if(!r||!n)return null;if(!Te(r.type,[ke(Me),ve,Me]))return e.error(`Expected first argument to be of type array or string, but found ${Pe(r.type)} instead`);if(4===t.length){const i=e.parse(t[3],3,xe);return i?new oi(r.type,r,n,i):null}return new oi(r.type,r,n)}evaluate(t){const e=this.input.evaluate(t),r=this.beginIndex.evaluate(t);if(!Be(e,["string","array"]))throw new qe(`Expected first argument to be of type array or string, but found ${Pe(Ne(e))} instead.`);if(this.endIndex){const n=this.endIndex.evaluate(t);return e.slice(r,n)}return e.slice(r)}eachChild(t){t(this.input),t(this.beginIndex),this.endIndex&&t(this.endIndex);}outputDefined(){return !1}serialize(){if(null!=this.endIndex&&void 0!==this.endIndex){const t=this.endIndex.serialize();return ["slice",this.input.serialize(),this.beginIndex.serialize(),t]}return ["slice",this.input.serialize(),this.beginIndex.serialize()]}}var li=oi;function ui(t,e){return "=="===t||"!="===t?"boolean"===e.kind||"string"===e.kind||"number"===e.kind||"null"===e.kind||"value"===e.kind:"string"===e.kind||"number"===e.kind||"value"===e.kind}function ci(t,e,r,n){return 0===n.compare(e,r)}function hi(t,e,r){const n="=="!==t&&"!="!==t;return class i{constructor(t,e,r){this.type=be,this.lhs=t,this.rhs=e,this.collator=r,this.hasUntypedArgument="value"===t.type.kind||"value"===e.type.kind;}static parse(t,e){if(3!==t.length&&4!==t.length)return e.error("Expected two or three arguments.");const r=t[0];let a=e.parse(t[1],1,Me);if(!a)return null;if(!ui(r,a.type))return e.concat(1).error(`"${r}" comparisons are not supported for type '${Pe(a.type)}'.`);let s=e.parse(t[2],2,Me);if(!s)return null;if(!ui(r,s.type))return e.concat(2).error(`"${r}" comparisons are not supported for type '${Pe(s.type)}'.`);if(a.type.kind!==s.type.kind&&"value"!==a.type.kind&&"value"!==s.type.kind)return e.error(`Cannot compare types '${Pe(a.type)}' and '${Pe(s.type)}'.`);n&&("value"===a.type.kind&&"value"!==s.type.kind?a=new Ye(s.type,[a]):"value"!==a.type.kind&&"value"===s.type.kind&&(s=new Ye(a.type,[s])));let o=null;if(4===t.length){if("string"!==a.type.kind&&"string"!==s.type.kind&&"value"!==a.type.kind&&"value"!==s.type.kind)return e.error("Cannot use collator to compare non-string types.");if(o=e.parse(t[3],3,Ae),!o)return null}return new i(a,s,o)}evaluate(i){const a=this.lhs.evaluate(i),s=this.rhs.evaluate(i);if(n&&this.hasUntypedArgument){const e=Ne(a),r=Ne(s);if(e.kind!==r.kind||"string"!==e.kind&&"number"!==e.kind)throw new qe(`Expected arguments for "${t}" to be (string, string) or (number, number), but found (${e.kind}, ${r.kind}) instead.`)}if(this.collator&&!n&&this.hasUntypedArgument){const t=Ne(a),r=Ne(s);if("string"!==t.kind||"string"!==r.kind)return e(i,a,s)}return this.collator?r(i,a,s,this.collator.evaluate(i)):e(i,a,s)}eachChild(t){t(this.lhs),t(this.rhs),this.collator&&t(this.collator);}outputDefined(){return !0}serialize(){const e=[t];return this.eachChild((t=>{e.push(t.serialize());})),e}}}const pi=hi("==",(function(t,e,r){return e===r}),ci),fi=hi("!=",(function(t,e,r){return e!==r}),(function(t,e,r,n){return !ci(0,e,r,n)})),di=hi("<",(function(t,e,r){return e<r}),(function(t,e,r,n){return n.compare(e,r)<0})),mi=hi(">",(function(t,e,r){return e>r}),(function(t,e,r,n){return n.compare(e,r)>0})),yi=hi("<=",(function(t,e,r){return e<=r}),(function(t,e,r,n){return n.compare(e,r)<=0})),gi=hi(">=",(function(t,e,r){return e>=r}),(function(t,e,r,n){return n.compare(e,r)>=0}));class xi{constructor(t,e,r,n,i,a){this.type=ve,this.number=t,this.locale=e,this.currency=r,this.unit=n,this.minFractionDigits=i,this.maxFractionDigits=a;}static parse(t,e){if(3!==t.length)return e.error("Expected two arguments.");const r=e.parse(t[1],1,xe);if(!r)return null;const n=t[2];if("object"!=typeof n||Array.isArray(n))return e.error("NumberFormat options argument must be an object.");let i=null;if(n.locale&&(i=e.parse(n.locale,1,ve),!i))return null;let a=null;if(n.currency&&(a=e.parse(n.currency,1,ve),!a))return null;let s=null;if(n.unit&&(s=e.parse(n.unit,1,ve),!s))return null;let o=null;if(n["min-fraction-digits"]&&(o=e.parse(n["min-fraction-digits"],1,xe),!o))return null;let l=null;return n["max-fraction-digits"]&&(l=e.parse(n["max-fraction-digits"],1,xe),!l)?null:new xi(r,i,a,s,o,l)}evaluate(t){return new Intl.NumberFormat(this.locale?this.locale.evaluate(t):[],{style:(this.currency?"currency":this.unit&&"unit")||"decimal",currency:this.currency?this.currency.evaluate(t):void 0,unit:this.unit?this.unit.evaluate(t):void 0,minimumFractionDigits:this.minFractionDigits?this.minFractionDigits.evaluate(t):void 0,maximumFractionDigits:this.maxFractionDigits?this.maxFractionDigits.evaluate(t):void 0}).format(this.number.evaluate(t))}eachChild(t){t(this.number),this.locale&&t(this.locale),this.currency&&t(this.currency),this.unit&&t(this.unit),this.minFractionDigits&&t(this.minFractionDigits),this.maxFractionDigits&&t(this.maxFractionDigits);}outputDefined(){return !1}serialize(){const t={};return this.locale&&(t.locale=this.locale.serialize()),this.currency&&(t.currency=this.currency.serialize()),this.unit&&(t.unit=this.unit.serialize()),this.minFractionDigits&&(t["min-fraction-digits"]=this.minFractionDigits.serialize()),this.maxFractionDigits&&(t["max-fraction-digits"]=this.maxFractionDigits.serialize()),["number-format",this.number.serialize(),t]}}class vi{constructor(t){this.type=xe,this.input=t;}static parse(t,e){if(2!==t.length)return e.error(`Expected 1 argument, but found ${t.length-1} instead.`);const r=e.parse(t[1],1);return r?"array"!==r.type.kind&&"string"!==r.type.kind&&"value"!==r.type.kind?e.error(`Expected argument of type string or array, but found ${Pe(r.type)} instead.`):new vi(r):null}evaluate(t){const e=this.input.evaluate(t);if("string"==typeof e)return e.length;if(Array.isArray(e))return e.length;throw new qe(`Expected value to be of type string or array, but found ${Pe(Ne(e))} instead.`)}eachChild(t){t(this.input);}outputDefined(){return !1}serialize(){const t=["length"];return this.eachChild((e=>{t.push(e.serialize());})),t}}function bi(t){return function(){t=1831565813+(t|=0)|0;let e=Math.imul(t^t>>>15,1|t);return e=e+Math.imul(e^e>>>7,61|e)^e,((e^e>>>14)>>>0)/4294967296}}const _i={"==":pi,"!=":fi,">":mi,"<":di,">=":gi,"<=":yi,array:Ye,at:Jn,boolean:Ye,case:si,coalesce:Zn,collator:ir,format:Xe,image:Ze,in:ti,"index-of":ri,interpolate:Yn,"interpolate-hcl":Yn,"interpolate-lab":Yn,length:vi,let:Hn,literal:je,match:ii,number:Ye,"number-format":xi,object:Ye,slice:li,step:Sn,string:Ye,"to-boolean":Je,"to-color":Je,"to-number":Je,"to-string":Je,var:vn,within:Ir,distance:un,config:fn};function wi(t,[e,r,n,i]){e=e.evaluate(t),r=r.evaluate(t),n=n.evaluate(t);const a=i?i.evaluate(t):1,s=Le(e,r,n,a);if(s)throw new qe(s);return new le(e/255*a,r/255*a,n/255*a,a)}function Mi(t,[e,r,n,i]){e=e.evaluate(t),r=r.evaluate(t),n=n.evaluate(t);const a=i?i.evaluate(t):1,s=function(t,e,r,n){return "number"==typeof t&&t>=0&&t<=360?"number"==typeof e&&e>=0&&e<=100&&"number"==typeof r&&r>=0&&r<=100?void 0===n||"number"==typeof n&&n>=0&&n<=1?null:`Invalid hsla value [${[t,e,r,n].join(", ")}]: 'a' must be between 0 and 1.`:`Invalid hsla value [${("number"==typeof n?[t,e,r,n]:[t,e,r]).join(", ")}]: 's', and 'l' must be between 0 and 100.`:`Invalid hsla value [${("number"==typeof n?[t,e,r,n]:[t,e,r]).join(", ")}]: 'h' must be between 0 and 360.`}(e,r,n,a);if(s)throw new qe(s);const o=`hsla(${e}, ${r}%, ${n}%, ${a})`,l=le.parse(o);if(!l)throw new qe(`Failed to parse HSLA color: ${o}`);return l}function Ai(t,e){return t in e}function Si(t,e){const r=e[t];return void 0===r?null:r}function Ii(t){return {type:t}}nr.register(_i,{error:[{kind:"error"},[ve],(t,[e])=>{throw new qe(e.evaluate(t))}],typeof:[ve,[Me],(t,[e])=>Pe(Ne(e.evaluate(t)))],"to-rgba":[ke(xe,4),[_e],(t,[e])=>e.evaluate(t).toArray()],rgb:[_e,[xe,xe,xe],wi],rgba:[_e,[xe,xe,xe,xe],wi],hsl:[_e,[xe,xe,xe],Mi],hsla:[_e,[xe,xe,xe,xe],Mi],has:{type:be,overloads:[[[ve],(t,[e])=>Ai(e.evaluate(t),t.properties())],[[ve,we],(t,[e,r])=>Ai(e.evaluate(t),r.evaluate(t))]]},get:{type:Me,overloads:[[[ve],(t,[e])=>Si(e.evaluate(t),t.properties())],[[ve,we],(t,[e,r])=>Si(e.evaluate(t),r.evaluate(t))]]},"feature-state":[Me,[ve],(t,[e])=>Si(e.evaluate(t),t.featureState||{})],properties:[we,[],t=>t.properties()],"geometry-type":[ve,[],t=>t.geometryType()],id:[Me,[],t=>t.id()],zoom:[xe,[],t=>t.globals.zoom],pitch:[xe,[],t=>t.globals.pitch||0],"distance-from-center":[xe,[],t=>t.distanceFromCenter()],"measure-light":[xe,[ve],(t,[e])=>t.measureLight(e.evaluate(t))],"heatmap-density":[xe,[],t=>t.globals.heatmapDensity||0],"line-progress":[xe,[],t=>t.globals.lineProgress||0],"raster-value":[xe,[],t=>t.globals.rasterValue||0],"raster-particle-speed":[xe,[],t=>t.globals.rasterParticleSpeed||0],"sky-radial-progress":[xe,[],t=>t.globals.skyRadialProgress||0],accumulated:[Me,[],t=>void 0===t.globals.accumulated?null:t.globals.accumulated],"+":[xe,Ii(xe),(t,e)=>{let r=0;for(const n of e)r+=n.evaluate(t);return r}],"*":[xe,Ii(xe),(t,e)=>{let r=1;for(const n of e)r*=n.evaluate(t);return r}],"-":{type:xe,overloads:[[[xe,xe],(t,[e,r])=>e.evaluate(t)-r.evaluate(t)],[[xe],(t,[e])=>-e.evaluate(t)]]},"/":[xe,[xe,xe],(t,[e,r])=>e.evaluate(t)/r.evaluate(t)],"%":[xe,[xe,xe],(t,[e,r])=>e.evaluate(t)%r.evaluate(t)],ln2:[xe,[],()=>Math.LN2],pi:[xe,[],()=>Math.PI],e:[xe,[],()=>Math.E],"^":[xe,[xe,xe],(t,[e,r])=>Math.pow(e.evaluate(t),r.evaluate(t))],sqrt:[xe,[xe],(t,[e])=>Math.sqrt(e.evaluate(t))],log10:[xe,[xe],(t,[e])=>Math.log(e.evaluate(t))/Math.LN10],ln:[xe,[xe],(t,[e])=>Math.log(e.evaluate(t))],log2:[xe,[xe],(t,[e])=>Math.log(e.evaluate(t))/Math.LN2],sin:[xe,[xe],(t,[e])=>Math.sin(e.evaluate(t))],cos:[xe,[xe],(t,[e])=>Math.cos(e.evaluate(t))],tan:[xe,[xe],(t,[e])=>Math.tan(e.evaluate(t))],asin:[xe,[xe],(t,[e])=>Math.asin(e.evaluate(t))],acos:[xe,[xe],(t,[e])=>Math.acos(e.evaluate(t))],atan:[xe,[xe],(t,[e])=>Math.atan(e.evaluate(t))],min:[xe,Ii(xe),(t,e)=>Math.min(...e.map((e=>e.evaluate(t))))],max:[xe,Ii(xe),(t,e)=>Math.max(...e.map((e=>e.evaluate(t))))],abs:[xe,[xe],(t,[e])=>Math.abs(e.evaluate(t))],round:[xe,[xe],(t,[e])=>{const r=e.evaluate(t);return r<0?-Math.round(-r):Math.round(r)}],floor:[xe,[xe],(t,[e])=>Math.floor(e.evaluate(t))],ceil:[xe,[xe],(t,[e])=>Math.ceil(e.evaluate(t))],"filter-==":[be,[ve,Me],(t,[e,r])=>t.properties()[e.value]===r.value],"filter-id-==":[be,[Me],(t,[e])=>t.id()===e.value],"filter-type-==":[be,[ve],(t,[e])=>t.geometryType()===e.value],"filter-<":[be,[ve,Me],(t,[e,r])=>{const n=t.properties()[e.value],i=r.value;return typeof n==typeof i&&n<i}],"filter-id-<":[be,[Me],(t,[e])=>{const r=t.id(),n=e.value;return typeof r==typeof n&&r<n}],"filter->":[be,[ve,Me],(t,[e,r])=>{const n=t.properties()[e.value],i=r.value;return typeof n==typeof i&&n>i}],"filter-id->":[be,[Me],(t,[e])=>{const r=t.id(),n=e.value;return typeof r==typeof n&&r>n}],"filter-<=":[be,[ve,Me],(t,[e,r])=>{const n=t.properties()[e.value],i=r.value;return typeof n==typeof i&&n<=i}],"filter-id-<=":[be,[Me],(t,[e])=>{const r=t.id(),n=e.value;return typeof r==typeof n&&r<=n}],"filter->=":[be,[ve,Me],(t,[e,r])=>{const n=t.properties()[e.value],i=r.value;return typeof n==typeof i&&n>=i}],"filter-id->=":[be,[Me],(t,[e])=>{const r=t.id(),n=e.value;return typeof r==typeof n&&r>=n}],"filter-has":[be,[Me],(t,[e])=>e.value in t.properties()],"filter-has-id":[be,[],t=>null!==t.id()&&void 0!==t.id()],"filter-type-in":[be,[ke(ve)],(t,[e])=>e.value.indexOf(t.geometryType())>=0],"filter-id-in":[be,[ke(Me)],(t,[e])=>e.value.indexOf(t.id())>=0],"filter-in-small":[be,[ve,ke(Me)],(t,[e,r])=>r.value.indexOf(t.properties()[e.value])>=0],"filter-in-large":[be,[ve,ke(Me)],(t,[e,r])=>function(t,e,r,n){for(;r<=n;){const i=r+n>>1;if(e[i]===t)return !0;e[i]>t?n=i-1:r=i+1;}return !1}(t.properties()[e.value],r.value,0,r.value.length-1)],all:{type:be,overloads:[[[be,be],(t,[e,r])=>e.evaluate(t)&&r.evaluate(t)],[Ii(be),(t,e)=>{for(const r of e)if(!r.evaluate(t))return !1;return !0}]]},any:{type:be,overloads:[[[be,be],(t,[e,r])=>e.evaluate(t)||r.evaluate(t)],[Ii(be),(t,e)=>{for(const r of e)if(r.evaluate(t))return !0;return !1}]]},"!":[be,[be],(t,[e])=>!e.evaluate(t)],"is-supported-script":[be,[ve],(t,[e])=>{const r=t.globals&&t.globals.isSupportedScript;return !r||r(e.evaluate(t))}],upcase:[ve,[ve],(t,[e])=>e.evaluate(t).toUpperCase()],downcase:[ve,[ve],(t,[e])=>e.evaluate(t).toLowerCase()],concat:[ve,Ii(Me),(t,e)=>e.map((e=>Oe(e.evaluate(t)))).join("")],"resolved-locale":[ve,[Ae],(t,[e])=>e.evaluate(t).resolvedLocale()],random:[xe,[xe,xe,Me],(t,e)=>{const[r,n,i]=e.map((e=>e.evaluate(t)));if(r>n)return r;if(r===n)return r;let a;if("string"==typeof i)a=function(t){let e=0;if(0===t.length)return e;for(let r=0;r<t.length;r++)e=(e<<5)-e+t.charCodeAt(r),e|=0;return e}(i);else {if("number"!=typeof i)throw new qe(`Invalid seed input: ${i}`);a=i;}return r+bi(a)()*(n-r)}]});var ki=_i;function Pi(t){return {result:"success",value:t}}function Ei(t){return {result:"error",value:t}}function zi(t,e){return !!t&&!!t.parameters&&t.parameters.indexOf(e)>-1}function Ti(t){return "data-driven"===t["property-type"]}function Bi(t){return zi(t.expression,"measure-light")}function Ci(t){return zi(t.expression,"zoom")}function Ri(t){return !!t.expression&&t.expression.interpolated}function Di(t){return "object"==typeof t&&null!==t&&!Array.isArray(t)}function Vi(t){return t}function Li(t,e){const r="color"===e.type,n=t.stops&&"object"==typeof t.stops[0][0],i=n||!(n||void 0!==t.property),a=t.type||(Ri(e)?"exponential":"interval");if(r&&((t=pe({},t)).stops&&(t.stops=t.stops.map((t=>[t[0],le.parse(t[1])]))),t.default=le.parse(t.default?t.default:e.default)),t.colorSpace&&"rgb"!==t.colorSpace&&!qn[t.colorSpace])throw new Error(`Unknown color space: ${t.colorSpace}`);let s,o,l;if("exponential"===a)s=Ui;else if("interval"===a)s=Oi;else if("categorical"===a){s=Ni,o=Object.create(null);for(const e of t.stops)o[e[0]]=e[1];l=typeof t.stops[0][0];}else {if("identity"!==a)throw new Error(`Unknown function type "${a}"`);s=ji;}if(n){const r={},n=[];for(let e=0;e<t.stops.length;e++){const i=t.stops[e],a=i[0].zoom;void 0===r[a]&&(r[a]={zoom:a,type:t.type,property:t.property,default:t.default,stops:[]},n.push(a)),r[a].stops.push([i[0].value,i[1]]);}const i=[];for(const t of n)i.push([r[t].zoom,Li(r[t],e)]);const a={name:"linear"};return {kind:"composite",interpolationType:a,interpolationFactor:Yn.interpolationFactor.bind(void 0,a),zoomStops:i.map((t=>t[0])),evaluate:({zoom:r},n)=>Ui({stops:i,base:t.base},e,r).evaluate(r,n)}}if(i){const r="exponential"===a?{name:"exponential",base:void 0!==t.base?t.base:1}:null;return {kind:"camera",interpolationType:r,interpolationFactor:Yn.interpolationFactor.bind(void 0,r),zoomStops:t.stops.map((t=>t[0])),evaluate:({zoom:r})=>s(t,e,r,o,l)}}return {kind:"source",evaluate(r,n){const i=n&&n.properties?n.properties[t.property]:void 0;return void 0===i?Fi(t.default,e.default):s(t,e,i,o,l)}}}function Fi(t,e,r){return void 0!==t?t:void 0!==e?e:void 0!==r?r:void 0}function Ni(t,e,r,n,i){return Fi(typeof r===i?n[r]:void 0,t.default,e.default)}function Oi(t,e,r){if("number"!==Ke(r))return Fi(t.default,e.default);const n=t.stops.length;if(1===n)return t.stops[0][1];if(r<=t.stops[0][0])return t.stops[0][1];if(r>=t.stops[n-1][0])return t.stops[n-1][1];const i=Mn(t.stops.map((t=>t[0])),r);return t.stops[i][1]}function Ui(t,e,r){const n=void 0!==t.base?t.base:1;if("number"!==Ke(r))return Fi(t.default,e.default);const i=t.stops.length;if(1===i)return t.stops[0][1];if(r<=t.stops[0][0])return t.stops[0][1];if(r>=t.stops[i-1][0])return t.stops[i-1][1];const a=Mn(t.stops.map((t=>t[0])),r),s=function(t,e,r,n){const i=n-r,a=t-r;return 0===i?0:1===e?a/i:(Math.pow(e,a)-1)/(Math.pow(e,i)-1)}(r,n,t.stops[a][0],t.stops[a+1][0]),o=t.stops[a][1],l=t.stops[a+1][1];let u=he[e.type]||Vi;if(t.colorSpace&&"rgb"!==t.colorSpace){const e=qn[t.colorSpace];u=(t,r)=>e.reverse(e.interpolate(e.forward(t),e.forward(r),s));}return "function"==typeof o.evaluate?{evaluate(...t){const e=o.evaluate.apply(void 0,t),r=l.evaluate.apply(void 0,t);if(void 0!==e&&void 0!==r)return u(e,r,s)}}:u(o,l,s)}function ji(t,e,r){return "color"===e.type?r=le.parse(r):"formatted"===e.type?r=De.fromString(r.toString()):"resolvedImage"===e.type?r=Ve.fromString(r.toString()):Ke(r)===e.type||"enum"===e.type&&e.values[r]||(r=void 0),Fi(r,t.default,e.default)}class qi{constructor(t,e,r,n){this.expression=t,this._warningHistory={},this._evaluator=new tr(r,n),this._defaultValue=e?function(t){return "color"===t.type&&(Di(t.default)||Array.isArray(t.default))?new le(0,0,0,0):"color"===t.type?le.parse(t.default)||null:void 0===t.default?null:t.default}(e):null,this._enumValues=e&&"enum"===e.type?e.values:null;}evaluateWithoutErrorHandling(t,e,r,n,i,a,s,o){return this._evaluator.globals=t,this._evaluator.feature=e,this._evaluator.featureState=r,this._evaluator.canonical=n||null,this._evaluator.availableImages=i||null,this._evaluator.formattedSection=a,this._evaluator.featureTileCoord=s||null,this._evaluator.featureDistanceData=o||null,this.expression.evaluate(this._evaluator)}evaluate(t,e,r,n,i,a,s,o){this._evaluator.globals=t,this._evaluator.feature=e||null,this._evaluator.featureState=r||null,this._evaluator.canonical=n||null,this._evaluator.availableImages=i||null,this._evaluator.formattedSection=a||null,this._evaluator.featureTileCoord=s||null,this._evaluator.featureDistanceData=o||null;try{const t=this.expression.evaluate(this._evaluator);if(null==t||"number"==typeof t&&t!=t)return this._defaultValue;if(this._enumValues&&!(t in this._enumValues))throw new qe(`Expected value to be one of ${Object.keys(this._enumValues).map((t=>JSON.stringify(t))).join(", ")}, but found ${JSON.stringify(t)} instead.`);return t}catch(t){return this._warningHistory[t.message]||(this._warningHistory[t.message]=!0,"undefined"!=typeof console&&console.warn(t.message)),this._defaultValue}}}function $i(t){return Array.isArray(t)&&t.length>0&&"string"==typeof t[0]&&t[0]in ki}function Gi(t,e,r,n){const i=new _n(ki,[],e?function(t){const e={color:_e,string:ve,number:xe,enum:ve,boolean:be,formatted:Se,resolvedImage:Ie};return "array"===t.type?ke(e[t.value]||Me,t.length):e[t.type]}(e):void 0,void 0,void 0,r,n),a=i.parse(t,void 0,void 0,void 0,e&&"string"===e.type?{typeAnnotation:"coerce"}:void 0);return a?Pi(new qi(a,e,r,n)):Ei(i.errors)}class Yi{constructor(t,e,r){this.kind=t,this._styleExpression=e,this.isLightConstant=r,this.isStateDependent="constant"!==t&&!mn(e.expression),this.isConfigDependent=!yn(e.expression);}evaluateWithoutErrorHandling(t,e,r,n,i,a){return this._styleExpression.evaluateWithoutErrorHandling(t,e,r,n,i,a)}evaluate(t,e,r,n,i,a){return this._styleExpression.evaluate(t,e,r,n,i,a)}}class Xi{constructor(t,e,r,n,i){this.kind=t,this.zoomStops=r,this._styleExpression=e,this.isStateDependent="camera"!==t&&!mn(e.expression),this.isLightConstant=i,this.isConfigDependent=!yn(e.expression),this.interpolationType=n;}evaluateWithoutErrorHandling(t,e,r,n,i,a){return this._styleExpression.evaluateWithoutErrorHandling(t,e,r,n,i,a)}evaluate(t,e,r,n,i,a){return this._styleExpression.evaluate(t,e,r,n,i,a)}interpolationFactor(t,e,r){return this.interpolationType?Yn.interpolationFactor(this.interpolationType,t,e,r):0}}function Zi(t,e,r,n){if("error"===(t=Gi(t,e,r,n)).result)return t;const i=t.value.expression,a=dn(i);if(!a&&!Ti(e))return Ei([new de("","data expressions not supported")]);const s=gn(i,["zoom","pitch","distance-from-center"]);if(!s&&!Ci(e))return Ei([new de("","zoom expressions not supported")]);const o=gn(i,["measure-light"]);if(!o&&!Bi(e))return Ei([new de("","measure-light expression not supported")]);const l=e.expression&&e.expression.relaxZoomRestriction,u=Hi(i);return u||s||l?u instanceof de?Ei([u]):u instanceof Yn&&!Ri(e)?Ei([new de("",'"interpolate" expressions cannot be used with this property')]):Pi(u?new Xi(a?"camera":"composite",t.value,u.labels,u instanceof Yn?u.interpolation:void 0,o):new Yi(a?"constant":"source",t.value,o)):Ei([new de("",'"zoom" expression may only be used as input to a top-level "step" or "interpolate" expression, or in the properties of atmosphere.')])}class Ki{constructor(t,e){this._parameters=t,this._specification=e,pe(this,Li(this._parameters,this._specification));}static deserialize(t){return new Ki(t._parameters,t._specification)}static serialize(t){return {_parameters:t._parameters,_specification:t._specification}}}function Hi(t){let e=null;if(t instanceof Hn)e=Hi(t.result);else if(t instanceof Zn){for(const r of t.args)if(e=Hi(r),e)break}else (t instanceof Sn||t instanceof Yn)&&t.input instanceof nr&&"zoom"===t.input.name&&(e=t);return e instanceof de||t.eachChild((t=>{const r=Hi(t);r instanceof de?e=r:e&&r&&e!==r&&(e=new de("",'Only one zoom-based "step" or "interpolate" subexpression may be used in an expression.'));})),e}var Wi=Qi,Ji=3;function Qi(t,e,r){var n=this.cells=[];if(t instanceof ArrayBuffer){this.arrayBuffer=t;var i=new Int32Array(this.arrayBuffer);t=i[0],this.d=(e=i[1])+2*(r=i[2]);for(var a=0;a<this.d*this.d;a++){var s=i[Ji+a],o=i[Ji+a+1];n.push(s===o?null:i.subarray(s,o));}var l=i[Ji+n.length+1];this.keys=i.subarray(i[Ji+n.length],l),this.bboxes=i.subarray(l),this.insert=this._insertReadonly;}else {this.d=e+2*r;for(var u=0;u<this.d*this.d;u++)n.push([]);this.keys=[],this.bboxes=[];}this.n=e,this.extent=t,this.padding=r,this.scale=e/t,this.uid=0;var c=r/e*t;this.min=-c,this.max=t+c;}Qi.prototype.insert=function(t,e,r,n,i){this._forEachCell(e,r,n,i,this._insertCell,this.uid++),this.keys.push(t),this.bboxes.push(e),this.bboxes.push(r),this.bboxes.push(n),this.bboxes.push(i);},Qi.prototype._insertReadonly=function(){throw "Cannot insert into a GridIndex created from an ArrayBuffer."},Qi.prototype._insertCell=function(t,e,r,n,i,a){this.cells[i].push(a);},Qi.prototype.query=function(t,e,r,n,i){var a=this.min,s=this.max;if(t<=a&&e<=a&&s<=r&&s<=n&&!i)return Array.prototype.slice.call(this.keys);var o=[];return this._forEachCell(t,e,r,n,this._queryCell,o,{},i),o},Qi.prototype._queryCell=function(t,e,r,n,i,a,s,o){var l=this.cells[i];if(null!==l)for(var u=this.keys,c=this.bboxes,h=0;h<l.length;h++){var p=l[h];if(void 0===s[p]){var f=4*p;(o?o(c[f+0],c[f+1],c[f+2],c[f+3]):t<=c[f+2]&&e<=c[f+3]&&r>=c[f+0]&&n>=c[f+1])?(s[p]=!0,a.push(u[p])):s[p]=!1;}}},Qi.prototype._forEachCell=function(t,e,r,n,i,a,s,o){for(var l=this._convertToCellCoord(t),u=this._convertToCellCoord(e),c=this._convertToCellCoord(r),h=this._convertToCellCoord(n),p=l;p<=c;p++)for(var f=u;f<=h;f++){var d=this.d*f+p;if((!o||o(this._convertFromCellCoord(p),this._convertFromCellCoord(f),this._convertFromCellCoord(p+1),this._convertFromCellCoord(f+1)))&&i.call(this,t,e,r,n,d,a,s,o))return}},Qi.prototype._convertFromCellCoord=function(t){return (t-this.padding)/this.scale},Qi.prototype._convertToCellCoord=function(t){return Math.max(0,Math.min(this.d-1,Math.floor(t*this.scale)+this.padding))},Qi.prototype.toArrayBuffer=function(){if(this.arrayBuffer)return this.arrayBuffer;for(var t=this.cells,e=Ji+this.cells.length+1+1,r=0,n=0;n<this.cells.length;n++)r+=this.cells[n].length;var i=new Int32Array(e+r+this.keys.length+this.bboxes.length);i[0]=this.extent,i[1]=this.n,i[2]=this.padding;for(var a=e,s=0;s<t.length;s++){var o=t[s];i[Ji+s]=a,i.set(o,a),a+=o.length;}return i[Ji+t.length]=a,i.set(this.keys,a),i[Ji+t.length+1]=a+=this.keys.length,i.set(this.bboxes,a),a+=this.bboxes.length,i.buffer};var ta=h(Wi);const ea={};function ra(t,e,r={}){Object.defineProperty(t,"_classRegistryKey",{value:e,writeable:!1}),ea[e]={klass:t,omit:r.omit||[]};}ra(Object,"Object"),ta.serialize=function(t,e){const r=t.toArrayBuffer();return e&&e.add(r),{buffer:r}},ta.deserialize=function(t){return new ta(t.buffer)},Object.defineProperty(ta,"name",{value:"Grid"}),ra(ta,"Grid"),ra(le,"Color"),ra(Error,"Error"),ra(De,"Formatted"),ra(Re,"FormattedSection"),ra(St,"AJAXError"),ra(Ve,"ResolvedImage"),ra(Ki,"StylePropertyFunction"),ra(qi,"StyleExpression",{omit:["_evaluator"]}),ra(Xi,"ZoomDependentExpression"),ra(Yi,"ZoomConstantExpression"),ra(nr,"CompoundExpression",{omit:["_evaluate"]});for(const t in ki)ea[ki[t]._classRegistryKey]||ra(ki[t],`Expression${t}`);function na(t){return t&&"undefined"!=typeof ArrayBuffer&&(t instanceof ArrayBuffer||t.constructor&&"ArrayBuffer"===t.constructor.name)}function ia(t){return self.ImageBitmap&&t instanceof ImageBitmap}function aa(t,e){if(null==t||"boolean"==typeof t||"number"==typeof t||"string"==typeof t||t instanceof Boolean||t instanceof Number||t instanceof String||t instanceof Date||t instanceof RegExp)return t;if(na(t)||ia(t))return e&&e.add(t),t;if(ArrayBuffer.isView(t)){const r=t;return e&&e.add(r.buffer),r}if(t instanceof ImageData)return e&&e.add(t.data.buffer),t;if(Array.isArray(t)){const r=[];for(const n of t)r.push(aa(n,e));return r}if(t instanceof Map){const e={$name:"Map"};for(const[r,n]of t.entries())e[r]=aa(n);return e}if("object"==typeof t){const r=t.constructor,n=r._classRegistryKey;if(!n)throw new Error(`can't serialize object of unregistered class ${n}`);const i=r.serialize?r.serialize(t,e):{};if(!r.serialize){for(const r in t)t.hasOwnProperty(r)&&(ea[n].omit.indexOf(r)>=0||(i[r]=aa(t[r],e)));t instanceof Error&&(i.message=t.message);}if(i.$name)throw new Error("$name property is reserved for worker serialization logic.");return "Object"!==n&&(i.$name=n),i}throw new Error("can't serialize object of type "+typeof t)}function sa(t){if(null==t||"boolean"==typeof t||"number"==typeof t||"string"==typeof t||t instanceof Boolean||t instanceof Number||t instanceof String||t instanceof Date||t instanceof RegExp||na(t)||ia(t)||ArrayBuffer.isView(t)||t instanceof ImageData)return t;if(Array.isArray(t))return t.map(sa);if("object"==typeof t){const e=t.$name||"Object";if("Map"===e){const e=new Map;for(const r of Object.keys(t))"$name"!==r&&e.set(r,sa(t[r]));return e}const{klass:r}=ea[e];if(!r)throw new Error(`can't deserialize unregistered class ${e}`);if(r.deserialize)return r.deserialize(t);const n=Object.create(r.prototype);for(const e of Object.keys(t))"$name"!==e&&(n[e]=sa(t[e]));return n}throw new Error("can't deserialize object of type "+typeof t)}const oa={"Latin-1 Supplement":t=>t>=128&&t<=255,Arabic:t=>t>=1536&&t<=1791,"Arabic Supplement":t=>t>=1872&&t<=1919,"Arabic Extended-A":t=>t>=2208&&t<=2303,"Hangul Jamo":t=>t>=4352&&t<=4607,"Unified Canadian Aboriginal Syllabics":t=>t>=5120&&t<=5759,Khmer:t=>t>=6016&&t<=6143,"Unified Canadian Aboriginal Syllabics Extended":t=>t>=6320&&t<=6399,"General Punctuation":t=>t>=8192&&t<=8303,"Letterlike Symbols":t=>t>=8448&&t<=8527,"Number Forms":t=>t>=8528&&t<=8591,"Miscellaneous Technical":t=>t>=8960&&t<=9215,"Control Pictures":t=>t>=9216&&t<=9279,"Optical Character Recognition":t=>t>=9280&&t<=9311,"Enclosed Alphanumerics":t=>t>=9312&&t<=9471,"Geometric Shapes":t=>t>=9632&&t<=9727,"Miscellaneous Symbols":t=>t>=9728&&t<=9983,"Miscellaneous Symbols and Arrows":t=>t>=11008&&t<=11263,"CJK Radicals Supplement":t=>t>=11904&&t<=12031,"Kangxi Radicals":t=>t>=12032&&t<=12255,"Ideographic Description Characters":t=>t>=12272&&t<=12287,"CJK Symbols and Punctuation":t=>t>=12288&&t<=12351,Hiragana:t=>t>=12352&&t<=12447,Katakana:t=>t>=12448&&t<=12543,Bopomofo:t=>t>=12544&&t<=12591,"Hangul Compatibility Jamo":t=>t>=12592&&t<=12687,Kanbun:t=>t>=12688&&t<=12703,"Bopomofo Extended":t=>t>=12704&&t<=12735,"CJK Strokes":t=>t>=12736&&t<=12783,"Katakana Phonetic Extensions":t=>t>=12784&&t<=12799,"Enclosed CJK Letters and Months":t=>t>=12800&&t<=13055,"CJK Compatibility":t=>t>=13056&&t<=13311,"CJK Unified Ideographs Extension A":t=>t>=13312&&t<=19903,"Yijing Hexagram Symbols":t=>t>=19904&&t<=19967,"CJK Unified Ideographs":t=>t>=19968&&t<=40959,"Yi Syllables":t=>t>=40960&&t<=42127,"Yi Radicals":t=>t>=42128&&t<=42191,"Hangul Jamo Extended-A":t=>t>=43360&&t<=43391,"Hangul Syllables":t=>t>=44032&&t<=55215,"Hangul Jamo Extended-B":t=>t>=55216&&t<=55295,"Private Use Area":t=>t>=57344&&t<=63743,"CJK Compatibility Ideographs":t=>t>=63744&&t<=64255,"Arabic Presentation Forms-A":t=>t>=64336&&t<=65023,"Vertical Forms":t=>t>=65040&&t<=65055,"CJK Compatibility Forms":t=>t>=65072&&t<=65103,"Small Form Variants":t=>t>=65104&&t<=65135,"Arabic Presentation Forms-B":t=>t>=65136&&t<=65279,"Halfwidth and Fullwidth Forms":t=>t>=65280&&t<=65519,"CJK Unified Ideographs Extension B":t=>t>=131072&&t<=173791};function la(t){for(const e of t)if(ha(e.charCodeAt(0)))return !0;return !1}function ua(t){for(const e of t)if(!ca(e.charCodeAt(0)))return !1;return !0}function ca(t){return !(oa.Arabic(t)||oa["Arabic Supplement"](t)||oa["Arabic Extended-A"](t)||oa["Arabic Presentation Forms-A"](t)||oa["Arabic Presentation Forms-B"](t))}function ha(t){return !(746!==t&&747!==t&&(t<4352||!(oa["Bopomofo Extended"](t)||oa.Bopomofo(t)||oa["CJK Compatibility Forms"](t)&&!(t>=65097&&t<=65103)||oa["CJK Compatibility Ideographs"](t)||oa["CJK Compatibility"](t)||oa["CJK Radicals Supplement"](t)||oa["CJK Strokes"](t)||!(!oa["CJK Symbols and Punctuation"](t)||t>=12296&&t<=12305||t>=12308&&t<=12319||12336===t)||oa["CJK Unified Ideographs Extension A"](t)||oa["CJK Unified Ideographs"](t)||oa["Enclosed CJK Letters and Months"](t)||oa["Hangul Compatibility Jamo"](t)||oa["Hangul Jamo Extended-A"](t)||oa["Hangul Jamo Extended-B"](t)||oa["Hangul Jamo"](t)||oa["Hangul Syllables"](t)||oa.Hiragana(t)||oa["Ideographic Description Characters"](t)||oa.Kanbun(t)||oa["Kangxi Radicals"](t)||oa["Katakana Phonetic Extensions"](t)||oa.Katakana(t)&&12540!==t||!(!oa["Halfwidth and Fullwidth Forms"](t)||65288===t||65289===t||65293===t||t>=65306&&t<=65310||65339===t||65341===t||65343===t||t>=65371&&t<=65503||65507===t||t>=65512&&t<=65519)||!(!oa["Small Form Variants"](t)||t>=65112&&t<=65118||t>=65123&&t<=65126)||oa["Unified Canadian Aboriginal Syllabics"](t)||oa["Unified Canadian Aboriginal Syllabics Extended"](t)||oa["Vertical Forms"](t)||oa["Yijing Hexagram Symbols"](t)||oa["Yi Syllables"](t)||oa["Yi Radicals"](t))))}function pa(t){return !(ha(t)||function(t){return !!(oa["Latin-1 Supplement"](t)&&(167===t||169===t||174===t||177===t||188===t||189===t||190===t||215===t||247===t)||oa["General Punctuation"](t)&&(8214===t||8224===t||8225===t||8240===t||8241===t||8251===t||8252===t||8258===t||8263===t||8264===t||8265===t||8273===t)||oa["Letterlike Symbols"](t)||oa["Number Forms"](t)||oa["Miscellaneous Technical"](t)&&(t>=8960&&t<=8967||t>=8972&&t<=8991||t>=8996&&t<=9e3||9003===t||t>=9085&&t<=9114||t>=9150&&t<=9165||9167===t||t>=9169&&t<=9179||t>=9186&&t<=9215)||oa["Control Pictures"](t)&&9251!==t||oa["Optical Character Recognition"](t)||oa["Enclosed Alphanumerics"](t)||oa["Geometric Shapes"](t)||oa["Miscellaneous Symbols"](t)&&!(t>=9754&&t<=9759)||oa["Miscellaneous Symbols and Arrows"](t)&&(t>=11026&&t<=11055||t>=11088&&t<=11097||t>=11192&&t<=11243)||oa["CJK Symbols and Punctuation"](t)||oa.Katakana(t)||oa["Private Use Area"](t)||oa["CJK Compatibility Forms"](t)||oa["Small Form Variants"](t)||oa["Halfwidth and Fullwidth Forms"](t)||8734===t||8756===t||8757===t||t>=9984&&t<=10087||t>=10102&&t<=10131||65532===t||65533===t)}(t))}function fa(t){return t>=1424&&t<=2303||oa["Arabic Presentation Forms-A"](t)||oa["Arabic Presentation Forms-B"](t)}function da(t,e){return !(!e&&fa(t)||t>=2304&&t<=3583||t>=3840&&t<=4255||oa.Khmer(t))}function ma(t){for(const e of t)if(fa(e.charCodeAt(0)))return !0;return !1}const ya="deferred",ga="loading",xa="loaded";let va=null,ba="unavailable",_a=null;const wa=function(t){t&&"string"==typeof t&&t.indexOf("NetworkError")>-1&&(ba="error"),va&&va(t);};function Ma(){Aa.fire(new Qt("pluginStateChange",{pluginStatus:ba,pluginURL:_a}));}const Aa=new ee,Sa=function(){return ba},Ia=function(){if(ba!==ya||!_a)throw new Error("rtl-text-plugin cannot be downloaded unless a pluginURL is specified");ba=ga,Ma(),_a&&Pt({url:_a},(t=>{t?wa(t):(ba=xa,Ma());}));},ka={applyArabicShaping:null,processBidirectionalText:null,processStyledBidirectionalText:null,isLoaded:()=>ba===xa||null!=ka.applyArabicShaping,isLoading:()=>ba===ga,setState(t){ba=t.pluginStatus,_a=t.pluginURL;},isParsed:()=>null!=ka.applyArabicShaping&&null!=ka.processBidirectionalText&&null!=ka.processStyledBidirectionalText,getPluginURL:()=>_a};class Pa{constructor(t,e){this.zoom=t,e?(this.now=e.now,this.fadeDuration=e.fadeDuration,this.transition=e.transition,this.pitch=e.pitch,this.brightness=e.brightness):(this.now=0,this.fadeDuration=0,this.transition={},this.pitch=0,this.brightness=0);}isSupportedScript(t){return function(t,e){for(const r of t)if(!da(r.charCodeAt(0),e))return !1;return !0}(t,ka.isLoaded())}}class Ea{constructor(t,e,r,n){this.property=t,this.value=e,this.expression=function(t,e,r,n){if(Di(t))return new Ki(t,e);if($i(t)||Array.isArray(t)&&t.length>0){const i=Zi(t,e,r,n);if("error"===i.result)throw new Error(i.value.map((t=>`${t.key}: ${t.message}`)).join(", "));return i.value}{let r=t;return "string"==typeof t&&"color"===e.type&&(r=le.parse(t)),{kind:"constant",isConfigDependent:!1,evaluate:()=>r}}}(void 0===e?t.specification.default:e,t.specification,r,n);}isDataDriven(){return "source"===this.expression.kind||"composite"===this.expression.kind}possiblyEvaluate(t,e,r){return this.property.possiblyEvaluate(this,t,e,r)}}class za{constructor(t,e,r){this.property=t,this.value=new Ea(t,void 0,e,r);}transitioned(t,e){return new Ba(this.property,this.value,e,z({},t.transition,this.transition),t.now)}untransitioned(){return new Ba(this.property,this.value,null,{},0)}}class Ta{constructor(t,e,r){this._properties=t,this._values=Object.create(t.defaultTransitionablePropertyValues),this._scope=e,this._options=r,this.isConfigDependent=!1;}getValue(t){return O(this._values[t].value.value)}setValue(t,e){this._values.hasOwnProperty(t)||(this._values[t]=new za(this._values[t].property,this._scope,this._options)),this._values[t].value=new Ea(this._values[t].property,null===e?void 0:O(e),this._scope,this._options),this.isConfigDependent=this.isConfigDependent||this._values[t].value.expression.isConfigDependent;}setTransitionOrValue(t,e){e&&(this._options=e);const r=this._properties.properties;if(t)for(const e in t){const n=t[e];if(L(e,"-transition")){const t=e.slice(0,-11);r[t]&&this.setTransition(t,n);}else r[e]&&this.setValue(e,n);}}getTransition(t){return O(this._values[t].transition)}setTransition(t,e){this._values.hasOwnProperty(t)||(this._values[t]=new za(this._values[t].property)),this._values[t].transition=O(e)||void 0;}serialize(){const t={};for(const e of Object.keys(this._values)){const r=this.getValue(e);void 0!==r&&(t[e]=r);const n=this.getTransition(e);void 0!==n&&(t[`${e}-transition`]=n);}return t}transitioned(t,e){const r=new Ca(this._properties);for(const n of Object.keys(this._values))r._values[n]=this._values[n].transitioned(t,e._values[n]);return r}untransitioned(){const t=new Ca(this._properties);for(const e of Object.keys(this._values))t._values[e]=this._values[e].untransitioned();return t}}class Ba{constructor(t,e,r,n,i){const a=n.delay||0,s=n.duration||0;i=i||0,this.property=t,this.value=e,this.begin=i+a,this.end=this.begin+s,t.specification.transition&&(n.delay||n.duration)&&(this.prior=r);}possiblyEvaluate(t,e,r){const n=t.now||0,i=this.value.possiblyEvaluate(t,e,r),a=this.prior;if(a){if(n>this.end)return this.prior=null,i;if(this.value.isDataDriven())return this.prior=null,i;if(n<this.begin)return a.possiblyEvaluate(t,e,r);{const s=(n-this.begin)/(this.end-this.begin);return this.property.interpolate(a.possiblyEvaluate(t,e,r),i,M(s))}}return i}}class Ca{constructor(t){this._properties=t,this._values=Object.create(t.defaultTransitioningPropertyValues);}possiblyEvaluate(t,e,r){const n=new Va(this._properties);for(const i of Object.keys(this._values))n._values[i]=this._values[i].possiblyEvaluate(t,e,r);return n}hasTransition(){for(const t of Object.keys(this._values))if(this._values[t].prior)return !0;return !1}}class Ra{constructor(t,e,r){this._properties=t,this._values=Object.create(t.defaultPropertyValues),this._scope=e,this._options=r,this.isConfigDependent=!1;}getValue(t){return O(this._values[t].value)}setValue(t,e){this._values[t]=new Ea(this._values[t].property,null===e?void 0:O(e),this._scope,this._options),this.isConfigDependent=this.isConfigDependent||this._values[t].expression.isConfigDependent;}serialize(){const t={};for(const e of Object.keys(this._values)){const r=this.getValue(e);void 0!==r&&(t[e]=r);}return t}possiblyEvaluate(t,e,r){const n=new Va(this._properties);for(const i of Object.keys(this._values))n._values[i]=this._values[i].possiblyEvaluate(t,e,r);return n}}class Da{constructor(t,e,r){this.property=t,this.value=e,this.parameters=r;}isConstant(){return "constant"===this.value.kind}constantOr(t){return "constant"===this.value.kind?this.value.value:t}evaluate(t,e,r,n){return this.property.evaluate(this.value,this.parameters,t,e,r,n)}}class Va{constructor(t){this._properties=t,this._values=Object.create(t.defaultPossiblyEvaluatedValues);}get(t){return this._values[t]}}class La{constructor(t){this.specification=t;}possiblyEvaluate(t,e){return t.expression.evaluate(e)}interpolate(t,e,r){const n=he[this.specification.type];return n?n(t,e,r):t}}class Fa{constructor(t,e){this.specification=t,this.overrides=e;}possiblyEvaluate(t,e,r,n){return new Da(this,"constant"===t.expression.kind||"camera"===t.expression.kind?{kind:"constant",value:t.expression.evaluate(e,null,{},r,n)}:t.expression,e)}interpolate(t,e,r){if("constant"!==t.value.kind||"constant"!==e.value.kind)return t;if(void 0===t.value.value||void 0===e.value.value)return new Da(this,{kind:"constant",value:void 0},t.parameters);const n=he[this.specification.type];return n?new Da(this,{kind:"constant",value:n(t.value.value,e.value.value,r)},t.parameters):t}evaluate(t,e,r,n,i,a){return "constant"===t.kind?t.value:t.evaluate(e,r,n,i,a)}}class Na{constructor(t){this.specification=t;}possiblyEvaluate(t,e,r,n){return !!t.expression.evaluate(e,null,{},r,n)}interpolate(){return !1}}class Oa{constructor(t){this.properties=t,this.defaultPropertyValues={},this.defaultTransitionablePropertyValues={},this.defaultTransitioningPropertyValues={},this.defaultPossiblyEvaluatedValues={},this.overridableProperties=[];const e=new Pa(0,{});for(const r in t){const n=t[r];n.specification.overridable&&this.overridableProperties.push(r);const i=this.defaultPropertyValues[r]=new Ea(n,void 0),a=this.defaultTransitionablePropertyValues[r]=new za(n);this.defaultTransitioningPropertyValues[r]=a.untransitioned(),this.defaultPossiblyEvaluatedValues[r]=i.possiblyEvaluate(e);}}}function Ua(t){return t instanceof Number||t instanceof String||t instanceof Boolean?t.valueOf():t}function ja(t){if(Array.isArray(t))return t.map(ja);if(t instanceof Object&&!(t instanceof Number||t instanceof String||t instanceof Boolean)){const e={};for(const r in t)e[r]=ja(t[r]);return e}return Ua(t)}ra(Fa,"DataDrivenProperty"),ra(La,"DataConstantProperty"),ra(Na,"ColorRampProperty");var qa=JSON.parse('{"$version":8,"$root":{"version":{"required":true,"type":"enum","values":[8]},"fragment":{"type":"boolean"},"name":{"type":"string"},"metadata":{"type":"*"},"center":{"type":"array","value":"number"},"zoom":{"type":"number"},"bearing":{"type":"number","default":0,"period":360},"pitch":{"type":"number","default":0},"light":{"type":"light"},"lights":{"required":false,"type":"array","value":"light-3d"},"terrain":{"type":"terrain","optional":true},"fog":{"type":"fog"},"camera":{"type":"camera"},"imports":{"type":"array","value":"import"},"schema":{"type":"schema"},"sources":{"required":true,"type":"sources"},"sprite":{"type":"string"},"glyphs":{"type":"string","default":"mapbox://fonts/mapbox/{fontstack}/{range}.pbf"},"transition":{"type":"transition"},"projection":{"type":"projection"},"layers":{"required":true,"type":"array","value":"layer"},"models":{"type":"models"}},"model":{"type":"string","required":true},"import":{"id":{"type":"string","required":true},"url":{"type":"string","required":true},"config":{"type":"config"},"data":{"type":"$root"}},"config":{"*":{"type":"*"}},"schema":{"*":{"type":"option"}},"option":{"default":{"type":"*","required":true},"type":{"type":"enum","values":{"string":1,"number":1,"boolean":1,"color":1}},"array":{"type":"boolean"},"minValue":{"type":"number"},"maxValue":{"type":"number"},"stepValue":{"type":"number"},"values":{"type":"array","value":"*"},"metadata":{"type":"*"}},"models":{"*":{"type":"model"}},"light-3d":{"id":{"type":"string","required":true},"properties":{"type":"properties"},"type":{"type":"enum","values":{"ambient":{},"directional":{},"flat":{}}}},"properties":["properties_light_directional","properties_light_ambient","properties_light_flat"],"properties_light_directional":{"direction":{"type":"array","default":[210,30],"minimum":[0,0],"maximum":[360,90],"length":2,"value":"number","property-type":"data-constant","transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"color":{"type":"color","property-type":"data-constant","default":"#ffffff","expression":{"interpolated":true,"parameters":["zoom"]},"transition":true},"intensity":{"type":"number","property-type":"data-constant","default":0.5,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true},"cast-shadows":{"type":"boolean","default":false,"expression":{},"property-type":"data-constant"},"shadow-intensity":{"type":"number","property-type":"data-constant","default":1,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true}},"properties_light_ambient":{"color":{"type":"color","property-type":"data-constant","default":"#ffffff","expression":{"interpolated":true,"parameters":["zoom"]},"transition":true},"intensity":{"type":"number","property-type":"data-constant","default":0.5,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true}},"properties_light_flat":{"anchor":{"type":"enum","default":"viewport","values":{"map":1,"viewport":1},"property-type":"data-constant","expression":{"parameters":["zoom"]}},"position":{"type":"array","default":[1.15,210,30],"length":3,"value":"number","property-type":"data-constant","transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"color":{"type":"color","property-type":"data-constant","default":"#ffffff","expression":{"interpolated":true,"parameters":["zoom"]},"transition":true},"intensity":{"type":"number","property-type":"data-constant","default":0.5,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true}},"sources":{"*":{"type":"source"}},"source":["source_vector","source_raster","source_raster_dem","source_raster_array","source_geojson","source_video","source_image","source_model"],"source_vector":{"type":{"required":true,"type":"enum","values":{"vector":1}},"url":{"type":"string"},"tiles":{"type":"array","value":"string"},"bounds":{"type":"array","value":"number","length":4,"default":[-180,-85.051129,180,85.051129]},"scheme":{"type":"enum","values":{"xyz":1,"tms":1},"default":"xyz"},"minzoom":{"type":"number","default":0},"maxzoom":{"type":"number","default":22},"attribution":{"type":"string"},"promoteId":{"type":"promoteId"},"volatile":{"type":"boolean","default":false},"*":{"type":"*"}},"source_raster":{"type":{"required":true,"type":"enum","values":{"raster":1}},"url":{"type":"string"},"tiles":{"type":"array","value":"string"},"bounds":{"type":"array","value":"number","length":4,"default":[-180,-85.051129,180,85.051129]},"minzoom":{"type":"number","default":0},"maxzoom":{"type":"number","default":22},"tileSize":{"type":"number","default":512},"scheme":{"type":"enum","values":{"xyz":1,"tms":1},"default":"xyz"},"attribution":{"type":"string"},"volatile":{"type":"boolean","default":false},"*":{"type":"*"}},"source_raster_dem":{"type":{"required":true,"type":"enum","values":{"raster-dem":1}},"url":{"type":"string"},"tiles":{"type":"array","value":"string"},"bounds":{"type":"array","value":"number","length":4,"default":[-180,-85.051129,180,85.051129]},"minzoom":{"type":"number","default":0},"maxzoom":{"type":"number","default":22},"tileSize":{"type":"number","default":512},"attribution":{"type":"string"},"encoding":{"type":"enum","values":{"terrarium":1,"mapbox":1},"default":"mapbox"},"volatile":{"type":"boolean","default":false},"*":{"type":"*"}},"source_raster_array":{"type":{"required":true,"type":"enum","values":{"raster-array":1}},"url":{"type":"string"},"tiles":{"type":"array","value":"string"},"bounds":{"type":"array","value":"number","length":4,"default":[-180,-85.051129,180,85.051129]},"minzoom":{"type":"number","default":0},"maxzoom":{"type":"number","default":22},"tileSize":{"type":"number","default":512},"attribution":{"type":"string"},"rasterLayers":{"type":"*"},"volatile":{"type":"boolean","default":false},"*":{"type":"*"}},"source_geojson":{"type":{"required":true,"type":"enum","values":{"geojson":1}},"data":{"type":"*"},"maxzoom":{"type":"number","default":18},"attribution":{"type":"string"},"buffer":{"type":"number","default":128,"maximum":512,"minimum":0},"filter":{"type":"*"},"tolerance":{"type":"number","default":0.375},"cluster":{"type":"boolean","default":false},"clusterRadius":{"type":"number","default":50,"minimum":0},"clusterMaxZoom":{"type":"number"},"clusterMinPoints":{"type":"number"},"clusterProperties":{"type":"*"},"lineMetrics":{"type":"boolean","default":false},"generateId":{"type":"boolean","default":false},"promoteId":{"type":"promoteId"}},"source_video":{"type":{"required":true,"type":"enum","values":{"video":1}},"urls":{"required":true,"type":"array","value":"string"},"coordinates":{"required":true,"type":"array","length":4,"value":{"type":"array","length":2,"value":"number"}}},"source_image":{"type":{"required":true,"type":"enum","values":{"image":1}},"url":{"required":false,"type":"string"},"coordinates":{"required":true,"type":"array","length":4,"value":{"type":"array","length":2,"value":"number"}}},"source_model":{"type":{"required":true,"type":"enum","values":{"model":1,"batched-model":1}},"maxzoom":{"type":"number","default":18},"minzoom":{"type":"number","default":0},"tiles":{"type":"array","value":"string"}},"layer":{"id":{"type":"string","required":true},"type":{"type":"enum","values":{"fill":{},"line":{},"symbol":{},"circle":{},"heatmap":{},"fill-extrusion":{},"raster":{},"raster-particle":{},"hillshade":{},"model":{},"background":{},"sky":{},"slot":{}},"required":true},"metadata":{"type":"*"},"source":{"type":"string"},"source-layer":{"type":"string"},"slot":{"type":"string"},"minzoom":{"type":"number","minimum":0,"maximum":24},"maxzoom":{"type":"number","minimum":0,"maximum":24},"filter":{"type":"filter"},"layout":{"type":"layout"},"paint":{"type":"paint"}},"layout":["layout_fill","layout_line","layout_circle","layout_heatmap","layout_fill-extrusion","layout_symbol","layout_raster","layout_raster-particle","layout_hillshade","layout_background","layout_sky","layout_model"],"layout_background":{"visibility":{"type":"enum","values":{"visible":1,"none":1},"default":"visible","expression":{},"property-type":"constant"}},"layout_sky":{"visibility":{"type":"enum","values":{"visible":1,"none":1},"default":"visible","expression":{},"property-type":"constant"}},"layout_model":{"visibility":{"type":"enum","values":{"visible":1,"none":1},"default":"visible","expression":{},"property-type":"constant"},"model-id":{"type":"string","default":"","property-type":"data-driven","expression":{"parameters":["zoom","feature"]}}},"layout_fill":{"fill-sort-key":{"type":"number","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"visibility":{"type":"enum","values":{"visible":1,"none":1},"default":"visible","expression":{},"property-type":"constant"}},"layout_circle":{"circle-sort-key":{"type":"number","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"visibility":{"type":"enum","values":{"visible":1,"none":1},"default":"visible","expression":{},"property-type":"constant"}},"layout_heatmap":{"visibility":{"type":"enum","values":{"visible":1,"none":1},"default":"visible","expression":{},"property-type":"constant"}},"layout_fill-extrusion":{"visibility":{"type":"enum","values":{"visible":1,"none":1},"default":"visible","expression":{},"property-type":"constant"},"fill-extrusion-edge-radius":{"type":"number","private":true,"default":0,"minimum":0,"maximum":1,"expression":{},"property-type":"constant"}},"layout_line":{"line-cap":{"type":"enum","values":{"butt":1,"round":1,"square":1},"default":"butt","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"line-join":{"type":"enum","values":{"bevel":1,"round":1,"miter":1},"default":"miter","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"line-miter-limit":{"type":"number","default":2,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"line-round-limit":{"type":"number","default":1.05,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"line-sort-key":{"type":"number","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"visibility":{"type":"enum","values":{"visible":1,"none":1},"default":"visible","expression":{},"property-type":"constant"}},"layout_symbol":{"symbol-placement":{"type":"enum","values":{"point":1,"line":1,"line-center":1},"default":"point","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"symbol-spacing":{"type":"number","default":250,"minimum":1,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"symbol-avoid-edges":{"type":"boolean","default":false,"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"symbol-sort-key":{"type":"number","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"symbol-z-order":{"type":"enum","values":{"auto":1,"viewport-y":1,"source":1},"default":"auto","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"symbol-z-elevate":{"type":"boolean","default":false,"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"icon-allow-overlap":{"type":"boolean","default":false,"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"icon-ignore-placement":{"type":"boolean","default":false,"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"icon-optional":{"type":"boolean","default":false,"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"icon-rotation-alignment":{"type":"enum","values":{"map":1,"viewport":1,"auto":1},"default":"auto","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"icon-size":{"type":"number","default":1,"minimum":0,"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"icon-text-fit":{"type":"enum","values":{"none":1,"width":1,"height":1,"both":1},"default":"none","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"icon-text-fit-padding":{"type":"array","value":"number","length":4,"default":[0,0,0,0],"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"icon-image":{"type":"resolvedImage","tokens":true,"expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"icon-rotate":{"type":"number","default":0,"period":360,"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"icon-padding":{"type":"number","default":2,"minimum":0,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"icon-keep-upright":{"type":"boolean","default":false,"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"icon-offset":{"type":"array","value":"number","length":2,"default":[0,0],"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"icon-anchor":{"type":"enum","values":{"center":1,"left":1,"right":1,"top":1,"bottom":1,"top-left":1,"top-right":1,"bottom-left":1,"bottom-right":1},"default":"center","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"icon-pitch-alignment":{"type":"enum","values":{"map":1,"viewport":1,"auto":1},"default":"auto","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"text-pitch-alignment":{"type":"enum","values":{"map":1,"viewport":1,"auto":1},"default":"auto","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"text-rotation-alignment":{"type":"enum","values":{"map":1,"viewport":1,"auto":1},"default":"auto","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"text-field":{"type":"formatted","default":"","tokens":true,"expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-font":{"type":"array","value":"string","default":["Open Sans Regular","Arial Unicode MS Regular"],"expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-size":{"type":"number","default":16,"minimum":0,"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-max-width":{"type":"number","default":10,"minimum":0,"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-line-height":{"type":"number","default":1.2,"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-letter-spacing":{"type":"number","default":0,"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-justify":{"type":"enum","values":{"auto":1,"left":1,"center":1,"right":1},"default":"center","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-radial-offset":{"type":"number","default":0,"property-type":"data-driven","expression":{"interpolated":true,"parameters":["zoom","feature"]}},"text-variable-anchor":{"type":"array","value":"enum","values":{"center":1,"left":1,"right":1,"top":1,"bottom":1,"top-left":1,"top-right":1,"bottom-left":1,"bottom-right":1},"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"text-anchor":{"type":"enum","values":{"center":1,"left":1,"right":1,"top":1,"bottom":1,"top-left":1,"top-right":1,"bottom-left":1,"bottom-right":1},"default":"center","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-max-angle":{"type":"number","default":45,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"text-writing-mode":{"type":"array","value":"enum","values":{"horizontal":1,"vertical":1},"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"text-rotate":{"type":"number","default":0,"period":360,"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-padding":{"type":"number","default":2,"minimum":0,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"text-keep-upright":{"type":"boolean","default":true,"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"text-transform":{"type":"enum","values":{"none":1,"uppercase":1,"lowercase":1},"default":"none","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-offset":{"type":"array","value":"number","length":2,"default":[0,0],"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-allow-overlap":{"type":"boolean","default":false,"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"text-ignore-placement":{"type":"boolean","default":false,"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"text-optional":{"type":"boolean","default":false,"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"visibility":{"type":"enum","values":{"visible":1,"none":1},"default":"visible","expression":{},"property-type":"constant"}},"layout_raster":{"visibility":{"type":"enum","values":{"visible":1,"none":1},"default":"visible","expression":{},"property-type":"constant"}},"layout_raster-particle":{"visibility":{"type":"enum","values":{"visible":1,"none":1},"default":"visible","expression":{},"property-type":"constant"}},"layout_hillshade":{"visibility":{"type":"enum","values":{"visible":1,"none":1},"default":"visible","expression":{},"property-type":"constant"}},"filter":{"type":"array","value":"*"},"filter_symbol":{"type":"boolean","default":false,"property-type":"data-driven","expression":{"parameters":["zoom","feature","pitch","distance-from-center"]}},"filter_fill":{"type":"boolean","default":false,"property-type":"data-driven","expression":{"parameters":["zoom","feature"]}},"filter_line":{"type":"boolean","default":false,"property-type":"data-driven","expression":{"parameters":["zoom","feature"]}},"filter_circle":{"type":"boolean","default":false,"property-type":"data-driven","expression":{"parameters":["zoom","feature"]}},"filter_fill-extrusion":{"type":"boolean","default":false,"property-type":"data-driven","expression":{"parameters":["zoom","feature"]}},"filter_heatmap":{"type":"boolean","default":false,"property-type":"data-driven","expression":{"parameters":["zoom","feature"]}},"filter_operator":{"type":"enum","values":{"==":1,"!=":1,">":1,">=":1,"<":1,"<=":1,"in":1,"!in":1,"all":1,"any":1,"none":1,"has":1,"!has":1}},"geometry_type":{"type":"enum","values":{"Point":1,"LineString":1,"Polygon":1}},"function":{"expression":{"type":"expression"},"stops":{"type":"array","value":"function_stop"},"base":{"type":"number","default":1,"minimum":0},"property":{"type":"string","default":"$zoom"},"type":{"type":"enum","values":{"identity":1,"exponential":1,"interval":1,"categorical":1},"default":"exponential"},"colorSpace":{"type":"enum","values":{"rgb":1,"lab":1,"hcl":1},"default":"rgb"},"default":{"type":"*","required":false}},"function_stop":{"type":"array","minimum":0,"maximum":24,"value":["number","color"],"length":2},"expression":{"type":"array","value":"*","minimum":1},"fog":{"range":{"type":"array","default":[0.5,10],"minimum":-20,"maximum":20,"length":2,"value":"number","property-type":"data-constant","transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true}},"color":{"type":"color","property-type":"data-constant","default":"#ffffff","expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"transition":true},"high-color":{"type":"color","property-type":"data-constant","default":"#245cdf","expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"transition":true},"space-color":{"type":"color","property-type":"data-constant","default":["interpolate",["linear"],["zoom"],4,"#010b19",7,"#367ab9"],"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"transition":true},"horizon-blend":{"type":"number","property-type":"data-constant","default":["interpolate",["linear"],["zoom"],4,0.2,7,0.1],"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"transition":true},"star-intensity":{"type":"number","property-type":"data-constant","default":["interpolate",["linear"],["zoom"],5,0.35,6,0],"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"transition":true},"vertical-range":{"type":"array","default":[0,0],"minimum":0,"length":2,"value":"number","property-type":"data-constant","transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true}}},"camera":{"camera-projection":{"type":"enum","values":{"perspective":1,"orthographic":1},"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"default":"perspective","property-type":"data-constant"}},"light":{"anchor":{"type":"enum","default":"viewport","values":{"map":1,"viewport":1},"property-type":"data-constant","expression":{"parameters":["zoom"]}},"position":{"type":"array","default":[1.15,210,30],"length":3,"value":"number","property-type":"data-constant","transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"color":{"type":"color","property-type":"data-constant","default":"#ffffff","expression":{"interpolated":true,"parameters":["zoom"]},"transition":true},"intensity":{"type":"number","property-type":"data-constant","default":0.5,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true}},"projection":{"name":{"type":"enum","values":{"albers":1,"equalEarth":1,"equirectangular":1,"lambertConformalConic":1,"mercator":1,"naturalEarth":1,"winkelTripel":1,"globe":1},"default":"mercator","required":true},"center":{"type":"array","length":2,"value":"number","property-type":"data-constant","minimum":[-180,-90],"maximum":[180,90]},"parallels":{"type":"array","length":2,"value":"number","property-type":"data-constant","minimum":[-90,-90],"maximum":[90,90]}},"terrain":{"source":{"type":"string","required":true},"exaggeration":{"type":"number","property-type":"data-constant","default":1,"minimum":0,"maximum":1000,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true}},"paint":["paint_fill","paint_line","paint_circle","paint_heatmap","paint_fill-extrusion","paint_symbol","paint_raster","paint_hillshade","paint_background","paint_sky","paint_model"],"paint_fill":{"fill-antialias":{"type":"boolean","default":true,"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"fill-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"fill-color":{"type":"color","default":"#000000","transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"fill-outline-color":{"type":"color","transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"fill-translate":{"type":"array","value":"number","length":2,"default":[0,0],"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"fill-translate-anchor":{"type":"enum","values":{"map":1,"viewport":1},"default":"map","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"fill-pattern":{"type":"resolvedImage","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"fill-emissive-strength":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]},"property-type":"data-constant"}},"paint_fill-extrusion":{"fill-extrusion-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"fill-extrusion-color":{"type":"color","default":"#000000","transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"fill-extrusion-translate":{"type":"array","value":"number","length":2,"default":[0,0],"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"fill-extrusion-translate-anchor":{"type":"enum","values":{"map":1,"viewport":1},"default":"map","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"fill-extrusion-pattern":{"type":"resolvedImage","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"fill-extrusion-height":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-extrusion-base":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-extrusion-vertical-gradient":{"type":"boolean","default":true,"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"fill-extrusion-ambient-occlusion-intensity":{"property-type":"data-constant","type":"number","private":true,"default":0,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true},"fill-extrusion-ambient-occlusion-radius":{"property-type":"data-constant","type":"number","private":true,"default":3,"minimum":0,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true},"fill-extrusion-ambient-occlusion-wall-radius":{"property-type":"data-constant","type":"number","default":3,"minimum":0,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true},"fill-extrusion-ambient-occlusion-ground-radius":{"property-type":"data-constant","type":"number","default":3,"minimum":0,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true},"fill-extrusion-ambient-occlusion-ground-attenuation":{"property-type":"data-constant","type":"number","default":0.69,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"fill-extrusion-flood-light-color":{"property-type":"data-constant","type":"color","default":"#ffffff","transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]}},"fill-extrusion-flood-light-intensity":{"property-type":"data-constant","type":"number","default":0,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]}},"fill-extrusion-flood-light-wall-radius":{"property-type":"data-driven","type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["feature","feature-state"]}},"fill-extrusion-flood-light-ground-radius":{"property-type":"data-driven","type":"number","default":0,"transition":true,"expression":{"interpolated":true,"parameters":["feature","feature-state"]}},"fill-extrusion-flood-light-ground-attenuation":{"property-type":"data-constant","type":"number","default":0.69,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"fill-extrusion-vertical-scale":{"property-type":"data-constant","type":"number","default":1,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"fill-extrusion-rounded-roof":{"property-type":"data-constant","type":"boolean","default":true,"expression":{"parameters":["zoom"]}},"fill-extrusion-cutoff-fade-range":{"type":"number","default":0,"minimum":0,"maximum":1,"expression":{},"property-type":"data-constant"},"fill-extrusion-emissive-strength":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]},"property-type":"data-constant"}},"paint_line":{"line-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"line-color":{"type":"color","default":"#000000","transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"line-translate":{"type":"array","value":"number","length":2,"default":[0,0],"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"line-translate-anchor":{"type":"enum","values":{"map":1,"viewport":1},"default":"map","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"line-width":{"type":"number","default":1,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"line-gap-width":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"line-offset":{"type":"number","default":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"line-blur":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"line-dasharray":{"type":"array","value":"number","minimum":0,"expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"line-pattern":{"type":"resolvedImage","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"line-gradient":{"type":"color","expression":{"interpolated":true,"parameters":["line-progress"]},"property-type":"color-ramp"},"line-trim-offset":{"type":"array","value":"number","length":2,"default":[0,0],"minimum":[0,0],"maximum":[1,1],"property-type":"constant"},"line-emissive-strength":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]},"property-type":"data-constant"},"line-border-width":{"type":"number","private":true,"default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-border-color":{"type":"color","private":true,"default":"rgba(0, 0, 0, 0)","transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"}},"paint_circle":{"circle-radius":{"type":"number","default":5,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"circle-color":{"type":"color","default":"#000000","transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"circle-blur":{"type":"number","default":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"circle-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"circle-translate":{"type":"array","value":"number","length":2,"default":[0,0],"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"circle-translate-anchor":{"type":"enum","values":{"map":1,"viewport":1},"default":"map","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"circle-pitch-scale":{"type":"enum","values":{"map":1,"viewport":1},"default":"map","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"circle-pitch-alignment":{"type":"enum","values":{"map":1,"viewport":1},"default":"viewport","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"circle-stroke-width":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"circle-stroke-color":{"type":"color","default":"#000000","transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"circle-stroke-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"circle-emissive-strength":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]},"property-type":"data-constant"}},"paint_heatmap":{"heatmap-radius":{"type":"number","default":30,"minimum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"heatmap-weight":{"type":"number","default":1,"minimum":0,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"heatmap-intensity":{"type":"number","default":1,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"heatmap-color":{"type":"color","default":["interpolate",["linear"],["heatmap-density"],0,"rgba(0, 0, 255, 0)",0.1,"royalblue",0.3,"cyan",0.5,"lime",0.7,"yellow",1,"red"],"expression":{"interpolated":true,"parameters":["heatmap-density"]},"property-type":"color-ramp"},"heatmap-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"}},"paint_symbol":{"icon-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"icon-emissive-strength":{"type":"number","default":1,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]},"property-type":"data-driven"},"text-emissive-strength":{"type":"number","default":1,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]},"property-type":"data-driven"},"icon-color":{"type":"color","default":"#000000","transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"icon-halo-color":{"type":"color","default":"rgba(0, 0, 0, 0)","transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"icon-halo-width":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"icon-halo-blur":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"icon-translate":{"type":"array","value":"number","length":2,"default":[0,0],"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"icon-translate-anchor":{"type":"enum","values":{"map":1,"viewport":1},"default":"map","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"icon-image-cross-fade":{"type":"number","property-type":"data-driven","default":0,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"transition":true},"text-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"text-color":{"type":"color","default":"#000000","transition":true,"overridable":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"text-halo-color":{"type":"color","default":"rgba(0, 0, 0, 0)","transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"text-halo-width":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"text-halo-blur":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"text-translate":{"type":"array","value":"number","length":2,"default":[0,0],"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"text-translate-anchor":{"type":"enum","values":{"map":1,"viewport":1},"default":"map","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"icon-color-saturation":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{},"property-type":"data-constant"}},"paint_raster":{"raster-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"raster-color":{"type":"color","expression":{"interpolated":true,"parameters":["raster-value"]},"property-type":"color-ramp"},"raster-color-mix":{"type":"array","default":[0.2126,0.7152,0.0722,0],"length":4,"value":"number","property-type":"data-constant","transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"raster-color-range":{"type":"array","length":2,"value":"number","property-type":"data-constant","transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"raster-hue-rotate":{"type":"number","default":0,"period":360,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"raster-brightness-min":{"type":"number","default":0,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"raster-brightness-max":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"raster-saturation":{"type":"number","default":0,"minimum":-1,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"raster-contrast":{"type":"number","default":0,"minimum":-1,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"raster-resampling":{"type":"enum","values":{"linear":1,"nearest":1},"default":"linear","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"raster-fade-duration":{"type":"number","default":300,"minimum":0,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"raster-emissive-strength":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]},"property-type":"data-constant"},"raster-array-band":{"type":"string","required":false,"property-type":"data-constant"},"raster-elevation":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"}},"paint_raster-particle":{"raster-particle-array-band":{"type":"string","required":false,"property-type":"data-constant"},"raster-particle-count":{"type":"number","default":512,"minimum":1,"property-type":"data-constant"},"raster-particle-color":{"type":"color","expression":{"interpolated":true,"parameters":["raster-particle-speed"]},"property-type":"color-ramp"},"raster-particle-max-speed":{"type":"number","default":1,"minimum":1,"property-type":"data-constant"},"raster-particle-speed-factor":{"type":"number","default":0.2,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"raster-particle-fade-opacity-factor":{"type":"number","default":0.98,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"raster-particle-reset-rate-factor":{"type":"number","default":0.8,"minimum":0,"maximum":1,"property-type":"data-constant"}},"paint_hillshade":{"hillshade-illumination-direction":{"type":"number","default":335,"minimum":0,"maximum":359,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"hillshade-illumination-anchor":{"type":"enum","values":{"map":1,"viewport":1},"default":"viewport","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"hillshade-exaggeration":{"type":"number","default":0.5,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"hillshade-shadow-color":{"type":"color","default":"#000000","transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]},"property-type":"data-constant"},"hillshade-highlight-color":{"type":"color","default":"#FFFFFF","transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]},"property-type":"data-constant"},"hillshade-accent-color":{"type":"color","default":"#000000","transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]},"property-type":"data-constant"},"hillshade-emissive-strength":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]},"property-type":"data-constant"}},"paint_background":{"background-color":{"type":"color","default":"#000000","transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"background-pattern":{"type":"resolvedImage","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"background-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"background-emissive-strength":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]},"property-type":"data-constant"}},"paint_sky":{"sky-type":{"type":"enum","values":{"gradient":1,"atmosphere":1},"default":"atmosphere","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"sky-atmosphere-sun":{"type":"array","value":"number","length":2,"minimum":[0,0],"maximum":[360,180],"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"sky-atmosphere-sun-intensity":{"type":"number","default":10,"minimum":0,"maximum":100,"property-type":"data-constant"},"sky-gradient-center":{"type":"array","value":"number","default":[0,0],"length":2,"minimum":[0,0],"maximum":[360,180],"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"sky-gradient-radius":{"type":"number","default":90,"minimum":0,"maximum":180,"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"sky-gradient":{"type":"color","default":["interpolate",["linear"],["sky-radial-progress"],0.8,"#87ceeb",1,"white"],"expression":{"interpolated":true,"parameters":["sky-radial-progress"]},"property-type":"color-ramp"},"sky-atmosphere-halo-color":{"type":"color","default":"white","property-type":"data-constant"},"sky-atmosphere-color":{"type":"color","default":"white","property-type":"data-constant"},"sky-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"}},"paint_model":{"model-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"model-rotation":{"type":"array","value":"number","length":3,"default":[0,0,0],"period":360,"property-type":"data-driven","expression":{"interpolated":true,"parameters":["feature","feature-state","zoom"]},"transition":true},"model-scale":{"type":"array","value":"number","length":3,"default":[1,1,1],"property-type":"data-driven","expression":{"interpolated":true,"parameters":["feature","feature-state","zoom"]},"transition":true},"model-translation":{"type":"array","value":"number","length":3,"default":[0,0,0],"property-type":"data-driven","expression":{"interpolated":true,"parameters":["feature","feature-state","zoom"]},"transition":true},"model-color":{"type":"color","default":"#ffffff","property-type":"data-driven","expression":{"interpolated":true,"parameters":["feature","feature-state","measure-light","zoom"]},"transition":true},"model-color-mix-intensity":{"type":"number","property-type":"data-driven","default":0,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["feature","feature-state","measure-light"]},"transition":true},"model-type":{"type":"enum","values":{"common-3d":1,"location-indicator":1},"default":"common-3d","property-type":"data-constant"},"model-cast-shadows":{"type":"boolean","default":true,"expression":{},"property-type":"data-constant"},"model-receive-shadows":{"type":"boolean","default":true,"expression":{},"property-type":"data-constant"},"model-ambient-occlusion-intensity":{"type":"number","default":1,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant","transition":true},"model-emissive-strength":{"type":"number","property-type":"data-driven","default":0,"minimum":0,"maximum":5,"expression":{"interpolated":true,"parameters":["feature","feature-state","measure-light"]},"transition":true},"model-roughness":{"type":"number","default":1,"minimum":0,"maximum":1,"property-type":"data-driven","expression":{"interpolated":true,"parameters":["feature","feature-state"]},"transition":true},"model-height-based-emissive-strength-multiplier":{"type":"array","default":[1,1,1,1,0],"length":5,"value":"number","property-type":"data-driven","expression":{"interpolated":true,"parameters":["feature","feature-state","measure-light"]},"transition":true},"model-cutoff-fade-range":{"type":"number","default":0,"minimum":0,"maximum":1,"expression":{},"property-type":"data-constant"}},"transition":{"duration":{"type":"number","default":300,"minimum":0},"delay":{"type":"number","default":0,"minimum":0}},"property-type":{"data-driven":{"type":"property-type"},"color-ramp":{"type":"property-type"},"data-constant":{"type":"property-type"},"constant":{"type":"property-type"}},"promoteId":{"*":{"type":"string"}}}');function $a(t){if(!0===t||!1===t)return !0;if(!Array.isArray(t)||0===t.length)return !1;switch(t[0]){case"has":return t.length>=2&&"$id"!==t[1]&&"$type"!==t[1];case"in":return t.length>=3&&("string"!=typeof t[1]||Array.isArray(t[2]));case"!in":case"!has":case"none":return !1;case"==":case"!=":case">":case">=":case"<":case"<=":return 3!==t.length||Array.isArray(t[1])||Array.isArray(t[2]);case"any":case"all":for(const e of t.slice(1))if(!$a(e)&&"boolean"!=typeof e)return !1;return !0;default:return !0}}function Ga(t,e="fill"){if(null==t)return {filter:()=>!0,needGeometry:!1,needFeature:!1};$a(t)||(t=Ja(t));const r=t;let n=!0;try{n=function(t){if(!Za(t))return t;let e=ja(t);return Xa(e),e=Ya(e),e}(r);}catch(t){console.warn(`Failed to extract static filter. Filter will continue working, but at higher memory usage and slower framerate.\nThis is most likely a bug, please report this via https://github.com/mapbox/mapbox-gl-js/issues/new?assignees=&labels=&template=Bug_report.md\nand paste the contents of this message in the report.\nThank you!\nFilter Expression:\n${JSON.stringify(r,null,2)}\n        `);}const i=qa[`filter_${e}`],a=Gi(n,i);let s=null;if("error"===a.result)throw new Error(a.value.map((t=>`${t.key}: ${t.message}`)).join(", "));s=(t,e,r)=>a.value.evaluate(t,e,{},r);let o=null,l=null;if(n!==r){const t=Gi(r,i);if("error"===t.result)throw new Error(t.value.map((t=>`${t.key}: ${t.message}`)).join(", "));o=(e,r,n,i,a)=>t.value.evaluate(e,r,{},n,void 0,void 0,i,a),l=!dn(t.value.expression);}return {filter:s,dynamicFilter:o||void 0,needGeometry:Wa(n),needFeature:!!l}}function Ya(t){if(!Array.isArray(t))return t;const e=function(t){if(Ka.has(t[0]))for(let e=1;e<t.length;e++)if(Za(t[e]))return !0;return t}(t);return !0===e?e:e.map((t=>Ya(t)))}function Xa(t){let e=!1;const r=[];if("case"===t[0]){for(let n=1;n<t.length-1;n+=2)e=e||Za(t[n]),r.push(t[n+1]);r.push(t[t.length-1]);}else if("match"===t[0]){e=e||Za(t[1]);for(let e=2;e<t.length-1;e+=2)r.push(t[e+1]);r.push(t[t.length-1]);}else if("step"===t[0]){e=e||Za(t[1]);for(let e=1;e<t.length-1;e+=2)r.push(t[e+1]);}e&&(t.length=0,t.push("any",...r));for(let e=1;e<t.length;e++)Xa(t[e]);}function Za(t){if(!Array.isArray(t))return !1;if("pitch"===(e=t[0])||"distance-from-center"===e)return !0;var e;for(let e=1;e<t.length;e++)if(Za(t[e]))return !0;return !1}const Ka=new Set(["in","==","!=",">",">=","<","<=","to-boolean"]);function Ha(t,e){return t<e?-1:t>e?1:0}function Wa(t){if(!Array.isArray(t))return !1;if("within"===t[0]||"distance"===t[0])return !0;for(let e=1;e<t.length;e++)if(Wa(t[e]))return !0;return !1}function Ja(t){if(!t)return !0;const e=t[0];return t.length<=1?"any"!==e:"=="===e?Qa(t[1],t[2],"=="):"!="===e?rs(Qa(t[1],t[2],"==")):"<"===e||">"===e||"<="===e||">="===e?Qa(t[1],t[2],e):"any"===e?(r=t.slice(1),["any"].concat(r.map(Ja))):"all"===e?["all"].concat(t.slice(1).map(Ja)):"none"===e?["all"].concat(t.slice(1).map(Ja).map(rs)):"in"===e?ts(t[1],t.slice(2)):"!in"===e?rs(ts(t[1],t.slice(2))):"has"===e?es(t[1]):"!has"!==e||rs(es(t[1]));var r;}function Qa(t,e,r){switch(t){case"$type":return [`filter-type-${r}`,e];case"$id":return [`filter-id-${r}`,e];default:return [`filter-${r}`,t,e]}}function ts(t,e){if(0===e.length)return !1;switch(t){case"$type":return ["filter-type-in",["literal",e]];case"$id":return ["filter-id-in",["literal",e]];default:return e.length>200&&!e.some((t=>typeof t!=typeof e[0]))?["filter-in-large",t,["literal",e.sort(Ha)]]:["filter-in-small",t,["literal",e]]}}function es(t){switch(t){case"$type":return !0;case"$id":return ["filter-has-id"];default:return ["filter-has",t]}}function rs(t){return ["!",t]}const ns="";function is(t,e){return e?`${t}${ns}${e}`:t}const as="-transition";class ss extends ee{constructor(t,e,r,n){if(super(),this.id=t.id,this.fqid=is(this.id,r),this.type=t.type,this.scope=r,this.options=n,this._featureFilter={filter:()=>!0,needGeometry:!1,needFeature:!1},this._filterCompiled=!1,this.isConfigDependent=!1,"custom"!==t.type&&(this.metadata=t.metadata,this.minzoom=t.minzoom,this.maxzoom=t.maxzoom,"background"!==t.type&&"sky"!==t.type&&"slot"!==t.type&&(this.source=t.source,this.sourceLayer=t["source-layer"],this.filter=t.filter),t.slot&&(this.slot=t.slot),e.layout&&(this._unevaluatedLayout=new Ra(e.layout,this.scope,n),this.isConfigDependent=this.isConfigDependent||this._unevaluatedLayout.isConfigDependent),e.paint)){this._transitionablePaint=new Ta(e.paint,this.scope,n);for(const e in t.paint)this.setPaintProperty(e,t.paint[e]);for(const e in t.layout)this.setLayoutProperty(e,t.layout[e]);this.isConfigDependent=this.isConfigDependent||this._transitionablePaint.isConfigDependent,this._transitioningPaint=this._transitionablePaint.untransitioned(),this.paint=new Va(e.paint);}}getLayoutProperty(t){return "visibility"===t?this.visibility:this._unevaluatedLayout.getValue(t)}setLayoutProperty(t,e){if("custom"===this.type&&"visibility"===t)return void(this.visibility=e);const r=this._unevaluatedLayout;r._properties.properties[t]&&(r.setValue(t,e),this.isConfigDependent=this.isConfigDependent||r.isConfigDependent,"visibility"===t&&this.possiblyEvaluateVisibility());}possiblyEvaluateVisibility(){this.visibility=this._unevaluatedLayout._values.visibility.possiblyEvaluate({zoom:0});}getPaintProperty(t){return L(t,as)?this._transitionablePaint.getTransition(t.slice(0,-11)):this._transitionablePaint.getValue(t)}setPaintProperty(t,e){const r=this._transitionablePaint,n=r._properties.properties;if(L(t,as)){const i=t.slice(0,-11);return n[i]&&r.setTransition(i,e||void 0),!1}if(!n[t])return !1;const i=r._values[t],a=i.value.isDataDriven(),s=i.value;r.setValue(t,e),this.isConfigDependent=this.isConfigDependent||r.isConfigDependent,this._handleSpecialPaintPropertyUpdate(t);const o=r._values[t].value,l=o.isDataDriven(),u=L(t,"pattern")||"line-dasharray"===t;return l||a||u||this._handleOverridablePaintPropertyUpdate(t,s,o)}_handleSpecialPaintPropertyUpdate(t){}getProgramIds(){return null}getDefaultProgramParams(t,e){return null}_handleOverridablePaintPropertyUpdate(t,e,r){return !1}isHidden(t){return !!(this.minzoom&&t<this.minzoom)||!!(this.maxzoom&&t>=this.maxzoom)||"none"===this.visibility}updateTransitions(t){this._transitioningPaint=this._transitionablePaint.transitioned(t,this._transitioningPaint);}hasTransition(){return this._transitioningPaint.hasTransition()}recalculate(t,e){this._unevaluatedLayout&&(this.layout=this._unevaluatedLayout.possiblyEvaluate(t,void 0,e)),this.paint=this._transitioningPaint.possiblyEvaluate(t,void 0,e);}serialize(){return N({id:this.id,type:this.type,slot:this.slot,source:this.source,"source-layer":this.sourceLayer,metadata:this.metadata,minzoom:this.minzoom,maxzoom:this.maxzoom,filter:this.filter,layout:this._unevaluatedLayout&&this._unevaluatedLayout.serialize(),paint:this._transitionablePaint&&this._transitionablePaint.serialize()},((t,e)=>!(void 0===t||"layout"===e&&!Object.keys(t).length||"paint"===e&&!Object.keys(t).length)))}is3D(){return !1}isSky(){return !1}isTileClipped(){return !1}hasOffscreenPass(){return !1}hasShadowPass(){return !1}canCastShadows(){return !1}hasLightBeamPass(){return !1}cutoffRange(){return 0}tileCoverLift(){return 0}resize(){}isStateDependent(){for(const t in this.paint._values){const e=this.paint.get(t);if(e instanceof Da&&Ti(e.property.specification)&&("source"===e.value.kind||"composite"===e.value.kind)&&e.value.isStateDependent)return !0}return !1}compileFilter(){this._filterCompiled||(this._featureFilter=Ga(this.filter),this._filterCompiled=!0);}invalidateCompiledFilter(){this._filterCompiled=!1;}dynamicFilter(){return this._featureFilter.dynamicFilter}dynamicFilterNeedsFeature(){return this._featureFilter.needFeature}getLayerRenderingStats(){return this._stats}resetLayerRenderingStats(t){this._stats&&("shadow"===t.renderPass?this._stats.numRenderedVerticesInShadowPass=0:this._stats.numRenderedVerticesInTransparentPass=0);}}const os={Int8:Int8Array,Uint8:Uint8Array,Int16:Int16Array,Uint16:Uint16Array,Int32:Int32Array,Uint32:Uint32Array,Float32:Float32Array};class ls{constructor(t,e){this._structArray=t,this._pos1=e*this.size,this._pos2=this._pos1/2,this._pos4=this._pos1/4,this._pos8=this._pos1/8;}}class us{constructor(){this.isTransferred=!1,this.capacity=-1,this.resize(0);}static serialize(t,e){return t._trim(),e&&(t.isTransferred=!0,e.add(t.arrayBuffer)),{length:t.length,arrayBuffer:t.arrayBuffer}}static deserialize(t){const e=Object.create(this.prototype);return e.arrayBuffer=t.arrayBuffer,e.length=t.length,e.capacity=t.arrayBuffer.byteLength/e.bytesPerElement,e._refreshViews(),e}_trim(){this.length!==this.capacity&&(this.capacity=this.length,this.arrayBuffer=this.arrayBuffer.slice(0,this.length*this.bytesPerElement),this._refreshViews());}clear(){this.length=0;}resize(t){this.reserve(t),this.length=t;}reserve(t){if(t>this.capacity){this.capacity=Math.max(t,Math.floor(5*this.capacity),128),this.arrayBuffer=new ArrayBuffer(this.capacity*this.bytesPerElement);const e=this.uint8;this._refreshViews(),e&&this.uint8.set(e);}}_refreshViews(){throw new Error("StructArray#_refreshViews() must be implemented by each concrete StructArray layout")}emplace(...t){throw new Error("StructArray#emplace() must be implemented by each concrete StructArray layout")}emplaceBack(...t){throw new Error("StructArray#emplaceBack() must be implemented by each concrete StructArray layout")}destroy(){this.int8=this.uint8=this.int16=this.uint16=this.int32=this.uint32=this.float32=null,this.arrayBuffer=null;}}function cs(t,e=1){let r=0,n=0;return {members:t.map((t=>{const i=os[t.type].BYTES_PER_ELEMENT,a=r=hs(r,Math.max(e,i)),s=t.components||1;return n=Math.max(n,i),r+=i*s,{name:t.name,type:t.type,components:s,offset:a}})),size:hs(r,Math.max(n,e)),alignment:e}}function hs(t,e){return Math.ceil(t/e)*e}class ps extends us{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e){const r=this.length;return this.resize(r+1),this.emplace(r,t,e)}emplace(t,e,r){const n=2*t;return this.int16[n+0]=e,this.int16[n+1]=r,t}}ps.prototype.bytesPerElement=4,ra(ps,"StructArrayLayout2i4");class fs extends us{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r){const n=this.length;return this.resize(n+1),this.emplace(n,t,e,r)}emplace(t,e,r,n){const i=3*t;return this.int16[i+0]=e,this.int16[i+1]=r,this.int16[i+2]=n,t}}fs.prototype.bytesPerElement=6,ra(fs,"StructArrayLayout3i6");class ds extends us{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r,n){const i=this.length;return this.resize(i+1),this.emplace(i,t,e,r,n)}emplace(t,e,r,n,i){const a=4*t;return this.int16[a+0]=e,this.int16[a+1]=r,this.int16[a+2]=n,this.int16[a+3]=i,t}}ds.prototype.bytesPerElement=8,ra(ds,"StructArrayLayout4i8");class ms extends us{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i){const a=this.length;return this.resize(a+1),this.emplace(a,t,e,r,n,i)}emplace(t,e,r,n,i,a){const s=5*t;return this.int16[s+0]=e,this.int16[s+1]=r,this.int16[s+2]=n,this.int16[s+3]=i,this.int16[s+4]=a,t}}ms.prototype.bytesPerElement=10,ra(ms,"StructArrayLayout5i10");class ys extends us{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,a,s){const o=this.length;return this.resize(o+1),this.emplace(o,t,e,r,n,i,a,s)}emplace(t,e,r,n,i,a,s,o){const l=6*t,u=12*t,c=3*t;return this.int16[l+0]=e,this.int16[l+1]=r,this.uint8[u+4]=n,this.uint8[u+5]=i,this.uint8[u+6]=a,this.uint8[u+7]=s,this.float32[c+2]=o,t}}ys.prototype.bytesPerElement=12,ra(ys,"StructArrayLayout2i4ub1f12");class gs extends us{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n){const i=this.length;return this.resize(i+1),this.emplace(i,t,e,r,n)}emplace(t,e,r,n,i){const a=4*t;return this.float32[a+0]=e,this.float32[a+1]=r,this.float32[a+2]=n,this.float32[a+3]=i,t}}gs.prototype.bytesPerElement=16,ra(gs,"StructArrayLayout4f16");class xs extends us{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i){const a=this.length;return this.resize(a+1),this.emplace(a,t,e,r,n,i)}emplace(t,e,r,n,i,a){const s=6*t,o=3*t;return this.uint16[s+0]=e,this.uint16[s+1]=r,this.uint16[s+2]=n,this.uint16[s+3]=i,this.float32[o+2]=a,t}}xs.prototype.bytesPerElement=12,ra(xs,"StructArrayLayout4ui1f12");class vs extends us{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e,r,n){const i=this.length;return this.resize(i+1),this.emplace(i,t,e,r,n)}emplace(t,e,r,n,i){const a=4*t;return this.uint16[a+0]=e,this.uint16[a+1]=r,this.uint16[a+2]=n,this.uint16[a+3]=i,t}}vs.prototype.bytesPerElement=8,ra(vs,"StructArrayLayout4ui8");class bs extends us{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,a){const s=this.length;return this.resize(s+1),this.emplace(s,t,e,r,n,i,a)}emplace(t,e,r,n,i,a,s){const o=6*t;return this.int16[o+0]=e,this.int16[o+1]=r,this.int16[o+2]=n,this.int16[o+3]=i,this.int16[o+4]=a,this.int16[o+5]=s,t}}bs.prototype.bytesPerElement=12,ra(bs,"StructArrayLayout6i12");class _s extends us{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,a,s,o,l,u,c,h){const p=this.length;return this.resize(p+1),this.emplace(p,t,e,r,n,i,a,s,o,l,u,c,h)}emplace(t,e,r,n,i,a,s,o,l,u,c,h,p){const f=12*t;return this.int16[f+0]=e,this.int16[f+1]=r,this.int16[f+2]=n,this.int16[f+3]=i,this.uint16[f+4]=a,this.uint16[f+5]=s,this.uint16[f+6]=o,this.uint16[f+7]=l,this.int16[f+8]=u,this.int16[f+9]=c,this.int16[f+10]=h,this.int16[f+11]=p,t}}_s.prototype.bytesPerElement=24,ra(_s,"StructArrayLayout4i4ui4i24");class ws extends us{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,a){const s=this.length;return this.resize(s+1),this.emplace(s,t,e,r,n,i,a)}emplace(t,e,r,n,i,a,s){const o=10*t,l=5*t;return this.int16[o+0]=e,this.int16[o+1]=r,this.int16[o+2]=n,this.float32[l+2]=i,this.float32[l+3]=a,this.float32[l+4]=s,t}}ws.prototype.bytesPerElement=20,ra(ws,"StructArrayLayout3i3f20");class Ms extends us{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer);}emplaceBack(t){const e=this.length;return this.resize(e+1),this.emplace(e,t)}emplace(t,e){return this.uint32[1*t+0]=e,t}}Ms.prototype.bytesPerElement=4,ra(Ms,"StructArrayLayout1ul4");class As extends us{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e){const r=this.length;return this.resize(r+1),this.emplace(r,t,e)}emplace(t,e,r){const n=2*t;return this.uint16[n+0]=e,this.uint16[n+1]=r,t}}As.prototype.bytesPerElement=4,ra(As,"StructArrayLayout2ui4");class Ss extends us{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,a,s,o,l,u,c,h,p){const f=this.length;return this.resize(f+1),this.emplace(f,t,e,r,n,i,a,s,o,l,u,c,h,p)}emplace(t,e,r,n,i,a,s,o,l,u,c,h,p,f){const d=20*t,m=10*t;return this.int16[d+0]=e,this.int16[d+1]=r,this.int16[d+2]=n,this.int16[d+3]=i,this.int16[d+4]=a,this.float32[m+3]=s,this.float32[m+4]=o,this.float32[m+5]=l,this.float32[m+6]=u,this.int16[d+14]=c,this.uint32[m+8]=h,this.uint16[d+18]=p,this.uint16[d+19]=f,t}}Ss.prototype.bytesPerElement=40,ra(Ss,"StructArrayLayout5i4f1i1ul2ui40");class Is extends us{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,a,s){const o=this.length;return this.resize(o+1),this.emplace(o,t,e,r,n,i,a,s)}emplace(t,e,r,n,i,a,s,o){const l=8*t;return this.int16[l+0]=e,this.int16[l+1]=r,this.int16[l+2]=n,this.int16[l+4]=i,this.int16[l+5]=a,this.int16[l+6]=s,this.int16[l+7]=o,t}}Is.prototype.bytesPerElement=16,ra(Is,"StructArrayLayout3i2i2i16");class ks extends us{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i){const a=this.length;return this.resize(a+1),this.emplace(a,t,e,r,n,i)}emplace(t,e,r,n,i,a){const s=4*t,o=8*t;return this.float32[s+0]=e,this.float32[s+1]=r,this.float32[s+2]=n,this.int16[o+6]=i,this.int16[o+7]=a,t}}ks.prototype.bytesPerElement=16,ra(ks,"StructArrayLayout2f1f2i16");class Ps extends us{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n){const i=this.length;return this.resize(i+1),this.emplace(i,t,e,r,n)}emplace(t,e,r,n,i){const a=12*t,s=3*t;return this.uint8[a+0]=e,this.uint8[a+1]=r,this.float32[s+1]=n,this.float32[s+2]=i,t}}Ps.prototype.bytesPerElement=12,ra(Ps,"StructArrayLayout2ub2f12");class Es extends us{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e,r){const n=this.length;return this.resize(n+1),this.emplace(n,t,e,r)}emplace(t,e,r,n){const i=3*t;return this.uint16[i+0]=e,this.uint16[i+1]=r,this.uint16[i+2]=n,t}}Es.prototype.bytesPerElement=6,ra(Es,"StructArrayLayout3ui6");class zs extends us{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,a,s,o,l,u,c,h,p,f,d,m,y,g,x,v,b){const _=this.length;return this.resize(_+1),this.emplace(_,t,e,r,n,i,a,s,o,l,u,c,h,p,f,d,m,y,g,x,v,b)}emplace(t,e,r,n,i,a,s,o,l,u,c,h,p,f,d,m,y,g,x,v,b,_){const w=30*t,M=15*t,A=60*t;return this.int16[w+0]=e,this.int16[w+1]=r,this.int16[w+2]=n,this.float32[M+2]=i,this.float32[M+3]=a,this.uint16[w+8]=s,this.uint16[w+9]=o,this.uint32[M+5]=l,this.uint32[M+6]=u,this.uint32[M+7]=c,this.uint16[w+16]=h,this.uint16[w+17]=p,this.uint16[w+18]=f,this.float32[M+10]=d,this.float32[M+11]=m,this.uint8[A+48]=y,this.uint8[A+49]=g,this.uint8[A+50]=x,this.uint32[M+13]=v,this.int16[w+28]=b,this.uint8[A+58]=_,t}}zs.prototype.bytesPerElement=60,ra(zs,"StructArrayLayout3i2f2ui3ul3ui2f3ub1ul1i1ub60");class Ts extends us{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,a,s,o,l,u,c,h,p,f,d,m,y,g,x,v,b,_,w,M,A,S,I,k,P,E,z,T){const B=this.length;return this.resize(B+1),this.emplace(B,t,e,r,n,i,a,s,o,l,u,c,h,p,f,d,m,y,g,x,v,b,_,w,M,A,S,I,k,P,E,z,T)}emplace(t,e,r,n,i,a,s,o,l,u,c,h,p,f,d,m,y,g,x,v,b,_,w,M,A,S,I,k,P,E,z,T,B){const C=20*t,R=40*t,D=80*t;return this.float32[C+0]=e,this.float32[C+1]=r,this.int16[R+4]=n,this.int16[R+5]=i,this.int16[R+6]=a,this.int16[R+7]=s,this.int16[R+8]=o,this.int16[R+9]=l,this.int16[R+10]=u,this.int16[R+11]=c,this.int16[R+12]=h,this.uint16[R+13]=p,this.uint16[R+14]=f,this.uint16[R+15]=d,this.uint16[R+16]=m,this.uint16[R+17]=y,this.uint16[R+18]=g,this.uint16[R+19]=x,this.uint16[R+20]=v,this.uint16[R+21]=b,this.uint16[R+22]=_,this.uint16[R+23]=w,this.uint16[R+24]=M,this.uint16[R+25]=A,this.uint16[R+26]=S,this.uint16[R+27]=I,this.uint32[C+14]=k,this.float32[C+15]=P,this.float32[C+16]=E,this.float32[C+17]=z,this.float32[C+18]=T,this.uint8[D+76]=B,t}}Ts.prototype.bytesPerElement=80,ra(Ts,"StructArrayLayout2f9i15ui1ul4f1ub80");class Bs extends us{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t){const e=this.length;return this.resize(e+1),this.emplace(e,t)}emplace(t,e){return this.float32[1*t+0]=e,t}}Bs.prototype.bytesPerElement=4,ra(Bs,"StructArrayLayout1f4");class Cs extends us{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i){const a=this.length;return this.resize(a+1),this.emplace(a,t,e,r,n,i)}emplace(t,e,r,n,i,a){const s=5*t;return this.float32[s+0]=e,this.float32[s+1]=r,this.float32[s+2]=n,this.float32[s+3]=i,this.float32[s+4]=a,t}}Cs.prototype.bytesPerElement=20,ra(Cs,"StructArrayLayout5f20");class Rs extends us{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,a,s){const o=this.length;return this.resize(o+1),this.emplace(o,t,e,r,n,i,a,s)}emplace(t,e,r,n,i,a,s,o){const l=7*t;return this.float32[l+0]=e,this.float32[l+1]=r,this.float32[l+2]=n,this.float32[l+3]=i,this.float32[l+4]=a,this.float32[l+5]=s,this.float32[l+6]=o,t}}Rs.prototype.bytesPerElement=28,ra(Rs,"StructArrayLayout7f28");class Ds extends us{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e,r,n){const i=this.length;return this.resize(i+1),this.emplace(i,t,e,r,n)}emplace(t,e,r,n,i){const a=6*t;return this.uint32[3*t+0]=e,this.uint16[a+2]=r,this.uint16[a+3]=n,this.uint16[a+4]=i,t}}Ds.prototype.bytesPerElement=12,ra(Ds,"StructArrayLayout1ul3ui12");class Vs extends us{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t){const e=this.length;return this.resize(e+1),this.emplace(e,t)}emplace(t,e){return this.uint16[1*t+0]=e,t}}Vs.prototype.bytesPerElement=2,ra(Vs,"StructArrayLayout1ui2");class Ls extends us{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r){const n=this.length;return this.resize(n+1),this.emplace(n,t,e,r)}emplace(t,e,r,n){const i=3*t;return this.float32[i+0]=e,this.float32[i+1]=r,this.float32[i+2]=n,t}}Ls.prototype.bytesPerElement=12,ra(Ls,"StructArrayLayout3f12");class Fs extends us{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e){const r=this.length;return this.resize(r+1),this.emplace(r,t,e)}emplace(t,e,r){const n=2*t;return this.float32[n+0]=e,this.float32[n+1]=r,t}}Fs.prototype.bytesPerElement=8,ra(Fs,"StructArrayLayout2f8");class Ns extends us{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,a,s,o,l,u,c,h,p,f,d,m){const y=this.length;return this.resize(y+1),this.emplace(y,t,e,r,n,i,a,s,o,l,u,c,h,p,f,d,m)}emplace(t,e,r,n,i,a,s,o,l,u,c,h,p,f,d,m,y){const g=16*t;return this.float32[g+0]=e,this.float32[g+1]=r,this.float32[g+2]=n,this.float32[g+3]=i,this.float32[g+4]=a,this.float32[g+5]=s,this.float32[g+6]=o,this.float32[g+7]=l,this.float32[g+8]=u,this.float32[g+9]=c,this.float32[g+10]=h,this.float32[g+11]=p,this.float32[g+12]=f,this.float32[g+13]=d,this.float32[g+14]=m,this.float32[g+15]=y,t}}Ns.prototype.bytesPerElement=64,ra(Ns,"StructArrayLayout16f64");class Os extends us{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,a,s){const o=this.length;return this.resize(o+1),this.emplace(o,t,e,r,n,i,a,s)}emplace(t,e,r,n,i,a,s,o){const l=10*t,u=5*t;return this.uint16[l+0]=e,this.uint16[l+1]=r,this.uint16[l+2]=n,this.uint16[l+3]=i,this.float32[u+2]=a,this.float32[u+3]=s,this.float32[u+4]=o,t}}Os.prototype.bytesPerElement=20,ra(Os,"StructArrayLayout4ui3f20");class Us extends us{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer);}emplaceBack(t){const e=this.length;return this.resize(e+1),this.emplace(e,t)}emplace(t,e){return this.uint8[1*t+0]=e,t}}Us.prototype.bytesPerElement=1,ra(Us,"StructArrayLayout1ub1");class js extends ls{get projectedAnchorX(){return this._structArray.int16[this._pos2+0]}get projectedAnchorY(){return this._structArray.int16[this._pos2+1]}get projectedAnchorZ(){return this._structArray.int16[this._pos2+2]}get tileAnchorX(){return this._structArray.int16[this._pos2+3]}get tileAnchorY(){return this._structArray.int16[this._pos2+4]}get x1(){return this._structArray.float32[this._pos4+3]}get y1(){return this._structArray.float32[this._pos4+4]}get x2(){return this._structArray.float32[this._pos4+5]}get y2(){return this._structArray.float32[this._pos4+6]}get padding(){return this._structArray.int16[this._pos2+14]}get featureIndex(){return this._structArray.uint32[this._pos4+8]}get sourceLayerIndex(){return this._structArray.uint16[this._pos2+18]}get bucketIndex(){return this._structArray.uint16[this._pos2+19]}}js.prototype.size=40;class qs extends Ss{get(t){return new js(this,t)}}ra(qs,"CollisionBoxArray");class $s extends ls{get projectedAnchorX(){return this._structArray.int16[this._pos2+0]}get projectedAnchorY(){return this._structArray.int16[this._pos2+1]}get projectedAnchorZ(){return this._structArray.int16[this._pos2+2]}get tileAnchorX(){return this._structArray.float32[this._pos4+2]}get tileAnchorY(){return this._structArray.float32[this._pos4+3]}get glyphStartIndex(){return this._structArray.uint16[this._pos2+8]}get numGlyphs(){return this._structArray.uint16[this._pos2+9]}get vertexStartIndex(){return this._structArray.uint32[this._pos4+5]}get lineStartIndex(){return this._structArray.uint32[this._pos4+6]}get lineLength(){return this._structArray.uint32[this._pos4+7]}get segment(){return this._structArray.uint16[this._pos2+16]}get lowerSize(){return this._structArray.uint16[this._pos2+17]}get upperSize(){return this._structArray.uint16[this._pos2+18]}get lineOffsetX(){return this._structArray.float32[this._pos4+10]}get lineOffsetY(){return this._structArray.float32[this._pos4+11]}get writingMode(){return this._structArray.uint8[this._pos1+48]}get placedOrientation(){return this._structArray.uint8[this._pos1+49]}set placedOrientation(t){this._structArray.uint8[this._pos1+49]=t;}get hidden(){return this._structArray.uint8[this._pos1+50]}set hidden(t){this._structArray.uint8[this._pos1+50]=t;}get crossTileID(){return this._structArray.uint32[this._pos4+13]}set crossTileID(t){this._structArray.uint32[this._pos4+13]=t;}get associatedIconIndex(){return this._structArray.int16[this._pos2+28]}get flipState(){return this._structArray.uint8[this._pos1+58]}set flipState(t){this._structArray.uint8[this._pos1+58]=t;}}$s.prototype.size=60;class Gs extends zs{get(t){return new $s(this,t)}}ra(Gs,"PlacedSymbolArray");class Ys extends ls{get tileAnchorX(){return this._structArray.float32[this._pos4+0]}get tileAnchorY(){return this._structArray.float32[this._pos4+1]}get projectedAnchorX(){return this._structArray.int16[this._pos2+4]}get projectedAnchorY(){return this._structArray.int16[this._pos2+5]}get projectedAnchorZ(){return this._structArray.int16[this._pos2+6]}get rightJustifiedTextSymbolIndex(){return this._structArray.int16[this._pos2+7]}get centerJustifiedTextSymbolIndex(){return this._structArray.int16[this._pos2+8]}get leftJustifiedTextSymbolIndex(){return this._structArray.int16[this._pos2+9]}get verticalPlacedTextSymbolIndex(){return this._structArray.int16[this._pos2+10]}get placedIconSymbolIndex(){return this._structArray.int16[this._pos2+11]}get verticalPlacedIconSymbolIndex(){return this._structArray.int16[this._pos2+12]}get key(){return this._structArray.uint16[this._pos2+13]}get textBoxStartIndex(){return this._structArray.uint16[this._pos2+14]}get textBoxEndIndex(){return this._structArray.uint16[this._pos2+15]}get verticalTextBoxStartIndex(){return this._structArray.uint16[this._pos2+16]}get verticalTextBoxEndIndex(){return this._structArray.uint16[this._pos2+17]}get iconBoxStartIndex(){return this._structArray.uint16[this._pos2+18]}get iconBoxEndIndex(){return this._structArray.uint16[this._pos2+19]}get verticalIconBoxStartIndex(){return this._structArray.uint16[this._pos2+20]}get verticalIconBoxEndIndex(){return this._structArray.uint16[this._pos2+21]}get featureIndex(){return this._structArray.uint16[this._pos2+22]}get numHorizontalGlyphVertices(){return this._structArray.uint16[this._pos2+23]}get numVerticalGlyphVertices(){return this._structArray.uint16[this._pos2+24]}get numIconVertices(){return this._structArray.uint16[this._pos2+25]}get numVerticalIconVertices(){return this._structArray.uint16[this._pos2+26]}get useRuntimeCollisionCircles(){return this._structArray.uint16[this._pos2+27]}get crossTileID(){return this._structArray.uint32[this._pos4+14]}set crossTileID(t){this._structArray.uint32[this._pos4+14]=t;}get textOffset0(){return this._structArray.float32[this._pos4+15]}get textOffset1(){return this._structArray.float32[this._pos4+16]}get collisionCircleDiameter(){return this._structArray.float32[this._pos4+17]}get zOffset(){return this._structArray.float32[this._pos4+18]}set zOffset(t){this._structArray.float32[this._pos4+18]=t;}get hasIconTextFit(){return this._structArray.uint8[this._pos1+76]}}Ys.prototype.size=80;class Xs extends Ts{get(t){return new Ys(this,t)}}ra(Xs,"SymbolInstanceArray");class Zs extends Bs{getoffsetX(t){return this.float32[1*t+0]}}ra(Zs,"GlyphOffsetArray");class Ks extends ps{getx(t){return this.int16[2*t+0]}gety(t){return this.int16[2*t+1]}}ra(Ks,"SymbolLineVertexArray");class Hs extends ls{get featureIndex(){return this._structArray.uint32[this._pos4+0]}get sourceLayerIndex(){return this._structArray.uint16[this._pos2+2]}get bucketIndex(){return this._structArray.uint16[this._pos2+3]}get layoutVertexArrayOffset(){return this._structArray.uint16[this._pos2+4]}}Hs.prototype.size=12;class Ws extends Ds{get(t){return new Hs(this,t)}}ra(Ws,"FeatureIndexArray");class Js extends As{geta_centroid_pos0(t){return this.uint16[2*t+0]}geta_centroid_pos1(t){return this.uint16[2*t+1]}}ra(Js,"FillExtrusionCentroidArray");const Qs=cs([{name:"a_pos",components:2,type:"Int16"}],4),to=cs([{name:"a_pos_3",components:3,type:"Int16"},{name:"a_pos_normal_3",components:3,type:"Int16"}]);class eo{constructor(t=[]){this.segments=t;}_prepareSegment(t,e,r,n){let i=this.segments[this.segments.length-1];return t>eo.MAX_VERTEX_ARRAY_LENGTH&&j(`Max vertices per segment is ${eo.MAX_VERTEX_ARRAY_LENGTH}: bucket requested ${t}`),(!i||i.vertexLength+t>eo.MAX_VERTEX_ARRAY_LENGTH||i.sortKey!==n)&&(i={vertexOffset:e,primitiveOffset:r,vertexLength:0,primitiveLength:0},void 0!==n&&(i.sortKey=n),this.segments.push(i)),i}prepareSegment(t,e,r,n){return this._prepareSegment(t,e.length,r.length,n)}get(){return this.segments}destroy(){for(const t of this.segments)for(const e in t.vaos)t.vaos[e].destroy();}static simpleSegment(t,e,r,n){return new eo([{vertexOffset:t,primitiveOffset:e,vertexLength:r,primitiveLength:n,vaos:{},sortKey:0}])}}function ro(t,e){return 256*(t=I(Math.floor(t),0,255))+I(Math.floor(e),0,255)}eo.MAX_VERTEX_ARRAY_LENGTH=Math.pow(2,16)-1,ra(eo,"SegmentVector");const no=cs([{name:"a_pattern",components:4,type:"Uint16"},{name:"a_pixel_ratio",components:1,type:"Float32"}]),io=cs([{name:"a_dash",components:4,type:"Uint16"}]);var ao={exports:{}},so={exports:{}};!function(t){t.exports=function(t,e){var r,n,i,a,s,o,l,u;for(n=t.length-(r=3&t.length),i=e,s=3432918353,o=461845907,u=0;u<n;)l=255&t.charCodeAt(u)|(255&t.charCodeAt(++u))<<8|(255&t.charCodeAt(++u))<<16|(255&t.charCodeAt(++u))<<24,++u,i=27492+(65535&(a=5*(65535&(i=(i^=l=(65535&(l=(l=(65535&l)*s+(((l>>>16)*s&65535)<<16)&4294967295)<<15|l>>>17))*o+(((l>>>16)*o&65535)<<16)&4294967295)<<13|i>>>19))+((5*(i>>>16)&65535)<<16)&4294967295))+((58964+(a>>>16)&65535)<<16);switch(l=0,r){case 3:l^=(255&t.charCodeAt(u+2))<<16;case 2:l^=(255&t.charCodeAt(u+1))<<8;case 1:i^=l=(65535&(l=(l=(65535&(l^=255&t.charCodeAt(u)))*s+(((l>>>16)*s&65535)<<16)&4294967295)<<15|l>>>17))*o+(((l>>>16)*o&65535)<<16)&4294967295;}return i^=t.length,i=2246822507*(65535&(i^=i>>>16))+((2246822507*(i>>>16)&65535)<<16)&4294967295,i=3266489909*(65535&(i^=i>>>13))+((3266489909*(i>>>16)&65535)<<16)&4294967295,(i^=i>>>16)>>>0};}(so);var oo=so.exports,lo={exports:{}};!function(t){t.exports=function(t,e){for(var r,n=t.length,i=e^n,a=0;n>=4;)r=1540483477*(65535&(r=255&t.charCodeAt(a)|(255&t.charCodeAt(++a))<<8|(255&t.charCodeAt(++a))<<16|(255&t.charCodeAt(++a))<<24))+((1540483477*(r>>>16)&65535)<<16),i=1540483477*(65535&i)+((1540483477*(i>>>16)&65535)<<16)^(r=1540483477*(65535&(r^=r>>>24))+((1540483477*(r>>>16)&65535)<<16)),n-=4,++a;switch(n){case 3:i^=(255&t.charCodeAt(a+2))<<16;case 2:i^=(255&t.charCodeAt(a+1))<<8;case 1:i=1540483477*(65535&(i^=255&t.charCodeAt(a)))+((1540483477*(i>>>16)&65535)<<16);}return i=1540483477*(65535&(i^=i>>>13))+((1540483477*(i>>>16)&65535)<<16),(i^=i>>>15)>>>0};}(lo);var uo=oo,co=lo.exports;ao.exports=uo,ao.exports.murmur3=uo,ao.exports.murmur2=co;var ho=h(ao.exports);class po{constructor(){this.ids=[],this.uniqueIds=[],this.positions=[],this.indexed=!1;}add(t,e,r,n){this.ids.push(fo(t)),this.positions.push(e,r,n);}eachPosition(t,e){const r=fo(t);let n=0,i=this.ids.length-1;for(;n<i;){const t=n+i>>1;this.ids[t]>=r?i=t:n=t+1;}for(;this.ids[n]===r;)e(this.positions[3*n],this.positions[3*n+1],this.positions[3*n+2]),n++;}static serialize(t,e){const r=new Float64Array(t.ids),n=new Uint32Array(t.positions);return mo(r,n,0,r.length-1),e&&(e.add(r.buffer),e.add(n.buffer)),{ids:r,positions:n}}static deserialize(t){const e=new po;let r;e.ids=t.ids,e.positions=t.positions;for(const t of e.ids)t!==r&&e.uniqueIds.push(t),r=t;return e.indexed=!0,e}}function fo(t){const e=+t;return !isNaN(e)&&Number.MIN_SAFE_INTEGER<=e&&e<=Number.MAX_SAFE_INTEGER?e:ho(String(t))}function mo(t,e,r,n){for(;r<n;){const i=t[r+n>>1];let a=r-1,s=n+1;for(;;){do{a++;}while(t[a]<i);do{s--;}while(t[s]>i);if(a>=s)break;yo(t,a,s),yo(e,3*a,3*s),yo(e,3*a+1,3*s+1),yo(e,3*a+2,3*s+2);}s-r<n-s?(mo(t,e,r,s),r=s+1):(mo(t,e,s+1,n),n=s);}}function yo(t,e,r){const n=t[e];t[e]=t[r],t[r]=n;}ra(po,"FeaturePositionMap");class go{constructor(t){this.gl=t.gl,this.initialized=!1;}fetchUniformLocation(t,e){return this.location||this.initialized||(this.location=this.gl.getUniformLocation(t,e),this.initialized=!0),!!this.location}}class xo extends go{constructor(t){super(t),this.current=0;}set(t,e,r){this.fetchUniformLocation(t,e)&&this.current!==r&&(this.current=r,this.gl.uniform1i(this.location,r));}}class vo extends go{constructor(t){super(t),this.current=0;}set(t,e,r){this.fetchUniformLocation(t,e)&&this.current!==r&&(this.current=r,this.gl.uniform1f(this.location,r));}}class bo extends go{constructor(t){super(t),this.current=[0,0];}set(t,e,r){this.fetchUniformLocation(t,e)&&(r[0]===this.current[0]&&r[1]===this.current[1]||(this.current=r,this.gl.uniform2f(this.location,r[0],r[1])));}}class _o extends go{constructor(t){super(t),this.current=[0,0,0];}set(t,e,r){this.fetchUniformLocation(t,e)&&(r[0]===this.current[0]&&r[1]===this.current[1]&&r[2]===this.current[2]||(this.current=r,this.gl.uniform3f(this.location,r[0],r[1],r[2])));}}class wo extends go{constructor(t){super(t),this.current=[0,0,0,0];}set(t,e,r){this.fetchUniformLocation(t,e)&&(r[0]===this.current[0]&&r[1]===this.current[1]&&r[2]===this.current[2]&&r[3]===this.current[3]||(this.current=r,this.gl.uniform4f(this.location,r[0],r[1],r[2],r[3])));}}class Mo extends go{constructor(t){super(t),this.current=le.transparent;}set(t,e,r){this.fetchUniformLocation(t,e)&&(r.r===this.current.r&&r.g===this.current.g&&r.b===this.current.b&&r.a===this.current.a||(this.current=r,this.gl.uniform4f(this.location,r.r,r.g,r.b,r.a)));}}const Ao=new Float32Array(16);class So extends go{constructor(t){super(t),this.current=Ao;}set(t,e,r){if(this.fetchUniformLocation(t,e)){if(r[12]!==this.current[12]||r[0]!==this.current[0])return this.current=r,void this.gl.uniformMatrix4fv(this.location,!1,r);for(let t=1;t<16;t++)if(r[t]!==this.current[t]){this.current=r,this.gl.uniformMatrix4fv(this.location,!1,r);break}}}}const Io=new Float32Array(9),ko=new Float32Array(4);class Po extends go{constructor(t){super(t),this.current=ko;}set(t,e,r){if(this.fetchUniformLocation(t,e))for(let t=0;t<4;t++)if(r[t]!==this.current[t]){this.current=r,this.gl.uniformMatrix2fv(this.location,!1,r);break}}}function Eo(t){return [ro(255*t.r,255*t.g),ro(255*t.b,255*t.a)]}class zo{constructor(t,e,r){this.value=t,this.uniformNames=e.map((t=>`u_${t}`)),this.type=r;}setUniform(t,e,r,n,i){e.set(t,i,n.constantOr(this.value));}getBinding(t,e){return "color"===this.type?new Mo(t):new vo(t)}}class To{constructor(t,e){this.uniformNames=e.map((t=>`u_${t}`)),this.pattern=null,this.pixelRatio=1;}setConstantPatternPositions(t){this.pixelRatio=t.pixelRatio||1,this.pattern=t.tl.concat(t.br);}setUniform(t,e,r,n,i){const a="u_pattern"===i||"u_dash"===i?this.pattern:"u_pixel_ratio"===i?this.pixelRatio:null;a&&e.set(t,i,a);}getBinding(t,e){return "u_pattern"===e||"u_dash"===e?new wo(t):new vo(t)}}class Bo{constructor(t,e,r,n){this.expression=t,this.type=r,this.maxValue=0,this.paintVertexAttributes=e.map((t=>({name:`a_${t}`,type:"Float32",components:"color"===r?2:1,offset:0}))),this.paintVertexArray=new n;}populatePaintArray(t,e,r,n,i,a,s){const o=this.paintVertexArray.length,l=this.expression.evaluate(new Pa(0,{brightness:a}),e,{},i,n,s);this.paintVertexArray.resize(t),this._setPaintValue(o,t,l);}updatePaintArray(t,e,r,n,i,a,s){const o=this.expression.evaluate({zoom:0,brightness:s},r,n,void 0,i);this._setPaintValue(t,e,o);}_setPaintValue(t,e,r){if("color"===this.type){const n=Eo(r);for(let r=t;r<e;r++)this.paintVertexArray.emplace(r,n[0],n[1]);}else {for(let n=t;n<e;n++)this.paintVertexArray.emplace(n,r);this.maxValue=Math.max(this.maxValue,Math.abs(r));}}upload(t){this.paintVertexArray&&this.paintVertexArray.arrayBuffer&&(this.paintVertexBuffer&&this.paintVertexBuffer.buffer?this.paintVertexBuffer.updateData(this.paintVertexArray):this.paintVertexBuffer=t.createVertexBuffer(this.paintVertexArray,this.paintVertexAttributes,this.expression.isStateDependent||!this.expression.isLightConstant));}destroy(){this.paintVertexBuffer&&this.paintVertexBuffer.destroy();}}class Co{constructor(t,e,r,n,i,a){this.expression=t,this.uniformNames=e.map((t=>`u_${t}_t`)),this.type=r,this.useIntegerZoom=n,this.zoom=i,this.maxValue=0,this.paintVertexAttributes=e.map((t=>({name:`a_${t}`,type:"Float32",components:"color"===r?4:2,offset:0}))),this.paintVertexArray=new a;}populatePaintArray(t,e,r,n,i,a,s){const o=this.expression.evaluate(new Pa(this.zoom,{brightness:a}),e,{},i,n,s),l=this.expression.evaluate(new Pa(this.zoom+1,{brightness:a}),e,{},i,n,s),u=this.paintVertexArray.length;this.paintVertexArray.resize(t),this._setPaintValue(u,t,o,l);}updatePaintArray(t,e,r,n,i,a,s){const o=this.expression.evaluate({zoom:this.zoom,brightness:s},r,n,void 0,i),l=this.expression.evaluate({zoom:this.zoom+1,brightness:s},r,n,void 0,i);this._setPaintValue(t,e,o,l);}_setPaintValue(t,e,r,n){if("color"===this.type){const i=Eo(r),a=Eo(n);for(let r=t;r<e;r++)this.paintVertexArray.emplace(r,i[0],i[1],a[0],a[1]);}else {for(let i=t;i<e;i++)this.paintVertexArray.emplace(i,r,n);this.maxValue=Math.max(this.maxValue,Math.abs(r),Math.abs(n));}}upload(t){this.paintVertexArray&&this.paintVertexArray.arrayBuffer&&(this.paintVertexBuffer&&this.paintVertexBuffer.buffer?this.paintVertexBuffer.updateData(this.paintVertexArray):this.paintVertexBuffer=t.createVertexBuffer(this.paintVertexArray,this.paintVertexAttributes,this.expression.isStateDependent||!this.expression.isLightConstant));}destroy(){this.paintVertexBuffer&&this.paintVertexBuffer.destroy();}setUniform(t,e,r,n,i){const a=this.useIntegerZoom?Math.floor(r.zoom):r.zoom,s=I(this.expression.interpolationFactor(a,this.zoom,this.zoom+1),0,1);e.set(t,i,s);}getBinding(t,e){return new vo(t)}}class Ro{constructor(t,e,r,n,i){this.expression=t,this.layerId=i,this.paintVertexAttributes=("array"===r?io:no).members;for(let t=0;t<e.length;++t);this.paintVertexArray=new n;}populatePaintArray(t,e,r){const n=this.paintVertexArray.length;this.paintVertexArray.resize(t),this._setPaintValues(n,t,e.patterns&&e.patterns[this.layerId],r);}updatePaintArray(t,e,r,n,i,a,s){this._setPaintValues(t,e,r.patterns&&r.patterns[this.layerId],a);}_setPaintValues(t,e,r,n){if(!n||!r)return;const i=n[r];if(!i)return;const{tl:a,br:s,pixelRatio:o}=i;for(let r=t;r<e;r++)this.paintVertexArray.emplace(r,a[0],a[1],s[0],s[1],o);}upload(t){this.paintVertexArray&&this.paintVertexArray.arrayBuffer&&(this.paintVertexBuffer=t.createVertexBuffer(this.paintVertexArray,this.paintVertexAttributes,this.expression.isStateDependent||!this.expression.isLightConstant));}destroy(){this.paintVertexBuffer&&this.paintVertexBuffer.destroy();}}class Do{constructor(t,e,r=(()=>!0)){this.binders={},this._buffers=[];const n=[];for(const i in t.paint._values){const a=t.paint.get(i);if(!r(i))continue;if(!(a instanceof Da&&Ti(a.property.specification)))continue;const s=Fo(i,t.type),o=a.value,l=a.property.specification.type,u=!!a.property.useIntegerZoom,c="line-dasharray"===i||i.endsWith("pattern"),h="line-dasharray"===i&&"constant"!==t.layout.get("line-cap").value.kind;if("constant"!==o.kind||h)if("source"===o.kind||h||c){const e=Uo(i,l,"source");this.binders[i]=c?new Ro(o,s,l,e,t.id):new Bo(o,s,l,e),n.push(`/a_${i}`);}else {const t=Uo(i,l,"composite");this.binders[i]=new Co(o,s,l,u,e,t),n.push(`/z_${i}`);}else this.binders[i]=c?new To(o.value,s):new zo(o.value,s,l),n.push(`/u_${i}`);}this.cacheKey=n.sort().join("");}getMaxValue(t){const e=this.binders[t];return e instanceof Bo||e instanceof Co?e.maxValue:0}populatePaintArrays(t,e,r,n,i,a,s){for(const o in this.binders){const l=this.binders[o];(l instanceof Bo||l instanceof Co||l instanceof Ro)&&l.populatePaintArray(t,e,r,n,i,a,s);}}setConstantPatternPositions(t){for(const e in this.binders){const r=this.binders[e];r instanceof To&&r.setConstantPatternPositions(t);}}updatePaintArrays(t,e,r,n,i,a,s,o){let l=!1;const u=Object.keys(t),c=0!==u.length,h=c?u:e.uniqueIds;for(const u in this.binders){const p=this.binders[u];if((p instanceof Bo||p instanceof Co||p instanceof Ro)&&(!0===p.expression.isStateDependent||!1===p.expression.isLightConstant)){const f=i.paint.get(u);p.expression=f.value;for(const r of h){const i=t[r.toString()];e.eachPosition(r,((t,e,r)=>{const l=n.feature(t);p.updatePaintArray(e,r,l,i,a,s,o);}));}if(!c)for(const e of r.uniqueIds){const i=t[e.toString()];r.eachPosition(e,((t,e,r)=>{const l=n.feature(t);p.updatePaintArray(e,r,l,i,a,s,o);}));}l=!0;}}return l}defines(){const t=[];for(const e in this.binders){const r=this.binders[e];(r instanceof zo||r instanceof To)&&t.push(...r.uniformNames.map((t=>`#define HAS_UNIFORM_${t}`)));}return t}getBinderAttributes(){const t=[];for(const e in this.binders){const r=this.binders[e];if(r instanceof Bo||r instanceof Co||r instanceof Ro)for(let e=0;e<r.paintVertexAttributes.length;e++)t.push(r.paintVertexAttributes[e].name);}return t}getBinderUniforms(){const t=[];for(const e in this.binders){const r=this.binders[e];if(r instanceof zo||r instanceof To||r instanceof Co)for(const e of r.uniformNames)t.push(e);}return t}getPaintVertexBuffers(){return this._buffers}getUniforms(t){const e=[];for(const r in this.binders){const n=this.binders[r];if(n instanceof zo||n instanceof To||n instanceof Co)for(const i of n.uniformNames)e.push({name:i,property:r,binding:n.getBinding(t,i)});}return e}setUniforms(t,e,r,n,i){for(const{name:e,property:a,binding:s}of r)this.binders[a].setUniform(t,s,i,n.get(a),e);}updatePaintBuffers(){this._buffers=[];for(const t in this.binders){const e=this.binders[t];(e instanceof Bo||e instanceof Co||e instanceof Ro)&&e.paintVertexBuffer&&this._buffers.push(e.paintVertexBuffer);}}upload(t){for(const e in this.binders){const r=this.binders[e];(r instanceof Bo||r instanceof Co||r instanceof Ro)&&r.upload(t);}this.updatePaintBuffers();}destroy(){for(const t in this.binders){const e=this.binders[t];(e instanceof Bo||e instanceof Co||e instanceof Ro)&&e.destroy();}}}class Vo{constructor(t,e,r=(()=>!0)){this.programConfigurations={};for(const n of t)this.programConfigurations[n.id]=new Do(n,e,r);this.needsUpload=!1,this._featureMap=new po,this._featureMapWithoutIds=new po,this._bufferOffset=0,this._idlessCounter=0;}populatePaintArrays(t,e,r,n,i,a,s,o){for(const r in this.programConfigurations)this.programConfigurations[r].populatePaintArrays(t,e,n,i,a,s,o);void 0!==e.id?this._featureMap.add(e.id,r,this._bufferOffset,t):(this._featureMapWithoutIds.add(this._idlessCounter,r,this._bufferOffset,t),this._idlessCounter+=1),this._bufferOffset=t,this.needsUpload=!0;}updatePaintArrays(t,e,r,n,i,a){for(const s of r)this.needsUpload=this.programConfigurations[s.id].updatePaintArrays(t,this._featureMap,this._featureMapWithoutIds,e,s,n,i,a||0)||this.needsUpload;}get(t){return this.programConfigurations[t]}upload(t){if(this.needsUpload){for(const e in this.programConfigurations)this.programConfigurations[e].upload(t);this.needsUpload=!1;}}destroy(){for(const t in this.programConfigurations)this.programConfigurations[t].destroy();}}const Lo={"text-opacity":["opacity"],"icon-opacity":["opacity"],"text-color":["fill_color"],"icon-color":["fill_color"],"text-emissive-strength":["emissive_strength"],"icon-emissive-strength":["emissive_strength"],"text-halo-color":["halo_color"],"icon-halo-color":["halo_color"],"text-halo-blur":["halo_blur"],"icon-halo-blur":["halo_blur"],"text-halo-width":["halo_width"],"icon-halo-width":["halo_width"],"line-gap-width":["gapwidth"],"line-pattern":["pattern","pixel_ratio"],"fill-pattern":["pattern","pixel_ratio"],"fill-extrusion-pattern":["pattern","pixel_ratio"],"line-dasharray":["dash"]};function Fo(t,e){return Lo[t]||[t.replace(`${e}-`,"").replace(/-/g,"_")]}const No={"line-pattern":{source:xs,composite:xs},"fill-pattern":{source:xs,composite:xs},"fill-extrusion-pattern":{source:xs,composite:xs},"line-dasharray":{source:vs,composite:vs}},Oo={color:{source:Fs,composite:gs},number:{source:Bs,composite:Fs}};function Uo(t,e,r){const n=No[t];return n&&n[r]||Oo[e][r]}ra(zo,"ConstantBinder"),ra(To,"PatternConstantBinder"),ra(Bo,"SourceExpressionBinder"),ra(Ro,"PatternCompositeBinder"),ra(Co,"CompositeExpressionBinder"),ra(Do,"ProgramConfiguration",{omit:["_buffers"]}),ra(Vo,"ProgramConfigurationSet");const jo=Tr/Math.PI/2,qo=5,$o=6,Go=16383,Yo=64,Xo=[Yo,32,16],Zo=-jo,Ko=jo;function Ho(t,e,r,n=jo){return r=b(r),[t*Math.sin(r)*n,-e*n,t*Math.cos(r)*n]}function Wo(t,e,r){return Ho(Math.cos(b(t)),Math.sin(b(t)),e,r)}const Jo=6371008.8,Qo=2*Math.PI*Jo;class tl{constructor(t,e){if(isNaN(t)||isNaN(e))throw new Error(`Invalid LngLat object: (${t}, ${e})`);if(this.lng=+t,this.lat=+e,this.lat>90||this.lat<-90)throw new Error("Invalid LngLat latitude value: must be between -90 and 90")}wrap(){return new tl(P(this.lng,-180,180),this.lat)}toArray(){return [this.lng,this.lat]}toString(){return `LngLat(${this.lng}, ${this.lat})`}distanceTo(t){const e=Math.PI/180,r=this.lat*e,n=t.lat*e,i=Math.sin(r)*Math.sin(n)+Math.cos(r)*Math.cos(n)*Math.cos((t.lng-this.lng)*e);return Jo*Math.acos(Math.min(i,1))}toBounds(t=0){const e=360*t/40075017,r=e/Math.cos(Math.PI/180*this.lat);return new el({lng:this.lng-r,lat:this.lat-e},{lng:this.lng+r,lat:this.lat+e})}toEcef(t){return Wo(this.lat,this.lng,jo+t*jo/Jo)}static convert(t){if(t instanceof tl)return t;if(Array.isArray(t)&&(2===t.length||3===t.length))return new tl(Number(t[0]),Number(t[1]));if(!Array.isArray(t)&&"object"==typeof t&&null!==t)return new tl(Number("lng"in t?t.lng:t.lon),Number(t.lat));throw new Error("`LngLatLike` argument must be specified as a LngLat instance, an object {lng: <lng>, lat: <lat>}, an object {lon: <lng>, lat: <lat>}, or an array of [<lng>, <lat>]")}}class el{constructor(t,e){t&&(e?this.setSouthWest(t).setNorthEast(e):4===t.length?this.setSouthWest([t[0],t[1]]).setNorthEast([t[2],t[3]]):this.setSouthWest(t[0]).setNorthEast(t[1]));}setNorthEast(t){return this._ne=t instanceof tl?new tl(t.lng,t.lat):tl.convert(t),this}setSouthWest(t){return this._sw=t instanceof tl?new tl(t.lng,t.lat):tl.convert(t),this}extend(t){const e=this._sw,r=this._ne;let n,i;if(t instanceof tl)n=t,i=t;else {if(!(t instanceof el))return Array.isArray(t)?4===t.length||t.every(Array.isArray)?this.extend(el.convert(t)):this.extend(tl.convert(t)):"object"==typeof t&&null!==t&&t.hasOwnProperty("lat")&&(t.hasOwnProperty("lon")||t.hasOwnProperty("lng"))?this.extend(tl.convert(t)):this;if(n=t._sw,i=t._ne,!n||!i)return this}return e||r?(e.lng=Math.min(n.lng,e.lng),e.lat=Math.min(n.lat,e.lat),r.lng=Math.max(i.lng,r.lng),r.lat=Math.max(i.lat,r.lat)):(this._sw=new tl(n.lng,n.lat),this._ne=new tl(i.lng,i.lat)),this}getCenter(){return new tl((this._sw.lng+this._ne.lng)/2,(this._sw.lat+this._ne.lat)/2)}getSouthWest(){return this._sw}getNorthEast(){return this._ne}getNorthWest(){return new tl(this.getWest(),this.getNorth())}getSouthEast(){return new tl(this.getEast(),this.getSouth())}getWest(){return this._sw.lng}getSouth(){return this._sw.lat}getEast(){return this._ne.lng}getNorth(){return this._ne.lat}toArray(){return [this._sw.toArray(),this._ne.toArray()]}toString(){return `LngLatBounds(${this._sw.toString()}, ${this._ne.toString()})`}isEmpty(){return !(this._sw&&this._ne)}contains(t){const{lng:e,lat:r}=tl.convert(t);let n=this._sw.lng<=e&&e<=this._ne.lng;return this._sw.lng>this._ne.lng&&(n=this._sw.lng>=e&&e>=this._ne.lng),this._sw.lat<=r&&r<=this._ne.lat&&n}static convert(t){return !t||t instanceof el?t:new el(t)}}var rl={};!function(t,e){!function(t){function e(t,e,n){var i=r(256*t,256*(e=Math.pow(2,n)-e-1),n),a=r(256*(t+1),256*(e+1),n);return i[0]+","+i[1]+","+a[0]+","+a[1]}function r(t,e,r){var n=2*Math.PI*6378137/256/Math.pow(2,r);return [t*n-2*Math.PI*6378137/2,e*n-2*Math.PI*6378137/2]}t.getURL=function(t,r,n,i,a,s){return s=s||{},t+"?"+["bbox="+e(n,i,a),"format="+(s.format||"image/png"),"service="+(s.service||"WMS"),"version="+(s.version||"1.1.1"),"request="+(s.request||"GetMap"),"srs="+(s.srs||"EPSG:3857"),"width="+(s.width||256),"height="+(s.height||256),"layers="+r].join("&")},t.getTileBBox=e,t.getMercCoords=r,Object.defineProperty(t,"__esModule",{value:!0});}(e);}(0,rl);var nl=rl;class il{constructor(t,e,r){this.z=t,this.x=e,this.y=r,this.key=ol(0,t,t,e,r);}equals(t){return this.z===t.z&&this.x===t.x&&this.y===t.y}url(t,e){const r=nl.getTileBBox(this.x,this.y,this.z),n=function(t,e,r){let n,i="";for(let a=t;a>0;a--)n=1<<a-1,i+=(e&n?1:0)+(r&n?2:0);return i}(this.z,this.x,this.y);return t[(this.x+this.y)%t.length].replace("{prefix}",(this.x%16).toString(16)+(this.y%16).toString(16)).replace(/{z}/g,String(this.z)).replace(/{x}/g,String(this.x)).replace(/{y}/g,String("tms"===e?Math.pow(2,this.z)-this.y-1:this.y)).replace("{quadkey}",n).replace("{bbox-epsg-3857}",r)}toString(){return `${this.z}/${this.x}/${this.y}`}}class al{constructor(t,e){this.wrap=t,this.canonical=e,this.key=ol(t,e.z,e.z,e.x,e.y);}}class sl{constructor(t,e,r,n,i){this.overscaledZ=t,this.wrap=e,this.canonical=new il(r,+n,+i),this.key=0===e&&t===r?this.canonical.key:ol(e,t,r,n,i);}equals(t){return this.overscaledZ===t.overscaledZ&&this.wrap===t.wrap&&this.canonical.equals(t.canonical)}scaledTo(t){const e=this.canonical.z-t;return t>this.canonical.z?new sl(t,this.wrap,this.canonical.z,this.canonical.x,this.canonical.y):new sl(t,this.wrap,t,this.canonical.x>>e,this.canonical.y>>e)}calculateScaledKey(t,e=!0){if(this.overscaledZ===t&&e)return this.key;if(t>this.canonical.z)return ol(this.wrap*+e,t,this.canonical.z,this.canonical.x,this.canonical.y);{const r=this.canonical.z-t;return ol(this.wrap*+e,t,t,this.canonical.x>>r,this.canonical.y>>r)}}isChildOf(t){if(t.wrap!==this.wrap)return !1;const e=this.canonical.z-t.canonical.z;return 0===t.overscaledZ||t.overscaledZ<this.overscaledZ&&t.canonical.z<this.canonical.z&&t.canonical.x===this.canonical.x>>e&&t.canonical.y===this.canonical.y>>e}children(t){if(this.overscaledZ>=t)return [new sl(this.overscaledZ+1,this.wrap,this.canonical.z,this.canonical.x,this.canonical.y)];const e=this.canonical.z+1,r=2*this.canonical.x,n=2*this.canonical.y;return [new sl(e,this.wrap,e,r,n),new sl(e,this.wrap,e,r+1,n),new sl(e,this.wrap,e,r,n+1),new sl(e,this.wrap,e,r+1,n+1)]}isLessThan(t){return this.wrap<t.wrap||!(this.wrap>t.wrap)&&(this.overscaledZ<t.overscaledZ||!(this.overscaledZ>t.overscaledZ)&&(this.canonical.x<t.canonical.x||!(this.canonical.x>t.canonical.x)&&this.canonical.y<t.canonical.y))}wrapped(){return new sl(this.overscaledZ,0,this.canonical.z,this.canonical.x,this.canonical.y)}unwrapTo(t){return new sl(this.overscaledZ,t,this.canonical.z,this.canonical.x,this.canonical.y)}overscaleFactor(){return Math.pow(2,this.overscaledZ-this.canonical.z)}toUnwrapped(){return new al(this.wrap,this.canonical)}toString(){return `${this.overscaledZ}/${this.canonical.x}/${this.canonical.y}`}}function ol(t,e,r,n,i){const a=1<<Math.min(r,22);let s=a*(i%a)+n%a;return t&&r<22&&(s+=a*a*((t<0?-2*t-1:2*t)%(1<<2*(22-r)))),16*(32*s+r)+(e-r)}const ll=[t=>{let e=t.canonical.x-1,r=t.wrap;return e<0&&(e=(1<<t.canonical.z)-1,r--),new sl(t.overscaledZ,r,t.canonical.z,e,t.canonical.y)},t=>{let e=t.canonical.x+1,r=t.wrap;return e===1<<t.canonical.z&&(e=0,r++),new sl(t.overscaledZ,r,t.canonical.z,e,t.canonical.y)},t=>new sl(t.overscaledZ,t.wrap,t.canonical.z,t.canonical.x,(0===t.canonical.y?1<<t.canonical.z:t.canonical.y)-1),t=>new sl(t.overscaledZ,t.wrap,t.canonical.z,t.canonical.x,t.canonical.y===(1<<t.canonical.z)-1?0:t.canonical.y+1)];ra(il,"CanonicalTileID"),ra(sl,"OverscaledTileID",{omit:["projMatrix","expandedProjMatrix"]});const ul=0,cl=25.5;function hl(t){return Qo*Math.cos(t*Math.PI/180)}function pl(t){return (180+t)/360}function fl(t){return (180-180/Math.PI*Math.log(Math.tan(Math.PI/4+t*Math.PI/360)))/360}function dl(t,e){return t/hl(e)}function ml(t){return 360*t-180}function yl(t){return 360/Math.PI*Math.atan(Math.exp((180-360*t)*Math.PI/180))-90}function gl(t,e){return t*hl(yl(e))}const xl=85.051129;function vl(t){return Math.cos(b(I(t,-xl,xl)))}function bl(t,e){const r=I(e,ul,cl),n=Math.pow(2,r);return vl(t)*Qo/(512*n)}function _l(t){return 1/Math.cos(t*Math.PI/180)}function wl(t,e=0){const r=Math.exp(Math.PI*(1-(t.y+e/Tr)/(1<<t.z)*2));return 80150034*r/(r*r+1)/Tr/(1<<t.z)}class Ml{constructor(t,e,r=0){this.x=+t,this.y=+e,this.z=+r;}static fromLngLat(t,e=0){const r=tl.convert(t);return new Ml(pl(r.lng),fl(r.lat),dl(e,r.lat))}toLngLat(){return new tl(ml(this.x),yl(this.y))}toAltitude(){return gl(this.z,this.y)}meterInMercatorCoordinateUnits(){return 1/Qo*_l(yl(this.y))}}function Al(t,e,r,n,i,a,s,o,l){const u=(e+n)/2,c=(r+i)/2,h=new g(u,c);o(h),function(t,e,r,n,i,a){const s=r-i,o=n-a;return Math.abs((n-e)*s-(r-t)*o)/Math.hypot(s,o)}(h.x,h.y,a.x,a.y,s.x,s.y)>=l?(Al(t,e,r,u,c,a,h,o,l),Al(t,u,c,n,i,h,s,o,l)):t.push(s);}function Sl(t,e,r){let n=t[0],i=n.x,a=n.y;e(n);const s=[n];for(let o=1;o<t.length;o++){const l=t[o],{x:u,y:c}=l;e(l),Al(s,i,a,u,c,n,l,e,r),i=u,a=c,n=l;}return s}function Il(t,e,r,n){if(n(e,r)){const i=e.add(r)._mult(.5);Il(t,e,i,n),Il(t,i,r,n);}else t.push(r);}function kl(t,e){let r=t[0];const n=[r];for(let i=1;i<t.length;i++){const a=t[i];Il(n,r,a,e),r=a;}return n}const Pl=Math.pow(2,14)-1,El=-Pl-1;function zl(t,e){const r=Math.round(t.x*e),n=Math.round(t.y*e);return t.x=I(r,El,Pl),t.y=I(n,El,Pl),(r<t.x||r>t.x+1||n<t.y||n>t.y+1)&&j("Geometry exceeds allowed extent, reduce your vector tile buffer size"),t}function Tl(t,e,r){const n=t.loadGeometry(),i=t.extent,a=Tr/i;if(e&&r&&r.projection.isReprojectedInTileSpace){const a=1<<e.z,{scale:s,x:o,y:l,projection:u}=r,c=t=>{const r=ml((e.x+t.x/i)/a),n=yl((e.y+t.y/i)/a),c=u.project(r,n);t.x=(c.x*s-o)*i,t.y=(c.y*s-l)*i;};for(let e=0;e<n.length;e++)if(1!==t.type)n[e]=Sl(n[e],c,1);else {const t=[];for(const r of n[e])r.x<0||r.x>=i||r.y<0||r.y>=i||(c(r),t.push(r));n[e]=t;}}for(const t of n)for(const e of t)zl(e,a);return n}function Bl(t,e){return {type:t.type,id:t.id,properties:t.properties,geometry:e?Tl(t):[]}}function Cl(t,e,r,n,i){t.emplaceBack(2*e+(n+1)/2,2*r+(i+1)/2);}function Rl(t,e,r){const n=16384;t.emplaceBack(e.x,e.y,e.z,r[0]*n,r[1]*n,r[2]*n);}class Dl{constructor(t){this.zoom=t.zoom,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.fqid)),this.index=t.index,this.hasPattern=!1,this.projection=t.projection,this.layoutVertexArray=new ps,this.indexArray=new Es,this.segments=new eo,this.programConfigurations=new Vo(t.layers,t.zoom),this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id));}populate(t,e,r,n){const i=this.layers[0],a=[];let s=null;"circle"===i.type&&(s=i.layout.get("circle-sort-key"));for(const{feature:e,id:i,index:o,sourceLayerIndex:l}of t){const t=this.layers[0]._featureFilter.needGeometry,u=Bl(e,t);if(!this.layers[0]._featureFilter.filter(new Pa(this.zoom),u,r))continue;const c=s?s.evaluate(u,{},r):void 0,h={id:i,properties:e.properties,type:e.type,sourceLayerIndex:l,index:o,geometry:t?u.geometry:Tl(e,r,n),patterns:{},sortKey:c};a.push(h);}s&&a.sort(((t,e)=>t.sortKey-e.sortKey));let o=null;"globe"===n.projection.name&&(this.globeExtVertexArray=new bs,o=n.projection);for(const n of a){const{geometry:i,index:a,sourceLayerIndex:s}=n,l=t[a].feature;this.addFeature(n,i,a,e.availableImages,r,o,e.brightness),e.featureIndex.insert(l,i,a,s,this.index);}}update(t,e,r,n,i){const a=0!==Object.keys(t).length;a&&!this.stateDependentLayers.length||this.programConfigurations.updatePaintArrays(t,e,a?this.stateDependentLayers:this.layers,r,n,i);}isEmpty(){return 0===this.layoutVertexArray.length}uploadPending(){return !this.uploaded||this.programConfigurations.needsUpload}upload(t){this.uploaded||(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,Qs.members),this.indexBuffer=t.createIndexBuffer(this.indexArray),this.globeExtVertexArray&&(this.globeExtVertexBuffer=t.createVertexBuffer(this.globeExtVertexArray,to.members))),this.programConfigurations.upload(t),this.uploaded=!0;}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy(),this.globeExtVertexBuffer&&this.globeExtVertexBuffer.destroy());}addFeature(t,e,r,n,i,a,s){for(const r of e)for(const e of r){const r=e.x,n=e.y;if(r<0||r>=Tr||n<0||n>=Tr)continue;if(a){const t=a.projectTilePoint(r,n,i),e=a.upVector(i,r,n),s=this.globeExtVertexArray;Rl(s,t,e),Rl(s,t,e),Rl(s,t,e),Rl(s,t,e);}const s=this.segments.prepareSegment(4,this.layoutVertexArray,this.indexArray,t.sortKey),o=s.vertexLength;Cl(this.layoutVertexArray,r,n,-1,-1),Cl(this.layoutVertexArray,r,n,1,-1),Cl(this.layoutVertexArray,r,n,1,1),Cl(this.layoutVertexArray,r,n,-1,1),this.indexArray.emplaceBack(o,o+1,o+2),this.indexArray.emplaceBack(o,o+2,o+3),s.vertexLength+=4,s.primitiveLength+=2;}this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,r,{},n,i,s);}}function Vl(t,e){for(let r=0;r<t.length;r++)if(Gl(e,t[r]))return !0;for(let r=0;r<e.length;r++)if(Gl(t,e[r]))return !0;return !!Ol(t,e)}function Ll(t,e,r){return !!Gl(t,e)||!!jl(e,t,r)}function Fl(t,e){if(1===t.length)return $l(e,t[0]);for(let r=0;r<e.length;r++){const n=e[r];for(let e=0;e<n.length;e++)if(Gl(t,n[e]))return !0}for(let r=0;r<t.length;r++)if($l(e,t[r]))return !0;for(let r=0;r<e.length;r++)if(Ol(t,e[r]))return !0;return !1}function Nl(t,e,r){if(t.length>1){if(Ol(t,e))return !0;for(let n=0;n<e.length;n++)if(jl(e[n],t,r))return !0}for(let n=0;n<t.length;n++)if(jl(t[n],e,r))return !0;return !1}function Ol(t,e){if(0===t.length||0===e.length)return !1;for(let r=0;r<t.length-1;r++){const n=t[r],i=t[r+1];for(let t=0;t<e.length-1;t++)if(Ul(n,i,e[t],e[t+1]))return !0}return !1}function Ul(t,e,r,n){return q(t,r,n)!==q(e,r,n)&&q(t,e,r)!==q(t,e,n)}function jl(t,e,r){const n=r*r;if(1===e.length)return t.distSqr(e[0])<n;for(let r=1;r<e.length;r++)if(ql(t,e[r-1],e[r])<n)return !0;return !1}function ql(t,e,r){const n=e.distSqr(r);if(0===n)return t.distSqr(e);const i=((t.x-e.x)*(r.x-e.x)+(t.y-e.y)*(r.y-e.y))/n;return t.distSqr(i<0?e:i>1?r:r.sub(e)._mult(i)._add(e))}function $l(t,e){let r,n,i,a=!1;for(let s=0;s<t.length;s++){r=t[s];for(let t=0,s=r.length-1;t<r.length;s=t++)n=r[t],i=r[s],n.y>e.y!=i.y>e.y&&e.x<(i.x-n.x)*(e.y-n.y)/(i.y-n.y)+n.x&&(a=!a);}return a}function Gl(t,e){let r=!1;for(let n=0,i=t.length-1;n<t.length;i=n++){const a=t[n],s=t[i];a.y>e.y!=s.y>e.y&&e.x<(s.x-a.x)*(e.y-a.y)/(s.y-a.y)+a.x&&(r=!r);}return r}function Yl(t,e,r,n,i){for(const a of t)if(e<=a.x&&r<=a.y&&n>=a.x&&i>=a.y)return !0;const a=[new g(e,r),new g(e,i),new g(n,i),new g(n,r)];if(t.length>2)for(const e of a)if(Gl(t,e))return !0;for(let e=0;e<t.length-1;e++)if(Xl(t[e],t[e+1],a))return !0;return !1}function Xl(t,e,r){const n=r[0],i=r[2];if(t.x<n.x&&e.x<n.x||t.x>i.x&&e.x>i.x||t.y<n.y&&e.y<n.y||t.y>i.y&&e.y>i.y)return !1;const a=q(t,e,r[0]);return a!==q(t,e,r[1])||a!==q(t,e,r[2])||a!==q(t,e,r[3])}function Zl(t,e,r,n,i,a){let s=e.y-t.y,o=t.x-e.x;if(a=a||0){const t=s*s+o*o;if(0===t)return !0;const e=Math.sqrt(t);s/=e,o/=e;}return !((r.x-t.x)*s+(r.y-t.y)*o-a<0||(n.x-t.x)*s+(n.y-t.y)*o-a<0||(i.x-t.x)*s+(i.y-t.y)*o-a<0)}function Kl(t,e,r,n,i,a,s){return !(Zl(t,e,n,i,a,s)||Zl(e,r,n,i,a,s)||Zl(r,t,n,i,a,s)||Zl(n,i,t,e,r,s)||Zl(i,a,t,e,r,s)||Zl(a,n,t,e,r,s))}function Hl(t,e,r){const n=e.paint.get(t).value;return "constant"===n.kind?n.value:r.programConfigurations.get(e.id).getMaxValue(t)}function Wl(t){return Math.sqrt(t[0]*t[0]+t[1]*t[1])}function Jl(t,e,r,n,i){if(!e[0]&&!e[1])return t;const a=g.convert(e)._mult(i);"viewport"===r&&a._rotate(-n);const s=[];for(let e=0;e<t.length;e++)s.push(t[e].sub(a));return s}function Ql(t,e,r,n){const i=g.convert(t)._mult(n);return "viewport"===e&&i._rotate(-r),i}ra(Dl,"CircleBucket",{omit:["layers"]});const tu=new Oa({"circle-sort-key":new Fa(qa.layout_circle["circle-sort-key"]),visibility:new La(qa.layout_circle.visibility)});var eu={paint:new Oa({"circle-radius":new Fa(qa.paint_circle["circle-radius"]),"circle-color":new Fa(qa.paint_circle["circle-color"]),"circle-blur":new Fa(qa.paint_circle["circle-blur"]),"circle-opacity":new Fa(qa.paint_circle["circle-opacity"]),"circle-translate":new La(qa.paint_circle["circle-translate"]),"circle-translate-anchor":new La(qa.paint_circle["circle-translate-anchor"]),"circle-pitch-scale":new La(qa.paint_circle["circle-pitch-scale"]),"circle-pitch-alignment":new La(qa.paint_circle["circle-pitch-alignment"]),"circle-stroke-width":new Fa(qa.paint_circle["circle-stroke-width"]),"circle-stroke-color":new Fa(qa.paint_circle["circle-stroke-color"]),"circle-stroke-opacity":new Fa(qa.paint_circle["circle-stroke-opacity"]),"circle-emissive-strength":new La(qa.paint_circle["circle-emissive-strength"])}),layout:tu},ru={},nu={};Object.defineProperty(nu,"__esModule",{value:!0}),nu.setMatrixArrayType=function(t){nu.ARRAY_TYPE=au=t;},nu.toRadian=function(t){return t*ou},nu.equals=function(t,e){return Math.abs(t-e)<=iu*Math.max(1,Math.abs(t),Math.abs(e))},nu.RANDOM=nu.ARRAY_TYPE=nu.EPSILON=void 0;var iu=1e-6;nu.EPSILON=iu;var au="undefined"!=typeof Float32Array?Float32Array:Array;nu.ARRAY_TYPE=au;var su=Math.random;nu.RANDOM=su;var ou=Math.PI/180;Math.hypot||(Math.hypot=function(){for(var t=0,e=arguments.length;e--;)t+=arguments[e]*arguments[e];return Math.sqrt(t)});var lu={};function uu(t){return uu="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t},uu(t)}Object.defineProperty(lu,"__esModule",{value:!0}),lu.create=function(){var t=new cu.ARRAY_TYPE(4);return cu.ARRAY_TYPE!=Float32Array&&(t[1]=0,t[2]=0),t[0]=1,t[3]=1,t},lu.clone=function(t){var e=new cu.ARRAY_TYPE(4);return e[0]=t[0],e[1]=t[1],e[2]=t[2],e[3]=t[3],e},lu.copy=function(t,e){return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t},lu.identity=function(t){return t[0]=1,t[1]=0,t[2]=0,t[3]=1,t},lu.fromValues=function(t,e,r,n){var i=new cu.ARRAY_TYPE(4);return i[0]=t,i[1]=e,i[2]=r,i[3]=n,i},lu.set=function(t,e,r,n,i){return t[0]=e,t[1]=r,t[2]=n,t[3]=i,t},lu.transpose=function(t,e){if(t===e){var r=e[1];t[1]=e[2],t[2]=r;}else t[0]=e[0],t[1]=e[2],t[2]=e[1],t[3]=e[3];return t},lu.invert=function(t,e){var r=e[0],n=e[1],i=e[2],a=e[3],s=r*a-i*n;return s?(t[0]=a*(s=1/s),t[1]=-n*s,t[2]=-i*s,t[3]=r*s,t):null},lu.adjoint=function(t,e){var r=e[0];return t[0]=e[3],t[1]=-e[1],t[2]=-e[2],t[3]=r,t},lu.determinant=function(t){return t[0]*t[3]-t[2]*t[1]},lu.multiply=pu,lu.rotate=function(t,e,r){var n=e[0],i=e[1],a=e[2],s=e[3],o=Math.sin(r),l=Math.cos(r);return t[0]=n*l+a*o,t[1]=i*l+s*o,t[2]=n*-o+a*l,t[3]=i*-o+s*l,t},lu.scale=function(t,e,r){var n=e[1],i=e[2],a=e[3],s=r[0],o=r[1];return t[0]=e[0]*s,t[1]=n*s,t[2]=i*o,t[3]=a*o,t},lu.fromRotation=function(t,e){var r=Math.sin(e),n=Math.cos(e);return t[0]=n,t[1]=r,t[2]=-r,t[3]=n,t},lu.fromScaling=function(t,e){return t[0]=e[0],t[1]=0,t[2]=0,t[3]=e[1],t},lu.str=function(t){return "mat2("+t[0]+", "+t[1]+", "+t[2]+", "+t[3]+")"},lu.frob=function(t){return Math.hypot(t[0],t[1],t[2],t[3])},lu.LDU=function(t,e,r,n){return t[2]=n[2]/n[0],r[0]=n[0],r[1]=n[1],r[3]=n[3]-t[2]*r[1],[t,e,r]},lu.add=function(t,e,r){return t[0]=e[0]+r[0],t[1]=e[1]+r[1],t[2]=e[2]+r[2],t[3]=e[3]+r[3],t},lu.subtract=fu,lu.exactEquals=function(t,e){return t[0]===e[0]&&t[1]===e[1]&&t[2]===e[2]&&t[3]===e[3]},lu.equals=function(t,e){var r=t[0],n=t[1],i=t[2],a=t[3],s=e[0],o=e[1],l=e[2],u=e[3];return Math.abs(r-s)<=cu.EPSILON*Math.max(1,Math.abs(r),Math.abs(s))&&Math.abs(n-o)<=cu.EPSILON*Math.max(1,Math.abs(n),Math.abs(o))&&Math.abs(i-l)<=cu.EPSILON*Math.max(1,Math.abs(i),Math.abs(l))&&Math.abs(a-u)<=cu.EPSILON*Math.max(1,Math.abs(a),Math.abs(u))},lu.multiplyScalar=function(t,e,r){return t[0]=e[0]*r,t[1]=e[1]*r,t[2]=e[2]*r,t[3]=e[3]*r,t},lu.multiplyScalarAndAdd=function(t,e,r,n){return t[0]=e[0]+r[0]*n,t[1]=e[1]+r[1]*n,t[2]=e[2]+r[2]*n,t[3]=e[3]+r[3]*n,t},lu.sub=lu.mul=void 0;var cu=function(t,e){if(t&&t.__esModule)return t;if(null===t||"object"!==uu(t)&&"function"!=typeof t)return {default:t};var r=hu(void 0);if(r&&r.has(t))return r.get(t);var n={},i=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var a in t)if("default"!==a&&Object.prototype.hasOwnProperty.call(t,a)){var s=i?Object.getOwnPropertyDescriptor(t,a):null;s&&(s.get||s.set)?Object.defineProperty(n,a,s):n[a]=t[a];}return n.default=t,r&&r.set(t,n),n}(nu);function hu(t){if("function"!=typeof WeakMap)return null;var e=new WeakMap,r=new WeakMap;return (hu=function(t){return t?r:e})(t)}function pu(t,e,r){var n=e[0],i=e[1],a=e[2],s=e[3],o=r[0],l=r[1],u=r[2],c=r[3];return t[0]=n*o+a*l,t[1]=i*o+s*l,t[2]=n*u+a*c,t[3]=i*u+s*c,t}function fu(t,e,r){return t[0]=e[0]-r[0],t[1]=e[1]-r[1],t[2]=e[2]-r[2],t[3]=e[3]-r[3],t}lu.mul=pu,lu.sub=fu;var du={};function mu(t){return mu="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t},mu(t)}Object.defineProperty(du,"__esModule",{value:!0}),du.create=function(){var t=new yu.ARRAY_TYPE(6);return yu.ARRAY_TYPE!=Float32Array&&(t[1]=0,t[2]=0,t[4]=0,t[5]=0),t[0]=1,t[3]=1,t},du.clone=function(t){var e=new yu.ARRAY_TYPE(6);return e[0]=t[0],e[1]=t[1],e[2]=t[2],e[3]=t[3],e[4]=t[4],e[5]=t[5],e},du.copy=function(t,e){return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t},du.identity=function(t){return t[0]=1,t[1]=0,t[2]=0,t[3]=1,t[4]=0,t[5]=0,t},du.fromValues=function(t,e,r,n,i,a){var s=new yu.ARRAY_TYPE(6);return s[0]=t,s[1]=e,s[2]=r,s[3]=n,s[4]=i,s[5]=a,s},du.set=function(t,e,r,n,i,a,s){return t[0]=e,t[1]=r,t[2]=n,t[3]=i,t[4]=a,t[5]=s,t},du.invert=function(t,e){var r=e[0],n=e[1],i=e[2],a=e[3],s=e[4],o=e[5],l=r*a-n*i;return l?(t[0]=a*(l=1/l),t[1]=-n*l,t[2]=-i*l,t[3]=r*l,t[4]=(i*o-a*s)*l,t[5]=(n*s-r*o)*l,t):null},du.determinant=function(t){return t[0]*t[3]-t[1]*t[2]},du.multiply=xu,du.rotate=function(t,e,r){var n=e[0],i=e[1],a=e[2],s=e[3],o=e[4],l=e[5],u=Math.sin(r),c=Math.cos(r);return t[0]=n*c+a*u,t[1]=i*c+s*u,t[2]=n*-u+a*c,t[3]=i*-u+s*c,t[4]=o,t[5]=l,t},du.scale=function(t,e,r){var n=e[1],i=e[2],a=e[3],s=e[4],o=e[5],l=r[0],u=r[1];return t[0]=e[0]*l,t[1]=n*l,t[2]=i*u,t[3]=a*u,t[4]=s,t[5]=o,t},du.translate=function(t,e,r){var n=e[0],i=e[1],a=e[2],s=e[3],o=e[4],l=e[5],u=r[0],c=r[1];return t[0]=n,t[1]=i,t[2]=a,t[3]=s,t[4]=n*u+a*c+o,t[5]=i*u+s*c+l,t},du.fromRotation=function(t,e){var r=Math.sin(e),n=Math.cos(e);return t[0]=n,t[1]=r,t[2]=-r,t[3]=n,t[4]=0,t[5]=0,t},du.fromScaling=function(t,e){return t[0]=e[0],t[1]=0,t[2]=0,t[3]=e[1],t[4]=0,t[5]=0,t},du.fromTranslation=function(t,e){return t[0]=1,t[1]=0,t[2]=0,t[3]=1,t[4]=e[0],t[5]=e[1],t},du.str=function(t){return "mat2d("+t[0]+", "+t[1]+", "+t[2]+", "+t[3]+", "+t[4]+", "+t[5]+")"},du.frob=function(t){return Math.hypot(t[0],t[1],t[2],t[3],t[4],t[5],1)},du.add=function(t,e,r){return t[0]=e[0]+r[0],t[1]=e[1]+r[1],t[2]=e[2]+r[2],t[3]=e[3]+r[3],t[4]=e[4]+r[4],t[5]=e[5]+r[5],t},du.subtract=vu,du.multiplyScalar=function(t,e,r){return t[0]=e[0]*r,t[1]=e[1]*r,t[2]=e[2]*r,t[3]=e[3]*r,t[4]=e[4]*r,t[5]=e[5]*r,t},du.multiplyScalarAndAdd=function(t,e,r,n){return t[0]=e[0]+r[0]*n,t[1]=e[1]+r[1]*n,t[2]=e[2]+r[2]*n,t[3]=e[3]+r[3]*n,t[4]=e[4]+r[4]*n,t[5]=e[5]+r[5]*n,t},du.exactEquals=function(t,e){return t[0]===e[0]&&t[1]===e[1]&&t[2]===e[2]&&t[3]===e[3]&&t[4]===e[4]&&t[5]===e[5]},du.equals=function(t,e){var r=t[0],n=t[1],i=t[2],a=t[3],s=t[4],o=t[5],l=e[0],u=e[1],c=e[2],h=e[3],p=e[4],f=e[5];return Math.abs(r-l)<=yu.EPSILON*Math.max(1,Math.abs(r),Math.abs(l))&&Math.abs(n-u)<=yu.EPSILON*Math.max(1,Math.abs(n),Math.abs(u))&&Math.abs(i-c)<=yu.EPSILON*Math.max(1,Math.abs(i),Math.abs(c))&&Math.abs(a-h)<=yu.EPSILON*Math.max(1,Math.abs(a),Math.abs(h))&&Math.abs(s-p)<=yu.EPSILON*Math.max(1,Math.abs(s),Math.abs(p))&&Math.abs(o-f)<=yu.EPSILON*Math.max(1,Math.abs(o),Math.abs(f))},du.sub=du.mul=void 0;var yu=function(t,e){if(t&&t.__esModule)return t;if(null===t||"object"!==mu(t)&&"function"!=typeof t)return {default:t};var r=gu(void 0);if(r&&r.has(t))return r.get(t);var n={},i=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var a in t)if("default"!==a&&Object.prototype.hasOwnProperty.call(t,a)){var s=i?Object.getOwnPropertyDescriptor(t,a):null;s&&(s.get||s.set)?Object.defineProperty(n,a,s):n[a]=t[a];}return n.default=t,r&&r.set(t,n),n}(nu);function gu(t){if("function"!=typeof WeakMap)return null;var e=new WeakMap,r=new WeakMap;return (gu=function(t){return t?r:e})(t)}function xu(t,e,r){var n=e[0],i=e[1],a=e[2],s=e[3],o=e[4],l=e[5],u=r[0],c=r[1],h=r[2],p=r[3],f=r[4],d=r[5];return t[0]=n*u+a*c,t[1]=i*u+s*c,t[2]=n*h+a*p,t[3]=i*h+s*p,t[4]=n*f+a*d+o,t[5]=i*f+s*d+l,t}function vu(t,e,r){return t[0]=e[0]-r[0],t[1]=e[1]-r[1],t[2]=e[2]-r[2],t[3]=e[3]-r[3],t[4]=e[4]-r[4],t[5]=e[5]-r[5],t}du.mul=xu,du.sub=vu;var bu={};function _u(t){return _u="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t},_u(t)}Object.defineProperty(bu,"__esModule",{value:!0}),bu.create=function(){var t=new wu.ARRAY_TYPE(9);return wu.ARRAY_TYPE!=Float32Array&&(t[1]=0,t[2]=0,t[3]=0,t[5]=0,t[6]=0,t[7]=0),t[0]=1,t[4]=1,t[8]=1,t},bu.fromMat4=function(t,e){return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[4],t[4]=e[5],t[5]=e[6],t[6]=e[8],t[7]=e[9],t[8]=e[10],t},bu.clone=function(t){var e=new wu.ARRAY_TYPE(9);return e[0]=t[0],e[1]=t[1],e[2]=t[2],e[3]=t[3],e[4]=t[4],e[5]=t[5],e[6]=t[6],e[7]=t[7],e[8]=t[8],e},bu.copy=function(t,e){return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t},bu.fromValues=function(t,e,r,n,i,a,s,o,l){var u=new wu.ARRAY_TYPE(9);return u[0]=t,u[1]=e,u[2]=r,u[3]=n,u[4]=i,u[5]=a,u[6]=s,u[7]=o,u[8]=l,u},bu.set=function(t,e,r,n,i,a,s,o,l,u){return t[0]=e,t[1]=r,t[2]=n,t[3]=i,t[4]=a,t[5]=s,t[6]=o,t[7]=l,t[8]=u,t},bu.identity=function(t){return t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=1,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t},bu.transpose=function(t,e){if(t===e){var r=e[1],n=e[2],i=e[5];t[1]=e[3],t[2]=e[6],t[3]=r,t[5]=e[7],t[6]=n,t[7]=i;}else t[0]=e[0],t[1]=e[3],t[2]=e[6],t[3]=e[1],t[4]=e[4],t[5]=e[7],t[6]=e[2],t[7]=e[5],t[8]=e[8];return t},bu.invert=function(t,e){var r=e[0],n=e[1],i=e[2],a=e[3],s=e[4],o=e[5],l=e[6],u=e[7],c=e[8],h=c*s-o*u,p=-c*a+o*l,f=u*a-s*l,d=r*h+n*p+i*f;return d?(t[0]=h*(d=1/d),t[1]=(-c*n+i*u)*d,t[2]=(o*n-i*s)*d,t[3]=p*d,t[4]=(c*r-i*l)*d,t[5]=(-o*r+i*a)*d,t[6]=f*d,t[7]=(-u*r+n*l)*d,t[8]=(s*r-n*a)*d,t):null},bu.adjoint=function(t,e){var r=e[0],n=e[1],i=e[2],a=e[3],s=e[4],o=e[5],l=e[6],u=e[7],c=e[8];return t[0]=s*c-o*u,t[1]=i*u-n*c,t[2]=n*o-i*s,t[3]=o*l-a*c,t[4]=r*c-i*l,t[5]=i*a-r*o,t[6]=a*u-s*l,t[7]=n*l-r*u,t[8]=r*s-n*a,t},bu.determinant=function(t){var e=t[3],r=t[4],n=t[5],i=t[6],a=t[7],s=t[8];return t[0]*(s*r-n*a)+t[1]*(-s*e+n*i)+t[2]*(a*e-r*i)},bu.multiply=Au,bu.translate=function(t,e,r){var n=e[0],i=e[1],a=e[2],s=e[3],o=e[4],l=e[5],u=e[6],c=e[7],h=e[8],p=r[0],f=r[1];return t[0]=n,t[1]=i,t[2]=a,t[3]=s,t[4]=o,t[5]=l,t[6]=p*n+f*s+u,t[7]=p*i+f*o+c,t[8]=p*a+f*l+h,t},bu.rotate=function(t,e,r){var n=e[0],i=e[1],a=e[2],s=e[3],o=e[4],l=e[5],u=e[6],c=e[7],h=e[8],p=Math.sin(r),f=Math.cos(r);return t[0]=f*n+p*s,t[1]=f*i+p*o,t[2]=f*a+p*l,t[3]=f*s-p*n,t[4]=f*o-p*i,t[5]=f*l-p*a,t[6]=u,t[7]=c,t[8]=h,t},bu.scale=function(t,e,r){var n=r[0],i=r[1];return t[0]=n*e[0],t[1]=n*e[1],t[2]=n*e[2],t[3]=i*e[3],t[4]=i*e[4],t[5]=i*e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t},bu.fromTranslation=function(t,e){return t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=1,t[5]=0,t[6]=e[0],t[7]=e[1],t[8]=1,t},bu.fromRotation=function(t,e){var r=Math.sin(e),n=Math.cos(e);return t[0]=n,t[1]=r,t[2]=0,t[3]=-r,t[4]=n,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t},bu.fromScaling=function(t,e){return t[0]=e[0],t[1]=0,t[2]=0,t[3]=0,t[4]=e[1],t[5]=0,t[6]=0,t[7]=0,t[8]=1,t},bu.fromMat2d=function(t,e){return t[0]=e[0],t[1]=e[1],t[2]=0,t[3]=e[2],t[4]=e[3],t[5]=0,t[6]=e[4],t[7]=e[5],t[8]=1,t},bu.fromQuat=function(t,e){var r=e[0],n=e[1],i=e[2],a=e[3],s=r+r,o=n+n,l=i+i,u=r*s,c=n*s,h=n*o,p=i*s,f=i*o,d=i*l,m=a*s,y=a*o,g=a*l;return t[0]=1-h-d,t[3]=c-g,t[6]=p+y,t[1]=c+g,t[4]=1-u-d,t[7]=f-m,t[2]=p-y,t[5]=f+m,t[8]=1-u-h,t},bu.normalFromMat4=function(t,e){var r=e[0],n=e[1],i=e[2],a=e[3],s=e[4],o=e[5],l=e[6],u=e[7],c=e[8],h=e[9],p=e[10],f=e[11],d=e[12],m=e[13],y=e[14],g=e[15],x=r*o-n*s,v=r*l-i*s,b=r*u-a*s,_=n*l-i*o,w=n*u-a*o,M=i*u-a*l,A=c*m-h*d,S=c*y-p*d,I=c*g-f*d,k=h*y-p*m,P=h*g-f*m,E=p*g-f*y,z=x*E-v*P+b*k+_*I-w*S+M*A;return z?(t[0]=(o*E-l*P+u*k)*(z=1/z),t[1]=(l*I-s*E-u*S)*z,t[2]=(s*P-o*I+u*A)*z,t[3]=(i*P-n*E-a*k)*z,t[4]=(r*E-i*I+a*S)*z,t[5]=(n*I-r*P-a*A)*z,t[6]=(m*M-y*w+g*_)*z,t[7]=(y*b-d*M-g*v)*z,t[8]=(d*w-m*b+g*x)*z,t):null},bu.projection=function(t,e,r){return t[0]=2/e,t[1]=0,t[2]=0,t[3]=0,t[4]=-2/r,t[5]=0,t[6]=-1,t[7]=1,t[8]=1,t},bu.str=function(t){return "mat3("+t[0]+", "+t[1]+", "+t[2]+", "+t[3]+", "+t[4]+", "+t[5]+", "+t[6]+", "+t[7]+", "+t[8]+")"},bu.frob=function(t){return Math.hypot(t[0],t[1],t[2],t[3],t[4],t[5],t[6],t[7],t[8])},bu.add=function(t,e,r){return t[0]=e[0]+r[0],t[1]=e[1]+r[1],t[2]=e[2]+r[2],t[3]=e[3]+r[3],t[4]=e[4]+r[4],t[5]=e[5]+r[5],t[6]=e[6]+r[6],t[7]=e[7]+r[7],t[8]=e[8]+r[8],t},bu.subtract=Su,bu.multiplyScalar=function(t,e,r){return t[0]=e[0]*r,t[1]=e[1]*r,t[2]=e[2]*r,t[3]=e[3]*r,t[4]=e[4]*r,t[5]=e[5]*r,t[6]=e[6]*r,t[7]=e[7]*r,t[8]=e[8]*r,t},bu.multiplyScalarAndAdd=function(t,e,r,n){return t[0]=e[0]+r[0]*n,t[1]=e[1]+r[1]*n,t[2]=e[2]+r[2]*n,t[3]=e[3]+r[3]*n,t[4]=e[4]+r[4]*n,t[5]=e[5]+r[5]*n,t[6]=e[6]+r[6]*n,t[7]=e[7]+r[7]*n,t[8]=e[8]+r[8]*n,t},bu.exactEquals=function(t,e){return t[0]===e[0]&&t[1]===e[1]&&t[2]===e[2]&&t[3]===e[3]&&t[4]===e[4]&&t[5]===e[5]&&t[6]===e[6]&&t[7]===e[7]&&t[8]===e[8]},bu.equals=function(t,e){var r=t[0],n=t[1],i=t[2],a=t[3],s=t[4],o=t[5],l=t[6],u=t[7],c=t[8],h=e[0],p=e[1],f=e[2],d=e[3],m=e[4],y=e[5],g=e[6],x=e[7],v=e[8];return Math.abs(r-h)<=wu.EPSILON*Math.max(1,Math.abs(r),Math.abs(h))&&Math.abs(n-p)<=wu.EPSILON*Math.max(1,Math.abs(n),Math.abs(p))&&Math.abs(i-f)<=wu.EPSILON*Math.max(1,Math.abs(i),Math.abs(f))&&Math.abs(a-d)<=wu.EPSILON*Math.max(1,Math.abs(a),Math.abs(d))&&Math.abs(s-m)<=wu.EPSILON*Math.max(1,Math.abs(s),Math.abs(m))&&Math.abs(o-y)<=wu.EPSILON*Math.max(1,Math.abs(o),Math.abs(y))&&Math.abs(l-g)<=wu.EPSILON*Math.max(1,Math.abs(l),Math.abs(g))&&Math.abs(u-x)<=wu.EPSILON*Math.max(1,Math.abs(u),Math.abs(x))&&Math.abs(c-v)<=wu.EPSILON*Math.max(1,Math.abs(c),Math.abs(v))},bu.sub=bu.mul=void 0;var wu=function(t,e){if(t&&t.__esModule)return t;if(null===t||"object"!==_u(t)&&"function"!=typeof t)return {default:t};var r=Mu(void 0);if(r&&r.has(t))return r.get(t);var n={},i=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var a in t)if("default"!==a&&Object.prototype.hasOwnProperty.call(t,a)){var s=i?Object.getOwnPropertyDescriptor(t,a):null;s&&(s.get||s.set)?Object.defineProperty(n,a,s):n[a]=t[a];}return n.default=t,r&&r.set(t,n),n}(nu);function Mu(t){if("function"!=typeof WeakMap)return null;var e=new WeakMap,r=new WeakMap;return (Mu=function(t){return t?r:e})(t)}function Au(t,e,r){var n=e[0],i=e[1],a=e[2],s=e[3],o=e[4],l=e[5],u=e[6],c=e[7],h=e[8],p=r[0],f=r[1],d=r[2],m=r[3],y=r[4],g=r[5],x=r[6],v=r[7],b=r[8];return t[0]=p*n+f*s+d*u,t[1]=p*i+f*o+d*c,t[2]=p*a+f*l+d*h,t[3]=m*n+y*s+g*u,t[4]=m*i+y*o+g*c,t[5]=m*a+y*l+g*h,t[6]=x*n+v*s+b*u,t[7]=x*i+v*o+b*c,t[8]=x*a+v*l+b*h,t}function Su(t,e,r){return t[0]=e[0]-r[0],t[1]=e[1]-r[1],t[2]=e[2]-r[2],t[3]=e[3]-r[3],t[4]=e[4]-r[4],t[5]=e[5]-r[5],t[6]=e[6]-r[6],t[7]=e[7]-r[7],t[8]=e[8]-r[8],t}bu.mul=Au,bu.sub=Su;var Iu={};function ku(t){return ku="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t},ku(t)}Object.defineProperty(Iu,"__esModule",{value:!0}),Iu.create=function(){var t=new Pu.ARRAY_TYPE(16);return Pu.ARRAY_TYPE!=Float32Array&&(t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[11]=0,t[12]=0,t[13]=0,t[14]=0),t[0]=1,t[5]=1,t[10]=1,t[15]=1,t},Iu.clone=function(t){var e=new Pu.ARRAY_TYPE(16);return e[0]=t[0],e[1]=t[1],e[2]=t[2],e[3]=t[3],e[4]=t[4],e[5]=t[5],e[6]=t[6],e[7]=t[7],e[8]=t[8],e[9]=t[9],e[10]=t[10],e[11]=t[11],e[12]=t[12],e[13]=t[13],e[14]=t[14],e[15]=t[15],e},Iu.copy=function(t,e){return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t},Iu.fromValues=function(t,e,r,n,i,a,s,o,l,u,c,h,p,f,d,m){var y=new Pu.ARRAY_TYPE(16);return y[0]=t,y[1]=e,y[2]=r,y[3]=n,y[4]=i,y[5]=a,y[6]=s,y[7]=o,y[8]=l,y[9]=u,y[10]=c,y[11]=h,y[12]=p,y[13]=f,y[14]=d,y[15]=m,y},Iu.set=function(t,e,r,n,i,a,s,o,l,u,c,h,p,f,d,m,y){return t[0]=e,t[1]=r,t[2]=n,t[3]=i,t[4]=a,t[5]=s,t[6]=o,t[7]=l,t[8]=u,t[9]=c,t[10]=h,t[11]=p,t[12]=f,t[13]=d,t[14]=m,t[15]=y,t},Iu.identity=zu,Iu.transpose=function(t,e){if(t===e){var r=e[1],n=e[2],i=e[3],a=e[6],s=e[7],o=e[11];t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=r,t[6]=e[9],t[7]=e[13],t[8]=n,t[9]=a,t[11]=e[14],t[12]=i,t[13]=s,t[14]=o;}else t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=e[1],t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=e[2],t[9]=e[6],t[10]=e[10],t[11]=e[14],t[12]=e[3],t[13]=e[7],t[14]=e[11],t[15]=e[15];return t},Iu.invert=function(t,e){var r=e[0],n=e[1],i=e[2],a=e[3],s=e[4],o=e[5],l=e[6],u=e[7],c=e[8],h=e[9],p=e[10],f=e[11],d=e[12],m=e[13],y=e[14],g=e[15],x=r*o-n*s,v=r*l-i*s,b=r*u-a*s,_=n*l-i*o,w=n*u-a*o,M=i*u-a*l,A=c*m-h*d,S=c*y-p*d,I=c*g-f*d,k=h*y-p*m,P=h*g-f*m,E=p*g-f*y,z=x*E-v*P+b*k+_*I-w*S+M*A;return z?(t[0]=(o*E-l*P+u*k)*(z=1/z),t[1]=(i*P-n*E-a*k)*z,t[2]=(m*M-y*w+g*_)*z,t[3]=(p*w-h*M-f*_)*z,t[4]=(l*I-s*E-u*S)*z,t[5]=(r*E-i*I+a*S)*z,t[6]=(y*b-d*M-g*v)*z,t[7]=(c*M-p*b+f*v)*z,t[8]=(s*P-o*I+u*A)*z,t[9]=(n*I-r*P-a*A)*z,t[10]=(d*w-m*b+g*x)*z,t[11]=(h*b-c*w-f*x)*z,t[12]=(o*S-s*k-l*A)*z,t[13]=(r*k-n*S+i*A)*z,t[14]=(m*v-d*_-y*x)*z,t[15]=(c*_-h*v+p*x)*z,t):null},Iu.adjoint=function(t,e){var r=e[0],n=e[1],i=e[2],a=e[3],s=e[4],o=e[5],l=e[6],u=e[7],c=e[8],h=e[9],p=e[10],f=e[11],d=e[12],m=e[13],y=e[14],g=e[15];return t[0]=o*(p*g-f*y)-h*(l*g-u*y)+m*(l*f-u*p),t[1]=-(n*(p*g-f*y)-h*(i*g-a*y)+m*(i*f-a*p)),t[2]=n*(l*g-u*y)-o*(i*g-a*y)+m*(i*u-a*l),t[3]=-(n*(l*f-u*p)-o*(i*f-a*p)+h*(i*u-a*l)),t[4]=-(s*(p*g-f*y)-c*(l*g-u*y)+d*(l*f-u*p)),t[5]=r*(p*g-f*y)-c*(i*g-a*y)+d*(i*f-a*p),t[6]=-(r*(l*g-u*y)-s*(i*g-a*y)+d*(i*u-a*l)),t[7]=r*(l*f-u*p)-s*(i*f-a*p)+c*(i*u-a*l),t[8]=s*(h*g-f*m)-c*(o*g-u*m)+d*(o*f-u*h),t[9]=-(r*(h*g-f*m)-c*(n*g-a*m)+d*(n*f-a*h)),t[10]=r*(o*g-u*m)-s*(n*g-a*m)+d*(n*u-a*o),t[11]=-(r*(o*f-u*h)-s*(n*f-a*h)+c*(n*u-a*o)),t[12]=-(s*(h*y-p*m)-c*(o*y-l*m)+d*(o*p-l*h)),t[13]=r*(h*y-p*m)-c*(n*y-i*m)+d*(n*p-i*h),t[14]=-(r*(o*y-l*m)-s*(n*y-i*m)+d*(n*l-i*o)),t[15]=r*(o*p-l*h)-s*(n*p-i*h)+c*(n*l-i*o),t},Iu.determinant=function(t){var e=t[0],r=t[1],n=t[2],i=t[3],a=t[4],s=t[5],o=t[6],l=t[7],u=t[8],c=t[9],h=t[10],p=t[11],f=t[12],d=t[13],m=t[14],y=t[15];return (e*s-r*a)*(h*y-p*m)-(e*o-n*a)*(c*y-p*d)+(e*l-i*a)*(c*m-h*d)+(r*o-n*s)*(u*y-p*f)-(r*l-i*s)*(u*m-h*f)+(n*l-i*o)*(u*d-c*f)},Iu.multiply=Tu,Iu.translate=function(t,e,r){var n,i,a,s,o,l,u,c,h,p,f,d,m=r[0],y=r[1],g=r[2];return e===t?(t[12]=e[0]*m+e[4]*y+e[8]*g+e[12],t[13]=e[1]*m+e[5]*y+e[9]*g+e[13],t[14]=e[2]*m+e[6]*y+e[10]*g+e[14],t[15]=e[3]*m+e[7]*y+e[11]*g+e[15]):(i=e[1],a=e[2],s=e[3],o=e[4],l=e[5],u=e[6],c=e[7],h=e[8],p=e[9],f=e[10],d=e[11],t[0]=n=e[0],t[1]=i,t[2]=a,t[3]=s,t[4]=o,t[5]=l,t[6]=u,t[7]=c,t[8]=h,t[9]=p,t[10]=f,t[11]=d,t[12]=n*m+o*y+h*g+e[12],t[13]=i*m+l*y+p*g+e[13],t[14]=a*m+u*y+f*g+e[14],t[15]=s*m+c*y+d*g+e[15]),t},Iu.scale=function(t,e,r){var n=r[0],i=r[1],a=r[2];return t[0]=e[0]*n,t[1]=e[1]*n,t[2]=e[2]*n,t[3]=e[3]*n,t[4]=e[4]*i,t[5]=e[5]*i,t[6]=e[6]*i,t[7]=e[7]*i,t[8]=e[8]*a,t[9]=e[9]*a,t[10]=e[10]*a,t[11]=e[11]*a,t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t},Iu.rotate=function(t,e,r,n){var i,a,s,o,l,u,c,h,p,f,d,m,y,g,x,v,b,_,w,M,A,S,I,k,P=n[0],E=n[1],z=n[2],T=Math.hypot(P,E,z);return T<Pu.EPSILON?null:(P*=T=1/T,E*=T,z*=T,i=Math.sin(r),a=Math.cos(r),l=e[1],u=e[2],c=e[3],p=e[5],f=e[6],d=e[7],y=e[9],g=e[10],x=e[11],v=P*P*(s=1-a)+a,w=P*E*s-z*i,M=E*E*s+a,A=z*E*s+P*i,S=P*z*s+E*i,I=E*z*s-P*i,k=z*z*s+a,t[0]=(o=e[0])*v+(h=e[4])*(b=E*P*s+z*i)+(m=e[8])*(_=z*P*s-E*i),t[1]=l*v+p*b+y*_,t[2]=u*v+f*b+g*_,t[3]=c*v+d*b+x*_,t[4]=o*w+h*M+m*A,t[5]=l*w+p*M+y*A,t[6]=u*w+f*M+g*A,t[7]=c*w+d*M+x*A,t[8]=o*S+h*I+m*k,t[9]=l*S+p*I+y*k,t[10]=u*S+f*I+g*k,t[11]=c*S+d*I+x*k,e!==t&&(t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15]),t)},Iu.rotateX=function(t,e,r){var n=Math.sin(r),i=Math.cos(r),a=e[4],s=e[5],o=e[6],l=e[7],u=e[8],c=e[9],h=e[10],p=e[11];return e!==t&&(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15]),t[4]=a*i+u*n,t[5]=s*i+c*n,t[6]=o*i+h*n,t[7]=l*i+p*n,t[8]=u*i-a*n,t[9]=c*i-s*n,t[10]=h*i-o*n,t[11]=p*i-l*n,t},Iu.rotateY=function(t,e,r){var n=Math.sin(r),i=Math.cos(r),a=e[0],s=e[1],o=e[2],l=e[3],u=e[8],c=e[9],h=e[10],p=e[11];return e!==t&&(t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15]),t[0]=a*i-u*n,t[1]=s*i-c*n,t[2]=o*i-h*n,t[3]=l*i-p*n,t[8]=a*n+u*i,t[9]=s*n+c*i,t[10]=o*n+h*i,t[11]=l*n+p*i,t},Iu.rotateZ=function(t,e,r){var n=Math.sin(r),i=Math.cos(r),a=e[0],s=e[1],o=e[2],l=e[3],u=e[4],c=e[5],h=e[6],p=e[7];return e!==t&&(t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15]),t[0]=a*i+u*n,t[1]=s*i+c*n,t[2]=o*i+h*n,t[3]=l*i+p*n,t[4]=u*i-a*n,t[5]=c*i-s*n,t[6]=h*i-o*n,t[7]=p*i-l*n,t},Iu.fromTranslation=function(t,e){return t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=1,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=1,t[11]=0,t[12]=e[0],t[13]=e[1],t[14]=e[2],t[15]=1,t},Iu.fromScaling=function(t,e){return t[0]=e[0],t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e[1],t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e[2],t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t},Iu.fromRotation=function(t,e,r){var n,i,a,s=r[0],o=r[1],l=r[2],u=Math.hypot(s,o,l);return u<Pu.EPSILON?null:(s*=u=1/u,o*=u,l*=u,n=Math.sin(e),i=Math.cos(e),t[0]=s*s*(a=1-i)+i,t[1]=o*s*a+l*n,t[2]=l*s*a-o*n,t[3]=0,t[4]=s*o*a-l*n,t[5]=o*o*a+i,t[6]=l*o*a+s*n,t[7]=0,t[8]=s*l*a+o*n,t[9]=o*l*a-s*n,t[10]=l*l*a+i,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t)},Iu.fromXRotation=function(t,e){var r=Math.sin(e),n=Math.cos(e);return t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=n,t[6]=r,t[7]=0,t[8]=0,t[9]=-r,t[10]=n,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t},Iu.fromYRotation=function(t,e){var r=Math.sin(e),n=Math.cos(e);return t[0]=n,t[1]=0,t[2]=-r,t[3]=0,t[4]=0,t[5]=1,t[6]=0,t[7]=0,t[8]=r,t[9]=0,t[10]=n,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t},Iu.fromZRotation=function(t,e){var r=Math.sin(e),n=Math.cos(e);return t[0]=n,t[1]=r,t[2]=0,t[3]=0,t[4]=-r,t[5]=n,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=1,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t},Iu.fromRotationTranslation=Bu,Iu.fromQuat2=function(t,e){var r=new Pu.ARRAY_TYPE(3),n=-e[0],i=-e[1],a=-e[2],s=e[3],o=e[4],l=e[5],u=e[6],c=e[7],h=n*n+i*i+a*a+s*s;return h>0?(r[0]=2*(o*s+c*n+l*a-u*i)/h,r[1]=2*(l*s+c*i+u*n-o*a)/h,r[2]=2*(u*s+c*a+o*i-l*n)/h):(r[0]=2*(o*s+c*n+l*a-u*i),r[1]=2*(l*s+c*i+u*n-o*a),r[2]=2*(u*s+c*a+o*i-l*n)),Bu(t,e,r),t},Iu.getTranslation=function(t,e){return t[0]=e[12],t[1]=e[13],t[2]=e[14],t},Iu.getScaling=Cu,Iu.getRotation=function(t,e){var r=new Pu.ARRAY_TYPE(3);Cu(r,e);var n=1/r[0],i=1/r[1],a=1/r[2],s=e[0]*n,o=e[1]*i,l=e[2]*a,u=e[4]*n,c=e[5]*i,h=e[6]*a,p=e[8]*n,f=e[9]*i,d=e[10]*a,m=s+c+d,y=0;return m>0?(y=2*Math.sqrt(m+1),t[3]=.25*y,t[0]=(h-f)/y,t[1]=(p-l)/y,t[2]=(o-u)/y):s>c&&s>d?(y=2*Math.sqrt(1+s-c-d),t[3]=(h-f)/y,t[0]=.25*y,t[1]=(o+u)/y,t[2]=(p+l)/y):c>d?(y=2*Math.sqrt(1+c-s-d),t[3]=(p-l)/y,t[0]=(o+u)/y,t[1]=.25*y,t[2]=(h+f)/y):(y=2*Math.sqrt(1+d-s-c),t[3]=(o-u)/y,t[0]=(p+l)/y,t[1]=(h+f)/y,t[2]=.25*y),t},Iu.fromRotationTranslationScale=function(t,e,r,n){var i=e[0],a=e[1],s=e[2],o=e[3],l=i+i,u=a+a,c=s+s,h=i*l,p=i*u,f=i*c,d=a*u,m=a*c,y=s*c,g=o*l,x=o*u,v=o*c,b=n[0],_=n[1],w=n[2];return t[0]=(1-(d+y))*b,t[1]=(p+v)*b,t[2]=(f-x)*b,t[3]=0,t[4]=(p-v)*_,t[5]=(1-(h+y))*_,t[6]=(m+g)*_,t[7]=0,t[8]=(f+x)*w,t[9]=(m-g)*w,t[10]=(1-(h+d))*w,t[11]=0,t[12]=r[0],t[13]=r[1],t[14]=r[2],t[15]=1,t},Iu.fromRotationTranslationScaleOrigin=function(t,e,r,n,i){var a=e[0],s=e[1],o=e[2],l=e[3],u=a+a,c=s+s,h=o+o,p=a*u,f=a*c,d=a*h,m=s*c,y=s*h,g=o*h,x=l*u,v=l*c,b=l*h,_=n[0],w=n[1],M=n[2],A=i[0],S=i[1],I=i[2],k=(1-(m+g))*_,P=(f+b)*_,E=(d-v)*_,z=(f-b)*w,T=(1-(p+g))*w,B=(y+x)*w,C=(d+v)*M,R=(y-x)*M,D=(1-(p+m))*M;return t[0]=k,t[1]=P,t[2]=E,t[3]=0,t[4]=z,t[5]=T,t[6]=B,t[7]=0,t[8]=C,t[9]=R,t[10]=D,t[11]=0,t[12]=r[0]+A-(k*A+z*S+C*I),t[13]=r[1]+S-(P*A+T*S+R*I),t[14]=r[2]+I-(E*A+B*S+D*I),t[15]=1,t},Iu.fromQuat=function(t,e){var r=e[0],n=e[1],i=e[2],a=e[3],s=r+r,o=n+n,l=i+i,u=r*s,c=n*s,h=n*o,p=i*s,f=i*o,d=i*l,m=a*s,y=a*o,g=a*l;return t[0]=1-h-d,t[1]=c+g,t[2]=p-y,t[3]=0,t[4]=c-g,t[5]=1-u-d,t[6]=f+m,t[7]=0,t[8]=p+y,t[9]=f-m,t[10]=1-u-h,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t},Iu.frustum=function(t,e,r,n,i,a,s){var o=1/(r-e),l=1/(i-n),u=1/(a-s);return t[0]=2*a*o,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=2*a*l,t[6]=0,t[7]=0,t[8]=(r+e)*o,t[9]=(i+n)*l,t[10]=(s+a)*u,t[11]=-1,t[12]=0,t[13]=0,t[14]=s*a*2*u,t[15]=0,t},Iu.perspectiveNO=Ru,Iu.perspectiveZO=function(t,e,r,n,i){var a,s=1/Math.tan(e/2);return t[0]=s/r,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=s,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[11]=-1,t[12]=0,t[13]=0,t[15]=0,null!=i&&i!==1/0?(t[10]=i*(a=1/(n-i)),t[14]=i*n*a):(t[10]=-1,t[14]=-n),t},Iu.perspectiveFromFieldOfView=function(t,e,r,n){var i=Math.tan(e.upDegrees*Math.PI/180),a=Math.tan(e.downDegrees*Math.PI/180),s=Math.tan(e.leftDegrees*Math.PI/180),o=Math.tan(e.rightDegrees*Math.PI/180),l=2/(s+o),u=2/(i+a);return t[0]=l,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=u,t[6]=0,t[7]=0,t[8]=-(s-o)*l*.5,t[9]=(i-a)*u*.5,t[10]=n/(r-n),t[11]=-1,t[12]=0,t[13]=0,t[14]=n*r/(r-n),t[15]=0,t},Iu.orthoNO=Du,Iu.orthoZO=function(t,e,r,n,i,a,s){var o=1/(e-r),l=1/(n-i),u=1/(a-s);return t[0]=-2*o,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=-2*l,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=u,t[11]=0,t[12]=(e+r)*o,t[13]=(i+n)*l,t[14]=a*u,t[15]=1,t},Iu.lookAt=function(t,e,r,n){var i,a,s,o,l,u,c,h,p,f,d=e[0],m=e[1],y=e[2],g=n[0],x=n[1],v=n[2],b=r[0],_=r[1],w=r[2];return Math.abs(d-b)<Pu.EPSILON&&Math.abs(m-_)<Pu.EPSILON&&Math.abs(y-w)<Pu.EPSILON?zu(t):(c=d-b,h=m-_,p=y-w,i=x*(p*=f=1/Math.hypot(c,h,p))-v*(h*=f),a=v*(c*=f)-g*p,s=g*h-x*c,(f=Math.hypot(i,a,s))?(i*=f=1/f,a*=f,s*=f):(i=0,a=0,s=0),o=h*s-p*a,l=p*i-c*s,u=c*a-h*i,(f=Math.hypot(o,l,u))?(o*=f=1/f,l*=f,u*=f):(o=0,l=0,u=0),t[0]=i,t[1]=o,t[2]=c,t[3]=0,t[4]=a,t[5]=l,t[6]=h,t[7]=0,t[8]=s,t[9]=u,t[10]=p,t[11]=0,t[12]=-(i*d+a*m+s*y),t[13]=-(o*d+l*m+u*y),t[14]=-(c*d+h*m+p*y),t[15]=1,t)},Iu.targetTo=function(t,e,r,n){var i=e[0],a=e[1],s=e[2],o=n[0],l=n[1],u=n[2],c=i-r[0],h=a-r[1],p=s-r[2],f=c*c+h*h+p*p;f>0&&(c*=f=1/Math.sqrt(f),h*=f,p*=f);var d=l*p-u*h,m=u*c-o*p,y=o*h-l*c;return (f=d*d+m*m+y*y)>0&&(d*=f=1/Math.sqrt(f),m*=f,y*=f),t[0]=d,t[1]=m,t[2]=y,t[3]=0,t[4]=h*y-p*m,t[5]=p*d-c*y,t[6]=c*m-h*d,t[7]=0,t[8]=c,t[9]=h,t[10]=p,t[11]=0,t[12]=i,t[13]=a,t[14]=s,t[15]=1,t},Iu.str=function(t){return "mat4("+t[0]+", "+t[1]+", "+t[2]+", "+t[3]+", "+t[4]+", "+t[5]+", "+t[6]+", "+t[7]+", "+t[8]+", "+t[9]+", "+t[10]+", "+t[11]+", "+t[12]+", "+t[13]+", "+t[14]+", "+t[15]+")"},Iu.frob=function(t){return Math.hypot(t[0],t[1],t[2],t[3],t[4],t[5],t[6],t[7],t[8],t[9],t[10],t[11],t[12],t[13],t[14],t[15])},Iu.add=function(t,e,r){return t[0]=e[0]+r[0],t[1]=e[1]+r[1],t[2]=e[2]+r[2],t[3]=e[3]+r[3],t[4]=e[4]+r[4],t[5]=e[5]+r[5],t[6]=e[6]+r[6],t[7]=e[7]+r[7],t[8]=e[8]+r[8],t[9]=e[9]+r[9],t[10]=e[10]+r[10],t[11]=e[11]+r[11],t[12]=e[12]+r[12],t[13]=e[13]+r[13],t[14]=e[14]+r[14],t[15]=e[15]+r[15],t},Iu.subtract=Vu,Iu.multiplyScalar=function(t,e,r){return t[0]=e[0]*r,t[1]=e[1]*r,t[2]=e[2]*r,t[3]=e[3]*r,t[4]=e[4]*r,t[5]=e[5]*r,t[6]=e[6]*r,t[7]=e[7]*r,t[8]=e[8]*r,t[9]=e[9]*r,t[10]=e[10]*r,t[11]=e[11]*r,t[12]=e[12]*r,t[13]=e[13]*r,t[14]=e[14]*r,t[15]=e[15]*r,t},Iu.multiplyScalarAndAdd=function(t,e,r,n){return t[0]=e[0]+r[0]*n,t[1]=e[1]+r[1]*n,t[2]=e[2]+r[2]*n,t[3]=e[3]+r[3]*n,t[4]=e[4]+r[4]*n,t[5]=e[5]+r[5]*n,t[6]=e[6]+r[6]*n,t[7]=e[7]+r[7]*n,t[8]=e[8]+r[8]*n,t[9]=e[9]+r[9]*n,t[10]=e[10]+r[10]*n,t[11]=e[11]+r[11]*n,t[12]=e[12]+r[12]*n,t[13]=e[13]+r[13]*n,t[14]=e[14]+r[14]*n,t[15]=e[15]+r[15]*n,t},Iu.exactEquals=function(t,e){return t[0]===e[0]&&t[1]===e[1]&&t[2]===e[2]&&t[3]===e[3]&&t[4]===e[4]&&t[5]===e[5]&&t[6]===e[6]&&t[7]===e[7]&&t[8]===e[8]&&t[9]===e[9]&&t[10]===e[10]&&t[11]===e[11]&&t[12]===e[12]&&t[13]===e[13]&&t[14]===e[14]&&t[15]===e[15]},Iu.equals=function(t,e){var r=t[0],n=t[1],i=t[2],a=t[3],s=t[4],o=t[5],l=t[6],u=t[7],c=t[8],h=t[9],p=t[10],f=t[11],d=t[12],m=t[13],y=t[14],g=t[15],x=e[0],v=e[1],b=e[2],_=e[3],w=e[4],M=e[5],A=e[6],S=e[7],I=e[8],k=e[9],P=e[10],E=e[11],z=e[12],T=e[13],B=e[14],C=e[15];return Math.abs(r-x)<=Pu.EPSILON*Math.max(1,Math.abs(r),Math.abs(x))&&Math.abs(n-v)<=Pu.EPSILON*Math.max(1,Math.abs(n),Math.abs(v))&&Math.abs(i-b)<=Pu.EPSILON*Math.max(1,Math.abs(i),Math.abs(b))&&Math.abs(a-_)<=Pu.EPSILON*Math.max(1,Math.abs(a),Math.abs(_))&&Math.abs(s-w)<=Pu.EPSILON*Math.max(1,Math.abs(s),Math.abs(w))&&Math.abs(o-M)<=Pu.EPSILON*Math.max(1,Math.abs(o),Math.abs(M))&&Math.abs(l-A)<=Pu.EPSILON*Math.max(1,Math.abs(l),Math.abs(A))&&Math.abs(u-S)<=Pu.EPSILON*Math.max(1,Math.abs(u),Math.abs(S))&&Math.abs(c-I)<=Pu.EPSILON*Math.max(1,Math.abs(c),Math.abs(I))&&Math.abs(h-k)<=Pu.EPSILON*Math.max(1,Math.abs(h),Math.abs(k))&&Math.abs(p-P)<=Pu.EPSILON*Math.max(1,Math.abs(p),Math.abs(P))&&Math.abs(f-E)<=Pu.EPSILON*Math.max(1,Math.abs(f),Math.abs(E))&&Math.abs(d-z)<=Pu.EPSILON*Math.max(1,Math.abs(d),Math.abs(z))&&Math.abs(m-T)<=Pu.EPSILON*Math.max(1,Math.abs(m),Math.abs(T))&&Math.abs(y-B)<=Pu.EPSILON*Math.max(1,Math.abs(y),Math.abs(B))&&Math.abs(g-C)<=Pu.EPSILON*Math.max(1,Math.abs(g),Math.abs(C))},Iu.sub=Iu.mul=Iu.ortho=Iu.perspective=void 0;var Pu=function(t,e){if(t&&t.__esModule)return t;if(null===t||"object"!==ku(t)&&"function"!=typeof t)return {default:t};var r=Eu(void 0);if(r&&r.has(t))return r.get(t);var n={},i=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var a in t)if("default"!==a&&Object.prototype.hasOwnProperty.call(t,a)){var s=i?Object.getOwnPropertyDescriptor(t,a):null;s&&(s.get||s.set)?Object.defineProperty(n,a,s):n[a]=t[a];}return n.default=t,r&&r.set(t,n),n}(nu);function Eu(t){if("function"!=typeof WeakMap)return null;var e=new WeakMap,r=new WeakMap;return (Eu=function(t){return t?r:e})(t)}function zu(t){return t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=1,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=1,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t}function Tu(t,e,r){var n=e[0],i=e[1],a=e[2],s=e[3],o=e[4],l=e[5],u=e[6],c=e[7],h=e[8],p=e[9],f=e[10],d=e[11],m=e[12],y=e[13],g=e[14],x=e[15],v=r[0],b=r[1],_=r[2],w=r[3];return t[0]=v*n+b*o+_*h+w*m,t[1]=v*i+b*l+_*p+w*y,t[2]=v*a+b*u+_*f+w*g,t[3]=v*s+b*c+_*d+w*x,t[4]=(v=r[4])*n+(b=r[5])*o+(_=r[6])*h+(w=r[7])*m,t[5]=v*i+b*l+_*p+w*y,t[6]=v*a+b*u+_*f+w*g,t[7]=v*s+b*c+_*d+w*x,t[8]=(v=r[8])*n+(b=r[9])*o+(_=r[10])*h+(w=r[11])*m,t[9]=v*i+b*l+_*p+w*y,t[10]=v*a+b*u+_*f+w*g,t[11]=v*s+b*c+_*d+w*x,t[12]=(v=r[12])*n+(b=r[13])*o+(_=r[14])*h+(w=r[15])*m,t[13]=v*i+b*l+_*p+w*y,t[14]=v*a+b*u+_*f+w*g,t[15]=v*s+b*c+_*d+w*x,t}function Bu(t,e,r){var n=e[0],i=e[1],a=e[2],s=e[3],o=n+n,l=i+i,u=a+a,c=n*o,h=n*l,p=n*u,f=i*l,d=i*u,m=a*u,y=s*o,g=s*l,x=s*u;return t[0]=1-(f+m),t[1]=h+x,t[2]=p-g,t[3]=0,t[4]=h-x,t[5]=1-(c+m),t[6]=d+y,t[7]=0,t[8]=p+g,t[9]=d-y,t[10]=1-(c+f),t[11]=0,t[12]=r[0],t[13]=r[1],t[14]=r[2],t[15]=1,t}function Cu(t,e){var r=e[4],n=e[5],i=e[6],a=e[8],s=e[9],o=e[10];return t[0]=Math.hypot(e[0],e[1],e[2]),t[1]=Math.hypot(r,n,i),t[2]=Math.hypot(a,s,o),t}function Ru(t,e,r,n,i){var a,s=1/Math.tan(e/2);return t[0]=s/r,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=s,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[11]=-1,t[12]=0,t[13]=0,t[15]=0,null!=i&&i!==1/0?(t[10]=(i+n)*(a=1/(n-i)),t[14]=2*i*n*a):(t[10]=-1,t[14]=-2*n),t}function Du(t,e,r,n,i,a,s){var o=1/(e-r),l=1/(n-i),u=1/(a-s);return t[0]=-2*o,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=-2*l,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=2*u,t[11]=0,t[12]=(e+r)*o,t[13]=(i+n)*l,t[14]=(s+a)*u,t[15]=1,t}function Vu(t,e,r){return t[0]=e[0]-r[0],t[1]=e[1]-r[1],t[2]=e[2]-r[2],t[3]=e[3]-r[3],t[4]=e[4]-r[4],t[5]=e[5]-r[5],t[6]=e[6]-r[6],t[7]=e[7]-r[7],t[8]=e[8]-r[8],t[9]=e[9]-r[9],t[10]=e[10]-r[10],t[11]=e[11]-r[11],t[12]=e[12]-r[12],t[13]=e[13]-r[13],t[14]=e[14]-r[14],t[15]=e[15]-r[15],t}Iu.perspective=Ru,Iu.ortho=Du,Iu.mul=Tu,Iu.sub=Vu;var Lu={},Fu={};function Nu(t){return Nu="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t},Nu(t)}Object.defineProperty(Fu,"__esModule",{value:!0}),Fu.create=ju,Fu.clone=function(t){var e=new Ou.ARRAY_TYPE(3);return e[0]=t[0],e[1]=t[1],e[2]=t[2],e},Fu.length=qu,Fu.fromValues=function(t,e,r){var n=new Ou.ARRAY_TYPE(3);return n[0]=t,n[1]=e,n[2]=r,n},Fu.copy=function(t,e){return t[0]=e[0],t[1]=e[1],t[2]=e[2],t},Fu.set=function(t,e,r,n){return t[0]=e,t[1]=r,t[2]=n,t},Fu.add=function(t,e,r){return t[0]=e[0]+r[0],t[1]=e[1]+r[1],t[2]=e[2]+r[2],t},Fu.subtract=$u,Fu.multiply=Gu,Fu.divide=Yu,Fu.ceil=function(t,e){return t[0]=Math.ceil(e[0]),t[1]=Math.ceil(e[1]),t[2]=Math.ceil(e[2]),t},Fu.floor=function(t,e){return t[0]=Math.floor(e[0]),t[1]=Math.floor(e[1]),t[2]=Math.floor(e[2]),t},Fu.min=function(t,e,r){return t[0]=Math.min(e[0],r[0]),t[1]=Math.min(e[1],r[1]),t[2]=Math.min(e[2],r[2]),t},Fu.max=function(t,e,r){return t[0]=Math.max(e[0],r[0]),t[1]=Math.max(e[1],r[1]),t[2]=Math.max(e[2],r[2]),t},Fu.round=function(t,e){return t[0]=Math.round(e[0]),t[1]=Math.round(e[1]),t[2]=Math.round(e[2]),t},Fu.scale=function(t,e,r){return t[0]=e[0]*r,t[1]=e[1]*r,t[2]=e[2]*r,t},Fu.scaleAndAdd=function(t,e,r,n){return t[0]=e[0]+r[0]*n,t[1]=e[1]+r[1]*n,t[2]=e[2]+r[2]*n,t},Fu.distance=Xu,Fu.squaredDistance=Zu,Fu.squaredLength=Ku,Fu.negate=function(t,e){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t},Fu.inverse=function(t,e){return t[0]=1/e[0],t[1]=1/e[1],t[2]=1/e[2],t},Fu.normalize=function(t,e){var r=e[0],n=e[1],i=e[2],a=r*r+n*n+i*i;return a>0&&(a=1/Math.sqrt(a)),t[0]=e[0]*a,t[1]=e[1]*a,t[2]=e[2]*a,t},Fu.dot=Hu,Fu.cross=function(t,e,r){var n=e[0],i=e[1],a=e[2],s=r[0],o=r[1],l=r[2];return t[0]=i*l-a*o,t[1]=a*s-n*l,t[2]=n*o-i*s,t},Fu.lerp=function(t,e,r,n){var i=e[0],a=e[1],s=e[2];return t[0]=i+n*(r[0]-i),t[1]=a+n*(r[1]-a),t[2]=s+n*(r[2]-s),t},Fu.hermite=function(t,e,r,n,i,a){var s=a*a,o=s*(2*a-3)+1,l=s*(a-2)+a,u=s*(a-1),c=s*(3-2*a);return t[0]=e[0]*o+r[0]*l+n[0]*u+i[0]*c,t[1]=e[1]*o+r[1]*l+n[1]*u+i[1]*c,t[2]=e[2]*o+r[2]*l+n[2]*u+i[2]*c,t},Fu.bezier=function(t,e,r,n,i,a){var s=1-a,o=s*s,l=a*a,u=o*s,c=3*a*o,h=3*l*s,p=l*a;return t[0]=e[0]*u+r[0]*c+n[0]*h+i[0]*p,t[1]=e[1]*u+r[1]*c+n[1]*h+i[1]*p,t[2]=e[2]*u+r[2]*c+n[2]*h+i[2]*p,t},Fu.random=function(t,e){e=e||1;var r=2*Ou.RANDOM()*Math.PI,n=2*Ou.RANDOM()-1,i=Math.sqrt(1-n*n)*e;return t[0]=Math.cos(r)*i,t[1]=Math.sin(r)*i,t[2]=n*e,t},Fu.transformMat4=function(t,e,r){var n=e[0],i=e[1],a=e[2],s=r[3]*n+r[7]*i+r[11]*a+r[15];return t[0]=(r[0]*n+r[4]*i+r[8]*a+r[12])/(s=s||1),t[1]=(r[1]*n+r[5]*i+r[9]*a+r[13])/s,t[2]=(r[2]*n+r[6]*i+r[10]*a+r[14])/s,t},Fu.transformMat3=function(t,e,r){var n=e[0],i=e[1],a=e[2];return t[0]=n*r[0]+i*r[3]+a*r[6],t[1]=n*r[1]+i*r[4]+a*r[7],t[2]=n*r[2]+i*r[5]+a*r[8],t},Fu.transformQuat=function(t,e,r){var n=r[0],i=r[1],a=r[2],s=e[0],o=e[1],l=e[2],u=i*l-a*o,c=a*s-n*l,h=n*o-i*s,p=i*h-a*c,f=a*u-n*h,d=n*c-i*u,m=2*r[3];return c*=m,h*=m,f*=2,d*=2,t[0]=s+(u*=m)+(p*=2),t[1]=o+c+f,t[2]=l+h+d,t},Fu.rotateX=function(t,e,r,n){var i=[],a=[];return i[0]=e[0]-r[0],i[1]=e[1]-r[1],i[2]=e[2]-r[2],a[0]=i[0],a[1]=i[1]*Math.cos(n)-i[2]*Math.sin(n),a[2]=i[1]*Math.sin(n)+i[2]*Math.cos(n),t[0]=a[0]+r[0],t[1]=a[1]+r[1],t[2]=a[2]+r[2],t},Fu.rotateY=function(t,e,r,n){var i=[],a=[];return i[0]=e[0]-r[0],i[1]=e[1]-r[1],i[2]=e[2]-r[2],a[0]=i[2]*Math.sin(n)+i[0]*Math.cos(n),a[1]=i[1],a[2]=i[2]*Math.cos(n)-i[0]*Math.sin(n),t[0]=a[0]+r[0],t[1]=a[1]+r[1],t[2]=a[2]+r[2],t},Fu.rotateZ=function(t,e,r,n){var i=[],a=[];return i[0]=e[0]-r[0],i[1]=e[1]-r[1],i[2]=e[2]-r[2],a[0]=i[0]*Math.cos(n)-i[1]*Math.sin(n),a[1]=i[0]*Math.sin(n)+i[1]*Math.cos(n),a[2]=i[2],t[0]=a[0]+r[0],t[1]=a[1]+r[1],t[2]=a[2]+r[2],t},Fu.angle=function(t,e){var r=t[0],n=t[1],i=t[2],a=e[0],s=e[1],o=e[2],l=Math.sqrt(r*r+n*n+i*i)*Math.sqrt(a*a+s*s+o*o),u=l&&Hu(t,e)/l;return Math.acos(Math.min(Math.max(u,-1),1))},Fu.zero=function(t){return t[0]=0,t[1]=0,t[2]=0,t},Fu.str=function(t){return "vec3("+t[0]+", "+t[1]+", "+t[2]+")"},Fu.exactEquals=function(t,e){return t[0]===e[0]&&t[1]===e[1]&&t[2]===e[2]},Fu.equals=function(t,e){var r=t[0],n=t[1],i=t[2],a=e[0],s=e[1],o=e[2];return Math.abs(r-a)<=Ou.EPSILON*Math.max(1,Math.abs(r),Math.abs(a))&&Math.abs(n-s)<=Ou.EPSILON*Math.max(1,Math.abs(n),Math.abs(s))&&Math.abs(i-o)<=Ou.EPSILON*Math.max(1,Math.abs(i),Math.abs(o))},Fu.forEach=Fu.sqrLen=Fu.len=Fu.sqrDist=Fu.dist=Fu.div=Fu.mul=Fu.sub=void 0;var Ou=function(t,e){if(t&&t.__esModule)return t;if(null===t||"object"!==Nu(t)&&"function"!=typeof t)return {default:t};var r=Uu(void 0);if(r&&r.has(t))return r.get(t);var n={},i=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var a in t)if("default"!==a&&Object.prototype.hasOwnProperty.call(t,a)){var s=i?Object.getOwnPropertyDescriptor(t,a):null;s&&(s.get||s.set)?Object.defineProperty(n,a,s):n[a]=t[a];}return n.default=t,r&&r.set(t,n),n}(nu);function Uu(t){if("function"!=typeof WeakMap)return null;var e=new WeakMap,r=new WeakMap;return (Uu=function(t){return t?r:e})(t)}function ju(){var t=new Ou.ARRAY_TYPE(3);return Ou.ARRAY_TYPE!=Float32Array&&(t[0]=0,t[1]=0,t[2]=0),t}function qu(t){return Math.hypot(t[0],t[1],t[2])}function $u(t,e,r){return t[0]=e[0]-r[0],t[1]=e[1]-r[1],t[2]=e[2]-r[2],t}function Gu(t,e,r){return t[0]=e[0]*r[0],t[1]=e[1]*r[1],t[2]=e[2]*r[2],t}function Yu(t,e,r){return t[0]=e[0]/r[0],t[1]=e[1]/r[1],t[2]=e[2]/r[2],t}function Xu(t,e){return Math.hypot(e[0]-t[0],e[1]-t[1],e[2]-t[2])}function Zu(t,e){var r=e[0]-t[0],n=e[1]-t[1],i=e[2]-t[2];return r*r+n*n+i*i}function Ku(t){var e=t[0],r=t[1],n=t[2];return e*e+r*r+n*n}function Hu(t,e){return t[0]*e[0]+t[1]*e[1]+t[2]*e[2]}Fu.sub=$u,Fu.mul=Gu,Fu.div=Yu,Fu.dist=Xu,Fu.sqrDist=Zu,Fu.len=qu,Fu.sqrLen=Ku;var Wu,Ju=(Wu=ju(),function(t,e,r,n,i,a){var s,o;for(e||(e=3),r||(r=0),o=n?Math.min(n*e+r,t.length):t.length,s=r;s<o;s+=e)Wu[0]=t[s],Wu[1]=t[s+1],Wu[2]=t[s+2],i(Wu,Wu,a),t[s]=Wu[0],t[s+1]=Wu[1],t[s+2]=Wu[2];return t});Fu.forEach=Ju;var Qu={};function tc(t){return tc="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t},tc(t)}Object.defineProperty(Qu,"__esModule",{value:!0}),Qu.create=nc,Qu.clone=function(t){var e=new ec.ARRAY_TYPE(4);return e[0]=t[0],e[1]=t[1],e[2]=t[2],e[3]=t[3],e},Qu.fromValues=function(t,e,r,n){var i=new ec.ARRAY_TYPE(4);return i[0]=t,i[1]=e,i[2]=r,i[3]=n,i},Qu.copy=function(t,e){return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t},Qu.set=function(t,e,r,n,i){return t[0]=e,t[1]=r,t[2]=n,t[3]=i,t},Qu.add=function(t,e,r){return t[0]=e[0]+r[0],t[1]=e[1]+r[1],t[2]=e[2]+r[2],t[3]=e[3]+r[3],t},Qu.subtract=ic,Qu.multiply=ac,Qu.divide=sc,Qu.ceil=function(t,e){return t[0]=Math.ceil(e[0]),t[1]=Math.ceil(e[1]),t[2]=Math.ceil(e[2]),t[3]=Math.ceil(e[3]),t},Qu.floor=function(t,e){return t[0]=Math.floor(e[0]),t[1]=Math.floor(e[1]),t[2]=Math.floor(e[2]),t[3]=Math.floor(e[3]),t},Qu.min=function(t,e,r){return t[0]=Math.min(e[0],r[0]),t[1]=Math.min(e[1],r[1]),t[2]=Math.min(e[2],r[2]),t[3]=Math.min(e[3],r[3]),t},Qu.max=function(t,e,r){return t[0]=Math.max(e[0],r[0]),t[1]=Math.max(e[1],r[1]),t[2]=Math.max(e[2],r[2]),t[3]=Math.max(e[3],r[3]),t},Qu.round=function(t,e){return t[0]=Math.round(e[0]),t[1]=Math.round(e[1]),t[2]=Math.round(e[2]),t[3]=Math.round(e[3]),t},Qu.scale=function(t,e,r){return t[0]=e[0]*r,t[1]=e[1]*r,t[2]=e[2]*r,t[3]=e[3]*r,t},Qu.scaleAndAdd=function(t,e,r,n){return t[0]=e[0]+r[0]*n,t[1]=e[1]+r[1]*n,t[2]=e[2]+r[2]*n,t[3]=e[3]+r[3]*n,t},Qu.distance=oc,Qu.squaredDistance=lc,Qu.length=uc,Qu.squaredLength=cc,Qu.negate=function(t,e){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t},Qu.inverse=function(t,e){return t[0]=1/e[0],t[1]=1/e[1],t[2]=1/e[2],t[3]=1/e[3],t},Qu.normalize=function(t,e){var r=e[0],n=e[1],i=e[2],a=e[3],s=r*r+n*n+i*i+a*a;return s>0&&(s=1/Math.sqrt(s)),t[0]=r*s,t[1]=n*s,t[2]=i*s,t[3]=a*s,t},Qu.dot=function(t,e){return t[0]*e[0]+t[1]*e[1]+t[2]*e[2]+t[3]*e[3]},Qu.cross=function(t,e,r,n){var i=r[0]*n[1]-r[1]*n[0],a=r[0]*n[2]-r[2]*n[0],s=r[0]*n[3]-r[3]*n[0],o=r[1]*n[2]-r[2]*n[1],l=r[1]*n[3]-r[3]*n[1],u=r[2]*n[3]-r[3]*n[2],c=e[0],h=e[1],p=e[2],f=e[3];return t[0]=h*u-p*l+f*o,t[1]=-c*u+p*s-f*a,t[2]=c*l-h*s+f*i,t[3]=-c*o+h*a-p*i,t},Qu.lerp=function(t,e,r,n){var i=e[0],a=e[1],s=e[2],o=e[3];return t[0]=i+n*(r[0]-i),t[1]=a+n*(r[1]-a),t[2]=s+n*(r[2]-s),t[3]=o+n*(r[3]-o),t},Qu.random=function(t,e){var r,n,i,a,s,o;e=e||1;do{s=(r=2*ec.RANDOM()-1)*r+(n=2*ec.RANDOM()-1)*n;}while(s>=1);do{o=(i=2*ec.RANDOM()-1)*i+(a=2*ec.RANDOM()-1)*a;}while(o>=1);var l=Math.sqrt((1-s)/o);return t[0]=e*r,t[1]=e*n,t[2]=e*i*l,t[3]=e*a*l,t},Qu.transformMat4=function(t,e,r){var n=e[0],i=e[1],a=e[2],s=e[3];return t[0]=r[0]*n+r[4]*i+r[8]*a+r[12]*s,t[1]=r[1]*n+r[5]*i+r[9]*a+r[13]*s,t[2]=r[2]*n+r[6]*i+r[10]*a+r[14]*s,t[3]=r[3]*n+r[7]*i+r[11]*a+r[15]*s,t},Qu.transformQuat=function(t,e,r){var n=e[0],i=e[1],a=e[2],s=r[0],o=r[1],l=r[2],u=r[3],c=u*n+o*a-l*i,h=u*i+l*n-s*a,p=u*a+s*i-o*n,f=-s*n-o*i-l*a;return t[0]=c*u+f*-s+h*-l-p*-o,t[1]=h*u+f*-o+p*-s-c*-l,t[2]=p*u+f*-l+c*-o-h*-s,t[3]=e[3],t},Qu.zero=function(t){return t[0]=0,t[1]=0,t[2]=0,t[3]=0,t},Qu.str=function(t){return "vec4("+t[0]+", "+t[1]+", "+t[2]+", "+t[3]+")"},Qu.exactEquals=function(t,e){return t[0]===e[0]&&t[1]===e[1]&&t[2]===e[2]&&t[3]===e[3]},Qu.equals=function(t,e){var r=t[0],n=t[1],i=t[2],a=t[3],s=e[0],o=e[1],l=e[2],u=e[3];return Math.abs(r-s)<=ec.EPSILON*Math.max(1,Math.abs(r),Math.abs(s))&&Math.abs(n-o)<=ec.EPSILON*Math.max(1,Math.abs(n),Math.abs(o))&&Math.abs(i-l)<=ec.EPSILON*Math.max(1,Math.abs(i),Math.abs(l))&&Math.abs(a-u)<=ec.EPSILON*Math.max(1,Math.abs(a),Math.abs(u))},Qu.forEach=Qu.sqrLen=Qu.len=Qu.sqrDist=Qu.dist=Qu.div=Qu.mul=Qu.sub=void 0;var ec=function(t,e){if(t&&t.__esModule)return t;if(null===t||"object"!==tc(t)&&"function"!=typeof t)return {default:t};var r=rc(void 0);if(r&&r.has(t))return r.get(t);var n={},i=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var a in t)if("default"!==a&&Object.prototype.hasOwnProperty.call(t,a)){var s=i?Object.getOwnPropertyDescriptor(t,a):null;s&&(s.get||s.set)?Object.defineProperty(n,a,s):n[a]=t[a];}return n.default=t,r&&r.set(t,n),n}(nu);function rc(t){if("function"!=typeof WeakMap)return null;var e=new WeakMap,r=new WeakMap;return (rc=function(t){return t?r:e})(t)}function nc(){var t=new ec.ARRAY_TYPE(4);return ec.ARRAY_TYPE!=Float32Array&&(t[0]=0,t[1]=0,t[2]=0,t[3]=0),t}function ic(t,e,r){return t[0]=e[0]-r[0],t[1]=e[1]-r[1],t[2]=e[2]-r[2],t[3]=e[3]-r[3],t}function ac(t,e,r){return t[0]=e[0]*r[0],t[1]=e[1]*r[1],t[2]=e[2]*r[2],t[3]=e[3]*r[3],t}function sc(t,e,r){return t[0]=e[0]/r[0],t[1]=e[1]/r[1],t[2]=e[2]/r[2],t[3]=e[3]/r[3],t}function oc(t,e){return Math.hypot(e[0]-t[0],e[1]-t[1],e[2]-t[2],e[3]-t[3])}function lc(t,e){var r=e[0]-t[0],n=e[1]-t[1],i=e[2]-t[2],a=e[3]-t[3];return r*r+n*n+i*i+a*a}function uc(t){return Math.hypot(t[0],t[1],t[2],t[3])}function cc(t){var e=t[0],r=t[1],n=t[2],i=t[3];return e*e+r*r+n*n+i*i}Qu.sub=ic,Qu.mul=ac,Qu.div=sc,Qu.dist=oc,Qu.sqrDist=lc,Qu.len=uc,Qu.sqrLen=cc;var hc=function(){var t=nc();return function(e,r,n,i,a,s){var o,l;for(r||(r=4),n||(n=0),l=i?Math.min(i*r+n,e.length):e.length,o=n;o<l;o+=r)t[0]=e[o],t[1]=e[o+1],t[2]=e[o+2],t[3]=e[o+3],a(t,t,s),e[o]=t[0],e[o+1]=t[1],e[o+2]=t[2],e[o+3]=t[3];return e}}();function pc(t){return pc="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t},pc(t)}Qu.forEach=hc,Object.defineProperty(Lu,"__esModule",{value:!0}),Lu.create=vc,Lu.identity=function(t){return t[0]=0,t[1]=0,t[2]=0,t[3]=1,t},Lu.setAxisAngle=bc,Lu.getAxisAngle=function(t,e){var r=2*Math.acos(e[3]),n=Math.sin(r/2);return n>fc.EPSILON?(t[0]=e[0]/n,t[1]=e[1]/n,t[2]=e[2]/n):(t[0]=1,t[1]=0,t[2]=0),r},Lu.getAngle=function(t,e){var r=kc(t,e);return Math.acos(2*r*r-1)},Lu.multiply=_c,Lu.rotateX=function(t,e,r){r*=.5;var n=e[0],i=e[1],a=e[2],s=e[3],o=Math.sin(r),l=Math.cos(r);return t[0]=n*l+s*o,t[1]=i*l+a*o,t[2]=a*l-i*o,t[3]=s*l-n*o,t},Lu.rotateY=function(t,e,r){r*=.5;var n=e[0],i=e[1],a=e[2],s=e[3],o=Math.sin(r),l=Math.cos(r);return t[0]=n*l-a*o,t[1]=i*l+s*o,t[2]=a*l+n*o,t[3]=s*l-i*o,t},Lu.rotateZ=function(t,e,r){r*=.5;var n=e[0],i=e[1],a=e[2],s=e[3],o=Math.sin(r),l=Math.cos(r);return t[0]=n*l+i*o,t[1]=i*l-n*o,t[2]=a*l+s*o,t[3]=s*l-a*o,t},Lu.calculateW=function(t,e){var r=e[0],n=e[1],i=e[2];return t[0]=r,t[1]=n,t[2]=i,t[3]=Math.sqrt(Math.abs(1-r*r-n*n-i*i)),t},Lu.exp=wc,Lu.ln=Mc,Lu.pow=function(t,e,r){return Mc(t,e),Ic(t,t,r),wc(t,t),t},Lu.slerp=Ac,Lu.random=function(t){var e=fc.RANDOM(),r=fc.RANDOM(),n=fc.RANDOM(),i=Math.sqrt(1-e),a=Math.sqrt(e);return t[0]=i*Math.sin(2*Math.PI*r),t[1]=i*Math.cos(2*Math.PI*r),t[2]=a*Math.sin(2*Math.PI*n),t[3]=a*Math.cos(2*Math.PI*n),t},Lu.invert=function(t,e){var r=e[0],n=e[1],i=e[2],a=e[3],s=r*r+n*n+i*i+a*a,o=s?1/s:0;return t[0]=-r*o,t[1]=-n*o,t[2]=-i*o,t[3]=a*o,t},Lu.conjugate=function(t,e){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=e[3],t},Lu.fromMat3=Sc,Lu.fromEuler=function(t,e,r,n){var i=.5*Math.PI/180;e*=i,r*=i,n*=i;var a=Math.sin(e),s=Math.cos(e),o=Math.sin(r),l=Math.cos(r),u=Math.sin(n),c=Math.cos(n);return t[0]=a*l*c-s*o*u,t[1]=s*o*c+a*l*u,t[2]=s*l*u-a*o*c,t[3]=s*l*c+a*o*u,t},Lu.str=function(t){return "quat("+t[0]+", "+t[1]+", "+t[2]+", "+t[3]+")"},Lu.setAxes=Lu.sqlerp=Lu.rotationTo=Lu.equals=Lu.exactEquals=Lu.normalize=Lu.sqrLen=Lu.squaredLength=Lu.len=Lu.length=Lu.lerp=Lu.dot=Lu.scale=Lu.mul=Lu.add=Lu.set=Lu.copy=Lu.fromValues=Lu.clone=void 0;var fc=xc(nu),dc=xc(bu),mc=xc(Fu),yc=xc(Qu);function gc(t){if("function"!=typeof WeakMap)return null;var e=new WeakMap,r=new WeakMap;return (gc=function(t){return t?r:e})(t)}function xc(t,e){if(!e&&t&&t.__esModule)return t;if(null===t||"object"!==pc(t)&&"function"!=typeof t)return {default:t};var r=gc(e);if(r&&r.has(t))return r.get(t);var n={},i=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var a in t)if("default"!==a&&Object.prototype.hasOwnProperty.call(t,a)){var s=i?Object.getOwnPropertyDescriptor(t,a):null;s&&(s.get||s.set)?Object.defineProperty(n,a,s):n[a]=t[a];}return n.default=t,r&&r.set(t,n),n}function vc(){var t=new fc.ARRAY_TYPE(4);return fc.ARRAY_TYPE!=Float32Array&&(t[0]=0,t[1]=0,t[2]=0),t[3]=1,t}function bc(t,e,r){r*=.5;var n=Math.sin(r);return t[0]=n*e[0],t[1]=n*e[1],t[2]=n*e[2],t[3]=Math.cos(r),t}function _c(t,e,r){var n=e[0],i=e[1],a=e[2],s=e[3],o=r[0],l=r[1],u=r[2],c=r[3];return t[0]=n*c+s*o+i*u-a*l,t[1]=i*c+s*l+a*o-n*u,t[2]=a*c+s*u+n*l-i*o,t[3]=s*c-n*o-i*l-a*u,t}function wc(t,e){var r=e[0],n=e[1],i=e[2],a=e[3],s=Math.sqrt(r*r+n*n+i*i),o=Math.exp(a),l=s>0?o*Math.sin(s)/s:0;return t[0]=r*l,t[1]=n*l,t[2]=i*l,t[3]=o*Math.cos(s),t}function Mc(t,e){var r=e[0],n=e[1],i=e[2],a=e[3],s=Math.sqrt(r*r+n*n+i*i),o=s>0?Math.atan2(s,a)/s:0;return t[0]=r*o,t[1]=n*o,t[2]=i*o,t[3]=.5*Math.log(r*r+n*n+i*i+a*a),t}function Ac(t,e,r,n){var i,a,s,o,l,u=e[0],c=e[1],h=e[2],p=e[3],f=r[0],d=r[1],m=r[2],y=r[3];return (a=u*f+c*d+h*m+p*y)<0&&(a=-a,f=-f,d=-d,m=-m,y=-y),1-a>fc.EPSILON?(i=Math.acos(a),s=Math.sin(i),o=Math.sin((1-n)*i)/s,l=Math.sin(n*i)/s):(o=1-n,l=n),t[0]=o*u+l*f,t[1]=o*c+l*d,t[2]=o*h+l*m,t[3]=o*p+l*y,t}function Sc(t,e){var r,n=e[0]+e[4]+e[8];if(n>0)r=Math.sqrt(n+1),t[3]=.5*r,t[0]=(e[5]-e[7])*(r=.5/r),t[1]=(e[6]-e[2])*r,t[2]=(e[1]-e[3])*r;else {var i=0;e[4]>e[0]&&(i=1),e[8]>e[3*i+i]&&(i=2);var a=(i+1)%3,s=(i+2)%3;r=Math.sqrt(e[3*i+i]-e[3*a+a]-e[3*s+s]+1),t[i]=.5*r,t[3]=(e[3*a+s]-e[3*s+a])*(r=.5/r),t[a]=(e[3*a+i]+e[3*i+a])*r,t[s]=(e[3*s+i]+e[3*i+s])*r;}return t}Lu.clone=yc.clone,Lu.fromValues=yc.fromValues,Lu.copy=yc.copy,Lu.set=yc.set,Lu.add=yc.add,Lu.mul=_c;var Ic=yc.scale;Lu.scale=Ic;var kc=yc.dot;Lu.dot=kc,Lu.lerp=yc.lerp;var Pc=yc.length;Lu.length=Pc,Lu.len=Pc;var Ec=yc.squaredLength;Lu.squaredLength=Ec,Lu.sqrLen=Ec;var zc=yc.normalize;Lu.normalize=zc,Lu.exactEquals=yc.exactEquals,Lu.equals=yc.equals;var Tc,Bc,Cc,Rc=(Tc=mc.create(),Bc=mc.fromValues(1,0,0),Cc=mc.fromValues(0,1,0),function(t,e,r){var n=mc.dot(e,r);return n<-.999999?(mc.cross(Tc,Bc,e),mc.len(Tc)<1e-6&&mc.cross(Tc,Cc,e),mc.normalize(Tc,Tc),bc(t,Tc,Math.PI),t):n>.999999?(t[0]=0,t[1]=0,t[2]=0,t[3]=1,t):(mc.cross(Tc,e,r),t[0]=Tc[0],t[1]=Tc[1],t[2]=Tc[2],t[3]=1+n,zc(t,t))});Lu.rotationTo=Rc;var Dc,Vc,Lc=(Dc=vc(),Vc=vc(),function(t,e,r,n,i,a){return Ac(Dc,e,i,a),Ac(Vc,r,n,a),Ac(t,Dc,Vc,2*a*(1-a)),t});Lu.sqlerp=Lc;var Fc,Nc=(Fc=dc.create(),function(t,e,r,n){return Fc[0]=r[0],Fc[3]=r[1],Fc[6]=r[2],Fc[1]=n[0],Fc[4]=n[1],Fc[7]=n[2],Fc[2]=-e[0],Fc[5]=-e[1],Fc[8]=-e[2],zc(t,Sc(t,Fc))});Lu.setAxes=Nc;var Oc={};function Uc(t){return Uc="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t},Uc(t)}Object.defineProperty(Oc,"__esModule",{value:!0}),Oc.create=function(){var t=new jc.ARRAY_TYPE(8);return jc.ARRAY_TYPE!=Float32Array&&(t[0]=0,t[1]=0,t[2]=0,t[4]=0,t[5]=0,t[6]=0,t[7]=0),t[3]=1,t},Oc.clone=function(t){var e=new jc.ARRAY_TYPE(8);return e[0]=t[0],e[1]=t[1],e[2]=t[2],e[3]=t[3],e[4]=t[4],e[5]=t[5],e[6]=t[6],e[7]=t[7],e},Oc.fromValues=function(t,e,r,n,i,a,s,o){var l=new jc.ARRAY_TYPE(8);return l[0]=t,l[1]=e,l[2]=r,l[3]=n,l[4]=i,l[5]=a,l[6]=s,l[7]=o,l},Oc.fromRotationTranslationValues=function(t,e,r,n,i,a,s){var o=new jc.ARRAY_TYPE(8);o[0]=t,o[1]=e,o[2]=r,o[3]=n;var l=.5*i,u=.5*a,c=.5*s;return o[4]=l*n+u*r-c*e,o[5]=u*n+c*t-l*r,o[6]=c*n+l*e-u*t,o[7]=-l*t-u*e-c*r,o},Oc.fromRotationTranslation=Xc,Oc.fromTranslation=function(t,e){return t[0]=0,t[1]=0,t[2]=0,t[3]=1,t[4]=.5*e[0],t[5]=.5*e[1],t[6]=.5*e[2],t[7]=0,t},Oc.fromRotation=function(t,e){return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=0,t[5]=0,t[6]=0,t[7]=0,t},Oc.fromMat4=function(t,e){var r=qc.create();$c.getRotation(r,e);var n=new jc.ARRAY_TYPE(3);return $c.getTranslation(n,e),Xc(t,r,n),t},Oc.copy=Zc,Oc.identity=function(t){return t[0]=0,t[1]=0,t[2]=0,t[3]=1,t[4]=0,t[5]=0,t[6]=0,t[7]=0,t},Oc.set=function(t,e,r,n,i,a,s,o,l){return t[0]=e,t[1]=r,t[2]=n,t[3]=i,t[4]=a,t[5]=s,t[6]=o,t[7]=l,t},Oc.getDual=function(t,e){return t[0]=e[4],t[1]=e[5],t[2]=e[6],t[3]=e[7],t},Oc.setDual=function(t,e){return t[4]=e[0],t[5]=e[1],t[6]=e[2],t[7]=e[3],t},Oc.getTranslation=function(t,e){var r=e[4],n=e[5],i=e[6],a=e[7],s=-e[0],o=-e[1],l=-e[2],u=e[3];return t[0]=2*(r*u+a*s+n*l-i*o),t[1]=2*(n*u+a*o+i*s-r*l),t[2]=2*(i*u+a*l+r*o-n*s),t},Oc.translate=function(t,e,r){var n=e[0],i=e[1],a=e[2],s=e[3],o=.5*r[0],l=.5*r[1],u=.5*r[2],c=e[4],h=e[5],p=e[6],f=e[7];return t[0]=n,t[1]=i,t[2]=a,t[3]=s,t[4]=s*o+i*u-a*l+c,t[5]=s*l+a*o-n*u+h,t[6]=s*u+n*l-i*o+p,t[7]=-n*o-i*l-a*u+f,t},Oc.rotateX=function(t,e,r){var n=-e[0],i=-e[1],a=-e[2],s=e[3],o=e[4],l=e[5],u=e[6],c=e[7],h=o*s+c*n+l*a-u*i,p=l*s+c*i+u*n-o*a,f=u*s+c*a+o*i-l*n,d=c*s-o*n-l*i-u*a;return qc.rotateX(t,e,r),t[4]=h*(s=t[3])+d*(n=t[0])+p*(a=t[2])-f*(i=t[1]),t[5]=p*s+d*i+f*n-h*a,t[6]=f*s+d*a+h*i-p*n,t[7]=d*s-h*n-p*i-f*a,t},Oc.rotateY=function(t,e,r){var n=-e[0],i=-e[1],a=-e[2],s=e[3],o=e[4],l=e[5],u=e[6],c=e[7],h=o*s+c*n+l*a-u*i,p=l*s+c*i+u*n-o*a,f=u*s+c*a+o*i-l*n,d=c*s-o*n-l*i-u*a;return qc.rotateY(t,e,r),t[4]=h*(s=t[3])+d*(n=t[0])+p*(a=t[2])-f*(i=t[1]),t[5]=p*s+d*i+f*n-h*a,t[6]=f*s+d*a+h*i-p*n,t[7]=d*s-h*n-p*i-f*a,t},Oc.rotateZ=function(t,e,r){var n=-e[0],i=-e[1],a=-e[2],s=e[3],o=e[4],l=e[5],u=e[6],c=e[7],h=o*s+c*n+l*a-u*i,p=l*s+c*i+u*n-o*a,f=u*s+c*a+o*i-l*n,d=c*s-o*n-l*i-u*a;return qc.rotateZ(t,e,r),t[4]=h*(s=t[3])+d*(n=t[0])+p*(a=t[2])-f*(i=t[1]),t[5]=p*s+d*i+f*n-h*a,t[6]=f*s+d*a+h*i-p*n,t[7]=d*s-h*n-p*i-f*a,t},Oc.rotateByQuatAppend=function(t,e,r){var n=r[0],i=r[1],a=r[2],s=r[3],o=e[0],l=e[1],u=e[2],c=e[3];return t[0]=o*s+c*n+l*a-u*i,t[1]=l*s+c*i+u*n-o*a,t[2]=u*s+c*a+o*i-l*n,t[3]=c*s-o*n-l*i-u*a,t[4]=(o=e[4])*s+(c=e[7])*n+(l=e[5])*a-(u=e[6])*i,t[5]=l*s+c*i+u*n-o*a,t[6]=u*s+c*a+o*i-l*n,t[7]=c*s-o*n-l*i-u*a,t},Oc.rotateByQuatPrepend=function(t,e,r){var n=e[0],i=e[1],a=e[2],s=e[3],o=r[0],l=r[1],u=r[2],c=r[3];return t[0]=n*c+s*o+i*u-a*l,t[1]=i*c+s*l+a*o-n*u,t[2]=a*c+s*u+n*l-i*o,t[3]=s*c-n*o-i*l-a*u,t[4]=n*(c=r[7])+s*(o=r[4])+i*(u=r[6])-a*(l=r[5]),t[5]=i*c+s*l+a*o-n*u,t[6]=a*c+s*u+n*l-i*o,t[7]=s*c-n*o-i*l-a*u,t},Oc.rotateAroundAxis=function(t,e,r,n){if(Math.abs(n)<jc.EPSILON)return Zc(t,e);var i=Math.hypot(r[0],r[1],r[2]);n*=.5;var a=Math.sin(n),s=a*r[0]/i,o=a*r[1]/i,l=a*r[2]/i,u=Math.cos(n),c=e[0],h=e[1],p=e[2],f=e[3];t[0]=c*u+f*s+h*l-p*o,t[1]=h*u+f*o+p*s-c*l,t[2]=p*u+f*l+c*o-h*s,t[3]=f*u-c*s-h*o-p*l;var d=e[4],m=e[5],y=e[6],g=e[7];return t[4]=d*u+g*s+m*l-y*o,t[5]=m*u+g*o+y*s-d*l,t[6]=y*u+g*l+d*o-m*s,t[7]=g*u-d*s-m*o-y*l,t},Oc.add=function(t,e,r){return t[0]=e[0]+r[0],t[1]=e[1]+r[1],t[2]=e[2]+r[2],t[3]=e[3]+r[3],t[4]=e[4]+r[4],t[5]=e[5]+r[5],t[6]=e[6]+r[6],t[7]=e[7]+r[7],t},Oc.multiply=Kc,Oc.scale=function(t,e,r){return t[0]=e[0]*r,t[1]=e[1]*r,t[2]=e[2]*r,t[3]=e[3]*r,t[4]=e[4]*r,t[5]=e[5]*r,t[6]=e[6]*r,t[7]=e[7]*r,t},Oc.lerp=function(t,e,r,n){var i=1-n;return Hc(e,r)<0&&(n=-n),t[0]=e[0]*i+r[0]*n,t[1]=e[1]*i+r[1]*n,t[2]=e[2]*i+r[2]*n,t[3]=e[3]*i+r[3]*n,t[4]=e[4]*i+r[4]*n,t[5]=e[5]*i+r[5]*n,t[6]=e[6]*i+r[6]*n,t[7]=e[7]*i+r[7]*n,t},Oc.invert=function(t,e){var r=Jc(e);return t[0]=-e[0]/r,t[1]=-e[1]/r,t[2]=-e[2]/r,t[3]=e[3]/r,t[4]=-e[4]/r,t[5]=-e[5]/r,t[6]=-e[6]/r,t[7]=e[7]/r,t},Oc.conjugate=function(t,e){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=e[3],t[4]=-e[4],t[5]=-e[5],t[6]=-e[6],t[7]=e[7],t},Oc.normalize=function(t,e){var r=Jc(e);if(r>0){r=Math.sqrt(r);var n=e[0]/r,i=e[1]/r,a=e[2]/r,s=e[3]/r,o=e[4],l=e[5],u=e[6],c=e[7],h=n*o+i*l+a*u+s*c;t[0]=n,t[1]=i,t[2]=a,t[3]=s,t[4]=(o-n*h)/r,t[5]=(l-i*h)/r,t[6]=(u-a*h)/r,t[7]=(c-s*h)/r;}return t},Oc.str=function(t){return "quat2("+t[0]+", "+t[1]+", "+t[2]+", "+t[3]+", "+t[4]+", "+t[5]+", "+t[6]+", "+t[7]+")"},Oc.exactEquals=function(t,e){return t[0]===e[0]&&t[1]===e[1]&&t[2]===e[2]&&t[3]===e[3]&&t[4]===e[4]&&t[5]===e[5]&&t[6]===e[6]&&t[7]===e[7]},Oc.equals=function(t,e){var r=t[0],n=t[1],i=t[2],a=t[3],s=t[4],o=t[5],l=t[6],u=t[7],c=e[0],h=e[1],p=e[2],f=e[3],d=e[4],m=e[5],y=e[6],g=e[7];return Math.abs(r-c)<=jc.EPSILON*Math.max(1,Math.abs(r),Math.abs(c))&&Math.abs(n-h)<=jc.EPSILON*Math.max(1,Math.abs(n),Math.abs(h))&&Math.abs(i-p)<=jc.EPSILON*Math.max(1,Math.abs(i),Math.abs(p))&&Math.abs(a-f)<=jc.EPSILON*Math.max(1,Math.abs(a),Math.abs(f))&&Math.abs(s-d)<=jc.EPSILON*Math.max(1,Math.abs(s),Math.abs(d))&&Math.abs(o-m)<=jc.EPSILON*Math.max(1,Math.abs(o),Math.abs(m))&&Math.abs(l-y)<=jc.EPSILON*Math.max(1,Math.abs(l),Math.abs(y))&&Math.abs(u-g)<=jc.EPSILON*Math.max(1,Math.abs(u),Math.abs(g))},Oc.sqrLen=Oc.squaredLength=Oc.len=Oc.length=Oc.dot=Oc.mul=Oc.setReal=Oc.getReal=void 0;var jc=Yc(nu),qc=Yc(Lu),$c=Yc(Iu);function Gc(t){if("function"!=typeof WeakMap)return null;var e=new WeakMap,r=new WeakMap;return (Gc=function(t){return t?r:e})(t)}function Yc(t,e){if(!e&&t&&t.__esModule)return t;if(null===t||"object"!==Uc(t)&&"function"!=typeof t)return {default:t};var r=Gc(e);if(r&&r.has(t))return r.get(t);var n={},i=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var a in t)if("default"!==a&&Object.prototype.hasOwnProperty.call(t,a)){var s=i?Object.getOwnPropertyDescriptor(t,a):null;s&&(s.get||s.set)?Object.defineProperty(n,a,s):n[a]=t[a];}return n.default=t,r&&r.set(t,n),n}function Xc(t,e,r){var n=.5*r[0],i=.5*r[1],a=.5*r[2],s=e[0],o=e[1],l=e[2],u=e[3];return t[0]=s,t[1]=o,t[2]=l,t[3]=u,t[4]=n*u+i*l-a*o,t[5]=i*u+a*s-n*l,t[6]=a*u+n*o-i*s,t[7]=-n*s-i*o-a*l,t}function Zc(t,e){return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t}function Kc(t,e,r){var n=e[0],i=e[1],a=e[2],s=e[3],o=r[4],l=r[5],u=r[6],c=r[7],h=e[4],p=e[5],f=e[6],d=e[7],m=r[0],y=r[1],g=r[2],x=r[3];return t[0]=n*x+s*m+i*g-a*y,t[1]=i*x+s*y+a*m-n*g,t[2]=a*x+s*g+n*y-i*m,t[3]=s*x-n*m-i*y-a*g,t[4]=n*c+s*o+i*u-a*l+h*x+d*m+p*g-f*y,t[5]=i*c+s*l+a*o-n*u+p*x+d*y+f*m-h*g,t[6]=a*c+s*u+n*l-i*o+f*x+d*g+h*y-p*m,t[7]=s*c-n*o-i*l-a*u+d*x-h*m-p*y-f*g,t}Oc.getReal=qc.copy,Oc.setReal=qc.copy,Oc.mul=Kc;var Hc=qc.dot;Oc.dot=Hc;var Wc=qc.length;Oc.length=Wc,Oc.len=Wc;var Jc=qc.squaredLength;Oc.squaredLength=Jc,Oc.sqrLen=Jc;var Qc={};function th(t){return th="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t},th(t)}Object.defineProperty(Qc,"__esModule",{value:!0}),Qc.create=nh,Qc.clone=function(t){var e=new eh.ARRAY_TYPE(2);return e[0]=t[0],e[1]=t[1],e},Qc.fromValues=function(t,e){var r=new eh.ARRAY_TYPE(2);return r[0]=t,r[1]=e,r},Qc.copy=function(t,e){return t[0]=e[0],t[1]=e[1],t},Qc.set=function(t,e,r){return t[0]=e,t[1]=r,t},Qc.add=function(t,e,r){return t[0]=e[0]+r[0],t[1]=e[1]+r[1],t},Qc.subtract=ih,Qc.multiply=ah,Qc.divide=sh,Qc.ceil=function(t,e){return t[0]=Math.ceil(e[0]),t[1]=Math.ceil(e[1]),t},Qc.floor=function(t,e){return t[0]=Math.floor(e[0]),t[1]=Math.floor(e[1]),t},Qc.min=function(t,e,r){return t[0]=Math.min(e[0],r[0]),t[1]=Math.min(e[1],r[1]),t},Qc.max=function(t,e,r){return t[0]=Math.max(e[0],r[0]),t[1]=Math.max(e[1],r[1]),t},Qc.round=function(t,e){return t[0]=Math.round(e[0]),t[1]=Math.round(e[1]),t},Qc.scale=function(t,e,r){return t[0]=e[0]*r,t[1]=e[1]*r,t},Qc.scaleAndAdd=function(t,e,r,n){return t[0]=e[0]+r[0]*n,t[1]=e[1]+r[1]*n,t},Qc.distance=oh,Qc.squaredDistance=lh,Qc.length=uh,Qc.squaredLength=ch,Qc.negate=function(t,e){return t[0]=-e[0],t[1]=-e[1],t},Qc.inverse=function(t,e){return t[0]=1/e[0],t[1]=1/e[1],t},Qc.normalize=function(t,e){var r=e[0],n=e[1],i=r*r+n*n;return i>0&&(i=1/Math.sqrt(i)),t[0]=e[0]*i,t[1]=e[1]*i,t},Qc.dot=function(t,e){return t[0]*e[0]+t[1]*e[1]},Qc.cross=function(t,e,r){var n=e[0]*r[1]-e[1]*r[0];return t[0]=t[1]=0,t[2]=n,t},Qc.lerp=function(t,e,r,n){var i=e[0],a=e[1];return t[0]=i+n*(r[0]-i),t[1]=a+n*(r[1]-a),t},Qc.random=function(t,e){e=e||1;var r=2*eh.RANDOM()*Math.PI;return t[0]=Math.cos(r)*e,t[1]=Math.sin(r)*e,t},Qc.transformMat2=function(t,e,r){var n=e[0],i=e[1];return t[0]=r[0]*n+r[2]*i,t[1]=r[1]*n+r[3]*i,t},Qc.transformMat2d=function(t,e,r){var n=e[0],i=e[1];return t[0]=r[0]*n+r[2]*i+r[4],t[1]=r[1]*n+r[3]*i+r[5],t},Qc.transformMat3=function(t,e,r){var n=e[0],i=e[1];return t[0]=r[0]*n+r[3]*i+r[6],t[1]=r[1]*n+r[4]*i+r[7],t},Qc.transformMat4=function(t,e,r){var n=e[0],i=e[1];return t[0]=r[0]*n+r[4]*i+r[12],t[1]=r[1]*n+r[5]*i+r[13],t},Qc.rotate=function(t,e,r,n){var i=e[0]-r[0],a=e[1]-r[1],s=Math.sin(n),o=Math.cos(n);return t[0]=i*o-a*s+r[0],t[1]=i*s+a*o+r[1],t},Qc.angle=function(t,e){var r=t[0],n=t[1],i=e[0],a=e[1],s=Math.sqrt(r*r+n*n)*Math.sqrt(i*i+a*a);return Math.acos(Math.min(Math.max(s&&(r*i+n*a)/s,-1),1))},Qc.zero=function(t){return t[0]=0,t[1]=0,t},Qc.str=function(t){return "vec2("+t[0]+", "+t[1]+")"},Qc.exactEquals=function(t,e){return t[0]===e[0]&&t[1]===e[1]},Qc.equals=function(t,e){var r=t[0],n=t[1],i=e[0],a=e[1];return Math.abs(r-i)<=eh.EPSILON*Math.max(1,Math.abs(r),Math.abs(i))&&Math.abs(n-a)<=eh.EPSILON*Math.max(1,Math.abs(n),Math.abs(a))},Qc.forEach=Qc.sqrLen=Qc.sqrDist=Qc.dist=Qc.div=Qc.mul=Qc.sub=Qc.len=void 0;var eh=function(t,e){if(t&&t.__esModule)return t;if(null===t||"object"!==th(t)&&"function"!=typeof t)return {default:t};var r=rh(void 0);if(r&&r.has(t))return r.get(t);var n={},i=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var a in t)if("default"!==a&&Object.prototype.hasOwnProperty.call(t,a)){var s=i?Object.getOwnPropertyDescriptor(t,a):null;s&&(s.get||s.set)?Object.defineProperty(n,a,s):n[a]=t[a];}return n.default=t,r&&r.set(t,n),n}(nu);function rh(t){if("function"!=typeof WeakMap)return null;var e=new WeakMap,r=new WeakMap;return (rh=function(t){return t?r:e})(t)}function nh(){var t=new eh.ARRAY_TYPE(2);return eh.ARRAY_TYPE!=Float32Array&&(t[0]=0,t[1]=0),t}function ih(t,e,r){return t[0]=e[0]-r[0],t[1]=e[1]-r[1],t}function ah(t,e,r){return t[0]=e[0]*r[0],t[1]=e[1]*r[1],t}function sh(t,e,r){return t[0]=e[0]/r[0],t[1]=e[1]/r[1],t}function oh(t,e){return Math.hypot(e[0]-t[0],e[1]-t[1])}function lh(t,e){var r=e[0]-t[0],n=e[1]-t[1];return r*r+n*n}function uh(t){return Math.hypot(t[0],t[1])}function ch(t){var e=t[0],r=t[1];return e*e+r*r}Qc.len=uh,Qc.sub=ih,Qc.mul=ah,Qc.div=sh,Qc.dist=oh,Qc.sqrDist=lh,Qc.sqrLen=ch;var hh=function(){var t=nh();return function(e,r,n,i,a,s){var o,l;for(r||(r=2),n||(n=0),l=i?Math.min(i*r+n,e.length):e.length,o=n;o<l;o+=r)t[0]=e[o],t[1]=e[o+1],a(t,t,s),e[o]=t[0],e[o+1]=t[1];return e}}();function ph(t){return ph="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t},ph(t)}Qc.forEach=hh,Object.defineProperty(ru,"__esModule",{value:!0}),t.a7=ru.vec4=t.N=ru.vec3=ru.vec2=ru.quat2=t.bi=ru.quat=t.a6=ru.mat4=t.co=ru.mat3=ru.mat2d=t.b4=ru.mat2=ru.glMatrix=void 0;var fh=Ah(nu);ru.glMatrix=fh;var dh=Ah(lu);t.b4=ru.mat2=dh;var mh=Ah(du);ru.mat2d=mh;var yh=Ah(bu);t.co=ru.mat3=yh;var gh=Ah(Iu);t.a6=ru.mat4=gh;var xh=Ah(Lu);t.bi=ru.quat=xh;var vh=Ah(Oc);ru.quat2=vh;var bh=Ah(Qc);ru.vec2=bh;var _h=Ah(Fu);t.N=ru.vec3=_h;var wh=Ah(Qu);function Mh(t){if("function"!=typeof WeakMap)return null;var e=new WeakMap,r=new WeakMap;return (Mh=function(t){return t?r:e})(t)}function Ah(t,e){if(!e&&t&&t.__esModule)return t;if(null===t||"object"!==ph(t)&&"function"!=typeof t)return {default:t};var r=Mh(e);if(r&&r.has(t))return r.get(t);var n={},i=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var a in t)if("default"!==a&&Object.prototype.hasOwnProperty.call(t,a)){var s=i?Object.getOwnPropertyDescriptor(t,a):null;s&&(s.get||s.set)?Object.defineProperty(n,a,s):n[a]=t[a];}return n.default=t,r&&r.set(t,n),n}t.a7=ru.vec4=wh;class Sh{constructor(t,e){this.pos=t,this.dir=e;}intersectsPlane(e,r,n){const i=t.N.dot(r,this.dir);if(Math.abs(i)<1e-6)return !1;const a=((e[0]-this.pos[0])*r[0]+(e[1]-this.pos[1])*r[1]+(e[2]-this.pos[2])*r[2])/i;return n[0]=this.pos[0]+this.dir[0]*a,n[1]=this.pos[1]+this.dir[1]*a,n[2]=this.pos[2]+this.dir[2]*a,!0}closestPointOnSphere(e,r,n){if(t.N.equals(this.pos,e)||0===r)return n[0]=n[1]=n[2]=0,!1;const[i,a,s]=this.dir,o=this.pos[0]-e[0],l=this.pos[1]-e[1],u=this.pos[2]-e[2],c=i*i+a*a+s*s,h=2*(o*i+l*a+u*s),p=h*h-4*c*(o*o+l*l+u*u-r*r);if(p<0){const t=Math.max(-h/2,0),e=o+i*t,c=l+a*t,p=u+s*t,f=Math.hypot(e,c,p);return n[0]=e*r/f,n[1]=c*r/f,n[2]=p*r/f,!1}{const t=(-h-Math.sqrt(p))/(2*c);if(t<0){const t=Math.hypot(o,l,u);return n[0]=o*r/t,n[1]=l*r/t,n[2]=u*r/t,!1}return n[0]=o+i*t,n[1]=l+a*t,n[2]=u+s*t,!0}}}class Ih{constructor(t,e,r,n,i){this.TL=t,this.TR=e,this.BR=r,this.BL=n,this.horizon=i;}static fromInvProjectionMatrix(e,r,n){const i=[-1,1,1],a=[1,1,1],s=[1,-1,1],o=[-1,-1,1],l=t.N.transformMat4(i,i,e),u=t.N.transformMat4(a,a,e),c=t.N.transformMat4(s,s,e),h=t.N.transformMat4(o,o,e);return new Ih(l,u,c,h,r/n)}}function kh(e,r,n){let i=1/0,a=-1/0;const s=[];for(const o of e){t.N.sub(s,o,r);const e=t.N.dot(s,n);i=Math.min(i,e),a=Math.max(a,e);}return [i,a]}function Ph(e,r){let n=!0;for(let i=0;i<e.planes.length;i++){const a=e.planes[i];let s=0;for(let e=0;e<r.length;e++)s+=t.N.dot(a,r[e])+a[3]>=0;if(0===s)return 0;s!==r.length&&(n=!1);}return n?2:1}function Eh(t,e){for(const r of t.projections){const n=kh(e,t.points[0],r.axis);if(r.projection[1]<n[0]||r.projection[0]>n[1])return 0}return 1}function zh(e,r){let n=0;const i=[0,0,0,0];for(let a=0;a<e.length;a++)i[0]=e[a][0],i[1]=e[a][1],i[2]=e[a][2],i[3]=1,t.a7.dot(i,r)>=0&&n++;return n}class Th{constructor(e,r){this.points=e||new Array(8).fill([0,0,0]),this.planes=r||new Array(6).fill([0,0,0,0]),this.bounds=Bh.fromPoints(this.points),this.projections=[],this.frustumEdges=[t.N.sub([],this.points[2],this.points[3]),t.N.sub([],this.points[0],this.points[3]),t.N.sub([],this.points[4],this.points[0]),t.N.sub([],this.points[5],this.points[1]),t.N.sub([],this.points[6],this.points[2]),t.N.sub([],this.points[7],this.points[3])];for(const t of this.frustumEdges){const e=[0,-t[2],t[1]],r=[t[2],0,-t[0]];this.projections.push({axis:e,projection:kh(this.points,this.points[0],e)}),this.projections.push({axis:r,projection:kh(this.points,this.points[0],r)});}}static fromInvProjectionMatrix(e,r,n,i){const a=Math.pow(2,n),s=[[-1,1,-1,1],[1,1,-1,1],[1,-1,-1,1],[-1,-1,-1,1],[-1,1,1,1],[1,1,1,1],[1,-1,1,1],[-1,-1,1,1]].map((n=>{const s=t.a7.transformMat4([],n,e),o=1/s[3]/r*a;return t.a7.mul(s,s,[o,o,i?1/s[3]:o,o])})),o=[[0,1,2],[6,5,4],[0,3,7],[2,1,5],[3,2,6],[0,4,5]].map((e=>{const r=t.N.sub([],s[e[0]],s[e[1]]),n=t.N.sub([],s[e[2]],s[e[1]]),i=t.N.normalize([],t.N.cross([],r,n)),a=-t.N.dot(i,s[e[1]]);return i.concat(a)})),l=[];for(let t=0;t<s.length;t++)l.push([s[t][0],s[t][1],s[t][2]]);return new Th(l,o)}intersectsPrecise(e,r,n){for(let t=0;t<r.length;t++)if(!zh(e,r[t]))return 0;for(let t=0;t<this.planes.length;t++)if(!zh(e,this.planes[t]))return 0;for(const r of n)for(const n of this.frustumEdges){const i=t.N.cross([],r,n),a=t.N.length(i);if(0===a)continue;t.N.scale(i,i,1/a);const s=kh(this.points,this.points[0],i),o=kh(e,this.points[0],i);if(s[0]>o[1]||o[0]>s[1])return 0}return 1}}class Bh{static fromPoints(e){const r=[1/0,1/0,1/0],n=[-1/0,-1/0,-1/0];for(const i of e)t.N.min(r,r,i),t.N.max(n,n,i);return new Bh(r,n)}static fromTileIdAndHeight(t,e,r){const n=1<<t.canonical.z,i=t.canonical.x,a=t.canonical.y;return new Bh([i/n,a/n,e],[(i+1)/n,(a+1)/n,r])}static applyTransform(e,r){const n=e.getCorners();for(let e=0;e<n.length;++e)t.N.transformMat4(n[e],n[e],r);return Bh.fromPoints(n)}static projectAabbCorners(e,r){const n=e.getCorners();for(let e=0;e<n.length;++e)t.N.transformMat4(n[e],n[e],r);return n}constructor(e,r){this.min=e,this.max=r,this.center=t.N.scale([],t.N.add([],this.min,this.max),.5);}quadrant(e){const r=[e%2==0,e<2],n=t.N.clone(this.min),i=t.N.clone(this.max);for(let t=0;t<r.length;t++)n[t]=r[t]?this.min[t]:this.center[t],i[t]=r[t]?this.center[t]:this.max[t];return i[2]=this.max[2],new Bh(n,i)}distanceX(t){return Math.max(Math.min(this.max[0],t[0]),this.min[0])-t[0]}distanceY(t){return Math.max(Math.min(this.max[1],t[1]),this.min[1])-t[1]}distanceZ(t){return Math.max(Math.min(this.max[2],t[2]),this.min[2])-t[2]}getCorners(){const t=this.min,e=this.max;return [[t[0],t[1],t[2]],[e[0],t[1],t[2]],[e[0],e[1],t[2]],[t[0],e[1],t[2]],[t[0],t[1],e[2]],[e[0],t[1],e[2]],[e[0],e[1],e[2]],[t[0],e[1],e[2]]]}intersects(t){return this.intersectsAabb(t.bounds)?Ph(t,this.getCorners()):0}intersectsFlat(t){return this.intersectsAabb(t.bounds)?Ph(t,[[this.min[0],this.min[1],0],[this.max[0],this.min[1],0],[this.max[0],this.max[1],0],[this.min[0],this.max[1],0]]):0}intersectsPrecise(t,e){return e||this.intersects(t)?Eh(t,this.getCorners()):0}intersectsPreciseFlat(t,e){return e||this.intersectsFlat(t)?Eh(t,[[this.min[0],this.min[1],0],[this.max[0],this.min[1],0],[this.max[0],this.max[1],0],[this.min[0],this.max[1],0]]):0}intersectsAabb(t){for(let e=0;e<3;++e)if(this.min[e]>t.max[e]||t.min[e]>this.max[e])return !1;return !0}intersectsAabbXY(t){return !(this.min[0]>t.max[0]||t.min[0]>this.max[0]||this.min[1]>t.max[1]||t.min[1]>this.max[1])}encapsulate(t){for(let e=0;e<3;e++)this.min[e]=Math.min(this.min[e],t.min[e]),this.max[e]=Math.max(this.max[e],t.max[e]);}encapsulatePoint(t){for(let e=0;e<3;e++)this.min[e]=Math.min(this.min[e],t[e]),this.max[e]=Math.max(this.max[e],t[e]);}closestPoint(t){return [Math.max(Math.min(this.max[0],t[0]),this.min[0]),Math.max(Math.min(this.max[1],t[1]),this.min[1]),Math.max(Math.min(this.max[2],t[2]),this.min[2])]}}ra(Bh,"Aabb");const Ch=cs([{type:"Float32",name:"a_globe_pos",components:3},{type:"Float32",name:"a_uv",components:2}]),{members:Rh}=Ch,Dh=cs([{name:"a_pos_3",components:3,type:"Int16"}]);var Vh=cs([{name:"a_pos",type:"Int16",components:2}]);function Lh(t){return t*jo/Jo}const Fh=[new Bh([Zo,Zo,Zo],[Ko,Ko,Ko]),new Bh([Zo,Zo,Zo],[0,0,Ko]),new Bh([0,Zo,Zo],[Ko,0,Ko]),new Bh([Zo,0,Zo],[0,Ko,Ko]),new Bh([0,0,Zo],[Ko,Ko,Ko])];function Nh(e,r,n,i=!0){const a=t.N.scale([],e._camera.position,e.worldSize),s=[r,n,1,1];t.a7.transformMat4(s,s,e.pixelMatrixInverse),t.a7.scale(s,s,1/s[3]);const o=t.N.sub([],s,a),l=t.N.normalize([],o),u=e.globeMatrix,c=[u[12],u[13],u[14]],h=t.N.sub([],c,a),p=t.N.length(h),f=t.N.normalize([],h),d=e.worldSize/(2*Math.PI),m=t.N.dot(f,l),y=Math.asin(d/p);if(y<Math.acos(m)){if(!i)return null;const e=[],r=[];t.N.scale(e,l,p/m),t.N.normalize(r,t.N.sub(r,e,h)),t.N.normalize(l,t.N.add(l,h,t.N.scale(l,r,Math.tan(y)*p)));}const g=[];new Sh(a,l).closestPointOnSphere(c,d,g);const x=t.N.normalize([],rt(u,0)),v=t.N.normalize([],rt(u,1)),b=t.N.normalize([],rt(u,2)),w=t.N.dot(x,g),M=t.N.dot(v,g),A=t.N.dot(b,g),S=_(Math.asin(-M/d));let k=_(Math.atan2(w,A));k=e.center.lng+function(t,e){const r=(e-t+180)%360-180;return r<-180?r+360:r}(e.center.lng,k);const P=pl(k),E=I(fl(S),0,1);return new Ml(P,E)}class Oh{constructor(e,r,n){this.a=t.N.sub([],e,n),this.b=t.N.sub([],r,n),this.center=n;const i=t.N.normalize([],this.a),a=t.N.normalize([],this.b);this.angle=Math.acos(t.N.dot(i,a));}}function Uh(t,e){if(0===t.angle)return null;let r;return r=0===t.a[e]?1/t.angle*.5*Math.PI:1/t.angle*Math.atan(t.b[e]/t.a[e]/Math.sin(t.angle)-1/Math.tan(t.angle)),r<0||r>1?null:function(t,e,r,n){const i=Math.sin(r);return t*(Math.sin((1-n)*r)/i)+e*(Math.sin(n*r)/i)}(t.a[e],t.b[e],t.angle,I(r,0,1))+t.center[e]}function jh(t){if(t.z<=1)return Fh[t.z+2*t.y+t.x];const e=Xh(Yh(t));return Bh.fromPoints(e)}function qh(e,r,n){return t.N.scale(e,e,1-n),t.N.scaleAndAdd(e,e,r,n)}function $h(e,r,n){for(const i of e)t.N.transformMat4(i,i,r),t.N.scale(i,i,n);}function Gh(e,r,n,i){const a=r/e.worldSize,s=e.globeMatrix;if(n.z<=1){const t=jh(n).getCorners();return $h(t,s,a),Bh.fromPoints(t)}const o=Yh(n,i),l=Xh(o,jo+Lh(e._tileCoverLift));$h(l,s,a);const u=Number.MAX_VALUE,c=[-u,-u,-u],h=[u,u,u];if(o.contains(e.center)){for(const e of l)t.N.min(h,h,e),t.N.max(c,c,e);c[2]=0;const r=e.point,n=[r.x*a,r.y*a,0];return t.N.min(h,h,n),t.N.max(c,c,n),new Bh(h,c)}if(e._tileCoverLift>0){for(const e of l)t.N.min(h,h,e),t.N.max(c,c,e);return new Bh(h,c)}const p=[s[12]*a,s[13]*a,s[14]*a],f=o.getCenter(),d=I(e.center.lat,-xl,xl),m=I(f.lat,-xl,xl),y=pl(e.center.lng),g=fl(d);let x=y-pl(f.lng);const v=g-fl(m);x>.5?x-=1:x<-.5&&(x+=1);let _=0;if(Math.abs(x)>Math.abs(v))_=x>=0?1:3;else {_=v>=0?0:2;const e=[s[4]*a,s[5]*a,s[6]*a],r=-Math.sin(b(v>=0?o.getSouth():o.getNorth()))*jo;t.N.scaleAndAdd(p,p,e,r);}const w=l[_],M=l[(_+1)%4],A=new Oh(w,M,p),S=[Uh(A,0)||w[0],Uh(A,1)||w[1],Uh(A,2)||w[2]],k=rp(e.zoom);if(k>0){const i=function({x:t,y:e,z:r},n,i,a,s){const o=1/(1<<r);let l=t*o,u=l+o,c=e*o,h=c+o,p=0;const f=(l+u)/2-a;return f>.5?p=-1:f<-.5&&(p=1),l=((l+p)*n-(a*=n))*i+a,u=((u+p)*n-a)*i+a,c=(c*n-(s*=n))*i+s,h=(h*n-s)*i+s,[[l,h,0],[u,h,0],[u,c,0],[l,c,0]]}(n,r,e._pixelsPerMercatorPixel,y,g);for(let t=0;t<l.length;t++)qh(l[t],i[t],k);const a=t.N.add([],i[_],i[(_+1)%4]);t.N.scale(a,a,.5),qh(S,a,k);}for(const e of l)t.N.min(h,h,e),t.N.max(c,c,e);return h[2]=Math.min(w[2],M[2]),t.N.min(h,h,S),t.N.max(c,c,S),new Bh(h,c)}function Yh({x:t,y:e,z:r},n=!1){const i=1/(1<<r),a=new tl(ml(t*i),e===(1<<r)-1&&n?-90:yl((e+1)*i)),s=new tl(ml((t+1)*i),0===e&&n?90:yl(e*i));return new el(a,s)}function Xh(t,e=jo){const r=b(t.getNorth()),n=b(t.getSouth()),i=Math.cos(r),a=Math.cos(n),s=Math.sin(r),o=Math.sin(n),l=t.getWest(),u=t.getEast();return [Ho(a,o,l,e),Ho(a,o,u,e),Ho(i,s,u,e),Ho(i,s,l,e)]}function Zh(t,e,r,n){const i=1<<r.z,a=(t/Tr+r.x)/i;return Wo(yl((e/Tr+r.y)/i),ml(a),n)}function Kh({min:t,max:e}){return Go/Math.max(e[0]-t[0],e[1]-t[1],e[2]-t[2])}const Hh=new Float64Array(16);function Wh(e){const r=Kh(e),n=t.a6.fromScaling(Hh,[r,r,r]);return t.a6.translate(n,n,t.N.negate([],e.min))}function Jh(e){const r=t.a6.fromTranslation(Hh,e.min),n=1/Kh(e);return t.a6.scale(r,r,[n,n,n])}function Qh(t){const e=Tr/(2*Math.PI);return t/(2*Math.PI)/e}function tp(t,e){return Tr/(512*Math.pow(2,t))*Kh(jh(e))}function ep(e,r,n,i,a){const s=Qh(n),o=[e,r,-n/(2*Math.PI)],l=t.a6.identity(new Float64Array(16));return t.a6.translate(l,l,o),t.a6.scale(l,l,[s,s,s]),t.a6.rotateX(l,l,b(-a)),t.a6.rotateY(l,l,b(-i)),l}function rp(t){return k(qo,$o,t)}function np(e,r){const n=Wo(r.lat,r.lng),i=function(e){const r=Wo(e._center.lat,e._center.lng),n=t.N.fromValues(0,1,0);let i=t.N.cross([],n,r);const a=t.a6.fromRotation([],-e.angle,r);i=t.N.transformMat4(i,i,a),t.a6.fromRotation(a,-e._pitch,i);const s=t.N.normalize([],r);return t.N.scale(s,s,Lh(e.cameraToCenterDistance/e.pixelsPerMeter)),t.N.transformMat4(s,s,a),t.N.add([],r,s)}(e),a=t.N.subtract([],i,n);return t.N.angle(a,n)}function ip(t,e){return np(t,e)>Math.PI/2*1.01}const ap=b(85),sp=Math.cos(ap),op=Math.sin(ap),lp=t.a6.create(),up=t=>{const e=[];return "map"===t.paint.get("circle-pitch-alignment")&&e.push("PITCH_WITH_MAP"),"map"===t.paint.get("circle-pitch-scale")&&e.push("SCALE_WITH_MAP"),e};function cp(e,r,n,i,a,s,o,l,u){if(s&&e.queryGeometry.isAboveHorizon)return !1;s&&(u*=e.pixelToTileUnitsFactor);const c=e.tileID.canonical,h=n.projection.upVectorScale(c,n.center.lat,n.worldSize).metersToTile;for(const p of r)for(const r of p){const p=r.add(l),f=a&&n.elevation?n.elevation.exaggeration()*a.getElevationAt(p.x,p.y,!0):0,d=n.projection.projectTilePoint(p.x,p.y,c);if(f>0){const t=n.projection.upVector(c,p.x,p.y);d.x+=t[0]*h*f,d.y+=t[1]*h*f,d.z+=t[2]*h*f;}const m=s?p:hp(d.x,d.y,d.z,i),y=s?e.tilespaceRays.map((t=>dp(t,f))):e.queryGeometry.screenGeometry,g=t.a7.transformMat4([],[d.x,d.y,d.z,1],i);if(!o&&s?u*=g[3]/n.cameraToCenterDistance:o&&!s&&(u*=n.cameraToCenterDistance/g[3]),s){const t=yl((r.y/Tr+c.y)/(1<<c.z));u/=n.projection.pixelsPerMeter(t,1)/dl(1,t);}if(Ll(y,m,u))return !0}return !1}function hp(e,r,n,i){const a=t.a7.transformMat4([],[e,r,n,1],i);return new g(a[0]/a[3],a[1]/a[3])}const pp=t.N.fromValues(0,0,0),fp=t.N.fromValues(0,0,1);function dp(e,r){const n=t.N.create();return pp[2]=r,e.intersectsPlane(pp,fp,n),new g(n[0],n[1])}class mp extends Dl{}function yp(t,{width:e,height:r},n,i){if(i){if(i instanceof Uint8ClampedArray)i=new Uint8Array(i.buffer);else if(i.length!==e*r*n)throw new RangeError("mismatched image size")}else i=new Uint8Array(e*r*n);return t.width=e,t.height=r,t.data=i,t}function gp(t,e,r){const{width:n,height:i}=e;n===t.width&&i===t.height||(xp(t,e,{x:0,y:0},{x:0,y:0},{width:Math.min(t.width,n),height:Math.min(t.height,i)},r),t.width=n,t.height=i,t.data=e.data);}function xp(t,e,r,n,i,a,s){if(0===i.width||0===i.height)return e;if(i.width>t.width||i.height>t.height||r.x>t.width-i.width||r.y>t.height-i.height)throw new RangeError("out of range source coordinates for image copy");if(i.width>e.width||i.height>e.height||n.x>e.width-i.width||n.y>e.height-i.height)throw new RangeError("out of range destination coordinates for image copy");const o=t.data,l=e.data,u=4===a&&s;for(let s=0;s<i.height;s++){const c=((r.y+s)*t.width+r.x)*a,h=((n.y+s)*e.width+n.x)*a;if(u)for(let t=0;t<i.width;t++){const e=c+t*a+3,r=h+t*a;l[r+0]=255,l[r+1]=255,l[r+2]=255,l[r+3]=o[e];}else for(let t=0;t<i.width*a;t++)l[h+t]=o[c+t];}return e}ra(mp,"HeatmapBucket",{omit:["layers"]});class vp{constructor(t,e){yp(this,t,1,e);}resize(t){gp(this,new vp(t),1);}clone(){return new vp({width:this.width,height:this.height},new Uint8Array(this.data))}static copy(t,e,r,n,i){xp(t,e,r,n,i,1);}}class bp{constructor(t,e){yp(this,t,4,e);}resize(t){gp(this,new bp(t),4);}replace(t,e){e?this.data.set(t):this.data=t instanceof Uint8ClampedArray?new Uint8Array(t.buffer):t;}clone(){return new bp({width:this.width,height:this.height},new Uint8Array(this.data))}static copy(t,e,r,n,i,a){xp(t,e,r,n,i,4,a);}}class _p{constructor(t,e){this.width=t.width,this.height=t.height,this.data=e instanceof Uint8Array?new Float32Array(e.buffer):e;}}ra(vp,"AlphaImage"),ra(bp,"RGBAImage");const wp=new Oa({visibility:new La(qa.layout_heatmap.visibility)});var Mp={paint:new Oa({"heatmap-radius":new Fa(qa.paint_heatmap["heatmap-radius"]),"heatmap-weight":new Fa(qa.paint_heatmap["heatmap-weight"]),"heatmap-intensity":new La(qa.paint_heatmap["heatmap-intensity"]),"heatmap-color":new Na(qa.paint_heatmap["heatmap-color"]),"heatmap-opacity":new La(qa.paint_heatmap["heatmap-opacity"])}),layout:wp};function Ap(t){const e={},r=t.resolution||256,n=t.clips?t.clips.length:1,i=t.image||new bp({width:r,height:n}),a=(r,n,a)=>{e[t.evaluationKey]=a;const s=t.expression.evaluate(e);s&&(i.data[r+n+0]=Math.floor(255*s.r/s.a),i.data[r+n+1]=Math.floor(255*s.g/s.a),i.data[r+n+2]=Math.floor(255*s.b/s.a),i.data[r+n+3]=Math.floor(255*s.a));};if(t.clips)for(let e=0,i=0;e<n;++e,i+=4*r)for(let n=0,s=0;n<r;n++,s+=4){const o=n/(r-1),{start:l,end:u}=t.clips[e];a(i,s,l*(1-o)+u*o);}else for(let t=0,e=0;t<r;t++,e+=4)a(0,e,t/(r-1));return i}const Sp=new Oa({visibility:new La(qa.layout_hillshade.visibility)});var Ip={paint:new Oa({"hillshade-illumination-direction":new La(qa.paint_hillshade["hillshade-illumination-direction"]),"hillshade-illumination-anchor":new La(qa.paint_hillshade["hillshade-illumination-anchor"]),"hillshade-exaggeration":new La(qa.paint_hillshade["hillshade-exaggeration"]),"hillshade-shadow-color":new La(qa.paint_hillshade["hillshade-shadow-color"]),"hillshade-highlight-color":new La(qa.paint_hillshade["hillshade-highlight-color"]),"hillshade-accent-color":new La(qa.paint_hillshade["hillshade-accent-color"]),"hillshade-emissive-strength":new La(qa.paint_hillshade["hillshade-emissive-strength"])}),layout:Sp};const kp=cs([{name:"a_pos",components:2,type:"Int16"}],4),{members:Pp}=kp;var Ep={exports:{}};function zp(t,e,r){r=r||2;var n,i,a,s,o,l,u,c=e&&e.length,h=c?e[0]*r:t.length,p=Tp(t,0,h,r,!0),f=[];if(!p||p.next===p.prev)return f;if(c&&(p=function(t,e,r,n){var i,a,s,o=[];for(i=0,a=e.length;i<a;i++)(s=Tp(t,e[i]*n,i<a-1?e[i+1]*n:t.length,n,!1))===s.next&&(s.steiner=!0),o.push(jp(s));for(o.sort(Fp),i=0;i<o.length;i++)r=Np(o[i],r);return r}(t,e,p,r)),t.length>80*r){n=a=t[0],i=s=t[1];for(var d=r;d<h;d+=r)(o=t[d])<n&&(n=o),(l=t[d+1])<i&&(i=l),o>a&&(a=o),l>s&&(s=l);u=0!==(u=Math.max(a-n,s-i))?32767/u:0;}return Cp(p,f,r,n,i,u,0),f}function Tp(t,e,r,n,i){var a,s;if(i===ef(t,e,r,n)>0)for(a=e;a<r;a+=n)s=Jp(a,t[a],t[a+1],s);else for(a=r-n;a>=e;a-=n)s=Jp(a,t[a],t[a+1],s);return s&&Yp(s,s.next)&&(Qp(s),s=s.next),s}function Bp(t,e){if(!t)return t;e||(e=t);var r,n=t;do{if(r=!1,n.steiner||!Yp(n,n.next)&&0!==Gp(n.prev,n,n.next))n=n.next;else {if(Qp(n),(n=e=n.prev)===n.next)break;r=!0;}}while(r||n!==e);return e}function Cp(t,e,r,n,i,a,s){if(t){!s&&a&&function(t,e,r,n){var i=t;do{0===i.z&&(i.z=Up(i.x,i.y,e,r,n)),i.prevZ=i.prev,i.nextZ=i.next,i=i.next;}while(i!==t);i.prevZ.nextZ=null,i.prevZ=null,function(t){var e,r,n,i,a,s,o,l,u=1;do{for(r=t,t=null,a=null,s=0;r;){for(s++,n=r,o=0,e=0;e<u&&(o++,n=n.nextZ);e++);for(l=u;o>0||l>0&&n;)0!==o&&(0===l||!n||r.z<=n.z)?(i=r,r=r.nextZ,o--):(i=n,n=n.nextZ,l--),a?a.nextZ=i:t=i,i.prevZ=a,a=i;r=n;}a.nextZ=null,u*=2;}while(s>1)}(i);}(t,n,i,a);for(var o,l,u=t;t.prev!==t.next;)if(o=t.prev,l=t.next,a?Dp(t,n,i,a):Rp(t))e.push(o.i/r|0),e.push(t.i/r|0),e.push(l.i/r|0),Qp(t),t=l.next,u=l.next;else if((t=l)===u){s?1===s?Cp(t=Vp(Bp(t),e,r),e,r,n,i,a,2):2===s&&Lp(t,e,r,n,i,a):Cp(Bp(t),e,r,n,i,a,1);break}}}function Rp(t){var e=t.prev,r=t,n=t.next;if(Gp(e,r,n)>=0)return !1;for(var i=e.x,a=r.x,s=n.x,o=e.y,l=r.y,u=n.y,c=i<a?i<s?i:s:a<s?a:s,h=o<l?o<u?o:u:l<u?l:u,p=i>a?i>s?i:s:a>s?a:s,f=o>l?o>u?o:u:l>u?l:u,d=n.next;d!==e;){if(d.x>=c&&d.x<=p&&d.y>=h&&d.y<=f&&qp(i,o,a,l,s,u,d.x,d.y)&&Gp(d.prev,d,d.next)>=0)return !1;d=d.next;}return !0}function Dp(t,e,r,n){var i=t.prev,a=t,s=t.next;if(Gp(i,a,s)>=0)return !1;for(var o=i.x,l=a.x,u=s.x,c=i.y,h=a.y,p=s.y,f=o<l?o<u?o:u:l<u?l:u,d=c<h?c<p?c:p:h<p?h:p,m=o>l?o>u?o:u:l>u?l:u,y=c>h?c>p?c:p:h>p?h:p,g=Up(f,d,e,r,n),x=Up(m,y,e,r,n),v=t.prevZ,b=t.nextZ;v&&v.z>=g&&b&&b.z<=x;){if(v.x>=f&&v.x<=m&&v.y>=d&&v.y<=y&&v!==i&&v!==s&&qp(o,c,l,h,u,p,v.x,v.y)&&Gp(v.prev,v,v.next)>=0)return !1;if(v=v.prevZ,b.x>=f&&b.x<=m&&b.y>=d&&b.y<=y&&b!==i&&b!==s&&qp(o,c,l,h,u,p,b.x,b.y)&&Gp(b.prev,b,b.next)>=0)return !1;b=b.nextZ;}for(;v&&v.z>=g;){if(v.x>=f&&v.x<=m&&v.y>=d&&v.y<=y&&v!==i&&v!==s&&qp(o,c,l,h,u,p,v.x,v.y)&&Gp(v.prev,v,v.next)>=0)return !1;v=v.prevZ;}for(;b&&b.z<=x;){if(b.x>=f&&b.x<=m&&b.y>=d&&b.y<=y&&b!==i&&b!==s&&qp(o,c,l,h,u,p,b.x,b.y)&&Gp(b.prev,b,b.next)>=0)return !1;b=b.nextZ;}return !0}function Vp(t,e,r){var n=t;do{var i=n.prev,a=n.next.next;!Yp(i,a)&&Xp(i,n,n.next,a)&&Hp(i,a)&&Hp(a,i)&&(e.push(i.i/r|0),e.push(n.i/r|0),e.push(a.i/r|0),Qp(n),Qp(n.next),n=t=a),n=n.next;}while(n!==t);return Bp(n)}function Lp(t,e,r,n,i,a){var s=t;do{for(var o=s.next.next;o!==s.prev;){if(s.i!==o.i&&$p(s,o)){var l=Wp(s,o);return s=Bp(s,s.next),l=Bp(l,l.next),Cp(s,e,r,n,i,a,0),void Cp(l,e,r,n,i,a,0)}o=o.next;}s=s.next;}while(s!==t)}function Fp(t,e){return t.x-e.x}function Np(t,e){var r=function(t,e){var r,n=e,i=t.x,a=t.y,s=-1/0;do{if(a<=n.y&&a>=n.next.y&&n.next.y!==n.y){var o=n.x+(a-n.y)*(n.next.x-n.x)/(n.next.y-n.y);if(o<=i&&o>s&&(s=o,r=n.x<n.next.x?n:n.next,o===i))return r}n=n.next;}while(n!==e);if(!r)return null;var l,u=r,c=r.x,h=r.y,p=1/0;n=r;do{i>=n.x&&n.x>=c&&i!==n.x&&qp(a<h?i:s,a,c,h,a<h?s:i,a,n.x,n.y)&&(l=Math.abs(a-n.y)/(i-n.x),Hp(n,t)&&(l<p||l===p&&(n.x>r.x||n.x===r.x&&Op(r,n)))&&(r=n,p=l)),n=n.next;}while(n!==u);return r}(t,e);if(!r)return e;var n=Wp(r,t);return Bp(n,n.next),Bp(r,r.next)}function Op(t,e){return Gp(t.prev,t,e.prev)<0&&Gp(e.next,t,t.next)<0}function Up(t,e,r,n,i){return (t=1431655765&((t=858993459&((t=252645135&((t=16711935&((t=(t-r)*i|0)|t<<8))|t<<4))|t<<2))|t<<1))|(e=1431655765&((e=858993459&((e=252645135&((e=16711935&((e=(e-n)*i|0)|e<<8))|e<<4))|e<<2))|e<<1))<<1}function jp(t){var e=t,r=t;do{(e.x<r.x||e.x===r.x&&e.y<r.y)&&(r=e),e=e.next;}while(e!==t);return r}function qp(t,e,r,n,i,a,s,o){return (i-s)*(e-o)>=(t-s)*(a-o)&&(t-s)*(n-o)>=(r-s)*(e-o)&&(r-s)*(a-o)>=(i-s)*(n-o)}function $p(t,e){return t.next.i!==e.i&&t.prev.i!==e.i&&!function(t,e){var r=t;do{if(r.i!==t.i&&r.next.i!==t.i&&r.i!==e.i&&r.next.i!==e.i&&Xp(r,r.next,t,e))return !0;r=r.next;}while(r!==t);return !1}(t,e)&&(Hp(t,e)&&Hp(e,t)&&function(t,e){var r=t,n=!1,i=(t.x+e.x)/2,a=(t.y+e.y)/2;do{r.y>a!=r.next.y>a&&r.next.y!==r.y&&i<(r.next.x-r.x)*(a-r.y)/(r.next.y-r.y)+r.x&&(n=!n),r=r.next;}while(r!==t);return n}(t,e)&&(Gp(t.prev,t,e.prev)||Gp(t,e.prev,e))||Yp(t,e)&&Gp(t.prev,t,t.next)>0&&Gp(e.prev,e,e.next)>0)}function Gp(t,e,r){return (e.y-t.y)*(r.x-e.x)-(e.x-t.x)*(r.y-e.y)}function Yp(t,e){return t.x===e.x&&t.y===e.y}function Xp(t,e,r,n){var i=Kp(Gp(t,e,r)),a=Kp(Gp(t,e,n)),s=Kp(Gp(r,n,t)),o=Kp(Gp(r,n,e));return i!==a&&s!==o||!(0!==i||!Zp(t,r,e))||!(0!==a||!Zp(t,n,e))||!(0!==s||!Zp(r,t,n))||!(0!==o||!Zp(r,e,n))}function Zp(t,e,r){return e.x<=Math.max(t.x,r.x)&&e.x>=Math.min(t.x,r.x)&&e.y<=Math.max(t.y,r.y)&&e.y>=Math.min(t.y,r.y)}function Kp(t){return t>0?1:t<0?-1:0}function Hp(t,e){return Gp(t.prev,t,t.next)<0?Gp(t,e,t.next)>=0&&Gp(t,t.prev,e)>=0:Gp(t,e,t.prev)<0||Gp(t,t.next,e)<0}function Wp(t,e){var r=new tf(t.i,t.x,t.y),n=new tf(e.i,e.x,e.y),i=t.next,a=e.prev;return t.next=e,e.prev=t,r.next=i,i.prev=r,n.next=r,r.prev=n,a.next=n,n.prev=a,n}function Jp(t,e,r,n){var i=new tf(t,e,r);return n?(i.next=n.next,i.prev=n,n.next.prev=i,n.next=i):(i.prev=i,i.next=i),i}function Qp(t){t.next.prev=t.prev,t.prev.next=t.next,t.prevZ&&(t.prevZ.nextZ=t.nextZ),t.nextZ&&(t.nextZ.prevZ=t.prevZ);}function tf(t,e,r){this.i=t,this.x=e,this.y=r,this.prev=null,this.next=null,this.z=0,this.prevZ=null,this.nextZ=null,this.steiner=!1;}function ef(t,e,r,n){for(var i=0,a=e,s=r-n;a<r;a+=n)i+=(t[s]-t[a])*(t[a+1]+t[s+1]),s=a;return i}Ep.exports=zp,Ep.exports.default=zp,zp.deviation=function(t,e,r,n){var i=e&&e.length,a=Math.abs(ef(t,0,i?e[0]*r:t.length,r));if(i)for(var s=0,o=e.length;s<o;s++)a-=Math.abs(ef(t,e[s]*r,s<o-1?e[s+1]*r:t.length,r));var l=0;for(s=0;s<n.length;s+=3){var u=n[s]*r,c=n[s+1]*r,h=n[s+2]*r;l+=Math.abs((t[u]-t[h])*(t[c+1]-t[u+1])-(t[u]-t[c])*(t[h+1]-t[u+1]));}return 0===a&&0===l?0:Math.abs((l-a)/a)},zp.flatten=function(t){for(var e=t[0][0].length,r={vertices:[],holes:[],dimensions:e},n=0,i=0;i<t.length;i++){for(var a=0;a<t[i].length;a++)for(var s=0;s<e;s++)r.vertices.push(t[i][a][s]);i>0&&r.holes.push(n+=t[i-1].length);}return r};var rf=h(Ep.exports);function nf(t,e){const r=t.length;if(r<=1)return [t];const n=[];let i,a;for(let e=0;e<r;e++){const r=$(t[e]);0!==r&&(t[e].area=Math.abs(r),void 0===a&&(a=r<0),a===r<0?(i&&n.push(i),i=[t[e]]):i.push(t[e]));}if(i&&n.push(i),e>1)for(let t=0;t<n.length;t++)n[t].length<=e||(sr(n[t],e,1,n[t].length-1,af),n[t]=n[t].slice(0,e));return n}function af(t,e){return e.area-t.area}function sf(t,e,r){const n=r.patternDependencies;let i=!1;for(const r of e){const e=r.paint.get(`${t}-pattern`);e.isConstant()||(i=!0);const a=e.constantOr(null);a&&(i=!0,n[a]=!0);}return i}function of(t,e,r,n,i){const a=i.patternDependencies;for(const s of e){const e=s.paint.get(`${t}-pattern`).value;if("constant"!==e.kind){let t=e.evaluate({zoom:n},r,{},i.availableImages);t=t&&t.name?t.name:t,a[t]=!0,r.patterns[s.id]=t;}}return r}class lf{constructor(t){this.zoom=t.zoom,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.fqid)),this.index=t.index,this.hasPattern=!1,this.patternFeatures=[],this.layoutVertexArray=new ps,this.indexArray=new Es,this.indexArray2=new As,this.programConfigurations=new Vo(t.layers,t.zoom),this.segments=new eo,this.segments2=new eo,this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id)),this.projection=t.projection;}populate(t,e,r,n){this.hasPattern=sf("fill",this.layers,e);const i=this.layers[0].layout.get("fill-sort-key"),a=[];for(const{feature:s,id:o,index:l,sourceLayerIndex:u}of t){const t=this.layers[0]._featureFilter.needGeometry,c=Bl(s,t);if(!this.layers[0]._featureFilter.filter(new Pa(this.zoom),c,r))continue;const h=i?i.evaluate(c,{},r,e.availableImages):void 0,p={id:o,properties:s.properties,type:s.type,sourceLayerIndex:u,index:l,geometry:t?c.geometry:Tl(s,r,n),patterns:{},sortKey:h};a.push(p);}i&&a.sort(((t,e)=>t.sortKey-e.sortKey));for(const n of a){const{geometry:i,index:a,sourceLayerIndex:s}=n;if(this.hasPattern){const t=of("fill",this.layers,n,this.zoom,e);this.patternFeatures.push(t);}else this.addFeature(n,i,a,r,{},e.availableImages,e.brightness);e.featureIndex.insert(t[a].feature,i,a,s,this.index);}}update(t,e,r,n,i){const a=0!==Object.keys(t).length;a&&!this.stateDependentLayers.length||this.programConfigurations.updatePaintArrays(t,e,a?this.stateDependentLayers:this.layers,r,n,i);}addFeatures(t,e,r,n,i,a){for(const t of this.patternFeatures)this.addFeature(t,t.geometry,t.index,e,r,n,a);}isEmpty(){return 0===this.layoutVertexArray.length}uploadPending(){return !this.uploaded||this.programConfigurations.needsUpload}upload(t){this.uploaded||(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,Pp),this.indexBuffer=t.createIndexBuffer(this.indexArray),this.indexBuffer2=t.createIndexBuffer(this.indexArray2)),this.programConfigurations.upload(t),this.uploaded=!0;}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.indexBuffer2.destroy(),this.programConfigurations.destroy(),this.segments.destroy(),this.segments2.destroy());}addFeature(t,e,r,n,i,a=[],s){for(const t of nf(e,500)){let e=0;for(const r of t)e+=r.length;const r=this.segments.prepareSegment(e,this.layoutVertexArray,this.indexArray),n=r.vertexLength,i=[],a=[];for(const e of t){if(0===e.length)continue;e!==t[0]&&a.push(i.length/2);const r=this.segments2.prepareSegment(e.length,this.layoutVertexArray,this.indexArray2),n=r.vertexLength;this.layoutVertexArray.emplaceBack(e[0].x,e[0].y),this.indexArray2.emplaceBack(n+e.length-1,n),i.push(e[0].x),i.push(e[0].y);for(let t=1;t<e.length;t++)this.layoutVertexArray.emplaceBack(e[t].x,e[t].y),this.indexArray2.emplaceBack(n+t-1,n+t),i.push(e[t].x),i.push(e[t].y);r.vertexLength+=e.length,r.primitiveLength+=e.length;}const s=rf(i,a);for(let t=0;t<s.length;t+=3)this.indexArray.emplaceBack(n+s[t],n+s[t+1],n+s[t+2]);r.vertexLength+=e,r.primitiveLength+=s.length/3;}this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,r,i,a,n,s);}}ra(lf,"FillBucket",{omit:["layers","patternFeatures"]});const uf=new Oa({"fill-sort-key":new Fa(qa.layout_fill["fill-sort-key"]),visibility:new La(qa.layout_fill.visibility)});var cf={paint:new Oa({"fill-antialias":new La(qa.paint_fill["fill-antialias"]),"fill-opacity":new Fa(qa.paint_fill["fill-opacity"]),"fill-color":new Fa(qa.paint_fill["fill-color"]),"fill-outline-color":new Fa(qa.paint_fill["fill-outline-color"]),"fill-translate":new La(qa.paint_fill["fill-translate"]),"fill-translate-anchor":new La(qa.paint_fill["fill-translate-anchor"]),"fill-pattern":new Fa(qa.paint_fill["fill-pattern"]),"fill-emissive-strength":new La(qa.paint_fill["fill-emissive-strength"])}),layout:uf};const hf=cs([{name:"a_pos_normal_ed",components:4,type:"Int16"}]),pf=cs([{name:"a_pos_end",components:4,type:"Int16"},{name:"a_angular_offset_factor",components:1,type:"Int16"}]),ff=cs([{name:"a_centroid_pos",components:2,type:"Uint16"}]),df=cs([{name:"a_hidden_by_landmark",components:1,type:"Uint8"}]),mf=cs([{name:"a_pos_3",components:3,type:"Int16"},{name:"a_pos_normal_3",components:3,type:"Int16"}]),{members:yf}=hf;var gf={},xf=m,vf=bf;function bf(t,e,r,n,i){this.properties={},this.extent=r,this.type=0,this._pbf=t,this._geometry=-1,this._keys=n,this._values=i,t.readFields(_f,this,e);}function _f(t,e,r){1==t?e.id=r.readVarint():2==t?function(t,e){for(var r=t.readVarint()+t.pos;t.pos<r;){var n=e._keys[t.readVarint()],i=e._values[t.readVarint()];e.properties[n]=i;}}(r,e):3==t?e.type=r.readVarint():4==t&&(e._geometry=r.pos);}function wf(t){for(var e,r,n=0,i=0,a=t.length,s=a-1;i<a;s=i++)n+=((r=t[s]).x-(e=t[i]).x)*(e.y+r.y);return n}bf.types=["Unknown","Point","LineString","Polygon"],bf.prototype.loadGeometry=function(){var t=this._pbf;t.pos=this._geometry;for(var e,r=t.readVarint()+t.pos,n=1,i=0,a=0,s=0,o=[];t.pos<r;){if(i<=0){var l=t.readVarint();n=7&l,i=l>>3;}if(i--,1===n||2===n)a+=t.readSVarint(),s+=t.readSVarint(),1===n&&(e&&o.push(e),e=[]),e.push(new xf(a,s));else {if(7!==n)throw new Error("unknown command "+n);e&&e.push(e[0].clone());}}return e&&o.push(e),o},bf.prototype.bbox=function(){var t=this._pbf;t.pos=this._geometry;for(var e=t.readVarint()+t.pos,r=1,n=0,i=0,a=0,s=1/0,o=-1/0,l=1/0,u=-1/0;t.pos<e;){if(n<=0){var c=t.readVarint();r=7&c,n=c>>3;}if(n--,1===r||2===r)(i+=t.readSVarint())<s&&(s=i),i>o&&(o=i),(a+=t.readSVarint())<l&&(l=a),a>u&&(u=a);else if(7!==r)throw new Error("unknown command "+r)}return [s,l,o,u]},bf.prototype.toGeoJSON=function(t,e,r){var n,i,a=this.extent*Math.pow(2,r),s=this.extent*t,o=this.extent*e,l=this.loadGeometry(),u=bf.types[this.type];function c(t){for(var e=0;e<t.length;e++){var r=t[e];t[e]=[360*(r.x+s)/a-180,360/Math.PI*Math.atan(Math.exp((180-360*(r.y+o)/a)*Math.PI/180))-90];}}switch(this.type){case 1:var h=[];for(n=0;n<l.length;n++)h[n]=l[n][0];c(l=h);break;case 2:for(n=0;n<l.length;n++)c(l[n]);break;case 3:for(l=function(t){var e=t.length;if(e<=1)return [t];for(var r,n,i=[],a=0;a<e;a++){var s=wf(t[a]);0!==s&&(void 0===n&&(n=s<0),n===s<0?(r&&i.push(r),r=[t[a]]):r.push(t[a]));}return r&&i.push(r),i}(l),n=0;n<l.length;n++)for(i=0;i<l[n].length;i++)c(l[n][i]);}1===l.length?l=l[0]:u="Multi"+u;var p={type:"Feature",geometry:{type:u,coordinates:l},properties:this.properties};return "id"in this&&(p.id=this.id),p};var Mf=vf,Af=Sf;function Sf(t,e){this.version=1,this.name=null,this.extent=4096,this.length=0,this._pbf=t,this._keys=[],this._values=[],this._features=[],t.readFields(If,this,e),this.length=this._features.length;}function If(t,e,r){15===t?e.version=r.readVarint():1===t?e.name=r.readString():5===t?e.extent=r.readVarint():2===t?e._features.push(r.pos):3===t?e._keys.push(r.readString()):4===t&&e._values.push(function(t){for(var e=null,r=t.readVarint()+t.pos;t.pos<r;){var n=t.readVarint()>>3;e=1===n?t.readString():2===n?t.readFloat():3===n?t.readDouble():4===n?t.readVarint64():5===n?t.readVarint():6===n?t.readSVarint():7===n?t.readBoolean():null;}return e}(r));}Sf.prototype.feature=function(t){if(t<0||t>=this._features.length)throw new Error("feature index out of bounds");this._pbf.pos=this._features[t];var e=this._pbf.readVarint()+this._pbf.pos;return new Mf(this._pbf,e,this.extent,this._keys,this._values)};var kf=Af;function Pf(t,e,r){if(3===t){var n=new kf(r,r.readVarint()+r.pos);n.length&&(e[n.name]=n);}}var Ef=gf.VectorTile=function(t,e){this.layers=t.readFields(Pf,{},e);},zf=gf.VectorTileFeature=vf;function Tf(t,e,r,n){const i=[],a=0===n?(t,e,r,n,i,a)=>{t.push(new g(a,r+(a-e)/(n-e)*(i-r)));}:(t,e,r,n,i,a)=>{t.push(new g(e+(a-r)/(i-r)*(n-e),a));};for(const s of t){const t=[];for(const i of s){if(i.length<=2)continue;const s=[];for(let t=0;t<i.length-1;t++){const o=i[t].x,l=i[t].y,u=i[t+1].x,c=i[t+1].y,h=0===n?o:l,p=0===n?u:c;h<e?p>e&&a(s,o,l,u,c,e):h>r?p<r&&a(s,o,l,u,c,r):s.push(i[t]),p<e&&h>=e&&a(s,o,l,u,c,e),p>r&&h<=r&&a(s,o,l,u,c,r);}let o=i[i.length-1];const l=0===n?o.x:o.y;l>=e&&l<=r&&s.push(o),s.length&&(o=s[s.length-1],s[0].x===o.x&&s[0].y===o.y||s.push(s[0]),t.push(s));}t.length&&i.push(t);}return i}function Bf(t,e){return t.x-e.x||t.y-e.y}function Cf(t,e){return 0===Bf(t.min,e.min)&&0===Bf(t.max,e.max)}function Rf(t,e){return !(t.min.x>e.max.x||t.max.x<e.min.x||t.min.y>e.max.y||t.max.y<e.min.y)}function Df(t,e,r){const n=1/Tr,i=1/(1<<r.canonical.z),a=(e.x*n+r.canonical.x)*i+r.wrap,s=(e.y*n+r.canonical.y)*i;return {min:new g((t.x*n+r.canonical.x)*i+r.wrap,(t.y*n+r.canonical.y)*i),max:new g(a,s)}}function Vf(t,e,r){const n=1<<r.canonical.z,i=((e.x-r.wrap)*n-r.canonical.x)*Tr,a=(e.y*n-r.canonical.y)*Tr;return {min:new g(((t.x-r.wrap)*n-r.canonical.x)*Tr,(t.y*n-r.canonical.y)*Tr),max:new g(i,a)}}function Lf(t,e,r,n,i,a,s){const o=t.indices,l=t.vertices,u=[];for(let c=n;c<n+i;c+=3){const n=e[r[c+0]+a],i=e[r[c+1]+a],h=e[r[c+2]+a],p=Math.min(n.x,i.x,h.x),f=Math.max(n.x,i.x,h.x),d=Math.min(n.y,i.y,h.y),m=Math.max(n.y,i.y,h.y);u.length=0,t.grid.query(new g(p,d),new g(f,m),u);for(let t=0;t<u.length;t++){const e=u[t];if(Kl(l[o[3*e+0]],l[o[3*e+1]],l[o[3*e+2]],n,i,h,s))return !0}}return !1}function Ff(t,e,r,n){if(!t||!r)return !1;let i=t.vertices;if(!e.canonical.equals(n.canonical)||e.wrap!==n.wrap){if(r.vertices.length<t.vertices.length)return Ff(r,n,t,e);const a=e.canonical,s=n.canonical,o=Math.pow(2,s.z-a.z);i=t.vertices.map((t=>new g(t.x*a.x*Tr*o-s.x*Tr,t.y*a.y*Tr*o-s.y*Tr)));}return Lf(r,i,t.indices,0,t.indices.length,0,0)}gf.VectorTileLayer=Af;class Nf{constructor(t){this.size=t,this.minimums=[],this.maximums=[],this.leaves=[];}getElevation(t,e){const r=this.toIdx(t,e);return {min:this.minimums[r],max:this.maximums[r]}}isLeaf(t,e){return this.leaves[this.toIdx(t,e)]}toIdx(t,e){return e*this.size+t}}function Of(t,e,r,n){let i=0,a=Number.MAX_VALUE;for(let s=0;s<3;s++)if(Math.abs(n[s])<1e-15){if(r[s]<t[s]||r[s]>e[s])return null}else {const o=1/n[s];let l=(t[s]-r[s])*o,u=(e[s]-r[s])*o;if(l>u){const t=l;l=u,u=t;}if(l>i&&(i=l),u<a&&(a=u),i>a)return null}return i}function Uf(t,e,r,n,i,a,s,o,l,u,c){const h=n-t,p=i-e,f=a-r,d=s-t,m=o-e,y=l-r,g=c[1]*y-c[2]*m,x=c[2]*d-c[0]*y,v=c[0]*m-c[1]*d,b=h*g+p*x+f*v;if(Math.abs(b)<1e-15)return null;const _=1/b,w=u[0]-t,M=u[1]-e,A=u[2]-r,S=(w*g+M*x+A*v)*_;if(S<0||S>1)return null;const I=M*f-A*p,k=A*h-w*f,P=w*p-M*h,E=(c[0]*I+c[1]*k+c[2]*P)*_;return E<0||S+E>1?null:(d*I+m*k+y*P)*_}function jf(t,e,r){return (t-e)/(r-e)}function qf(t,e,r,n,i,a,s,o,l){const u=1<<r,c=a-n,h=s-i,p=(t+1)/u*c+n,f=(e+0)/u*h+i,d=(e+1)/u*h+i;o[0]=(t+0)/u*c+n,o[1]=f,l[0]=p,l[1]=d;}class $f{constructor(t){if(this.maximums=[],this.minimums=[],this.leaves=[],this.childOffsets=[],this.nodeCount=0,this.dem=t,this._siblingOffset=[[0,0],[1,0],[0,1],[1,1]],!this.dem)return;const e=function(t){const e=Math.ceil(Math.log2(t.dim/8)),r=[];let n=Math.ceil(Math.pow(2,e));const i=1/n,a=(t,e,r,n,i)=>{const a=n?1:0,s=(t+1)*r-a,o=e*r,l=(e+1)*r-a;i[0]=t*r,i[1]=o,i[2]=s,i[3]=l;};let s=new Nf(n);const o=[];for(let e=0;e<n*n;e++){a(e%n,Math.floor(e/n),i,!1,o);const r=Yf(o[0],o[1],t),l=Yf(o[2],o[1],t),u=Yf(o[2],o[3],t),c=Yf(o[0],o[3],t);s.minimums.push(Math.min(r,l,u,c)),s.maximums.push(Math.max(r,l,u,c)),s.leaves.push(1);}for(r.push(s),n/=2;n>=1;n/=2){const t=r[r.length-1];s=new Nf(n);for(let e=0;e<n*n;e++){a(e%n,Math.floor(e/n),2,!0,o);const r=t.getElevation(o[0],o[1]),i=t.getElevation(o[2],o[1]),l=t.getElevation(o[2],o[3]),u=t.getElevation(o[0],o[3]),c=t.isLeaf(o[0],o[1]),h=t.isLeaf(o[2],o[1]),p=t.isLeaf(o[2],o[3]),f=t.isLeaf(o[0],o[3]),d=Math.min(r.min,i.min,l.min,u.min),m=Math.max(r.max,i.max,l.max,u.max),y=c&&h&&p&&f;s.maximums.push(m),s.minimums.push(d),s.leaves.push(m-d<=5&&y?1:0);}r.push(s);}return r}(this.dem),r=e.length-1,n=e[r];this._addNode(n.minimums[0],n.maximums[0],n.leaves[0]),this._construct(e,0,0,r,0);}raycastRoot(t,e,r,n,i,a,s=1){return Of([t,e,-100],[r,n,this.maximums[0]*s],i,a)}raycast(e,r,n,i,a,s,o=1){if(!this.nodeCount)return null;const l=this.raycastRoot(e,r,n,i,a,s,o);if(null==l)return null;const u=[],c=[],h=[],p=[],f=[{idx:0,t:l,nodex:0,nodey:0,depth:0}];for(;f.length>0;){const{idx:l,t:d,nodex:m,nodey:y,depth:g}=f.pop();if(this.leaves[l]){qf(m,y,g,e,r,n,i,h,p);const l=1<<g,u=(m+0)/l,c=(m+1)/l,f=(y+0)/l,x=(y+1)/l,v=Yf(u,f,this.dem)*o,b=Yf(c,f,this.dem)*o,_=Yf(c,x,this.dem)*o,w=Yf(u,x,this.dem)*o,M=Uf(h[0],h[1],v,p[0],h[1],b,p[0],p[1],_,a,s),A=Uf(p[0],p[1],_,h[0],p[1],w,h[0],h[1],v,a,s),S=Math.min(null!==M?M:Number.MAX_VALUE,null!==A?A:Number.MAX_VALUE);if(S!==Number.MAX_VALUE)return S;{const e=t.N.scaleAndAdd([],a,s,d);if(Gf(v,b,w,_,jf(e[0],h[0],p[0]),jf(e[1],h[1],p[1]))>=e[2])return d}continue}let x=0;for(let t=0;t<this._siblingOffset.length;t++){qf((m<<1)+this._siblingOffset[t][0],(y<<1)+this._siblingOffset[t][1],g+1,e,r,n,i,h,p),h[2]=-100,p[2]=this.maximums[this.childOffsets[l]+t]*o;const f=Of(h,p,a,s);if(null!=f){const e=f;u[t]=e;let r=!1;for(let n=0;n<x&&!r;n++)e>=u[c[n]]&&(c.splice(n,0,t),r=!0);r||(c[x]=t),x++;}}for(let t=0;t<x;t++){const e=c[t];f.push({idx:this.childOffsets[l]+e,t:u[e],nodex:(m<<1)+this._siblingOffset[e][0],nodey:(y<<1)+this._siblingOffset[e][1],depth:g+1});}}return null}_addNode(t,e,r){return this.minimums.push(t),this.maximums.push(e),this.leaves.push(r),this.childOffsets.push(0),this.nodeCount++}_construct(t,e,r,n,i){if(1===t[n].isLeaf(e,r))return;this.childOffsets[i]||(this.childOffsets[i]=this.nodeCount);const a=n-1,s=t[a];let o=0,l=0;for(let t=0;t<this._siblingOffset.length;t++){const n=2*e+this._siblingOffset[t][0],i=2*r+this._siblingOffset[t][1],a=s.getElevation(n,i),u=s.isLeaf(n,i),c=this._addNode(a.min,a.max,u);u&&(o|=1<<t),l||(l=c);}for(let n=0;n<this._siblingOffset.length;n++)o&1<<n||this._construct(t,2*e+this._siblingOffset[n][0],2*r+this._siblingOffset[n][1],a,l+n);}}function Gf(t,e,r,n,i,a){return ue(ue(t,r,a),ue(e,n,a),i)}function Yf(t,e,r){const n=r.dim,i=I(t*n-.5,0,n-1),a=I(e*n-.5,0,n-1),s=Math.floor(i),o=Math.floor(a),l=Math.min(s+1,n-1),u=Math.min(o+1,n-1);return Gf(r.get(s,o),r.get(l,o),r.get(s,u),r.get(l,u),i-s,a-o)}const Xf={mapbox:[6553.6,25.6,.1,1e4],terrarium:[256,1,1/256,32768]};function Zf(t,e,r){return (256*t*256+256*e+r)/10-1e4}function Kf(t,e,r){return 256*t+e+r/256-32768}class Hf{get tree(){return this._tree||this._buildQuadTree(),this._tree}constructor(t,e,r,n=!1){if(this.uid=t,e.height!==e.width)throw new RangeError("DEM tiles must be square");if(r&&"mapbox"!==r&&"terrarium"!==r)return j(`"${r}" is not a valid encoding type. Valid types include "mapbox" and "terrarium".`);this.stride=e.height;const i=this.dim=e.height-2,a=new Uint32Array(e.data.buffer);if(this.pixels=new Uint8Array(e.data.buffer),this.floatView=new Float32Array(e.data.buffer),this.borderReady=n,this._modifiedForSources={},!n){for(let t=0;t<i;t++)a[this._idx(-1,t)]=a[this._idx(0,t)],a[this._idx(i,t)]=a[this._idx(i-1,t)],a[this._idx(t,-1)]=a[this._idx(t,0)],a[this._idx(t,i)]=a[this._idx(t,i-1)];a[this._idx(-1,-1)]=a[this._idx(0,0)],a[this._idx(i,-1)]=a[this._idx(i-1,0)],a[this._idx(-1,i)]=a[this._idx(0,i-1)],a[this._idx(i,i)]=a[this._idx(i-1,i-1)];}const s="terrarium"===r?Kf:Zf;for(let t=0;t<a.length;++t){const e=4*t;this.floatView[t]=s(this.pixels[e],this.pixels[e+1],this.pixels[e+2]);}this._timestamp=st.now();}_buildQuadTree(){this._tree=new $f(this);}get(t,e,r=!1){r&&(t=I(t,-1,this.dim),e=I(e,-1,this.dim));const n=this._idx(t,e);return this.floatView[n]}set(t,e,r){const n=this._idx(t,e),i=this.floatView[n];return this.floatView[n]=r,r-i}static getUnpackVector(t){return Xf[t]}_idx(t,e){if(t<-1||t>=this.dim+1||e<-1||e>=this.dim+1)throw new RangeError("out of range source coordinates for DEM data");return (e+1)*this.stride+(t+1)}static pack(t,e){const r=[0,0,0,0],n=Hf.getUnpackVector(e);let i=Math.floor((t+n[3])/n[2]);return r[2]=i%256,i=Math.floor(i/256),r[1]=i%256,i=Math.floor(i/256),r[0]=i,r}getPixels(){return new _p({width:this.stride,height:this.stride},this.pixels)}backfillBorder(t,e,r){if(this.dim!==t.dim)throw new Error("dem dimension mismatch");let n=e*this.dim,i=e*this.dim+this.dim,a=r*this.dim,s=r*this.dim+this.dim;switch(e){case-1:n=i-1;break;case 1:i=n+1;}switch(r){case-1:a=s-1;break;case 1:s=a+1;}const o=-e*this.dim,l=-r*this.dim;for(let e=a;e<s;e++)for(let r=n;r<i;r++){const n=4*this._idx(r,e),i=4*this._idx(r+o,e+l);this.pixels[n+0]=t.pixels[i+0],this.pixels[n+1]=t.pixels[i+1],this.pixels[n+2]=t.pixels[i+2],this.pixels[n+3]=t.pixels[i+3];}}onDeserialize(){this._tree&&(this._tree.dem=this);}}ra(Hf,"DEMData"),ra($f,"DemMinMaxQuadTree",{omit:["dem"]});class Wf{constructor(t,e,r){this._demTile=t,this._dem=this._demTile.dem,this._scale=e,this._offset=r;}static create(t,e,r){const n=r||t.findDEMTileFor(e);if(!n||!n.dem)return;const i=n.dem,a=n.tileID,s=1<<e.canonical.z-a.canonical.z;return new Wf(n,i.dim/Tr/s,[(e.canonical.x/s-a.canonical.x)*i.dim,(e.canonical.y/s-a.canonical.y)*i.dim])}tileCoordToPixel(t,e){const r=e*this._scale+this._offset[1],n=Math.floor(t*this._scale+this._offset[0]),i=Math.floor(r);return new g(n,i)}getElevationAt(t,e,r,n){const i=t*this._scale+this._offset[0],a=e*this._scale+this._offset[1],s=Math.floor(i),o=Math.floor(a),l=this._dem;return n=!!n,r?ue(ue(l.get(s,o,n),l.get(s,o+1,n),a-o),ue(l.get(s+1,o,n),l.get(s+1,o+1,n),a-o),i-s):l.get(s,o,n)}getElevationAtPixel(t,e,r){return this._dem.get(t,e,!!r)}getMeterToDEM(t){return (1<<this._demTile.tileID.canonical.z)*dl(1,t)*this._dem.stride}}const Jf=zf.types,Qf=["fill-extrusion-base","fill-extrusion-height","fill-extrusion-color","fill-extrusion-pattern","fill-extrusion-flood-light-wall-radius"],td=["fill-extrusion-flood-light-ground-radius"],ed=Math.pow(2,13),rd=Math.pow(2,15)-1,nd=new g(0,1),id=2147483648;function ad(t,e,r,n,i,a,s,o){t.emplaceBack((e<<1)+s,(r<<1)+a,(Math.floor(n*ed)<<1)+i,Math.round(o));}function sd(t,e,r,n,i,a){t.emplaceBack(e.x,e.y,(r.x<<1)+n,(r.y<<1)+i,a);}function od(t,e,r){const n=16384;t.emplaceBack(e.x,e.y,e.z,r[0]*n,r[1]*n,r[2]*n);}class ld{constructor(){this.vertexOffset=0,this.vertexCount=0,this.indexOffset=0,this.indexCount=0;}}class ud{constructor(){this.centroidXY=new g(0,0),this.vertexArrayOffset=0,this.vertexCount=0,this.groundVertexArrayOffset=0,this.groundVertexCount=0,this.flags=0,this.footprintSegIdx=-1,this.footprintSegLen=0,this.polygonSegIdx=-1,this.polygonSegLen=0,this.min=new g(Number.MAX_VALUE,Number.MAX_VALUE),this.max=new g(-Number.MAX_VALUE,-Number.MAX_VALUE),this.height=0;}span(){return new g(this.max.x-this.min.x,this.max.y-this.min.y)}}class cd{constructor(){this.acc=new g(0,0),this.accCount=0,this.centroidDataIndex=0;}startRing(t,e){t.min.x===Number.MAX_VALUE&&(t.min.x=t.max.x=e.x,t.min.y=t.max.y=e.y);}appendEdge(t,e,r){this.accCount++,this.acc._add(e);let n=!!this.borders;e.x<t.min.x?(t.min.x=e.x,n=!0):e.x>t.max.x&&(t.max.x=e.x,n=!0),e.y<t.min.y?(t.min.y=e.y,n=!0):e.y>t.max.y&&(t.max.y=e.y,n=!0),((0===e.x||e.x===Tr)&&e.x===r.x)!=((0===e.y||e.y===Tr)&&e.y===r.y)&&this.processBorderOverlap(e,r),n&&this.checkBorderIntersection(e,r);}checkBorderIntersection(t,e){e.x<0!=t.x<0&&this.addBorderIntersection(0,ue(e.y,t.y,(0-e.x)/(t.x-e.x))),e.x>Tr!=t.x>Tr&&this.addBorderIntersection(1,ue(e.y,t.y,(Tr-e.x)/(t.x-e.x))),e.y<0!=t.y<0&&this.addBorderIntersection(2,ue(e.x,t.x,(0-e.y)/(t.y-e.y))),e.y>Tr!=t.y>Tr&&this.addBorderIntersection(3,ue(e.x,t.x,(Tr-e.y)/(t.y-e.y)));}addBorderIntersection(t,e){this.borders||(this.borders=[[Number.MAX_VALUE,-Number.MAX_VALUE],[Number.MAX_VALUE,-Number.MAX_VALUE],[Number.MAX_VALUE,-Number.MAX_VALUE],[Number.MAX_VALUE,-Number.MAX_VALUE]]);const r=this.borders[t];e<r[0]&&(r[0]=e),e>r[1]&&(r[1]=e);}processBorderOverlap(t,e){if(t.x===e.x){if(t.y===e.y)return;const r=0===t.x?0:1;this.addBorderIntersection(r,e.y),this.addBorderIntersection(r,t.y);}else {const r=0===t.y?2:3;this.addBorderIntersection(r,e.x),this.addBorderIntersection(r,t.x);}}centroid(){return 0===this.accCount?new g(0,0):new g(Math.floor(Math.max(0,this.acc.x)/this.accCount),Math.floor(Math.max(0,this.acc.y)/this.accCount))}intersectsCount(){return this.borders?this.borders.reduce(((t,e)=>t+ +(e[0]!==Number.MAX_VALUE)),0):0}}function hd(t,e){const r=t.add(e)._unit(),n=I(t.x*r.x+t.y*r.y,-1,1);var i,a,s;return i=Math.acos(n),Math.min(4,Math.max(-4,Math.tan(i)))/4*rd*((a=t).x*(s=e).y-a.y*s.x<0?-1:1)}const pd=[t=>t.x<0,t=>t.x>Tr,t=>t.y<0,t=>t.y>Tr];function fd(t,e,r,n){const i=[4];if(0===n)return i;r._mult(n);const a=t.sub(r),s=e.sub(r),o=[t,e,a,s];for(let t=0;t<4;t++)for(const e of o)if(pd[t](e)){i.push(t);break}return i}class dd{constructor(t){this.vertexArray=new ms,this.indexArray=new Es,this.programConfigurations=new Vo(t.layers,t.zoom,(t=>td.includes(t))),this._segments=new eo,this.hiddenByLandmarkVertexArray=new Us,this._segmentToGroundQuads={},this._segmentToGroundQuads[0]=[],this._segmentToRegionTriCounts={},this._segmentToRegionTriCounts[0]=[0,0,0,0,0],this.regionSegments={},this.regionSegments[4]=new eo;}getDefaultSegment(){return this.regionSegments[4]}hasData(){return 0!==this.vertexArray.length}addData(t,e,r,n=!1){const i=t.length;if(i>2){let a=Math.max(0,this._segments.get().length-1);const s=this._segments._prepareSegment(4*i,this.vertexArray.length,2*this._segmentToGroundQuads[a].length);let o;a!==this._segments.get().length-1&&(a++,this._segmentToGroundQuads[a]=[],this._segmentToRegionTriCounts[a]=[0,0,0,0,0]);{const e=t[0],r=t[1];o=hd(e.sub(t[i-1])._perp()._unit(),r.sub(e)._perp()._unit());}for(let l=0;l<i;l++){const u=l===i-1?0:l+1,c=t[l],h=t[u],p=t[u===i-1?0:u+1],f=h.sub(c)._perp()._unit(),d=hd(f,p.sub(h)._perp()._unit()),m=o,y=d;if(vd(c,h,e)||n&&bd(c,e)&&bd(h,e)){o=d;continue}const g=s.vertexLength;sd(this.vertexArray,c,h,1,1,m),sd(this.vertexArray,c,h,1,0,m),sd(this.vertexArray,c,h,0,1,y),sd(this.vertexArray,c,h,0,0,y),s.vertexLength+=4;const x=fd(c,h,f,r);for(const t of x)this._segmentToGroundQuads[a].push({id:g,region:t}),this._segmentToRegionTriCounts[a][t]+=2,s.primitiveLength+=2;o=d;}}}prepareBorderSegments(){if(!this.hasData())return;const t=this._segments.get(),e=t.length;for(let t=0;t<e;t++)this._segmentToGroundQuads[t].sort(((t,e)=>t.region-e.region));for(let r=0;r<e;r++){const e=this._segmentToGroundQuads[r],n=t[r],i=this._segmentToRegionTriCounts[r];i.reduce(((t,e)=>t+e),0);let a=0;for(let t=0;t<=4;t++){const e=i[t];if(0!==e){let r=this.regionSegments[t];r||(r=this.regionSegments[t]=new eo);const i={vertexOffset:n.vertexOffset,primitiveOffset:n.primitiveOffset+a,vertexLength:n.vertexLength,primitiveLength:e};r.get().push(i);}a+=e;}for(let t=0;t<e.length;t++){const r=e[t].id;this.indexArray.emplaceBack(r,r+1,r+3),this.indexArray.emplaceBack(r,r+3,r+2);}}this._segmentToGroundQuads=null,this._segmentToRegionTriCounts=null,this._segments.destroy(),this._segments=null;}addPaintPropertiesData(t,e,r,n,i,a){this.hasData()&&this.programConfigurations.populatePaintArrays(this.vertexArray.length,t,e,r,n,i,a);}upload(t){this.hasData()&&(this.vertexBuffer=t.createVertexBuffer(this.vertexArray,pf.members),this.indexBuffer=t.createIndexBuffer(this.indexArray));}uploadPaintProperties(t){this.hasData()&&this.programConfigurations.upload(t);}update(t,e,r,n,i,a){this.hasData()&&this.programConfigurations.updatePaintArrays(t,e,r,n,i,a);}updateHiddenByLandmark(t){if(!this.hasData())return;const e=t.groundVertexCount+t.groundVertexArrayOffset;if(0===t.groundVertexCount)return;const r=t.flags&id?1:0;for(let n=t.groundVertexArrayOffset;n<e;++n)this.hiddenByLandmarkVertexArray.emplace(n,r);this._needsHiddenByLandmarkUpdate=!0;}uploadHiddenByLandmark(t){this.hasData()&&this._needsHiddenByLandmarkUpdate&&(!this.hiddenByLandmarkVertexBuffer&&this.hiddenByLandmarkVertexArray.length>0?this.hiddenByLandmarkVertexBuffer=t.createVertexBuffer(this.hiddenByLandmarkVertexArray,df.members,!0):this.hiddenByLandmarkVertexBuffer&&this.hiddenByLandmarkVertexBuffer.updateData(this.hiddenByLandmarkVertexArray),this._needsHiddenByLandmarkUpdate=!1);}destroy(){if(this.vertexBuffer){this.vertexBuffer.destroy(),this.indexBuffer.destroy(),this.hiddenByLandmarkVertexBuffer&&this.hiddenByLandmarkVertexBuffer.destroy(),this._segments&&this._segments.destroy(),this.programConfigurations.destroy();for(let t=0;t<=4;t++){const e=this.regionSegments[t];e&&e.destroy();}}}}class md{constructor(t){this.zoom=t.zoom,this.canonical=t.canonical,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.fqid)),this.index=t.index,this.hasPattern=!1,this.edgeRadius=0,this.projection=t.projection,this.activeReplacements=[],this.replacementUpdateTime=0,this.centroidData=[],this.footprintIndices=new Es,this.footprintVertices=new ps,this.footprintSegments=[],this.layoutVertexArray=new ds,this.centroidVertexArray=new Js,this.indexArray=new Es,this.programConfigurations=new Vo(t.layers,t.zoom,(t=>Qf.includes(t))),this.segments=new eo,this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id)),this.groundEffect=new dd(t),this.maxHeight=0,this.partLookup={},this.triangleSubSegments=[],this.polygonSegments=[];}populate(t,e,r,n){this.features=[],this.hasPattern=sf("fill-extrusion",this.layers,e),this.featuresOnBorder=[],this.borderFeatureIndices=[[],[],[],[]],this.borderDoneWithNeighborZ=[-1,-1,-1,-1],this.tileToMeter=wl(r),this.edgeRadius=this.layers[0].layout.get("fill-extrusion-edge-radius")/this.tileToMeter;for(const{feature:i,id:a,index:s,sourceLayerIndex:o}of t){const t=this.layers[0]._featureFilter.needGeometry,l=Bl(i,t);if(!this.layers[0]._featureFilter.filter(new Pa(this.zoom),l,r))continue;const u={id:a,sourceLayerIndex:o,index:s,geometry:t?l.geometry:Tl(i,r,n),properties:i.properties,type:i.type,patterns:{}},c=this.layoutVertexArray.length;this.hasPattern?this.features.push(of("fill-extrusion",this.layers,u,this.zoom,e)):this.addFeature(u,u.geometry,s,r,{},e.availableImages,n,e.brightness),e.featureIndex.insert(i,u.geometry,s,o,this.index,c);}this.sortBorders(),"mercator"===this.projection.name&&this.splitToSubtiles(),this.groundEffect.prepareBorderSegments(),this.polygonSegments.length=0;}addFeatures(t,e,r,n,i,a){for(const t of this.features){const{geometry:s}=t;this.addFeature(t,s,t.index,e,r,n,i,a);}this.sortBorders(),"mercator"===this.projection.name&&this.splitToSubtiles();}update(t,e,r,n,i){const a=0!==Object.keys(t).length;if(a&&!this.stateDependentLayers.length)return;const s=a?this.stateDependentLayers:this.layers;this.programConfigurations.updatePaintArrays(t,e,s,r,n,i),this.groundEffect.update(t,e,s,r,n,i);}isEmpty(){return 0===this.layoutVertexArray.length}uploadPending(){return !this.uploaded||this.programConfigurations.needsUpload||this.groundEffect.programConfigurations.needsUpload}upload(t){this.uploaded||(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,yf),this.indexBuffer=t.createIndexBuffer(this.indexArray),this.layoutVertexExtArray&&(this.layoutVertexExtBuffer=t.createVertexBuffer(this.layoutVertexExtArray,mf.members,!0)),this.groundEffect.upload(t)),this.groundEffect.uploadPaintProperties(t),this.programConfigurations.upload(t),this.uploaded=!0;}uploadCentroid(t){this.groundEffect.uploadHiddenByLandmark(t),this.needsCentroidUpdate&&(!this.centroidVertexBuffer&&this.centroidVertexArray.length>0?this.centroidVertexBuffer=t.createVertexBuffer(this.centroidVertexArray,ff.members,!0):this.centroidVertexBuffer&&this.centroidVertexBuffer.updateData(this.centroidVertexArray),this.needsCentroidUpdate=!1);}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.centroidVertexBuffer&&this.centroidVertexBuffer.destroy(),this.layoutVertexExtBuffer&&this.layoutVertexExtBuffer.destroy(),this.groundEffect.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy());}addFeature(t,e,r,n,i,a,s,o){const l=this.layers[0].paint.get("fill-extrusion-flood-light-ground-radius").evaluate(t,{})/this.tileToMeter,u=[new g(0,0),new g(Tr,Tr)],c=s.projection,h="globe"===c.name,p="Polygon"===Jf[t.type],f=new cd;f.centroidDataIndex=this.centroidData.length;const d=new ud,m=this.layers[0].paint.get("fill-extrusion-base").evaluate(t,{},n)<=0,y=this.layers[0].paint.get("fill-extrusion-height").evaluate(t,{},n);d.height=y,d.vertexArrayOffset=this.layoutVertexArray.length,d.groundVertexArrayOffset=this.groundEffect.vertexArray.length,h&&!this.layoutVertexExtArray&&(this.layoutVertexExtArray=new bs);const x=nf(e,500);for(let t=x.length-1;t>=0;t--){const e=x[t];(0===e.length||(v=e[0]).every((t=>t.x<=0))||v.every((t=>t.x>=Tr))||v.every((t=>t.y<=0))||v.every((t=>t.y>=Tr)))&&x.splice(t,1);}var v;let b;if(h)b=Ad(x,u,n);else {b=[];for(const t of x)b.push({polygon:t,bounds:u});}const _=p?this.edgeRadius:0,w=_>0&&this.zoom<17,M=(t,e)=>{if(0===t.length)return !1;const r=t[t.length-1];return e.x===r.x&&e.y===r.y};for(const{polygon:t,bounds:e}of b){let r=0,i=0;for(const e of t)p&&!e[0].equals(e[e.length-1])&&e.push(e[0]),i+=p?e.length-1:e.length;const a=this.segments.prepareSegment((p?5:4)*i,this.layoutVertexArray,this.indexArray);d.footprintSegIdx<0&&(d.footprintSegIdx=this.footprintSegments.length),d.polygonSegIdx<0&&(d.polygonSegIdx=this.polygonSegments.length);const s={triangleArrayOffset:this.indexArray.length,triangleCount:0,triangleSegIdx:this.segments.segments.length-1},o=new ld;if(o.vertexOffset=this.footprintVertices.length,o.indexOffset=3*this.footprintIndices.length,o.ringIndices=[],p){const i=[],s=[];r=a.vertexLength;for(let r=0;r<t.length;r++){const u=t[r];u.length&&0!==r&&s.push(i.length/2);const p=[];let f,d;f=u[1].sub(u[0])._perp()._unit(),o.ringIndices.push(u.length-1);for(let t=1;t<u.length;t++){const e=u[t],r=u[t===u.length-1?1:t+1],s=e.clone();if(_){d=r.sub(e)._perp()._unit();const t=f.add(d)._unit(),n=_*Math.min(4,1/(f.x*t.x+f.y*t.y));s.x+=n*t.x,s.y+=n*t.y,s.x=Math.round(s.x),s.y=Math.round(s.y),f=d;}!m||0!==_&&!w||M(p,s)||p.push(s),ad(this.layoutVertexArray,s.x,s.y,0,0,1,1,0),a.vertexLength++,this.footprintVertices.emplaceBack(e.x,e.y),i.push(e.x,e.y),h&&od(this.layoutVertexExtArray,c.projectTilePoint(s.x,s.y,n),c.upVector(n,s.x,s.y));}m&&(0===_||w)&&(0!==p.length&&M(p,p[0])&&p.pop(),this.groundEffect.addData(p,e,l));}const u=rf(i,s);for(let t=0;t<u.length;t+=3)this.footprintIndices.emplaceBack(o.vertexOffset+u[t+0],o.vertexOffset+u[t+1],o.vertexOffset+u[t+2]),this.indexArray.emplaceBack(r+u[t],r+u[t+2],r+u[t+1]),a.primitiveLength++;o.indexCount+=u.length,o.vertexCount+=this.footprintVertices.length-o.vertexOffset;}for(let i=0;i<t.length;i++){const s=t[i];f.startRing(d,s[0]);let o=s.length>4&&_d(s[s.length-2],s[0],s[1]),u=_?gd(s[s.length-2],s[0],s[1],_):0;const y=[];let g,x,v;x=s[1].sub(s[0])._perp()._unit();let b=!0;for(let t=1,i=0;t<s.length;t++){let l=s[t-1],p=s[t];const w=s[t===s.length-1?1:t+1];if(f.appendEdge(d,p,l),vd(p,l,e)){_&&(x=w.sub(p)._perp()._unit(),b=!b);continue}const A=p.sub(l)._perp(),S=A.x/(Math.abs(A.x)+Math.abs(A.y)),I=A.y>0?1:0,k=l.dist(p);if(i+k>32768&&(i=0),_){v=w.sub(p)._perp()._unit();let t=xd(l,p,w,yd(x,v),_);isNaN(t)&&(t=0);const e=p.sub(l)._unit();l=l.add(e.mult(u))._round(),p=p.add(e.mult(-t))._round(),u=t,x=v,m&&this.zoom>=17&&(M(y,l)||y.push(l),M(y,p)||y.push(p));}const P=a.vertexLength,E=s.length>4&&_d(l,p,w);let z=wd(i,o,b);if(ad(this.layoutVertexArray,l.x,l.y,S,I,0,0,z),ad(this.layoutVertexArray,l.x,l.y,S,I,0,1,z),i+=k,z=wd(i,E,!b),o=E,ad(this.layoutVertexArray,p.x,p.y,S,I,0,0,z),ad(this.layoutVertexArray,p.x,p.y,S,I,0,1,z),a.vertexLength+=4,this.indexArray.emplaceBack(P+0,P+1,P+2),this.indexArray.emplaceBack(P+1,P+3,P+2),a.primitiveLength+=2,_){const n=r+(1===t?s.length-2:t-2),i=1===t?r:n+1;if(this.indexArray.emplaceBack(P+1,n,P+3),this.indexArray.emplaceBack(n,i,P+3),a.primitiveLength+=2,void 0===g&&(g=P),!vd(w,s[t],e)){const e=t===s.length-1?g:a.vertexLength;this.indexArray.emplaceBack(P+2,P+3,e),this.indexArray.emplaceBack(P+3,e+1,e),this.indexArray.emplaceBack(P+3,i,e+1),a.primitiveLength+=3;}b=!b;}if(h){const t=this.layoutVertexExtArray,e=c.projectTilePoint(l.x,l.y,n),r=c.projectTilePoint(p.x,p.y,n),i=c.upVector(n,l.x,l.y),a=c.upVector(n,p.x,p.y);od(t,e,i),od(t,e,i),od(t,r,a),od(t,r,a);}}p&&(r+=s.length-1),m&&_&&this.zoom>=17&&(0!==y.length&&M(y,y[0])&&y.pop(),this.groundEffect.addData(y,e,l,_>0));}this.footprintSegments.push(o),s.triangleCount=this.indexArray.length-s.triangleArrayOffset,this.polygonSegments.push(s),++d.footprintSegLen,++d.polygonSegLen;}if(d.vertexCount=this.layoutVertexArray.length-d.vertexArrayOffset,d.groundVertexCount=this.groundEffect.vertexArray.length-d.groundVertexArrayOffset,0!==d.vertexCount){if(d.centroidXY=f.borders?nd:this.encodeCentroid(f,d),this.centroidData.push(d),f.borders){this.featuresOnBorder.push(f);const t=this.featuresOnBorder.length-1;for(let e=0;e<f.borders.length;e++)f.borders[e][0]!==Number.MAX_VALUE&&this.borderFeatureIndices[e].push(t);}this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,r,i,a,n,o),this.groundEffect.addPaintPropertiesData(t,r,i,a,n,o),this.maxHeight=Math.max(this.maxHeight,y);}}sortBorders(){for(let t=0;t<this.borderFeatureIndices.length;t++)this.borderFeatureIndices[t].sort(((e,r)=>this.featuresOnBorder[e].borders[t][0]-this.featuresOnBorder[r].borders[t][0]));}splitToSubtiles(){const t=[];for(let e=0;e<this.centroidData.length;e++){const r=this.centroidData[e],n=+(r.min.y+r.max.y>Tr),i=2*n+(+(r.min.x+r.max.x>Tr)^n);for(let n=0;n<r.polygonSegLen;n++){const a=r.polygonSegIdx+n;t.push({centroidIdx:e,subtile:i,polygonSegmentIdx:a,triangleSegmentIdx:this.polygonSegments[a].triangleSegIdx});}}const e=new Es;t.sort(((t,e)=>t.triangleSegmentIdx===e.triangleSegmentIdx?t.subtile-e.subtile:t.triangleSegmentIdx-e.triangleSegmentIdx));let r=0,n=0,i=0;for(const e of t){if(e.triangleSegmentIdx!==r)break;i++;}const a=t.length;for(;n!==t.length;){r=t[n].triangleSegmentIdx;let s=0,o=n,l=n;for(let e=o;e<i&&t[e].subtile===s;e++)l++;for(;o!==i;){const n=t[o];s=n.subtile;const a=this.centroidData[n.centroidIdx].min.clone(),u=this.centroidData[n.centroidIdx].max.clone(),c={vertexOffset:this.segments.segments[r].vertexOffset,primitiveOffset:e.length,vertexLength:this.segments.segments[r].vertexLength,primitiveLength:0,sortKey:void 0,vaos:{}};for(let r=o;r<l;r++){const n=t[r],i=this.polygonSegments[n.polygonSegmentIdx],s=this.centroidData[n.centroidIdx].min,o=this.centroidData[n.centroidIdx].max,l=this.indexArray.uint16;for(let t=i.triangleArrayOffset;t<i.triangleArrayOffset+i.triangleCount;t++)e.emplaceBack(l[3*t],l[3*t+1],l[3*t+2]);c.primitiveLength+=i.triangleCount,a.x=Math.min(a.x,s.x),a.y=Math.min(a.y,s.y),u.x=Math.max(u.x,o.x),u.y=Math.max(u.y,o.y);}c.primitiveLength>0&&this.triangleSubSegments.push({segment:c,min:a,max:u}),o=l;for(let e=o;e<i&&t[e].subtile===t[o].subtile;e++)l++;}n=i;for(let e=n;e<a&&t[e].triangleSegmentIdx===t[n].triangleSegmentIdx;e++)i++;}e._trim(),this.indexArray=e;}getVisibleSegments(t,e,r){let n=0,i=0;const a=1<<t.canonical.z;if(e){const r=e.getMinMaxForTile(t);r&&(n=r.min,i=r.max);}i+=this.maxHeight;const s=t.toUnwrapped();let o;const l=[s.canonical.x/a+s.wrap,s.canonical.y/a],u=[(s.canonical.x+1)/a+s.wrap,(s.canonical.y+1)/a],c=new eo,h=(t,e,r)=>[t[0]*(1-r[0])+e[0]*r[0],t[1]*(1-r[1])+e[1]*r[1]],p=[],f=[];for(const t of this.triangleSubSegments){p[0]=t.min.x/Tr,p[1]=t.min.y/Tr,f[0]=t.max.x/Tr,f[1]=t.max.y/Tr;const e=h(l,u,p),a=h(l,u,f);if(0===new Bh([e[0],e[1],n],[a[0],a[1],i]).intersectsPrecise(r)){o&&(c.segments.push(o),o=void 0);continue}const s=t.segment;o&&o.vertexOffset!==s.vertexOffset&&(c.segments.push(o),o=void 0),o?(o.vertexLength+=s.vertexLength,o.primitiveLength+=s.primitiveLength):o={vertexOffset:s.vertexOffset,primitiveLength:s.primitiveLength,vertexLength:s.vertexLength,primitiveOffset:s.primitiveOffset,sortKey:void 0,vaos:{}};}return o&&c.segments.push(o),c}encodeCentroid(t,e){const r=t.centroid(),n=e.span(),i=Math.min(7,Math.round(n.x*this.tileToMeter/10)),a=Math.min(7,Math.round(n.y*this.tileToMeter/10));return new g(I(r.x,1,Tr-1)<<3|i,I(r.y,1,Tr-1)<<3|a)}encodeBorderCentroid(t){if(!t.borders)return new g(0,0);const e=t.borders,r=Number.MAX_VALUE;if(e[0][0]!==r||e[1][0]!==r){const t=e[0][0]!==r?0:1;return new g(6|(e[0][0]!==r?0:65528),(e[t][0]+e[t][1])/2<<3|6)}{const t=e[2][0]!==r?2:3;return new g((e[t][0]+e[t][1])/2<<3|6,6|(e[2][0]!==r?0:65528))}}showCentroid(t){const e=this.centroidData[t.centroidDataIndex];e.flags&=id,e.centroidXY.x=0,e.centroidXY.y=0,this.writeCentroidToBuffer(e);}writeCentroidToBuffer(t){this.groundEffect.updateHiddenByLandmark(t);const e=t.vertexArrayOffset,r=t.vertexCount+t.vertexArrayOffset,n=t.flags&id?nd:t.centroidXY,i=this.centroidVertexArray.geta_centroid_pos0(e);if(this.centroidVertexArray.geta_centroid_pos1(e)!==n.y||i!==n.x){for(let t=e;t<r;++t)this.centroidVertexArray.emplace(t,n.x,n.y);this.needsCentroidUpdate=!0;}}createCentroidsBuffer(){this.centroidVertexArray.resize(this.layoutVertexArray.length),this.groundEffect.hiddenByLandmarkVertexArray.resize(this.groundEffect.vertexArray.length);for(const t of this.centroidData)this.writeCentroidToBuffer(t);}updateReplacement(t,e){if(e.updateTime===this.replacementUpdateTime)return;this.replacementUpdateTime=e.updateTime;const r=e.getReplacementRegionsForTile(t.toUnwrapped());if(function(t,e){if(t.length!==e.length)return !1;for(let r=0;r<t.length;r++)if(t[r].sourceId!==e[r].sourceId||!Cf(t[r],e[r]))return !1;return !0}(this.activeReplacements,r))return;if(this.activeReplacements=r,0===this.centroidVertexArray.length)this.createCentroidsBuffer();else for(const t of this.centroidData)t.flags&=2147483647;const n=[];for(const e of this.activeReplacements){const r=Math.pow(2,e.footprintTileId.canonical.z-t.canonical.z);for(const i of this.centroidData)if(!(i.flags&id||e.min.x>i.max.x||i.min.x>e.max.x||e.min.y>i.max.y||i.min.y>e.max.y))for(let a=0;a<i.footprintSegLen;a++){const s=this.footprintSegments[i.footprintSegIdx+a];if(n.length=0,Sd(this.footprintVertices,s.vertexOffset,s.vertexCount,e.footprintTileId.canonical,t.canonical,n),Lf(e.footprint,n,this.footprintIndices.uint16,s.indexOffset,s.indexCount,-s.vertexOffset,-r)){i.flags|=id;break}}}for(const t of this.centroidData)this.writeCentroidToBuffer(t);this.borderDoneWithNeighborZ=[-1,-1,-1,-1];}footprintContainsPoint(t,e,r){let n=!1;for(let i=0;i<r.footprintSegLen;i++){const a=this.footprintSegments[r.footprintSegIdx+i];let s=0;for(const r of a.ringIndices){for(let i=s,o=r+s-1;i<r+s;o=i++){const r=this.footprintVertices.int16[2*(i+a.vertexOffset)+0],s=this.footprintVertices.int16[2*(i+a.vertexOffset)+1],l=this.footprintVertices.int16[2*(o+a.vertexOffset)+1];s>e!=l>e&&t<(this.footprintVertices.int16[2*(o+a.vertexOffset)+0]-r)*(e-s)/(l-s)+r&&(n=!n);}s=r;}}return n}getHeightAtTileCoord(t,e){let r=Number.NEGATIVE_INFINITY,n=!0;const i=4*(t+Tr)*Tr+(e+Tr);if(this.partLookup.hasOwnProperty(i)){const t=this.partLookup[i];return t?{height:t.height,hidden:!!(t.flags&id)}:void 0}for(const a of this.centroidData)t>a.max.x||a.min.x>t||e>a.max.y||a.min.y>e||this.footprintContainsPoint(t,e,a)&&a&&a.height>r&&(r=a.height,this.partLookup[i]=a,n=!!(a.flags&id));if(r!==Number.NEGATIVE_INFINITY)return {height:r,hidden:n};this.partLookup[i]=void 0;}}function yd(t,e){const r=t.add(e)._unit();return t.x*r.x+t.y*r.y}function gd(t,e,r,n){const i=e.sub(t)._perp()._unit(),a=r.sub(e)._perp()._unit();return xd(t,e,r,yd(i,a),n)}function xd(t,e,r,n,i){const a=Math.sqrt(1-n*n);return Math.min(t.dist(e)/3,e.dist(r)/3,i*a/n)}function vd(t,e,r){return t.x<r[0].x&&e.x<r[0].x||t.x>r[1].x&&e.x>r[1].x||t.y<r[0].y&&e.y<r[0].y||t.y>r[1].y&&e.y>r[1].y}function bd(t,e){return t.x<e[0].x||t.x>e[1].x||t.y<e[0].y||t.y>e[1].y}function _d(t,e,r){if(t.x<0||t.x>=Tr||e.x<0||e.x>=Tr||r.x<0||r.x>=Tr)return !1;const n=r.sub(e),i=n.perp(),a=t.sub(e);return (n.x*a.x+n.y*a.y)/Math.sqrt((n.x*n.x+n.y*n.y)*(a.x*a.x+a.y*a.y))>-.866&&i.x*a.x+i.y*a.y<0}function wd(t,e,r){const n=e?2|t:-3&t;return r?1|n:-2&n}function Md(){const t=Math.PI/32,e=Math.tan(t),r=Jo;return r*Math.sqrt(1+2*e*e)-r}function Ad(t,e,r){const n=1<<r.z,i=ml(r.x/n),a=ml((r.x+1)/n),s=yl(r.y/n),o=yl((r.y+1)/n);return function(t,e,r,n,i=0,a){const s=[];if(!t.length||!r||!n)return s;const o=(t,e)=>{for(const r of t)s.push({polygon:r,bounds:e});},l=Math.ceil(Math.log2(r)),u=Math.ceil(Math.log2(n)),c=l-u,h=[];for(let t=0;t<Math.abs(c);t++)h.push(c>0?0:1);for(let t=0;t<Math.min(l,u);t++)h.push(0),h.push(1);let p=t;if(p=Tf(p,e[0].y-i,e[1].y+i,1),p=Tf(p,e[0].x-i,e[1].x+i,0),!p.length)return s;const f=[];for(h.length?f.push({polygons:p,bounds:e,depth:0}):o(p,e);f.length;){const t=f.pop(),e=t.depth,r=h[e],n=t.bounds[0],s=t.bounds[1],l=0===r?n.x:n.y,u=0===r?s.x:s.y,c=a?a(r,l,u):.5*(l+u),p=Tf(t.polygons,l-i,c+i,r),d=Tf(t.polygons,c-i,u+i,r);if(p.length){const t=[n,new g(0===r?c:s.x,1===r?c:s.y)];h.length>e+1?f.push({polygons:p,bounds:t,depth:e+1}):o(p,t);}if(d.length){const t=[new g(0===r?c:n.x,1===r?c:n.y),s];h.length>e+1?f.push({polygons:d,bounds:t,depth:e+1}):o(d,t);}}return s}(t,e,Math.ceil((a-i)/11.25),Math.ceil((s-o)/11.25),1,((t,e,i)=>{if(0===t)return .5*(e+i);{const t=yl((r.y+e/Tr)/n);return (fl(.5*(yl((r.y+i/Tr)/n)+t))*n-r.y)*Tr}}))}function Sd(t,e,r,n,i,a){const s=Math.pow(2,n.z-i.z);for(let o=0;o<r;o++){let r=t.int16[2*(o+e)+0],l=t.int16[2*(o+e)+1];r=(r+i.x*Tr)*s-n.x*Tr,l=(l+i.y*Tr)*s-n.y*Tr,a.push(new g(r,l));}}ra(md,"FillExtrusionBucket",{omit:["layers","features"]}),ra(ud,"PartData"),ra(ld,"FootprintSegment"),ra(cd,"BorderCentroidData"),ra(dd,"GroundEffect");const Id=new Oa({visibility:new La(qa["layout_fill-extrusion"].visibility),"fill-extrusion-edge-radius":new La(qa["layout_fill-extrusion"]["fill-extrusion-edge-radius"])});var kd={paint:new Oa({"fill-extrusion-opacity":new La(qa["paint_fill-extrusion"]["fill-extrusion-opacity"]),"fill-extrusion-color":new Fa(qa["paint_fill-extrusion"]["fill-extrusion-color"]),"fill-extrusion-translate":new La(qa["paint_fill-extrusion"]["fill-extrusion-translate"]),"fill-extrusion-translate-anchor":new La(qa["paint_fill-extrusion"]["fill-extrusion-translate-anchor"]),"fill-extrusion-pattern":new Fa(qa["paint_fill-extrusion"]["fill-extrusion-pattern"]),"fill-extrusion-height":new Fa(qa["paint_fill-extrusion"]["fill-extrusion-height"]),"fill-extrusion-base":new Fa(qa["paint_fill-extrusion"]["fill-extrusion-base"]),"fill-extrusion-vertical-gradient":new La(qa["paint_fill-extrusion"]["fill-extrusion-vertical-gradient"]),"fill-extrusion-ambient-occlusion-intensity":new La(qa["paint_fill-extrusion"]["fill-extrusion-ambient-occlusion-intensity"]),"fill-extrusion-ambient-occlusion-radius":new La(qa["paint_fill-extrusion"]["fill-extrusion-ambient-occlusion-radius"]),"fill-extrusion-ambient-occlusion-wall-radius":new La(qa["paint_fill-extrusion"]["fill-extrusion-ambient-occlusion-wall-radius"]),"fill-extrusion-ambient-occlusion-ground-radius":new La(qa["paint_fill-extrusion"]["fill-extrusion-ambient-occlusion-ground-radius"]),"fill-extrusion-ambient-occlusion-ground-attenuation":new La(qa["paint_fill-extrusion"]["fill-extrusion-ambient-occlusion-ground-attenuation"]),"fill-extrusion-flood-light-color":new La(qa["paint_fill-extrusion"]["fill-extrusion-flood-light-color"]),"fill-extrusion-flood-light-intensity":new La(qa["paint_fill-extrusion"]["fill-extrusion-flood-light-intensity"]),"fill-extrusion-flood-light-wall-radius":new Fa(qa["paint_fill-extrusion"]["fill-extrusion-flood-light-wall-radius"]),"fill-extrusion-flood-light-ground-radius":new Fa(qa["paint_fill-extrusion"]["fill-extrusion-flood-light-ground-radius"]),"fill-extrusion-flood-light-ground-attenuation":new La(qa["paint_fill-extrusion"]["fill-extrusion-flood-light-ground-attenuation"]),"fill-extrusion-vertical-scale":new La(qa["paint_fill-extrusion"]["fill-extrusion-vertical-scale"]),"fill-extrusion-rounded-roof":new La(qa["paint_fill-extrusion"]["fill-extrusion-rounded-roof"]),"fill-extrusion-cutoff-fade-range":new La(qa["paint_fill-extrusion"]["fill-extrusion-cutoff-fade-range"]),"fill-extrusion-emissive-strength":new La(qa["paint_fill-extrusion"]["fill-extrusion-emissive-strength"])}),layout:Id};class Pd extends g{constructor(t,e,r){super(t,e),this.z=r;}}function Ed(t,e){return t.x*e.x+t.y*e.y}function zd(t,e){if(1===t.length){let r=0;const n=e[r++];let i;for(;!i||n.equals(i);)if(i=e[r++],!i)return 1/0;for(;r<e.length;r++){const a=e[r],s=t[0],o=i.sub(n),l=a.sub(n),u=s.sub(n),c=Ed(o,o),h=Ed(o,l),p=Ed(l,l),f=Ed(u,o),d=Ed(u,l),m=c*p-h*h,y=(p*f-h*d)/m,g=(c*d-h*f)/m,x=n.z*(1-y-g)+i.z*y+a.z*g;if(isFinite(x))return x}return 1/0}{let t=1/0;for(const r of e)t=Math.min(t,r.z);return t}}function Td(t,e,r,n,i,a,s,o){const l=s*i.getElevationAt(t,e,!0,!0),u=0!==a[0],c=u?0===a[1]?s*(a[0]/7-450):s*function(t,e,r){const n=Math.floor(e[0]/8),i=Math.floor(e[1]/8),a=10*(e[0]-8*n),s=10*(e[1]-8*i),o=t.getElevationAt(n,i,!0,!0),l=t.getMeterToDEM(r),u=Math.floor(.5*(a*l-1)),c=Math.floor(.5*(s*l-1)),h=t.tileCoordToPixel(n,i),p=2*u+1,f=2*c+1,d=function(t,e,r,n,i){return [t.getElevationAtPixel(e,r,!0),t.getElevationAtPixel(e+i,r,!0),t.getElevationAtPixel(e,r+i,!0),t.getElevationAtPixel(e+n,r+i,!0)]}(t,h.x-u,h.y-c,p,f),m=Math.abs(d[0]-d[1]),y=Math.abs(d[2]-d[3]),g=Math.abs(d[0]-d[2])+Math.abs(d[1]-d[3]),x=Math.min(.25,.5*l*(m+y)/p),v=Math.min(.25,.5*l*g/f);return o+Math.max(x*a,v*s)}(i,a,o):l;return {base:l+(0===r)?-1:r,top:u?Math.max(c+n,l+r+2):l+n}}const Bd=cs([{name:"a_pos_normal",components:2,type:"Int16"},{name:"a_data",components:4,type:"Uint8"},{name:"a_linesofar",components:1,type:"Float32"}],4),{members:Cd}=Bd,Rd=cs([{name:"a_packed",components:4,type:"Float32"}]),{members:Dd}=Rd;class Vd{constructor(t,e){this.width=t,this.height=e,this.nextRow=0,this.image=new vp({width:t,height:e}),this.positions={},this.uploaded=!1;}getDash(t,e){const r=this.getKey(t,e);return this.positions[r]}trim(){const t=this.width,e=this.height=R(this.nextRow);this.image.resize({width:t,height:e});}getKey(t,e){return t.join(",")+e}getDashRanges(t,e,r){const n=[];let i=t.length%2==1?-t[t.length-1]*r:0,a=t[0]*r,s=!0;n.push({left:i,right:a,isDash:s,zeroLength:0===t[0]});let o=t[0];for(let e=1;e<t.length;e++){s=!s;const l=t[e];i=o*r,o+=l,a=o*r,n.push({left:i,right:a,isDash:s,zeroLength:0===l});}return n}addRoundDash(t,e,r){const n=e/2;for(let e=-r;e<=r;e++){const i=this.width*(this.nextRow+r+e);let a=0,s=t[a];for(let o=0;o<this.width;o++){o/s.right>1&&(s=t[++a]);const l=Math.abs(o-s.left),u=Math.abs(o-s.right),c=Math.min(l,u);let h;const p=e/r*(n+1);if(s.isDash){const t=n-Math.abs(p);h=Math.sqrt(c*c+t*t);}else h=n-Math.sqrt(c*c+p*p);this.image.data[i+o]=Math.max(0,Math.min(255,h+128));}}}addRegularDash(t,e){for(let e=t.length-1;e>=0;--e){const r=t[e],n=t[e+1];r.zeroLength?t.splice(e,1):n&&n.isDash===r.isDash&&(n.left=r.left,t.splice(e,1));}const r=t[0],n=t[t.length-1];r.isDash===n.isDash&&(r.left=n.left-this.width,n.right=r.right+this.width);const i=this.width*this.nextRow;let a=0,s=t[a];for(let r=0;r<this.width;r++){r/s.right>1&&(s=t[++a]);const n=Math.abs(r-s.left),o=Math.abs(r-s.right),l=Math.min(n,o);this.image.data[i+r]=Math.max(0,Math.min(255,(s.isDash?l:-l)+e+128));}}addDash(t,e){const r=this.getKey(t,e);if(this.positions[r])return this.positions[r];const n="round"===e,i=n?7:0,a=2*i+1;if(this.nextRow+a>this.height)return j("LineAtlas out of space"),null;0===t.length&&t.push(1);let s=0;for(let e=0;e<t.length;e++)t[e]<0&&(j("Negative value is found in line dasharray, replacing values with 0"),t[e]=0),s+=t[e];if(0!==s){const r=this.width/s,a=this.getDashRanges(t,this.width,r);n?this.addRoundDash(a,r,i):this.addRegularDash(a,"square"===e?.5*r:0);}const o=this.nextRow+i;this.nextRow+=a;const l={tl:[o,i],br:[s,0]};return this.positions[r]=l,l}}ra(Vd,"LineAtlas");const Ld=zf.types,Fd=Math.cos(Math.PI/180*37.5);class Nd{constructor(t){this.zoom=t.zoom,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.fqid)),this.index=t.index,this.projection=t.projection,this.hasPattern=!1,this.patternFeatures=[],this.lineClipsArray=[],this.gradients={},this.layers.forEach((t=>{this.gradients[t.id]={};})),this.layoutVertexArray=new ys,this.layoutVertexArray2=new gs,this.indexArray=new Es,this.programConfigurations=new Vo(t.layers,t.zoom),this.segments=new eo,this.maxLineLength=0,this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id));}populate(t,e,r,n){this.hasPattern=sf("line",this.layers,e);const i=this.layers[0].layout.get("line-sort-key"),a=[];for(const{feature:e,id:s,index:o,sourceLayerIndex:l}of t){const t=this.layers[0]._featureFilter.needGeometry,u=Bl(e,t);if(!this.layers[0]._featureFilter.filter(new Pa(this.zoom),u,r))continue;const c=i?i.evaluate(u,{},r):void 0,h={id:s,properties:e.properties,type:e.type,sourceLayerIndex:l,index:o,geometry:t?u.geometry:Tl(e,r,n),patterns:{},sortKey:c};a.push(h);}i&&a.sort(((t,e)=>t.sortKey-e.sortKey));const{lineAtlas:s,featureIndex:o}=e,l=this.addConstantDashes(s);for(const n of a){const{geometry:i,index:a,sourceLayerIndex:u}=n;if(l&&this.addFeatureDashes(n,s),this.hasPattern){const t=of("line",this.layers,n,this.zoom,e);this.patternFeatures.push(t);}else this.addFeature(n,i,a,r,s.positions,e.availableImages,e.brightness);o.insert(t[a].feature,i,a,u,this.index);}}addConstantDashes(t){let e=!1;for(const r of this.layers){const n=r.paint.get("line-dasharray").value,i=r.layout.get("line-cap").value;if("constant"!==n.kind||"constant"!==i.kind)e=!0;else {const e=i.value,r=n.value;if(!r)continue;t.addDash(r,e);}}return e}addFeatureDashes(t,e){const r=this.zoom;for(const n of this.layers){const i=n.paint.get("line-dasharray").value,a=n.layout.get("line-cap").value;if("constant"===i.kind&&"constant"===a.kind)continue;let s,o;if("constant"===i.kind){if(s=i.value,!s)continue}else s=i.evaluate({zoom:r},t);o="constant"===a.kind?a.value:a.evaluate({zoom:r},t),e.addDash(s,o),t.patterns[n.id]=e.getKey(s,o);}}update(t,e,r,n,i){const a=0!==Object.keys(t).length;a&&!this.stateDependentLayers.length||this.programConfigurations.updatePaintArrays(t,e,a?this.stateDependentLayers:this.layers,r,n,i);}addFeatures(t,e,r,n,i,a){for(const t of this.patternFeatures)this.addFeature(t,t.geometry,t.index,e,r,n,a);}isEmpty(){return 0===this.layoutVertexArray.length}uploadPending(){return !this.uploaded||this.programConfigurations.needsUpload}upload(t){this.uploaded||(0!==this.layoutVertexArray2.length&&(this.layoutVertexBuffer2=t.createVertexBuffer(this.layoutVertexArray2,Dd)),this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,Cd),this.indexBuffer=t.createIndexBuffer(this.indexArray)),this.programConfigurations.upload(t),this.uploaded=!0;}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy());}lineFeatureClips(t){if(t.properties&&t.properties.hasOwnProperty("mapbox_clip_start")&&t.properties.hasOwnProperty("mapbox_clip_end"))return {start:+t.properties.mapbox_clip_start,end:+t.properties.mapbox_clip_end}}addFeature(t,e,r,n,i,a,s){const o=this.layers[0].layout,l=o.get("line-join").evaluate(t,{}),u=o.get("line-cap").evaluate(t,{}),c=o.get("line-miter-limit"),h=o.get("line-round-limit");this.lineClips=this.lineFeatureClips(t);for(const r of e)this.addLine(r,t,l,u,c,h);this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,r,i,a,n,s);}addLine(t,e,r,n,i,a){if(this.distance=0,this.scaledDistance=0,this.totalDistance=0,this.lineSoFar=0,this.lineClips){this.lineClipsArray.push(this.lineClips);for(let e=0;e<t.length-1;e++)this.totalDistance+=t[e].dist(t[e+1]);this.updateScaledDistance(),this.maxLineLength=Math.max(this.maxLineLength,this.totalDistance);}const s="Polygon"===Ld[e.type];let o=t.length;for(;o>=2&&t[o-1].equals(t[o-2]);)o--;let l=0;for(;l<o-1&&t[l].equals(t[l+1]);)l++;if(o<(s?3:2))return;"bevel"===r&&(i=1.05);const u=this.overscaling<=16?15*Tr/(512*this.overscaling):0,c=this.segments.prepareSegment(10*o,this.layoutVertexArray,this.indexArray);let h,p,f,d,m;this.e1=this.e2=-1,s&&(h=t[o-2],m=t[l].sub(h)._unit()._perp());for(let e=l;e<o;e++){if(f=e===o-1?s?t[l+1]:void 0:t[e+1],f&&t[e].equals(f))continue;m&&(d=m),h&&(p=h),h=t[e],m=f?f.sub(h)._unit()._perp():d,d=d||m;let y=d.add(m);0===y.x&&0===y.y||y._unit();const g=d.x*m.x+d.y*m.y,x=y.x*m.x+y.y*m.y,v=0!==x?1/x:1/0,b=2*Math.sqrt(2-2*x),_=x<Fd&&p&&f,w=d.x*m.y-d.y*m.x>0;if(_&&e>l){const t=h.dist(p);if(t>2*u){const e=h.sub(h.sub(p)._mult(u/t)._round());this.updateDistance(p,e),this.addCurrentVertex(e,d,0,0,c),p=e;}}const M=p&&f;let A=M?r:s?"butt":n;if(M&&"round"===A&&(v<a?A="miter":v<=2&&(A="fakeround")),"miter"===A&&v>i&&(A="bevel"),"bevel"===A&&(v>2&&(A="flipbevel"),v<i&&(A="miter")),p&&this.updateDistance(p,h),"miter"===A)y._mult(v),this.addCurrentVertex(h,y,0,0,c);else if("flipbevel"===A){if(v>100)y=m.mult(-1);else {const t=v*d.add(m).mag()/d.sub(m).mag();y._perp()._mult(t*(w?-1:1));}this.addCurrentVertex(h,y,0,0,c),this.addCurrentVertex(h,y.mult(-1),0,0,c);}else if("bevel"===A||"fakeround"===A){const t=-Math.sqrt(v*v-1),e=w?t:0,r=w?0:t;if(p&&this.addCurrentVertex(h,d,e,r,c),"fakeround"===A){const t=Math.round(180*b/Math.PI/20);for(let e=1;e<t;e++){let r=e/t;if(.5!==r){const t=r-.5;r+=r*t*(r-1)*((1.0904+g*(g*(3.55645-1.43519*g)-3.2452))*t*t+(.848013+g*(.215638*g-1.06021)));}const n=m.sub(d)._mult(r)._add(d)._unit()._mult(w?-1:1);this.addHalfVertex(h,n.x,n.y,!1,w,0,c);}}f&&this.addCurrentVertex(h,m,-e,-r,c);}else if("butt"===A)this.addCurrentVertex(h,y,0,0,c);else if("square"===A){const t=p?1:-1;p||this.addCurrentVertex(h,y,t,t,c),this.addCurrentVertex(h,y,0,0,c),p&&this.addCurrentVertex(h,y,t,t,c);}else "round"===A&&(p&&(this.addCurrentVertex(h,d,0,0,c),this.addCurrentVertex(h,d,1,1,c,!0)),f&&(this.addCurrentVertex(h,m,-1,-1,c,!0),this.addCurrentVertex(h,m,0,0,c)));if(_&&e<o-1){const t=h.dist(f);if(t>2*u){const e=h.add(f.sub(h)._mult(u/t)._round());this.updateDistance(h,e),this.addCurrentVertex(e,m,0,0,c),h=e;}}}}addCurrentVertex(t,e,r,n,i,a=!1){const s=e.y*n-e.x,o=-e.y-e.x*n;this.addHalfVertex(t,e.x+e.y*r,e.y-e.x*r,a,!1,r,i),this.addHalfVertex(t,s,o,a,!0,-n,i);}addHalfVertex({x:t,y:e},r,n,i,a,s,o){this.layoutVertexArray.emplaceBack((t<<1)+(i?1:0),(e<<1)+(a?1:0),Math.round(63*r)+128,Math.round(63*n)+128,1+(0===s?0:s<0?-1:1),0,this.lineSoFar),this.lineClips&&this.layoutVertexArray2.emplaceBack(this.scaledDistance,this.lineClipsArray.length,this.lineClips.start,this.lineClips.end);const l=o.vertexLength++;this.e1>=0&&this.e2>=0&&(this.indexArray.emplaceBack(this.e1,this.e2,l),o.primitiveLength++),a?this.e2=l:this.e1=l;}updateScaledDistance(){if(this.lineClips){const t=this.totalDistance/(this.lineClips.end-this.lineClips.start);this.scaledDistance=this.distance/this.totalDistance,this.lineSoFar=t*this.lineClips.start+this.distance;}else this.lineSoFar=this.distance;}updateDistance(t,e){this.distance+=t.dist(e),this.updateScaledDistance();}}ra(Nd,"LineBucket",{omit:["layers","patternFeatures"]});const Od=new Oa({"line-cap":new Fa(qa.layout_line["line-cap"]),"line-join":new Fa(qa.layout_line["line-join"]),"line-miter-limit":new La(qa.layout_line["line-miter-limit"]),"line-round-limit":new La(qa.layout_line["line-round-limit"]),"line-sort-key":new Fa(qa.layout_line["line-sort-key"]),visibility:new La(qa.layout_line.visibility)});var Ud={paint:new Oa({"line-opacity":new Fa(qa.paint_line["line-opacity"]),"line-color":new Fa(qa.paint_line["line-color"]),"line-translate":new La(qa.paint_line["line-translate"]),"line-translate-anchor":new La(qa.paint_line["line-translate-anchor"]),"line-width":new Fa(qa.paint_line["line-width"]),"line-gap-width":new Fa(qa.paint_line["line-gap-width"]),"line-offset":new Fa(qa.paint_line["line-offset"]),"line-blur":new Fa(qa.paint_line["line-blur"]),"line-dasharray":new Fa(qa.paint_line["line-dasharray"]),"line-pattern":new Fa(qa.paint_line["line-pattern"]),"line-gradient":new Na(qa.paint_line["line-gradient"]),"line-trim-offset":new La(qa.paint_line["line-trim-offset"]),"line-emissive-strength":new La(qa.paint_line["line-emissive-strength"]),"line-border-width":new Fa(qa.paint_line["line-border-width"]),"line-border-color":new Fa(qa.paint_line["line-border-color"])}),layout:Od};function jd(t,e,r){return e*(Tr/(t.tileSize*Math.pow(2,r-t.tileID.overscaledZ)))}function qd(t,e){return 1/jd(t,1,e.tileZoom)}function $d(t,e,r,n){return t.translatePosMatrix(n||e.tileID.projMatrix,e,r.paint.get("line-translate"),r.paint.get("line-translate-anchor"))}const Gd=t=>{const e=[];Yd(t)&&e.push("RENDER_LINE_DASH"),t.paint.get("line-gradient")&&e.push("RENDER_LINE_GRADIENT");const r=t.paint.get("line-trim-offset");return 0===r[0]&&0===r[1]||e.push("RENDER_LINE_TRIM_OFFSET"),0!==t.paint.get("line-border-width").constantOr(1)&&e.push("RENDER_LINE_BORDER"),e};function Yd(t){const e=t.paint.get("line-dasharray").value;return e.value||"constant"!==e.kind}const Xd=new class extends Fa{possiblyEvaluate(t,e){return e=new Pa(Math.floor(e.zoom),{now:e.now,fadeDuration:e.fadeDuration,transition:e.transition}),super.possiblyEvaluate(t,e)}evaluate(t,e,r,n){return e=z({},e,{zoom:Math.floor(e.zoom)}),super.evaluate(t,e,r,n)}}(Ud.paint.properties["line-width"].specification);function Zd(t,e){return e>0?e+2*t:t}Xd.useIntegerZoom=!0;const Kd=cs([{name:"a_pos_offset",components:4,type:"Int16"},{name:"a_tex_size",components:4,type:"Uint16"},{name:"a_pixeloffset",components:4,type:"Int16"}],4),Hd=cs([{name:"a_globe_anchor",components:3,type:"Int16"},{name:"a_globe_normal",components:3,type:"Float32"}],4),Wd=cs([{name:"a_projected_pos",components:4,type:"Float32"}],4);cs([{name:"a_fade_opacity",components:1,type:"Uint32"}],4);const Jd=cs([{name:"a_z_offset",components:1,type:"Float32"}],4),Qd=cs([{name:"a_texb",components:2,type:"Uint16"}]),tm=cs([{name:"a_placed",components:2,type:"Uint8"},{name:"a_shift",components:2,type:"Float32"}]),em=cs([{name:"a_size_scale",components:1,type:"Float32"},{name:"a_padding",components:2,type:"Float32"},{name:"a_z_offset",components:1,type:"Float32"}]);cs([{type:"Int16",name:"projectedAnchorX"},{type:"Int16",name:"projectedAnchorY"},{type:"Int16",name:"projectedAnchorZ"},{type:"Int16",name:"tileAnchorX"},{type:"Int16",name:"tileAnchorY"},{type:"Float32",name:"x1"},{type:"Float32",name:"y1"},{type:"Float32",name:"x2"},{type:"Float32",name:"y2"},{type:"Int16",name:"padding"},{type:"Uint32",name:"featureIndex"},{type:"Uint16",name:"sourceLayerIndex"},{type:"Uint16",name:"bucketIndex"}]);const rm=cs([{name:"a_pos",components:3,type:"Int16"},{name:"a_anchor_pos",components:2,type:"Int16"},{name:"a_extrude",components:2,type:"Int16"}],4),nm=cs([{name:"a_pos_2f",components:2,type:"Float32"},{name:"a_radius",components:1,type:"Float32"},{name:"a_flags",components:2,type:"Int16"}],4);cs([{name:"triangle",components:3,type:"Uint16"}]),cs([{type:"Int16",name:"projectedAnchorX"},{type:"Int16",name:"projectedAnchorY"},{type:"Int16",name:"projectedAnchorZ"},{type:"Float32",name:"tileAnchorX"},{type:"Float32",name:"tileAnchorY"},{type:"Uint16",name:"glyphStartIndex"},{type:"Uint16",name:"numGlyphs"},{type:"Uint32",name:"vertexStartIndex"},{type:"Uint32",name:"lineStartIndex"},{type:"Uint32",name:"lineLength"},{type:"Uint16",name:"segment"},{type:"Uint16",name:"lowerSize"},{type:"Uint16",name:"upperSize"},{type:"Float32",name:"lineOffsetX"},{type:"Float32",name:"lineOffsetY"},{type:"Uint8",name:"writingMode"},{type:"Uint8",name:"placedOrientation"},{type:"Uint8",name:"hidden"},{type:"Uint32",name:"crossTileID"},{type:"Int16",name:"associatedIconIndex"},{type:"Uint8",name:"flipState"}]),cs([{type:"Float32",name:"tileAnchorX"},{type:"Float32",name:"tileAnchorY"},{type:"Int16",name:"projectedAnchorX"},{type:"Int16",name:"projectedAnchorY"},{type:"Int16",name:"projectedAnchorZ"},{type:"Int16",name:"rightJustifiedTextSymbolIndex"},{type:"Int16",name:"centerJustifiedTextSymbolIndex"},{type:"Int16",name:"leftJustifiedTextSymbolIndex"},{type:"Int16",name:"verticalPlacedTextSymbolIndex"},{type:"Int16",name:"placedIconSymbolIndex"},{type:"Int16",name:"verticalPlacedIconSymbolIndex"},{type:"Uint16",name:"key"},{type:"Uint16",name:"textBoxStartIndex"},{type:"Uint16",name:"textBoxEndIndex"},{type:"Uint16",name:"verticalTextBoxStartIndex"},{type:"Uint16",name:"verticalTextBoxEndIndex"},{type:"Uint16",name:"iconBoxStartIndex"},{type:"Uint16",name:"iconBoxEndIndex"},{type:"Uint16",name:"verticalIconBoxStartIndex"},{type:"Uint16",name:"verticalIconBoxEndIndex"},{type:"Uint16",name:"featureIndex"},{type:"Uint16",name:"numHorizontalGlyphVertices"},{type:"Uint16",name:"numVerticalGlyphVertices"},{type:"Uint16",name:"numIconVertices"},{type:"Uint16",name:"numVerticalIconVertices"},{type:"Uint16",name:"useRuntimeCollisionCircles"},{type:"Uint32",name:"crossTileID"},{type:"Float32",components:2,name:"textOffset"},{type:"Float32",name:"collisionCircleDiameter"},{type:"Float32",name:"zOffset"},{type:"Uint8",name:"hasIconTextFit"}]),cs([{type:"Float32",name:"offsetX"}]),cs([{type:"Int16",name:"x"},{type:"Int16",name:"y"}]);var im=24;const am=128;function sm(t,e){const{expression:r}=e;if("constant"===r.kind)return {kind:"constant",layoutSize:r.evaluate(new Pa(t+1))};if("source"===r.kind)return {kind:"source"};{const{zoomStops:e,interpolationType:n}=r;let i=0;for(;i<e.length&&e[i]<=t;)i++;i=Math.max(0,i-1);let a=i;for(;a<e.length&&e[a]<t+1;)a++;a=Math.min(e.length-1,a);const s=e[i],o=e[a];return "composite"===r.kind?{kind:"composite",minZoom:s,maxZoom:o,interpolationType:n}:{kind:"camera",minZoom:s,maxZoom:o,minSize:r.evaluate(new Pa(s)),maxSize:r.evaluate(new Pa(o)),interpolationType:n}}}function om(t,{uSize:e,uSizeT:r},{lowerSize:n,upperSize:i}){return "source"===t.kind?n/am:"composite"===t.kind?ue(n/am,i/am,r):e}function lm(t,e){let r=0,n=0;if("constant"===t.kind)n=t.layoutSize;else if("source"!==t.kind){const{interpolationType:i,minZoom:a,maxZoom:s}=t,o=i?I(Yn.interpolationFactor(i,e,a,s),0,1):0;"camera"===t.kind?n=ue(t.minSize,t.maxSize,o):r=o;}return {uSizeT:r,uSize:n}}var um=Object.freeze({__proto__:null,SIZE_PACK_FACTOR:am,evaluateSizeForFeature:om,evaluateSizeForZoom:lm,getSizeData:sm});function cm(t,e,r){return t.sections.forEach((t=>{t.text=function(t,e,r){const n=e.layout.get("text-transform").evaluate(r,{});return "uppercase"===n?t=t.toLocaleUpperCase():"lowercase"===n&&(t=t.toLocaleLowerCase()),ka.applyArabicShaping&&(t=ka.applyArabicShaping(t)),t}(t.text,e,r);})),t}const hm={"!":"︕","#":"＃",$:"＄","%":"％","&":"＆","(":"︵",")":"︶","*":"＊","+":"＋",",":"︐","-":"︲",".":"・","/":"／",":":"︓",";":"︔","<":"︿","=":"＝",">":"﹀","?":"︖","@":"＠","[":"﹇","\\":"＼","]":"﹈","^":"＾",_:"︳","`":"｀","{":"︷","|":"―","}":"︸","~":"～","¢":"￠","£":"￡","¥":"￥","¦":"￤","¬":"￢","¯":"￣","–":"︲","—":"︱","‘":"﹃","’":"﹄","“":"﹁","”":"﹂","…":"︙","‧":"・","₩":"￦","、":"︑","。":"︒","〈":"︿","〉":"﹀","《":"︽","》":"︾","「":"﹁","」":"﹂","『":"﹃","』":"﹄","【":"︻","】":"︼","〔":"︹","〕":"︺","〖":"︗","〗":"︘","！":"︕","（":"︵","）":"︶","，":"︐","－":"︲","．":"・","：":"︓","；":"︔","＜":"︿","＞":"﹀","？":"︖","［":"﹇","］":"﹈","＿":"︳","｛":"︷","｜":"―","｝":"︸","｟":"︵","｠":"︶","｡":"︒","｢":"﹁","｣":"﹂","←":"↑","→":"↓"};function pm(t){return "︶"===t||"﹈"===t||"︸"===t||"﹄"===t||"﹂"===t||"︾"===t||"︼"===t||"︺"===t||"︘"===t||"﹀"===t||"︐"===t||"︓"===t||"︔"===t||"｀"===t||"￣"===t||"︑"===t||"︒"===t}function fm(t){return "︵"===t||"﹇"===t||"︷"===t||"﹃"===t||"﹁"===t||"︽"===t||"︻"===t||"︹"===t||"︗"===t||"︿"===t}var dm={
/*! ieee754. BSD-3-Clause License. Feross Aboukhadijeh <https://feross.org/opensource> */
read:function(t,e,r,n,i){var a,s,o=8*i-n-1,l=(1<<o)-1,u=l>>1,c=-7,h=r?i-1:0,p=r?-1:1,f=t[e+h];for(h+=p,a=f&(1<<-c)-1,f>>=-c,c+=o;c>0;a=256*a+t[e+h],h+=p,c-=8);for(s=a&(1<<-c)-1,a>>=-c,c+=n;c>0;s=256*s+t[e+h],h+=p,c-=8);if(0===a)a=1-u;else {if(a===l)return s?NaN:1/0*(f?-1:1);s+=Math.pow(2,n),a-=u;}return (f?-1:1)*s*Math.pow(2,a-n)},write:function(t,e,r,n,i,a){var s,o,l,u=8*a-i-1,c=(1<<u)-1,h=c>>1,p=23===i?Math.pow(2,-24)-Math.pow(2,-77):0,f=n?0:a-1,d=n?1:-1,m=e<0||0===e&&1/e<0?1:0;for(e=Math.abs(e),isNaN(e)||e===1/0?(o=isNaN(e)?1:0,s=c):(s=Math.floor(Math.log(e)/Math.LN2),e*(l=Math.pow(2,-s))<1&&(s--,l*=2),(e+=s+h>=1?p/l:p*Math.pow(2,1-h))*l>=2&&(s++,l/=2),s+h>=c?(o=0,s=c):s+h>=1?(o=(e*l-1)*Math.pow(2,i),s+=h):(o=e*Math.pow(2,h-1)*Math.pow(2,i),s=0));i>=8;t[r+f]=255&o,f+=d,o/=256,i-=8);for(s=s<<i|o,u+=i;u>0;t[r+f]=255&s,f+=d,s/=256,u-=8);t[r+f-d]|=128*m;}},mm=gm,ym=dm;function gm(t){this.buf=ArrayBuffer.isView&&ArrayBuffer.isView(t)?t:new Uint8Array(t||0),this.pos=0,this.type=0,this.length=this.buf.length;}gm.Varint=0,gm.Fixed64=1,gm.Bytes=2,gm.Fixed32=5;var xm=4294967296,vm=1/xm,bm="undefined"==typeof TextDecoder?null:new TextDecoder("utf8");function _m(t){return t.type===gm.Bytes?t.readVarint()+t.pos:t.pos+1}function wm(t,e,r){return r?4294967296*e+(t>>>0):4294967296*(e>>>0)+(t>>>0)}function Mm(t,e,r){var n=e<=16383?1:e<=2097151?2:e<=268435455?3:Math.floor(Math.log(e)/(7*Math.LN2));r.realloc(n);for(var i=r.pos-1;i>=t;i--)r.buf[i+n]=r.buf[i];}function Am(t,e){for(var r=0;r<t.length;r++)e.writeVarint(t[r]);}function Sm(t,e){for(var r=0;r<t.length;r++)e.writeSVarint(t[r]);}function Im(t,e){for(var r=0;r<t.length;r++)e.writeFloat(t[r]);}function km(t,e){for(var r=0;r<t.length;r++)e.writeDouble(t[r]);}function Pm(t,e){for(var r=0;r<t.length;r++)e.writeBoolean(t[r]);}function Em(t,e){for(var r=0;r<t.length;r++)e.writeFixed32(t[r]);}function zm(t,e){for(var r=0;r<t.length;r++)e.writeSFixed32(t[r]);}function Tm(t,e){for(var r=0;r<t.length;r++)e.writeFixed64(t[r]);}function Bm(t,e){for(var r=0;r<t.length;r++)e.writeSFixed64(t[r]);}function Cm(t,e){return (t[e]|t[e+1]<<8|t[e+2]<<16)+16777216*t[e+3]}function Rm(t,e,r){t[r]=e,t[r+1]=e>>>8,t[r+2]=e>>>16,t[r+3]=e>>>24;}function Dm(t,e){return (t[e]|t[e+1]<<8|t[e+2]<<16)+(t[e+3]<<24)}gm.prototype={destroy:function(){this.buf=null;},readFields:function(t,e,r){for(r=r||this.length;this.pos<r;){var n=this.readVarint(),i=n>>3,a=this.pos;this.type=7&n,t(i,e,this),this.pos===a&&this.skip(n);}return e},readMessage:function(t,e){return this.readFields(t,e,this.readVarint()+this.pos)},readFixed32:function(){var t=Cm(this.buf,this.pos);return this.pos+=4,t},readSFixed32:function(){var t=Dm(this.buf,this.pos);return this.pos+=4,t},readFixed64:function(){var t=Cm(this.buf,this.pos)+Cm(this.buf,this.pos+4)*xm;return this.pos+=8,t},readSFixed64:function(){var t=Cm(this.buf,this.pos)+Dm(this.buf,this.pos+4)*xm;return this.pos+=8,t},readFloat:function(){var t=ym.read(this.buf,this.pos,!0,23,4);return this.pos+=4,t},readDouble:function(){var t=ym.read(this.buf,this.pos,!0,52,8);return this.pos+=8,t},readVarint:function(t){var e,r,n=this.buf;return e=127&(r=n[this.pos++]),r<128?e:(e|=(127&(r=n[this.pos++]))<<7,r<128?e:(e|=(127&(r=n[this.pos++]))<<14,r<128?e:(e|=(127&(r=n[this.pos++]))<<21,r<128?e:function(t,e,r){var n,i,a=r.buf;if(n=(112&(i=a[r.pos++]))>>4,i<128)return wm(t,n,e);if(n|=(127&(i=a[r.pos++]))<<3,i<128)return wm(t,n,e);if(n|=(127&(i=a[r.pos++]))<<10,i<128)return wm(t,n,e);if(n|=(127&(i=a[r.pos++]))<<17,i<128)return wm(t,n,e);if(n|=(127&(i=a[r.pos++]))<<24,i<128)return wm(t,n,e);if(n|=(1&(i=a[r.pos++]))<<31,i<128)return wm(t,n,e);throw new Error("Expected varint not more than 10 bytes")}(e|=(15&(r=n[this.pos]))<<28,t,this))))},readVarint64:function(){return this.readVarint(!0)},readSVarint:function(){var t=this.readVarint();return t%2==1?(t+1)/-2:t/2},readBoolean:function(){return Boolean(this.readVarint())},readString:function(){var t=this.readVarint()+this.pos,e=this.pos;return this.pos=t,t-e>=12&&bm?function(t,e,r){return bm.decode(t.subarray(e,r))}(this.buf,e,t):function(t,e,r){for(var n="",i=e;i<r;){var a,s,o,l=t[i],u=null,c=l>239?4:l>223?3:l>191?2:1;if(i+c>r)break;1===c?l<128&&(u=l):2===c?128==(192&(a=t[i+1]))&&(u=(31&l)<<6|63&a)<=127&&(u=null):3===c?(s=t[i+2],128==(192&(a=t[i+1]))&&128==(192&s)&&((u=(15&l)<<12|(63&a)<<6|63&s)<=2047||u>=55296&&u<=57343)&&(u=null)):4===c&&(s=t[i+2],o=t[i+3],128==(192&(a=t[i+1]))&&128==(192&s)&&128==(192&o)&&((u=(15&l)<<18|(63&a)<<12|(63&s)<<6|63&o)<=65535||u>=1114112)&&(u=null)),null===u?(u=65533,c=1):u>65535&&(u-=65536,n+=String.fromCharCode(u>>>10&1023|55296),u=56320|1023&u),n+=String.fromCharCode(u),i+=c;}return n}(this.buf,e,t)},readBytes:function(){var t=this.readVarint()+this.pos,e=this.buf.subarray(this.pos,t);return this.pos=t,e},readPackedVarint:function(t,e){if(this.type!==gm.Bytes)return t.push(this.readVarint(e));var r=_m(this);for(t=t||[];this.pos<r;)t.push(this.readVarint(e));return t},readPackedSVarint:function(t){if(this.type!==gm.Bytes)return t.push(this.readSVarint());var e=_m(this);for(t=t||[];this.pos<e;)t.push(this.readSVarint());return t},readPackedBoolean:function(t){if(this.type!==gm.Bytes)return t.push(this.readBoolean());var e=_m(this);for(t=t||[];this.pos<e;)t.push(this.readBoolean());return t},readPackedFloat:function(t){if(this.type!==gm.Bytes)return t.push(this.readFloat());var e=_m(this);for(t=t||[];this.pos<e;)t.push(this.readFloat());return t},readPackedDouble:function(t){if(this.type!==gm.Bytes)return t.push(this.readDouble());var e=_m(this);for(t=t||[];this.pos<e;)t.push(this.readDouble());return t},readPackedFixed32:function(t){if(this.type!==gm.Bytes)return t.push(this.readFixed32());var e=_m(this);for(t=t||[];this.pos<e;)t.push(this.readFixed32());return t},readPackedSFixed32:function(t){if(this.type!==gm.Bytes)return t.push(this.readSFixed32());var e=_m(this);for(t=t||[];this.pos<e;)t.push(this.readSFixed32());return t},readPackedFixed64:function(t){if(this.type!==gm.Bytes)return t.push(this.readFixed64());var e=_m(this);for(t=t||[];this.pos<e;)t.push(this.readFixed64());return t},readPackedSFixed64:function(t){if(this.type!==gm.Bytes)return t.push(this.readSFixed64());var e=_m(this);for(t=t||[];this.pos<e;)t.push(this.readSFixed64());return t},skip:function(t){var e=7&t;if(e===gm.Varint)for(;this.buf[this.pos++]>127;);else if(e===gm.Bytes)this.pos=this.readVarint()+this.pos;else if(e===gm.Fixed32)this.pos+=4;else {if(e!==gm.Fixed64)throw new Error("Unimplemented type: "+e);this.pos+=8;}},writeTag:function(t,e){this.writeVarint(t<<3|e);},realloc:function(t){for(var e=this.length||16;e<this.pos+t;)e*=2;if(e!==this.length){var r=new Uint8Array(e);r.set(this.buf),this.buf=r,this.length=e;}},finish:function(){return this.length=this.pos,this.pos=0,this.buf.subarray(0,this.length)},writeFixed32:function(t){this.realloc(4),Rm(this.buf,t,this.pos),this.pos+=4;},writeSFixed32:function(t){this.realloc(4),Rm(this.buf,t,this.pos),this.pos+=4;},writeFixed64:function(t){this.realloc(8),Rm(this.buf,-1&t,this.pos),Rm(this.buf,Math.floor(t*vm),this.pos+4),this.pos+=8;},writeSFixed64:function(t){this.realloc(8),Rm(this.buf,-1&t,this.pos),Rm(this.buf,Math.floor(t*vm),this.pos+4),this.pos+=8;},writeVarint:function(t){(t=+t||0)>268435455||t<0?function(t,e){var r,n;if(t>=0?(r=t%4294967296|0,n=t/4294967296|0):(n=~(-t/4294967296),4294967295^(r=~(-t%4294967296))?r=r+1|0:(r=0,n=n+1|0)),t>=0x10000000000000000||t<-0x10000000000000000)throw new Error("Given varint doesn't fit into 10 bytes");e.realloc(10),function(t,e,r){r.buf[r.pos++]=127&t|128,t>>>=7,r.buf[r.pos++]=127&t|128,t>>>=7,r.buf[r.pos++]=127&t|128,t>>>=7,r.buf[r.pos++]=127&t|128,r.buf[r.pos]=127&(t>>>=7);}(r,0,e),function(t,e){var r=(7&t)<<4;e.buf[e.pos++]|=r|((t>>>=3)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t)))));}(n,e);}(t,this):(this.realloc(4),this.buf[this.pos++]=127&t|(t>127?128:0),t<=127||(this.buf[this.pos++]=127&(t>>>=7)|(t>127?128:0),t<=127||(this.buf[this.pos++]=127&(t>>>=7)|(t>127?128:0),t<=127||(this.buf[this.pos++]=t>>>7&127))));},writeSVarint:function(t){this.writeVarint(t<0?2*-t-1:2*t);},writeBoolean:function(t){this.writeVarint(Boolean(t));},writeString:function(t){t=String(t),this.realloc(4*t.length),this.pos++;var e=this.pos;this.pos=function(t,e,r){for(var n,i,a=0;a<e.length;a++){if((n=e.charCodeAt(a))>55295&&n<57344){if(!i){n>56319||a+1===e.length?(t[r++]=239,t[r++]=191,t[r++]=189):i=n;continue}if(n<56320){t[r++]=239,t[r++]=191,t[r++]=189,i=n;continue}n=i-55296<<10|n-56320|65536,i=null;}else i&&(t[r++]=239,t[r++]=191,t[r++]=189,i=null);n<128?t[r++]=n:(n<2048?t[r++]=n>>6|192:(n<65536?t[r++]=n>>12|224:(t[r++]=n>>18|240,t[r++]=n>>12&63|128),t[r++]=n>>6&63|128),t[r++]=63&n|128);}return r}(this.buf,t,this.pos);var r=this.pos-e;r>=128&&Mm(e,r,this),this.pos=e-1,this.writeVarint(r),this.pos+=r;},writeFloat:function(t){this.realloc(4),ym.write(this.buf,t,this.pos,!0,23,4),this.pos+=4;},writeDouble:function(t){this.realloc(8),ym.write(this.buf,t,this.pos,!0,52,8),this.pos+=8;},writeBytes:function(t){var e=t.length;this.writeVarint(e),this.realloc(e);for(var r=0;r<e;r++)this.buf[this.pos++]=t[r];},writeRawMessage:function(t,e){this.pos++;var r=this.pos;t(e,this);var n=this.pos-r;n>=128&&Mm(r,n,this),this.pos=r-1,this.writeVarint(n),this.pos+=n;},writeMessage:function(t,e,r){this.writeTag(t,gm.Bytes),this.writeRawMessage(e,r);},writePackedVarint:function(t,e){e.length&&this.writeMessage(t,Am,e);},writePackedSVarint:function(t,e){e.length&&this.writeMessage(t,Sm,e);},writePackedBoolean:function(t,e){e.length&&this.writeMessage(t,Pm,e);},writePackedFloat:function(t,e){e.length&&this.writeMessage(t,Im,e);},writePackedDouble:function(t,e){e.length&&this.writeMessage(t,km,e);},writePackedFixed32:function(t,e){e.length&&this.writeMessage(t,Em,e);},writePackedSFixed32:function(t,e){e.length&&this.writeMessage(t,zm,e);},writePackedFixed64:function(t,e){e.length&&this.writeMessage(t,Tm,e);},writePackedSFixed64:function(t,e){e.length&&this.writeMessage(t,Bm,e);},writeBytesField:function(t,e){this.writeTag(t,gm.Bytes),this.writeBytes(e);},writeFixed32Field:function(t,e){this.writeTag(t,gm.Fixed32),this.writeFixed32(e);},writeSFixed32Field:function(t,e){this.writeTag(t,gm.Fixed32),this.writeSFixed32(e);},writeFixed64Field:function(t,e){this.writeTag(t,gm.Fixed64),this.writeFixed64(e);},writeSFixed64Field:function(t,e){this.writeTag(t,gm.Fixed64),this.writeSFixed64(e);},writeVarintField:function(t,e){this.writeTag(t,gm.Varint),this.writeVarint(e);},writeSVarintField:function(t,e){this.writeTag(t,gm.Varint),this.writeSVarint(e);},writeStringField:function(t,e){this.writeTag(t,gm.Bytes),this.writeString(e);},writeFloatField:function(t,e){this.writeTag(t,gm.Fixed32),this.writeFloat(e);},writeDoubleField:function(t,e){this.writeTag(t,gm.Fixed64),this.writeDouble(e);},writeBooleanField:function(t,e){this.writeVarintField(t,Boolean(e));}};var Vm=h(mm);const Lm=3;function Fm(t,e,r){e.glyphs=[],1===t&&r.readMessage(Nm,e);}function Nm(t,e,r){if(3===t){const{id:t,bitmap:n,width:i,height:a,left:s,top:o,advance:l}=r.readMessage(Om,{});e.glyphs.push({id:t,bitmap:new vp({width:i+2*Lm,height:a+2*Lm},n),metrics:{width:i,height:a,left:s,top:o,advance:l}});}else 4===t?e.ascender=r.readSVarint():5===t&&(e.descender=r.readSVarint());}function Om(t,e,r){1===t?e.id=r.readVarint():2===t?e.bitmap=r.readBytes():3===t?e.width=r.readVarint():4===t?e.height=r.readVarint():5===t?e.left=r.readSVarint():6===t?e.top=r.readSVarint():7===t&&(e.advance=r.readVarint());}const Um=Lm,jm={horizontal:1,vertical:2,horizontalOnly:3};class qm{constructor(){this.scale=1,this.fontStack="",this.imageName=null;}static forText(t,e){const r=new qm;return r.scale=t||1,r.fontStack=e,r}static forImage(t){const e=new qm;return e.imageName=t,e}}class $m{constructor(){this.text="",this.sectionIndex=[],this.sections=[],this.imageSectionID=null;}static fromFeature(t,e){const r=new $m;for(let n=0;n<t.sections.length;n++){const i=t.sections[n];i.image?r.addImageSection(i):r.addTextSection(i,e);}return r}length(){return this.text.length}getSection(t){return this.sections[this.sectionIndex[t]]}getSections(){return this.sections}getSectionIndex(t){return this.sectionIndex[t]}getCodePoint(t){return this.text.codePointAt(t)}verticalizePunctuation(t){this.text=function(t,e){let r="";for(let n=0;n<t.length;n++){const i=t.charCodeAt(n+1)||null,a=t.charCodeAt(n-1)||null;r+=!e&&(i&&pa(i)&&!hm[t[n+1]]||a&&pa(a)&&!hm[t[n-1]])||!hm[t[n]]?t[n]:hm[t[n]];}return r}(this.text,t);}trim(){let t=0;for(let e=0;e<this.text.length&&Ym[this.text.charCodeAt(e)];e++)t++;let e=this.text.length;for(let r=this.text.length-1;r>=0&&r>=t&&Ym[this.text.charCodeAt(r)];r--)e--;this.text=this.text.substring(t,e),this.sectionIndex=this.sectionIndex.slice(t,e);}substring(t,e){const r=new $m;return r.text=this.text.substring(t,e),r.sectionIndex=this.sectionIndex.slice(t,e),r.sections=this.sections,r}toString(){return this.text}getMaxScale(){return this.sectionIndex.reduce(((t,e)=>Math.max(t,this.sections[e].scale)),0)}addTextSection(t,e){this.text+=t.text,this.sections.push(qm.forText(t.scale,t.fontStack||e));const r=this.sections.length-1;for(let e=0;e<t.text.length;++e)this.sectionIndex.push(r);}addImageSection(t){const e=t.image?t.image.namePrimary:"";if(0===e.length)return void j("Can't add FormattedSection with an empty image.");const r=this.getNextImageSectionCharCode();r?(this.text+=String.fromCodePoint(r),this.sections.push(qm.forImage(e)),this.sectionIndex.push(this.sections.length-1)):j("Reached maximum number of images 6401");}getNextImageSectionCharCode(){return this.imageSectionID?this.imageSectionID>=63743?null:++this.imageSectionID:(this.imageSectionID=57344,this.imageSectionID)}}function Gm(t,e,r,n,i,a,s,o,l,u,c,h,p,f,d){const m=$m.fromFeature(t,i);h===jm.vertical&&m.verticalizePunctuation(p);let y=[];const g=function(t,e,r,n,i,a){if(!t)return [];const s=[],o=function(t,e,r,n,i,a){let s=0;for(let r=0;r<t.length();r++){const o=t.getSection(r);s+=Zm(t.getCodePoint(r),o,n,i,e,a);}return s/Math.max(1,Math.ceil(s/r))}(t,e,r,n,i,a),l=t.text.indexOf("​")>=0;let u=0;for(let r=0;r<t.length();r++){const h=t.getSection(r),p=t.getCodePoint(r);if(Ym[p]||(u+=Zm(p,h,n,i,e,a)),r<t.length()-1){const e=!((c=p)<11904||!(oa["Bopomofo Extended"](c)||oa.Bopomofo(c)||oa["CJK Compatibility Forms"](c)||oa["CJK Compatibility Ideographs"](c)||oa["CJK Compatibility"](c)||oa["CJK Radicals Supplement"](c)||oa["CJK Strokes"](c)||oa["CJK Symbols and Punctuation"](c)||oa["CJK Unified Ideographs Extension A"](c)||oa["CJK Unified Ideographs"](c)||oa["Enclosed CJK Letters and Months"](c)||oa["Halfwidth and Fullwidth Forms"](c)||oa.Hiragana(c)||oa["Ideographic Description Characters"](c)||oa["Kangxi Radicals"](c)||oa["Katakana Phonetic Extensions"](c)||oa.Katakana(c)||oa["Vertical Forms"](c)||oa["Yi Radicals"](c)||oa["Yi Syllables"](c)));(Xm[p]||e||h.imageName)&&s.push(Wm(r+1,u,o,s,Hm(p,t.getCodePoint(r+1),e&&l),!1));}}var c;return Jm(Wm(t.length(),u,o,s,0,!0))}(m,u,a,e,n,f),{processBidirectionalText:x,processStyledBidirectionalText:v}=ka;if(x&&1===m.sections.length){const t=x(m.toString(),g);for(const e of t){const t=new $m;t.text=e,t.sections=m.sections;for(let r=0;r<e.length;r++)t.sectionIndex.push(0);y.push(t);}}else if(v){const t=v(m.text,m.sectionIndex,g);for(const e of t){const t=new $m;t.text=e[0],t.sectionIndex=e[1],t.sections=m.sections,y.push(t);}}else y=function(t,e){const r=[],n=t.text;let i=0;for(const n of e)r.push(t.substring(i,n)),i=n;return i<n.length&&r.push(t.substring(i,n.length)),r}(m,g);const b=[],_={positionedLines:b,text:m.toString(),top:c[1],bottom:c[1],left:c[0],right:c[0],writingMode:h,iconsInText:!1,verticalizable:!1,hasBaseline:!1};return function(t,e,r,n,i,a,s,o,l,u,c,h){let p=0,f=0,d=0;const m="right"===o?1:"left"===o?0:.5;let y=!1;for(const t of i){const r=t.getSections();for(const t of r){if(t.imageName)continue;const r=e[t.fontStack];if(r&&(y=void 0!==r.ascender&&void 0!==r.descender,!y))break}if(!y)break}let g=0;for(const s of i){s.trim();const i=s.getMaxScale(),o=(i-1)*im,v={positionedGlyphs:[],lineOffset:0};t.positionedLines[g]=v;const b=v.positionedGlyphs;let _=0;if(!s.length()){f+=a,++g;continue}let w=0,M=0;for(let a=0;a<s.length();a++){const o=s.getSection(a),d=s.getSectionIndex(a),m=s.getCodePoint(a);let g=o.scale,v=null,A=null,S=null,I=im,k=0;const P=!(l===jm.horizontal||!c&&!ha(m)||c&&(Ym[m]||(x=m,oa.Arabic(x)||oa["Arabic Supplement"](x)||oa["Arabic Extended-A"](x)||oa["Arabic Presentation Forms-A"](x)||oa["Arabic Presentation Forms-B"](x))));if(o.imageName){const e=n[o.imageName];if(!e)continue;S=o.imageName,t.iconsInText=t.iconsInText||!0,A=e.paddedRect;const r=e.displaySize;g=g*im/h,v={width:r[0],height:r[1],left:0,top:-Um,advance:P?r[1]:r[0],localGlyph:!1},k=y?-v.height*g:i*im-17-r[1]*g,I=v.advance;const a=(P?r[0]:r[1])*g-im*i;a>0&&a>_&&(_=a);}else {const t=r[o.fontStack];if(!t)continue;t[m]&&(A=t[m]);const n=e[o.fontStack];if(!n)continue;const a=n.glyphs[m];if(!a)continue;if(v=a.metrics,I=8203!==m?im:0,y){const t=void 0!==n.ascender?Math.abs(n.ascender):0,e=void 0!==n.descender?Math.abs(n.descender):0,r=(t+e)*g;w<r&&(w=r,M=(t-e)/2*g),k=-t*g;}else k=(i-g)*im-17;}P?(t.verticalizable=!0,b.push({glyph:m,imageName:S,x:p,y:f+k,vertical:P,scale:g,localGlyph:v.localGlyph,fontStack:o.fontStack,sectionIndex:d,metrics:v,rect:A}),p+=I*g+u):(b.push({glyph:m,imageName:S,x:p,y:f+k,vertical:P,scale:g,localGlyph:v.localGlyph,fontStack:o.fontStack,sectionIndex:d,metrics:v,rect:A}),p+=v.advance*g+u);}0!==b.length&&(d=Math.max(p-u,d),y?ty(b,m,_,M,a*i/2):ty(b,m,_,0,a/2)),p=0;const A=a*i+_;v.lineOffset=Math.max(_,o),f+=A,++g;}var x;const v=f,{horizontalAlign:b,verticalAlign:_}=Qm(s);((function(t,e,r,n,i,a){const s=(e-r)*i,o=-a*n;for(const e of t)for(const t of e.positionedGlyphs)t.x+=s,t.y+=o;}))(t.positionedLines,m,b,_,d,v),t.top+=-_*v,t.bottom=t.top+v,t.left+=-b*d,t.right=t.left+d,t.hasBaseline=y;}(_,e,r,n,y,s,o,l,h,u,p,d),!function(t){for(const e of t)if(0!==e.positionedGlyphs.length)return !1;return !0}(b)&&_}const Ym={9:!0,10:!0,11:!0,12:!0,13:!0,32:!0},Xm={10:!0,32:!0,38:!0,40:!0,41:!0,43:!0,45:!0,47:!0,173:!0,183:!0,8203:!0,8208:!0,8211:!0,8231:!0};function Zm(t,e,r,n,i,a){if(e.imageName){const t=n[e.imageName];return t?t.displaySize[0]*e.scale*im/a+i:0}{const n=r[e.fontStack],a=n&&n.glyphs[t];return a?a.metrics.advance*e.scale+i:0}}function Km(t,e,r,n){const i=Math.pow(t-e,2);return n?t<e?i/2:2*i:i+Math.abs(r)*r}function Hm(t,e,r){let n=0;return 10===t&&(n-=1e4),r&&(n+=150),40!==t&&65288!==t||(n+=50),41!==e&&65289!==e||(n+=50),n}function Wm(t,e,r,n,i,a){let s=null,o=Km(e,r,i,a);for(const t of n){const n=Km(e-t.x,r,i,a)+t.badness;n<=o&&(s=t,o=n);}return {index:t,x:e,priorBreak:s,badness:o}}function Jm(t){return t?Jm(t.priorBreak).concat(t.index):[]}function Qm(t){let e=.5,r=.5;switch(t){case"right":case"top-right":case"bottom-right":e=1;break;case"left":case"top-left":case"bottom-left":e=0;}switch(t){case"bottom":case"bottom-right":case"bottom-left":r=1;break;case"top":case"top-right":case"top-left":r=0;}return {horizontalAlign:e,verticalAlign:r}}function ty(t,e,r,n,i){if(!(e||r||n||i))return;const a=t.length-1,s=t[a],o=(s.x+s.metrics.advance*s.scale)*e;for(let e=0;e<=a;e++)t[e].x-=o,t[e].y+=r+n+i;}function ey(t,e,r,n){const{horizontalAlign:i,verticalAlign:a}=Qm(n),s=r[0]-t.displaySize[0]*i,o=r[1]-t.displaySize[1]*a;return {imagePrimary:t,imageSecondary:e,top:o,bottom:o+t.displaySize[1],left:s,right:s+t.displaySize[0]}}function ry(t,e,r,n,i,a){const s=t.imagePrimary;let o;if(s.content){const t=s.content,e=s.pixelRatio||1;o=[t[0]/e,t[1]/e,s.displaySize[0]-t[2]/e,s.displaySize[1]-t[3]/e];}const l=e.left*a,u=e.right*a;let c,h,p,f;"width"===r||"both"===r?(f=i[0]+l-n[3],h=i[0]+u+n[1]):(f=i[0]+(l+u-s.displaySize[0])/2,h=f+s.displaySize[0]);const d=e.top*a,m=e.bottom*a;return "height"===r||"both"===r?(c=i[1]+d-n[0],p=i[1]+m+n[2]):(c=i[1]+(d+m-s.displaySize[1])/2,p=c+s.displaySize[1]),{imagePrimary:s,imageSecondary:void 0,top:c,right:h,bottom:p,left:f,collisionPadding:o}}class ny extends g{constructor(t,e,r,n,i){super(t,e),this.angle=n,this.z=r,void 0!==i&&(this.segment=i);}clone(){return new ny(this.x,this.y,this.z,this.angle,this.segment)}}function iy(t,e,r,n,i){if(void 0===e.segment)return !0;let a=e,s=e.segment+1,o=0;for(;o>-r/2;){if(s--,s<0)return !1;o-=t[s].dist(a),a=t[s];}o+=t[s].dist(t[s+1]),s++;const l=[];let u=0;for(;o<r/2;){const e=t[s],r=t[s+1];if(!r)return !1;let a=t[s-1].angleTo(e)-e.angleTo(r);for(a=Math.abs((a+3*Math.PI)%(2*Math.PI)-Math.PI),l.push({distance:o,angleDelta:a}),u+=a;o-l[0].distance>n;)u-=l.shift().angleDelta;if(u>i)return !1;s++,o+=e.dist(r);}return !0}function ay(t){let e=0;for(let r=0;r<t.length-1;r++)e+=t[r].dist(t[r+1]);return e}function sy(t,e,r){return t?.6*e*r:0}function oy(t,e){return Math.max(t?t.right-t.left:0,e?e.right-e.left:0)}function ly(t,e,r,n,i,a){const s=sy(r,i,a),o=oy(r,n)*a;let l=0;const u=ay(t)/2;for(let r=0;r<t.length-1;r++){const n=t[r],i=t[r+1],a=n.dist(i);if(l+a>u){const c=(u-l)/a,h=ue(n.x,i.x,c),p=ue(n.y,i.y,c),f=new ny(h,p,0,i.angleTo(n),r);return !s||iy(t,f,o,s,e)?f:void 0}l+=a;}}function uy(t,e,r,n,i,a,s,o,l){const u=sy(n,a,s),c=oy(n,i),h=c*s,p=0===t[0].x||t[0].x===l||0===t[0].y||t[0].y===l;return e-h<e/4&&(e=h+e/4),cy(t,p?e/2*o%e:(c/2+2*a)*s*o%e,e,u,r,h,p,!1,l)}function cy(t,e,r,n,i,a,s,o,l){const u=a/2,c=ay(t);let h=0,p=e-r,f=[];for(let e=0;e<t.length-1;e++){const s=t[e],o=t[e+1],d=s.dist(o),m=o.angleTo(s);for(;p+r<h+d;){p+=r;const y=(p-h)/d,g=ue(s.x,o.x,y),x=ue(s.y,o.y,y);if(g>=0&&g<l&&x>=0&&x<l&&p-u>=0&&p+u<=c){const r=new ny(g,x,0,m,e);n&&!iy(t,r,a,n,i)||f.push(r);}}h+=d;}return o||f.length||s||(f=cy(t,h/2,r,n,i,a,s,!0,l)),f}function hy(t,e,r,n,i){const a=[];for(let s=0;s<t.length;s++){const o=t[s];let l;for(let t=0;t<o.length-1;t++){let s=o[t],u=o[t+1];s.x<e&&u.x<e||(s.x<e?s=new g(e,s.y+(e-s.x)/(u.x-s.x)*(u.y-s.y))._round():u.x<e&&(u=new g(e,s.y+(e-s.x)/(u.x-s.x)*(u.y-s.y))._round()),s.y<r&&u.y<r||(s.y<r?s=new g(s.x+(r-s.y)/(u.y-s.y)*(u.x-s.x),r)._round():u.y<r&&(u=new g(s.x+(r-s.y)/(u.y-s.y)*(u.x-s.x),r)._round()),s.x>=n&&u.x>=n||(s.x>=n?s=new g(n,s.y+(n-s.x)/(u.x-s.x)*(u.y-s.y))._round():u.x>=n&&(u=new g(n,s.y+(n-s.x)/(u.x-s.x)*(u.y-s.y))._round()),s.y>=i&&u.y>=i||(s.y>=i?s=new g(s.x+(i-s.y)/(u.y-s.y)*(u.x-s.x),i)._round():u.y>=i&&(u=new g(s.x+(i-s.y)/(u.y-s.y)*(u.x-s.x),i)._round()),l&&s.equals(l[l.length-1])||(l=[s],a.push(l)),l.push(u)))));}}return a}function py(t){let e=0,r=0;for(const n of t)e+=n.w*n.h,r=Math.max(r,n.w);t.sort(((t,e)=>e.h-t.h));const n=[{x:0,y:0,w:Math.max(Math.ceil(Math.sqrt(e/.95)),r),h:1/0}];let i=0,a=0;for(const e of t)for(let t=n.length-1;t>=0;t--){const r=n[t];if(!(e.w>r.w||e.h>r.h)){if(e.x=r.x,e.y=r.y,a=Math.max(a,e.y+e.h),i=Math.max(i,e.x+e.w),e.w===r.w&&e.h===r.h){const e=n.pop();t<n.length&&(n[t]=e);}else e.h===r.h?(r.x+=e.w,r.w-=e.w):e.w===r.w?(r.y+=e.h,r.h-=e.h):(n.push({x:r.x+e.w,y:r.y,w:r.w-e.w,h:e.h}),r.y+=e.h,r.h-=e.h);break}}return {w:i,h:a,fill:e/(i*a)||0}}ra(ny,"Anchor");const fy=1;class dy{constructor(t,{pixelRatio:e,version:r,stretchX:n,stretchY:i,content:a}){this.paddedRect=t,this.pixelRatio=e,this.stretchX=n,this.stretchY=i,this.content=a,this.version=r;}get tl(){return [this.paddedRect.x+fy,this.paddedRect.y+fy]}get br(){return [this.paddedRect.x+this.paddedRect.w-fy,this.paddedRect.y+this.paddedRect.h-fy]}get displaySize(){return [(this.paddedRect.w-2*fy)/this.pixelRatio,(this.paddedRect.h-2*fy)/this.pixelRatio]}}class my{constructor(t,e){const r={},n={};this.haveRenderCallbacks=[];const i=[];this.addImages(t,r,i),this.addImages(e,n,i);const{w:a,h:s}=py(i),o=new bp({width:a||1,height:s||1});for(const e in t){const n=t[e],i=r[e].paddedRect;bp.copy(n.data,o,{x:0,y:0},{x:i.x+fy,y:i.y+fy},n.data,n.sdf);}for(const t in e){const r=e[t],i=n[t].paddedRect,a=i.x+fy,s=i.y+fy,l=r.data.width,u=r.data.height;bp.copy(r.data,o,{x:0,y:0},{x:a,y:s},r.data),bp.copy(r.data,o,{x:0,y:u-1},{x:a,y:s-1},{width:l,height:1}),bp.copy(r.data,o,{x:0,y:0},{x:a,y:s+u},{width:l,height:1}),bp.copy(r.data,o,{x:l-1,y:0},{x:a-1,y:s},{width:1,height:u}),bp.copy(r.data,o,{x:0,y:0},{x:a+l,y:s},{width:1,height:u});}this.image=o,this.iconPositions=r,this.patternPositions=n;}addImages(t,e,r){for(const n in t){const i=t[n],a={x:0,y:0,w:i.data.width+2*fy,h:i.data.height+2*fy};r.push(a),e[n]=new dy(a,i),i.hasRenderCallback&&this.haveRenderCallbacks.push(n);}}patchUpdatedImages(t,e,r){this.haveRenderCallbacks=this.haveRenderCallbacks.filter((e=>t.hasImage(e,r))),t.dispatchRenderCallbacks(this.haveRenderCallbacks,r);for(const n in t.getUpdatedImages(r))this.patchUpdatedImage(this.iconPositions[n],t.getImage(n,r),e),this.patchUpdatedImage(this.patternPositions[n],t.getImage(n,r),e);}patchUpdatedImage(t,e,r){if(!t||!e)return;if(t.version===e.version)return;t.version=e.version;const[n,i]=t.tl,a=!!Object.keys(this.patternPositions).length;r.update(e.data,{useMipmap:a},{x:n,y:i});}}ra(dy,"ImagePosition"),ra(my,"ImageAtlas");const yy=1e20;function gy(t,e,r,n,i,a,s,o,l){for(let u=e;u<e+n;u++)xy(t,r*a+u,a,i,s,o,l);for(let u=r;u<r+i;u++)xy(t,u*a+e,1,n,s,o,l);}function xy(t,e,r,n,i,a,s){a[0]=0,s[0]=-yy,s[1]=yy,i[0]=t[e];for(let o=1,l=0,u=0;o<n;o++){i[o]=t[e+o*r];const n=o*o;do{const t=a[l];u=(i[o]-i[t]+n-t*t)/(o-t)/2;}while(u<=s[l]&&--l>-1);l++,a[l]=o,s[l]=u,s[l+1]=yy;}for(let o=0,l=0;o<n;o++){for(;s[l+1]<o;)l++;const n=a[l],u=o-n;t[e+o*r]=i[n]+u*u;}}const vy=2,by={none:0,ideographs:1,all:2};class _y{constructor(t,e,r){this.requestManager=t,this.localGlyphMode=e,this.localFontFamily=r,this.urls={},this.entries={},this.localGlyphs={200:{},400:{},500:{},900:{}};}setURL(t,e){this.urls[e]=t;}getGlyphs(t,e,r){const i=[],a=this.urls[e]||n.GLYPHS_URL;for(const e in t)for(const r of t[e])i.push({stack:e,id:r});E(i,(({stack:t,id:e},r)=>{let n=this.entries[t];n||(n=this.entries[t]={glyphs:{},requests:{},ranges:{},ascender:void 0,descender:void 0});let i=n.glyphs[e];if(void 0!==i)return void r(null,{stack:t,id:e,glyph:i});if(i=this._tinySDF(n,t,e),i)return n.glyphs[e]=i,void r(null,{stack:t,id:e,glyph:i});const s=Math.floor(e/256);if(256*s>65535)return void r(new Error("glyphs > 65535 not supported"));if(n.ranges[s])return void r(null,{stack:t,id:e,glyph:i});let o=n.requests[s];o||(o=n.requests[s]=[],_y.loadGlyphRange(t,s,a,this.requestManager,((t,e)=>{if(e){n.ascender=e.ascender,n.descender=e.descender;for(const t in e.glyphs)this._doesCharSupportLocalGlyph(+t)||(n.glyphs[+t]=e.glyphs[+t]);n.ranges[s]=!0;}for(const r of o)r(t,e);delete n.requests[s];}))),o.push(((n,i)=>{n?r(n):i&&r(null,{stack:t,id:e,glyph:i.glyphs[e]||null});}));}),((t,e)=>{if(t)r(t);else if(e){const t={};for(const{stack:r,id:n,glyph:i}of e)void 0===t[r]&&(t[r]={}),void 0===t[r].glyphs&&(t[r].glyphs={}),t[r].glyphs[n]=i&&{id:i.id,bitmap:i.bitmap.clone(),metrics:i.metrics},t[r].ascender=this.entries[r].ascender,t[r].descender=this.entries[r].descender;r(null,t);}}));}_doesCharSupportLocalGlyph(t){return this.localGlyphMode!==by.none&&(this.localGlyphMode===by.all?!!this.localFontFamily:!!this.localFontFamily&&(oa["CJK Unified Ideographs"](t)||oa["Hangul Syllables"](t)||oa.Hiragana(t)||oa.Katakana(t)||oa["CJK Symbols and Punctuation"](t)||oa["CJK Unified Ideographs Extension A"](t)||oa["CJK Unified Ideographs Extension B"](t)))}_tinySDF(t,e,r){const n=this.localFontFamily;if(!n||!this._doesCharSupportLocalGlyph(r))return;let i=t.tinySDF;if(!i){let r="400";/bold/i.test(e)?r="900":/medium/i.test(e)?r="500":/light/i.test(e)&&(r="200"),i=t.tinySDF=new _y.TinySDF({fontFamily:n,fontWeight:r,fontSize:24*vy,buffer:3*vy,radius:8*vy}),i.fontWeight=r;}if(this.localGlyphs[i.fontWeight][r])return this.localGlyphs[i.fontWeight][r];const a=String.fromCodePoint(r),{data:s,width:o,height:l,glyphWidth:u,glyphHeight:c,glyphLeft:h,glyphTop:p,glyphAdvance:f}=i.draw(a);return this.localGlyphs[i.fontWeight][r]={id:r,bitmap:new vp({width:o,height:l},s),metrics:{width:u/vy,height:c/vy,left:h/vy,top:p/vy-27,advance:f/vy,localGlyph:!0}}}}_y.loadGlyphRange=function(t,e,r,n,i){const a=256*e,s=a+255,o=n.transformRequest(n.normalizeGlyphsURL(r).replace("{fontstack}",t).replace("{range}",`${a}-${s}`),At.Glyphs);Pt(o,((t,e)=>{if(t)i(t);else if(e){const t={},r=function(t){return new Vm(t).readFields(Fm,{})}(e);for(const e of r.glyphs)t[e.id]=e;i(null,{glyphs:t,ascender:r.ascender,descender:r.descender});}}));},_y.TinySDF=class{constructor({fontSize:t=24,buffer:e=3,radius:r=8,cutoff:n=.25,fontFamily:i="sans-serif",fontWeight:a="normal",fontStyle:s="normal"}={}){this.buffer=e,this.cutoff=n,this.radius=r;const o=this.size=t+4*e,l=this._createCanvas(o),u=this.ctx=l.getContext("2d",{willReadFrequently:!0});u.font=`${s} ${a} ${t}px ${i}`,u.textBaseline="alphabetic",u.textAlign="left",u.fillStyle="black",this.gridOuter=new Float64Array(o*o),this.gridInner=new Float64Array(o*o),this.f=new Float64Array(o),this.z=new Float64Array(o+1),this.v=new Uint16Array(o);}_createCanvas(t){const e=document.createElement("canvas");return e.width=e.height=t,e}draw(t){const{width:e,actualBoundingBoxAscent:r,actualBoundingBoxDescent:n,actualBoundingBoxLeft:i,actualBoundingBoxRight:a}=this.ctx.measureText(t),s=Math.ceil(r),o=Math.max(0,Math.min(this.size-this.buffer,Math.ceil(a-i))),l=Math.min(this.size-this.buffer,s+Math.ceil(n)),u=o+2*this.buffer,c=l+2*this.buffer,h=Math.max(u*c,0),p=new Uint8ClampedArray(h),f={data:p,width:u,height:c,glyphWidth:o,glyphHeight:l,glyphTop:s,glyphLeft:0,glyphAdvance:e};if(0===o||0===l)return f;const{ctx:d,buffer:m,gridInner:y,gridOuter:g}=this;d.clearRect(m,m,o,l),d.fillText(t,m,m+s);const x=d.getImageData(m,m,o,l);g.fill(yy,0,h),y.fill(0,0,h);for(let t=0;t<l;t++)for(let e=0;e<o;e++){const r=x.data[4*(t*o+e)+3]/255;if(0===r)continue;const n=(t+m)*u+e+m;if(1===r)g[n]=0,y[n]=yy;else {const t=.5-r;g[n]=t>0?t*t:0,y[n]=t<0?t*t:0;}}gy(g,0,0,u,c,u,this.f,this.v,this.z),gy(y,m,m,o,l,u,this.f,this.v,this.z);for(let t=0;t<h;t++){const e=Math.sqrt(g[t])-Math.sqrt(y[t]);p[t]=Math.round(255-255*(e/this.radius+this.cutoff));}return f}};const wy=fy;function My(t,e,r,n){const i=[],a=t.imagePrimary,s=a.pixelRatio,o=a.paddedRect.w-2*wy,l=a.paddedRect.h-2*wy,u=t.right-t.left,c=t.bottom-t.top,h=a.stretchX||[[0,o]],p=a.stretchY||[[0,l]],f=(t,e)=>t+e[1]-e[0],d=h.reduce(f,0),m=p.reduce(f,0),y=o-d,x=l-m;let v=0,b=d,_=0,w=m,M=0,A=y,S=0,I=x;if(a.content&&n){const t=a.content;v=Ay(h,0,t[0]),_=Ay(p,0,t[1]),b=Ay(h,t[0],t[2]),w=Ay(p,t[1],t[3]),M=t[0]-v,S=t[1]-_,A=t[2]-t[0]-b,I=t[3]-t[1]-w;}const k=(n,i,o,l)=>{const h=Iy(n.stretch-v,b,u,t.left),p=ky(n.fixed-M,A,n.stretch,d),f=Iy(i.stretch-_,w,c,t.top),y=ky(i.fixed-S,I,i.stretch,m),x=Iy(o.stretch-v,b,u,t.left),k=ky(o.fixed-M,A,o.stretch,d),P=Iy(l.stretch-_,w,c,t.top),E=ky(l.fixed-S,I,l.stretch,m),z=new g(h,f),T=new g(x,f),B=new g(x,P),C=new g(h,P),R=new g(p/s,y/s),D=new g(k/s,E/s),V=e*Math.PI/180;if(V){const t=Math.sin(V),e=Math.cos(V),r=[e,-t,t,e];z._matMult(r),T._matMult(r),C._matMult(r),B._matMult(r);}const L=n.stretch+n.fixed,F=o.stretch+o.fixed,N=i.stretch+i.fixed,O=l.stretch+l.fixed,U=t.imageSecondary;return {tl:z,tr:T,bl:C,br:B,texPrimary:{x:a.paddedRect.x+wy+L,y:a.paddedRect.y+wy+N,w:F-L,h:O-N},texSecondary:U?{x:U.paddedRect.x+wy+L,y:U.paddedRect.y+wy+N,w:F-L,h:O-N}:void 0,writingMode:void 0,glyphOffset:[0,0],sectionIndex:0,pixelOffsetTL:R,pixelOffsetBR:D,minFontScaleX:A/s/u,minFontScaleY:I/s/c,isSDF:r}};if(n&&(a.stretchX||a.stretchY)){const t=Sy(h,y,d),e=Sy(p,x,m);for(let r=0;r<t.length-1;r++){const n=t[r],a=t[r+1];for(let t=0;t<e.length-1;t++)i.push(k(n,e[t],a,e[t+1]));}}else i.push(k({fixed:0,stretch:-1},{fixed:0,stretch:-1},{fixed:0,stretch:o+1},{fixed:0,stretch:l+1}));return i}function Ay(t,e,r){let n=0;for(const i of t)n+=Math.max(e,Math.min(r,i[1]))-Math.max(e,Math.min(r,i[0]));return n}function Sy(t,e,r){const n=[{fixed:-wy,stretch:0}];for(const[e,r]of t){const t=n[n.length-1];n.push({fixed:e-t.stretch,stretch:t.stretch}),n.push({fixed:e-t.stretch,stretch:t.stretch+(r-e)});}return n.push({fixed:e+wy,stretch:r}),n}function Iy(t,e,r,n){return t/e*r+n}function ky(t,e,r,n){return t-e*r/n}function Py(t,e,r,n){const i=e+t.positionedLines[n].lineOffset;return 0===n?r+i/2:r+(i+(e+t.positionedLines[n-1].lineOffset))/2}function Ey(t,e=1,r=!1){let n=1/0,i=1/0,a=-1/0,s=-1/0;const o=t[0];for(let t=0;t<o.length;t++){const e=o[t];(!t||e.x<n)&&(n=e.x),(!t||e.y<i)&&(i=e.y),(!t||e.x>a)&&(a=e.x),(!t||e.y>s)&&(s=e.y);}const l=Math.min(a-n,s-i);let u=l/2;const c=new zr([],zy);if(0===l)return new g(n,i);for(let e=n;e<a;e+=l)for(let r=i;r<s;r+=l)c.push(new Ty(e+u,r+u,u,t));let h=function(t){let e=0,r=0,n=0;const i=t[0];for(let t=0,a=i.length,s=a-1;t<a;s=t++){const a=i[t],o=i[s],l=a.x*o.y-o.x*a.y;r+=(a.x+o.x)*l,n+=(a.y+o.y)*l,e+=3*l;}return new Ty(r/e,n/e,0,t)}(t),p=c.length;for(;c.length;){const n=c.pop();(n.d>h.d||!h.d)&&(h=n,r&&console.log("found best %d after %d probes",Math.round(1e4*n.d)/1e4,p)),n.max-h.d<=e||(u=n.h/2,c.push(new Ty(n.p.x-u,n.p.y-u,u,t)),c.push(new Ty(n.p.x+u,n.p.y-u,u,t)),c.push(new Ty(n.p.x-u,n.p.y+u,u,t)),c.push(new Ty(n.p.x+u,n.p.y+u,u,t)),p+=4);}return r&&(console.log(`num probes: ${p}`),console.log(`best distance: ${h.d}`)),h.p}function zy(t,e){return e.max-t.max}class Ty{constructor(t,e,r,n){this.p=new g(t,e),this.h=r,this.d=function(t,e){let r=!1,n=1/0;for(let i=0;i<e.length;i++){const a=e[i];for(let e=0,i=a.length,s=i-1;e<i;s=e++){const i=a[e],o=a[s];i.y>t.y!=o.y>t.y&&t.x<(o.x-i.x)*(t.y-i.y)/(o.y-i.y)+i.x&&(r=!r),n=Math.min(n,ql(t,i,o));}}return (r?1:-1)*Math.sqrt(n)}(this.p,n),this.max=this.d+this.h*Math.SQRT2;}}const By=Number.POSITIVE_INFINITY,Cy=Math.sqrt(2);function Ry(t,[e,r]){let n=0,i=0;if(r===By){e<0&&(e=0);const r=e/Cy;switch(t){case"top-right":case"top-left":i=r-7;break;case"bottom-right":case"bottom-left":i=7-r;break;case"bottom":i=7-e;break;case"top":i=e-7;}switch(t){case"top-right":case"bottom-right":n=-r;break;case"top-left":case"bottom-left":n=r;break;case"left":n=e;break;case"right":n=-e;}}else {switch(e=Math.abs(e),r=Math.abs(r),t){case"top-right":case"top-left":case"top":i=r-7;break;case"bottom-right":case"bottom-left":case"bottom":i=7-r;}switch(t){case"top-right":case"bottom-right":case"right":n=-e;break;case"top-left":case"bottom-left":case"left":n=e;}}return [n,i]}function Dy(t){switch(t){case"right":case"top-right":case"bottom-right":return "right";case"left":case"top-left":case"bottom-left":return "left"}return "center"}function Vy(t,e,r,n,i,a,s,o,l,u,c,h,p,f,d){let m=a.textMaxSize.evaluate(e,{},h);void 0===m&&(m=s);const y=t.layers[0].layout,g=y.get("icon-offset").evaluate(e,{},h),x=Oy(r.horizontal)||r.vertical,v="globe"===p.name,_=im,w=s/_,M=t.tilePixelRatio*m/_,A=(B=t.overscaling,t.zoom>18&&B>2&&(B>>=1),Math.max(Tr/(512*B),1)*y.get("symbol-spacing")),S=y.get("text-padding")*t.tilePixelRatio,I=y.get("icon-padding")*t.tilePixelRatio,k=b(y.get("text-max-angle")),P="map"===y.get("text-rotation-alignment")&&"point"!==y.get("symbol-placement"),E="map"===y.get("icon-rotation-alignment")&&"point"!==y.get("symbol-placement"),z=y.get("symbol-placement"),T=A/2;var B;const C=y.get("icon-text-fit").evaluate(e,{},h),R=y.get("icon-text-fit-padding").evaluate(e,{},h),D="none"!==C;let V;!1===t.hasAnyIconTextFit&&D&&(t.hasAnyIconTextFit=!0),n&&D&&(t.allowVerticalPlacement&&r.vertical&&(V=ry(n,r.vertical,C,R,g,w)),x&&(n=ry(n,x,C,R,g,w)));const L=(s,o,m)=>{if(o.x<0||o.x>=Tr||o.y<0||o.y>=Tr)return;let y=null;if(v){const{x:t,y:e,z:r}=p.projectTilePoint(o.x,o.y,m);y={anchor:new ny(t,e,r,0,void 0),up:p.upVector(m,o.x,o.y)};}!function(t,e,r,n,i,a,s,o,l,u,c,h,p,f,d,m,y,g,x,v,b,_,w,M,A,S,I){const k=t.addToLineVertexArray(e,n);let P,E,z,T,B,C,R,D=0,V=0,L=0,F=0,N=-1,O=-1;const U={};let q=ho("");const $=r?r.anchor:e,G="none"!==l.layout.get("icon-text-fit").evaluate(b,{},A);let Y=0,X=0;if(void 0===l._unevaluatedLayout.getValue("text-radial-offset")?[Y,X]=l.layout.get("text-offset").evaluate(b,{},A).map((t=>t*im)):(Y=l.layout.get("text-radial-offset").evaluate(b,{},A)*im,X=By),t.allowVerticalPlacement&&i.vertical){const t=i.vertical;if(d)C=jy(t),o&&(R=jy(o));else {const r=l.layout.get("text-rotate").evaluate(b,{},A)+90;z=Uy(u,$,e,c,h,p,t,f,r,m),o&&(T=Uy(u,$,e,c,h,p,o,g,r));}}if(a){const n=l.layout.get("icon-rotate").evaluate(b,{},A),i=My(a,n,w,G),s=o?My(o,n,w,G):void 0;E=Uy(u,$,e,c,h,p,a,g,n),D=4*i.length;const f=t.iconSizeData;let d=null;"source"===f.kind?(d=[am*l.layout.get("icon-size").evaluate(b,{},A)],d[0]>Fy&&j(`${t.layerIds[0]}: Value for "icon-size" is >= ${Ly}. Reduce your "icon-size".`)):"composite"===f.kind&&(d=[am*_.compositeIconSizes[0].evaluate(b,{},A),am*_.compositeIconSizes[1].evaluate(b,{},A)],(d[0]>Fy||d[1]>Fy)&&j(`${t.layerIds[0]}: Value for "icon-size" is >= ${Ly}. Reduce your "icon-size".`)),t.addSymbols(t.icon,i,d,v,x,b,!1,r,e,k.lineStartIndex,k.lineLength,-1,M,A,S,I),N=t.icon.placedSymbolArray.length-1,s&&(V=4*s.length,t.addSymbols(t.icon,s,d,v,x,b,jm.vertical,r,e,k.lineStartIndex,k.lineLength,-1,M,A,S,I),O=t.icon.placedSymbolArray.length-1);}for(const n in i.horizontal){const a=i.horizontal[n];P||(q=ho(a.text),d?B=jy(a):P=Uy(u,$,e,c,h,p,a,f,l.layout.get("text-rotate").evaluate(b,{},A),m));const o=1===a.positionedLines.length;if(L+=Ny(t,r,e,a,s,l,d,b,m,k,i.vertical?jm.horizontal:jm.horizontalOnly,o?Object.keys(i.horizontal):[n],U,N,_,M,A,S),o)break}i.vertical&&(F+=Ny(t,r,e,i.vertical,s,l,d,b,m,k,jm.vertical,["vertical"],U,O,_,M,A,S));let Z=-1;const K=(t,e)=>t?Math.max(t,e):e;Z=K(B,Z),Z=K(C,Z),Z=K(R,Z);const H=Z>-1?1:0;t.glyphOffsetArray.length>=65535&&j("Too many glyphs being rendered in a tile. See https://github.com/mapbox/mapbox-gl-js/issues/2907"),void 0!==b.sortKey&&t.addToSortKeyRanges(t.symbolInstances.length,b.sortKey),t.symbolInstances.emplaceBack(e.x,e.y,$.x,$.y,$.z,U.right>=0?U.right:-1,U.center>=0?U.center:-1,U.left>=0?U.left:-1,U.vertical>=0?U.vertical:-1,N,O,q,void 0!==P?P:t.collisionBoxArray.length,void 0!==P?P+1:t.collisionBoxArray.length,void 0!==z?z:t.collisionBoxArray.length,void 0!==z?z+1:t.collisionBoxArray.length,void 0!==E?E:t.collisionBoxArray.length,void 0!==E?E+1:t.collisionBoxArray.length,T||t.collisionBoxArray.length,T?T+1:t.collisionBoxArray.length,c,L,F,D,V,H,0,Y,X,Z,0,G?1:0);}(t,o,y,s,r,n,i,V,t.layers[0],t.collisionBoxArray,e.index,e.sourceLayerIndex,t.index,S,P,l,0,I,E,g,e,a,u,c,h,f,d);};if("line"===z)for(const i of hy(e.geometry,0,0,Tr,Tr)){const e=uy(i,A,k,r.vertical||x,n,_,M,t.overscaling,Tr);for(const r of e)x&&qy(t,x.text,T,r)||L(i,r,h);}else if("line-center"===z){for(const t of e.geometry)if(t.length>1){const e=ly(t,k,r.vertical||x,n,_,M);e&&L(t,e,h);}}else if("Polygon"===e.type)for(const t of nf(e.geometry,0)){const e=Ey(t,16);L(t[0],new ny(e.x,e.y,0,0,void 0),h);}else if("LineString"===e.type)for(const t of e.geometry)L(t,new ny(t[0].x,t[0].y,0,0,void 0),h);else if("Point"===e.type)for(const t of e.geometry)for(const e of t)L([e],new ny(e.x,e.y,0,0,void 0),h);}const Ly=255,Fy=Ly*am;function Ny(t,e,r,n,i,a,s,o,l,u,c,h,p,f,d,m,y,x){const v=function(t,e,r,n,i,a,s,o){const l=[];if(0===e.positionedLines.length)return l;const u=n.layout.get("text-rotate").evaluate(a,{})*Math.PI/180,c=function(t){const e=t[0],r=t[1],n=e*r;return n>0?[e,-r]:n<0?[-e,r]:0===e?[r,e]:[r,-e]}(r);let h=Math.abs(e.top-e.bottom);for(const t of e.positionedLines)h-=t.lineOffset;const p=e.positionedLines.length,f=h/p;let d=e.top-r[1];for(let t=0;t<p;++t){const n=e.positionedLines[t];d=Py(e,f,d,t);for(const t of n.positionedGlyphs){if(!t.rect)continue;const n=t.rect||{};let a=Um+1,h=!0,p=1,f=0;if(t.imageName){const e=s[t.imageName];if(!e)continue;if(e.sdf){j("SDF images are not supported in formatted text and will be ignored.");continue}h=!1,p=e.pixelRatio,a=fy/p;}const m=(i||o)&&t.vertical,y=t.metrics.advance*t.scale/2,x=t.metrics,v=t.rect;if(null===v)continue;o&&e.verticalizable&&(f=t.imageName?y-t.metrics.width*t.scale/2:0);const b=i?[t.x+y,t.y]:[0,0];let _=[0,0],w=[0,0],M=!1;i||(m?(w=[t.x+y+c[0],t.y+c[1]-f],M=!0):_=[t.x+y+r[0],t.y+r[1]-f]);const A=v.w*t.scale/(p*(t.localGlyph?vy:1)),S=v.h*t.scale/(p*(t.localGlyph?vy:1));let I,k,P,E;if(m){const e=t.y-d,r=new g(-y,y-e),n=-Math.PI/2,i=new g(...w);I=new g(-y+_[0],_[1]),I._rotateAround(n,r)._add(i),I.x+=-e+y,I.y-=(x.left-a)*t.scale;const s=t.imageName?x.advance*t.scale:im*t.scale,o=String.fromCodePoint(t.glyph);pm(o)?I.x+=(1-a)*t.scale:fm(o)?I.x+=s-x.height*t.scale+(-a-1)*t.scale:I.x+=t.imageName||x.width+2*a===v.w&&x.height+2*a===v.h?(s-S)/2:(s-(x.height+2*a)*t.scale)/2,k=new g(I.x,I.y-A),P=new g(I.x+S,I.y),E=new g(I.x+S,I.y-A);}else {const e=(x.left-a)*t.scale-y+_[0],r=(-x.top-a)*t.scale+_[1],n=e+A,i=r+S;I=new g(e,r),k=new g(n,r),P=new g(e,i),E=new g(n,i);}if(u){let t;t=i?new g(0,0):M?new g(c[0],c[1]):new g(r[0],r[1]),I._rotateAround(u,t),k._rotateAround(u,t),P._rotateAround(u,t),E._rotateAround(u,t);}const z=new g(0,0),T=new g(0,0);l.push({tl:I,tr:k,bl:P,br:E,texPrimary:n,texSecondary:void 0,writingMode:e.writingMode,glyphOffset:b,sectionIndex:t.sectionIndex,isSDF:h,pixelOffsetTL:z,pixelOffsetBR:T,minFontScaleX:0,minFontScaleY:0});}}return l}(0,n,l,a,s,o,i,t.allowVerticalPlacement),b=t.textSizeData;let _=null;"source"===b.kind?(_=[am*a.layout.get("text-size").evaluate(o,{},y)],_[0]>Fy&&j(`${t.layerIds[0]}: Value for "text-size" is >= ${Ly}. Reduce your "text-size".`)):"composite"===b.kind&&(_=[am*d.compositeTextSizes[0].evaluate(o,{},y),am*d.compositeTextSizes[1].evaluate(o,{},y)],(_[0]>Fy||_[1]>Fy)&&j(`${t.layerIds[0]}: Value for "text-size" is >= ${Ly}. Reduce your "text-size".`)),t.addSymbols(t.text,v,_,l,s,o,c,e,r,u.lineStartIndex,u.lineLength,f,m,y,x,!1);for(const e of h)p[e]=t.text.placedSymbolArray.length-1;return 4*v.length}function Oy(t){for(const e in t)return t[e];return null}function Uy(t,e,r,n,i,a,s,o,l,u){let c=s.top,h=s.bottom,p=s.left,f=s.right;const d=s.collisionPadding;if(d&&(p-=d[0],c-=d[1],f+=d[2],h+=d[3]),l){const t=new g(p,c),e=new g(f,c),r=new g(p,h),n=new g(f,h),i=b(l);let a=new g(0,0);u&&(a=new g(u[0],u[1])),t._rotateAround(i,a),e._rotateAround(i,a),r._rotateAround(i,a),n._rotateAround(i,a),p=Math.min(t.x,e.x,r.x,n.x),f=Math.max(t.x,e.x,r.x,n.x),c=Math.min(t.y,e.y,r.y,n.y),h=Math.max(t.y,e.y,r.y,n.y);}return t.emplaceBack(e.x,e.y,e.z,r.x,r.y,p,c,f,h,o,n,i,a),t.length-1}function jy(t){t.collisionPadding&&(t.top-=t.collisionPadding[1],t.bottom+=t.collisionPadding[3]);const e=t.bottom-t.top;return e>0?Math.max(10,e):null}function qy(t,e,r,n){const i=t.compareText;if(e in i){const t=i[e];for(let e=t.length-1;e>=0;e--)if(n.dist(t[e])<r)return !0}else i[e]=[];return i[e].push(n),!1}function $y(t,e){const r=t.fovAboveCenter,n=t.elevation?t.elevation.getMinElevationBelowMSL()*e:0,i=(t._camera.position[2]*t.worldSize-n)/Math.cos(t._pitch),a=Math.sin(r)*i/Math.sin(Math.max(Math.PI/2-t._pitch-r,.01)),s=Math.sin(t._pitch)*a+i;return Math.min(1.01*s,i*(1/t._horizonShift))}function Gy(t,e){if(!e.isReprojectedInTileSpace)return {scale:1<<t.z,x:t.x,y:t.y,x2:t.x+1,y2:t.y+1,projection:e};const r=Math.pow(2,-t.z),n=t.x*r,i=(t.x+1)*r,a=t.y*r,s=(t.y+1)*r,o=ml(n),l=ml(i),u=yl(a),c=yl(s),h=e.project(o,u),p=e.project(l,u),f=e.project(l,c),d=e.project(o,c);let m=Math.min(h.x,p.x,f.x,d.x),y=Math.min(h.y,p.y,f.y,d.y),g=Math.max(h.x,p.x,f.x,d.x),x=Math.max(h.y,p.y,f.y,d.y);const v=r/16;function b(t,r,n,i,a,s){const o=(n+a)/2,l=(i+s)/2,u=e.project(ml(o),yl(l)),c=Math.max(0,m-u.x,y-u.y,u.x-g,u.y-x);m=Math.min(m,u.x),g=Math.max(g,u.x),y=Math.min(y,u.y),x=Math.max(x,u.y),c>v&&(b(t,u,n,i,o,l),b(u,r,o,l,a,s));}b(h,p,n,a,i,a),b(p,f,i,a,i,s),b(f,d,i,s,n,s),b(d,h,n,s,n,a),m-=v,y-=v,g+=v,x+=v;const _=1/Math.max(g-m,x-y);return {scale:_,x:m*_,y:y*_,x2:g*_,y2:x*_,projection:e}}function Yy(t,{x:e,y:r},n=0){return new g(((e-n)*t.scale-t.x)*Tr,(r*t.scale-t.y)*Tr)}const Xy=t.a6.identity(new Float32Array(16));class Zy{constructor(t){this.spec=t,this.name=t.name,this.wrap=!1,this.requiresDraping=!1,this.supportsWorldCopies=!1,this.supportsTerrain=!1,this.supportsFog=!1,this.supportsFreeCamera=!1,this.zAxisUnit="meters",this.isReprojectedInTileSpace=!0,this.unsupportedLayers=["custom"],this.center=[0,0],this.range=[3.5,7];}project(t,e){return {x:0,y:0,z:0}}unproject(t,e){return new tl(0,0)}projectTilePoint(t,e,r){return {x:t,y:e,z:0}}locationPoint(t,e,r=!0){return t._coordinatePoint(t.locationCoordinate(e),r)}pixelsPerMeter(t,e){return dl(1,t)*e}pixelSpaceConversion(t,e,r){return 1}farthestPixelDistance(t){return $y(t,t.pixelsPerMeter)}pointCoordinate(t,e,r,n){const i=t.horizonLineFromTop(!1),a=new g(e,Math.max(i,r));return t.rayIntersectionCoordinate(t.pointRayIntersection(a,n))}pointCoordinate3D(t,e,r){const n=new g(e,r);if(t.elevation)return t.elevation.pointCoordinate(n);{const e=this.pointCoordinate(t,n.x,n.y,0);return [e.x,e.y,e.z]}}isPointAboveHorizon(t,e){if(t.elevation)return !this.pointCoordinate3D(t,e.x,e.y);const r=t.horizonLineFromTop();return e.y<r}createInversionMatrix(t,e){return Xy}createTileMatrix(e,r,n){let i,a,s;const o=n.canonical,l=t.a6.identity(new Float64Array(16));if(this.isReprojectedInTileSpace){const u=Gy(o,this);i=1,a=u.x+n.wrap*u.scale,s=u.y,t.a6.scale(l,l,[i/u.scale,i/u.scale,e.pixelsPerMeter/r]);}else i=r/e.zoomScale(o.z),a=(o.x+Math.pow(2,o.z)*n.wrap)*i,s=o.y*i;return t.a6.translate(l,l,[a,s,0]),t.a6.scale(l,l,[i/Tr,i/Tr,1]),l}upVector(t,e,r){return [0,0,1]}upVectorScale(t,e,r){return {metersToTile:1}}}class Ky extends Zy{constructor(t){super(t),this.range=[4,7],this.center=t.center||[-96,37.5];const[e,r]=this.parallels=t.parallels||[29.5,45.5],n=Math.sin(b(e));this.n=(n+Math.sin(b(r)))/2,this.c=1+n*(2*this.n-n),this.r0=Math.sqrt(this.c)/this.n;}project(t,e){const{n:r,c:n,r0:i}=this,a=b(t-this.center[0]),s=b(e),o=Math.sqrt(n-2*r*Math.sin(s))/r;return {x:o*Math.sin(a*r),y:o*Math.cos(a*r)-i,z:0}}unproject(t,e){const{n:r,c:n,r0:i}=this,a=i+e;let s=Math.atan2(t,Math.abs(a))*Math.sign(a);a*r<0&&(s-=Math.PI*Math.sign(t)*Math.sign(a));const o=b(this.center[0])*r;s=P(s,-Math.PI-o,Math.PI-o);const l=I(_(s/r)+this.center[0],-180,180),u=Math.asin(I((n-(t*t+a*a)*r*r)/(2*r),-1,1)),c=I(_(u),-xl,xl);return new tl(l,c)}}const Hy=1.340264,Wy=-.081106,Jy=893e-6,Qy=.003796,tg=Math.sqrt(3)/2;class eg extends Zy{project(t,e){e=e/180*Math.PI,t=t/180*Math.PI;const r=Math.asin(tg*Math.sin(e)),n=r*r,i=n*n*n;return {x:.5*(t*Math.cos(r)/(tg*(Hy+3*Wy*n+i*(7*Jy+9*Qy*n)))/Math.PI+.5),y:1-.5*(r*(Hy+Wy*n+i*(Jy+Qy*n))/Math.PI+1),z:0}}unproject(t,e){t=(2*t-.5)*Math.PI;let r=e=(2*(1-e)-1)*Math.PI,n=r*r,i=n*n*n;for(let t,a,s,o=0;o<12&&(a=r*(Hy+Wy*n+i*(Jy+Qy*n))-e,s=Hy+3*Wy*n+i*(7*Jy+9*Qy*n),t=a/s,r=I(r-t,-Math.PI/3,Math.PI/3),n=r*r,i=n*n*n,!(Math.abs(t)<1e-12));++o);const a=tg*t*(Hy+3*Wy*n+i*(7*Jy+9*Qy*n))/Math.cos(r),s=Math.asin(Math.sin(r)/tg),o=I(180*a/Math.PI,-180,180),l=I(180*s/Math.PI,-xl,xl);return new tl(o,l)}}class rg extends Zy{constructor(t){super(t),this.wrap=!0,this.supportsWorldCopies=!0;}project(t,e){return {x:.5+t/360,y:.5-e/360,z:0}}unproject(t,e){const r=360*(t-.5),n=I(360*(.5-e),-xl,xl);return new tl(r,n)}}const ng=Math.PI/2;function ig(t){return Math.tan((ng+t)/2)}class ag extends Zy{constructor(t){super(t),this.center=t.center||[0,30];const[e,r]=this.parallels=t.parallels||[30,30];let n=b(e),i=b(r);this.southernCenter=n+i<0,this.southernCenter&&(n=-n,i=-i);const a=Math.cos(n),s=ig(n);this.n=n===i?Math.sin(n):Math.log(a/Math.cos(i))/Math.log(ig(i)/s),this.f=a*Math.pow(ig(n),this.n)/this.n;}project(t,e){e=b(e),this.southernCenter&&(e=-e),t=b(t-this.center[0]);const r=1e-6,{n:n,f:i}=this;i>0?e<-ng+r&&(e=-ng+r):e>ng-r&&(e=ng-r);const a=i/Math.pow(ig(e),n);let s=a*Math.sin(n*t),o=i-a*Math.cos(n*t);return s=.5*(s/Math.PI+.5),o=.5*(o/Math.PI+.5),{x:s,y:this.southernCenter?o:1-o,z:0}}unproject(t,e){t=(2*t-.5)*Math.PI,this.southernCenter&&(e=1-e),e=(2*(1-e)-.5)*Math.PI;const{n:r,f:n}=this,i=n-e,a=Math.sign(i),s=Math.sign(r)*Math.sqrt(t*t+i*i);let o=Math.atan2(t,Math.abs(i))*a;i*r<0&&(o-=Math.PI*Math.sign(t)*a);const l=I(_(o/r)+this.center[0],-180,180),u=I(_(2*Math.atan(Math.pow(n/s,1/r))-ng),-xl,xl);return new tl(l,this.southernCenter?-u:u)}}class sg extends Zy{constructor(t){super(t),this.wrap=!0,this.supportsWorldCopies=!0,this.supportsTerrain=!0,this.supportsFog=!0,this.supportsFreeCamera=!0,this.isReprojectedInTileSpace=!1,this.unsupportedLayers=[],this.range=null;}project(t,e){return {x:pl(t),y:fl(e),z:0}}unproject(t,e){const r=ml(t),n=yl(e);return new tl(r,n)}}const og=b(xl);class lg extends Zy{project(t,e){const r=(e=b(e))*e,n=r*r;return {x:.5*((t=b(t))*(.8707-.131979*r+n*(n*(.003971*r-.001529*n)-.013791))/Math.PI+.5),y:1-.5*(e*(1.007226+r*(.015085+n*(.028874*r-.044475-.005916*n)))/Math.PI+1),z:0}}unproject(t,e){t=(2*t-.5)*Math.PI;let r=e=(2*(1-e)-1)*Math.PI,n=25,i=0,a=r*r;do{a=r*r;const t=a*a;i=(r*(1.007226+a*(.015085+t*(.028874*a-.044475-.005916*t)))-e)/(1.007226+a*(.045255+t*(.259866*a-.311325-.005916*11*t))),r=I(r-i,-og,og);}while(Math.abs(i)>1e-6&&--n>0);a=r*r;const s=I(_(t/(.8707+a*(a*(a*a*a*(.003971-.001529*a)-.013791)-.131979))),-180,180),o=_(r);return new tl(s,o)}}const ug=b(xl);class cg extends Zy{project(t,e){e=b(e),t=b(t);const r=Math.cos(e),n=2/Math.PI,i=Math.acos(r*Math.cos(t/2)),a=Math.sin(i)/i,s=.5*(t*n+2*r*Math.sin(t/2)/a)||0,o=.5*(e+Math.sin(e)/a)||0;return {x:.5*(s/Math.PI+.5),y:1-.5*(o/Math.PI+1),z:0}}unproject(t,e){let r=t=(2*t-.5)*Math.PI,n=e=(2*(1-e)-1)*Math.PI,i=25;const a=1e-6;let s=0,o=0;do{const i=Math.cos(n),a=Math.sin(n),l=2*a*i,u=a*a,c=i*i,h=Math.cos(r/2),p=Math.sin(r/2),f=2*h*p,d=p*p,m=1-c*h*h,y=m?1/m:0,g=m?Math.acos(i*h)*Math.sqrt(1/m):0,x=.5*(2*g*i*p+2*r/Math.PI)-t,v=.5*(g*a+n)-e,b=.5*y*(c*d+g*i*h*u)+1/Math.PI,_=y*(f*l/4-g*a*p),w=.125*y*(l*p-g*a*c*f),M=.5*y*(u*h+g*d*i)+.5,A=_*w-M*b;s=(v*_-x*M)/A,o=(x*w-v*b)/A,r=I(r-s,-Math.PI,Math.PI),n=I(n-o,-ug,ug);}while((Math.abs(s)>a||Math.abs(o)>a)&&--i>0);return new tl(_(r),_(n))}}class hg extends Zy{constructor(t){super(t),this.center=t.center||[0,0],this.parallels=t.parallels||[0,0],this.cosPhi=Math.max(.01,Math.cos(b(this.parallels[0]))),this.scale=1/(2*Math.max(Math.PI*this.cosPhi,1/this.cosPhi)),this.wrap=!0,this.supportsWorldCopies=!0;}project(t,e){const{scale:r,cosPhi:n}=this;return {x:b(t)*n*r+.5,y:-Math.sin(b(e))/n*r+.5,z:0}}unproject(t,e){const{scale:r,cosPhi:n}=this,i=-(e-.5)/r,a=I(_((t-.5)/r)/n,-180,180),s=Math.asin(I(i*n,-1,1)),o=I(_(s),-xl,xl);return new tl(a,o)}}class pg extends sg{constructor(t){super(t),this.requiresDraping=!0,this.supportsWorldCopies=!1,this.supportsFog=!0,this.zAxisUnit="pixels",this.unsupportedLayers=["debug"],this.range=[3,5];}projectTilePoint(e,r,n){const i=Zh(e,r,n),a=Wh(jh(n));return t.N.transformMat4(i,i,a),{x:i[0],y:i[1],z:i[2]}}locationPoint(e,r){const n=Wo(r.lat,r.lng),i=t.N.normalize([],n),a=e.elevation?e.elevation.getAtPointOrZero(e.locationCoordinate(r),e._centerAltitude):e._centerAltitude,s=dl(1,0)*Tr*a;t.N.scaleAndAdd(n,n,i,s);const o=t.a6.identity(new Float64Array(16));return t.a6.multiply(o,e.pixelMatrix,e.globeMatrix),t.N.transformMat4(n,n,o),new g(n[0],n[1])}pixelsPerMeter(t,e){return dl(1,0)*e}pixelSpaceConversion(t,e,r){const n=dl(1,t)*e,i=ue(dl(1,45)*e,n,r);return this.pixelsPerMeter(t,e)/i}createTileMatrix(e,r,n){const i=Jh(jh(n.canonical));return t.a6.multiply(new Float64Array(16),e.globeMatrix,i)}createInversionMatrix(e,r){const{center:n}=e,i=Wh(jh(r));return t.a6.rotateY(i,i,b(n.lng)),t.a6.rotateX(i,i,b(n.lat)),t.a6.scale(i,i,[e._pixelsPerMercatorPixel,e._pixelsPerMercatorPixel,1]),Float32Array.from(i)}pointCoordinate(t,e,r,n){return Nh(t,e,r,!0)||new Ml(0,0)}pointCoordinate3D(t,e,r){const n=this.pointCoordinate(t,e,r,0);return [n.x,n.y,n.z]}isPointAboveHorizon(t,e){return !Nh(t,e.x,e.y,!1)}farthestPixelDistance(e){const r=function(e,r){const n=e.cameraToCenterDistance,i=e._centerAltitude*r,a=e._camera,s=e._camera.forward(),o=t.N.add([],t.N.scale([],s,-n),[0,0,i]),l=e.worldSize/(2*Math.PI),u=[0,0,-l],c=e.width/e.height,h=Math.tan(e.fovAboveCenter),p=t.N.scale([],a.up(),h),f=t.N.scale([],a.right(),h*c),d=t.N.normalize([],t.N.add([],t.N.add([],s,p),f)),m=[];let y;if(new Sh(o,d).closestPointOnSphere(u,l,m)){const r=t.N.add([],m,u),n=t.N.sub([],r,o);y=Math.cos(e.fovAboveCenter)*t.N.length(n);}else {const e=t.N.sub([],o,u),r=t.N.sub([],u,o);t.N.normalize(r,r);const n=t.N.length(e)-l;y=Math.sqrt(n*(n+2*l));const i=Math.acos(y/(l+n))-Math.acos(t.N.dot(s,r));y*=Math.cos(i);}return 1.01*y}(e,this.pixelsPerMeter(e.center.lat,e.worldSize)),n=rp(e.zoom);if(n>0){const t=$y(e,dl(1,e.center.lat)*e.worldSize),i=e.worldSize/(2*Math.PI),a=Math.max(e.width,e.height)/e.worldSize*Math.PI;return ue(r,t+i*(1-Math.cos(a)),Math.pow(n,10))}return r}upVector(t,e,r){return Zh(e,r,t,1)}upVectorScale(t){return {metersToTile:Lh(Kh(jh(t)))}}}function fg(t){const e=t.parallels,r=!!e&&Math.abs(e[0]+e[1])<.01;switch(t.name){case"mercator":return new sg(t);case"equirectangular":return new rg(t);case"naturalEarth":return new lg(t);case"equalEarth":return new eg(t);case"winkelTripel":return new cg(t);case"albers":return r?new hg(t):new Ky(t);case"lambertConformalConic":return r?new hg(t):new ag(t);case"globe":return new pg(t)}throw new Error(`Invalid projection name: ${t.name}`)}const dg=zf.types,mg=[{name:"a_fade_opacity",components:1,type:"Uint8",offset:0}];function yg(t,e,r,n,i,a,s,o,l,u,c,h,p){const f=o?Math.min(Fy,Math.round(o[0])):0,d=o?Math.min(Fy,Math.round(o[1])):0;t.emplaceBack(e,r,Math.round(32*n),Math.round(32*i),a,s,(f<<1)+(l?1:0),d,16*u,16*c,256*h,256*p);}function gg(t,e,r){t.emplaceBack(e,r);}function xg(t,e,r,n,i,a,s){t.emplaceBack(e,r,n,i,a,s);}function vg(t,e,r,n,i){t.emplaceBack(e,r,n,i),t.emplaceBack(e,r,n,i),t.emplaceBack(e,r,n,i),t.emplaceBack(e,r,n,i);}function bg(t){for(const e of t.sections)if(ma(e.text))return !0;return !1}class _g{constructor(t){this.layoutVertexArray=new _s,this.indexArray=new Es,this.programConfigurations=t,this.segments=new eo,this.dynamicLayoutVertexArray=new gs,this.opacityVertexArray=new Ms,this.placedSymbolArray=new Gs,this.iconTransitioningVertexArray=new As,this.globeExtVertexArray=new ws,this.zOffsetVertexArray=new Bs;}isEmpty(){return 0===this.layoutVertexArray.length&&0===this.indexArray.length&&0===this.dynamicLayoutVertexArray.length&&0===this.opacityVertexArray.length&&0===this.iconTransitioningVertexArray.length}upload(t,e,r,n,i){this.isEmpty()||(r&&(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,Kd.members),this.indexBuffer=t.createIndexBuffer(this.indexArray,e),this.dynamicLayoutVertexBuffer=t.createVertexBuffer(this.dynamicLayoutVertexArray,Wd.members,!0),this.opacityVertexBuffer=t.createVertexBuffer(this.opacityVertexArray,mg,!0),this.iconTransitioningVertexArray.length>0&&(this.iconTransitioningVertexBuffer=t.createVertexBuffer(this.iconTransitioningVertexArray,Qd.members,!0)),this.globeExtVertexArray.length>0&&(this.globeExtVertexBuffer=t.createVertexBuffer(this.globeExtVertexArray,Hd.members,!0)),!this.zOffsetVertexBuffer&&(this.zOffsetVertexArray.length>0||i)&&(this.zOffsetVertexBuffer=t.createVertexBuffer(this.zOffsetVertexArray,Jd.members,!0)),this.opacityVertexBuffer.itemSize=1),(r||n)&&this.programConfigurations.upload(t));}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy(),this.dynamicLayoutVertexBuffer.destroy(),this.opacityVertexBuffer.destroy(),this.iconTransitioningVertexBuffer&&this.iconTransitioningVertexBuffer.destroy(),this.globeExtVertexBuffer&&this.globeExtVertexBuffer.destroy(),this.zOffsetVertexBuffer&&this.zOffsetVertexBuffer.destroy());}}ra(_g,"SymbolBuffers");class wg{constructor(t,e,r){this.layoutVertexArray=new t,this.layoutAttributes=e,this.indexArray=new r,this.segments=new eo,this.collisionVertexArray=new Ps,this.collisionVertexArrayExt=new gs;}upload(t){this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,this.layoutAttributes),this.indexBuffer=t.createIndexBuffer(this.indexArray),this.collisionVertexBuffer=t.createVertexBuffer(this.collisionVertexArray,tm.members,!0),this.collisionVertexBufferExt=t.createVertexBuffer(this.collisionVertexArrayExt,em.members,!0);}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.segments.destroy(),this.collisionVertexBuffer.destroy(),this.collisionVertexBufferExt.destroy());}}ra(wg,"CollisionBuffers");class Mg{constructor(e){this.collisionBoxArray=e.collisionBoxArray,this.zoom=e.zoom,this.overscaling=e.overscaling,this.layers=e.layers,this.layerIds=this.layers.map((t=>t.fqid)),this.index=e.index,this.pixelRatio=e.pixelRatio,this.sourceLayerIndex=e.sourceLayerIndex,this.hasPattern=!1,this.hasRTLText=!1,this.fullyClipped=!1,this.hasAnyIconTextFit=!1,this.sortKeyRanges=[],this.collisionCircleArray=[],this.placementInvProjMatrix=t.a6.identity([]),this.placementViewportMatrix=t.a6.identity([]);const r=this.layers[0]._unevaluatedLayout._values;this.textSizeData=sm(this.zoom,r["text-size"]),this.iconSizeData=sm(this.zoom,r["icon-size"]);const n=this.layers[0].layout,i=n.get("symbol-sort-key"),a=n.get("symbol-z-order");this.canOverlap=n.get("text-allow-overlap")||n.get("icon-allow-overlap")||n.get("text-ignore-placement")||n.get("icon-ignore-placement"),this.sortFeaturesByKey="viewport-y"!==a&&void 0!==i.constantOr(1),this.sortFeaturesByY=("viewport-y"===a||"auto"===a&&!this.sortFeaturesByKey)&&this.canOverlap,this.writingModes=n.get("text-writing-mode").map((t=>jm[t])),this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id)),this.sourceID=e.sourceID,this.projection=e.projection,this.hasAnyZOffset=!1,this.zOffsetSortDirty=!1,this.zOffsetBuffersNeedUpload=n.get("symbol-z-elevate");}createArrays(){this.text=new _g(new Vo(this.layers,this.zoom,(t=>/^text/.test(t)))),this.icon=new _g(new Vo(this.layers,this.zoom,(t=>/^icon/.test(t)))),this.glyphOffsetArray=new Zs,this.lineVertexArray=new Ks,this.symbolInstances=new Xs;}calculateGlyphDependencies(t,e,r,n,i){for(let r=0;r<t.length;r++){const a=t.codePointAt(r);if(void 0===a)break;if(e[a]=!0,n&&i&&a<=65535){const n=hm[t.charAt(r)];n&&(e[n.charCodeAt(0)]=!0);}}}populate(e,r,n,i){const a=this.layers[0],s=a.layout,o="globe"===this.projection.name,l=s.get("text-font"),u=s.get("text-field"),c=s.get("icon-image"),h=("constant"!==u.value.kind||u.value.value instanceof De&&!u.value.value.isEmpty()||u.value.value.toString().length>0)&&("constant"!==l.value.kind||l.value.value.length>0),p="constant"!==c.value.kind||!!c.value.value||Object.keys(c.parameters).length>0,f=s.get("symbol-sort-key");if(this.features=[],!h&&!p)return;const d=r.iconDependencies,m=r.glyphDependencies,y=r.availableImages,g=new Pa(this.zoom);for(const{feature:r,id:u,index:c,sourceLayerIndex:x}of e){const e=a._featureFilter.needGeometry,v=Bl(r,e);if(!a._featureFilter.filter(g,v,n))continue;if(e||(v.geometry=Tl(r,n,i)),o&&1!==r.type&&n.z<=5){const e=v.geometry,r=.98078528056,i=(e,i)=>{const a=Zh(e.x,e.y,n,1),s=Zh(i.x,i.y,n,1);return t.N.dot(a,s)<r};for(let t=0;t<e.length;t++)e[t]=kl(e[t],i);}let b,_;if(h){const t=a.getValueAndResolveTokens("text-field",v,n,y),e=De.factory(t);bg(e)&&(this.hasRTLText=!0),(!this.hasRTLText||"unavailable"===Sa()||this.hasRTLText&&ka.isParsed())&&(b=cm(e,a,v));}if(p){const t=a.getValueAndResolveTokens("icon-image",v,n,y);_=t instanceof Ve?t:Ve.fromString(t);}if(!b&&!_)continue;const w=this.sortFeaturesByKey?f.evaluate(v,{},n):void 0;if(this.features.push({id:u,text:b,icon:_,index:c,sourceLayerIndex:x,geometry:v.geometry,properties:r.properties,type:dg[r.type],sortKey:w}),_&&(d[_.namePrimary]=!0,_.nameSecondary&&(d[_.nameSecondary]=!0)),b){const t=l.evaluate(v,{},n).join(","),e="map"===s.get("text-rotation-alignment")&&"point"!==s.get("symbol-placement");this.allowVerticalPlacement=this.writingModes&&this.writingModes.indexOf(jm.vertical)>=0;for(const r of b.sections)if(r.image)d[r.image.namePrimary]=!0;else {const n=la(b.toString()),i=r.fontStack||t,a=m[i]=m[i]||{};this.calculateGlyphDependencies(r.text,a,e,this.allowVerticalPlacement,n);}}}"line"===s.get("symbol-placement")&&(this.features=function(t){const e={},r={},n=[];let i=0;function a(e){n.push(t[e]),i++;}function s(t,e,i){const a=r[t];return delete r[t],r[e]=a,n[a].geometry[0].pop(),n[a].geometry[0]=n[a].geometry[0].concat(i[0]),a}function o(t,r,i){const a=e[r];return delete e[r],e[t]=a,n[a].geometry[0].shift(),n[a].geometry[0]=i[0].concat(n[a].geometry[0]),a}function l(t,e,r){const n=r?e[0][e[0].length-1]:e[0][0];return `${t}:${n.x}:${n.y}`}for(let u=0;u<t.length;u++){const c=t[u],h=c.geometry,p=c.text?c.text.toString():null;if(!p){a(u);continue}const f=l(p,h),d=l(p,h,!0);if(f in r&&d in e&&r[f]!==e[d]){const t=o(f,d,h),i=s(f,d,n[t].geometry);delete e[f],delete r[d],r[l(p,n[i].geometry,!0)]=i,n[t].geometry=null;}else f in r?s(f,d,h):d in e?o(f,d,h):(a(u),e[f]=i-1,r[d]=i-1);}return n.filter((t=>t.geometry))}(this.features)),this.sortFeaturesByKey&&this.features.sort(((t,e)=>t.sortKey-e.sortKey));}update(t,e,r,n,i){const a=0!==Object.keys(t).length;if(a&&!this.stateDependentLayers.length)return;const s=a?this.stateDependentLayers:this.layers;this.text.programConfigurations.updatePaintArrays(t,e,s,r,n,i),this.icon.programConfigurations.updatePaintArrays(t,e,s,r,n,i);}updateZOffset(){const t=(t,e,n)=>{r+=e,r>t.length&&t.resize(r);for(let i=-e;i<0;i++)t.emplace(i+r,n);},e=(t,e,r)=>{n+=e,n>t.length&&t.resize(n);for(let i=-e;i<0;i++)t.emplace(i+n,r);};if(!this.zOffsetBuffersNeedUpload)return;this.zOffsetBuffersNeedUpload=!1;let r=0,n=0;for(let r=0;r<this.symbolInstances.length;r++){const n=this.symbolInstances.get(r),{numHorizontalGlyphVertices:i,numVerticalGlyphVertices:a,numIconVertices:s}=n,o=n.zOffset,l=s>0;if((i>0||a>0)&&(t(this.text.zOffsetVertexArray,i,o),t(this.text.zOffsetVertexArray,a,o)),l){const{placedIconSymbolIndex:t,verticalPlacedIconSymbolIndex:r}=n;t>=0&&e(this.icon.zOffsetVertexArray,s,o),r>=0&&e(this.icon.zOffsetVertexArray,n.numVerticalIconVertices,o);}}this.text.zOffsetVertexBuffer&&this.text.zOffsetVertexBuffer.updateData(this.text.zOffsetVertexArray),this.icon.zOffsetVertexBuffer&&this.icon.zOffsetVertexBuffer.updateData(this.icon.zOffsetVertexArray);}isEmpty(){return 0===this.symbolInstances.length&&!this.hasRTLText}uploadPending(){return !this.uploaded||this.text.programConfigurations.needsUpload||this.icon.programConfigurations.needsUpload}upload(t){!this.uploaded&&this.hasDebugData()&&(this.textCollisionBox.upload(t),this.iconCollisionBox.upload(t)),this.text.upload(t,this.sortFeaturesByY,!this.uploaded,this.text.programConfigurations.needsUpload,this.zOffsetBuffersNeedUpload),this.icon.upload(t,this.sortFeaturesByY,!this.uploaded,this.icon.programConfigurations.needsUpload,this.zOffsetBuffersNeedUpload),this.uploaded=!0;}destroyDebugData(){this.textCollisionBox.destroy(),this.iconCollisionBox.destroy();}getProjection(){return this.projectionInstance||(this.projectionInstance=fg(this.projection)),this.projectionInstance}destroy(){this.text.destroy(),this.icon.destroy(),this.hasDebugData()&&this.destroyDebugData();}addToLineVertexArray(t,e){const r=this.lineVertexArray.length;if(void 0!==t.segment)for(const{x:t,y:r}of e)this.lineVertexArray.emplaceBack(t,r);return {lineStartIndex:r,lineLength:this.lineVertexArray.length-r}}addSymbols(t,e,r,n,i,a,s,o,l,u,c,h,p,f,d,m){const y=t.indexArray,g=t.layoutVertexArray,x=t.globeExtVertexArray,v=t.segments.prepareSegment(4*e.length,g,y,this.canOverlap?a.sortKey:void 0),b=this.glyphOffsetArray.length,_=v.vertexLength,w=this.allowVerticalPlacement&&s===jm.vertical?Math.PI/2:0,M=a.text&&a.text.sections;for(let n=0;n<e.length;n++){const{tl:i,tr:s,bl:u,br:c,texPrimary:h,texSecondary:b,pixelOffsetTL:_,pixelOffsetBR:A,minFontScaleX:S,minFontScaleY:I,glyphOffset:k,isSDF:P,sectionIndex:E}=e[n],z=v.vertexLength,T=k[1];if(yg(g,l.x,l.y,i.x,T+i.y,h.x,h.y,r,P,_.x,_.y,S,I),yg(g,l.x,l.y,s.x,T+s.y,h.x+h.w,h.y,r,P,A.x,_.y,S,I),yg(g,l.x,l.y,u.x,T+u.y,h.x,h.y+h.h,r,P,_.x,A.y,S,I),yg(g,l.x,l.y,c.x,T+c.y,h.x+h.w,h.y+h.h,r,P,A.x,A.y,S,I),o){const{x:e,y:r,z:n}=o.anchor,[i,a,s]=o.up;xg(x,e,r,n,i,a,s),xg(x,e,r,n,i,a,s),xg(x,e,r,n,i,a,s),xg(x,e,r,n,i,a,s),vg(t.dynamicLayoutVertexArray,e,r,n,w);}else vg(t.dynamicLayoutVertexArray,l.x,l.y,l.z,w);if(m){const e=b||h;gg(t.iconTransitioningVertexArray,e.x,e.y),gg(t.iconTransitioningVertexArray,e.x+e.w,e.y),gg(t.iconTransitioningVertexArray,e.x,e.y+e.h),gg(t.iconTransitioningVertexArray,e.x+e.w,e.y+e.h);}y.emplaceBack(z,z+1,z+2),y.emplaceBack(z+1,z+2,z+3),v.vertexLength+=4,v.primitiveLength+=2,this.glyphOffsetArray.emplaceBack(k[0]),n!==e.length-1&&E===e[n+1].sectionIndex||t.programConfigurations.populatePaintArrays(g.length,a,a.index,{},p,f,d,M&&M[E]);}const A=o?o.anchor:l;t.placedSymbolArray.emplaceBack(A.x,A.y,A.z,l.x,l.y,b,this.glyphOffsetArray.length-b,_,u,c,l.segment,r?r[0]:0,r?r[1]:0,n[0],n[1],s,0,!1,0,h,0);}_commitLayoutVertex(t,e,r,n,i,a,s){t.emplaceBack(e,r,n,i,a,Math.round(s.x),Math.round(s.y));}_addCollisionDebugVertices(t,e,r,n,i,a,s){const o=r.segments.prepareSegment(4,r.layoutVertexArray,r.indexArray),l=o.vertexLength,u=s.tileAnchorX,c=s.tileAnchorY;for(let t=0;t<4;t++)r.collisionVertexArray.emplaceBack(0,0,0,0);this._commitDebugCollisionVertexUpdate(r.collisionVertexArrayExt,e,t.padding,s.zOffset),this._commitLayoutVertex(r.layoutVertexArray,n,i,a,u,c,new g(t.x1,t.y1)),this._commitLayoutVertex(r.layoutVertexArray,n,i,a,u,c,new g(t.x2,t.y1)),this._commitLayoutVertex(r.layoutVertexArray,n,i,a,u,c,new g(t.x2,t.y2)),this._commitLayoutVertex(r.layoutVertexArray,n,i,a,u,c,new g(t.x1,t.y2)),o.vertexLength+=4;const h=r.indexArray;h.emplaceBack(l,l+1),h.emplaceBack(l+1,l+2),h.emplaceBack(l+2,l+3),h.emplaceBack(l+3,l),o.primitiveLength+=4;}_addTextDebugCollisionBoxes(t,e,r,n,i,a){for(let s=n;s<i;s++){const n=r.get(s),i=this.getSymbolInstanceTextSize(t,a,e,s);this._addCollisionDebugVertices(n,i,this.textCollisionBox,n.projectedAnchorX,n.projectedAnchorY,n.projectedAnchorZ,a);}}_addIconDebugCollisionBoxes(t,e,r,n,i,a){for(let s=n;s<i;s++){const n=r.get(s),i=this.getSymbolInstanceIconSize(t,e,a.placedIconSymbolIndex);this._addCollisionDebugVertices(n,i,this.iconCollisionBox,n.projectedAnchorX,n.projectedAnchorY,n.projectedAnchorZ,a);}}generateCollisionDebugBuffers(t,e){this.hasDebugData()&&this.destroyDebugData(),this.textCollisionBox=new wg(Is,rm.members,As),this.iconCollisionBox=new wg(Is,rm.members,As);const r=lm(this.iconSizeData,t),n=lm(this.textSizeData,t);for(let i=0;i<this.symbolInstances.length;i++){const a=this.symbolInstances.get(i);this._addTextDebugCollisionBoxes(n,t,e,a.textBoxStartIndex,a.textBoxEndIndex,a),this._addTextDebugCollisionBoxes(n,t,e,a.verticalTextBoxStartIndex,a.verticalTextBoxEndIndex,a),this._addIconDebugCollisionBoxes(r,t,e,a.iconBoxStartIndex,a.iconBoxEndIndex,a),this._addIconDebugCollisionBoxes(r,t,e,a.verticalIconBoxStartIndex,a.verticalIconBoxEndIndex,a);}}getSymbolInstanceTextSize(t,e,r,n){const i=this.text.placedSymbolArray.get(e.rightJustifiedTextSymbolIndex>=0?e.rightJustifiedTextSymbolIndex:e.centerJustifiedTextSymbolIndex>=0?e.centerJustifiedTextSymbolIndex:e.leftJustifiedTextSymbolIndex>=0?e.leftJustifiedTextSymbolIndex:e.verticalPlacedTextSymbolIndex>=0?e.verticalPlacedTextSymbolIndex:n),a=om(this.textSizeData,t,i)/im;return this.tilePixelRatio*a}getSymbolInstanceIconSize(t,e,r){const n=this.icon.placedSymbolArray.get(r),i=om(this.iconSizeData,t,n);return this.tilePixelRatio*i}_commitDebugCollisionVertexUpdate(t,e,r,n){t.emplaceBack(e,-r,-r,n),t.emplaceBack(e,r,-r,n),t.emplaceBack(e,r,r,n),t.emplaceBack(e,-r,r,n);}_updateTextDebugCollisionBoxes(t,e,r,n,i,a){for(let s=n;s<i;s++){const n=r.get(s),i=this.getSymbolInstanceTextSize(t,a,e,s);this._commitDebugCollisionVertexUpdate(this.textCollisionBox.collisionVertexArrayExt,i,n.padding,a.zOffset);}}_updateIconDebugCollisionBoxes(t,e,r,n,i,a){for(let s=n;s<i;s++){const n=r.get(s),i=this.getSymbolInstanceIconSize(t,e,a.placedIconSymbolIndex);this._commitDebugCollisionVertexUpdate(this.iconCollisionBox.collisionVertexArrayExt,i,n.padding,a.zOffset);}}updateCollisionDebugBuffers(t,e){if(!this.hasDebugData())return;this.hasTextCollisionBoxData()&&this.textCollisionBox.collisionVertexArrayExt.clear(),this.hasIconCollisionBoxData()&&this.iconCollisionBox.collisionVertexArrayExt.clear();const r=lm(this.iconSizeData,t),n=lm(this.textSizeData,t);for(let i=0;i<this.symbolInstances.length;i++){const a=this.symbolInstances.get(i);this._updateTextDebugCollisionBoxes(n,t,e,a.textBoxStartIndex,a.textBoxEndIndex,a),this._updateTextDebugCollisionBoxes(n,t,e,a.verticalTextBoxStartIndex,a.verticalTextBoxEndIndex,a),this._updateIconDebugCollisionBoxes(r,t,e,a.iconBoxStartIndex,a.iconBoxEndIndex,a),this._updateIconDebugCollisionBoxes(r,t,e,a.verticalIconBoxStartIndex,a.verticalIconBoxEndIndex,a);}this.hasTextCollisionBoxData()&&this.textCollisionBox.collisionVertexBufferExt&&this.textCollisionBox.collisionVertexBufferExt.updateData(this.textCollisionBox.collisionVertexArrayExt),this.hasIconCollisionBoxData()&&this.iconCollisionBox.collisionVertexBufferExt&&this.iconCollisionBox.collisionVertexBufferExt.updateData(this.iconCollisionBox.collisionVertexArrayExt);}_deserializeCollisionBoxesForSymbol(t,e,r,n,i,a,s,o,l){const u={};if(e<r){const{x1:r,y1:n,x2:i,y2:a,padding:s,projectedAnchorX:o,projectedAnchorY:l,projectedAnchorZ:c,tileAnchorX:h,tileAnchorY:p,featureIndex:f}=t.get(e);u.textBox={x1:r,y1:n,x2:i,y2:a,padding:s,projectedAnchorX:o,projectedAnchorY:l,projectedAnchorZ:c,tileAnchorX:h,tileAnchorY:p},u.textFeatureIndex=f;}if(n<i){const{x1:e,y1:r,x2:i,y2:a,padding:s,projectedAnchorX:o,projectedAnchorY:l,projectedAnchorZ:c,tileAnchorX:h,tileAnchorY:p,featureIndex:f}=t.get(n);u.verticalTextBox={x1:e,y1:r,x2:i,y2:a,padding:s,projectedAnchorX:o,projectedAnchorY:l,projectedAnchorZ:c,tileAnchorX:h,tileAnchorY:p},u.verticalTextFeatureIndex=f;}if(a<s){const{x1:e,y1:r,x2:n,y2:i,padding:s,projectedAnchorX:o,projectedAnchorY:l,projectedAnchorZ:c,tileAnchorX:h,tileAnchorY:p,featureIndex:f}=t.get(a);u.iconBox={x1:e,y1:r,x2:n,y2:i,padding:s,projectedAnchorX:o,projectedAnchorY:l,projectedAnchorZ:c,tileAnchorX:h,tileAnchorY:p},u.iconFeatureIndex=f;}if(o<l){const{x1:e,y1:r,x2:n,y2:i,padding:a,projectedAnchorX:s,projectedAnchorY:l,projectedAnchorZ:c,tileAnchorX:h,tileAnchorY:p,featureIndex:f}=t.get(o);u.verticalIconBox={x1:e,y1:r,x2:n,y2:i,padding:a,projectedAnchorX:s,projectedAnchorY:l,projectedAnchorZ:c,tileAnchorX:h,tileAnchorY:p},u.verticalIconFeatureIndex=f;}return u}deserializeCollisionBoxes(t){this.collisionArrays=[];for(let e=0;e<this.symbolInstances.length;e++){const r=this.symbolInstances.get(e);this.collisionArrays.push(this._deserializeCollisionBoxesForSymbol(t,r.textBoxStartIndex,r.textBoxEndIndex,r.verticalTextBoxStartIndex,r.verticalTextBoxEndIndex,r.iconBoxStartIndex,r.iconBoxEndIndex,r.verticalIconBoxStartIndex,r.verticalIconBoxEndIndex));}}hasTextData(){return this.text.segments.get().length>0}hasIconData(){return this.icon.segments.get().length>0}hasDebugData(){return this.textCollisionBox&&this.iconCollisionBox}hasTextCollisionBoxData(){return this.hasDebugData()&&this.textCollisionBox.segments.get().length>0}hasIconCollisionBoxData(){return this.hasDebugData()&&this.iconCollisionBox.segments.get().length>0}hasIconTextFit(){return this.hasAnyIconTextFit}addIndicesForPlacedSymbol(t,e){const r=t.placedSymbolArray.get(e),n=r.vertexStartIndex+4*r.numGlyphs;for(let e=r.vertexStartIndex;e<n;e+=4)t.indexArray.emplaceBack(e,e+1,e+2),t.indexArray.emplaceBack(e+1,e+2,e+3);}getSortedSymbolIndexes(t){if(this.sortedAngle===t&&void 0!==this.symbolInstanceIndexes)return this.symbolInstanceIndexes;const e=Math.sin(t),r=Math.cos(t),n=[],i=[],a=[];for(let t=0;t<this.symbolInstances.length;++t){a.push(t);const s=this.symbolInstances.get(t);n.push(0|Math.round(e*s.tileAnchorX+r*s.tileAnchorY)),i.push(s.featureIndex);}return a.sort(((t,e)=>n[t]-n[e]||i[e]-i[t])),a}getSortedIndexesByZOffset(){if(!this.zOffsetSortDirty)return this.symbolInstanceIndexesSortedZOffset;if(!this.symbolInstanceIndexesSortedZOffset){this.symbolInstanceIndexesSortedZOffset=[];for(let t=0;t<this.symbolInstances.length;++t)this.symbolInstanceIndexesSortedZOffset.push(t);}return this.zOffsetSortDirty=!1,this.symbolInstanceIndexesSortedZOffset.sort(((t,e)=>this.symbolInstances.get(e).zOffset-this.symbolInstances.get(t).zOffset))}addToSortKeyRanges(t,e){const r=this.sortKeyRanges[this.sortKeyRanges.length-1];r&&r.sortKey===e?r.symbolInstanceEnd=t+1:this.sortKeyRanges.push({sortKey:e,symbolInstanceStart:t,symbolInstanceEnd:t+1});}sortFeatures(t){if(this.sortFeaturesByY&&this.sortedAngle!==t&&!(this.text.segments.get().length>1||this.icon.segments.get().length>1)){this.symbolInstanceIndexes=this.getSortedSymbolIndexes(t),this.sortedAngle=t,this.text.indexArray.clear(),this.icon.indexArray.clear(),this.featureSortOrder=[];for(const t of this.symbolInstanceIndexes){const e=this.symbolInstances.get(t);this.featureSortOrder.push(e.featureIndex);const{rightJustifiedTextSymbolIndex:r,centerJustifiedTextSymbolIndex:n,leftJustifiedTextSymbolIndex:i,verticalPlacedTextSymbolIndex:a,placedIconSymbolIndex:s,verticalPlacedIconSymbolIndex:o}=e;r>=0&&this.addIndicesForPlacedSymbol(this.text,r),n>=0&&n!==r&&this.addIndicesForPlacedSymbol(this.text,n),i>=0&&i!==n&&i!==r&&this.addIndicesForPlacedSymbol(this.text,i),a>=0&&this.addIndicesForPlacedSymbol(this.text,a),s>=0&&this.addIndicesForPlacedSymbol(this.icon,s),o>=0&&this.addIndicesForPlacedSymbol(this.icon,o);}this.text.indexBuffer&&this.text.indexBuffer.updateData(this.text.indexArray),this.icon.indexBuffer&&this.icon.indexBuffer.updateData(this.icon.indexArray);}}}ra(Mg,"SymbolBucket",{omit:["layers","collisionBoxArray","features","compareText"]}),Mg.addDynamicAttributes=vg;const Ag=new Oa({"symbol-placement":new La(qa.layout_symbol["symbol-placement"]),"symbol-spacing":new La(qa.layout_symbol["symbol-spacing"]),"symbol-avoid-edges":new La(qa.layout_symbol["symbol-avoid-edges"]),"symbol-sort-key":new Fa(qa.layout_symbol["symbol-sort-key"]),"symbol-z-order":new La(qa.layout_symbol["symbol-z-order"]),"symbol-z-elevate":new La(qa.layout_symbol["symbol-z-elevate"]),"icon-allow-overlap":new La(qa.layout_symbol["icon-allow-overlap"]),"icon-ignore-placement":new La(qa.layout_symbol["icon-ignore-placement"]),"icon-optional":new La(qa.layout_symbol["icon-optional"]),"icon-rotation-alignment":new La(qa.layout_symbol["icon-rotation-alignment"]),"icon-size":new Fa(qa.layout_symbol["icon-size"]),"icon-text-fit":new Fa(qa.layout_symbol["icon-text-fit"]),"icon-text-fit-padding":new Fa(qa.layout_symbol["icon-text-fit-padding"]),"icon-image":new Fa(qa.layout_symbol["icon-image"]),"icon-rotate":new Fa(qa.layout_symbol["icon-rotate"]),"icon-padding":new La(qa.layout_symbol["icon-padding"]),"icon-keep-upright":new La(qa.layout_symbol["icon-keep-upright"]),"icon-offset":new Fa(qa.layout_symbol["icon-offset"]),"icon-anchor":new Fa(qa.layout_symbol["icon-anchor"]),"icon-pitch-alignment":new La(qa.layout_symbol["icon-pitch-alignment"]),"text-pitch-alignment":new La(qa.layout_symbol["text-pitch-alignment"]),"text-rotation-alignment":new La(qa.layout_symbol["text-rotation-alignment"]),"text-field":new Fa(qa.layout_symbol["text-field"]),"text-font":new Fa(qa.layout_symbol["text-font"]),"text-size":new Fa(qa.layout_symbol["text-size"]),"text-max-width":new Fa(qa.layout_symbol["text-max-width"]),"text-line-height":new Fa(qa.layout_symbol["text-line-height"]),"text-letter-spacing":new Fa(qa.layout_symbol["text-letter-spacing"]),"text-justify":new Fa(qa.layout_symbol["text-justify"]),"text-radial-offset":new Fa(qa.layout_symbol["text-radial-offset"]),"text-variable-anchor":new La(qa.layout_symbol["text-variable-anchor"]),"text-anchor":new Fa(qa.layout_symbol["text-anchor"]),"text-max-angle":new La(qa.layout_symbol["text-max-angle"]),"text-writing-mode":new La(qa.layout_symbol["text-writing-mode"]),"text-rotate":new Fa(qa.layout_symbol["text-rotate"]),"text-padding":new La(qa.layout_symbol["text-padding"]),"text-keep-upright":new La(qa.layout_symbol["text-keep-upright"]),"text-transform":new Fa(qa.layout_symbol["text-transform"]),"text-offset":new Fa(qa.layout_symbol["text-offset"]),"text-allow-overlap":new La(qa.layout_symbol["text-allow-overlap"]),"text-ignore-placement":new La(qa.layout_symbol["text-ignore-placement"]),"text-optional":new La(qa.layout_symbol["text-optional"]),visibility:new La(qa.layout_symbol.visibility)});var Sg={paint:new Oa({"icon-opacity":new Fa(qa.paint_symbol["icon-opacity"]),"icon-emissive-strength":new Fa(qa.paint_symbol["icon-emissive-strength"]),"text-emissive-strength":new Fa(qa.paint_symbol["text-emissive-strength"]),"icon-color":new Fa(qa.paint_symbol["icon-color"]),"icon-halo-color":new Fa(qa.paint_symbol["icon-halo-color"]),"icon-halo-width":new Fa(qa.paint_symbol["icon-halo-width"]),"icon-halo-blur":new Fa(qa.paint_symbol["icon-halo-blur"]),"icon-translate":new La(qa.paint_symbol["icon-translate"]),"icon-translate-anchor":new La(qa.paint_symbol["icon-translate-anchor"]),"icon-image-cross-fade":new Fa(qa.paint_symbol["icon-image-cross-fade"]),"text-opacity":new Fa(qa.paint_symbol["text-opacity"]),"text-color":new Fa(qa.paint_symbol["text-color"],{runtimeType:_e,getOverride:t=>t.textColor,hasOverride:t=>!!t.textColor}),"text-halo-color":new Fa(qa.paint_symbol["text-halo-color"]),"text-halo-width":new Fa(qa.paint_symbol["text-halo-width"]),"text-halo-blur":new Fa(qa.paint_symbol["text-halo-blur"]),"text-translate":new La(qa.paint_symbol["text-translate"]),"text-translate-anchor":new La(qa.paint_symbol["text-translate-anchor"]),"icon-color-saturation":new La(qa.paint_symbol["icon-color-saturation"])}),layout:Ag};class Ig{constructor(t){this.type=t.property.overrides?t.property.overrides.runtimeType:ge,this.defaultValue=t;}evaluate(t){if(t.formattedSection){const e=this.defaultValue.property.overrides;if(e&&e.hasOverride(t.formattedSection))return e.getOverride(t.formattedSection)}return t.feature&&t.featureState?this.defaultValue.evaluate(t.feature,t.featureState):this.defaultValue.property.specification.default}eachChild(t){this.defaultValue.isConstant()||t(this.defaultValue.value._styleExpression.expression);}outputDefined(){return !1}serialize(){return null}}ra(Ig,"FormatSectionOverride",{omit:["defaultValue"]});class kg extends ss{constructor(t,e,r){super(t,Sg,e,r);}recalculate(t,e){super.recalculate(t,e),"auto"===this.layout.get("icon-rotation-alignment")&&(this.layout._values["icon-rotation-alignment"]="point"!==this.layout.get("symbol-placement")?"map":"viewport"),"auto"===this.layout.get("text-rotation-alignment")&&(this.layout._values["text-rotation-alignment"]="point"!==this.layout.get("symbol-placement")?"map":"viewport"),"auto"===this.layout.get("text-pitch-alignment")&&(this.layout._values["text-pitch-alignment"]=this.layout.get("text-rotation-alignment")),"auto"===this.layout.get("icon-pitch-alignment")&&(this.layout._values["icon-pitch-alignment"]=this.layout.get("icon-rotation-alignment"));const r=this.layout.get("text-writing-mode");if(r){const t=[];for(const e of r)t.indexOf(e)<0&&t.push(e);this.layout._values["text-writing-mode"]=t;}else this.layout._values["text-writing-mode"]="point"===this.layout.get("symbol-placement")?["horizontal"]:["horizontal","vertical"];this._setPaintOverrides();}getValueAndResolveTokens(t,e,r,n){const i=this.layout.get(t).evaluate(e,{},r,n),a=this._unevaluatedLayout._values[t];return a.isDataDriven()||$i(a.value)||!i?i:function(t,e){return e.replace(/{([^{}]+)}/g,((e,r)=>r in t?String(t[r]):""))}(e.properties,i)}createBucket(t){return new Mg(t)}queryRadius(){return 0}queryIntersectsFeature(){return !1}_setPaintOverrides(){for(const t of Sg.paint.overridableProperties){if(!kg.hasPaintOverride(this.layout,t))continue;const e=this.paint.get(t),r=new Ig(e),n=new qi(r,e.property.specification,this.scope,this.options);let i=null;i="constant"===e.value.kind||"source"===e.value.kind?new Yi("source",n):new Xi("composite",n,e.value.zoomStops,e.value._interpolationType),this.paint._values[t]=new Da(e.property,i,e.parameters);}}_handleOverridablePaintPropertyUpdate(t,e,r){return !(!this.layout||e.isDataDriven()||r.isDataDriven())&&kg.hasPaintOverride(this.layout,t)}static hasPaintOverride(t,e){const r=t.get("text-field"),n=Sg.paint.properties[e];let i=!1;const a=t=>{for(const e of t)if(n.overrides&&n.overrides.hasOverride(e))return void(i=!0)};if("constant"===r.value.kind&&r.value.value instanceof De)a(r.value.value.sections);else if("source"===r.value.kind){const t=e=>{i||(e instanceof je&&Ne(e.value)===Se?a(e.value.sections):e instanceof Xe?a(e.sections):e.eachChild(t));},e=r.value;e._styleExpression&&t(e._styleExpression.expression);}return i}getProgramIds(){const t=0!==this.paint.get("icon-opacity").constantOr(1),e=0!==this.paint.get("text-opacity").constantOr(1),r=[];return t&&r.push("symbolIcon"),e&&r.push("symbolSDF"),r}getDefaultProgramParams(t,e){return {config:new Do(this,e),overrideFog:!1}}}const Pg=new Oa({visibility:new La(qa.layout_background.visibility)});var Eg={paint:new Oa({"background-color":new La(qa.paint_background["background-color"]),"background-pattern":new La(qa.paint_background["background-pattern"]),"background-opacity":new La(qa.paint_background["background-opacity"]),"background-emissive-strength":new La(qa.paint_background["background-emissive-strength"])}),layout:Pg};const zg=new Oa({visibility:new La(qa.layout_raster.visibility)});var Tg={paint:new Oa({"raster-opacity":new La(qa.paint_raster["raster-opacity"]),"raster-color":new Na(qa.paint_raster["raster-color"]),"raster-color-mix":new La(qa.paint_raster["raster-color-mix"]),"raster-color-range":new La(qa.paint_raster["raster-color-range"]),"raster-hue-rotate":new La(qa.paint_raster["raster-hue-rotate"]),"raster-brightness-min":new La(qa.paint_raster["raster-brightness-min"]),"raster-brightness-max":new La(qa.paint_raster["raster-brightness-max"]),"raster-saturation":new La(qa.paint_raster["raster-saturation"]),"raster-contrast":new La(qa.paint_raster["raster-contrast"]),"raster-resampling":new La(qa.paint_raster["raster-resampling"]),"raster-fade-duration":new La(qa.paint_raster["raster-fade-duration"]),"raster-emissive-strength":new La(qa.paint_raster["raster-emissive-strength"]),"raster-array-band":new La(qa.paint_raster["raster-array-band"]),"raster-elevation":new La(qa.paint_raster["raster-elevation"])}),layout:zg},Bg=cs([{name:"a_pos",type:"Int16",components:2},{name:"a_texture_pos",type:"Int16",components:2}]);class Cg{constructor(t,e,r,n){this.context=t,this.format=r,this.texture=t.gl.createTexture(),this.update(e,n);}update(t,e,r){const{width:n,height:i}=t,{context:a}=this,{gl:s}=a;if(s.bindTexture(s.TEXTURE_2D,this.texture),a.pixelStoreUnpackFlipY.set(!1),a.pixelStoreUnpack.set(1),a.pixelStoreUnpackPremultiplyAlpha.set(this.format===s.RGBA&&(!e||!1!==e.premultiply)),r||this.size&&this.size[0]===n&&this.size[1]===i){const{x:e,y:a}=r||{x:0,y:0};if(t instanceof HTMLImageElement||t instanceof HTMLCanvasElement||t instanceof HTMLVideoElement||t instanceof ImageData||ImageBitmap&&t instanceof ImageBitmap)s.texSubImage2D(s.TEXTURE_2D,0,e,a,s.RGBA,s.UNSIGNED_BYTE,t);else {let r=this.format,o=s.UNSIGNED_BYTE;this.format===s.R32F&&(r=s.RED,o=s.FLOAT),s.texSubImage2D(s.TEXTURE_2D,0,e,a,n,i,r,o,t.data);}}else if(this.size=[n,i],t instanceof HTMLImageElement||t instanceof HTMLCanvasElement||t instanceof HTMLVideoElement||t instanceof ImageData||ImageBitmap&&t instanceof ImageBitmap){let e=this.format;this.format===s.R8&&(e=s.RED),s.texImage2D(s.TEXTURE_2D,0,this.format,e,s.UNSIGNED_BYTE,t);}else {let e=this.format,r=this.format,a=s.UNSIGNED_BYTE;this.format===s.DEPTH_COMPONENT&&(e=s.DEPTH_COMPONENT16,a=s.UNSIGNED_SHORT),this.format===s.R8&&(r=s.RED),this.format===s.R32F&&(a=s.FLOAT,r=s.RED),s.texImage2D(s.TEXTURE_2D,0,e,n,i,0,r,a,t.data);}this.useMipmap=Boolean(e&&e.useMipmap),this.useMipmap&&s.generateMipmap(s.TEXTURE_2D);}bind(t,e,r=!1){const{context:n}=this,{gl:i}=n;i.bindTexture(i.TEXTURE_2D,this.texture),t!==this.minFilter&&(i.texParameteri(i.TEXTURE_2D,i.TEXTURE_MAG_FILTER,t),i.texParameteri(i.TEXTURE_2D,i.TEXTURE_MIN_FILTER,this.useMipmap&&!r?t===i.NEAREST?i.NEAREST_MIPMAP_NEAREST:i.LINEAR_MIPMAP_LINEAR:t),this.minFilter=t),e!==this.wrapS&&(i.texParameteri(i.TEXTURE_2D,i.TEXTURE_WRAP_S,e),i.texParameteri(i.TEXTURE_2D,i.TEXTURE_WRAP_T,e),this.wrapS=e);}bindExtraParam(t,e,r,n){const{context:i}=this,{gl:a}=i;a.bindTexture(a.TEXTURE_2D,this.texture),e!==this.magFilter&&(a.texParameteri(a.TEXTURE_2D,a.TEXTURE_MAG_FILTER,e),this.magFilter=e),t!==this.minFilter&&(a.texParameteri(a.TEXTURE_2D,a.TEXTURE_MIN_FILTER,this.useMipmap?t===a.NEAREST?a.NEAREST_MIPMAP_NEAREST:a.LINEAR_MIPMAP_LINEAR:t),this.minFilter=t),r!==this.wrapS&&(a.texParameteri(a.TEXTURE_2D,a.TEXTURE_WRAP_S,r),this.wrapS=r),n!==this.wrapT&&(a.texParameteri(a.TEXTURE_2D,a.TEXTURE_WRAP_T,n),this.wrapT=n);}destroy(){const{gl:t}=this.context;t.deleteTexture(this.texture),this.texture=null;}}class Rg{constructor(t,e){this.context=t,this.texture=e;}bind(t,e){const{context:r}=this,{gl:n}=r;n.bindTexture(n.TEXTURE_2D,this.texture),t!==this.minFilter&&(n.texParameteri(n.TEXTURE_2D,n.TEXTURE_MAG_FILTER,t),n.texParameteri(n.TEXTURE_2D,n.TEXTURE_MIN_FILTER,t),this.minFilter=t),e!==this.wrapS&&(n.texParameteri(n.TEXTURE_2D,n.TEXTURE_WRAP_S,e),n.texParameteri(n.TEXTURE_2D,n.TEXTURE_WRAP_T,e),this.wrapS=e);}}function Dg(e,r,n,i,a,s,o,l){const u=[e,r,1,n,i,1,a,s,1],c=[o,l,1],h=t.co.adjoint([],u),[p,f,d]=t.N.transformMat3(c,c,h);return t.co.multiply(u,u,[p,0,0,0,f,0,0,0,d])}function Vg(e,r,n,i,a,s,o,l){const u=function(e,r,n,i,a,s,o,l){const u=Dg(0,0,1,0,1,1,0,1),c=Dg(e,r,n,i,a,s,o,l),h=t.co.adjoint([],u);return t.co.multiply(c,c,h)}(e,r,n,i,a,s,o,l);return [u[2]/u[8]/Tr,u[5]/u[8]/Tr]}function Lg(t){return [t[0],Math.min(Math.max(t[1],-xl),xl)]}class Fg extends ee{constructor(t,e,r,n){super(),this.id=t,this.dispatcher=r,this.coordinates=e.coordinates,this.type="image",this.minzoom=0,this.maxzoom=22,this.tileSize=512,this.tiles={},this._loaded=!1,this.onNorthPole=!1,this.onSouthPole=!1,this.setEventedParent(n),this.options=e,this._dirty=!1;}load(t,e){if(this._loaded=e||!1,this.fire(new Qt("dataloading",{dataType:"source"})),this.url=this.options.url,!this.url)return t&&(this.coordinates=t),this._loaded=!0,void this._finishLoading();this._imageRequest=Ct(this.map._requestManager.transformRequest(this.url,At.Image),((e,r)=>{this._imageRequest=null,this._loaded=!0,e?this.fire(new te(e)):r&&(this.image=r instanceof HTMLImageElement?st.getImageData(r):r,this._dirty=!0,this.width=this.image.width,this.height=this.image.height,t&&(this.coordinates=t),this._finishLoading());}));}loaded(){return this._loaded}updateImage(t){return t.url?(this._imageRequest&&t.url!==this.options.url&&(this._imageRequest.cancel(),this._imageRequest=null),this.options.url=t.url,this.load(t.coordinates,this._loaded),this):this}setTexture(t){if(!(t.handle instanceof WebGLTexture))throw new Error("The provided handle is not a WebGLTexture instance");return this.texture=new Rg(this.map.painter.context,t.handle),this.width=t.dimensions[0],this.height=t.dimensions[1],this._dirty=!1,this._loaded=!0,this._finishLoading(),this}_finishLoading(){this.map&&(this.setCoordinates(this.coordinates),this.fire(new Qt("data",{dataType:"source",sourceDataType:"metadata"})));}onAdd(t){this.map=t,this.load();}onRemove(){this._imageRequest&&(this._imageRequest.cancel(),this._imageRequest=null),!this.texture||this.texture instanceof Rg||this.texture.destroy(),this.boundsBuffer&&(this.boundsBuffer.destroy(),this.elevatedGlobeVertexBuffer&&this.elevatedGlobeVertexBuffer.destroy(),this.elevatedGlobeIndexBuffer&&this.elevatedGlobeIndexBuffer.destroy());}setCoordinates(t){if(this.coordinates=t,this._boundsArray=void 0,this._unsupportedCoords=!1,!t.length)return this;this.onNorthPole=!1,this.onSouthPole=!1;let e=t[0][1],r=t[0][1];for(const n of t)n[1]>r&&(r=n[1]),n[1]<e&&(e=n[1]);const n=(r+e)/2;if(n>xl?this.onNorthPole=!0:n<-xl&&(this.onSouthPole=!0),!this.onNorthPole&&!this.onSouthPole){const e=t.map(Ml.fromLngLat);this.tileID=function(t){let e=1/0,r=1/0,n=-1/0,i=-1/0;for(const a of t)e=Math.min(e,a.x),r=Math.min(r,a.y),n=Math.max(n,a.x),i=Math.max(i,a.y);const a=Math.max(n-e,i-r),s=Math.max(0,Math.floor(-Math.log(a)/Math.LN2)),o=Math.pow(2,s);let l=Math.floor((e+n)/2*o);return l>1&&(l-=1),new il(s,l,Math.floor((r+i)/2*o))}(e),this.minzoom=this.maxzoom=this.tileID.z;}return this.fire(new Qt("data",{dataType:"source",sourceDataType:"content"})),this}_clear(){this._boundsArray=void 0,this._unsupportedCoords=!1;}_prepareData(e){for(const t in this.tiles){const e=this.tiles[t];"loaded"!==e.state&&(e.state="loaded",e.texture=this.texture);}if(this._boundsArray||this.onNorthPole||this.onSouthPole||this._unsupportedCoords)return;const r=Gy(new il(0,0,0),this.map.transform.projection),n=[r.projection.project(this.coordinates[0][0],this.coordinates[0][1]),r.projection.project(this.coordinates[1][0],this.coordinates[1][1]),r.projection.project(this.coordinates[2][0],this.coordinates[2][1]),r.projection.project(this.coordinates[3][0],this.coordinates[3][1])];if(!function(t){const e=t[1].x-t[0].x,r=t[1].y-t[0].y,n=t[2].x-t[1].x,i=t[2].y-t[1].y,a=t[3].x-t[2].x,s=t[3].y-t[2].y,o=t[0].x-t[3].x,l=t[0].y-t[3].y,u=e*i-n*r,c=n*s-a*i,h=a*l-o*s,p=o*r-e*l;return u>0&&c>0&&h>0&&p>0||u<0&&c<0&&h<0&&p<0}(n))return console.warn("Image source coordinates are defining non-convex area in the Mercator projection"),void(this._unsupportedCoords=!0);const i=Gy(this.tileID,this.map.transform.projection),[a,s,o,l]=this.coordinates.map((t=>{const e=i.projection.project(t[0],t[1]);return Yy(i,e)._round()}));this.perspectiveTransform=Vg(a.x,a.y,s.x,s.y,o.x,o.y,l.x,l.y);const u=this._boundsArray=new ds;u.emplaceBack(a.x,a.y,0,0),u.emplaceBack(s.x,s.y,Tr,0),u.emplaceBack(l.x,l.y,0,Tr),u.emplaceBack(o.x,o.y,Tr,Tr),this.boundsBuffer&&(this.boundsBuffer.destroy(),this.elevatedGlobeVertexBuffer&&this.elevatedGlobeVertexBuffer.destroy(),this.elevatedGlobeIndexBuffer&&this.elevatedGlobeIndexBuffer.destroy()),this.boundsBuffer=e.createVertexBuffer(u,Bg.members),this.boundsSegments=eo.simpleSegment(0,0,4,2);const c=[],h=[Lg((p=this.coordinates)[0]),Lg(p[1]),Lg(p[2]),Lg(p[3])];var p;const[f,d,m,y]=function(t){let e=t[0][0],r=e,n=t[0][1],i=n;for(let a=1;a<t.length;a++)t[a][0]<e?e=t[a][0]:t[a][0]>r&&(r=t[a][0]),t[a][1]<n?n=t[a][1]:t[a][1]>i&&(i=t[a][1]);return [e,n,r-e,i-n]}(h);{const i=new ds,[a,s,o,l]=function(t){let e=t[0].x,r=e,n=t[0].y,i=n;for(let a=1;a<t.length;a++)t[a].x<e?e=t[a].x:t[a].x>r&&(r=t[a].x),t[a].y<n?n=t[a].y:t[a].y>i&&(i=t[a].y);return [e,n,r-e,i-n]}(n),u=t=>[(t.x-a)/o,(t.y-s)/l],[h,p,g,x]=n.map(u),v=function(e,r,n,i,a,s,o,l){const u=Dg(0,0,1,0,1,1,0,1),c=Dg(e,r,n,i,a,s,o,l),h=t.co.adjoint([],c);return t.co.multiply(u,u,h)}(h[0],h[1],p[0],p[1],g[0],g[1],x[0],x[1]);this.elevatedGlobePerspectiveTransform=Vg(h[0],h[1],p[0],p[1],g[0],g[1],x[0],x[1]);const b=(e,r)=>{c.push(e.lng);const n=Math.round((e.lng-f)/m*Tr),a=Math.round((e.lat-d)/y*Tr),s=u(r),o=t.N.transformMat3([],[s[0],s[1],1],v),l=Math.round(o[0]/o[2]*Tr),h=Math.round(o[1]/o[2]*Tr);i.emplaceBack(n,a,l,h);},_=n[3].x-n[0].x,w=n[3].y-n[0].y,M=n[2].x-n[1].x,A=n[2].y-n[1].y;for(let t=0;t<65;t++){const e=t/64,i=[n[0].x+e*_,n[0].y+e*w],a=[n[1].x+e*M,n[1].y+e*A],s=a[0]-i[0],o=a[1]-i[1];for(let t=0;t<65;t++){const e=t/64,n={x:i[0]+s*e,y:i[1]+o*e,z:0};b(r.projection.unproject(n.x,n.y),n);}}this.elevatedGlobeVertexBuffer=e.createVertexBuffer(i,Bg.members);}{this.maxLongitudeTriangleSize=0;let t=[],r=new Es;const n=(e,n,i)=>{r.emplaceBack(e,n,i);const a=c[e],s=c[n],o=c[i],l=Math.min(Math.min(a,s),o),u=Math.max(Math.max(a,s),o)-l;u>this.maxLongitudeTriangleSize&&(this.maxLongitudeTriangleSize=u),t.push(l+u/2);};for(let t=0;t<64;t++)for(let e=0;e<64;e++){const r=65*t+e,i=r+1,a=r+65,s=a+1;n(r,a,i),n(i,a,s);}[t,r]=function(t,e){const r=Array.from({length:t.length},((t,e)=>e));r.sort(((e,r)=>t[e]-t[r]));const n=[],i=new Es;for(let a=0;a<r.length;a++){const s=r[a];n.push(t[s]);const o=3*s,l=o+1;i.emplaceBack(e.uint16[o],e.uint16[l],e.uint16[l+1]);}return [n,i]}(t,r),this.elevatedGlobeTrianglesCenterLongitudes=t,this.elevatedGlobeIndexBuffer=e.createIndexBuffer(r);}this.elevatedGlobeSegments=eo.simpleSegment(0,0,4225,8192),this.elevatedGlobeGridMatrix=new Float32Array([0,m/Tr,0,y/Tr,0,0,d,f,0]);}prepare(){const t=0!==Object.keys(this.tiles).length;if(this.tileID&&!t)return;const e=this.map.painter.context,r=e.gl;!this._dirty||this.texture instanceof Rg||(this.texture?this.texture.update(this.image):(this.texture=new Cg(e,this.image,r.RGBA),this.texture.bind(r.LINEAR,r.CLAMP_TO_EDGE)),this._dirty=!1),t&&this._prepareData(e);}loadTile(t,e){this.tileID&&this.tileID.equals(t.tileID.canonical)?(this.tiles[String(t.tileID.wrap)]=t,t.buckets={},e(null)):(t.state="errored",e(null));}serialize(){return {type:"image",url:this.options.url,coordinates:this.coordinates}}hasTransition(){return !1}getSegmentsForLongitude(t){const e=this.elevatedGlobeSegments;if(!this.elevatedGlobeTrianglesCenterLongitudes||!e)return null;const r=this.elevatedGlobeTrianglesCenterLongitudes;let n=((t,e)=>t+360*Math.round((e-t)/360))(t+180,r[0]);const i=new eo,a=(t,r)=>{i.segments.push({vertexOffset:0,primitiveOffset:t,vertexLength:e.segments[0].vertexLength,primitiveLength:r,sortKey:void 0,vaos:{}});},s=.51*this.maxLongitudeTriangleSize;if(Math.abs(r[0]-n)<=s){const t=it(r,0,r.length,n+s);return t===r.length||a(t,nt(r,t+1,r.length,n+360-s)-t),i}n<r[0]&&(n+=360);const o=nt(r,0,r.length,n-s);if(o===r.length)return a(0,r.length),i;a(0,o-0);const l=it(r,o+1,r.length,n+s);return l!==r.length&&a(l,r.length-l),i}}const Ng=(Math.pow(256,2)-1)/16907520;class Og extends ss{constructor(t,e,r){super(t,Tg,e,r),this.updateColorRamp(),this._curRampRange=[NaN,NaN];}getProgramIds(){return ["raster"]}hasColorMap(){return !!this._transitionablePaint._values["raster-color"].value.value}tileCoverLift(){return this.paint.get("raster-elevation")}isLayerDraped(t){return !(t&&t._source instanceof Fg&&(t._source.onNorthPole||t._source.onSouthPole))&&0===this.paint.get("raster-elevation")}_handleSpecialPaintPropertyUpdate(t){"raster-color"!==t&&"raster-color-range"!==t||(this._curRampRange=[NaN,NaN],this.updateColorRamp());}updateColorRamp(t){if(!this.hasColorMap())return;if(!this._curRampRange)return;const e=this._transitionablePaint._values["raster-color"].value.expression,[r,n]=t||this._transitionablePaint._values["raster-color-range"].value.expression.evaluate({zoom:0})||[NaN,NaN];isNaN(r)&&isNaN(n)||r===this._curRampRange[0]&&n===this._curRampRange[1]||(this.colorRamp=Ap({expression:e,evaluationKey:"rasterValue",image:this.colorRamp,clips:[{start:r,end:n}],resolution:256}),this.colorRampTexture=null,this._curRampRange=[r,n]);}}const Ug=new Oa({visibility:new La(qa["layout_raster-particle"].visibility)});var jg={paint:new Oa({"raster-particle-array-band":new La(qa["paint_raster-particle"]["raster-particle-array-band"]),"raster-particle-count":new La(qa["paint_raster-particle"]["raster-particle-count"]),"raster-particle-color":new Na(qa["paint_raster-particle"]["raster-particle-color"]),"raster-particle-max-speed":new La(qa["paint_raster-particle"]["raster-particle-max-speed"]),"raster-particle-speed-factor":new La(qa["paint_raster-particle"]["raster-particle-speed-factor"]),"raster-particle-fade-opacity-factor":new La(qa["paint_raster-particle"]["raster-particle-fade-opacity-factor"]),"raster-particle-reset-rate-factor":new La(qa["paint_raster-particle"]["raster-particle-reset-rate-factor"])}),layout:Ug};class qg extends ss{constructor(t,e,r){super(t,jg,e,r),this._updateColorRamp(),this.onRemove=t=>{this.colorRampTexture&&this.colorRampTexture.destroy(),this.transformFeedbackObject&&t.painter.context.gl.deleteTransformFeedback(this.transformFeedbackObject),this.tileFramebuffer&&this.tileFramebuffer.destroy();},this.lastInvalidatedAt=st.now();}hasColorMap(){return !!this._transitionablePaint._values["raster-particle-color"].value.value}getProgramIds(){return ["rasterParticle"]}hasOffscreenPass(){return "none"!==this.visibility}isLayerDraped(t){return !1}_handleSpecialPaintPropertyUpdate(t){"raster-particle-color"!==t&&"raster-particle-max-speed"!==t||(this._updateColorRamp(),this._invalidateAnimationState()),"raster-particle-count"===t&&this._invalidateAnimationState();}_updateColorRamp(){if(!this.hasColorMap())return;const t=this._transitionablePaint._values["raster-particle-color"].value.expression,e=this._transitionablePaint._values["raster-particle-max-speed"].value.expression.evaluate({zoom:0});this.colorRamp=Ap({expression:t,evaluationKey:"rasterParticleSpeed",image:this.colorRamp,clips:[{start:0,end:e}],resolution:256}),this.colorRampTexture=null;}_invalidateAnimationState(){this.lastInvalidatedAt=st.now();}}class $g extends ss{constructor(t,e){super(t,{},e),this.implementation=t,t.slot&&(this.slot=t.slot);}is3D(){return "3d"===this.implementation.renderingMode}hasOffscreenPass(){return void 0!==this.implementation.prerender}isLayerDraped(t){return void 0!==this.implementation.renderToTile}shouldRedrape(){return !!this.implementation.shouldRerenderTiles&&this.implementation.shouldRerenderTiles()}recalculate(){}updateTransitions(){}hasTransition(){return !1}serialize(){}onAdd(t){this.implementation.onAdd&&this.implementation.onAdd(t,t.painter.context.gl);}onRemove(t){this.implementation.onRemove&&this.implementation.onRemove(t,t.painter.context.gl);}}const Gg=new Oa({visibility:new La(qa.layout_sky.visibility)});var Yg={paint:new Oa({"sky-type":new La(qa.paint_sky["sky-type"]),"sky-atmosphere-sun":new La(qa.paint_sky["sky-atmosphere-sun"]),"sky-atmosphere-sun-intensity":new La(qa.paint_sky["sky-atmosphere-sun-intensity"]),"sky-gradient-center":new La(qa.paint_sky["sky-gradient-center"]),"sky-gradient-radius":new La(qa.paint_sky["sky-gradient-radius"]),"sky-gradient":new Na(qa.paint_sky["sky-gradient"]),"sky-atmosphere-halo-color":new La(qa.paint_sky["sky-atmosphere-halo-color"]),"sky-atmosphere-color":new La(qa.paint_sky["sky-atmosphere-color"]),"sky-opacity":new La(qa.paint_sky["sky-opacity"])}),layout:Gg};function Xg(e,r,n){const i=[0,0,1],a=t.bi.identity([]);return t.bi.rotateY(a,a,n?-b(e)+Math.PI:b(e)),t.bi.rotateX(a,a,-b(r)),t.N.transformQuat(i,i,a),t.N.normalize(i,i)}var Zg={paint:new Oa({})};function Kg(e,r){const n=Wg(e.projection,e.zoom,e.width,e.height),i=function(e,r,n,i,a){const s=new tl(n.lng-180*Jg,n.lat),o=new tl(n.lng+180*Jg,n.lat),l=e.project(s.lng,s.lat),u=e.project(o.lng,o.lat),c=-Math.atan2(u.y-l.y,u.x-l.x),h=Ml.fromLngLat(n);h.y=I(h.y,-1+Jg,1-Jg);const p=h.toLngLat(),f=e.project(p.lng,p.lat),d=Ml.fromLngLat(p);d.x+=Jg;const m=d.toLngLat(),y=e.project(m.lng,m.lat),g=tx(y.x-f.x,y.y-f.y,c),x=Ml.fromLngLat(p);x.y+=Jg;const v=x.toLngLat(),b=e.project(v.lng,v.lat),_=tx(b.x-f.x,b.y-f.y,c),w=Math.abs(g.x)/Math.abs(_.y),M=t.a6.identity([]);t.a6.rotateZ(M,M,-c*(1-(a?0:i)));const A=t.a6.identity([]);return t.a6.scale(A,A,[1,1-(1-w)*i,1]),A[4]=-_.x/_.y*i,t.a6.rotateZ(A,A,c),t.a6.multiply(A,M,A),A}(e.projection,0,e.center,n,r),a=Hg(e);return t.a6.scale(i,i,[a,a,1]),i}function Hg(t){const e=t.projection,r=Wg(t.projection,t.zoom,t.width,t.height),n=Qg(e,t.center),i=Qg(e,tl.convert(e.center));return Math.pow(2,n*r+(1-r)*i)}function Wg(t,e,r,n,i=1/0){const a=t.range;if(!a)return 0;const s=Math.min(i,Math.max(r,n)),o=Math.log(s/1024)/Math.LN2;return k(a[0]+o,a[1]+o,e)}const Jg=1/4e4;function Qg(t,e){const r=I(e.lat,-xl,xl),n=new tl(e.lng-180*Jg,r),i=new tl(e.lng+180*Jg,r),a=t.project(n.lng,r),s=t.project(i.lng,r),o=Ml.fromLngLat(n),l=Ml.fromLngLat(i),u=s.x-a.x,c=s.y-a.y,h=l.x-o.x,p=l.y-o.y,f=Math.sqrt((h*h+p*p)/(u*u+c*c));return Math.log(f)/Math.LN2}function tx(t,e,r){const n=Math.cos(r),i=Math.sin(r);return {x:t*n-e*i,y:t*i+e*n}}function ex(e,r,n){t.a6.identity(e),t.a6.rotateZ(e,e,b(r[2])),t.a6.rotateX(e,e,b(r[0])),t.a6.rotateY(e,e,b(r[1])),t.a6.scale(e,e,n),t.a6.multiply(e,e,[1,0,0,0,0,0,1,0,0,1,0,0,0,0,0,1]);}function rx(e,r,n,i,a,s,o,l){const u=[n[0]-r[0],n[1]-r[1],0],c=[i[0]-r[0],i[1]-r[1],0];if(t.N.length(u)<1e-12||t.N.length(c)<1e-12)return t.bi.identity(e);const h=t.N.cross([],u,c);t.N.normalize(h,h),t.N.subtract(c,i,r),u[2]=(s-a)*l,c[2]=(o-a)*l;const p=u;return t.N.cross(p,u,c),t.N.normalize(p,p),t.bi.rotationTo(e,h,p)}function nx(e,r,n=!1){const i=rp(r.zoom),a=function(e,r,n){const i=r.worldSize,a=[e[12],e[13],e[14]],s=yl(a[1]/i),o=ml(a[0]/i),l=t.a6.identity([]),u=dl(1,s)*i,c=dl(1,0)*i*bl(s,r.zoom),h=1/Qh(i);let p=c*h;if(n){const t=Wg(r.projection,r.zoom,r.width,r.height,1024);p=h*r.projection.pixelSpaceConversion(r.center.lat,i,t);}const f=Wo(s,o);t.N.add(f,f,t.N.scale([],t.N.normalize([],f),u*p*a[2]));const d=function(e){const r=[e[0],e[1],e[2]];let n=[0,1,0];const i=t.N.cross([],n,r);return t.N.cross(n,r,i),0===t.N.squaredLength(n)&&(n=[0,1,0],t.N.cross(i,r,n)),t.N.normalize(i,i),t.N.normalize(n,n),t.N.normalize(r,r),[i[0],i[1],i[2],0,n[0],n[1],n[2],0,r[0],r[1],r[2],0,e[0],e[1],e[2],1]}(f);t.a6.scale(l,l,[p,p,p*u]),t.a6.translate(l,l,[-a[0],-a[1],-a[2]]);const m=t.a6.multiply([],r.globeMatrix,d);return t.a6.multiply(m,m,l),t.a6.multiply(m,m,e),m}(e,r,n);if(i>0){const n=function(e,r){const n=r.worldSize,i=dl(1,0)*n*bl(r.center.lat,r.zoom)/Qh(n),a=dl(1,r.center.lat)*n,s=t.a6.identity([]);return t.a6.rotateY(s,s,b(r.center.lng)),t.a6.rotateX(s,s,b(r.center.lat)),t.a6.translate(s,s,[0,0,jo]),t.a6.scale(s,s,[i,i,i*a]),t.a6.translate(s,s,[r.point.x-.5*n,r.point.y-.5*n,0]),t.a6.multiply(s,s,e),t.a6.multiply(s,r.globeMatrix,s)}(e,r);return function(e,r,n){const i=(e,r,n)=>{const i=t.N.length(e),a=t.N.length(r),s=qh(e,r,n);return t.N.scale(s,s,1/t.N.length(s)*ue(i,a,n))},a=i([e[0],e[1],e[2]],[r[0],r[1],r[2]],n),s=i([e[4],e[5],e[6]],[r[4],r[5],r[6]],n),o=i([e[8],e[9],e[10]],[r[8],r[9],r[10]],n),l=qh([e[12],e[13],e[14]],[r[12],r[13],r[14]],n);return [a[0],a[1],a[2],0,s[0],s[1],s[2],0,o[0],o[1],o[2],0,l[0],l[1],l[2],1]}(a,n,i)}return a}function ix(t,e,r,n){const i=Bh.projectAabbCorners(n,r);let a=Number.MAX_VALUE,s=-1;for(let t=0;t<i.length;++t){const r=i[t];r[0]=(.5*r[0]+.5)*e.width,r[1]=(.5-.5*r[1])*e.height,r[2]<a&&(s=t,a=r[2]);}const o=t=>new g(i[t][0],i[t][1]);let l;switch(s){case 0:case 6:l=[o(1),o(5),o(4),o(7),o(3),o(2),o(1)];break;case 1:case 7:l=[o(0),o(4),o(5),o(6),o(2),o(3),o(0)];break;case 3:case 5:l=[o(1),o(0),o(4),o(7),o(6),o(2),o(1)];break;default:l=[o(1),o(5),o(6),o(7),o(3),o(0),o(1)];}if(Vl(t,l))return a}const ax=cs([{name:"a_pos_3f",components:3,type:"Float32"}]),sx=cs([{name:"a_color_3f",components:3,type:"Float32"}]),ox=cs([{name:"a_color_4f",components:4,type:"Float32"}]),lx=cs([{name:"a_uv_2f",components:2,type:"Float32"}]),ux=cs([{name:"a_normal_3f",components:3,type:"Float32"}]),cx=cs([{name:"a_normal_matrix0",components:4,type:"Float32"},{name:"a_normal_matrix1",components:4,type:"Float32"},{name:"a_normal_matrix2",components:4,type:"Float32"},{name:"a_normal_matrix3",components:4,type:"Float32"}]),hx=cs([{name:"a_pbr",components:4,type:"Uint16"},{name:"a_heightBasedEmissiveStrength",components:3,type:"Float32"}]);class px{constructor(t,e){this.feature=t,this.instancedDataOffset=e,this.instancedDataCount=0,this.rotation=[0,0,0],this.scale=[1,1,1],this.translation=[0,0,0];}}class fx{constructor(){this.instancedDataArray=new Ns,this.instancesEvaluatedElevation=[],this.features=[],this.idToFeaturesIndex={};}}class dx{constructor(t){this.zoom=t.zoom,this.canonical=t.canonical,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.fqid)),this.projection=t.projection,this.index=t.index,this.hasZoomDependentProperties=this.layers[0].isZoomDependent(),this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id)),this.hasPattern=!1,this.instancesPerModel={},this.validForExaggeration=0,this.maxVerticalOffset=0,this.maxScale=0,this.maxHeight=0,this.lookupDim=this.zoom>this.canonical.z?256:this.zoom>15?75:100,this.instanceCount=0,this.terrainElevationMin=0,this.terrainElevationMax=0,this.validForDEMTile={id:null,timestamp:0};}populate(t,e,r,n){this.tileToMeter=wl(r);const i=this.layers[0]._featureFilter.needGeometry;this.lookup=new Uint8Array(this.lookupDim*this.lookupDim);for(const{feature:a,id:s,index:o,sourceLayerIndex:l}of t){const t=Bl(a,i);if(!this.layers[0]._featureFilter.filter(new Pa(this.zoom),t,r))continue;const u={id:s,sourceLayerIndex:l,index:o,geometry:i?t.geometry:Tl(a,r,n),properties:a.properties,type:a.type,patterns:{}},c=this.addFeature(u,u.geometry,t);c&&e.featureIndex.insert(a,u.geometry,o,l,this.index,this.instancesPerModel[c].instancedDataArray.length,Tr/32);}this.lookup=null;}update(t,e,r,n){for(const e in this.instancesPerModel){const r=this.instancesPerModel[e];for(const e in t)r.idToFeaturesIndex.hasOwnProperty(e)&&this.evaluate(r.features[r.idToFeaturesIndex[e]],t[e],r,!0);}this.maxHeight=0;}updateZoomBasedPaintProperties(){if(!this.hasZoomDependentProperties)return !1;let e=!1;for(const r in this.instancesPerModel){const n=this.instancesPerModel[r];for(const r of n.features){const i=this.layers[0],a=r.feature,s=this.canonical,o=i.paint.get("model-rotation").evaluate(a,{},s),l=i.paint.get("model-scale").evaluate(a,{},s),u=i.paint.get("model-translation").evaluate(a,{},s);t.N.exactEquals(r.rotation,o)&&t.N.exactEquals(r.scale,l)&&t.N.exactEquals(r.translation,u)||(this.evaluate(r,r.featureStates,n,!0),e=!0);}}return e}isEmpty(){for(const t in this.instancesPerModel)if(0!==this.instancesPerModel[t].instancedDataArray.length)return !1;return !0}uploadPending(){return !this.uploaded}upload(t){if(!this.uploaded)for(const e in this.instancesPerModel){const r=this.instancesPerModel[e];r.instancedDataArray.length<0||0===r.instancedDataArray.length||(r.instancedDataBuffer?r.instancedDataBuffer.updateData(r.instancedDataArray):r.instancedDataBuffer=t.createVertexBuffer(r.instancedDataArray,cx.members,!0,void 0,this.instanceCount));}this.uploaded=!0;}destroy(){for(const t in this.instancesPerModel){const e=this.instancesPerModel[t];0!==e.instancedDataArray.length&&e.instancedDataBuffer&&e.instancedDataBuffer.destroy();}}addFeature(t,e,r){const n=this.layers[0],i=n.layout.get("model-id").evaluate(r,{},this.canonical);if(!i)return j(`modelId is not evaluated for layer ${n.id} and it is not going to get rendered.`),i;this.instancesPerModel[i]||(this.instancesPerModel[i]=new fx);const a=this.instancesPerModel[i],s=a.instancedDataArray,o=new px(r,s.length);for(const t of e)for(const e of t){if(e.x<0||e.x>=Tr||e.y<0||e.y>=Tr)continue;const t=(this.lookupDim-1)/Tr,r=this.lookupDim*(e.y*t|0)+e.x*t|0;if(this.lookup){if(0!==this.lookup[r])continue;this.lookup[r]=1;}this.instanceCount++;const n=s.length;s.resize(n+1),a.instancesEvaluatedElevation.push(0),s.float32[16*n]=e.x,s.float32[16*n+1]=e.y;}return o.instancedDataCount=a.instancedDataArray.length-o.instancedDataOffset,o.instancedDataCount>0&&(t.id&&(a.idToFeaturesIndex[t.id]=a.features.length),a.features.push(o),this.evaluate(o,{},a,!1)),i}evaluate(t,e,r,n){const i=this.layers[0],a=t.feature,s=this.canonical,o=t.rotation=i.paint.get("model-rotation").evaluate(a,e,s),l=t.scale=i.paint.get("model-scale").evaluate(a,e,s),u=t.translation=i.paint.get("model-translation").evaluate(a,e,s),c=i.paint.get("model-color").evaluate(a,e,s);c.a=i.paint.get("model-color-mix-intensity").evaluate(a,e,s);const h=[];this.maxVerticalOffset<u[2]&&(this.maxVerticalOffset=u[2]),this.maxScale=Math.max(Math.max(this.maxScale,l[0]),Math.max(l[1],l[2])),ex(h,o,l);const p=Math.round(100*c.a)+c.b/1.05;for(let e=0;e<t.instancedDataCount;++e){const i=t.instancedDataOffset+e,a=16*i,o=r.instancedDataArray.float32;let l=0;n&&(l=o[a+6]-r.instancesEvaluatedElevation[i]);const f=0|o[a+1];o[a]=(0|o[a])+c.r/1.05,o[a+1]=f+c.g/1.05,o[a+2]=p,o[a+3]=1/(s.z>10?this.tileToMeter:wl(s,f)),o[a+4]=u[0],o[a+5]=u[1],o[a+6]=u[2]+l,o[a+7]=h[0],o[a+8]=h[1],o[a+9]=h[2],o[a+10]=h[4],o[a+11]=h[5],o[a+12]=h[6],o[a+13]=h[8],o[a+14]=h[9],o[a+15]=h[10],r.instancesEvaluatedElevation[i]=u[2];}}}ra(dx,"ModelBucket",{omit:["layers"]}),ra(fx,"PerModelAttributes"),ra(px,"ModelFeature");const mx=new Oa({visibility:new La(qa.layout_model.visibility),"model-id":new Fa(qa.layout_model["model-id"])});var yx={paint:new Oa({"model-opacity":new La(qa.paint_model["model-opacity"]),"model-rotation":new Fa(qa.paint_model["model-rotation"]),"model-scale":new Fa(qa.paint_model["model-scale"]),"model-translation":new Fa(qa.paint_model["model-translation"]),"model-color":new Fa(qa.paint_model["model-color"]),"model-color-mix-intensity":new Fa(qa.paint_model["model-color-mix-intensity"]),"model-type":new La(qa.paint_model["model-type"]),"model-cast-shadows":new La(qa.paint_model["model-cast-shadows"]),"model-receive-shadows":new La(qa.paint_model["model-receive-shadows"]),"model-ambient-occlusion-intensity":new La(qa.paint_model["model-ambient-occlusion-intensity"]),"model-emissive-strength":new Fa(qa.paint_model["model-emissive-strength"]),"model-roughness":new Fa(qa.paint_model["model-roughness"]),"model-height-based-emissive-strength-multiplier":new Fa(qa.paint_model["model-height-based-emissive-strength-multiplier"]),"model-cutoff-fade-range":new La(qa.paint_model["model-cutoff-fade-range"])}),layout:mx};const gx=64,xx={CoordinateSpaceTile:1,CoordinateSpaceYUp:2,HasMapboxMeshFeatures:4,HasMeshoptCompression:8};function vx(e,r,n,i,a,s,o,l,u,c=!1){const h=n.zoom,p=n.project(i),f=bl(i.lat,h),d=1/f;t.a6.identity(e),t.a6.translate(e,e,[p.x+o[0]*d,p.y+o[1]*d,o[2]]);let m=1,y=1;const g=n.worldSize;if(c){if("mercator"===n.projection.name){let e=0;n.elevation&&(e=n.elevation.getAtPointOrZero(new Ml(p.x/g,p.y/g),0));const r=t.a7.transformMat4([],[p.x,p.y,e,1],n.projMatrix)[3]/n.cameraToCenterDistance;m=r,y=r*bl(n.center.lat,h);}else if("globe"===n.projection.name){const r=nx(e,n),a=t.a6.multiply([],n.projMatrix,r),s=[0,0,0,1];t.a7.transformMat4(s,s,a);const o=s[3]/n.cameraToCenterDistance,l=rp(h),u=n.projection.pixelsPerMeter(i.lat,g)*bl(i.lat,h),c=n.projection.pixelsPerMeter(n.center.lat,g)*bl(n.center.lat,h);m=o/ue(u,vl(n.center.lat),l),y=o*f/u,m*=c,y*=c;}}else m=d;t.a6.scale(e,e,[m,m,y]);const x=[...e],v=r.orientation,b=[];if(ex(b,[v[0]+a[0],v[1]+a[1],v[2]+a[2]],s),t.a6.multiply(e,x,b),l&&n.elevation){let a=0;const s=[];if(u&&n.elevation){a=function(e,r,n,i,a){const s=r.elevation;if(!s)return 0;const o=Bh.projectAabbCorners(n,i),l=dl(1,a.lat)*r.worldSize,u=function(e,r){const n=[0,0,1],i=[{corners:[0,1,3,2],dotProductWithUp:0},{corners:[1,5,2,6],dotProductWithUp:0},{corners:[0,4,1,5],dotProductWithUp:0},{corners:[2,6,3,7],dotProductWithUp:0},{corners:[4,7,5,6],dotProductWithUp:0},{corners:[0,3,4,7],dotProductWithUp:0}];for(const a of i){const i=e[a.corners[0]],s=e[a.corners[1]],o=e[a.corners[2]],l=[s[0]-i[0],s[1]-i[1],r*(s[2]-i[2])],u=t.N.cross(l,l,[o[0]-i[0],o[1]-i[1],r*(o[2]-i[2])]);t.N.normalize(u,u),a.dotProductWithUp=t.N.dot(u,n);}return i.sort(((t,e)=>t.dotProductWithUp-e.dotProductWithUp)),i[0].corners}(o,l),c=o[u[0]],h=o[u[1]],p=o[u[2]],f=o[u[3]],d=s.getAtPointOrZero(new Ml(c[0]/r.worldSize,c[1]/r.worldSize),0),m=s.getAtPointOrZero(new Ml(h[0]/r.worldSize,h[1]/r.worldSize),0),y=s.getAtPointOrZero(new Ml(p[0]/r.worldSize,p[1]/r.worldSize),0),g=s.getAtPointOrZero(new Ml(f[0]/r.worldSize,f[1]/r.worldSize),0),x=(d+g)/2,v=(m+y)/2;return x>v?m<y?rx(e,h,f,c,m,g,d,l):rx(e,p,c,f,y,d,g,l):d<g?rx(e,c,h,p,d,m,y,l):rx(e,f,p,h,g,y,m,l),Math.max(x,v)}(s,n,r.aabb,e,i);const o=t.a6.fromQuat([],s),l=t.a6.multiply([],o,b);t.a6.multiply(e,x,l);}else a=n.elevation.getAtPointOrZero(new Ml(p.x/g,p.y/g),0);0!==a&&(e[14]+=a);}}function bx(t,e,r=!1){t.uploaded||(t.gfxTexture=new Cg(e,t.image,r?e.gl.R8:e.gl.RGBA,{useMipmap:t.sampler.minFilter>=e.gl.NEAREST_MIPMAP_NEAREST}),t.uploaded=!0,t.image=null);}function _x(t,e,r){t.indexBuffer=e.createIndexBuffer(t.indexArray,!1,!0),t.vertexBuffer=e.createVertexBuffer(t.vertexArray,ax.members,!1,!0),t.normalArray&&(t.normalBuffer=e.createVertexBuffer(t.normalArray,ux.members,!1,!0)),t.texcoordArray&&(t.texcoordBuffer=e.createVertexBuffer(t.texcoordArray,lx.members,!1,!0)),t.colorArray&&(t.colorBuffer=e.createVertexBuffer(t.colorArray,(12===t.colorArray.bytesPerElement?sx:ox).members,!1,!0)),t.featureArray&&(t.pbrBuffer=e.createVertexBuffer(t.featureArray,hx.members,!0)),t.segments=eo.simpleSegment(0,0,t.vertexArray.length,t.indexArray.length);const n=t.material;n.pbrMetallicRoughness.baseColorTexture&&bx(n.pbrMetallicRoughness.baseColorTexture,e),n.pbrMetallicRoughness.metallicRoughnessTexture&&bx(n.pbrMetallicRoughness.metallicRoughnessTexture,e),n.normalTexture&&bx(n.normalTexture,e),n.occlusionTexture&&bx(n.occlusionTexture,e,r),n.emissionTexture&&bx(n.emissionTexture,e);}function wx(t,e,r){if(t.meshes)for(const n of t.meshes)_x(n,e,r);if(t.children)for(const n of t.children)wx(n,e,r);}function Mx(t){if(t.meshes)for(const e of t.meshes)e.indexArray.destroy(),e.vertexArray.destroy(),e.colorArray&&e.colorArray.destroy(),e.normalArray&&e.normalArray.destroy(),e.texcoordArray&&e.texcoordArray.destroy(),e.featureArray&&e.featureArray.destroy();if(t.children)for(const e of t.children)Mx(e);}function Ax(t){if(t.meshes)for(const r of t.meshes)r.vertexBuffer&&(r.vertexBuffer.destroy(),r.indexBuffer.destroy(),r.normalBuffer&&r.normalBuffer.destroy(),r.texcoordBuffer&&r.texcoordBuffer.destroy(),r.colorBuffer&&r.colorBuffer.destroy(),r.pbrBuffer&&r.pbrBuffer.destroy(),r.segments.destroy(),r.material&&((e=r.material).pbrMetallicRoughness.baseColorTexture&&e.pbrMetallicRoughness.baseColorTexture.gfxTexture&&e.pbrMetallicRoughness.baseColorTexture.gfxTexture.destroy(),e.pbrMetallicRoughness.metallicRoughnessTexture&&e.pbrMetallicRoughness.metallicRoughnessTexture.gfxTexture&&e.pbrMetallicRoughness.metallicRoughnessTexture.gfxTexture.destroy(),e.normalTexture&&e.normalTexture.gfxTexture&&e.normalTexture.gfxTexture.destroy(),e.emissionTexture&&e.emissionTexture.gfxTexture&&e.emissionTexture.gfxTexture.destroy(),e.occlusionTexture&&e.occlusionTexture.gfxTexture&&e.occlusionTexture.gfxTexture.destroy()));var e;if(t.children)for(const e of t.children)Ax(e);}class Sx{constructor(t){this._callback=t,this._triggered=!1,"undefined"!=typeof MessageChannel&&(this._channel=new MessageChannel,this._channel.port2.onmessage=()=>{this._triggered=!1,this._callback();});}trigger(){this._triggered||(this._triggered=!0,this._channel?this._channel.port1.postMessage(!0):setTimeout((()=>{this._triggered=!1,this._callback();}),0));}remove(){this._channel=void 0,this._callback=()=>{};}}class Ix{constructor(){this.tasks={},this.taskQueue=[],V(["process"],this),this.invoker=new Sx(this.process),this.nextId=0;}add(t,e){const r=this.nextId++,n=function({type:t,isSymbolTile:e,zoom:r}){return r=r||0,"message"===t?0:"maybePrepare"!==t||e?"parseTile"!==t||e?"parseTile"===t&&e?300-r:"maybePrepare"===t&&e?400-r:500:200-r:100-r}(e);if(0===n){Y();try{t();}finally{}return null}return this.tasks[r]={fn:t,metadata:e,priority:n,id:r},this.taskQueue.push(r),this.invoker.trigger(),{cancel:()=>{delete this.tasks[r];}}}process(){Y();try{if(this.taskQueue=this.taskQueue.filter((t=>!!this.tasks[t])),!this.taskQueue.length)return;const t=this.pick();if(null===t)return;const e=this.tasks[t];if(delete this.tasks[t],this.taskQueue.length&&this.invoker.trigger(),!e)return;e.fn();}finally{}}pick(){let t=null,e=1/0;for(let r=0;r<this.taskQueue.length;r++){const n=this.tasks[this.taskQueue[r]];n.priority<e&&(e=n.priority,t=r);}if(null===t)return null;const r=this.taskQueue[t];return this.taskQueue.splice(t,1),r}remove(){this.invoker.remove();}}class kx{constructor(t,e,r){this.target=t,this.parent=e,this.mapId=r,this.callbacks={},this.cancelCallbacks={},V(["receive"],this),this.target.addEventListener("message",this.receive,!1),this.scheduler=new Ix;}send(t,e,r,n,i=!1,a){const s=Math.round(1e18*Math.random()).toString(36).substring(0,10);r&&(r.metadata=a,this.callbacks[s]=r);const o=new Set;return this.target.postMessage({id:s,type:t,hasCallback:!!r,targetMapId:n,mustQueue:i,sourceMapId:this.mapId,data:aa(e,o)},o),{cancel:()=>{r&&delete this.callbacks[s],this.target.postMessage({id:s,type:"<cancel>",targetMapId:n,sourceMapId:this.mapId});}}}receive(t){const e=t.data,r=e.id;if(r&&(!e.targetMapId||this.mapId===e.targetMapId))if("<cancel>"===e.type){const t=this.cancelCallbacks[r];delete this.cancelCallbacks[r],t&&t.cancel();}else if(e.mustQueue||Y()){const t=this.callbacks[r],n=this.scheduler.add((()=>this.processTask(r,e)),t&&t.metadata||{type:"message"});n&&(this.cancelCallbacks[r]=n);}else this.processTask(r,e);}processTask(t,e){if(delete this.cancelCallbacks[t],"<response>"===e.type){const r=this.callbacks[t];delete this.callbacks[t],r&&(e.error?r(sa(e.error)):r(null,sa(e.data)));}else {const r=new Set,n=e.hasCallback?(e,n)=>{this.target.postMessage({id:t,type:"<response>",sourceMapId:this.mapId,error:e?aa(e):null,data:aa(n,r)},r);}:t=>{},i=sa(e.data);if(this.parent[e.type])this.parent[e.type](e.sourceMapId,i,n);else if(this.parent.getWorkerSource){const t=e.type.split(".");this.parent.getWorkerSource(e.sourceMapId,t[0],i.source,i.scope)[t[1]](i,n);}else n(new Error(`Could not find function ${e.type}`));}}remove(){this.scheduler.remove(),this.target.removeEventListener("message",this.receive,!1);}}class Px{constructor(t,e){this.workerPool=t,this.actors=[],this.currentActor=0,this.id=B();const r=this.workerPool.acquire(this.id);for(let t=0;t<r.length;t++){const n=new Px.Actor(r[t],e,this.id);n.name=`Worker ${t}`,this.actors.push(n);}this.ready=!1,this.broadcast("checkIfReady",null,(()=>{this.ready=!0;}));}broadcast(t,e,r){E(this.actors,((r,n)=>{r.send(t,e,n);}),r=r||function(){});}getActor(){return this.currentActor=(this.currentActor+1)%this.actors.length,this.actors[this.currentActor]}remove(){this.actors.forEach((t=>{t.remove();})),this.actors=[],this.workerPool.release(this.id);}}Px.Actor=kx;var Ex={workerUrl:"",workerClass:null,workerParams:void 0};function zx(){return null!=Ex.workerClass?new Ex.workerClass:new self.Worker(Ex.workerUrl,Ex.workerParams)}const Tx="mapboxgl_preloaded_worker_pool";class Bx{constructor(){this.active={};}acquire(t){if(!this.workers)for(this.workers=[];this.workers.length<Bx.workerCount;)this.workers.push(new zx);return this.active[t]=!0,this.workers.slice()}release(t){delete this.active[t],this.workers&&0===this.numActive()&&(this.workers.forEach((t=>{t.terminate();})),this.workers=null);}isPreloaded(){return !!this.active[Tx]}numActive(){return Object.keys(this.active).length}}let Cx;function Rx(){return Cx||(Cx=new Bx),Cx}Bx.workerCount=2;let Dx,Vx,Lx,Fx,Nx,Ox=null;function Ux(){return Y()&&self.worker&&self.worker.dracoUrl?self.worker.dracoUrl:Vx||n.DRACO_URL}function jx(){if(Y()&&self.worker&&self.worker.meshoptUrl)return self.worker.meshoptUrl;if(Fx)return Fx;const t=new Uint8Array([0,97,115,109,1,0,0,0,1,4,1,96,0,0,3,3,2,0,0,5,3,1,0,1,12,1,0,10,22,2,12,0,65,0,65,0,65,0,252,10,0,0,11,7,0,65,0,253,15,26,11]);if("object"!=typeof WebAssembly)throw new Error("WebAssembly not supported, cannot instantiate meshoptimizer");return Fx=WebAssembly.validate(t)?n.MESHOPT_SIMD_URL:n.MESHOPT_URL,Fx}const qx={5120:Int8Array,5121:Uint8Array,5122:Int16Array,5123:Uint16Array,5125:Uint32Array,5126:Float32Array},$x={5120:"DT_INT8",5121:"DT_UINT8",5122:"DT_INT16",5123:"DT_UINT16",5125:"DT_UINT32",5126:"DT_FLOAT32"},Gx={SCALAR:1,VEC2:2,VEC3:3,VEC4:4,MAT2:4,MAT3:9,MAT4:16};function Yx(t,e,r){const n=r.json.bufferViews.length,i=r.buffers.length;e.bufferView=n,r.json.bufferViews[n]={buffer:i,byteLength:t.byteLength},r.buffers[i]=t;}const Xx="KHR_draco_mesh_compression";function Zx(t,e){const r=t.extensions&&t.extensions[Xx];if(!r)return;const n=new Lx.Decoder,i=ev(e,r.bufferView),a=new Lx.Mesh;if(!n.DecodeArrayToMesh(i,i.byteLength,a))throw new Error("Failed to decode Draco mesh");const s=e.json.accessors[t.indices],o=qx[s.componentType],l=s.count*o.BYTES_PER_ELEMENT,u=Lx._malloc(l);o===Uint16Array?n.GetTrianglesUInt16Array(a,l,u):n.GetTrianglesUInt32Array(a,l,u),Yx(Lx.memory.buffer.slice(u,u+l),s,e),Lx._free(u);for(const i of Object.keys(r.attributes)){const s=n.GetAttributeByUniqueId(a,r.attributes[i]),o=e.json.accessors[t.attributes[i]],l=$x[o.componentType],u=o.count*Gx[o.type]*qx[o.componentType].BYTES_PER_ELEMENT,c=Lx._malloc(u);n.GetAttributeDataArrayForAllPoints(a,s,Lx[l],u,c),Yx(Lx.memory.buffer.slice(c,c+u),o,e),Lx._free(c);}n.destroy(),a.destroy(),delete t.extensions[Xx];}const Kx="EXT_meshopt_compression";function Hx(t,e){if(!t.extensions||!t.extensions[Kx])return;const r=t.extensions[Kx],n=new Uint8Array(e.buffers[r.buffer],r.byteOffset||0,r.byteLength||0),i=new Uint8Array(r.count*r.byteStride);Nx.decodeGltfBuffer(i,r.count,r.byteStride,n,r.mode,r.filter),t.buffer=e.buffers.length,t.byteOffset=0,e.buffers[t.buffer]=i.buffer,delete t.extensions[Kx];}const Wx=1179937895,Jx=new TextDecoder("utf8");function Qx(t,e){return new URL(t,e).href}function tv(t,e,r,n){return fetch(Qx(t.uri,n)).then((t=>t.arrayBuffer())).then((t=>{e.buffers[r]=t;}))}function ev(t,e){const r=t.json.bufferViews[e];return new Uint8Array(t.buffers[r.buffer],r.byteOffset||0,r.byteLength)}function rv(t,e,r,n){if(t.uri){const i=Qx(t.uri,n);return fetch(i).then((t=>t.blob())).then((t=>createImageBitmap(t))).then((t=>{e.images[r]=t;}))}if(void 0!==t.bufferView){const n=ev(e,t.bufferView),i=new Blob([n],{type:t.mimeType});return createImageBitmap(i).then((t=>{e.images[r]=t;}))}}function nv(t,e=0,r){const n={json:null,images:[],buffers:[]};if(new Uint32Array(t,e,1)[0]===Wx){const r=new Uint32Array(t,e);let i=2;const a=(r[i++]>>2)-3,s=r[i++]>>2;if(i++,n.json=JSON.parse(Jx.decode(r.subarray(i,i+s))),i+=s,i<a){const a=r[i++];i++;const s=e+(i<<2);n.buffers[0]=t.slice(s,s+a);}}else n.json=JSON.parse(Jx.decode(new Uint8Array(t,e)));const{buffers:i,images:a,meshes:s,extensionsUsed:o,bufferViews:l}=n.json;let u=Promise.resolve();if(i){const t=[];for(let e=0;e<i.length;e++){const a=i[e];a.uri?t.push(tv(a,n,e,r)):n.buffers[e]||(n.buffers[e]=null);}u=Promise.all(t);}return u.then((()=>{const t=[],e=o&&o.includes(Xx),i=o&&o.includes(Kx);if(e&&t.push(function(){if(!Lx)return Dx||(Dx=function(t){let e,r=null;function n(){e=new Uint8Array(r.buffer);}function i(){throw new Error("Unexpected Draco error.")}const a={a:{a:i,d:function(t,r,n){return e.copyWithin(t,r,r+n)},c:function(t){const i=e.length,a=Math.max(t>>>0,Math.ceil(1.2*i)),s=Math.ceil((a-i)/65536);try{return r.grow(s),n(),!0}catch(t){return !1}},b:i}};return (WebAssembly.instantiateStreaming?WebAssembly.instantiateStreaming(t,a):t.then((t=>t.arrayBuffer())).then((t=>WebAssembly.instantiate(t,a)))).then((t=>{const{Rb:i,Qb:a,P:s,T:o,X:l,Ja:u,La:c,Qa:h,Va:p,Wa:f,eb:d,jb:m,f:y,e:g,yb:x,zb:v,Ab:b,Bb:_,Db:w,Gb:M}=t.instance.exports;r=g;const A=(()=>{let t=0,r=0,n=0,s=0;return o=>{n&&(i(s),i(t),r+=n,n=t=0),t||(r+=128,t=a(r));const l=o.length+7&-8;let u=t;l>=r&&(n=l,u=s=a(l));for(let t=0;t<o.length;t++)e[u+t]=o[t];return u}})();return n(),y(),{memory:g,_free:i,_malloc:a,Mesh:class{constructor(){this.ptr=s();}destroy(){o(this.ptr);}},Decoder:class{constructor(){this.ptr=u();}destroy(){m(this.ptr);}DecodeArrayToMesh(t,e,r){const n=A(t),i=c(this.ptr,n,e,r.ptr);return !!l(i)}GetAttributeByUniqueId(t,e){return {ptr:h(this.ptr,t.ptr,e)}}GetTrianglesUInt16Array(t,e,r){p(this.ptr,t.ptr,e,r);}GetTrianglesUInt32Array(t,e,r){f(this.ptr,t.ptr,e,r);}GetAttributeDataArrayForAllPoints(t,e,r,n,i){d(this.ptr,t.ptr,e.ptr,r,n,i);}},DT_INT8:x(),DT_UINT8:v(),DT_INT16:b(),DT_UINT16:_(),DT_UINT32:w(),DT_FLOAT32:M()}}))}(fetch(Ux())),Dx.then((t=>{Lx=t,Dx=void 0;})))}()),i&&t.push(function(){if(Nx)return;const t=function(t){let e;const r=WebAssembly.instantiateStreaming(t,{}).then((t=>{e=t.instance,e.exports.__wasm_call_ctors();})),n={NONE:"",OCTAHEDRAL:"meshopt_decodeFilterOct",QUATERNION:"meshopt_decodeFilterQuat",EXPONENTIAL:"meshopt_decodeFilterExp"},i={ATTRIBUTES:"meshopt_decodeVertexBuffer",TRIANGLES:"meshopt_decodeIndexBuffer",INDICES:"meshopt_decodeIndexSequence"};return {ready:r,supported:!0,decodeGltfBuffer(t,r,a,s,o,l){!function(t,e,r,n,i,a,s){const o=t.exports.sbrk,l=n+3&-4,u=o(l*i),c=o(a.length),h=new Uint8Array(t.exports.memory.buffer);h.set(a,c);const p=e(u,n,i,c,a.length);if(0===p&&s&&s(u,l,i),r.set(h.subarray(u,u+n*i)),o(u-o(0)),0!==p)throw new Error(`Malformed buffer data: ${p}`)}(e,e.exports[i[o]],t,r,a,s,e.exports[n[l]]);}}}(fetch(jx()));return t.ready.then((()=>{Nx=t;}))}()),a)for(let e=0;e<a.length;e++)t.push(rv(a[e],n,e,r));return (t.length?Promise.all(t):Promise.resolve()).then((()=>{if(e&&s)for(const{primitives:t}of s)for(const e of t)Zx(e,n);if(i&&s&&l)for(const t of l)Hx(t,n);return n}))}))}class iv{constructor(t,e,r){if(this.triangleCount=e.length/3,this.min=new g(0,0),this.max=new g(0,0),this.xScale=0,this.yScale=0,this.cellsX=0,this.cellsY=0,this.cells=[],this.payload=[],0===this.triangleCount||0===t.length||0===r)return;const n=t.map((t=>t.x)),i=t.map((t=>t.y));this.min=new g(Math.min(...n),Math.min(...i)),this.max=new g(Math.max(...n),Math.max(...i));const a=this.max.sub(this.min);a.x=Math.max(a.x,1),a.y=Math.max(a.y,1);const s=Math.max(a.x,a.y)/r;this.cellsX=Math.max(1,Math.ceil(a.x/s)),this.cellsY=Math.max(1,Math.ceil(a.y/s)),this.xScale=1/s,this.yScale=1/s;const o=[];for(let r=0;r<this.triangleCount;r++){const n=t[e[3*r+0]].sub(this.min),i=t[e[3*r+1]].sub(this.min),a=t[e[3*r+2]].sub(this.min),l=av(Math.floor(Math.min(n.x,i.x,a.x)),this.xScale,this.cellsX),u=av(Math.floor(Math.max(n.x,i.x,a.x)),this.xScale,this.cellsX),c=av(Math.floor(Math.min(n.y,i.y,a.y)),this.yScale,this.cellsY),h=av(Math.floor(Math.max(n.y,i.y,a.y)),this.yScale,this.cellsY),p=new g(0,0),f=new g(0,0),d=new g(0,0),m=new g(0,0);for(let t=c;t<=h;++t){p.y=f.y=t*s,d.y=m.y=(t+1)*s;for(let e=l;e<=u;++e)p.x=d.x=e*s,f.x=m.x=(e+1)*s,(Kl(n,i,a,p,f,m)||Kl(n,i,a,p,m,d))&&o.push({cellIdx:t*this.cellsX+e,triIdx:r});}}if(0===o.length)return;o.sort(((t,e)=>t.cellIdx-e.cellIdx||t.triIdx-e.triIdx));let l=0;for(;l<o.length;){const t=o[l].cellIdx,e={start:this.payload.length,len:0};for(;l<o.length&&o[l].cellIdx===t;)++e.len,this.payload.push(o[l++].triIdx);this.cells[t]=e;}}query(t,e,r){if(0===this.triangleCount||0===this.cells.length)return;if(t.x>this.max.x||this.min.x>e.x)return;if(t.y>this.max.y||this.min.y>e.y)return;this.lookup||(this.lookup=new Uint8Array(Math.ceil(this.triangleCount/8)));for(let t=0;t<this.lookup.length;t++)this.lookup[t]=0;const n=av(t.x-this.min.x,this.xScale,this.cellsX),i=av(e.x-this.min.x,this.xScale,this.cellsX),a=av(t.y-this.min.y,this.yScale,this.cellsY),s=av(e.y-this.min.y,this.yScale,this.cellsY);for(let t=a;t<=s;t++)for(let e=n;e<=i;e++){const n=this.cells[t*this.cellsX+e];if(n)for(let t=0;t<n.len;t++){const e=this.payload[n.start+t],i=Math.floor(e/8),a=1<<e%8;if(!(this.lookup[i]&a)&&(this.lookup[i]|=a,r.push(e),r.length===this.triangleCount))return}}}}function av(t,e,r){return Math.max(0,Math.min(r-1,Math.floor(t*e)))}function sv(t,e){const r=t.json.bufferViews[e.bufferView],n=qx[e.componentType];return new n(t.buffers[r.buffer],(e.byteOffset||0)+(r.byteOffset||0),e.count*(r.byteStride&&r.byteStride!==Gx[e.type]*n.BYTES_PER_ELEMENT?r.byteStride/n.BYTES_PER_ELEMENT:Gx[e.type]))}function ov(t,e,r,n){const i=qx[e.componentType],a=function(t){switch(t){case Int8Array:return 1/127;case Uint8Array:return 1/255;case Int16Array:return 1/32767;case Uint16Array:return 1/65535;default:return 1}}(i),s=t.json.bufferViews[e.bufferView],o=s.byteStride?s.byteStride/i.BYTES_PER_ELEMENT:Gx[e.type],l=r.float32,u=l.length/r.capacity;for(let t=0,r=0;t<e.count*o;t+=o,r+=u)for(let e=0;e<u;e++)l[r+e]=n[t+e]*a;r._trim();}function lv(t,e,r){const n=t.indices,i=t.attributes,a={};a.indexArray=new Es;const s=e.json.accessors[n],o=s.count/3;a.indexArray.reserve(o);const l=sv(e,s);for(let t=0;t<o;t++)a.indexArray.emplaceBack(l[3*t],l[3*t+1],l[3*t+2]);a.indexArray._trim(),a.vertexArray=new Ls;const u=e.json.accessors[i.POSITION];a.vertexArray.reserve(u.count);const c=sv(e,u);for(let t=0;t<u.count;t++)a.vertexArray.emplaceBack(c[3*t],c[3*t+1],c[3*t+2]);if(a.vertexArray._trim(),a.aabb=new Bh(u.min,u.max),a.centroid=function(t,e){const r=[0,0,0],n=t.length;if(n>0){for(let i=0;i<n;i++){const n=3*t[i];r[0]+=e[n],r[1]+=e[n+1],r[2]+=e[n+2];}r[0]/=n,r[1]/=n,r[2]/=n;}return r}(l,c),void 0!==i.COLOR_0){const t=e.json.accessors[i.COLOR_0],r=Gx[t.type],n=sv(e,t);a.colorArray=3===r?new Ls:new gs,a.colorArray.resize(t.count),ov(e,t,a.colorArray,n);}if(void 0!==i.NORMAL){a.normalArray=new Ls;const t=e.json.accessors[i.NORMAL];a.normalArray.resize(t.count);const r=sv(e,t);ov(e,t,a.normalArray,r);}if(void 0!==i.TEXCOORD_0&&r.length>0){a.texcoordArray=new Fs;const t=e.json.accessors[i.TEXCOORD_0];a.texcoordArray.resize(t.count);const r=sv(e,t);ov(e,t,a.texcoordArray,r);}if(void 0!==i._FEATURE_ID_RGBA4444){const t=e.json.accessors[i._FEATURE_ID_RGBA4444];e.json.extensionsUsed&&e.json.extensionsUsed.includes("EXT_meshopt_compression")&&(a.featureData=sv(e,t));}void 0!==i._FEATURE_RGBA4444&&(a.featureData=new Uint32Array(sv(e,e.json.accessors[i._FEATURE_RGBA4444]).buffer));const h=t.material;return a.material=function(t,e){const{emissiveFactor:r=[0,0,0],alphaMode:n="OPAQUE",alphaCutoff:i=.5,normalTexture:a,occlusionTexture:s,emissiveTexture:o,doubleSided:l}=t,{baseColorFactor:u=[1,1,1,1],metallicFactor:c=1,roughnessFactor:h=1,baseColorTexture:p,metallicRoughnessTexture:f}=t.pbrMetallicRoughness||{},d=s?e[s.index]:void 0;if(s&&s.extensions&&s.extensions.KHR_texture_transform&&d){const t=s.extensions.KHR_texture_transform;d.offsetScale=[t.offset[0],t.offset[1],t.scale[0],t.scale[1]];}return {pbrMetallicRoughness:{baseColorFactor:new le(...u),metallicFactor:c,roughnessFactor:h,baseColorTexture:p?e[p.index]:void 0,metallicRoughnessTexture:f?e[f.index]:void 0},doubleSided:l,emissiveFactor:r,alphaMode:n,alphaCutoff:i,normalTexture:a?e[a.index]:void 0,occlusionTexture:d,emissionTexture:o?e[o.index]:void 0,defined:void 0===t.defined}}(void 0!==h?e.json.materials[h]:{defined:!1},r),a}function uv(e,r,n){const{matrix:i,rotation:a,translation:s,scale:o,mesh:l,extras:u,children:c}=e,h={};if(h.matrix=i||t.a6.fromRotationTranslationScale([],a||[0,0,0,1],s||[0,0,0],o||[1,1,1]),void 0!==l){h.meshes=n[l];const t=h.anchor=[0,0];for(const e of h.meshes){const{min:r,max:n}=e.aabb;t[0]+=r[0]+n[0],t[1]+=r[1]+n[1];}t[0]=Math.floor(t[0]/h.meshes.length/2),t[1]=Math.floor(t[1]/h.meshes.length/2);}if(u&&(u.id&&(h.id=u.id),u.lights&&(h.lights=function(t){if(!t.length)return [];const e=function(t){const e=atob(t),r=new Uint8Array(e.length);for(let t=0;t<e.length;t++)r[t]=e.codePointAt(t);return r}(t),r=[],n=e.length/24,i=new Uint16Array(e.buffer),a=new Float32Array(e.buffer);for(let t=0;t<n;t++){const e=i[2*t*6]/30,n=i[2*t*6+1]/30,s=i[2*t*6+10]/100,o=a[6*t+1],l=a[6*t+2],u=a[6*t+3],c=a[6*t+4],h=u-o,p=c-l,f=Math.hypot(h,p);r.push({pos:[o+.5*h,l+.5*p,n],normal:[p/f,-h/f,0],width:f,height:e,depth:s,points:[o,l,u,c]});}return r}(u.lights))),c){const t=[];for(const e of c)t.push(uv(r.json.nodes[e],r,n));h.children=t;}return h}function cv(t){if(0===t.vertices.length||0===t.indices.length)return null;const[e,r]=[t.vertices[0].clone(),t.vertices[0].clone()];for(let n=1;n<t.vertices.length;++n){const i=t.vertices[n];e.x=Math.min(e.x,i.x),e.y=Math.min(e.y,i.y),r.x=Math.max(r.x,i.x),r.y=Math.max(r.y,i.y);}const n=Math.ceil(Math.max(r.x-e.x,r.y-e.y)/256),i=Math.max(8,n),a=new iv(t.vertices,t.indices,i);return {vertices:t.vertices,indices:t.indices,grid:a,min:e,max:r}}function hv(t){if(!t.extras||!t.extras.ground)return null;const e=t.extras.ground;if(!e||!Array.isArray(e)||0===e.length)return null;const r=e[0];if(!r||!Array.isArray(r)||0===r.length)return null;const n=[];for(const t of r){if(!Array.isArray(t)||2!==t.length)continue;const e=t[0],r=t[1];"number"==typeof e&&"number"==typeof r&&n.push(new g(e,r));}if(n.length<3)return null;n.length>1&&n[n.length-1].equals(n[0])&&n.pop();let i=0;for(let t=0;t<n.length;t++){const e=n[t],r=n[(t+1)%n.length],a=n[(t+2)%n.length];i+=(e.x-r.x)*(a.y-r.y)-(a.x-r.x)*(e.y-r.y);}i>0&&n.reverse();const a=rf(n.flatMap((t=>[t.x,t.y])),[]);return 0===a.length?null:{vertices:n,indices:a}}function pv(t){const e=[],r=[];let n=0;for(const i of t){n=e.length;const t=i.vertexArray.float32,a=i.indexArray.uint16;for(let r=0;r<i.vertexArray.length;r++)e.push(new g(t[3*r+0],t[3*r+1]));for(let t=0;t<3*i.indexArray.length;t++)r.push(a[t]+n);}if(r.length%3!=0)return null;for(let t=0;t<r.length;t+=3){const n=e[r[t+0]],i=e[r[t+1]],a=e[r[t+2]];(n.x-i.x)*(a.y-i.y)-(a.x-i.x)*(n.y-i.y)>0&&([r[t+1],r[t+2]]=[r[t+2],r[t+1]]);}return {vertices:e,indices:r}}function fv(t){const e=function(t,e){const r=[],n=WebGL2RenderingContext;if(t.json.textures)for(const i of t.json.textures){const a={magFilter:n.LINEAR,minFilter:n.NEAREST,wrapS:n.REPEAT,wrapT:n.REPEAT};void 0!==i.sampler&&Object.assign(a,t.json.samplers[i.sampler]),r.push({image:e[i.source],sampler:a,uploaded:!1});}return r}(t,t.images),r=function(t,e){const r=[];for(const n of t.json.meshes){const i=[];for(const r of n.primitives)i.push(lv(r,t,e));r.push(i);}return r}(t,e),{scenes:n,scene:i,nodes:a}=t.json,s=n?n[i||0].nodes:a,o=[];for(const e of s)o.push(uv(a[e],t,r));return function(t,e,r){const n={},i=new Set;for(let a=0;a<t.length;a++){const t=r[e[a]];if(!t.extras)continue;const s=t.extras["mapbox:footprint:version"],o=t.extras["mapbox:footprint:id"];(s||o)&&i.add(a),"1.0.0"===s&&o&&(n[o]=a);}for(let a=0;a<t.length;a++){if(i.has(a))continue;const s=t[a],o=r[e[a]];if(!o.extras)continue;let l=null;s.id in n&&(l=pv(t[n[s.id]].meshes)),l||(l=hv(o)),l&&(s.footprint=cv(l));}if(i.size>0){const e=Array.from(i.values()).sort(((t,e)=>t-e));for(let r=e.length-1;r>=0;r--)t.splice(e[r],1);}}(o,s,t.json.nodes),o}function dv(t){t.heightmap=new Float32Array(4096),t.heightmap.fill(-1);const e=t.vertexArray.float32,r=t.aabb.min[0]-1,n=t.aabb.min[1]-1,i=gx/(t.aabb.max[0]-r+2),a=gx/(t.aabb.max[1]-n+2);for(let s=0;s<e.length;s+=3){const o=e[s+2],l=(e[s+0]-r)*i|0,u=(e[s+1]-n)*a|0;o>t.heightmap[u*gx+l]&&(t.heightmap[u*gx+l]=o);}}function mv(e,r){const n={};n.indexArray=new Es,n.indexArray.reserve(4*e.length),n.vertexArray=new Ls,n.vertexArray.reserve(10*e.length),n.colorArray=new gs,n.vertexArray.reserve(10*e.length);let i=0;for(const a of e){const e=Math.min(10,Math.max(4,1.3*a.height))*r,s=[-a.normal[1],a.normal[0],0],o=Math.min(.29,.1*a.width/a.depth),l=a.width-2*a.depth*r*(o+.01),u=t.N.scaleAndAdd([],a.pos,s,l/2),c=t.N.scaleAndAdd([],a.pos,s,-l/2),h=[u[0],u[1],u[2]+a.height],p=[c[0],c[1],c[2]+a.height],f=t.N.scaleAndAdd([],a.normal,s,o);t.N.scale(f,f,e);const d=t.N.scaleAndAdd([],a.normal,s,-o);t.N.scale(d,d,e),t.N.add(f,u,f),t.N.add(d,c,d),u[2]+=.1,c[2]+=.1,n.vertexArray.emplaceBack(f[0],f[1],f[2]),n.vertexArray.emplaceBack(d[0],d[1],d[2]),n.vertexArray.emplaceBack(u[0],u[1],u[2]),n.vertexArray.emplaceBack(c[0],c[1],c[2]),n.vertexArray.emplaceBack(h[0],h[1],h[2]),n.vertexArray.emplaceBack(p[0],p[1],p[2]),n.vertexArray.emplaceBack(u[0],u[1],u[2]),n.vertexArray.emplaceBack(c[0],c[1],c[2]),n.vertexArray.emplaceBack(f[0],f[1],f[2]),n.vertexArray.emplaceBack(d[0],d[1],d[2]);const m=l/e/2;n.colorArray.emplaceBack(-m-o,-1,m,.8),n.colorArray.emplaceBack(m+o,-1,m,.8),n.colorArray.emplaceBack(-m,0,m,1.3),n.colorArray.emplaceBack(m,0,m,1.3),n.colorArray.emplaceBack(m+o,-.8,m,.7),n.colorArray.emplaceBack(m+o,-.8,m,.7),n.colorArray.emplaceBack(0,0,m,1.3),n.colorArray.emplaceBack(0,0,m,1.3),n.colorArray.emplaceBack(m+o,-1.2,m,.8),n.colorArray.emplaceBack(m+o,-1.2,m,.8),n.indexArray.emplaceBack(6+i,4+i,8+i),n.indexArray.emplaceBack(7+i,9+i,5+i),n.indexArray.emplaceBack(0+i,1+i,2+i),n.indexArray.emplaceBack(1+i,3+i,2+i),i+=10;}const a={defined:!0,emissiveFactor:[0,0,0]},s={};return s.baseColorFactor=le.white,a.pbrMetallicRoughness=s,n.material=a,n.aabb=new Bh([1/0,1/0,1/0],[-1/0,-1/0,-1/0]),n}ra(iv,"TriangleGridIndex");class yv{constructor(t){this._stringToNumber={},this._numberToString=[];for(let e=0;e<t.length;e++){const r=t[e];this._stringToNumber[r]=e,this._numberToString[e]=r;}}encode(t){return this._stringToNumber[t]}decode(t){return this._numberToString[t]}}const gv=["tile","layer","source","sourceLayer","state"];class xv{constructor(t,e,r,n,i){this.type="Feature",this._vectorTileFeature=t,this._z=e,this._x=r,this._y=n,this.properties=t.properties,this.id=i;}get geometry(){return void 0===this._geometry&&(this._geometry=this._vectorTileFeature.toGeoJSON(this._x,this._y,this._z).geometry),this._geometry}set geometry(t){this._geometry=t;}toJSON(){const t={type:"Feature",state:void 0,geometry:this.geometry,properties:this.properties};void 0!==this.id&&(t.id=this.id);for(const e of gv)void 0!==this[e]&&(t[e]=this[e]);return t}}class vv{constructor(t,e){this.tileID=t,this.x=t.canonical.x,this.y=t.canonical.y,this.z=t.canonical.z,this.grid=new ta(Tr,16,0),this.featureIndexArray=new Ws,this.promoteId=e,this.is3DTile=!1;}insert(t,e,r,n,i,a=0,s=0){const o=this.featureIndexArray.length;this.featureIndexArray.emplaceBack(r,n,i,a);const l=this.grid;for(let t=0;t<e.length;t++){const r=e[t],n=[1/0,1/0,-1/0,-1/0];for(let t=0;t<r.length;t++){const e=r[t];n[0]=Math.min(n[0],e.x),n[1]=Math.min(n[1],e.y),n[2]=Math.max(n[2],e.x),n[3]=Math.max(n[3],e.y);}0!==s&&(n[0]-=s,n[1]-=s,n[2]+=s,n[3]+=s),n[0]<Tr&&n[1]<Tr&&n[2]>=0&&n[3]>=0&&l.insert(o,n[0],n[1],n[2],n[3]);}}loadVTLayers(){if(!this.vtLayers){this.vtLayers=new Ef(new Vm(this.rawTileData)).layers,this.sourceLayerCoder=new yv(this.vtLayers?Object.keys(this.vtLayers).sort():["_geojsonTileLayer"]),this.vtFeatures={};for(const t in this.vtLayers)this.vtFeatures[t]=[];}return this.vtLayers}query(t,e,r,n){this.loadVTLayers();const i=t.params||{},a=Ga(i.filter),s=t.tileResult,o=t.transform,l=s.bufferedTilespaceBounds,u=this.grid.query(l.min.x,l.min.y,l.max.x,l.max.y,((t,e,r,n)=>Yl(s.bufferedTilespaceGeometry,t,e,r,n)));u.sort(_v);let c=null;o.elevation&&u.length>0&&(c=Wf.create(o.elevation,this.tileID));const h={};let p;for(let l=0;l<u.length;l++){const f=u[l];if(f===p)continue;p=f;const d=this.featureIndexArray.get(f);let m=null;if(this.is3DTile){const t=this.bucketLayerIDs[0][0],r=e[t];if("model"!==r.type)continue;const{queryFeature:n,intersectionZ:i}=r.queryIntersectsMatchingFeature(s,d.featureIndex,a,o);n&&this.appendToResult(h,t,d.featureIndex,n,i);}else this.loadMatchingFeature(h,d,a,i.layers,i.availableImages,e,r,n,((e,r,n,i=0)=>(m||(m=Tl(e,this.tileID.canonical,t.tileTransform)),r.queryIntersectsFeature(s,e,n,m,this.z,t.transform,t.pixelPosMatrix,c,i))));}return h}loadMatchingFeature(t,e,r,n,i,a,s,o,l){const{featureIndex:u,bucketIndex:c,sourceLayerIndex:h,layoutVertexArrayOffset:p}=e,f=this.bucketLayerIDs[c];if(n&&!function(t,e){for(let r=0;r<t.length;r++)if(e.indexOf(t[r])>=0)return !0;return !1}(n,f))return;const d=this.sourceLayerCoder.decode(h),m=this.vtLayers[d].feature(u);if(r.needGeometry){const t=Bl(m,!0);if(!r.filter(new Pa(this.tileID.overscaledZ),t,this.tileID.canonical))return}else if(!r.filter(new Pa(this.tileID.overscaledZ),m))return;const y=this.getId(m,d);for(let e=0;e<f.length;e++){const r=f[e];if(n&&n.indexOf(r)<0)continue;const c=a[r];if(!c)continue;let h={};void 0!==y&&o&&(h=o.getState(c.sourceLayer||"_geojsonTileLayer",y));const d=!l||l(m,c,h,p);if(!d)continue;const g=new xv(m,this.z,this.x,this.y,y),x=z({},s[r]);x.paint=bv(x.paint,c.paint,m,h,i),x.layout=bv(x.layout,c.layout,m,h,i),g.layer=x,this.appendToResult(t,r,u,g,d);}}appendToResult(t,e,r,n,i){let a=t[e];void 0===a&&(a=t[e]=[]),a.push({featureIndex:r,feature:n,intersectionZ:i});}lookupSymbolFeatures(t,e,r,n,i,a,s,o){const l={};this.loadVTLayers();const u=Ga(i);for(const i of t)this.loadMatchingFeature(l,{bucketIndex:r,sourceLayerIndex:n,featureIndex:i,layoutVertexArrayOffset:0},u,a,s,o,e);return l}loadFeature(t){const{featureIndex:e,sourceLayerIndex:r}=t;this.loadVTLayers();const n=this.sourceLayerCoder.decode(r),i=this.vtFeatures[n];if(i[e])return i[e];const a=this.vtLayers[n].feature(e);return i[e]=a,a}hasLayer(t){for(const e of this.bucketLayerIDs)for(const r of e)if(t===r)return !0;return !1}getId(t,e){let r=t.id;if(this.promoteId){const n="string"==typeof this.promoteId?this.promoteId:this.promoteId[e];null!=n&&(r=t.properties[n]),"boolean"==typeof r&&(r=Number(r));}return r}}function bv(t,e,r,n,i){return F(t,((t,a)=>{const s=e instanceof Va?e.get(a):null;return s&&s.evaluate?s.evaluate(r,n,i):s}))}function _v(t,e){return e-t}ra(vv,"FeatureIndex",{omit:["rawTileData","sourceLayerCoder"]});const wv=new Float32Array(262144),Mv=new Uint8Array(262144);function Av(t){let e=0;if(t.meshes)for(const r of t.meshes)e=Math.max(e,r.aabb.max[2]);if(t.children)for(const r of t.children)e=Math.max(e,Av(r));return e}function Sv(t,e,r){if(t.meshes)for(const n of t.meshes)n.aabb.min[0]!==1/0&&r.insert(e,n.aabb.min[0],n.aabb.min[1],n.aabb.max[0],n.aabb.max[1]);if(t.children)for(const n of t.children)Sv(n,e,r);}const Iv=["","wall","door","roof","window","lamp","logo"];class kv{constructor(t){this.node=t,this.evaluatedRMEA=[[1,0,0,1],[1,0,0,1],[1,0,0,1],[1,0,0,1],[.4,1,0,1],[1,0,0,1],[1,0,0,1]],this.hiddenByReplacement=!1,this.evaluatedScale=[1,1,1],this.evaluatedColor=[],this.emissionHeightBasedParams=[],this.feature={type:"Point",id:t.id,geometry:[],properties:{height:Av(t)}};}getLocalBounds(){if(!this.node.meshes)return new Bh([1/0,1/0,1/0],[-1/0,-1/0,-1/0]);if(!this.aabb){let t=0;const e=new Bh([1/0,1/0,1/0],[-1/0,-1/0,-1/0]);for(const r of this.node.meshes)this.node.lightMeshIndex!==t&&e.encapsulate(r.aabb),t++;this.aabb=e;}return this.aabb}}class Pv{constructor(t,e,r,n,i,a){this.id=e,this.modelTraits|=xx.CoordinateSpaceTile,this.uploaded=!1,this.hasPattern=!1,r&&(this.modelTraits|=xx.HasMapboxMeshFeatures),n&&(this.modelTraits|=xx.HasMeshoptCompression),this.zoom=-1,this.terrainExaggeration=1,this.projection={name:"mercator"},this.replacementUpdateTime=0,this.elevationReadFromZ=255,this.brightness=i,this.dirty=!0,this.needsUpload=!1,this.nodesInfo=[];for(const e of t)this.nodesInfo.push(new kv(e)),Sv(e,a.featureIndexArray.length,a.grid),a.featureIndexArray.emplaceBack(this.nodesInfo.length-1,0,a.bucketLayerIDs.length-1,0);}update(){console.log("Update 3D model bucket");}populate(){console.log("populate 3D model bucket");}uploadPending(){return !this.uploaded||this.needsUpload}upload(t){if(!this.needsUpload)return;const e=this.getNodesInfo();for(const r of e){const e=r.node;this.uploaded?this.updatePbrBuffer(e):wx(e,t,!0);}for(const t of e)Mx(t.node);this.uploaded=!0,this.needsUpload=!1;}updatePbrBuffer(t){let e=!1;if(!t.meshes)return e;for(const r of t.meshes)r.pbrBuffer&&(r.pbrBuffer.updateData(r.featureArray),e=!0);return e}needsReEvaluation(t,e,r){const n=t.transform.projectionOptions,i=t.style.getBrightness(),a=this.brightness!==i;return !!(!this.uploaded||this.dirty||n.name!==this.projection.name||Ev(r.paint.get("model-color").value,a)||Ev(r.paint.get("model-color-mix-intensity").value,a)||Ev(r.paint.get("model-roughness").value,a)||Ev(r.paint.get("model-emissive-strength").value,a)||Ev(r.paint.get("model-height-based-emissive-strength-multiplier").value,a))&&(this.projection=n,this.brightness=i,!0)}evaluateScale(t,e){if(t.transform.zoom===this.zoom)return;this.zoom=t.transform.zoom;const r=this.getNodesInfo(),n=this.id.canonical;for(const t of r){const r=t.feature;t.evaluatedScale=e.paint.get("model-scale").evaluate(r,{},n);}}evaluate(t){const e=this.getNodesInfo();for(const r of e){if(!r.node.meshes)continue;const e=r.feature,n=r.node.meshes&&r.node.meshes[0].featureData,i=r.evaluatedColor[2],a=r.evaluatedRMEA[2],s=this.id.canonical;if(r.hasTranslucentParts=!1,n){for(let n=0;n<Iv.length;n++){const i=Iv[n];i.length&&(e.properties.part=i);const a=t.paint.get("model-color").evaluate(e,{},s),o=t.paint.get("model-color-mix-intensity").evaluate(e,{},s);r.evaluatedColor[n]=[a.r,a.g,a.b,o],r.evaluatedRMEA[n][0]=t.paint.get("model-roughness").evaluate(e,{},s),r.evaluatedRMEA[n][2]=t.paint.get("model-emissive-strength").evaluate(e,{},s),r.evaluatedRMEA[n][3]=a.a,r.emissionHeightBasedParams[n]=t.paint.get("model-height-based-emissive-strength-multiplier").evaluate(e,{},s),!r.hasTranslucentParts&&a.a<1&&(r.hasTranslucentParts=!0);}delete e.properties.part,Tv(r,i!==r.evaluatedColor[2]||a!==r.evaluatedRMEA[2],this.modelTraits);}else r.evaluatedRMEA[0][2]=t.paint.get("model-emissive-strength").evaluate(e,{},s);r.evaluatedScale=t.paint.get("model-scale").evaluate(e,{},s),this.updatePbrBuffer(r.node)||(this.needsUpload=!0);}this.dirty=!1;}elevationUpdate(t,e,r,n){const i=t.findDEMTileFor(r);if(i&&(i.tileID.canonical!==this.terrainTile||e!==this.terrainExaggeration)){if(i.dem&&i.tileID.overscaledZ!==this.elevationReadFromZ){this.elevationReadFromZ=i.tileID.overscaledZ;const e=Wf.create(t,r,i);if(!e)return;this.modelTraits&xx.HasMapboxMeshFeatures&&this.updateDEM(t,e,r,n);for(const t of this.getNodesInfo()){const r=t.node;if(!r.footprint||!r.footprint.vertices||!r.footprint.vertices.length)continue;const n=r.footprint.vertices;let i=e.getElevationAt(n[0].x,n[0].y,!0,!0);for(let t=1;t<n.length;t++)i=Math.min(i,e.getElevationAt(n[t].x,n[t].y,!0,!0));r.elevation=i;}}this.terrainTile=i.tileID.canonical,this.terrainExaggeration=e;}}updateDEM(t,e,r,n){let i=e._dem._modifiedForSources[n];if(void 0===i&&(e._dem._modifiedForSources[n]=[],i=e._dem._modifiedForSources[n]),i.includes(r.canonical))return;const a=e._dem.dim;i.push(r.canonical);let s=!1;for(const t of this.getNodesInfo()){const r=t.node;if(!r.footprint||!r.footprint.grid)continue;const n=r.footprint.grid,i=e.tileCoordToPixel(n.min.x,n.min.y),o=e.tileCoordToPixel(n.max.x,n.max.y),l=Math.min(Math.min(a-o.y,i.x),Math.min(i.y,a-o.x));if(l<0)continue;const u=I(l,2,5);let c=Math.max(0,i.x-u),h=Math.max(0,i.y-u),p=Math.min(o.x+u,a-1),f=Math.min(o.y+u,a-1);for(let t=h;t<=f;++t)for(let e=c;e<=p;++e)Mv[t*a+e]=255;let d=0,m=0;for(let t=0;t<n.cellsY;++t)for(let r=0;r<n.cellsX;++r){if(!n.cells[t*n.cellsX+r])continue;const i=e.tileCoordToPixel(n.min.x+r/n.xScale,n.min.y+t/n.yScale),s=e.tileCoordToPixel(n.min.x+(r+1)/n.xScale,n.min.y+(t+1)/n.yScale);for(let t=i.y;t<=Math.min(s.y+1,a-1);++t)for(let r=i.x;r<=Math.min(s.x+1,a-1);++r)255===Mv[t*a+r]&&(Mv[t*a+r]=0,d+=e.getElevationAtPixel(r,t),m++);}const y=d/m;c=Math.max(1,i.x-u),h=Math.max(1,i.y-u),p=Math.min(o.x+u,a-2),f=Math.min(o.y+u,a-2),s=!0;for(let t=h;t<=f;++t)for(let r=c;r<=p;++r)0===Mv[t*a+r]&&(wv[t*a+r]=e._dem.set(r,t,y));for(let t=1;t<u;++t){c=Math.max(1,i.x-t),h=Math.max(1,i.y-t),p=Math.min(o.x+t,a-2),f=Math.min(o.y+t,a-2);for(let r=h;r<=f;++r)for(let n=c;n<=p;++n){const i=r*a+n;if(255===Mv[i]){let s=0,o=0,l=-1,c=-1;for(let e=-1;e<=1;++e)for(let i=-1;i<=1;++i){const u=(r+e)*a+n+i;if(Mv[u]>=t)continue;const h=wv[u],p=Math.abs(h);p>o&&(s=h,o=p,l=i,c=e);}if(o>.1){const a=1-(t+.5*Math.abs(l*c))/u;let o=e._dem.get(n,r)+s*a;const h=e._dem.get(n+l,r+c),p=e._dem.get(n-l,r-c,!0);(o-h)*(o-p)>0&&(o=(h+p)/2),wv[i]=e._dem.set(n,r,o),Mv[i]=t;}}}}}s&&(e._demTile.needsDEMTextureUpload=!0,e._dem._timestamp=st.now());}getNodesInfo(){return this.nodesInfo}destroy(){const t=this.getNodesInfo();for(const e of t)Mx(e.node),Ax(e.node);}isEmpty(){return !this.nodesInfo.length}updateReplacement(t,e){if(e.updateTime===this.replacementUpdateTime)return;this.replacementUpdateTime=e.updateTime;const r=e.getReplacementRegionsForTile(t.toUnwrapped()),n=this.getNodesInfo();for(let t=0;t<this.nodesInfo.length;t++){const e=n[t].node;n[t].hiddenByReplacement=!!e.footprint&&!r.find((t=>t.footprint===e.footprint));}}getHeightAtTileCoord(t,e){const r=this.getNodesInfo(),n=[];for(let i=0;i<this.nodesInfo.length;i++){const a=r[i],s=a.node.meshes[0];if(t<s.aabb.min[0]||e<s.aabb.min[1]||t>s.aabb.max[0]||e>s.aabb.max[1])continue;const o=(t-s.aabb.min[0])/(s.aabb.max[0]-s.aabb.min[0])*gx|0,l=Math.min(63,(e-s.aabb.min[1])/(s.aabb.max[1]-s.aabb.min[1])*gx|0)*gx+Math.min(63,o);if(!(s.heightmap[l]<0&&a.node.footprint)){if(a.hiddenByReplacement)return;return {height:s.heightmap[l],maxHeight:a.feature.properties.height,hidden:!1,verticalScale:a.evaluatedScale[2]}}if(a.node.footprint.grid.query(new g(t,e),new g(t,e),n),n.length>0)return {height:void 0,maxHeight:a.feature.properties.height,hidden:a.hiddenByReplacement,verticalScale:a.evaluatedScale[2]}}}}function Ev(t,e){return !t.isLightConstant&&e}function zv(t,e,r,n,i,a,s,o){let l=(61440&e|(61440&e)>>4)>>8,u=(3840&e|(3840&e)>>4)>>4,c=240&e|(240&e)>>4;r[3]>0&&(l=ue(l,255*r[0],r[3]),u=ue(u,255*r[1],r[3]),c=ue(c,255*r[2],r[3]));const h=l<<8|u,p=c<<8|Math.floor(255*n[3]),f=function(t){const e=I(t,0,2);return Math.min(Math.round(.5*e*255),255)}(n[2])<<8|15*n[0]<<4|15*n[1],d=I(i[0],0,1),m=I(i[1],0,1),y=I(i[2],0,1),g=I(i[3],0,1);let x,v,b,_;if(d!==m&&s!==a&&m!==d){const t=s-a;v=1/(t*(m-d)),b=-(a+t*d)/(t*(m-d));const e=I(i[4],-1,1);_=Math.pow(10,e),x=255*y<<8|255*g;}else x=65535,v=0,b=1,_=1;if(t.emplaceBack(h,p,f,x,v,b,_),o){const t=o.length;o.clear();for(let e=0;e<t;e++)o.emplaceBack(h,p,f,x,v,b,_);}}function Tv(t,e,r){const n=t.node;let i=0;const a=r&xx.HasMeshoptCompression;for(const r of n.meshes){if(n.lights&&n.lightMeshIndex===i)continue;if(!r.featureData)continue;r.featureArray=new Os,r.featureArray.reserve(r.featureData.length);let s=e;for(const e of r.featureData){const i=a?65535&e:e>>16&65535,o=a?e>>16&65535:65535&e,l=(15&o)<8?15&o:0,u=t.evaluatedRMEA[l],c=t.evaluatedColor[l],h=t.emissionHeightBasedParams[l];let p;if(s&&2===l&&n.lights&&(p=new Os,p.resize(10*n.lights.length)),zv(r.featureArray,i,c,u,h,r.aabb.min[2],r.aabb.max[2],p),p&&s){s=!1;const t=n.meshes[n.lightMeshIndex];t.featureArray=p,t.featureArray._trim();}}r.featureArray._trim(),i++;}}function Bv(t,e,r,n){const i=1<<t.z;e.lat=yl((n/Tr+t.y)/i),e.lng=ml((r/Tr+t.x)/i);}ra(Pv,"Tiled3dModelBucket",{omit:["layers"]}),ra(kv,"Tiled3dModelFeature");const Cv={circle:class extends ss{constructor(t,e,r){super(t,eu,e,r);}createBucket(t){return new Dl(t)}queryRadius(t){const e=t;return Hl("circle-radius",this,e)+Hl("circle-stroke-width",this,e)+Wl(this.paint.get("circle-translate"))}queryIntersectsFeature(t,e,r,n,i,a,s,o){const l=Ql(this.paint.get("circle-translate"),this.paint.get("circle-translate-anchor"),a.angle,t.pixelToTileUnitsFactor),u=this.paint.get("circle-radius").evaluate(e,r)+this.paint.get("circle-stroke-width").evaluate(e,r);return cp(t,n,a,s,o,"map"===this.paint.get("circle-pitch-alignment"),"map"===this.paint.get("circle-pitch-scale"),l,u)}getProgramIds(){return ["circle"]}getDefaultProgramParams(t,e){const r=up(this);return {config:new Do(this,e),defines:r,overrideFog:!1}}},heatmap:class extends ss{createBucket(t){return new mp(t)}constructor(t,e,r){super(t,Mp,e,r),this._updateColorRamp();}_handleSpecialPaintPropertyUpdate(t){"heatmap-color"===t&&this._updateColorRamp();}_updateColorRamp(){this.colorRamp=Ap({expression:this._transitionablePaint._values["heatmap-color"].value.expression,evaluationKey:"heatmapDensity",image:this.colorRamp}),this.colorRampTexture=null;}resize(){this.heatmapFbo&&(this.heatmapFbo.destroy(),this.heatmapFbo=null);}queryRadius(t){return Hl("heatmap-radius",this,t)}queryIntersectsFeature(t,e,r,n,i,a,s,o){const l=this.paint.get("heatmap-radius").evaluate(e,r);return cp(t,n,a,s,o,!0,!0,new g(0,0),l)}hasOffscreenPass(){return 0!==this.paint.get("heatmap-opacity")&&"none"!==this.visibility}getProgramIds(){return ["heatmap","heatmapTexture"]}getDefaultProgramParams(t,e){return "heatmap"===t?{config:new Do(this,e),overrideFog:!1}:{}}},hillshade:class extends ss{constructor(t,e,r){super(t,Ip,e,r);}hasOffscreenPass(){return 0!==this.paint.get("hillshade-exaggeration")&&"none"!==this.visibility}getProgramIds(){return ["hillshade","hillshadePrepare"]}getDefaultProgramParams(t,e){return {overrideFog:!1}}},fill:class extends ss{constructor(t,e,r){super(t,cf,e,r);}getProgramIds(){const t=this.paint.get("fill-pattern"),e=t&&t.constantOr(1),r=[e?"fillPattern":"fill"];return this.paint.get("fill-antialias")&&r.push(e&&!this.getPaintProperty("fill-outline-color")?"fillOutlinePattern":"fillOutline"),r}getDefaultProgramParams(t,e){return {config:new Do(this,e),overrideFog:!1}}recalculate(t,e){super.recalculate(t,e);const r=this.paint._values["fill-outline-color"];"constant"===r.value.kind&&void 0===r.value.value&&(this.paint._values["fill-outline-color"]=this.paint._values["fill-color"]);}createBucket(t){return new lf(t)}queryRadius(){return Wl(this.paint.get("fill-translate"))}queryIntersectsFeature(t,e,r,n,i,a){return !t.queryGeometry.isAboveHorizon&&Fl(Jl(t.tilespaceGeometry,this.paint.get("fill-translate"),this.paint.get("fill-translate-anchor"),a.angle,t.pixelToTileUnitsFactor),n)}isTileClipped(){return !0}},"fill-extrusion":class extends ss{constructor(t,e,r){super(t,kd,e,r),this._stats={numRenderedVerticesInShadowPass:0,numRenderedVerticesInTransparentPass:0};}createBucket(t){return new md(t)}queryRadius(){return Wl(this.paint.get("fill-extrusion-translate"))}is3D(){return !0}hasShadowPass(){return !0}cutoffRange(){return this.paint.get("fill-extrusion-cutoff-fade-range")}canCastShadows(){return !0}getProgramIds(){return [this.paint.get("fill-extrusion-pattern").constantOr(1)?"fillExtrusionPattern":"fillExtrusion"]}queryIntersectsFeature(e,r,n,i,a,s,o,l,u){const c=Ql(this.paint.get("fill-extrusion-translate"),this.paint.get("fill-extrusion-translate-anchor"),s.angle,e.pixelToTileUnitsFactor),h=this.paint.get("fill-extrusion-height").evaluate(r,n),p=this.paint.get("fill-extrusion-base").evaluate(r,n),f=[0,0],d=l&&s.elevation,m=s.elevation?s.elevation.exaggeration():1,y=e.tile.getBucket(this);if(d&&y instanceof md){const t=y.centroidVertexArray,e=u+1;e<t.length&&(f[0]=t.geta_centroid_pos0(e),f[1]=t.geta_centroid_pos1(e));}if(0===f[0]&&1===f[1])return !1;"globe"===s.projection.name&&(i=Ad([i],[new g(0,0),new g(Tr,Tr)],e.tileID.canonical).map((t=>t.polygon)).flat());const x=d?l:null,[v,b]=function(e,r,n,i,a,s,o,l,u,c,h){return "globe"===e.projection.name?function(e,r,n,i,a,s,o,l,u,c,h){const p=[],f=[],d=e.projection.upVectorScale(h,e.center.lat,e.worldSize).metersToTile,m=[0,0,0,1],y=[0,0,0,1],g=(t,e,r,n)=>{t[0]=e,t[1]=r,t[2]=n,t[3]=1;},x=Md();n>0&&(n+=x),i+=x;for(const x of r){const r=[],v=[];for(const p of x){const f=p.x+a.x,x=p.y+a.y,b=e.projection.projectTilePoint(f,x,h),_=e.projection.upVector(h,p.x,p.y);let w=n,M=i;if(o){const t=Td(f,x,n,i,o,l,u,c);w+=t.base,M+=t.top;}0!==n?g(m,b.x+_[0]*d*w,b.y+_[1]*d*w,b.z+_[2]*d*w):g(m,b.x,b.y,b.z),g(y,b.x+_[0]*d*M,b.y+_[1]*d*M,b.z+_[2]*d*M),t.N.transformMat4(m,m,s),t.N.transformMat4(y,y,s),r.push(new Pd(m[0],m[1],m[2])),v.push(new Pd(y[0],y[1],y[2]));}p.push(r),f.push(v);}return [p,f]}(e,r,n,i,a,s,o,l,u,c,h):o?function(e,r,n,i,a,s,o,l,u){const c=[],h=[],p=[0,0,0,1];for(const f of e){const e=[],d=[];for(const c of f){const h=c.x+i.x,f=c.y+i.y,m=Td(h,f,r,n,s,o,l,u);p[0]=h,p[1]=f,p[2]=m.base,p[3]=1,t.a7.transformMat4(p,p,a),p[3]=Math.max(p[3],1e-5);const y=new Pd(p[0]/p[3],p[1]/p[3],p[2]/p[3]);p[0]=h,p[1]=f,p[2]=m.top,p[3]=1,t.a7.transformMat4(p,p,a),p[3]=Math.max(p[3],1e-5);const g=new Pd(p[0]/p[3],p[1]/p[3],p[2]/p[3]);e.push(y),d.push(g);}c.push(e),h.push(d);}return [c,h]}(r,n,i,a,s,o,l,u,c):function(t,e,r,n,i){const a=[],s=[],o=i[8]*e,l=i[9]*e,u=i[10]*e,c=i[11]*e,h=i[8]*r,p=i[9]*r,f=i[10]*r,d=i[11]*r;for(const e of t){const t=[],r=[];for(const a of e){const e=a.x+n.x,s=a.y+n.y,m=i[0]*e+i[4]*s+i[12],y=i[1]*e+i[5]*s+i[13],g=i[2]*e+i[6]*s+i[14],x=i[3]*e+i[7]*s+i[15],v=m+o,b=y+l,_=g+u,w=Math.max(x+c,1e-5),M=m+h,A=y+p,S=g+f,I=Math.max(x+d,1e-5);t.push(new Pd(v/w,b/w,_/w)),r.push(new Pd(M/I,A/I,S/I));}a.push(t),s.push(r);}return [a,s]}(r,n,i,a,s)}(s,i,p,h,c,o,x,f,m,s.center.lat,e.tileID.canonical),_=e.queryGeometry;return function(t,e,r){let n=1/0;Fl(r,e)&&(n=zd(r,e[0]));for(let i=0;i<e.length;i++){const a=e[i],s=t[i];for(let t=0;t<a.length-1;t++){const e=a[t],i=[e,a[t+1],s[t+1],s[t],e];Vl(r,i)&&(n=Math.min(n,zd(r,i)));}}return n!==1/0&&n}(v,b,_.isPointQuery()?_.screenBounds:_.screenGeometry)}},line:class extends ss{constructor(t,e,r){super(t,Ud,e,r),this.gradientVersion=0;}_handleSpecialPaintPropertyUpdate(t){if("line-gradient"===t){const t=this._transitionablePaint._values["line-gradient"].value.expression;this.stepInterpolant=t._styleExpression&&t._styleExpression.expression instanceof Sn,this.gradientVersion=(this.gradientVersion+1)%Number.MAX_SAFE_INTEGER;}}gradientExpression(){return this._transitionablePaint._values["line-gradient"].value.expression}widthExpression(){return this._transitionablePaint._values["line-width"].value.expression}recalculate(t,e){super.recalculate(t,e),this.paint._values["line-floorwidth"]=Xd.possiblyEvaluate(this._transitioningPaint._values["line-width"].value,t);}createBucket(t){return new Nd(t)}getProgramIds(){return [this.paint.get("line-pattern").constantOr(1)?"linePattern":"line"]}getDefaultProgramParams(t,e){const r=Gd(this);return {config:new Do(this,e),defines:r,overrideFog:!1}}queryRadius(t){const e=t,r=Zd(Hl("line-width",this,e),Hl("line-gap-width",this,e)),n=Hl("line-offset",this,e);return r/2+Math.abs(n)+Wl(this.paint.get("line-translate"))}queryIntersectsFeature(t,e,r,n,i,a){if(t.queryGeometry.isAboveHorizon)return !1;const s=Jl(t.tilespaceGeometry,this.paint.get("line-translate"),this.paint.get("line-translate-anchor"),a.angle,t.pixelToTileUnitsFactor),o=t.pixelToTileUnitsFactor/2*Zd(this.paint.get("line-width").evaluate(e,r),this.paint.get("line-gap-width").evaluate(e,r)),l=this.paint.get("line-offset").evaluate(e,r);return l&&(n=function(t,e){const r=[],n=new g(0,0);for(let i=0;i<t.length;i++){const a=t[i],s=[];for(let t=0;t<a.length;t++){const r=a[t],i=a[t+1],o=0===t?n:r.sub(a[t-1])._unit()._perp(),l=t===a.length-1?n:i.sub(r)._unit()._perp(),u=o._add(l)._unit();u._mult(1/(u.x*l.x+u.y*l.y)),s.push(u._mult(e)._add(r));}r.push(s);}return r}(n,l*t.pixelToTileUnitsFactor)),function(t,e,r){for(let n=0;n<e.length;n++){const i=e[n];if(t.length>=3)for(let e=0;e<i.length;e++)if(Gl(t,i[e]))return !0;if(Nl(t,i,r))return !0}return !1}(s,n,o)}isTileClipped(){return !0}},symbol:kg,background:class extends ss{constructor(t,e,r){super(t,Eg,e,r);}getProgramIds(){return [this.paint.get("background-pattern")?"backgroundPattern":"background"]}getDefaultProgramParams(t,e){return {overrideFog:!1}}},raster:Og,"raster-particle":qg,sky:class extends ss{constructor(t,e,r){super(t,Yg,e,r),this._updateColorRamp();}_handleSpecialPaintPropertyUpdate(t){"sky-gradient"===t?this._updateColorRamp():"sky-atmosphere-sun"!==t&&"sky-atmosphere-halo-color"!==t&&"sky-atmosphere-color"!==t&&"sky-atmosphere-sun-intensity"!==t||(this._skyboxInvalidated=!0);}_updateColorRamp(){this.colorRamp=Ap({expression:this._transitionablePaint._values["sky-gradient"].value.expression,evaluationKey:"skyRadialProgress"}),this.colorRampTexture&&(this.colorRampTexture.destroy(),this.colorRampTexture=null);}needsSkyboxCapture(t){if(this._skyboxInvalidated||!this.skyboxTexture||!this.skyboxGeometry)return !0;if(!this.paint.get("sky-atmosphere-sun")){const e=t.style.light.properties.get("position");return this._lightPosition.azimuthal!==e.azimuthal||this._lightPosition.polar!==e.polar}return !1}getCenter(t,e){if("atmosphere"===this.paint.get("sky-type")){const r=this.paint.get("sky-atmosphere-sun"),n=!r,i=t.style.light,a=i.properties.get("position");return n&&"viewport"===i.properties.get("anchor")&&j("The sun direction is attached to a light with viewport anchor, lighting may behave unexpectedly."),n?Xg(a.azimuthal,90-a.polar,e):Xg(r[0],90-r[1],e)}const r=this.paint.get("sky-gradient-center");return Xg(r[0],90-r[1],e)}isSky(){return !0}markSkyboxValid(t){this._skyboxInvalidated=!1,this._lightPosition=t.style.light.properties.get("position");}hasOffscreenPass(){return !0}getProgramIds(){const t=this.paint.get("sky-type");return "atmosphere"===t?["skyboxCapture","skybox"]:"gradient"===t?["skyboxGradient"]:null}},slot:class extends ss{constructor(t,e,r){super(t,Zg,e);}},model:class extends ss{constructor(t,e,r){super(t,yx,e,r),this._stats={numRenderedVerticesInShadowPass:0,numRenderedVerticesInTransparentPass:0};}createBucket(t){return new dx(t)}getProgramIds(){return ["model"]}is3D(){return !0}hasShadowPass(){return !0}canCastShadows(){return !0}hasLightBeamPass(){return !0}cutoffRange(){return this.paint.get("model-cutoff-fade-range")}queryRadius(t){return t instanceof Pv?Tr-1:0}queryIntersectsFeature(e,r,n,i,a,s){if(!this.modelManager)return !1;const o=this.modelManager,l=e.tile.getBucket(this);if(!(l&&l instanceof dx))return !1;const u=l;for(const n in u.instancesPerModel){const i=u.instancesPerModel[n];if(i.idToFeaturesIndex.hasOwnProperty(r.id)){const a=i.features[i.idToFeaturesIndex[r.id]],l=o.getModel(n,this.scope);if(!l)return !1;let c=t.a6.create();const h=new tl(0,0),p=u.canonical;let f=Number.MAX_VALUE;for(let r=0;r<a.instancedDataCount;++r){const n=16*(a.instancedDataOffset+r),o=i.instancedDataArray.float32,u=[o[n+4],o[n+5],o[n+6]];Bv(p,h,o[n],0|o[n+1]),vx(c,l,s,h,a.rotation,a.scale,u,!1,!1,!1),"globe"===s.projection.name&&(c=nx(c,s));const d=t.a6.multiply([],s.projMatrix,c),m=e.queryGeometry,y=ix(m.isPointQuery()?m.screenBounds:m.screenGeometry,s,d,l.aabb);null!=y&&(f=Math.min(y,f));}return f!==Number.MAX_VALUE&&f}}return !1}_handleOverridablePaintPropertyUpdate(t,e,r){return !(!this.layout||e.isDataDriven()||r.isDataDriven()||"model-color"!==t&&"model-color-mix-intensity"!==t&&"model-rotation"!==t&&"model-scale"!==t&&"model-translation"!==t&&"model-emissive-strength"!==t)}_isPropertyZoomDependent(t){const e=this._transitionablePaint._values[t];return null!=e&&null!=e.value&&null!=e.value.expression&&e.value.expression instanceof Xi}isZoomDependent(){return this._isPropertyZoomDependent("model-scale")||this._isPropertyZoomDependent("model-rotation")||this._isPropertyZoomDependent("model-translation")}queryIntersectsMatchingFeature(e,r,n,i){const a=e.tile,s=a.getBucket(this);let o=null,l=Number.MAX_VALUE;if(!(s&&s instanceof Pv))return {queryFeature:o,intersectionZ:l};const u=s.getNodesInfo()[r];if(u.hiddenByReplacement||!u.node.meshes||!n.filter(new Pa(a.tileID.overscaledZ),u.feature,a.tileID.canonical))return {queryFeature:o,intersectionZ:l};const c=u.node,h=i.calculatePosMatrix(a.tileID.toUnwrapped(),i.worldSize),p=u.evaluatedScale;let f=0;i.elevation&&c.elevation&&(f=c.elevation*i.elevation.exaggeration()),t.a6.translate(h,h,[(c.anchor?c.anchor[0]:0)*(p[0]-1),(c.anchor?c.anchor[1]:0)*(p[1]-1),f]),t.a6.scale(h,h,p),t.a6.multiply(h,h,c.matrix);const d=e.queryGeometry,m=d.isPointQuery()?d.screenBounds:d.screenGeometry,y=function(e){const r=t.a6.multiply([],h,e.matrix),n=t.a6.multiply(r,i.expandedFarZProjMatrix,r);for(let t=0;t<e.meshes.length;++t){const r=e.meshes[t];if(t===e.lightMeshIndex)continue;const a=ix(m,i,n,r.aabb);null!=a&&(l=Math.min(a,l));}if(e.children)for(const t of e.children)y(t);};if(y(c),l===Number.MAX_VALUE)return {queryFeature:o,intersectionZ:l};const g=new tl(0,0);return Bv(a.tileID.canonical,g,u.node.anchor[0],u.node.anchor[1]),o={type:"Feature",geometry:{type:"Point",coordinates:[g.lng,g.lat]},properties:u.feature.properties,id:u.feature.id,state:{},layer:this.serialize()},{queryFeature:o,intersectionZ:l}}}},Rv={read:function(t,e){return t.readFields(Rv._readField,{header_length:0,x:0,y:0,z:0,layers:[]},e)},_readField:function(t,e,r){1===t?e.header_length=r.readFixed32():2===t?e.x=r.readVarint():3===t?e.y=r.readVarint():4===t?e.z=r.readVarint():5===t&&e.layers.push(Rv.Layer.read(r,r.readVarint()+r.pos));},PixelFormat:{PIXEL_FORMAT_UNKNOWN:{value:0,options:{}},PIXEL_FORMAT_UINT32:{value:1,options:{}},PIXEL_FORMAT_UINT16:{value:2,options:{}},PIXEL_FORMAT_UINT8:{value:3,options:{}}},Filter:{}};Rv.Filter.read=function(t,e){return t.readFields(Rv.Filter._readField,{delta_filter:null,filter:null,zigzag_filter:null,bitshuffle_filter:null,byteshuffle_filter:null},e)},Rv.Filter._readField=function(t,e,r){1===t?(e.delta_filter=Rv.Filter.Delta.read(r,r.readVarint()+r.pos),e.filter="delta_filter"):2===t?(e.zigzag_filter=Rv.Filter.Zigzag.read(r,r.readVarint()+r.pos),e.filter="zigzag_filter"):3===t?(e.bitshuffle_filter=Rv.Filter.BitShuffle.read(r,r.readVarint()+r.pos),e.filter="bitshuffle_filter"):4===t&&(e.byteshuffle_filter=Rv.Filter.ByteShuffle.read(r,r.readVarint()+r.pos),e.filter="byteshuffle_filter");},Rv.Filter.Delta={},Rv.Filter.Delta.read=function(t,e){return t.readFields(Rv.Filter.Delta._readField,{block_size:0},e)},Rv.Filter.Delta._readField=function(t,e,r){1===t&&(e.block_size=r.readVarint());},Rv.Filter.Zigzag={},Rv.Filter.Zigzag.read=function(t,e){return t.readFields(Rv.Filter.Zigzag._readField,{},e)},Rv.Filter.Zigzag._readField=function(t,e,r){},Rv.Filter.BitShuffle={},Rv.Filter.BitShuffle.read=function(t,e){return t.readFields(Rv.Filter.BitShuffle._readField,{},e)},Rv.Filter.BitShuffle._readField=function(t,e,r){},Rv.Filter.ByteShuffle={},Rv.Filter.ByteShuffle.read=function(t,e){return t.readFields(Rv.Filter.ByteShuffle._readField,{},e)},Rv.Filter.ByteShuffle._readField=function(t,e,r){},Rv.Codec={},Rv.Codec.read=function(t,e){return t.readFields(Rv.Codec._readField,{gzip_data:null,codec:null,jpeg_image:null,webp_image:null,png_image:null},e)},Rv.Codec._readField=function(t,e,r){1===t?(e.gzip_data=Rv.Codec.GzipData.read(r,r.readVarint()+r.pos),e.codec="gzip_data"):2===t?(e.jpeg_image=Rv.Codec.JpegImage.read(r,r.readVarint()+r.pos),e.codec="jpeg_image"):3===t?(e.webp_image=Rv.Codec.WebpImage.read(r,r.readVarint()+r.pos),e.codec="webp_image"):4===t&&(e.png_image=Rv.Codec.PngImage.read(r,r.readVarint()+r.pos),e.codec="png_image");},Rv.Codec.GzipData={},Rv.Codec.GzipData.read=function(t,e){return t.readFields(Rv.Codec.GzipData._readField,{},e)},Rv.Codec.GzipData._readField=function(t,e,r){},Rv.Codec.JpegImage={},Rv.Codec.JpegImage.read=function(t,e){return t.readFields(Rv.Codec.JpegImage._readField,{},e)},Rv.Codec.JpegImage._readField=function(t,e,r){},Rv.Codec.WebpImage={},Rv.Codec.WebpImage.read=function(t,e){return t.readFields(Rv.Codec.WebpImage._readField,{},e)},Rv.Codec.WebpImage._readField=function(t,e,r){},Rv.Codec.PngImage={},Rv.Codec.PngImage.read=function(t,e){return t.readFields(Rv.Codec.PngImage._readField,{},e)},Rv.Codec.PngImage._readField=function(t,e,r){},Rv.DataIndexEntry={},Rv.DataIndexEntry.read=function(t,e){return t.readFields(Rv.DataIndexEntry._readField,{first_byte:0,last_byte:0,filters:[],codec:null,offset:0,scale:0,bands:[]},e)},Rv.DataIndexEntry._readField=function(t,e,r){1===t?e.first_byte=r.readFixed64():2===t?e.last_byte=r.readFixed64():3===t?e.filters.push(Rv.Filter.read(r,r.readVarint()+r.pos)):4===t?e.codec=Rv.Codec.read(r,r.readVarint()+r.pos):5===t?e.offset=r.readFloat():6===t?e.scale=r.readFloat():7===t&&e.bands.push(r.readString());},Rv.Layer={},Rv.Layer.read=function(t,e){return t.readFields(Rv.Layer._readField,{version:0,name:"",units:"",tilesize:0,buffer:0,pixel_format:0,data_index:[]},e)},Rv.Layer._readField=function(t,e,r){1===t?e.version=r.readVarint():2===t?e.name=r.readString():3===t?e.units=r.readString():4===t?e.tilesize=r.readVarint():5===t?e.buffer=r.readVarint():6===t?e.pixel_format=r.readVarint():7===t&&e.data_index.push(Rv.DataIndexEntry.read(r,r.readVarint()+r.pos));};const Dv={read:function(t,e){return t.readFields(Dv._readField,{uint32_values:null,values:null,fixed32_values:null},e)},_readField:function(t,e,r){2===t?(e.uint32_values=Dv.Uint32Values.read(r,r.readVarint()+r.pos),e.values="uint32_values"):3===t&&(e.fixed32_values=Dv.Fixed32Values.read(r,r.readVarint()+r.pos),e.values="fixed32_values");},Uint32Values:{}};Dv.Uint32Values.read=function(t,e){return t.readFields(Dv.Uint32Values._readField,{values:[]},e)},Dv.Uint32Values._readField=function(t,e,r){1===t&&(e.readValuesInto=function(t){if(2!==t.type)throw new Error(`Unsupported pbf type "${t.type}"`);const e=function(t){return 2===t.type?t.readVarint()+t.pos:t.pos+1}(t),r=t.pos;return t.pos=e,function(n){t.pos=r;let i=0;for(;t.pos<e;){const e=t.readVarint();n[i++]=e;}return n}}(r));},Dv.Fixed32Values={},Dv.Fixed32Values.read=function(t,e){return t.readFields(Dv.Fixed32Values._readField,{values:[]},e)},Dv.Fixed32Values._readField=function(t,e,r){throw new Error("Not implemented")};
/**
 * tiny-lru
 *
 * @copyright 2023 Jason Mulligan <jason.mulligan@avoidwork.com>
 * @license BSD-3-Clause
 * @version 11.2.5
 */
class Vv{constructor(t=0,e=0,r=!1){this.first=null,this.items=Object.create(null),this.last=null,this.max=t,this.resetTtl=r,this.size=0,this.ttl=e;}clear(){return this.first=null,this.items=Object.create(null),this.last=null,this.size=0,this}delete(t){if(this.has(t)){const e=this.items[t];delete this.items[t],this.size--,null!==e.prev&&(e.prev.next=e.next),null!==e.next&&(e.next.prev=e.prev),this.first===e&&(this.first=e.next),this.last===e&&(this.last=e.prev);}return this}entries(t=this.keys()){return t.map((t=>[t,this.get(t)]))}evict(t=!1){if(t||this.size>0){const t=this.first;delete this.items[t.key],0==--this.size?(this.first=null,this.last=null):(this.first=t.next,this.first.prev=null);}return this}expiresAt(t){let e;return this.has(t)&&(e=this.items[t].expiry),e}get(t){let e;if(this.has(t)){const r=this.items[t];this.ttl>0&&r.expiry<=Date.now()?this.delete(t):(e=r.value,this.set(t,e,!0));}return e}has(t){return t in this.items}keys(){const t=[];let e=this.first;for(;null!==e;)t.push(e.key),e=e.next;return t}set(t,e,r=!1,n=this.resetTtl){let i;if(r||this.has(t)){if(i=this.items[t],i.value=e,!1===r&&n&&(i.expiry=this.ttl>0?Date.now()+this.ttl:this.ttl),this.last!==i){const t=this.last,e=i.next,r=i.prev;this.first===i&&(this.first=i.next),i.next=null,i.prev=this.last,t.next=i,null!==r&&(r.next=e),null!==e&&(e.prev=r);}}else this.max>0&&this.size===this.max&&this.evict(!0),i=this.items[t]={expiry:this.ttl>0?Date.now()+this.ttl:this.ttl,key:t,prev:this.last,next:null,value:e},1==++this.size?this.first=i:this.last.next=i;return this.last=i,this}values(t=this.keys()){return t.map((t=>this.get(t)))}}function Lv(t,e){if(4!==e.length)throw new Error(`Expected data of dimension 4 but got ${e.length}.`);let r=e[3];for(let n=2;n>=1;n--){const i=1===n?1:0,a=2===n?1:0;for(let n=0;n<e[0];n++){const s=e[1]*n;for(let n=i;n<e[1];n++){const i=e[2]*(n+s);for(let n=a;n<e[2];n++){const a=e[3]*(n+i);for(let n=0;n<e[3];n++){const e=a+n;t[e]+=t[e-r];}}}}r*=e[n];}return t}function Fv(t){for(let e=0,r=t.length;e<r;e++)t[e]=t[e]>>>1^-(1&t[e]);return t}function Nv(t,e){switch(e){case"uint32":return t;case"uint16":for(let e=0;e<t.length;e+=2){const r=t[e],n=t[e+1];t[e]=(240&r)>>4|(61440&r)>>8|(240&n)<<4|61440&n,t[e+1]=15&r|(3840&r)>>4|(15&n)<<8|(3840&n)<<4;}return t;case"uint8":for(let e=0;e<t.length;e+=4){const r=t[e],n=t[e+1],i=t[e+2],a=t[e+3];t[e+0]=(192&r)>>6|(192&n)>>4|(192&i)>>2|192&a,t[e+1]=(48&r)>>4|(48&n)>>2|48&i|(48&a)<<2,t[e+2]=(12&r)>>2|12&n|(12&i)<<2|(12&a)<<4,t[e+3]=3&r|(3&n)<<2|(3&i)<<4|(3&a)<<6;}return t;default:throw new Error(`Invalid pixel format, "${e}"`)}}class Ov extends Error{constructor(t){super(t),this.name="MRTError";}}var Uv=Uint8Array,jv=Uint16Array,qv=Int32Array,$v=new Uv([0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,2,3,3,3,3,4,4,4,4,5,5,5,5,0,0,0,0]),Gv=new Uv([0,0,0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,0,0]),Yv=new Uv([16,17,18,0,8,7,9,6,10,5,11,4,12,3,13,2,14,1,15]),Xv=function(t,e){for(var r=new jv(31),n=0;n<31;++n)r[n]=e+=1<<t[n-1];var i=new qv(r[30]);for(n=1;n<30;++n)for(var a=r[n];a<r[n+1];++a)i[a]=a-r[n]<<5|n;return {b:r,r:i}},Zv=Xv($v,2),Kv=Zv.b,Hv=Zv.r;Kv[28]=258,Hv[258]=28;for(var Wv=Xv(Gv,0).b,Jv=new jv(32768),Qv=0;Qv<32768;++Qv){var tb=(43690&Qv)>>1|(21845&Qv)<<1;Jv[Qv]=((65280&(tb=(61680&(tb=(52428&tb)>>2|(13107&tb)<<2))>>4|(3855&tb)<<4))>>8|(255&tb)<<8)>>1;}var eb=function(t,e,r){for(var n=t.length,i=0,a=new jv(e);i<n;++i)t[i]&&++a[t[i]-1];var s,o=new jv(e);for(i=1;i<e;++i)o[i]=o[i-1]+a[i-1]<<1;if(r){s=new jv(1<<e);var l=15-e;for(i=0;i<n;++i)if(t[i])for(var u=i<<4|t[i],c=e-t[i],h=o[t[i]-1]++<<c,p=h|(1<<c)-1;h<=p;++h)s[Jv[h]>>l]=u;}else for(s=new jv(n),i=0;i<n;++i)t[i]&&(s[i]=Jv[o[t[i]-1]++]>>15-t[i]);return s},rb=new Uv(288);for(Qv=0;Qv<144;++Qv)rb[Qv]=8;for(Qv=144;Qv<256;++Qv)rb[Qv]=9;for(Qv=256;Qv<280;++Qv)rb[Qv]=7;for(Qv=280;Qv<288;++Qv)rb[Qv]=8;var nb=new Uv(32);for(Qv=0;Qv<32;++Qv)nb[Qv]=5;var ib=eb(rb,9,1),ab=eb(nb,5,1),sb=function(t){for(var e=t[0],r=1;r<t.length;++r)t[r]>e&&(e=t[r]);return e},ob=function(t,e,r){var n=e/8|0;return (t[n]|t[n+1]<<8)>>(7&e)&r},lb=function(t,e){var r=e/8|0;return (t[r]|t[r+1]<<8|t[r+2]<<16)>>(7&e)},ub=["unexpected EOF","invalid block type","invalid length/literal","invalid distance","stream finished","no stream handler",,"no callback","invalid UTF-8 data","extra field too long","date not in range 1980-2099","filename too long","stream finishing","invalid zip data"],cb=function(t,e,r){var n=new Error(e||ub[t]);if(n.code=t,Error.captureStackTrace&&Error.captureStackTrace(n,cb),!r)throw n;return n},hb=new Uv(0),pb="undefined"!=typeof TextDecoder&&new TextDecoder;try{pb.decode(hb,{stream:!0});}catch(t){}const fb={gzip_data:"gzip"};const db={0:"uint32",1:"uint32",2:"uint16",3:"uint8"},mb={uint32:1,uint16:2,uint8:4},yb={uint32:Uint32Array,uint16:Uint16Array,uint8:Uint8Array};class gb{constructor(t=1){this.x=NaN,this.y=NaN,this.z=NaN,this.layers={},this._cacheSize=t;}getLayer(t){return this.layers[t]}getHeaderLength(t){const e=new Uint8Array(t),r=new DataView(t);if(13!==e[0])throw new Ov("File is not a valid MRT.");return r.getUint32(1,!0)}parseHeader(t){const e=new Uint8Array(t),r=this.getHeaderLength(t);if(e.length<r)throw new Ov(`Expected header with length >= ${r} but got buffer of length ${e.length}`);const n=new Vm(e.subarray(0,r)),i=Rv.read(n);if(!isNaN(this.x)&&(this.x!==i.x||this.y!==i.y||this.z!==i.z))throw new Ov(`Invalid attempt to parse header ${i.z}/${i.x}/${i.y} for tile ${this.z}/${this.x}/${this.y}`);this.x=i.x,this.y=i.y,this.z=i.z;for(const t of i.layers)this.layers[t.name]=new xb(t,{cacheSize:this._cacheSize});return this}createDecodingTask(t){const e=[],r=this.getLayer(t.layerName);for(let n=0;n<r.dataIndex.length;n++){const i=r.dataIndex[n],a=i.first_byte-t.firstByte,s=i.last_byte+1-t.firstByte;if(n<t.firstBlock||n>t.lastBlock)continue;if(r._blocksInProgress.has(n))continue;const o={layerName:r.name,firstByte:a,lastByte:s,pixelFormat:r.pixelFormat,blockIndex:n,blockShape:[i.bands.length].concat(r.bandShape),buffer:r.buffer,codec:i.codec.codec,filters:i.filters.map((t=>t.filter))};r._blocksInProgress.add(n),e.push(o);}return new vb(e,(()=>{e.forEach((t=>r._blocksInProgress.delete(t.blockIndex)));}),((t,n)=>{if(e.forEach((t=>r._blocksInProgress.delete(t.blockIndex))),t)throw t;n.forEach((t=>{this.getLayer(t.layerName).processDecodedData(t);}));}))}}class xb{constructor({version:t,name:e,units:r,tilesize:n,pixel_format:i,buffer:a,data_index:s},o){if(this.version=t,1!==this.version)throw new Ov(`Cannot parse raster layer encoded with MRT version ${t}`);this.name=e,this.units=r,this.tileSize=n,this.buffer=a,this.pixelFormat=db[i],this.dataIndex=s,this.bandShape=[n+2*a,n+2*a,mb[this.pixelFormat]],this._decodedBlocks=function(t=1e3,e=0,r=!1){if(isNaN(t)||t<0)throw new TypeError("Invalid max value");if(isNaN(e)||e<0)throw new TypeError("Invalid ttl value");if("boolean"!=typeof r)throw new TypeError("Invalid resetTtl value");return new Vv(t,e,r)}(o?o.cacheSize:5),this._blocksInProgress=new Set;}processDecodedData(t){const e=t.blockIndex.toString();this._decodedBlocks.get(e)||this._decodedBlocks.set(e,t.data);}getBlockForBand(t){let e=0;switch(typeof t){case"string":for(const[r,n]of this.dataIndex.entries()){for(const[i,a]of n.bands.entries())if(a===t)return {bandIndex:e+i,blockIndex:r,blockBandIndex:i};e+=n.bands.length;}break;case"number":for(const[r,n]of this.dataIndex.entries()){if(t>=e&&t<e+n.bands.length)return {bandIndex:t,blockIndex:r,blockBandIndex:t-e};e+=n.bands.length;}break;default:throw new Ov(`Invalid band \`${JSON.stringify(t)}\`. Expected string or integer.`)}throw new Ov(`Band not found: ${JSON.stringify(t)}`)}getDataRange(t){let e=1/0,r=-1/0,n=1/0,i=-1/0;for(const a of t){const{blockIndex:t}=this.getBlockForBand(a);if(t<0)throw new Ov(`Invalid band: ${JSON.stringify(a)}`);const s=this.dataIndex[t];n=Math.min(n,t),i=Math.max(i,t),e=Math.min(e,s.first_byte),r=Math.max(r,s.last_byte);}return {layerName:this.name,firstByte:e,lastByte:r,firstBlock:n,lastBlock:i}}hasBand(t){const{blockIndex:e}=this.getBlockForBand(t);return e>=0}hasDataForBand(t){const{blockIndex:e}=this.getBlockForBand(t);return e>=0&&!!this._decodedBlocks.get(e.toString())}getBandView(t){const{blockIndex:e,blockBandIndex:r}=this.getBlockForBand(t),n=this._decodedBlocks.get(e.toString());if(!n)throw new Ov(`Data for band ${JSON.stringify(t)} of layer "${this.name}" not decoded.`);const i=this.dataIndex[e],a=this.bandShape.reduce(((t,e)=>t*e),1),s=r*a,o=n.subarray(s,s+a);return {data:o,bytes:new Uint8Array(o.buffer).subarray(o.byteOffset,o.byteOffset+o.byteLength),tileSize:this.tileSize,buffer:this.buffer,offset:i.offset,scale:i.scale}}}class vb{constructor(t,e,r){this.tasks=t,this._onCancel=e,this._onComplete=r,this._finalized=!1;}cancel(){this._finalized||(this._onCancel(),this._finalized=!0);}complete(t,e){this._finalized||(this._onComplete(t,e),this._finalized=!0);}}gb.performDecoding=function(t,e){return Promise.all(e.tasks.map((e=>{const{layerName:r,firstByte:n,lastByte:i,pixelFormat:a,blockShape:s,blockIndex:o,filters:l,codec:u}=e,c=new Uint8Array(t).subarray(n,i+1),h=new Uint32Array(s[0]*s[1]*s[2]);let p;if("gzip_data"!==u)throw new Error(`Unhandled codec: ${u}`);return p=function(t,e){if(!globalThis.DecompressionStream&&"gzip_data"===e)return Promise.resolve(((a=function(t){31==t[0]&&139==t[1]&&8==t[2]||cb(6,"invalid gzip data");var e=t[3],r=10;4&e&&(r+=2+(t[10]|t[11]<<8));for(var n=(e>>3&1)+(e>>4&1);n>0;n-=!t[r++]);return r+(2&e)}(i=t))+8>i.length&&cb(6,"invalid gzip data"),function(t,e,r,n){var i=t.length;if(!i||e.f&&!e.l)return r||new Uv(0);var a=!r,s=a||2!=e.i,o=e.i;a&&(r=new Uv(3*i));var l=function(t){var e=r.length;if(t>e){var n=new Uv(Math.max(2*e,t));n.set(r),r=n;}},u=e.f||0,c=e.p||0,h=e.b||0,p=e.l,f=e.d,d=e.m,m=e.n,y=8*i;do{if(!p){u=ob(t,c,1);var g=ob(t,c+1,3);if(c+=3,!g){var x=t[(E=4+((c+7)/8|0))-4]|t[E-3]<<8,v=E+x;if(v>i){o&&cb(0);break}s&&l(h+x),r.set(t.subarray(E,v),h),e.b=h+=x,e.p=c=8*v,e.f=u;continue}if(1==g)p=ib,f=ab,d=9,m=5;else if(2==g){var b=ob(t,c,31)+257,_=ob(t,c+10,15)+4,w=b+ob(t,c+5,31)+1;c+=14;for(var M=new Uv(w),A=new Uv(19),S=0;S<_;++S)A[Yv[S]]=ob(t,c+3*S,7);c+=3*_;var I=sb(A),k=(1<<I)-1,P=eb(A,I,1);for(S=0;S<w;){var E,z=P[ob(t,c,k)];if(c+=15&z,(E=z>>4)<16)M[S++]=E;else {var T=0,B=0;for(16==E?(B=3+ob(t,c,3),c+=2,T=M[S-1]):17==E?(B=3+ob(t,c,7),c+=3):18==E&&(B=11+ob(t,c,127),c+=7);B--;)M[S++]=T;}}var C=M.subarray(0,b),R=M.subarray(b);d=sb(C),m=sb(R),p=eb(C,d,1),f=eb(R,m,1);}else cb(1);if(c>y){o&&cb(0);break}}s&&l(h+131072);for(var D=(1<<d)-1,V=(1<<m)-1,L=c;;L=c){var F=(T=p[lb(t,c)&D])>>4;if((c+=15&T)>y){o&&cb(0);break}if(T||cb(2),F<256)r[h++]=F;else {if(256==F){L=c,p=null;break}var N=F-254;F>264&&(N=ob(t,c,(1<<(j=$v[S=F-257]))-1)+Kv[S],c+=j);var O=f[lb(t,c)&V],U=O>>4;if(O||cb(3),c+=15&O,R=Wv[U],U>3){var j=Gv[U];R+=lb(t,c)&(1<<j)-1,c+=j;}if(c>y){o&&cb(0);break}s&&l(h+131072);var q=h+N;if(h<R){var $=0-R,G=Math.min(R,q);for($+h<0&&cb(3);h<G;++h)r[h]=n[$+h];}for(;h<q;++h)r[h]=r[h-R];}}e.l=p,e.p=L,e.b=h,e.f=u,p&&(u=1,e.m=d,e.d=f,e.n=m);}while(!u);return h!=r.length&&a?function(t,e,r){return (null==e||e<0)&&(e=0),(null==r||r>t.length)&&(r=t.length),new Uv(t.subarray(e,r))}(r,0,h):r.subarray(0,h)}(i.subarray(a,-8),{i:2},new Uv(((r=i)[(n=r.length)-4]|r[n-3]<<8|r[n-2]<<16|r[n-1]<<24)>>>0),void 0)));var r,n,i,a;const s=fb[e];if(!s)throw new Error(`Unhandled codec: ${e}`);const o=new globalThis.DecompressionStream(s);return new Response(new Blob([t]).stream().pipeThrough(o)).arrayBuffer().then((t=>new Uint8Array(t)))}(c,u).then((t=>{const e=Dv.read(new Vm(t));if("uint32_values"===e.values)return e.uint32_values.readValuesInto(h),new(0,yb[a])(h.buffer);throw new Error(`Unhandled numeric data "${e.values}"`)})),p.then((t=>{for(let e=l.length-1;e>=0;e--)switch(l[e]){case"delta_filter":Lv(t,s);break;case"zigzag_filter":Fv(t);break;case"bitshuffle_filter":Nv(t,a);break;default:throw new Error(`Unhandled filter "${l[e]}"`)}return {layerName:r,blockIndex:o,data:t}})).catch((t=>{throw t}))})))},ra(vb,"MRTDecodingBatch",{omit:["_onCancel","_onComplete"]});const bb=[Int8Array,Uint8Array,Uint8ClampedArray,Int16Array,Uint16Array,Int32Array,Uint32Array,Float32Array,Float64Array];class _b{static from(t){if(!(t instanceof ArrayBuffer))throw new Error("Data must be an instance of ArrayBuffer.");const[e,r]=new Uint8Array(t,0,2);if(219!==e)throw new Error("Data does not appear to be in a KDBush format.");const n=r>>4;if(1!==n)throw new Error(`Got v${n} data when expected v1.`);const i=bb[15&r];if(!i)throw new Error("Unrecognized array type.");const[a]=new Uint16Array(t,2,1),[s]=new Uint32Array(t,4,1);return new _b(s,a,i,t)}constructor(t,e=64,r=Float64Array,n){if(isNaN(t)||t<0)throw new Error(`Unpexpected numItems value: ${t}.`);this.numItems=+t,this.nodeSize=Math.min(Math.max(+e,2),65535),this.ArrayType=r,this.IndexArrayType=t<65536?Uint16Array:Uint32Array;const i=bb.indexOf(this.ArrayType),a=2*t*this.ArrayType.BYTES_PER_ELEMENT,s=t*this.IndexArrayType.BYTES_PER_ELEMENT,o=(8-s%8)%8;if(i<0)throw new Error(`Unexpected typed array class: ${r}.`);n&&n instanceof ArrayBuffer?(this.data=n,this.ids=new this.IndexArrayType(this.data,8,t),this.coords=new this.ArrayType(this.data,8+s+o,2*t),this._pos=2*t,this._finished=!0):(this.data=new ArrayBuffer(8+a+s+o),this.ids=new this.IndexArrayType(this.data,8,t),this.coords=new this.ArrayType(this.data,8+s+o,2*t),this._pos=0,this._finished=!1,new Uint8Array(this.data,0,2).set([219,16+i]),new Uint16Array(this.data,2,1)[0]=e,new Uint32Array(this.data,4,1)[0]=t);}add(t,e){const r=this._pos>>1;return this.ids[r]=r,this.coords[this._pos++]=t,this.coords[this._pos++]=e,r}finish(){const t=this._pos>>1;if(t!==this.numItems)throw new Error(`Added ${t} items when expected ${this.numItems}.`);return wb(this.ids,this.coords,this.nodeSize,0,this.numItems-1,0),this._finished=!0,this}range(t,e,r,n){if(!this._finished)throw new Error("Data not yet indexed - call index.finish().");const{ids:i,coords:a,nodeSize:s}=this,o=[0,i.length-1,0],l=[];for(;o.length;){const u=o.pop()||0,c=o.pop()||0,h=o.pop()||0;if(c-h<=s){for(let s=h;s<=c;s++){const o=a[2*s],u=a[2*s+1];o>=t&&o<=r&&u>=e&&u<=n&&l.push(i[s]);}continue}const p=h+c>>1,f=a[2*p],d=a[2*p+1];f>=t&&f<=r&&d>=e&&d<=n&&l.push(i[p]),(0===u?t<=f:e<=d)&&(o.push(h),o.push(p-1),o.push(1-u)),(0===u?r>=f:n>=d)&&(o.push(p+1),o.push(c),o.push(1-u));}return l}within(t,e,r){if(!this._finished)throw new Error("Data not yet indexed - call index.finish().");const{ids:n,coords:i,nodeSize:a}=this,s=[0,n.length-1,0],o=[],l=r*r;for(;s.length;){const u=s.pop()||0,c=s.pop()||0,h=s.pop()||0;if(c-h<=a){for(let r=h;r<=c;r++)Ib(i[2*r],i[2*r+1],t,e)<=l&&o.push(n[r]);continue}const p=h+c>>1,f=i[2*p],d=i[2*p+1];Ib(f,d,t,e)<=l&&o.push(n[p]),(0===u?t-r<=f:e-r<=d)&&(s.push(h),s.push(p-1),s.push(1-u)),(0===u?t+r>=f:e+r>=d)&&(s.push(p+1),s.push(c),s.push(1-u));}return o}}function wb(t,e,r,n,i,a){if(i-n<=r)return;const s=n+i>>1;Mb(t,e,s,n,i,a),wb(t,e,r,n,s-1,1-a),wb(t,e,r,s+1,i,1-a);}function Mb(t,e,r,n,i,a){for(;i>n;){if(i-n>600){const s=i-n+1,o=r-n+1,l=Math.log(s),u=.5*Math.exp(2*l/3),c=.5*Math.sqrt(l*u*(s-u)/s)*(o-s/2<0?-1:1);Mb(t,e,r,Math.max(n,Math.floor(r-o*u/s+c)),Math.min(i,Math.floor(r+(s-o)*u/s+c)),a);}const s=e[2*r+a];let o=n,l=i;for(Ab(t,e,n,r),e[2*i+a]>s&&Ab(t,e,n,i);o<l;){for(Ab(t,e,o,l),o++,l--;e[2*o+a]<s;)o++;for(;e[2*l+a]>s;)l--;}e[2*n+a]===s?Ab(t,e,n,l):(l++,Ab(t,e,l,i)),l<=r&&(n=l+1),r<=l&&(i=l-1);}}function Ab(t,e,r,n){Sb(t,r,n),Sb(e,2*r,2*n),Sb(e,2*r+1,2*n+1);}function Sb(t,e,r){const n=t[e];t[e]=t[r],t[r]=n;}function Ib(t,e,r,n){const i=t-r,a=e-n;return i*i+a*a}t.$=Yy,t.A=Di,t.B=Bi,t.C=nr,t.D=qa,t.E=ee,t.F=Oa,t.G=La,t.H=class{constructor(t){this.specification=t;}possiblyEvaluate(t,e){return G(t.expression.evaluate(e))}interpolate(t,e,r){return {x:ue(t.x,e.x,r),y:ue(t.y,e.y,r),z:ue(t.z,e.z,r),azimuthal:ue(t.azimuthal,e.azimuthal,r),polar:ue(t.polar,e.polar,r)}}},t.I=dy,t.J=Ta,t.K=Pa,t.L=Ml,t.M=class{constructor(t,e,r,n){this.id=t,this.position=null!=e?new tl(e[0],e[1]):new tl(0,0),this.orientation=null!=r?r:[0,0,0],this.nodes=n,this.uploaded=!1,this.aabb=new Bh([1/0,1/0,1/0],[-1/0,-1/0,-1/0]),this.matrix=[];}_applyTransformations(e,r){if(t.a6.multiply(e.matrix,r,e.matrix),e.meshes)for(const t of e.meshes){const r=Bh.applyTransform(t.aabb,e.matrix);this.aabb.encapsulate(r);}if(e.children)for(const t of e.children)this._applyTransformations(t,e.matrix);}computeBoundsAndApplyParent(){const e=t.a6.identity([]);for(const t of this.nodes)this._applyTransformations(t,e);}computeModelMatrix(t,e,r,n,i,a,s=!1){vx(this.matrix,this,t.transform,this.position,e,r,n,i,a,s);}upload(t){if(!this.uploaded){for(const e of this.nodes)wx(e,t);for(const t of this.nodes)Mx(t);this.uploaded=!0;}}destroy(){for(const t of this.nodes)Ax(t);}},t.O=k,t.P=g,t.Q=Va,t.R=At,t.S=rp,t.T=Cg,t.U=ue,t.V=Tr,t.W=ce,t.X=class{constructor(t){this.specification=t;}possiblyEvaluate(t,e){return function([t,e]){const r=G([1,t,e]);return {x:r.x,y:r.y,z:r.z}}(t.expression.evaluate(e))}interpolate(t,e,r){return {x:ue(t.x,e.x,r),y:ue(t.y,e.y,r),z:ue(t.z,e.z,r)}}},t.Y=function(t,e,r=0,n=!0){const i=new g(r,r),a=t.sub(i),s=e.add(i),o=[a,new g(s.x,a.y),s,new g(a.x,s.y)];return n&&o.push(a.clone()),o},t.Z=Xi,t._=function(t,e){const r=[];for(let n=0;n<t.length;n++){const i=P(n-1,-1,t.length-1),a=P(n+1,-1,t.length-1),s=t[n],o=t[a],l=t[i].sub(s).unit(),u=o.sub(s).unit(),c=u.angleWithSep(l.x,l.y),h=l.add(u).unit().mult(-1*e/Math.sin(c/2));r.push(s.add(h));}return r},t.a=te,t.a$=function(t){const e=[];for(const r in t)e.push(t[r]);return e},t.a0=Yl,t.a1=function(e,r,n=0){return t.N.fromValues(((r.x-n)*e.scale-e.x)*Tr,(r.y*e.scale-e.y)*Tr,gl(r.z,r.y))},t.a2=Sh,t.a3=jd,t.a4=function(t){let e=1/0,r=1/0,n=-1/0,i=-1/0;for(const a of t)e=Math.min(e,a.x),r=Math.min(r,a.y),n=Math.max(n,a.x),i=Math.max(i,a.y);return {min:new g(e,r),max:new g(n,i)}},t.a5=pl,t.a8=Gl,t.a9=Sl,t.aA=bi,t.aB=eo,t.aC=B,t.aD=qs,t.aE=Mg,t.aF=function(){ka.isLoading()||ka.isLoaded()||"deferred"!==Sa()||Ia();},t.aG=Ga,t.aH=Bl,t.aI=xv,t.aJ=X,t.aK=Nd,t.aL=lf,t.aM=Tl,t.aN=ps,t.aO=Vs,t.aP=Vh,t.aQ=rf,t.aR=Bg,t.aS=function(e,r){const n=rp(r.zoom);if(0===n)return jh(e);const i=Yh(e),a=Xh(i),s=pl(i.getWest())*r.worldSize,o=pl(i.getEast())*r.worldSize,l=fl(i.getNorth())*r.worldSize,u=fl(i.getSouth())*r.worldSize,c=[s,l,0],h=[o,l,0],p=[s,u,0],f=[o,u,0],d=t.a6.invert([],r.globeMatrix);return t.N.transformMat4(c,c,d),t.N.transformMat4(h,h,d),t.N.transformMat4(p,p,d),t.N.transformMat4(f,f,d),a[0]=qh(a[0],p,n),a[1]=qh(a[1],f,n),a[2]=qh(a[2],h,n),a[3]=qh(a[3],c,n),Bh.fromPoints(a)},t.aT=Wh,t.aU=Zh,t.aV=qh,t.aW=fs,t.aX=Dh,t.aY=V,t.aZ=gb,t.a_=Pt,t.aa=I,t.ab=jo,t.ac=function(t,e){const r={};for(let n=0;n<e.length;n++){const i=e[n];i in t&&(r[i]=t[i]);}return r},t.ad=el,t.ae=fl,t.af=class{constructor(t){this.entries={},this.scheduler=t;}request(t,e,r,n){const i=this.entries[t]=this.entries[t]||{callbacks:[]};if(i.result){const[t,r]=i.result;return this.scheduler?this.scheduler.add((()=>{n(t,r);}),e):n(t,r),()=>{}}return i.callbacks.push(n),i.cancel||(i.cancel=r(((r,n)=>{i.result=[r,n];for(const t of i.callbacks)this.scheduler?this.scheduler.add((()=>{t(r,n);}),e):t(r,n);setTimeout((()=>delete this.entries[t]),3e3);}))),()=>{i.result||(i.callbacks=i.callbacks.filter((t=>t!==n)),i.callbacks.length||(i.cancel(),delete this.entries[t]));}}},t.ag=is,t.ah=function(t,e,r){const n=JSON.stringify(t.request);return t.data&&(this.deduped.entries[n]={result:[null,t.data]}),this.deduped.request(n,{type:"parseTile",isSymbolTile:t.isSymbolTile,zoom:t.tileZoom},(e=>{const n=Pt(t.request,((t,n,i,a)=>{t?e(t):n&&e(null,{vectorTile:r?void 0:new Ef(new Vm(n)),rawData:n,cacheControl:i,expires:a});}));return ()=>{n.cancel(),e();}}),e)},t.ai=function(t){yt++,yt>ut&&(t.getActor().send("enforceCacheSizeLimit",lt),yt=0);},t.aj=qt,t.ak=at,t.al=function(t){return t<=1?1:Math.pow(2,Math.floor(Math.log(t)/Math.LN2))},t.am=sl,t.an=Og,t.ao=qg,t.ap=Fg,t.aq=function(t,e){const r=document.createElement("video");r.muted=!0,r.onloadstart=function(){e(null,r);};for(let e=0;e<t.length;e++){const n=document.createElement("source");Et(t[e])||(r.crossOrigin="Anonymous"),n.src=t[e],r.appendChild(n);}return {cancel:()=>{}}},t.ar=Rg,t.as=Gy,t.at=ml,t.au=yl,t.av=ds,t.aw=Es,t.ax=le,t.ay=cs,t.az=Ls,t.b=Qt,t.b$=wa,t.b0=function(t,e){const r=[];for(const n in t)n in e||r.push(n);return r},t.b1=E,t.b2=["type","source","source-layer","minzoom","maxzoom","filter","layout"],t.b3=function(e,r){const{x:n,y:i}=e.point,a=ep(n,i,e.worldSize/e._pixelsPerMercatorPixel,0,0);return t.a6.multiply(a,a,Jh(jh(r)))},t.b5=lm,t.b6=jm,t.b7=om,t.b8=function(t,e,r,n,i){const a=5*e+2;t.float32[a+0]=r,t.float32[a+1]=n,t.float32[a+2]=i;},t.b9=vg,t.bA=Wg,t.bB=Kg,t.bC=function(e){const r=Kg(e,!0);return t.b4.invert([],[r[0],r[1],r[4],r[5]])},t.bD=Ih,t.bE=function(t){const{x:e,y:r}=t.point,{lng:n,lat:i}=t._center;return ep(e,r,t.worldSize,n,i)},t.bF=_,t.bG=qo,t.bH=function(t){const e=Math.round((t+45+360)%360/90)%4;return w[e]},t.bI=45,t.bJ=hl,t.bK=So,t.bL=bo,t.bM=_o,t.bN=vo,t.bO=xo,t.bP=wo,t.bQ=function(t,e,r){const n=Math.sqrt(t*t+e*e+r*r),i=n>0?Math.acos(r/n)*v:0;let a=0!==t||0!==e?Math.atan2(-e,-t)*v+90:0;return a<0&&(a+=360),[n,a,i]},t.bR=wl,t.bS=Bh,t.bT=G,t.bU=function(t){return [Math.pow(t[0],1/2.2),Math.pow(t[1],1/2.2),Math.pow(t[2],1/2.2)]},t.bV=function(t){return t({pluginStatus:ba,pluginURL:_a}),Aa.on("pluginStateChange",t),t},t.bW=Px,t.bX=Rx,t.bY=_y,t.bZ=by,t.b_=It,t.ba=hy,t.bb=Vl,t.bc=im,t.bd=Ry,t.be=Dy,t.bf=Qm,t.bg=_b,t.bh=P,t.bj=b,t.bk=rt,t.bl=dl,t.bm=function(t,e,r){t[4*e+0]=r[0],t[4*e+1]=r[1],t[4*e+2]=r[2],t[4*e+3]=r[3];},t.bn=tl,t.bo=fg,t.bp=al,t.bq=Th,t.br=Hg,t.bs=il,t.bt=Gh,t.bu=function(t,e,r,n,i,a,s,o,l){if("globe"===l.name)return Gh(t,e,new il(r,n,i),!1);const u=Gy({z:r,x:n,y:i},l);return new Bh([(a+u.x/u.scale)*e,e*(u.y/u.scale),s],[(a+u.x2/u.scale)*e,e*(u.y2/u.scale),o])},t.bv=function(t,e,r){let n=0;for(let i=0;i<2;++i){const a=r?r[i]:0;t[i]>a&&(n+=(t[i]-a)*(t[i]-a)),e[i]<a&&(n+=(a-e[i])*(a-e[i]));}return n},t.bw=xl,t.bx=$o,t.by=function(e){const r=t.a6.identity(new Float64Array(16));t.a6.multiply(r,e.pixelMatrix,e.globeMatrix);const n=[0,Zo,0],i=[0,Ko,0];return t.N.transformMat4(n,n,r),t.N.transformMat4(i,i,r),[n[0]>0&&n[0]<=e.width&&n[1]>0&&n[1]<=e.height&&!ip(e,new tl(e.center.lat,90)),i[0]>0&&i[0]<=e.width&&i[1]>0&&i[1]<=e.height&&!ip(e,new tl(e.center.lat,-90))]},t.bz=function(e,r){const{scale:n}=e.tileTransform,i=n*Tr/(e.tileSize*Math.pow(2,r.zoom-e.tileID.overscaledZ+e.tileID.canonical.z));return t.b4.scale(new Float32Array(4),r.inverseAdjustmentMatrix,[i,i])},t.c=fv,t.c$=function(){return !!document.fullscreenElement||!!document.webkitFullscreenElement},t.c0=a,t.c1=O,t.c2=function(t,e,r){return "custom"===t.type?new $g(t,e):new Cv[t.type](t,e,r)},t.c3=function(t){const e=t.indexOf(ns);return e>=0?t.slice(0,e):t},t.c4=function(t){return t.indexOf(ns)>=0},t.c5=function(t){const e=t.indexOf(ns);return e>=0?t.slice(e+1):""},t.c6=function(t){const e=[],r=t.id;return void 0===r&&e.push({message:`layers.${r}: missing required property "id"`}),void 0===t.render&&e.push({message:`layers.${r}: missing required method "render"`}),t.renderingMode&&"2d"!==t.renderingMode&&"3d"!==t.renderingMode&&e.push({message:`layers.${r}: property "renderingMode" must be either "2d" or "3d"`}),e},t.c7=N,t.c8=Aa,t.c9=kt,t.cA=Gd,t.cB=(t,e,r,n,i,a)=>{const s=t.transform;return {u_matrix:$d(t,e,r,n),u_texsize:e.imageAtlasTexture?e.imageAtlasTexture.size:[0,0],u_pixels_to_tile_units:s.calculatePixelsToTileUnitsMatrix(e),u_device_pixel_ratio:i,u_image:0,u_tile_units_to_pixels:qd(e,s),u_units_to_pixels:[1/s.pixelsToGLUnits[0],1/s.pixelsToGLUnits[1]],u_alpha_discard_threshold:0,u_trim_offset:a}},t.cC=(t,e,r,n,i,a,s)=>{const o=t.transform,l=o.calculatePixelsToTileUnitsMatrix(e);return {u_matrix:$d(t,e,r,n),u_pixels_to_tile_units:l,u_device_pixel_ratio:a,u_units_to_pixels:[1/o.pixelsToGLUnits[0],1/o.pixelsToGLUnits[1]],u_dash_image:0,u_gradient_image:1,u_image_height:i,u_texsize:Yd(r)&&e.lineAtlasTexture?e.lineAtlasTexture.size:[0,0],u_tile_units_to_pixels:qd(e,t.transform),u_alpha_discard_threshold:0,u_trim_offset:s,u_emissive_strength:r.paint.get("line-emissive-strength")}},t.cD=R,t.cE=Ap,t.cF=Md,t.cG=ll,t.cH=md,t.cI=id,t.cJ=450,t.cK=7,t.cL=Ng,t.cM=256,t.cN=Jh,t.cO=Cs,t.cP=Rs,t.cQ=function(t,e,r,n,i){return I((t-e)/(r-e)*(i-n)+n,n,i)},t.cR=bl,t.cS=nx,t.cT=[1,1,1],t.cU=Wf,t.cV=xx,t.cW=As,t.cX=class{constructor(){this._updateTime=0,this._sourceIds=[],this._activeRegions=[],this._prevRegions=[];}clear(){this._activeRegions.length>0&&++this._updateTime,this._activeRegions=[],this._prevRegions=[];}get updateTime(){return this._updateTime}getReplacementRegionsForTile(t){const e=Df(new g(0,0),new g(Tr,Tr),t),r=[];for(const n of this._activeRegions){if(n.hiddenByOverlap)continue;if(!Rf(e,n))continue;const i=Vf(n.min,n.max,t);r.push({min:i.min,max:i.max,sourceId:this._sourceIds[n.priority],footprint:n.footprint,footprintTileId:n.tileId});}return r}setSources(t){this._setSources(t.map((t=>({getSourceId:()=>t.cache.id,getFootprints:()=>{const e=[];for(const r of t.cache.getVisibleCoordinates()){const n=t.cache.getTile(r).buckets[t.layer];if(n)for(const t of n.getNodesInfo()){const n=t.node;n.footprint&&e.push({footprint:n.footprint,id:r.toUnwrapped()});}}return e}}))));}_addSource(t){const e=t.getFootprints();if(0!==e.length){for(const t of e){if(!t.footprint)continue;const e=Df(t.footprint.min,t.footprint.max,t.id);this._activeRegions.push({min:e.min,max:e.max,hiddenByOverlap:!1,priority:this._sourceIds.length,tileId:t.id,footprint:t.footprint});}this._sourceIds.push(t.getSourceId());}}_computeReplacement(){this._activeRegions.sort(((t,e)=>t.priority-e.priority||Bf(t.min,e.min)||Bf(t.max,e.max)));let t=this._activeRegions.length!==this._prevRegions.length;if(!t){let e=0,r=0;for(;!t&&e!==this._activeRegions.length;){const n=this._activeRegions[e],i=this._prevRegions[r];t=n.priority!==i.priority||!Cf(n,i),++e,++r;}}if(t){++this._updateTime;const t=t=>{const e=this._activeRegions;if(t>=e.length)return t;const r=e[t].priority;for(;t<e.length&&e[t].priority===r;)++t;return t};if(this._sourceIds.length>1){let e=0,r=t(e);for(;e!==r;){let n=e;const i=e;for(;n!==r;){const t=this._activeRegions[n];t.hiddenByOverlap=!1;for(let e=0;e<i;e++){const r=this._activeRegions[e];if(!r.hiddenByOverlap&&Rf(t,r)&&(t.hiddenByOverlap=Ff(t.footprint,t.tileId,r.footprint,r.tileId),t.hiddenByOverlap))break}++n;}e=r,r=t(e);}}}}_setSources(t){[this._prevRegions,this._activeRegions]=[this._activeRegions,[]],this._sourceIds=[];for(let e=t.length-1;e>=0;e--)this._addSource(t[e]);this._computeReplacement();}},t.cY=class{constructor(t){this._createGrid(t),this._createPoles(t);}destroy(){this._poleIndexBuffer.destroy(),this._gridBuffer.destroy(),this._gridIndexBuffer.destroy(),this._poleNorthVertexBuffer.destroy(),this._poleSouthVertexBuffer.destroy();for(const t of this._poleSegments)t.destroy();for(const t of this._gridSegments)t.withSkirts.destroy(),t.withoutSkirts.destroy();}_fillGridMeshWithLods(t,e){const r=new ps,n=new Es,i=[],a=t+1+2,s=e[0]+1,o=e[0]+1+(1+e.length),l=(t,e,r)=>{let n=t===a-1?t-2:0===t?t:t-1;return n+=r?24575:0,[n,e]};for(let t=0;t<a;++t)r.emplaceBack(...l(t,0,!0));for(let t=0;t<s;++t)for(let e=0;e<a;++e)r.emplaceBack(...l(e,t,(0===e||e===a-1)&&!0));for(let t=0;t<e.length;++t){const n=e[t];for(let t=0;t<a;++t)r.emplaceBack(...l(t,n,!0));}for(let t=0;t<e.length;++t){const s=n.length,l=e[t]+1+2,u=new Es;for(let r=0;r<l-1;r++){const i=r===l-2,s=i?a*(o-e.length+t-r):a;for(let t=0;t<a-1;t++){const e=r*a+t;0===r||i||0===t||t===a-2?(u.emplaceBack(e+1,e,e+s),u.emplaceBack(e+s,e+s+1,e+1)):(n.emplaceBack(e+1,e,e+s),n.emplaceBack(e+s,e+s+1,e+1));}}const c=eo.simpleSegment(0,s,r.length,n.length-s);for(let t=0;t<u.uint16.length;t+=3)n.emplaceBack(u.uint16[t],u.uint16[t+1],u.uint16[t+2]);const h=eo.simpleSegment(0,s,r.length,n.length-s);i.push({withoutSkirts:c,withSkirts:h});}return {vertices:r,indices:n,segments:i}}_createGrid(t){const e=this._fillGridMeshWithLods(Yo,Xo);this._gridSegments=e.segments,this._gridBuffer=t.createVertexBuffer(e.vertices,Vh.members),this._gridIndexBuffer=t.createIndexBuffer(e.indices,!0);}_createPoles(t){const e=new Es;for(let t=0;t<=Yo;t++)e.emplaceBack(0,t+1,t+2);this._poleIndexBuffer=t.createIndexBuffer(e,!0);const r=new Cs,n=new Cs,i=new Cs,a=new Cs;this._poleSegments=[];for(let t=0,e=0;t<qo;t++){const s=360/(1<<t);r.emplaceBack(0,-jo,0,.5,0),n.emplaceBack(0,-jo,0,.5,1),i.emplaceBack(0,-jo,0,.5,.5),a.emplaceBack(0,-jo,0,.5,.5);for(let t=0;t<=Yo;t++){let e=t/Yo,o=0;const l=ue(0,s,e),[u,c,h]=Ho(sp,op,l,jo);r.emplaceBack(u,c,h,e,o),n.emplaceBack(u,c,h,e,1-o);const p=b(l);e=.5+.5*Math.sin(p),o=.5+.5*Math.cos(p),i.emplaceBack(u,c,h,e,o),a.emplaceBack(u,c,h,e,1-o);}this._poleSegments.push(eo.simpleSegment(e,0,66,64)),e+=66;}this._poleNorthVertexBuffer=t.createVertexBuffer(r,Rh,!1),this._poleSouthVertexBuffer=t.createVertexBuffer(n,Rh,!1),this._texturedPoleNorthVertexBuffer=t.createVertexBuffer(i,Rh,!1),this._texturedPoleSouthVertexBuffer=t.createVertexBuffer(a,Rh,!1);}getGridBuffers(t,e){return [this._gridBuffer,this._gridIndexBuffer,e?this._gridSegments[t].withSkirts:this._gridSegments[t].withoutSkirts]}getPoleBuffers(t,e){return [e?this._texturedPoleNorthVertexBuffer:this._poleNorthVertexBuffer,e?this._texturedPoleSouthVertexBuffer:this._poleSouthVertexBuffer,this._poleIndexBuffer,this._poleSegments[t]]}},t.cZ=function(t){return Ht.has(t)},t.c_=A,t.ca=Mo,t.cb=class extends go{constructor(t){super(t),this.current=Io;}set(t,e,r){if(this.fetchUniformLocation(t,e))for(let t=0;t<9;t++)if(r[t]!==this.current[t]){this.current=r,this.gl.uniformMatrix3fv(this.location,!1,r);break}}},t.cc=M,t.cd=function(t,e,r){const n=rp(r.zoom),i=t.style.map._antialias,a=e.options.extStandardDerivativesForceOff||t.terrain&&t.terrain.exaggeration()>0;return 0===n&&!i&&!a},t.ce=function(e){const r=e.pixelsPerMeter,n=r/dl(1,e.center.lat),i=t.a6.identity(new Float64Array(16));return t.a6.translate(i,i,[e.point.x,e.point.y,0]),t.a6.scale(i,i,[n,n,r]),Float32Array.from(i)},t.cf=Yh,t.cg=function(t){const e=xl-5;t=I(t,-e,e)/e*90;const r=Math.pow(Math.abs(Math.sin(b(t))),3);return Math.round(r*(Xo.length-1))},t.ch=function(e,r,n,i){const a=r.getNorth(),s=r.getSouth(),o=r.getWest(),l=r.getEast(),u=1<<e.z,c=l-o,h=a-s,p=c/Yo,f=-h/Xo[n],d=[0,p,0,f,0,0,a,o,0];if(e.z>0){const e=180/i;t.co.multiply(d,d,[e/c+1,0,0,0,e/h+1,0,-.5*e/p,.5*e/f,1]);}return d[2]=u,d[5]=e.x,d[8]=e.y,d},t.ci=jh,t.cj=function(e,r,n){const i=t.a6.identity(new Float64Array(16)),a=(r/(1<<e)-.5)*Math.PI*2;return t.a6.rotateY(i,n.globeMatrix,a),Float32Array.from(i)},t.ck=class{isDataAvailableAtPoint(t){const e=this._source();if(this.isUsingMockSource()||!e||t.y<0||t.y>1)return !1;const r=e.getSource().maxzoom,n=1<<r,i=Math.floor(t.x),a=Math.floor((t.x-i)*n),s=Math.floor(t.y*n),o=this.findDEMTileFor(new sl(r,i,r,a,s));return !(!o||!o.dem)}getAtPointOrZero(t,e=0){return this.getAtPoint(t,e)||0}getAtPoint(t,e,r=!0){if(this.isUsingMockSource())return null;null==e&&(e=null);const n=this._source();if(!n)return e;if(t.y<0||t.y>1)return e;const i=n.getSource().maxzoom,a=1<<i,s=Math.floor(t.x),o=t.x-s,l=new sl(i,s,i,Math.floor(o*a),Math.floor(t.y*a)),u=this.findDEMTileFor(l);if(!u||!u.dem)return e;const c=u.dem,h=1<<u.tileID.canonical.z,p=(o*h-u.tileID.canonical.x)*c.dim,f=(t.y*h-u.tileID.canonical.y)*c.dim,d=Math.floor(p),m=Math.floor(f);return (r?this.exaggeration():1)*ue(ue(c.get(d,m),c.get(d,m+1),f-m),ue(c.get(d+1,m),c.get(d+1,m+1),f-m),p-d)}getAtTileOffset(t,e,r){const n=1<<t.canonical.z;return this.getAtPointOrZero(new Ml(t.wrap+(t.canonical.x+e/Tr)/n,(t.canonical.y+r/Tr)/n))}getAtTileOffsetFunc(e,r,n,i){return a=>{const s=this.getAtTileOffset(e,a.x,a.y),o=i.upVector(e.canonical,a.x,a.y),l=i.upVectorScale(e.canonical,r,n).metersToTile;return t.N.scale(o,o,s*l),o}}getForTilePoints(t,e,r,n){if(this.isUsingMockSource())return !1;const i=Wf.create(this,t,n);return !!i&&(e.forEach((t=>{t[2]=this.exaggeration()*i.getElevationAt(t[0],t[1],r);})),!0)}getMinMaxForTile(t){if(this.isUsingMockSource())return null;const e=this.findDEMTileFor(t);if(!e||!e.dem)return null;const r=e.dem.tree,n=e.tileID,i=1<<t.canonical.z-n.canonical.z;let a=t.canonical.x/i-n.canonical.x,s=t.canonical.y/i-n.canonical.y,o=0;for(let e=0;e<t.canonical.z-n.canonical.z&&!r.leaves[o];e++){a*=2,s*=2;const t=2*Math.floor(s)+Math.floor(a);o=r.childOffsets[o]+t,a%=1,s%=1;}return {min:this.exaggeration()*r.minimums[o],max:this.exaggeration()*r.maximums[o]}}getMinElevationBelowMSL(){throw new Error("Pure virtual method called.")}raycast(t,e,r){throw new Error("Pure virtual method called.")}pointCoordinate(t){throw new Error("Pure virtual method called.")}_source(){throw new Error("Pure virtual method called.")}isUsingMockSource(){throw new Error("Pure virtual method called.")}exaggeration(){throw new Error("Pure virtual method called.")}findDEMTileFor(t){throw new Error("Pure virtual method called.")}get visibleDemTiles(){throw new Error("Getter must be implemented in subclass.")}getMinMaxForVisibleTiles(){const t=this.visibleDemTiles;if(0===t.length)return null;let e=!1,r=Number.MAX_VALUE,n=Number.MIN_VALUE;for(const i of t){const t=this.getMinMaxForTile(i.tileID);t&&(r=Math.min(r,t.min),n=Math.max(n,t.max),e=!0);}return e?{min:r,max:n}:null}},t.cl=Lh,t.cm=_p,t.cn=function(t,e){return [Math.pow(t[0],2.2)*e,Math.pow(t[1],2.2)*e,Math.pow(t[2],2.2)*e]},t.cp=tp,t.cq=256,t.cr=function(e,r){const n=[0,0,0],i=Wh(jh(r.canonical));return t.N.transformMat4(n,n,i),t.N.transformMat4(n,n,e),n},t.cs=t=>({u_camera_to_center_distance:new vo(t),u_extrude_scale:new Po(t),u_device_pixel_ratio:new vo(t),u_matrix:new So(t),u_inv_rot_matrix:new So(t),u_merc_center:new bo(t),u_tile_id:new _o(t),u_zoom_transition:new vo(t),u_up_dir:new _o(t),u_emissive_strength:new vo(t)}),t.ct=t=>({u_matrix:new So(t),u_pixels_to_tile_units:new Po(t),u_device_pixel_ratio:new vo(t),u_units_to_pixels:new bo(t),u_dash_image:new xo(t),u_gradient_image:new xo(t),u_image_height:new vo(t),u_texsize:new bo(t),u_tile_units_to_pixels:new vo(t),u_alpha_discard_threshold:new vo(t),u_trim_offset:new bo(t),u_emissive_strength:new vo(t)}),t.cu=t=>({u_matrix:new So(t),u_texsize:new bo(t),u_pixels_to_tile_units:new Po(t),u_device_pixel_ratio:new vo(t),u_image:new xo(t),u_units_to_pixels:new bo(t),u_tile_units_to_pixels:new vo(t),u_alpha_discard_threshold:new vo(t),u_trim_offset:new bo(t)}),t.cv=ks,t.cw=nm,t.cx=um,t.cy=up,t.cz=(t,e,r,n,i,a)=>{const s=t.transform,o="globe"===s.projection.name;let l;if("map"===a.paint.get("circle-pitch-alignment"))if(o){const t=tp(s.zoom,e.canonical)*s._pixelsPerMercatorPixel;l=Float32Array.from([t,0,0,t]);}else l=s.calculatePixelsToTileUnitsMatrix(r);else l=new Float32Array([s.pixelsToGLUnits[0],0,0,s.pixelsToGLUnits[1]]);const u={u_camera_to_center_distance:t.transform.getCameraToCenterDistance(s.projection),u_matrix:t.translatePosMatrix(e.projMatrix,r,a.paint.get("circle-translate"),a.paint.get("circle-translate-anchor")),u_device_pixel_ratio:st.devicePixelRatio,u_extrude_scale:l,u_inv_rot_matrix:lp,u_merc_center:[0,0],u_tile_id:[0,0,0],u_zoom_transition:0,u_up_dir:[0,0,0],u_emissive_strength:a.paint.get("circle-emissive-strength")};if(o){u.u_inv_rot_matrix=n,u.u_merc_center=i,u.u_tile_id=[e.canonical.x,e.canonical.y,1<<e.canonical.z],u.u_zoom_transition=rp(s.zoom);const t=i[0]*Tr,r=i[1]*Tr;u.u_up_dir=s.projection.upVector(new il(0,0,0),t,r);}return u},t.d=Ct,t.d0=S,t.d1=_l,t.d2=Wo,t.d3=function([t,e,r]){const n=Math.hypot(t,e,r),i=Math.atan2(t,r),a=.5*Math.PI-Math.acos(-e/n);return new tl(_(i),_(a))},t.d4=Jo,t.d5=n,t.d6=ip,t.d7=np,t.d8=function(e){const r=[0,0,0],n=t.a6.identity(new Float64Array(16));return t.a6.multiply(n,e.pixelMatrix,e.globeMatrix),t.N.transformMat4(r,r,n),new g(r[0],r[1])},t.d9=function(t){const e=t.navigator?t.navigator.userAgent:null;return !!function(t){if(null==tt){const e=t.navigator?t.navigator.userAgent:null;tt=!!t.safari||!(!e||!(/\b(iPad|iPhone|iPod)\b/.test(e)||e.match("Safari")&&!e.match("Chrome")));}return tt}(t)&&e&&(e.match("Version/15.4")||e.match("Version/15.5")||e.match(/CPU (OS|iPhone OS) (15_4|15_5) like Mac OS X/))},t.dA=vy,t.dB=yv,t.dC=vv,t.dD=Vd,t.dE=F,t.dF=my,t.dG=function(t,e,r,n,i,a,s,o,l,u,c){t.createArrays(),t.tilePixelRatio=Tr/(512*t.overscaling),t.compareText={},t.iconsNeedLinear=!1;const h=t.layers[0].layout,p=t.layers[0]._unevaluatedLayout._values,f={};if("composite"===t.textSizeData.kind){const{minZoom:e,maxZoom:r}=t.textSizeData;f.compositeTextSizes=[p["text-size"].possiblyEvaluate(new Pa(e),o),p["text-size"].possiblyEvaluate(new Pa(r),o)];}if("composite"===t.iconSizeData.kind){const{minZoom:e,maxZoom:r}=t.iconSizeData;f.compositeIconSizes=[p["icon-size"].possiblyEvaluate(new Pa(e),o),p["icon-size"].possiblyEvaluate(new Pa(r),o)];}f.layoutTextSize=p["text-size"].possiblyEvaluate(new Pa(l+1),o),f.layoutIconSize=p["icon-size"].possiblyEvaluate(new Pa(l+1),o),f.textMaxSize=p["text-size"].possiblyEvaluate(new Pa(18),o);const d="map"===h.get("text-rotation-alignment")&&"point"!==h.get("symbol-placement"),m=h.get("text-size");let y=!1;for(const e of t.features)if(e.icon&&e.icon.nameSecondary){y=!0;break}for(const a of t.features){const l=h.get("text-font").evaluate(a,{},o).join(","),p=m.evaluate(a,{},o),g=f.layoutTextSize.evaluate(a,{},o),x=(f.layoutIconSize.evaluate(a,{},o),{horizontal:{},vertical:void 0}),v=a.text;let b,_=[0,0];if(v){const n=v.toString(),s=h.get("text-letter-spacing").evaluate(a,{},o)*im,u=h.get("text-line-height").evaluate(a,{},o)*im,c=ua(n)?s:0,f=h.get("text-anchor").evaluate(a,{},o),m=h.get("text-variable-anchor");if(!m){const t=h.get("text-radial-offset").evaluate(a,{},o);_=t?Ry(f,[t*im,By]):h.get("text-offset").evaluate(a,{},o).map((t=>t*im));}let y=d?"center":h.get("text-justify").evaluate(a,{},o);const b="point"===h.get("symbol-placement"),w=b?h.get("text-max-width").evaluate(a,{},o)*im:1/0,M=a=>{t.allowVerticalPlacement&&la(n)&&(x.vertical=Gm(v,e,r,i,l,w,u,f,a,c,_,jm.vertical,!0,g,p));};if(!d&&m){const t="auto"===y?m.map((t=>Dy(t))):[y];let n=!1;for(let a=0;a<t.length;a++){const s=t[a];if(!x.horizontal[s])if(n)x.horizontal[s]=x.horizontal[0];else {const t=Gm(v,e,r,i,l,w,u,"center",s,c,_,jm.horizontal,!1,g,p);t&&(x.horizontal[s]=t,n=1===t.positionedLines.length);}}M("left");}else {if("auto"===y&&(y=Dy(f)),b||h.get("text-writing-mode").indexOf("horizontal")>=0||!la(n)){const t=Gm(v,e,r,i,l,w,u,f,y,c,_,jm.horizontal,!1,g,p);t&&(x.horizontal[y]=t);}M(b?"left":y);}}let w=!1;if(a.icon&&a.icon.namePrimary){const e=n[a.icon.namePrimary];e&&(b=ey(i[a.icon.namePrimary],a.icon.nameSecondary?i[a.icon.nameSecondary]:void 0,h.get("icon-offset").evaluate(a,{},o),h.get("icon-anchor").evaluate(a,{},o)),w=e.sdf,void 0===t.sdfIcons?t.sdfIcons=e.sdf:t.sdfIcons!==e.sdf&&j("Style sheet warning: Cannot mix SDF and non-SDF icons in one buffer"),(e.pixelRatio!==t.pixelRatio||0!==h.get("icon-rotate").constantOr(1))&&(t.iconsNeedLinear=!0));}const M=Oy(x.horizontal)||x.vertical;t.iconsInText||(t.iconsInText=!!M&&M.iconsInText),(M||b)&&Vy(t,a,x,b,n,f,g,0,_,w,s,o,u,c,y);}a&&t.generateCollisionDebugBuffers(l,t.collisionBoxArray);},t.dH=Ef,t.dI=Vm,t.dJ=Hf,t.dK=h,t.dL=zf,t.dM=gf,t.dN=m,t.dO=mm,t.dP=function(t){let e=0;if(new Uint32Array(t,0,1)[0]!==Wx){const r=new Uint32Array(t,0,7),[,,n,i,a,s]=r;e=r.byteLength+i+a+s+a,(n!==t.byteLength||e>=t.byteLength)&&j("Invalid b3dm header information.");}return nv(t,e)},t.dQ=function(t,e){const r=fv(t);for(const t of r){for(const e of t.meshes)dv(e);t.lights&&(t.lightMeshIndex=t.meshes.length,t.meshes.push(mv(t.lights,e)));}return r},t.dR=Pv,t.dS=kx,t.dT=ka,t.dU=function(t){ft(),ct&&ct.then((e=>{e.keys().then((r=>{for(let n=0;n<r.length-t;n++)e.delete(r[n]);}));}));},t.da=class{constructor(t,e,r){this._transformRequestFn=t,this._customAccessToken=e,this._silenceAuthErrors=!!r,this._createSkuToken();}_createSkuToken(){const t=function(){let t="";for(let e=0;e<10;e++)t+="0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ"[Math.floor(62*Math.random())];return {token:["1",Rt,t].join(""),tokenExpiresAt:Date.now()+432e5}}();this._skuToken=t.token,this._skuTokenExpiresAt=t.tokenExpiresAt;}_isSkuTokenExpired(){return Date.now()>this._skuTokenExpiresAt}transformRequest(t,e){return this._transformRequestFn&&this._transformRequestFn(t,e)||{url:t}}normalizeStyleURL(t,r){if(!a(t))return t;const n=Lt(t);return n.params.push(`sdk=js-${e}`),n.path=`/styles/v1${n.path}`,this._makeAPIURL(n,this._customAccessToken||r)}normalizeGlyphsURL(t,e){if(!a(t))return t;const r=Lt(t);return r.path=`/fonts/v1${r.path}`,this._makeAPIURL(r,this._customAccessToken||e)}normalizeModelURL(t,e){if(!a(t))return t;const r=Lt(t);return r.path=`/models/v1${r.path}`,this._makeAPIURL(r,this._customAccessToken||e)}normalizeSourceURL(t,e,r,n){if(!a(t))return t;const i=Lt(t);return i.path=`/v4/${i.authority}.json`,i.params.push("secure"),r&&i.params.push(`language=${r}`),n&&i.params.push(`worldview=${n}`),this._makeAPIURL(i,this._customAccessToken||e)}normalizeSpriteURL(t,e,r,n){const i=Lt(t);return a(t)?(i.path=`/styles/v1${i.path}/sprite${e}${r}`,this._makeAPIURL(i,this._customAccessToken||n)):(i.path+=`${e}${r}`,Ft(i))}normalizeTileURL(t,e,r){if(this._isSkuTokenExpired()&&this._createSkuToken(),t&&!a(t))return t;const i=Lt(t);i.path=i.path.replace(/(\.(png|jpg)\d*)(?=$)/,`${e||r&&"raster"!==i.authority&&512===r?"@2x":""}${gt.supported?".webp":"$1"}`),"raster"===i.authority?i.path=`/${n.RASTER_URL_PREFIX}${i.path}`:"rasterarrays"===i.authority?i.path=`/${n.RASTERARRAYS_URL_PREFIX}${i.path}`:(i.path=i.path.replace(/^.+\/v4\//,"/"),i.path=`/${n.TILE_URL_VERSION}${i.path}`);const s=this._customAccessToken||function(t){for(const e of t){const t=e.match(/^access_token=(.*)$/);if(t)return t[1]}return null}(i.params)||n.ACCESS_TOKEN;return n.REQUIRE_ACCESS_TOKEN&&s&&this._skuToken&&i.params.push(`sku=${this._skuToken}`),this._makeAPIURL(i,s)}canonicalizeTileURL(t,e){const r=Lt(t);if(!r.path.match(/^(\/v4\/|\/(raster|rasterarrays)\/v1\/)/)||!r.path.match(/\.[\w]+$/))return t;let i="mapbox://";r.path.match(/^\/raster\/v1\//)?i+=`raster/${r.path.replace(`/${n.RASTER_URL_PREFIX}/`,"")}`:r.path.match(/^\/rasterarrays\/v1\//)?i+=`rasterarrays/${r.path.replace(`/${n.RASTERARRAYS_URL_PREFIX}/`,"")}`:i+=`tiles/${r.path.replace(`/${n.TILE_URL_VERSION}/`,"")}`;let a=r.params;return e&&(a=a.filter((t=>!t.match(/^access_token=/)))),a.length&&(i+=`?${a.join("&")}`),i}canonicalizeTileset(t,e){const r=!!e&&a(e),n=[];for(const e of t.tiles||[])i(e)?n.push(this.canonicalizeTileURL(e,r)):n.push(e);return n}_makeAPIURL(t,e){const r="See https://docs.mapbox.com/api/overview/#access-tokens-and-token-scopes",i=Lt(n.API_URL);if(t.protocol=i.protocol,t.authority=i.authority,"http"===t.protocol){const e=t.params.indexOf("secure");e>=0&&t.params.splice(e,1);}if("/"!==i.path&&(t.path=`${i.path}${t.path}`),!n.REQUIRE_ACCESS_TOKEN)return Ft(t);if(e=e||n.ACCESS_TOKEN,!this._silenceAuthErrors){if(!e)throw new Error(`An API access token is required to use Mapbox GL. ${r}`);if("s"===e[0])throw new Error(`Use a public access token (pk.*) with Mapbox GL, not a secret access token (sk.*). ${r}`)}return t.params=t.params.filter((t=>-1===t.indexOf("access_token"))),t.params.push(`access_token=${e||""}`),Ft(t)}},t.db=function(t,e){e?Ht.add(t):Ht.delete(t);},t.dc=gt,t.dd=Xt,t.de=Kt,t.df=Dt,t.dg=Gt,t.dh=function(t){Ht.delete(t);},t.di=Zt,t.dj=$t,t.dk=e,t.dl=function(t,e){lt=t,ut=e;},t.dm=function(t,e,r=!1){if(ba===ya||ba===ga||ba===xa)throw new Error("setRTLTextPlugin cannot be called multiple times.");_a=st.resolveURL(t),ba=ya,va=e,Ma(),r||Ia();},t.dn=Sa,t.dp=function(){Rx().acquire(Tx);},t.dq=function(){const t=Cx;t&&(t.isPreloaded()&&1===t.numActive()?(t.release(Tx),Cx=null):console.warn("Could not clear WebWorkers since there are active Map instances that still reference it. The pre-warmed WebWorker pool can only be cleared when all map instances have been removed with map.remove()"));},t.dr=Bx,t.ds=function(t){const e=pt();if(!e)return;const r=e.delete(ot);t&&r.catch(t).then((()=>t()));},t.dt=Ex,t.du=Ux,t.dv=function(t){Vx=st.resolveURL(t),Ox||(Ox=new Px(Rx(),new ee)),Ox.broadcast("setDracoUrl",Vx);},t.dw=jx,t.dx=function(t){Fx=st.resolveURL(t),Ox||(Ox=new Px(Rx(),new ee)),Ox.broadcast("setMeshoptUrl",Fx);},t.dy=ra,t.dz=vp,t.e=z,t.f=st,t.g=function(t,e){return kt(z(t,{type:"json"}),e)},t.h=bp,t.i=Ke,t.j=pe,t.k=Ti,t.l=function(t){return fetch(t).then((t=>t.arrayBuffer())).then((e=>nv(e,0,t)))},t.m=Ci,t.n=$i,t.o=ja,t.p=py,t.q=Zi,t.r=Gi,t.s=Ri,t.t=mn,t.u=Ua,t.v=gn,t.w=j,t.x=dn,t.z=$a;}));

define(["./shared"],(function(e){"use strict";function t(e){const t=e?e.url.toString():void 0;return t?performance.getEntriesByName(t):[]}function s(e){if("number"==typeof e||"boolean"==typeof e||"string"==typeof e||null==e)return JSON.stringify(e);if(Array.isArray(e)){let t="[";for(const i of e)t+=`${s(i)},`;return `${t}]`}let t="{";for(const i of Object.keys(e).sort())t+=`${i}:${s(e[i])},`;return `${t}}`}function i(t){let i="";for(const o of e.b2)i+=`/${s(t[o])}`;return i}class o{constructor(e){this.keyCache={},this._layers={},this._layerConfigs={},e&&this.replace(e);}replace(e,t){this._layerConfigs={},this._layers={},this.update(e,[],t);}update(t,s,o){this._options=o;for(const s of t)this._layerConfigs[s.id]=s,(this._layers[s.id]=e.c2(s,this.scope,this._options)).compileFilter(),this.keyCache[s.id]&&delete this.keyCache[s.id];for(const e of s)delete this.keyCache[e],delete this._layerConfigs[e],delete this._layers[e];this.familiesBySource={};const r=function(e,t){const s={};for(let o=0;o<e.length;o++){const r=t&&t[e[o].id]||i(e[o]);t&&(t[e[o].id]=r);let n=s[r];n||(n=s[r]=[]),n.push(e[o]);}const o=[];for(const e in s)o.push(s[e]);return o}(e.a$(this._layerConfigs),this.keyCache);for(const e of r){const t=e.map((e=>this._layers[e.id])),s=t[0];if("none"===s.visibility)continue;const i=s.source||"";let o=this.familiesBySource[i];o||(o=this.familiesBySource[i]={});const r=s.sourceLayer||"_geojsonTileLayer";let n=o[r];n||(n=o[r]=[]),n.push(t);}}}const r=1*e.dA;class n{constructor(t){const s={},i=[];for(const e in t){const o=t[e],n=s[e]={};for(const e in o.glyphs){const t=o.glyphs[+e];if(!t||0===t.bitmap.width||0===t.bitmap.height)continue;const s=t.metrics.localGlyph?r:1,a={x:0,y:0,w:t.bitmap.width+2*s,h:t.bitmap.height+2*s};i.push(a),n[e]=a;}}const{w:o,h:n}=e.p(i),a=new e.dz({width:o||1,height:n||1});for(const i in t){const o=t[i];for(const t in o.glyphs){const n=o.glyphs[+t];if(!n||0===n.bitmap.width||0===n.bitmap.height)continue;const l=s[i][t],h=n.metrics.localGlyph?r:1;e.dz.copy(n.bitmap,a,{x:0,y:0},{x:l.x+h,y:l.y+h},n.bitmap);}}this.image=a,this.positions=s;}}e.dy(n,"GlyphAtlas");class a{constructor(t){this.tileID=new e.am(t.tileID.overscaledZ,t.tileID.wrap,t.tileID.canonical.z,t.tileID.canonical.x,t.tileID.canonical.y),this.tileZoom=t.tileZoom,this.uid=t.uid,this.zoom=t.zoom,this.canonical=t.tileID.canonical,this.pixelRatio=t.pixelRatio,this.tileSize=t.tileSize,this.source=t.source,this.scope=t.scope,this.overscaling=this.tileID.overscaleFactor(),this.showCollisionBoxes=t.showCollisionBoxes,this.collectResourceTiming=!!t.collectResourceTiming,this.promoteId=t.promoteId,this.isSymbolTile=t.isSymbolTile,this.tileTransform=e.as(t.tileID.canonical,t.projection),this.projection=t.projection,this.brightness=t.brightness,this.extraShadowCaster=!!t.extraShadowCaster;}parse(t,s,i,o,r){this.status="parsing",this.data=t,this.collisionBoxArray=new e.aD;const a=new e.dB(Object.keys(t.layers).sort()),h=new e.dC(this.tileID,this.promoteId);h.bucketLayerIDs=[];const c={},u=new e.dD(256,256),d={featureIndex:h,iconDependencies:{},patternDependencies:{},glyphDependencies:{},lineAtlas:u,availableImages:i,brightness:this.brightness},p=s.familiesBySource[this.source];for(const s in p){const o=t.layers[s];if(!o)continue;let r=!1,n=!1,u=!1;for(const e of p[s])"symbol"===e[0].type?r=!0:n=!0,e[0].is3D()&&"model"!==e[0].type&&(u=!0);if(this.extraShadowCaster&&!u)continue;if(!0===this.isSymbolTile&&!r)continue;if(!1===this.isSymbolTile&&!n)continue;1===o.version&&e.w(`Vector tile source "${this.source}" layer "${s}" does not use vector tile spec v2 and therefore may have some rendering errors.`);const f=a.encode(s),g=[];for(let e=0;e<o.length;e++){const t=o.feature(e),i=h.getId(t,s);g.push({feature:t,id:i,index:e,sourceLayerIndex:f});}for(const e of p[s]){const t=e[0];(!this.extraShadowCaster||t.is3D()&&"model"!==t.type)&&(void 0!==this.isSymbolTile&&"symbol"===t.type!==this.isSymbolTile||t.minzoom&&this.zoom<Math.floor(t.minzoom)||t.maxzoom&&this.zoom>=t.maxzoom||"none"!==t.visibility&&(l(e,this.zoom,d.brightness,i),(c[t.id]=t.createBucket({index:h.bucketLayerIDs.length,layers:e,zoom:this.zoom,canonical:this.canonical,pixelRatio:this.pixelRatio,overscaling:this.overscaling,collisionBoxArray:this.collisionBoxArray,sourceLayerIndex:f,sourceID:this.source,projection:this.projection.spec})).populate(g,d,this.tileID.canonical,this.tileTransform),h.bucketLayerIDs.push(e.map((e=>e.id)))));}}let f,g,m,y;u.trim();const v={type:"maybePrepare",isSymbolTile:this.isSymbolTile,zoom:this.zoom},x=()=>{if(f)return this.status="done",r(f);if(this.extraShadowCaster)this.status="done",r(null,{buckets:e.a$(c).filter((e=>!e.isEmpty())),featureIndex:h,collisionBoxArray:null,glyphAtlasImage:null,lineAtlas:null,imageAtlas:null,brightness:d.brightness,glyphMap:null,iconMap:null,glyphPositions:null});else if(g&&m&&y){const t=new n(g),s=new e.dF(m,y);for(const o in c){const r=c[o];r instanceof e.aE?(l(r.layers,this.zoom,d.brightness,i),e.dG(r,g,t.positions,m,s.iconPositions,this.showCollisionBoxes,i,this.tileID.canonical,this.tileZoom,this.projection,this.brightness)):r.hasPattern&&(r instanceof e.aK||r instanceof e.aL||r instanceof e.cH)&&(l(r.layers,this.zoom,d.brightness,i),r.addFeatures(d,this.tileID.canonical,s.patternPositions,i,this.tileTransform,this.brightness));}this.status="done",r(null,{buckets:e.a$(c).filter((e=>!e.isEmpty())),featureIndex:h,collisionBoxArray:this.collisionBoxArray,glyphAtlasImage:t.image,lineAtlas:u,imageAtlas:s,brightness:d.brightness});}};if(!this.extraShadowCaster){const t=e.dE(d.glyphDependencies,(e=>Object.keys(e).map(Number)));Object.keys(t).length?o.send("getGlyphs",{uid:this.uid,stacks:t,scope:this.scope},((e,t)=>{f||(f=e,g=t,x());}),void 0,!1,v):g={};const s=Object.keys(d.iconDependencies);s.length?o.send("getImages",{icons:s,source:this.source,scope:this.scope,tileID:this.tileID,type:"icons"},((e,t)=>{f||(f=e,m=t,x());}),void 0,!1,v):m={};const i=Object.keys(d.patternDependencies);i.length?o.send("getImages",{icons:i,source:this.source,scope:this.scope,tileID:this.tileID,type:"patterns"},((e,t)=>{f||(f=e,y=t,x());}),void 0,!1,v):y={};}x();}}function l(t,s,i,o){const r=new e.K(s,{brightness:i});for(const e of t)e.recalculate(r,o);}class h extends e.E{constructor(t,s,i,o,r,n){super(),this.actor=t,this.layerIndex=s,this.availableImages=i,this.loadVectorData=r||e.ah,this.loading={},this.loaded={},this.deduped=new e.af(t.scheduler),this.isSpriteLoaded=o,this.scheduler=t.scheduler,this.brightness=n;}loadTile(s,i){const o=s.uid,r=s&&s.request,n=r&&r.collectResourceTiming,l=this.loading[o]=new a(s);l.abort=this.loadVectorData(s,((a,h)=>{const c=!this.loading[o];if(delete this.loading[o],c||a||!h)return l.status="done",c||(this.loaded[o]=l),i(a);const u=h.rawData,d={};h.expires&&(d.expires=h.expires),h.cacheControl&&(d.cacheControl=h.cacheControl),l.vectorTile=h.vectorTile||new e.dH(new e.dI(u));const p=()=>{l.parse(l.vectorTile,this.layerIndex,this.availableImages,this.actor,((s,o)=>{if(s||!o)return i(s);const a={};if(n){const e=t(r);e.length>0&&(a.resourceTiming=JSON.parse(JSON.stringify(e)));}i(null,e.e({rawTileData:u.slice(0)},o,d,a));}));};this.isSpriteLoaded?p():this.once("isSpriteLoaded",(()=>{this.scheduler?this.scheduler.add(p,{type:"parseTile",isSymbolTile:s.isSymbolTile,zoom:s.tileZoom}):p();})),this.loaded=this.loaded||{},this.loaded[o]=l;}));}reloadTile(t,s){const i=this.loaded,o=t.uid,r=this;if(i&&i[o]){const n=i[o];n.showCollisionBoxes=t.showCollisionBoxes,n.projection=t.projection,n.brightness=t.brightness,n.tileTransform=e.as(t.tileID.canonical,t.projection),n.extraShadowCaster=t.extraShadowCaster;const a=(e,t)=>{const i=n.reloadCallback;i&&(delete n.reloadCallback,n.parse(n.vectorTile,r.layerIndex,this.availableImages,r.actor,i)),s(e,t);};"parsing"===n.status?n.reloadCallback=a:"done"===n.status&&(n.vectorTile?n.parse(n.vectorTile,this.layerIndex,this.availableImages,this.actor,a):a());}else s(null,void 0);}abortTile(e,t){const s=e.uid,i=this.loading[s];i&&(i.abort&&i.abort(),delete this.loading[s]),t();}removeTile(e,t){const s=this.loaded,i=e.uid;s&&s[i]&&delete s[i],t();}}class c{loadTile(t,s){const{uid:i,encoding:o,rawImageData:r,padding:n}=t,a=ImageBitmap&&r instanceof ImageBitmap?this.getImageData(r,n):r;s(null,new e.dJ(i,a,o,n<1));}getImageData(e,t){this.offscreenCanvas&&this.offscreenCanvasContext||(this.offscreenCanvas=new OffscreenCanvas(e.width,e.height),this.offscreenCanvasContext=this.offscreenCanvas.getContext("2d",{willReadFrequently:!0})),this.offscreenCanvas.width=e.width,this.offscreenCanvas.height=e.height,this.offscreenCanvasContext.drawImage(e,0,0,e.width,e.height);const s=this.offscreenCanvasContext.getImageData(-t,-t,e.width+2*t,e.height+2*t);return this.offscreenCanvasContext.clearRect(0,0,this.offscreenCanvas.width,this.offscreenCanvas.height),s}}class u{decodeRasterArray({task:t,buffer:s},i){e.aZ.performDecoding(s,t).then((e=>{i(null,e);}),(e=>{i(e);}));}}function d(e,t){if(0!==e.length){p(e[0],t);for(var s=1;s<e.length;s++)p(e[s],!t);}}function p(e,t){for(var s=0,i=0,o=0,r=e.length,n=r-1;o<r;n=o++){var a=(e[o][0]-e[n][0])*(e[n][1]+e[o][1]),l=s+a;i+=Math.abs(s)>=Math.abs(a)?s-l+a:a-l+s,s=l;}s+i>=0!=!!t&&e.reverse();}var f=e.dK((function e(t,s){var i,o=t&&t.type;if("FeatureCollection"===o)for(i=0;i<t.features.length;i++)e(t.features[i],s);else if("GeometryCollection"===o)for(i=0;i<t.geometries.length;i++)e(t.geometries[i],s);else if("Feature"===o)e(t.geometry,s);else if("Polygon"===o)d(t.coordinates,s);else if("MultiPolygon"===o)for(i=0;i<t.coordinates.length;i++)d(t.coordinates[i],s);return t}));const g=e.dL.prototype.toGeoJSON;let m=class{constructor(t){this._feature=t,this.extent=e.V,this.type=t.type,this.properties=t.tags,"id"in t&&!isNaN(t.id)&&(this.id=parseInt(t.id,10));}loadGeometry(){if(1===this._feature.type){const t=[];for(const s of this._feature.geometry)t.push([new e.P(s[0],s[1])]);return t}{const t=[];for(const s of this._feature.geometry){const i=[];for(const t of s)i.push(new e.P(t[0],t[1]));t.push(i);}return t}}toGeoJSON(e,t,s){return g.call(this,e,t,s)}},y=class{constructor(t){this.layers={_geojsonTileLayer:this},this.name="_geojsonTileLayer",this.extent=e.V,this.length=t.length,this._features=t;}feature(e){return new m(this._features[e])}};var v={exports:{}},x=e.dN,w=e.dM.VectorTileFeature,S=b;function b(e,t){this.options=t||{},this.features=e,this.length=e.length;}function I(e,t){this.id="number"==typeof e.id?e.id:void 0,this.type=e.type,this.rawGeometry=1===e.type?[e.geometry]:e.geometry,this.properties=e.tags,this.extent=t||4096;}b.prototype.feature=function(e){return new I(this.features[e],this.options.extent)},I.prototype.loadGeometry=function(){var e=this.rawGeometry;this.geometry=[];for(var t=0;t<e.length;t++){for(var s=e[t],i=[],o=0;o<s.length;o++)i.push(new x(s[o][0],s[o][1]));this.geometry.push(i);}return this.geometry},I.prototype.bbox=function(){this.geometry||this.loadGeometry();for(var e=this.geometry,t=1/0,s=-1/0,i=1/0,o=-1/0,r=0;r<e.length;r++)for(var n=e[r],a=0;a<n.length;a++){var l=n[a];t=Math.min(t,l.x),s=Math.max(s,l.x),i=Math.min(i,l.y),o=Math.max(o,l.y);}return [t,i,s,o]},I.prototype.toGeoJSON=w.prototype.toGeoJSON;var M=e.dO,k=S;function T(e){var t=new M;return function(e,t){for(var s in e.layers)t.writeMessage(3,P,e.layers[s]);}(e,t),t.finish()}function P(e,t){var s;t.writeVarintField(15,e.version||1),t.writeStringField(1,e.name||""),t.writeVarintField(5,e.extent||4096);var i={keys:[],values:[],keycache:{},valuecache:{}};for(s=0;s<e.length;s++)i.feature=e.feature(s),t.writeMessage(2,C,i);var o=i.keys;for(s=0;s<o.length;s++)t.writeStringField(3,o[s]);var r=i.values;for(s=0;s<r.length;s++)t.writeMessage(4,O,r[s]);}function C(e,t){var s=e.feature;void 0!==s.id&&t.writeVarintField(1,s.id),t.writeMessage(2,_,e),t.writeVarintField(3,s.type),t.writeMessage(4,j,s);}function _(e,t){var s=e.feature,i=e.keys,o=e.values,r=e.keycache,n=e.valuecache;for(var a in s.properties){var l=s.properties[a],h=r[a];if(null!==l){void 0===h&&(i.push(a),r[a]=h=i.length-1),t.writeVarint(h);var c=typeof l;"string"!==c&&"boolean"!==c&&"number"!==c&&(l=JSON.stringify(l));var u=c+":"+l,d=n[u];void 0===d&&(o.push(l),n[u]=d=o.length-1),t.writeVarint(d);}}}function D(e,t){return (t<<3)+(7&e)}function L(e){return e<<1^e>>31}function j(e,t){for(var s=e.loadGeometry(),i=e.type,o=0,r=0,n=s.length,a=0;a<n;a++){var l=s[a],h=1;1===i&&(h=l.length),t.writeVarint(D(1,h));for(var c=3===i?l.length-1:l.length,u=0;u<c;u++){1===u&&1!==i&&t.writeVarint(D(2,c-1));var d=l[u].x-o,p=l[u].y-r;t.writeVarint(L(d)),t.writeVarint(L(p)),o+=d,r+=p;}3===i&&t.writeVarint(D(7,1));}}function O(e,t){var s=typeof e;"string"===s?t.writeStringField(1,e):"boolean"===s?t.writeBooleanField(7,e):"number"===s&&(e%1!=0?t.writeDoubleField(3,e):e<0?t.writeSVarintField(6,e):t.writeVarintField(5,e));}v.exports=T,v.exports.fromVectorTileJs=T,v.exports.fromGeojsonVt=function(e,t){t=t||{};var s={};for(var i in e)s[i]=new k(e[i].features,t),s[i].name=i,s[i].version=t.version,s[i].extent=t.extent;return T({layers:s})},v.exports.GeoJSONWrapper=k;var z=e.dK(v.exports);const Z={minZoom:0,maxZoom:16,minPoints:2,radius:40,extent:512,nodeSize:64,log:!1,generateId:!1,reduce:null,map:e=>e},A=Math.fround||(E=new Float32Array(1),e=>(E[0]=+e,E[0]));var E;const F=3,N=5,B=6;class W{constructor(e){this.options=Object.assign(Object.create(Z),e),this.trees=new Array(this.options.maxZoom+1),this.stride=this.options.reduce?7:6,this.clusterProps=[];}load(e){const{log:t,minZoom:s,maxZoom:i}=this.options;t&&console.time("total time");const o=`prepare ${e.length} points`;t&&console.time(o),this.points=e;const r=[];for(let t=0;t<e.length;t++){const s=e[t];if(!s.geometry)continue;const[i,o]=s.geometry.coordinates,n=A(R(i)),a=A(Y(o));r.push(n,a,1/0,t,-1,1),this.options.reduce&&r.push(0);}let n=this.trees[i+1]=this._createTree(r);t&&console.timeEnd(o);for(let e=i;e>=s;e--){const s=+Date.now();n=this.trees[e]=this._createTree(this._cluster(n,e)),t&&console.log("z%d: %d clusters in %dms",e,n.numItems,+Date.now()-s);}return t&&console.timeEnd("total time"),this}getClusters(e,t){let s=((e[0]+180)%360+360)%360-180;const i=Math.max(-90,Math.min(90,e[1]));let o=180===e[2]?180:((e[2]+180)%360+360)%360-180;const r=Math.max(-90,Math.min(90,e[3]));if(e[2]-e[0]>=360)s=-180,o=180;else if(s>o){const e=this.getClusters([s,i,180,r],t),n=this.getClusters([-180,i,o,r],t);return e.concat(n)}const n=this.trees[this._limitZoom(t)],a=n.range(R(s),Y(r),R(o),Y(i)),l=n.data,h=[];for(const e of a){const t=this.stride*e;h.push(l[t+N]>1?G(l,t,this.clusterProps):this.points[l[t+F]]);}return h}getChildren(e){const t=this._getOriginId(e),s=this._getOriginZoom(e),i="No cluster with the specified id.",o=this.trees[s];if(!o)throw new Error(i);const r=o.data;if(t*this.stride>=r.length)throw new Error(i);const n=this.options.radius/(this.options.extent*Math.pow(2,s-1)),a=o.within(r[t*this.stride],r[t*this.stride+1],n),l=[];for(const t of a){const s=t*this.stride;r[s+4]===e&&l.push(r[s+N]>1?G(r,s,this.clusterProps):this.points[r[s+F]]);}if(0===l.length)throw new Error(i);return l}getLeaves(e,t,s){const i=[];return this._appendLeaves(i,e,t=t||10,s=s||0,0),i}getTile(e,t,s){const i=this.trees[this._limitZoom(e)],o=Math.pow(2,e),{extent:r,radius:n}=this.options,a=n/r,l=(s-a)/o,h=(s+1+a)/o,c={features:[]};return this._addTileFeatures(i.range((t-a)/o,l,(t+1+a)/o,h),i.data,t,s,o,c),0===t&&this._addTileFeatures(i.range(1-a/o,l,1,h),i.data,o,s,o,c),t===o-1&&this._addTileFeatures(i.range(0,l,a/o,h),i.data,-1,s,o,c),c.features.length?c:null}getClusterExpansionZoom(e){let t=this._getOriginZoom(e)-1;for(;t<=this.options.maxZoom;){const s=this.getChildren(e);if(t++,1!==s.length)break;e=s[0].properties.cluster_id;}return t}_appendLeaves(e,t,s,i,o){const r=this.getChildren(t);for(const t of r){const r=t.properties;if(r&&r.cluster?o+r.point_count<=i?o+=r.point_count:o=this._appendLeaves(e,r.cluster_id,s,i,o):o<i?o++:e.push(t),e.length===s)break}return o}_createTree(t){const s=new e.bg(t.length/this.stride|0,this.options.nodeSize,Float32Array);for(let e=0;e<t.length;e+=this.stride)s.add(t[e],t[e+1]);return s.finish(),s.data=t,s}_addTileFeatures(e,t,s,i,o,r){for(const n of e){const e=n*this.stride,a=t[e+N]>1;let l,h,c;if(a)l=J(t,e,this.clusterProps),h=t[e],c=t[e+1];else {const s=this.points[t[e+F]];l=s.properties;const[i,o]=s.geometry.coordinates;h=R(i),c=Y(o);}const u={type:1,geometry:[[Math.round(this.options.extent*(h*o-s)),Math.round(this.options.extent*(c*o-i))]],tags:l};let d;d=a||this.options.generateId?t[e+F]:this.points[t[e+F]].id,void 0!==d&&(u.id=d),r.features.push(u);}}_limitZoom(e){return Math.max(this.options.minZoom,Math.min(Math.floor(+e),this.options.maxZoom+1))}_cluster(e,t){const{radius:s,extent:i,reduce:o,minPoints:r}=this.options,n=s/(i*Math.pow(2,t)),a=e.data,l=[],h=this.stride;for(let s=0;s<a.length;s+=h){if(a[s+2]<=t)continue;a[s+2]=t;const i=a[s],c=a[s+1],u=e.within(a[s],a[s+1],n),d=a[s+N];let p=d;for(const e of u){const s=e*h;a[s+2]>t&&(p+=a[s+N]);}if(p>d&&p>=r){let e,r=i*d,n=c*d,f=-1;const g=(s/h<<5)+(t+1)+this.points.length;for(const i of u){const l=i*h;if(a[l+2]<=t)continue;a[l+2]=t;const c=a[l+N];r+=a[l]*c,n+=a[l+1]*c,a[l+4]=g,o&&(e||(e=this._map(a,s,!0),f=this.clusterProps.length,this.clusterProps.push(e)),o(e,this._map(a,l)));}a[s+4]=g,l.push(r/p,n/p,1/0,g,-1,p),o&&l.push(f);}else {for(let e=0;e<h;e++)l.push(a[s+e]);if(p>1)for(const e of u){const s=e*h;if(!(a[s+2]<=t)){a[s+2]=t;for(let e=0;e<h;e++)l.push(a[s+e]);}}}}return l}_getOriginId(e){return e-this.points.length>>5}_getOriginZoom(e){return (e-this.points.length)%32}_map(e,t,s){if(e[t+N]>1){const i=this.clusterProps[e[t+B]];return s?Object.assign({},i):i}const i=this.points[e[t+F]].properties,o=this.options.map(i);return s&&o===i?Object.assign({},o):o}}function G(e,t,s){return {type:"Feature",id:e[t+F],properties:J(e,t,s),geometry:{type:"Point",coordinates:[(i=e[t],360*(i-.5)),X(e[t+1])]}};var i;}function J(e,t,s){const i=e[t+N],o=i>=1e4?`${Math.round(i/1e3)}k`:i>=1e3?Math.round(i/100)/10+"k":i,r=e[t+B],n=-1===r?{}:Object.assign({},s[r]);return Object.assign(n,{cluster:!0,cluster_id:e[t+F],point_count:i,point_count_abbreviated:o})}function R(e){return e/360+.5}function Y(e){const t=Math.sin(e*Math.PI/180),s=.5-.25*Math.log((1+t)/(1-t))/Math.PI;return s<0?0:s>1?1:s}function X(e){const t=(180-360*e)*Math.PI/180;return 360*Math.atan(Math.exp(t))/Math.PI-90}var V={exports:{}};V.exports=function(){function e(s,i,o,r){for(var n,a=r,l=o-i>>1,h=o-i,c=s[i],u=s[i+1],d=s[o],p=s[o+1],f=i+3;f<o;f+=3){var g=t(s[f],s[f+1],c,u,d,p);if(g>a)n=f,a=g;else if(g===a){var m=Math.abs(f-l);m<h&&(n=f,h=m);}}a>r&&(n-i>3&&e(s,i,n,r),s[n+2]=a,o-n>3&&e(s,n,o,r));}function t(e,t,s,i,o,r){var n=o-s,a=r-i;if(0!==n||0!==a){var l=((e-s)*n+(t-i)*a)/(n*n+a*a);l>1?(s=o,i=r):l>0&&(s+=n*l,i+=a*l);}return (n=e-s)*n+(a=t-i)*a}function s(e,t,s,o){var r={id:void 0===e?null:e,type:t,geometry:s,tags:o,minX:1/0,minY:1/0,maxX:-1/0,maxY:-1/0};return function(e){var t=e.geometry,s=e.type;if("Point"===s||"MultiPoint"===s||"LineString"===s)i(e,t);else if("Polygon"===s||"MultiLineString"===s)for(var o=0;o<t.length;o++)i(e,t[o]);else if("MultiPolygon"===s)for(o=0;o<t.length;o++)for(var r=0;r<t[o].length;r++)i(e,t[o][r]);}(r),r}function i(e,t){for(var s=0;s<t.length;s+=3)e.minX=Math.min(e.minX,t[s]),e.minY=Math.min(e.minY,t[s+1]),e.maxX=Math.max(e.maxX,t[s]),e.maxY=Math.max(e.maxY,t[s+1]);}function o(e,t,i,l){if(t.geometry){var h=t.geometry.coordinates,c=t.geometry.type,u=Math.pow(i.tolerance/((1<<i.maxZoom)*i.extent),2),d=[],p=t.id;if(i.promoteId?p=t.properties[i.promoteId]:i.generateId&&(p=l||0),"Point"===c)r(h,d);else if("MultiPoint"===c)for(var f=0;f<h.length;f++)r(h[f],d);else if("LineString"===c)n(h,d,u,!1);else if("MultiLineString"===c){if(i.lineMetrics){for(f=0;f<h.length;f++)n(h[f],d=[],u,!1),e.push(s(p,"LineString",d,t.properties));return}a(h,d,u,!1);}else if("Polygon"===c)a(h,d,u,!0);else {if("MultiPolygon"!==c){if("GeometryCollection"===c){for(f=0;f<t.geometry.geometries.length;f++)o(e,{id:p,geometry:t.geometry.geometries[f],properties:t.properties},i,l);return}throw new Error("Input data is not a valid GeoJSON object.")}for(f=0;f<h.length;f++){var g=[];a(h[f],g,u,!0),d.push(g);}}e.push(s(p,c,d,t.properties));}}function r(e,t){t.push(l(e[0])),t.push(h(e[1])),t.push(0);}function n(t,s,i,o){for(var r,n,a=0,c=0;c<t.length;c++){var u=l(t[c][0]),d=h(t[c][1]);s.push(u),s.push(d),s.push(0),c>0&&(a+=o?(r*d-u*n)/2:Math.sqrt(Math.pow(u-r,2)+Math.pow(d-n,2))),r=u,n=d;}var p=s.length-3;s[2]=1,e(s,0,p,i),s[p+2]=1,s.size=Math.abs(a),s.start=0,s.end=s.size;}function a(e,t,s,i){for(var o=0;o<e.length;o++){var r=[];n(e[o],r,s,i),t.push(r);}}function l(e){return e/360+.5}function h(e){var t=Math.sin(e*Math.PI/180),s=.5-.25*Math.log((1+t)/(1-t))/Math.PI;return s<0?0:s>1?1:s}function c(e,t,i,o,r,n,a,l){if(o/=t,n>=(i/=t)&&a<o)return e;if(a<i||n>=o)return null;for(var h=[],c=0;c<e.length;c++){var p=e[c],g=p.geometry,m=p.type,y=0===r?p.minX:p.minY,v=0===r?p.maxX:p.maxY;if(y>=i&&v<o)h.push(p);else if(!(v<i||y>=o)){var x=[];if("Point"===m||"MultiPoint"===m)u(g,x,i,o,r);else if("LineString"===m)d(g,x,i,o,r,!1,l.lineMetrics);else if("MultiLineString"===m)f(g,x,i,o,r,!1);else if("Polygon"===m)f(g,x,i,o,r,!0);else if("MultiPolygon"===m)for(var w=0;w<g.length;w++){var S=[];f(g[w],S,i,o,r,!0),S.length&&x.push(S);}if(x.length){if(l.lineMetrics&&"LineString"===m){for(w=0;w<x.length;w++)h.push(s(p.id,m,x[w],p.tags));continue}"LineString"!==m&&"MultiLineString"!==m||(1===x.length?(m="LineString",x=x[0]):m="MultiLineString"),"Point"!==m&&"MultiPoint"!==m||(m=3===x.length?"Point":"MultiPoint"),h.push(s(p.id,m,x,p.tags));}}}return h.length?h:null}function u(e,t,s,i,o){for(var r=0;r<e.length;r+=3){var n=e[r+o];n>=s&&n<=i&&(t.push(e[r]),t.push(e[r+1]),t.push(e[r+2]));}}function d(e,t,s,i,o,r,n){for(var a,l,h=p(e),c=0===o?m:y,u=e.start,d=0;d<e.length-3;d+=3){var f=e[d],v=e[d+1],x=e[d+2],w=e[d+3],S=e[d+4],b=0===o?f:v,I=0===o?w:S,M=!1;n&&(a=Math.sqrt(Math.pow(f-w,2)+Math.pow(v-S,2))),b<s?I>s&&(l=c(h,f,v,w,S,s),n&&(h.start=u+a*l)):b>i?I<i&&(l=c(h,f,v,w,S,i),n&&(h.start=u+a*l)):g(h,f,v,x),I<s&&b>=s&&(l=c(h,f,v,w,S,s),M=!0),I>i&&b<=i&&(l=c(h,f,v,w,S,i),M=!0),!r&&M&&(n&&(h.end=u+a*l),t.push(h),h=p(e)),n&&(u+=a);}var k=e.length-3;f=e[k],v=e[k+1],x=e[k+2],(b=0===o?f:v)>=s&&b<=i&&g(h,f,v,x),k=h.length-3,r&&k>=3&&(h[k]!==h[0]||h[k+1]!==h[1])&&g(h,h[0],h[1],h[2]),h.length&&t.push(h);}function p(e){var t=[];return t.size=e.size,t.start=e.start,t.end=e.end,t}function f(e,t,s,i,o,r){for(var n=0;n<e.length;n++)d(e[n],t,s,i,o,r,!1);}function g(e,t,s,i){e.push(t),e.push(s),e.push(i);}function m(e,t,s,i,o,r){var n=(r-t)/(i-t);return e.push(r),e.push(s+(o-s)*n),e.push(1),n}function y(e,t,s,i,o,r){var n=(r-s)/(o-s);return e.push(t+(i-t)*n),e.push(r),e.push(1),n}function v(e,t){for(var i=[],o=0;o<e.length;o++){var r,n=e[o],a=n.type;if("Point"===a||"MultiPoint"===a||"LineString"===a)r=x(n.geometry,t);else if("MultiLineString"===a||"Polygon"===a){r=[];for(var l=0;l<n.geometry.length;l++)r.push(x(n.geometry[l],t));}else if("MultiPolygon"===a)for(r=[],l=0;l<n.geometry.length;l++){for(var h=[],c=0;c<n.geometry[l].length;c++)h.push(x(n.geometry[l][c],t));r.push(h);}i.push(s(n.id,a,r,n.tags));}return i}function x(e,t){var s=[];s.size=e.size,void 0!==e.start&&(s.start=e.start,s.end=e.end);for(var i=0;i<e.length;i+=3)s.push(e[i]+t,e[i+1],e[i+2]);return s}function w(e,t){if(e.transformed)return e;var s,i,o,r=1<<e.z,n=e.x,a=e.y;for(s=0;s<e.features.length;s++){var l=e.features[s],h=l.geometry,c=l.type;if(l.geometry=[],1===c)for(i=0;i<h.length;i+=2)l.geometry.push(S(h[i],h[i+1],t,r,n,a));else for(i=0;i<h.length;i++){var u=[];for(o=0;o<h[i].length;o+=2)u.push(S(h[i][o],h[i][o+1],t,r,n,a));l.geometry.push(u);}}return e.transformed=!0,e}function S(e,t,s,i,o,r){return [Math.round(s*(e*i-o)),Math.round(s*(t*i-r))]}function b(e,t,s,i,o){for(var r=t===o.maxZoom?0:o.tolerance/((1<<t)*o.extent),n={features:[],numPoints:0,numSimplified:0,numFeatures:0,source:null,x:s,y:i,z:t,transformed:!1,minX:2,minY:1,maxX:-1,maxY:0},a=0;a<e.length;a++){n.numFeatures++,I(n,e[a],r,o);var l=e[a].minX,h=e[a].minY,c=e[a].maxX,u=e[a].maxY;l<n.minX&&(n.minX=l),h<n.minY&&(n.minY=h),c>n.maxX&&(n.maxX=c),u>n.maxY&&(n.maxY=u);}return n}function I(e,t,s,i){var o=t.geometry,r=t.type,n=[];if("Point"===r||"MultiPoint"===r)for(var a=0;a<o.length;a+=3)n.push(o[a]),n.push(o[a+1]),e.numPoints++,e.numSimplified++;else if("LineString"===r)M(n,o,e,s,!1,!1);else if("MultiLineString"===r||"Polygon"===r)for(a=0;a<o.length;a++)M(n,o[a],e,s,"Polygon"===r,0===a);else if("MultiPolygon"===r)for(var l=0;l<o.length;l++){var h=o[l];for(a=0;a<h.length;a++)M(n,h[a],e,s,!0,0===a);}if(n.length){var c=t.tags||null;if("LineString"===r&&i.lineMetrics){for(var u in c={},t.tags)c[u]=t.tags[u];c.mapbox_clip_start=o.start/o.size,c.mapbox_clip_end=o.end/o.size;}var d={geometry:n,type:"Polygon"===r||"MultiPolygon"===r?3:"LineString"===r||"MultiLineString"===r?2:1,tags:c};null!==t.id&&(d.id=t.id),e.features.push(d);}}function M(e,t,s,i,o,r){var n=i*i;if(i>0&&t.size<(o?n:i))s.numPoints+=t.length/3;else {for(var a=[],l=0;l<t.length;l+=3)(0===i||t[l+2]>n)&&(s.numSimplified++,a.push(t[l]),a.push(t[l+1])),s.numPoints++;o&&function(e,t){for(var s=0,i=0,o=e.length,r=o-2;i<o;r=i,i+=2)s+=(e[i]-e[r])*(e[i+1]+e[r+1]);if(s>0===t)for(i=0,o=e.length;i<o/2;i+=2){var n=e[i],a=e[i+1];e[i]=e[o-2-i],e[i+1]=e[o-1-i],e[o-2-i]=n,e[o-1-i]=a;}}(a,r),e.push(a);}}function k(e,t){var s=(t=this.options=function(e,t){for(var s in t)e[s]=t[s];return e}(Object.create(this.options),t)).debug;if(s&&console.time("preprocess data"),t.maxZoom<0||t.maxZoom>24)throw new Error("maxZoom should be in the 0-24 range");if(t.promoteId&&t.generateId)throw new Error("promoteId and generateId cannot be used together.");var i=function(e,t){var s=[];if("FeatureCollection"===e.type)for(var i=0;i<e.features.length;i++)o(s,e.features[i],t,i);else o(s,"Feature"===e.type?e:{geometry:e},t);return s}(e,t);this.tiles={},this.tileCoords=[],s&&(console.timeEnd("preprocess data"),console.log("index: maxZoom: %d, maxPoints: %d",t.indexMaxZoom,t.indexMaxPoints),console.time("generate tiles"),this.stats={},this.total=0),(i=function(e,t){var s=t.buffer/t.extent,i=e,o=c(e,1,-1-s,s,0,-1,2,t),r=c(e,1,1-s,2+s,0,-1,2,t);return (o||r)&&(i=c(e,1,-s,1+s,0,-1,2,t)||[],o&&(i=v(o,1).concat(i)),r&&(i=i.concat(v(r,-1)))),i}(i,t)).length&&this.splitTile(i,0,0,0),s&&(i.length&&console.log("features: %d, points: %d",this.tiles[0].numFeatures,this.tiles[0].numPoints),console.timeEnd("generate tiles"),console.log("tiles generated:",this.total,JSON.stringify(this.stats)));}function T(e,t,s){return 32*((1<<e)*s+t)+e}return k.prototype.options={maxZoom:14,indexMaxZoom:5,indexMaxPoints:1e5,tolerance:3,extent:4096,buffer:64,lineMetrics:!1,promoteId:null,generateId:!1,debug:0},k.prototype.splitTile=function(e,t,s,i,o,r,n){for(var a=[e,t,s,i],l=this.options,h=l.debug;a.length;){i=a.pop(),s=a.pop(),t=a.pop(),e=a.pop();var u=1<<t,d=T(t,s,i),p=this.tiles[d];if(!p&&(h>1&&console.time("creation"),p=this.tiles[d]=b(e,t,s,i,l),this.tileCoords.push({z:t,x:s,y:i}),h)){h>1&&(console.log("tile z%d-%d-%d (features: %d, points: %d, simplified: %d)",t,s,i,p.numFeatures,p.numPoints,p.numSimplified),console.timeEnd("creation"));var f="z"+t;this.stats[f]=(this.stats[f]||0)+1,this.total++;}if(p.source=e,o){if(t===l.maxZoom||t===o)continue;var g=1<<o-t;if(s!==Math.floor(r/g)||i!==Math.floor(n/g))continue}else if(t===l.indexMaxZoom||p.numPoints<=l.indexMaxPoints)continue;if(p.source=null,0!==e.length){h>1&&console.time("clipping");var m,y,v,x,w,S,I=.5*l.buffer/l.extent,M=.5-I,k=.5+I,P=1+I;m=y=v=x=null,w=c(e,u,s-I,s+k,0,p.minX,p.maxX,l),S=c(e,u,s+M,s+P,0,p.minX,p.maxX,l),e=null,w&&(m=c(w,u,i-I,i+k,1,p.minY,p.maxY,l),y=c(w,u,i+M,i+P,1,p.minY,p.maxY,l),w=null),S&&(v=c(S,u,i-I,i+k,1,p.minY,p.maxY,l),x=c(S,u,i+M,i+P,1,p.minY,p.maxY,l),S=null),h>1&&console.timeEnd("clipping"),a.push(m||[],t+1,2*s,2*i),a.push(y||[],t+1,2*s,2*i+1),a.push(v||[],t+1,2*s+1,2*i),a.push(x||[],t+1,2*s+1,2*i+1);}}},k.prototype.getTile=function(e,t,s){var i=this.options,o=i.extent,r=i.debug;if(e<0||e>24)return null;var n=1<<e,a=T(e,t=(t%n+n)%n,s);if(this.tiles[a])return w(this.tiles[a],o);r>1&&console.log("drilling down to z%d-%d-%d",e,t,s);for(var l,h=e,c=t,u=s;!l&&h>0;)h--,c=Math.floor(c/2),u=Math.floor(u/2),l=this.tiles[T(h,c,u)];return l&&l.source?(r>1&&console.log("found parent tile z%d-%d-%d",h,c,u),r>1&&console.time("drilling down"),this.splitTile(l.source,h,c,u,e,t,s),r>1&&console.timeEnd("drilling down"),this.tiles[a]?w(this.tiles[a],o):null):null},function(e,t){return new k(e,t)}}();var $=e.dK(V.exports);function U(e,t){const s=e.tileID.canonical;if(!this._geoJSONIndex)return t(null,null);const i=this._geoJSONIndex.getTile(s.z,s.x,s.y);if(!i)return t(null,null);const o=new y(i.features);let r=z(o);0===r.byteOffset&&r.byteLength===r.buffer.byteLength||(r=new Uint8Array(r)),t(null,{vectorTile:o,rawData:r.buffer});}class q extends h{constructor(e,t,s,i,o,r){super(e,t,s,i,U,r),o&&(this.loadGeoJSON=o);}loadData(s,i){const o=s&&s.request,r=o&&o.collectResourceTiming;this.loadGeoJSON(s,((n,a)=>{if(n||!a)return i(n);if("object"!=typeof a)return i(new Error(`Input data given to '${s.source}' is not a valid GeoJSON object.`));{f(a,!0);try{if(s.filter){const t=e.r(s.filter,{type:"boolean","property-type":"data-driven",overridable:!1,transition:!1});if("error"===t.result)throw new Error(t.value.map((e=>`${e.key}: ${e.message}`)).join(", "));const i=a.features.filter((e=>t.value.evaluate({zoom:0},e)));a={type:"FeatureCollection",features:i};}this._geoJSONIndex=s.cluster?new W(function({superclusterOptions:t,clusterProperties:s}){if(!s||!t)return t;const i={},o={},r={accumulated:null,zoom:0},n={properties:null},a=Object.keys(s);for(const t of a){const[r,n]=s[t],a=e.r(n),l=e.r("string"==typeof r?[r,["accumulated"],["get",t]]:r);i[t]=a.value,o[t]=l.value;}return t.map=e=>{n.properties=e;const t={};for(const e of a)t[e]=i[e].evaluate(r,n);return t},t.reduce=(e,t)=>{n.properties=t;for(const t of a)r.accumulated=e[t],e[t]=o[t].evaluate(r,n);},t}(s)).load(a.features):$(a,s.geojsonVtOptions);}catch(n){return i(n)}this.loaded={};const l={};if(r){const e=t(o);e&&(l.resourceTiming={},l.resourceTiming[s.source]=JSON.parse(JSON.stringify(e)));}i(null,l);}}));}reloadTile(e,t){const s=this.loaded;return s&&s[e.uid]?super.reloadTile(e,t):this.loadTile(e,t)}loadGeoJSON(t,s){if(t.request)e.g(t.request,s);else {if("string"!=typeof t.data)return s(new Error(`Input data given to '${t.source}' is not a valid GeoJSON object.`));try{return s(null,JSON.parse(t.data))}catch(e){return s(new Error(`Input data given to '${t.source}' is not a valid GeoJSON object.`))}}}getClusterExpansionZoom(e,t){try{t(null,this._geoJSONIndex.getClusterExpansionZoom(e.clusterId));}catch(e){t(e);}}getClusterChildren(e,t){try{t(null,this._geoJSONIndex.getChildren(e.clusterId));}catch(e){t(e);}}getClusterLeaves(e,t){try{t(null,this._geoJSONIndex.getLeaves(e.clusterId,e.limit,e.offset));}catch(e){t(e);}}}class K{constructor(t,s){this.tileID=new e.am(t.tileID.overscaledZ,t.tileID.wrap,t.tileID.canonical.z,t.tileID.canonical.x,t.tileID.canonical.y),this.tileZoom=t.tileZoom,this.uid=t.uid,this.zoom=t.zoom,this.canonical=t.tileID.canonical,this.pixelRatio=t.pixelRatio,this.tileSize=t.tileSize,this.source=t.source,this.overscaling=this.tileID.overscaleFactor(),this.projection=t.projection,this.brightness=s;}parse(t,s,i,o){this.status="parsing";const r=new e.am(i.tileID.overscaledZ,i.tileID.wrap,i.tileID.canonical.z,i.tileID.canonical.x,i.tileID.canonical.y),n={},a=s.familiesBySource[i.source],l=new e.dC(r,i.promoteId);return l.bucketLayerIDs=[],l.is3DTile=!0,e.dP(t).then((t=>{if(!t)return o(new Error("Could not parse tile"));const s=e.dQ(t,1/e.bR(i.tileID.canonical)),h=t.json.extensionsUsed&&t.json.extensionsUsed.includes("MAPBOX_mesh_features")||t.json.asset.extras&&t.json.asset.extras.MAPBOX_mesh_features,c=t.json.extensionsUsed&&t.json.extensionsUsed.includes("EXT_meshopt_compression"),u=new e.K(this.zoom,{brightness:this.brightness});for(const t in a)for(const i of a[t]){const t=i[0];l.bucketLayerIDs.push(i.map((e=>e.id))),t.recalculate(u,[]);const o=new e.dR(s,r,h,c,this.brightness,l);h||(o.needsUpload=!0),n[t.fqid]=o,o.evaluate(t);}this.status="done",o(null,{buckets:n,featureIndex:l});})).catch((e=>o(new Error(e.message))))}}class H{constructor(e,t,s,i,o,r){this.actor=e,this.layerIndex=t,this.brightness=r,this.loading={},this.loaded={};}loadTile(t,s){const i=t.uid,o=this.loading[i]=new K(t,this.brightness);e.a_(t.request,((e,r)=>{const n=!this.loading[i];return delete this.loading[i],n||e?(o.status="done",n||(this.loaded[i]=o),s(e)):r&&0!==r.byteLength?void o.parse(r,this.layerIndex,t,((e,t)=>{o.status="done",this.loaded=this.loaded||{},this.loaded[i]=o,e||!t?s(e):s(null,t);})):(o.status="done",this.loaded[i]=o,s())}));}reloadTile(e,t){const s=this.loaded,i=e.uid;if(s&&s[i]){const o=s[i];o.projection=e.projection,o.brightness=e.brightness;const r=(s,i)=>{o.reloadCallback&&(delete o.reloadCallback,this.loadTile(e,t)),t(s,i);};"parsing"===o.status?o.reloadCallback=r:"done"===o.status&&this.loadTile(e,t);}}abortTile(e,t){const s=e.uid;this.loading[s]&&delete this.loading[s],t();}removeTile(e,t){const s=this.loaded,i=e.uid;s&&s[i]&&delete s[i],t();}}class Q{constructor(t){this.self=t,this.actor=new e.dS(t,this),this.layerIndexes={},this.availableImages={},this.isSpriteLoaded={},this.projections={},this.defaultProjection=e.bo({name:"mercator"}),this.workerSourceTypes={vector:h,geojson:q,"batched-model":H},this.workerSources={},this.demWorkerSources={},this.self.registerWorkerSource=(e,t)=>{if(this.workerSourceTypes[e])throw new Error(`Worker source with name "${e}" already registered.`);this.workerSourceTypes[e]=t;},this.self.registerRTLTextPlugin=t=>{if(e.dT.isParsed())throw new Error("RTL text plugin already registered.");e.dT.applyArabicShaping=t.applyArabicShaping,e.dT.processBidirectionalText=t.processBidirectionalText,e.dT.processStyledBidirectionalText=t.processStyledBidirectionalText;};}clearCaches(e,t,s){delete this.layerIndexes[e],delete this.availableImages[e],delete this.workerSources[e],delete this.demWorkerSources[e],delete this.rasterArrayWorkerSource,s();}checkIfReady(e,t,s){s();}setReferrer(e,t){this.referrer=t;}spriteLoaded(t,{scope:s,isLoaded:i}){if(this.isSpriteLoaded[t]||(this.isSpriteLoaded[t]={}),this.isSpriteLoaded[t][s]=i,this.workerSources[t]&&this.workerSources[t][s])for(const o in this.workerSources[t][s]){const r=this.workerSources[t][s][o];for(const t in r)r[t]instanceof h&&(r[t].isSpriteLoaded=i,r[t].fire(new e.b("isSpriteLoaded")));}}setImages(e,{scope:t,images:s},i){if(this.availableImages[e]||(this.availableImages[e]={}),this.availableImages[e][t]=s,this.workerSources[e]&&this.workerSources[e][t]){for(const i in this.workerSources[e][t]){const o=this.workerSources[e][t][i];for(const e in o)o[e].availableImages=s;}i();}else i();}setProjection(t,s){this.projections[t]=e.bo(s);}setBrightness(e,t,s){this.brightness=t,s();}setLayers(e,t,s){this.getLayerIndex(e,t.scope).replace(t.layers,t.options),s();}updateLayers(e,t,s){this.getLayerIndex(e,t.scope).update(t.layers,t.removedIds,t.options),s();}loadTile(e,t,s){t.projection=this.projections[e]||this.defaultProjection,this.getWorkerSource(e,t.type,t.source,t.scope).loadTile(t,s);}loadDEMTile(e,t,s){this.getDEMWorkerSource(e,t.source,t.scope).loadTile(t,s);}decodeRasterArray(e,t,s){this.getRasterArrayWorkerSource().decodeRasterArray(t,s);}reloadTile(e,t,s){t.projection=this.projections[e]||this.defaultProjection,this.getWorkerSource(e,t.type,t.source,t.scope).reloadTile(t,s);}abortTile(e,t,s){this.getWorkerSource(e,t.type,t.source,t.scope).abortTile(t,s);}removeTile(e,t,s){this.getWorkerSource(e,t.type,t.source,t.scope).removeTile(t,s);}removeSource(e,t,s){if(!(this.workerSources[e]&&this.workerSources[e][t.scope]&&this.workerSources[e][t.scope][t.type]&&this.workerSources[e][t.scope][t.type][t.source]))return;const i=this.workerSources[e][t.scope][t.type][t.source];delete this.workerSources[e][t.scope][t.type][t.source],void 0!==i.removeSource?i.removeSource(t,s):s();}loadWorkerSource(e,t,s){try{this.self.importScripts(t.url),s();}catch(e){s(e.toString());}}syncRTLPluginState(t,s,i){try{e.dT.setState(s);const t=e.dT.getPluginURL();if(e.dT.isLoaded()&&!e.dT.isParsed()&&null!=t){this.self.importScripts(t);const s=e.dT.isParsed();i(s?void 0:new Error(`RTL Text Plugin failed to import scripts from ${t}`),s);}}catch(e){i(e.toString());}}setDracoUrl(e,t){this.dracoUrl=t;}getAvailableImages(e,t){this.availableImages[e]||(this.availableImages[e]={});let s=this.availableImages[e][t];return s||(s=[]),s}getLayerIndex(e,t){this.layerIndexes[e]||(this.layerIndexes[e]={});let s=this.layerIndexes[e][t];return s||(s=this.layerIndexes[e][t]=new o,s.scope=t),s}getWorkerSource(e,t,s,i){if(this.workerSources[e]||(this.workerSources[e]={}),this.workerSources[e][i]||(this.workerSources[e][i]={}),this.workerSources[e][i][t]||(this.workerSources[e][i][t]={}),this.isSpriteLoaded[e]||(this.isSpriteLoaded[e]={}),!this.workerSources[e][i][t][s]){const o={send:(t,s,i,o,r,n)=>{this.actor.send(t,s,i,e,r,n);},scheduler:this.actor.scheduler};this.workerSources[e][i][t][s]=new this.workerSourceTypes[t](o,this.getLayerIndex(e,i),this.getAvailableImages(e,i),this.isSpriteLoaded[e][i],void 0,this.brightness);}return this.workerSources[e][i][t][s]}getDEMWorkerSource(e,t,s){return this.demWorkerSources[e]||(this.demWorkerSources[e]={}),this.demWorkerSources[e][s]||(this.demWorkerSources[e][s]={}),this.demWorkerSources[e][s][t]||(this.demWorkerSources[e][s][t]=new c),this.demWorkerSources[e][s][t]}getRasterArrayWorkerSource(){return this.rasterArrayWorkerSource||(this.rasterArrayWorkerSource=new u),this.rasterArrayWorkerSource}enforceCacheSizeLimit(t,s){e.dU(s);}getWorkerPerformanceMetrics(e,t,s){s(void 0,void 0);}}return "undefined"!=typeof WorkerGlobalScope&&"undefined"!=typeof self&&self instanceof WorkerGlobalScope&&(self.worker=new Q(self)),Q}));

define(["./shared"],(function(e){"use strict";function t(e,i){if(Array.isArray(e)){if(!Array.isArray(i)||e.length!==i.length)return !1;for(let o=0;o<e.length;o++)if(!t(e[o],i[o]))return !1;return !0}if("object"==typeof e&&null!==e&&null!==i){if("object"!=typeof i)return !1;if(Object.keys(e).length!==Object.keys(i).length)return !1;for(const o in e)if(!t(e[o],i[o]))return !1;return !0}return e===i}var i=o;function o(e){return !function(e){return "undefined"==typeof window||"undefined"==typeof document?"not a browser":function(){if(!("Worker"in window&&"Blob"in window&&"URL"in window))return !1;var e,t,i=new Blob([""],{type:"text/javascript"}),o=URL.createObjectURL(i);try{t=new Worker(o),e=!0;}catch(t){e=!1;}return t&&t.terminate(),URL.revokeObjectURL(o),e}()?function(){var e=document.createElement("canvas");e.width=e.height=1;var t=e.getContext("2d");if(!t)return !1;var i=t.getImageData(0,0,1,1);return i&&i.width===e.width}()?(void 0===r[t=e&&e.failIfMajorPerformanceCaveat]&&(r[t]=function(e){var t,i=function(e){var t=document.createElement("canvas"),i=Object.create(o.webGLContextAttributes);return i.failIfMajorPerformanceCaveat=e,t.getContext("webgl2",i)}(e);if(!i)return !1;try{t=i.createShader(i.VERTEX_SHADER);}catch(e){return !1}return !(!t||i.isContextLost())&&(i.shaderSource(t,"void main() {}"),i.compileShader(t),!0===i.getShaderParameter(t,i.COMPILE_STATUS))}(t)),r[t]?document.documentMode?"insufficient ECMAScript 6 support":void 0:"insufficient WebGL2 support"):"insufficient Canvas/getImageData support":"insufficient worker support";var t;}(e)}var r={};function s(e,t,i){const o=document.createElement(e);return null!=t&&(o.className=t),i&&i.appendChild(o),o}function n(e,t,i){const o=document.createElementNS("http://www.w3.org/2000/svg",e);for(const e of Object.keys(t))o.setAttributeNS(null,e,String(t[e]));return i&&i.appendChild(o),o}o.webGLContextAttributes={antialias:!1,alpha:!0,stencil:!0,depth:!0};const a="undefined"!=typeof document?document.documentElement&&document.documentElement.style:null,l=a&&void 0!==a.userSelect?"userSelect":"WebkitUserSelect";let c;function h(){a&&l&&(c=a[l],a[l]="none");}function u(){a&&l&&(a[l]=c);}function d(e){e.preventDefault(),e.stopPropagation(),window.removeEventListener("click",d,!0);}function _(){window.addEventListener("click",d,!0),window.setTimeout((()=>{window.removeEventListener("click",d,!0);}),0);}function p(e,t){const i=e.getBoundingClientRect();return g(e,i,t)}function f(e,t){const i=e.getBoundingClientRect(),o=[];for(let r=0;r<t.length;r++)o.push(g(e,i,t[r]));return o}function m(e){return void 0!==window.InstallTrigger&&2===e.button&&e.ctrlKey&&window.navigator.platform.toUpperCase().indexOf("MAC")>=0?0:e.button}function g(t,i,o){const r=t.offsetWidth===i.width?1:t.offsetWidth/i.width;return new e.P((o.clientX-i.left)*r,(o.clientY-i.top)*r)}class v{constructor(){this._changed=!1,this._updatedLayers={},this._removedLayers={},this._updatedSourceCaches={},this._updatedPaintProps=new Set,this._updatedImages=new Set;}isDirty(){return this._changed}setDirty(){this._changed=!0;}getUpdatedSourceCaches(){return this._updatedSourceCaches}updateSourceCache(e,t){this._updatedSourceCaches[e]=t,this.setDirty();}discardSourceCacheUpdate(e){delete this._updatedSourceCaches[e];}updateLayer(e){const t=e.scope;this._updatedLayers[t]=this._updatedLayers[t]||new Set,this._updatedLayers[t].add(e.id),this.setDirty();}removeLayer(e){const t=e.scope;this._removedLayers[t]=this._removedLayers[t]||{},this._updatedLayers[t]=this._updatedLayers[t]||new Set,this._removedLayers[t][e.id]=e,this._updatedLayers[t].delete(e.id),this._updatedPaintProps.delete(e.fqid),this.setDirty();}getRemovedLayer(e){return this._removedLayers[e.scope]?this._removedLayers[e.scope][e.id]:null}discardLayerRemoval(e){this._removedLayers[e.scope]&&delete this._removedLayers[e.scope][e.id];}getLayerUpdatesByScope(){const e={};for(const t in this._updatedLayers)e[t]=e[t]||{},e[t].updatedIds=Array.from(this._updatedLayers[t].values());for(const t in this._removedLayers)e[t]=e[t]||{},e[t].removedIds=Object.keys(this._removedLayers[t]);return e}getUpdatedPaintProperties(){return this._updatedPaintProps}updatePaintProperties(e){this._updatedPaintProps.add(e.fqid),this.setDirty();}getUpdatedImages(){return Array.from(this._updatedImages.values())}updateImage(e){this._updatedImages.add(e),this.setDirty();}resetUpdatedImages(){this._updatedImages.clear();}reset(){this._changed=!1,this._updatedLayers={},this._removedLayers={},this._updatedSourceCaches={},this._updatedPaintProps.clear(),this._updatedImages.clear();}}class x extends e.E{constructor(e){super(),this.requestManager=e,this.models={"":{}},this.numModelsLoading={};}loadModel(t,i){return e.l(this.requestManager.transformRequest(i,e.R.Model).url).then((i=>{if(!i)return;const o=e.c(i),r=new e.M(t,void 0,void 0,o);return r.computeBoundsAndApplyParent(),r})).catch((o=>{this.fire(new e.a(new Error(`Could not load model ${t} from ${i}: ${o.message}`)));}))}load(t,i){this.models[i]||(this.models[i]={});const o=Object.keys(t);this.numModelsLoading[i]=(this.numModelsLoading[i]||0)+o.length;const r=[];for(const e of o)r.push(this.loadModel(e,t[e]));Promise.allSettled(r).then((t=>{for(let e=0;e<t.length;e++){const{status:r,value:s}=t[e];"fulfilled"===r&&s&&(this.models[i][o[e]]=s);}this.numModelsLoading[i]-=o.length,this.fire(new e.b("data",{dataType:"style"}));})).catch((t=>{this.fire(new e.a(new Error(`Could not load models: ${t.message}`)));}));}isLoaded(){for(const e in this.numModelsLoading)if(this.numModelsLoading[e]>0)return !1;return !0}hasModel(e,t){return !!this.getModel(e,t)}getModel(e,t){return this.models[t]||(this.models[t]={}),this.models[t][e]}addModel(e,t,i){this.models[i]||(this.models[i]={}),this.hasModel(e,i)&&this.removeModel(e,i),this.load({[e]:this.requestManager.normalizeModelURL(t)},i);}addModels(e,t){const i={};for(const t in e)i[t]=this.requestManager.normalizeModelURL(e[t]);this.load(i,t);}removeModel(e,t){this.models[t]||(this.models[t]={});const i=this.models[t][e];delete this.models[t][e],i.destroy();}listModels(e){return this.models[e]||(this.models[e]={}),Object.keys(this.models[e])}upload(e,t){this.models[t]||(this.models[t]={});for(const i in this.models[t])this.models[t][i].upload(e.context);}}class y{constructor(){this.state={},this.stateChanges={},this.deletedStates={};}updateState(t,i,o){const r=String(i);if(this.stateChanges[t]=this.stateChanges[t]||{},this.stateChanges[t][r]=this.stateChanges[t][r]||{},e.e(this.stateChanges[t][r],o),null===this.deletedStates[t]){this.deletedStates[t]={};for(const e in this.state[t])e!==r&&(this.deletedStates[t][e]=null);}else if(this.deletedStates[t]&&null===this.deletedStates[t][r]){this.deletedStates[t][r]={};for(const e in this.state[t][r])o[e]||(this.deletedStates[t][r][e]=null);}else for(const e in o)this.deletedStates[t]&&this.deletedStates[t][r]&&null===this.deletedStates[t][r][e]&&delete this.deletedStates[t][r][e];}removeFeatureState(e,t,i){if(null===this.deletedStates[e])return;const o=String(t);if(this.deletedStates[e]=this.deletedStates[e]||{},i&&void 0!==t)null!==this.deletedStates[e][o]&&(this.deletedStates[e][o]=this.deletedStates[e][o]||{},this.deletedStates[e][o][i]=null);else if(void 0!==t)if(this.stateChanges[e]&&this.stateChanges[e][o])for(i in this.deletedStates[e][o]={},this.stateChanges[e][o])this.deletedStates[e][o][i]=null;else this.deletedStates[e][o]=null;else this.deletedStates[e]=null;}getState(t,i){const o=String(i),r=e.e({},(this.state[t]||{})[o],(this.stateChanges[t]||{})[o]);if(null===this.deletedStates[t])return {};if(this.deletedStates[t]){const e=this.deletedStates[t][i];if(null===e)return {};for(const t in e)delete r[t];}return r}initializeTileState(e,t){e.setFeatureState(this.state,t);}coalesceChanges(t,i){const o={};for(const t in this.stateChanges){this.state[t]=this.state[t]||{};const i={};for(const o in this.stateChanges[t])this.state[t][o]||(this.state[t][o]={}),e.e(this.state[t][o],this.stateChanges[t][o]),i[o]=this.state[t][o];o[t]=i;}for(const t in this.deletedStates){this.state[t]=this.state[t]||{};const i={};if(null===this.deletedStates[t])for(const e in this.state[t])i[e]={},this.state[t][e]={};else for(const e in this.deletedStates[t]){if(null===this.deletedStates[t][e])this.state[t][e]={};else if(this.state[t][e])for(const i of Object.keys(this.deletedStates[t][e]))delete this.state[t][e][i];i[e]=this.state[t][e];}o[t]=o[t]||{},e.e(o[t],i);}if(this.stateChanges={},this.deletedStates={},0!==Object.keys(o).length)for(const e in t)t[e].setFeatureState(o,i);}}function b(e){const{userImage:t}=e;return !!(t&&t.render&&t.render())&&(e.data.replace(new Uint8Array(t.data.buffer)),!0)}class w extends e.E{constructor(){super(),this.images={},this.updatedImages={},this.callbackDispatchedThisFrame={},this.loaded={},this.requestors=[],this.patterns={},this.atlasImage={},this.atlasTexture={},this.dirty=!0;}createScope(t){this.images[t]={},this.loaded[t]=!1,this.updatedImages[t]={},this.patterns[t]={},this.callbackDispatchedThisFrame[t]={},this.atlasImage[t]=new e.h({width:1,height:1});}isLoaded(){for(const e in this.loaded)if(!this.loaded[e])return !1;return !0}setLoaded(e,t){if(this.loaded[t]!==e&&(this.loaded[t]=e,e)){for(const{ids:e,callback:i}of this.requestors)this._notify(e,t,i);this.requestors=[];}}hasImage(e,t){return !!this.getImage(e,t)}getImage(e,t){return this.images[t][e]}addImage(e,t,i){this._validate(e,i)&&(this.images[t][e]=i);}_validate(t,i){let o=!0;return this._validateStretch(i.stretchX,i.data&&i.data.width)||(this.fire(new e.a(new Error(`Image "${t}" has invalid "stretchX" value`))),o=!1),this._validateStretch(i.stretchY,i.data&&i.data.height)||(this.fire(new e.a(new Error(`Image "${t}" has invalid "stretchY" value`))),o=!1),this._validateContent(i.content,i)||(this.fire(new e.a(new Error(`Image "${t}" has invalid "content" value`))),o=!1),o}_validateStretch(e,t){if(!e)return !0;let i=0;for(const o of e){if(o[0]<i||o[1]<o[0]||t<o[1])return !1;i=o[1];}return !0}_validateContent(e,t){return !(e&&(4!==e.length||e[0]<0||t.data.width<e[0]||e[1]<0||t.data.height<e[1]||e[2]<0||t.data.width<e[2]||e[3]<0||t.data.height<e[3]||e[2]<e[0]||e[3]<e[1]))}updateImage(e,t,i){i.version=this.images[t][e].version+1,this.images[t][e]=i,this.updatedImages[t][e]=!0;}removeImage(e,t){const i=this.images[t][e];delete this.images[t][e],delete this.patterns[t][e],i.userImage&&i.userImage.onRemove&&i.userImage.onRemove();}listImages(e){return Object.keys(this.images[e])}getImages(e,t,i){let o=!0;const r=!!this.loaded[t];if(!r)for(const i of e)this.images[t][i]||(o=!1);r||o?this._notify(e,t,i):this.requestors.push({ids:e,scope:t,callback:i});}getUpdatedImages(e){return this.updatedImages[e]}_notify(t,i,o){const r={};for(const o of t){this.images[i][o]||this.fire(new e.b("styleimagemissing",{id:o}));const t=this.images[i][o];t?r[o]={data:t.data.clone(),pixelRatio:t.pixelRatio,sdf:t.sdf,version:t.version,stretchX:t.stretchX,stretchY:t.stretchY,content:t.content,hasRenderCallback:Boolean(t.userImage&&t.userImage.render)}:e.w(`Image "${o}" could not be loaded. Please make sure you have added the image with map.addImage() or a "sprite" property in your style. You can provide missing images by listening for the "styleimagemissing" map event.`);}o(null,r);}getPixelSize(e){const{width:t,height:i}=this.atlasImage[e];return {width:t,height:i}}getPattern(t,i){const o=this.patterns[i][t],r=this.getImage(t,i);if(!r)return null;if(o&&o.position.version===r.version)return o.position;if(o)o.position.version=r.version;else {const o={w:r.data.width+2,h:r.data.height+2,x:0,y:0},s=new e.I(o,r);this.patterns[i][t]={bin:o,position:s};}return this._updatePatternAtlas(i),this.patterns[i][t].position}bind(t,i){const o=t.gl;let r=this.atlasTexture[i];r?this.dirty&&(r.update(this.atlasImage[i]),this.dirty=!1):(r=new e.T(t,this.atlasImage[i],o.RGBA),this.atlasTexture[i]=r),r.bind(o.LINEAR,o.CLAMP_TO_EDGE);}_updatePatternAtlas(t){const i=[];for(const e in this.patterns[t])i.push(this.patterns[t][e].bin);const{w:o,h:r}=e.p(i),s=this.atlasImage[t];s.resize({width:o||1,height:r||1});for(const i in this.patterns[t]){const{bin:o}=this.patterns[t][i],r=o.x+1,n=o.y+1,a=this.images[t][i].data,l=a.width,c=a.height;e.h.copy(a,s,{x:0,y:0},{x:r,y:n},{width:l,height:c}),e.h.copy(a,s,{x:0,y:c-1},{x:r,y:n-1},{width:l,height:1}),e.h.copy(a,s,{x:0,y:0},{x:r,y:n+c},{width:l,height:1}),e.h.copy(a,s,{x:l-1,y:0},{x:r-1,y:n},{width:1,height:c}),e.h.copy(a,s,{x:0,y:0},{x:r+l,y:n},{width:1,height:c});}this.dirty=!0;}beginFrame(){for(const e in this.images)this.callbackDispatchedThisFrame[e]={};}dispatchRenderCallbacks(e,t){for(const i of e){if(this.callbackDispatchedThisFrame[t][i])continue;this.callbackDispatchedThisFrame[t][i]=!0;const e=this.images[t][i];b(e)&&this.updateImage(i,t,e);}}}class T{constructor(e,t,i,o){this.message=(e?`${e}: `:"")+i,o&&(this.identifier=o),null!=t&&t.__line__&&(this.line=t.__line__);}}class E extends T{}function S(t){const i=t.key,o=t.value,r=t.valueSpec||{},s=t.objectElementValidators||{},n=t.style,a=t.styleSpec;let l=[];const c=e.i(o);if("object"!==c)return [new T(i,o,`object expected, ${c} found`)];for(const e in o){const t=e.split(".")[0];let c;s[t]?c=s[t]:r[t]?c=$:s["*"]?c=s["*"]:r["*"]&&(c=$),c?l=l.concat(c({key:(i?`${i}.`:i)+e,value:o[e],valueSpec:r[t]||r["*"],style:n,styleSpec:a,object:o,objectKey:e},o)):l.push(new E(i,o[e],`unknown property "${e}"`));}for(const e in r)s[e]||r[e].required&&void 0===r[e].default&&void 0===o[e]&&l.push(new T(i,o,`missing required property "${e}"`));return l}function C(t){const i=t.value,o=t.valueSpec,r=t.style,s=t.styleSpec,n=t.key,a=t.arrayElementValidator||$;if("array"!==e.i(i))return [new T(n,i,`array expected, ${e.i(i)} found`)];if(o.length&&i.length!==o.length)return [new T(n,i,`array length ${o.length} expected, length ${i.length} found`)];if(o["min-length"]&&i.length<o["min-length"])return [new T(n,i,`array length at least ${o["min-length"]} expected, length ${i.length} found`)];let l={type:o.value,values:o.values,minimum:o.minimum,maximum:o.maximum,function:void 0};s.$version<7&&(l.function=o.function),"object"===e.i(o.value)&&(l=o.value);let c=[];for(let e=0;e<i.length;e++)c=c.concat(a({array:i,arrayIndex:e,value:i[e],valueSpec:l,style:r,styleSpec:s,key:`${n}[${e}]`},!0));return c}function I(t){const i=t.key,o=t.value,r=t.valueSpec;let s=e.i(o);if("number"===s&&o!=o&&(s="NaN"),"number"!==s)return [new T(i,o,`number expected, ${s} found`)];if("minimum"in r){let s=r.minimum;if("array"===e.i(r.minimum)&&(s=r.minimum[t.arrayIndex]),o<s)return [new T(i,o,`${o} is less than the minimum value ${s}`)]}if("maximum"in r){let s=r.maximum;if("array"===e.i(r.maximum)&&(s=r.maximum[t.arrayIndex]),o>s)return [new T(i,o,`${o} is greater than the maximum value ${s}`)]}return []}function D(t){const i=t.valueSpec,o=e.u(t.value.type);let r,s,n,a={};const l="categorical"!==o&&void 0===t.value.property,c=!l,h="array"===e.i(t.value.stops)&&"array"===e.i(t.value.stops[0])&&"object"===e.i(t.value.stops[0][0]),u=S({key:t.key,value:t.value,valueSpec:t.styleSpec.function,style:t.style,styleSpec:t.styleSpec,objectElementValidators:{stops:function(t){if("identity"===o)return [new T(t.key,t.value,'identity function may not have a "stops" property')];let i=[];const r=t.value;return i=i.concat(C({key:t.key,value:r,valueSpec:t.valueSpec,style:t.style,styleSpec:t.styleSpec,arrayElementValidator:d})),"array"===e.i(r)&&0===r.length&&i.push(new T(t.key,r,"array must have at least one stop")),i},default:function(e){return $({key:e.key,value:e.value,valueSpec:i,style:e.style,styleSpec:e.styleSpec})}}});return "identity"===o&&l&&u.push(new T(t.key,t.value,'missing required property "property"')),"identity"===o||t.value.stops||u.push(new T(t.key,t.value,'missing required property "stops"')),"exponential"===o&&t.valueSpec.expression&&!e.s(t.valueSpec)&&u.push(new T(t.key,t.value,"exponential functions not supported")),t.styleSpec.$version>=8&&(c&&!e.k(t.valueSpec)?u.push(new T(t.key,t.value,"property functions not supported")):l&&!e.m(t.valueSpec)&&u.push(new T(t.key,t.value,"zoom functions not supported"))),"categorical"!==o&&!h||void 0!==t.value.property||u.push(new T(t.key,t.value,'"property" property is required')),u;function d(t){let o=[];const r=t.value,l=t.key;if("array"!==e.i(r))return [new T(l,r,`array expected, ${e.i(r)} found`)];if(2!==r.length)return [new T(l,r,`array length 2 expected, length ${r.length} found`)];if(h){if("object"!==e.i(r[0]))return [new T(l,r,`object expected, ${e.i(r[0])} found`)];if(void 0===r[0].zoom)return [new T(l,r,"object stop key must have zoom")];if(void 0===r[0].value)return [new T(l,r,"object stop key must have value")];const i=e.u(r[0].zoom);if("number"!=typeof i)return [new T(l,r[0].zoom,"stop zoom values must be numbers")];if(n&&n>i)return [new T(l,r[0].zoom,"stop zoom values must appear in ascending order")];i!==n&&(n=i,s=void 0,a={}),o=o.concat(S({key:`${l}[0]`,value:r[0],valueSpec:{zoom:{}},style:t.style,styleSpec:t.styleSpec,objectElementValidators:{zoom:I,value:_}}));}else o=o.concat(_({key:`${l}[0]`,value:r[0],valueSpec:{},style:t.style,styleSpec:t.styleSpec},r));return e.n(e.o(r[1]))?o.concat([new T(`${l}[1]`,r[1],"expressions are not allowed in function stops.")]):o.concat($({key:`${l}[1]`,value:r[1],valueSpec:i,style:t.style,styleSpec:t.styleSpec}))}function _(t,n){const l=e.i(t.value),c=e.u(t.value),h=null!==t.value?t.value:n;if(r){if(l!==r)return [new T(t.key,h,`${l} stop domain type must match previous stop domain type ${r}`)]}else r=l;if("number"!==l&&"string"!==l&&"boolean"!==l&&"number"!=typeof c&&"string"!=typeof c&&"boolean"!=typeof c)return [new T(t.key,h,"stop domain value must be a number, string, or boolean")];if("number"!==l&&"categorical"!==o){let r=`number expected, ${l} found`;return e.k(i)&&void 0===o&&(r+='\nIf you intended to use a categorical function, specify `"type": "categorical"`.'),[new T(t.key,h,r)]}return "categorical"!==o||"number"!==l||"number"==typeof c&&isFinite(c)&&Math.floor(c)===c?"categorical"!==o&&"number"===l&&"number"==typeof c&&"number"==typeof s&&void 0!==s&&c<s?[new T(t.key,h,"stop domain values must appear in ascending order")]:(s=c,"categorical"===o&&c in a?[new T(t.key,h,"stop domain values must be unique")]:(a[c]=!0,[])):[new T(t.key,h,`integer expected, found ${String(c)}`)]}}function L(t){const i=("property"===t.expressionContext?e.q:e.r)(e.o(t.value),t.valueSpec);if("error"===i.result)return i.value.map((e=>new T(`${t.key}${e.key}`,t.value,e.message)));const o=i.value.expression||i.value._styleExpression.expression;if("property"===t.expressionContext&&"text-font"===t.propertyKey&&!o.outputDefined())return [new T(t.key,t.value,`Invalid data expression for "${t.propertyKey}". Output values must be contained as literals within the expression.`)];if("property"===t.expressionContext&&"layout"===t.propertyType&&!e.t(o))return [new T(t.key,t.value,'"feature-state" data expressions are not supported with layout properties.')];if("filter"===t.expressionContext)return A(o,t);if(t.expressionContext&&0===t.expressionContext.indexOf("cluster")){if(!e.v(o,["zoom","feature-state"]))return [new T(t.key,t.value,'"zoom" and "feature-state" expressions are not supported with cluster properties.')];if("cluster-initial"===t.expressionContext&&!e.x(o))return [new T(t.key,t.value,"Feature data expressions are not supported with initial expression part of cluster properties.")]}return []}function A(t,i){const o=new Set(["zoom","feature-state","pitch","distance-from-center"]);if(i.valueSpec&&i.valueSpec.expression)for(const e of i.valueSpec.expression.parameters)o.delete(e);if(0===o.size)return [];const r=[];return t instanceof e.C&&o.has(t.name)?[new T(i.key,i.value,`["${t.name}"] expression is not supported in a filter for a ${i.object.type} layer with id: ${i.object.id}`)]:(t.eachChild((e=>{r.push(...A(e,i));})),r)}function R(t){const i=t.key,o=t.value,r=t.valueSpec,s=[];return Array.isArray(r.values)?-1===r.values.indexOf(e.u(o))&&s.push(new T(i,o,`expected one of [${r.values.join(", ")}], ${JSON.stringify(o)} found`)):-1===Object.keys(r.values).indexOf(e.u(o))&&s.push(new T(i,o,`expected one of [${Object.keys(r.values).join(", ")}], ${JSON.stringify(o)} found`)),s}function P(t){return e.z(e.o(t.value))?L(e.j({},t,{expressionContext:"filter",valueSpec:t.styleSpec[`filter_${t.layerType||"fill"}`]})):M(t)}function M(t){const i=t.value,o=t.key;if("array"!==e.i(i))return [new T(o,i,`array expected, ${e.i(i)} found`)];const r=t.styleSpec;let s,n=[];if(i.length<1)return [new T(o,i,"filter array must have at least 1 element")];switch(n=n.concat(R({key:`${o}[0]`,value:i[0],valueSpec:r.filter_operator,style:t.style,styleSpec:t.styleSpec})),e.u(i[0])){case"<":case"<=":case">":case">=":i.length>=2&&"$type"===e.u(i[1])&&n.push(new T(o,i,`"$type" cannot be use with operator "${i[0]}"`));case"==":case"!=":3!==i.length&&n.push(new T(o,i,`filter array for operator "${i[0]}" must have 3 elements`));case"in":case"!in":i.length>=2&&(s=e.i(i[1]),"string"!==s&&n.push(new T(`${o}[1]`,i[1],`string expected, ${s} found`)));for(let a=2;a<i.length;a++)s=e.i(i[a]),"$type"===e.u(i[1])?n=n.concat(R({key:`${o}[${a}]`,value:i[a],valueSpec:r.geometry_type,style:t.style,styleSpec:t.styleSpec})):"string"!==s&&"number"!==s&&"boolean"!==s&&n.push(new T(`${o}[${a}]`,i[a],`string, number, or boolean expected, ${s} found`));break;case"any":case"all":case"none":for(let e=1;e<i.length;e++)n=n.concat(M({key:`${o}[${e}]`,value:i[e],style:t.style,styleSpec:t.styleSpec}));break;case"has":case"!has":s=e.i(i[1]),2!==i.length?n.push(new T(o,i,`filter array for "${i[0]}" operator must have 2 elements`)):"string"!==s&&n.push(new T(`${o}[1]`,i[1],`string expected, ${s} found`));}return n}function z(t,i){const o=t.key,r=t.style,s=t.layer,n=t.styleSpec,a=t.value,l=t.objectKey,c=n[`${i}_${t.layerType}`];if(!c)return [];const h=l.match(/^(.*)-transition$/);if("paint"===i&&h&&c[h[1]]&&c[h[1]].transition)return $({key:o,value:a,valueSpec:n.transition,style:r,styleSpec:n});const u=t.valueSpec||c[l];if(!u)return [new E(o,a,`unknown property "${l}"`)];let d;if("string"===e.i(a)&&e.k(u)&&!u.tokens&&(d=/^{([^}]+)}$/.exec(a))){const e=`\`{ "type": "identity", "property": ${d?JSON.stringify(d[1]):'"_"'} }\``;return [new T(o,a,`"${l}" does not support interpolation syntax\nUse an identity property function instead: ${e}.`)]}const _=[];if("symbol"===t.layerType)"text-field"!==l||!r||r.glyphs||r.imports||_.push(new T(o,a,'use of "text-field" requires a style "glyphs" property')),"text-font"===l&&e.A(e.o(a))&&"identity"===e.u(a.type)&&_.push(new T(o,a,'"text-font" does not support identity functions'));else if("model"===t.layerType&&"paint"===i&&s&&s.layout&&s.layout.hasOwnProperty("model-id")&&e.k(u)&&(e.B(u)||e.m(u))){const t=e.q(e.o(a),u),i=t.value.expression||t.value._styleExpression.expression;i&&!e.v(i,["measure-light"])&&("model-emissive-strength"===l&&e.x(i)&&e.t(i)||_.push(new T(o,a,`${l} does not support measure-light expressions when the model layer source is vector tile or GeoJSON.`)));}return _.concat($({key:t.key,value:a,valueSpec:u,style:r,styleSpec:n,expressionContext:"property",propertyType:i,propertyKey:l}))}function O(e){return z(e,"paint")}function F(e){return z(e,"layout")}function B(t){let i=[];const o=t.value,r=t.key,s=t.style,n=t.styleSpec;o.type||o.ref||i.push(new T(r,o,'either "type" or "ref" is required'));let a=e.u(o.type);const l=e.u(o.ref);if(o.id){const n=e.u(o.id);for(let a=0;a<t.arrayIndex;a++){const t=s.layers[a];e.u(t.id)===n&&i.push(new T(r,o.id,`duplicate layer id "${o.id}", previously used at line ${t.id.__line__}`));}}if("ref"in o){let t;["type","source","source-layer","filter","layout"].forEach((e=>{e in o&&i.push(new T(r,o[e],`"${e}" is prohibited for ref layers`));})),s.layers.forEach((i=>{e.u(i.id)===l&&(t=i);})),t?t.ref?i.push(new T(r,o.ref,"ref cannot reference another ref layer")):a=e.u(t.type):"string"==typeof l&&i.push(new T(r,o.ref,`ref layer "${l}" not found`));}else if("background"!==a&&"sky"!==a&&"slot"!==a)if(o.source){const t=s.sources&&s.sources[o.source],n=t&&e.u(t.type);t?"vector"===n&&"raster"===a?i.push(new T(r,o.source,`layer "${o.id}" requires a raster source`)):"raster"===n&&"raster"!==a?i.push(new T(r,o.source,`layer "${o.id}" requires a vector source`)):"vector"!==n||o["source-layer"]?"raster-dem"===n&&"hillshade"!==a?i.push(new T(r,o.source,"raster-dem source can only be used with layer type 'hillshade'.")):"raster-array"!==n||["raster","raster-particle"].includes(a)?"line"!==a||!o.paint||!o.paint["line-gradient"]&&!o.paint["line-trim-offset"]||"geojson"===n&&t.lineMetrics?"raster-particle"===a&&"raster-array"!==n&&i.push(new T(r,o.source,`layer "${o.id}" requires a 'raster-array' source.`)):i.push(new T(r,o,`layer "${o.id}" specifies a line-gradient, which requires a GeoJSON source with \`lineMetrics\` enabled.`)):i.push(new T(r,o.source,"raster-array source can only be used with layer type 'raster'.")):i.push(new T(r,o,`layer "${o.id}" must specify a "source-layer"`)):i.push(new T(r,o.source,`source "${o.source}" not found`));}else i.push(new T(r,o,'missing required property "source"'));return i=i.concat(S({key:r,value:o,valueSpec:n.layer,style:t.style,styleSpec:t.styleSpec,objectElementValidators:{"*":()=>[],type:()=>$({key:`${r}.type`,value:o.type,valueSpec:n.layer.type,style:t.style,styleSpec:t.styleSpec,object:o,objectKey:"type"}),filter:t=>P(e.j({layerType:a},t)),layout:t=>S({layer:o,key:t.key,value:t.value,valueSpec:{},style:t.style,styleSpec:t.styleSpec,objectElementValidators:{"*":t=>F(e.j({layerType:a},t))}}),paint:t=>S({layer:o,key:t.key,value:t.value,valueSpec:{},style:t.style,styleSpec:t.styleSpec,objectElementValidators:{"*":t=>O(e.j({layerType:a,layer:o},t))}})}})),i}function k(t){const i=t.value,o=t.key,r=e.i(i);return "string"!==r?[new T(o,i,`string expected, ${r} found`)]:[]}const N={promoteId:function({key:t,value:i}){if("string"===e.i(i))return k({key:t,value:i});{const e=[];for(const o in i)e.push(...k({key:`${t}.${o}`,value:i[o]}));return e}}};function U(t){const i=t.value,o=t.key,r=t.styleSpec,s=t.style;if(!i.type)return [new T(o,i,'"type" is required')];const n=e.u(i.type);let a=[];switch(["vector","raster","raster-dem","raster-array"].includes(n)&&(i.url||i.tiles||a.push(new E(o,i,'Either "url" or "tiles" is required.'))),n){case"vector":case"raster":case"raster-dem":case"raster-array":return a=a.concat(S({key:o,value:i,valueSpec:r[`source_${n.replace("-","_")}`],style:t.style,styleSpec:r,objectElementValidators:N})),a;case"geojson":if(a=S({key:o,value:i,valueSpec:r.source_geojson,style:s,styleSpec:r,objectElementValidators:N}),i.cluster)for(const e in i.clusterProperties){const[t,r]=i.clusterProperties[e],s="string"==typeof t?[t,["accumulated"],["get",e]]:t;a.push(...L({key:`${o}.${e}.map`,value:r,expressionContext:"cluster-map"})),a.push(...L({key:`${o}.${e}.reduce`,value:s,expressionContext:"cluster-reduce"}));}return a;case"video":return S({key:o,value:i,valueSpec:r.source_video,style:s,styleSpec:r});case"image":return S({key:o,value:i,valueSpec:r.source_image,style:s,styleSpec:r});case"canvas":return [new T(o,null,"Please use runtime APIs to add canvas sources, rather than including them in stylesheets.","source.canvas")];default:return R({key:`${o}.type`,value:i.type,valueSpec:{values:G(r)},style:s,styleSpec:r})}}function G(e){return e.source.reduce(((t,i)=>{const o=e[i];return "enum"===o.type.type&&(t=t.concat(Object.keys(o.type.values))),t}),[])}function j(t){const i=t.value;let o=[];if(!i)return o;const r=e.i(i);return "string"!==r?(o=o.concat([new T(t.key,i,`string expected, "${r}" found`)]),o):(function(e){const t=-1===e.indexOf("://");try{return new URL(e,t?"http://example.com":void 0),!0}catch(e){return !1}}(i)||(o=o.concat([new T(t.key,i,`invalid url "${i}"`)])),o)}function V(t){const i=t.value,o=t.styleSpec,r=o.light,s=t.style;let n=[];const a=e.i(i);if(void 0===i)return n;if("object"!==a)return n=n.concat([new T("light",i,`object expected, ${a} found`)]),n;for(const e in i){const t=e.match(/^(.*)-transition$/);n=n.concat(t&&r[t[1]]&&r[t[1]].transition?$({key:e,value:i[e],valueSpec:o.transition,style:s,styleSpec:o}):r[e]?$({key:e,value:i[e],valueSpec:r[e],style:s,styleSpec:o}):[new T(e,i[e],`unknown property "${e}"`)]);}return n}function Z(t){const i=t.value;let o=[];if(!i)return o;const r=e.i(i);if("object"!==r)return o=o.concat([new T("light-3d",i,`object expected, ${r} found`)]),o;const s=t.styleSpec,n=s["light-3d"],a=t.key,l=t.style,c=t.style.lights;for(const e of ["type","id"])if(!(e in i))return o=o.concat([new T("light-3d",i,`missing property ${e} on light`)]),o;if(i.type&&c)for(let r=0;r<t.arrayIndex;r++){const t=e.u(i.type),s=c[r];e.u(s.type)===t&&o.push(new T(a,i.id,`duplicate light type "${i.type}", previously defined at line ${s.id.__line__}`));}const h=`properties_light_${i.type}`;if(!(h in s))return o=o.concat([new T("light-3d",i,`Invalid light type ${i.type}`)]),o;const u=s[h];for(const r in i)if("properties"===r){const n=i[r],a=e.i(n);if("object"!==a)return o=o.concat([new T("properties",n,`object expected, ${a} found`)]),o;for(const e in n)o=o.concat(u[e]?$({key:e,value:n[e],valueSpec:u[e],style:l,styleSpec:s}):[new E(t.key,n[e],`unknown property "${e}"`)]);}else {const e=r.match(/^(.*)-transition$/);o=o.concat(e&&n[e[1]]&&n[e[1]].transition?$({key:r,value:i[r],valueSpec:s.transition,style:l,styleSpec:s}):n[r]?$({key:r,value:i[r],valueSpec:n[r],style:l,styleSpec:s}):[new E(r,i[r],`unknown property "${r}"`)]);}return o}function H(t){const i=t.value,o=t.key,r=t.style,s=t.styleSpec,n=s.terrain;let a=[];const l=e.i(i);if(void 0===i)return a;if("null"===l)return a;if("object"!==l)return a=a.concat([new T("terrain",i,`object expected, ${l} found`)]),a;for(const e in i){const t=e.match(/^(.*)-transition$/);a=a.concat(t&&n[t[1]]&&n[t[1]].transition?$({key:e,value:i[e],valueSpec:s.transition,style:r,styleSpec:s}):n[e]?$({key:e,value:i[e],valueSpec:n[e],style:r,styleSpec:s}):[new E(e,i[e],`unknown property "${e}"`)]);}if(i.source){const t=r.sources&&r.sources[i.source],s=t&&e.u(t.type);t?"raster-dem"!==s&&a.push(new T(o,i.source,`terrain cannot be used with a source of type ${String(s)}, it only be used with a "raster-dem" source type`)):a.push(new T(o,i.source,`source "${i.source}" not found`));}else a.push(new T(o,i,'terrain is missing required property "source"'));return a}function W(t){const i=t.value,o=t.style,r=t.styleSpec,s=r.fog;let n=[];const a=e.i(i);if(void 0===i)return n;if("object"!==a)return n=n.concat([new T("fog",i,`object expected, ${a} found`)]),n;for(const e in i){const t=e.match(/^(.*)-transition$/);n=n.concat(t&&s[t[1]]&&s[t[1]].transition?$({key:e,value:i[e],valueSpec:r.transition,style:o,styleSpec:r}):s[e]?$({key:e,value:i[e],valueSpec:s[e],style:o,styleSpec:r}):[new E(e,i[e],`unknown property "${e}"`)]);}return n}const q={"*":()=>[],array:C,boolean:function(t){const i=t.value,o=t.key,r=e.i(i);return "boolean"!==r?[new T(o,i,`boolean expected, ${r} found`)]:[]},number:I,color:function(t){const i=t.key,o=t.value,r=e.i(o);return "string"!==r?[new T(i,o,`color expected, ${r} found`)]:null===e.y(o)?[new T(i,o,`color expected, "${o}" found`)]:[]},enum:R,filter:P,function:D,layer:B,object:S,source:U,model:j,light:V,"light-3d":Z,terrain:H,fog:W,string:k,formatted:function(e){return 0===k(e).length?[]:L(e)},resolvedImage:function(e){return 0===k(e).length?[]:L(e)},projection:function(t){const i=t.value,o=t.styleSpec,r=o.projection,s=t.style;let n=[];const a=e.i(i);if("object"===a)for(const e in i)n=n.concat($({key:e,value:i[e],valueSpec:r[e],style:s,styleSpec:o}));else "string"!==a&&(n=n.concat([new T("projection",i,`object or string expected, ${a} found`)]));return n},import:function(t){const{value:i,styleSpec:o}=t,{data:r,...s}=i;Object.defineProperty(s,"__line__",{value:i.__line__,enumerable:!1});let n=S(e.j({},t,{value:s,valueSpec:o.import}));return ""===e.u(s.id)&&n.push(new T(`${t.key}.id`,s,"import id can't be an empty string")),r&&(n=n.concat(K(r,o,{key:`${t.key}.data`}))),n}};function $(t,i=!1){const o=t.value,r=t.valueSpec,s=t.styleSpec;if(r.expression&&e.A(e.u(o)))return D(t);if(r.expression&&e.n(e.o(o)))return L(t);if(r.type&&q[r.type]){const o=q[r.type](t);return !0===i&&o.length>0&&"array"===e.i(t.value)?L(t):o}return S(e.j({},t,{valueSpec:r.type?s[r.type]:r}))}function X(e){const t=e.value,i=e.key,o=k(e);return o.length||(-1===t.indexOf("{fontstack}")&&o.push(new T(i,t,'"glyphs" url must include a "{fontstack}" token')),-1===t.indexOf("{range}")&&o.push(new T(i,t,'"glyphs" url must include a "{range}" token'))),o}function K(t,i=e.D,o={}){return $({key:o.key||"",value:t,valueSpec:i.$root,styleSpec:i,style:t,objectElementValidators:{glyphs:X,"*":()=>[]}})}function Y(t,i=e.D){return le(K(t,i))}const J=e=>le(U(e)),Q=e=>le(V(e)),ee=e=>le(Z(e)),te=e=>le(H(e)),ie=e=>le(W(e)),oe=e=>le(B(e)),re=e=>le(P(e)),se=e=>le(O(e)),ne=e=>le(F(e)),ae=e=>le(j(e));function le(e){return e.slice().sort(((e,t)=>e.line&&t.line?e.line-t.line:0))}function ce(t,i){let o=!1;if(i&&i.length)for(const r of i)r instanceof E?e.w(r.message):(t.fire(new e.a(new Error(r.message))),o=!0);return o}const he=new e.F({anchor:new e.G(e.D.light.anchor),position:new e.H(e.D.light.position),color:new e.G(e.D.light.color),intensity:new e.G(e.D.light.intensity)});class ue extends e.E{constructor(t,i="flat"){super(),this._transitionable=new e.J(he),this.setLight(t,i),this._transitioning=this._transitionable.untransitioned();}getLight(){return this._transitionable.serialize()}setLight(e,t,i={}){this._validate(Q,e,i)||(this._transitionable.setTransitionOrValue(e),this.id=t);}updateTransitions(e){this._transitioning=this._transitionable.transitioned(e,this._transitioning);}hasTransition(){return this._transitioning.hasTransition()}recalculate(e){this.properties=this._transitioning.possiblyEvaluate(e);}_validate(t,i,o){return (!o||!1!==o.validate)&&ce(this,t.call(Y,e.e({value:i,style:{glyphs:!0,sprite:!0},styleSpec:e.D})))}}const de=new e.F({source:new e.G(e.D.terrain.source),exaggeration:new e.G(e.D.terrain.exaggeration)});let _e=class extends e.E{constructor(t,i,o,r){super(),this.scope=o,this._transitionable=new e.J(de,o,r),this._transitionable.setTransitionOrValue(t,r),this._transitioning=this._transitionable.untransitioned(),this.drapeRenderMode=i;}get(){return this._transitionable.serialize()}set(e,t){this._transitionable.setTransitionOrValue(e,t);}updateTransitions(e){this._transitioning=this._transitionable.transitioned(e,this._transitioning);}hasTransition(){return this._transitioning.hasTransition()}recalculate(e){this.properties=this._transitioning.possiblyEvaluate(e);}getExaggeration(t){return this._transitioning.possiblyEvaluate(new e.K(t)).get("exaggeration")}isZoomDependent(){const t=this._transitionable._values.exaggeration;return null!=t&&null!=t.value&&null!=t.value.expression&&t.value.expression instanceof e.Z}};const pe=45,fe=65,me=.05;function ge(t,i,o,r){const s=e.O(pe,fe,o),[n,a]=ve(t,r);let l=1-Math.min(1,Math.exp((i-n)/(a-n)*-6));return l*=l*l,l=Math.min(1,1.00747*l),l*s*t.alpha}function ve(e,t){const i=.5/Math.tan(.5*t);return [e.range[0]+i,e.range[1]+i]}function xe(t,i,o,r,s){const n=e.N.transformMat4([],[i,o,r],s.mercatorFogMatrix);return ge(t,e.N.length(n),s.pitch,s._fov)}function ye(t,i,o,r,s,n,a){const l=[[o,r,0],[s,r,0],[s,n,0],[o,n,0]];let c=Number.MAX_VALUE,h=-Number.MAX_VALUE;for(const t of l){const o=e.N.transformMat4([],t,i),r=e.N.length(o);c=Math.min(c,r),h=Math.max(h,r);}return [ge(t,c,a.pitch,a._fov),ge(t,h,a.pitch,a._fov)]}const be=new e.F({range:new e.G(e.D.fog.range),color:new e.G(e.D.fog.color),"high-color":new e.G(e.D.fog["high-color"]),"space-color":new e.G(e.D.fog["space-color"]),"horizon-blend":new e.G(e.D.fog["horizon-blend"]),"star-intensity":new e.G(e.D.fog["star-intensity"]),"vertical-range":new e.G(e.D.fog["vertical-range"])});class we extends e.E{constructor(t,i,o,r){super(),this._transitionable=new e.J(be,o,new Map(r)),this.set(t,r),this._transitioning=this._transitionable.untransitioned(),this._transform=i,this.properties=new e.Q(be);}get state(){const t=this._transform,i="globe"===t.projection.name,o=e.S(t.zoom),r=this.properties.get("range"),s=[.5,3];return {range:i?[e.U(s[0],r[0],o),e.U(s[1],r[1],o)]:r,horizonBlend:this.properties.get("horizon-blend"),alpha:this.properties.get("color").a}}get(){return this._transitionable.serialize()}set(t,i,o={}){if(this._validate(ie,t,o))return;const r=e.e({},t);for(const t of Object.keys(e.D.fog))void 0===r[t]&&(r[t]=e.D.fog[t].default);this._options=r,this._transitionable.setTransitionOrValue(this._options,i);}getOpacity(t){if(!this._transform.projection.supportsFog)return 0;const i=this.properties&&this.properties.get("color")||1;return ("globe"===this._transform.projection.name?1:e.O(pe,fe,t))*i.a}getOpacityAtLatLng(t,i){return this._transform.projection.supportsFog?function(t,i,o){const r=e.L.fromLngLat(i),s=o.elevation?o.elevation.getAtPointOrZero(r):0;return xe(t,r.x,r.y,s,o)}(this.state,t,i):0}getOpacityForTile(t){if(!this._transform.projection.supportsFog)return [1,1];const i=this._transform.calculateFogTileMatrix(t.toUnwrapped());return ye(this.state,i,0,0,e.V,e.V,this._transform)}getOpacityForBounds(e,t,i,o,r){return this._transform.projection.supportsFog?ye(this.state,e,t,i,o,r,this._transform):[1,1]}getFovAdjustedRange(e){return this._transform.projection.supportsFog?ve(this.state,e):[0,1]}isVisibleOnFrustum(t){if(!this._transform.projection.supportsFog)return !1;const i=[4,5,6,7];for(const o of i){const i=t.points[o];let r;if(i[2]>=0)r=i;else {const s=t.points[o-4];r=e.W(s,i,s[2]/(s[2]-i[2]));}if(xe(this.state,r[0],r[1],0,this._transform)>=me)return !0}return !1}updateConfig(e){this._transitionable.setTransitionOrValue(this._options,new Map(e));}updateTransitions(e){this._transitioning=this._transitionable.transitioned(e,this._transitioning);}hasTransition(){return this._transitioning.hasTransition()}recalculate(e){this.properties=this._transitioning.possiblyEvaluate(e);}_validate(t,i,o){return (!o||!1!==o.validate)&&ce(this,t.call(Y,e.e({value:i,style:{glyphs:!0,sprite:!0},styleSpec:e.D})))}}class Te extends e.E{constructor(t,i,o,r){super(),this.scope=o,this._options=t,this.properties=new e.Q(i),this._transitionable=new e.J(i,o,new Map(r)),this._transitionable.setTransitionOrValue(t.properties),this._transitioning=this._transitionable.untransitioned();}updateConfig(e){this._transitionable.setTransitionOrValue(this._options.properties,new Map(e));}updateTransitions(e){this._transitioning=this._transitionable.transitioned(e,this._transitioning);}hasTransition(){return this._transitioning.hasTransition()}recalculate(e){this.properties=this._transitioning.possiblyEvaluate(e);}get(){return this._options.properties=this._transitionable.serialize(),this._options}set(e,t){this._options=e,this._transitionable.setTransitionOrValue(e.properties,t);}shadowsEnabled(){return !!this.properties&&!0===this.properties.get("cast-shadows")}}const Ee=new e.F({color:new e.G(e.D.properties_light_ambient.color),intensity:new e.G(e.D.properties_light_ambient.intensity)}),Se=new e.F({direction:new e.X(e.D.properties_light_directional.direction),color:new e.G(e.D.properties_light_directional.color),intensity:new e.G(e.D.properties_light_directional.intensity),"cast-shadows":new e.G(e.D.properties_light_directional["cast-shadows"]),"shadow-intensity":new e.G(e.D.properties_light_directional["shadow-intensity"])});class Ce{constructor(e,t,i,o){this.screenBounds=e,this.cameraPoint=t,this._screenRaycastCache={},this._cameraRaycastCache={},this.isAboveHorizon=i,this.screenGeometry=this.bufferedScreenGeometry(0),this.screenGeometryMercator=this._bufferedScreenMercator(0,o);}static createFromScreenPoints(t,i){let o,r;if(t instanceof e.P||"number"==typeof t[0]){const s=e.P.convert(t);o=[s],r=i.isPointAboveHorizon(s);}else {const s=e.P.convert(t[0]),n=e.P.convert(t[1]);o=[s,n],r=e.Y(s,n).every((e=>i.isPointAboveHorizon(e)));}return new Ce(o,i.getCameraPoint(),r,i)}isPointQuery(){return 1===this.screenBounds.length}bufferedScreenGeometry(t){return e.Y(this.screenBounds[0],1===this.screenBounds.length?this.screenBounds[0]:this.screenBounds[1],t)}bufferedCameraGeometry(t){const i=this.screenBounds[0],o=1===this.screenBounds.length?this.screenBounds[0].add(new e.P(1,1)):this.screenBounds[1],r=e.Y(i,o,0,!1);return this.cameraPoint.y>o.y&&(this.cameraPoint.x>i.x&&this.cameraPoint.x<o.x?r.splice(3,0,this.cameraPoint):this.cameraPoint.x>=o.x?r[2]=this.cameraPoint:this.cameraPoint.x<=i.x&&(r[3]=this.cameraPoint)),e._(r,t)}bufferedCameraGeometryGlobe(t){const i=this.screenBounds[0],o=1===this.screenBounds.length?this.screenBounds[0].add(new e.P(1,1)):this.screenBounds[1],r=e.Y(i,o,t),s=this.cameraPoint.clone();switch(3*((s.y>i.y)+(s.y>o.y))+((s.x>i.x)+(s.x>o.x))){case 0:r[0]=s,r[4]=s.clone();break;case 1:r.splice(1,0,s);break;case 2:r[1]=s;break;case 3:r.splice(4,0,s);break;case 5:r.splice(2,0,s);break;case 6:r[3]=s;break;case 7:r.splice(3,0,s);break;case 8:r[2]=s;}return r}containsTile(t,i,o,r=0){const s=t.queryPadding/i._pixelsPerMercatorPixel+1,n=o?this._bufferedCameraMercator(s,i):this._bufferedScreenMercator(s,i);let a=t.tileID.wrap+(n.unwrapped?r:0);const l=n.polygon.map((i=>e.$(t.tileTransform,i,a)));if(!e.a0(l,0,0,e.V,e.V))return;a=t.tileID.wrap+(this.screenGeometryMercator.unwrapped?r:0);const c=this.screenGeometryMercator.polygon.map((i=>e.a1(t.tileTransform,i,a))),h=c.map((t=>new e.P(t[0],t[1]))),u=i.getFreeCameraOptions().position||new e.L(0,0,0),d=e.a1(t.tileTransform,u,a),_=c.map((t=>{const i=e.N.sub(t,t,d);return e.N.normalize(i,i),new e.a2(d,i)})),p=e.a3(t,1,i.zoom)*i._pixelsPerMercatorPixel;return {queryGeometry:this,tilespaceGeometry:h,tilespaceRays:_,bufferedTilespaceGeometry:l,bufferedTilespaceBounds:(f=e.a4(l),f.min.x=e.aa(f.min.x,0,e.V),f.min.y=e.aa(f.min.y,0,e.V),f.max.x=e.aa(f.max.x,0,e.V),f.max.y=e.aa(f.max.y,0,e.V),f),tile:t,tileID:t.tileID,pixelToTileUnitsFactor:p};var f;}_bufferedScreenMercator(e,t){const i=Le(e);if(this._screenRaycastCache[i])return this._screenRaycastCache[i];{let o;return o="globe"===t.projection.name?this._projectAndResample(this.bufferedScreenGeometry(e),t):{polygon:this.bufferedScreenGeometry(e).map((e=>t.pointCoordinate3D(e))),unwrapped:!0},this._screenRaycastCache[i]=o,o}}_bufferedCameraMercator(e,t){const i=Le(e);if(this._cameraRaycastCache[i])return this._cameraRaycastCache[i];{let o;return o="globe"===t.projection.name?this._projectAndResample(this.bufferedCameraGeometryGlobe(e),t):{polygon:this.bufferedCameraGeometry(e).map((e=>t.pointCoordinate3D(e))),unwrapped:!0},this._cameraRaycastCache[i]=o,o}}_projectAndResample(t,i){const o=function(t,i){const o=e.a6.multiply([],i.pixelMatrix,i.globeMatrix),r=[0,-e.ab,0,1],s=[0,e.ab,0,1],n=[0,0,0,1];e.a7.transformMat4(r,r,o),e.a7.transformMat4(s,s,o),e.a7.transformMat4(n,n,o);const a=new e.P(r[0]/r[3],r[1]/r[3]),l=new e.P(s[0]/s[3],s[1]/s[3]),c=e.a8(t,a)&&r[3]<n[3],h=e.a8(t,l)&&s[3]<n[3];if(!c&&!h)return null;const u=function(e,t,i){for(let o=1;o<e.length;o++){const r=De(t.pointCoordinate3D(e[o-1]).x),s=De(t.pointCoordinate3D(e[o]).x);if(i<0){if(r<s)return {idx:o,t:-r/(s-1-r)}}else if(s<r)return {idx:o,t:(1-r)/(s+1-r)}}return null}(t,i,c?-1:1);if(!u)return null;const{idx:d,t:_}=u;let p=d>1?Ie(t.slice(0,d),i):[],f=d<t.length?Ie(t.slice(d),i):[];p=p.map((t=>new e.P(De(t.x),t.y))),f=f.map((t=>new e.P(De(t.x),t.y)));const m=[...p];0===m.length&&m.push(f[f.length-1]);const g=e.U(m[m.length-1].y,(0===f.length?p[0]:f[0]).y,_);let v;return v=c?[new e.P(0,g),new e.P(0,0),new e.P(1,0),new e.P(1,g)]:[new e.P(1,g),new e.P(1,1),new e.P(0,1),new e.P(0,g)],m.push(...v),0===f.length?m.push(p[0]):m.push(...f),{polygon:m.map((t=>new e.L(t.x,t.y))),unwrapped:!1}}(t,i);if(o)return o;const r=function(t,i){let o=!1,r=-1/0,s=0;for(let e=0;e<t.length-1;e++)t[e].x>r&&(r=t[e].x,s=e);for(let e=0;e<t.length-1;e++){const i=(s+e)%(t.length-1),r=t[i],n=t[i+1];Math.abs(r.x-n.x)>.5&&(r.x<n.x?(r.x+=1,0===i&&(t[t.length-1].x+=1)):(n.x+=1,i+1===t.length-1&&(t[0].x+=1)),o=!0);}const n=e.a5(i.center.lng);return o&&n<Math.abs(n-1)&&t.forEach((e=>{e.x-=1;})),{polygon:t,unwrapped:o}}(Ie(t,i).map((t=>new e.P(De(t.x),t.y))),i);return {polygon:r.polygon.map((t=>new e.L(t.x,t.y))),unwrapped:r.unwrapped}}}function Ie(t,i){return e.a9(t,(e=>{const t=i.pointCoordinate3D(e);e.x=t.x,e.y=t.y;}),1/256)}function De(e){return e<0?1+e%1:e%1}function Le(e){return 100*e|0}function Ae(t,i,o,r,s){const n=function(o,r){if(o)return s(o);if(r){t.url&&r.tiles&&t.tiles&&delete t.tiles;const o=e.ac(e.e(r,t),["tiles","minzoom","maxzoom","attribution","mapbox_logo","bounds","scheme","tileSize","encoding"]);r.vector_layers&&(o.vectorLayers=r.vector_layers,o.vectorLayerIds=o.vectorLayers.map((e=>e.id))),r.raster_layers&&(o.rasterLayers=r.raster_layers,o.rasterLayerIds=o.rasterLayers.map((e=>e.id))),o.tiles=i.canonicalizeTileset(o,t.url),s(null,o);}};return t.url?e.g(i.transformRequest(i.normalizeSourceURL(t.url,null,o,r),e.R.Source),n):e.f.frame((()=>n(null,t)))}class Re{constructor(t,i,o){this.bounds=e.ad.convert(this.validateBounds(t)),this.minzoom=i||0,this.maxzoom=o||24;}validateBounds(e){return Array.isArray(e)&&4===e.length?[Math.max(-180,e[0]),Math.max(-90,e[1]),Math.min(180,e[2]),Math.min(90,e[3])]:[-180,-90,180,90]}contains(t){const i=Math.pow(2,t.z),o=Math.floor(e.a5(this.bounds.getWest())*i),r=Math.floor(e.ae(this.bounds.getNorth())*i),s=Math.ceil(e.a5(this.bounds.getEast())*i),n=Math.ceil(e.ae(this.bounds.getSouth())*i);return t.x>=o&&t.x<s&&t.y>=r&&t.y<n}}class Pe extends e.E{constructor(t,i,o,r){if(super(),this.id=t,this.dispatcher=o,this.type="vector",this.minzoom=0,this.maxzoom=22,this.scheme="xyz",this.tileSize=512,this.reparseOverscaled=!0,this.isTileClipped=!0,this._loaded=!1,e.e(this,e.ac(i,["url","scheme","tileSize","promoteId"])),this._options=e.e({type:"vector"},i),this._collectResourceTiming=!!i.collectResourceTiming,512!==this.tileSize)throw new Error("vector tile sources must have a tileSize of 512");this.setEventedParent(r),this._tileWorkers={},this._deduped=new e.af;}load(t){this._loaded=!1,this.fire(new e.b("dataloading",{dataType:"source"}));const i=Array.isArray(this.map._language)?this.map._language.join():this.map._language,o=this.map._worldview;this._tileJSONRequest=Ae(this._options,this.map._requestManager,i,o,((r,s)=>{this._tileJSONRequest=null,this._loaded=!0,r?(i&&console.warn(`Ensure that your requested language string is a valid BCP-47 code or list of codes. Found: ${i}`),o&&2!==o.length&&console.warn(`Requested worldview strings must be a valid ISO alpha-2 code. Found: ${o}`),this.fire(new e.a(r))):s&&(e.e(this,s),s.bounds&&(this.tileBounds=new Re(s.bounds,this.minzoom,this.maxzoom)),e.aj(s.tiles,this.map._requestManager._customAccessToken),this.fire(new e.b("data",{dataType:"source",sourceDataType:"metadata"})),this.fire(new e.b("data",{dataType:"source",sourceDataType:"content"}))),t&&t(r);}));}loaded(){return this._loaded}hasTile(e){return !this.tileBounds||this.tileBounds.contains(e.canonical)}onAdd(e){this.map=e,this.load();}reload(){this.cancelTileJSONRequest();const t=e.ag(this.id,this.scope);this.load((()=>this.map.style.clearSource(t)));}setTiles(e){return this._options.tiles=e,this.reload(),this}setUrl(e){return this.url=e,this._options.url=e,this.reload(),this}onRemove(){this.cancelTileJSONRequest();}serialize(){return e.e({},this._options)}loadTile(t,i){const o=this.map._requestManager.normalizeTileURL(t.tileID.canonical.url(this.tiles,this.scheme)),r={request:this.map._requestManager.transformRequest(o,e.R.Tile),data:void 0,uid:t.uid,tileID:t.tileID,tileZoom:t.tileZoom,zoom:t.tileID.overscaledZ,tileSize:this.tileSize*t.tileID.overscaleFactor(),type:this.type,source:this.id,scope:this.scope,pixelRatio:e.f.devicePixelRatio,showCollisionBoxes:this.map.showCollisionBoxes,promoteId:this.promoteId,isSymbolTile:t.isSymbolTile,brightness:this.map.style&&this.map.style.getBrightness()||0,extraShadowCaster:t.isExtraShadowCaster};if(r.request.collectResourceTiming=this._collectResourceTiming,t.actor&&"expired"!==t.state)"loading"===t.state?t.reloadCallback=i:t.request=t.actor.send("reloadTile",r,s.bind(this));else if(t.actor=this._tileWorkers[o]=this._tileWorkers[o]||this.dispatcher.getActor(),this.dispatcher.ready)t.request=t.actor.send("loadTile",r,s.bind(this),void 0,!0);else {const i=e.ah.call({deduped:this._deduped},r,((e,i)=>{e||!i?s.call(this,e):(r.data={cacheControl:i.cacheControl,expires:i.expires,rawData:i.rawData.slice(0)},t.actor&&t.actor.send("loadTile",r,s.bind(this),void 0,!0));}),!0);t.request={cancel:i};}function s(o,r){return delete t.request,t.aborted?i(null):o&&404!==o.status?i(o):(r&&r.resourceTiming&&(t.resourceTiming=r.resourceTiming),this.map._refreshExpiredTiles&&r&&t.setExpiryData(r),t.loadVectorData(r,this.map.painter),e.ai(this.dispatcher),i(null),void(t.reloadCallback&&(this.loadTile(t,t.reloadCallback),t.reloadCallback=null)))}}abortTile(e){e.request&&(e.request.cancel(),delete e.request),e.actor&&e.actor.send("abortTile",{uid:e.uid,type:this.type,source:this.id,scope:this.scope});}unloadTile(e){e.actor&&e.actor.send("removeTile",{uid:e.uid,type:this.type,source:this.id,scope:this.scope}),e.destroy();}hasTransition(){return !1}afterUpdate(){this._tileWorkers={};}cancelTileJSONRequest(){this._tileJSONRequest&&(this._tileJSONRequest.cancel(),this._tileJSONRequest=null);}}class Me extends e.E{constructor(t,i,o,r){super(),this.id=t,this.dispatcher=o,this.setEventedParent(r),this.type="raster",this.minzoom=0,this.maxzoom=22,this.roundZoom=!0,this.scheme="xyz",this.tileSize=512,this._loaded=!1,this._options=e.e({type:"raster"},i),e.e(this,e.ac(i,["url","scheme","tileSize"]));}load(t){this._loaded=!1,this.fire(new e.b("dataloading",{dataType:"source"})),this._tileJSONRequest=Ae(this._options,this.map._requestManager,null,null,((i,o)=>{this._tileJSONRequest=null,this._loaded=!0,i?this.fire(new e.a(i)):o&&(e.e(this,o),o.bounds&&(this.tileBounds=new Re(o.bounds,this.minzoom,this.maxzoom)),e.aj(o.tiles),this.fire(new e.b("data",{dataType:"source",sourceDataType:"metadata"})),this.fire(new e.b("data",{dataType:"source",sourceDataType:"content"}))),t&&t(i);}));}loaded(){return this._loaded}onAdd(e){this.map=e,this.load();}reload(){this.cancelTileJSONRequest();const t=e.ag(this.id,this.scope);this.load((()=>this.map.style.clearSource(t)));}setTiles(e){return this._options.tiles=e,this.reload(),this}setUrl(e){return this.url=e,this._options.url=e,this.reload(),this}onRemove(){this.cancelTileJSONRequest();}serialize(){return e.e({},this._options)}hasTile(e){return !this.tileBounds||this.tileBounds.contains(e.canonical)}loadTile(t,i){const o=e.f.devicePixelRatio>=2,r=this.map._requestManager.normalizeTileURL(t.tileID.canonical.url(this.tiles,this.scheme),o,this.tileSize);t.request=e.d(this.map._requestManager.transformRequest(r,e.R.Tile),((o,r,s,n)=>(delete t.request,t.aborted?(t.state="unloaded",i(null)):o?(t.state="errored",i(o)):r?(this.map._refreshExpiredTiles&&t.setExpiryData({cacheControl:s,expires:n}),t.setTexture(r,this.map.painter),t.state="loaded",e.ai(this.dispatcher),void i(null)):i(null))));}abortTile(e,t){e.request&&(e.request.cancel(),delete e.request),t();}unloadTile(t,i){t.texture&&t.texture instanceof e.T?(t.destroy(!0),t.texture&&t.texture instanceof e.T&&this.map.painter.saveTileTexture(t.texture)):t.destroy(),i();}hasTransition(){return !1}cancelTileJSONRequest(){this._tileJSONRequest&&(this._tileJSONRequest.cancel(),this._tileJSONRequest=null);}}class ze extends Me{constructor(t,i,o,r){super(t,i,o,r),this.type="raster-array",this.maxzoom=22,this._options=e.e({type:"raster-array"},i);}triggerRepaint(e){const t=this.map.painter._terrain,i=this.map.style.getSourceCache(this.id);t&&t.enabled&&i&&t._clearRenderCacheForTile(i.id,e.tileID),this.map.triggerRepaint();}loadTile(t,i){const o=this.map._requestManager.normalizeTileURL(t.tileID.canonical.url(this.tiles,this.scheme),!1,this.tileSize),r=this.map._requestManager.transformRequest(o,e.R.Tile);t.requestParams=r,t.actor||(t.actor=this.dispatcher.getActor()),t.request=t.fetchHeader(void 0,((e,o,r,s)=>{if(delete t.request,t.aborted)return t.state="unloaded",i(null);if(e){if(20===e.code)return;return t.state="errored",i(e)}this.map._refreshExpiredTiles&&t.setExpiryData({cacheControl:r,expires:s}),t.state="empty",i(null);}));}unloadTile(t){const i=t.texture;i&&i instanceof e.T?(t.destroy(!0),this.map.painter.saveTileTexture(i)):(t.destroy(),t.flushQueues(),t._isHeaderLoaded=!1,delete t._mrt,delete t.textureDescriptor),t.fbo&&(t.fbo.destroy(),delete t.fbo),delete t.request,delete t.requestParams,delete t.neighboringTiles,t.state="unloaded";}prepareTile(t,i,o){t._isHeaderLoaded&&("empty"!==t.state&&(t.state="reloading"),t.fetchBand(i,o,((i,o)=>{if(i)return t.state="errored",this.fire(new e.a(i)),void this.triggerRepaint(t);o&&(t.setTexture(o,this.map.painter),t.state="loaded",this.triggerRepaint(t));})));}getInitialBand(e){if(!this.rasterLayers)return 0;const t=this.rasterLayers.find((({id:t})=>t===e)),i=t&&t.fields,o=i&&i.bands&&i.bands;return o?o[0]:0}getTextureDescriptor(t,i,o){if(!t)return;const r=i.sourceLayer||this.rasterLayerIds&&this.rasterLayerIds[0];if(!r)return;let s=null;i instanceof e.an?s=i.paint.get("raster-array-band"):i instanceof e.ao&&(s=i.paint.get("raster-particle-array-band"));const n=s||this.getInitialBand(r);if(null!=n)if(t.textureDescriptor){if(!t.updateNeeded(r,n)||o)return Object.assign({},t.textureDescriptor,{texture:t.texture})}else this.prepareTile(t,r,n);}}const Oe=32,Fe=33,Be=new Uint16Array(8184);for(let e=0;e<2046;e++){let t=e+2,i=0,o=0,r=0,s=0,n=0,a=0;for(1&t?r=s=n=Oe:i=o=a=Oe;(t>>=1)>1;){const e=i+r>>1,l=o+s>>1;1&t?(r=i,s=o,i=n,o=a):(i=r,o=s,r=n,s=a),n=e,a=l;}const l=4*e;Be[l+0]=i,Be[l+1]=o,Be[l+2]=r,Be[l+3]=s;}const ke=new Uint16Array(2178),Ne=new Uint8Array(1089),Ue=new Uint16Array(1089);function Ge(e){return 0===e?-.03125:32===e?.03125:0}class je{constructor(e,t,i,o){this.id=je.uniqueIdxCounter,je.uniqueIdxCounter++,this.context=e;const r=e.gl;this.buffer=r.createBuffer(),this.dynamicDraw=Boolean(i),this.context.unbindVAO(),e.bindElementBuffer.set(this.buffer),r.bufferData(r.ELEMENT_ARRAY_BUFFER,t.arrayBuffer,this.dynamicDraw?r.DYNAMIC_DRAW:r.STATIC_DRAW),this.dynamicDraw||o||t.destroy();}bind(){this.context.bindElementBuffer.set(this.buffer);}updateData(e){this.id=je.uniqueIdxCounter,je.uniqueIdxCounter++;const t=this.context.gl;this.context.unbindVAO(),this.bind(),t.bufferSubData(t.ELEMENT_ARRAY_BUFFER,0,e.arrayBuffer);}destroy(){this.buffer&&(this.context.gl.deleteBuffer(this.buffer),delete this.buffer);}}je.uniqueIdxCounter=0;const Ve={Int8:"BYTE",Uint8:"UNSIGNED_BYTE",Int16:"SHORT",Uint16:"UNSIGNED_SHORT",Int32:"INT",Uint32:"UNSIGNED_INT",Float32:"FLOAT"};class Ze{constructor(e,t,i,o,r,s){this.length=t.length,this.attributes=i,this.itemSize=t.bytesPerElement,this.dynamicDraw=o,this.instanceCount=s,this.context=e;const n=e.gl;this.buffer=n.createBuffer(),e.bindVertexBuffer.set(this.buffer),n.bufferData(n.ARRAY_BUFFER,t.arrayBuffer,this.dynamicDraw?n.DYNAMIC_DRAW:n.STATIC_DRAW),this.dynamicDraw||r||t.destroy();}bind(){this.context.bindVertexBuffer.set(this.buffer);}updateData(e){const t=this.context.gl;this.bind(),t.bufferSubData(t.ARRAY_BUFFER,0,e.arrayBuffer);}enableAttributes(e,t){for(let i=0;i<this.attributes.length;i++){const o=t.attributes[this.attributes[i].name];void 0!==o&&e.enableVertexAttribArray(o);}}setVertexAttribPointers(e,t,i){for(let o=0;o<this.attributes.length;o++){const r=this.attributes[o],s=t.attributes[r.name];void 0!==s&&e.vertexAttribPointer(s,r.components,e[Ve[r.type]],!1,this.itemSize,r.offset+this.itemSize*(i||0));}}setVertexAttribDivisor(e,t,i){for(let o=0;o<this.attributes.length;o++){const r=t.attributes[this.attributes[o].name];void 0!==r&&this.instanceCount&&this.instanceCount>0&&e.vertexAttribDivisor(r,i);}}destroy(){this.buffer&&(this.context.gl.deleteBuffer(this.buffer),delete this.buffer);}}class He{constructor(e){this.gl=e.gl,this.default=this.getDefault(),this.current=this.default,this.dirty=!1;}get(){return this.current}set(e){}getDefault(){return this.default}setDefault(){this.set(this.default);}}class We extends He{getDefault(){return e.ax.transparent}set(e){const t=this.current;(e.r!==t.r||e.g!==t.g||e.b!==t.b||e.a!==t.a||this.dirty)&&(this.gl.clearColor(e.r,e.g,e.b,e.a),this.current=e,this.dirty=!1);}}class qe extends He{getDefault(){return 1}set(e){(e!==this.current||this.dirty)&&(this.gl.clearDepth(e),this.current=e,this.dirty=!1);}}class $e extends He{getDefault(){return 0}set(e){(e!==this.current||this.dirty)&&(this.gl.clearStencil(e),this.current=e,this.dirty=!1);}}class Xe extends He{getDefault(){return [!0,!0,!0,!0]}set(e){const t=this.current;(e[0]!==t[0]||e[1]!==t[1]||e[2]!==t[2]||e[3]!==t[3]||this.dirty)&&(this.gl.colorMask(e[0],e[1],e[2],e[3]),this.current=e,this.dirty=!1);}}class Ke extends He{getDefault(){return !0}set(e){(e!==this.current||this.dirty)&&(this.gl.depthMask(e),this.current=e,this.dirty=!1);}}class Ye extends He{getDefault(){return 255}set(e){(e!==this.current||this.dirty)&&(this.gl.stencilMask(e),this.current=e,this.dirty=!1);}}class Je extends He{getDefault(){return {func:this.gl.ALWAYS,ref:0,mask:255}}set(e){const t=this.current;(e.func!==t.func||e.ref!==t.ref||e.mask!==t.mask||this.dirty)&&(this.gl.stencilFunc(e.func,e.ref,e.mask),this.current=e,this.dirty=!1);}}class Qe extends He{getDefault(){const e=this.gl;return [e.KEEP,e.KEEP,e.KEEP]}set(e){const t=this.current;(e[0]!==t[0]||e[1]!==t[1]||e[2]!==t[2]||this.dirty)&&(this.gl.stencilOp(e[0],e[1],e[2]),this.current=e,this.dirty=!1);}}class et extends He{getDefault(){return !1}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;e?t.enable(t.STENCIL_TEST):t.disable(t.STENCIL_TEST),this.current=e,this.dirty=!1;}}class tt extends He{getDefault(){return [0,1]}set(e){const t=this.current;(e[0]!==t[0]||e[1]!==t[1]||this.dirty)&&(this.gl.depthRange(e[0],e[1]),this.current=e,this.dirty=!1);}}class it extends He{getDefault(){return !1}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;e?t.enable(t.DEPTH_TEST):t.disable(t.DEPTH_TEST),this.current=e,this.dirty=!1;}}class ot extends He{getDefault(){return this.gl.LESS}set(e){(e!==this.current||this.dirty)&&(this.gl.depthFunc(e),this.current=e,this.dirty=!1);}}class rt extends He{getDefault(){return !1}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;e?t.enable(t.BLEND):t.disable(t.BLEND),this.current=e,this.dirty=!1;}}class st extends He{getDefault(){const e=this.gl;return [e.ONE,e.ZERO,e.ONE,e.ZERO]}set(e){const t=this.current;(e[0]!==t[0]||e[1]!==t[1]||e[2]!==t[2]||e[3]!==t[3]||this.dirty)&&(this.gl.blendFuncSeparate(e[0],e[1],e[2],e[3]),this.current=e,this.dirty=!1);}}class nt extends He{getDefault(){return e.ax.transparent}set(e){const t=this.current;(e.r!==t.r||e.g!==t.g||e.b!==t.b||e.a!==t.a||this.dirty)&&(this.gl.blendColor(e.r,e.g,e.b,e.a),this.current=e,this.dirty=!1);}}class at extends He{getDefault(){return this.gl.FUNC_ADD}set(e){(e!==this.current||this.dirty)&&(this.gl.blendEquationSeparate(e,e),this.current=e,this.dirty=!1);}}class lt extends He{getDefault(){return !1}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;e?t.enable(t.CULL_FACE):t.disable(t.CULL_FACE),this.current=e,this.dirty=!1;}}class ct extends He{getDefault(){return this.gl.BACK}set(e){(e!==this.current||this.dirty)&&(this.gl.cullFace(e),this.current=e,this.dirty=!1);}}class ht extends He{getDefault(){return this.gl.CCW}set(e){(e!==this.current||this.dirty)&&(this.gl.frontFace(e),this.current=e,this.dirty=!1);}}let ut=class extends He{getDefault(){return null}set(e){(e!==this.current||this.dirty)&&(this.gl.useProgram(e),this.current=e,this.dirty=!1);}};class dt extends He{getDefault(){return this.gl.TEXTURE0}set(e){(e!==this.current||this.dirty)&&(this.gl.activeTexture(e),this.current=e,this.dirty=!1);}}class _t extends He{getDefault(){const e=this.gl;return [0,0,e.drawingBufferWidth,e.drawingBufferHeight]}set(e){const t=this.current;(e[0]!==t[0]||e[1]!==t[1]||e[2]!==t[2]||e[3]!==t[3]||this.dirty)&&(this.gl.viewport(e[0],e[1],e[2],e[3]),this.current=e,this.dirty=!1);}}class pt extends He{getDefault(){return null}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;t.bindFramebuffer(t.FRAMEBUFFER,e),this.current=e,this.dirty=!1;}}class ft extends He{getDefault(){return null}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;t.bindRenderbuffer(t.RENDERBUFFER,e),this.current=e,this.dirty=!1;}}class mt extends He{getDefault(){return null}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;t.bindTexture(t.TEXTURE_2D,e),this.current=e,this.dirty=!1;}}class gt extends He{getDefault(){return null}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;t.bindBuffer(t.ARRAY_BUFFER,e),this.current=e,this.dirty=!1;}}class vt extends He{getDefault(){return null}set(e){const t=this.gl;t.bindBuffer(t.ELEMENT_ARRAY_BUFFER,e),this.current=e,this.dirty=!1;}}class xt extends He{getDefault(){return null}set(e){this.gl&&(e!==this.current||this.dirty)&&(this.gl.bindVertexArray(e),this.current=e,this.dirty=!1);}}class yt extends He{getDefault(){return 4}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;t.pixelStorei(t.UNPACK_ALIGNMENT,e),this.current=e,this.dirty=!1;}}class bt extends He{getDefault(){return !1}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;t.pixelStorei(t.UNPACK_PREMULTIPLY_ALPHA_WEBGL,e),this.current=e,this.dirty=!1;}}class wt extends He{getDefault(){return !1}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;t.pixelStorei(t.UNPACK_FLIP_Y_WEBGL,e),this.current=e,this.dirty=!1;}}class Tt extends He{constructor(e,t){super(e),this.context=e,this.parent=t;}getDefault(){return null}}class Et extends Tt{setDirty(){this.dirty=!0;}set(e){if(e===this.current&&!this.dirty)return;this.context.bindFramebuffer.set(this.parent);const t=this.gl;t.framebufferTexture2D(t.FRAMEBUFFER,t.COLOR_ATTACHMENT0,t.TEXTURE_2D,e,0),this.current=e,this.dirty=!1;}}class St extends Tt{attachment(){return this.gl.DEPTH_ATTACHMENT}set(e){if(e===this.current&&!this.dirty)return;this.context.bindFramebuffer.set(this.parent);const t=this.gl;t.framebufferRenderbuffer(t.FRAMEBUFFER,this.attachment(),t.RENDERBUFFER,e),this.current=e,this.dirty=!1;}}class Ct extends Tt{attachment(){return this.gl.DEPTH_ATTACHMENT}set(e){if(e===this.current&&!this.dirty)return;this.context.bindFramebuffer.set(this.parent);const t=this.gl;t.framebufferTexture2D(t.FRAMEBUFFER,this.attachment(),t.TEXTURE_2D,e,0),this.current=e,this.dirty=!1;}}class It extends St{attachment(){return this.gl.DEPTH_STENCIL_ATTACHMENT}}class Dt{constructor(e,t,i,o,r){this.context=e,this.width=t,this.height=i;const s=this.framebuffer=e.gl.createFramebuffer();o&&(this.colorAttachment=new Et(e,s)),r&&(this.depthAttachmentType=r,this.depthAttachment="renderbuffer"===r?new St(e,s):new Ct(e,s));}destroy(){const e=this.context.gl;if(this.colorAttachment){const t=this.colorAttachment.get();t&&e.deleteTexture(t);}if(this.depthAttachment&&this.depthAttachmentType)if("renderbuffer"===this.depthAttachmentType){const t=this.depthAttachment.get();t&&e.deleteRenderbuffer(t);}else {const t=this.depthAttachment.get();t&&e.deleteTexture(t);}e.deleteFramebuffer(this.framebuffer);}}class Lt{constructor(e,t,i){this.func=e,this.mask=t,this.range=i;}}Lt.ReadOnly=!1,Lt.ReadWrite=!0,Lt.disabled=new Lt(519,Lt.ReadOnly,[0,1]);const At=7680;class Rt{constructor(e,t,i,o,r,s){this.test=e,this.ref=t,this.mask=i,this.fail=o,this.depthFail=r,this.pass=s;}}Rt.disabled=new Rt({func:519,mask:0},0,0,At,At,At);const Pt=771;class Mt{constructor(e,t,i,o){this.blendFunction=e,this.blendColor=t,this.mask=i,this.blendEquation=o;}}Mt.Replace=[1,0,1,0],Mt.disabled=new Mt(Mt.Replace,e.ax.transparent,[!1,!1,!1,!1]),Mt.unblended=new Mt(Mt.Replace,e.ax.transparent,[!0,!0,!0,!0]),Mt.alphaBlended=new Mt([1,Pt,1,Pt],e.ax.transparent,[!0,!0,!0,!0]),Mt.multiply=new Mt([774,0,774,0],e.ax.transparent,[!0,!0,!0,!0]);const zt=1029,Ot=2305;class Ft{constructor(e,t,i){this.enable=e,this.mode=t,this.frontFace=i;}}Ft.disabled=new Ft(!1,zt,Ot),Ft.backCCW=new Ft(!0,zt,Ot),Ft.backCW=new Ft(!0,zt,2304),Ft.frontCW=new Ft(!0,1028,2304),Ft.frontCCW=new Ft(!0,1028,Ot);class Bt{constructor(e,t){this.gl=e,this.clearColor=new We(this),this.clearDepth=new qe(this),this.clearStencil=new $e(this),this.colorMask=new Xe(this),this.depthMask=new Ke(this),this.stencilMask=new Ye(this),this.stencilFunc=new Je(this),this.stencilOp=new Qe(this),this.stencilTest=new et(this),this.depthRange=new tt(this),this.depthTest=new it(this),this.depthFunc=new ot(this),this.blend=new rt(this),this.blendFunc=new st(this),this.blendColor=new nt(this),this.blendEquation=new at(this),this.cullFace=new lt(this),this.cullFaceSide=new ct(this),this.frontFace=new ht(this),this.program=new ut(this),this.activeTexture=new dt(this),this.viewport=new _t(this),this.bindFramebuffer=new pt(this),this.bindRenderbuffer=new ft(this),this.bindTexture=new mt(this),this.bindVertexBuffer=new gt(this),this.bindElementBuffer=new vt(this),this.bindVertexArrayOES=new xt(this),this.pixelStoreUnpack=new yt(this),this.pixelStoreUnpackPremultiplyAlpha=new bt(this),this.pixelStoreUnpackFlipY=new wt(this),this.options=t?{...t}:{},this.options.extTextureFilterAnisotropicForceOff||(this.extTextureFilterAnisotropic=e.getExtension("EXT_texture_filter_anisotropic")||e.getExtension("MOZ_EXT_texture_filter_anisotropic")||e.getExtension("WEBKIT_EXT_texture_filter_anisotropic"),this.extTextureFilterAnisotropic&&(this.extTextureFilterAnisotropicMax=e.getParameter(this.extTextureFilterAnisotropic.MAX_TEXTURE_MAX_ANISOTROPY_EXT))),this.extDebugRendererInfo=e.getExtension("WEBGL_debug_renderer_info"),this.extDebugRendererInfo&&(this.renderer=e.getParameter(this.extDebugRendererInfo.UNMASKED_RENDERER_WEBGL),this.vendor=e.getParameter(this.extDebugRendererInfo.UNMASKED_VENDOR_WEBGL)),this.options.extTextureFloatLinearForceOff||(this.extTextureFloatLinear=e.getExtension("OES_texture_float_linear")),this.extRenderToTextureHalfFloat=e.getExtension("EXT_color_buffer_half_float"),this.extTimerQuery=e.getExtension("EXT_disjoint_timer_query_webgl2"),this.maxTextureSize=e.getParameter(e.MAX_TEXTURE_SIZE),this.maxPointSize=e.getParameter(e.ALIASED_POINT_SIZE_RANGE)[1];}setDefault(){this.unbindVAO(),this.clearColor.setDefault(),this.clearDepth.setDefault(),this.clearStencil.setDefault(),this.colorMask.setDefault(),this.depthMask.setDefault(),this.stencilMask.setDefault(),this.stencilFunc.setDefault(),this.stencilOp.setDefault(),this.stencilTest.setDefault(),this.depthRange.setDefault(),this.depthTest.setDefault(),this.depthFunc.setDefault(),this.blend.setDefault(),this.blendFunc.setDefault(),this.blendColor.setDefault(),this.blendEquation.setDefault(),this.cullFace.setDefault(),this.cullFaceSide.setDefault(),this.frontFace.setDefault(),this.program.setDefault(),this.activeTexture.setDefault(),this.bindFramebuffer.setDefault(),this.pixelStoreUnpack.setDefault(),this.pixelStoreUnpackPremultiplyAlpha.setDefault(),this.pixelStoreUnpackFlipY.setDefault();}setDirty(){this.clearColor.dirty=!0,this.clearDepth.dirty=!0,this.clearStencil.dirty=!0,this.colorMask.dirty=!0,this.depthMask.dirty=!0,this.stencilMask.dirty=!0,this.stencilFunc.dirty=!0,this.stencilOp.dirty=!0,this.stencilTest.dirty=!0,this.depthRange.dirty=!0,this.depthTest.dirty=!0,this.depthFunc.dirty=!0,this.blend.dirty=!0,this.blendFunc.dirty=!0,this.blendColor.dirty=!0,this.blendEquation.dirty=!0,this.cullFace.dirty=!0,this.cullFaceSide.dirty=!0,this.frontFace.dirty=!0,this.program.dirty=!0,this.activeTexture.dirty=!0,this.viewport.dirty=!0,this.bindFramebuffer.dirty=!0,this.bindRenderbuffer.dirty=!0,this.bindTexture.dirty=!0,this.bindVertexBuffer.dirty=!0,this.bindElementBuffer.dirty=!0,this.bindVertexArrayOES.dirty=!0,this.pixelStoreUnpack.dirty=!0,this.pixelStoreUnpackPremultiplyAlpha.dirty=!0,this.pixelStoreUnpackFlipY.dirty=!0;}createIndexBuffer(e,t,i){return new je(this,e,t,i)}createVertexBuffer(e,t,i,o,r){return new Ze(this,e,t,i,o,r)}createRenderbuffer(e,t,i){const o=this.gl,r=o.createRenderbuffer();return this.bindRenderbuffer.set(r),o.renderbufferStorage(o.RENDERBUFFER,e,t,i),this.bindRenderbuffer.set(null),r}createFramebuffer(e,t,i,o){return new Dt(this,e,t,i,o)}clear({color:e,depth:t,stencil:i,colorMask:o}){const r=this.gl;let s=0;e&&(s|=r.COLOR_BUFFER_BIT,this.clearColor.set(e),this.colorMask.set(o||[!0,!0,!0,!0])),void 0!==t&&(s|=r.DEPTH_BUFFER_BIT,this.depthRange.set([0,1]),this.clearDepth.set(t),this.depthMask.set(!0)),void 0!==i&&(s|=r.STENCIL_BUFFER_BIT,this.clearStencil.set(i),this.stencilMask.set(255)),r.clear(s);}setCullFace(e){!1===e.enable?this.cullFace.set(!1):(this.cullFace.set(!0),this.cullFaceSide.set(e.mode),this.frontFace.set(e.frontFace));}setDepthMode(e){e.func!==this.gl.ALWAYS||e.mask?(this.depthTest.set(!0),this.depthFunc.set(e.func),this.depthMask.set(e.mask),this.depthRange.set(e.range)):this.depthTest.set(!1);}setStencilMode(e){e.test.func!==this.gl.ALWAYS||e.mask?(this.stencilTest.set(!0),this.stencilMask.set(e.mask),this.stencilOp.set([e.fail,e.depthFail,e.pass]),this.stencilFunc.set({func:e.test.func,ref:e.ref,mask:e.test.mask})):this.stencilTest.set(!1);}setColorMode(e){t(e.blendFunction,Mt.Replace)?this.blend.set(!1):(this.blend.set(!0),this.blendFunc.set(e.blendFunction),this.blendColor.set(e.blendColor),e.blendEquation?this.blendEquation.set(e.blendEquation):this.blendEquation.setDefault()),this.colorMask.set(e.mask);}unbindVAO(){this.bindVertexArrayOES.set(null);}}var kt=e.ay([{name:"a_pos",type:"Float32",components:3}]);class Nt{constructor(t,i,o,r){const s={width:o[0],height:o[1],data:null},n=t.gl;this.targetColorTexture=new e.T(t,s,n.RGBA,{useMipmap:!1}),this.backgroundColorTexture=new e.T(t,s,n.RGBA,{useMipmap:!1}),this.context=t,this.setNumParticles(i,r),this.lastInvalidatedAt=0;}setNumParticles(t,i){if(this.numParticles===i)return;(this.particleVertices0||this.particleVertices1||this.particleSegment)&&(this.particleVertices0.destroy(),this.particleVertices1.destroy(),this.particleSegment.destroy());const o=new e.az;o.reserve(Math.round(i));const r=e.aA(t.key);for(let e=0;e<i;e++)o.emplaceBack(r(),r(),r());this.particleVertices0=this.context.createVertexBuffer(o,kt.members,!0),this.particleVertices1=this.context.createVertexBuffer(o,kt.members,!0),this.particleSegment=e.aB.simpleSegment(0,0,this.particleVertices0.length,0),this.numParticles=i;}update(t){return !(this.lastInvalidatedAt<t&&(this.lastInvalidatedAt=e.f.now(),1))}destroy(){this.targetColorTexture.destroy(),this.backgroundColorTexture.destroy(),this.particleVertices0.destroy(),this.particleVertices1.destroy(),this.particleSegment.destroy();}}const Ut={type:2,extent:e.V,loadGeometry:()=>[[new e.P(0,0),new e.P(e.V+1,0),new e.P(e.V+1,e.V+1),new e.P(0,e.V+1),new e.P(0,0)]]};class Gt{constructor(t,i,o,r,s){this.tileID=t,this.uid=e.aC(),this.uses=0,this.tileSize=i,this.tileZoom=o,this.buckets={},this.expirationTime=null,this.queryPadding=0,this.hasSymbolBuckets=!1,this.hasRTLText=!1,this.dependencies={},this.isRaster=s,r&&r.style&&(this._lastUpdatedBrightness=r.style.getBrightness()),this.expiredRequestCount=0,this.state="loading",r&&r.transform&&(this.projection=r.transform.projection);}registerFadeDuration(t){const i=t+this.timeAdded;i<e.f.now()||this.fadeEndTime&&i<this.fadeEndTime||(this.fadeEndTime=i);}wasRequested(){return "errored"===this.state||"loaded"===this.state||"reloading"===this.state}get tileTransform(){return this._tileTransform||(this._tileTransform=e.as(this.tileID.canonical,this.projection)),this._tileTransform}loadVectorData(t,i,o){if(this.unloadVectorData(),this.state="loaded",t){t.featureIndex&&(this.latestFeatureIndex=t.featureIndex,t.rawTileData?(this.latestRawTileData=t.rawTileData,this.latestFeatureIndex.rawTileData=t.rawTileData):this.latestRawTileData&&(this.latestFeatureIndex.rawTileData=this.latestRawTileData)),this.collisionBoxArray=t.collisionBoxArray,this.buckets=function(e,t){const i={};if(!t)return i;for(const o of e){const e=o.layerIds.map((e=>t.getLayer(e))).filter(Boolean);if(0!==e.length){o.layers=e,o.stateDependentLayerIds&&(o.stateDependentLayers=o.stateDependentLayerIds.map((t=>e.filter((e=>e.id===t))[0])));for(const t of e)i[t.fqid]=o;}}return i}(t.buckets,i.style),this.hasSymbolBuckets=!1;for(const t in this.buckets){const i=this.buckets[t];if(i instanceof e.aE){if(this.hasSymbolBuckets=!0,!o)break;i.justReloaded=!0;}}if(this.hasRTLText=!1,this.hasSymbolBuckets)for(const t in this.buckets){const i=this.buckets[t];if(i instanceof e.aE&&i.hasRTLText){this.hasRTLText=!0,e.aF();break}}this.queryPadding=0;for(const e in this.buckets){const t=this.buckets[e],o=i.style.getOwnLayer(e);if(!o)continue;const r=o.queryRadius(t);this.queryPadding=Math.max(this.queryPadding,r);}t.imageAtlas&&(this.imageAtlas=t.imageAtlas),t.glyphAtlasImage&&(this.glyphAtlasImage=t.glyphAtlasImage),t.lineAtlas&&(this.lineAtlas=t.lineAtlas),this._lastUpdatedBrightness=t.brightness;}else this.collisionBoxArray=new e.aD;}unloadVectorData(){if(this.hasData()){for(const e in this.buckets)this.buckets[e].destroy();this.buckets={},this.imageAtlas&&(this.imageAtlas=null),this.lineAtlas&&(this.lineAtlas=null),this.imageAtlasTexture&&this.imageAtlasTexture.destroy(),this.glyphAtlasTexture&&this.glyphAtlasTexture.destroy(),this.lineAtlasTexture&&this.lineAtlasTexture.destroy(),this._tileBoundsBuffer&&(this._tileBoundsBuffer.destroy(),this._tileBoundsIndexBuffer.destroy(),this._tileBoundsSegments.destroy(),this._tileBoundsBuffer=null),this._tileDebugBuffer&&(this._tileDebugBuffer.destroy(),this._tileDebugSegments.destroy(),this._tileDebugBuffer=null),this._tileDebugIndexBuffer&&(this._tileDebugIndexBuffer.destroy(),this._tileDebugIndexBuffer=null),this._globeTileDebugBorderBuffer&&(this._globeTileDebugBorderBuffer.destroy(),this._globeTileDebugBorderBuffer=null),this._tileDebugTextBuffer&&(this._tileDebugTextBuffer.destroy(),this._tileDebugTextSegments.destroy(),this._tileDebugTextIndexBuffer.destroy(),this._tileDebugTextBuffer=null),this._globeTileDebugTextBuffer&&(this._globeTileDebugTextBuffer.destroy(),this._globeTileDebugTextBuffer=null),this.latestFeatureIndex=null,this.state="unloaded";}}getBucket(e){return this.buckets[e.fqid]}upload(t){for(const e in this.buckets){const i=this.buckets[e];i.uploadPending()&&i.upload(t);}const i=t.gl,o=this.imageAtlas;if(o&&!o.uploaded){const r=!!Object.keys(o.patternPositions).length;this.imageAtlasTexture=new e.T(t,o.image,i.RGBA,{useMipmap:r}),this.imageAtlas.uploaded=!0;}this.glyphAtlasImage&&(this.glyphAtlasTexture=new e.T(t,this.glyphAtlasImage,i.R8),this.glyphAtlasImage=null),this.lineAtlas&&!this.lineAtlas.uploaded&&(this.lineAtlasTexture=new e.T(t,this.lineAtlas.image,i.R8),this.lineAtlas.uploaded=!0);}prepare(e,t,i){if(this.imageAtlas&&this.imageAtlasTexture&&this.imageAtlas.patchUpdatedImages(e,this.imageAtlasTexture,i),!t||!this.latestFeatureIndex||!this.latestFeatureIndex.rawTileData)return;const o=t.style.getBrightness();(this._lastUpdatedBrightness||o)&&(this._lastUpdatedBrightness&&o&&Math.abs(this._lastUpdatedBrightness-o)<.001||(this._lastUpdatedBrightness=o,this.updateBuckets(void 0,t)));}queryRenderedFeatures(e,t,i,o,r,s,n,a){return this.latestFeatureIndex&&(this.latestFeatureIndex.rawTileData||this.latestFeatureIndex.is3DTile)?this.latestFeatureIndex.query({tileResult:o,pixelPosMatrix:n,transform:s,params:r,tileTransform:this.tileTransform},e,t,i):{}}querySourceFeatures(t,i){const o=this.latestFeatureIndex;if(!o||!o.rawTileData)return;const r=o.loadVTLayers(),s=i?i.sourceLayer:"",n=r._geojsonTileLayer||r[s];if(!n)return;const a=e.aG(i&&i.filter),{z:l,x:c,y:h}=this.tileID.canonical,u={z:l,x:c,y:h};for(let i=0;i<n.length;i++){const r=n.feature(i);if(a.needGeometry){const t=e.aH(r,!0);if(!a.filter(new e.K(this.tileID.overscaledZ),t,this.tileID.canonical))continue}else if(!a.filter(new e.K(this.tileID.overscaledZ),r))continue;const d=o.getId(r,s),_=new e.aI(r,l,c,h,d);_.tile=u,t.push(_);}}hasData(){return "loaded"===this.state||"reloading"===this.state||"expired"===this.state}bucketsLoaded(){for(const e in this.buckets)if(this.buckets[e].uploadPending())return !1;return !0}patternsLoaded(){return !!this.imageAtlas&&!!Object.keys(this.imageAtlas.patternPositions).length}setExpiryData(t){const i=this.expirationTime;if(t.cacheControl){const i=e.aJ(t.cacheControl);i["max-age"]&&(this.expirationTime=Date.now()+1e3*i["max-age"]);}else t.expires&&(this.expirationTime=new Date(t.expires).getTime());if(this.expirationTime){const e=Date.now();let t=!1;if(this.expirationTime>e)t=!1;else if(i)if(this.expirationTime<i)t=!0;else {const o=this.expirationTime-i;o?this.expirationTime=e+Math.max(o,3e4):t=!0;}else t=!0;t?(this.expiredRequestCount++,this.state="expired"):this.expiredRequestCount=0;}}getExpiryTimeout(){if(this.expirationTime)return this.expiredRequestCount?1e3*(1<<Math.min(this.expiredRequestCount-1,31)):Math.min(this.expirationTime-(new Date).getTime(),Math.pow(2,31)-1)}setFeatureState(e,t){this.latestFeatureIndex&&this.latestFeatureIndex.rawTileData&&0!==Object.keys(e).length&&t&&this.updateBuckets(e,t);}updateBuckets(t,i){if(!this.latestFeatureIndex)return;const o=this.latestFeatureIndex.loadVTLayers(),r=i.style.listImages(),s=i.style.getBrightness();for(const n in this.buckets){if(!i.style.hasLayer(n))continue;const a=this.buckets[n],l=a.layers[0].sourceLayer||"_geojsonTileLayer",c=o[l];let h={};if(t&&(h=t[l],!c||!h||0===Object.keys(h).length))continue;if(a.update(h,c,r,this.imageAtlas&&this.imageAtlas.patternPositions||{},s),a instanceof e.aK||a instanceof e.aL){const e=i.style.getOwnSourceCache(a.layers[0].source);i._terrain&&i._terrain.enabled&&e&&a.programConfigurations.needsUpload&&i._terrain._clearRenderCacheForTile(e.id,this.tileID);}const u=i&&i.style&&i.style.getOwnLayer(n);u&&(this.queryPadding=Math.max(this.queryPadding,u.queryRadius(a)));}}holdingForFade(){return void 0!==this.symbolFadeHoldUntil}symbolFadeFinished(){return !this.symbolFadeHoldUntil||this.symbolFadeHoldUntil<e.f.now()}clearFadeHold(){this.symbolFadeHoldUntil=void 0;}setHoldDuration(t){this.symbolFadeHoldUntil=e.f.now()+t;}setTexture(t,i){const o=i.context,r=o.gl;this.texture=this.texture||i.getTileTexture(t.width),this.texture&&this.texture instanceof e.T?this.texture.update(t,{useMipmap:!0}):(this.texture=new e.T(o,t,r.RGBA,{useMipmap:!0}),this.texture.bind(r.LINEAR,r.CLAMP_TO_EDGE));}setDependencies(e,t){const i={};for(const e of t)i[e]=!0;this.dependencies[e]=i;}hasDependency(e,t){for(const i of e){const e=this.dependencies[i];if(e)for(const i of t)if(e[i])return !0}return !1}clearQueryDebugViz(){}_makeDebugTileBoundsBuffers(t,i){if(!i||"mercator"===i.name||this._tileDebugBuffer)return;const o=e.aM(Ut,this.tileID.canonical,this.tileTransform)[0],r=new e.aN,s=new e.aO;for(let e=0;e<o.length;e++){const{x:t,y:i}=o[e];r.emplaceBack(t,i),s.emplaceBack(e);}s.emplaceBack(0),this._tileDebugIndexBuffer=t.createIndexBuffer(s),this._tileDebugBuffer=t.createVertexBuffer(r,e.aP.members),this._tileDebugSegments=e.aB.simpleSegment(0,0,r.length,s.length);}_makeTileBoundsBuffers(t,i){if(this._tileBoundsBuffer||!i||"mercator"===i.name)return;const o=e.aM(Ut,this.tileID.canonical,this.tileTransform)[0];let r,s;if(this.isRaster){const t=function(t,i){const o=e.as(t,i),r=Math.pow(2,t.z);for(let s=0;s<Fe;s++)for(let n=0;n<Fe;n++){const a=e.at((t.x+(n+Ge(n))/Oe)/r),l=e.au((t.y+(s+Ge(s))/Oe)/r),c=i.project(a,l),h=s*Fe+n;ke[2*h+0]=Math.round((c.x*o.scale-o.x)*e.V),ke[2*h+1]=Math.round((c.y*o.scale-o.y)*e.V);}Ne.fill(0),Ue.fill(0);for(let e=2045;e>=0;e--){const t=4*e,i=Be[t+0],o=Be[t+1],r=Be[t+2],s=Be[t+3],n=i+r>>1,a=o+s>>1,l=n+a-o,c=a+i-n,h=o*Fe+i,u=s*Fe+r,d=a*Fe+n,_=Math.hypot((ke[2*h+0]+ke[2*u+0])/2-ke[2*d+0],(ke[2*h+1]+ke[2*u+1])/2-ke[2*d+1])>=16;Ne[d]=Ne[d]||(_?1:0),e<1022&&(Ne[d]=Ne[d]||Ne[(o+c>>1)*Fe+(i+l>>1)]||Ne[(s+c>>1)*Fe+(r+l>>1)]);}const s=new e.av,n=new e.aw;let a=0;function l(t,i){const o=i*Fe+t;return 0===Ue[o]&&(s.emplaceBack(ke[2*o+0],ke[2*o+1],t*e.V/Oe,i*e.V/Oe),Ue[o]=++a),Ue[o]-1}function c(e,t,i,o,r,s){const a=e+i>>1,h=t+o>>1;if(Math.abs(e-r)+Math.abs(t-s)>1&&Ne[h*Fe+a])c(r,s,e,t,a,h),c(i,o,r,s,a,h);else {const a=l(e,t),c=l(i,o),h=l(r,s);n.emplaceBack(a,c,h);}}return c(0,0,Oe,Oe,Oe,0),c(Oe,Oe,0,0,0,Oe),{vertices:s,indices:n}}(this.tileID.canonical,i);r=t.vertices,s=t.indices;}else {r=new e.av,s=new e.aw;for(const{x:e,y:t}of o)r.emplaceBack(e,t,0,0);const t=e.aQ(r.int16,void 0,4);for(let e=0;e<t.length;e+=3)s.emplaceBack(t[e],t[e+1],t[e+2]);}this._tileBoundsBuffer=t.createVertexBuffer(r,e.aR.members),this._tileBoundsIndexBuffer=t.createIndexBuffer(s),this._tileBoundsSegments=e.aB.simpleSegment(0,0,r.length,s.length);}_makeGlobeTileDebugBuffers(t,i){const o=i.projection;if(!o||"globe"!==o.name||i.freezeTileCoverage)return;const r=this.tileID.canonical,s=e.aS(r,i),n=e.aT(s),a=e.S(i.zoom);let l;a>0&&(l=e.a6.invert(new Float64Array(16),i.globeMatrix)),this._makeGlobeTileDebugBorderBuffer(t,r,i,n,l,a),this._makeGlobeTileDebugTextBuffer(t,r,i,n,l,a);}_globePoint(t,i,o,r,s,n,a){let l=e.aU(t,i,o);if(n){const s=1<<o.z,c=e.a5(r.center.lng),h=e.ae(r.center.lat),u=(o.x+.5)/s-c;let d=0;u>.5?d=-1:u<-.5&&(d=1);let _=(t/e.V+o.x)/s+d,p=(i/e.V+o.y)/s;_=(_-c)*r._pixelsPerMercatorPixel+c,p=(p-h)*r._pixelsPerMercatorPixel+h;const f=[_*r.worldSize,p*r.worldSize,0];e.N.transformMat4(f,f,n),l=e.aV(l,f,a);}return e.N.transformMat4(l,l,s)}_makeGlobeTileDebugBorderBuffer(t,i,o,r,s,n){const a=new e.aN,l=new e.aO,c=new e.aW,h=(e,t,h,u,d)=>{const _=(h-e)/(d-1),p=(u-t)/(d-1),f=a.length;for(let h=0;h<d;h++){const u=e+h*_,d=t+h*p;a.emplaceBack(u,d);const m=this._globePoint(u,d,i,o,r,s,n);c.emplaceBack(m[0],m[1],m[2]),l.emplaceBack(f+h);}},u=e.V;h(0,0,u,0,16),h(u,0,u,u,16),h(u,u,0,u,16),h(0,u,0,0,16),this._tileDebugIndexBuffer=t.createIndexBuffer(l),this._tileDebugBuffer=t.createVertexBuffer(a,e.aP.members),this._globeTileDebugBorderBuffer=t.createVertexBuffer(c,e.aX.members),this._tileDebugSegments=e.aB.simpleSegment(0,0,a.length,l.length);}_makeGlobeTileDebugTextBuffer(t,i,o,r,s,n){const a=e.V/4,l=new e.aN,c=new e.aw,h=new e.aW,u=25;c.reserve(32),l.reserve(u),h.reserve(u);const d=(e,t)=>u*e+t;for(let e=0;e<u;e++){const t=e*a;for(let e=0;e<u;e++){const c=e*a;l.emplaceBack(c,t);const u=this._globePoint(c,t,i,o,r,s,n);h.emplaceBack(u[0],u[1],u[2]);}}for(let e=0;e<4;e++)for(let t=0;t<4;t++){const i=d(e,t),o=d(e,t+1),r=d(e+1,t),s=d(e+1,t+1);c.emplaceBack(i,o,r),c.emplaceBack(r,o,s);}this._tileDebugTextIndexBuffer=t.createIndexBuffer(c),this._tileDebugTextBuffer=t.createVertexBuffer(l,e.aP.members),this._globeTileDebugTextBuffer=t.createVertexBuffer(h,e.aX.members),this._tileDebugTextSegments=e.aB.simpleSegment(0,0,u,32);}destroy(t=!1){for(const e in this.buckets)this.buckets[e].destroy();this.buckets={},this.imageAtlas&&(this.imageAtlas=null),this.lineAtlas&&(this.lineAtlas=null),this.imageAtlasTexture&&(this.imageAtlasTexture.destroy(),delete this.imageAtlasTexture),this.glyphAtlasTexture&&(this.glyphAtlasTexture.destroy(),delete this.glyphAtlasTexture),this.lineAtlasTexture&&(this.lineAtlasTexture.destroy(),delete this.lineAtlasTexture),this._tileBoundsBuffer&&(this._tileBoundsBuffer.destroy(),this._tileBoundsIndexBuffer.destroy(),this._tileBoundsSegments.destroy(),this._tileBoundsBuffer=null),this._tileDebugBuffer&&(this._tileDebugBuffer.destroy(),this._tileDebugSegments.destroy(),this._tileDebugBuffer=null),this._tileDebugIndexBuffer&&(this._tileDebugIndexBuffer.destroy(),this._tileDebugIndexBuffer=null),this._globeTileDebugBorderBuffer&&(this._globeTileDebugBorderBuffer.destroy(),this._globeTileDebugBorderBuffer=null),this._tileDebugTextBuffer&&(this._tileDebugTextBuffer.destroy(),this._tileDebugTextSegments.destroy(),this._tileDebugTextIndexBuffer.destroy(),this._tileDebugTextBuffer=null),this._globeTileDebugTextBuffer&&(this._globeTileDebugTextBuffer.destroy(),this._globeTileDebugTextBuffer=null),!t&&this.texture&&this.texture instanceof e.T&&(this.texture.destroy(),delete this.texture),this.hillshadeFBO&&(this.hillshadeFBO.destroy(),delete this.hillshadeFBO),this.dem&&delete this.dem,this.neighboringTiles&&delete this.neighboringTiles,this.demTexture&&(this.demTexture.destroy(),delete this.demTexture),this.rasterParticleState&&(this.rasterParticleState.destroy(),delete this.rasterParticleState),this.latestFeatureIndex=null,this.state="unloaded";}}const jt={vector:Pe,raster:Me,"raster-dem":class extends Me{constructor(t,i,o,r){super(t,i,o,r),this.type="raster-dem",this.maxzoom=22,this._options=e.e({type:"raster-dem"},i),this.encoding=i.encoding||"mapbox";}loadTile(t,i){const o=this.map._requestManager.normalizeTileURL(t.tileID.canonical.url(this.tiles,this.scheme),!1,this.tileSize);function r(e,o){e&&(t.state="errored",i(e)),o&&(t.dem=o,t.dem.onDeserialize(),t.needsHillshadePrepare=!0,t.needsDEMTextureUpload=!0,t.state="loaded",i(null));}t.request=e.d(this.map._requestManager.transformRequest(o,e.R.Tile),function(o,s,n,a){if(delete t.request,t.aborted)t.state="unloaded",i(null);else if(o)t.state="errored",i(o);else if(s){this.map._refreshExpiredTiles&&t.setExpiryData({cacheControl:n,expires:a});const i=ImageBitmap&&s instanceof ImageBitmap&&e.ak(),o=1-(s.width-e.al(s.width))/2;o<1||t.neighboringTiles||(t.neighboringTiles=this._getNeighboringTiles(t.tileID));const l=i?s:e.f.getImageData(s,o),c={uid:t.uid,coord:t.tileID,source:this.id,scope:this.scope,rawImageData:l,encoding:this.encoding,padding:o};t.actor&&"expired"!==t.state||(t.actor=this.dispatcher.getActor(),t.actor.send("loadDEMTile",c,r.bind(this),void 0,!0));}}.bind(this));}_getNeighboringTiles(t){const i=t.canonical,o=Math.pow(2,i.z),r=(i.x-1+o)%o,s=0===i.x?t.wrap-1:t.wrap,n=(i.x+1+o)%o,a=i.x+1===o?t.wrap+1:t.wrap,l={};return l[new e.am(t.overscaledZ,s,i.z,r,i.y).key]={backfilled:!1},l[new e.am(t.overscaledZ,a,i.z,n,i.y).key]={backfilled:!1},i.y>0&&(l[new e.am(t.overscaledZ,s,i.z,r,i.y-1).key]={backfilled:!1},l[new e.am(t.overscaledZ,t.wrap,i.z,i.x,i.y-1).key]={backfilled:!1},l[new e.am(t.overscaledZ,a,i.z,n,i.y-1).key]={backfilled:!1}),i.y+1<o&&(l[new e.am(t.overscaledZ,s,i.z,r,i.y+1).key]={backfilled:!1},l[new e.am(t.overscaledZ,t.wrap,i.z,i.x,i.y+1).key]={backfilled:!1},l[new e.am(t.overscaledZ,a,i.z,n,i.y+1).key]={backfilled:!1}),l}},"raster-array":ze,geojson:class extends e.E{constructor(t,i,o,r){super(),this.id=t,this.type="geojson",this.minzoom=0,this.maxzoom=18,this.tileSize=512,this.isTileClipped=!0,this.reparseOverscaled=!0,this._loaded=!1,this.actor=o.getActor(),this.setEventedParent(r),this._data=i.data,this._options=e.e({},i),this._collectResourceTiming=i.collectResourceTiming,void 0!==i.maxzoom&&(this.maxzoom=i.maxzoom),i.type&&(this.type=i.type),i.attribution&&(this.attribution=i.attribution),this.promoteId=i.promoteId;const s=e.V/this.tileSize;this.workerOptions=e.e({source:this.id,scope:this.scope,cluster:i.cluster||!1,geojsonVtOptions:{buffer:(void 0!==i.buffer?i.buffer:128)*s,tolerance:(void 0!==i.tolerance?i.tolerance:.375)*s,extent:e.V,maxZoom:this.maxzoom,lineMetrics:i.lineMetrics||!1,generateId:i.generateId||!1},superclusterOptions:{maxZoom:void 0!==i.clusterMaxZoom?i.clusterMaxZoom:this.maxzoom-1,minPoints:Math.max(2,i.clusterMinPoints||2),extent:e.V,radius:(void 0!==i.clusterRadius?i.clusterRadius:50)*s,log:!1,generateId:i.generateId||!1},clusterProperties:i.clusterProperties,filter:i.filter},i.workerOptions);}onAdd(e){this.map=e,this.setData(this._data);}setData(e){return this._data=e,this._updateWorkerData(),this}getClusterExpansionZoom(e,t){return this.actor.send("geojson.getClusterExpansionZoom",{clusterId:e,source:this.id,scope:this.scope},t),this}getClusterChildren(e,t){return this.actor.send("geojson.getClusterChildren",{clusterId:e,source:this.id,scope:this.scope},t),this}getClusterLeaves(e,t,i,o){return this.actor.send("geojson.getClusterLeaves",{source:this.id,scope:this.scope,clusterId:e,limit:t,offset:i},o),this}_updateWorkerData(){if(this._pendingLoad)return void(this._coalesce=!0);this.fire(new e.b("dataloading",{dataType:"source"})),this._loaded=!1;const t=e.e({},this.workerOptions);t.scope=this.scope;const i=this._data;"string"==typeof i?(t.request=this.map._requestManager.transformRequest(e.f.resolveURL(i),e.R.Source),t.request.collectResourceTiming=this._collectResourceTiming):t.data=JSON.stringify(i),this._pendingLoad=this.actor.send(`${this.type}.loadData`,t,((t,i)=>{if(this._loaded=!0,this._pendingLoad=null,t)this.fire(new e.a(t));else {const t={dataType:"source",sourceDataType:this._metadataFired?"content":"metadata"};this._collectResourceTiming&&i&&i.resourceTiming&&i.resourceTiming[this.id]&&(t.resourceTiming=i.resourceTiming[this.id]),this.fire(new e.b("data",t)),this._metadataFired=!0;}this._coalesce&&(this._updateWorkerData(),this._coalesce=!1);}));}loaded(){return this._loaded}loadTile(t,i){const o=t.actor?"reloadTile":"loadTile";t.actor=this.actor;const r={type:this.type,uid:t.uid,tileID:t.tileID,tileZoom:t.tileZoom,zoom:t.tileID.overscaledZ,maxZoom:this.maxzoom,tileSize:this.tileSize,source:this.id,scope:this.scope,pixelRatio:e.f.devicePixelRatio,showCollisionBoxes:this.map.showCollisionBoxes,promoteId:this.promoteId,brightness:this.map.style&&this.map.style.getBrightness()||0};t.request=this.actor.send(o,r,((e,r)=>(delete t.request,t.destroy(),t.aborted?i(null):e?i(e):(t.loadVectorData(r,this.map.painter,"reloadTile"===o),i(null)))),void 0,"loadTile"===o);}abortTile(e){e.request&&(e.request.cancel(),delete e.request),e.aborted=!0;}unloadTile(e){this.actor.send("removeTile",{uid:e.uid,type:this.type,source:this.id,scope:this.scope}),e.destroy();}onRemove(){this._pendingLoad&&this._pendingLoad.cancel();}serialize(){return e.e({},this._options,{type:this.type,data:this._data})}hasTransition(){return !1}},video:class extends e.ap{constructor(e,t,i,o){super(e,t,i,o),this.roundZoom=!0,this.type="video",this.options=t;}load(){this._loaded=!1;const t=this.options;this.urls=[];for(const i of t.urls)this.urls.push(this.map._requestManager.transformRequest(i,e.R.Source).url);e.aq(this.urls,((t,i)=>{this._loaded=!0,t?this.fire(new e.a(t)):i&&(this.video=i,this.video.loop=!0,this.video.setAttribute("playsinline",""),this.video.addEventListener("playing",(()=>{this.map.triggerRepaint();})),this.map&&this.video.play(),this._finishLoading());}));}pause(){this.video&&this.video.pause();}play(){this.video&&this.video.play();}seek(t){if(this.video){const i=this.video.seekable;t<i.start(0)||t>i.end(0)?this.fire(new e.a(new T(`sources.${this.id}`,null,`Playback for this video can be set only between the ${i.start(0)} and ${i.end(0)}-second mark.`))):this.video.currentTime=t;}}getVideo(){return this.video}onAdd(e){this.map||(this.map=e,this.load(),this.video&&(this.video.play(),this.setCoordinates(this.coordinates)));}prepare(){if(0===Object.keys(this.tiles).length||this.video.readyState<2)return;const t=this.map.painter.context,i=t.gl;this.texture?this.video.paused||(this.texture.bind(i.LINEAR,i.CLAMP_TO_EDGE),i.texSubImage2D(i.TEXTURE_2D,0,0,0,i.RGBA,i.UNSIGNED_BYTE,this.video)):(this.texture=new e.T(t,this.video,i.RGBA),this.texture.bind(i.LINEAR,i.CLAMP_TO_EDGE),this.width=this.video.videoWidth,this.height=this.video.videoHeight),this._prepareData(t);}serialize(){return {type:"video",urls:this.urls,coordinates:this.coordinates}}hasTransition(){return this.video&&!this.video.paused}},image:e.ap,model:class extends e.E{constructor(e,t,i,o){super(),this.id=e,this.type="model",this.models=[],this._loaded=!1,this._options=t;}load(){const t=[];for(const i in this._options.models){const o=this._options.models[i],r=e.l(this.map._requestManager.transformRequest(o.uri,e.R.Model).url).then((t=>{if(!t)return;const r=e.c(t),s=new e.M(i,o.position,o.orientation,r);s.computeBoundsAndApplyParent(),this.models.push(s);})).catch((t=>{this.fire(new e.a(new Error(`Could not load model ${i} from ${o.uri}: ${t.message}`)));}));t.push(r);}return Promise.allSettled(t).then((()=>{this._loaded=!0,this.fire(new e.b("data",{dataType:"source",sourceDataType:"metadata"}));})).catch((t=>{this.fire(new e.a(new Error(`Could not load models: ${t.message}`)));}))}onAdd(e){this.map=e,this.load();}hasTransition(){return !1}loaded(){return this._loaded}getModels(){return this.models}loadTile(e,t){}serialize(){return {type:"model"}}},"batched-model":class extends e.E{constructor(e,t,i,o){super(),this.type="batched-model",this.id=e,this.tileSize=512,this._options=t,this.tiles=this._options.tiles,this.maxzoom=t.maxzoom||19,this.minzoom=t.minzoom||0,this.roundZoom=!0,this.usedInConflation=!0,this.dispatcher=i,this.reparseOverscaled=!1,this.scheme="xyz",this._loaded=!1,this.setEventedParent(o);}onAdd(e){this.map=e,this.load();}load(t){this._loaded=!1,this.fire(new e.b("dataloading",{dataType:"source"}));const i=Array.isArray(this.map._language)?this.map._language.join():this.map._language,o=this.map._worldview;this._tileJSONRequest=Ae(this._options,this.map._requestManager,i,o,((r,s)=>{this._tileJSONRequest=null,this._loaded=!0,r?(i&&console.warn(`Ensure that your requested language string is a valid BCP-47 code or list of codes. Found: ${i}`),o&&2!==o.length&&console.warn(`Requested worldview strings must be a valid ISO alpha-2 code. Found: ${o}`),this.fire(new e.a(r))):s&&(e.e(this,s),s.bounds&&(this.tileBounds=new Re(s.bounds,this.minzoom,this.maxzoom)),e.aj(s.tiles,this.map._requestManager._customAccessToken),this.fire(new e.b("data",{dataType:"source",sourceDataType:"metadata"})),this.fire(new e.b("data",{dataType:"source",sourceDataType:"content"}))),t&&t(r);}));}hasTransition(){return !1}hasTile(e){return !this.tileBounds||this.tileBounds.contains(e.canonical)}loaded(){return this._loaded}loadTile(t,i){const o=this.map._requestManager.normalizeTileURL(t.tileID.canonical.url(this.tiles,this.scheme)),r={request:this.map._requestManager.transformRequest(o,e.R.Tile),data:void 0,uid:t.uid,tileID:t.tileID,tileZoom:t.tileZoom,zoom:t.tileID.overscaledZ,tileSize:this.tileSize*t.tileID.overscaleFactor(),type:this.type,source:this.id,scope:this.scope,showCollisionBoxes:this.map.showCollisionBoxes,isSymbolTile:t.isSymbolTile,brightness:this.map.style&&this.map.style.getBrightness()||0};if(t.actor&&"expired"!==t.state)if("loading"===t.state)t.reloadCallback=i;else {if(t.buckets){const e=Object.values(t.buckets);for(const t of e)t.dirty=!0;return void(t.state="loaded")}t.request=t.actor.send("reloadTile",r,s.bind(this));}else t.actor=this.dispatcher.getActor(),t.request=t.actor.send("loadTile",r,s.bind(this),void 0,!0);function s(e,o){return t.aborted?i(null):e&&404!==e.status?i(e):(o&&(o.resourceTiming&&(t.resourceTiming=o.resourceTiming),this.map._refreshExpiredTiles&&t.setExpiryData(o),t.buckets={...t.buckets,...o.buckets},o.featureIndex&&(t.latestFeatureIndex=o.featureIndex)),t.state="loaded",void i(null))}}serialize(){return e.e({},this._options)}},canvas:class extends e.ap{constructor(t,i,o,r){super(t,i,o,r),i.coordinates?Array.isArray(i.coordinates)&&4===i.coordinates.length&&!i.coordinates.some((e=>!Array.isArray(e)||2!==e.length||e.some((e=>"number"!=typeof e))))||this.fire(new e.a(new T(`sources.${t}`,null,'"coordinates" property must be an array of 4 longitude/latitude array pairs'))):this.fire(new e.a(new T(`sources.${t}`,null,'missing required property "coordinates"'))),i.animate&&"boolean"!=typeof i.animate&&this.fire(new e.a(new T(`sources.${t}`,null,'optional "animate" property must be a boolean value'))),i.canvas?"string"==typeof i.canvas||i.canvas instanceof HTMLCanvasElement||this.fire(new e.a(new T(`sources.${t}`,null,'"canvas" must be either a string representing the ID of the canvas element from which to read, or an HTMLCanvasElement instance'))):this.fire(new e.a(new T(`sources.${t}`,null,'missing required property "canvas"'))),this.options=i,this.animate=void 0===i.animate||i.animate;}load(){this._loaded=!0,this.canvas||(this.canvas=this.options.canvas instanceof HTMLCanvasElement?this.options.canvas:document.getElementById(this.options.canvas)),this.width=this.canvas.width,this.height=this.canvas.height,this._hasInvalidDimensions()?this.fire(new e.a(new Error("Canvas dimensions cannot be less than or equal to zero."))):(this.play=function(){this._playing=!0,this.map.triggerRepaint();},this.pause=function(){this._playing&&(this.prepare(),this._playing=!1);},this._finishLoading());}getCanvas(){return this.canvas}onAdd(e){this.map=e,this.load(),this.canvas&&this.animate&&this.play();}onRemove(){this.pause();}prepare(){let t=!1;if(this.canvas.width!==this.width&&(this.width=this.canvas.width,t=!0),this.canvas.height!==this.height&&(this.height=this.canvas.height,t=!0),this._hasInvalidDimensions())return;if(0===Object.keys(this.tiles).length)return;const i=this.map.painter.context;this.texture?!t&&!this._playing||this.texture instanceof e.ar||this.texture.update(this.canvas,{premultiply:!0}):this.texture=new e.T(i,this.canvas,i.gl.RGBA,{premultiply:!0}),this._prepareData(i);}serialize(){return {type:"canvas",coordinates:this.coordinates}}hasTransition(){return this._playing}_hasInvalidDimensions(){for(const e of [this.canvas.width,this.canvas.height])if(isNaN(e)||e<=0)return !0;return !1}},custom:class extends e.E{constructor(t,i,o,r){super(),this.id=t,this.type="custom",this._dataType="raster",this._dispatcher=o,this._implementation=i,this.setEventedParent(r),this.scheme="xyz",this.minzoom=0,this.maxzoom=22,this.tileSize=512,this._loaded=!1,this.roundZoom=!0,this._implementation||this.fire(new e.a(new Error(`Missing implementation for ${this.id} custom source`))),this._implementation.loadTile||this.fire(new e.a(new Error(`Missing loadTile implementation for ${this.id} custom source`))),this._implementation.bounds&&(this.tileBounds=new Re(this._implementation.bounds,this.minzoom,this.maxzoom)),i.update=this._update.bind(this),i.clearTiles=this._clearTiles.bind(this),i.coveringTiles=this._coveringTiles.bind(this),e.e(this,e.ac(i,["dataType","scheme","minzoom","maxzoom","tileSize","attribution","minTileCacheSize","maxTileCacheSize"]));}serialize(){return e.ac(this,["type","scheme","minzoom","maxzoom","tileSize","attribution"])}load(){this._loaded=!0,this.fire(new e.b("data",{dataType:"source",sourceDataType:"metadata"})),this.fire(new e.b("data",{dataType:"source",sourceDataType:"content"}));}loaded(){return this._loaded}onAdd(t){this._map=t,this._loaded=!1,this.fire(new e.b("dataloading",{dataType:"source"})),this._implementation.onAdd&&this._implementation.onAdd(t),this.load();}onRemove(e){this._implementation.onRemove&&this._implementation.onRemove(e);}hasTile(e){if(this._implementation.hasTile){const{x:t,y:i,z:o}=e.canonical;return this._implementation.hasTile({x:t,y:i,z:o})}return !this.tileBounds||this.tileBounds.contains(e.canonical)}loadTile(e,t){const{x:i,y:o,z:r}=e.tileID.canonical,s=new AbortController;e.request=Promise.resolve(this._implementation.loadTile({x:i,y:o,z:r},{signal:s.signal})).then(function(i){return delete e.request,e.aborted?(e.state="unloaded",t(null)):void 0===i?(e.state="errored",t(null)):null===i?(this.loadTileData(e,{width:this.tileSize,height:this.tileSize,data:null}),e.state="loaded",t(null)):function(e){return e instanceof ImageData||e instanceof HTMLCanvasElement||e instanceof ImageBitmap||e instanceof HTMLImageElement}(i)?(this.loadTileData(e,i),e.state="loaded",void t(null)):(e.state="errored",t(new Error(`Can't infer data type for ${this.id}, only raster data supported at the moment`)))}.bind(this)).catch((i=>{20!==i.code&&(e.state="errored",t(i));})),e.request.cancel=()=>s.abort();}loadTileData(e,t){e.setTexture(t,this._map.painter);}unloadTile(t,i){if(t.texture&&t.texture instanceof e.T?(t.destroy(!0),t.texture&&t.texture instanceof e.T&&this._map.painter.saveTileTexture(t.texture)):t.destroy(),this._implementation.unloadTile){const{x:e,y:i,z:o}=t.tileID.canonical;this._implementation.unloadTile({x:e,y:i,z:o});}i();}abortTile(e,t){e.request&&e.request.cancel&&(e.request.cancel(),delete e.request),t();}hasTransition(){return !1}_coveringTiles(){return this._map.transform.coveringTiles({tileSize:this.tileSize,minzoom:this.minzoom,maxzoom:this.maxzoom,roundZoom:this.roundZoom}).map((e=>({x:e.canonical.x,y:e.canonical.y,z:e.canonical.z})))}_clearTiles(){const t=e.ag(this.id,this.scope);this._map.style.clearSource(t);}_update(){this.fire(new e.b("data",{dataType:"source",sourceDataType:"content"}));}}},Vt=function(t,i,o,r){const s=new jt[i.type](t,i,o,r);if(s.id!==t)throw new Error(`Expected Source id to be ${t} instead of ${s.id}`);return e.aY(["load","abort","unload","serialize","prepare"],s),s};function Zt(t,i){const o=e.a6.identity([]);return e.a6.scale(o,o,[.5*t.width,.5*-t.height,1]),e.a6.translate(o,o,[1,-1,0]),e.a6.multiply(o,o,t.calculateProjMatrix(i.toUnwrapped())),Float32Array.from(o)}function Ht(e,t,i,o,r,s,n,a=!1){const l=e.tilesIn(o,n,a);l.sort(qt);const c=[];for(const o of l)c.push({wrappedTileID:o.tile.tileID.wrapped().key,queryResults:o.tile.queryRenderedFeatures(t,i,e._state,o,r,s,Zt(e.transform,o.tile.tileID),a)});const h=function(e){const t={},i={};for(const o of e){const e=o.queryResults,r=o.wrappedTileID,s=i[r]=i[r]||{};for(const i in e){const o=e[i],r=s[i]=s[i]||{},n=t[i]=t[i]||[];for(const e of o)r[e.featureIndex]||(r[e.featureIndex]=!0,n.push(e));}}return t}(c);for(const t in h)h[t].forEach((t=>{const i=t.feature,o=i.layer;o&&"background"!==o.type&&"sky"!==o.type&&"slot"!==o.type&&(i.source=o.source,o["source-layer"]&&(i.sourceLayer=o["source-layer"]),i.state=void 0!==i.id?e.getFeatureState(o["source-layer"],i.id):{});}));return h}function Wt(e,t){const i=e.getRenderableIds().map((t=>e.getTileByID(t))),o=[],r={};for(let e=0;e<i.length;e++){const s=i[e],n=s.tileID.canonical.key;r[n]||(r[n]=!0,s.querySourceFeatures(o,t));}return o}function qt(e,t){const i=e.tileID,o=t.tileID;return i.overscaledZ-o.overscaledZ||i.canonical.y-o.canonical.y||i.wrap-o.wrap||i.canonical.x-o.canonical.x}class $t extends Gt{constructor(e,t,i,o,r){super(e,t,i,o,r),this._workQueue=[],this._fetchQueue=[],this._isHeaderLoaded=!1;}setTexture(t,i){const o=i.context,r=o.gl;this.texture=this.texture||i.getTileTexture(t.width),this.texture&&this.texture instanceof e.T?this.texture.update(t,{useMipmap:!1,premultiply:!1}):this.texture=new e.T(o,t,r.RGBA,{useMipmap:!1,premultiply:!1});}flushQueues(){for(;this._workQueue.length;)this._workQueue.pop()();for(;this._fetchQueue.length;)this._fetchQueue.pop()();}fetchHeader(t=16384,i){const o=this._mrt=new e.aZ(30),r=Object.assign({},this.requestParams,{headers:{Range:"bytes=0-"+(t-1)}});return this.entireBuffer=null,this.request=e.a_(r,((e,r,s,n)=>{if(e)i(e);else try{const e=o.getHeaderLength(r);if(e>t)return void(this.request=this.fetchHeader(e,i));o.parseHeader(r),this._isHeaderLoaded=!0;let a=0;for(const e of Object.values(o.layers))a=Math.max(a,e.dataIndex[e.dataIndex.length-1].last_byte);r.byteLength>=a&&(this.entireBuffer=r),i(null,this.entireBuffer||r,s,n);}catch(e){i(e);}})),this.request}fetchBand(t,i,o){const r=this._mrt;if(!this._isHeaderLoaded||!r)return void o(new Error("Tile header is not ready"));const s=this.actor;if(!s)return void o(new Error("Can't fetch tile band without an actor"));let n;const a=(e,r)=>{n.complete(e,r),e?o(e):(this.updateTextureDescriptor(t,i),o(null,this.textureDescriptor&&this.textureDescriptor.img));},l=(e,t)=>{if(e)return o(e);const i=s.send("decodeRasterArray",{buffer:t,task:n},a,void 0,!0);this._workQueue.push((()=>{i&&i.cancel(),n.cancel();}));},c=r.getLayer(t);if(!c)return void o(new Error(`Unknown sourceLayer "${t}"`));if(c.hasDataForBand(i))return this.updateTextureDescriptor(t,i),void o(null,this.textureDescriptor?this.textureDescriptor.img:null);const h=c.getDataRange([i]);if(n=r.createDecodingTask(h),!n||n.tasks.length)if(this.flushQueues(),this.entireBuffer)l(null,this.entireBuffer.slice(h.firstByte,h.lastByte+1));else {const t=Object.assign({},this.requestParams,{headers:{Range:`bytes=${h.firstByte}-${h.lastByte}`}}),i=e.a_(t,l);this._fetchQueue.push((()=>{i.cancel(),n.cancel();}));}else o(null);}updateNeeded(e,t){return (!this.textureDescriptor||this.textureDescriptor.band!==t||this.textureDescriptor.layer!==e)&&"errored"!==this.state}updateTextureDescriptor(t,i){if(!this._mrt)return;const o=this._mrt.getLayer(t);if(!o||!o.hasBand(i)||!o.hasDataForBand(i))return;const{bytes:r,tileSize:s,buffer:n,offset:a,scale:l}=o.getBandView(i),c=s+2*n,h={data:r,width:c,height:c},u=this.texture;u&&u instanceof e.T&&u.update(h,{useMipmap:!1,premultiply:!1}),this.textureDescriptor={layer:t,band:i,img:h,buffer:n,offset:a,tileSize:s,format:o.pixelFormat,mix:[l,256*l,65536*l,16777216*l]};}}class Xt{constructor(e,t){this.max=e,this.onRemove=t,this.reset();}reset(){for(const e in this.data)for(const t of this.data[e])t.timeout&&clearTimeout(t.timeout),this.onRemove(t.value);return this.data={},this.order=[],this}add(e,t,i){const o=e.wrapped().key;void 0===this.data[o]&&(this.data[o]=[]);const r={value:t,timeout:void 0};if(void 0!==i&&(r.timeout=setTimeout((()=>{this.remove(e,r);}),i)),this.data[o].push(r),this.order.push(o),this.order.length>this.max){const e=this._getAndRemoveByKey(this.order[0]);e&&this.onRemove(e);}return this}has(e){return e.wrapped().key in this.data}getAndRemove(e){return this.has(e)?this._getAndRemoveByKey(e.wrapped().key):null}_getAndRemoveByKey(e){const t=this.data[e].shift();return t.timeout&&clearTimeout(t.timeout),0===this.data[e].length&&delete this.data[e],this.order.splice(this.order.indexOf(e),1),t.value}getByKey(e){const t=this.data[e];return t?t[0].value:null}get(e){return this.has(e)?this.data[e.wrapped().key][0].value:null}remove(e,t){if(!this.has(e))return this;const i=e.wrapped().key,o=void 0===t?0:this.data[i].indexOf(t),r=this.data[i][o];return this.data[i].splice(o,1),r.timeout&&clearTimeout(r.timeout),0===this.data[i].length&&delete this.data[i],this.onRemove(r.value),this.order.splice(this.order.indexOf(i),1),this}setMaxSize(e){for(this.max=e;this.order.length>this.max;){const e=this._getAndRemoveByKey(this.order[0]);e&&this.onRemove(e);}return this}filter(e){const t=[];for(const i in this.data)for(const o of this.data[i])e(o.value)||t.push(o);for(const e of t)this.remove(e.value.tileID,e);}}class Kt extends e.E{constructor(e,t,i){super(),this.id=e,this._onlySymbols=i,t.on("data",(e=>{"source"===e.dataType&&"metadata"===e.sourceDataType&&(this._sourceLoaded=!0),this._sourceLoaded&&!this._paused&&"source"===e.dataType&&"content"===e.sourceDataType&&(this.reload(),this.transform&&this.update(this.transform));})),t.on("error",(()=>{this._sourceErrored=!0;})),this._source=t,this._tiles={},this._cache=new Xt(0,this._unloadTile.bind(this)),this._timers={},this._cacheTimers={},this._minTileCacheSize=t.minTileCacheSize,this._maxTileCacheSize=t.maxTileCacheSize,this._loadedParentTiles={},this.castsShadows=!1,this.tileCoverLift=0,this._coveredTiles={},this._shadowCasterTiles={},this._state=new y,this._isRaster="raster"===this._source.type||"raster-dem"===this._source.type||"raster-array"===this._source.type||"custom"===this._source.type&&"raster"===this._source._dataType;}onAdd(e){this.map=e,this._minTileCacheSize=void 0===this._minTileCacheSize&&e?e._minTileCacheSize:this._minTileCacheSize,this._maxTileCacheSize=void 0===this._maxTileCacheSize&&e?e._maxTileCacheSize:this._maxTileCacheSize;}loaded(){if(this._sourceErrored)return !0;if(!this._sourceLoaded)return !1;if(!this._source.loaded())return !1;for(const e in this._tiles){const t=this._tiles[e];if("errored"!==t.state&&("loaded"!==t.state||!t.bucketsLoaded()))return !1}return !0}getSource(){return this._source}pause(){this._paused=!0;}resume(){if(!this._paused)return;const e=this._shouldReloadOnResume;this._paused=!1,this._shouldReloadOnResume=!1,e&&this.reload(),this.transform&&this.update(this.transform);}_loadTile(e,t){return e.isSymbolTile=this._onlySymbols,e.isExtraShadowCaster=this._shadowCasterTiles[e.tileID.key],this._source.loadTile(e,t)}_unloadTile(e){if(this._source.unloadTile)return this._source.unloadTile(e,(()=>{}))}_abortTile(e){if(this._source.abortTile)return this._source.abortTile(e,(()=>{}))}serialize(){return this._source.serialize()}prepare(e){this._source.prepare&&this._source.prepare(),this._state.coalesceChanges(this._tiles,this.map?this.map.painter:null);for(const t in this._tiles){const i=this._tiles[t];i.upload(e),i.prepare(this.map.style.imageManager,this.map?this.map.painter:null,this._source.scope);}}getIds(){return e.a$(this._tiles).map((e=>e.tileID)).sort(Yt).map((e=>e.key))}getRenderableIds(t,i){const o=[];for(const e in this._tiles)this._isIdRenderable(+e,t,i)&&o.push(this._tiles[e]);return t?o.sort(((t,i)=>{const o=t.tileID,r=i.tileID,s=new e.P(o.canonical.x,o.canonical.y)._rotate(this.transform.angle),n=new e.P(r.canonical.x,r.canonical.y)._rotate(this.transform.angle);return o.overscaledZ-r.overscaledZ||n.y-s.y||n.x-s.x})).map((e=>e.tileID.key)):o.map((e=>e.tileID)).sort(Yt).map((e=>e.key))}hasRenderableParent(e){const t=this.findLoadedParent(e,0);return !!t&&this._isIdRenderable(t.tileID.key)}_isIdRenderable(e,t,i){return this._tiles[e]&&this._tiles[e].hasData()&&!this._coveredTiles[e]&&(t||!this._tiles[e].holdingForFade())&&(i||!this._shadowCasterTiles[e])}reload(){if(this._paused)this._shouldReloadOnResume=!0;else {this._cache.reset();for(const e in this._tiles)"errored"!==this._tiles[e].state&&this._reloadTile(+e,"reloading");}}_reloadTile(e,t){const i=this._tiles[e];i&&("loading"!==i.state&&(i.state=t),this._loadTile(i,this._tileLoaded.bind(this,i,e,t)));}_tileLoaded(t,i,o,r){if(r)if(t.state="errored",404!==r.status)this._source.fire(new e.a(r,{tile:t}));else {if(!(t.tileID.key in this._loadedParentTiles))return void this._source.fire(new e.b("data",{dataType:"source",sourceDataType:"error",sourceId:this._source.id}));if("raster-dem"===this._source.type&&this.usedForTerrain&&this.map.painter.terrain){const e=this.map.painter.terrain;this.update(this.transform,e.getScaledDemTileSize(),!0),e.resetTileLookupCache(this.id);}else this.update(this.transform);}else t.timeAdded=e.f.now(),"expired"===o&&(t.refreshedUponExpiration=!0),this._setTileReloadTimer(i,t),"raster-dem"===this._source.type&&t.dem&&this._backfillDEM(t),this._state.initializeTileState(t,this.map?this.map.painter:null),this._source.fire(new e.b("data",{dataType:"source",tile:t,coord:t.tileID,sourceCacheId:this.id}));}_backfillDEM(e){const t=this.getRenderableIds();for(let o=0;o<t.length;o++){const r=t[o];if(e.neighboringTiles&&e.neighboringTiles[r]){const t=this.getTileByID(r);i(e,t),i(t,e);}}function i(e,t){if(!e.dem||e.dem.borderReady)return;e.needsHillshadePrepare=!0,e.needsDEMTextureUpload=!0;let i=t.tileID.canonical.x-e.tileID.canonical.x;const o=t.tileID.canonical.y-e.tileID.canonical.y,r=Math.pow(2,e.tileID.canonical.z),s=t.tileID.key;0===i&&0===o||Math.abs(o)>1||(Math.abs(i)>1&&(1===Math.abs(i+r)?i+=r:1===Math.abs(i-r)&&(i-=r)),t.dem&&e.dem&&(e.dem.backfillBorder(t.dem,i,o),e.neighboringTiles&&e.neighboringTiles[s]&&(e.neighboringTiles[s].backfilled=!0)));}}getTile(e){return this.getTileByID(e.key)}getTileByID(e){return this._tiles[e]}_retainLoadedChildren(e,t,i,o){for(const r in this._tiles){let s=this._tiles[r];if(o[r]||!s.hasData()||s.tileID.overscaledZ<=t||s.tileID.overscaledZ>i)continue;let n=s.tileID;for(;s&&s.tileID.overscaledZ>t+1;){const e=s.tileID.scaledTo(s.tileID.overscaledZ-1);s=this._tiles[e.key],s&&s.hasData()&&(n=e);}let a=n;for(;a.overscaledZ>t;)if(a=a.scaledTo(a.overscaledZ-1),e[a.key]){o[n.key]=n;break}}}findLoadedParent(e,t){if(e.key in this._loadedParentTiles){const i=this._loadedParentTiles[e.key];return i&&i.tileID.overscaledZ>=t?i:null}for(let i=e.overscaledZ-1;i>=t;i--){const t=e.scaledTo(i),o=this._getLoadedTile(t);if(o)return o}}_getLoadedTile(e){const t=this._tiles[e.key];return t&&t.hasData()?t:this._cache.getByKey(this._source.reparseOverscaled?e.wrapped().key:e.canonical.key)}updateCacheSize(e,t){t=t||this._source.tileSize;const i=Math.ceil(e.width/t)+1,o=Math.ceil(e.height/t)+1,r=Math.floor(i*o*5),s="number"==typeof this._minTileCacheSize?Math.max(this._minTileCacheSize,r):r,n="number"==typeof this._maxTileCacheSize?Math.min(this._maxTileCacheSize,s):s;this._cache.setMaxSize(n);}handleWrapJump(e){const t=Math.round((e-(void 0===this._prevLng?e:this._prevLng))/360);if(this._prevLng=e,t){const e={};for(const i in this._tiles){const o=this._tiles[i];o.tileID=o.tileID.unwrapTo(o.tileID.wrap+t),e[o.tileID.key]=o;}this._tiles=e;for(const e in this._timers)clearTimeout(this._timers[e]),delete this._timers[e];for(const e in this._tiles)this._setTileReloadTimer(+e,this._tiles[e]);}}update(t,i,o,r){if(this.transform=t,!this._sourceLoaded||this._paused||this.transform.freezeTileCoverage)return;if(this.usedForTerrain&&!o)return;let s;if(this.updateCacheSize(t,i),"globe"!==this.transform.projection.name&&this.handleWrapJump(this.transform.center.lng),this._shadowCasterTiles={},this._coveredTiles={},this.used||this.usedForTerrain)if(this._source.tileID)s=t.getVisibleUnwrappedCoordinates(this._source.tileID).map((t=>new e.am(t.canonical.z,t.wrap,t.canonical.z,t.canonical.x,t.canonical.y)));else if(0!==this.tileCoverLift){const r=t.clone();r.tileCoverLift=this.tileCoverLift,s=r.coveringTiles({tileSize:i||this._source.tileSize,minzoom:this._source.minzoom,maxzoom:this._source.maxzoom,roundZoom:this._source.roundZoom&&!o,reparseOverscaled:this._source.reparseOverscaled,isTerrainDEM:this.usedForTerrain}),this._source.minzoom<=1&&"globe"===t.projection.name&&(s.push(new e.am(1,0,1,0,0)),s.push(new e.am(1,0,1,1,0)),s.push(new e.am(1,0,1,0,1)),s.push(new e.am(1,0,1,1,1)));}else s=t.coveringTiles({tileSize:i||this._source.tileSize,minzoom:this._source.minzoom,maxzoom:this._source.maxzoom,roundZoom:this._source.roundZoom&&!o,reparseOverscaled:this._source.reparseOverscaled,isTerrainDEM:this.usedForTerrain}),this._source.hasTile&&(s=s.filter((e=>this._source.hasTile(e))));else s=[];if(s.length>0&&this.castsShadows&&r&&"globe"!==this.transform.projection.name&&!this.usedForTerrain&&!Jt(this._source.type)){const e=t.coveringZoomLevel({tileSize:i||this._source.tileSize,roundZoom:this._source.roundZoom&&!o}),n=Math.min(e,this._source.maxzoom),a=t.extendTileCoverForShadows(s,r,n);for(const e of a)this._shadowCasterTiles[e.key]=!0,s.push(e);}const n=this._updateRetainedTiles(s);if(Jt(this._source.type)&&0!==s.length){const t={},i={},o=Object.keys(n);for(const r of o){const o=n[r],s=this._tiles[r];if(!s||s.fadeEndTime&&s.fadeEndTime<=e.f.now())continue;const a=this.findLoadedParent(o,Math.max(o.overscaledZ-Kt.maxOverzooming,this._source.minzoom));a&&(this._addTile(a.tileID),t[a.tileID.key]=a.tileID),i[r]=o;}const r=s[s.length-1].overscaledZ;for(const e in this._tiles){const t=this._tiles[e];if(n[e]||!t.hasData())continue;let o=t.tileID;for(;o.overscaledZ>r;){o=o.scaledTo(o.overscaledZ-1);const r=this._tiles[o.key];if(r&&r.hasData()&&i[o.key]){n[e]=t.tileID;break}}}for(const e in t)n[e]||(this._coveredTiles[e]=!0,n[e]=t[e]);}for(const e in n)this._tiles[e].clearFadeHold();const a=e.b0(this._tiles,n);for(const e of a){const t=this._tiles[e];t.hasSymbolBuckets&&!t.holdingForFade()?t.setHoldDuration(this.map._fadeDuration):t.hasSymbolBuckets&&!t.symbolFadeFinished()||this._removeTile(+e);}this._updateLoadedParentTileCache(),this._onlySymbols&&this._source.afterUpdate&&this._source.afterUpdate();}releaseSymbolFadeTiles(){for(const e in this._tiles)this._tiles[e].holdingForFade()&&this._removeTile(+e);}_updateRetainedTiles(e){const t={};if(0===e.length)return t;const i={},o=e.reduce(((e,t)=>Math.min(e,t.overscaledZ)),1/0),r=e[0].overscaledZ,s=Math.max(r-Kt.maxOverzooming,this._source.minzoom),n=Math.max(r+Kt.maxUnderzooming,this._source.minzoom),a={};for(const i of e){const e=this._addTile(i);t[i.key]=i,e.hasData()||o<this._source.maxzoom&&(a[i.key]=i);}this._retainLoadedChildren(a,o,n,t);for(const o of e){let e=this._tiles[o.key];if(e.hasData())continue;if(o.canonical.z>=this._source.maxzoom){const e=o.children(this._source.maxzoom)[0],i=this.getTile(e);if(i&&i.hasData()){t[e.key]=e;continue}}else {const e=o.children(this._source.maxzoom);if(t[e[0].key]&&t[e[1].key]&&t[e[2].key]&&t[e[3].key])continue}let r=e.wasRequested();for(let n=o.overscaledZ-1;n>=s;--n){const s=o.scaledTo(n);if(i[s.key])break;if(i[s.key]=!0,e=this.getTile(s),!e&&r&&(e=this._addTile(s)),e&&(t[s.key]=s,r=e.wasRequested(),e.hasData()))break}}return t}_updateLoadedParentTileCache(){this._loadedParentTiles={};for(const e in this._tiles){const t=[];let i,o=this._tiles[e].tileID;for(;o.overscaledZ>0;){if(o.key in this._loadedParentTiles){i=this._loadedParentTiles[o.key];break}t.push(o.key);const e=o.scaledTo(o.overscaledZ-1);if(i=this._getLoadedTile(e),i)break;o=e;}for(const e of t)this._loadedParentTiles[e]=i;}}_addTile(t){let i=this._tiles[t.key];if(i)return !0!==i.isExtraShadowCaster||!!this._shadowCasterTiles[t.key]||this._reloadTile(t.key,"reloading"),i;i=this._cache.getAndRemove(t),i&&(this._setTileReloadTimer(t.key,i),i.tileID=t,this._state.initializeTileState(i,this.map?this.map.painter:null),this._cacheTimers[t.key]&&(clearTimeout(this._cacheTimers[t.key]),delete this._cacheTimers[t.key],this._setTileReloadTimer(t.key,i)));const o=Boolean(i);if(!o){const e=this.map?this.map.painter:null,o=this._source.tileSize*t.overscaleFactor();i="raster-array"===this._source.type?new $t(t,o,this.transform.tileZoom,e,this._isRaster):new Gt(t,o,this.transform.tileZoom,e,this._isRaster),this._loadTile(i,this._tileLoaded.bind(this,i,t.key,i.state));}return i?(i.uses++,this._tiles[t.key]=i,o||this._source.fire(new e.b("dataloading",{tile:i,coord:i.tileID,dataType:"source"})),i):null}_setTileReloadTimer(e,t){e in this._timers&&(clearTimeout(this._timers[e]),delete this._timers[e]);const i=t.getExpiryTimeout();i&&(this._timers[e]=setTimeout((()=>{this._reloadTile(e,"expired"),delete this._timers[e];}),i));}_removeTile(e){const t=this._tiles[e];t&&(t.uses--,delete this._tiles[e],this._timers[e]&&(clearTimeout(this._timers[e]),delete this._timers[e]),t.uses>0||(t.hasData()&&"reloading"!==t.state||"empty"===t.state?this._cache.add(t.tileID,t,t.getExpiryTimeout()):(t.aborted=!0,this._abortTile(t),this._unloadTile(t))));}clearTiles(){this._shouldReloadOnResume=!1,this._paused=!1;for(const e in this._tiles)this._removeTile(+e);this._source._clear&&this._source._clear(),this._cache.reset(),this.map&&this.usedForTerrain&&this.map.painter.terrain&&this.map.painter.terrain.resetTileLookupCache(this.id);}tilesIn(t,i,o){const r=[],s=this.transform;if(!s)return r;const n="globe"===s.projection.name,a=e.a5(s.center.lng);for(const l in this._tiles){const c=this._tiles[l];if(o&&c.clearQueryDebugViz(),c.holdingForFade())continue;let h;if(n){const t=c.tileID.canonical;if(0===t.z){const i=[Math.abs(e.aa(a,...Qt(t,-1))-a),Math.abs(e.aa(a,...Qt(t,1))-a)];h=[0,2*i.indexOf(Math.min(...i))-1];}else {const i=[Math.abs(e.aa(a,...Qt(t,-1))-a),Math.abs(e.aa(a,...Qt(t,0))-a),Math.abs(e.aa(a,...Qt(t,1))-a)];h=[i.indexOf(Math.min(...i))-1];}}else h=[0];for(const e of h){const o=t.containsTile(c,s,i,e);o&&r.push(o);}}return r}getShadowCasterCoordinates(){return this._getRenderableCoordinates(!1,!0)}getVisibleCoordinates(e){return this._getRenderableCoordinates(e)}_getRenderableCoordinates(e,t){const i=this.getRenderableIds(e,t).map((e=>this._tiles[e].tileID)),o="globe"===this.transform.projection.name;for(const e of i)e.projMatrix=this.transform.calculateProjMatrix(e.toUnwrapped()),e.expandedProjMatrix=o?this.transform.calculateProjMatrix(e.toUnwrapped(),!1,!0):e.projMatrix;return i}sortCoordinatesByDistance(e){const t=e.slice(),i=this.transform._camera.position,o=this.transform._camera.forward(),r={};for(const e of t){const t=1/(1<<e.canonical.z);r[e.key]=((e.canonical.x+.5)*t+e.wrap-i[0])*o[0]+((e.canonical.y+.5)*t-i[1])*o[1]-i[2]*o[2];}return t.sort(((e,t)=>r[e.key]-r[t.key])),t}hasTransition(){if(this._source.hasTransition())return !0;if(Jt(this._source.type))for(const t in this._tiles){const i=this._tiles[t];if(void 0!==i.fadeEndTime&&i.fadeEndTime>=e.f.now())return !0}return !1}setFeatureState(e,t,i){this._state.updateState(e=e||"_geojsonTileLayer",t,i);}removeFeatureState(e,t,i){this._state.removeFeatureState(e=e||"_geojsonTileLayer",t,i);}getFeatureState(e,t){return this._state.getState(e=e||"_geojsonTileLayer",t)}setDependencies(e,t,i){const o=this._tiles[e];o&&o.setDependencies(t,i);}reloadTilesForDependencies(e,t){for(const i in this._tiles)this._tiles[i].hasDependency(e,t)&&this._reloadTile(+i,"reloading");this._cache.filter((i=>!i.hasDependency(e,t)));}_preloadTiles(t,i){if(!this._sourceLoaded){const e=()=>{this._sourceLoaded&&(this._source.off("data",e),this._preloadTiles(t,i));};return void this._source.on("data",e)}const o=new Map,r=Array.isArray(t)?t:[t],s=this.map.painter.terrain,n=this.usedForTerrain&&s?s.getScaledDemTileSize():this._source.tileSize;for(const e of r){const t=e.coveringTiles({tileSize:n,minzoom:this._source.minzoom,maxzoom:this._source.maxzoom,roundZoom:this._source.roundZoom&&!this.usedForTerrain,reparseOverscaled:this._source.reparseOverscaled,isTerrainDEM:this.usedForTerrain});for(const e of t)o.set(e.key,e);this.usedForTerrain&&e.updateElevation(!1);}const a=Array.from(o.values());e.b1(a,((e,t)=>{const i=new Gt(e,this._source.tileSize*e.overscaleFactor(),this.transform.tileZoom,this.map.painter,this._isRaster);this._loadTile(i,(e=>{"raster-dem"===this._source.type&&i.dem&&this._backfillDEM(i),t(e,i);}));}),i);}}function Yt(e,t){const i=Math.abs(2*e.wrap)-+(e.wrap<0),o=Math.abs(2*t.wrap)-+(t.wrap<0);return e.overscaledZ-t.overscaledZ||o-i||t.canonical.y-e.canonical.y||t.canonical.x-e.canonical.x}function Jt(e){return "raster"===e||"image"===e||"video"===e||"custom"===e}function Qt(e,t){const i=1<<e.z;return [e.x/i+t,(e.x+1)/i+t]}Kt.maxOverzooming=10,Kt.maxUnderzooming=3;class ei{constructor(e){this.style=e,this.layersGotHidden=!1,this.layers=[];}processLayersChanged(){this.layers=[];const e=!1,t=!1;for(const i in this.style._mergedLayers){const o=this.style._mergedLayers[i];if("fill-extrusion"===o.type)this.layers.push({layer:o,visible:e,visibilityChanged:t});else if("model"===o.type){const i=this.style.getLayerSource(o);i&&"batched-model"===i.type&&this.layers.push({layer:o,visible:e,visibilityChanged:t});}}}onNewFrame(e){this.layersGotHidden=!1;for(const t of this.layers){const i=t.layer;let o=!1;"fill-extrusion"===i.type?o=!i.isHidden(e)&&i.paint.get("fill-extrusion-opacity")>0:"model"===i.type&&(o=!i.isHidden(e)&&i.paint.get("model-opacity")>0),this.layersGotHidden=this.layersGotHidden||!o&&t.visible,t.visible=o;}}updateZOffset(e,t){this.currentBuildingBuckets=[];for(const e of this.layers){const i=e.layer,o=this.style.getLayerSourceCache(i);let r=1;"fill-extrusion"===i.type&&(r=e.visible?i.paint.get("fill-extrusion-vertical-scale"):0);let s=o?o.getTile(t):null;if(!s&&o&&t.canonical.z>o.getSource().minzoom){let e=t.scaledTo(Math.min(o.getSource().maxzoom,t.overscaledZ-1));for(;e.overscaledZ>=o.getSource().minzoom&&(s=o.getTile(e),!s&&0!==e.overscaledZ);)e=e.scaledTo(e.overscaledZ-1);}this.currentBuildingBuckets.push({bucket:s?s.getBucket(i):null,tileID:s?s.tileID:t,verticalScale:r});}e.hasAnyZOffset=!1;let i=!1;for(let o=0;o<e.symbolInstances.length;o++){const r=e.symbolInstances.get(o),s=r.zOffset,n=this._getHeightAtTileOffset(t,r.tileAnchorX,r.tileAnchorY);r.zOffset=n!==Number.NEGATIVE_INFINITY?n:s,i||s===r.zOffset||(i=!0),e.hasAnyZOffset||0===r.zOffset||(e.hasAnyZOffset=!0);}i&&(e.zOffsetBuffersNeedUpload=!0,e.zOffsetSortDirty=!0);}_mapCoordToOverlappingTile(t,i,o,r){let s=i,n=o;if(t.canonical.z!==r.canonical.z){const a=r.canonical,l=1/(1<<t.canonical.z-a.z);s=(i+t.canonical.x*e.V)*l-a.x*e.V|0,n=(o+t.canonical.y*e.V)*l-a.y*e.V|0;}return {tileX:s,tileY:n}}_getHeightAtTileOffset(e,t,i){let o,r;for(let s=0;s<this.layers.length;++s){if("fill-extrusion"!==this.layers[s].layer.type)continue;const{bucket:n,tileID:a,verticalScale:l}=this.currentBuildingBuckets[s];if(!n)continue;const{tileX:c,tileY:h}=this._mapCoordToOverlappingTile(e,t,i,a),u=n.getHeightAtTileCoord(c,h);u&&void 0!==u.height&&(u.hidden?o=u.height:r=Math.max(u.height*l,r||0));}if(void 0!==r)return r;for(let r=0;r<this.layers.length;++r){const s=this.layers[r];if("model"!==s.layer.type||!s.visible)continue;const{bucket:n,tileID:a}=this.currentBuildingBuckets[r];if(!n)continue;const{tileX:l,tileY:c}=this._mapCoordToOverlappingTile(e,t,i,a),h=n.getHeightAtTileCoord(l,c);if(h&&!h.hidden)return void 0===h.height&&void 0!==o?Math.min(h.maxHeight,o)*h.verticalScale:(h.height||0)*h.verticalScale}return this.layersGotHidden?0:Number.NEGATIVE_INFINITY}}function ti(t,i){const o={};for(const e in t)"ref"!==e&&(o[e]=t[e]);return e.b2.forEach((e=>{e in i&&(o[e]=i[e]);})),o}function ii(e){e=e.slice();const t=Object.create(null);for(let i=0;i<e.length;i++)t[e[i].id]=e[i];for(let i=0;i<e.length;i++)"ref"in e[i]&&(e[i]=ti(e[i],t[e[i].ref]));return e}const oi={setStyle:"setStyle",addLayer:"addLayer",removeLayer:"removeLayer",setPaintProperty:"setPaintProperty",setLayoutProperty:"setLayoutProperty",setSlot:"setSlot",setFilter:"setFilter",addSource:"addSource",removeSource:"removeSource",setGeoJSONSourceData:"setGeoJSONSourceData",setLayerZoomRange:"setLayerZoomRange",setLayerProperty:"setLayerProperty",setCenter:"setCenter",setZoom:"setZoom",setBearing:"setBearing",setPitch:"setPitch",setSprite:"setSprite",setGlyphs:"setGlyphs",setTransition:"setTransition",setLight:"setLight",setTerrain:"setTerrain",setFog:"setFog",setCamera:"setCamera",setLights:"setLights",setProjection:"setProjection",addImport:"addImport",removeImport:"removeImport",updateImport:"updateImport"};function ri(e,t,i){i.push({command:oi.addSource,args:[e,t[e]]});}function si(e,t,i){t.push({command:oi.removeSource,args:[e]}),i[e]=!0;}function ni(e,t,i,o){si(e,i,o),ri(e,t,i);}function ai(e,i,o){let r;for(r in e[o])if(e[o].hasOwnProperty(r)&&"data"!==r&&!t(e[o][r],i[o][r]))return !1;for(r in i[o])if(i[o].hasOwnProperty(r)&&"data"!==r&&!t(e[o][r],i[o][r]))return !1;return !0}function li(e,i,o,r,s,n){let a;for(a in i=i||{},e=e||{})e.hasOwnProperty(a)&&(t(e[a],i[a])||o.push({command:n,args:[r,a,i[a],s]}));for(a in i)i.hasOwnProperty(a)&&!e.hasOwnProperty(a)&&(t(e[a],i[a])||o.push({command:n,args:[r,a,i[a],s]}));}function ci(e){return e.id}function hi(e,t){return e[t.id]=t,e}class ui{constructor(e,t){this.reset(e,t);}reset(e,t){this.points=e||[],this._distances=[0];for(let e=1;e<this.points.length;e++)this._distances[e]=this._distances[e-1]+this.points[e].dist(this.points[e-1]);this.length=this._distances[this._distances.length-1],this.padding=Math.min(t||0,.5*this.length),this.paddedLength=this.length-2*this.padding;}lerp(t){if(1===this.points.length)return this.points[0];t=e.aa(t,0,1);let i=1,o=this._distances[i];const r=t*this.paddedLength+this.padding;for(;o<r&&i<this._distances.length;)o=this._distances[++i];const s=i-1,n=this._distances[s],a=o-n,l=a>0?(r-n)/a:0;return this.points[s].mult(1-l).add(this.points[i].mult(l))}}class di{constructor(e,t,i){const o=this.boxCells=[],r=this.circleCells=[];this.xCellCount=Math.ceil(e/i),this.yCellCount=Math.ceil(t/i);for(let e=0;e<this.xCellCount*this.yCellCount;e++)o.push([]),r.push([]);this.circleKeys=[],this.boxKeys=[],this.bboxes=[],this.circles=[],this.width=e,this.height=t,this.xScale=this.xCellCount/e,this.yScale=this.yCellCount/t,this.boxUid=0,this.circleUid=0;}keysLength(){return this.boxKeys.length+this.circleKeys.length}insert(e,t,i,o,r){this._forEachCell(t,i,o,r,this._insertBoxCell,this.boxUid++),this.boxKeys.push(e),this.bboxes.push(t),this.bboxes.push(i),this.bboxes.push(o),this.bboxes.push(r);}insertCircle(e,t,i,o){this._forEachCell(t-o,i-o,t+o,i+o,this._insertCircleCell,this.circleUid++),this.circleKeys.push(e),this.circles.push(t),this.circles.push(i),this.circles.push(o);}_insertBoxCell(e,t,i,o,r,s){this.boxCells[r].push(s);}_insertCircleCell(e,t,i,o,r,s){this.circleCells[r].push(s);}_query(e,t,i,o,r,s){if(i<0||e>this.width||o<0||t>this.height)return !r&&[];const n=[];if(e<=0&&t<=0&&this.width<=i&&this.height<=o){if(r)return !0;for(let e=0;e<this.boxKeys.length;e++)n.push({key:this.boxKeys[e],x1:this.bboxes[4*e],y1:this.bboxes[4*e+1],x2:this.bboxes[4*e+2],y2:this.bboxes[4*e+3]});for(let e=0;e<this.circleKeys.length;e++){const t=this.circles[3*e],i=this.circles[3*e+1],o=this.circles[3*e+2];n.push({key:this.circleKeys[e],x1:t-o,y1:i-o,x2:t+o,y2:i+o});}return s?n.filter(s):n}return this._forEachCell(e,t,i,o,this._queryCell,n,{hitTest:r,seenUids:{box:{},circle:{}}},s),r?n.length>0:n}_queryCircle(e,t,i,o,r){const s=e-i,n=e+i,a=t-i,l=t+i;if(n<0||s>this.width||l<0||a>this.height)return !o&&[];const c=[];return this._forEachCell(s,a,n,l,this._queryCellCircle,c,{hitTest:o,circle:{x:e,y:t,radius:i},seenUids:{box:{},circle:{}}},r),o?c.length>0:c}query(e,t,i,o,r){return this._query(e,t,i,o,!1,r)}hitTest(e,t,i,o,r){return this._query(e,t,i,o,!0,r)}hitTestCircle(e,t,i,o){return this._queryCircle(e,t,i,!0,o)}_queryCell(e,t,i,o,r,s,n,a){const l=n.seenUids,c=this.boxCells[r];if(null!==c){const r=this.bboxes;for(const h of c)if(!l.box[h]){l.box[h]=!0;const c=4*h;if(e<=r[c+2]&&t<=r[c+3]&&i>=r[c+0]&&o>=r[c+1]&&(!a||a(this.boxKeys[h]))){if(n.hitTest)return s.push(!0),!0;s.push({key:this.boxKeys[h],x1:r[c],y1:r[c+1],x2:r[c+2],y2:r[c+3]});}}}const h=this.circleCells[r];if(null!==h){const r=this.circles;for(const c of h)if(!l.circle[c]){l.circle[c]=!0;const h=3*c;if(this._circleAndRectCollide(r[h],r[h+1],r[h+2],e,t,i,o)&&(!a||a(this.circleKeys[c]))){if(n.hitTest)return s.push(!0),!0;{const e=r[h],t=r[h+1],i=r[h+2];s.push({key:this.circleKeys[c],x1:e-i,y1:t-i,x2:e+i,y2:t+i});}}}}}_queryCellCircle(e,t,i,o,r,s,n,a){const l=n.circle,c=n.seenUids,h=this.boxCells[r];if(null!==h){const e=this.bboxes;for(const t of h)if(!c.box[t]){c.box[t]=!0;const i=4*t;if(this._circleAndRectCollide(l.x,l.y,l.radius,e[i+0],e[i+1],e[i+2],e[i+3])&&(!a||a(this.boxKeys[t])))return s.push(!0),!0}}const u=this.circleCells[r];if(null!==u){const e=this.circles;for(const t of u)if(!c.circle[t]){c.circle[t]=!0;const i=3*t;if(this._circlesCollide(e[i],e[i+1],e[i+2],l.x,l.y,l.radius)&&(!a||a(this.circleKeys[t])))return s.push(!0),!0}}}_forEachCell(e,t,i,o,r,s,n,a){const l=this._convertToXCellCoord(e),c=this._convertToYCellCoord(t),h=this._convertToXCellCoord(i),u=this._convertToYCellCoord(o);for(let d=l;d<=h;d++)for(let l=c;l<=u;l++)if(r.call(this,e,t,i,o,this.xCellCount*l+d,s,n,a))return}_convertToXCellCoord(e){return Math.max(0,Math.min(this.xCellCount-1,Math.floor(e*this.xScale)))}_convertToYCellCoord(e){return Math.max(0,Math.min(this.yCellCount-1,Math.floor(e*this.yScale)))}_circlesCollide(e,t,i,o,r,s){const n=o-e,a=r-t,l=i+s;return l*l>n*n+a*a}_circleAndRectCollide(e,t,i,o,r,s,n){const a=(s-o)/2,l=Math.abs(e-(o+a));if(l>a+i)return !1;const c=(n-r)/2,h=Math.abs(t-(r+c));if(h>c+i)return !1;if(l<=a||h<=c)return !0;const u=l-a,d=h-c;return u*u+d*d<=i*i}}const _i={unknown:0,flipRequired:1,flipNotRequired:2},pi=Math.tan(85*Math.PI/180);function fi(t,i,o,r,s,n,a){const l=e.a6.create();if(o)if("globe"===n.name){const t=e.b3(s,i);e.a6.multiply(l,l,t);}else {const t=e.b4.invert([],a);l[0]=t[0],l[1]=t[1],l[4]=t[2],l[5]=t[3],r||e.a6.rotateZ(l,l,s.angle);}else e.a6.multiply(l,s.labelPlaneMatrix,t);return l}function mi(e,t,i,o,r,s,n){const a=fi(e,t,i,o,r,s,n);return "globe"===s.name&&i||(a[2]=a[6]=a[10]=a[14]=0),a}function gi(t,i,o,r,s,n,a){if(o){if("globe"===n.name){const l=fi(t,i,o,r,s,n,a);return e.a6.invert(l,l),e.a6.multiply(l,t,l),l}{const i=e.a6.clone(t),o=e.a6.identity([]);return o[0]=a[0],o[1]=a[1],o[4]=a[2],o[5]=a[3],e.a6.multiply(i,i,o),r||e.a6.rotateZ(i,i,-s.angle),i}}return s.glCoordMatrix}function vi(t,i,o,r){const s=[t,i,o,1];o?e.a7.transformMat4(s,s,r):Li(s,s,r);const n=s[3];return s[0]/=n,s[1]/=n,s[2]/=n,s}function xi(e,t){return Math.min(.5+e/t*.5,1.5)}function yi(e,t){const i=e[0]/e[3],o=e[1]/e[3];return i>=-t[0]&&i<=t[0]&&o>=-t[1]&&o<=t[1]}function bi(t,i,o,r,s,n,a,l,c,h){const u=o.transform,d=r?t.textSizeData:t.iconSizeData,_=e.b5(d,o.transform.zoom),p="globe"===u.projection.name,f=[256/o.width*2+1,256/o.height*2+1],m=r?t.text.dynamicLayoutVertexArray:t.icon.dynamicLayoutVertexArray;m.clear();let g=null;p&&(g=r?t.text.globeExtVertexArray:t.icon.globeExtVertexArray);const v=t.lineVertexArray,x=r?t.text.placedSymbolArray:t.icon.placedSymbolArray,y=o.transform.width/o.transform.height;let b,w=!1;for(let r=0;r<x.length;r++){const p=x.get(r),{numGlyphs:T,writingMode:E}=p;if(E!==e.b6.vertical||w||b===e.b6.horizontal||(w=!0),b=E,(p.hidden||E===e.b6.vertical)&&!w){Di(T,m);continue}w=!1;const S=new e.P(p.tileAnchorX,p.tileAnchorY);let{x:C,y:I,z:D}=u.projection.projectTilePoint(S.x,S.y,h.canonical);if(c){const[e,t,i]=c(S);C+=e,I+=t,D+=i;}const L=[C,I,D,1];if(e.a7.transformMat4(L,L,i),!yi(L,f)){Di(T,m);continue}const A=L[3],R=xi(o.transform.getCameraToCenterDistance(u.projection),A),P=e.b7(d,_,p),M=a?P/R:P*R,z=vi(C,I,D,s);if(z[3]<=0){Di(T,m);continue}let O={};const F=a?null:c,B=Ei(p,M,!1,l,i,s,n,t.glyphOffsetArray,v,m,g,z,S,O,y,F,u.projection,h,a);w=B.useVertical,F&&B.needsFlipping&&(O={}),(B.notEnoughRoom||w||B.needsFlipping&&Ei(p,M,!0,l,i,s,n,t.glyphOffsetArray,v,m,g,z,S,O,y,F,u.projection,h,a).notEnoughRoom)&&Di(T,m);}r?(t.text.dynamicLayoutVertexBuffer.updateData(m),g&&t.text.globeExtVertexBuffer&&t.text.globeExtVertexBuffer.updateData(g)):(t.icon.dynamicLayoutVertexBuffer.updateData(m),g&&t.icon.globeExtVertexBuffer&&t.icon.globeExtVertexBuffer.updateData(g));}function wi(e,t,i,o,r,s,n,a,l,c,h,u,d,_,p,f){const{lineStartIndex:m,glyphStartIndex:g,segment:v}=a,x=g+a.numGlyphs,y=m+a.lineLength,b=t.getoffsetX(g),w=t.getoffsetX(x-1),T=Ii(e*b,i,o,r,s,n,v,m,y,l,c,h,u,d,!0,_,p,f);if(!T)return null;const E=Ii(e*w,i,o,r,s,n,v,m,y,l,c,h,u,d,!0,_,p,f);return E?{first:T,last:E}:null}function Ti(t,i,o,r){return t===e.b6.horizontal&&Math.abs(r)>Math.abs(o)?{useVertical:!0}:t===e.b6.vertical?r>0?{needsFlipping:!0}:null:i!==_i.unknown&&function(e,t){return 0===e||Math.abs(t/e)>pi}(o,r)?i===_i.flipRequired?{needsFlipping:!0}:null:o<0?{needsFlipping:!0}:null}function Ei(t,i,o,r,s,n,a,l,c,h,u,d,_,p,f,m,g,v,x){const y=i/24,b=t.lineOffsetX*y,w=t.lineOffsetY*y,{lineStartIndex:T,glyphStartIndex:E,numGlyphs:S,segment:C,writingMode:I,flipState:D}=t,L=T+t.lineLength,A=t=>{if(u){const[i,o,r]=t.up,s=h.length;e.b8(u,s+0,i,o,r),e.b8(u,s+1,i,o,r),e.b8(u,s+2,i,o,r),e.b8(u,s+3,i,o,r);}const[i,o,r]=t.point;e.b9(h,i,o,r,t.angle);};if(S>1){const e=wi(y,l,b,w,o,d,_,t,c,n,p,m,!1,g,v,x);if(!e)return {notEnoughRoom:!0};if(r&&!o){let[i,o,r]=e.first.point,[s,n,l]=e.last.point;[i,o]=vi(i,o,r,a),[s,n]=vi(s,n,l,a);const c=Ti(I,D,(s-i)*f,n-o);if(t.flipState=c&&c.needsFlipping?_i.flipRequired:_i.flipNotRequired,c)return c}A(e.first);for(let e=E+1;e<E+S-1;e++){const t=Ii(y*l.getoffsetX(e),b,w,o,d,_,C,T,L,c,n,p,m,!1,!1,g,v,x);if(!t)return h.length-=4*(e-E),{notEnoughRoom:!0};A(t);}A(e.last);}else {if(r&&!o){const i=vi(_.x,_.y,0,s),o=T+C+1,r=new e.P(c.getx(o),c.gety(o)),n=vi(r.x,r.y,0,s),a=n[3]>0?n:Ci(_,r,i,1,s,void 0,g,v.canonical),l=Ti(I,D,(a[0]-i[0])*f,a[1]-i[1]);if(t.flipState=l&&l.needsFlipping?_i.flipRequired:_i.flipNotRequired,l)return l}const i=Ii(y*l.getoffsetX(E),b,w,o,d,_,C,T,L,c,n,p,m,!1,!1,g,v,x);if(!i)return {notEnoughRoom:!0};A(i);}return {}}function Si(e,t,i,o,r){const{x:s,y:n,z:a}=o.projectTilePoint(e.x,e.y,t);if(!r)return vi(s,n,a,i);const[l,c,h]=r(e);return vi(s+l,n+c,a+h,i)}function Ci(t,i,o,r,s,n,a,l){const c=Si(t.sub(i)._unit()._add(t),l,s,a,n);return e.N.sub(c,o,c),e.N.normalize(c,c),e.N.scaleAndAdd(c,o,c,r)}function Ii(t,i,o,r,s,n,a,l,c,h,u,d,_,p,f,m,g,v){const x=r?t-i:t+i;let y=x>0?1:-1,b=0;r&&(y*=-1,b=Math.PI),y<0&&(b+=Math.PI);let w=l+a+(y>0?0:1)|0,T=s,E=s,S=0,C=0;const I=Math.abs(x),D=[],L=[];let A=n,R=A;const P=()=>Ci(R,A,E,I-S+1,u,_,m,g.canonical);for(;S+C<=I;){if(w+=y,w<l||w>=c)return null;if(E=T,R=A,D.push(E),p&&L.push(R),A=new e.P(h.getx(w),h.gety(w)),T=d[w],!T){const e=Si(A,g.canonical,u,m,_);T=e[3]>0?d[w]=e:P();}S+=C,C=e.N.distance(E,T);}f&&_&&(d[w]&&(T=P(),C=e.N.distance(E,T)),d[w]=T);const M=(I-S)/C,z=A.sub(R)._mult(M)._add(R),O=e.N.sub([],T,E),F=e.N.scaleAndAdd([],E,O,M);let B=[0,0,1],k=O[0],N=O[1];if(v&&(B=m.upVector(g.canonical,z.x,z.y),0!==B[0]||0!==B[1]||1!==B[2])){const t=[B[2],0,-B[0]],i=e.N.cross([],B,t);e.N.normalize(t,t),e.N.normalize(i,i),k=e.N.dot(O,t),N=e.N.dot(O,i);}if(o){const t=e.N.cross([],B,O);e.N.normalize(t,t),e.N.scaleAndAdd(F,F,t,o*y);}const U=b+Math.atan2(N,k);return D.push(F),p&&L.push(z),{point:F,angle:U,path:D,tilePath:L,up:B}}function Di(e,t){const i=t.length,o=i+4*e;t.resize(o),t.float32.fill(-1/0,4*i,4*o);}function Li(e,t,i){const o=t[0],r=t[1];return e[0]=i[0]*o+i[4]*r+i[12],e[1]=i[1]*o+i[5]*r+i[13],e[3]=i[3]*o+i[7]*r+i[15],e}const Ai=100;class Ri{constructor(e,t,i=new di(e.width+200,e.height+200,25),o=new di(e.width+200,e.height+200,25)){this.transform=e,this.grid=i,this.ignoredGrid=o,this.pitchfactor=Math.cos(e._pitch)*e.cameraToCenterDistance,this.screenRightBoundary=e.width+Ai,this.screenBottomBoundary=e.height+Ai,this.gridRightBoundary=e.width+200,this.gridBottomBoundary=e.height+200,this.fogState=t;}placeCollisionBox(e,t,i,o,r,s,n,a){let l=i.projectedAnchorX,c=i.projectedAnchorY,h=i.projectedAnchorZ;const u=i.elevation,d=i.tileID,_=e.getProjection();if(u&&d){const[e,t,o]=_.upVector(d.canonical,i.tileAnchorX,i.tileAnchorY),r=_.upVectorScale(d.canonical,this.transform.center.lat,this.transform.worldSize).metersToTile;l+=e*u*r,c+=t*u*r,h+=o*u*r;}const p=this.projectAndGetPerspectiveRatio(n,l,c,h,i.tileID,"globe"===_.name||!!u||this.transform.pitch>0,_),f=s*p.perspectiveRatio,m=(i.x1*t+o.x-i.padding)*f+p.point.x,g=(i.y1*t+o.y-i.padding)*f+p.point.y,v=(i.x2*t+o.x+i.padding)*f+p.point.x,x=(i.y2*t+o.y+i.padding)*f+p.point.y,y=p.perspectiveRatio<=.55||p.occluded;return !this.isInsideGrid(m,g,v,x)||!r&&this.grid.hitTest(m,g,v,x,a)||y?{box:[],offscreen:!1,occluded:p.occluded}:{box:[m,g,v,x],offscreen:this.isOffscreen(m,g,v,x),occluded:!1}}placeCollisionCircles(t,i,o,r,s,n,a,l,c,h,u,d,_,p,f){const m=[],g=this.transform.elevation,v=t.getProjection(),x=g?g.getAtTileOffsetFunc(f,this.transform.center.lat,this.transform.worldSize,v):null,y=new e.P(o.tileAnchorX,o.tileAnchorY);let{x:b,y:w,z:T}=v.projectTilePoint(y.x,y.y,f.canonical);if(x){const[e,t,i]=x(y);b+=e,w+=t,T+=i;}const E="globe"===v.name,S=this.projectAndGetPerspectiveRatio(a,b,w,T,f,E||!!g||this.transform.pitch>0,v),{perspectiveRatio:C}=S,I=(u?n/C:n*C)/e.bc,D=vi(b,w,T,l),L=S.signedDistanceFromCamera>0?wi(I,s,o.lineOffsetX*I,o.lineOffsetY*I,!1,D,y,o,r,l,{},g&&!u?x:null,u&&!!g,v,f,u):null;let A=!1,R=!1,P=!0;if(L&&!S.occluded){const t=.5*_*C+p,o=new e.P(-100,-100),r=new e.P(this.screenRightBoundary,this.screenBottomBoundary),s=new ui,{first:n,last:a}=L,l=n.path.length;let u=[];for(let e=l-1;e>=1;e--)u.push(n.path[e]);for(let e=1;e<a.path.length;e++)u.push(a.path[e]);const f=2.5*t;c&&(u=u.map((([e,t,i],o)=>(x&&!E&&(i=x(o<l-1?n.tilePath[l-1-o]:a.tilePath[o-l+2])[2]),vi(e,t,i,c)))),u.some((e=>e[3]<=0))&&(u=[]));let g=[];if(u.length>0){let t=1/0,i=-1/0,s=1/0,n=-1/0;for(const e of u)t=Math.min(t,e[0]),s=Math.min(s,e[1]),i=Math.max(i,e[0]),n=Math.max(n,e[1]);i>=o.x&&t<=r.x&&n>=o.y&&s<=r.y&&(g=[u.map((t=>new e.P(t[0],t[1])))],(t<o.x||i>r.x||s<o.y||n>r.y)&&(g=e.ba(g,o.x,o.y,r.x,r.y)));}for(const e of g){s.reset(e,.25*t);let o=0;o=s.length<=.5*t?1:Math.ceil(s.paddedLength/f)+1;for(let e=0;e<o;e++){const r=e/Math.max(o-1,1),n=s.lerp(r),a=n.x+Ai,l=n.y+Ai;m.push(a,l,t,0);const c=a-t,u=l-t,_=a+t,p=l+t;if(P=P&&this.isOffscreen(c,u,_,p),R=R||this.isInsideGrid(c,u,_,p),!i&&this.grid.hitTestCircle(a,l,t,d)&&(A=!0,!h))return {circles:[],offscreen:!1,collisionDetected:A,occluded:!1}}}}return {circles:!h&&A||!R?[]:m,offscreen:P,collisionDetected:A,occluded:S.occluded}}queryRenderedSymbols(t){if(0===t.length||0===this.grid.keysLength()&&0===this.ignoredGrid.keysLength())return {};const i=[];let o=1/0,r=1/0,s=-1/0,n=-1/0;for(const a of t){const t=new e.P(a.x+Ai,a.y+Ai);o=Math.min(o,t.x),r=Math.min(r,t.y),s=Math.max(s,t.x),n=Math.max(n,t.y),i.push(t);}const a=this.grid.query(o,r,s,n).concat(this.ignoredGrid.query(o,r,s,n)),l={},c={};for(const t of a){const o=t.key;if(void 0===l[o.bucketInstanceId]&&(l[o.bucketInstanceId]={}),l[o.bucketInstanceId][o.featureIndex])continue;const r=[new e.P(t.x1,t.y1),new e.P(t.x2,t.y1),new e.P(t.x2,t.y2),new e.P(t.x1,t.y2)];e.bb(i,r)&&(l[o.bucketInstanceId][o.featureIndex]=!0,void 0===c[o.bucketInstanceId]&&(c[o.bucketInstanceId]=[]),c[o.bucketInstanceId].push(o.featureIndex));}return c}insertCollisionBox(e,t,i,o,r){(t?this.ignoredGrid:this.grid).insert({bucketInstanceId:i,featureIndex:o,collisionGroupID:r},e[0],e[1],e[2],e[3]);}insertCollisionCircles(e,t,i,o,r){const s=t?this.ignoredGrid:this.grid,n={bucketInstanceId:i,featureIndex:o,collisionGroupID:r};for(let t=0;t<e.length;t+=4)s.insertCircle(n,e[t],e[t+1],e[t+2]);}projectAndGetPerspectiveRatio(t,i,o,r,s,n,a){const l=[i,o,r,1];let c=!1;if(r||this.transform.pitch>0){if(e.a7.transformMat4(l,l,t),this.fogState&&s&&"globe"!==a.name){const t=function(t,i,o,r,s,n){const a=n.calculateFogTileMatrix(s),l=[i,o,r];return e.N.transformMat4(l,l,a),ge(t,e.N.length(l),n.pitch,n._fov)}(this.fogState,i,o,r,s.toUnwrapped(),this.transform);c=t>.9;}}else Li(l,l,t);const h=l[3];return {point:new e.P((l[0]/h+1)/2*this.transform.width+Ai,(-l[1]/h+1)/2*this.transform.height+Ai),perspectiveRatio:Math.min(.5+this.transform.getCameraToCenterDistance(a)/h*.5,1.5),signedDistanceFromCamera:h,occluded:n&&l[2]>h||c}}isOffscreen(e,t,i,o){return i<Ai||e>=this.screenRightBoundary||o<Ai||t>this.screenBottomBoundary}isInsideGrid(e,t,i,o){return i>=0&&e<this.gridRightBoundary&&o>=0&&t<this.gridBottomBoundary}getViewportMatrix(){const t=e.a6.identity([]);return e.a6.translate(t,t,[-100,-100,0]),t}}function Pi(t,i,o){const r=i.createTileMatrix(t,t.worldSize,o.toUnwrapped());return e.a6.multiply(new Float32Array(16),t.projMatrix,r)}function Mi(e,t,i){if(t.projection.name===i.projection.name)return e.projMatrix;const o=i.clone();return o.setProjection(t.projection),Pi(o,t.getProjection(),e)}function zi(e,t,i){return t.name===i.projection.name?e.projMatrix:Pi(i,t,e)}class Oi{constructor(e,t,i,o){this.opacity=e?Math.max(0,Math.min(1,e.opacity+(e.placed?t:-t))):o&&i?1:0,this.placed=i;}isHidden(){return 0===this.opacity&&!this.placed}}class Fi{constructor(e,t,i,o,r,s=!1){this.text=new Oi(e?e.text:null,t,i,r),this.icon=new Oi(e?e.icon:null,t,o,r),this.clipped=s;}isHidden(){return this.text.isHidden()&&this.icon.isHidden()}}class Bi{constructor(e,t,i,o=!1){this.text=e,this.icon=t,this.skipFade=i,this.clipped=o;}}class ki{constructor(){this.invProjMatrix=e.a6.create(),this.viewportMatrix=e.a6.create(),this.circles=[];}}class Ni{constructor(e,t,i,o,r){this.bucketInstanceId=e,this.featureIndex=t,this.sourceLayerIndex=i,this.bucketIndex=o,this.tileID=r;}}class Ui{constructor(e){this.crossSourceCollisions=e,this.maxGroupID=0,this.collisionGroups={};}get(e){if(this.crossSourceCollisions)return {ID:0,predicate:null};if(!this.collisionGroups[e]){const t=++this.maxGroupID;this.collisionGroups[e]={ID:t,predicate:e=>e.collisionGroupID===t};}return this.collisionGroups[e]}}function Gi(t,i,o,r,s){const{horizontalAlign:n,verticalAlign:a}=e.bf(t),l=-(n-.5)*i,c=-(a-.5)*o,h=e.bd(t,r);return new e.P(l+h[0]*s,c+h[1]*s)}function ji(t,i,o,r,s){const n=new e.P(t,i);return o&&n._rotate(r?s:-s),n}class Vi{constructor(e,t,i,o,r,s){this.transform=e.clone(),this.projection=e.projection.name,this.collisionIndex=new Ri(this.transform,r),this.buildingIndex=s,this.placements={},this.opacities={},this.variableOffsets={},this.stale=!1,this.commitTime=0,this.fadeDuration=t,this.retainedQueryData={},this.collisionGroups=new Ui(i),this.collisionCircleArrays={},this.prevPlacement=o,o&&(o.prevPlacement=void 0),this.placedOrientations={};}getBucketParts(t,i,o,r){const s=o.getBucket(i),n=o.latestFeatureIndex;if(!s||!n||i.fqid!==s.layerIds[0])return;const a=s.layers[0].layout,l=o.collisionBoxArray,c=Math.pow(2,this.transform.zoom-o.tileID.overscaledZ),h=o.tileSize/e.V,u=o.tileID.toUnwrapped();this.transform.setProjection(s.projection);const d=(_=o.tileID,p=s.getProjection(),f=this.transform,p.name===this.projection?f.calculateProjMatrix(_.toUnwrapped()):Pi(f,p,_));var _,p,f;const m="map"===a.get("text-pitch-alignment"),g="map"===a.get("text-rotation-alignment");i.compileFilter();const v=i.dynamicFilter(),x=i.dynamicFilterNeedsFeature(),y=this.transform.calculatePixelsToTileUnitsMatrix(o),b=mi(d,o.tileID.canonical,m,g,this.transform,s.getProjection(),y);let w=null;if(m){const t=gi(d,o.tileID.canonical,m,g,this.transform,s.getProjection(),y);w=e.a6.multiply([],this.transform.labelPlaneMatrix,t);}let T=null;v&&o.latestFeatureIndex&&(T={unwrappedTileID:u,dynamicFilter:v,dynamicFilterNeedsFeature:x,featureIndex:o.latestFeatureIndex}),this.retainedQueryData[s.bucketInstanceId]=new Ni(s.bucketInstanceId,n,s.sourceLayerIndex,s.index,o.tileID);const E={bucket:s,layout:a,posMatrix:d,textLabelPlaneMatrix:b,labelToScreenMatrix:w,clippingData:T,scale:c,textPixelRatio:h,holdingForFade:o.holdingForFade(),collisionBoxArray:l,partiallyEvaluatedTextSize:e.b5(s.textSizeData,this.transform.zoom),partiallyEvaluatedIconSize:e.b5(s.iconSizeData,this.transform.zoom),collisionGroup:this.collisionGroups.get(s.sourceID)};if(r)for(const e of s.sortKeyRanges){const{sortKey:i,symbolInstanceStart:o,symbolInstanceEnd:r}=e;t.push({sortKey:i,symbolInstanceStart:o,symbolInstanceEnd:r,parameters:E});}else t.push({symbolInstanceStart:0,symbolInstanceEnd:s.symbolInstances.length,parameters:E});}attemptAnchorPlacement(e,t,i,o,r,s,n,a,l,c,h,u,d,_,p,f,m,g){const{textOffset0:v,textOffset1:x,crossTileID:y}=u,b=[v,x],w=Gi(e,i,o,b,r),T=this.collisionIndex.placeCollisionBox(_,r,t,ji(w.x,w.y,s,n,this.transform.angle),h,a,l,c.predicate);if(f){const e=_.getSymbolInstanceIconSize(g,this.transform.zoom,u.placedIconSymbolIndex);if(0===this.collisionIndex.placeCollisionBox(_,e,f,ji(w.x,w.y,s,n,this.transform.angle),h,a,l,c.predicate).box.length)return}if(T.box.length>0){let t;return this.prevPlacement&&this.prevPlacement.variableOffsets[y]&&this.prevPlacement.placements[y]&&this.prevPlacement.placements[y].text&&(t=this.prevPlacement.variableOffsets[y].anchor),this.variableOffsets[y]={textOffset:b,width:i,height:o,anchor:e,textScale:r,prevAnchor:t},this.markUsedJustification(_,e,u,p),_.allowVerticalPlacement&&(this.markUsedOrientation(_,p,u),this.placedOrientations[y]=p),{shift:w,placedGlyphBoxes:T}}}placeLayerBucketPart(t,i,o,r){const{bucket:s,layout:n,posMatrix:a,textLabelPlaneMatrix:l,labelToScreenMatrix:c,clippingData:h,textPixelRatio:u,holdingForFade:d,collisionBoxArray:_,partiallyEvaluatedTextSize:p,partiallyEvaluatedIconSize:f,collisionGroup:m}=t.parameters,g=n.get("text-optional"),v=n.get("icon-optional"),x=n.get("text-allow-overlap"),y=n.get("icon-allow-overlap"),b="map"===n.get("text-rotation-alignment"),w="map"===n.get("text-pitch-alignment"),T="viewport-y"===n.get("symbol-z-order"),E=n.get("symbol-z-elevate");this.transform.setProjection(s.projection);let S=x&&(y||!s.hasIconData()||v),C=y&&(x||!s.hasTextData()||g);!s.collisionArrays&&_&&s.deserializeCollisionBoxes(_),o&&r&&s.updateCollisionDebugBuffers(this.transform.zoom,_);const I=(t,r,_)=>{const{crossTileID:T,numVerticalGlyphVertices:E}=t;if(h){const o={zoom:this.transform.zoom,pitch:this.transform.pitch};let r=null;if(h.dynamicFilterNeedsFeature){const e=this.retainedQueryData[s.bucketInstanceId];r=h.featureIndex.loadFeature({featureIndex:t.featureIndex,bucketIndex:e.bucketIndex,sourceLayerIndex:e.sourceLayerIndex,layoutVertexArrayOffset:0});}if(!(0,h.dynamicFilter)(o,r,this.retainedQueryData[s.bucketInstanceId].tileID.canonical,new e.P(t.tileAnchorX,t.tileAnchorY),this.transform.calculateDistanceTileData(h.unwrappedTileID)))return this.placements[T]=new Bi(!1,!1,!1,!0),void i.add(T)}if(i.has(T))return;if(d)return void(this.placements[T]=new Bi(!1,!1,!1));let I=!1,D=!1,L=!0,A=!1,R=!1,P=null,M={box:null,offscreen:null,occluded:null},z={box:null,offscreen:null,occluded:null},O=null,F=null,B=null,k=0,N=0,U=0;_.textFeatureIndex?k=_.textFeatureIndex:t.useRuntimeCollisionCircles&&(k=t.featureIndex),_.verticalTextFeatureIndex&&(N=_.verticalTextFeatureIndex);const G=e=>{e.tileID=this.retainedQueryData[s.bucketInstanceId].tileID;const i=this.transform.elevation;e.elevation=t.zOffset+(i?i.getAtTileOffset(e.tileID,e.tileAnchorX,e.tileAnchorY):0);},j=_.textBox;if(j){G(j);const i=i=>{let o=e.b6.horizontal;if(s.allowVerticalPlacement&&!i&&this.prevPlacement){const e=this.prevPlacement.placedOrientations[T];e&&(this.placedOrientations[T]=e,o=e,this.markUsedOrientation(s,o,t));}return o},o=(t,i)=>{if(s.allowVerticalPlacement&&E>0&&_.verticalTextBox){for(const o of s.writingModes)if(o===e.b6.vertical?(M=i(),z=M):M=t(),M&&M.box&&M.box.length)break}else M=t();};if(n.get("text-variable-anchor")){let l=n.get("text-variable-anchor");if(this.prevPlacement&&this.prevPlacement.variableOffsets[T]){const e=this.prevPlacement.variableOffsets[T];l.indexOf(e.anchor)>0&&(l=l.filter((t=>t!==e.anchor)),l.unshift(e.anchor));}const c=(e,i,o)=>{const n=s.getSymbolInstanceTextSize(p,t,this.transform.zoom,r),c=(e.x2-e.x1)*n+2*e.padding,h=(e.y2-e.y1)*n+2*e.padding,d=t.hasIconTextFit&&!y?i:null;d&&G(d);let _={box:[],offscreen:!1,occluded:!1};const g=x?2*l.length:l.length;for(let i=0;i<g;++i){const g=this.attemptAnchorPlacement(l[i%l.length],e,c,h,n,b,w,u,a,m,i>=l.length,t,r,s,o,d,p,f);if(g&&(_=g.placedGlyphBoxes,_&&_.box&&_.box.length)){I=!0,P=g.shift;break}}return _};o((()=>c(j,_.iconBox,e.b6.horizontal)),(()=>{const t=_.verticalTextBox;return t&&G(t),s.allowVerticalPlacement&&!(M&&M.box&&M.box.length)&&E>0&&t?c(t,_.verticalIconBox,e.b6.vertical):{box:null,offscreen:null,occluded:null}})),M&&(I=M.box,L=M.offscreen,A=M.occluded);const h=i(!(!M||!M.box));if(!I&&this.prevPlacement){const e=this.prevPlacement.variableOffsets[T];e&&(this.variableOffsets[T]=e,this.markUsedJustification(s,e.anchor,t,h));}}else {const n=(i,o)=>{const n=s.getSymbolInstanceTextSize(p,t,this.transform.zoom,r),l=this.collisionIndex.placeCollisionBox(s,n,i,new e.P(0,0),x,u,a,m.predicate);return l&&l.box&&l.box.length&&(this.markUsedOrientation(s,o,t),this.placedOrientations[T]=o),l};o((()=>n(j,e.b6.horizontal)),(()=>{const t=_.verticalTextBox;return s.allowVerticalPlacement&&E>0&&t?(G(t),n(t,e.b6.vertical)):{box:null,offscreen:null,occluded:null}})),i(!!(M&&M.box&&M.box.length));}}if(O=M,I=O&&O.box&&O.box.length>0,L=O&&O.offscreen,A=O&&O.occluded,t.useRuntimeCollisionCircles){const i=s.text.placedSymbolArray.get(t.centerJustifiedTextSymbolIndex>=0?t.centerJustifiedTextSymbolIndex:t.verticalPlacedTextSymbolIndex),r=e.b7(s.textSizeData,p,i),h=n.get("text-padding");F=this.collisionIndex.placeCollisionCircles(s,x,i,s.lineVertexArray,s.glyphOffsetArray,r,a,l,c,o,w,m.predicate,t.collisionCircleDiameter*r/e.bc,h,this.retainedQueryData[s.bucketInstanceId].tileID),I=x||F.circles.length>0&&!F.collisionDetected,L=L&&F.offscreen,A=F.occluded;}if(_.iconFeatureIndex&&(U=_.iconFeatureIndex),_.iconBox){const i=i=>{G(i);const o=t.hasIconTextFit&&P?ji(P.x,P.y,b,w,this.transform.angle):new e.P(0,0),r=s.getSymbolInstanceIconSize(f,this.transform.zoom,t.placedIconSymbolIndex);return this.collisionIndex.placeCollisionBox(s,r,i,o,y,u,a,m.predicate)};z&&z.box&&z.box.length&&_.verticalIconBox?(B=i(_.verticalIconBox),D=B.box.length>0):(B=i(_.iconBox),D=B.box.length>0),L=L&&B.offscreen,R=B.occluded;}const V=g||0===t.numHorizontalGlyphVertices&&0===E,Z=v||0===t.numIconVertices;if(V||Z?Z?V||(D=D&&I):I=D&&I:D=I=D&&I,I&&O&&O.box&&this.collisionIndex.insertCollisionBox(O.box,n.get("text-ignore-placement"),s.bucketInstanceId,z&&z.box&&N?N:k,m.ID),D&&B&&this.collisionIndex.insertCollisionBox(B.box,n.get("icon-ignore-placement"),s.bucketInstanceId,U,m.ID),F&&(I&&this.collisionIndex.insertCollisionCircles(F.circles,n.get("text-ignore-placement"),s.bucketInstanceId,k,m.ID),o)){const e=s.bucketInstanceId;let t=this.collisionCircleArrays[e];void 0===t&&(t=this.collisionCircleArrays[e]=new ki);for(let e=0;e<F.circles.length;e+=4)t.circles.push(F.circles[e+0]),t.circles.push(F.circles[e+1]),t.circles.push(F.circles[e+2]),t.circles.push(F.collisionDetected?1:0);}const H="globe"!==s.projection.name;S=S&&(H||!A),C=C&&(H||!R),this.placements[T]=new Bi(I||S,D||C,L||s.justReloaded),i.add(T);};if(E&&this.buildingIndex&&(this.buildingIndex.updateZOffset(s,this.retainedQueryData[s.bucketInstanceId].tileID),s.updateZOffset()),T){const t=s.getSortedSymbolIndexes(this.transform.angle);for(let e=t.length-1;e>=0;--e){const i=t[e];I(s.symbolInstances.get(i),i,s.collisionArrays[i]);}s.hasAnyZOffset&&e.w(`${s.layerIds[0]} layer symbol-z-elevate: symbols are not sorted by elevation if symbol-z-order is evaluated to viewport-y`);}else if(s.hasAnyZOffset){const e=s.getSortedIndexesByZOffset();for(let t=0;t<e.length;++t){const i=e[t];I(s.symbolInstances.get(i),i,s.collisionArrays[i]);}}else for(let e=t.symbolInstanceStart;e<t.symbolInstanceEnd;e++)I(s.symbolInstances.get(e),e,s.collisionArrays[e]);if(o&&s.bucketInstanceId in this.collisionCircleArrays){const t=this.collisionCircleArrays[s.bucketInstanceId];e.a6.invert(t.invProjMatrix,a),t.viewportMatrix=this.collisionIndex.getViewportMatrix();}s.justReloaded=!1;}markUsedJustification(t,i,o,r){const{leftJustifiedTextSymbolIndex:s,centerJustifiedTextSymbolIndex:n,rightJustifiedTextSymbolIndex:a,verticalPlacedTextSymbolIndex:l,crossTileID:c}=o,h=e.be(i),u=r===e.b6.vertical?l:"left"===h?s:"center"===h?n:"right"===h?a:-1;s>=0&&(t.text.placedSymbolArray.get(s).crossTileID=u>=0&&s!==u?0:c),n>=0&&(t.text.placedSymbolArray.get(n).crossTileID=u>=0&&n!==u?0:c),a>=0&&(t.text.placedSymbolArray.get(a).crossTileID=u>=0&&a!==u?0:c),l>=0&&(t.text.placedSymbolArray.get(l).crossTileID=u>=0&&l!==u?0:c);}markUsedOrientation(t,i,o){const r=i===e.b6.horizontal||i===e.b6.horizontalOnly?i:0,s=i===e.b6.vertical?i:0,{leftJustifiedTextSymbolIndex:n,centerJustifiedTextSymbolIndex:a,rightJustifiedTextSymbolIndex:l,verticalPlacedTextSymbolIndex:c}=o,h=t.text.placedSymbolArray;n>=0&&(h.get(n).placedOrientation=r),a>=0&&(h.get(a).placedOrientation=r),l>=0&&(h.get(l).placedOrientation=r),c>=0&&(h.get(c).placedOrientation=s);}commit(e){this.commitTime=e,this.zoomAtLastRecencyCheck=this.transform.zoom;const t=this.prevPlacement;let i=!1;this.prevZoomAdjustment=t?t.zoomAdjustment(this.transform.zoom):0;const o=t?t.symbolFadeChange(e):1,r=t?t.opacities:{},s=t?t.variableOffsets:{},n=t?t.placedOrientations:{};for(const e in this.placements){const t=this.placements[e],s=r[e];s?(this.opacities[e]=new Fi(s,o,t.text,t.icon,null,t.clipped),i=i||t.text!==s.text.placed||t.icon!==s.icon.placed):(this.opacities[e]=new Fi(null,o,t.text,t.icon,t.skipFade,t.clipped),i=i||t.text||t.icon);}for(const e in r){const t=r[e];if(!this.opacities[e]){const r=new Fi(t,o,!1,!1);r.isHidden()||(this.opacities[e]=r,i=i||t.text.placed||t.icon.placed);}}for(const e in s)this.variableOffsets[e]||!this.opacities[e]||this.opacities[e].isHidden()||(this.variableOffsets[e]=s[e]);for(const e in n)this.placedOrientations[e]||!this.opacities[e]||this.opacities[e].isHidden()||(this.placedOrientations[e]=n[e]);i?this.lastPlacementChangeTime=e:"number"!=typeof this.lastPlacementChangeTime&&(this.lastPlacementChangeTime=t?t.lastPlacementChangeTime:e);}updateLayerOpacities(e,t){const i=new Set;for(const o of t){const t=o.getBucket(e);t&&o.latestFeatureIndex&&e.fqid===t.layerIds[0]&&(this.updateBucketOpacities(t,i,o.collisionBoxArray),t.layers[0].layout.get("symbol-z-elevate")&&this.buildingIndex&&(this.buildingIndex.updateZOffset(t,o.tileID),t.updateZOffset()));}}updateBucketOpacities(t,i,o){t.hasTextData()&&t.text.opacityVertexArray.clear(),t.hasIconData()&&t.icon.opacityVertexArray.clear(),t.hasIconCollisionBoxData()&&t.iconCollisionBox.collisionVertexArray.clear(),t.hasTextCollisionBoxData()&&t.textCollisionBox.collisionVertexArray.clear();const r=t.layers[0].layout,s=!!t.layers[0].dynamicFilter(),n=new Fi(null,0,!1,!1,!0),a=r.get("text-allow-overlap"),l=r.get("icon-allow-overlap"),c=r.get("text-variable-anchor"),h="map"===r.get("text-rotation-alignment"),u="map"===r.get("text-pitch-alignment"),d=new Fi(null,0,a&&(l||!t.hasIconData()||r.get("icon-optional")),l&&(a||!t.hasTextData()||r.get("text-optional")),!0);!t.collisionArrays&&o&&(t.hasIconCollisionBoxData()||t.hasTextCollisionBoxData())&&t.deserializeCollisionBoxes(o);const _=(e,t,i)=>{for(let o=0;o<t/4;o++)e.opacityVertexArray.emplaceBack(i);};let p=0;for(let o=0;o<t.symbolInstances.length;o++){const r=t.symbolInstances.get(o),{numHorizontalGlyphVertices:a,numVerticalGlyphVertices:l,crossTileID:f,numIconVertices:m}=r,g=i.has(f);let v=this.opacities[f];g?v=n:v||(v=d,this.opacities[f]=v),i.add(f);const x=a>0||l>0,y=m>0,b=this.placedOrientations[f],w=b===e.b6.vertical,T=b===e.b6.horizontal||b===e.b6.horizontalOnly;if(!x&&!y||v.isHidden()||p++,x){const e=Ji(v.text);_(t.text,a,w?Qi:e),_(t.text,l,T?Qi:e);const i=v.text.isHidden(),{leftJustifiedTextSymbolIndex:o,centerJustifiedTextSymbolIndex:s,rightJustifiedTextSymbolIndex:n,verticalPlacedTextSymbolIndex:c}=r,h=t.text.placedSymbolArray,u=i||w?1:0;o>=0&&(h.get(o).hidden=u),s>=0&&(h.get(s).hidden=u),n>=0&&(h.get(n).hidden=u),c>=0&&(h.get(c).hidden=i||T?1:0);const d=this.variableOffsets[f];d&&this.markUsedJustification(t,d.anchor,r,b);const p=this.placedOrientations[f];p&&(this.markUsedJustification(t,"left",r,p),this.markUsedOrientation(t,p,r));}if(y){const e=Ji(v.icon),{placedIconSymbolIndex:i,verticalPlacedIconSymbolIndex:o}=r,s=t.icon.placedSymbolArray,n=v.icon.isHidden()?1:0;i>=0&&(_(t.icon,m,w?Qi:e),s.get(i).hidden=n),o>=0&&(_(t.icon,r.numVerticalIconVertices,T?Qi:e),s.get(o).hidden=n);}if(t.hasIconCollisionBoxData()||t.hasTextCollisionBoxData()){const i=t.collisionArrays[o];if(i){let o=new e.P(0,0),n=!0;if(i.textBox||i.verticalTextBox){if(c){const e=this.variableOffsets[f];e?(o=Gi(e.anchor,e.width,e.height,e.textOffset,e.textScale),h&&o._rotate(u?this.transform.angle:-this.transform.angle)):n=!1;}s&&(n=!v.clipped),i.textBox&&Zi(t.textCollisionBox.collisionVertexArray,v.text.placed,!n||w,o.x,o.y),i.verticalTextBox&&Zi(t.textCollisionBox.collisionVertexArray,v.text.placed,!n||T,o.x,o.y);}const a=n&&Boolean(!T&&i.verticalIconBox);i.iconBox&&Zi(t.iconCollisionBox.collisionVertexArray,v.icon.placed,a,r.hasIconTextFit?o.x:0,r.hasIconTextFit?o.y:0),i.verticalIconBox&&Zi(t.iconCollisionBox.collisionVertexArray,v.icon.placed,!a,r.hasIconTextFit?o.x:0,r.hasIconTextFit?o.y:0);}}}if(t.fullyClipped=0===p,t.sortFeatures(this.transform.angle),this.retainedQueryData[t.bucketInstanceId]&&(this.retainedQueryData[t.bucketInstanceId].featureSortOrder=t.featureSortOrder),t.hasTextData()&&t.text.opacityVertexBuffer&&t.text.opacityVertexBuffer.updateData(t.text.opacityVertexArray),t.hasIconData()&&t.icon.opacityVertexBuffer&&t.icon.opacityVertexBuffer.updateData(t.icon.opacityVertexArray),t.hasIconCollisionBoxData()&&t.iconCollisionBox.collisionVertexBuffer&&t.iconCollisionBox.collisionVertexBuffer.updateData(t.iconCollisionBox.collisionVertexArray),t.hasTextCollisionBoxData()&&t.textCollisionBox.collisionVertexBuffer&&t.textCollisionBox.collisionVertexBuffer.updateData(t.textCollisionBox.collisionVertexArray),t.bucketInstanceId in this.collisionCircleArrays){const e=this.collisionCircleArrays[t.bucketInstanceId];t.placementInvProjMatrix=e.invProjMatrix,t.placementViewportMatrix=e.viewportMatrix,t.collisionCircleArray=e.circles,delete this.collisionCircleArrays[t.bucketInstanceId];}}symbolFadeChange(e){return 0===this.fadeDuration?1:(e-this.commitTime)/this.fadeDuration+this.prevZoomAdjustment}zoomAdjustment(e){return Math.max(0,(this.transform.zoom-e)/1.5)}hasTransitions(e){return this.stale||e-this.lastPlacementChangeTime<this.fadeDuration}stillRecent(e,t){const i=this.zoomAtLastRecencyCheck===t?1-this.zoomAdjustment(t):1;return this.zoomAtLastRecencyCheck=t,this.commitTime+this.fadeDuration*i>e}setStale(){this.stale=!0;}}function Zi(e,t,i,o,r){e.emplaceBack(t?1:0,i?1:0,o||0,r||0),e.emplaceBack(t?1:0,i?1:0,o||0,r||0),e.emplaceBack(t?1:0,i?1:0,o||0,r||0),e.emplaceBack(t?1:0,i?1:0,o||0,r||0);}const Hi=Math.pow(2,25),Wi=Math.pow(2,24),qi=Math.pow(2,17),$i=Math.pow(2,16),Xi=Math.pow(2,9),Ki=Math.pow(2,8),Yi=Math.pow(2,1);function Ji(e){if(0===e.opacity&&!e.placed)return 0;if(1===e.opacity&&e.placed)return 4294967295;const t=e.placed?1:0,i=Math.floor(127*e.opacity);return i*Hi+t*Wi+i*qi+t*$i+i*Xi+t*Ki+i*Yi+t}const Qi=0;class eo{constructor(e){this._sortAcrossTiles="viewport-y"!==e.layout.get("symbol-z-order")&&void 0!==e.layout.get("symbol-sort-key").constantOr(1),this._currentTileIndex=0,this._currentPartIndex=0,this._seenCrossTileIDs=new Set,this._bucketParts=[];}continuePlacement(e,t,i,o,r){const s=this._bucketParts;for(;this._currentTileIndex<e.length;)if(t.getBucketParts(s,o,e[this._currentTileIndex],this._sortAcrossTiles),this._currentTileIndex++,r())return !0;for(this._sortAcrossTiles&&(this._sortAcrossTiles=!1,s.sort(((e,t)=>e.sortKey-t.sortKey)));this._currentPartIndex<s.length;){const e=s[this._currentPartIndex];if(t.placeLayerBucketPart(e,this._seenCrossTileIDs,i,0===e.symbolInstanceStart),this._currentPartIndex++,r())return !0}return !1}}class to{constructor(e,t,i,o,r,s,n,a,l){this.placement=new Vi(e,r,s,n,a,l),this._currentPlacementIndex=t.length-1,this._forceFullPlacement=i,this._showCollisionBoxes=o,this._done=!1;}isDone(){return this._done}continuePlacement(t,i,o,r){const s=e.f.now(),n=()=>{const t=e.f.now()-s;return !this._forceFullPlacement&&t>2};for(;this._currentPlacementIndex>=0;){const s=i[t[this._currentPlacementIndex]],a=this.placement.collisionIndex.transform.zoom;if("symbol"===s.type&&(!s.minzoom||s.minzoom<=a)&&(!s.maxzoom||s.maxzoom>a)){const t=s,i=t.layout.get("symbol-z-elevate"),a=this._inProgressLayer=this._inProgressLayer||new eo(t),l=e.ag(s.source,s.scope);if(a.continuePlacement(i?r[l]:o[l],this.placement,this._showCollisionBoxes,s,n))return;delete this._inProgressLayer;}this._currentPlacementIndex--;}this._done=!0;}commit(e){return this.placement.commit(e),this.placement}}const io=512/e.V/2;class oo{constructor(t,i,o){this.tileID=t,this.bucketInstanceId=o,this.index=new e.bg(i.length,16,Int32Array),this.keys=[],this.crossTileIDs=[];const r=t.canonical.x*e.V,s=t.canonical.y*e.V;for(let e=0;e<i.length;e++){const{key:t,crossTileID:o,tileAnchorX:n,tileAnchorY:a}=i.get(e),l=Math.floor((r+n)*io),c=Math.floor((s+a)*io);this.index.add(l,c),this.keys.push(t),this.crossTileIDs.push(o);}this.index.finish();}findMatches(t,i,o){const r=this.tileID.canonical.z<i.canonical.z?1:Math.pow(2,this.tileID.canonical.z-i.canonical.z),s=io/Math.pow(2,i.canonical.z-this.tileID.canonical.z),n=i.canonical.x*e.V,a=i.canonical.y*e.V;for(let e=0;e<t.length;e++){const i=t.get(e);if(i.crossTileID)continue;const{key:l,tileAnchorX:c,tileAnchorY:h}=i,u=Math.floor((n+c)*s),d=Math.floor((a+h)*s),_=this.index.range(u-r,d-r,u+r,d+r);for(const e of _){const t=this.crossTileIDs[e];if(this.keys[e]===l&&!o.has(t)){o.add(t),i.crossTileID=t;break}}}}}class ro{constructor(){this.maxCrossTileID=0;}generate(){return ++this.maxCrossTileID}}class so{constructor(){this.indexes={},this.usedCrossTileIDs={},this.lng=0;}handleWrapJump(e){const t=Math.round((e-this.lng)/360);if(0!==t)for(const e in this.indexes){const i=this.indexes[e],o={};for(const e in i){const r=i[e];r.tileID=r.tileID.unwrapTo(r.tileID.wrap+t),o[r.tileID.key]=r;}this.indexes[e]=o;}this.lng=e;}addBucket(e,t,i){if(this.indexes[e.overscaledZ]&&this.indexes[e.overscaledZ][e.key]){if(this.indexes[e.overscaledZ][e.key].bucketInstanceId===t.bucketInstanceId)return !1;this.removeBucketCrossTileIDs(e.overscaledZ,this.indexes[e.overscaledZ][e.key]);}for(let e=0;e<t.symbolInstances.length;e++)t.symbolInstances.get(e).crossTileID=0;this.usedCrossTileIDs[e.overscaledZ]||(this.usedCrossTileIDs[e.overscaledZ]=new Set);const o=this.usedCrossTileIDs[e.overscaledZ];for(const i in this.indexes){const r=this.indexes[i];if(Number(i)>e.overscaledZ)for(const i in r){const s=r[i];s.tileID.isChildOf(e)&&s.findMatches(t.symbolInstances,e,o);}else {const s=r[e.scaledTo(Number(i)).key];s&&s.findMatches(t.symbolInstances,e,o);}}for(let e=0;e<t.symbolInstances.length;e++){const r=t.symbolInstances.get(e);r.crossTileID||(r.crossTileID=i.generate(),o.add(r.crossTileID));}return void 0===this.indexes[e.overscaledZ]&&(this.indexes[e.overscaledZ]={}),this.indexes[e.overscaledZ][e.key]=new oo(e,t.symbolInstances,t.bucketInstanceId),!0}removeBucketCrossTileIDs(e,t){for(const i of t.crossTileIDs)this.usedCrossTileIDs[e].delete(i);}removeStaleBuckets(e){let t=!1;for(const i in this.indexes){const o=this.indexes[i];for(const r in o)e[o[r].bucketInstanceId]||(this.removeBucketCrossTileIDs(i,o[r]),delete o[r],t=!0);}return t}}class no{constructor(){this.layerIndexes={},this.crossTileIDs=new ro,this.maxBucketInstanceId=0,this.bucketsInCurrentPlacement={};}addLayer(e,t,i,o){let r=this.layerIndexes[e.fqid];void 0===r&&(r=this.layerIndexes[e.fqid]=new so);let s=!1;const n={};"globe"!==o.name&&r.handleWrapJump(i);for(const i of t){const t=i.getBucket(e);t&&e.fqid===t.layerIds[0]&&(t.bucketInstanceId||(t.bucketInstanceId=++this.maxBucketInstanceId),r.addBucket(i.tileID,t,this.crossTileIDs)&&(s=!0),n[t.bucketInstanceId]=!0);}return r.removeStaleBuckets(n)&&(s=!0),s}pruneUnusedLayers(e){const t={};e.forEach((e=>{t[e]=!0;}));for(const e in this.layerIndexes)t[e]||delete this.layerIndexes[e];}}class ao{constructor(e=0,t=0,i=0,o=0){if(isNaN(e)||e<0||isNaN(t)||t<0||isNaN(i)||i<0||isNaN(o)||o<0)throw new Error("Invalid value for edge-insets, top, bottom, left and right must all be numbers");this.top=e,this.bottom=t,this.left=i,this.right=o;}interpolate(t,i,o){return null!=i.top&&null!=t.top&&(this.top=e.U(t.top,i.top,o)),null!=i.bottom&&null!=t.bottom&&(this.bottom=e.U(t.bottom,i.bottom,o)),null!=i.left&&null!=t.left&&(this.left=e.U(t.left,i.left,o)),null!=i.right&&null!=t.right&&(this.right=e.U(t.right,i.right,o)),this}getCenter(t,i){const o=e.aa((this.left+t-this.right)/2,0,t),r=e.aa((this.top+i-this.bottom)/2,0,i);return new e.P(o,r)}equals(e){return this.top===e.top&&this.bottom===e.bottom&&this.left===e.left&&this.right===e.right}clone(){return new ao(this.top,this.bottom,this.left,this.right)}toJSON(){return {top:this.top,bottom:this.bottom,left:this.left,right:this.right}}}function lo(t,i){const o=e.bk(t,3);e.a6.fromQuat(t,i),e.bm(t,3,o);}function co(t,i){const o=e.bi.identity([]);return e.bi.rotateZ(o,o,-i),e.bi.rotateX(o,o,-t),o}function ho(t,i){const o=[t[0],t[1],0],r=[i[0],i[1],0];if(e.N.length(o)>=1e-15){const t=e.N.normalize([],o);e.N.scale(r,t,e.N.dot(r,t)),i[0]=r[0],i[1]=r[1];}const s=e.N.cross([],i,t);if(e.N.len(s)<1e-15)return null;const n=Math.atan2(-s[1],s[0]);return co(Math.atan2(Math.sqrt(t[0]*t[0]+t[1]*t[1]),-t[2]),n)}class uo{constructor(e,t){this.position=e,this.orientation=t;}get position(){return this._position}set position(t){if(t){const i=t instanceof e.L?t:new e.L(t[0],t[1],t[2]);this._renderWorldCopies&&(i.x=e.bh(i.x,0,1)),this._position=i;}else this._position=null;}lookAtPoint(t,i){if(this.orientation=null,!this.position)return;const o=this.position,r=this._elevation?this._elevation.getAtPointOrZero(e.L.fromLngLat(t)):0,s=e.L.fromLngLat(t,r),n=[s.x-o.x,s.y-o.y,s.z-o.z];i||(i=[0,0,1]),i[2]=Math.abs(i[2]),this.orientation=ho(n,i);}setPitchBearing(t,i){this.orientation=co(e.bj(t),e.bj(-i));}}class _o{constructor(t,i){this._transform=e.a6.identity([]),this.orientation=i,this.position=t;}get mercatorPosition(){const t=this.position;return new e.L(t[0],t[1],t[2])}get position(){const t=e.bk(this._transform,3);return [t[0],t[1],t[2]]}set position(t){var i;t&&e.bm(this._transform,3,[(i=t)[0],i[1],i[2],1]);}get orientation(){return this._orientation}set orientation(t){this._orientation=t||e.bi.identity([]),t&&lo(this._transform,this._orientation);}getPitchBearing(){const e=this.forward(),t=this.right();return {bearing:Math.atan2(-t[1],t[0]),pitch:Math.atan2(Math.sqrt(e[0]*e[0]+e[1]*e[1]),-e[2])}}setPitchBearing(e,t){this._orientation=co(e,t),lo(this._transform,this._orientation);}forward(){const t=e.bk(this._transform,2);return [-t[0],-t[1],-t[2]]}up(){const t=e.bk(this._transform,1);return [-t[0],-t[1],-t[2]]}right(){const t=e.bk(this._transform,0);return [t[0],t[1],t[2]]}getCameraToWorld(t,i){const o=new Float64Array(16);return e.a6.invert(o,this.getWorldToCamera(t,i)),o}getCameraToWorldMercator(){return this._transform}getWorldToCameraPosition(t,i,o){const r=this.position;e.N.scale(r,r,-t);const s=new Float64Array(16);return e.a6.fromScaling(s,[o,o,o]),e.a6.translate(s,s,r),s[10]*=i,s}getWorldToCamera(t,i){const o=new Float64Array(16),r=new Float64Array(4),s=this.position;return e.bi.conjugate(r,this._orientation),e.N.scale(s,s,-t),e.a6.fromQuat(o,r),e.a6.translate(o,o,s),o[1]*=-1,o[5]*=-1,o[9]*=-1,o[13]*=-1,o[8]*=i,o[9]*=i,o[10]*=i,o[11]*=i,o}getCameraToClipPerspective(t,i,o,r){const s=new Float64Array(16);return e.a6.perspective(s,t,i,o,r),s}getCameraToClipOrthographic(t,i,o,r,s,n){const a=new Float64Array(16);return e.a6.ortho(a,t,i,o,r,s,n),a}getDistanceToElevation(t,i=!1){const o=0===t?0:e.bl(t,i?e.au(this.position[1]):this.position[1]),r=this.forward();return (o-this.position[2])/r[2]}clone(){return new _o([...this.position],[...this.orientation])}}const po=(e,t,i)=>(1-i)*e+i*t,fo=e=>e*e*e*e*e;class mo{constructor(t,i,o,r,s,n,a){this.tileSize=512,this._renderWorldCopies=void 0===s||s,this._minZoom=t||0,this._maxZoom=i||22,this._minPitch=null==o?0:o,this._maxPitch=null==r?60:r,this.setProjection(n),this.setMaxBounds(a),this.width=0,this.height=0,this._center=new e.bn(0,0),this.zoom=0,this.angle=0,this._fov=.6435011087932844,this._pitch=0,this._nearZ=0,this._farZ=0,this._unmodified=!0,this._edgeInsets=new ao,this._projMatrixCache={},this._alignedProjMatrixCache={},this._fogTileMatrixCache={},this._expandedProjMatrixCache={},this._distanceTileDataCache={},this._camera=new _o,this._centerAltitude=0,this._averageElevation=0,this.cameraElevationReference="ground",this._pixelsPerMercatorPixel=1,this.globeRadius=0,this.globeCenterInViewSpace=[0,0,0],this._tileCoverLift=0,this._horizonShift=.1,this._orthographicProjectionAtLowPitch=!1;}clone(){const e=new mo(this._minZoom,this._maxZoom,this._minPitch,this.maxPitch,this._renderWorldCopies,this.getProjection());return e._elevation=this._elevation,e._centerAltitude=this._centerAltitude,e._centerAltitudeValidForExaggeration=this._centerAltitudeValidForExaggeration,e.tileSize=this.tileSize,e.mercatorFromTransition=this.mercatorFromTransition,e.width=this.width,e.height=this.height,e.cameraElevationReference=this.cameraElevationReference,e._center=this._center,e._setZoom(this.zoom),e._seaLevelZoom=this._seaLevelZoom,e.angle=this.angle,e._fov=this._fov,e._pitch=this._pitch,e._nearZ=this._nearZ,e._farZ=this._farZ,e._averageElevation=this._averageElevation,e._orthographicProjectionAtLowPitch=this._orthographicProjectionAtLowPitch,e._unmodified=this._unmodified,e._edgeInsets=this._edgeInsets.clone(),e._camera=this._camera.clone(),e._calcMatrices(),e.freezeTileCoverage=this.freezeTileCoverage,e.frustumCorners=this.frustumCorners,e}get isOrthographic(){return "globe"!==this.projection.name&&this._orthographicProjectionAtLowPitch&&this.pitch<15}get elevation(){return this._elevation}set elevation(e){this._elevation!==e&&(this._elevation=e,this._updateCameraOnTerrain(),this._calcMatrices());}get depthOcclusionForSymbolsAndCircles(){return "globe"!==this.projection.name&&!this.isOrthographic}updateElevation(e,t=!1){const i=this._elevation&&this._elevation.exaggeration()!==this._centerAltitudeValidForExaggeration;(null==this._seaLevelZoom||i)&&this._updateCameraOnTerrain(),(e||i)&&this._constrainCamera(t),this._calcMatrices();}getProjection(){return e.ac(this.projection,["name","center","parallels"])}setProjection(i){this.projectionOptions=i||{name:"mercator"};const o=this.projection?this.getProjection():void 0;this.projection=e.bo(this.projectionOptions);const r=!t(o,this.getProjection());return r&&this._calcMatrices(),this.mercatorFromTransition=!1,r}setOrthographicProjectionAtLowPitch(e){return this._orthographicProjectionAtLowPitch!==e&&(this._orthographicProjectionAtLowPitch=e,this._calcMatrices(),!0)}setMercatorFromTransition(){const t=this.projection.name;this.mercatorFromTransition=!0,this.projectionOptions={name:"mercator"},this.projection=e.bo({name:"mercator"});const i=t!==this.projection.name;return i&&this._calcMatrices(),i}get minZoom(){return this._minZoom}set minZoom(e){this._minZoom!==e&&(this._minZoom=e,this.zoom=Math.max(this.zoom,e));}get maxZoom(){return this._maxZoom}set maxZoom(e){this._maxZoom!==e&&(this._maxZoom=e,this.zoom=Math.min(this.zoom,e));}get minPitch(){return this._minPitch}set minPitch(e){this._minPitch!==e&&(this._minPitch=e,this.pitch=Math.max(this.pitch,e));}get maxPitch(){return this._maxPitch}set maxPitch(e){this._maxPitch!==e&&(this._maxPitch=e,this.pitch=Math.min(this.pitch,e));}get renderWorldCopies(){return this._renderWorldCopies&&!0===this.projection.supportsWorldCopies}set renderWorldCopies(e){void 0===e?e=!0:null===e&&(e=!1),this._renderWorldCopies=e;}get worldSize(){return this.tileSize*this.scale}get cameraWorldSizeForFog(){const e=Math.max(this._camera.getDistanceToElevation(this._averageElevation),Number.EPSILON);return this._worldSizeFromZoom(this._zoomFromMercatorZ(e))}get cameraWorldSize(){const e=Math.max(this._camera.getDistanceToElevation(this._averageElevation,!0),Number.EPSILON);return this._worldSizeFromZoom(this._zoomFromMercatorZ(e))}get pixelsPerMeter(){return this.projection.pixelsPerMeter(this.center.lat,this.worldSize)}get cameraPixelsPerMeter(){return e.bl(1,this.center.lat)*this.cameraWorldSizeForFog}get centerOffset(){return this.centerPoint._sub(this.size._div(2))}get size(){return new e.P(this.width,this.height)}get bearing(){return e.bh(this.rotation,-180,180)}set bearing(e){this.rotation=e;}get rotation(){return -this.angle/Math.PI*180}set rotation(t){const i=-t*Math.PI/180;this.angle!==i&&(this._unmodified=!1,this.angle=i,this._calcMatrices(),this.rotationMatrix=e.b4.create(),e.b4.rotate(this.rotationMatrix,this.rotationMatrix,this.angle));}get pitch(){return this._pitch/Math.PI*180}set pitch(t){const i=e.aa(t,this.minPitch,this.maxPitch)/180*Math.PI;this._pitch!==i&&(this._unmodified=!1,this._pitch=i,this._calcMatrices());}get aspect(){return this.width/this.height}get fov(){return this._fov/Math.PI*180}get fovX(){return this._fov}get fovY(){const e=1/Math.tan(.5*this.fovX);return 2*Math.atan(1/this.aspect/e)}set fov(t){t=Math.max(.01,Math.min(60,t)),this._fov!==t&&(this._unmodified=!1,this._fov=e.bj(t),this._calcMatrices());}get averageElevation(){return this._averageElevation}set averageElevation(e){this._averageElevation=e,this._calcFogMatrices(),this._distanceTileDataCache={};}get zoom(){return this._zoom}set zoom(e){const t=Math.min(Math.max(e,this.minZoom),this.maxZoom);this._zoom!==t&&(this._unmodified=!1,this._setZoom(t),this._updateSeaLevelZoom(),this._constrain(),this._calcMatrices());}_setZoom(e){this._zoom=e,this.scale=this.zoomScale(e),this.tileZoom=Math.floor(e),this.zoomFraction=e-this.tileZoom;}get tileCoverLift(){return this._tileCoverLift}set tileCoverLift(e){this._tileCoverLift!==e&&(this._tileCoverLift=e);}_updateCameraOnTerrain(){const e=this.elevation?this.elevation.getAtPoint(this.locationCoordinate(this.center),Number.NEGATIVE_INFINITY):Number.NEGATIVE_INFINITY,t=this.elevation&&e===Number.NEGATIVE_INFINITY&&this.elevation.visibleDemTiles.length>0&&this.elevation.exaggeration()>0&&this._centerAltitudeValidForExaggeration;if(!this._elevation||e===Number.NEGATIVE_INFINITY&&(!t||!this._centerAltitude))return this._centerAltitude=0,this._seaLevelZoom=null,void(this._centerAltitudeValidForExaggeration=void 0);const i=this._elevation;t||this._centerAltitude&&this._centerAltitudeValidForExaggeration&&i.exaggeration()&&this._centerAltitudeValidForExaggeration!==i.exaggeration()?(this._centerAltitude=this._centerAltitude/this._centerAltitudeValidForExaggeration*i.exaggeration(),this._centerAltitudeValidForExaggeration=i.exaggeration()):(this._centerAltitude=e||0,this._centerAltitudeValidForExaggeration=i.exaggeration()),this._updateSeaLevelZoom();}_updateSeaLevelZoom(){void 0!==this._centerAltitudeValidForExaggeration&&(this._seaLevelZoom=this._zoomFromMercatorZ((this.pixelsPerMeter*this._centerAltitude+this.cameraToCenterDistance)/this.worldSize));}sampleAverageElevation(){if(!this._elevation)return 0;const t=this._elevation,i=[[.5,.2],[.3,.5],[.5,.5],[.7,.5],[.5,.8]],o=this.horizonLineFromTop();let r=0,s=0;for(let n=0;n<i.length;n++){const a=new e.P(i[n][0]*this.width,o+i[n][1]*(this.height-o)),l=t.pointCoordinate(a);if(!l)continue;const c=1/Math.hypot(l[0]-this._camera.position[0],l[1]-this._camera.position[1]);r+=l[3]*c,s+=c;}return 0===s?NaN:r/s}get center(){return this._center}set center(e){e.lat===this._center.lat&&e.lng===this._center.lng||(this._unmodified=!1,this._center=e,this._terrainEnabled()&&("ground"===this.cameraElevationReference?this._updateCameraOnTerrain():this._updateZoomFromElevation()),this._constrain(),this._calcMatrices());}_updateZoomFromElevation(){if(null==this._seaLevelZoom||!this._elevation)return;const e=this._seaLevelZoom,t=this._elevation.getAtPointOrZero(this.locationCoordinate(this.center)),i=this.pixelsPerMeter/this.worldSize*t,o=this._mercatorZfromZoom(e),r=this._mercatorZfromZoom(this._maxZoom),s=Math.max(o-i,r);this._setZoom(this._zoomFromMercatorZ(s));}get padding(){return this._edgeInsets.toJSON()}set padding(e){this._edgeInsets.equals(e)||(this._unmodified=!1,this._edgeInsets.interpolate(this._edgeInsets,e,1),this._calcMatrices());}computeZoomRelativeTo(t){const i=this.rayIntersectionCoordinate(this.pointRayIntersection(this.centerPoint,t.toAltitude()));let o;o=t.z<this._camera.position[2]?[i.x,i.y,i.z]:[t.x,t.y,t.z];const r=e.N.length(e.N.sub([],this._camera.position,o));return e.aa(this._zoomFromMercatorZ(r),this._minZoom,this._maxZoom)}setFreeCameraOptions(t){if(!this.height)return;if(!t.position&&!t.orientation)return;this._updateCameraState();let i=!1;if(t.orientation&&!e.bi.exactEquals(t.orientation,this._camera.orientation)&&(i=this._setCameraOrientation(t.orientation)),t.position){const o=[t.position.x,t.position.y,t.position.z];e.N.exactEquals(o,this._camera.position)||(this._setCameraPosition(o),i=!0);}i&&(this._updateStateFromCamera(),this.recenterOnTerrain());}getFreeCameraOptions(){this._updateCameraState();const t=this._camera.position,i=new uo;return i.position=new e.L(t[0],t[1],t[2]),i.orientation=this._camera.orientation,i._elevation=this.elevation,i._renderWorldCopies=this.renderWorldCopies,i}_setCameraOrientation(t){if(!e.bi.length(t))return !1;e.bi.normalize(t,t);const i=e.N.transformQuat([],[0,0,-1],t),o=e.N.transformQuat([],[0,-1,0],t);if(o[2]<0)return !1;const r=ho(i,o);return !!r&&(this._camera.orientation=r,!0)}_setCameraPosition(t){const i=this.zoomScale(this.minZoom)*this.tileSize,o=this.zoomScale(this.maxZoom)*this.tileSize,r=this.cameraToCenterDistance;t[2]=e.aa(t[2],r/o,r/i),this._camera.position=t;}get centerPoint(){return this._edgeInsets.getCenter(this.width,this.height)}get fovAboveCenter(){return this._fov*(.5+this.centerOffset.y/this.height)}isPaddingEqual(e){return this._edgeInsets.equals(e)}interpolatePadding(e,t,i){this._unmodified=!1,this._edgeInsets.interpolate(e,t,i),this._constrain(),this._calcMatrices();}coveringZoomLevel(e){const t=(e.roundZoom?Math.round:Math.floor)(this.zoom+this.scaleZoom(this.tileSize/e.tileSize));return Math.max(0,t)}getVisibleUnwrappedCoordinates(t){const i=[new e.bp(0,t)];if(this.renderWorldCopies){const o=this.pointCoordinate(new e.P(0,0)),r=this.pointCoordinate(new e.P(this.width,0)),s=this.pointCoordinate(new e.P(this.width,this.height)),n=this.pointCoordinate(new e.P(0,this.height)),a=Math.floor(Math.min(o.x,r.x,s.x,n.x)),l=Math.floor(Math.max(o.x,r.x,s.x,n.x)),c=1;for(let o=a-c;o<=l+c;o++)0!==o&&i.push(new e.bp(o,t));}return i}isLODDisabled(e){return (!e||this.pitch<=60)&&this._edgeInsets.top<=this._edgeInsets.bottom&&!this._elevation&&!this.projection.isReprojectedInTileSpace}extendTileCoverForShadows(t,i,o){let r=[];if(0===i[0]&&0===i[1])return r;for(const o of t){const t=o.canonical,s=o.overscaledZ,n=o.wrap,a=1<<t.z,l=t.x+1<a,c=t.x>0,h=t.y+1<a,u=t.y>0,d=o.wrap-(c?0:1),_=o.wrap+(l?0:1),p=c?t.x-1:a-1,f=l?t.x+1:0;i[0]<0?(r.push(new e.am(s,_,t.z,f,t.y)),i[1]<0&&h&&(r.push(new e.am(s,n,t.z,t.x,t.y+1)),r.push(new e.am(s,_,t.z,f,t.y+1))),i[1]>0&&u&&(r.push(new e.am(s,n,t.z,t.x,t.y-1)),r.push(new e.am(s,_,t.z,f,t.y-1)))):i[0]>0?(r.push(new e.am(s,d,t.z,p,t.y)),i[1]<0&&h&&(r.push(new e.am(s,n,t.z,t.x,t.y+1)),r.push(new e.am(s,d,t.z,p,t.y+1))),i[1]>0&&u&&(r.push(new e.am(s,n,t.z,t.x,t.y-1)),r.push(new e.am(s,d,t.z,p,t.y-1)))):i[1]<0&&h?r.push(new e.am(s,n,t.z,t.x,t.y+1)):u&&r.push(new e.am(s,n,t.z,t.x,t.y-1));}if(r.length>1){r.sort(((e,t)=>e.overscaledZ-t.overscaledZ||e.wrap-t.wrap||e.canonical.z-t.canonical.z||e.canonical.x-t.canonical.x||e.canonical.y-t.canonical.y));let e=0,t=0;for(;t<r.length;)r[t].equals(r[e])?++t:r[++e]=r[t++];r.length=e+1;}const s=[];for(const e of r)r.some((t=>e.isChildOf(t)))||s.push(e);return r=s.filter((e=>!t.some((t=>!!(e.overscaledZ<o&&t.isChildOf(e))||e.equals(t)||e.isChildOf(t))))),r}coveringTiles(t){let i=this.coveringZoomLevel(t);const o=i,r=this.elevation&&this.elevation.exaggeration(),s=r&&!t.isTerrainDEM,n="mercator"===this.projection.name;if(void 0!==t.minzoom&&i<t.minzoom)return [];void 0!==t.maxzoom&&i>t.maxzoom&&(i=t.maxzoom);const a=this.locationCoordinate(this.center),l=this.center.lat,c=1<<i,h=[c*a.x,c*a.y,0],u="globe"===this.projection.name,d=!u,_=e.bq.fromInvProjectionMatrix(this.invProjMatrix,this.worldSize,i,d),p=u?this._camera.mercatorPosition:this.pointCoordinate(this.getCameraPoint()),f=c*e.bl(1,this.center.lat),m=this._camera.position[2]/e.bl(1,this.center.lat),g=[c*p.x,c*p.y,m*(d?1:f)],v=u||r,x=this.cameraToCenterDistance/t.tileSize*(t.roundZoom?1:.502),y=this.isLODDisabled(!0)?i:0;let b;if(this._elevation&&t.isTerrainDEM)b=1e4*this._elevation.exaggeration();else if(this._elevation){const e=this._elevation.getMinMaxForVisibleTiles();b=e?e.max:this._centerAltitude;}else b=this._centerAltitude;const w=t.isTerrainDEM?-b:this._elevation?this._elevation.getMinElevationBelowMSL():0,T=this.projection.isReprojectedInTileSpace?e.br(this):1,E=t=>{const i=1/4e4,o=new e.L(t.x+i,t.y,t.z),r=new e.L(t.x,t.y+i,t.z),s=t.toLngLat(),n=o.toLngLat(),a=r.toLngLat(),l=this.locationCoordinate(s),c=this.locationCoordinate(n),h=this.locationCoordinate(a),u=Math.hypot(c.x-l.x,c.y-l.y),d=Math.hypot(h.x-l.x,h.y-l.y);return Math.sqrt(u*d)*T/i},S=t=>{const i=b,o=w;return {aabb:e.bu(this,c,0,0,0,t,o,i,this.projection),zoom:0,x:0,y:0,minZ:o,maxZ:i,wrap:t,fullyVisible:!1}},C=[];let I=[];const D=i,L=t.reparseOverscaled?o:i,A=e=>e*e,R=A((m-this._centerAltitude)*f),P=e=>{if(!this._elevation||!e.tileID||!n)return;const t=this._elevation.getMinMaxForTile(e.tileID),i=e.aabb;t?(i.min[2]=t.min,i.max[2]=t.max,i.center[2]=(i.min[2]+i.max[2])/2):(e.shouldSplit=M(e),e.shouldSplit||(i.min[2]=i.max[2]=i.center[2]=this._centerAltitude));},M=t=>{if(t.zoom<y)return !0;if(t.zoom===D)return !1;if(null!=t.shouldSplit)return t.shouldSplit;const i=t.aabb.distanceX(g),r=t.aabb.distanceY(g);let n=R,a=1;if(u){n=A(t.aabb.distanceZ(g));const i=Math.pow(2,t.zoom),o=e.au((t.y+1)/i),r=e.au(t.y/i),s=Math.min(Math.max(l,o),r),c=e.bJ(s)/e.bJ(l);if(a=s===l?1/Math.max(1,this._mercatorScaleRatio-.3):Math.min(1,c/this._mercatorScaleRatio),this.zoom<=e.bG&&t.zoom===D-1&&c>=.9)return !0}else if(s&&(n=A(t.aabb.distanceZ(g)*f)),this.projection.isReprojectedInTileSpace&&o<=5){const i=Math.pow(2,t.zoom),o=E(new e.L((t.x+.5)/i,(t.y+.5)/i));a=o>.85?1:o;}const c=i*i+r*r+n,h=A((1<<D-t.zoom)*x*a*((e,t)=>{if(t*A(.707)<e)return 1;const i=Math.sqrt(t/e);return i/(1.4144271570014144+(Math.pow(1.1,i-1.4144271570014144+1)-1)/(1.1-1)-1)})(Math.max(n,R),c));return c<h};if(this.renderWorldCopies)for(let e=1;e<=3;e++)C.push(S(-e)),C.push(S(e));for(C.push(S(0));C.length>0;){const o=C.pop(),r=o.x,a=o.y;let l=o.fullyVisible;const d=()=>"globe"===this.projection.name&&(0===o.y||o.y===(1<<o.zoom)-1);if(!l){let t=v?o.aabb.intersects(_):o.aabb.intersectsFlat(_);if(0===t&&d()){const i=new e.bs(o.zoom,r,a);t=e.bt(this,c,i,!0).intersects(_);}if(0===t)continue;l=2===t;}if(o.zoom!==D&&M(o))for(let t=0;t<4;t++){const i=(r<<1)+t%2,h=(a<<1)+(t>>1),d={aabb:n?o.aabb.quadrant(t):e.bu(this,c,o.zoom+1,i,h,o.wrap,o.minZ,o.maxZ,this.projection),zoom:o.zoom+1,x:i,y:h,wrap:o.wrap,fullyVisible:l,tileID:void 0,shouldSplit:void 0,minZ:o.minZ,maxZ:o.maxZ};s&&!u&&(d.tileID=new e.am(o.zoom+1===D?L:o.zoom+1,o.wrap,o.zoom+1,i,h),P(d)),C.push(d);}else {const s=o.zoom===D?L:o.zoom;if(t.minzoom&&t.minzoom>s)continue;if(!l){let t=v?o.aabb.intersectsPrecise(_):o.aabb.intersectsPreciseFlat(_);if(0===t&&d()){const i=new e.bs(o.zoom,r,a);t=e.bt(this,c,i,!0).intersectsPrecise(_);}if(0===t)continue}const n=h[0]-(.5+r+(o.wrap<<o.zoom))*(1<<i-o.zoom),u=h[1]-.5-a,p=o.tileID?o.tileID:new e.am(s,o.wrap,o.zoom,r,a);I.push({tileID:p,distanceSq:n*n+u*u});}}if(this.fogCullDistSq){const i=this.fogCullDistSq,o=this.horizonLineFromTop();I=I.filter((r=>{const s=[0,0,0,1],n=[e.V,e.V,0,1],a=this.calculateFogTileMatrix(r.tileID.toUnwrapped());e.a7.transformMat4(s,s,a),e.a7.transformMat4(n,n,a);const l=e.a7.min([],s,n),c=e.a7.max([],s,n),h=e.bv(l,c);if(0===h)return !0;let u=!1;const d=this._elevation;if(d&&h>i&&0!==o){const i=this.calculateProjMatrix(r.tileID.toUnwrapped());let s;t.isTerrainDEM||(s=d.getMinMaxForTile(r.tileID)),s||(s={min:w,max:b});const n=e.bH(this.rotation),a=[n[0]*e.V,n[1]*e.V,s.max];e.N.transformMat4(a,a,i),u=(1-a[1])*this.height*.5<o;}return h<i||u}));}return I.sort(((e,t)=>e.distanceSq-t.distanceSq)).map((e=>e.tileID))}resize(e,t){this.width=e,this.height=t,this.pixelsToGLUnits=[2/e,-2/t],this._constrain(),this._calcMatrices();}get unmodified(){return this._unmodified}zoomScale(e){return Math.pow(2,e)}scaleZoom(e){return Math.log(e)/Math.LN2}project(t){const i=e.aa(t.lat,-e.bw,e.bw),o=this.projection.project(t.lng,i);return new e.P(o.x*this.worldSize,o.y*this.worldSize)}unproject(e){return this.projection.unproject(e.x/this.worldSize,e.y/this.worldSize)}get point(){return this.project(this.center)}get pointMerc(){return this.point._div(this.worldSize)}get pixelsPerMeterRatio(){return this.pixelsPerMeter/e.bl(1,this.center.lat)/this.worldSize}setLocationAtPoint(t,i){let o,r;const s=this.centerPoint;if("globe"===this.projection.name){const e=this.worldSize;o=(i.x-s.x)/e,r=(i.y-s.y)/e;}else {const e=this.pointCoordinate(i),t=this.pointCoordinate(s);o=e.x-t.x,r=e.y-t.y;}const n=this.locationCoordinate(t);this.setLocation(new e.L(n.x-o,n.y-r));}setLocation(e){this.center=this.coordinateLocation(e),this.projection.wrap&&(this.center=this.center.wrap());}locationPoint(e){return this.projection.locationPoint(this,e)}locationPoint3D(e){return this.projection.locationPoint(this,e,!0)}pointLocation(e){return this.coordinateLocation(this.pointCoordinate(e))}pointLocation3D(e){return this.coordinateLocation(this.pointCoordinate3D(e))}locationCoordinate(t,i){const o=i?e.bl(i,t.lat):void 0,r=this.projection.project(t.lng,t.lat);return new e.L(r.x,r.y,o)}coordinateLocation(e){return this.projection.unproject(e.x,e.y)}pointRayIntersection(t,i){const o=null!=i?i:this._centerAltitude,r=[t.x,t.y,0,1],s=[t.x,t.y,1,1];e.a7.transformMat4(r,r,this.pixelMatrixInverse),e.a7.transformMat4(s,s,this.pixelMatrixInverse);const n=s[3];e.a7.scale(r,r,1/r[3]),e.a7.scale(s,s,1/n);const a=r[2],l=s[2];return {p0:r,p1:s,t:a===l?0:(o-a)/(l-a)}}screenPointToMercatorRay(t){const i=[t.x,t.y,0,1],o=[t.x,t.y,1,1];return e.a7.transformMat4(i,i,this.pixelMatrixInverse),e.a7.transformMat4(o,o,this.pixelMatrixInverse),e.a7.scale(i,i,1/i[3]),e.a7.scale(o,o,1/o[3]),i[2]=e.bl(i[2],this._center.lat)*this.worldSize,o[2]=e.bl(o[2],this._center.lat)*this.worldSize,e.a7.scale(i,i,1/this.worldSize),e.a7.scale(o,o,1/this.worldSize),new e.a2([i[0],i[1],i[2]],e.N.normalize([],e.N.sub([],o,i)))}rayIntersectionCoordinate(t){const{p0:i,p1:o,t:r}=t,s=e.bl(i[2],this._center.lat),n=e.bl(o[2],this._center.lat);return new e.L(e.U(i[0],o[0],r)/this.worldSize,e.U(i[1],o[1],r)/this.worldSize,e.U(s,n,r))}pointCoordinate(e,t=this._centerAltitude){return this.projection.pointCoordinate(this,e.x,e.y,t)}pointCoordinate3D(t){if(!this.elevation)return this.pointCoordinate(t);let i=this.projection.pointCoordinate3D(this,t.x,t.y);if(i)return new e.L(i[0],i[1],i[2]);let o=0,r=this.horizonLineFromTop();if(t.y>r)return this.pointCoordinate(t);const s=.02*r,n=t.clone();for(let t=0;t<10&&r-o>s;t++){n.y=e.U(o,r,.66);const t=this.projection.pointCoordinate3D(this,n.x,n.y);t?(r=n.y,i=t):o=n.y;}return i?new e.L(i[0],i[1],i[2]):this.pointCoordinate(t)}isPointAboveHorizon(e){return this.projection.isPointAboveHorizon(this,e)}isPointOnSurface(t){if(t.y<0||t.y>this.height||t.x<0||t.x>this.width)return !1;if(this.elevation||this.zoom>=e.bx)return !this.isPointAboveHorizon(t);const i=this.pointCoordinate(t);return i.y>=0&&i.y<=1}_coordinatePoint(t,i){const o=i&&this.elevation?this.elevation.getAtPointOrZero(t,this._centerAltitude):this._centerAltitude,r=[t.x*this.worldSize,t.y*this.worldSize,o+t.toAltitude(),1];return e.a7.transformMat4(r,r,this.pixelMatrix),r[3]>0?new e.P(r[0]/r[3],r[1]/r[3]):new e.P(Number.MAX_VALUE,Number.MAX_VALUE)}_getBoundsNonRectangular(){const{top:t,left:i}=this._edgeInsets,o=this.height-this._edgeInsets.bottom,r=this.width-this._edgeInsets.right,s=this.pointLocation3D(new e.P(i,t)),n=this.pointLocation3D(new e.P(r,t)),a=this.pointLocation3D(new e.P(r,o)),l=this.pointLocation3D(new e.P(i,o));let c=Math.min(s.lng,n.lng,a.lng,l.lng),h=Math.max(s.lng,n.lng,a.lng,l.lng),u=Math.min(s.lat,n.lat,a.lat,l.lat),d=Math.max(s.lat,n.lat,a.lat,l.lat);const _=Math.pow(2,-this.zoom)/16*270,p="globe"===this.projection.name?1:4,f=(t,i,o,r,s)=>{const n=(t+o)/2,a=(i+r)/2,l=new e.P(n,a),{lng:m,lat:g}=this.pointLocation3D(l),v=Math.max(0,c-m,u-g,m-h,g-d);c=Math.min(c,m),h=Math.max(h,m),u=Math.min(u,g),d=Math.max(d,g),(s<p||v>_)&&(f(t,i,n,a,s+1),f(n,a,o,r,s+1));};if(f(i,t,r,t,1),f(r,t,r,o,1),f(r,o,i,o,1),f(i,o,i,t,1),"globe"===this.projection.name){const[t,i]=e.by(this);t?(d=90,h=180,c=-180):i&&(u=-90,h=180,c=-180);}return new e.ad(new e.bn(c,u),new e.bn(h,d))}_getBoundsRectangular(t,i){const{top:o,left:r}=this._edgeInsets,s=this.height-this._edgeInsets.bottom,n=this.width-this._edgeInsets.right,a=new e.P(r,o),l=new e.P(n,o),c=new e.P(n,s),h=new e.P(r,s);let u=this.pointCoordinate(a,t),d=this.pointCoordinate(l,t);const _=this.pointCoordinate(c,i),p=this.pointCoordinate(h,i),f=(e,t)=>(t.y-e.y)/(t.x-e.x);return u.y>1&&d.y>=0?u=new e.L((1-p.y)/f(p,u)+p.x,1):u.y<0&&d.y<=1&&(u=new e.L(-p.y/f(p,u)+p.x,0)),d.y>1&&u.y>=0?d=new e.L((1-_.y)/f(_,d)+_.x,1):d.y<0&&u.y<=1&&(d=new e.L(-_.y/f(_,d)+_.x,0)),(new e.ad).extend(this.coordinateLocation(u)).extend(this.coordinateLocation(d)).extend(this.coordinateLocation(p)).extend(this.coordinateLocation(_))}_getBoundsRectangularTerrain(){const e=this.elevation;if(!e.visibleDemTiles.length||e.isUsingMockSource())return this._getBoundsRectangular(0,0);const t=e.visibleDemTiles.reduce(((e,t)=>{if(t.dem){const i=t.dem.tree;e.min=Math.min(e.min,i.minimums[0]),e.max=Math.max(e.max,i.maximums[0]);}return e}),{min:Number.MAX_VALUE,max:0});return this._getBoundsRectangular(t.min*e.exaggeration(),t.max*e.exaggeration())}getBounds(){return "mercator"===this.projection.name||"equirectangular"===this.projection.name?this._terrainEnabled()?this._getBoundsRectangularTerrain():this._getBoundsRectangular(0,0):this._getBoundsNonRectangular()}horizonLineFromTop(e=!0){const t=this.height/2/Math.tan(this._fov/2)/Math.tan(Math.max(this._pitch,.1))-this.centerOffset.y,i=this.height/2-t*(1-this._horizonShift);return e?Math.max(0,i):i}getMaxBounds(){return this.maxBounds}setMaxBounds(t){this.maxBounds=t,this.minLat=-e.bw,this.maxLat=e.bw,this.minLng=-180,this.maxLng=180,t&&(this.minLat=t.getSouth(),this.maxLat=t.getNorth(),this.minLng=t.getWest(),this.maxLng=t.getEast(),this.maxLng<this.minLng&&(this.maxLng+=360)),this.worldMinX=e.a5(this.minLng)*this.tileSize,this.worldMaxX=e.a5(this.maxLng)*this.tileSize,this.worldMinY=e.ae(this.maxLat)*this.tileSize,this.worldMaxY=e.ae(this.minLat)*this.tileSize,this._constrain();}calculatePosMatrix(e,t){return this.projection.createTileMatrix(this,t,e)}calculateDistanceTileData(t){const i=t.key,o=this._distanceTileDataCache;if(o[i])return o[i];const r=t.canonical,s=1/this.height,n=this.cameraWorldSize,a=n/this.zoomScale(r.z),l=(r.x+Math.pow(2,r.z)*t.wrap)*a,c=r.y*a,h=this.point;h.x*=n/this.worldSize,h.y*=n/this.worldSize;const u=this.angle,d=Math.sin(-u),_=-Math.cos(-u);return o[i]={bearing:[d,_],center:[(h.x-l)*s,(h.y-c)*s],scale:a/e.V*s},o[i]}calculateFogTileMatrix(t){const i=t.key,o=this._fogTileMatrixCache;if(o[i])return o[i];const r=this.projection.createTileMatrix(this,this.cameraWorldSizeForFog,t);return e.a6.multiply(r,this.worldToFogMatrix,r),o[i]=new Float32Array(r),o[i]}calculateProjMatrix(t,i=!1,o=!1){const r=t.key;let s;if(s=o?this._expandedProjMatrixCache:i?this._alignedProjMatrixCache:this._projMatrixCache,s[r])return s[r];const n=this.calculatePosMatrix(t,this.worldSize);let a;return a=this.projection.isReprojectedInTileSpace?this.mercatorMatrix:o?this.expandedFarZProjMatrix:i?this.alignedProjMatrix:this.projMatrix,e.a6.multiply(n,a,n),s[r]=new Float32Array(n),s[r]}calculatePixelsToTileUnitsMatrix(t){const i=t.tileID.key,o=this._pixelsToTileUnitsCache;if(o[i])return o[i];const r=e.bz(t,this);return o[i]=r,o[i]}customLayerMatrix(){return this.mercatorMatrix.slice()}globeToMercatorMatrix(){if("globe"===this.projection.name){const t=1/this.worldSize,i=e.a6.fromScaling([],[t,t,t]);return e.a6.multiply(i,i,this.globeMatrix),i}}recenterOnTerrain(){if(!this._elevation||"globe"===this.projection.name)return;const t=this._elevation;this._updateCameraState();const i=e.bl(1,this._center.lat)*this.worldSize,o=this._computeCameraPosition(i),r=this._camera.forward(),s=e.bl(1,this._center.lat);o[2]/=s,r[2]/=s,e.N.normalize(r,r);const n=t.raycast(o,r,t.exaggeration());if(n){const t=e.N.scaleAndAdd([],o,r,n),i=new e.L(t[0],t[1],e.bl(t[2],e.au(t[1]))),a=(i.z+e.N.length([i.x-o[0],i.y-o[1],i.z-o[2]*s]))*this._pixelsPerMercatorPixel;this._seaLevelZoom=this._zoomFromMercatorZ(a),this._centerAltitude=i.toAltitude(),this._center=this.coordinateLocation(i),this._updateZoomFromElevation(),this._constrain(),this._calcMatrices();}}_constrainCamera(t=!1){if(!this._elevation)return;const i=this._elevation,o=e.bl(1,this._center.lat)*this.worldSize,r=this._computeCameraPosition(o),s=i.getAtPointOrZero(new e.L(...r)),n=this.pixelsPerMeter/this.worldSize*s,a=this._minimumHeightOverTerrain(),l=r[2]-n;if(l<=a)if(l<0||t){const t=this.locationCoordinate(this._center,this._centerAltitude),i=[r[0],r[1],t.z-r[2]],o=e.N.length(i);i[2]-=(a-l)/this._pixelsPerMercatorPixel;const s=e.N.length(i);if(0===s)return;e.N.scale(i,i,o/s*this._pixelsPerMercatorPixel),this._camera.position=[r[0],r[1],t.z*this._pixelsPerMercatorPixel-i[2]],this._updateStateFromCamera();}else this._isCameraConstrained=!0;}_constrain(){if(!this.center||!this.width||!this.height||this._constraining)return;this._constraining=!0;const t="globe"===this.projection.name||this.mercatorFromTransition;if(this.projection.isReprojectedInTileSpace||t){const i=this.center;return i.lat=e.aa(i.lat,this.minLat,this.maxLat),(this.maxBounds||!this.renderWorldCopies&&!t)&&(i.lng=e.aa(i.lng,this.minLng,this.maxLng)),this.center=i,void(this._constraining=!1)}const i=this._unmodified,{x:o,y:r}=this.point;let s=0,n=o,a=r;const l=this.width/2,c=this.height/2,h=this.worldMinY*this.scale,u=this.worldMaxY*this.scale;if(r-c<h&&(a=h+c),r+c>u&&(a=u-c),u-h<this.height&&(s=Math.max(s,this.height/(u-h)),a=(u+h)/2),this.maxBounds||!this._renderWorldCopies||!this.projection.wrap){const e=this.worldMinX*this.scale,t=this.worldMaxX*this.scale,i=this.worldSize/2-(e+t)/2;n=(o+i+this.worldSize)%this.worldSize-i,n-l<e&&(n=e+l),n+l>t&&(n=t-l),t-e<this.width&&(s=Math.max(s,this.width/(t-e)),n=(t+e)/2);}n===o&&a===r||(this.center=this.unproject(new e.P(n,a))),s&&(this.zoom+=this.scaleZoom(s)),this._constrainCamera(),this._unmodified=i,this._constraining=!1;}_minZoomForBounds(){let e=Math.max(0,this.scaleZoom(this.height/(this.worldMaxY-this.worldMinY)));return this.maxBounds&&(e=Math.max(e,this.scaleZoom(this.width/(this.worldMaxX-this.worldMinX)))),e}_maxCameraBoundsDistance(){return this._mercatorZfromZoom(this._minZoomForBounds())}_calcMatrices(){if(!this.height)return;const t=this.centerOffset,i="globe"===this.projection.name,o=this.pixelsPerMeter;"globe"===this.projection.name&&(this._mercatorScaleRatio=e.bl(1,this.center.lat)/e.bl(1,e.bI));const r=e.bA(this.projection,this.zoom,this.width,this.height,1024);this._pixelsPerMercatorPixel=this.projection.pixelSpaceConversion(this.center.lat,this.worldSize,r),this.cameraToCenterDistance=.5/Math.tan(.5*this._fov)*this.height*this._pixelsPerMercatorPixel,this._updateCameraState(),this._farZ=this.projection.farthestPixelDistance(this),this._nearZ=this.height/50;const s="meters"===this.projection.zAxisUnit?o:1,n=this._camera.getWorldToCamera(this.worldSize,s);let a;const l=this._camera.getCameraToClipPerspective(this._fov,this.width/this.height,this._nearZ,this._farZ);if(l[8]=2*-t.x/this.width,l[9]=2*t.y/this.height,this.isOrthographic){let e=.5*this.height/Math.tan(this._fov/2)*1*Math.tan(.5*this._fov),i=e*this.aspect,o=-i,r=-e;i-=t.x,o-=t.x,e+=t.y,r+=t.y,a=this._camera.getCameraToClipOrthographic(o,i,r,e,this._nearZ,this._farZ),((e,t,i,o)=>{for(let r=0;r<16;r++)e[r]=po(t[r],i[r],o);})(a,a,l,fo(this.pitch>=15?1:this.pitch/15));}else a=l;const c=e.a6.mul([],l,n);let h=e.a6.mul([],a,n);if(this.projection.isReprojectedInTileSpace){const t=this.locationCoordinate(this.center),i=e.a6.identity([]);e.a6.translate(i,i,[t.x*this.worldSize,t.y*this.worldSize,0]),e.a6.multiply(i,i,e.bB(this)),e.a6.translate(i,i,[-t.x*this.worldSize,-t.y*this.worldSize,0]),e.a6.multiply(h,h,i),e.a6.multiply(c,c,i),this.inverseAdjustmentMatrix=e.bC(this);}else this.inverseAdjustmentMatrix=[1,0,0,1];if(this.mercatorMatrix=e.a6.scale([],h,[this.worldSize,this.worldSize,this.worldSize/s,1]),this.projMatrix=h,this.invProjMatrix=e.a6.invert(new Float64Array(16),this.projMatrix),i){const i=this._camera.getCameraToClipPerspective(this._fov,this.width/this.height,this._nearZ,1/0);i[8]=2*-t.x/this.width,i[9]=2*t.y/this.height,this.expandedFarZProjMatrix=e.a6.mul([],i,n);}else this.expandedFarZProjMatrix=this.projMatrix;const u=e.a6.invert([],a);this.frustumCorners=e.bD.fromInvProjectionMatrix(u,this.horizonLineFromTop(),this.height),this.cameraFrustum=e.bq.fromInvProjectionMatrix(this.invProjMatrix,this.worldSize,0,!i);const d=new Float32Array(16);e.a6.identity(d),e.a6.scale(d,d,[1,-1,1]),e.a6.rotateX(d,d,this._pitch),e.a6.rotateZ(d,d,this.angle);const _=e.a6.perspective(new Float32Array(16),this._fov,this.width/this.height,this._nearZ,this._farZ);this.starsProjMatrix=e.a6.clone(_);const p=(Math.PI/2-this._pitch)*(this.height/this._fov)*this._horizonShift;_[8]=2*-t.x/this.width,_[9]=2*(t.y+p)/this.height,this.skyboxMatrix=e.a6.multiply(d,_,d);const f=this.point,m=f.x,g=f.y,v=this.width%2/2,x=this.height%2/2,y=Math.cos(this.angle),b=Math.sin(this.angle),w=m-Math.round(m)+y*v+b*x,T=g-Math.round(g)+y*x+b*v,E=new Float64Array(h);if(e.a6.translate(E,E,[w>.5?w-1:w,T>.5?T-1:T,0]),this.alignedProjMatrix=E,h=e.a6.create(),e.a6.scale(h,h,[this.width/2,-this.height/2,1]),e.a6.translate(h,h,[1,-1,0]),this.labelPlaneMatrix=h,h=e.a6.create(),e.a6.scale(h,h,[1,-1,1]),e.a6.translate(h,h,[-1,-1,0]),e.a6.scale(h,h,[2/this.width,2/this.height,1]),this.glCoordMatrix=h,this.pixelMatrix=e.a6.multiply(new Float64Array(16),this.labelPlaneMatrix,c),this._calcFogMatrices(),this._distanceTileDataCache={},h=e.a6.invert(new Float64Array(16),this.pixelMatrix),!h)throw new Error("failed to invert matrix");if(this.pixelMatrixInverse=h,"globe"===this.projection.name||this.mercatorFromTransition){this.globeMatrix=e.bE(this);const t=[this.globeMatrix[12],this.globeMatrix[13],this.globeMatrix[14]];this.globeCenterInViewSpace=e.N.transformMat4(t,t,n),this.globeRadius=this.worldSize/2/Math.PI-1;}else this.globeMatrix=h;this._projMatrixCache={},this._alignedProjMatrixCache={},this._pixelsToTileUnitsCache={},this._expandedProjMatrixCache={};}_calcFogMatrices(){this._fogTileMatrixCache={};const t=this.cameraWorldSizeForFog,i=this.cameraPixelsPerMeter,o=this._camera.position,r=1/this.height/this._pixelsPerMercatorPixel,s=[t,t,i];e.N.scale(s,s,r),e.N.scale(o,o,-1),e.N.multiply(o,o,s);const n=e.a6.create();e.a6.translate(n,n,o),e.a6.scale(n,n,s),this.mercatorFogMatrix=n,this.worldToFogMatrix=this._camera.getWorldToCameraPosition(t,i,r);}_computeCameraPosition(e){const t=(e=e||this.pixelsPerMeter)/this.pixelsPerMeter,i=this._camera.forward(),o=this.point,r=this._mercatorZfromZoom(this._seaLevelZoom?this._seaLevelZoom:this._zoom)*t-e/this.worldSize*this._centerAltitude;return [o.x/this.worldSize-i[0]*r,o.y/this.worldSize-i[1]*r,e/this.worldSize*this._centerAltitude-i[2]*r]}_updateCameraState(){this.height&&(this._camera.setPitchBearing(this._pitch,this.angle),this._camera.position=this._computeCameraPosition());}_translateCameraConstrained(t){const i=this._maxCameraBoundsDistance()*Math.cos(this._pitch),o=this._camera.position[2],r=t[2];let s=1;this.projection.wrap&&(this.center=this.center.wrap()),r>0&&(s=Math.min((i-o)/r,1)),this._camera.position=e.N.scaleAndAdd([],this._camera.position,t,s),this._updateStateFromCamera();}_updateStateFromCamera(){const t=this._camera.position,i=this._camera.forward(),{pitch:o,bearing:r}=this._camera.getPitchBearing(),s=e.bl(this._centerAltitude,this.center.lat)*this._pixelsPerMercatorPixel,n=this._mercatorZfromZoom(this._maxZoom)*Math.cos(e.bj(this._maxPitch)),a=Math.max((t[2]-s)/Math.cos(o),n),l=this._zoomFromMercatorZ(a);e.N.scaleAndAdd(t,t,i,a),this._pitch=e.aa(o,e.bj(this.minPitch),e.bj(this.maxPitch)),this.angle=e.bh(r,-Math.PI,Math.PI),this._setZoom(e.aa(l,this._minZoom,this._maxZoom)),this._updateSeaLevelZoom(),this._center=this.coordinateLocation(new e.L(t[0],t[1],t[2])),this._unmodified=!1,this._constrain(),this._calcMatrices();}_worldSizeFromZoom(e){return Math.pow(2,e)*this.tileSize}_mercatorZfromZoom(e){return this.cameraToCenterDistance/this._worldSizeFromZoom(e)}_minimumHeightOverTerrain(){const e=Math.min(null!=this._seaLevelZoom?this._seaLevelZoom:this._zoom,this._maxZoom)+4;return this._mercatorZfromZoom(e)}_zoomFromMercatorZ(e){return this.scaleZoom(this.cameraToCenterDistance/(e*this.tileSize))}zoomFromMercatorZAdjusted(t){let i=0,o=e.bx,r=0,s=1/0;for(;o-i>1e-6&&o>i;){const e=i+.5*(o-i),n=this.tileSize*Math.pow(2,e),a=this.getCameraToCenterDistance(this.projection,e,n),l=this.scaleZoom(a/(t*this.tileSize)),c=Math.abs(e-l);c<s&&(s=c,r=e),e<l?i=e:o=e;}return r}_terrainEnabled(){return !(!this._elevation||!this.projection.supportsTerrain&&(e.w("Terrain is not yet supported with alternate projections. Use mercator or globe to enable terrain."),1))}anyCornerOffEdge(t,i){const o=Math.min(t.x,i.x),r=Math.max(t.x,i.x),s=Math.min(t.y,i.y),n=Math.max(t.y,i.y);if(s<this.horizonLineFromTop(!1))return !0;if("mercator"!==this.projection.name)return !1;const a=[new e.P(o,s),new e.P(r,n),new e.P(o,n),new e.P(r,s)],l=this.renderWorldCopies?-3:0,c=this.renderWorldCopies?4:1;for(const e of a){const t=this.pointRayIntersection(e);if(t.t<0)return !0;const i=this.rayIntersectionCoordinate(t);if(i.x<l||i.y<0||i.x>c||i.y>1)return !0}return !1}isHorizonVisible(){return this.pitch+e.bF(this.fovAboveCenter)>88||this.anyCornerOffEdge(new e.P(0,0),new e.P(this.width,this.height))}zoomDeltaToMovement(t,i){const o=e.N.length(e.N.sub([],this._camera.position,t)),r=this._zoomFromMercatorZ(o)+i;return o-this._mercatorZfromZoom(r)}getCameraPoint(){if("globe"===this.projection.name){const t=function([t,i,o],r){const s=[t,i,o,1];e.a7.transformMat4(s,s,r);const n=s[3]=Math.max(s[3],1e-6);return s[0]/=n,s[1]/=n,s[2]/=n,s}([this.globeMatrix[12],this.globeMatrix[13],this.globeMatrix[14]],this.pixelMatrix);return new e.P(t[0],t[1])}{const t=Math.tan(this._pitch)*(this.cameraToCenterDistance||1);return this.centerPoint.add(new e.P(0,t))}}getCameraToCenterDistance(t,i=this.zoom,o=this.worldSize){const r=e.bA(t,i,this.width,this.height,1024),s=t.pixelSpaceConversion(this.center.lat,o,r);let n=.5/Math.tan(.5*this._fov)*this.height*s;return this.isOrthographic&&(n=po(1,n,fo(this.pitch>=15?1:this.pitch/15))),n}getWorldToCameraMatrix(){const t=this._camera.getWorldToCamera(this.worldSize,"meters"===this.projection.zAxisUnit?this.pixelsPerMeter:1);return "globe"===this.projection.name&&e.a6.multiply(t,t,this.globeMatrix),t}getFrustum(t){return e.bq.fromInvProjectionMatrix(this.invProjMatrix,this.worldSize,t,"meters"===this.projection.zAxisUnit)}}const go={BaseColor:5,MetallicRoughness:6,Normal:7,Occlusion:8,Emission:9,ShadowMap0:10},vo=(t,i)=>{if(i>0&&t.terrain&&e.w("Cutoff is currently disabled on terrain"),i<=0||t.terrain)return {shouldRenderCutoff:!1,uniformValues:{u_cutoff_params:[0,0,0,1]}};const o=t.transform,r=Math.max(Math.abs(o._zoom-(t.minCutoffZoom-1)),1),s=o.isLODDisabled(!1)?e.O(60,45,o.pitch):e.O(30,15,o.pitch),n=o._farZ-o._nearZ,a=i*o.height,l=((1-(c=s))*o.cameraToCenterDistance+c*(o._farZ+a))*r;var c;return {shouldRenderCutoff:s<1,uniformValues:{u_cutoff_params:[o._nearZ,o._farZ,(l-o._nearZ)/n,(l-a-o._nearZ)/n]}}},xo={cascadeCount:2,shadowMapResolution:2048};class yo{constructor(e,t){this.aabb=e,this.lastCascade=t;}}class bo{add(e,t){const i=this.receivers[e.key];void 0!==i?(i.aabb.min[0]=Math.min(i.aabb.min[0],t.min[0]),i.aabb.min[1]=Math.min(i.aabb.min[1],t.min[1]),i.aabb.min[2]=Math.min(i.aabb.min[2],t.min[2]),i.aabb.max[0]=Math.max(i.aabb.max[0],t.max[0]),i.aabb.max[1]=Math.max(i.aabb.max[1],t.max[1]),i.aabb.max[2]=Math.max(i.aabb.max[2],t.max[2])):this.receivers[e.key]=new yo(t,null);}clear(){this.receivers={};}get(e){return this.receivers[e.key]}computeRequiredCascades(t,i,o){const r=e.bS.fromPoints(t.points);let s=0;for(const t in this.receivers){const n=this.receivers[t];if(!n)continue;if(!r.intersectsAabb(n.aabb))continue;n.aabb.min=r.closestPoint(n.aabb.min),n.aabb.max=r.closestPoint(n.aabb.max);const a=n.aabb.getCorners();for(let t=0;t<o.length;t++){let r=!0;for(const s of a){const n=[s[0]*i,s[1]*i,s[2]];if(e.N.transformMat4(n,n,o[t].matrix),n[0]<-1||n[0]>1||n[1]<-1||n[1]>1){r=!1;break}}if(n.lastCascade=t,s=Math.max(s,t),r)break}}return s+1}}class wo{constructor(e){this.painter=e,this._enabled=!1,this._shadowLayerCount=0,this._numCascadesToRender=0,this._cascades=[],this._groundShadowTiles=[],this._receivers=new bo,this._depthMode=new Lt(e.context.gl.LEQUAL,Lt.ReadWrite,[0,1]),this._uniformValues={u_light_matrix_0:new Float32Array(16),u_light_matrix_1:new Float32Array(16),u_shadow_intensity:0,u_fade_range:[0,0],u_shadow_normal_offset:[1,1,1],u_shadow_texel_size:1,u_shadow_map_resolution:1,u_shadow_direction:[0,0,1],u_shadow_bias:[36e-5,.0012,.012],u_shadowmap_0:0,u_shadowmap_1:0},this.useNormalOffset=!1,e.tp.registerParameter(xo,["Shadows"],"cascadeCount",{min:1,max:2,step:1}),e.tp.registerParameter(xo,["Shadows"],"shadowMapResolution",{min:32,max:2048,step:32});}destroy(){for(const e of this._cascades)e.texture.destroy(),e.framebuffer.destroy();this._cascades=[];}updateShadowParameters(t,i){const o=this.painter;if(this._enabled=!1,this._shadowLayerCount=0,this._receivers.clear(),!i||!i.properties)return;const r=i.properties.get("shadow-intensity");if(!i.shadowsEnabled()||r<=0)return;if(this._shadowLayerCount=o.style.order.reduce(((e,i)=>{const r=o.style._mergedLayers[i];return e+(r.hasShadowPass()&&!r.isHidden(t.zoom)?1:0)}),0),this._enabled=this._shadowLayerCount>0,!this._enabled)return;const s=o.context,n=xo.shadowMapResolution,a=xo.shadowMapResolution;if(0===this._cascades.length||xo.shadowMapResolution!==this._cascades[0].texture.size[0]){this._cascades=[];for(let t=0;t<xo.cascadeCount;++t){const t=o._shadowMapDebug,i=s.gl,r=s.createFramebuffer(n,a,t,"texture"),l=new e.T(s,{width:n,height:a,data:null},i.DEPTH_COMPONENT);if(r.depthAttachment.set(l.texture),t){const t=new e.T(s,{width:n,height:a,data:null},i.RGBA);r.colorAttachment.set(t.texture);}this._cascades.push({framebuffer:r,texture:l,matrix:[],far:0,boundingSphereRadius:0,frustum:new e.bq,scale:0});}}this.shadowDirection=Eo(i);let l=0;if(t.elevation){const e=t.elevation,i=[1e4,-1e4];e.visibleDemTiles.filter((e=>e.dem)).forEach((e=>{const t=e.dem.tree;i[0]=Math.min(i[0],t.minimums[0]),i[1]=Math.max(i[1],t.maximums[0]);})),1e4!==i[0]&&(l=(i[1]-i[0])*e.exaggeration());}const c=1.5*t.cameraToCenterDistance,h=3*c,u=new Float64Array(16);for(let i=0;i<this._cascades.length;++i){const o=this._cascades[i];let r=t.height/50,s=1;1===xo.cascadeCount?s=h:0===i?s=c:(r=c,s=h);const[n,a]=Co(t,this.shadowDirection,r,s,xo.shadowMapResolution,l);o.scale=t.scale,o.matrix=n,o.boundingSphereRadius=a,e.a6.invert(u,o.matrix),o.frustum=e.bq.fromInvProjectionMatrix(u,1,0,!0),o.far=s;}const d=this._cascades.length-1;this._uniformValues.u_fade_range=[.75*this._cascades[d].far,this._cascades[d].far],this._uniformValues.u_shadow_intensity=r,this._uniformValues.u_shadow_direction=[this.shadowDirection[0],this.shadowDirection[1],this.shadowDirection[2]],this._uniformValues.u_shadow_texel_size=1/xo.shadowMapResolution,this._uniformValues.u_shadow_map_resolution=xo.shadowMapResolution,this._uniformValues.u_shadowmap_0=go.ShadowMap0,this._uniformValues.u_shadowmap_1=go.ShadowMap0+1,this._groundShadowTiles=o.transform.coveringTiles({tileSize:512,renderWorldCopies:!0});const _=o.transform.elevation;for(const e of this._groundShadowTiles){let t={min:0,max:0};if(_){const i=_.getMinMaxForTile(e);i&&(t=i);}this.addShadowReceiver(e.toUnwrapped(),t.min,t.max);}}get enabled(){return this._enabled}set enabled(e){this._enabled=e;}drawShadowPass(t,i){if(!this._enabled)return;const o=this.painter,r=o.context;this._numCascadesToRender=this._receivers.computeRequiredCascades(o.transform.getFrustum(0),o.transform.worldSize,this._cascades),r.viewport.set([0,0,xo.shadowMapResolution,xo.shadowMapResolution]);for(let s=0;s<this._numCascadesToRender;++s){o.currentShadowCascade=s,r.bindFramebuffer.set(this._cascades[s].framebuffer.framebuffer),r.clear({color:e.ax.white,depth:1});for(const e of t.order){const r=t._mergedLayers[e];if(!r.hasShadowPass()||r.isHidden(o.transform.zoom))continue;const s=t.getLayerSourceCache(r),n=s?i[s.id]:void 0;("model"===r.type||n&&n.length)&&o.renderLayer(o,s,r,n);}}o.currentShadowCascade=0;}drawGroundShadows(){if(!this._enabled)return;const e=this.painter,t=e.style,i=e.context,o=t.directionalLight,r=t.ambientLight;if(!o||!r)return;const s=[],n=vo(e,e.longestCutoffRange);n.shouldRenderCutoff&&s.push("RENDER_CUTOFF");const a=So(o,r),l=new Lt(i.gl.LEQUAL,Lt.ReadOnly,e.depthRangeFor3D);for(const t of this._groundShadowTiles){const o=t.toUnwrapped(),r=e.isTileAffectedByFog(t),c=e.getOrCreateProgram("groundShadow",{defines:s,overrideFog:r});this.setupShadows(o,c),e.uploadCommonUniforms(i,c,o,null,n);const h={u_matrix:e.transform.calculateProjMatrix(o),u_ground_shadow_factor:a};c.draw(e,i.gl.TRIANGLES,l,Rt.disabled,Mt.multiply,Ft.disabled,h,"ground_shadow",e.tileExtentBuffer,e.quadTriangleIndexBuffer,e.tileExtentSegments,{},e.transform.zoom,null,null);}}getShadowPassColorMode(){return this.painter._shadowMapDebug?Mt.unblended:Mt.disabled}getShadowPassDepthMode(){return this._depthMode}getShadowCastingLayerCount(){return this._shadowLayerCount}calculateShadowPassMatrixFromTile(t){const i=this.painter.transform,o=i.calculatePosMatrix(t,i.worldSize);return e.a6.multiply(o,this._cascades[this.painter.currentShadowCascade].matrix,o),Float32Array.from(o)}calculateShadowPassMatrixFromMatrix(t){return e.a6.multiply(t,this._cascades[this.painter.currentShadowCascade].matrix,t),Float32Array.from(t)}setupShadows(t,i,o,r=0){if(!this._enabled)return;const s=this.painter.transform,n=this.painter.context,a=n.gl,l=this._uniformValues,c=new Float64Array(16),h=s.calculatePosMatrix(t,s.worldSize);for(let t=0;t<this._cascades.length;t++)e.a6.multiply(c,this._cascades[t].matrix,h),l[0===t?"u_light_matrix_0":"u_light_matrix_1"]=Float32Array.from(c),n.activeTexture.set(a.TEXTURE0+go.ShadowMap0+t),this._cascades[t].texture.bind(a.NEAREST,a.CLAMP_TO_EDGE);if(this.useNormalOffset=!!o,this.useNormalOffset){const i=e.bR(t.canonical),n=2/s.tileSize*e.V/xo.shadowMapResolution,a=n*this._cascades[0].boundingSphereRadius,c=n*this._cascades[this._cascades.length-1].boundingSphereRadius,h=("vector-tile"===o?1:3)/Math.pow(2,r-t.canonical.z-(1-s.zoom+Math.floor(s.zoom)));l.u_shadow_normal_offset=[i,a*h,c*h],l.u_shadow_bias=[6e-5,.0012,.012];}else l.u_shadow_bias=[36e-5,.0012,.012];i.setShadowUniformValues(n,l);}setupShadowsFromMatrix(t,i,o=!1){if(!this._enabled)return;const r=this.painter.context,s=r.gl,n=this._uniformValues,a=new Float64Array(16);for(let i=0;i<xo.cascadeCount;i++)e.a6.multiply(a,this._cascades[i].matrix,t),n[0===i?"u_light_matrix_0":"u_light_matrix_1"]=Float32Array.from(a),r.activeTexture.set(s.TEXTURE0+go.ShadowMap0+i),this._cascades[i].texture.bind(s.NEAREST,s.CLAMP_TO_EDGE);if(this.useNormalOffset=o,o){const e=5;n.u_shadow_normal_offset=[1,e,e],n.u_shadow_bias=[6e-5,.0012,.012];}else n.u_shadow_bias=[36e-5,.0012,.012];i.setShadowUniformValues(r,n);}getShadowUniformValues(){return this._uniformValues}getCurrentCascadeFrustum(){return this._cascades[this.painter.currentShadowCascade].frustum}computeSimplifiedTileShadowVolume(t,i,o,r){if(r[2]>=0)return {};const s=function(t,i,o){const r=o/(1<<t.canonical.z);return new e.bS([t.canonical.x*r+t.wrap*o,t.canonical.y*r+t.wrap*o,0],[(t.canonical.x+1)*r+t.wrap*o,(t.canonical.y+1)*r+t.wrap*o,i])}(t,i,o).getCorners(),n=i/-r[2];r[0]<0?(e.N.add(s[0],s[0],[r[0]*n,0,0]),e.N.add(s[3],s[3],[r[0]*n,0,0])):r[0]>0&&(e.N.add(s[1],s[1],[r[0]*n,0,0]),e.N.add(s[2],s[2],[r[0]*n,0,0])),r[1]<0?(e.N.add(s[0],s[0],[0,r[1]*n,0]),e.N.add(s[1],s[1],[0,r[1]*n,0])):r[1]>0&&(e.N.add(s[2],s[2],[0,r[1]*n,0]),e.N.add(s[3],s[3],[0,r[1]*n,0]));const a={};return a.vertices=s,a.planes=[To(s[1],s[0],s[4]),To(s[2],s[1],s[5]),To(s[3],s[2],s[6]),To(s[0],s[3],s[7])],a}addShadowReceiver(t,i,o){this._receivers.add(t,e.bS.fromTileIdAndHeight(t,i,o));}getMaxCascadeForTile(e){const t=this._receivers.get(e);return t&&t.lastCascade?t.lastCascade:0}}function To(t,i,o){const r=e.N.sub([],o,i),s=e.N.sub([],t,i),n=e.N.cross([],r,s),a=e.N.length(n);return 0===a?[0,0,1,0]:(e.N.scale(n,n,1/a),[n[0],n[1],n[2],-e.N.dot(n,i)])}function Eo(t){const i=t.properties.get("direction"),o=e.bQ(i.x,i.y,i.z);o[2]=e.aa(o[2],0,75);const r=e.bT([o[0],o[1],o[2]]);return e.N.fromValues(r.x,r.y,r.z)}function So(t,i){const o=t.properties.get("color"),r=t.properties.get("intensity"),s=t.properties.get("direction"),n=[s.x,s.y,s.z],a=i.properties.get("color"),l=i.properties.get("intensity"),c=Math.max(e.N.dot([0,0,1],n),0),h=[0,0,0];e.N.scale(h,a.toArray01Linear().slice(0,3),l);const u=[0,0,0];return e.N.scale(u,o.toArray01Linear().slice(0,3),c*r),e.bU([h[0]>0?h[0]/(h[0]+u[0]):0,h[1]>0?h[1]/(h[1]+u[1]):0,h[2]>0?h[2]/(h[2]+u[2]):0])}function Co(t,i,o,r,s,n){const a=t.zoom,l=t.scale,c=t.worldSize,h=1/c,u=t.aspect,d=Math.sqrt(1+u*u)*Math.tan(.5*t.fovX),_=d*d,p=r-o,f=r+o;let m,g;_>p/f?(m=r,g=r*d):(m=.5*f*(1+_),g=.5*Math.sqrt(p*p+2*(r*r+o*o)*_+f*f*_*_));const v=t.projection.pixelsPerMeter(t.center.lat,c),x=t._camera.getCameraToWorldMercator(),y=[0,0,-m*h];e.N.transformMat4(y,y,x);let b=g*h;const w=t._edgeInsets;if(!(0===w.left&&0===w.top&&0===w.right&&0===w.bottom||w.left===w.right&&w.top===w.bottom)){const i=t._camera.getWorldToCamera(t.worldSize,"meters"===t.projection.zAxisUnit?v:1),s=t._camera.getCameraToClipPerspective(t._fov,t.width/t.height,o,r);s[8]=2*-t.centerOffset.x/t.width,s[9]=2*t.centerOffset.y/t.height;const n=new Float64Array(16);e.a6.mul(n,s,i);const h=new Float64Array(16);e.a6.invert(h,n);const u=e.bq.fromInvProjectionMatrix(h,c,a,!0);for(const i of u.points){const o=((T=i)[0]/=l,T[1]/=l,T[2]=e.bl(T[2],t._center.lat),T);b=Math.max(b,e.N.len(e.N.subtract([],y,o)));}}var T;b*=s/(s-1);const E=Math.acos(i[2]),S=Math.atan2(-i[0],-i[1]),C=new _o;C.position=y,C.setPitchBearing(E,S);const I=C.getWorldToCamera(c,v),D=b*c,L=Math.min(t._mercatorZfromZoom(17)*c*-2,-2*D),A=C.getCameraToClipOrthographic(-D,D,-D,D,L,(D+n*v)/i[2]),R=new Float64Array(16);e.a6.multiply(R,A,I);const P=e.N.fromValues(Math.floor(1e6*y[0])/1e6*c,Math.floor(1e6*y[1])/1e6*c,0),M=.5*s,z=[0,0,0];e.N.transformMat4(z,P,R),e.N.scale(z,z,M);const O=[Math.floor(z[0]),Math.floor(z[1]),Math.floor(z[2])],F=[0,0,0];e.N.sub(F,z,O),e.N.scale(F,F,-1/M);const B=new Float64Array(16);return e.a6.identity(B),e.a6.translate(B,B,F),e.a6.multiply(R,B,R),[R,D]}const Io=(e,t)=>ce(e,t&&t.filter((e=>"source.canvas"!==e.identifier))),Do=e.ac(oi,["addLayer","removeLayer","setLights","setPaintProperty","setLayoutProperty","setSlot","setFilter","addSource","removeSource","setLayerZoomRange","setLight","setTransition","setGeoJSONSourceData","setTerrain","setFog","setProjection","setCamera","addImport","removeImport","updateImport"]),Lo=e.ac(oi,["setCenter","setZoom","setBearing","setPitch"]),Ao={version:8,layers:[],sources:{}},Ro={duration:300,delay:0},Po=new Set(["fill","line","background","hillshade","raster"]);class Mo extends e.E{constructor(t,i={}){super(),this.map=t,this.scope=i.scope||"",this.fragments=[],this.importDepth=i.importDepth||0,this.importsCache=i.importsCache||new Map,this.resolvedImports=i.resolvedImports||new Set,this.transition=e.e({},Ro),this._buildingIndex=new ei(this),this.crossTileSymbolIndex=new no,this._mergedOrder=[],this._drapedFirstOrder=[],this._mergedLayers={},this._mergedSourceCaches={},this._mergedOtherSourceCaches={},this._mergedSymbolSourceCaches={},this._has3DLayers=!1,this._hasCircleLayers=!1,this._hasSymbolLayers=!1,this._changes=i.styleChanges||new v,this.dispatcher=i.dispatcher?i.dispatcher:new e.bW(e.bX(),this),i.imageManager?this.imageManager=i.imageManager:(this.imageManager=new w,this.imageManager.setEventedParent(this)),this.imageManager.createScope(this.scope),this.glyphManager=i.glyphManager?i.glyphManager:new e.bY(t._requestManager,i.localFontFamily?e.bZ.all:i.localIdeographFontFamily?e.bZ.ideographs:e.bZ.none,i.localFontFamily||i.localIdeographFontFamily),i.modelManager?this.modelManager=i.modelManager:(this.modelManager=new x(t._requestManager),this.modelManager.setEventedParent(this)),this._layers={},this._serializedLayers={},this._sourceCaches={},this._otherSourceCaches={},this._symbolSourceCaches={},this._loaded=!1,this._precompileDone=!1,this._shouldPrecompile=!1,this._availableImages=[],this._order=[],this._markersNeedUpdate=!1,this.options=i.configOptions?i.configOptions:new Map,this._configDependentLayers=i.configDependentLayers?i.configDependentLayers:new Set,this._config=i.config,this.dispatcher.broadcast("setReferrer",e.b_());const o=this;this._rtlTextPluginCallback=Mo.registerForPluginStateChange((t=>{o.dispatcher.broadcast("syncRTLPluginState",{pluginStatus:t.pluginStatus,pluginURL:t.pluginURL},((t,i)=>{if(e.b$(t),i&&i.every((e=>e)))for(const e in o._sourceCaches){const t=o._sourceCaches[e],i=t.getSource().type;"vector"!==i&&"geojson"!==i||t.reload();}}));})),this.on("data",(e=>{if("source"!==e.dataType||"metadata"!==e.sourceDataType)return;const t=this.getOwnSource(e.sourceId);if(t&&t.vectorLayerIds)for(const e in this._layers){const i=this._layers[e];i.source===t.id&&this._validateLayer(i);}}));}loadURL(t,i={}){this.fire(new e.b("dataloading",{dataType:"style"}));const o="boolean"==typeof i.validate?i.validate:!e.c0(t);t=this.map._requestManager.normalizeStyleURL(t,i.accessToken),this.resolvedImports.add(t);const r=this.importsCache.get(t);if(r)return this._load(r,o);const s=this.map._requestManager.transformRequest(t,e.R.Style);this._request=e.g(s,((i,r)=>{if(this._request=null,i)this.fire(new e.a(i));else if(r)return this.importsCache.set(t,r),this._load(r,o)}));}loadJSON(t,i={}){this.fire(new e.b("dataloading",{dataType:"style"})),this._request=e.f.frame((()=>{this._request=null,this._load(t,!1!==i.validate);}));}loadEmpty(){this.fire(new e.b("dataloading",{dataType:"style"})),this._load(Ao,!1);}_loadImports(t,i,o){if(this.importDepth>=4)return e.w("Style doesn't support nesting deeper than 5"),Promise.resolve();const r=[];for(const e of t){const t=this._createFragmentStyle(e),s=new Promise((e=>{t.once("style.import.load",e),t.once("error",e);})).then((()=>this.mergeAll()));if(r.push(s),this.resolvedImports.has(e.url)){t.loadEmpty();continue}const n=e.data||this.importsCache.get(e.url);n?t.loadJSON(n,{validate:i}):e.url?t.loadURL(e.url,{validate:i}):t.loadEmpty();const a={style:t,id:e.id,config:e.config};if(o){const e=this.fragments.findIndex((({id:e})=>e===o));this.fragments=this.fragments.slice(0,e).concat(a).concat(this.fragments.slice(e));}else this.fragments.push(a);}return Promise.allSettled(r)}_createFragmentStyle(t){const i=this.scope?e.ag(t.id,this.scope):t.id,o=new Mo(this.map,{scope:i,styleChanges:this._changes,importDepth:this.importDepth+1,importsCache:this.importsCache,resolvedImports:new Set(this.resolvedImports),dispatcher:this.dispatcher,imageManager:this.imageManager,glyphManager:this.glyphManager,modelManager:this.modelManager,config:t.config,configOptions:this.options,configDependentLayers:this._configDependentLayers});return o.setEventedParent(this.map,{style:o}),o}_reloadImports(){this.mergeAll(),this._updateMapProjection(),this.updateConfigDependencies(),this.map._triggerCameraUpdate(this.camera),this.dispatcher.broadcast("setLayers",{layers:this._serializeLayers(this._order),scope:this.scope,options:this.options});const t=this.isRootStyle();this._shouldPrecompile=t,this.fire(new e.b(t?"style.load":"style.import.load"));}_load(t,i){const o=t.schema;if(this.isRootStyle()&&(t.fragment||o&&!1!==t.fragment)){const o=e.e({},Ao,{imports:[{id:"basemap",data:t,url:""}]});return void this._load(o,i)}if(this.setConfig(this._config,o),i&&Io(this,Y(t)))return;this._loaded=!0,this.stylesheet=e.c1(t);for(const e in t.sources)this.addSource(e,t.sources[e],{validate:!1,isInitialLoad:!0});t.sprite?this._loadSprite(t.sprite):(this.imageManager.setLoaded(!0,this.scope),this.dispatcher.broadcast("spriteLoaded",{scope:this.scope,isLoaded:!0})),this.glyphManager.setURL(t.glyphs,this.scope);const r=ii(this.stylesheet.layers);if(this._order=r.map((e=>e.id)),this.stylesheet.light&&e.w("The `light` root property is deprecated, prefer using `lights` with `flat` light type instead."),this.stylesheet.lights)if(1===this.stylesheet.lights.length&&"flat"===this.stylesheet.lights[0].type){const e=this.stylesheet.lights[0];this.light=new ue(e.properties,e.id);}else this.setLights(this.stylesheet.lights);this.light||(this.light=new ue(this.stylesheet.light)),this._layers={},this._serializedLayers={};for(const t of r){const i=e.c2(t,this.scope,this.options);i.isConfigDependent&&this._configDependentLayers.add(i.fqid),i.setEventedParent(this,{layer:{id:i.id}}),this._layers[i.id]=i,this._serializedLayers[i.id]=i.serialize();const o=this.getOwnLayerSourceCache(i),r=!!this.directionalLight&&this.directionalLight.shadowsEnabled();o&&i.canCastShadows()&&r&&(o.castsShadows=!0);}this.stylesheet.models&&this.modelManager.addModels(this.stylesheet.models,this.scope);const s=this.stylesheet.terrain;s&&(void 0===this.disableElevatedTerrain&&(this.disableElevatedTerrain=e.f.hasCanvasFingerprintNoise()),this.disableElevatedTerrain?e.w("Terrain and hillshade are disabled because of Canvas2D limitations when fingerprinting protection is enabled (e.g. in private browsing mode)."):this.terrainSetForDrapingOnly()||this._createTerrain(s,1)),this.stylesheet.fog&&this._createFog(this.stylesheet.fog),this.stylesheet.transition&&this.setTransition(this.stylesheet.transition),this.fire(new e.b("data",{dataType:"style"})),t.imports?this._loadImports(t.imports,i).then((()=>this._reloadImports())):this._reloadImports();}isRootStyle(){return 0===this.importDepth}mergeAll(){let t,i,o,r,s,n,a,l;this.terrain&&this.terrain.scope!==this.scope&&delete this.terrain,this.forEachFragmentStyle((e=>{if(e.stylesheet){if(null!=e.light&&(t=e.light),e.stylesheet.lights)for(const t of e.stylesheet.lights)"ambient"===t.type&&null!=e.ambientLight&&(i=e.ambientLight),"directional"===t.type&&null!=e.directionalLight&&(o=e.directionalLight);r=this._prioritizeTerrain(r,e.terrain,e.stylesheet.terrain),e.stylesheet.fog&&null!=e.fog&&(s=e.fog),null!=e.stylesheet.camera&&(l=e.stylesheet.camera),null!=e.stylesheet.projection&&(n=e.stylesheet.projection),null!=e.stylesheet.transition&&(a=e.stylesheet.transition);}})),this.light=t,this.ambientLight=i,this.directionalLight=o,this.fog=s,null===r?delete this.terrain:this.terrain=r,this.camera=l||{"camera-projection":"perspective"},this.projection=n||{name:"mercator"},this.transition=e.e({},Ro,a),this.mergeSources(),this.mergeLayers();}forEachFragmentStyle(e){const t=i=>{for(const e of i.fragments)t(e.style);e(i);};t(this);}_prioritizeTerrain(e,t,i){const o=e&&0===e.drapeRenderMode;return null===i?t&&0===t.drapeRenderMode?t:o?e:null:null!=t&&(!e||o||t&&1===t.drapeRenderMode)?t:e}mergeTerrain(){let e;this.terrain&&this.terrain.scope!==this.scope&&delete this.terrain,this.forEachFragmentStyle((t=>{e=this._prioritizeTerrain(e,t.terrain,t.stylesheet.terrain);})),null===e?delete this.terrain:this.terrain=e;}mergeProjection(){let e;this.forEachFragmentStyle((t=>{null!=t.stylesheet.projection&&(e=t.stylesheet.projection);})),this.projection=e||{name:"mercator"};}mergeSources(){const t={},i={},o={};this.forEachFragmentStyle((r=>{for(const i in r._sourceCaches){const o=e.ag(i,r.scope);t[o]=r._sourceCaches[i];}for(const t in r._otherSourceCaches){const o=e.ag(t,r.scope);i[o]=r._otherSourceCaches[t];}for(const t in r._symbolSourceCaches){const i=e.ag(t,r.scope);o[i]=r._symbolSourceCaches[t];}})),this._mergedSourceCaches=t,this._mergedOtherSourceCaches=i,this._mergedSymbolSourceCaches=o;}mergeLayers(){const t={},i=[],o={};this._has3DLayers=!1,this._hasCircleLayers=!1,this._hasSymbolLayers=!1,this.forEachFragmentStyle((o=>{for(const r of o._order){const s=o._layers[r];if("slot"===s.type){const i=e.c3(r);if(t[i])continue;t[i]=[];}s.slot&&t[s.slot]?t[s.slot].push(s):i.push(s);}})),this._mergedOrder=[];const r=(i=[])=>{for(const s of i)if("slot"===s.type){const i=e.c3(s.id);t[i]&&r(t[i]);}else {const t=e.ag(s.id,s.scope);this._mergedOrder.push(t),o[t]=s,s.is3D()&&(this._has3DLayers=!0),"circle"===s.type&&(this._hasCircleLayers=!0),"symbol"===s.type&&(this._hasSymbolLayers=!0);}};r(i),this._mergedLayers=o,this.updateDrapeFirstLayers(),this._buildingIndex.processLayersChanged();}terrainSetForDrapingOnly(){return !!this.terrain&&0===this.terrain.drapeRenderMode}getCamera(){return this.stylesheet.camera}setCamera(t){return this.stylesheet.camera=e.e({},this.stylesheet.camera,t),this.camera=this.stylesheet.camera,this}setProjection(e){e?this.stylesheet.projection=e:delete this.stylesheet.projection,this.mergeProjection(),this._updateMapProjection();}applyProjectionUpdate(){this._loaded&&(this.dispatcher.broadcast("setProjection",this.map.transform.projectionOptions),this.map.transform.projection.requiresDraping?(this.getTerrain()||this.stylesheet.terrain)&&!this.disableElevatedTerrain||this.setTerrainForDraping():this.terrainSetForDrapingOnly()&&this.setTerrain(null,0));}_updateMapProjection(){this.isRootStyle()&&(this.map._useExplicitProjection?this.applyProjectionUpdate():this.map._prioritizeAndUpdateProjection(null,this.projection));}_loadSprite(t){this._spriteRequest=function(t,i,o){let r,s,n;const a=e.f.devicePixelRatio>1?"@2x":"";let l=e.g(i.transformRequest(i.normalizeSpriteURL(t,a,".json"),e.R.SpriteJSON),((e,t)=>{l=null,n||(n=e,r=t,h());})),c=e.d(i.transformRequest(i.normalizeSpriteURL(t,a,".png"),e.R.SpriteImage),((e,t)=>{c=null,n||(n=e,s=t,h());}));function h(){if(n)o(n);else if(r&&s){const t=e.f.getImageData(s),i={};for(const o in r){const{width:s,height:n,x:a,y:l,sdf:c,pixelRatio:h,stretchX:u,stretchY:d,content:_}=r[o],p=new e.h({width:s,height:n});e.h.copy(t,p,{x:a,y:l},{x:0,y:0},{width:s,height:n}),i[o]={data:p,pixelRatio:h,sdf:c,stretchX:u,stretchY:d,content:_};}o(null,i);}}return {cancel(){l&&(l.cancel(),l=null),c&&(c.cancel(),c=null);}}}(t,this.map._requestManager,((t,i)=>{if(this._spriteRequest=null,t)this.fire(new e.a(t));else if(i)for(const e in i)this.imageManager.addImage(e,this.scope,i[e]);this.imageManager.setLoaded(!0,this.scope),this._availableImages=this.imageManager.listImages(this.scope),this.dispatcher.broadcast("setImages",{scope:this.scope,images:this._availableImages}),this.dispatcher.broadcast("spriteLoaded",{scope:this.scope,isLoaded:!0}),this.fire(new e.b("data",{dataType:"style"}));}));}_validateLayer(t){const i=this.getOwnSource(t.source);if(!i)return;const o=t.sourceLayer;o&&("geojson"===i.type||i.vectorLayerIds&&-1===i.vectorLayerIds.indexOf(o))&&this.fire(new e.a(new Error(`Source layer "${o}" does not exist on source "${i.id}" as specified by style layer "${t.id}"`)));}loaded(){if(!this._loaded)return !1;if(Object.keys(this._changes.getUpdatedSourceCaches()).length)return !1;for(const e in this._sourceCaches)if(!this._sourceCaches[e].loaded())return !1;if(!this.imageManager.isLoaded())return !1;if(!this.modelManager.isLoaded())return !1;for(const{style:e}of this.fragments)if(!e.loaded())return !1;return !0}_serializeImports(){if(this.stylesheet.imports)return this.stylesheet.imports.map(((e,t)=>{const i=this.fragments[t];return i&&i.style&&(e.data=i.style.serialize()),e}))}_serializeSources(){const e={};for(const t in this._sourceCaches){const i=this._sourceCaches[t].getSource();e[i.id]||(e[i.id]=i.serialize());}return e}_serializeLayers(e){const t=[];for(const i of e){const e=this._layers[i];e&&"custom"!==e.type&&t.push(e.serialize());}return t}hasLightTransitions(){return !(!this.light||!this.light.hasTransition())||!(!this.ambientLight||!this.ambientLight.hasTransition())||!(!this.directionalLight||!this.directionalLight.hasTransition())}hasFogTransition(){return !!this.fog&&this.fog.hasTransition()}hasTransitions(){if(this.hasLightTransitions())return !0;if(this.hasFogTransition())return !0;for(const e in this._sourceCaches)if(this._sourceCaches[e].hasTransition())return !0;for(const e in this._layers)if(this._layers[e].hasTransition())return !0;return !1}get order(){return this.terrain?this._drapedFirstOrder:this._mergedOrder}isLayerDraped(e){return !!this.terrain&&("function"==typeof e.isLayerDraped?e.isLayerDraped(this.getLayerSourceCache(e)):Po.has(e.type))}_checkLoaded(){if(!this._loaded)throw new Error("Style is not done loading")}_checkLayer(t){const i=this.getOwnLayer(t);if(i)return i;this.fire(new e.a(new Error(`The layer '${t}' does not exist in the map's style.`)));}_checkSource(t){const i=this.getOwnSource(t);if(i)return i;this.fire(new e.a(new Error(`The source '${t}' does not exist in the map's style.`)));}update(t){if(!this._loaded)return;this.ambientLight&&this.ambientLight.recalculate(t),this.directionalLight&&this.directionalLight.recalculate(t);const i=this.calculateLightsBrightness();t.brightness=i||0,i!==this._brightness&&(this._brightness=i,this.dispatcher.broadcast("setBrightness",i));const o=this._changes.isDirty();if(this._changes.isDirty()){const e=this._changes.getLayerUpdatesByScope();for(const t in e){const{updatedIds:i,removedIds:o}=e[t];(i||o)&&this._updateWorkerLayers(t,i,o);}this.updateSourceCaches(),this._updateTilesForChangedImages(),this.updateLayers(t),this.light&&this.light.updateTransitions(t),this.ambientLight&&this.ambientLight.updateTransitions(t),this.directionalLight&&this.directionalLight.updateTransitions(t),this.fog&&this.fog.updateTransitions(t),this._changes.reset();}const r={};for(const e in this._mergedSourceCaches){const t=this._mergedSourceCaches[e];r[e]=t.used,t.used=!1,t.tileCoverLift=0;}for(const e of this._mergedOrder){const i=this._mergedLayers[e];if(i.recalculate(t,this._availableImages),!i.isHidden(t.zoom)){const e=this.getLayerSourceCache(i);e&&(e.used=!0,e.tileCoverLift=Math.max(e.tileCoverLift,i.tileCoverLift()));}if(!this._precompileDone&&this._shouldPrecompile)for(let e=i.minzoom||0;e<(i.maxzoom||25.5);e++){const e=this.map.painter;if(e){const o=i.getProgramIds();if(!o)continue;for(const r of o){const o=i.getDefaultProgramParams(r,t.zoom);o&&(e.style=this,this.fog&&(e._fogVisible=!0,o.overrideFog=!0,e.getOrCreateProgram(r,o)),e._fogVisible=!1,o.overrideFog=!1,e.getOrCreateProgram(r,o),(this.stylesheet.terrain||this.stylesheet.projection&&"globe"===this.stylesheet.projection.name)&&(o.overrideRtt=!0,e.getOrCreateProgram(r,o)));}}}}this._shouldPrecompile&&(this._precompileDone=!0);for(const t in r){const i=this._mergedSourceCaches[t];r[t]!==i.used&&i.getSource().fire(new e.b("data",{sourceDataType:"visibility",dataType:"source",sourceId:i.getSource().id}));}this.light&&this.light.recalculate(t),this.terrain&&this.terrain.recalculate(t),this.fog&&this.fog.recalculate(t),this.z=t.zoom,this._markersNeedUpdate&&(this._updateMarkersOpacity(),this._markersNeedUpdate=!1),o&&this.fire(new e.b("data",{dataType:"style"}));}_updateTilesForChangedImages(){const e=this._changes.getUpdatedImages();if(e.length){for(const t in this._sourceCaches)this._sourceCaches[t].reloadTilesForDependencies(["icons","patterns"],e);this._changes.resetUpdatedImages();}}_updateWorkerLayers(e,t,i){const o=this.getFragmentStyle(e);o&&this.dispatcher.broadcast("updateLayers",{layers:t?o._serializeLayers(t):[],scope:e,removedIds:i||[],options:o.options});}setState(i){if(this._checkLoaded(),Io(this,Y(i)))return !1;(i=e.c1(i)).layers=ii(i.layers);const o=function(e,i){if(!e)return [{command:oi.setStyle,args:[i]}];let o=[];try{if(!t(e.version,i.version))return [{command:oi.setStyle,args:[i]}];t(e.center,i.center)||o.push({command:oi.setCenter,args:[i.center]}),t(e.zoom,i.zoom)||o.push({command:oi.setZoom,args:[i.zoom]}),t(e.bearing,i.bearing)||o.push({command:oi.setBearing,args:[i.bearing]}),t(e.pitch,i.pitch)||o.push({command:oi.setPitch,args:[i.pitch]}),t(e.sprite,i.sprite)||o.push({command:oi.setSprite,args:[i.sprite]}),t(e.glyphs,i.glyphs)||o.push({command:oi.setGlyphs,args:[i.glyphs]}),t(e.imports,i.imports)||function(e=[],i=[],o){i=i||[];const r=(e=e||[]).map(ci),s=i.map(ci),n=e.reduce(hi,{}),a=i.reduce(hi,{}),l=r.slice();let c,h,u,d;for(c=0,h=0;c<r.length;c++)u=r[c],a.hasOwnProperty(u)?h++:(o.push({command:oi.removeImport,args:[u]}),l.splice(l.indexOf(u,h),1));for(c=0,h=0;c<s.length;c++)u=s[s.length-1-c],l[l.length-1-c]!==u&&(n.hasOwnProperty(u)?(o.push({command:oi.removeImport,args:[u]}),l.splice(l.lastIndexOf(u,l.length-h),1)):h++,d=l[l.length-c],o.push({command:oi.addImport,args:[a[u],d]}),l.splice(l.length-c,0,u));for(const e of i){const i=n[e.id];i&&!t(i,e)&&o.push({command:oi.updateImport,args:[e.id,e]});}}(e.imports,i.imports,o),t(e.transition,i.transition)||o.push({command:oi.setTransition,args:[i.transition]}),t(e.light,i.light)||o.push({command:oi.setLight,args:[i.light]}),t(e.fog,i.fog)||o.push({command:oi.setFog,args:[i.fog]}),t(e.projection,i.projection)||o.push({command:oi.setProjection,args:[i.projection]}),t(e.lights,i.lights)||o.push({command:oi.setLights,args:[i.lights]}),t(e.camera,i.camera)||o.push({command:oi.setCamera,args:[i.camera]});const r={},s=[];!function(e,i,o,r){let s;for(s in i=i||{},e=e||{})e.hasOwnProperty(s)&&(i.hasOwnProperty(s)||si(s,o,r));for(s in i){if(!i.hasOwnProperty(s))continue;const n=i[s];e.hasOwnProperty(s)?t(e[s],n)||("geojson"===e[s].type&&"geojson"===n.type&&ai(e,i,s)?o.push({command:oi.setGeoJSONSourceData,args:[s,n.data]}):ni(s,i,o,r)):ri(s,i,o);}}(e.sources,i.sources,s,r);const n=[];e.layers&&e.layers.forEach((e=>{e.source&&r[e.source]?o.push({command:oi.removeLayer,args:[e.id]}):n.push(e);}));let a=e.terrain;a&&r[a.source]&&(o.push({command:oi.setTerrain,args:[void 0]}),a=void 0),o=o.concat(s),t(a,i.terrain)||o.push({command:oi.setTerrain,args:[i.terrain]}),function(e,i,o){i=i||[];const r=(e=e||[]).map(ci),s=i.map(ci),n=e.reduce(hi,{}),a=i.reduce(hi,{}),l=r.slice(),c=Object.create(null);let h,u,d,_,p,f,m;for(h=0,u=0;h<r.length;h++)d=r[h],a.hasOwnProperty(d)?u++:(o.push({command:oi.removeLayer,args:[d]}),l.splice(l.indexOf(d,u),1));for(h=0,u=0;h<s.length;h++)d=s[s.length-1-h],l[l.length-1-h]!==d&&(n.hasOwnProperty(d)?(o.push({command:oi.removeLayer,args:[d]}),l.splice(l.lastIndexOf(d,l.length-u),1)):u++,f=l[l.length-h],o.push({command:oi.addLayer,args:[a[d],f]}),l.splice(l.length-h,0,d),c[d]=!0);for(h=0;h<s.length;h++)if(d=s[h],_=n[d],p=a[d],!c[d]&&!t(_,p))if(t(_.source,p.source)&&t(_["source-layer"],p["source-layer"])&&t(_.type,p.type)){for(m in li(_.layout,p.layout,o,d,null,oi.setLayoutProperty),li(_.paint,p.paint,o,d,null,oi.setPaintProperty),t(_.slot,p.slot)||o.push({command:oi.setSlot,args:[d,p.slot]}),t(_.filter,p.filter)||o.push({command:oi.setFilter,args:[d,p.filter]}),t(_.minzoom,p.minzoom)&&t(_.maxzoom,p.maxzoom)||o.push({command:oi.setLayerZoomRange,args:[d,p.minzoom,p.maxzoom]}),_)_.hasOwnProperty(m)&&"layout"!==m&&"paint"!==m&&"filter"!==m&&"metadata"!==m&&"minzoom"!==m&&"maxzoom"!==m&&"slot"!==m&&(0===m.indexOf("paint.")?li(_[m],p[m],o,d,m.slice(6),oi.setPaintProperty):t(_[m],p[m])||o.push({command:oi.setLayerProperty,args:[d,m,p[m]]}));for(m in p)p.hasOwnProperty(m)&&!_.hasOwnProperty(m)&&"layout"!==m&&"paint"!==m&&"filter"!==m&&"metadata"!==m&&"minzoom"!==m&&"maxzoom"!==m&&"slot"!==m&&(0===m.indexOf("paint.")?li(_[m],p[m],o,d,m.slice(6),oi.setPaintProperty):t(_[m],p[m])||o.push({command:oi.setLayerProperty,args:[d,m,p[m]]}));}else o.push({command:oi.removeLayer,args:[d]}),f=l[l.lastIndexOf(d)+1],o.push({command:oi.addLayer,args:[p,f]});}(n,i.layers,o);}catch(e){console.warn("Unable to compute style diff:",e),o=[{command:oi.setStyle,args:[i]}];}return o}(this.serialize(),i).filter((e=>!(e.command in Lo)));if(0===o.length)return !1;const r=o.filter((e=>!(e.command in Do)));if(r.length>0)throw new Error(`Unimplemented: ${r.map((e=>e.command)).join(", ")}.`);return o.forEach((e=>{this[e.command].apply(this,e.args);})),this.stylesheet=i,this.mergeAll(),this.dispatcher.broadcast("setLayers",{layers:this._serializeLayers(this._order),scope:this.scope,options:this.options}),!0}addImage(t,i){return this.getImage(t)?this.fire(new e.a(new Error("An image with this name already exists."))):(this.imageManager.addImage(t,this.scope,i),this._afterImageUpdated(t),this)}updateImage(e,t){this.imageManager.updateImage(e,this.scope,t);}getImage(e){return this.imageManager.getImage(e,this.scope)}removeImage(t){return this.getImage(t)?(this.imageManager.removeImage(t,this.scope),this._afterImageUpdated(t),this):this.fire(new e.a(new Error("No image with this name exists.")))}_afterImageUpdated(t){this._availableImages=this.imageManager.listImages(this.scope),this._changes.updateImage(t),this.dispatcher.broadcast("setImages",{scope:this.scope,images:this._availableImages}),this.fire(new e.b("data",{dataType:"style"}));}listImages(){return this._checkLoaded(),this._availableImages.slice()}addModel(e,t,i={}){return this._checkLoaded(),this._validate(ae,`models.${e}`,t,null,i)||(this.modelManager.addModel(e,t,this.scope),this._changes.setDirty()),this}hasModel(e){return this.modelManager.hasModel(e,this.scope)}removeModel(t){return this.hasModel(t)?(this.modelManager.removeModel(t,this.scope),this):this.fire(new e.a(new Error("No model with this ID exists.")))}listModels(){return this._checkLoaded(),this.modelManager.listModels(this.scope)}addSource(t,i,o={}){if(this._checkLoaded(),void 0!==this.getOwnSource(t))throw new Error(`There is already a source with ID "${t}".`);if(!i.type)throw new Error(`The type property must be defined, but only the following properties were given: ${Object.keys(i).join(", ")}.`);if(["vector","raster","geojson","video","image"].indexOf(i.type)>=0&&this._validate(J,`sources.${t}`,i,null,o))return;this.map&&this.map._collectResourceTiming&&(i.collectResourceTiming=!0);const r=Vt(t,i,this.dispatcher,this);r.scope=this.scope,r.setEventedParent(this,(()=>({isSourceLoaded:this._isSourceCacheLoaded(r.id),source:r.serialize(),sourceId:r.id})));const s=t=>{const i=(t?"symbol:":"other:")+r.id,o=e.ag(i,this.scope),s=this._sourceCaches[i]=new Kt(o,r,t);(t?this._symbolSourceCaches:this._otherSourceCaches)[r.id]=s,s.onAdd(this.map);};s(!1),"vector"!==i.type&&"geojson"!==i.type||s(!0),r.onAdd&&r.onAdd(this.map),o.isInitialLoad||(this.mergeSources(),this._changes.setDirty());}removeSource(t){this._checkLoaded();const i=this.getOwnSource(t);if(!i)throw new Error("There is no source with this ID");for(const i in this._layers)if(this._layers[i].source===t)return this.fire(new e.a(new Error(`Source "${t}" cannot be removed while layer "${i}" is using it.`)));if(this.terrain&&this.terrain.scope===this.scope&&this.terrain.get().source===t)return this.fire(new e.a(new Error(`Source "${t}" cannot be removed while terrain is using it.`)));const o=this.getOwnSourceCaches(t);for(const t of o){const i=e.c3(t.id);delete this._sourceCaches[i],this._changes.discardSourceCacheUpdate(t.id),t.fire(new e.b("data",{sourceDataType:"metadata",dataType:"source",sourceId:t.getSource().id})),t.setEventedParent(null),t.clearTiles();}return delete this._otherSourceCaches[t],delete this._symbolSourceCaches[t],this.mergeSources(),i.setEventedParent(null),i.onRemove&&i.onRemove(this.map),this._changes.setDirty(),this}setGeoJSONSourceData(e,t){this._checkLoaded(),this.getOwnSource(e).setData(t),this._changes.setDirty();}getOwnSource(e){const t=this.getOwnSourceCache(e);return t&&t.getSource()}getOwnSources(){const e=[];for(const t in this._otherSourceCaches){const i=this.getOwnSourceCache(t);i&&e.push(i.getSource());}return e}areTilesLoaded(){const e=this._mergedSourceCaches;for(const t in e){const i=e[t]._tiles;for(const e in i){const t=i[e];if("loaded"!==t.state&&"errored"!==t.state)return !1}}return !0}setLights(t){if(this._checkLoaded(),!t)return delete this.ambientLight,void delete this.directionalLight;const i=this._getTransitionParameters();for(const e of t){if(this._validate(ee,"lights",e))return;switch(e.type){case"ambient":if(this.ambientLight){const t=this.ambientLight;t.set(e),t.updateTransitions(i);}else this.ambientLight=new Te(e,Ee,this.scope,this.options);break;case"directional":if(this.directionalLight){const t=this.directionalLight;t.set(e),t.updateTransitions(i);}else this.directionalLight=new Te(e,Se,this.scope,this.options);}}const o=new e.K(this.z||0,i);this.ambientLight&&this.ambientLight.recalculate(o),this.directionalLight&&this.directionalLight.recalculate(o),this._brightness=this.calculateLightsBrightness(),this.dispatcher.broadcast("setBrightness",this._brightness);}calculateLightsBrightness(){const t=this.directionalLight,i=this.ambientLight;if(!t||!i)return;const o=e=>.2126*(e[0]<=.03928?e[0]/12.92:Math.pow((e[0]+.055)/1.055,2.4))+.7152*(e[1]<=.03928?e[1]/12.92:Math.pow((e[1]+.055)/1.055,2.4))+.0722*(e[2]<=.03928?e[2]/12.92:Math.pow((e[2]+.055)/1.055,2.4)),r=t.properties.get("color").toArray01(),s=t.properties.get("intensity"),n=t.properties.get("direction"),a=1-e.bQ(n.x,n.y,n.z)[2]/90,l=o(r)*s*a,c=i.properties.get("color").toArray01(),h=i.properties.get("intensity");return (l+o(c)*h)/2}getBrightness(){return this._brightness}getLights(){if(!this.enable3dLights())return null;const e=[];return this.directionalLight&&e.push(this.directionalLight.get()),this.ambientLight&&e.push(this.ambientLight.get()),e}enable3dLights(){return !!this.ambientLight&&!!this.directionalLight}getFragmentStyle(t){if(!t)return this;if(e.c4(t)){const i=e.c5(t),o=this.fragments.find((({id:e})=>e===i));if(!o)throw new Error(`Style import not found: ${t}`);const r=e.c3(t);return o.style.getFragmentStyle(r)}{const e=this.fragments.find((({id:e})=>e===t));if(!e)throw new Error(`Style import not found: ${t}`);return e.style}}getConfigProperty(t,i){const o=this.getFragmentStyle(t);if(!o)return null;const r=e.ag(i,o.scope),s=o.options.get(r),n=s?s.value||s.default:null;return n?n.serialize():null}setConfigProperty(t,i,o){const r=e.r(o);if("success"!==r.result)return void Io(this,r.value);const s=r.value.expression,n=this.getFragmentStyle(t);if(!n)return;const a=e.ag(i,n.scope),l=n.options.get(a);l&&(this.options.set(a,{...l,value:s}),this.updateConfigDependencies());}setConfig(t,i){if(this._config=t,t||i)if(i)for(const o in i){let r,s;const n=e.r(i[o].default);if("success"===n.result&&(r=n.value.expression),t&&void 0!==t[o]){const i=e.r(t[o]);"success"===i.result&&(s=i.value.expression);}const{minValue:a,maxValue:l,stepValue:c,type:h,values:u}=i[o];if(r){const t=e.ag(o,this.scope);this.options.set(t,{default:r,value:s,minValue:a,maxValue:l,stepValue:c,type:h,values:u});}else this.fire(new e.a(new Error(`No schema defined for config option "${o}".`)));}else this.fire(new e.a(new Error("Attempting to set config for a style without schema.")));}updateConfigDependencies(){for(const e of this._configDependentLayers){const t=this.getLayer(e);t&&(t.possiblyEvaluateVisibility(),this._updateLayer(t));}this.ambientLight&&this.ambientLight.updateConfig(this.options),this.directionalLight&&this.directionalLight.updateConfig(this.options),this.fog&&this.fog.updateConfig(this.options),this._changes.setDirty();}addLayer(t,i,o={}){this._checkLoaded();const r=t.id;if(this._layers[r])return void this.fire(new e.a(new Error(`Layer with id "${r}" already exists on this map`)));let s;if("custom"===t.type){if(Io(this,e.c6(t)))return;s=e.c2(t,this.scope,this.options);}else {if("object"==typeof t.source&&(this.addSource(r,t.source),t=e.c1(t),t=e.e(t,{source:r})),this._validate(oe,`layers.${r}`,t,{arrayIndex:-1},o))return;s=e.c2(t,this.scope,this.options),this._validateLayer(s),s.setEventedParent(this,{layer:{id:r}}),this._serializedLayers[s.id]=s.serialize();}s.isConfigDependent&&this._configDependentLayers.add(s.fqid);let n=this._order.length;if(i){const t=this._order.indexOf(i);if(-1===t)return void this.fire(new e.a(new Error(`Layer with id "${i}" does not exist on this map.`)));s.slot===this._layers[i].slot?n=t:e.w(`Layer with id "${i}" has a different slot. Layers can only be rearranged within the same slot.`);}this._order.splice(n,0,r),this._layerOrderChanged=!0,this._layers[r]=s;const a=this.getOwnLayerSourceCache(s),l=!!this.directionalLight&&this.directionalLight.shadowsEnabled();a&&s.canCastShadows()&&l&&(a.castsShadows=!0);const c=this._changes.getRemovedLayer(s);if(c&&s.source&&a&&"custom"!==s.type){this._changes.discardLayerRemoval(s);const t=e.ag(s.source,s.scope);c.type!==s.type?this._changes.updateSourceCache(t,"clear"):(this._changes.updateSourceCache(t,"reload"),a.pause());}this._updateLayer(s),s.onAdd&&s.onAdd(this.map),s.scope=this.scope,this.mergeLayers();}moveLayer(t,i){this._checkLoaded();const o=this._checkLayer(t);if(!o)return;if(t===i)return;const r=this._order.indexOf(t);this._order.splice(r,1);let s=this._order.length;if(i){const t=this._order.indexOf(i);if(-1===t)return void this.fire(new e.a(new Error(`Layer with id "${i}" does not exist on this map.`)));o.slot===this._layers[i].slot?s=t:e.w(`Layer with id "${i}" has a different slot. Layers can only be rearranged within the same slot.`);}this._order.splice(s,0,t),this._changes.setDirty(),this._layerOrderChanged=!0,this.mergeLayers();}removeLayer(e){this._checkLoaded();const t=this._checkLayer(e);if(!t)return;t.setEventedParent(null);const i=this._order.indexOf(e);this._order.splice(i,1),delete this._layers[e],delete this._serializedLayers[e],this._changes.setDirty(),this._layerOrderChanged=!0,this._configDependentLayers.delete(t.fqid),this._changes.removeLayer(t);const o=this.getOwnLayerSourceCache(t);if(o&&o.castsShadows){let e=!1;for(const i in this._layers)if(this._layers[i].source===t.source&&this._layers[i].canCastShadows()){e=!0;break}o.castsShadows=e;}t.onRemove&&t.onRemove(this.map),this.mergeLayers();}getOwnLayer(e){return this._layers[e]}hasLayer(e){return e in this._mergedLayers}hasLayerType(e){for(const t in this._layers)if(this._layers[t].type===e)return !0;return !1}setLayerZoomRange(e,t,i){this._checkLoaded();const o=this._checkLayer(e);o&&(o.minzoom===t&&o.maxzoom===i||(null!=t&&(o.minzoom=t),null!=i&&(o.maxzoom=i),this._updateLayer(o)));}setSlot(e,t){this._checkLoaded();const i=this._checkLayer(e);i&&i.slot!==t&&(i.slot=t,this._updateLayer(i));}setFilter(i,o,r={}){this._checkLoaded();const s=this._checkLayer(i);if(s&&!t(s.filter,o))return null==o?(s.filter=void 0,void this._updateLayer(s)):void(this._validate(re,`layers.${s.id}.filter`,o,{layerType:s.type},r)||(s.filter=e.c1(o),this._updateLayer(s)))}getFilter(t){const i=this._checkLayer(t);if(i)return e.c1(i.filter)}setLayoutProperty(i,o,r,s={}){this._checkLoaded();const n=this._checkLayer(i);if(n&&!t(n.getLayoutProperty(o),r)){if(null!=r&&(!s||!1!==s.validate)&&Io(n,ne.call(Y,{key:`layers.${i}.layout.${o}`,layerType:n.type,objectKey:o,value:r,styleSpec:e.D,style:{glyphs:!0,sprite:!0}})))return;n.setLayoutProperty(o,r),n.isConfigDependent&&this._configDependentLayers.add(n.fqid),this._updateLayer(n);}}getLayoutProperty(e,t){const i=this._checkLayer(e);if(i)return i.getLayoutProperty(t)}setPaintProperty(i,o,r,s={}){this._checkLoaded();const n=this._checkLayer(i);if(!n)return;if(t(n.getPaintProperty(o),r))return;if(null!=r&&(!s||!1!==s.validate)&&Io(n,se.call(Y,{key:`layers.${i}.paint.${o}`,layerType:n.type,objectKey:o,value:r,styleSpec:e.D})))return;const a=n.setPaintProperty(o,r);n.isConfigDependent&&this._configDependentLayers.add(n.fqid),a&&this._updateLayer(n),this._changes.updatePaintProperties(n);}getPaintProperty(e,t){const i=this._checkLayer(e);if(i)return i.getPaintProperty(t)}setFeatureState(t,i){this._checkLoaded();const o=t.source,r=t.sourceLayer,s=this._checkSource(o);if(!s)return;const n=s.type;if("geojson"===n&&r)return void this.fire(new e.a(new Error("GeoJSON sources cannot have a sourceLayer parameter.")));if("vector"===n&&!r)return void this.fire(new e.a(new Error("The sourceLayer parameter must be provided for vector source types.")));void 0===t.id&&this.fire(new e.a(new Error("The feature id parameter must be provided.")));const a=this.getOwnSourceCaches(o);for(const e of a)e.setFeatureState(r,t.id,i);}removeFeatureState(t,i){this._checkLoaded();const o=t.source,r=this._checkSource(o);if(!r)return;const s=r.type,n="vector"===s?t.sourceLayer:void 0;if("vector"===s&&!n)return void this.fire(new e.a(new Error("The sourceLayer parameter must be provided for vector source types.")));if(i&&"string"!=typeof t.id&&"number"!=typeof t.id)return void this.fire(new e.a(new Error("A feature id is required to remove its specific state property.")));const a=this.getOwnSourceCaches(o);for(const e of a)e.removeFeatureState(n,t.id,i);}getFeatureState(t){this._checkLoaded();const i=t.source,o=t.sourceLayer,r=this._checkSource(i);if(r){if("vector"!==r.type||o)return void 0===t.id&&this.fire(new e.a(new Error("The feature id parameter must be provided."))),this.getOwnSourceCaches(i)[0].getFeatureState(o,t.id);this.fire(new e.a(new Error("The sourceLayer parameter must be provided for vector source types.")));}}setTransition(t){return this.stylesheet.transition=e.e({},this.stylesheet.transition,t),this.transition=this.stylesheet.transition,this}getTransition(){return e.e({},this.stylesheet.transition)}serialize(){this._checkLoaded();const t=this.getTerrain(),i=t&&this.terrain&&this.terrain.scope===this.scope?t:this.stylesheet.terrain;return e.c7({version:this.stylesheet.version,name:this.stylesheet.name,metadata:this.stylesheet.metadata,imports:this._serializeImports(),schema:this.stylesheet.schema,camera:this.stylesheet.camera,light:this.stylesheet.light,lights:this.stylesheet.lights,terrain:i,fog:this.stylesheet.fog,center:this.stylesheet.center,zoom:this.stylesheet.zoom,bearing:this.stylesheet.bearing,pitch:this.stylesheet.pitch,sprite:this.stylesheet.sprite,glyphs:this.stylesheet.glyphs,transition:this.stylesheet.transition,projection:this.stylesheet.projection,sources:this._serializeSources(),layers:this._serializeLayers(this._order)},(e=>void 0!==e))}_updateLayer(t){this._changes.updateLayer(t);const i=this.getLayerSourceCache(t),o=e.ag(t.source,t.scope),r=this._changes.getUpdatedSourceCaches();t.source&&!r[o]&&i&&"raster"!==i.getSource().type&&(this._changes.updateSourceCache(o,"reload"),i.pause()),t.invalidateCompiledFilter();}_flattenAndSortRenderedFeatures(e){const t=e=>"fill-extrusion"===this._mergedLayers[e].type||"model"===this._mergedLayers[e].type,i=this.order,o={},r=[];for(let s=i.length-1;s>=0;s--){const n=i[s];if(t(n)){o[n]=s;for(const t of e){const e=t[n];if(e)for(const t of e)r.push(t);}}}r.sort(((e,t)=>t.intersectionZ-e.intersectionZ));const s=[];for(let n=i.length-1;n>=0;n--){const a=i[n];if(t(a))for(let e=r.length-1;e>=0;e--){const t=r[e].feature;if(o[t.layer.id]<n)break;s.push(t),r.pop();}else for(const t of e){const e=t[a];if(e)for(const t of e)s.push(t.feature);}}return s}queryRenderedFeatures(t,i,o){i&&i.filter&&this._validate(re,"queryRenderedFeatures.filter",i.filter,null,i),i.scope=this.scope,i.availableImages=this._availableImages,i.serializedLayers=this._serializedLayers;const r={};if(i&&i.layers){if(!Array.isArray(i.layers))return this.fire(new e.a(new Error("parameters.layers must be an Array."))),[];for(const t of i.layers){const i=this._mergedLayers[t];if(!i)return this.fire(new e.a(new Error(`The layer '${t}' does not exist in the map's style and cannot be queried for features.`))),[];r[i.source]=!0;}}const s=[],n=i.serializedLayers||{},a=i&&i.layers?i.layers.some((e=>{const t=this.getLayer(e);return t&&t.is3D()})):this.has3DLayers(),l=Ce.createFromScreenPoints(t,o);for(const e in this._mergedSourceCaches){const t=this._mergedSourceCaches[e].getSource();if(!t||t.scope!==i.scope)continue;const c=this._mergedSourceCaches[e].getSource().id;i.layers&&!r[c]||s.push(Ht(this._mergedSourceCaches[e],this._mergedLayers,n,l,i,o,a,!!this.map._showQueryGeometry));}return this.placement&&s.push(function(e,t,i,o,r,s,n){const a={},l=s.queryRenderedSymbols(o),c=[];for(const e of Object.keys(l).map(Number))c.push(n[e]);c.sort(qt);for(const i of c){const o=i.featureIndex.lookupSymbolFeatures(l[i.bucketInstanceId],t,i.bucketIndex,i.sourceLayerIndex,r.filter,r.layers,r.availableImages,e);for(const e in o){const t=a[e]=a[e]||[],r=o[e];r.sort(((e,t)=>{const o=i.featureSortOrder;if(o){const i=o.indexOf(e.featureIndex);return o.indexOf(t.featureIndex)-i}return t.featureIndex-e.featureIndex}));for(const e of r)t.push(e);}}for(const t in a)a[t].forEach((o=>{const r=o.feature,s=i(e[t]);if(!s)return;const n=s.getFeatureState(r.layer["source-layer"],r.id);r.source=r.layer.source,r.layer["source-layer"]&&(r.sourceLayer=r.layer["source-layer"]),r.state=n;}));return a}(this._mergedLayers,n,this.getLayerSourceCache.bind(this),l.screenGeometry,i,this.placement.collisionIndex,this.placement.retainedQueryData)),this._flattenAndSortRenderedFeatures(s)}querySourceFeatures(e,t){t&&t.filter&&this._validate(re,"querySourceFeatures.filter",t.filter,null,t);const i=this.getOwnSourceCaches(e);let o=[];for(const e of i)o=o.concat(Wt(e,t));return o}addSourceType(e,t,i){return Mo.getSourceType(e)?i(new Error(`A source type called "${e}" already exists.`)):(Mo.setSourceType(e,t),t.workerSourceURL?void this.dispatcher.broadcast("loadWorkerSource",{name:e,url:t.workerSourceURL},i):i(null,null))}getFlatLight(){return this.light.getLight()}setFlatLight(e,i,o={}){this._checkLoaded();const r=this.light.getLight();let s=!1;for(const i in e)if(!t(e[i],r[i])){s=!0;break}if(!s)return;const n=this._getTransitionParameters();this.light.setLight(e,i,o),this.light.updateTransitions(n);}getTerrain(){return this.terrain&&1===this.terrain.drapeRenderMode?this.terrain.get():null}setTerrainForDraping(){this.setTerrain({source:"",exaggeration:0},0);}setTerrain(i,o=1){if(this._checkLoaded(),!i)return this.terrainSetForDrapingOnly()&&0!==o||delete this.terrain,null===i?this.stylesheet.terrain=null:delete this.stylesheet.terrain,this._force3DLayerUpdate(),void(this._markersNeedUpdate=!0);let r=i;const s=null==i.source;if(1===o){if("object"==typeof r.source){const t="terrain-dem-src";this.addSource(t,r.source),r=e.c1(r),r=e.e(r,{source:t});}const t=e.e({},r),i={};if(this.terrain&&s){t.source=this.terrain.get().source;const e=this.terrain?this.getFragmentStyle(this.terrain.scope):null;e&&(i.style=e.serialize());}if(this._validate(te,"terrain",t,i))return}if(!this.terrain||this.terrain.scope!==this.scope&&!s||this.terrain&&o!==this.terrain.drapeRenderMode){if(!r)return;this._createTerrain(r,o),this.fire(new e.b("data",{dataType:"style"}));}else {const o=this.terrain,s=o.get();for(const t of Object.keys(e.D.terrain))!r.hasOwnProperty(t)&&e.D.terrain[t].default&&(r[t]=e.D.terrain[t].default);for(const r in i)if(!t(i[r],s[r])){o.set(i,this.options),this.stylesheet.terrain=i;const t=this._getTransitionParameters({duration:0});o.updateTransitions(t),this.fire(new e.b("data",{dataType:"style"}));break}}this.mergeTerrain(),this.updateDrapeFirstLayers(),this._markersNeedUpdate=!0;}_createFog(e){const t=this.fog=new we(e,this.map.transform,this.scope,this.options);this.stylesheet.fog=t.get();const i=this._getTransitionParameters({duration:0});t.updateTransitions(i);}_updateMarkersOpacity(){0!==this.map._markers.length&&this.map._requestDomTask((()=>{for(const e of this.map._markers)e._evaluateOpacity();}));}getFog(){return this.fog?this.fog.get():null}setFog(e){if(this._checkLoaded(),!e)return delete this.fog,delete this.stylesheet.fog,void(this._markersNeedUpdate=!0);if(this.fog){const i=this.fog;if(!t(i.get(),e)){i.set(e,this.options),this.stylesheet.fog=i.get();const t=this._getTransitionParameters({duration:0});i.updateTransitions(t);}}else this._createFog(e);this._markersNeedUpdate=!0;}_getTransitionParameters(t){return {now:e.f.now(),transition:e.e(this.transition,t)}}updateDrapeFirstLayers(){if(!this.terrain)return;const e=[],t=[];for(const i in this._mergedLayers)this.isLayerDraped(this._mergedLayers[i])?e.push(i):t.push(i);this._drapedFirstOrder=[],this._drapedFirstOrder.push(...e),this._drapedFirstOrder.push(...t);}_createTerrain(e,t){const i=this.terrain=new _e(e,t,this.scope,this.options);1===t&&(this.stylesheet.terrain=e),this.mergeTerrain(),this.updateDrapeFirstLayers(),this._force3DLayerUpdate();const o=this._getTransitionParameters({duration:0});i.updateTransitions(o);}_force3DLayerUpdate(){for(const e in this._layers){const t=this._layers[e];"fill-extrusion"===t.type&&this._updateLayer(t);}}_forceSymbolLayerUpdate(){for(const e in this._layers){const t=this._layers[e];"symbol"===t.type&&this._updateLayer(t);}}_validate(t,i,o,r,s={}){if(s&&!1===s.validate)return !1;const n=e.e({},this.serialize());return Io(this,t.call(Y,e.e({key:i,style:n,value:o,styleSpec:e.D},r)))}_remove(){this._request&&(this._request.cancel(),this._request=null),this._spriteRequest&&(this._spriteRequest.cancel(),this._spriteRequest=null),e.c8.off("pluginStateChange",this._rtlTextPluginCallback);for(const e in this._mergedLayers)this._mergedLayers[e].setEventedParent(null);for(const e in this._mergedSourceCaches)this._mergedSourceCaches[e].clearTiles(),this._mergedSourceCaches[e].setEventedParent(null);this.setEventedParent(null),delete this.fog,delete this.terrain,delete this.ambientLight,delete this.directionalLight,this.isRootStyle()&&(this.imageManager.setEventedParent(null),this.modelManager.setEventedParent(null),this.dispatcher.remove());}clearSource(e){const t=this.getSourceCaches(e);for(const e of t)e.clearTiles();}clearSources(){for(const e in this._mergedSourceCaches)this._mergedSourceCaches[e].clearTiles();}reloadSource(e){const t=this.getSourceCaches(e);for(const e of t)e.resume(),e.reload();}reloadSources(){for(const e of this.getSources())e.reload&&e.reload();}updateSources(e){let t;this.directionalLight&&(t=Eo(this.directionalLight));for(const i in this._mergedSourceCaches)this._mergedSourceCaches[i].update(e,void 0,void 0,t);}_generateCollisionBoxes(){for(const e in this._sourceCaches){const t=this._sourceCaches[e];t.resume(),t.reload();}}_updatePlacement(t,i,o,r,s=!1){let n=!1,a=!1;const l={},c={};for(const i of this._mergedOrder){const o=this._mergedLayers[i];if("symbol"!==o.type)continue;const r=e.ag(o.source,o.scope);let s=l[r];if(!s){const e=this.getLayerSourceCache(o);if(!e)continue;const t=e.getRenderableIds(!0).map((t=>e.getTileByID(t)));c[r]=t.slice(),s=l[r]=t.sort(((e,t)=>t.tileID.overscaledZ-e.tileID.overscaledZ||(e.tileID.isLessThan(t.tileID)?-1:1)));}const a=this.crossTileSymbolIndex.addLayer(o,s,t.center.lng,t.projection);n=n||a;}if(this.crossTileSymbolIndex.pruneUnusedLayers(this._mergedOrder),s=s||this._layerOrderChanged||0===o,this._layerOrderChanged&&this.fire(new e.b("neworder")),(s||!this.pauseablePlacement||this.pauseablePlacement.isDone()&&!this.placement.stillRecent(e.f.now(),t.zoom))&&(this.pauseablePlacement=new to(t,this._mergedOrder,s,i,o,r,this.placement,this.fog&&t.projection.supportsFog?this.fog.state:null,this._buildingIndex),this._layerOrderChanged=!1),this.pauseablePlacement.isDone()?this.placement.setStale():(this.pauseablePlacement.continuePlacement(this._mergedOrder,this._mergedLayers,l,c),this.pauseablePlacement.isDone()&&(this.placement=this.pauseablePlacement.commit(e.f.now()),a=!0),n&&this.pauseablePlacement.placement.setStale()),a||n){this._buildingIndex.onNewFrame(t.zoom);for(const t of this._mergedOrder){const i=this._mergedLayers[t];"symbol"===i.type&&this.placement.updateLayerOpacities(i,l[e.ag(i.source,i.scope)]);}}return !this.pauseablePlacement.isDone()||this.placement.hasTransitions(e.f.now())}_releaseSymbolFadeTiles(){for(const e in this._sourceCaches)this._sourceCaches[e].releaseSymbolFadeTiles();}addImport(t,i){this._checkLoaded();const o=this.stylesheet.imports=this.stylesheet.imports||[];if(-1!==o.findIndex((({id:e})=>e===t.id)))return this.fire(new e.a(new Error(`Import with id '${t.id}' already exists in the map's style.`)));if(!i)return o.push(t),this._loadImports([t],!0),this;const r=o.findIndex((({id:e})=>e===i));return -1===r?this.fire(new e.a(new Error(`Import with id "${i}" does not exist on this map.`))):(this.stylesheet.imports=o.slice(0,r).concat(t).concat(o.slice(r)),this._loadImports([t],!0,i),this)}updateImport(e,i){this._checkLoaded();const o=this.stylesheet.imports||[],r=this.getImportIndex(e);return -1===r?this:"string"==typeof i?(this.setImportUrl(e,i),this):(i.url&&i.url!==o[r].url&&this.setImportUrl(e,i.url),t(i.config,o[r].config)||this.setImportConfig(e,i.config),t(i.data,o[r].data)||this.setImportData(e,i.data),this)}moveImport(e,t){this._checkLoaded();let i=this.stylesheet.imports||[];const o=this.getImportIndex(e);if(-1===o)return this;const r=this.getImportIndex(t);if(-1===r)return this;const s=i[o],n=this.fragments[o];return i=i.filter((({id:t})=>t!==e)),this.fragments=this.fragments.filter((({id:t})=>t!==e)),this.stylesheet.imports=i.slice(0,r).concat(s).concat(i.slice(r)),this.fragments=this.fragments.slice(0,r).concat(n).concat(this.fragments.slice(r)),this.mergeLayers(),this}setImportUrl(e,t){this._checkLoaded();const i=this.stylesheet.imports||[],o=this.getImportIndex(e);if(-1===o)return this;i[o].url=t;const r=this.fragments[o];return r.style=this._createFragmentStyle(i[o]),r.style.on("style.import.load",(()=>this.mergeAll())),r.style.loadURL(t),this}setImportData(e,t){this._checkLoaded();const i=this.getImportIndex(e),o=this.stylesheet.imports||[];return -1===i?this:t?(this.fragments[i].style.setState(t),this._reloadImports(),this):(delete o[i].data,this.setImportUrl(e,o[i].url))}setImportConfig(e,t){this._checkLoaded();const i=this.getImportIndex(e),o=this.stylesheet.imports||[];if(-1===i)return this;t?o[i].config=t:delete o[i].config;const r=this.fragments[i],s=r.style.stylesheet&&r.style.stylesheet.schema;return r.config=t,r.style.setConfig(t,s),this.updateConfigDependencies(),this}removeImport(e){this._checkLoaded();const t=this.stylesheet.imports||[],i=this.getImportIndex(e);return -1===i||(t.splice(i,1),this.fragments[i].style._remove(),this.fragments.splice(i,1),this._reloadImports()),this}getImportIndex(t){const i=(this.stylesheet.imports||[]).findIndex((e=>e.id===t));return -1===i&&this.fire(new e.a(new Error(`Import '${t}' does not exist in the map's style and cannot be updated.`))),i}getLayer(e){return this._mergedLayers[e]}getSources(){const e=[];for(const t in this._mergedOtherSourceCaches){const i=this._mergedOtherSourceCaches[t];i&&e.push(i.getSource());}return e}getSource(e,t){const i=this.getSourceCache(e,t);return i&&i.getSource()}getLayerSource(e){const t=this.getLayerSourceCache(e);return t&&t.getSource()}getSourceCache(t,i){const o=e.ag(t,i);return this._mergedOtherSourceCaches[o]}getLayerSourceCache(t){const i=e.ag(t.source,t.scope);return "symbol"===t.type?this._mergedSymbolSourceCaches[i]:this._mergedOtherSourceCaches[i]}getSourceCaches(e){const t=[];return this._mergedOtherSourceCaches[e]&&t.push(this._mergedOtherSourceCaches[e]),this._mergedSymbolSourceCaches[e]&&t.push(this._mergedSymbolSourceCaches[e]),t}updateSourceCaches(){const e=this._changes.getUpdatedSourceCaches();for(const t in e){const i=e[t];"reload"===i?this.reloadSource(t):"clear"===i&&this.clearSource(t);}}updateLayers(e){const t=this._changes.getUpdatedPaintProperties();for(const i of t){const t=this.getLayer(i);t&&t.updateTransitions(e);}}getImages(e,t,i){this.imageManager.getImages(t.icons,t.scope,i),this._updateTilesForChangedImages();const o=e=>{e&&e.setDependencies(t.tileID.key,t.type,t.icons);};o(this._otherSourceCaches[t.source]),o(this._symbolSourceCaches[t.source]);}getGlyphs(e,t,i){this.glyphManager.getGlyphs(t.stacks,t.scope,i);}getResource(t,i,o){return e.c9(i,o)}getOwnSourceCache(e){return this._otherSourceCaches[e]}getOwnLayerSourceCache(e){return "symbol"===e.type?this._symbolSourceCaches[e.source]:this._otherSourceCaches[e.source]}getOwnSourceCaches(e){const t=[];return this._otherSourceCaches[e]&&t.push(this._otherSourceCaches[e]),this._symbolSourceCaches[e]&&t.push(this._symbolSourceCaches[e]),t}_isSourceCacheLoaded(t){const i=this.getOwnSourceCaches(t);return 0===i.length?(this.fire(new e.a(new Error(`There is no source with ID '${t}'`))),!1):i.every((e=>e.loaded()))}has3DLayers(){return this._has3DLayers}hasSymbolLayers(){return this._hasSymbolLayers}hasCircleLayers(){return this._hasCircleLayers}_clearWorkerCaches(){this.dispatcher.broadcast("clearCaches");}destroy(){this._clearWorkerCaches(),this.fragments.forEach((e=>{e.style._remove();})),this.terrainSetForDrapingOnly()&&(delete this.terrain,delete this.stylesheet.terrain);}}Mo.getSourceType=function(e){return jt[e]},Mo.setSourceType=function(e,t){jt[e]=t;},Mo.registerForPluginStateChange=e.bV;var zo="\n#define EPSILON 0.0000001\n#define PI 3.141592653589793\n#ifdef RENDER_CUTOFF\nfloat cutoff_opacity(vec4 cutoff_params,float depth) {float near=cutoff_params.x;float far=cutoff_params.y;float cutoffStart=cutoff_params.z;float cutoffEnd=cutoff_params.w;float linearDepth=(depth-near)/(far-near);return clamp((linearDepth-cutoffStart)/(cutoffEnd-cutoffStart),0.0,1.0);}\n#endif",Oo="\nout vec4 glFragColor;highp float unpack_depth(highp vec4 rgba_depth)\n{const highp vec4 bit_shift=vec4(1.0/(255.0*255.0*255.0),1.0/(255.0*255.0),1.0/255.0,1.0);return dot(rgba_depth,bit_shift)*2.0-1.0;}highp vec4 pack_depth(highp float ndc_z) {highp float depth=ndc_z*0.5+0.5;const highp vec4 bit_shift=vec4(255.0*255.0*255.0,255.0*255.0,255.0,1.0);const highp vec4 bit_mask =vec4(0.0,1.0/255.0,1.0/255.0,1.0/255.0);highp vec4 res=fract(depth*bit_shift);res-=res.xxyz*bit_mask;return res;}\n#ifdef INDICATOR_CUTOUT\nuniform vec2 u_indicator_cutout_centers;uniform vec4 u_indicator_cutout_params;\n#endif\nvec4 applyCutout(vec4 color) {\n#ifdef INDICATOR_CUTOUT\nfloat holeMinOpacity=u_indicator_cutout_params.x;float holeRadius=max(u_indicator_cutout_params.y,0.0);float holeAspectRatio=u_indicator_cutout_params.z;float fadeStart=u_indicator_cutout_params.w;float distA=distance(vec2(gl_FragCoord.x,gl_FragCoord.y*holeAspectRatio),vec2(u_indicator_cutout_centers[0],u_indicator_cutout_centers[1]*holeAspectRatio));return color*min(smoothstep(fadeStart,holeRadius,distA)+holeMinOpacity,1.0);\n#else\nreturn color;\n#endif\n}\n#ifdef DEBUG_WIREFRAME\n#define HANDLE_WIREFRAME_DEBUG \\\nglFragColor=vec4(0.7,0.0,0.0,0.7); \\\ngl_FragDepth=gl_FragCoord.z-0.0001;\n#else\n#define HANDLE_WIREFRAME_DEBUG\n#endif\n#ifdef RENDER_CUTOFF\nuniform highp vec4 u_cutoff_params;in float v_cutoff_opacity;\n#endif\nvec4 textureLodCustom(sampler2D image,vec2 pos,vec2 lod_coord) {vec2 size=vec2(textureSize(image,0));vec2 dx=dFdx(lod_coord.xy*size);vec2 dy=dFdy(lod_coord.xy*size);float delta_max_sqr=max(dot(dx,dx),dot(dy,dy));float lod=0.5*log2(delta_max_sqr);return textureLod(image,pos,lod);}",Fo="\n#define EXTENT 8192.0\n#define RAD_TO_DEG 180.0/PI\n#define DEG_TO_RAD PI/180.0\n#define GLOBE_RADIUS EXTENT/PI/2.0\nfloat wrap(float n,float min,float max) {float d=max-min;float w=mod(mod(n-min,d)+d,d)+min;return (w==min) ? max : w;}\n#ifdef PROJECTION_GLOBE_VIEW\nvec3 mercator_tile_position(mat4 matrix,vec2 tile_anchor,vec3 tile_id,vec2 mercator_center) {\n#ifndef PROJECTED_POS_ON_VIEWPORT\nfloat tiles=tile_id.z;vec2 mercator=(tile_anchor/EXTENT+tile_id.xy)/tiles;mercator-=mercator_center;mercator.x=wrap(mercator.x,-0.5,0.5);vec4 mercator_tile=vec4(mercator.xy*EXTENT,EXTENT/(2.0*PI),1.0);mercator_tile=matrix*mercator_tile;return mercator_tile.xyz;\n#else\nreturn vec3(0.0);\n#endif\n}vec3 mix_globe_mercator(vec3 globe,vec3 mercator,float t) {return mix(globe,mercator,t);}mat3 globe_mercator_surface_vectors(vec3 pos_normal,vec3 up_dir,float zoom_transition) {vec3 normal=zoom_transition==0.0 ? pos_normal : normalize(mix(pos_normal,up_dir,zoom_transition));vec3 xAxis=normalize(vec3(normal.z,0.0,-normal.x));vec3 yAxis=normalize(cross(normal,xAxis));return mat3(xAxis,yAxis,normal);}\n#endif\nvec2 unpack_float(const float packedValue) {int packedIntValue=int(packedValue);int v0=packedIntValue/256;return vec2(v0,packedIntValue-v0*256);}vec2 unpack_opacity(const float packedOpacity) {int intOpacity=int(packedOpacity)/2;return vec2(float(intOpacity)/127.0,mod(packedOpacity,2.0));}vec4 decode_color(const vec2 encodedColor) {return vec4(\nunpack_float(encodedColor[0])/255.0,unpack_float(encodedColor[1])/255.0\n);}float unpack_mix_vec2(const vec2 packedValue,const float t) {return mix(packedValue[0],packedValue[1],t);}vec4 unpack_mix_color(const vec4 packedColors,const float t) {vec4 minColor=decode_color(vec2(packedColors[0],packedColors[1]));vec4 maxColor=decode_color(vec2(packedColors[2],packedColors[3]));return mix(minColor,maxColor,t);}vec2 get_pattern_pos(const vec2 pixel_coord_upper,const vec2 pixel_coord_lower,const vec2 pattern_size,const float tile_units_to_pixels,const vec2 pos) {vec2 offset=mod(mod(mod(pixel_coord_upper,pattern_size)*256.0,pattern_size)*256.0+pixel_coord_lower,pattern_size);return (tile_units_to_pixels*pos+offset)/pattern_size;}float mercatorXfromLng(float lng) {return (180.0+lng)/360.0;}float mercatorYfromLat(float lat) {return (180.0-(RAD_TO_DEG*log(tan(PI/4.0+lat/2.0*DEG_TO_RAD))))/360.0;}vec3 latLngToECEF(vec2 latLng) {latLng=DEG_TO_RAD*latLng;float cosLat=cos(latLng[0]);float sinLat=sin(latLng[0]);float cosLng=cos(latLng[1]);float sinLng=sin(latLng[1]);float sx=cosLat*sinLng*GLOBE_RADIUS;float sy=-sinLat*GLOBE_RADIUS;float sz=cosLat*cosLng*GLOBE_RADIUS;return vec3(sx,sy,sz);}\n#ifdef RENDER_CUTOFF\nuniform vec4 u_cutoff_params;out float v_cutoff_opacity;\n#endif\nconst vec4 AWAY=vec4(-1000.0,-1000.0,-1000.0,1);const float skirtOffset=24575.0;vec3 decomposeToPosAndSkirt(vec2 posWithComposedSkirt)\n{float skirt=float(posWithComposedSkirt.x >=skirtOffset);vec2 pos=posWithComposedSkirt-vec2(skirt*skirtOffset,0.0);return vec3(pos,skirt);}",Bo="in highp vec3 a_pos_3f;uniform lowp mat4 u_matrix;out highp vec3 v_uv;void main() {const mat3 half_neg_pi_around_x=mat3(1.0,0.0, 0.0,0.0,0.0,-1.0,0.0,1.0, 0.0);v_uv=half_neg_pi_around_x*a_pos_3f;vec4 pos=u_matrix*vec4(a_pos_3f,1.0);gl_Position=pos.xyww;}",ko="\n#define ELEVATION_SCALE 7.0\n#define ELEVATION_OFFSET 450.0\n#ifdef PROJECTION_GLOBE_VIEW\nuniform vec3 u_tile_tl_up;uniform vec3 u_tile_tr_up;uniform vec3 u_tile_br_up;uniform vec3 u_tile_bl_up;uniform float u_tile_up_scale;vec3 elevationVector(vec2 pos) {vec2 uv=pos/EXTENT;vec3 up=normalize(mix(\nmix(u_tile_tl_up,u_tile_tr_up,uv.xxx),mix(u_tile_bl_up,u_tile_br_up,uv.xxx),uv.yyy));return up*u_tile_up_scale;}\n#else\nvec3 elevationVector(vec2 pos) { return vec3(0,0,1); }\n#endif\n#ifdef TERRAIN\nuniform highp sampler2D u_dem;uniform highp sampler2D u_dem_prev;uniform vec2 u_dem_tl;uniform vec2 u_dem_tl_prev;uniform float u_dem_scale;uniform float u_dem_scale_prev;uniform float u_dem_size;uniform float u_dem_lerp;uniform float u_exaggeration;uniform float u_meter_to_dem;uniform mat4 u_label_plane_matrix_inv;uniform sampler2D u_depth;uniform vec2 u_depth_size_inv;vec4 tileUvToDemSample(vec2 uv,float dem_size,float dem_scale,vec2 dem_tl) {vec2 pos=dem_size*(uv*dem_scale+dem_tl)+1.0;vec2 f=fract(pos);return vec4((pos-f+0.5)/(dem_size+2.0),f);}float currentElevation(vec2 apos) {\n#ifdef TERRAIN_DEM_FLOAT_FORMAT\nvec2 pos=(u_dem_size*(apos/8192.0*u_dem_scale+u_dem_tl)+1.5)/(u_dem_size+2.0);return u_exaggeration*texture(u_dem,pos).r;\n#else\nfloat dd=1.0/(u_dem_size+2.0);vec4 r=tileUvToDemSample(apos/8192.0,u_dem_size,u_dem_scale,u_dem_tl);vec2 pos=r.xy;vec2 f=r.zw;float tl=texture(u_dem,pos).r;float tr=texture(u_dem,pos+vec2(dd,0)).r;float bl=texture(u_dem,pos+vec2(0,dd)).r;float br=texture(u_dem,pos+vec2(dd,dd)).r;return u_exaggeration*mix(mix(tl,tr,f.x),mix(bl,br,f.x),f.y);\n#endif\n}float prevElevation(vec2 apos) {\n#ifdef TERRAIN_DEM_FLOAT_FORMAT\nvec2 pos=(u_dem_size*(apos/8192.0*u_dem_scale_prev+u_dem_tl_prev)+1.5)/(u_dem_size+2.0);return u_exaggeration*texture(u_dem_prev,pos).r;\n#else\nfloat dd=1.0/(u_dem_size+2.0);vec4 r=tileUvToDemSample(apos/8192.0,u_dem_size,u_dem_scale_prev,u_dem_tl_prev);vec2 pos=r.xy;vec2 f=r.zw;float tl=texture(u_dem_prev,pos).r;float tr=texture(u_dem_prev,pos+vec2(dd,0)).r;float bl=texture(u_dem_prev,pos+vec2(0,dd)).r;float br=texture(u_dem_prev,pos+vec2(dd,dd)).r;return u_exaggeration*mix(mix(tl,tr,f.x),mix(bl,br,f.x),f.y);\n#endif\n}\n#ifdef TERRAIN_VERTEX_MORPHING\nfloat elevation(vec2 apos) {\n#ifdef ZERO_EXAGGERATION\nreturn 0.0;\n#endif\nfloat nextElevation=currentElevation(apos);float prevElevation=prevElevation(apos);return mix(prevElevation,nextElevation,u_dem_lerp);}\n#else\nfloat elevation(vec2 apos) {\n#ifdef ZERO_EXAGGERATION\nreturn 0.0;\n#endif\nreturn currentElevation(apos);}\n#endif\nhighp float unpack_depth(highp vec4 rgba_depth)\n{const highp vec4 bit_shift=vec4(1.0/(255.0*255.0*255.0),1.0/(255.0*255.0),1.0/255.0,1.0);return dot(rgba_depth,bit_shift)*2.0-1.0;}bool isOccluded(vec4 frag) {vec3 coord=frag.xyz/frag.w;float depth=unpack_depth(texture(u_depth,(coord.xy+1.0)*0.5));return coord.z > depth+0.0005;}float occlusionFade(vec4 frag) {vec3 coord=frag.xyz/frag.w;vec3 df=vec3(5.0*u_depth_size_inv,0.0);vec2 uv=0.5*coord.xy+0.5;vec4 depth=vec4(\nunpack_depth(texture(u_depth,uv-df.xz)),unpack_depth(texture(u_depth,uv+df.xz)),unpack_depth(texture(u_depth,uv-df.zy)),unpack_depth(texture(u_depth,uv+df.zy))\n);return dot(vec4(0.25),vec4(1.0)-clamp(300.0*(vec4(coord.z-0.001)-depth),0.0,1.0));}vec4 fourSample(vec2 pos,vec2 off) {float tl=texture(u_dem,pos).r;float tr=texture(u_dem,pos+vec2(off.x,0.0)).r;float bl=texture(u_dem,pos+vec2(0.0,off.y)).r;float br=texture(u_dem,pos+off).r;return vec4(tl,tr,bl,br);}float flatElevation(vec2 pack) {vec2 apos=floor(pack/8.0);vec2 span=10.0*(pack-apos*8.0);vec2 uvTex=(apos-vec2(1.0,1.0))/8190.0;float size=u_dem_size+2.0;float dd=1.0/size;vec2 pos=u_dem_size*(uvTex*u_dem_scale+u_dem_tl)+1.0;vec2 f=fract(pos);pos=(pos-f+0.5)*dd;vec4 h=fourSample(pos,vec2(dd));float z=mix(mix(h.x,h.y,f.x),mix(h.z,h.w,f.x),f.y);vec2 w=floor(0.5*(span*u_meter_to_dem-1.0));vec2 d=dd*w;h=fourSample(pos-d,2.0*d+vec2(dd));vec4 diff=abs(h.xzxy-h.ywzw);vec2 slope=min(vec2(0.25),u_meter_to_dem*0.5*(diff.xz+diff.yw)/(2.0*w+vec2(1.0)));vec2 fix=slope*span;float base=z+max(fix.x,fix.y);return u_exaggeration*base;}float elevationFromUint16(float word) {return u_exaggeration*(word/ELEVATION_SCALE-ELEVATION_OFFSET);}\n#else\nfloat elevation(vec2 pos) { return 0.0; }bool isOccluded(vec4 frag) { return false; }float occlusionFade(vec4 frag) { return 1.0; }\n#endif",No="#ifdef FOG\nuniform mediump vec4 u_fog_color;uniform mediump vec2 u_fog_range;uniform mediump float u_fog_horizon_blend;uniform mediump mat4 u_fog_matrix;out vec3 v_fog_pos;float fog_range(float depth) {return (depth-u_fog_range[0])/(u_fog_range[1]-u_fog_range[0]);}float fog_horizon_blending(vec3 camera_dir) {float t=max(0.0,camera_dir.z/u_fog_horizon_blend);return u_fog_color.a*exp(-3.0*t*t);}float fog_opacity(float t) {const float decay=6.0;float falloff=1.0-min(1.0,exp(-decay*t));falloff*=falloff*falloff;return u_fog_color.a*min(1.0,1.00747*falloff);}vec3 fog_position(vec3 pos) {return (u_fog_matrix*vec4(pos,1.0)).xyz;}vec3 fog_position(vec2 pos) {return fog_position(vec3(pos,0.0));}float fog(vec3 pos) {float depth=length(pos);float opacity=fog_opacity(fog_range(depth));return opacity*fog_horizon_blending(pos/depth);}\n#endif",Uo="highp vec3 hash(highp vec2 p) {highp vec3 p3=fract(p.xyx*vec3(443.8975,397.2973,491.1871));p3+=dot(p3,p3.yxz+19.19);return fract((p3.xxy+p3.yzz)*p3.zyx);}vec3 dither(vec3 color,highp vec2 seed) {vec3 rnd=hash(seed)+hash(seed+0.59374)-0.5;return color+rnd/255.0;}\n#ifdef FOG\nuniform mediump vec4 u_fog_color;uniform mediump vec2 u_fog_range;uniform mediump float u_fog_horizon_blend;uniform mediump vec2 u_fog_vertical_limit;uniform mediump float u_fog_temporal_offset;in vec3 v_fog_pos;uniform highp vec3 u_frustum_tl;uniform highp vec3 u_frustum_tr;uniform highp vec3 u_frustum_br;uniform highp vec3 u_frustum_bl;uniform highp vec3 u_globe_pos;uniform highp float u_globe_radius;uniform highp vec2 u_viewport;uniform float u_globe_transition;uniform int u_is_globe;float fog_range(float depth) {return (depth-u_fog_range[0])/(u_fog_range[1]-u_fog_range[0]);}float fog_horizon_blending(vec3 camera_dir) {float t=max(0.0,camera_dir.z/u_fog_horizon_blend);return u_fog_color.a*exp(-3.0*t*t);}float fog_opacity(float t) {const float decay=6.0;float falloff=1.0-min(1.0,exp(-decay*t));falloff*=falloff*falloff;return u_fog_color.a*min(1.0,1.00747*falloff);}float globe_glow_progress() {highp vec2 uv=gl_FragCoord.xy/u_viewport;highp vec3 ray_dir=mix(\nmix(u_frustum_tl,u_frustum_tr,uv.x),mix(u_frustum_bl,u_frustum_br,uv.x),1.0-uv.y);highp vec3 dir=normalize(ray_dir);highp vec3 closest_point=dot(u_globe_pos,dir)*dir;highp float sdf=length(closest_point-u_globe_pos)/u_globe_radius;return sdf+PI*0.5;}float fog_opacity(vec3 pos) {float depth=length(pos);return fog_opacity(fog_range(depth));}vec3 fog_apply(vec3 color,vec3 pos,float opacity_limit) {float depth=length(pos);float opacity;if (u_is_globe==1) {float glow_progress=globe_glow_progress();float t=mix(glow_progress,depth,u_globe_transition);opacity=fog_opacity(fog_range(t));} else {opacity=fog_opacity(fog_range(depth));opacity*=fog_horizon_blending(pos/depth);}return mix(color,u_fog_color.rgb,min(opacity,opacity_limit));}vec3 fog_apply(vec3 color,vec3 pos) {return fog_apply(color,pos,1.0);}vec4 fog_apply_from_vert(vec4 color,float fog_opac) {float alpha=EPSILON+color.a;color.rgb=mix(color.rgb/alpha,u_fog_color.rgb,fog_opac)*alpha;return color;}vec3 fog_apply_sky_gradient(vec3 camera_ray,vec3 sky_color) {float horizon_blend=fog_horizon_blending(normalize(camera_ray));return mix(sky_color,u_fog_color.rgb,horizon_blend);}vec4 fog_apply_premultiplied(vec4 color,vec3 pos) {float alpha=EPSILON+color.a;color.rgb=fog_apply(color.rgb/alpha,pos)*alpha;return color;}vec4 fog_apply_premultiplied(vec4 color,vec3 pos,float heightMeters) {float verticalProgress=(u_fog_vertical_limit.x > 0.0 || u_fog_vertical_limit.y > 0.0) ? smoothstep(u_fog_vertical_limit.x,u_fog_vertical_limit.y,heightMeters) : 0.0;float opacityLimit=1.0-smoothstep(0.9,1.0,fog_opacity(pos));return mix(fog_apply_premultiplied(color,pos),color,min(verticalProgress,opacityLimit));}vec3 fog_dither(vec3 color) {\n#ifdef FOG_DITHERING\nvec2 dither_seed=gl_FragCoord.xy+u_fog_temporal_offset;return dither(color,dither_seed);\n#else\nreturn color;\n#endif\n}vec4 fog_dither(vec4 color) {return vec4(fog_dither(color.rgb),color.a);}\n#endif",Go="#ifdef RASTER_ARRAY\nuniform sampler2D u_image0;uniform sampler2D u_image1;const vec4 NODATA=vec4(1);ivec4 _raTexLinearCoord(highp vec2 texCoord,highp vec2 texResolution,out highp vec2 fxy) {texCoord=texCoord*texResolution-0.5;fxy=fract(texCoord);texCoord-=fxy;return ivec4(texCoord.xxyy+vec2(1.5,0.5).xyxy);}vec2 _raTexLinearMix(highp vec2 fxy,highp vec4 colorMix,highp float colorOffset,highp vec4 t00,highp vec4 t10,highp vec4 t01,highp vec4 t11) {vec2 c00=t00==NODATA ? vec2(0) : vec2(colorOffset+dot(t00,colorMix),1);vec2 c10=t10==NODATA ? vec2(0) : vec2(colorOffset+dot(t10,colorMix),1);vec2 c01=t01==NODATA ? vec2(0) : vec2(colorOffset+dot(t01,colorMix),1);vec2 c11=t11==NODATA ? vec2(0) : vec2(colorOffset+dot(t11,colorMix),1);return mix(mix(c01,c11,fxy.x),mix(c00,c10,fxy.x),fxy.y);}vec2 raTexture2D_image0_linear(highp vec2 texCoord,highp vec2 texResolution,highp vec4 colorMix,highp float colorOffset) {vec2 fxy;ivec4 c=_raTexLinearCoord(texCoord,texResolution,fxy);return _raTexLinearMix(fxy,colorMix,colorOffset,texelFetch(u_image0,c.yz,0),texelFetch(u_image0,c.xz,0),texelFetch(u_image0,c.yw,0),texelFetch(u_image0,c.xw,0)\n);}vec2 raTexture2D_image1_linear(highp vec2 texCoord,highp vec2 texResolution,highp vec4 colorMix,highp float colorOffset) {vec2 fxy;ivec4 c=_raTexLinearCoord(texCoord,texResolution,fxy);return _raTexLinearMix(fxy,colorMix,colorOffset,texelFetch(u_image1,c.yz,0),texelFetch(u_image1,c.xz,0),texelFetch(u_image1,c.yw,0),texelFetch(u_image1,c.xw,0)\n);}vec2 raTexture2D_image0_nearest(highp vec2 texCoord,highp vec2 texResolution,highp vec4 colorMix,highp float colorOffset) {vec4 t=texelFetch(u_image0,ivec2(texCoord*texResolution),0);return t==NODATA ? vec2(0) : vec2(colorOffset+dot(t,colorMix),1);}vec2 raTexture2D_image1_nearest(highp vec2 texCoord,highp vec2 texResolution,highp vec4 colorMix,highp float colorOffset) {vec4 t=texelFetch(u_image1,ivec2(texCoord*texResolution),0);return t==NODATA ? vec2(0) : vec2(colorOffset+dot(t,colorMix),1);}\n#endif",jo="#ifdef RASTER_ARRAY\nuniform sampler2D u_velocity;uniform vec2 u_velocity_res;uniform float u_max_speed;const vec2 INVALID_VELOCITY=vec2(-1);uniform vec2 u_texture_offset;uniform float u_data_offset;uniform vec4 u_data_scale;vec2 lookup_velocity(vec2 uv) {uv=u_texture_offset.x+u_texture_offset.y*uv;vec2 fxy;ivec4 c=_raTexLinearCoord(uv,u_velocity_res,fxy);vec4 tl=texelFetch(u_velocity,c.yz,0);vec4 tr=texelFetch(u_velocity,c.xz,0);vec4 bl=texelFetch(u_velocity,c.yw,0);vec4 br=texelFetch(u_velocity,c.xw,0);if (tl==NODATA) {return INVALID_VELOCITY;}if (tr==NODATA) {return INVALID_VELOCITY;}if (bl==NODATA) {return INVALID_VELOCITY;}if (br==NODATA) {return INVALID_VELOCITY;}vec4 t=mix(mix(bl,br,fxy.x),mix(tl,tr,fxy.x),fxy.y);\n#ifdef DATA_FORMAT_UINT32\nvec2 velocity=vec2(u_data_offset+dot(t,u_data_scale),0);return velocity;\n#else\nvec2 velocity=vec2(u_data_offset+dot(t.rg,u_data_scale.yx),-(u_data_offset+dot(t.ba,u_data_scale.yx)));\n#endif\nreturn velocity/max(u_max_speed,length(velocity));}\n#endif",Vo="#ifdef RENDER_SHADOWS\nuniform mediump vec3 u_shadow_direction;uniform highp vec3 u_shadow_normal_offset;vec3 shadow_normal_offset(vec3 normal) {float tileInMeters=u_shadow_normal_offset[0];vec3 n=vec3(-normal.xy,tileInMeters*normal.z);float dotScale=min(1.0-dot(normal,u_shadow_direction),1.0)*0.5+0.5;return n*dotScale;}vec3 shadow_normal_offset_model(vec3 normal) {float dotScale=min(1.0-dot(normal,u_shadow_direction),1.0)*0.5+0.5;return normal*dotScale;}float shadow_normal_offset_multiplier0() {return u_shadow_normal_offset[1];}float shadow_normal_offset_multiplier1() {return u_shadow_normal_offset[2];}\n#endif//RENDER_SHADOWS",Zo="#ifdef RENDER_SHADOWS\n#ifdef DEPTH_TEXTURE\nuniform highp sampler2D u_shadowmap_0;uniform highp sampler2D u_shadowmap_1;\n#else\nuniform sampler2D u_shadowmap_0;uniform sampler2D u_shadowmap_1;\n#endif\nuniform float u_shadow_intensity;uniform float u_shadow_map_resolution;uniform float u_shadow_texel_size;uniform highp vec3 u_shadow_normal_offset;uniform vec2 u_fade_range;uniform mediump vec3 u_shadow_direction;uniform highp vec3 u_shadow_bias;highp float shadow_sample_1(highp vec2 uv,highp float compare) {highp float shadow_depth;\n#ifdef DEPTH_TEXTURE\nshadow_depth=texture(u_shadowmap_1,uv).r;\n#else\nshadow_depth=unpack_depth(texture(u_shadowmap_1,uv))*0.5+0.5;\n#endif\nreturn step(shadow_depth,compare);}highp float shadow_sample_0(highp vec2 uv,highp float compare) {highp float shadow_depth;\n#ifdef DEPTH_TEXTURE\nshadow_depth=texture(u_shadowmap_0,uv).r;\n#else\nshadow_depth=unpack_depth(texture(u_shadowmap_0,uv))*0.5+0.5;\n#endif\nreturn step(shadow_depth,compare);}float shadow_occlusion_1(highp vec4 pos,highp float bias) {highp vec2 uv=pos.xy;return shadow_sample_1(uv,pos.z-bias);}float shadow_occlusion_0(highp vec4 pos,highp float bias) {highp float compare0=pos.z-bias;\n#ifdef NATIVE\nhighp vec2 uv=pos.xy;highp vec4 samples=textureGather(u_shadowmap_0,uv,0);lowp vec4 stepSamples=step(samples,vec4(compare0));\n#else\nhighp vec2 uv00=pos.xy-vec2(0.5*u_shadow_texel_size);highp vec2 uv10=uv00+vec2(u_shadow_texel_size,0.0);highp vec2 uv01=uv00+vec2(0.0,u_shadow_texel_size);highp vec2 uv11=uv01+vec2(u_shadow_texel_size,0.0);lowp vec4 stepSamples=vec4(\nshadow_sample_0(uv01,compare0),shadow_sample_0(uv11,compare0),shadow_sample_0(uv10,compare0),shadow_sample_0(uv00,compare0)\n);\n#endif\nvec2 f=fract(pos.xy*u_shadow_map_resolution-vec2(0.5));lowp vec2 lerpx=mix(stepSamples.wx,stepSamples.zy,f.xx);return mix(lerpx.x,lerpx.y,f.y);}float shadow_occlusion(highp vec4 light_view_pos0,highp vec4 light_view_pos1,float view_depth,highp float bias) {\n#ifdef SHADOWS_SINGLE_CASCADE\nlight_view_pos0.xyz=light_view_pos0.xyz/light_view_pos0.w*0.5+0.5;return shadow_occlusion_0(light_view_pos0,bias);\n#else\nlight_view_pos0.xyz/=light_view_pos0.w;light_view_pos1.xyz/=light_view_pos1.w;vec4 uv=vec4(light_view_pos0.xy,light_view_pos1.xy);vec4 abs_bounds=abs(uv);if (abs_bounds.x < 1.0 && abs_bounds.y < 1.0) {light_view_pos0.xyz=light_view_pos0.xyz*0.5+0.5;return shadow_occlusion_0(light_view_pos0,bias);}if (abs_bounds.z >=1.0 || abs_bounds.w >=1.0) {return 0.0;}light_view_pos1.xyz=light_view_pos1.xyz*0.5+0.5;float occlusion1=shadow_occlusion_1(light_view_pos1,bias);return mix(occlusion1,0.0,smoothstep(u_fade_range.x,u_fade_range.y,view_depth));\n#endif\n}highp float calculate_shadow_bias(float NDotL) {\n#ifdef NORMAL_OFFSET\nreturn 0.5*u_shadow_bias.x;\n#else\nreturn 0.5*(u_shadow_bias.x+clamp(u_shadow_bias.y*tan(acos(NDotL)),0.0,u_shadow_bias.z));\n#endif\n}float shadowed_light_factor_normal(vec3 N,highp vec4 light_view_pos0,highp vec4 light_view_pos1,float view_depth) {float NDotL=dot(N,u_shadow_direction);float bias=calculate_shadow_bias(NDotL);float occlusion=shadow_occlusion(light_view_pos0,light_view_pos1,view_depth,bias);return mix(0.0,(1.0-(u_shadow_intensity*occlusion))*NDotL,step(0.0,NDotL));}float shadowed_light_factor_normal_unbiased(vec3 N,highp vec4 light_view_pos0,highp vec4 light_view_pos1,float view_depth) {float NDotL=dot(N,u_shadow_direction);float bias=0.0;float occlusion=shadow_occlusion(light_view_pos0,light_view_pos1,view_depth,bias);return mix(0.0,(1.0-(u_shadow_intensity*occlusion))*NDotL,step(0.0,NDotL));}float shadowed_light_factor(highp vec4 light_view_pos0,highp vec4 light_view_pos1,float view_depth) {float bias=0.0;float occlusion=shadow_occlusion(light_view_pos0,light_view_pos1,view_depth,bias);return 1.0-(u_shadow_intensity*occlusion);}float shadow_occlusion(float ndotl,highp vec4 light_view_pos0,highp vec4 light_view_pos1,float view_depth) {float bias=calculate_shadow_bias(ndotl);return shadow_occlusion(light_view_pos0,light_view_pos1,view_depth,bias);}\n#endif";const Ho=[];Yo(zo,Ho),Yo(Fo,Ho),Yo(Oo,Ho);const Wo={"_prelude_fog.vertex.glsl":No,"_prelude_terrain.vertex.glsl":ko,"_prelude_shadow.vertex.glsl":Vo,"_prelude_fog.fragment.glsl":Uo,"_prelude_shadow.fragment.glsl":Zo,"_prelude_lighting.glsl":"\n#ifdef LIGHTING_3D_MODE\nuniform mediump vec3 u_lighting_ambient_color;uniform mediump vec3 u_lighting_directional_dir;uniform mediump vec3 u_lighting_directional_color;uniform mediump vec3 u_ground_radiance;float calculate_ambient_directional_factor(vec3 normal) {float NdotL=dot(normal,u_lighting_directional_dir);const float factor_reduction_max=0.3;float dir_luminance=dot(u_lighting_directional_color,vec3(0.2126,0.7152,0.0722));float directional_factor_min=1.0-factor_reduction_max*min(dir_luminance,1.0);float ambient_directional_factor=mix(directional_factor_min,1.0,min((NdotL+1.0),1.0));const float vertical_factor_min=0.92;float vertical_factor=mix(vertical_factor_min,1.0,normal.z*0.5+0.5);return vertical_factor*ambient_directional_factor;}vec3 linearProduct(vec3 srgbIn,vec3 k) {return srgbIn*pow(k,vec3(1./2.2));}vec3 apply_lighting(vec3 color,vec3 normal,float dir_factor) {float ambient_directional_factor=calculate_ambient_directional_factor(normal);vec3 ambient_contrib=ambient_directional_factor*u_lighting_ambient_color;vec3 directional_contrib=u_lighting_directional_color*dir_factor;return linearProduct(color,ambient_contrib+directional_contrib);}vec4 apply_lighting(vec4 color,vec3 normal,float dir_factor) {return vec4(apply_lighting(color.rgb,normal,dir_factor),color.a);}vec3 apply_lighting(vec3 color,vec3 normal) {float dir_factor=max(dot(normal,u_lighting_directional_dir),0.0);return apply_lighting(color.rgb,normal,dir_factor);}vec4 apply_lighting(vec4 color,vec3 normal) {float dir_factor=max(dot(normal,u_lighting_directional_dir),0.0);return vec4(apply_lighting(color.rgb,normal,dir_factor),color.a);}vec3 apply_lighting_ground(vec3 color) {return color*u_ground_radiance;}vec4 apply_lighting_ground(vec4 color) {return vec4(apply_lighting_ground(color.rgb),color.a);}float calculate_NdotL(vec3 normal) {const float ext=0.70710678118;return (clamp(dot(normal,u_lighting_directional_dir),-ext,1.0)+ext)/(1.0+ext);}vec4 apply_lighting_with_emission_ground(vec4 color,float emissive_strength) {return mix(apply_lighting_ground(color),color,emissive_strength);}vec3 compute_flood_lighting(vec3 flood_light_color,float fully_occluded_factor,float occlusion,vec3 ground_shadow_factor) {vec3 fully_occluded_color=flood_light_color*mix(ground_shadow_factor,vec3(1.0),fully_occluded_factor);float occlusion_ramp=smoothstep(0.0,0.2,1.0-occlusion);return mix(fully_occluded_color,flood_light_color,occlusion_ramp);}vec3 compute_emissive_draped(vec3 unlit_color,float fully_occluded_factor,float occlusion,vec3 ground_shadow_factor) {vec3 fully_occluded_color=unlit_color*mix(ground_shadow_factor,vec3(1.0),fully_occluded_factor);return mix(fully_occluded_color,unlit_color,1.0-occlusion);}\n#endif//LIGHTING_3D_MODE","_prelude_raster_array.glsl":Go,"_prelude_raster_particle.glsl":jo},qo={};Jo("",ko),Jo(Uo,No),Jo(Zo,Vo),Jo(Go,""),Jo(jo,"");const $o=Jo(Oo,Fo),Xo=zo;var Ko={background:Jo('#include "_prelude_fog.fragment.glsl"\n#include "_prelude_lighting.glsl"\nuniform vec4 u_color;uniform float u_opacity;\n#ifdef LIGHTING_3D_MODE\nin vec4 v_color;\n#endif\nvoid main() {vec4 out_color;\n#ifdef LIGHTING_3D_MODE\nout_color=v_color;\n#else\nout_color=u_color;\n#endif\n#ifdef FOG\nout_color=fog_dither(fog_apply_premultiplied(out_color,v_fog_pos));\n#endif\nglFragColor=out_color*u_opacity;\n#ifdef OVERDRAW_INSPECTOR\nglFragColor=vec4(1.0);\n#endif\nHANDLE_WIREFRAME_DEBUG;}','#include "_prelude_fog.vertex.glsl"\n#include "_prelude_lighting.glsl"\nin vec2 a_pos;uniform mat4 u_matrix;\n#ifdef LIGHTING_3D_MODE\nuniform mediump vec4 u_color;out vec4 v_color;uniform float u_emissive_strength;\n#endif\nvoid main() {gl_Position=u_matrix*vec4(a_pos,0,1);\n#ifdef LIGHTING_3D_MODE\nv_color=apply_lighting_with_emission_ground(u_color,u_emissive_strength);\n#endif\n#ifdef FOG\nv_fog_pos=fog_position(a_pos);\n#endif\n}'),backgroundPattern:Jo('#include "_prelude_fog.fragment.glsl"\n#include "_prelude_lighting.glsl"\nuniform vec2 u_pattern_tl;uniform vec2 u_pattern_br;uniform vec2 u_texsize;uniform float u_opacity;uniform float u_emissive_strength;uniform sampler2D u_image;in vec2 v_pos;void main() {vec2 imagecoord=mod(v_pos,1.0);vec2 pos=mix(u_pattern_tl/u_texsize,u_pattern_br/u_texsize,imagecoord);vec4 out_color=textureLodCustom(u_image,pos,v_pos);\n#ifdef LIGHTING_3D_MODE\nout_color=apply_lighting_with_emission_ground(out_color,u_emissive_strength);\n#endif\n#ifdef FOG\nout_color=fog_dither(fog_apply_premultiplied(out_color,v_fog_pos));\n#endif\nglFragColor=out_color*u_opacity;\n#ifdef OVERDRAW_INSPECTOR\nglFragColor=vec4(1.0);\n#endif\nHANDLE_WIREFRAME_DEBUG;}','#include "_prelude_fog.vertex.glsl"\nuniform mat4 u_matrix;uniform vec2 u_pattern_size;uniform vec2 u_pixel_coord_upper;uniform vec2 u_pixel_coord_lower;uniform float u_tile_units_to_pixels;in vec2 a_pos;out vec2 v_pos;void main() {gl_Position=u_matrix*vec4(a_pos,0,1);v_pos=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,u_pattern_size,u_tile_units_to_pixels,a_pos);\n#ifdef FOG\nv_fog_pos=fog_position(a_pos);\n#endif\n}'),circle:Jo('#include "_prelude_fog.fragment.glsl"\n#include "_prelude_lighting.glsl"\nin vec3 v_data;in float v_visibility;\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define mediump float radius\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define highp vec4 stroke_color\n#pragma mapbox: define mediump float stroke_width\n#pragma mapbox: define lowp float stroke_opacity\nuniform float u_emissive_strength;void main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize mediump float radius\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize highp vec4 stroke_color\n#pragma mapbox: initialize mediump float stroke_width\n#pragma mapbox: initialize lowp float stroke_opacity\nvec2 extrude=v_data.xy;float extrude_length=length(extrude);lowp float antialiasblur=v_data.z;float antialiased_blur=-max(blur,antialiasblur);float opacity_t=smoothstep(0.0,antialiased_blur,extrude_length-1.0);float color_t=stroke_width < 0.01 ? 0.0 : smoothstep(\nantialiased_blur,0.0,extrude_length-radius/(radius+stroke_width)\n);vec4 out_color=mix(color*opacity,stroke_color*stroke_opacity,color_t);\n#ifdef LIGHTING_3D_MODE\nout_color=apply_lighting_with_emission_ground(out_color,u_emissive_strength);\n#endif\n#ifdef FOG\nout_color=fog_apply_premultiplied(out_color,v_fog_pos);\n#endif\nglFragColor=out_color*(v_visibility*opacity_t);\n#ifdef OVERDRAW_INSPECTOR\nglFragColor=vec4(1.0);\n#endif\n}','#include "_prelude_fog.vertex.glsl"\n#include "_prelude_terrain.vertex.glsl"\n#define NUM_VISIBILITY_RINGS 2\n#define INV_SQRT2 0.70710678\n#define ELEVATION_BIAS 0.0001\n#define NUM_SAMPLES_PER_RING 16\nuniform mat4 u_matrix;uniform mat2 u_extrude_scale;uniform lowp float u_device_pixel_ratio;uniform highp float u_camera_to_center_distance;in vec2 a_pos;\n#ifdef PROJECTION_GLOBE_VIEW\nin vec3 a_pos_3;in vec3 a_pos_normal_3;uniform mat4 u_inv_rot_matrix;uniform vec2 u_merc_center;uniform vec3 u_tile_id;uniform float u_zoom_transition;uniform vec3 u_up_dir;\n#endif\nout vec3 v_data;out float v_visibility;\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define mediump float radius\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define highp vec4 stroke_color\n#pragma mapbox: define mediump float stroke_width\n#pragma mapbox: define lowp float stroke_opacity\nvec2 calc_offset(vec2 extrusion,float radius,float stroke_width, float view_scale) {return extrusion*(radius+stroke_width)*u_extrude_scale*view_scale;}float cantilevered_elevation(vec2 pos,float radius,float stroke_width,float view_scale) {vec2 c1=pos+calc_offset(vec2(-1,-1),radius,stroke_width,view_scale);vec2 c2=pos+calc_offset(vec2(1,-1),radius,stroke_width,view_scale);vec2 c3=pos+calc_offset(vec2(1,1),radius,stroke_width,view_scale);vec2 c4=pos+calc_offset(vec2(-1,1),radius,stroke_width,view_scale);float h1=elevation(c1)+ELEVATION_BIAS;float h2=elevation(c2)+ELEVATION_BIAS;float h3=elevation(c3)+ELEVATION_BIAS;float h4=elevation(c4)+ELEVATION_BIAS;return max(h4,max(h3,max(h1,h2)));}float circle_elevation(vec2 pos) {\n#if defined(TERRAIN)\nreturn elevation(pos)+ELEVATION_BIAS;\n#else\nreturn 0.0;\n#endif\n}vec4 project_vertex(vec2 extrusion,vec4 world_center,vec4 projected_center,float radius,float stroke_width, float view_scale,mat3 surface_vectors) {vec2 sample_offset=calc_offset(extrusion,radius,stroke_width,view_scale);\n#ifdef PITCH_WITH_MAP\n#ifdef PROJECTION_GLOBE_VIEW\nreturn u_matrix*( world_center+vec4(sample_offset.x*surface_vectors[0]+sample_offset.y*surface_vectors[1],0) );\n#else\nreturn u_matrix*( world_center+vec4(sample_offset,0,0) );\n#endif\n#else\nreturn projected_center+vec4(sample_offset,0,0);\n#endif\n}float get_sample_step() {\n#ifdef PITCH_WITH_MAP\nreturn 2.0*PI/float(NUM_SAMPLES_PER_RING);\n#else\nreturn PI/float(NUM_SAMPLES_PER_RING);\n#endif\n}void main(void) {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize mediump float radius\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize highp vec4 stroke_color\n#pragma mapbox: initialize mediump float stroke_width\n#pragma mapbox: initialize lowp float stroke_opacity\nvec2 extrude=vec2(mod(a_pos,2.0)*2.0-1.0);vec2 circle_center=floor(a_pos*0.5);vec4 world_center;mat3 surface_vectors;\n#ifdef PROJECTION_GLOBE_VIEW\nvec3 pos_normal_3=a_pos_normal_3/16384.0;surface_vectors=globe_mercator_surface_vectors(pos_normal_3,u_up_dir,u_zoom_transition);vec3 surface_extrusion=extrude.x*surface_vectors[0]+extrude.y*surface_vectors[1];vec3 globe_elevation=elevationVector(circle_center)*circle_elevation(circle_center);vec3 globe_pos=a_pos_3+surface_extrusion+globe_elevation;vec3 mercator_elevation=u_up_dir*u_tile_up_scale*circle_elevation(circle_center);vec3 merc_pos=mercator_tile_position(u_inv_rot_matrix,circle_center,u_tile_id,u_merc_center)+surface_extrusion+mercator_elevation;vec3 pos=mix_globe_mercator(globe_pos,merc_pos,u_zoom_transition);world_center=vec4(pos,1);\n#else \nsurface_vectors=mat3(1.0);float height=circle_elevation(circle_center);world_center=vec4(circle_center,height,1);\n#endif\nvec4 projected_center=u_matrix*world_center;float view_scale=0.0;\n#ifdef PITCH_WITH_MAP\n#ifdef SCALE_WITH_MAP\nview_scale=1.0;\n#else\nview_scale=projected_center.w/u_camera_to_center_distance;\n#endif\n#else\n#ifdef SCALE_WITH_MAP\nview_scale=u_camera_to_center_distance;\n#else\nview_scale=projected_center.w;\n#endif\n#endif\ngl_Position=project_vertex(extrude,world_center,projected_center,radius,stroke_width,view_scale,surface_vectors);float visibility=0.0;\n#ifdef TERRAIN\nfloat step=get_sample_step();vec4 occlusion_world_center;vec4 occlusion_projected_center;\n#ifdef PITCH_WITH_MAP\nfloat cantilevered_height=cantilevered_elevation(circle_center,radius,stroke_width,view_scale);occlusion_world_center=vec4(circle_center,cantilevered_height,1);occlusion_projected_center=u_matrix*occlusion_world_center;\n#else\nocclusion_world_center=world_center;occlusion_projected_center=projected_center;\n#endif\nfor(int ring=0; ring < NUM_VISIBILITY_RINGS; ring++) {float scale=(float(ring)+1.0)/float(NUM_VISIBILITY_RINGS);for(int i=0; i < NUM_SAMPLES_PER_RING; i++) {vec2 extrusion=vec2(cos(step*float(i)),-sin(step*float(i)))*scale;vec4 frag_pos=project_vertex(extrusion,occlusion_world_center,occlusion_projected_center,radius,stroke_width,view_scale,surface_vectors);visibility+=float(!isOccluded(frag_pos));}}visibility/=float(NUM_VISIBILITY_RINGS)*float(NUM_SAMPLES_PER_RING);\n#else\nvisibility=1.0;\n#endif\n#ifdef PROJECTION_GLOBE_VIEW\nvisibility=1.0;\n#endif\nv_visibility=visibility;lowp float antialiasblur=1.0/u_device_pixel_ratio/(radius+stroke_width);v_data=vec3(extrude.x,extrude.y,antialiasblur);\n#ifdef FOG\nv_fog_pos=fog_position(world_center.xyz);\n#endif\n}'),clippingMask:Jo("void main() {glFragColor=vec4(1.0);}","in vec2 a_pos;uniform mat4 u_matrix;void main() {gl_Position=u_matrix*vec4(a_pos,0,1);}"),heatmap:Jo('#include "_prelude_fog.fragment.glsl"\nuniform highp float u_intensity;in vec2 v_extrude;\n#pragma mapbox: define highp float weight\n#define GAUSS_COEF 0.3989422804014327\nvoid main() {\n#pragma mapbox: initialize highp float weight\nfloat d=-0.5*3.0*3.0*dot(v_extrude,v_extrude);float val=weight*u_intensity*GAUSS_COEF*exp(d);glFragColor=vec4(val,1.0,1.0,1.0);\n#ifdef FOG\nif (u_is_globe==0) {glFragColor.r*=pow(1.0-fog_opacity(v_fog_pos),2.0);}\n#endif\n#ifdef OVERDRAW_INSPECTOR\nglFragColor=vec4(1.0);\n#endif\nHANDLE_WIREFRAME_DEBUG;}','#include "_prelude_terrain.vertex.glsl"\n#include "_prelude_fog.vertex.glsl"\nuniform mat4 u_matrix;uniform float u_extrude_scale;uniform float u_opacity;uniform float u_intensity;in vec2 a_pos;\n#ifdef PROJECTION_GLOBE_VIEW\nin vec3 a_pos_3;in vec3 a_pos_normal_3;uniform mat4 u_inv_rot_matrix;uniform vec2 u_merc_center;uniform vec3 u_tile_id;uniform float u_zoom_transition;uniform vec3 u_up_dir;\n#endif\nout vec2 v_extrude;\n#pragma mapbox: define highp float weight\n#pragma mapbox: define mediump float radius\nconst highp float ZERO=1.0/255.0/16.0;\n#define GAUSS_COEF 0.3989422804014327\nvoid main(void) {\n#pragma mapbox: initialize highp float weight\n#pragma mapbox: initialize mediump float radius\nvec2 unscaled_extrude=vec2(mod(a_pos,2.0)*2.0-1.0);float S=sqrt(-2.0*log(ZERO/weight/u_intensity/GAUSS_COEF))/3.0;v_extrude=S*unscaled_extrude;vec2 extrude=v_extrude*radius*u_extrude_scale;vec2 tilePos=floor(a_pos*0.5);vec3 pos;\n#ifdef PROJECTION_GLOBE_VIEW\nvec3 pos_normal_3=a_pos_normal_3/16384.0;mat3 surface_vectors=globe_mercator_surface_vectors(pos_normal_3,u_up_dir,u_zoom_transition);vec3 surface_extrusion=extrude.x*surface_vectors[0]+extrude.y*surface_vectors[1];vec3 globe_elevation=elevationVector(tilePos)*elevation(tilePos);vec3 globe_pos=a_pos_3+surface_extrusion+globe_elevation;vec3 mercator_elevation=u_up_dir*u_tile_up_scale*elevation(tilePos);vec3 merc_pos=mercator_tile_position(u_inv_rot_matrix,tilePos,u_tile_id,u_merc_center)+surface_extrusion+mercator_elevation;pos=mix_globe_mercator(globe_pos,merc_pos,u_zoom_transition);\n#else\npos=vec3(tilePos+extrude,elevation(tilePos));\n#endif\ngl_Position=u_matrix*vec4(pos,1);\n#ifdef FOG\nv_fog_pos=fog_position(pos);\n#endif\n}'),heatmapTexture:Jo("uniform sampler2D u_image;uniform sampler2D u_color_ramp;uniform float u_opacity;in vec2 v_pos;void main() {float t=texture(u_image,v_pos).r;vec4 color=texture(u_color_ramp,vec2(t,0.5));glFragColor=color*u_opacity;\n#ifdef OVERDRAW_INSPECTOR\nglFragColor=vec4(0.0);\n#endif\nHANDLE_WIREFRAME_DEBUG;}","in vec2 a_pos;out vec2 v_pos;void main() {gl_Position=vec4(a_pos,0,1);v_pos=a_pos*0.5+0.5;}"),collisionBox:Jo("in float v_placed;in float v_notUsed;void main() {vec4 red =vec4(1.0,0.0,0.0,1.0);vec4 blue=vec4(0.0,0.0,1.0,0.5);glFragColor =mix(red,blue,step(0.5,v_placed))*0.5;glFragColor*=mix(1.0,0.1,step(0.5,v_notUsed));}",'#include "_prelude_terrain.vertex.glsl"\nin vec3 a_pos;in vec2 a_anchor_pos;in vec2 a_extrude;in vec2 a_placed;in vec2 a_shift;in float a_size_scale;in vec2 a_padding;in float a_z_offset;uniform mat4 u_matrix;uniform vec2 u_extrude_scale;uniform float u_camera_to_center_distance;out float v_placed;out float v_notUsed;void main() {vec4 projectedPoint=u_matrix*vec4(a_pos+elevationVector(a_anchor_pos)*(a_z_offset+elevation(a_anchor_pos)),1);highp float camera_to_anchor_distance=projectedPoint.w;highp float collision_perspective_ratio=clamp(\n0.5+0.5*(u_camera_to_center_distance/camera_to_anchor_distance),0.0,1.5);gl_Position=projectedPoint;gl_Position.xy+=(a_extrude*a_size_scale+a_shift+a_padding)*u_extrude_scale*gl_Position.w*collision_perspective_ratio;v_placed=a_placed.x;v_notUsed=a_placed.y;}'),collisionCircle:Jo("in float v_radius;in vec2 v_extrude;in float v_perspective_ratio;in float v_collision;void main() {float alpha=0.5*min(v_perspective_ratio,1.0);float stroke_radius=0.9*max(v_perspective_ratio,1.0);float distance_to_center=length(v_extrude);float distance_to_edge=abs(distance_to_center-v_radius);float opacity_t=smoothstep(-stroke_radius,0.0,-distance_to_edge);vec4 color=mix(vec4(0.0,0.0,1.0,0.5),vec4(1.0,0.0,0.0,1.0),v_collision);glFragColor=color*alpha*opacity_t;}","in vec2 a_pos_2f;in float a_radius;in vec2 a_flags;uniform mat4 u_matrix;uniform mat4 u_inv_matrix;uniform vec2 u_viewport_size;uniform float u_camera_to_center_distance;out float v_radius;out vec2 v_extrude;out float v_perspective_ratio;out float v_collision;vec3 toTilePosition(vec2 screenPos) {vec4 rayStart=u_inv_matrix*vec4(screenPos,-1.0,1.0);vec4 rayEnd  =u_inv_matrix*vec4(screenPos, 1.0,1.0);rayStart.xyz/=rayStart.w;rayEnd.xyz  /=rayEnd.w;highp float t=(0.0-rayStart.z)/(rayEnd.z-rayStart.z);return mix(rayStart.xyz,rayEnd.xyz,t);}void main() {vec2 quadCenterPos=a_pos_2f;float radius=a_radius;float collision=a_flags.x;float vertexIdx=a_flags.y;vec2 quadVertexOffset=vec2(\nmix(-1.0,1.0,float(vertexIdx >=2.0)),mix(-1.0,1.0,float(vertexIdx >=1.0 && vertexIdx <=2.0)));vec2 quadVertexExtent=quadVertexOffset*radius;vec3 tilePos=toTilePosition(quadCenterPos);vec4 clipPos=u_matrix*vec4(tilePos,1.0);highp float camera_to_anchor_distance=clipPos.w;highp float collision_perspective_ratio=clamp(\n0.5+0.5*(u_camera_to_center_distance/camera_to_anchor_distance),0.0,4.0);float padding_factor=1.2;v_radius=radius;v_extrude=quadVertexExtent*padding_factor;v_perspective_ratio=collision_perspective_ratio;v_collision=collision;gl_Position=vec4(clipPos.xyz/clipPos.w,1.0)+vec4(quadVertexExtent*padding_factor/u_viewport_size*2.0,0.0,0.0);}"),debug:Jo("uniform highp vec4 u_color;uniform sampler2D u_overlay;in vec2 v_uv;void main() {vec4 overlay_color=texture(u_overlay,v_uv);glFragColor=mix(u_color,overlay_color,overlay_color.a);}",'#include "_prelude_terrain.vertex.glsl"\nin vec2 a_pos;\n#ifdef PROJECTION_GLOBE_VIEW\nin vec3 a_pos_3;\n#endif\nout vec2 v_uv;uniform mat4 u_matrix;uniform float u_overlay_scale;void main() {float h=elevation(a_pos);v_uv=a_pos/8192.0;\n#ifdef PROJECTION_GLOBE_VIEW\ngl_Position=u_matrix*vec4(a_pos_3+elevationVector(a_pos)*h,1);\n#else\ngl_Position=u_matrix*vec4(a_pos*u_overlay_scale,h,1);\n#endif\n}'),fill:Jo('#include "_prelude_fog.fragment.glsl"\n#include "_prelude_lighting.glsl"\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float opacity\nuniform float u_emissive_strength;void main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float opacity\nvec4 out_color=color;\n#ifdef LIGHTING_3D_MODE\nout_color=apply_lighting_with_emission_ground(out_color,u_emissive_strength);\n#endif\n#ifdef FOG\nout_color=fog_dither(fog_apply_premultiplied(out_color,v_fog_pos));\n#endif\nglFragColor=out_color*opacity;\n#ifdef OVERDRAW_INSPECTOR\nglFragColor=vec4(1.0);\n#endif\nHANDLE_WIREFRAME_DEBUG;}','#include "_prelude_fog.vertex.glsl"\nin vec2 a_pos;uniform mat4 u_matrix;\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float opacity\ngl_Position=u_matrix*vec4(a_pos,0,1);\n#ifdef FOG\nv_fog_pos=fog_position(a_pos);\n#endif\n}'),fillOutline:Jo('#include "_prelude_fog.fragment.glsl"\n#include "_prelude_lighting.glsl"\nin highp vec2 v_pos;uniform float u_emissive_strength;\n#pragma mapbox: define highp vec4 outline_color\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 outline_color\n#pragma mapbox: initialize lowp float opacity\nfloat dist=length(v_pos-gl_FragCoord.xy);float alpha=1.0-smoothstep(0.0,1.0,dist);vec4 out_color=outline_color;\n#ifdef LIGHTING_3D_MODE\nout_color=apply_lighting_with_emission_ground(out_color,u_emissive_strength);\n#endif\n#ifdef FOG\nout_color=fog_dither(fog_apply_premultiplied(out_color,v_fog_pos));\n#endif\nglFragColor=out_color*(alpha*opacity);\n#ifdef OVERDRAW_INSPECTOR\nglFragColor=vec4(1.0);\n#endif\nHANDLE_WIREFRAME_DEBUG;}','#include "_prelude_fog.vertex.glsl"\nin vec2 a_pos;uniform mat4 u_matrix;uniform vec2 u_world;out highp vec2 v_pos;\n#pragma mapbox: define highp vec4 outline_color\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 outline_color\n#pragma mapbox: initialize lowp float opacity\ngl_Position=u_matrix*vec4(a_pos,0,1);v_pos=(gl_Position.xy/gl_Position.w+1.0)/2.0*u_world;\n#ifdef FOG\nv_fog_pos=fog_position(a_pos);\n#endif\n}'),fillOutlinePattern:Jo('#include "_prelude_fog.fragment.glsl"\n#include "_prelude_lighting.glsl"\nuniform vec2 u_texsize;uniform sampler2D u_image;uniform float u_emissive_strength;in highp vec2 v_pos;in highp vec2 v_pos_world;\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp vec4 pattern\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump vec4 pattern\nvec2 pattern_tl=pattern.xy;vec2 pattern_br=pattern.zw;vec2 imagecoord=mod(v_pos,1.0);vec2 pos=mix(pattern_tl/u_texsize,pattern_br/u_texsize,imagecoord);vec2 lod_pos=mix(pattern_tl/u_texsize,pattern_br/u_texsize,v_pos);float dist=length(v_pos_world-gl_FragCoord.xy);float alpha=1.0-smoothstep(0.0,1.0,dist);vec4 out_color=textureLodCustom(u_image,pos,lod_pos);\n#ifdef LIGHTING_3D_MODE\nout_color=apply_lighting_with_emission_ground(out_color,u_emissive_strength);\n#endif\n#ifdef FOG\nout_color=fog_dither(fog_apply_premultiplied(out_color,v_fog_pos));\n#endif\nglFragColor=out_color*(alpha*opacity);\n#ifdef OVERDRAW_INSPECTOR\nglFragColor=vec4(1.0);\n#endif\nHANDLE_WIREFRAME_DEBUG;}','#include "_prelude_fog.vertex.glsl"\nuniform mat4 u_matrix;uniform vec2 u_world;uniform vec2 u_pixel_coord_upper;uniform vec2 u_pixel_coord_lower;uniform float u_tile_units_to_pixels;in vec2 a_pos;out highp vec2 v_pos;out highp vec2 v_pos_world;\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp vec4 pattern\n#pragma mapbox: define lowp float pixel_ratio\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump vec4 pattern\n#pragma mapbox: initialize lowp float pixel_ratio\nvec2 pattern_tl=pattern.xy;vec2 pattern_br=pattern.zw;gl_Position=u_matrix*vec4(a_pos,0,1);vec2 display_size=(pattern_br-pattern_tl)/pixel_ratio;v_pos=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,display_size,u_tile_units_to_pixels,a_pos);v_pos_world=(gl_Position.xy/gl_Position.w+1.0)/2.0*u_world;\n#ifdef FOG\nv_fog_pos=fog_position(a_pos);\n#endif\n}'),fillPattern:Jo('#include "_prelude_fog.fragment.glsl"\n#include "_prelude_lighting.glsl"\nuniform vec2 u_texsize;uniform sampler2D u_image;in vec2 v_pos;uniform float u_emissive_strength;\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp vec4 pattern\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump vec4 pattern\nvec2 pattern_tl=pattern.xy;vec2 pattern_br=pattern.zw;vec2 imagecoord=mod(v_pos,1.0);vec2 pos=mix(pattern_tl/u_texsize,pattern_br/u_texsize,imagecoord);vec2 lod_pos=mix(pattern_tl/u_texsize,pattern_br/u_texsize,v_pos);vec4 out_color=textureLodCustom(u_image,pos,lod_pos);\n#ifdef LIGHTING_3D_MODE\nout_color=apply_lighting_with_emission_ground(out_color,u_emissive_strength);\n#endif\n#ifdef FOG\nout_color=fog_dither(fog_apply_premultiplied(out_color,v_fog_pos));\n#endif\nglFragColor=out_color*opacity;\n#ifdef OVERDRAW_INSPECTOR\nglFragColor=vec4(1.0);\n#endif\nHANDLE_WIREFRAME_DEBUG;}','#include "_prelude_fog.vertex.glsl"\nuniform mat4 u_matrix;uniform vec2 u_pixel_coord_upper;uniform vec2 u_pixel_coord_lower;uniform float u_tile_units_to_pixels;in vec2 a_pos;out vec2 v_pos;\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp vec4 pattern\n#pragma mapbox: define lowp float pixel_ratio\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump vec4 pattern\n#pragma mapbox: initialize lowp float pixel_ratio\nvec2 pattern_tl=pattern.xy;vec2 pattern_br=pattern.zw;vec2 display_size=(pattern_br-pattern_tl)/pixel_ratio;gl_Position=u_matrix*vec4(a_pos,0,1);v_pos=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,display_size,u_tile_units_to_pixels,a_pos);\n#ifdef FOG\nv_fog_pos=fog_position(a_pos);\n#endif\n}'),fillExtrusion:Jo('#include "_prelude_fog.fragment.glsl"\n#include "_prelude_shadow.fragment.glsl"\n#include "_prelude_lighting.glsl"\nin vec4 v_color;in vec4 v_flat;\n#ifdef RENDER_SHADOWS\nin highp vec4 v_pos_light_view_0;in highp vec4 v_pos_light_view_1;\n#endif\nuniform lowp float u_opacity;\n#ifdef FAUX_AO\nuniform lowp vec2 u_ao;in vec2 v_ao;\n#endif\n#if defined(ZERO_ROOF_RADIUS) && !defined(LIGHTING_3D_MODE)\nin vec4 v_roof_color;\n#endif\n#if defined(ZERO_ROOF_RADIUS) || defined(RENDER_SHADOWS) || defined(LIGHTING_3D_MODE)\nin highp vec3 v_normal;\n#endif\nuniform vec3 u_flood_light_color;uniform highp float u_vertical_scale;uniform float u_flood_light_intensity;uniform vec3 u_ground_shadow_factor;\n#if defined(LIGHTING_3D_MODE) && defined(FLOOD_LIGHT)\nin float v_flood_radius;in float v_has_floodlight;\n#endif\nuniform float u_emissive_strength;in float v_height;void main() {\n#if defined(ZERO_ROOF_RADIUS) || defined(RENDER_SHADOWS) || defined(LIGHTING_3D_MODE)\nvec3 normal=normalize(v_normal);\n#endif\nfloat z;vec4 color=v_color;\n#ifdef ZERO_ROOF_RADIUS\nz=float(normal.z > 0.00001);\n#ifdef LIGHTING_3D_MODE\nnormal=mix(normal,vec3(0.0,0.0,1.0),z);\n#else\ncolor=mix(v_color,v_roof_color,z);\n#endif\n#endif\nfloat h=max(0.0,v_height);float ao_shade=1.0;\n#ifdef FAUX_AO\nfloat intensity=u_ao[0];float h_floors=h/(u_ao[1]*u_vertical_scale);float y_shade=1.0-0.9*intensity*min(v_ao.y,1.0);ao_shade=(1.0-0.08*intensity)*(y_shade+(1.0-y_shade)*(1.0-pow(1.0-min(h_floors/16.0,1.0),16.0)))+0.08*intensity*min(h_floors/160.0,1.0);float concave=v_ao.x*v_ao.x;\n#ifdef ZERO_ROOF_RADIUS\nconcave*=(1.0-z);\n#endif\nfloat x_shade=mix(1.0,mix(0.6,0.75,min(h_floors/30.0,1.0)),intensity)+0.1*intensity*min(h,1.0);ao_shade*=mix(1.0,x_shade*x_shade*x_shade,concave);\n#ifdef LIGHTING_3D_MODE\n#ifdef FLOOD_LIGHT\ncolor.rgb*=mix(ao_shade,1.0,v_has_floodlight);\n#else\ncolor.rgb*=ao_shade;\n#endif\n#else\ncolor.rgb*=ao_shade;\n#endif\n#endif\n#ifdef LIGHTING_3D_MODE\nfloat flood_radiance=0.0;\n#ifdef FLOOD_LIGHT\nflood_radiance=(1.0-min(h/v_flood_radius,1.0))*u_flood_light_intensity*v_has_floodlight;\n#endif\n#ifdef RENDER_SHADOWS\n#ifdef FLOOD_LIGHT\nfloat ndotl_unclamped=dot(normal,u_shadow_direction);float ndotl=max(0.0,ndotl_unclamped);float occlusion=ndotl_unclamped < 0.0 ? 1.0 : shadow_occlusion(ndotl,v_pos_light_view_0,v_pos_light_view_1,1.0/gl_FragCoord.w);vec3 litColor=apply_lighting(color.rgb,normal,(1.0-u_shadow_intensity*occlusion)*ndotl);vec3 floodLitColor=compute_flood_lighting(u_flood_light_color*u_opacity,1.0-u_shadow_intensity,occlusion,u_ground_shadow_factor);color.rgb=mix(litColor,floodLitColor,flood_radiance);\n#else\nfloat shadowed_lighting_factor=shadowed_light_factor_normal(normal,v_pos_light_view_0,v_pos_light_view_1,1.0/gl_FragCoord.w);color.rgb=apply_lighting(color.rgb,normal,shadowed_lighting_factor);\n#endif\n#else\ncolor.rgb=apply_lighting(color.rgb,normal);\n#ifdef FLOOD_LIGHT\ncolor.rgb=mix(color.rgb,u_flood_light_color*u_opacity,flood_radiance);\n#endif\n#endif\ncolor.rgb=mix(color.rgb,v_flat.rgb,u_emissive_strength);color*=u_opacity;\n#endif\n#ifdef FOG\ncolor=fog_dither(fog_apply_premultiplied(color,v_fog_pos,h));\n#endif\n#ifdef INDICATOR_CUTOUT\ncolor=applyCutout(color);\n#endif\nglFragColor=color;\n#ifdef OVERDRAW_INSPECTOR\nglFragColor=vec4(1.0);\n#endif\nHANDLE_WIREFRAME_DEBUG;}','#include "_prelude_fog.vertex.glsl"\n#include "_prelude_terrain.vertex.glsl"\n#include "_prelude_shadow.vertex.glsl"\n#include "_prelude_lighting.glsl"\nuniform mat4 u_matrix;uniform vec3 u_lightcolor;uniform lowp vec3 u_lightpos;uniform lowp float u_lightintensity;uniform float u_vertical_gradient;uniform lowp float u_opacity;uniform float u_edge_radius;in vec4 a_pos_normal_ed;in vec2 a_centroid_pos;\n#ifdef PROJECTION_GLOBE_VIEW\nin vec3 a_pos_3;in vec3 a_pos_normal_3;uniform mat4 u_inv_rot_matrix;uniform vec2 u_merc_center;uniform vec3 u_tile_id;uniform float u_zoom_transition;uniform vec3 u_up_dir;uniform float u_height_lift;\n#endif\nuniform highp float u_vertical_scale;out vec4 v_color;out vec4 v_flat;\n#ifdef RENDER_SHADOWS\nuniform mat4 u_light_matrix_0;uniform mat4 u_light_matrix_1;out highp vec4 v_pos_light_view_0;out highp vec4 v_pos_light_view_1;out float v_depth;\n#endif\n#if defined(ZERO_ROOF_RADIUS) && !defined(LIGHTING_3D_MODE)\nout vec4 v_roof_color;\n#endif\n#if defined(ZERO_ROOF_RADIUS) || defined(RENDER_SHADOWS) || defined(LIGHTING_3D_MODE)\nout highp vec3 v_normal;\n#endif\n#ifdef FAUX_AO\nuniform lowp vec2 u_ao;out vec2 v_ao;\n#endif\n#if defined(LIGHTING_3D_MODE) && defined(FLOOD_LIGHT)\nout float v_flood_radius;out float v_has_floodlight;\n#endif\nout float v_height;\n#pragma mapbox: define highp float base\n#pragma mapbox: define highp float height\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define highp float flood_light_wall_radius\nvoid main() {\n#pragma mapbox: initialize highp float base\n#pragma mapbox: initialize highp float height\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize highp float flood_light_wall_radius\nbase*=u_vertical_scale;height*=u_vertical_scale;vec4 pos_nx=floor(a_pos_normal_ed*0.5);vec4 top_up_ny_start=a_pos_normal_ed-2.0*pos_nx;vec3 top_up_ny=top_up_ny_start.xyz;float x_normal=pos_nx.z/8192.0;vec3 normal=top_up_ny.y==1.0 ? vec3(0.0,0.0,1.0) : normalize(vec3(x_normal,(2.0*top_up_ny.z-1.0)*(1.0-abs(x_normal)),0.0));\n#if defined(ZERO_ROOF_RADIUS) || defined(RENDER_SHADOWS) || defined(LIGHTING_3D_MODE)\nv_normal=normal;\n#endif\nbase=max(0.0,base);float attr_height=height;height=max(0.0,top_up_ny.y==0.0 && top_up_ny.x==1.0 ? height-u_edge_radius : height);float t=top_up_ny.x;vec2 centroid_pos=vec2(0.0);\n#if defined(HAS_CENTROID) || defined(TERRAIN)\ncentroid_pos=a_centroid_pos;\n#endif\nfloat ele=0.0;float h=0.0;float c_ele=0.0;vec3 pos;\n#ifdef TERRAIN\nbool flat_roof=centroid_pos.x !=0.0 && t > 0.0;ele=elevation(pos_nx.xy);c_ele=flat_roof ? centroid_pos.y==0.0 ? elevationFromUint16(centroid_pos.x) : flatElevation(centroid_pos) : ele;h=flat_roof ? max(c_ele+height,ele+base+2.0) : ele+(t > 0.0 ? height : base==0.0 ?-5.0 : base);pos=vec3(pos_nx.xy,h);\n#else\nh=t > 0.0 ? height : base;pos=vec3(pos_nx.xy,h);\n#endif\n#ifdef PROJECTION_GLOBE_VIEW\nfloat lift=float((t+base) > 0.0)*u_height_lift;h+=lift;vec3 globe_normal=normalize(mix(a_pos_normal_3/16384.0,u_up_dir,u_zoom_transition));vec3 globe_pos=a_pos_3+globe_normal*(u_tile_up_scale*h);vec3 merc_pos=mercator_tile_position(u_inv_rot_matrix,pos.xy,u_tile_id,u_merc_center)+u_up_dir*u_tile_up_scale*pos.z;pos=mix_globe_mercator(globe_pos,merc_pos,u_zoom_transition);\n#endif\nfloat cutoff=1.0;vec3 scaled_pos=pos;\n#ifdef RENDER_CUTOFF\nvec3 centroid_random=vec3(centroid_pos.xy,centroid_pos.x+centroid_pos.y+1.0);vec3 ground_pos=centroid_pos.x==0.0 ? pos.xyz : (centroid_random/8.0);vec4 ground=u_matrix*vec4(ground_pos.xy,ele,1.0);cutoff=max(0.01,cutoff_opacity(u_cutoff_params,ground.z));if (centroid_pos.y !=0.0 && centroid_pos.x !=0.0) {vec3 g=floor(ground_pos);vec3 mod_=centroid_random-g*8.0;float seed=min(1.0,0.1*(min(3.5,max(mod_.x+mod_.y,0.2*attr_height))*0.35+mod_.z));if (cutoff < 0.8-seed) {cutoff=0.0;}}float cutoff_scale=cutoff;scaled_pos.z=mix(c_ele,h,cutoff_scale);\n#endif\nfloat hidden=float((centroid_pos.x==0.0 && centroid_pos.y==1.0) || (cutoff < 0.01 && centroid_pos.x !=0.0));gl_Position=mix(u_matrix*vec4(scaled_pos,1),AWAY,hidden);h=h-ele;v_height=h;\n#ifdef RENDER_SHADOWS\nvec3 shd_pos0=pos;vec3 shd_pos1=pos;\n#ifdef NORMAL_OFFSET\nvec3 offset=shadow_normal_offset(normal);shd_pos0+=offset*shadow_normal_offset_multiplier0();shd_pos1+=offset*shadow_normal_offset_multiplier1();\n#endif\nv_pos_light_view_0=u_light_matrix_0*vec4(shd_pos0,1);v_pos_light_view_1=u_light_matrix_1*vec4(shd_pos1,1);\n#endif\nfloat NdotL=0.0;float colorvalue=0.0;\n#ifndef LIGHTING_3D_MODE\ncolorvalue=color.r*0.2126+color.g*0.7152+color.b*0.0722;vec4 ambientlight=vec4(0.03,0.03,0.03,1.0);color+=ambientlight;NdotL=clamp(dot(normal,u_lightpos),0.0,1.0);NdotL=mix((1.0-u_lightintensity),max((1.0-colorvalue+u_lightintensity),1.0),NdotL);if (normal.y !=0.0) {float r=0.84;r=mix(0.7,0.98,1.0-u_lightintensity);NdotL*=(\n(1.0-u_vertical_gradient)+(u_vertical_gradient*clamp((t+base)*pow(height/150.0,0.5),r,1.0)));}\n#endif\n#ifdef FAUX_AO\nfloat concave=pos_nx.w-floor(pos_nx.w*0.5)*2.0;float start=top_up_ny_start.w;float y_ground=1.0-clamp(t+base,0.0,1.0);float top_height=height;\n#ifdef TERRAIN\ntop_height=mix(max(c_ele+height,ele+base+2.0),ele+height,float(centroid_pos.x==0.0))-ele;y_ground+=y_ground*5.0/max(3.0,top_height);\n#endif\nv_ao=vec2(mix(concave,-concave,start),y_ground);NdotL*=(1.0+0.05*(1.0-top_up_ny.y)*u_ao[0]);\n#ifdef PROJECTION_GLOBE_VIEW\ntop_height+=u_height_lift;\n#endif\ngl_Position.z-=(0.0000006*(min(top_height,500.)+2.0*min(base,500.0)+60.0*concave+3.0*start))*gl_Position.w;\n#endif\n#ifdef LIGHTING_3D_MODE\n#ifdef FLOOD_LIGHT\nfloat is_wall=1.0-float(t > 0.0 && top_up_ny.y > 0.0);v_has_floodlight=float(flood_light_wall_radius > 0.0 && is_wall > 0.0);v_flood_radius=flood_light_wall_radius*u_vertical_scale;\n#endif\nv_color=vec4(color.rgb,1.0);v_flat=vec4(linearProduct(color.rgb,vec3(calculate_NdotL(normal))),1.0);\n#else\nv_color=vec4(0.0,0.0,0.0,1.0);v_color.rgb+=clamp(color.rgb*NdotL*u_lightcolor,mix(vec3(0.0),vec3(0.3),1.0-u_lightcolor),vec3(1.0));v_color*=u_opacity;\n#endif\n#if defined(ZERO_ROOF_RADIUS) && !defined(LIGHTING_3D_MODE)\nfloat roofNdotL=clamp(u_lightpos.z,0.0,1.0);roofNdotL=mix((1.0-u_lightintensity),max((1.0-colorvalue+u_lightintensity),1.0),roofNdotL);v_roof_color=vec4(0.0,0.0,0.0,1.0);v_roof_color.rgb+=clamp(color.rgb*roofNdotL*u_lightcolor,mix(vec3(0.0),vec3(0.3),1.0-u_lightcolor),vec3(1.0));v_roof_color*=u_opacity;\n#endif\n#ifdef FOG\nv_fog_pos=fog_position(pos);\n#endif\n}'),fillExtrusionDepth:Jo("in highp float v_depth;void main() {\n#ifndef DEPTH_TEXTURE\nglFragColor=pack_depth(v_depth);\n#endif\n}",'#include "_prelude_terrain.vertex.glsl"\nuniform mat4 u_matrix;uniform float u_edge_radius;uniform float u_vertical_scale;in vec4 a_pos_normal_ed;in vec2 a_centroid_pos;\n#pragma mapbox: define highp float base\n#pragma mapbox: define highp float height\nout highp float v_depth;void main() {\n#pragma mapbox: initialize highp float base\n#pragma mapbox: initialize highp float height\nbase*=u_vertical_scale;height*=u_vertical_scale;vec3 pos_nx=floor(a_pos_normal_ed.xyz*0.5);mediump vec3 top_up_ny=a_pos_normal_ed.xyz-2.0*pos_nx;base=max(0.0,base);height=max(0.0,top_up_ny.y==0.0 && top_up_ny.x==1.0 ? height-u_edge_radius : height);float t=top_up_ny.x;vec2 centroid_pos=vec2(0.0);\n#if defined(HAS_CENTROID) || defined(TERRAIN)\ncentroid_pos=a_centroid_pos;\n#endif\nvec3 pos;\n#ifdef TERRAIN\nbool flat_roof=centroid_pos.x !=0.0 && t > 0.0;float ele=elevation(pos_nx.xy);float c_ele=flat_roof ? centroid_pos.y==0.0 ? elevationFromUint16(centroid_pos.x) : flatElevation(centroid_pos) : ele;float h=flat_roof ? max(c_ele+height,ele+base+2.0) : ele+(t > 0.0 ? height : base);pos=vec3(pos_nx.xy,h);\n#else\npos=vec3(pos_nx.xy,t > 0.0 ? height : base);\n#endif\nfloat hidden=float(centroid_pos.x==0.0 && centroid_pos.y==1.0);gl_Position=mix(u_matrix*vec4(pos,1),AWAY,hidden);v_depth=gl_Position.z/gl_Position.w;}'),fillExtrusionPattern:Jo('#include "_prelude_fog.fragment.glsl"\n#include "_prelude_lighting.glsl"\nuniform vec2 u_texsize;uniform sampler2D u_image;\n#ifdef FAUX_AO\nuniform lowp vec2 u_ao;in vec3 v_ao;\n#endif\n#ifdef LIGHTING_3D_MODE\nin vec3 v_normal;\n#endif\nin vec2 v_pos;in vec4 v_lighting;uniform lowp float u_opacity;\n#pragma mapbox: define highp float base\n#pragma mapbox: define highp float height\n#pragma mapbox: define mediump vec4 pattern\n#pragma mapbox: define highp float pixel_ratio\nvoid main() {\n#pragma mapbox: initialize highp float base\n#pragma mapbox: initialize highp float height\n#pragma mapbox: initialize mediump vec4 pattern\n#pragma mapbox: initialize highp float pixel_ratio\nvec2 pattern_tl=pattern.xy;vec2 pattern_br=pattern.zw;vec2 imagecoord=mod(v_pos,1.0);vec2 pos=mix(pattern_tl/u_texsize,pattern_br/u_texsize,imagecoord);vec2 lod_pos=mix(pattern_tl/u_texsize,pattern_br/u_texsize,v_pos);vec4 out_color=textureLodCustom(u_image,pos,lod_pos);\n#ifdef LIGHTING_3D_MODE\nout_color=apply_lighting(out_color,normalize(v_normal))*u_opacity;\n#else\nout_color=out_color*v_lighting;\n#endif\n#ifdef FAUX_AO\nfloat intensity=u_ao[0];float h=max(0.0,v_ao.z);float h_floors=h/u_ao[1];float y_shade=1.0-0.9*intensity*min(v_ao.y,1.0);float shade=(1.0-0.08*intensity)*(y_shade+(1.0-y_shade)*(1.0-pow(1.0-min(h_floors/16.0,1.0),16.0)))+0.08*intensity*min(h_floors/160.0,1.0);float concave=v_ao.x*v_ao.x;float x_shade=mix(1.0,mix(0.6,0.75,min(h_floors/30.0,1.0)),intensity)+0.1*intensity*min(h,1.0);shade*=mix(1.0,x_shade*x_shade*x_shade,concave);out_color.rgb=out_color.rgb*shade;\n#endif\n#ifdef FOG\nout_color=fog_dither(fog_apply_premultiplied(out_color,v_fog_pos));\n#endif\n#ifdef INDICATOR_CUTOUT\nout_color=applyCutout(out_color);\n#endif\nglFragColor=out_color;\n#ifdef OVERDRAW_INSPECTOR\nglFragColor=vec4(1.0);\n#endif\nHANDLE_WIREFRAME_DEBUG;}','#include "_prelude_fog.vertex.glsl"\n#include "_prelude_terrain.vertex.glsl"\n#include "_prelude_lighting.glsl"\nuniform mat4 u_matrix;uniform vec2 u_pixel_coord_upper;uniform vec2 u_pixel_coord_lower;uniform float u_height_factor;uniform float u_tile_units_to_pixels;uniform float u_vertical_gradient;uniform lowp float u_opacity;uniform vec3 u_lightcolor;uniform lowp vec3 u_lightpos;uniform lowp float u_lightintensity;in vec4 a_pos_normal_ed;in vec2 a_centroid_pos;\n#ifdef PROJECTION_GLOBE_VIEW\nin vec3 a_pos_3;in vec3 a_pos_normal_3;uniform mat4 u_inv_rot_matrix;uniform vec2 u_merc_center;uniform vec3 u_tile_id;uniform float u_zoom_transition;uniform vec3 u_up_dir;uniform float u_height_lift;\n#endif\nout vec2 v_pos;out vec4 v_lighting;\n#ifdef FAUX_AO\nuniform lowp vec2 u_ao;out vec3 v_ao;\n#endif\n#ifdef LIGHTING_3D_MODE\nout vec3 v_normal;\n#endif\n#pragma mapbox: define highp float base\n#pragma mapbox: define highp float height\n#pragma mapbox: define mediump vec4 pattern\n#pragma mapbox: define highp float pixel_ratio\nvoid main() {\n#pragma mapbox: initialize highp float base\n#pragma mapbox: initialize highp float height\n#pragma mapbox: initialize mediump vec4 pattern\n#pragma mapbox: initialize highp float pixel_ratio\nvec2 pattern_tl=pattern.xy;vec2 pattern_br=pattern.zw;vec4 pos_nx=floor(a_pos_normal_ed*0.5);mediump vec4 top_up_ny_start=a_pos_normal_ed-2.0*pos_nx;mediump vec3 top_up_ny=top_up_ny_start.xyz;float x_normal=pos_nx.z/8192.0;vec3 normal=top_up_ny.y==1.0 ? vec3(0.0,0.0,1.0) : normalize(vec3(x_normal,(2.0*top_up_ny.z-1.0)*(1.0-abs(x_normal)),0.0));float edgedistance=a_pos_normal_ed.w;vec2 display_size=(pattern_br-pattern_tl)/pixel_ratio;base=max(0.0,base);height=max(0.0,height);float t=top_up_ny.x;float z=t > 0.0 ? height : base;vec2 centroid_pos=vec2(0.0);\n#if defined(HAS_CENTROID) || defined(TERRAIN)\ncentroid_pos=a_centroid_pos;\n#endif\nfloat ele=0.0;float h=z;vec3 p;float c_ele;\n#ifdef TERRAIN\nbool flat_roof=centroid_pos.x !=0.0 && t > 0.0;ele=elevation(pos_nx.xy);c_ele=flat_roof ? centroid_pos.y==0.0 ? elevationFromUint16(centroid_pos.x) : flatElevation(centroid_pos) : ele;h=flat_roof ? max(c_ele+height,ele+base+2.0) : ele+(t > 0.0 ? height : base==0.0 ?-5.0 : base);p=vec3(pos_nx.xy,h);\n#else\np=vec3(pos_nx.xy,z);\n#endif\n#ifdef PROJECTION_GLOBE_VIEW\nfloat lift=float((t+base) > 0.0)*u_height_lift;h+=lift;vec3 globe_normal=normalize(mix(a_pos_normal_3/16384.0,u_up_dir,u_zoom_transition));vec3 globe_pos=a_pos_3+globe_normal*(u_tile_up_scale*(p.z+lift));vec3 merc_pos=mercator_tile_position(u_inv_rot_matrix,p.xy,u_tile_id,u_merc_center)+u_up_dir*u_tile_up_scale*p.z;p=mix_globe_mercator(globe_pos,merc_pos,u_zoom_transition);\n#endif\nfloat hidden=float(centroid_pos.x==0.0 && centroid_pos.y==1.0);gl_Position=mix(u_matrix*vec4(p,1),AWAY,hidden);vec2 pos=normal.z==1.0\n? pos_nx.xy\n: vec2(edgedistance,z*u_height_factor);v_pos=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,display_size,u_tile_units_to_pixels,pos);v_lighting=vec4(0.0,0.0,0.0,1.0);float NdotL=0.0;\n#ifdef LIGHTING_3D_MODE\nNdotL=calculate_NdotL(normal);\n#else\nNdotL=clamp(dot(normal,u_lightpos),0.0,1.0);NdotL=mix((1.0-u_lightintensity),max((0.5+u_lightintensity),1.0),NdotL);\n#endif\nif (normal.y !=0.0) {float r=0.84;\n#ifndef LIGHTING_3D_MODE\nr=mix(0.7,0.98,1.0-u_lightintensity);\n#endif\nNdotL*=(\n(1.0-u_vertical_gradient)+(u_vertical_gradient*clamp((t+base)*pow(height/150.0,0.5),r,1.0)));}\n#ifdef FAUX_AO\nfloat concave=pos_nx.w-floor(pos_nx.w*0.5)*2.0;float start=top_up_ny_start.w;float y_ground=1.0-clamp(t+base,0.0,1.0);float top_height=height;\n#ifdef TERRAIN\ntop_height=mix(max(c_ele+height,ele+base+2.0),ele+height,float(centroid_pos.x==0.0))-ele;y_ground+=y_ground*5.0/max(3.0,top_height);\n#endif\nv_ao=vec3(mix(concave,-concave,start),y_ground,h-ele);NdotL*=(1.0+0.05*(1.0-top_up_ny.y)*u_ao[0]);\n#ifdef PROJECTION_GLOBE_VIEW\ntop_height+=u_height_lift;\n#endif\ngl_Position.z-=(0.0000006*(min(top_height,500.)+2.0*min(base,500.0)+60.0*concave+3.0*start))*gl_Position.w;\n#endif\n#ifdef LIGHTING_3D_MODE\nv_normal=normal;\n#else\nv_lighting.rgb+=clamp(NdotL*u_lightcolor,mix(vec3(0.0),vec3(0.3),1.0-u_lightcolor),vec3(1.0));v_lighting*=u_opacity;\n#endif \n#ifdef FOG\nv_fog_pos=fog_position(p);\n#endif\n}'),groundShadow:Jo('#include "_prelude_shadow.fragment.glsl"\nprecision highp float;uniform vec3 u_ground_shadow_factor;in vec4 v_pos_light_view_0;in vec4 v_pos_light_view_1;\n#ifdef FOG\nin float v_fog_opacity;\n#endif\nvoid main() {float light=shadowed_light_factor(v_pos_light_view_0,v_pos_light_view_1,1.0/gl_FragCoord.w);vec3 shadow=mix(u_ground_shadow_factor,vec3(1.0),light);\n#ifdef RENDER_CUTOFF\nshadow=mix(vec3(1.0),shadow,cutoff_opacity(u_cutoff_params,1.0/gl_FragCoord.w));\n#endif\n#ifdef FOG\nshadow=mix(shadow,vec3(1.0),v_fog_opacity);\n#endif\n#ifdef INDICATOR_CUTOUT\nshadow=mix(shadow,vec3(1.0),1.0-applyCutout(vec4(1.0)).r);\n#endif\nglFragColor=vec4(shadow,1.0);}','#include "_prelude_fog.vertex.glsl"\nuniform mat4 u_matrix;uniform mat4 u_light_matrix_0;uniform mat4 u_light_matrix_1;in vec2 a_pos;out vec4 v_pos_light_view_0;out vec4 v_pos_light_view_1;\n#ifdef FOG\nout float v_fog_opacity;\n#endif\nvoid main() {gl_Position=u_matrix*vec4(a_pos,0.0,1.0);v_pos_light_view_0=u_light_matrix_0*vec4(a_pos,0.0,1.0);v_pos_light_view_1=u_light_matrix_1*vec4(a_pos,0.0,1.0);\n#ifdef FOG\nv_fog_pos=fog_position(a_pos);v_fog_opacity=fog(v_fog_pos);\n#endif\n}'),fillExtrusionGroundEffect:Jo("uniform highp float u_ao_pass;uniform highp float u_opacity;uniform highp float u_flood_light_intensity;uniform highp vec3 u_flood_light_color;uniform highp float u_attenuation;uniform sampler2D u_fb;uniform float u_fb_size;\n#ifdef SDF_SUBPASS\nin highp vec2 v_pos;in highp vec4 v_line_segment;in highp float v_flood_light_radius_tile;in highp vec2 v_ao;float line_df(highp vec2 a,highp vec2 b,highp vec2 p) {highp vec2 ba=b-a;highp vec2 pa=p-a;highp float r=clamp(dot(pa,ba)/dot(ba,ba),0.0,1.0);return length(pa-r*ba);}\n#ifdef FOG\nin highp float v_fog;\n#endif\n#endif\nvoid main() {\n#ifdef CLEAR_SUBPASS\nvec4 color=vec4(1.0);\n#ifdef CLEAR_FROM_TEXTURE\ncolor=texture(u_fb,gl_FragCoord.xy/vec2(u_fb_size));\n#endif\nglFragColor=color;\n#else\n#ifdef SDF_SUBPASS\nhighp float d=line_df(v_line_segment.xy,v_line_segment.zw,v_pos);highp float effect_radius=mix(v_flood_light_radius_tile,v_ao.y,u_ao_pass);d/=effect_radius;d=min(d,1.0);d=1.0-pow(1.0-d,u_attenuation);highp float effect_intensity=mix(u_flood_light_intensity,v_ao.x,u_ao_pass);highp float fog=1.0;\n#ifdef FOG\nfog=v_fog;\n#endif\n#ifdef RENDER_CUTOFF\nfog*=v_cutoff_opacity;\n#endif\nglFragColor=vec4(vec3(0.0),mix(1.0,d,effect_intensity*u_opacity*fog));\n#else\nvec4 color=mix(vec4(u_flood_light_color,1.0),vec4(vec3(0.0),1.0),u_ao_pass);\n#ifdef OVERDRAW_INSPECTOR\ncolor=vec4(1.0);\n#endif\nglFragColor=color;\n#endif\nHANDLE_WIREFRAME_DEBUG;\n#endif\n}",'#include "_prelude_fog.vertex.glsl"\nin highp vec4 a_pos_end;in highp float a_angular_offset_factor;in highp float a_hidden_by_landmark;\n#ifdef SDF_SUBPASS\nout highp vec2 v_pos;out highp vec4 v_line_segment;out highp float v_flood_light_radius_tile;out highp vec2 v_ao;\n#ifdef FOG\nout highp float v_fog;\n#endif\n#endif\nuniform highp float u_flood_light_intensity;uniform highp mat4 u_matrix;uniform highp float u_ao_pass;uniform highp float u_meter_to_tile;uniform highp float u_edge_radius;uniform highp vec2 u_ao;\n#pragma mapbox: define highp float flood_light_ground_radius\nconst float TANGENT_CUTOFF=4.0;const float NORM=32767.0;void main() {\n#pragma mapbox: initialize highp float flood_light_ground_radius\nvec2 p=a_pos_end.xy;vec2 q=floor(a_pos_end.zw*0.5);vec2 start_bottom=a_pos_end.zw-q*2.0;float fl_ground_radius=flood_light_ground_radius;fl_ground_radius=abs(flood_light_ground_radius);float direction=flood_light_ground_radius < 0.0 ?-1.0 : 1.0;float flood_radius_tile=fl_ground_radius*u_meter_to_tile;vec2 v=normalize(q-p);float ao_radius=u_ao.y/3.5;float effect_radius=mix(flood_radius_tile,ao_radius,u_ao_pass)+u_edge_radius;float angular_offset_factor=a_angular_offset_factor/NORM*TANGENT_CUTOFF;float angular_offset=direction*angular_offset_factor*effect_radius;float top=1.0-start_bottom.y;float side=(0.5-start_bottom.x)*2.0;vec2 extrusion_parallel=v*side*mix(1.0,angular_offset,top);vec2 perp=vec2(v.y,-v.x);vec2 extrusion_perp=direction*perp*effect_radius*top;vec3 pos=vec3(mix(q,p,start_bottom.x),0.0);pos.xy+=extrusion_parallel+extrusion_perp;\n#ifdef SDF_SUBPASS\nv_pos=pos.xy;v_line_segment=vec4(p,q)+perp.xyxy*u_edge_radius;v_flood_light_radius_tile=flood_radius_tile;v_ao=vec2(u_ao.x,ao_radius);\n#ifdef FOG\nv_fog_pos=fog_position(pos);v_fog=1.0-fog(v_fog_pos);\n#endif\n#endif\nfloat hidden_by_landmark=0.0;\n#ifdef HAS_CENTROID\nhidden_by_landmark=a_hidden_by_landmark;\n#endif\nfloat isFloodlit=float(fl_ground_radius > 0.0 && u_flood_light_intensity > 0.0);float hidden=mix(1.0-isFloodlit,isFloodlit,u_ao_pass);hidden+=hidden_by_landmark;gl_Position=mix(u_matrix*vec4(pos,1.0),AWAY,float(hidden > 0.0));\n#ifdef RENDER_CUTOFF\nv_cutoff_opacity=cutoff_opacity(u_cutoff_params,gl_Position.z);\n#endif\n}'),hillshadePrepare:Jo("precision highp float;uniform sampler2D u_image;in vec2 v_pos;uniform vec2 u_dimension;uniform float u_zoom;float getElevation(vec2 coord) {return texture(u_image,coord).r/4.0;}void main() {vec2 epsilon=1.0/u_dimension;float a=getElevation(v_pos+vec2(-epsilon.x,-epsilon.y));float b=getElevation(v_pos+vec2(0,-epsilon.y));float c=getElevation(v_pos+vec2(epsilon.x,-epsilon.y));float d=getElevation(v_pos+vec2(-epsilon.x,0));float e=getElevation(v_pos+vec2(epsilon.x,0));float f=getElevation(v_pos+vec2(-epsilon.x,epsilon.y));float g=getElevation(v_pos+vec2(0,epsilon.y));float h=getElevation(v_pos+vec2(epsilon.x,epsilon.y));float exaggerationFactor=u_zoom < 2.0 ? 0.4 : u_zoom < 4.5 ? 0.35 : 0.3;float exaggeration=u_zoom < 15.0 ? (u_zoom-15.0)*exaggerationFactor : 0.0;vec2 deriv=vec2(\n(c+e+e+h)-(a+d+d+f),(f+g+g+h)-(a+b+b+c)\n)/pow(2.0,exaggeration+(19.2562-u_zoom));glFragColor=clamp(vec4(\nderiv.x/2.0+0.5,deriv.y/2.0+0.5,1.0,1.0),0.0,1.0);}","uniform mat4 u_matrix;uniform vec2 u_dimension;in vec2 a_pos;in vec2 a_texture_pos;out vec2 v_pos;void main() {gl_Position=u_matrix*vec4(a_pos,0,1);highp vec2 epsilon=1.0/u_dimension;float scale=(u_dimension.x-2.0)/u_dimension.x;v_pos=(a_texture_pos/8192.0)*scale+epsilon;}"),hillshade:Jo('#include "_prelude_fog.fragment.glsl"\n#include "_prelude_lighting.glsl"\nuniform sampler2D u_image;in vec2 v_pos;uniform vec2 u_latrange;uniform vec2 u_light;uniform vec4 u_shadow;uniform vec4 u_highlight;uniform vec4 u_accent;uniform float u_emissive_strength;void main() {vec4 pixel=texture(u_image,v_pos);vec2 deriv=((pixel.rg*2.0)-1.0);float scaleFactor=cos(radians((u_latrange[0]-u_latrange[1])*(1.0-v_pos.y)+u_latrange[1]));float slope=atan(1.25*length(deriv)/scaleFactor);float aspect=deriv.x !=0.0 ? atan(deriv.y,-deriv.x) : PI/2.0*(deriv.y > 0.0 ? 1.0 :-1.0);float intensity=u_light.x;float azimuth=u_light.y+PI;float base=1.875-intensity*1.75;float maxValue=0.5*PI;float scaledSlope=intensity !=0.5 ? ((pow(base,slope)-1.0)/(pow(base,maxValue)-1.0))*maxValue : slope;float accent=cos(scaledSlope);vec4 accent_color=(1.0-accent)*u_accent*clamp(intensity*2.0,0.0,1.0);float shade=abs(mod((aspect+azimuth)/PI+0.5,2.0)-1.0);vec4 shade_color=mix(u_shadow,u_highlight,shade)*sin(scaledSlope)*clamp(intensity*2.0,0.0,1.0);glFragColor=accent_color*(1.0-shade_color.a)+shade_color;\n#ifdef LIGHTING_3D_MODE\nglFragColor=apply_lighting_with_emission_ground(glFragColor,u_emissive_strength);\n#endif\n#ifdef FOG\nglFragColor=fog_dither(fog_apply_premultiplied(glFragColor,v_fog_pos));\n#endif\n#ifdef OVERDRAW_INSPECTOR\nglFragColor=vec4(1.0);\n#endif\nHANDLE_WIREFRAME_DEBUG;}','#include "_prelude_fog.vertex.glsl"\nuniform mat4 u_matrix;in vec2 a_pos;in vec2 a_texture_pos;out vec2 v_pos;void main() {gl_Position=u_matrix*vec4(a_pos,0,1);v_pos=a_texture_pos/8192.0;\n#ifdef FOG\nv_fog_pos=fog_position(a_pos);\n#endif\n}'),line:Jo('#include "_prelude_fog.fragment.glsl"\n#include "_prelude_lighting.glsl"\nuniform lowp float u_device_pixel_ratio;uniform float u_alpha_discard_threshold;uniform highp vec2 u_trim_offset;in vec2 v_width2;in vec2 v_normal;in float v_gamma_scale;in highp vec4 v_uv;\n#ifdef RENDER_LINE_DASH\nuniform sampler2D u_dash_image;in vec2 v_tex;\n#endif\n#ifdef RENDER_LINE_GRADIENT\nuniform sampler2D u_gradient_image;\n#endif\nfloat luminance(vec3 c) {return (c.r+c.r+c.b+c.g+c.g+c.g)*0.1667;}uniform float u_emissive_strength;\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float floorwidth\n#pragma mapbox: define lowp vec4 dash\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float border_width\n#pragma mapbox: define lowp vec4 border_color\nfloat linearstep(float edge0,float edge1,float x) {return  clamp((x-edge0)/(edge1-edge0),0.0,1.0);}void main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float floorwidth\n#pragma mapbox: initialize lowp vec4 dash\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float border_width\n#pragma mapbox: initialize lowp vec4 border_color\nfloat dist=length(v_normal)*v_width2.s;float blur2=(blur+1.0/u_device_pixel_ratio)*v_gamma_scale;float alpha=clamp(min(dist-(v_width2.t-blur2),v_width2.s-dist)/blur2,0.0,1.0);\n#ifdef RENDER_LINE_DASH\nfloat sdfdist=texture(u_dash_image,v_tex).r;float sdfgamma=1.0/(2.0*u_device_pixel_ratio)/dash.z;alpha*=linearstep(0.5-sdfgamma/floorwidth,0.5+sdfgamma/floorwidth,sdfdist);\n#endif\nhighp vec4 out_color;\n#ifdef RENDER_LINE_GRADIENT\nout_color=texture(u_gradient_image,v_uv.xy);\n#else\nout_color=color;\n#endif\nfloat trimmed=1.0;\n#ifdef RENDER_LINE_TRIM_OFFSET\nhighp float start=v_uv[2];highp float end=v_uv[3];highp float trim_start=u_trim_offset[0];highp float trim_end=u_trim_offset[1];highp float line_progress=(start+(v_uv.x)*(end-start));if (trim_end > trim_start) {if (line_progress <=trim_end && line_progress >=trim_start) {out_color=vec4(0,0,0,0);trimmed=0.0;}}\n#endif\nif (u_alpha_discard_threshold !=0.0) {if (alpha < u_alpha_discard_threshold) {discard;}}\n#ifdef RENDER_LINE_BORDER\nfloat edgeBlur=(border_width+1.0/u_device_pixel_ratio);float alpha2=clamp(min(dist-(v_width2.t-edgeBlur),v_width2.s-dist)/edgeBlur,0.0,1.0);if (alpha2 < 1.) {float smoothAlpha=smoothstep(0.6,1.0,alpha2);if (border_color.a==0.0) {    \nfloat Y=(out_color.a > 0.01) ? luminance(out_color.rgb/out_color.a) : 1.;float adjustment=(Y > 0.) ? 0.5/Y : 0.45;if (out_color.a > 0.25 && Y < 0.25) {vec3 borderColor=(Y > 0.) ? out_color.rgb : vec3(1,1,1)*out_color.a;out_color.rgb=out_color.rgb+borderColor*(adjustment*(1.0-smoothAlpha));} else {out_color.rgb*=(0.6 +0.4*smoothAlpha);}} else {out_color.rgb=mix(border_color.rgb*border_color.a*trimmed,out_color.rgb,smoothAlpha);}}\n#endif\n#ifdef LIGHTING_3D_MODE\nout_color=apply_lighting_with_emission_ground(out_color,u_emissive_strength);\n#endif\n#ifdef FOG\nout_color=fog_dither(fog_apply_premultiplied(out_color,v_fog_pos));\n#endif\nout_color*=(alpha*opacity);\n#ifdef INDICATOR_CUTOUT\nout_color=applyCutout(out_color);\n#endif\nglFragColor=out_color;\n#ifdef OVERDRAW_INSPECTOR\nglFragColor=vec4(1.0);\n#endif\nHANDLE_WIREFRAME_DEBUG;}','#include "_prelude_fog.vertex.glsl"\n#define EXTRUDE_SCALE 0.015873016\nin vec2 a_pos_normal;in vec4 a_data;\n#if defined(RENDER_LINE_GRADIENT) || defined(RENDER_LINE_TRIM_OFFSET)\nin highp vec4 a_packed;\n#endif\n#ifdef RENDER_LINE_DASH\nin float a_linesofar;\n#endif\nuniform mat4 u_matrix;uniform mat2 u_pixels_to_tile_units;uniform vec2 u_units_to_pixels;uniform lowp float u_device_pixel_ratio;out vec2 v_normal;out vec2 v_width2;out float v_gamma_scale;out highp vec4 v_uv;\n#ifdef RENDER_LINE_DASH\nuniform vec2 u_texsize;uniform float u_tile_units_to_pixels;out vec2 v_tex;\n#endif\n#ifdef RENDER_LINE_GRADIENT\nuniform float u_image_height;\n#endif\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float floorwidth\n#pragma mapbox: define lowp vec4 dash\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define mediump float gapwidth\n#pragma mapbox: define lowp float offset\n#pragma mapbox: define mediump float width\n#pragma mapbox: define lowp float border_width\n#pragma mapbox: define lowp vec4 border_color\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float floorwidth\n#pragma mapbox: initialize lowp vec4 dash\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump float gapwidth\n#pragma mapbox: initialize lowp float offset\n#pragma mapbox: initialize mediump float width\n#pragma mapbox: initialize lowp float border_width\n#pragma mapbox: initialize lowp vec4 border_color\nfloat ANTIALIASING=1.0/u_device_pixel_ratio/2.0;vec2 a_extrude=a_data.xy-128.0;float a_direction=mod(a_data.z,4.0)-1.0;vec2 pos=floor(a_pos_normal*0.5);mediump vec2 normal=a_pos_normal-2.0*pos;normal.y=normal.y*2.0-1.0;v_normal=normal;gapwidth=gapwidth/2.0;float halfwidth=width/2.0;offset=-1.0*offset;float inset=gapwidth+(gapwidth > 0.0 ? ANTIALIASING : 0.0);float outset=gapwidth+halfwidth*(gapwidth > 0.0 ? 2.0 : 1.0)+(halfwidth==0.0 ? 0.0 : ANTIALIASING);mediump vec2 dist=outset*a_extrude*EXTRUDE_SCALE;mediump float u=0.5*a_direction;mediump float t=1.0-abs(u);mediump vec2 offset2=offset*a_extrude*EXTRUDE_SCALE*normal.y*mat2(t,-u,u,t);vec4 projected_extrude=u_matrix*vec4(dist*u_pixels_to_tile_units,0.0,0.0);gl_Position=u_matrix*vec4(pos+offset2*u_pixels_to_tile_units,0.0,1.0)+projected_extrude;\n#ifndef RENDER_TO_TEXTURE\nfloat extrude_length_without_perspective=length(dist);float extrude_length_with_perspective=length(projected_extrude.xy/gl_Position.w*u_units_to_pixels);v_gamma_scale=extrude_length_without_perspective/extrude_length_with_perspective;\n#else\nv_gamma_scale=1.0;\n#endif\n#if defined(RENDER_LINE_GRADIENT) || defined(RENDER_LINE_TRIM_OFFSET)\nfloat a_uv_x=a_packed[0];float a_split_index=a_packed[1];highp float a_clip_start=a_packed[2];highp float a_clip_end=a_packed[3];\n#ifdef RENDER_LINE_GRADIENT\nhighp float texel_height=1.0/u_image_height;highp float half_texel_height=0.5*texel_height;v_uv=vec4(a_uv_x,a_split_index*texel_height-half_texel_height,a_clip_start,a_clip_end);\n#else\nv_uv=vec4(a_uv_x,0.0,a_clip_start,a_clip_end);\n#endif\n#endif\n#ifdef RENDER_LINE_DASH\nfloat scale=dash.z==0.0 ? 0.0 : u_tile_units_to_pixels/dash.z;float height=dash.y;v_tex=vec2(a_linesofar*scale/floorwidth,(-normal.y*height+dash.x+0.5)/u_texsize.y);\n#endif\nv_width2=vec2(outset,inset);\n#ifdef FOG\nv_fog_pos=fog_position(pos);\n#endif\n}'),linePattern:Jo('#include "_prelude_fog.fragment.glsl"\n#include "_prelude_lighting.glsl"\nuniform lowp float u_device_pixel_ratio;uniform vec2 u_texsize;uniform float u_tile_units_to_pixels;uniform highp vec2 u_trim_offset;uniform sampler2D u_image;in vec2 v_normal;in vec2 v_width2;in float v_linesofar;in float v_gamma_scale;in float v_width;\n#ifdef RENDER_LINE_TRIM_OFFSET\nin highp vec4 v_uv;\n#endif\n#pragma mapbox: define lowp vec4 pattern\n#pragma mapbox: define lowp float pixel_ratio\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize mediump vec4 pattern\n#pragma mapbox: initialize lowp float pixel_ratio\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\nvec2 pattern_tl=pattern.xy;vec2 pattern_br=pattern.zw;vec2 display_size=(pattern_br-pattern_tl)/pixel_ratio;vec2 pattern_size=vec2(display_size.x/u_tile_units_to_pixels,display_size.y);float aspect=display_size.y/v_width;float dist=length(v_normal)*v_width2.s;float blur2=(blur+1.0/u_device_pixel_ratio)*v_gamma_scale;float alpha=clamp(min(dist-(v_width2.t-blur2),v_width2.s-dist)/blur2,0.0,1.0);float pattern_x=v_linesofar/pattern_size.x*aspect;float x=mod(pattern_x,1.0);float y=0.5*v_normal.y+0.5;vec2 texel_size=1.0/u_texsize;vec2 pos=mix(pattern_tl*texel_size-texel_size,pattern_br*texel_size+texel_size,vec2(x,y));vec2 lod_pos=mix(pattern_tl*texel_size-texel_size,pattern_br*texel_size+texel_size,vec2(pattern_x,y));vec4 color=textureLodCustom(u_image,pos,lod_pos);\n#ifdef RENDER_LINE_TRIM_OFFSET\nhighp float start=v_uv[2];highp float end=v_uv[3];highp float trim_start=u_trim_offset[0];highp float trim_end=u_trim_offset[1];highp float line_progress=(start+(v_uv.x)*(end-start));if (trim_end > trim_start) {if (line_progress <=trim_end && line_progress >=trim_start) {color=vec4(0,0,0,0);}}\n#endif\n#ifdef LIGHTING_3D_MODE\ncolor=apply_lighting_ground(color);\n#endif\n#ifdef FOG\ncolor=fog_dither(fog_apply_premultiplied(color,v_fog_pos));\n#endif\ncolor*=(alpha*opacity);\n#ifdef INDICATOR_CUTOUT\ncolor=applyCutout(color);\n#endif\nglFragColor=color;\n#ifdef OVERDRAW_INSPECTOR\nglFragColor=vec4(1.0);\n#endif\nHANDLE_WIREFRAME_DEBUG;}','#include "_prelude_fog.vertex.glsl"\n#define scale 0.015873016\nin vec2 a_pos_normal;in vec4 a_data;\n#ifdef RENDER_LINE_TRIM_OFFSET\nin highp vec4 a_packed;\n#endif\nin float a_linesofar;uniform mat4 u_matrix;uniform vec2 u_units_to_pixels;uniform mat2 u_pixels_to_tile_units;uniform lowp float u_device_pixel_ratio;out vec2 v_normal;out vec2 v_width2;out float v_linesofar;out float v_gamma_scale;out float v_width;\n#ifdef RENDER_LINE_TRIM_OFFSET\nout highp vec4 v_uv;\n#endif\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float offset\n#pragma mapbox: define mediump float gapwidth\n#pragma mapbox: define mediump float width\n#pragma mapbox: define lowp float floorwidth\n#pragma mapbox: define lowp vec4 pattern\n#pragma mapbox: define lowp float pixel_ratio\nvoid main() {\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float offset\n#pragma mapbox: initialize mediump float gapwidth\n#pragma mapbox: initialize mediump float width\n#pragma mapbox: initialize lowp float floorwidth\n#pragma mapbox: initialize mediump vec4 pattern\n#pragma mapbox: initialize lowp float pixel_ratio\nfloat ANTIALIASING=1.0/u_device_pixel_ratio/2.0;vec2 a_extrude=a_data.xy-128.0;float a_direction=mod(a_data.z,4.0)-1.0;vec2 pos=floor(a_pos_normal*0.5);mediump vec2 normal=a_pos_normal-2.0*pos;normal.y=normal.y*2.0-1.0;v_normal=normal;gapwidth=gapwidth/2.0;float halfwidth=width/2.0;offset=-1.0*offset;float inset=gapwidth+(gapwidth > 0.0 ? ANTIALIASING : 0.0);float outset=gapwidth+halfwidth*(gapwidth > 0.0 ? 2.0 : 1.0)+(halfwidth==0.0 ? 0.0 : ANTIALIASING);mediump vec2 dist=outset*a_extrude*scale;mediump float u=0.5*a_direction;mediump float t=1.0-abs(u);mediump vec2 offset2=offset*a_extrude*scale*normal.y*mat2(t,-u,u,t);vec4 projected_extrude=u_matrix*vec4(dist*u_pixels_to_tile_units,0.0,0.0);gl_Position=u_matrix*vec4(pos+offset2*u_pixels_to_tile_units,0.0,1.0)+projected_extrude;\n#ifndef RENDER_TO_TEXTURE\nfloat extrude_length_without_perspective=length(dist);float extrude_length_with_perspective=length(projected_extrude.xy/gl_Position.w*u_units_to_pixels);v_gamma_scale=extrude_length_without_perspective/extrude_length_with_perspective;\n#else\nv_gamma_scale=1.0;\n#endif\n#ifdef RENDER_LINE_TRIM_OFFSET\nfloat a_uv_x=a_packed[0];highp float a_clip_start=a_packed[2];highp float a_clip_end=a_packed[3];v_uv=vec4(a_uv_x,0.0,a_clip_start,a_clip_end);\n#endif\nv_linesofar=a_linesofar;v_width2=vec2(outset,inset);v_width=floorwidth;\n#ifdef FOG\nv_fog_pos=fog_position(pos);\n#endif\n}'),raster:Jo('#include "_prelude_fog.fragment.glsl"\n#include "_prelude_lighting.glsl"\n#include "_prelude_raster_array.glsl"\nuniform float u_fade_t;uniform float u_opacity;uniform highp float u_raster_elevation;uniform highp float u_zoom_transition;in vec2 v_pos0;in vec2 v_pos1;in float v_depth;\n#ifdef PROJECTION_GLOBE_VIEW\nin float v_split_fade;\n#endif\nuniform float u_brightness_low;uniform float u_brightness_high;uniform float u_saturation_factor;uniform float u_contrast_factor;uniform vec3 u_spin_weights;uniform float u_emissive_strength;\n#ifndef RASTER_ARRAY\nuniform sampler2D u_image0;uniform sampler2D u_image1;\n#endif\n#ifdef RASTER_COLOR\nuniform sampler2D u_color_ramp;uniform highp vec4 u_colorization_mix;uniform highp float u_colorization_offset;uniform vec2 u_texture_res;\n#endif\nvoid main() {vec4 color0,color1,color;vec2 value;\n#ifdef RASTER_COLOR\n#ifdef RASTER_ARRAY\n#ifdef RASTER_ARRAY_LINEAR\nvalue=mix(\nraTexture2D_image0_linear(v_pos0,u_texture_res,u_colorization_mix,u_colorization_offset),raTexture2D_image1_linear(v_pos1,u_texture_res,u_colorization_mix,u_colorization_offset),u_fade_t\n);\n#else\nvalue=mix(\nraTexture2D_image0_nearest(v_pos0,u_texture_res,u_colorization_mix,u_colorization_offset),raTexture2D_image1_nearest(v_pos1,u_texture_res,u_colorization_mix,u_colorization_offset),u_fade_t\n);\n#endif\nif (value.y > 0.0) value.x/=value.y;\n#else\ncolor=mix(texture(u_image0,v_pos0),texture(u_image1,v_pos1),u_fade_t);value=vec2(u_colorization_offset+dot(color.rgb,u_colorization_mix.rgb),color.a);\n#endif\ncolor=texture(u_color_ramp,vec2(value.x,0.5));if (color.a > 0.0) color.rgb/=color.a;color.a*=value.y;\n#else\ncolor0=texture(u_image0,v_pos0);color1=texture(u_image1,v_pos1);if (color0.a > 0.0) color0.rgb/=color0.a;if (color1.a > 0.0) color1.rgb/=color1.a;color=mix(color0,color1,u_fade_t);\n#endif\ncolor.a*=u_opacity;\n#ifdef GLOBE_POLES\ncolor.a*=1.0-smoothstep(0.0,0.05,u_zoom_transition);\n#endif\nvec3 rgb=color.rgb;rgb=vec3(\ndot(rgb,u_spin_weights.xyz),dot(rgb,u_spin_weights.zxy),dot(rgb,u_spin_weights.yzx));float average=(color.r+color.g+color.b)/3.0;rgb+=(average-rgb)*u_saturation_factor;rgb=(rgb-0.5)*u_contrast_factor+0.5;vec3 u_high_vec=vec3(u_brightness_low,u_brightness_low,u_brightness_low);vec3 u_low_vec=vec3(u_brightness_high,u_brightness_high,u_brightness_high);vec3 out_color=mix(u_high_vec,u_low_vec,rgb);\n#ifdef LIGHTING_3D_MODE\nout_color=apply_lighting_with_emission_ground(vec4(out_color,1.0),u_emissive_strength).rgb;\n#endif\n#ifdef FOG\nhighp float fog_limit_high_meters=1000000.0;highp float fog_limit_low_meters=600000.0;float fog_limit=1.0-smoothstep(fog_limit_low_meters,fog_limit_high_meters,u_raster_elevation);out_color=fog_dither(fog_apply(out_color,v_fog_pos,fog_limit));\n#endif\nglFragColor=vec4(out_color*color.a,color.a);\n#ifdef PROJECTION_GLOBE_VIEW\nglFragColor*=mix(1.0,1.0-smoothstep(0.0,0.05,u_zoom_transition),smoothstep(0.8,0.9,v_split_fade));\n#endif\n#ifdef RENDER_CUTOFF\nglFragColor=glFragColor*cutoff_opacity(u_cutoff_params,v_depth);\n#endif\n#ifdef OVERDRAW_INSPECTOR\nglFragColor=vec4(1.0);\n#endif\nHANDLE_WIREFRAME_DEBUG;}','#include "_prelude_fog.vertex.glsl"\nuniform mat4 u_matrix;uniform mat4 u_normalize_matrix;uniform mat4 u_globe_matrix;uniform mat4 u_merc_matrix;uniform mat3 u_grid_matrix;uniform vec2 u_tl_parent;uniform float u_scale_parent;uniform vec2 u_perspective_transform;uniform vec2 u_texture_offset;uniform float u_raster_elevation;uniform float u_zoom_transition;uniform vec2 u_merc_center;\n#define GLOBE_UPSCALE GLOBE_RADIUS/6371008.8\n#ifdef GLOBE_POLES\nin vec3 a_globe_pos;in vec2 a_uv;\n#else\nin vec2 a_pos;in vec2 a_texture_pos;\n#endif\nout vec2 v_pos0;out vec2 v_pos1;out float v_depth;\n#ifdef PROJECTION_GLOBE_VIEW\nout float v_split_fade;\n#endif\nvoid main() {vec2 uv;\n#ifdef GLOBE_POLES\nvec3 globe_pos=a_globe_pos;globe_pos+=normalize(globe_pos)*u_raster_elevation*GLOBE_UPSCALE;gl_Position=u_matrix*u_globe_matrix*vec4(globe_pos   ,1.0);uv=a_uv;\n#ifdef FOG\nv_fog_pos=fog_position((u_normalize_matrix*vec4(a_globe_pos,1.0)).xyz);\n#endif\n#else\nfloat w=1.0+dot(a_texture_pos,u_perspective_transform);uv=a_texture_pos/8192.0;\n#ifdef PROJECTION_GLOBE_VIEW\nvec3 decomposed_pos_and_skirt=decomposeToPosAndSkirt(a_pos);vec3 latLng=u_grid_matrix*vec3(decomposed_pos_and_skirt.xy,1.0);vec3 globe_pos=latLngToECEF(latLng.xy);globe_pos+=normalize(globe_pos)*u_raster_elevation*GLOBE_UPSCALE;vec4 globe_world_pos=u_globe_matrix*vec4(globe_pos,1.0);vec4 merc_world_pos=vec4(0.0);float mercatorY=mercatorYfromLat(latLng[0]);float mercatorX=mercatorXfromLng(latLng[1]);    \nv_split_fade=0.0;if (u_zoom_transition > 0.0) {vec2 merc_pos=vec2(mercatorX,mercatorY);merc_world_pos=vec4(merc_pos,u_raster_elevation,1.0);merc_world_pos.xy-=u_merc_center;merc_world_pos.x=wrap(merc_world_pos.x,-0.5,0.5);merc_world_pos=u_merc_matrix*merc_world_pos;float opposite_merc_center=mod(u_merc_center.x+0.5,1.0);float dist_from_poles=(abs(mercatorY-0.5)*2.0);float range=0.1;v_split_fade=abs(opposite_merc_center-mercatorX);v_split_fade=clamp(1.0-v_split_fade,0.0,1.0);v_split_fade=max(smoothstep(1.0-range,1.0,dist_from_poles),max(smoothstep(1.0-range,1.0,v_split_fade),smoothstep(1.0-range,1.0,1.0-v_split_fade)));}float tiles=u_grid_matrix[0][2];if (tiles > 0.0) {float idx=u_grid_matrix[1][2];float idy=u_grid_matrix[2][2];float uvY=mercatorY*tiles-idy;float uvX=mercatorX*tiles-idx;uv=vec2(uvX,uvY);}vec4 interpolated_pos=vec4(mix(globe_world_pos.xyz,merc_world_pos.xyz,u_zoom_transition)*w,w);gl_Position=u_matrix*interpolated_pos;\n#ifdef FOG\nv_fog_pos=fog_position((u_normalize_matrix*vec4(globe_pos,1.0)).xyz);\n#endif\n#else\ngl_Position=u_matrix*vec4(a_pos*w,u_raster_elevation*w,w);\n#ifdef FOG\nv_fog_pos=fog_position(a_pos);\n#endif\n#endif\n#endif\nv_pos0=uv;v_pos1=(v_pos0*u_scale_parent)+u_tl_parent;v_pos0=u_texture_offset.x+u_texture_offset.y*v_pos0;v_pos1=u_texture_offset.x+u_texture_offset.y*v_pos1;\n#ifdef RENDER_CUTOFF\nv_depth=gl_Position.z;\n#endif\n}'),rasterParticle:Jo('#include "_prelude_fog.fragment.glsl"\n#include "_prelude_lighting.glsl"\nuniform float u_fade_t;uniform float u_opacity;uniform highp float u_raster_elevation;in vec2 v_pos0;in vec2 v_pos1;uniform sampler2D u_image0;uniform sampler2D u_image1;void main() {vec4 color0,color1,color;color0=texture(u_image0,v_pos0);color1=texture(u_image1,v_pos1);if (color0.a > 0.0) color0.rgb/=color0.a;if (color1.a > 0.0) color1.rgb/=color1.a;color=mix(color0,color1,u_fade_t);color.a*=u_opacity;vec3 out_color=color.rgb;\n#ifdef LIGHTING_3D_MODE\nout_color=apply_lighting_with_emission_ground(vec4(out_color,1.0),0.0).rgb;\n#endif\n#ifdef FOG\nhighp float fog_limit_high_meters=1000000.0;highp float fog_limit_low_meters=600000.0;float fog_limit=1.0-smoothstep(fog_limit_low_meters,fog_limit_high_meters,u_raster_elevation);out_color=fog_dither(fog_apply(out_color,v_fog_pos,fog_limit));\n#endif\nglFragColor=vec4(out_color*color.a,color.a);\n#ifdef OVERDRAW_INSPECTOR\nglFragColor=vec4(1.0);\n#endif\nHANDLE_WIREFRAME_DEBUG;}','#include "_prelude_fog.vertex.glsl"\nuniform mat4 u_matrix;uniform mat4 u_normalize_matrix;uniform mat4 u_globe_matrix;uniform mat4 u_merc_matrix;uniform mat3 u_grid_matrix;uniform vec2 u_tl_parent;uniform float u_scale_parent;uniform float u_raster_elevation;uniform float u_zoom_transition;uniform vec2 u_merc_center;\n#define GLOBE_UPSCALE GLOBE_RADIUS/6371008.8\nin vec2 a_pos;in vec2 a_texture_pos;out vec2 v_pos0;out vec2 v_pos1;void main() {float w=1.0;\n#ifdef PROJECTION_GLOBE_VIEW\nvec3 decomposed_pos_and_skirt=decomposeToPosAndSkirt(a_pos);vec3 latLng=u_grid_matrix*vec3(decomposed_pos_and_skirt.xy,1.0);float mercatorY=mercatorYfromLat(latLng[0]);float mercatorX=mercatorXfromLng(latLng[1]);float tiles=u_grid_matrix[0][2];float idx=u_grid_matrix[1][2];float idy=u_grid_matrix[2][2];float uvX=mercatorX*tiles-idx;float uvY=mercatorY*tiles-idy;vec2 uv=vec2(uvX,uvY);vec3 globe_pos=latLngToECEF(latLng.xy);globe_pos+=normalize(globe_pos)*u_raster_elevation*GLOBE_UPSCALE;vec4 globe_world_pos=u_globe_matrix*vec4(globe_pos,1.0);vec4 merc_world_pos=vec4(0.0);if (u_zoom_transition > 0.0) {vec2 merc_pos=vec2(mercatorX,mercatorY);merc_world_pos=vec4(merc_pos,u_raster_elevation,1.0);merc_world_pos.xy-=u_merc_center;merc_world_pos.x=wrap(merc_world_pos.x,-0.5,0.5);merc_world_pos=u_merc_matrix*merc_world_pos;}vec4 interpolated_pos=vec4(mix(globe_world_pos.xyz,merc_world_pos.xyz,u_zoom_transition)*w,w);gl_Position=u_matrix*interpolated_pos;\n#ifdef FOG\nv_fog_pos=fog_position((u_normalize_matrix*vec4(globe_pos,1.0)).xyz);\n#endif\n#else\nvec2 uv=a_texture_pos/8192.0;gl_Position=u_matrix*vec4(a_pos*w,u_raster_elevation*w,w);\n#ifdef FOG\nv_fog_pos=fog_position(a_pos);\n#endif\n#endif\nv_pos0=uv;v_pos1=(v_pos0*u_scale_parent)+u_tl_parent;}'),rasterParticleDraw:Jo("precision highp float;uniform sampler2D u_color_ramp;in float v_particle_speed;void main() {glFragColor=texture(u_color_ramp,vec2(v_particle_speed,0.5));}",'precision highp float;\n#include "_prelude_raster_array.glsl"\n#include "_prelude_raster_particle.glsl"\nin vec3 a_pos;uniform vec2 u_tile_offset;out float v_particle_speed;void main() {vec2 pos=a_pos.xy+u_tile_offset;vec2 tex_coords=fract(pos);gl_PointSize=1.0;vec2 velocity=lookup_velocity(tex_coords);if (velocity==INVALID_VELOCITY) {v_particle_speed=0.0;gl_Position=vec4(2.0,2.0,2.0,1.0);} else {v_particle_speed=length(velocity);gl_Position=vec4(2.0*pos-vec2(1.0),0.0,1.0);}}'),rasterParticleTexture:Jo("uniform sampler2D u_texture;uniform float u_opacity;in vec2 v_tex_pos;void main() {vec4 color=texture(u_texture,v_tex_pos);glFragColor=vec4(floor(255.0*color*u_opacity)/255.0);}","in vec2 a_pos;out vec2 v_tex_pos;void main() {v_tex_pos=0.5*a_pos+vec2(0.5);gl_Position=vec4(a_pos,0.0,1.0);}"),rasterParticleUpdate:Jo("void main() {}",'#include "_prelude_raster_array.glsl"\n#include "_prelude_raster_particle.glsl"\nin vec3 a_pos;uniform float u_speed_factor;uniform float u_lifetime_delta;uniform float u_rand_seed;out vec3 v_new_particle;const vec3 rand_constants=vec3(12.9898,78.233,4375.85453);float rand(const vec2 co) {float t=dot(rand_constants.xy,co);return fract(sin(t)*(rand_constants.z+t));}void main() {float lifetime=a_pos.z;vec2 pos=a_pos.xy;vec2 uv=clamp(pos,vec2(0.0),vec2(1.0));vec2 velocity=lookup_velocity(uv);float next_lifetime=lifetime-u_lifetime_delta;float t=step(0.0,next_lifetime);\n#ifdef DATA_FORMAT_UINT32\nvec2 dp=vec2(0);\n#else\nvec2 dp=velocity==INVALID_VELOCITY ? vec2(0) : velocity*u_speed_factor;\n#endif\nvec2 seed=pos*u_rand_seed;vec2 next_pos=pos+dp;vec2 random_pos=vec2(rand(seed+1.3),rand(seed+2.1));v_new_particle=vec3(\nvec2(mix(random_pos,next_pos,t)),mix(1.0,next_lifetime,t)\n);}'),symbolIcon:Jo('#include "_prelude_lighting.glsl"\nuniform sampler2D u_texture;\n#ifdef ICON_TRANSITION\nuniform float u_icon_transition;\n#endif\nin float v_fade_opacity;in vec2 v_tex_a;\n#ifdef ICON_TRANSITION\nin vec2 v_tex_b;\n#endif\nuniform mediump float u_icon_saturation;\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float emissive_strength\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float emissive_strength\nlowp float alpha=opacity*v_fade_opacity;vec4 out_color;\n#ifdef ICON_TRANSITION\nvec4 a=texture(u_texture,v_tex_a)*(1.0-u_icon_transition);vec4 b=texture(u_texture,v_tex_b)*u_icon_transition;out_color=(a+b)*alpha;\n#else\nout_color=texture(u_texture,v_tex_a)*alpha;\n#endif\n#ifdef SATURATION\nvec3 luma=vec3(dot(out_color.rgb,vec3(0.2126,0.7152,0.0722)));out_color.rgb=mix(luma,out_color.rgb,u_icon_saturation);\n#endif\n#ifdef LIGHTING_3D_MODE\nout_color=apply_lighting_with_emission_ground(out_color,emissive_strength);\n#endif\nglFragColor=out_color;\n#ifdef OVERDRAW_INSPECTOR\nglFragColor=vec4(1.0);\n#endif\nHANDLE_WIREFRAME_DEBUG;}','#include "_prelude_terrain.vertex.glsl"\nin vec4 a_pos_offset;in vec4 a_tex_size;in vec4 a_pixeloffset;in vec4 a_projected_pos;in float a_fade_opacity;\n#ifdef Z_OFFSET\nin float a_z_offset;\n#endif\n#ifdef PROJECTION_GLOBE_VIEW\nin vec3 a_globe_anchor;in vec3 a_globe_normal;\n#endif\n#ifdef ICON_TRANSITION\nin vec2 a_texb;\n#endif\nuniform bool u_is_size_zoom_constant;uniform bool u_is_size_feature_constant;uniform highp float u_size_t;uniform highp float u_size;uniform highp float u_camera_to_center_distance;uniform bool u_rotate_symbol;uniform highp float u_aspect_ratio;uniform float u_fade_change;uniform mat4 u_matrix;uniform mat4 u_label_plane_matrix;uniform mat4 u_coord_matrix;uniform bool u_is_text;uniform bool u_pitch_with_map;uniform vec2 u_texsize;uniform vec3 u_up_vector;\n#ifdef PROJECTION_GLOBE_VIEW\nuniform vec3 u_tile_id;uniform mat4 u_inv_rot_matrix;uniform vec2 u_merc_center;uniform vec3 u_camera_forward;uniform float u_zoom_transition;uniform vec3 u_ecef_origin;uniform mat4 u_tile_matrix;\n#endif\nout vec2 v_tex_a;\n#ifdef ICON_TRANSITION\nout vec2 v_tex_b;\n#endif\nout float v_fade_opacity;\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float emissive_strength\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float emissive_strength\nvec2 a_pos=a_pos_offset.xy;vec2 a_offset=a_pos_offset.zw;vec2 a_tex=a_tex_size.xy;vec2 a_size=a_tex_size.zw;float a_size_min=floor(a_size[0]*0.5);vec2 a_pxoffset=a_pixeloffset.xy;vec2 a_min_font_scale=a_pixeloffset.zw/256.0;highp float segment_angle=-a_projected_pos[3];float size;if (!u_is_size_zoom_constant && !u_is_size_feature_constant) {size=mix(a_size_min,a_size[1],u_size_t)/128.0;} else if (u_is_size_zoom_constant && !u_is_size_feature_constant) {size=a_size_min/128.0;} else {size=u_size;}vec2 tile_anchor=a_pos;float e=elevation(tile_anchor);\n#ifdef Z_OFFSET\ne+=a_z_offset;\n#endif\nvec3 h=elevationVector(tile_anchor)*e;float globe_occlusion_fade;vec3 world_pos;vec3 mercator_pos;\n#ifdef PROJECTION_GLOBE_VIEW\nmercator_pos=mercator_tile_position(u_inv_rot_matrix,tile_anchor,u_tile_id,u_merc_center);world_pos=mix_globe_mercator(a_globe_anchor+h,mercator_pos,u_zoom_transition);vec4 ecef_point=u_tile_matrix*vec4(world_pos,1.0);vec3 origin_to_point=ecef_point.xyz-u_ecef_origin;globe_occlusion_fade=dot(origin_to_point,u_camera_forward) >=0.0 ? 0.0 : 1.0;\n#else\nworld_pos=vec3(tile_anchor,0)+h;globe_occlusion_fade=1.0;\n#endif\nvec4 projected_point=u_matrix*vec4(world_pos,1);highp float camera_to_anchor_distance=projected_point.w;highp float distance_ratio=u_pitch_with_map ?\ncamera_to_anchor_distance/u_camera_to_center_distance :\nu_camera_to_center_distance/camera_to_anchor_distance;highp float perspective_ratio=clamp(\n0.5+0.5*distance_ratio,0.0,1.5);size*=perspective_ratio;float font_scale=u_is_text ? size/24.0 : size;highp float symbol_rotation=0.0;if (u_rotate_symbol) {vec4 offsetProjected_point;\n#ifdef PROJECTION_GLOBE_VIEW\nvec3 displacement=vec3(a_globe_normal.z,0,-a_globe_normal.x);offsetProjected_point=u_matrix*vec4(a_globe_anchor+displacement,1);\n#else\noffsetProjected_point=u_matrix*vec4(tile_anchor+vec2(1,0),0,1);\n#endif\nvec2 a=projected_point.xy/projected_point.w;vec2 b=offsetProjected_point.xy/offsetProjected_point.w;symbol_rotation=atan((b.y-a.y)/u_aspect_ratio,b.x-a.x);}vec4 projected_pos;\n#ifdef PROJECTION_GLOBE_VIEW\nvec3 proj_pos=mix_globe_mercator(a_projected_pos.xyz+h,mercator_pos,u_zoom_transition);projected_pos=u_label_plane_matrix*vec4(proj_pos,1.0);\n#else\nprojected_pos=u_label_plane_matrix*vec4(a_projected_pos.xy,h.z,1.0);\n#endif\nhighp float angle_sin=sin(segment_angle+symbol_rotation);highp float angle_cos=cos(segment_angle+symbol_rotation);mat2 rotation_matrix=mat2(angle_cos,-1.0*angle_sin,angle_sin,angle_cos);float z=0.0;vec2 offset=rotation_matrix*(a_offset/32.0*max(a_min_font_scale,font_scale)+a_pxoffset/16.0);\n#ifdef TERRAIN\n#ifdef PITCH_WITH_MAP_TERRAIN\nvec4 tile_pos=u_label_plane_matrix_inv*vec4(a_projected_pos.xy+offset,0.0,1.0);z=elevation(tile_pos.xy);\n#endif\n#endif\nfloat occlusion_fade=occlusionFade(projected_point)*globe_occlusion_fade;float projection_transition_fade=1.0;\n#if defined(PROJECTED_POS_ON_VIEWPORT) && defined(PROJECTION_GLOBE_VIEW)\nprojection_transition_fade=1.0-step(EPSILON,u_zoom_transition);\n#endif\nvec2 fade_opacity=unpack_opacity(a_fade_opacity);float fade_change=fade_opacity[1] > 0.5 ? u_fade_change :-u_fade_change;float out_fade_opacity=max(0.0,min(occlusion_fade,fade_opacity[0]+fade_change))*projection_transition_fade;float alpha=opacity*out_fade_opacity;float hidden=float(alpha==0.0 || projected_point.w <=0.0 || occlusion_fade==0.0);\n#ifdef PROJECTION_GLOBE_VIEW\nvec3 xAxis=u_pitch_with_map ? normalize(cross(a_globe_normal,u_up_vector)) : vec3(1,0,0);vec3 yAxis=u_pitch_with_map ? normalize(cross(a_globe_normal,xAxis)) : vec3(0,1,0);gl_Position=mix(u_coord_matrix*vec4(projected_pos.xyz/projected_pos.w+xAxis*offset.x+yAxis*offset.y,1.0),AWAY,hidden);\n#else\ngl_Position=mix(u_coord_matrix*vec4(projected_pos.xy/projected_pos.w+offset,z,1.0),AWAY,hidden);\n#endif\nv_tex_a=a_tex/u_texsize;\n#ifdef ICON_TRANSITION\nv_tex_b=a_texb/u_texsize;\n#endif\nv_fade_opacity=out_fade_opacity;}'),symbolSDF:Jo('#include "_prelude_lighting.glsl"\n#define SDF_PX 8.0\nuniform sampler2D u_texture;uniform highp float u_gamma_scale;uniform lowp float u_device_pixel_ratio;uniform bool u_is_text;uniform bool u_is_halo;in float v_draw_halo;in vec2 v_data0;in vec3 v_data1;\n#pragma mapbox: defin